// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewWaypointServiceDeleteNamespaceParams creates a new WaypointServiceDeleteNamespaceParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointServiceDeleteNamespaceParams() *WaypointServiceDeleteNamespaceParams {
	return &WaypointServiceDeleteNamespaceParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointServiceDeleteNamespaceParamsWithTimeout creates a new WaypointServiceDeleteNamespaceParams object
// with the ability to set a timeout on a request.
func NewWaypointServiceDeleteNamespaceParamsWithTimeout(timeout time.Duration) *WaypointServiceDeleteNamespaceParams {
	return &WaypointServiceDeleteNamespaceParams{
		timeout: timeout,
	}
}

// NewWaypointServiceDeleteNamespaceParamsWithContext creates a new WaypointServiceDeleteNamespaceParams object
// with the ability to set a context for a request.
func NewWaypointServiceDeleteNamespaceParamsWithContext(ctx context.Context) *WaypointServiceDeleteNamespaceParams {
	return &WaypointServiceDeleteNamespaceParams{
		Context: ctx,
	}
}

// NewWaypointServiceDeleteNamespaceParamsWithHTTPClient creates a new WaypointServiceDeleteNamespaceParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointServiceDeleteNamespaceParamsWithHTTPClient(client *http.Client) *WaypointServiceDeleteNamespaceParams {
	return &WaypointServiceDeleteNamespaceParams{
		HTTPClient: client,
	}
}

/*
WaypointServiceDeleteNamespaceParams contains all the parameters to send to the API endpoint

	for the waypoint service delete namespace operation.

	Typically these are written to a http.Request.
*/
type WaypointServiceDeleteNamespaceParams struct {

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	LocationRegionRegion *string

	// NamespaceID.
	NamespaceID string

	/* NamespaceLocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	NamespaceLocationRegionProvider *string

	/* NamespaceLocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	NamespaceLocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint service delete namespace params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceDeleteNamespaceParams) WithDefaults() *WaypointServiceDeleteNamespaceParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint service delete namespace params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceDeleteNamespaceParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint service delete namespace params
func (o *WaypointServiceDeleteNamespaceParams) WithTimeout(timeout time.Duration) *WaypointServiceDeleteNamespaceParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint service delete namespace params
func (o *WaypointServiceDeleteNamespaceParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint service delete namespace params
func (o *WaypointServiceDeleteNamespaceParams) WithContext(ctx context.Context) *WaypointServiceDeleteNamespaceParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint service delete namespace params
func (o *WaypointServiceDeleteNamespaceParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint service delete namespace params
func (o *WaypointServiceDeleteNamespaceParams) WithHTTPClient(client *http.Client) *WaypointServiceDeleteNamespaceParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint service delete namespace params
func (o *WaypointServiceDeleteNamespaceParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithLocationOrganizationID adds the locationOrganizationID to the waypoint service delete namespace params
func (o *WaypointServiceDeleteNamespaceParams) WithLocationOrganizationID(locationOrganizationID string) *WaypointServiceDeleteNamespaceParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the waypoint service delete namespace params
func (o *WaypointServiceDeleteNamespaceParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the waypoint service delete namespace params
func (o *WaypointServiceDeleteNamespaceParams) WithLocationProjectID(locationProjectID string) *WaypointServiceDeleteNamespaceParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the waypoint service delete namespace params
func (o *WaypointServiceDeleteNamespaceParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the waypoint service delete namespace params
func (o *WaypointServiceDeleteNamespaceParams) WithLocationRegionProvider(locationRegionProvider *string) *WaypointServiceDeleteNamespaceParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the waypoint service delete namespace params
func (o *WaypointServiceDeleteNamespaceParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the waypoint service delete namespace params
func (o *WaypointServiceDeleteNamespaceParams) WithLocationRegionRegion(locationRegionRegion *string) *WaypointServiceDeleteNamespaceParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the waypoint service delete namespace params
func (o *WaypointServiceDeleteNamespaceParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WithNamespaceID adds the namespaceID to the waypoint service delete namespace params
func (o *WaypointServiceDeleteNamespaceParams) WithNamespaceID(namespaceID string) *WaypointServiceDeleteNamespaceParams {
	o.SetNamespaceID(namespaceID)
	return o
}

// SetNamespaceID adds the namespaceId to the waypoint service delete namespace params
func (o *WaypointServiceDeleteNamespaceParams) SetNamespaceID(namespaceID string) {
	o.NamespaceID = namespaceID
}

// WithNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service delete namespace params
func (o *WaypointServiceDeleteNamespaceParams) WithNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) *WaypointServiceDeleteNamespaceParams {
	o.SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider)
	return o
}

// SetNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service delete namespace params
func (o *WaypointServiceDeleteNamespaceParams) SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) {
	o.NamespaceLocationRegionProvider = namespaceLocationRegionProvider
}

// WithNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service delete namespace params
func (o *WaypointServiceDeleteNamespaceParams) WithNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) *WaypointServiceDeleteNamespaceParams {
	o.SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion)
	return o
}

// SetNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service delete namespace params
func (o *WaypointServiceDeleteNamespaceParams) SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) {
	o.NamespaceLocationRegionRegion = namespaceLocationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointServiceDeleteNamespaceParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	// path param namespace.id
	if err := r.SetPathParam("namespace.id", o.NamespaceID); err != nil {
		return err
	}

	if o.NamespaceLocationRegionProvider != nil {

		// query param namespace.location.region.provider
		var qrNamespaceLocationRegionProvider string

		if o.NamespaceLocationRegionProvider != nil {
			qrNamespaceLocationRegionProvider = *o.NamespaceLocationRegionProvider
		}
		qNamespaceLocationRegionProvider := qrNamespaceLocationRegionProvider
		if qNamespaceLocationRegionProvider != "" {

			if err := r.SetQueryParam("namespace.location.region.provider", qNamespaceLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationRegionRegion != nil {

		// query param namespace.location.region.region
		var qrNamespaceLocationRegionRegion string

		if o.NamespaceLocationRegionRegion != nil {
			qrNamespaceLocationRegionRegion = *o.NamespaceLocationRegionRegion
		}
		qNamespaceLocationRegionRegion := qrNamespaceLocationRegionRegion
		if qNamespaceLocationRegionRegion != "" {

			if err := r.SetQueryParam("namespace.location.region.region", qNamespaceLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
