// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpCloudWaypointActionConfigFlavorGitHub GitHub mode is configured to do various operations on a GitHub repositories
// defined Workflows.
//
// swagger:model hashicorp.cloud.waypoint.ActionConfig.Flavor.GitHub
type HashicorpCloudWaypointActionConfigFlavorGitHub struct {

	// TODO(briancain): SECURITY. We'd be storing users GitHub auth tokens, but
	// we need it to make the request for them.
	AuthToken string `json:"auth_token,omitempty"`

	// Enables debug logging on the workflow, if supported by the Method
	EnableDebugLog bool `json:"enable_debug_log,omitempty"`

	// Input keys and values configured in the workflow file. Expected to be
	// turned into a string of json key/vals.
	Inputs map[string]string `json:"inputs,omitempty"`

	// Which GitHub action workflow method to take for this Waypoint action config
	Method *HashicorpCloudWaypointActionConfigFlavorGitHubMethod `json:"method,omitempty"`

	// The git reference for the workflow. Can be a branch or tag name.
	Ref string `json:"ref,omitempty"`

	// The repo to submit the action to
	Repo string `json:"repo,omitempty"`

	// The unique identifier of the workflow run. Can be used to create, re-run,
	// cancel workflows, or approve a workflow from a pull request. (Optional)
	RunID string `json:"run_id,omitempty"`

	// The username to submit the action to
	Username string `json:"username,omitempty"`

	// The workflow to run
	WorkflowID string `json:"workflow_id,omitempty"`
}

// Validate validates this hashicorp cloud waypoint action config flavor git hub
func (m *HashicorpCloudWaypointActionConfigFlavorGitHub) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMethod(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWaypointActionConfigFlavorGitHub) validateMethod(formats strfmt.Registry) error {
	if swag.IsZero(m.Method) { // not required
		return nil
	}

	if m.Method != nil {
		if err := m.Method.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("method")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("method")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp cloud waypoint action config flavor git hub based on the context it is used
func (m *HashicorpCloudWaypointActionConfigFlavorGitHub) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateMethod(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWaypointActionConfigFlavorGitHub) contextValidateMethod(ctx context.Context, formats strfmt.Registry) error {

	if m.Method != nil {

		if swag.IsZero(m.Method) { // not required
			return nil
		}

		if err := m.Method.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("method")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("method")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudWaypointActionConfigFlavorGitHub) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudWaypointActionConfigFlavorGitHub) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudWaypointActionConfigFlavorGitHub
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
