// Copyright 2023 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package contentwarehouse provides access to the Document AI Warehouse API.
//
// For product documentation, see: https://cloud.google.com/document-warehouse
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/contentwarehouse/v1"
//	...
//	ctx := context.Background()
//	contentwarehouseService, err := contentwarehouse.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	contentwarehouseService, err := contentwarehouse.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	contentwarehouseService, err := contentwarehouse.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package contentwarehouse // import "google.golang.org/api/contentwarehouse/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "contentwarehouse:v1"
const apiName = "contentwarehouse"
const apiVersion = "v1"
const basePath = "https://contentwarehouse.googleapis.com/"
const mtlsBasePath = "https://contentwarehouse.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the
	// email address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.DocumentSchemas = NewProjectsLocationsDocumentSchemasService(s)
	rs.Documents = NewProjectsLocationsDocumentsService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.RuleSets = NewProjectsLocationsRuleSetsService(s)
	rs.SynonymSets = NewProjectsLocationsSynonymSetsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	DocumentSchemas *ProjectsLocationsDocumentSchemasService

	Documents *ProjectsLocationsDocumentsService

	Operations *ProjectsLocationsOperationsService

	RuleSets *ProjectsLocationsRuleSetsService

	SynonymSets *ProjectsLocationsSynonymSetsService
}

func NewProjectsLocationsDocumentSchemasService(s *Service) *ProjectsLocationsDocumentSchemasService {
	rs := &ProjectsLocationsDocumentSchemasService{s: s}
	return rs
}

type ProjectsLocationsDocumentSchemasService struct {
	s *Service
}

func NewProjectsLocationsDocumentsService(s *Service) *ProjectsLocationsDocumentsService {
	rs := &ProjectsLocationsDocumentsService{s: s}
	rs.DocumentLinks = NewProjectsLocationsDocumentsDocumentLinksService(s)
	rs.ReferenceId = NewProjectsLocationsDocumentsReferenceIdService(s)
	return rs
}

type ProjectsLocationsDocumentsService struct {
	s *Service

	DocumentLinks *ProjectsLocationsDocumentsDocumentLinksService

	ReferenceId *ProjectsLocationsDocumentsReferenceIdService
}

func NewProjectsLocationsDocumentsDocumentLinksService(s *Service) *ProjectsLocationsDocumentsDocumentLinksService {
	rs := &ProjectsLocationsDocumentsDocumentLinksService{s: s}
	return rs
}

type ProjectsLocationsDocumentsDocumentLinksService struct {
	s *Service
}

func NewProjectsLocationsDocumentsReferenceIdService(s *Service) *ProjectsLocationsDocumentsReferenceIdService {
	rs := &ProjectsLocationsDocumentsReferenceIdService{s: s}
	return rs
}

type ProjectsLocationsDocumentsReferenceIdService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsRuleSetsService(s *Service) *ProjectsLocationsRuleSetsService {
	rs := &ProjectsLocationsRuleSetsService{s: s}
	return rs
}

type ProjectsLocationsRuleSetsService struct {
	s *Service
}

func NewProjectsLocationsSynonymSetsService(s *Service) *ProjectsLocationsSynonymSetsService {
	rs := &ProjectsLocationsSynonymSetsService{s: s}
	return rs
}

type ProjectsLocationsSynonymSetsService struct {
	s *Service
}

type AbuseiamAbuseType struct {
	// Possible values:
	//   "NONE" - no abuse
	//   "OTHER_ABUSE" - generic abuse that isn't enumerated here
	//   "CHILD_PORN" - illegal child porn images
	//   "PORNOGRAPHY"
	//   "SPAM"
	//   "PHISHING"
	//   "HATE"
	//   "TOS_OTHER" - To be only used for Multi-Image Review.
	//   "MALWARE" - MALWARE includes viruses, worms, trojans, adware and
	// even potentially unwanted software which may not necessarily be
	// harmful.
	//   "MALICIOUS_JAVASCRIPT"
	//   "NOT_FAMILY_SAFE" - DEPRECATED - For safe searches, etc.
	//   "IMPERSONATION"
	//   "PEDOPHILIA" - Not illegal, but image or text content
	//   "PERSONAL_INFO" - promoting or related to young pornography
	// Personally identifiable information
	//   "COPYRIGHT"
	//   "HIGH_RISK" - High risk reviews for any client.
	//   "VIOLENCE"
	//   "UNSAFE_RACY" - Content that is unsafe because it is sexually
	//   "UNSAFE_OTHER" - suggestive/racy Content that is unsafe for other
	// reasons than
	//   "FAKE_USER" - being sexually suggestive/racy. Category for users
	// who are not real
	//   "NAME_VIOLATION" - User's name that violates policy.
	//   "PLUSONE_VIOLATION" - Violates PLUSONE policy.
	//   "DEFAMATION" - Defamation claims
	//   "TRADEMARK" - Trademark violations where Google could be
	//   "COURT_ORDER" - liable Third-party court orders
	//   "GOVERNMENT_ORDER" - Government request, regardless of reason
	//   "LOCAL_LAWS" - Other misc country-specific laws
	//   "PRIVACY" - Local privacy laws
	//   "ES_BLACKLIST" - Internal type to check es content against
	//   "ES_COMMENTS_BLACKLIST" - the ocelot blocklist. Internal type.
	//   "HARASSMENT" - Consistent harassing behaviour directed
	//   "COMPROMISED" - towards a person. Hijacked or Compromised profile.
	//   "LOW_QUALITY" - Low quality/Annoying content.
	//   "API_VIOLATION" - Violates APIARY policy.
	//   "REGULATED" - Contains regulated products and services, such as
	// pharmaceuticals, alcohol, tobacco, etc. For details,
	// https://sites.google.com/a/google.com/crt-policy-site/regulated
	//   "CAROUSEL_FRAME_BLACKLIST" - Internal type.
	//   "QUOTA_EXCEEDED" - Quota exceeded for the action.
	//   "FOUNTAIN_BLACKLIST" - Internal type.
	//   "COPPA_REGULATED" - Contains content regulated by COPPA.
	//   "DOXXING" - Revealing personal/protected information.
	//   "SOFT_HATE" - Pattern of behavior verdicts. Used to aggregate
	// verdicts that aren't typically bad enough for one of the above
	// verdicts, but something we want to keep track of in cases of rotten
	// behavior. Hate without incitement
	//   "SOFT_HARASSMENT" - Harassment that does meet the harm bar.
	//   "OBNOXIOUS" - Obnoxious, Lousy behavior, not against TOS.
	//   "UNWANTED" - Content targeted at a person who considered
	//   "NOT_UNICORN_SAFE" - Not safe for kids.
	//   "FAKE_ENGAGEMENT" - Engagements that are not organic.
	//   "COUNTERFEIT" - Promotion of counterfeit product claims.
	//   "CTM" - Circumvention of Technological measures
	Id string `json:"id,omitempty"`

	// Subtype: Optional client specific subtype of abuse that is too
	// specific to belong in the above enumeration. For example, some client
	// may want to differentiate nudity from graphic sex, but both are
	// PORNOGRAPHY.
	Subtype string `json:"subtype,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AbuseiamAbuseType) MarshalJSON() ([]byte, error) {
	type NoMethod AbuseiamAbuseType
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AbuseiamAgeRestriction struct {
	// AgeYears: This restriction applies if the user is between
	// [min_age_years, age_years) years old.
	AgeYears int64 `json:"ageYears,omitempty"`

	MinAgeYears int64 `json:"minAgeYears,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AgeYears") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AgeYears") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AbuseiamAgeRestriction) MarshalJSON() ([]byte, error) {
	type NoMethod AbuseiamAgeRestriction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AbuseiamAndRestriction struct {
	// Child: This restriction applies if all of the children apply.
	Child []*AbuseiamUserRestriction `json:"child,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Child") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Child") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AbuseiamAndRestriction) MarshalJSON() ([]byte, error) {
	type NoMethod AbuseiamAndRestriction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AbuseiamClient: A client is be a Google product, or subproduct that
// provides content for AbuseIAm to classify.
type AbuseiamClient struct {
	// Possible values:
	//   "ABUSE_TEAM"
	//   "SQE" - Search Quality Eval
	//   "SEARCH" - Web Search.
	//   "POSTINI"
	//   "BLOGGER"
	//   "ORKUT"
	//   "ZIPIT"
	//   "GROUPS"
	//   "RIPTIDE"
	//   "GADGETS" - OpenSocial
	//   "SITES"
	//   "READER"
	//   "DOCS" - Obsolete. Use WRITELY.
	//   "U2U" - Obsolete. Merged into Google Groups.
	//   "YOUTUBE"
	//   "POPTART" - Obsolete.
	//   "COSMO"
	//   "PROFILES"
	//   "KNOL" - Obsolete.
	//   "SKETCHUP"
	//   "CALENDAR"
	//   "HOTSHOTS"
	//   "TRIKI" - Obsolete.
	//   "MAPS"
	//   "COMMUNITY_TRANSLATION"
	//   "WRITELY" - Being superseded by KIX soon.
	//   "SPREADSHEET_FORM" - Freebird forms only.
	//   "SPREADSHEET" - Trix, and Bluebird forms.
	//   "EXPLORER" - Blobs stored by explorer.
	//   "FINANCE" - Obsolete.
	//   "GMR"
	//   "LAIBA" - Obsolete. Product has been shut down.
	//   "CONFUCIUS" - Obsolete. Product has been shut down.
	//   "PRESENTATION"
	//   "CHROME_EXTENSION" - Obsolete. It will be replaced by
	// CHROME_WEBSTORE
	//   "WENDA" - Obsolete. It has been merged into Confucius.
	//   "TACOTOWN" - Obsolete. Has been replaced with ES.
	//   "KRAKEN" - Obsolete.
	//   "URL_SHORTENER"
	//   "WAREHOUSE"
	//   "ANDROID_VM"
	//   "CODESITE"
	//   "FRIEND_CONNECT"
	//   "GEOWIKI"
	//   "GOOGLE_LABS"
	//   "HELP_CENTER" - Obsolete.
	//   "SEARCHWIKI" - Obsolete.
	//   "SIDEWIKI" - Obsolete.
	//   "TOPIC_SEARCH" - Obsolete.
	//   "VIDEO"
	//   "GOOGLEBASE"
	//   "FEEDBURNER"
	//   "PUBLISHER_QUALITY"
	//   "NOTEBOOK" - Obsolete.
	//   "SMARTLISTS"
	//   "ENTERPRISE_MARKETPLACE"
	//   "BOOKS"
	//   "IGOOGLE"
	//   "USENET"
	//   "TRANSLATE"
	//   "PERFECT_STREAM" - Obsolete.
	//   "PHOTOS"
	//   "AFMA" - Obsolete.
	//   "LIKES"
	//   "QUESTIONS"
	//   "SKYJAM"
	//   "MIC" - Obsolete.
	//   "ANDROID_MARKET"
	//   "CHROME_WEBSTORE"
	//   "FINSKY"
	//   "BARNOWL"
	//   "STREET_VIEW"
	//   "ADCONNECT" - Obsolete.
	//   "ES" - Emerald Sea.
	//   "HELLO" - Obsolete. Project has been terminated.
	//   "TRADER"
	//   "SCHEMER"
	//   "ANDROID" - Android and its clients/subservice.
	//   "MINE" - Obsolete.
	//   "GAIA"
	//   "GOGGLES" - Obsolete.
	//   "SIGNUP"
	//   "BABEL"
	//   "CHECKOUT"
	//   "TASTEMAKER"
	//   "STRATUS" - Stratus uses the corpus name as subservice.
	//   "DRAGONFLY" - Obsolete.
	//   "APIARY" - API integration with DevConsole.
	//   "CAROUSEL" - ES FrameService traffic (initialy intended for Diary).
	//   "FOUNTAIN" - ES content from fountain widget.
	//   "GEOPIX" - Photo content in geo (e.g. Google+ Local).
	//   "VILLAGE" - UGC for knowledge graph
	//   "KIX" - Replaces WRITELY.
	//   "AMARNA" - Image search indexing pipeline team.
	//   "GINKGO" - Social shopping.
	//   "TEE" - Obsolete. Helpouts has been shut down.
	//   "SHOPPING" - Product reviews.
	//   "SLAM" - SLAM server
	//   "APPENGINE" - App Engine
	//   "GUNS" - Google Unified Notifications Service
	//   "CULTURAL" - Cultural Institute products.
	//   "COMPUTEENGINE" - Compute Engine.
	//   "BIGSTORE" - Big Store.
	//   "COPACABANA" - Service that keeps a COPPA content list.
	//   "ANALYTICS" - Google Analytics and its subservices.
	//   "GRANDCENTRAL" - Google Voice.
	//   "GMAIL" - Gmail.
	//   "GLASS" - Project Glass.
	//   "CRISIS_RESPONSE" - OBSOLETE - Google.org Crisis Response UGC.
	//   "GJOBS" - Garage, or G+ Jobs.
	//   "HAZMAT" - Hazmat, or Child Safety Server.
	//   "SAFE_BROWSING" - Safe browsing team (Mawler, Ictis,
	// anti-phishing).
	//   "CLOUD" - Common client for Cloud services.
	//   "PANTHEON" - Cloud main front end console.
	//   "CLUSTER" - Common client for Cluff pipelines.
	//   "KEEP" - Google Keep client.
	//   "APP_HISTORY" - App History.
	//   "COMMERCIAL_ENTITY" - For expanding commercial entity graph:
	// go/daisy-design
	//   "ARES_DATA_PROVIDER" - Access data provided by Ares.
	// go/project-ares for more details.
	//   "ARES_DATA_WRITER"
	//   "BIZBUILDER" - Local businesses.
	//   "RITZ" - Google Sheets (this and SPREADSHEET_FORM replace
	// SPREADSHEET)
	//   "POLLS" - Google Polls client.
	//   "APPINVITE" - Social Platform AppInvite (go/appinvite).
	Id string `json:"id,omitempty"`

	// Subservice: The name of the subservice within a client. This
	// subservice can be used to affect the flow of decision script, or
	// selection of backend classifiers. For example, StreetView may want to
	// specify a panel is insufficiently blurred (maybe there is a lisense
	// plate or public sex, etc), which requires manual review then the
	// subservice might be "blurring".
	Subservice string `json:"subservice,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AbuseiamClient) MarshalJSON() ([]byte, error) {
	type NoMethod AbuseiamClient
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AbuseiamClusterEvaluationContext: Extra information regarding
// evaluations received through cluster review.
type AbuseiamClusterEvaluationContext struct {
	// ClusterFamily: The family of the cluster where the case received the
	// evaluation.
	ClusterFamily string `json:"clusterFamily,omitempty"`

	// ClusterRowkey: The AbuseIAm rowkey of the cluster where the case
	// received an evaluation.
	ClusterRowkey string `json:"clusterRowkey,omitempty"`

	// GaiaIdToEscalate: The gaia id of a mail box that ops can send
	// inquiries to for appeals. Used only by user clusters to fill a
	// required gatekeeper param. See
	// gaia_disableserver.DisableSpec.escalate_to field.
	GaiaIdToEscalate int64 `json:"gaiaIdToEscalate,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "ClusterFamily") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ClusterFamily") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AbuseiamClusterEvaluationContext) MarshalJSON() ([]byte, error) {
	type NoMethod AbuseiamClusterEvaluationContext
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AbuseiamConstantRestriction struct {
	// Type: A constant of type TRUE always applies, and of type FALSE never
	// applies.
	//
	// Possible values:
	//   "ALWAYS_TRUE"
	//   "ALWAYS_FALSE"
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Type") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Type") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AbuseiamConstantRestriction) MarshalJSON() ([]byte, error) {
	type NoMethod AbuseiamConstantRestriction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AbuseiamContentRestriction: Pair of Verdicts used for ProjectR
// age/geo gating. See http://go/projectr for more information.
type AbuseiamContentRestriction struct {
	// AdminVerdict: Takedowns specified by admins via AbuseIAm
	AdminVerdict []*AbuseiamVerdict `json:"adminVerdict,omitempty"`

	// UserVerdict: User-specified takedowns
	UserVerdict []*AbuseiamVerdict `json:"userVerdict,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdminVerdict") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdminVerdict") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AbuseiamContentRestriction) MarshalJSON() ([]byte, error) {
	type NoMethod AbuseiamContentRestriction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AbuseiamEvaluation: Backends return Evaluations to AbuseIAm. One of
// the things Evaluations are used for is to explain Verdicts.
type AbuseiamEvaluation struct {
	AbuseType *AbuseiamAbuseType `json:"abuseType,omitempty"`

	// Backend: Who creates this Evaluation. This field is required.
	//
	// Possible values:
	//   "UNKNOWN"
	//   "ADMIN" - Eval directly from the AbuseIAm server.
	//   "GRADS"
	//   "OCELOT"
	//   "SPAMIAM"
	//   "MANUAL_REVIEW"
	//   "MAWLER"
	//   "SNEAKY_JS" - Deprecated and code removed.
	//   "DOWNLOADER"
	//   "PORN_CLASSIFIER" - Text-based porn classifier.
	//   "GIBBERISH_DETECTOR" - Language model-based gibberish detector.
	//   "ANTIVIRUS"
	//   "GAUSS" - Gauss positive score.
	//   "REALUSERS"
	//   "USERRANK" - Gmail userrank goodness score.
	//   "GRADS_AGGRESSIVE"
	//   "BULK_ACTION" - Intended for manually executed bulk actions.
	//   "BADWORD" - Deprecated. Please use PATTERNLIST instead.
	//   "GAIA" - Gaia account maninuplation (disable, enable).
	//   "LINKS_COUNT"
	//   "RE_RULE" - The most common type of rule.
	//   "SLAM"
	//   "AUTHORRANK" - Authorrank.percentile -> score.
	//   "USERRANK_BADNESS" - Gmail userrank badness score.
	//   "GAUSS_EXPLICIT"
	//   "GAUSS_IMPLICIT"
	//   "RETRIEVE_MESSAGE" - For message retrieving only.
	//   "SPAM_REPORT"
	//   "SQUEAL"
	//   "BLOGGER_LOGS"
	//   "TRUSTRANK_PHISHING"
	//   "CATFOOD"
	//   "IMAGE_PORN_CLASSIFIER"
	//   "OCELOT_IMPORT"
	//   "FIFE_IMAGE_FETCHER"
	//   "FAST_RISING_FEATURES"
	//   "BOTGUARD" - Special rule in decision scripts.
	//   "NAME_CHECKER"
	//   "CHEETAH" - Deprecated. Do not use. Use CHEETAH_IMPORT
	//   "GALLIFREY"
	//   "OCELOT_DELETE"
	//   "RULE" - For miscellaneous rules in decision scripts
	//   "FOCUS" - that are not separate backends.
	//   "VIDEO_THUMBNAILER"
	//   "PATTERNLIST" - Check texts against a list of regex patterns.
	//   "METADATA" - Reads data from metadata store (aka BadWolf).
	//   "METADATA_IMPORT" - Metadata import adapter.
	//   "NAME_DETECTOR" - Name detector adapter.
	//   "SHINGLE_COMPUTER" - Computes shingles for text messages.
	//   "WIGGUM" - Does search-by-image using Wiggum Server.
	//   "BINARY_EXPLORATION" - Slow backend. See http://go/bineval.
	//   "REVNET" - Review graph analysis, stored in metadata.
	//   "FURS"
	//   "YOUTUBE_CLASSIFIER" - Classifies messages using the youtube
	// models.
	//   "IDV" - Reads UserProfile from the IDV server.
	//   "CLUSTERCAT"
	//   "CHEETAH_IMPORT" - Adapter that writes to Cheetah.
	//   "CHEETAH_READ" - Adapter that reads from Cheetah.
	//   "BOTGUARD_DECODE" - Adapter that decodes BotGuard response.
	//   "QUOTASERVER" - Quota server adapter.
	//   "YOUTUBE" - Video classification from youtube.
	//   "BLOGGER"
	//   "SOCIAL_GRAPH" - Evaluation from SocialGraph adapter.
	//   "WEB_SIGNALS"
	//   "TRAWLER"
	//   "NOTIFICATIONS" - Adapter that sends notifications to users.
	//   "CASES" - Adapter that interacts with Cases.
	//   "BADURLS"
	//   "LINK_IMPORT" - Adatper that imports link signals.
	//   "SHINGLE_DEDUPER" - Badwolf based shingle deduper.
	//   "DEV_CONSOLE" - Dev Console info for cloud projects.
	//   "METADATA_QUERY" - Rich query facility for BadWolf.
	//   "PLUS_PAGE" - Adapter for querying pluspage info.
	//   "YOUTUBE_VIDEO_INFO" - Queries video info from YT.
	//   "GOOGLE_ADMIN" - Google Admin for manual operations.
	//   "RESPAY" - Clould billing information and termination.
	//   "COOKBOOK" - Matched to some Cookbook recipes.
	//   "EASY_LEARN" - Machine learning models evaluations.
	//   "QUALITY_SAMPLER" - Decides if a message is sampled for quality.
	//   "BLOBSTORE" - Blobstore adapter.
	//   "OWNER" - For evaluation initiated by content owner.
	//   "POLICY" - For evaluation generated according to policy.
	//   "EXTERNAL" - For evaluations generated by services outside
	//   "ABUSEIAM_FEEDBACK" - AbuseIAm. Adapter that sends feedbacks
	// between clients.
	//   "BIGSTORE" - Adapters that access Bigstore files.
	//   "PHOTO_SERVICE" - Adapter that queries Photo Service.
	//   "GRADS_RELATED" - Fetch grads related accounts.
	//   "REAPER" - Site reputation service by safe browsing team
	//   "GATEKEEPER" - Gaia disableserver.
	//   "VIPER" - Adapters that run a Viper graph.
	//   "MSISDN" - Phone metadata adapter.
	//   "VIDEO_REVIEW" - The YouTube Video review service.
	//   "CSAI_MATCH" - Video matching for CSAI.
	//   "REDQUEEN" - RedQueen reputation adapter.
	//   "STREAMER_INDEXER" - Streamer Indexer Service to get locations
	//   "DREMEL" - of a video for various formats. Dremel service.
	//   "VISUAL_SEARCH_SERVICE_PORN" - Visual search service for porn
	// scores.
	//   "VISUAL_SEARCH_SERVICE_OCR" - Visual search service for OCR.
	//   "IMPLICIT_SOCIAL_GRAPH" - implicit social graph for affinity scores
	//   "EASY_LEARN_BLEND" - Blend Service for Easy Learn (ML models)
	//   "USER_AURA" - User aura service.
	//   "GOOPS" - Goops adapter used for publishing messages.
	//   "ANDROID_CHECKIN" - Android checkin data including device info
	//   "ARES_DATA_PROVIDER" - Adapter that fetches data from Ares.
	//   "DROIDGUARD_VERDICT" - Retrieves droidguard verdict for the device.
	//   "ARES_DATA_WRITER" - Adapter that writes data into Ares.
	//   "ADAPTIVE_QUOTA" - Adapter to talk to Adaptive Quota system.
	//   "AIAPLX" - For evaluations derived from aia-plx queries.
	//   "INFAME" - For evaluations derived from infame.
	//   "ARES" - For evaluations generated by Ares.
	//   "VISUAL_SEARCH_SERVICE_ICA" - Visual search service for ICA.
	//   "VISUAL_SEARCH_SERVICE_BUTTON_DETECTION"
	//   "VISUAL_SEARCH_SERVICE_LOGO_DETECTION" - Visual search service for
	Backend string `json:"backend,omitempty"`

	// ClusterEvaluationContext: Extra information regarding the cluster
	// review context where the case received the evaluation.
	ClusterEvaluationContext *AbuseiamClusterEvaluationContext `json:"clusterEvaluationContext,omitempty"`

	// Comment: Backends can choose to put some debug info in addition to
	// abuse_type, score, and status.
	Comment string `json:"comment,omitempty"`

	// Feature: A set of repeated features to allow adapters to return semi
	// structured data. Please, prefer using feature instead of the old
	// misc_data field since it supports richer and more structured data to
	// be passed back.
	Feature []*AbuseiamFeature `json:"feature,omitempty"`

	// ManualReviewInfo: Information about the manual review, for manual
	// review evaluations. Do NOT expect this field to be set if `backend !=
	// MANUAL_REVIEW`.
	ManualReviewInfo *AbuseiamManualReviewEvaluationInfo `json:"manualReviewInfo,omitempty"`

	// MiscData: This field is used to store miscellaneous information that
	// Backend might provide. If you find youself here considering to use
	// this field, please prefer using the repeated feature field below
	// instead. It supports a richer structure for passing complex data back
	// from the backend.
	MiscData []*AbuseiamNameValuePair `json:"miscData,omitempty"`

	// ProcessTimeMillisecs: Time in milliseconds when the Backend processed
	// this Evaluation.
	ProcessTimeMillisecs int64 `json:"processTimeMillisecs,omitempty,string"`

	// ProcessedMicros: When the evaluation was processed by the decision
	// script.
	ProcessedMicros int64 `json:"processedMicros,omitempty,string"`

	// Region: The list of regions where the evaluation applies.
	Region []*AbuseiamRegion `json:"region,omitempty"`

	Score float64 `json:"score,omitempty"`

	// Possible values:
	//   "OK"
	//   "ERROR" - The Backend failed to process the target.
	Status string `json:"status,omitempty"`

	Target *AbuseiamTarget `json:"target,omitempty"`

	// TimestampMicros: When the Evaluation was generated.
	TimestampMicros int64 `json:"timestampMicros,omitempty,string"`

	// UserRestriction: A boolean expression tree used to define the
	// restrictions where the verdict applies. Please use
	// java/com/google/ccc/abuse/abuseiam/client/TakedownManager.java to
	// evaluate this proto.
	UserRestriction *AbuseiamUserRestriction `json:"userRestriction,omitempty"`

	// Version: Version of Backend. For rules, this string is the only way
	// to differentiate between them.
	Version string `json:"version,omitempty"`

	// VideoReviewData: Information about the video review, for video review
	// evaluations. Do NOT expect this field to be set if `backend !=
	// VIDEO_REVIEW`.
	VideoReviewData *AbuseiamVideoReviewData `json:"videoReviewData,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AbuseType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AbuseType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AbuseiamEvaluation) MarshalJSON() ([]byte, error) {
	type NoMethod AbuseiamEvaluation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *AbuseiamEvaluation) UnmarshalJSON(data []byte) error {
	type NoMethod AbuseiamEvaluation
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

type AbuseiamFeature struct {
	// BooleanValue: Exactly one of the following should be filled in.
	BooleanValue bool `json:"booleanValue,omitempty"`

	DoubleValue float64 `json:"doubleValue,omitempty"`

	// FeatureCount: Useful for applications that need to know how many
	// times a specific feature occurs
	FeatureCount int64 `json:"featureCount,omitempty,string"`

	// Int64Value: Useful for timestamps, or for numerical features where it
	// is helpful for decision scripts to have exact values.
	Int64Value int64 `json:"int64Value,omitempty,string"`

	// IntegerValue: integer value field is deprecated and shall only be
	// used for passing the following features hardcoded in
	// spamiam::SpamIAmMessage: spamiam::OrkutSenderId
	// spamiam::OrkutPostnumReports spamiam::BloggerNumComments
	// spamiam::BloggerNumCommentsByOthers Another hard-coded spamiam
	// feature is spamiam::BlogName, which can be specified via string
	// value.
	IntegerValue int64 `json:"integerValue,omitempty"`

	Name string `json:"name,omitempty"`

	StringValue []string `json:"stringValue,omitempty"`

	// TimestampSequence: This field should only be used to store a sequence
	// of timestamps associated with the feature.
	TimestampSequence googleapi.Int64s `json:"timestampSequence,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BooleanValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BooleanValue") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AbuseiamFeature) MarshalJSON() ([]byte, error) {
	type NoMethod AbuseiamFeature
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *AbuseiamFeature) UnmarshalJSON(data []byte) error {
	type NoMethod AbuseiamFeature
	var s1 struct {
		DoubleValue gensupport.JSONFloat64 `json:"doubleValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.DoubleValue = float64(s1.DoubleValue)
	return nil
}

// AbuseiamGeoRestriction: A node representing a table of regions and
// restrictions that apply to those regions. This table understands
// region inclusion and knows to apply the most specific rule, for
// example, a rule for France would override a rule for the EU for a
// user in France.
type AbuseiamGeoRestriction struct {
	Locale []*AbuseiamGeoRestrictionLocale `json:"locale,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Locale") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Locale") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AbuseiamGeoRestriction) MarshalJSON() ([]byte, error) {
	type NoMethod AbuseiamGeoRestriction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AbuseiamGeoRestrictionLocale struct {
	// Location: The location where the restriction applies. Defaults to the
	// "The world". See go/iii.
	Location string `json:"location,omitempty"`

	// Restriction: The UserRestriction that applies to this location. If
	// not specified evaluates to true.
	Restriction *AbuseiamUserRestriction `json:"restriction,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Location") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Location") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AbuseiamGeoRestrictionLocale) MarshalJSON() ([]byte, error) {
	type NoMethod AbuseiamGeoRestrictionLocale
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AbuseiamHash: Information about various hashes that can be computed
// on a message ex: simhash, attachment hash, etc
type AbuseiamHash struct {
	// Hash: 64 bit hash in the hex form.
	Hash string `json:"hash,omitempty"`

	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Hash") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Hash") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AbuseiamHash) MarshalJSON() ([]byte, error) {
	type NoMethod AbuseiamHash
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AbuseiamManualReviewEvaluationInfo: Relevant information for manual
// review evaluations.
type AbuseiamManualReviewEvaluationInfo struct {
	// Reviewer: Reviewer performing the manual review.
	Reviewer *AbuseiamManualReviewerInfo `json:"reviewer,omitempty"`

	// Tool: Tool used to perform the manual review.
	Tool *AbuseiamManualReviewTool `json:"tool,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Reviewer") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Reviewer") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AbuseiamManualReviewEvaluationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AbuseiamManualReviewEvaluationInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AbuseiamManualReviewTool struct {
	ExperimentId string `json:"experimentId,omitempty"`

	// Possible values:
	//   "UNKNOWN"
	//   "NUFF" - content-review.corp.google.com
	//   "GOOGLE_ADMIN" - google-admin.corp.google.com
	//   "YOUTUBE" - admin.youtube.com
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExperimentId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExperimentId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AbuseiamManualReviewTool) MarshalJSON() ([]byte, error) {
	type NoMethod AbuseiamManualReviewTool
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AbuseiamManualReviewerInfo struct {
	// Possible values:
	//   "UNKNOWN"
	//   "LEGAL" - Member of mdb/legal-removals-contentreview-abuseiam.
	//   "POLICY" - Member of mdb/user-policy.
	//   "ANALYST" - Member of mdb/abuse-analysts.
	//   "LEGAL_PANEL" - A group of two or more members of
	// mdb/legal-removals-contentreview-abuseiam who review content
	// collectively. This credential will be set manually in decision
	// scripts when reviews come from the appropriate queue and will not be
	// automatically set by the manual review server.
	Credential []string `json:"credential,omitempty"`

	Username string `json:"username,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Credential") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Credential") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AbuseiamManualReviewerInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AbuseiamManualReviewerInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AbuseiamNameValuePair struct {
	Name string `json:"name,omitempty"`

	NonUtf8Value string `json:"nonUtf8Value,omitempty"`

	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AbuseiamNameValuePair) MarshalJSON() ([]byte, error) {
	type NoMethod AbuseiamNameValuePair
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AbuseiamNotRestriction struct {
	// Child: This restriction applies if the child does not apply. Only one
	// is allowed. "repeated" is used to avoid breaking Sawzall (See
	// b/6758277).
	Child []*AbuseiamUserRestriction `json:"child,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Child") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Child") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AbuseiamNotRestriction) MarshalJSON() ([]byte, error) {
	type NoMethod AbuseiamNotRestriction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AbuseiamOrRestriction struct {
	// Child: This restriction applies if any of the children apply.
	Child []*AbuseiamUserRestriction `json:"child,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Child") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Child") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AbuseiamOrRestriction) MarshalJSON() ([]byte, error) {
	type NoMethod AbuseiamOrRestriction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AbuseiamRegion struct {
	// Region: This is a CLDR Region Code:
	// http://wiki/Main/IIIHowTo#using_region It is used to denote the
	// region affected by a verdict.
	Region string `json:"region,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Region") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Region") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AbuseiamRegion) MarshalJSON() ([]byte, error) {
	type NoMethod AbuseiamRegion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AbuseiamSpecialRestriction: A SpecialRestriction is a standardized
// UserRestriction which lives in a table maintained via CDD.
type AbuseiamSpecialRestriction struct {
	// Possible values:
	//   "ALCOHOL"
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Type") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Type") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AbuseiamSpecialRestriction) MarshalJSON() ([]byte, error) {
	type NoMethod AbuseiamSpecialRestriction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AbuseiamTarget struct {
	Id string `json:"id,omitempty"`

	// Possible values:
	//   "MESSAGE_ID" - verdict is issued on the whole message
	//   "CHUNK_ID" - verdict is issued on the specified chunk
	//   "IMAGE_URL" - target id is an image url inside chunk content
	//   "URL" - target id is a non-image url inside chunk content
	//   "USER_ID" - abuse happens at gaia user level
	//   "IP" - target id is an IP address
	//   "SITE" - target id is a sitechunk
	//   "SITEDOMAIN" - target id is a domain
	//   "ENTITY_ID" - The 4 entries below are *only* for the +1 pipeline.
	// Please do not use elsewhere. entity id is a generic Zipit ID
	//   "PERFECT_STREAM_ID" - Obsolete.
	//   "ACTIVITY_ID" - activity id in ASBE for ES
	//   "COMMENT_ID" - comment id for ASBE comments in ES
	//   "AD_ID" - ad id for ES
	//   "TEXT" - text target. Used in Ocelot name reputation.
	//   "TEXT_FRAGMENT" - text fragment. Ocelot for name reputation.
	//   "CLUSTER_MEMBER_ID" - Targets for Cluster reviews. See
	// http://go/cluff-design-doc. Message ID for the targetted cluster
	// member
	//   "EMBED_ID" - embed_id for ASBE embeds in ES
	//   "ANDROID_ID" - android_id of the device
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AbuseiamTarget) MarshalJSON() ([]byte, error) {
	type NoMethod AbuseiamTarget
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AbuseiamUserNotification: A structure used to configure a
// notification to a user.
type AbuseiamUserNotification struct {
	// Possible values:
	//   "UNKNOWN"
	//   "BUILT_IN" - Use product built-in notification, such as pop-ups.
	//   "EMAIL" - Email user, e.g., through ANS(http://sites/cat/ans).
	//   "GAIA" - Show notifications at Gaia level, such as during login.
	Channel string `json:"channel,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Channel") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Channel") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AbuseiamUserNotification) MarshalJSON() ([]byte, error) {
	type NoMethod AbuseiamUserNotification
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AbuseiamUserRestriction: Describes restrictions on where the verdict
// applies. Please use {@code TakedownManager} to evaluate this proto.
type AbuseiamUserRestriction struct {
	AgeRestriction *AbuseiamAgeRestriction `json:"ageRestriction,omitempty"`

	// AndRestriction: Operators
	AndRestriction *AbuseiamAndRestriction `json:"andRestriction,omitempty"`

	// ConstantRestriction: Constant
	ConstantRestriction *AbuseiamConstantRestriction `json:"constantRestriction,omitempty"`

	// GeoRestriction: Leaf Nodes
	GeoRestriction *AbuseiamGeoRestriction `json:"geoRestriction,omitempty"`

	NotRestriction *AbuseiamNotRestriction `json:"notRestriction,omitempty"`

	OrRestriction *AbuseiamOrRestriction `json:"orRestriction,omitempty"`

	SpecialRestriction *AbuseiamSpecialRestriction `json:"specialRestriction,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AgeRestriction") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AgeRestriction") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AbuseiamUserRestriction) MarshalJSON() ([]byte, error) {
	type NoMethod AbuseiamUserRestriction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AbuseiamVerdict: Verdict against a target. AbuseIAm generates a
// verdict based on evaluations. AbuseIAm can send such verdicts to
// clients for enforcement.
type AbuseiamVerdict struct {
	// Client: Target client of the verdict. It can be used to differentiate
	// verdicts from multiple clients when such verdicts are processed in
	// one common place.
	Client *AbuseiamClient `json:"client,omitempty"`

	// Comment: Additional info regarding the verdict.
	Comment string `json:"comment,omitempty"`

	// Possible values:
	//   "ERROR"
	//   "NO_ACTION" - The content is okay and no action needs to be taken.
	//   "GOOD" - To mark content/user as good.
	//   "DELETE"
	//   "INTERSTITIAL" - Give a user an interstial message. E.g., via a
	// pop-up or an email.
	//   "HIDE"
	//   "BLACK_LIST" - The product should black list this content itself.
	//   "MARK_AS_SPAM"
	//   "REWRITE_LINKS" - There's something bad about the links, so we
	// recommend that the links be 'scrubbed' to go through the GWS
	// redirector to protect against malware and phishing:
	// http://wiki.corp.google.com/twiki/bin/view/Main/SafeRedirector
	//   "HIDE_AND_NOTIFY" - HIDE_AND_NOTIFY is used when the target needs
	// to be hidden, but the UI needs to show an appropriate error message.
	//   "FREEZE_SERVICE" - Freeze a user on service level. E.g., a frozen
	// user can not generate new content.
	//   "SUSPEND_SERVICE" - Suspend a user on service level.
	//   "SMS_DISABLE" - SMS-disable a user on Gaia level.
	//   "NOTIFY" - Notify a user (e.g., warn a user).
	Decision string `json:"decision,omitempty"`

	// DurationMins: Time duration (in minutes) of the verdict.
	DurationMins int64 `json:"durationMins,omitempty"`

	// Evaluation: Evaluations relevant to this verdict. Every Verdict
	// should contain at least one Evaluation.
	Evaluation []*AbuseiamEvaluation `json:"evaluation,omitempty"`

	// Hashes: Details of all the hashes that can be computed on a message,
	// such as simhash and attachment hash
	Hashes []*AbuseiamHash `json:"hashes,omitempty"`

	// IsLegalIssued: Is this verdict issued by legal?
	IsLegalIssued bool `json:"isLegalIssued,omitempty"`

	// MiscScores: This field is used to pass relevant / necessary scores to
	// our clients. For eg: ASBE propogates these scores to moonshine.
	MiscScores []*AbuseiamNameValuePair `json:"miscScores,omitempty"`

	// ReasonCode: A short description of the reason why the verdict
	// decision is made.
	ReasonCode string `json:"reasonCode,omitempty"`

	// Region: The regions in which this verdict should be enforced. Absence
	// of this field indicates that the verdict is applicable everywhere.
	Region []*AbuseiamRegion `json:"region,omitempty"`

	// Restriction: Restrictions on where this verdict applies. If any
	// restriction is met, the verdict is applied there. If no restrictions
	// are present, the verdict is considered global.
	Restriction []*AbuseiamVerdictRestriction `json:"restriction,omitempty"`

	// StrikeCategory: Category of the strike if this is a strike verdict.
	//
	// Possible values:
	//   "ES" - General Emerald Sea.
	//   "CP" - Child porn.
	//   "COPYRIGHT" - Copyright violations.
	//   "BLOGGER" - Blogger.
	//   "GRANDCENTRAL" - Google Voice.
	//   "DRIVE" - Drive.
	//   "CLOUD" - Cloud platform.
	//   "SITES" - Google Sites.
	StrikeCategory string `json:"strikeCategory,omitempty"`

	Target *AbuseiamTarget `json:"target,omitempty"`

	// TargetTimestampMicros: The timestamp of the target. E.g., the time
	// when the target was updated.
	TargetTimestampMicros int64 `json:"targetTimestampMicros,omitempty,string"`

	// TimestampMicros: When the verdict is generated
	TimestampMicros int64 `json:"timestampMicros,omitempty,string"`

	// UserNotification: Extra notification(s) to be delivered to target
	// user or message owner about the verdict.
	UserNotification []*AbuseiamUserNotification `json:"userNotification,omitempty"`

	// Version: version of decision script
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Client") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Client") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AbuseiamVerdict) MarshalJSON() ([]byte, error) {
	type NoMethod AbuseiamVerdict
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AbuseiamVerdictRestriction: Describes restrictions on where the
// verdict applies.
type AbuseiamVerdictRestriction struct {
	// Context: For a restriction to apply, all contexts must be satisfied.
	// For example, if context[0] is COUNTRY/'GERMANY' and context[1] is
	// DESTINATION_STREAM/'gplus:SQUARE:knitting_discussion', then the
	// verdict applies only when the 'knitting discussion' square is viewed
	// from inside Germany. Please note that this is present for legacy
	// reasons and users of this field would be migrated to use the
	// user_restriction field defined below.
	Context []*AbuseiamVerdictRestrictionContext `json:"context,omitempty"`

	// UserRestriction: A boolean expression tree used to define the
	// restrictions where the verdict applies. Please use
	// java/com/google/ccc/abuse/abuseiam/client/TakedownManager.java to
	// evaluate this proto.
	UserRestriction *AbuseiamUserRestriction `json:"userRestriction,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Context") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Context") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AbuseiamVerdictRestriction) MarshalJSON() ([]byte, error) {
	type NoMethod AbuseiamVerdictRestriction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AbuseiamVerdictRestrictionContext: Describes a dimension of a context
// where a verdict applies.
type AbuseiamVerdictRestrictionContext struct {
	// Id: String identifying the context.
	Id string `json:"id,omitempty"`

	// Possible values:
	//   "UNKNOWN" - Dummy default value. Avoid using it explicitly as a
	// Type.
	//   "DESTINATION_STREAM" - DESTINATION_STREAM is used when a verdict
	// only applies to content in a particular indexed stream/channel.
	// Examples include Squares, Blogs, and Youtube videos.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AbuseiamVerdictRestrictionContext) MarshalJSON() ([]byte, error) {
	type NoMethod AbuseiamVerdictRestrictionContext
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AbuseiamVideoReviewData: Information about a video review.
type AbuseiamVideoReviewData struct {
	// ReferenceFragment: Serialized repeated
	// youtube_admin.adminmatch.csai.ReferenceFragment
	ReferenceFragment []string `json:"referenceFragment,omitempty"`

	// Reviewer: Information about the video reviewer.
	Reviewer *AbuseiamVideoReviewer `json:"reviewer,omitempty"`

	// VideoId: The Viper id of the video.
	VideoId string `json:"videoId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ReferenceFragment")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ReferenceFragment") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AbuseiamVideoReviewData) MarshalJSON() ([]byte, error) {
	type NoMethod AbuseiamVideoReviewData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AbuseiamVideoReviewer: Information about video reviewers.
type AbuseiamVideoReviewer struct {
	// Possible values:
	//   "UNKNOWN" - Default value, do not use explicitly.
	//   "CRT" - Content review team. This team does general reviews.
	//   "TIERED_CRT" - Special high quality CRT which do more high
	// confidence reviews.
	//   "POLICY" - Policy team.
	//   "ANALYSTS" - Analysts from the abuse team.
	//   "LEGAL" - The general legal team.
	//   "LEGAL_CSAI" - Queue for LEGAL_CSAI team for high priority items.
	//   "LEGAL_REMOVALS" - The legal team which handles content removals
	// (e.g. copyright).
	//   "HIJACKING_TEAM" - Team which deals with hijacking reviews.
	//   "CRT_CSAI" - CRT Team in Dublin, which handles CSAI-related
	// reviews.
	//   "LEGAL_CSAI_LOW_PRIORITY" - Queue for lower priority suspected CSAI
	// items (e.g. content from disabled users)
	Type string `json:"type,omitempty"`

	// Username: The username of the person doing the video review.
	Username string `json:"username,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Type") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Type") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AbuseiamVideoReviewer) MarshalJSON() ([]byte, error) {
	type NoMethod AbuseiamVideoReviewer
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AdsShoppingReportingOffersSerializedSoriId: The serialized form of a
// SORI id. NOTE that this proto is stored in V4/O4 index and that new
// fields should not be added without getting an agreement from the
// serving team as well.
type AdsShoppingReportingOffersSerializedSoriId struct {
	HighId uint64 `json:"highId,omitempty,string"`

	LowId1 uint64 `json:"lowId1,omitempty,string"`

	LowId2 uint64 `json:"lowId2,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "HighId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HighId") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AdsShoppingReportingOffersSerializedSoriId) MarshalJSON() ([]byte, error) {
	type NoMethod AdsShoppingReportingOffersSerializedSoriId
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type Anchors struct {
	Anchor []*AnchorsAnchor `json:"anchor,omitempty"`

	// HomepageAnchorsDropped: The total # of local homepage anchors dropped
	// in AnchorAccumulator.
	HomepageAnchorsDropped int64 `json:"homepageAnchorsDropped,omitempty,string"`

	// IndexTier: The index tier from which the anchors were extracted. Note
	// that this is only valid in the anchor record written by
	// linkextractor. The value can be one of the enum values defined in
	// segindexer/types.h.
	IndexTier int64 `json:"indexTier,omitempty"`

	// LocalAnchorsDropped: The total # of local non-homepage anchors
	// dropped in AnchorAccumulator.
	LocalAnchorsDropped int64 `json:"localAnchorsDropped,omitempty,string"`

	// NonlocalAnchorsDropped: The total # of non-local anchors dropped in
	// AnchorAccumulator.
	NonlocalAnchorsDropped int64 `json:"nonlocalAnchorsDropped,omitempty,string"`

	// RedundantAnchorsDropped: The *_anchors_dropped fields below are not
	// populated by Alexandria, which uses cdoc.anchor_stats instead. The
	// total # of redundant anchors dropped in linkextractor.
	RedundantAnchorsDropped int64 `json:"redundantAnchorsDropped,omitempty,string"`

	Redundantanchorinfo []*AnchorsRedundantAnchorInfo `json:"redundantanchorinfo,omitempty"`

	// SupplementalAnchorsDropped: The total # of supplemental anchors
	// dropped in AnchorAccumulator. ## DEPRECATED.
	SupplementalAnchorsDropped int64 `json:"supplementalAnchorsDropped,omitempty,string"`

	// TargetDocid: may be implicit
	TargetDocid uint64 `json:"targetDocid,omitempty,string"`

	// TargetSite: HOST_LEVEL site chunking.
	TargetSite string `json:"targetSite,omitempty"`

	// TargetUrl: This is produced during link extraction but not written
	// out in the linklogs in order to save space.
	TargetUrl string `json:"targetUrl,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Anchor") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Anchor") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Anchors) MarshalJSON() ([]byte, error) {
	type NoMethod Anchors
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AnchorsAnchor struct {
	Bucket int64 `json:"bucket,omitempty"`

	// CatfishTags: CATfish tags attached to a link. These are similar to
	// link tags, except the values are created on the fly within Cookbook.
	// See: http://sites/cookbook/exporting/indexing
	CatfishTags []int64 `json:"catfishTags,omitempty"`

	// CompressedImageUrls: If the anchor contained images, these image urls
	// are stored here in compressed form.
	CompressedImageUrls []string `json:"compressedImageUrls,omitempty"`

	// CompressedOriginalTargetUrl: The anchor's original target url,
	// compressed. Available only in Alexandria docjoins when the anchor is
	// forwarded.
	CompressedOriginalTargetUrl string `json:"compressedOriginalTargetUrl,omitempty"`

	Context int64 `json:"context,omitempty"`

	// Context2: This is a hash of terms near the anchor. (This is a
	// second-generation hash replacing the value stored in the 'context'
	// field.)
	Context2 int64 `json:"context2,omitempty"`

	// CreationDate: used for history - the first and last time we have seen
	// this anchor. creation_date also used for Freshdocs Twitter indexing,
	// a retweet is an anchor of the original tweet. This field records the
	// time when a retweet is created.
	CreationDate int64 `json:"creationDate,omitempty"`

	Deleted bool `json:"deleted,omitempty"`

	DeletionDate int64 `json:"deletionDate,omitempty"`

	// Demotionreason: DEPRECATED
	Demotionreason int64 `json:"demotionreason,omitempty"`

	// EncodedNewsAnchorData: Encoded data containing information about
	// newsiness of anchor. Populated only if anchor is classified as coming
	// from a newsy, high quality site. Encoded data for anchor sources are
	// being stored in
	// googledata/quality/freshness/news_anchors/encoded_news_anchors_data.tx
	// t Scores are being computed with quality/freshness/news_anchors/
	// routines.
	EncodedNewsAnchorData int64 `json:"encodedNewsAnchorData,omitempty"`

	// Experimental: If true, the anchor is for experimental purposes and
	// should not be used in serving.
	Experimental bool `json:"experimental,omitempty"`

	// Expired: true iff exp domain
	Expired bool `json:"expired,omitempty"`

	// FirstseenDate: # days past Dec 31, 1994, 23:00:00 UTC (Unix time
	// @788914800) that this link was first seen. Should never occupy more
	// than 15 bits. NOTE: this is NOT the same as creation_date;
	// firstseen_date is filled during link extraction
	FirstseenDate int64 `json:"firstseenDate,omitempty"`

	// FirstseenNearCreation: true if we think 'firstseen_date' is an
	// accurate estimate of when the link was actually added to the source
	// page. false if it may have existed for some time before we saw it.
	FirstseenNearCreation bool `json:"firstseenNearCreation,omitempty"`

	Fontsize int64 `json:"fontsize,omitempty"`

	// ForwardingTypes: How the anchor is forwarded to the canonical,
	// available only for forwarded anchors (i.e., the field is set). The
	// forwarding types are defined in URLForwardingUtil
	// (segindexer/segment-indexer-util.h). Always use URLForwardingUtil to
	// access this field and use
	// URLForwardingUtil::GetAnchorForwardingReason to get the explanation
	// how the anchor is forwarded to the canonical. NOTE: Use with caution
	// as it is only set for docjoins generated using the urlmap from
	// repository/updater.
	ForwardingTypes int64 `json:"forwardingTypes,omitempty"`

	// Fragment: The URL fragment for this anchor (the foo in
	// http://www.google.com#foo)
	Fragment string `json:"fragment,omitempty"`

	// FullLeftContext: The full context. These are not written out in the
	// linklogs.
	FullLeftContext googleapi.Uint64s `json:"fullLeftContext,omitempty"`

	FullRightContext googleapi.Uint64s `json:"fullRightContext,omitempty"`

	// IsLocal: The bit ~roughly~ indicates whether an anchor's source and
	// target pages are on the same domain. Note: this plays no role in
	// determining whether an anchor is onsite, ondomain, or offdomain in
	// mustang (i.e., the bit above).
	IsLocal bool `json:"isLocal,omitempty"`

	// LastUpdateTimestamp: Used for history and freshness tracking - the
	// timestamp this anchor is updated in indexing.
	LastUpdateTimestamp int64 `json:"lastUpdateTimestamp,omitempty"`

	// LinkAdditionalInfo: Additional information related to the anchor,
	// such as additional anchor text or scores.
	LinkAdditionalInfo *Proto2BridgeMessageSet `json:"linkAdditionalInfo,omitempty"`

	// LinkTags: Contains info on link type, source page, etc.
	LinkTags []int64 `json:"linkTags,omitempty"`

	// Locality: For ranking purposes, the quality of an anchor is measured
	// by its "locality" and "bucket". See quality/anchors/definitions.h for
	// more information.
	Locality int64 `json:"locality,omitempty"`

	// Offset: This is the offset for the first term in the anchor - it can
	// be used as a unique ID for the anchor within the document and
	// compared against all per-tag data. This is measured in bytes from the
	// start of the document. We write this out to the linklogs to recover
	// the original order of links after source/target forwarding. This is
	// necessary for computing the global related data.
	Offset int64 `json:"offset,omitempty"`

	// OrigText: Original text, including capitalization and punctuation.
	// Runs of whitespace are collapsed into a single space.
	OrigText string `json:"origText,omitempty"`

	// OriginalTargetDocid: The docid of the anchor's original target. This
	// field is available if and only if the anchor is forwarded.
	OriginalTargetDocid uint64 `json:"originalTargetDocid,omitempty,string"`

	// PagerankWeight: Weight to be stored in linkmaps for pageranker
	PagerankWeight float64 `json:"pagerankWeight,omitempty"`

	// ParallelLinks: The number of additional links from the same source
	// page to the same target domain. Not populated if is_local is true.
	ParallelLinks int64 `json:"parallelLinks,omitempty"`

	// PossiblyOldFirstseenDate: DEPRECATED. It used to be set if
	// firstseen_date is not set. It's to indicate that the anchor is
	// possibly old, but we don't have enough information to tell until the
	// linkage map is updated. TODO(hxu) rename it to
	// possibly_old_firstseen_date_DEPRECATED after clean up other
	// dependencies.
	PossiblyOldFirstseenDate bool `json:"possiblyOldFirstseenDate,omitempty"`

	// SetiPagerankWeight: TEMPORARY
	SetiPagerankWeight float64 `json:"setiPagerankWeight,omitempty"`

	Source *AnchorsAnchorSource `json:"source,omitempty"`

	// SourceType:  is to record the quality of the anchor's source page and
	// is correlated with but not identical to the index tier of the source
	// page. In the docjoins built by the indexing pipeline (Alexandria), -
	// Anchors marked TYPE_HIGH_QUALITY are from base documents. - Anchors
	// marked TYPE_MEDIUM_QUALITY are from documents of medium quality
	// (roughly but not exactly supplemental tier documents). - Anchors
	// marked TYPE_LOW_QUALITY are from documents of low quality (roughly
	// but not exactly blackhole documents). Note that the source_type can
	// also be used as an importance indicator of an anchor (a lower
	// source_type value indicates a more important anchor), so it is
	// important to enforce that TYPE_HIGH_QUALITY < TYPE_MEDIUM_QUALITY <
	// TYPE_LOW_QUALITY To add a new source type in future, please maintain
	// the proper relationship among the types as well. TYPE_FRESHDOCS, only
	// available in freshdocs indexing, is a special case and is considered
	// the same type as TYPE_HIGH_QUALITY for the purpose of anchor
	// importance in duplicate anchor removal.
	SourceType int64 `json:"sourceType,omitempty"`

	// TargetUrlEncoding: A given target URL may be found in different
	// encodings in different documents. We store the URL encoding with each
	// source anchor so that we can count them later to find the encoding
	// most likely to be expected by the Web site. Around 0.7% of target
	// URLs are expected to require a non-default value here. The default
	// value 0 is referenced in C++ as webutil::kDefaultUrlEncoding. See
	// also webutil/urlencoding.
	TargetUrlEncoding int64 `json:"targetUrlEncoding,omitempty"`

	// Text: Space-delimited anchor words. Text that needs segmentation
	// (like CJK or Thai) is unsegmented, since we set
	// FLAGS_segment_during_lexing to false in mr-linkextractor.cc .
	Text string `json:"text,omitempty"`

	// Timestamp: This field is DEPRECATED and no longer filled. For source
	// page crawl timestamp, use Source.crawl_timestamp. Next tag id should
	// be 62.
	Timestamp int64 `json:"timestamp,omitempty,string"`

	// Type: DEPRECATED: Now in link_tags
	Type int64 `json:"type,omitempty"`

	// Weight: weights are 0-127
	Weight int64 `json:"weight,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Bucket") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Bucket") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AnchorsAnchor) MarshalJSON() ([]byte, error) {
	type NoMethod AnchorsAnchor
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *AnchorsAnchor) UnmarshalJSON(data []byte) error {
	type NoMethod AnchorsAnchor
	var s1 struct {
		PagerankWeight     gensupport.JSONFloat64 `json:"pagerankWeight"`
		SetiPagerankWeight gensupport.JSONFloat64 `json:"setiPagerankWeight"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.PagerankWeight = float64(s1.PagerankWeight)
	s.SetiPagerankWeight = float64(s1.SetiPagerankWeight)
	return nil
}

// AnchorsAnchorSource: attributes of the source document for the link
type AnchorsAnchorSource struct {
	// AdditionalInfo: Additional information related to the source, such as
	// news hub info.
	AdditionalInfo *Proto2BridgeMessageSet `json:"additionalInfo,omitempty"`

	// Cluster: anchor++ cluster id
	Cluster int64 `json:"cluster,omitempty"`

	// CompressedUrl: compressed source url
	CompressedUrl string `json:"compressedUrl,omitempty"`

	// CrawlTimestamp: Source page crawl timestamp.
	CrawlTimestamp int64 `json:"crawlTimestamp,omitempty,string"`

	// Docid: The docid field used to be "required", but it is now
	// "optional" because it is not present when anchors are stored in
	// webtable. When anchors are stored as part of docjoin files in the
	// segment indexer, however, docid should be considered required.
	Docid uint64 `json:"docid,omitempty,string"`

	// Doclength: necessary for anything?
	Doclength int64 `json:"doclength,omitempty"`

	// HomePageInfo: Information about if the source page is a home page. It
	// can be one of the enum values defined in PerDocData::HomePageInfo
	// (NOT_HOMEPAGE, NOT_TRUSTED, PARTIALLY_TRUSTED, and FULLY_TRUSTED).
	HomePageInfo int64 `json:"homePageInfo,omitempty"`

	// Indyrank: uint16 scale
	Indyrank int64 `json:"indyrank,omitempty"`

	// Ipaddr: DEPRECATED, use packed_ipaddress
	Ipaddr int64 `json:"ipaddr,omitempty"`

	// Language: default -> English
	Language int64 `json:"language,omitempty"`

	// Linkhash: 0 -> no hash
	Linkhash uint64 `json:"linkhash,omitempty,string"`

	// LocalCountryCodes: Countries to which the source page is local/most
	// relevant; stored as III identifiers for country/region codes (see
	// http://go/iii).
	LocalCountryCodes []int64 `json:"localCountryCodes,omitempty"`

	// Nsr: This NSR value has range [0,1000] and is the original value
	// [0.0,1.0] multiplied by 1000 rounded to an integer.
	Nsr int64 `json:"nsr,omitempty"`

	Outdegree int64 `json:"outdegree,omitempty"`

	// Outsites: approx num of pointed-to sites
	Outsites int64 `json:"outsites,omitempty"`

	// PackedIpaddress: string in IPAddress::ToPackedString() format.
	PackedIpaddress string `json:"packedIpaddress,omitempty"`

	// PageTags: Page tags are described by enum PageTag in PerDocData. Page
	// tags are used in anchors to identify properties of the linking page.
	// These are DEPRECATED: in the future, use link_tags instead.
	// DEPRECATED
	PageTags []int64 `json:"pageTags,omitempty"`

	// Pagerank: uint16 scale
	Pagerank int64 `json:"pagerank,omitempty"`

	// PagerankNs: unit16 scale
	PagerankNs int64 `json:"pagerankNs,omitempty"`

	// Seglanguage: DEPRECATED
	Seglanguage int64 `json:"seglanguage,omitempty"`

	Site string `json:"site,omitempty"`

	// Spamrank: uint16 scale
	Spamrank int64 `json:"spamrank,omitempty"`

	// Spamscore1: deprecated, to be removed after October 20. 0-127 scale
	Spamscore1 int64 `json:"spamscore1,omitempty"`

	// Spamscore2: 0-127 scale
	Spamscore2 int64 `json:"spamscore2,omitempty"`

	// WebtableKey: Webtable key of source
	WebtableKey string `json:"webtableKey,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdditionalInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdditionalInfo") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AnchorsAnchorSource) MarshalJSON() ([]byte, error) {
	type NoMethod AnchorsAnchorSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AnchorsRedundantAnchorInfo: NOTE: in docjoins, the following anchor
// sampling information is only ## available in the first record of a
// document (under the same docid). The total number of redundant
// anchors dropped per (domain, text) in linkextractor. If we receive a
// large number of anchors from a particular domain, then we'll throw
// out all but a sampling of them from that domain. The data is sorted
// by the (domain,text) pairs. This field is not populated by
// Alexandria, which uses cdoc.anchor_stats instead.
type AnchorsRedundantAnchorInfo struct {
	AnchorsDropped int64 `json:"anchorsDropped,omitempty,string"`

	Domain string `json:"domain,omitempty"`

	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AnchorsDropped") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnchorsDropped") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AnchorsRedundantAnchorInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AnchorsRedundantAnchorInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteCustomerId: Represents a GSuite customer ID. Obfuscated
// with CustomerIdObfuscator.
type AppsDynamiteCustomerId struct {
	CustomerId string `json:"customerId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CustomerId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CustomerId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteCustomerId) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteCustomerId
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedOrganizationInfo: Contains info about the entity
// that something is, or is owned by.
type AppsDynamiteSharedOrganizationInfo struct {
	ConsumerInfo *AppsDynamiteSharedOrganizationInfoConsumerInfo `json:"consumerInfo,omitempty"`

	CustomerInfo *AppsDynamiteSharedOrganizationInfoCustomerInfo `json:"customerInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConsumerInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConsumerInfo") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedOrganizationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedOrganizationInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedOrganizationInfoConsumerInfo: Intentionally empty.
// Used to disambiguate consumer and customer use cases in oneof below.
type AppsDynamiteSharedOrganizationInfoConsumerInfo struct {
}

type AppsDynamiteSharedOrganizationInfoCustomerInfo struct {
	CustomerId *AppsDynamiteCustomerId `json:"customerId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CustomerId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CustomerId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedOrganizationInfoCustomerInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedOrganizationInfoCustomerInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsDynamiteSharedSegmentedMembershipCount: Contains info on
// membership count for member types: HUMAN_USER, APP_USER &
// ROSTER_MEMBER different states: INVITED, JOINED
type AppsDynamiteSharedSegmentedMembershipCount struct {
	// Possible values:
	//   "MEMBER_TYPE_UNSPECIFIED" - default value
	//   "HUMAN_USER" - member is a human user
	//   "ROSTER_MEMBER" - member is a roster
	MemberType string `json:"memberType,omitempty"`

	// MembershipCount: count of members with given type and state
	MembershipCount int64 `json:"membershipCount,omitempty"`

	// Possible values:
	//   "MEMBER_UNKNOWN" - Default state, do not use
	//   "MEMBER_INVITED" - An invitation to the space has been sent
	//   "MEMBER_JOINED" - User has joined the space
	//   "MEMBER_NOT_A_MEMBER" - User is not a member
	//   "MEMBER_FAILED" - This state should never be stored in Spanner. It
	// is a state for responses to the clients to indicate that membership
	// mutations have failed and the member is in its previous state.
	MembershipState string `json:"membershipState,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MemberType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MemberType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedSegmentedMembershipCount) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedSegmentedMembershipCount
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsDynamiteSharedSegmentedMembershipCounts struct {
	Value []*AppsDynamiteSharedSegmentedMembershipCount `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Value") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Value") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsDynamiteSharedSegmentedMembershipCounts) MarshalJSON() ([]byte, error) {
	type NoMethod AppsDynamiteSharedSegmentedMembershipCounts
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleActivityBackendDestinationStream: A DestinationStream is a
// /namespace/id[0]/id[1]/.../id[n] that represents a collection of
// Activities. Example destinations: -The Profile Stream on
// http://plus.google.com/+JohnDoe/posts -A Square Stream on
// http://plus.google.com/squares/123 -A "comment Stream" (Fountain) on
// http://www.youtube.com/watch?id=123 It's possible for a single
// Activity to show in each of these destinations - and it might
// behave/look slightly differently for each one. Destinations can have
// their own business logic associated with them at both write-time and
// read-time server-side (these are documented below). Each
// DestinationStream is indexed and can be retrieved using the
// GetDestinationStreamRequest. For the repeated ID space indexing
// happens at all levels, e.g. if you have: /square/123/abc
// /square/123/efd /square/456 You can fetch /square/123/abc directly or
// /square/123 (which includes all Activities in both /square/123/abc
// and /square/123/efd), or even /square which retrieves all Activities
// in the Square namespace (visible for that user). On the storage
// layer, we represent DestinationStream as Channel
// (http://cs/#google3/social/common/channel/channel.proto), since the
// storage does not have the concept of a Stream. Both terms are used
// interchangeably within the service layer, but client of Social
// Infrastructure should use the term DestinationStream. Next ID: 3
type AppsPeopleActivityBackendDestinationStream struct {
	// Id: The hierarchy of IDs. Each individual ID is "flat" and the
	// repeated list defines the hierarchy. Namespaces define the "validity"
	// of this hierachy (depth, naming convention, etc) and the server will
	// reject invalid IDs.
	Id []string `json:"id,omitempty"`

	// Possible values:
	//   "UNKNOWN_DESTINATION_NAMESPACE" - To prevent issues with
	// out-of-sync clients sending unexpected values.
	//   "SQUARES" - Use for G+ community. The ID is the square gaia id. If
	// this is a square substream, second ID is the substream stream ID.
	// Write-time logic: -Verify that the AUTHOR is a member of this Square.
	// Read-time logic: -Fetch the name of the Square and substream.
	//   "FOUNTAIN" - For Blogger Fountain, the ID is the canonical URL of
	// the site. For Distiller, the ID is "youtube"/channel_id/video_id. For
	// Distiller Discussion Page, the ID is "youtube"/channel_id/"channel".
	// For Distiller Private Msg, the ID is "youtube"/channel_id/"private".
	// For Backstage, the ID is "youtube"/channel_id/"backstage". For Live,
	// the ID is "youtube"/channel_id/"live"/"chat" and
	// "youtube"/channel_id/video_id/"live"/"chat".
	//   "PROFILE" - Used for Profile Stream fetches. The ID is the
	// (decimal) Gaia ID of the user whose profile is being fetched.
	//   "COLLEXIONS" - Used for Collexions feature (go/g+c) ID is the
	// Collexion ID to which the post is assigned. These IDs are allocated
	// from their own id space maintained via UniqueId. They are NOT gaia
	// ids, nor do they need to be used in conjunction with a gaia id when
	// identifying a collection. In general a post will be assigned to at
	// most 1 collexion, however there do exist corner cases where
	// multi-inclusion can occur.
	//   "TEST" - Used for test data for clients to prototype with. This
	// should only ever be used in the SBE_PLAYGROUND corpus
	// (go/sbe-playground), or in tests.
	//   "HIGHLIGHT" - Used for Search Highlight (go/seng-highlight). The ID
	// is the account id to which a highlight belongs.
	//   "SOCIETY" - Used for Society (go/society) ID is an s2 cell id
	// (go/s2), optionally with an additional ID of a "topic" string within
	// that cell.
	//   "MEMEGEN" - Used for Memegen integration with SBE
	// (go/memegen-sbe-onboarding) The ID is "meme" followed by the meme id
	// to which a comment belongs.
	//   "PHOTOS" - Used for Photos integration with SBE
	// (go/envelope-comments-design-doc)
	//   "SUPPLY_CHAIN_CENTRAL" - Used for Supply Chain Central commenting
	// capability (go/scc-comment). ID format: - For purchase order app:
	// resource/purchase_order//line_item/ - For data exchange app:
	// application/data_exchange/report/
	//   "PAISA" - Used for Paisa integration with SBE
	// (go/paisa-stanza-plan)
	//   "SOCIETY_CHAT" - Use for Society Chat (http://go/society-chat). The
	// ID format is /society/users/private/.
	//   "PLUS_ENTERPRISE_LOG" - Use for G+ Enterprise Log API Event API
	// (http://go/gplus_interaction_event_sync_queue) The ID format is
	// /enterprise//
	//   "SEARCH_UGC" - Used for UGC for knowledge (go/knowledge-ugc). The
	// ID format is /livestream/sports/
	//   "LOUPE" - Loupe go/sbe-loupe-requirements.
	//   "MINDSEARCH" - Mindsearch go/india-qa.
	//   "SOS_LIVE_COMMENTS" - Used for SOS Live comments
	// (go/live-comments-sos-alerts). The ID format is /livestream/sos/
	//   "SBE_LOADTEST" - Used for SBE loadtests.
	//   "SYSTEM1" - Used for System 1 (go/sys1-sbe)
	//   "G_PLUS" - Use if you want the Activity to show in the regular G+
	// product, i.e. the main Stream, user's profile streams, the G+ search
	// stream, etc. No ID should be used with this DestinationNamespace.
	//   "YOUTUBE" - Used to serve consumption stream on Youtube homepage.
	// The stream is essentially a user's consumption stream with restricts
	// set during write-time indexing such that only activities with Youtube
	// video are retrieved during read-time. Deprecated - Do not use.
	//   "EVENTS" - DEPRECATED - once used for the G+ Events feature, but
	// never launched.
	//   "DEPRECATED_COLLECTIONS" - It is deprecated and replaced by
	// COLLEXIONS.
	//   "REVIEWS" - Used for Review Stream fetches. The ID is the canonical
	// representation of the entity being reviewed (for place reviews, it is
	// cluster_id).
	//   "BACKSTAGE" - Deprecated - do not use. Backstage uses FOUNTAIN
	// DestinationNamespace.
	//   "SPACES" - Deprecated. Used for Spaces (go/spaces) ID is the space
	// ID in which the post is made. Posts will reside in exactly one space.
	Namespace string `json:"namespace,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleActivityBackendDestinationStream) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleActivityBackendDestinationStream
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleActivityStreamqualityDistillerEngagements: Stores the
// number of different kind of user engagement actions. Abuse Report is
// also consider an engagement. Currently we only have abuse report
// engagements but in future we might add other types of engagements as
// well.
type AppsPeopleActivityStreamqualityDistillerEngagements struct {
	// ReportCompromised: Corresponds on "This account might be compromised
	// or hacked" reporting action.
	ReportCompromised int64 `json:"reportCompromised,omitempty,string"`

	// ReportHarassment: Corresponds on "Harassment or bullying" reporting
	// action.
	ReportHarassment int64 `json:"reportHarassment,omitempty,string"`

	// ReportHate: Corresponds on "Hate speach or graphic violence"
	// reporting action.
	ReportHate int64 `json:"reportHate,omitempty,string"`

	// ReportPorn: Corresponds on "Pornography or sexually explicit
	// material" reporting action.
	ReportPorn int64 `json:"reportPorn,omitempty,string"`

	// ReportSpam: Corresponds on "Unwanted commercial content or spam"
	// reporting action.
	ReportSpam int64 `json:"reportSpam,omitempty,string"`

	// ServeCount: Number of times this activity was served out of
	// asbe/stanza.
	ServeCount int64 `json:"serveCount,omitempty,string"`

	// TimeSec: Timestamp in seconds for which time this record is valid.
	TimeSec int64 `json:"timeSec,omitempty,string"`

	// YtThumbsDown: Corresponds on Distiller comment thumbs down action.
	YtThumbsDown int64 `json:"ytThumbsDown,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "ReportCompromised")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ReportCompromised") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleActivityStreamqualityDistillerEngagements) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleActivityStreamqualityDistillerEngagements
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiAbout struct {
	// Possible values:
	//   "TEXT_PLAIN"
	//   "TEXT_HTML"
	ContentType string `json:"contentType,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// SafeHtmlValue: Sanitized HTML value that is only populated when the
	// SANITIZE_ABOUT_HTML extension is requested.
	SafeHtmlValue *WebutilHtmlTypesSafeHtmlProto `json:"safeHtmlValue,omitempty"`

	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ContentType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContentType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiAbout) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiAbout
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedData: Extension
// data for use in AboutMe.
type AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedData struct {
	NameDisplayOptions *AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataNameDisplayOptions `json:"nameDisplayOptions,omitempty"`

	PhotosCompareData *AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataPhotosCompareData `json:"photosCompareData,omitempty"`

	ProfileEditability *AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataProfileEditability `json:"profileEditability,omitempty"`

	ProfileNameModificationHistory *AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataProfileNameModificationHistory `json:"profileNameModificationHistory,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NameDisplayOptions")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NameDisplayOptions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedData) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataNameDisplayOptio
// ns: See NameDisplayOptions in
// //depot/google3/focus/backend/proto/backend.proto. See also
// go/nickname-mess.
type AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataNameDisplayOptions struct {
	// Possible values:
	//   "UNKNOWN_NICKNAME_OPTION"
	//   "QUOTED_NICKNAME" - Include the nickname, in quotes, in the display
	// name. In English, the nickname appears between the given and family
	// names. Example: Victor "Pug" Henry.
	//   "PAREN_NICKNAME" - Include the nickname, in parentheses, in the
	// display name. In English, the nickname appears after the given and
	// family names. Example: Victor Henry (Pug).
	NicknameOption string `json:"nicknameOption,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NicknameOption") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NicknameOption") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataNameDisplayOptions) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataNameDisplayOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataPhotosCompareData struct {
	DiffData *AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataPhotosCompareDataDiffData `json:"diffData,omitempty"`

	HighResUrl string `json:"highResUrl,omitempty"`

	// InconsistentPhoto: True if photo diff is greater than 0.01 on any
	// color band, or if the user has a low res photo but no high res photo.
	// This field is primarily for use in About Me and for other uses it's
	// recommended to use the DiffData values directly instead. The cutoff
	// is based on a heuristic determined in go/comparing-profile-photos
	InconsistentPhoto bool `json:"inconsistentPhoto,omitempty"`

	// LowResData: Only present if the photo diff is greater than 0.01 on
	// any color band.
	LowResData string `json:"lowResData,omitempty"`

	LowResUrl string `json:"lowResUrl,omitempty"`

	MonogramUrl string `json:"monogramUrl,omitempty"`

	// PrivateLowResAcl: True if the low-res photo has a private ACL set.
	PrivateLowResAcl bool `json:"privateLowResAcl,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DiffData") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DiffData") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataPhotosCompareData) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataPhotosCompareData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataPhotosCompareDataDiffData struct {
	BlueDiff float64 `json:"blueDiff,omitempty"`

	GreenDiff float64 `json:"greenDiff,omitempty"`

	RedDiff float64 `json:"redDiff,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BlueDiff") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BlueDiff") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataPhotosCompareDataDiffData) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataPhotosCompareDataDiffData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataPhotosCompareDataDiffData) UnmarshalJSON(data []byte) error {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataPhotosCompareDataDiffData
	var s1 struct {
		BlueDiff  gensupport.JSONFloat64 `json:"blueDiff"`
		GreenDiff gensupport.JSONFloat64 `json:"greenDiff"`
		RedDiff   gensupport.JSONFloat64 `json:"redDiff"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.BlueDiff = float64(s1.BlueDiff)
	s.GreenDiff = float64(s1.GreenDiff)
	s.RedDiff = float64(s1.RedDiff)
	return nil
}

// AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataProfileEditabili
// ty: See UserEditedLockedMask in
// //depot/google3/focus/backend/proto/backend.proto.
type AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataProfileEditability struct {
	// LockedField: Read-only set of zero or more field paths that are
	// locked for update on this person, such as "person.name",
	// "person.email", etc. The set of fields is only populated for the
	// requester's profile. Fields in the set cannot be edited, added, or
	// deleted from the profile. Attempting to update any of these fields
	// will result in an exception.
	LockedField []string `json:"lockedField,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LockedField") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LockedField") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataProfileEditability) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataProfileEditability
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataProfileNameModif
// icationHistory: See ABUSE_NAME_LAST_MODIFIED in
// //depot/google3/focus/backend/proto/backend.proto which maps to
// //depot/google3/focus/proto/profileattribute.proto
type AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataProfileNameModificationHistory struct {
	// ComputedNameChangesRemaining: The number of name changes remaining at
	// RPC request time. This can be more than name_changes_remaining, if
	// user hasn't changed name for some time and accrued quota since last
	// change.
	ComputedNameChangesRemaining int64 `json:"computedNameChangesRemaining,omitempty"`

	// ComputedNicknameChangesRemaining: The number of nickname changes
	// remaining at RPC request time. This can be more than
	// nickname_changes_remaining, if user hasn't changed nickname for some
	// time and accrued quota since last change.
	ComputedNicknameChangesRemaining int64 `json:"computedNicknameChangesRemaining,omitempty"`

	// NameChangesRemaining: The number of name changes remaining at the
	// time the name was last modified.
	NameChangesRemaining int64 `json:"nameChangesRemaining,omitempty"`

	// NameLastModified: The last time the profile name was modified in
	// milliseconds UTC.
	NameLastModified int64 `json:"nameLastModified,omitempty,string"`

	// NicknameChangesRemaining: The number of nickname changes remaining at
	// the time the nickname was last modified.
	NicknameChangesRemaining int64 `json:"nicknameChangesRemaining,omitempty"`

	// NicknameLastModified: The last time the profile nickname was modified
	// in milliseconds UTC.
	NicknameLastModified int64 `json:"nicknameLastModified,omitempty,string"`

	// Possible values:
	//   "UNKNOWN_QUOTA_ENFORCEMENT_STATUS"
	//   "ENFORCED" - Name change quota is enforced.
	//   "NOT_ENFORCED" - Name change quota exists but is not enforced. This
	// is used for users suspended due to abusive names, where users are
	// allowed to change their names back to non-abusive state without being
	// charged against the quota.
	//   "NOT_APPLICABLE" - Name change quota does not apply. This is used
	// for premium dasher users.
	QuotaEnforcementStatus string `json:"quotaEnforcementStatus,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ComputedNameChangesRemaining") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "ComputedNameChangesRemaining") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataProfileNameModificationHistory) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataProfileNameModificationHistory
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiAccountEmail struct {
	Email string `json:"email,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Email") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiAccountEmail) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiAccountEmail
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiAdditionalContainerInfo:
// Additional information about a container. TO BE DELETED: replaced by
// DeviceContactInfo.
type AppsPeopleOzExternalMergedpeopleapiAdditionalContainerInfo struct {
	// RawDeviceContactInfo: When the container is a DEVICE_CONTACT, this
	// list provides account information from the raw contact which is the
	// source of this field.
	RawDeviceContactInfo []*AppsPeopleOzExternalMergedpeopleapiRawDeviceContactInfo `json:"rawDeviceContactInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "RawDeviceContactInfo") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RawDeviceContactInfo") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiAdditionalContainerInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiAdditionalContainerInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiAddress struct {
	Country string `json:"country,omitempty"`

	CountryCode string `json:"countryCode,omitempty"`

	// EncodedPlaceId: FeatureId associated with the address. The format is
	// the same as that used for ids in PLACE containers in SourceIdentity.
	EncodedPlaceId string `json:"encodedPlaceId,omitempty"`

	ExtendedAddress string `json:"extendedAddress,omitempty"`

	Formatted string `json:"formatted,omitempty"`

	// FormattedType: The `type` translated and formatted in the request
	// locale. See go/people-api-howto/localization for details on how to
	// usage.
	FormattedType string `json:"formattedType,omitempty"`

	Locality string `json:"locality,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	PoBox string `json:"poBox,omitempty"`

	PointSpec *AppsPeopleOzExternalMergedpeopleapiPointSpec `json:"pointSpec,omitempty"`

	PostalCode string `json:"postalCode,omitempty"`

	Region string `json:"region,omitempty"`

	StreetAddress string `json:"streetAddress,omitempty"`

	// Type: The type of the address. The type can be free form or one of
	// these predefined values: * `home` * `work` * `other`
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Country") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Country") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiAddress) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiAddress
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiAffinity: Similar to
// social.graph.storage.Affinity, but pared down to what the clients of
// the People API are interested in.
type AppsPeopleOzExternalMergedpeopleapiAffinity struct {
	// AffinityMetadata: Contains extra ranking information returned by DAS.
	AffinityMetadata *SocialGraphWireProtoPeopleapiAffinityMetadata `json:"affinityMetadata,omitempty"`

	// Possible values:
	//   "AFFINITY_TYPE_UNKNOWN"
	//   "EMAIL_AUTOCOMPLETE"
	//   "CONTACTS_PLUS_FREQUENTLY_CONTACTED"
	//   "CHAT_AUTOCOMPLETE"
	//   "GPLUS_AUTOCOMPLETE"
	//   "GLASS_AFFINITY"
	//   "PEOPLE_AUTOCOMPLETE_SOCIAL"
	//   "FIELD_AUTOCOMPLETE_SOCIAL"
	//   "CONTACTS_PLUS_EMAIL"
	//   "PHOTOS_PEOPLE_TO_SHARE_WITH_SUGGESTIONS" - Will eventually be
	// deprecated in favor of PHOTOS_SUGGESTED_TARGETS.
	//   "PHOTOS_FIELDS_TO_SHARE_WITH_SUGGESTIONS" - Will eventually be
	// deprecated in favor of PHOTOS_SUGGESTED_TARGETS.
	//   "INBOX_AFFINITY"
	//   "DYNAMITE_AFFINITY"
	//   "PHOTOS_SUGGESTIONS_AFFINITY" - Will eventually be deprecated in
	// favour of PHOTOS_SUGGESTED_TARGETS.
	//   "PHOTOS_SUGGESTED_TARGETS"
	//   "PHOTOS_ASSISTANT_SUGGESTIONS_AFFINITY"
	//   "DRIVE_AUTOCOMPLETE"
	//   "WALLET_PEOPLE_TO_PAY_SUGGESTIONS"
	//   "CONTACTS_PLUS_CONTACT_CENTRIC"
	//   "POMEROY_AFFINITY"
	//   "CALENDAR_AFFINITY"
	//   "SPACES_APP_PEOPLE_AFFINITY"
	//   "HOMEROOM_AFFINITY"
	//   "PEOPLE_PLAYGROUND_AFFINITY"
	//   "FAMILY_AFFINITY"
	//   "CONTACTS_ASSISTANT_SUGGESTED_CONTACTS"
	//   "TRIPS_AFFINITY"
	//   "GOOGLE_VOICE_AFFINITY"
	//   "PHOTOS_FACE_AFFINITY"
	//   "G3DOC_AUTOCOMPLETE"
	//   "LOUPE_SUGGESTIONS_AFFINITY"
	//   "MAPS_SHARING_AFFINITY"
	//   "CLOUD_SEARCH_AFFINITY"
	//   "YOUTUBE_UNPLUGGED"
	//   "JAM_AFFINITY"
	//   "ITEM_SUGGEST_AFFINITY"
	//   "ISSUE_TRACKER_AFFINITY"
	//   "APPS_ASSISTANT_AFFINITY"
	//   "APDL_CONTACT_CENTRIC_DEFAULT_AFFINITY"
	//   "APDL_PROFILE_CENTRIC_DEFAULT_AFFINITY"
	//   "SOCIAL_RECOVERY"
	//   "TEZ_AFFINITY"
	//   "NEWS_AFFINITY"
	//   "ALLO_AFFINITY"
	//   "GPLUS_PEOPLE_RECOMMENDATIONS"
	//   "GPLUS_PEOPLE_RECOMMENDATIONS_SAME_DOMAIN"
	//   "DRIVE_AFFINITY"
	//   "PODIUM_AFFINITY"
	//   "ZOOM_SIGHTS_EMAIL_AFFINITY"
	//   "AIRDROME_AFFINITY"
	//   "HANGOUTS_MEET_AFFINITY"
	//   "GALLERY_AFFINITY"
	//   "AGSA_AFFINITY"
	//   "PAY_AFFINITY"
	//   "SAVES_AFFINITY"
	//   "JASPER_AFFINITY"
	//   "GOOGLE_HOME_APP_AFFINITY"
	//   "TOPAZ_TEAMS_AFFINITY"
	//   "DYNAMITE_OUT_OF_DOMAIN_AFFINITY"
	//   "GOOGLE_VOICE_SIRI_EXTENSION_AFFINITY"
	//   "COURSE_KIT_AFFINITY"
	//   "FORMS_AFFINITY"
	//   "NOVITAS_AFFINITY"
	//   "GTI_PEER_INTERACTIONS_AFFINITY"
	//   "ANDROID_EMERGENCY_AFFINITY"
	//   "DATA_STUDIO_AFFINITY"
	//   "SPUR_AFFINITY"
	//   "PLAY_GAMES_SERVICES_AFFINITY"
	//   "GROUPS_ADD_MEMBER_AFFINITY"
	//   "DUO_AFFINITY"
	//   "MY_BUSINESS_AFFINITY"
	//   "GMAIL_COMPOSE"
	//   "NON_GPLUS_AFFINITY"
	//   "ABUSE_AFFINITY"
	//   "ABUSE_AFFINITY_LITE"
	//   "CALENDAR_PEEK_AFFINITY"
	//   "HUB_CALL_AFFINITY"
	//   "GSUITE_WORKFLOW_AFFINITY"
	//   "VR_POLY_PRO_AFFINITY"
	//   "TASKS_AFFINITY"
	//   "GOOGLE_ONE_AFFINITY"
	//   "TRAVEL_AFFINITY"
	//   "GEO_DISCOVERY_FOLLOW_AFFINITY"
	//   "GMAIL_WEB_AFFINITY"
	//   "ASSISTANT_SETTINGS_WEB_UI_AFFINITY"
	//   "ARTIFEX_AFFINITY"
	//   "CONTACT_STORE_DEFAULT_AFFINITY"
	//   "CONTACT_STORE_SELF_EXCLUSIVE"
	//   "PHOTOS_FACE_STALE_AFFINITY"
	//   "LANDSPEEDER_AFFINITY"
	//   "GOOGLE_FI_AFFINITY"
	//   "CONTACTS_PLUS_DOMAIN_ONLY"
	//   "PHOTOS_SUGGESTED_TARGETS_IN_APP_ONLY"
	//   "SOCIETY_AFFINITY"
	//   "NANDHI_TEST_SCHEDULER_AFFINITY"
	//   "HIJACKING_HIGH_RISK_AFFINITY"
	//   "TRUECOLOURS_AFFINITY"
	//   "ESPRESSO_AFFINITY"
	//   "TAG_AFFINITY"
	//   "CORPBOT_AFFINITY"
	//   "SHOPPING_LIST_AFFINITY"
	//   "INTEGRATION_PLATFORM_AFFINITY"
	//   "HOT_ORDERS_UI_AFFINITY"
	//   "TELLY_MOBILE_APP_AFFINITY"
	//   "NGA_SUGGESTION_RESOLUTION_AFFINITY"
	//   "DUC_COMPANION_AFFINITY"
	//   "TOG_AFFINITY"
	//   "ANDROID_SYSTEM_INTELLIGENCE_AFFINITY"
	//   "EARTH_AFFINITY"
	//   "SHORTCUT_AFFINITY"
	//   "CHROME_OS_SCALING_AFFINITY"
	//   "SHOWTIME_AFFINITY"
	//   "PLAY_GAMES_SERVICES_EXPERIMENTAL"
	//   "GUPPEEPS_AFFINITY"
	//   "NEST_AFFINITY"
	//   "BLOGGER_AFFINITY"
	//   "INDIVIDUAL_OUTGOING_INTERACTIONS_RECENCY_RANK"
	//   "ASSISTANT_TOOLCHAIN_AFFINITY"
	//   "CHAT_CONSERVER_FAVORITE_CONTACTS_AFFINITY"
	//   "CHAT_CONSERVER_INVITEE_AFFINITY"
	//   "GANTRY_AFFINITY"
	//   "KINTARO_AFFINITY"
	//   "KEEP_AFFINITY"
	//   "INCIDENTFLOW_AFFINITY"
	//   "DRIVE_MENTION_AFFINITY"
	//   "DRIVE_LOOKUP_AFFINITY"
	//   "PODCASTS_MANAGER_AFFINITY"
	//   "EMAIL_AUTOCOMPLETE_GG"
	//   "ONE_REVIEWER_TOOL_AFFINITY"
	//   "ASSISTANT_FAMILY_VERTICAL_AFFINITY"
	//   "STADIA_AFFINITY"
	//   "ATLAS_AFFINITY"
	//   "CONSTELLATION_AFFINITY"
	//   "CORONADO_AFFINITY"
	//   "WALLET_GOLDEN_GATE_AFFINITY"
	//   "PUMICE_AFFINITY"
	//   "DEMO_AFFINITY_DEFAULT_ALGO"
	//   "DEMO_AFFINITY_DEFAULT_ALGO_DOMAIN_ONLY"
	//   "DEMO_AFFINITY_EMAIL_ALGO"
	//   "DEMO_AFFINITY_EMAIL_ALGO_DOMAIN_ONLY"
	//   "BACKLIGHT_AFFINITY"
	//   "DYNAMITE_GROUPS_AFFINITY"
	//   "DYNAMITE_OUT_OF_DOMAIN_GROUPS_AFFINITY"
	//   "GLOSSARY_MANAGER_AFFINITY"
	//   "ONEDEV_WORKFLOW_AFFINITY"
	//   "GSUITE_HUB_CALL_AFFINITY"
	//   "AVALANCHE_AFFINITY"
	//   "SANDTROUT_DEVICE_CONTACTS_AFFINITY"
	//   "DYNAMITE_ROOM_AFFINITY"
	//   "DESKBOOKING_AFFINITY"
	//   "TEZ_EXTENDED_AFFINITY"
	//   "DRIVE_PROFILE_ONLY_AFFINITY"
	//   "OFFSEC_AFFINITY"
	//   "GOOGLE_HOME_FAMILY_AFFINITY"
	//   "ONEMARKET_CALENDAR_AFFINITY"
	//   "GPAY_MERCHANT_CONSOLE_AFFINITY"
	//   "WORDFLOW_AFFINITY"
	//   "YOUTUBE_CREATOR_STUDIO_AFFINITY"
	//   "BRICKS_AFFINITY"
	//   "BUG_OBSERVER_AFFINITY"
	//   "ALPHASCHEDULE_AFFINITY"
	//   "BURROW_AFFINITY"
	//   "TEAMSPACES_AFFINITY"
	//   "GMAIL_SMARTADDRESS_REPLACE_AFFINITY"
	//   "GMAIL_SMARTADDRESS_EXPAND_AFFINITY"
	//   "ASSISTANT_OPA_AFFINITY"
	//   "POLYGLOT_AFFINITY"
	//   "TRANSLATION_MEMORY_MANAGER_AFFINITY"
	//   "THREADIT_AFFINITY"
	//   "RESOURCE_SYMPHONY_AFFINITY"
	//   "HOUSEHOLD_CONTACTS_PICKER_AFFINITY"
	//   "L10N_INFRA_SHARED_AFFINITY"
	//   "WORK_TRACKER_AFFINITY"
	//   "ARIANE_AFFINITY"
	//   "DRIVE_ROOM_AFFINITY"
	//   "MOMA_SEARCH_AFFINITY"
	//   "COLAB_INTERNAL_AFFINITY"
	//   "COLAB_EXTERNAL_AFFINITY"
	//   "TALENT_GROW_AFFINITY"
	//   "SOCIAL_CONNECTION_CHECKER_AFFINITY"
	//   "GMS_PEOPLE_AFFINITY"
	//   "ROCKET_LABS_AFFINITY"
	//   "DYNAMITE_ROOM_AND_INDIVIDUAL_ONLY_AFFINITY"
	//   "TEZ_PHONE_SEARCH_AFFINITY"
	//   "MY_GOOGLE_FAMILIES_AFFINITY"
	//   "DYNAMITE_UNIFIED_AFFINITY"
	//   "SHORTCUT_SERVER_AFFINITY"
	//   "LEGAL_CONTRACTS_AFFINITY"
	//   "CALENDAR_WEB_AFFINITY"
	//   "DATA_CATALOG_AFFINITY"
	//   "BRIEF_API_AFFINITY"
	//   "HARDWARE_MFG_DATA_VENUS_AFFINITY"
	//   "BETTERBUG_AFFINITY"
	//   "DCMS_AFFINITY"
	//   "PLAY_BOOKS_PUBENG_AFFINITY"
	//   "YAQS_AFFINITY"
	//   "RESPONSIBLE_FEATURE_ACCESS_AFFINITY"
	//   "PROSPER_AFFINITY"
	//   "PEOPLE_TO_ADD_BIRTHDAY_FOR_AFFINITY"
	//   "FLOURISH_AFFINITY"
	//   "CAMPAIGN_MANAGEMENT_TOOL_AFFINITY"
	//   "RECORDER_AFFINITY"
	//   "CLASSROOM_SEARCH_AFFINITY"
	//   "HIRING_AFFINITY"
	//   "DATACENTER_SOFTWARE_AFFINITY"
	//   "PHOTOS_INVITE_AFFINITY"
	//   "PHOTOS_PARTNER_SHARING_AFFINITY"
	//   "MARKETING_WORKFLOWS_AFFINITY"
	//   "INTROSPECT_AFFINITY"
	//   "YOUTUBE_PARENT_TOOLS_AFFINITY"
	//   "RELIABILITY_INSIGHTS_PST_AFFINITY"
	//   "GMAIL_ANDROID_AFFINITY"
	//   "CUSTOMER_CARE_PORTAL_AFFINITY"
	//   "MOMAHOME_3C_AFFINITY"
	//   "DIGITAL_CAR_KEY_AFFINITY"
	//   "PLAY_BOOKS_DISTRIBUTION_AFFINITY"
	//   "GOOGLE_ASSIGNMENTS_AFFINITY"
	//   "TEST_FUSION_AFFINITY"
	//   "PRODUCTION2020_UIE_AFFINITY"
	//   "SPEAKEASY_AFFINITY"
	//   "DOCS_TASKS_AFFINITY"
	//   "DYNAMITE_SEARCH_AFFINITY"
	//   "GPAY_RELEASE_OPS_AFFINITY"
	//   "VOICE_PBX_AFFINITY"
	//   "VOICE_WEB_AFFINITY"
	//   "SKILLSSTACK_AFFINITY"
	//   "WHOSTORY_AFFINITY"
	//   "PHOTOS_PARTNER_SHARING_EMAIL_ONLY"
	//   "MEMORIZE_AFFINITY"
	//   "BETTANY_AFFINITY"
	//   "BASECAMP_AFFINITY"
	//   "DRIVE_SEARCH_FILTER_AFFINITY"
	//   "CULTURE_EVENTS_CALENDAR_AFFINITY"
	//   "DATABRIDGE_CONSOLE_AFFINITY"
	//   "COMMSTAR_AFFINITY"
	//   "CDDB_AFFINITY"
	//   "DATA_STUDIO_SPACES_AFFINITY"
	//   "SOJI_AFFINITY"
	//   "PLAY_MOVIES_ANDROID_AFFINITY"
	//   "DATA_STUDIO_DOMAIN_ONLY_AFFINITY"
	//   "MONOSPACE_AFFINITY"
	//   "MY_ACCOUNT_AFFINITY"
	//   "NUDGEIT_CAMPAIGN_MANAGER_AFFINITY"
	//   "LEGAL_CONTRACTS_EXTERNAL_AFFINITY"
	//   "CONTACTS_TO_STAR_AFFINITY"
	//   "DECS_AFFINITY"
	//   "GSOX_MOCHI_AFFINITY"
	//   "MEET_AFFINITY"
	//   "PMW_TI_AFFINITY"
	//   "DRIVE_SEARCH_FILTER_PERSON_ONLY"
	//   "ACCESSIBILITY_TRACKER_AFFINITY"
	//   "PLX_DATASOURCE_AFFINITY"
	//   "DUCKIEWEB_AFFINITY"
	//   "MEET_CALLING_AFFINITY"
	//   "MATTERSPACE_AFFINITY"
	//   "TRUSTED_CONTACTS_OOBE_AFFINITY"
	//   "REFERRALS_AFFINITY"
	//   "WAYMO_TRIAGE_TOOLING_AFFINITY"
	//   "DATA_STUDIO_GAIA_ONLY_AFFINITY"
	//   "TWENTYPERCENT_JOBPOSTINGS_AFFINITY"
	//   "ENGAGEMENTS_AFFINITY"
	//   "TRUSTED_CONTACTS_FL_AFFINITY"
	//   "CALENDAR_WEB_TEAM_MEMBERS_AFFINITY"
	//   "CLOUDCONNECT_AFFINITY"
	//   "PERSONAL_AGENT_AFFINITY"
	//   "MOBILE_HARNESS_AFFINITY"
	//   "LOOKER_STUDIO_PRO_AFFINITY"
	//   "SUPPORT_CLASSIFICATION_UI_AFFINITY"
	//   "NOTEBOOKLM_AFFINITY"
	//   "PLAYSPACE_LABS_AFFINITY"
	//   "ZOMBIE_CLOUD_AFFINITY"
	//   "RELATIONSHIPS_AFFINITY"
	//   "APPS_WORKFLOW_AFFINITY"
	AffinityType string `json:"affinityType,omitempty"`

	// ContainerId: The ID of the container
	ContainerId string `json:"containerId,omitempty"`

	// ContainerType: The type of container to which this affinity applies
	//
	// Possible values:
	//   "UNKNOWN_CONTAINER"
	//   "PROFILE" - Google Profile. PROFILE fields are editable by the
	// profile owner, unless the field metadata includes writeable=false.
	//   "CONTACT" - Google Contact
	//   "CIRCLE" - Deprecated. E-mail only circle membership should be
	// dead. E-mail only circle membership of non-g+ user.
	//   "PLACE" - A maps place
	//   "ACCOUNT" - The requester's own Gaia account. ACCOUNT fields are
	// not editable by anyone. They only occur when the requester is "me".
	// In the event an ACCOUNT field is ACLed non-private, it will be
	// returned as a PROFILE field when viewed by a requester who is not
	// "me".
	//   "EXTERNAL_ACCOUNT" - LinkedExternalSites
	// (go/PeopleApiConnectedSites)
	//   "DOMAIN_PROFILE" - Google-For-Work Profile. DOMAIN_PROFILE fields
	// are editable by the Dasher administrator of the domain. They are not
	// editable by the profile owner.
	//   "DOMAIN_CONTACT" - Domain shared contact. An entity that is owned
	// by a domain and represents a person, but is not a user in the domain.
	// For more details see https://support.google.com/a/answer/9281635.
	//   "DEVICE_CONTACT" - To be deprecated in favor of RAW_DEVICE_CONTACT
	// See go/mergedperson-for-device-contacts Aggregation is represented
	// using person.metadata.device_contact_info
	//   "GOOGLE_GROUP" - Google group. Examples: sales@zara.es.
	//   "NAMED_CHAT_ROOM" - Dynamite "Named Flat Room" (NFR). This is a
	// Baggins Roster with label DYNAMITE_SPACE *and* label
	// DYNAMITE_NAMED_SPACE. See go/people-api-concepts#chat-rooms
	//   "UNNAMED_CHAT_ROOM" - Dynamite "Unnamed Flat Room" (UFR). This is a
	// Baggins Roster with label DYNAMITE_SPACE but does *not* have label
	// DYNAMITE_NAMED_SPACE. See go/people-api-concepts#chat-rooms
	//   "AFFINITY" - Device contacts that are used in interaction ranking,
	// but have not been uploaded to Google. These are synthesized people
	// from interaction data. This container type is only used in
	// ListRankedPeople and ListRankedTargets actions. See
	// go/TopNWithClusteringPart1.
	//   "RAW_DEVICE_CONTACT" - Data from a raw (non-aggregated) device
	// contact. See go/mergedperson-for-device-contacts
	//   "CONTACT_ANNOTATION" - Data from contact annotation. Contact
	// annotations are currently generated and used by Google Assistant.
	//   "DELEGATED_CONTACT" - Data from delegated contacts. Delegated
	// contacts are the contacts delegated to the current requester. The
	// requester can then access those contacts. See go/ph-delegation.
	ContainerType string `json:"containerType,omitempty"`

	// LoggingId: Used to log events for this affinity value, for disco
	// diagnostic-purposes. See go/disco-diagnostics.
	LoggingId string `json:"loggingId,omitempty"`

	// Value: Affinity value. Frequently represented as an inverse ranking,
	// sometimes with additional data encoded. If
	// data_formats.affinity_formats.score_format is set to RAW_SCORE then
	// the value will be the score returned by DAS.
	Value float64 `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AffinityMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AffinityMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiAffinity) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiAffinity
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *AppsPeopleOzExternalMergedpeopleapiAffinity) UnmarshalJSON(data []byte) error {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiAffinity
	var s1 struct {
		Value gensupport.JSONFloat64 `json:"value"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Value = float64(s1.Value)
	return nil
}

// AppsPeopleOzExternalMergedpeopleapiAgeRangeType: Please read
// go/people-api-howto:age on how to get age data. Message for the
// `Person.age_range_repeated` field. Replaces the existing
// `Person.age_range` field.
type AppsPeopleOzExternalMergedpeopleapiAgeRangeType struct {
	// AgeInYears: Please read go/people-api-howto:age on how to get age
	// data. Age of the user. The field is set based on profile storage
	// fields such as account birthday. If the source fields are not
	// present, `age_in_years` will be left unset.
	AgeInYears int64 `json:"ageInYears,omitempty"`

	// AgeOfConsentStatus: Deprecated. Use
	// go/supervised-accounts#capabilities-for-child-accounts instead.
	// Denotes whether the user is under the region based Age of Consent.
	// The user's region is based on ClientUserInfo.GlobalTos.AgreedLocation
	// The age is inferred from Birthday field or CertifiedBornBefore field.
	// The region based AoC is specified at go/aoc.
	//
	// Possible values:
	//   "AOC_STATUS_UNKNOWN" - We do not have enough information to
	// determine the user's age. e.g. user has no declared age or region is
	// not known.
	//   "UNDER_AOC" - The user is under the Age of Consent of the region
	// the user is in.
	//   "AT_OR_ABOVE_AOC" - The user is at or older than the Age of Consent
	// of the region the user is in.
	AgeOfConsentStatus string `json:"ageOfConsentStatus,omitempty"`

	// AgeRange: Deprecated. Please read go/people-api-howto:age on how to
	// get age data. Age range is populated based on `account_birthday` and
	// `certified_born_before`, which may not be set for dasher users.
	//
	// Possible values:
	//   "UNKNOWN"
	//   "LESS_THAN_EIGHTEEN"
	//   "TWENTY_ONE_OR_OLDER"
	//   "EIGHTEEN_TO_TWENTY"
	AgeRange string `json:"ageRange,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AgeInYears") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AgeInYears") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiAgeRangeType) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiAgeRangeType
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiAppUniqueInfo: Store all app
// unique info that are needed for app action fulfillment.
type AppsPeopleOzExternalMergedpeopleapiAppUniqueInfo struct {
	// AppUniqueId: Store the app unique id endpoint. This will be passed
	// over to app to fulfill the action. For example, app_unique_id for
	// Whatsapp will be "11234567890@s.whatsapp.net"
	AppUniqueId string `json:"appUniqueId,omitempty"`

	// ContactInfoSource: Where this contact info was retrieved from. Note:
	// only added for Assistant usage, and will not be populated by PAPI.
	// This is due to the coupling between Assistant Proto, and PAPI proto.
	// (//depot/google3/quality/qrewrite/servlets/proto/focus_name.proto)
	//
	// Possible values:
	//   "SOURCE_UNKNOWN"
	//   "APP_SEARCH" - The contact info came from AppSearch.
	ContactInfoSource string `json:"contactInfoSource,omitempty"`

	// DisplayAppUniqueId: Store third party endpoint that is displayed to
	// users. For example, display_app_unique_id for Whatsapp will be
	// "Message +11234567890".
	DisplayAppUniqueId string `json:"displayAppUniqueId,omitempty"`

	// Label: Store third party endpoint label. For example, "HOME", "WORK"
	Label string `json:"label,omitempty"`

	// Mimetype: Store mimetype of this endpoint. We will use this as the
	// differentiator for Assistant to know whether to use the RawContact
	// for messaging, call or video call. For example, send message mimetype
	// for whatsapp: "vnd.android.cursor.item/vnd.com.whatsapp.profile"
	// voice call mimetype for whatsapp:
	// "vnd.android.cursor.item/vnd.com.whatsapp.voip.call"
	Mimetype string `json:"mimetype,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AppUniqueId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AppUniqueId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiAppUniqueInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiAppUniqueInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiBestDisplayName: The best
// suggested name to use for the Person from the available source
// fields, which may include FileAs, Name, Org, Email, IM, Phone, ...
// Rough source container priority order is Contact, then Profile, then
// Place.
type AppsPeopleOzExternalMergedpeopleapiBestDisplayName struct {
	// ContainerType: The container the suggested name was sourced from
	//
	// Possible values:
	//   "UNKNOWN_CONTAINER"
	//   "PROFILE" - Google Profile. PROFILE fields are editable by the
	// profile owner, unless the field metadata includes writeable=false.
	//   "CONTACT" - Google Contact
	//   "CIRCLE" - Deprecated. E-mail only circle membership should be
	// dead. E-mail only circle membership of non-g+ user.
	//   "PLACE" - A maps place
	//   "ACCOUNT" - The requester's own Gaia account. ACCOUNT fields are
	// not editable by anyone. They only occur when the requester is "me".
	// In the event an ACCOUNT field is ACLed non-private, it will be
	// returned as a PROFILE field when viewed by a requester who is not
	// "me".
	//   "EXTERNAL_ACCOUNT" - LinkedExternalSites
	// (go/PeopleApiConnectedSites)
	//   "DOMAIN_PROFILE" - Google-For-Work Profile. DOMAIN_PROFILE fields
	// are editable by the Dasher administrator of the domain. They are not
	// editable by the profile owner.
	//   "DOMAIN_CONTACT" - Domain shared contact. An entity that is owned
	// by a domain and represents a person, but is not a user in the domain.
	// For more details see https://support.google.com/a/answer/9281635.
	//   "DEVICE_CONTACT" - To be deprecated in favor of RAW_DEVICE_CONTACT
	// See go/mergedperson-for-device-contacts Aggregation is represented
	// using person.metadata.device_contact_info
	//   "GOOGLE_GROUP" - Google group. Examples: sales@zara.es.
	//   "NAMED_CHAT_ROOM" - Dynamite "Named Flat Room" (NFR). This is a
	// Baggins Roster with label DYNAMITE_SPACE *and* label
	// DYNAMITE_NAMED_SPACE. See go/people-api-concepts#chat-rooms
	//   "UNNAMED_CHAT_ROOM" - Dynamite "Unnamed Flat Room" (UFR). This is a
	// Baggins Roster with label DYNAMITE_SPACE but does *not* have label
	// DYNAMITE_NAMED_SPACE. See go/people-api-concepts#chat-rooms
	//   "AFFINITY" - Device contacts that are used in interaction ranking,
	// but have not been uploaded to Google. These are synthesized people
	// from interaction data. This container type is only used in
	// ListRankedPeople and ListRankedTargets actions. See
	// go/TopNWithClusteringPart1.
	//   "RAW_DEVICE_CONTACT" - Data from a raw (non-aggregated) device
	// contact. See go/mergedperson-for-device-contacts
	//   "CONTACT_ANNOTATION" - Data from contact annotation. Contact
	// annotations are currently generated and used by Google Assistant.
	//   "DELEGATED_CONTACT" - Data from delegated contacts. Delegated
	// contacts are the contacts delegated to the current requester. The
	// requester can then access those contacts. See go/ph-delegation.
	ContainerType string `json:"containerType,omitempty"`

	// DisplayName: The display name. This name is intended to be the best
	// name to display for this Person. It may be built from a variety of
	// fields, even if those fields are not explicitly requested in the
	// request mask. Generally, the display name is formatted in 'first
	// last' format. If the name appears to be a CJK name (as determined by
	// a heuristic), the 'last first' format will be used. There may be
	// other cases that the 'last first' format is used which are not
	// documented here. See the code at:
	// http://google3/java/com/google/focus/backend/client/DisplayNameFormatter.java?l=659&rcl=351360938
	DisplayName string `json:"displayName,omitempty"`

	// DisplayNameLastFirst: The display name, always in 'last first'
	// format. This field does not depend on the format of `display_name`
	// and will always be in 'last first' format.
	DisplayNameLastFirst string `json:"displayNameLastFirst,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ContainerType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContainerType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiBestDisplayName) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiBestDisplayName
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiBirthday: IMPORTANT NOTES: -
// Requesting person.birthday requires membership in the purpose limited
// data ACL group sgbe-ac-d-birthday-(read|mutate). Contact
// people-api-eng@ for assistance with initial setup. - The birthday
// field should not be used to calculate the requester's age! To
// determine the requester's age, use person.age_range_repeated. - For
// more details about age see go/peopleapi-howto/age Birthday value may
// not be present: - Consumer users generally required to have account
// birthday set (required at account creation), though some users
// created via legacy flows may not have birthday present. - Dasher
// users generally don't require birthday, but could optionally have it
// set by users. - Any other types of accounts (e.g. robot, service) do
// not have birthdays. - Account Birthday field may be present but
// without birthday value set for grace period birthday (provisional new
// birthday). For users that do have birthday data: - "Profile Birthday"
// (person.birthday.metadata.container is PROFILE) may not have a year
// set if user "hides" the year. - "Account Birthday" (see api-specific
// notes below) will only be returned for the requester's own profile. -
// People API (go/peopleapi): * Account birthday is only supported in
// GetPeople for PeopleAPI. * If account birthday is needed, use a
// request mask with: `include_field { paths: "person.birthday" }`
// `include_container: ACCOUNT` - People API++ (go/peopleapi++): *
// Account birthday is supported for most apis in PeopleAPI++. * If
// account birthday is needed, use a request mask with: `include_field {
// paths: "person.account_birthday" }` `include_container: PROFILE`
// (note: it will also need `include_container: DOMAIN_PROFILE` because
// they must be requested together:
// go/people-api-masks#profile-domain_profile) - See
// go/papi-vs-papi++#birthday for more details.
type AppsPeopleOzExternalMergedpeopleapiBirthday struct {
	// AgeDisableGracePeriod: Only supported for
	// PROFILE/DOMAIN_PROFILE/ACCOUNT container.
	AgeDisableGracePeriod *AppsPeopleOzExternalMergedpeopleapiBirthdayAgeDisableGracePeriod `json:"ageDisableGracePeriod,omitempty"`

	// BirthdayDecoration: Whether the user has opted in to display their
	// birthday via photo decorations. Only supported for
	// PROFILE/DOMAIN_PROFILE container.
	BirthdayDecoration *SocialGraphApiProtoBirthdayDecoration `json:"birthdayDecoration,omitempty"`

	// BirthdayResolution: Only supported for PROFILE/DOMAIN_PROFILE/ACCOUNT
	// container.
	//
	// Possible values:
	//   "FULL" - Birthday includes year, month, and day.
	//   "MONTH_AND_APPROXIMATED_YEAR" - Birthday includes approximate year
	// and month.
	//   "APPROXIMATED_YEAR" - Birthday includes an approximate year.
	BirthdayResolution string `json:"birthdayResolution,omitempty"`

	// CalendarDay: Birthdays are more accurately represented as a calendar
	// day that does not depend on a timestamp representation at all. When
	// given a timestamp, there are lots of opportunities to make mistakes,
	// so a CalendarDay proto is replacing timestamps. Currently this is
	// always returned by PeopleApi on reads that include birthday fields.
	// New clients should write using calendar_day. Clients that were
	// already writing via date_ms are allowlisted such that writes use that
	// field. Old callers should migrate to writing BOTH date_ms and
	// calendar_day values. If those are consistent, they may be removed
	// from the 'legacy_timestamp_event_write_behavior_enabled' capability.
	CalendarDay *GoogleTypeDate `json:"calendarDay,omitempty"`

	// DateMs: Birthdays are currently represented as timestamp values,
	// although the interpretation of these timestamp values is a calendar
	// date. Clients are recommended to read the calendar_day field, which
	// is easier to work with than date_ms. New clients writing to PeopleApi
	// must set calendar_day instead of date_ms. There are a few important
	// details about how this value should be mapped to a calendar date that
	// should be consistent among all clients. 1. Epoch - The epoch or
	// calendar date equivalent to 0 ms is chosen to be 1970-01-01 UTC. 2.
	// Timezone - All of the conversions to calendars should occur in the
	// UTC timezone. We don't typically think of someones birthday changing
	// when they travel, so clients should not use local times. 3. Calendar
	// - The calendar used for the dates should be a Gregorian proleptic
	// calendar. Proleptic means that the rules of the Gregorian calendar
	// are retrofitted to before its adoption. It is easy to get this wrong,
	// particularly with the java GregorianCalendar class, which by default
	// is a mixed Gregorian/Julian calendar. Joda Time makes this easy, but
	// if it's not an option, look into
	// GregorianCalendar.setGregorianChange(). 4. Omitted years - Clients
	// have chosen to represent birthdays or events without years as
	// timestamps within the year zero. When the computed date has a year of
	// 0, it means the client did not specify a year. Note that a year 0
	// does not exist in a chronology like the familiar Anno Domini (A.D.
	// and B.C.); clients must agree on year numbering. 5. Year Numbering -
	// The chronology used to map dates to the calendar should use
	// Astronomical Year Numbering so that the year 0 is defined and dates
	// before it have a negative year. If libraries only provide Anno
	// Domini, then the year of 1 BC corresponds to year zero and an omitted
	// user provided year. Other BC values are presumed rare, but clients
	// should still not ignore the era and interpret the year as an A.D.
	// value, especially if writing values back to PeopleApi.
	DateMs int64 `json:"dateMs,omitempty,string"`

	// DateMsAsNumber: date_ms_as_number contains the same data as date_ms,
	// but has a different type in generated javascript bindings. Non
	// javascript clients can ignore it.
	DateMsAsNumber int64 `json:"dateMsAsNumber,omitempty,string"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// Prompt: People Prompts settings for contact birthday data. Only
	// supported for CONTACT container.
	Prompt *SocialGraphApiProtoPrompt `json:"prompt,omitempty"`

	// Value: Actual value entered. Allows unstructured values.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AgeDisableGracePeriod") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AgeDisableGracePeriod") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiBirthday) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiBirthday
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiBirthdayAgeDisableGracePeriod:
// Whether this field is set or not determines whether an account is in
// the grace period. While in the grace period, the user is unable to
// change their birthday on their own, and will be age-disabled if they
// don't act in a limited amount of time. Applies only to ServiceData
// Birthday. Users enter the grace period if they choose a birthday
// below the Age of Consent (go/aoc). After the grace period ends, the
// account will be age disabled. See go/age-disable-grace-period-dd.
type AppsPeopleOzExternalMergedpeopleapiBirthdayAgeDisableGracePeriod struct {
	// CalendarDay: Provisional birthday <AoC the user provided, which made
	// them enter the grace period. The main birthday fields were not
	// altered yet while in the grace period.
	CalendarDay *GoogleTypeDate `json:"calendarDay,omitempty"`

	// GracePeriodEnd: Timestamp which signifies the end of the grace period
	// for this account.
	GracePeriodEnd string `json:"gracePeriodEnd,omitempty"`

	// GracePeriodStart: Timestamp which signifies the start of the grace
	// period for this account.
	GracePeriodStart string `json:"gracePeriodStart,omitempty"`

	// Possible values:
	//   "UNKNOWN"
	//   "USER_SPECIFIED_BIRTHDAY" - When CalendarDay is populated by user
	// specified birthday.
	//   "UNDERAGE_SUSPECTED" - Account is marked as underage by other
	// means. The CalendarDay field is not populated.
	GracePeriodType string `json:"gracePeriodType,omitempty"`

	ManualGracePeriodInfo *AppsPeopleOzExternalMergedpeopleapiBirthdayAgeDisableGracePeriodManualGracePeriodInfo `json:"manualGracePeriodInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CalendarDay") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CalendarDay") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiBirthdayAgeDisableGracePeriod) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiBirthdayAgeDisableGracePeriod
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiBirthdayAgeDisableGracePeriodManual
// GracePeriodInfo: Information provided within MutateDataRequest when
// setting a user into AgeDisableGracePeriod manually. When the grace
// period expires, this info will be forwarded to Gaia when disabling
// the user. cs//symbol:InitiateAgeDisableGracePeriodArguments
type AppsPeopleOzExternalMergedpeopleapiBirthdayAgeDisableGracePeriodManualGracePeriodInfo struct {
	// EscalateTo: The Gaia ID of an email that ops can send inquiries to
	// for appeals.
	EscalateTo int64 `json:"escalateTo,omitempty,string"`

	// ExecutedBy: The Gaia ID of a Googler who initiated this disable.
	ExecutedBy int64 `json:"executedBy,omitempty,string"`

	// Reason: When setting a user into age grace period manually, the
	// requester can additionally supply a short human-readable reason of
	// why the account is put into manual grace period. The description will
	// be forwarded to Gaia when we disable the account when the grace
	// period expires.
	Reason string `json:"reason,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EscalateTo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EscalateTo") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiBirthdayAgeDisableGracePeriodManualGracePeriodInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiBirthdayAgeDisableGracePeriodManualGracePeriodInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiBraggingRights struct {
	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Metadata") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiBraggingRights) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiBraggingRights
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiCalendar: A url to the person's
// calendar. As of 03/2018 is not supported for user Profile.
type AppsPeopleOzExternalMergedpeopleapiCalendar struct {
	// FormattedType: The `type` translated and formatted in the request
	// locale. See go/people-api-howto/localization for details on how to
	// usage.
	FormattedType string `json:"formattedType,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// Type: The type of the calendar URL. The type can be free form or one
	// of these predefined values: * `home` * `freeBusy` * `work`
	Type string `json:"type,omitempty"`

	Url string `json:"url,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FormattedType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FormattedType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiCalendar) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiCalendar
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiCallerIdExtendedData struct {
	// CallerIdSource: Indicates which data source was used to populate the
	// caller ID result
	CallerIdSource *AppsPeopleOzExternalMergedpeopleapiCallerIdExtendedDataCallerIdSource `json:"callerIdSource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CallerIdSource") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CallerIdSource") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiCallerIdExtendedData) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiCallerIdExtendedData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiCallerIdExtendedDataCallerIdSource struct {
	// Possible values:
	//   "UNKNOWN_SOURCE_TYPE"
	//   "PLACE"
	//   "SCOOBY_MANUAL"
	//   "SCOOBY_GOOGLE_VOICE"
	//   "SCOOBY_CSA"
	//   "SCOOBY_KNOWLEDGE_GRAPH"
	SourceType string `json:"sourceType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SourceType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SourceType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiCallerIdExtendedDataCallerIdSource) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiCallerIdExtendedDataCallerIdSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiCertifiedBornBefore: Information
// related to domain administrator (or authority) certification of a
// users age.
type AppsPeopleOzExternalMergedpeopleapiCertifiedBornBefore struct {
	// BornBefore: Indicates that the user was born at or before this time.
	BornBefore string `json:"bornBefore,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BornBefore") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BornBefore") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiCertifiedBornBefore) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiCertifiedBornBefore
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiChannelData struct {
	// ChannelId: Unique ID that corresponds to a Youtube channel.
	ChannelId string `json:"channelId,omitempty"`

	// CommentCount: Number of comments for a given Youtube channel.
	CommentCount int64 `json:"commentCount,omitempty,string"`

	// Description: Description of the channel.
	Description string `json:"description,omitempty"`

	PlaylistCount int64 `json:"playlistCount,omitempty,string"`

	// ProfilePictureUrl: A FIFE URL pointing to the channel's profile image
	// (go/avatar-fife-urls) with default fife url options. Also refer to
	// go/people-api-concepts:photos for People API's FIFE best practices.
	// The image could be up to a couple of days stale, though it is much
	// fresher in practice. If a fresh image is required, contact the
	// YouTubeAccountProfileService. The URL itself expires ~30 days after
	// generation.
	ProfilePictureUrl string `json:"profilePictureUrl,omitempty"`

	// ProfileUrl: URL of user's Youtube channel profile.
	ProfileUrl string `json:"profileUrl,omitempty"`

	// SubscriberCount: Number of subscribers for a given Youtube channel.
	SubscriberCount int64 `json:"subscriberCount,omitempty,string"`

	// Title: Title of the YouTube channel
	Title string `json:"title,omitempty"`

	// UsesYoutubeNames: Whether or not the channel's profile has a
	// title/avatar that is canonical in YouTube. Used to determine if the
	// product profile card should be part of the core persona or have their
	// own persona.
	UsesYoutubeNames bool `json:"usesYoutubeNames,omitempty"`

	// VideoCount: Number of videos uploaded in a given Youtube channel.
	VideoCount int64 `json:"videoCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "ChannelId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ChannelId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiChannelData) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiChannelData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiCircleMembership: A circle
// membership that the person has. A circle membership is created by
// adding a person to a circle by person-id or by email.
type AppsPeopleOzExternalMergedpeopleapiCircleMembership struct {
	// CircleId: The circle that the person belongs to.
	CircleId string `json:"circleId,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CircleId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CircleId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiCircleMembership) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiCircleMembership
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiClientData: Arbitrary client data
// that is populated based on the client
type AppsPeopleOzExternalMergedpeopleapiClientData struct {
	Key string `json:"key,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	Namespace string `json:"namespace,omitempty"`

	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiClientData) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiClientData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiCommunicationEmail: Email for
// Google product communication with the user. This is only allowed in
// ServiceData. It is purely synthesized and read-only, and contains at
// most one field. It proxies from RawCommunicationEmail and only
// includes the primary field if exists. Otherwise if
// RawCommunicationEmail does not have primary, this includes a field
// synthesized from valid Gaia primary account email. Otherwise if Gaia
// primary account email is invalid, this field is empty. See
// go/comm-email-use for more details.
type AppsPeopleOzExternalMergedpeopleapiCommunicationEmail struct {
	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Metadata") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiCommunicationEmail) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiCommunicationEmail
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiConnectionReminder: Contact-level
// people-prompts settings and contact-level connection reminders. Part
// of go/people-prompts.
type AppsPeopleOzExternalMergedpeopleapiConnectionReminder struct {
	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// Prompt: Contact-level "reminder to connect" prompts for this contact.
	Prompt []*SocialGraphApiProtoPrompt `json:"prompt,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Metadata") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiConnectionReminder) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiConnectionReminder
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiContactCreateContextInfo: Contact
// creation timestamps and related metadata. See
// go/contact-edit-history. This message is a pure wrapper of the shared
// ContactCreactionContext message so that it can be a top-level person
// field. No other fields should be added to the message.
type AppsPeopleOzExternalMergedpeopleapiContactCreateContextInfo struct {
	ContactCreateContext *SocialGraphApiProtoContactCreateContext `json:"contactCreateContext,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ContactCreateContext") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContactCreateContext") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiContactCreateContextInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiContactCreateContextInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiContactEditContextInfo: Contact
// edit timestamps and related metadata. See go/contact-edit-history.
// This message is a pure wrapper of the shared ContactCreactionContext
// message so that it can be a top-level person field. No other fields
// should be added to the message.
type AppsPeopleOzExternalMergedpeopleapiContactEditContextInfo struct {
	ContactEditContext *SocialGraphApiProtoContactEditContext `json:"contactEditContext,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ContactEditContext")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContactEditContext") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiContactEditContextInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiContactEditContextInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiContactGroupMembership: A
// membership that the person has. The person can be a member of
// multiple circles and multiple contact-groups. A circle membership is
// created by adding a person to a circle by person-id or by email. A
// contact-group membership is created by adding a contact to a
// contact-group.
type AppsPeopleOzExternalMergedpeopleapiContactGroupMembership struct {
	// ContactGroupId: The contact-group that the person belong to. The id
	// can be either a hex-formatted id or a camel-cased SystemContactGroup
	// predefined group name. The id will be predefined group name iff the
	// system_contact_group_id has a value.
	ContactGroupId string `json:"contactGroupId,omitempty"`

	// DelegatedGroupInfo: Information related to delegated group that this
	// contact belongs to.
	DelegatedGroupInfo *AppsPeopleOzExternalMergedpeopleapiDelegatedGroupInfo `json:"delegatedGroupInfo,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// SystemContactGroupId: This field will be populated when the
	// membership is in a system-reserved contact-group.
	//
	// Possible values:
	//   "UNKNOWN"
	//   "MY_CONTACTS"
	//   "STARRED"
	//   "FRIENDS"
	//   "FAMILY"
	//   "COWORKERS"
	SystemContactGroupId string `json:"systemContactGroupId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ContactGroupId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContactGroupId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiContactGroupMembership) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiContactGroupMembership
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiContactPromptSettingsInfo: Contact
// level People Prompt settings. This message is a pure wrapper of the
// shared ContactPromptSettings message so that it can be a top-level
// person field. No other fields should be added to the message.
type AppsPeopleOzExternalMergedpeopleapiContactPromptSettingsInfo struct {
	ContactPromptSettings *SocialGraphApiProtoContactPromptSettings `json:"contactPromptSettings,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ContactPromptSettings") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContactPromptSettings") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiContactPromptSettingsInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiContactPromptSettingsInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiContactStateInfo: Contact state
// and related metadata. See go/fbs-contacts-trash. This message is a
// pure wrapper of the shared ContactState message so that it can be a
// top-level person field. No other fields should be added to the
// message.
type AppsPeopleOzExternalMergedpeopleapiContactStateInfo struct {
	ContactState *SocialGraphApiProtoContactState `json:"contactState,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ContactState") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContactState") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiContactStateInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiContactStateInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiCoverPhoto: CoverPhoto is the long
// banner photo (also called full bleed photo) at the top of G+ profile
// page.
type AppsPeopleOzExternalMergedpeopleapiCoverPhoto struct {
	ImageHeight int64 `json:"imageHeight,omitempty"`

	ImageId string `json:"imageId,omitempty"`

	ImageUrl string `json:"imageUrl,omitempty"`

	ImageWidth int64 `json:"imageWidth,omitempty"`

	IsAnimated bool `json:"isAnimated,omitempty"`

	IsDefault bool `json:"isDefault,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ImageHeight") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ImageHeight") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiCoverPhoto) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiCoverPhoto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiCustomSchemaField: Custom fields
// associated with a person, from the custom schema defined on the
// domain. See go/custompeopleapi and go/customfocus. NOTE: these are
// only updatable via Cloud Directory (go/cd).
type AppsPeopleOzExternalMergedpeopleapiCustomSchemaField struct {
	FieldDisplayName string `json:"fieldDisplayName,omitempty"`

	FieldId string `json:"fieldId,omitempty"`

	// Possible values:
	//   "CUSTOM_FIELD_TYPE_UNKNOWN"
	//   "STRING"
	//   "INT64"
	//   "BOOL"
	//   "DOUBLE"
	//   "EMAIL"
	//   "PHONE"
	//   "DATE"
	FieldType string `json:"fieldType,omitempty"`

	// FormattedType: The `type` translated and formatted in the request
	// locale. See go/people-api-howto/localization for details on how to
	// usage.
	FormattedType string `json:"formattedType,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	MultiValued bool `json:"multiValued,omitempty"`

	SchemaDisplayName string `json:"schemaDisplayName,omitempty"`

	SchemaId string `json:"schemaId,omitempty"`

	// Type: The type of the custom schema field. The type can be free form
	// or one of these predefined values: * `home` * `other` * `work`
	Type string `json:"type,omitempty"`

	// Value: String representation of the value, based on FieldType
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FieldDisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FieldDisplayName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiCustomSchemaField) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiCustomSchemaField
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiCustomerInfo: Contains customer
// data for profile owner proxied from D3.
type AppsPeopleOzExternalMergedpeopleapiCustomerInfo struct {
	// CustomerId: DEPRECATED. Use obfuscated_customer_id instead. If result
	// has a GSuite Customer ID, this field will continue to be populated
	// with -1 to indicate the presence of a value for backwards
	// compatibility with clients in the wild. See b/144596193.
	CustomerId int64 `json:"customerId,omitempty,string"`

	// CustomerName: Customer organization name for dasher user.
	CustomerName string `json:"customerName,omitempty"`

	// ObfuscatedCustomerId: Obfuscated FlexOrgs customer ID for Dasher
	// user. See cs/symbol:CustomerIdObfuscator.
	ObfuscatedCustomerId string `json:"obfuscatedCustomerId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CustomerId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CustomerId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiCustomerInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiCustomerInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiDedupedContainerInfo: Container
// information for deduping. When two fields have the same value and
// only differ by field.metadata a service implementation can choose to
// avoid duplicating the fields and instead set
// field.metadata.other_deduped_containers This type can include
// information on the dedupe type (for example, strict value match vs.
// lenient value match)
type AppsPeopleOzExternalMergedpeopleapiDedupedContainerInfo struct {
	// ContainerType: See SourceIdentity.container_type
	//
	// Possible values:
	//   "UNKNOWN_CONTAINER"
	//   "PROFILE" - Google Profile. PROFILE fields are editable by the
	// profile owner, unless the field metadata includes writeable=false.
	//   "CONTACT" - Google Contact
	//   "CIRCLE" - Deprecated. E-mail only circle membership should be
	// dead. E-mail only circle membership of non-g+ user.
	//   "PLACE" - A maps place
	//   "ACCOUNT" - The requester's own Gaia account. ACCOUNT fields are
	// not editable by anyone. They only occur when the requester is "me".
	// In the event an ACCOUNT field is ACLed non-private, it will be
	// returned as a PROFILE field when viewed by a requester who is not
	// "me".
	//   "EXTERNAL_ACCOUNT" - LinkedExternalSites
	// (go/PeopleApiConnectedSites)
	//   "DOMAIN_PROFILE" - Google-For-Work Profile. DOMAIN_PROFILE fields
	// are editable by the Dasher administrator of the domain. They are not
	// editable by the profile owner.
	//   "DOMAIN_CONTACT" - Domain shared contact. An entity that is owned
	// by a domain and represents a person, but is not a user in the domain.
	// For more details see https://support.google.com/a/answer/9281635.
	//   "DEVICE_CONTACT" - To be deprecated in favor of RAW_DEVICE_CONTACT
	// See go/mergedperson-for-device-contacts Aggregation is represented
	// using person.metadata.device_contact_info
	//   "GOOGLE_GROUP" - Google group. Examples: sales@zara.es.
	//   "NAMED_CHAT_ROOM" - Dynamite "Named Flat Room" (NFR). This is a
	// Baggins Roster with label DYNAMITE_SPACE *and* label
	// DYNAMITE_NAMED_SPACE. See go/people-api-concepts#chat-rooms
	//   "UNNAMED_CHAT_ROOM" - Dynamite "Unnamed Flat Room" (UFR). This is a
	// Baggins Roster with label DYNAMITE_SPACE but does *not* have label
	// DYNAMITE_NAMED_SPACE. See go/people-api-concepts#chat-rooms
	//   "AFFINITY" - Device contacts that are used in interaction ranking,
	// but have not been uploaded to Google. These are synthesized people
	// from interaction data. This container type is only used in
	// ListRankedPeople and ListRankedTargets actions. See
	// go/TopNWithClusteringPart1.
	//   "RAW_DEVICE_CONTACT" - Data from a raw (non-aggregated) device
	// contact. See go/mergedperson-for-device-contacts
	//   "CONTACT_ANNOTATION" - Data from contact annotation. Contact
	// annotations are currently generated and used by Google Assistant.
	//   "DELEGATED_CONTACT" - Data from delegated contacts. Delegated
	// contacts are the contacts delegated to the current requester. The
	// requester can then access those contacts. See go/ph-delegation.
	ContainerType string `json:"containerType,omitempty"`

	// Id: See SourceIdentity.id
	Id string `json:"id,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ContainerType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContainerType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiDedupedContainerInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiDedupedContainerInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiDelegatedGroupInfo: Information
// related to delegated group that this contact belongs to.
type AppsPeopleOzExternalMergedpeopleapiDelegatedGroupInfo struct {
	// DelegatedGroupId: Required. The additional id specifically for a
	// delegated group.
	DelegatedGroupId *SocialGraphApiProtoDelegatedGroupId `json:"delegatedGroupId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DelegatedGroupId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DelegatedGroupId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiDelegatedGroupInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiDelegatedGroupInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiDeviceContactExtraMetadata: Extra
// metadata for an aggregated or raw device contact.
type AppsPeopleOzExternalMergedpeopleapiDeviceContactExtraMetadata struct {
	// Attributes: Attributes for this device contact.
	//
	// Possible values:
	//   "ATTRIBUTE_UNKNOWN"
	//   "STARRED" - This contact is starred.
	Attributes []string `json:"attributes,omitempty"`

	// UsageInfo: Usage info for this device contact.
	UsageInfo []*SocialGraphApiProtoUsageInfo `json:"usageInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Attributes") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiDeviceContactExtraMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiDeviceContactExtraMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiDeviceContactId: Unique id for an
// aggregated device contact.
type AppsPeopleOzExternalMergedpeopleapiDeviceContactId struct {
	// ContactId: Aggregated device contact id on the source device.
	ContactId int64 `json:"contactId,omitempty,string"`

	// DeviceId: Source device id (go/client-instance-id) of this device
	// contact.
	DeviceId string `json:"deviceId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ContactId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContactId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiDeviceContactId) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiDeviceContactId
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiDeviceContactInfo: Device contact
// information.
type AppsPeopleOzExternalMergedpeopleapiDeviceContactInfo struct {
	// DeviceContactMetadata: Metadata for this device contact.
	DeviceContactMetadata *AppsPeopleOzExternalMergedpeopleapiDeviceContactExtraMetadata `json:"deviceContactMetadata,omitempty"`

	// HasCrossDeviceData: Output only. True if any of the contact's phone,
	// email or address fields can be used on devices other than the one it
	// originated from. Note that there can be other fields, typically name,
	// and metadata such as some of the raw_contact_infos that can be used
	// on other devices. Assigned by the server.
	HasCrossDeviceData bool `json:"hasCrossDeviceData,omitempty"`

	// Id: Id of the device contact.
	Id *AppsPeopleOzExternalMergedpeopleapiDeviceContactId `json:"id,omitempty"`

	// LastClientUpdateTime: Last time a device contact was updated on
	// device.
	LastClientUpdateTime string `json:"lastClientUpdateTime,omitempty"`

	// LookupKey: An opaque value used by the device to look up this contact
	// if its row id changed as a result of a sync or aggregation. See:
	// https://developer.android.com/reference/android/provider/ContactsContract.ContactsColumns.html#LOOKUP_KEY
	LookupKey string `json:"lookupKey,omitempty"`

	// RawContactInfo: Info about the raw device contacts that make up this
	// device contact.
	RawContactInfo []*AppsPeopleOzExternalMergedpeopleapiRawDeviceContactInfo `json:"rawContactInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "DeviceContactMetadata") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeviceContactMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiDeviceContactInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiDeviceContactInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiEdgeKeyInfo struct {
	// ContainerId: The container ID of the entity this field creates a join
	// to. See `SourceIdentity.id`.
	ContainerId string `json:"containerId,omitempty"`

	// ContainerType: The type of container that this edge points to. See
	// `SourceIdentity.container_type`.
	//
	// Possible values:
	//   "UNKNOWN_CONTAINER"
	//   "PROFILE" - Google Profile. PROFILE fields are editable by the
	// profile owner, unless the field metadata includes writeable=false.
	//   "CONTACT" - Google Contact
	//   "CIRCLE" - Deprecated. E-mail only circle membership should be
	// dead. E-mail only circle membership of non-g+ user.
	//   "PLACE" - A maps place
	//   "ACCOUNT" - The requester's own Gaia account. ACCOUNT fields are
	// not editable by anyone. They only occur when the requester is "me".
	// In the event an ACCOUNT field is ACLed non-private, it will be
	// returned as a PROFILE field when viewed by a requester who is not
	// "me".
	//   "EXTERNAL_ACCOUNT" - LinkedExternalSites
	// (go/PeopleApiConnectedSites)
	//   "DOMAIN_PROFILE" - Google-For-Work Profile. DOMAIN_PROFILE fields
	// are editable by the Dasher administrator of the domain. They are not
	// editable by the profile owner.
	//   "DOMAIN_CONTACT" - Domain shared contact. An entity that is owned
	// by a domain and represents a person, but is not a user in the domain.
	// For more details see https://support.google.com/a/answer/9281635.
	//   "DEVICE_CONTACT" - To be deprecated in favor of RAW_DEVICE_CONTACT
	// See go/mergedperson-for-device-contacts Aggregation is represented
	// using person.metadata.device_contact_info
	//   "GOOGLE_GROUP" - Google group. Examples: sales@zara.es.
	//   "NAMED_CHAT_ROOM" - Dynamite "Named Flat Room" (NFR). This is a
	// Baggins Roster with label DYNAMITE_SPACE *and* label
	// DYNAMITE_NAMED_SPACE. See go/people-api-concepts#chat-rooms
	//   "UNNAMED_CHAT_ROOM" - Dynamite "Unnamed Flat Room" (UFR). This is a
	// Baggins Roster with label DYNAMITE_SPACE but does *not* have label
	// DYNAMITE_NAMED_SPACE. See go/people-api-concepts#chat-rooms
	//   "AFFINITY" - Device contacts that are used in interaction ranking,
	// but have not been uploaded to Google. These are synthesized people
	// from interaction data. This container type is only used in
	// ListRankedPeople and ListRankedTargets actions. See
	// go/TopNWithClusteringPart1.
	//   "RAW_DEVICE_CONTACT" - Data from a raw (non-aggregated) device
	// contact. See go/mergedperson-for-device-contacts
	//   "CONTACT_ANNOTATION" - Data from contact annotation. Contact
	// annotations are currently generated and used by Google Assistant.
	//   "DELEGATED_CONTACT" - Data from delegated contacts. Delegated
	// contacts are the contacts delegated to the current requester. The
	// requester can then access those contacts. See go/ph-delegation.
	ContainerType string `json:"containerType,omitempty"`

	// ExtendedData: Data that is added to the proto by peopleapi read
	// extensions.
	ExtendedData *AppsPeopleOzExternalMergedpeopleapiEdgeKeyInfoExtensionData `json:"extendedData,omitempty"`

	// Materialized: True indicates this edge links this source to a
	// container represented by this person object. Note: Except for certain
	// legacy clients, EdgeKeyInfo is only created for for edges to an
	// entity in this person and this will always be true.
	Materialized bool `json:"materialized,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ContainerId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContainerId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiEdgeKeyInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiEdgeKeyInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiEdgeKeyInfoExtensionData struct {
	// GdataCompatibilityExtensionId: The GDataCompatibilityExtension will
	// (temporarily) return mobile_owner_id for profile containers.
	GdataCompatibilityExtensionId string `json:"gdataCompatibilityExtensionId,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "GdataCompatibilityExtensionId") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "GdataCompatibilityExtensionId") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiEdgeKeyInfoExtensionData) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiEdgeKeyInfoExtensionData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiEmail struct {
	Certificate []*AppsPeopleOzExternalMergedpeopleapiEmailCertificate `json:"certificate,omitempty"`

	// Possible values:
	//   "EMAIL_CLASSIFICATION_UNKNOWN"
	//   "SIGNUP_EMAIL" - This is the email user provided when signing up
	// with Google (ie. this email is stored in Gaia). There may be more
	// than 1 signup email. This is set for an Email of container type
	// PROFILE.
	Classification string `json:"classification,omitempty"`

	// ContactGroupPreference: To read or update, use the
	// CONTACT_GROUP_PREFERENCE mask field.
	ContactGroupPreference []*AppsPeopleOzExternalMergedpeopleapiEmailContactGroupPreference `json:"contactGroupPreference,omitempty"`

	DisplayName string `json:"displayName,omitempty"`

	ExtendedData *AppsPeopleOzExternalMergedpeopleapiEmailExtendedData `json:"extendedData,omitempty"`

	// FormattedType: The `type` translated and formatted in the request
	// locale. See go/people-api-howto/localization for details on how to
	// usage.
	FormattedType string `json:"formattedType,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	SignupEmailMetadata *AppsPeopleOzExternalMergedpeopleapiEmailSignupEmailMetadata `json:"signupEmailMetadata,omitempty"`

	// Type: The type of the email address. The type can be free form or one
	// of these predefined values: * `home` * `work` * `other`
	Type string `json:"type,omitempty"`

	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Certificate") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Certificate") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiEmail) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiEmail
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiEmailCertificate: Represents a
// S/MIME certificate config for use with Gmail. See
// //caribou/smime/proto/certificate_status.proto. There can be zero or
// more certificates associated with an email address, be it profile
// email or contact email.
type AppsPeopleOzExternalMergedpeopleapiEmailCertificate struct {
	// ConfigurationName: The name of this certificate configuration.
	// Examples could be "High security level" or "For domain emails only".
	ConfigurationName string `json:"configurationName,omitempty"`

	// Metadata: It is conceivable that certificates could be ACLed. We also
	// need to indicate which certificate is the default. The
	// PersonFieldMetadata can accomplish both of these.
	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	Status *AppsPeopleOzExternalMergedpeopleapiEmailCertificateCertificateStatus `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConfigurationName")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConfigurationName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiEmailCertificate) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiEmailCertificate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiEmailCertificateCertificateStatus:
// Minimal S/MIME certificate status i.e. two fields per email address.
type AppsPeopleOzExternalMergedpeopleapiEmailCertificateCertificateStatus struct {
	// NotAfterSec: The certificate expiration timestamp in seconds.
	NotAfterSec int64 `json:"notAfterSec,omitempty,string"`

	// StatusCode: Current status of the email's certificate chain.
	//
	// Possible values:
	//   "UNKNOWN"
	//   "CERTIFICATE_VALID"
	//   "CERTIFICATE_MISSING"
	//   "CERTIFICATE_EXPIRED"
	//   "CERTIFICATE_REVOKED"
	StatusCode string `json:"statusCode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NotAfterSec") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NotAfterSec") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiEmailCertificateCertificateStatus) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiEmailCertificateCertificateStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiEmailContactGroupPreference:
// Preferred email addresses for contact groups.
type AppsPeopleOzExternalMergedpeopleapiEmailContactGroupPreference struct {
	ContactGroupId string `json:"contactGroupId,omitempty"`

	// IsSynthetic: If the Preference was implicitly set by
	// PeopleApi/Contacts Service. A preference with this bit will not be
	// saved to storage. See go/contact-group-email-preference-papi-problem
	// for more info.
	IsSynthetic bool `json:"isSynthetic,omitempty"`

	// Possible values:
	//   "UNKNOWN"
	//   "GMAIL"
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ContactGroupId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContactGroupId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiEmailContactGroupPreference) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiEmailContactGroupPreference
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiEmailExtendedData: Extension data
// for a person email.
type AppsPeopleOzExternalMergedpeopleapiEmailExtendedData struct {
	// InternalExternal: For use with the CUSTOMER_INFO_ADDITIONAL_DATA
	// extension. This includes information on whether the given email is
	// internal to or external to the requesting user's domain.
	InternalExternal *PeoplestackFlexorgsProtoInternalExternal `json:"internalExternal,omitempty"`

	// IsPlaceholder: For ListPeoplebyKnownId to indicate an email is
	// sythesized from a lookup email.
	IsPlaceholder bool `json:"isPlaceholder,omitempty"`

	// SmtpServerSupportsTls: For use with the TLS extension. Whether the
	// SMTP server that handles delivery for this email address supports TLS
	// encryption.
	SmtpServerSupportsTls bool `json:"smtpServerSupportsTls,omitempty"`

	// UsesConfusingCharacters: For use with the Gmail Homograph Warning
	// extension. Whether the email contains mixed character sets that could
	// be used to decieve users. This field is populated by the
	// GMAIL_SECURITY_DATA extension.
	UsesConfusingCharacters bool `json:"usesConfusingCharacters,omitempty"`

	// ForceSendFields is a list of field names (e.g. "InternalExternal") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InternalExternal") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiEmailExtendedData) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiEmailExtendedData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiEmailSignupEmailMetadata:
// Additional metadata for a signup email. This will only be set if the
// email's classification is SIGNUP_EMAIL.
type AppsPeopleOzExternalMergedpeopleapiEmailSignupEmailMetadata struct {
	// Primary: This is considered to be the primary signup email. At most 1
	// signup email will have this set.
	Primary bool `json:"primary,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Primary") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Primary") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiEmailSignupEmailMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiEmailSignupEmailMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiEmergencyInfo: Emergency info for
// Person. See go/emergency-trusted-contacts-papi.
type AppsPeopleOzExternalMergedpeopleapiEmergencyInfo struct {
	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// PomeroyId: Opaque id from Pomeroy (go/pomeroy). Non-empty pomeroy_id
	// means that this contact has the potential to become trusted contact
	// or it's already trusted contact. Trust is eventually gaia<->gaia
	// link, but when the trust link is initiated gaia might not be known.
	// Until gaia is discovered, pomeroy_id is used to identify the contact
	// uniquely. If trust_level is missing or set to TRUST_LEVEL_UNSPECIFIED
	// pomeroy_id must be empty.
	PomeroyId string `json:"pomeroyId,omitempty"`

	// Possible values:
	//   "TRUST_LEVEL_UNSPECIFIED" - The person does not have a specified
	// trust level.
	//   "TRUST_LEVEL_EMERGENCY_CONTACT" - The person is an Emergency
	// Contact.
	TrustLevel string `json:"trustLevel,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Metadata") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiEmergencyInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiEmergencyInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiEvent struct {
	// CalendarDay: Event are more accurately represented as a calendar day
	// that does not depend on a timestamp representation at all. When given
	// a timestamp, there are lots of opportunities to make mistakes, so a
	// CalendarDay proto is replacing timestamps. PeopleApi will return
	// these values on reads, and unless the client is a legacy caller in
	// the legacy_timestamp_event_write_behavior_enabled capability
	// allowlist, this value is what is used for Person writes.
	CalendarDay *GoogleTypeDate `json:"calendarDay,omitempty"`

	// FormattedType: The `type` translated and formatted in the request
	// locale. See go/people-api-howto/localization for details on how to
	// usage.
	FormattedType string `json:"formattedType,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// Prompt: People Prompts settings for contact event data.
	Prompt *SocialGraphApiProtoPrompt `json:"prompt,omitempty"`

	// TimestampMillis: Clients are recommended to read the calendar_day
	// field instead of timestamp_millis. When writing events, new clients
	// must set calendar_day instead of timestamp_millis. Events are
	// currently represented as timestamp values, although the
	// interpretation of these timestamp values is a calendar date. There
	// are a few important details about how this value should be mapped to
	// a calendar date that should be consistent among all clients. For
	// detailed information, see Birthday.date_ms.
	TimestampMillis int64 `json:"timestampMillis,omitempty,string"`

	// Type: The type of the event. The type can be free form or one of
	// these predefined values: * `anniversary` * `other`
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CalendarDay") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CalendarDay") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiEvent) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiEvent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiExternalId: External identifier
// associated with the person.
type AppsPeopleOzExternalMergedpeopleapiExternalId struct {
	// FormattedType: The `type` translated and formatted in the request
	// locale. See go/people-api-howto/localization for details on how to
	// usage.
	FormattedType string `json:"formattedType,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// Type: The type of the external ID. The type can be free form or one
	// of these predefined values: * `account` * `customer` * `loginId` *
	// `network` * `organization`
	Type string `json:"type,omitempty"`

	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FormattedType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FormattedType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiExternalId) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiExternalId
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiFieldAcl: The field ACL. Currently
// only populated on profile fields for the profile owner. A Person
// field ACL; see http://go/peopleapi-acl
type AppsPeopleOzExternalMergedpeopleapiFieldAcl struct {
	// AclEntry: A custom type of field ACL entry. The set of all ACL
	// entries includes those listed in acl_entry as well as
	// predefined_acl_entry.
	AclEntry []*AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntry `json:"aclEntry,omitempty"`

	// AuthorizedViewers: Set of users that will be authorized to view the
	// field by this field ACL. If the ACL is public, this will only contain
	// ALL_USERS. This field is synthesized, read-only, and currently only
	// used for profile photos. It's populated under
	// "person.photo.metadata.field_acl" for the current photo ACL and
	// "person.photo.metadata.acl_choices" for available photo ACL choices.
	// Note: The set of authorized viewers for a given FieldAcl may depend
	// on the user's account type and domain configuration. For example, a
	// PRIVATE_READ FieldAcl could have any of the following authorized
	// viewers: Consumer user: [IDENTITY_ACL_ESTABLISHED] Dasher user
	// without domain contact sharing: [IDENTITY_ACL_ESTABLISHED] Unicorn
	// user: [SAME_UNICORN_FAMILY] Hafez user: []
	//
	// Possible values:
	//   "AUTHORIZED_VIEWER_UNSPECIFIED"
	//   "IDENTITY_ACL_ESTABLISHED" - Users with an identity ACL established
	// with the field owner through user-to-user interactions.
	//   "SAME_ORGANIZATION" - Users in the same enterprise organization as
	// the field owner.
	//   "SAME_UNICORN_FAMILY" - Users in the same Unicorn family as the
	// field owner.
	//   "ALL_USERS" - All users, including anonymous viewers.
	AuthorizedViewers []string `json:"authorizedViewers,omitempty"`

	// PredefinedAclEntry: A common type of field ACL entry. A predefined
	// ACL entry is a shortcut for a commonly occurring case of role and
	// scope. For example, PUBLIC_READ is the same as an AclEntry with role
	// = READER and scope.all_users = true. The set of all ACL entries
	// includes those listed in acl_entry as well as predefined_acl_entry.
	//
	// Possible values:
	//   "UNKNOWN"
	//   "OWNER" - Equivalent to role = OWNER and scope.person.person_id =
	// requester's person ID.
	//   "PUBLIC_READ" - Equivalent to role = READER and scope.all_users =
	// true.
	//   "DOMAIN_READ" - Equivalent to role = READER and scope.domain_users
	// = true.
	//   "YOUR_CIRCLES_READ" - Equivalent to role = READER and
	// scope.membership.circle.circle_set = YOUR_CIRCLES.
	//   "EXTENDED_CIRCLES_READ" - Equivalent to role = READER and
	// scope.membership.circle.circle_set = EXTENDED_CIRCLES.
	//   "PRIVATE_READ" - This is under implementation and not populated in
	// PeopleAPI yet. Equivalent to role = READER and scope.person.person_id
	// = requester's person ID. Presence of this entry means the field is
	// private and is not visible to others.
	PredefinedAclEntry []string `json:"predefinedAclEntry,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AclEntry") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AclEntry") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiFieldAcl) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiFieldAcl
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntry struct {
	// Possible values:
	//   "UNKNOWN"
	//   "READER"
	//   "WRITER"
	//   "OWNER" - owner can change ACL
	Role string `json:"role,omitempty"`

	Scope *AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScope `json:"scope,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Role") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Role") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntry) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScope struct {
	// AllUsers: Indicates that the field is accessible to all users
	// including unauthenticated users. For some fields this means "to
	// everyone except blocked users".
	AllUsers bool `json:"allUsers,omitempty"`

	// DomainUsers: This is a "synthetic" field. In reality domains are
	// treated as gaia- groups. This field will be 'true' when the field is
	// ACLed to the gaia-group of the requester's domain.
	DomainUsers bool `json:"domainUsers,omitempty"`

	Membership *AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopeMembershipAcl `json:"membership,omitempty"`

	// Person: Indicates that the field is accessible to a person.
	Person *AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopePersonAcl `json:"person,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AllUsers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllUsers") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScope) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScope
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopeMembershipAcl:
//
//	Used when the field is accessible to a membership that the person
//
// has.
type AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopeMembershipAcl struct {
	Circle *AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopeMembershipAclCircleAcl `json:"circle,omitempty"`

	ContactGroup *AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopeMembershipAclContactGroupAcl `json:"contactGroup,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Circle") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Circle") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopeMembershipAcl) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopeMembershipAcl
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopeMembershipAclC
// ircleAcl: Used when a field is accessible to a circle.
type AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopeMembershipAclCircleAcl struct {
	CircleId string `json:"circleId,omitempty"`

	// Possible values:
	//   "UNKNOWN"
	//   "YOUR_CIRCLES"
	//   "EXTENDED_CIRCLES"
	CircleSet string `json:"circleSet,omitempty"`

	// DisplayName: Equivalent to Circle.display_name for the circle_id.
	// Included when FieldAclOption.FULL_ACL_WITH_DETAILS is requested. This
	// field is read-only and ignored on update.
	DisplayName string `json:"displayName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CircleId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CircleId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopeMembershipAclCircleAcl) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopeMembershipAclCircleAcl
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopeMembershipAclC
// ontactGroupAcl: Used when a field is accessible to a legacy contact
// group. Contact groups are discouraged and may be deprecated soon.
// ContactGroupAcls are read-only. If they are included as part of an
// ACL on an Update, an exception is thrown.
type AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopeMembershipAclContactGroupAcl struct {
	// ContactGroupId: A contact group ID. This is either a user-defined
	// contact group hex ID, or it is the string name of the enum constant
	// in Group.PredefinedId in FBS backend.proto for predefined groups.
	// Common values for the predefined name include, but are not limited
	// to: all, myContacts, starred, chatBuddies, friends, family,
	// coworkers, and blocked.
	ContactGroupId string `json:"contactGroupId,omitempty"`

	// DisplayName: The localized display name for the predefined group, if
	// known; or, the display name for the user-defined contact group.
	// Included when FieldAclOption.FULL_ACL_WITH_DETAILS is requested.
	DisplayName string `json:"displayName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ContactGroupId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContactGroupId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopeMembershipAclContactGroupAcl) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopeMembershipAclContactGroupAcl
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopePersonAcl:
// Used when a field is accessible to a person. NOTE: ACLs to a circle
// or to a non-self person are no longer supported, so this can only be
// applied to the requester self.
type AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopePersonAcl struct {
	// DisplayName: DEPRECATED. This is not different than reading from
	// person.name for a self-read; ACLs to a circle or to a non-self person
	// are no longer supported. Equivalent to Name.display_name for the
	// person_id profile. Included when the profile Name is ACLed to the
	// requester and FieldAclOption.FULL_ACL_WITH_DETAILS is requested. This
	// field is read-only and ignored on update.
	DisplayName string `json:"displayName,omitempty"`

	PersonId string `json:"personId,omitempty"`

	// PhotoUrl: DEPRECATED. This is not different than reading from
	// person.photo for a self-read; ACLs to a circle or to a non-self
	// person are no longer supported. Equivalent to Photo.url for the
	// person_id profile. Included when the profile Photo is ACLed to the
	// requester and FieldAclOption.FULL_ACL_WITH_DETAILS is requested. This
	// field is read-only and ignored on update.
	PhotoUrl string `json:"photoUrl,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopePersonAcl) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopePersonAcl
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiFieldEmergencyInfo: Emergency
// information for Person field, such as Phone or Email. See
// go/emergency-trusted-contacts-papi.
type AppsPeopleOzExternalMergedpeopleapiFieldEmergencyInfo struct {
	// Possible values:
	//   "EMERGENCY_LEVEL_UNSPECIFIED" - The field (such as phone) is not
	// designated for emergency communication.
	//   "EMERGENCY_LEVEL_PRIMARY" - The field (such as phone) is designated
	// for emergency communication.
	EmergencyLevel string `json:"emergencyLevel,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EmergencyLevel") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EmergencyLevel") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiFieldEmergencyInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiFieldEmergencyInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiFileAs: The FileAs field in
// Contacts is used to override the DisplayName of a Contact for that
// User.
type AppsPeopleOzExternalMergedpeopleapiFileAs struct {
	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Metadata") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiFileAs) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiFileAs
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiGPayExtendedData: Extension data
// for use in GPay Product Profile. go/gpay-product-profile-1-pager
// Contact: profiles-eng-fe@google.com
type AppsPeopleOzExternalMergedpeopleapiGPayExtendedData struct {
	// Failure: Failure type if there is an error when fetching product
	// profile data.
	Failure *AppsPeopleOzExternalMergedpeopleapiProductProfileFailure `json:"failure,omitempty"`

	// InternationalNumber: A number in international format including the
	// country code that is made user readable by including formatting such
	// as spaces. Example: "+41 44 668 1800" DEPRECATED: A user's phone
	// number should be masked and not in an international format
	InternationalNumber string `json:"internationalNumber,omitempty"`

	// MaskedNumber: The masked string of a user's phone number The number
	// will be obfucsated with * except the last 4 digits. Refer to:
	// //java/com/google/nbu/paisa/common/PhoneNumberMasker.java
	MaskedNumber string `json:"maskedNumber,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Failure") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Failure") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiGPayExtendedData) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiGPayExtendedData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiGender: Gender in PeopleApi has
// some odd semantics about writing and reading that are not obvious
// from the proto definition. First, the `type` string, when read,
// always maps to the constrained domain of "male", "female", and
// "other", aside from a pathological case that PeopleApi would like to
// fix. There are two typical patterns: 1. `type` is either "male" or
// "female" and `custom_type` and `address_me_as` are exactly as
// specified by an update to PeopleApi, although they are most often
// absent for "male" and "female" writes. 2. `type` is "other" and
// `custom_type` is set to a freeform string from the request.
// `address_me_as` is equal to whatever was provided at write time. When
// writing, the free-form string for `custom_type` can come from either
// `custom_type` if the field is present on the request, or if
// `custom_type` is absent, the string value of `type` will be copied
// into it. Any value in `type` will be coerced to "other" and the
// free-form value will be copied into `custom_type`, even if `type` is
// exactly "other". Prefer to explicitly set `custom_type` and set type
// to "other" instead of setting type to a free-form value. There are
// weird edge cases when the value is "unknown". Consider the behavior
// for `type` == "unknown" unspecified. Clients reading the gender
// should use the value from `formatted_type` if `type` is "male" or
// "female". If `type` is "other", `formatted_type` will be "Other" (or
// some translation) and clients should read `custom_type` for more
// specificity.
type AppsPeopleOzExternalMergedpeopleapiGender struct {
	// AddressMeAs: Preferred pronoun choice. It's unclear whether this
	// value is constrained to a finite domain by UIs. `address_me_as` may
	// be populated regardless of whether `type` is "male", "female", or
	// "other", although most writers only set it if `type` is "other".
	AddressMeAs string `json:"addressMeAs,omitempty"`

	// CustomType: A free-form string indicating what the user entered as
	// their gender. `custom_type` may exist even if the type is "male" or
	// "female", although most writers do not set it unless `type` is
	// "other".
	CustomType string `json:"customType,omitempty"`

	// FormattedType: The `type` translated and formatted in the request
	// locale. See go/people-api-howto/localization for details on how to
	// usage.
	FormattedType string `json:"formattedType,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// Type: The gender. "male", "female", or "other". If "other",
	// typically, additional fields will have additional information.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AddressMeAs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AddressMeAs") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiGender) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiGender
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiGplusExtendedData struct {
	// Possible values:
	//   "UNKNOWN"
	//   "PUBLIC" - Can send and consume public content
	//   "DISCOVERY" - Restricted to only sending content internally, cannot
	// mutate external content in any manner
	//   "WALLED_GARDEN" - Restricted to sending content internally, no
	// public content naturally surfaces
	ContentRestriction string `json:"contentRestriction,omitempty"`

	// IsEnterpriseUser: Equivalent to having the DASHER_POLICY bit in the
	// REGISTERED state.
	IsEnterpriseUser bool `json:"isEnterpriseUser,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ContentRestriction")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContentRestriction") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiGplusExtendedData) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiGplusExtendedData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiHangoutsExtendedData: Extension
// data for use in Hangouts.
type AppsPeopleOzExternalMergedpeopleapiHangoutsExtendedData struct {
	// Possible values:
	//   "UNKNOWN_PAST_HANGOUT_STATE"
	//   "HAD_PAST_HANGOUT"
	//   "NO_PAST_HANGOUT"
	HadPastHangoutState string `json:"hadPastHangoutState,omitempty"`

	// InvitationStatus: Populated for all contacts. Only set if
	// had_past_hangout_state == HAD_PAST_HANGOUT. INVITATION_NEEDED is not
	// a valid value because there already is a past hangout, which means
	// either the invitation is still pending or it’s been accepted.
	//
	// Possible values:
	//   "UNKNOWN_INVITATION_STATUS"
	//   "PENDING_INVITATION" - The invitation is still pending, or was
	// declined
	//   "ACCEPTED_INVITATION" - The other user accepted the invitation
	//   "INVITATION_NEEDED" - An invitation is needed to chat with this
	// user
	InvitationStatus string `json:"invitationStatus,omitempty"`

	// IsBot: True if this is a Hangouts bot.
	IsBot bool `json:"isBot,omitempty"`

	IsDismissed bool `json:"isDismissed,omitempty"`

	IsFavorite bool `json:"isFavorite,omitempty"`

	IsPinned bool `json:"isPinned,omitempty"`

	// Possible values:
	//   "UNKNOWN_USER_TYPE"
	//   "INVALID" - No entity found.
	//   "GAIA" - Regular GAIA users.
	//   "OFF_NETWORK_PHONE" - Phone numbers represented as GAIA ids.
	//   "MALFORMED_PHONE_NUMBER" - Malformed number. Those are numbers that
	// don't comfirm to an E.164 format that we get with phone
	// calls/voicemails (e.g. "HELLO").
	//   "UNKNOWN_PHONE_NUMBER" - Unknown number. This is a number that the
	// caller has chosen not to broadcast.
	//   "ANONYMOUS_PHONE_NUMBER" - Phone number that Google knows about,
	// but the caller chose not to reveal to the recipient.
	UserType string `json:"userType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HadPastHangoutState")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HadPastHangoutState") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiHangoutsExtendedData) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiHangoutsExtendedData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiIdentityInfo struct {
	// OriginalLookupToken: Original lookup token from the request that
	// resulted in this person or one of its containers.
	OriginalLookupToken []string `json:"originalLookupToken,omitempty"`

	// PreviousPersonId: Any former IDs this person may have had, in the
	// case that their ID may have changed. Populated only for sync
	// requests. Examples of such changes include adding an edge to a
	// contact that links to a profile. The ID will change from being
	// contact-oriented to being profile-oriented. To be used to clear out
	// old versions of a person.
	PreviousPersonId []string `json:"previousPersonId,omitempty"`

	// SourceIds: A list of sources contributing to the merged person,
	// including profiles (with gaia-id), contacts and synthetic-contacts.
	SourceIds []*AppsPeopleOzExternalMergedpeopleapiSourceIdentity `json:"sourceIds,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OriginalLookupToken")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OriginalLookupToken") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiIdentityInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiIdentityInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiIm struct {
	// FormattedProtocol: The `protocol` translated and formatted in the
	// request locale. See go/people-api-howto/localization for details on
	// how to usage.
	FormattedProtocol string `json:"formattedProtocol,omitempty"`

	// FormattedType: The `type` translated and formatted in the request
	// locale. See go/people-api-howto/localization for details on how to
	// usage.
	FormattedType string `json:"formattedType,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// Protocol: The protocol of the IM. The protocol can be free form or
	// one of these predefined values: * `aim` * `msn` * `yahoo` * `skype` *
	// `qq` * `googleTalk` * `icq` * `jabber` * `netMeeting`
	Protocol string `json:"protocol,omitempty"`

	// Type: The type of the IM. The type can be free form or one of these
	// predefined values: * `home` * `work` * `other`
	Type string `json:"type,omitempty"`

	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FormattedProtocol")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FormattedProtocol") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiIm) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiIm
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiInAppNotificationTarget: How and
// where to send notifications to this person in other apps, and why the
// requester can do so. See go/reachability for more info. "How" and
// "where" identify the recipient in a P2P Bridge (glossary/p2p bridge),
// and "why" may be helpful in a UI to disambiguate which of several
// ways may be used to contact the recipient. How: Via a Google profile
// or a reachable-only phone number that the requester has access to.
// Specified in the target "type" and "value". Where: Apps in which the
// profile/phone number owner may receive notifications. Specified in
// the repeated "app". Why: Which fields in, e.g., a contact associated
// with this person make the notification target info visible to the
// requester. Specified in the repeated originating_field param.
// Example: Alice has a contact Bob, with: Email 0 = bob@gmail.com Phone
// 0 = +12223334444 Phone 1 = +15556667777 Email 0 and Phone 0 let Alice
// see Bob's public profile (obfuscated gaia ID = 123). Public profiles
// are visible by email by default, and Bob has explicitly made it
// visible via Phone 0. Bob says people can send notifications to his
// public profile in YouTube. Phone 2 is associated with another Google
// profile that Bob owns, but he doesn't want others to see it. He is
// okay with people sending notifications to him in Who's Down if they
// have this phone number, however. There will be separate
// InAppNotificationTargets: one for Bob's public Google profile, and
// one for the second phone number, which is in his private profile.
// IANT #1 - targeting Bob's public profile (visible via Email 0 and
// Phone 0): app = [YOUTUBE] type = OBFUSCATED_GAIA_ID value = 123
// originating_field: [ { field_type = EMAIL, field_index = 0 } // For
// Email 0 { field_type = PHONE, field_index = 0 } // For Phone 0 ] IANT
// #2 - targeting Bob's private profile phone number Phone 1: app =
// [WHOS_DOWN] type = PHONE value = +15556667777 originating_field: [ {
// field_type = PHONE, field_index = 1 } // For Phone 1 ]
type AppsPeopleOzExternalMergedpeopleapiInAppNotificationTarget struct {
	// Possible values:
	//   "UNKNOWN" - Should never be stored in practice
	//   "BABEL" - Aka Hangouts
	//   "YOUTUBE" - Aka Reactr
	//   "WHOS_DOWN" - Aka Who's Down
	//   "YOUTUBE_MANGO" - Aka YouTube for Emerging Markets
	//   "PHOTOS" - Aka Google Photos
	//   "GOOGLE_ASSISTANT"
	//   "KABOO" - Aka PAISA, aka Tez
	//   "COMMERCE_PLATFORM" - Aka Naksha
	//   "SPACES" - Aka Google Spaces
	//   "MAPS" - Aka Google Map
	//   "LOUPE_UNUSED" - This field is deprecated.
	//   "POMEROY" - Aka Trusted Contacts
	//   "LOUPE" - Aka Camera by Google Photos
	//   "PEOPLE_PLAYGROUND" - See go/people-playground-design.
	//   "NEWS_360" - Also mdb/social-magazines
	//   "DUO" - Aka Taychon
	//   "MEET" - Aka Google Meet
	App []string `json:"app,omitempty"`

	ClientData []*AppsPeopleOzExternalMergedpeopleapiInAppNotificationTargetClientData `json:"clientData,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// OriginatingField: There may be more than one field from which this
	// IANT originates, as in the case of Bob's public profile.
	OriginatingField []*AppsPeopleOzExternalMergedpeopleapiInAppNotificationTargetOriginatingField `json:"originatingField,omitempty"`

	// Possible values:
	//   "UNKNOWN_KEY_TYPE"
	//   "PHONE"
	//   "OBFUSCATED_GAIA_ID"
	//   "EMAIL"
	Type string `json:"type,omitempty"`

	// Value: The value of the target, used for delivery. E.g., the
	// obfuscated gaia ID for a visible profile.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "App") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "App") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiInAppNotificationTarget) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiInAppNotificationTarget
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiInAppNotificationTargetClientData:
// Client-specific data pertaining to app reachability. No PII data or
// user content should be stored in this blob.
type AppsPeopleOzExternalMergedpeopleapiInAppNotificationTargetClientData struct {
	// App: The app to which this client data applies.
	//
	// Possible values:
	//   "UNKNOWN" - Should never be stored in practice
	//   "BABEL" - Aka Hangouts
	//   "YOUTUBE" - Aka Reactr
	//   "WHOS_DOWN" - Aka Who's Down
	//   "YOUTUBE_MANGO" - Aka YouTube for Emerging Markets
	//   "PHOTOS" - Aka Google Photos
	//   "GOOGLE_ASSISTANT"
	//   "KABOO" - Aka PAISA, aka Tez
	//   "COMMERCE_PLATFORM" - Aka Naksha
	//   "SPACES" - Aka Google Spaces
	//   "MAPS" - Aka Google Map
	//   "LOUPE_UNUSED" - This field is deprecated.
	//   "POMEROY" - Aka Trusted Contacts
	//   "LOUPE" - Aka Camera by Google Photos
	//   "PEOPLE_PLAYGROUND" - See go/people-playground-design.
	//   "NEWS_360" - Also mdb/social-magazines
	//   "DUO" - Aka Taychon
	//   "MEET" - Aka Google Meet
	App string `json:"app,omitempty"`

	ByteValue string `json:"byteValue,omitempty"`

	// ForceSendFields is a list of field names (e.g. "App") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "App") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiInAppNotificationTargetClientData) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiInAppNotificationTargetClientData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiInAppNotificationTargetOriginatingF
// ield: Info for identifying the specific field in this person that
// lets the requester send them notifications. These are typically
// fields added to a contact (e.g., email). There will not always be in
// originating field, typically in the case that whatever permits the
// requester to see this target info is not something that can be used
// on its own for contacting this person.
type AppsPeopleOzExternalMergedpeopleapiInAppNotificationTargetOriginatingField struct {
	// FieldIndex: The index of the relevant field in the merged person
	FieldIndex int64 `json:"fieldIndex,omitempty"`

	// Possible values:
	//   "UNKNOWN_FIELD_TYPE"
	//   "PHONE"
	//   "EMAIL"
	FieldType string `json:"fieldType,omitempty"`

	// Value: The value of the origin field
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FieldIndex") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FieldIndex") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiInAppNotificationTargetOriginatingField) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiInAppNotificationTargetOriginatingField
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiInAppReachability: This is
// deprecated in PEOPLE_API/SHARPEN, and should only be used for
// PROFILES. Clients should use InAppNotificationTarget field instead.
// Which apps the person has indicated they are reachable at for the
// requester. See go/d13y and com.google.focus.proto.InAppReachability.
type AppsPeopleOzExternalMergedpeopleapiInAppReachability struct {
	// Possible values:
	//   "UNKNOWN" - should never be stored in practice
	//   "BABEL" - aka Hangouts
	//   "YOUTUBE" - aka Reactr
	//   "WHOS_DOWN" - aka Who's Down?
	//   "YOUTUBE_MANGO" - aka YouTube for Emerging Markets
	//   "PHOTOS" - aka Google Photos
	//   "KABOO" - aka PAISA
	//   "COMMERCE_PLATFORM" - aka Naksha
	//   "SPACES"
	//   "GOOGLE_ASSISTANT"
	//   "PEOPLE_PLAYGROUND" - See go/people-playground-design.
	//   "MAPS" - Aka Google Map
	//   "LOUPE_UNUSED" - This field is deprecated.
	//   "POMEROY" - aka Trusted Contacts
	//   "LOUPE" - Aka Camera by Google Photos
	//   "NEWS_360" - Also mdb/social-magazines
	//   "DUO" - aka Taychon
	//   "MEET" - Aka Google Meet
	AppType string `json:"appType,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	ReachabilityKey *AppsPeopleOzExternalMergedpeopleapiInAppReachabilityReachabilityKey `json:"reachabilityKey,omitempty"`

	// Possible values:
	//   "UNKNOWN_REACHABLE_STATUS"
	//   "REACHABLE"
	//   "NOT_REACHABLE"
	Status string `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AppType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AppType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiInAppReachability) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiInAppReachability
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiInAppReachabilityReachabilityKey:
// Information pertaining to how this reachable state was established.
type AppsPeopleOzExternalMergedpeopleapiInAppReachabilityReachabilityKey struct {
	// Possible values:
	//   "UNKNOWN_KEY_TYPE"
	//   "PHONE"
	//   "OBFUSCATED_GAIA_ID"
	KeyType string `json:"keyType,omitempty"`

	// KeyValue: The value of the key by which the user said they may be
	// reachable. E.g., the phone number.
	KeyValue string `json:"keyValue,omitempty"`

	// ForceSendFields is a list of field names (e.g. "KeyType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "KeyType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiInAppReachabilityReachabilityKey) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiInAppReachabilityReachabilityKey
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiInteractionSettings: Defines
// interactions that are allowed or disallowed with this person.
type AppsPeopleOzExternalMergedpeopleapiInteractionSettings struct {
	Allowed bool `json:"allowed,omitempty"`

	// Possible values:
	//   "UNKNOWN"
	//   "INCOMING_CIRCLE_MEMBERSHIP"
	//   "INCOMING_SOCIAL_EDGE"
	//   "INVITE_TO_EMAIL"
	Interaction string `json:"interaction,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Allowed") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Allowed") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiInteractionSettings) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiInteractionSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiInterest struct {
	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Metadata") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiInterest) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiInterest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiLanguage: The value can either by
// a language code conforming to the IETF BCP 47 specification or a
// custom freeform value. By default the returned value is proxied from
// FBS Profile.Language. If `include_account_locale` is set on the
// `MergePersonSourceOptions` the language from go/uls is preferred and
// returned as primary along with a secondary language from FBS.
type AppsPeopleOzExternalMergedpeopleapiLanguage struct {
	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Metadata") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiLanguage) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiLanguage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiLatLng struct {
	Lat float64 `json:"lat,omitempty"`

	Lng float64 `json:"lng,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Lat") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Lat") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiLatLng) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiLatLng
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *AppsPeopleOzExternalMergedpeopleapiLatLng) UnmarshalJSON(data []byte) error {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiLatLng
	var s1 struct {
		Lat gensupport.JSONFloat64 `json:"lat"`
		Lng gensupport.JSONFloat64 `json:"lng"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Lat = float64(s1.Lat)
	s.Lng = float64(s1.Lng)
	return nil
}

// AppsPeopleOzExternalMergedpeopleapiLegacyFields: Fields used in
// legacy applications. Useful for joining legacy and new data streams.
// Most applications should not care about these fields.
type AppsPeopleOzExternalMergedpeopleapiLegacyFields struct {
	// MobileOwnerId: Mobile obfuscated gaia id. This is the same gaia id in
	// metadata.owner_id, but obfuscated with the legacy mobile obfuscator.
	MobileOwnerId string `json:"mobileOwnerId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MobileOwnerId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MobileOwnerId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiLegacyFields) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiLegacyFields
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiLimitedProfileSettingsField struct {
	LimitedProfileSettings *SocialGraphApiProtoLimitedProfileSettings `json:"limitedProfileSettings,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "LimitedProfileSettings") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LimitedProfileSettings")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiLimitedProfileSettingsField) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiLimitedProfileSettingsField
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiLocation struct {
	BuildingId string `json:"buildingId,omitempty"`

	// BuildingName: The building_name field is only filled if the
	// DESK_LOCATION_ADDITIONAL_DATA extension is active.
	BuildingName string `json:"buildingName,omitempty"`

	Current bool `json:"current,omitempty"`

	// DeskCode: Most specific textual description of individual desk
	// location.
	DeskCode string `json:"deskCode,omitempty"`

	FloorName string `json:"floorName,omitempty"`

	FloorSection string `json:"floorSection,omitempty"`

	// LastUpdateTime: Indicates the time this location was added or last
	// edited.
	LastUpdateTime string `json:"lastUpdateTime,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// Source: Value indicates the origin of this location information.
	//
	// Possible values:
	//   "UNKNOWN"
	//   "EXPLICIT" - The location was directly set by the user or admin.
	//   "INFERRED" - The location was inferred from available signals (e.g.
	// past rooms usage).
	Source string `json:"source,omitempty"`

	// Type: Describes the type of location. For e.g. Grew_up, Desk.
	// Corresponds to FBS backend.proto Location.StandardTag
	Type string `json:"type,omitempty"`

	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BuildingId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BuildingId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiLocation) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiLocation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiManagementUpchain struct {
	// IndirectManager: List of managers in the chain. If user has manager
	// email "abc@google.com" and manager's manager has email
	// "xyz@google.com" then the list will be: [0]: { email:
	// "abc@google.com" } [1]: { email: "xyz@google.com" }
	IndirectManager []*AppsPeopleOzExternalMergedpeopleapiManagementUpchainIndirectManager `json:"indirectManager,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// Possible values:
	//   "UNKNOWN"
	//   "OK"
	//   "PARTIAL" - An error occurred while retrieving next manager so
	// resulting management upchain is partial up to manager that was not
	// retrieved.
	//   "LOOP" - A loop was found in management upchain so resulting
	// upchain contains all managers retrieved in first iteration of the
	// loop.
	Status string `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IndirectManager") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IndirectManager") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiManagementUpchain) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiManagementUpchain
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiManagementUpchainIndirectManager struct {
	Email string `json:"email,omitempty"`

	PersonId string `json:"personId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Email") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiManagementUpchainIndirectManager) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiManagementUpchainIndirectManager
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiMapsExtendedData: Extension data
// for use in Maps Product Profile.
type AppsPeopleOzExternalMergedpeopleapiMapsExtendedData struct {
	// Failure: Failure type if there is an error when fetching product
	// profile data.
	Failure *AppsPeopleOzExternalMergedpeopleapiProductProfileFailure `json:"failure,omitempty"`

	// FolloweeCount: Number of people the user is following.
	FolloweeCount int64 `json:"followeeCount,omitempty,string"`

	// FollowerCount: Number of people who are following the user.
	FollowerCount int64 `json:"followerCount,omitempty"`

	// NumContributions: Sum of creators contributions i.e. reviews, rating,
	// questions, etc.
	NumContributions int64 `json:"numContributions,omitempty,string"`

	// ProfilePhotoUrl: The user's profile photo that might have a badge
	// rendered at the corner if the user is eligible for a badge.
	ProfilePhotoUrl string `json:"profilePhotoUrl,omitempty"`

	// Tagline: A user's bio, or tagline.
	Tagline string `json:"tagline,omitempty"`

	// TopicExpertise: A topic that creator has expertise in. This will be
	// in the format: emoji associated with the topic, display name of the
	// topic, topic score
	TopicExpertise []string `json:"topicExpertise,omitempty"`

	// UserCaption: A user's caption displayed under the user name on their
	// profile page i.e. 'Local Guide Level 8'
	UserCaption string `json:"userCaption,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Failure") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Failure") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiMapsExtendedData) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiMapsExtendedData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiMapsProfile: Maps Profile Data.
// See go/product-profiles-backend-api.
type AppsPeopleOzExternalMergedpeopleapiMapsProfile struct {
	FieldRestriction []*AppsPeopleOzExternalMergedpeopleapiMapsProfileFieldRestriction `json:"fieldRestriction,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	Tagline string `json:"tagline,omitempty"`

	// WebsiteLink: A link to the profile owner's website to be displayed in
	// profile.
	WebsiteLink *AppsPeopleOzExternalMergedpeopleapiMapsProfileUrlLink `json:"websiteLink,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FieldRestriction") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FieldRestriction") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiMapsProfile) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiMapsProfile
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiMapsProfileFieldRestriction struct {
	// ClientData: Opaque data associated with this restriction e.g. abuse
	// status.
	ClientData string `json:"clientData,omitempty"`

	// Possible values:
	//   "TYPE_UNSPECIFIED"
	//   "HIDE_TAGLINE"
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ClientData") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ClientData") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiMapsProfileFieldRestriction) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiMapsProfileFieldRestriction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiMapsProfileUrlLink struct {
	// AnchorText: Anchor text to be displayed as clickable link. If not
	// present, the URL should be displayed directly.
	AnchorText string `json:"anchorText,omitempty"`

	// Url: The URL to be linked to.
	Url string `json:"url,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AnchorText") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnchorText") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiMapsProfileUrlLink) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiMapsProfileUrlLink
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiMatchInfo: Represents the matching
// information for a field when there is a query.
type AppsPeopleOzExternalMergedpeopleapiMatchInfo struct {
	// Match: The list of matches ordered by most relevant matching for
	// autocomplete coming first.
	Match []*AppsPeopleOzExternalMergedpeopleapiMatchInfoLookupTokenMatch `json:"match,omitempty"`

	// Query: The query token we are matching against.
	Query string `json:"query,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Match") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Match") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiMatchInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiMatchInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiMatchInfoLookupTokenMatch: All the
// substring that were matched for the given query against the current
// field. Represents a substring of another string.
type AppsPeopleOzExternalMergedpeopleapiMatchInfoLookupTokenMatch struct {
	// EndIndex: Index right after the last character that matches the
	// query. length = end-start, we have substring = [start, end).
	EndIndex int64 `json:"endIndex,omitempty"`

	// StartIndex: Index of the first unicode character that matches the
	// query.
	StartIndex int64 `json:"startIndex,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndIndex") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiMatchInfoLookupTokenMatch) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiMatchInfoLookupTokenMatch
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiMembership: A membership that the
// person has. The person can be a member of multiple circles and
// multiple contact-groups. A circle membership is created by adding a
// person to a circle by person-id or by email. A contact-group
// membership is created by adding a contact to a contact-group.
type AppsPeopleOzExternalMergedpeopleapiMembership struct {
	// CircleId: A circle that the person belongs to.
	CircleId string `json:"circleId,omitempty"`

	// ContactGroupId: A contact-group that the person belong to. The id can
	// be either a hex-formatted id or a camel-cased SystemContactGroup
	// predefined group name. The id will be predefined group name iff the
	// system_contact_group_id has a value.
	ContactGroupId string `json:"contactGroupId,omitempty"`

	// Metadata: The metadata field can be used to determine which container
	// generated the membership. For example, when the membership has a
	// contact_group_id, the metadata.container will be CONTACT and the
	// container_id will be the contact Id.
	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// SystemContactGroupId: The membership has a contact_group_id, this
	// field will be populated when the membership is in a system-reserved
	// contact-group.
	//
	// Possible values:
	//   "UNKNOWN"
	//   "MY_CONTACTS"
	//   "STARRED"
	//   "FRIENDS"
	//   "FAMILY"
	//   "COWORKERS"
	SystemContactGroupId string `json:"systemContactGroupId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CircleId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CircleId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiMembership) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiMembership
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiMission struct {
	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Metadata") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiMission) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiMission
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiName: See
// go/people-api-howto:names for an overview of name usage in PeopleAPI.
// The `unstructured_name` field contains a free form name value. The
// `given_name`, `middle_name`, `family_name`, etc, fields contain the
// structured name. For CONTACT mutates, (i.e. when
// Name.metadata.container is CONTACT), it is recommended for clients to
// set either the `unstructured_name` or the set of structured name
// fields, not both. * When only the `unstructured_name` is set, it is
// parsed to produce a best-guess set of structured name values for the
// `given_name`, `family_name`, etc. * When only the structured name
// fields are set, the various values are combined to produce an
// `unstructured_name`. * When both are set, the `unstructured_name` is
// saved as-is and the structured name fields are saved as-is. This may
// be confusing as they might not "match". For PROFILE mutates, (i.e.
// when Name.metadata.container is PROFILE), it is _required_ for
// clients to use the structured name fields as the unstructured field
// value is ignored on write. The unstructured name fields are generated
// for convenience on read. For DEVICE_CONTACTS, see b/156020778.
type AppsPeopleOzExternalMergedpeopleapiName struct {
	// DisplayName: Read-only. A name synthesized based on
	// `unstructured_name` and the structured name fields. Example: "John
	// Smith" If a language code is passed in the side channel using
	// http://cs/symbol:framework.rpc.DeprecatedPropagatedLanguageCode.value
	// or http://cs/symbol:google.rpc.context.OriginContext.accept_language
	// and the name does not have `honorific_prefix`, `middle_name`, or
	// `honorific_suffix` set, the language code will be used to format
	// `display_name`. If `include_account_locale` is set on the
	// `MergePersonSourceOptions` and a language code is not passed in the
	// side channel. The language code from go/uls will be used as the
	// language code for formatting `display_name`.
	DisplayName string `json:"displayName,omitempty"`

	// DisplayNameLastFirst: Read-only. A name synthesized based on
	// `unstructured_name` and the structured name fields with the last name
	// first. Example: "Smith, John"
	DisplayNameLastFirst string `json:"displayNameLastFirst,omitempty"`

	// DisplayNameSource: Read-only. The source of the display name.
	DisplayNameSource *SocialGraphApiProtoDisplayNameSource `json:"displayNameSource,omitempty"`

	FamilyName string `json:"familyName,omitempty"`

	// FormattedName: DEPRECATED(b/70571931). Use `unstructured_name`
	// instead.
	FormattedName string `json:"formattedName,omitempty"`

	GivenName string `json:"givenName,omitempty"`

	HonorificPrefix string `json:"honorificPrefix,omitempty"`

	HonorificSuffix string `json:"honorificSuffix,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	MiddleName string `json:"middleName,omitempty"`

	// Pronunciations: This field is stored in contact annotations and
	// merged at read-time. It is available with CONTACT_ANNOTATION
	// container type at read time.
	Pronunciations *SocialGraphApiProtoPronunciations `json:"pronunciations,omitempty"`

	// ShortDisplayName: NOTE: this is currently NOT IMPLEMENTED due to
	// changed priorities. Clients usually rely on "first name" instead,
	// when a short name is needed. Read-only. A possibly shorter version of
	// the user's name. - The purpose of this field is to address the needs
	// of UIs where a full display name might be too large to fit. Instead
	// of relying on `first_name`, which might not be present,
	// `short_display_name` is preferred. - This is only available for
	// PROFILE and DOMAIN_PROFILE container types. - About the actual
	// content in this field: will be the first name when it's visible to
	// the requester, or the same as `display_name`, otherwise. A sample
	// scenario where the first name may not be visible is when the limited
	// profile is returned. For more info, see: http://shortn/_9iV7TJ33la
	ShortDisplayName string `json:"shortDisplayName,omitempty"`

	// UnstructuredName: The free form name value. For contact mutates it is
	// recommended for clients to set either the `unstructured_name` or the
	// set of structured name fields, not both.
	UnstructuredName string `json:"unstructuredName,omitempty"`

	YomiFamilyName string `json:"yomiFamilyName,omitempty"`

	YomiFullName string `json:"yomiFullName,omitempty"`

	YomiGivenName string `json:"yomiGivenName,omitempty"`

	YomiHonorificPrefix string `json:"yomiHonorificPrefix,omitempty"`

	YomiHonorificSuffix string `json:"yomiHonorificSuffix,omitempty"`

	YomiMiddleName string `json:"yomiMiddleName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiName) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiName
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiNamePronunciationAudioMetadataInfo:
//
//	Pronunciation audio metadata info. See
//
// go/name-pronunciation-backend. The metadata itself tracks the state
// of a user's name pronunciation audio.
type AppsPeopleOzExternalMergedpeopleapiNamePronunciationAudioMetadataInfo struct {
	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// NamePronunciationAudioMetadata: Actual metadata proto, shared with
	// FBS backends.
	NamePronunciationAudioMetadata *SocialGraphApiProtoNamePronunciationAudioMetadata `json:"namePronunciationAudioMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Metadata") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiNamePronunciationAudioMetadataInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiNamePronunciationAudioMetadataInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiNickname struct {
	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// Possible values:
	//   "NICKNAME_UNKNOWN"
	//   "DEFAULT"
	//   "OTHER_NAME" - Used in Profiles UI
	//   "MAIDEN_NAME"
	//   "SHORT_NAME"
	//   "INITIALS"
	//   "ALTERNATE_NAME" - The nickname or alternate name, incorporated
	// into Display Name.
	Type string `json:"type,omitempty"`

	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Metadata") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiNickname) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiNickname
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiOccupation struct {
	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Metadata") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiOccupation) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiOccupation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiOpeningHours: The periods that
// this place is open during the week. The periods are in chronological
// order, starting with today in the place-local timezone. An empty (but
// not absent) value indicates a place that is never open, e.g. because
// it is closed temporarily for renovations.
type AppsPeopleOzExternalMergedpeopleapiOpeningHours struct {
	// OpenNow: Is this place open right now? Always present unless we lack
	// time-of-day or timezone data for these opening hours.
	OpenNow bool `json:"openNow,omitempty"`

	Periods []*AppsPeopleOzExternalMergedpeopleapiOpeningHoursPeriod `json:"periods,omitempty"`

	// WeekdayTexts: Localized strings describing the opening hours of this
	// place, one string for each day of the week. Will be empty if the
	// hours are unknown or could not be converted to localized text.
	// Example: "Sun: 18:00-06:00"
	WeekdayTexts []string `json:"weekdayTexts,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OpenNow") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OpenNow") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiOpeningHours) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiOpeningHours
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiOpeningHoursEndpoint struct {
	// Day: A day of the week, as an integer in the range 0-6. 0 is Sunday,
	// 1 is Monday, etc.
	Day int64 `json:"day,omitempty"`

	// Time: A time in 24-hour "hhmm" format (i.e. range is 0000 to 2359).
	Time string `json:"time,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Day") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Day") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiOpeningHoursEndpoint) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiOpeningHoursEndpoint
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiOpeningHoursPeriod struct {
	Close *AppsPeopleOzExternalMergedpeopleapiOpeningHoursEndpoint `json:"close,omitempty"`

	Open *AppsPeopleOzExternalMergedpeopleapiOpeningHoursEndpoint `json:"open,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Close") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Close") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiOpeningHoursPeriod) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiOpeningHoursPeriod
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiOrganization struct {
	Assignment []*AppsPeopleOzExternalMergedpeopleapiOrganizationAssignment `json:"assignment,omitempty"`

	Certification string `json:"certification,omitempty"`

	CostCenter string `json:"costCenter,omitempty"`

	Current bool `json:"current,omitempty"`

	Department string `json:"department,omitempty"`

	Description string `json:"description,omitempty"`

	Domain string `json:"domain,omitempty"`

	// EndCalendarDay: Start and End Dates are better represented as
	// calendar entities. The intention is to replace timestamps. Not set if
	// no value exists. Clients can choose whether to use has* semantics or
	// default value semantics. For writes, the default proto and an absent
	// message are equivalent. Legacy callers in the
	// legacy_timestamp_event_write_behavior_enabled capability allowlist
	// should write to PeopleApi via end_ms and migrate to setting both so
	// they can be removed from the whitelist.
	EndCalendarDay *GoogleTypeDate `json:"endCalendarDay,omitempty"`

	// EndMs: Clients are encouraged to read the end_calendar_day instead.
	// PeopleApi writes will still use end_ms for legacy callers that are in
	// the legacy_timestamp_event_write_behavior_enabled capability
	// allowlist. New writers must use the calendar_day fields.
	EndMs int64 `json:"endMs,omitempty,string"`

	EndMsAsNumber int64 `json:"endMsAsNumber,omitempty,string"`

	// FormattedStringType: The `string_type` translated and formatted in
	// the request locale. See go/people-api-howto/localization for details
	// on how to usage.
	FormattedStringType string `json:"formattedStringType,omitempty"`

	FteMilliPercent int64 `json:"fteMilliPercent,omitempty"`

	Importance float64 `json:"importance,omitempty"`

	Location string `json:"location,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	Name string `json:"name,omitempty"`

	Project []*AppsPeopleOzExternalMergedpeopleapiOrganizationProject `json:"project,omitempty"`

	// StartCalendarDay: Start and End Dates are better represented as
	// calendar entities. The intention is to replace timestamps. Not set if
	// no value exists. Clients can choose whether to use has* semantics or
	// default value semantics. For writes, the default proto and an absent
	// message are equivalent. Legacy callers in the
	// legacy_timestamp_event_write_behavior_enabled capability allowlist
	// should write to PeopleApi via start_ms and migrate to setting both so
	// they can be removed from the allowlist.
	StartCalendarDay *GoogleTypeDate `json:"startCalendarDay,omitempty"`

	// StartMs: Clients are encouraged to read the start_calendar_day
	// instead. PeopleApi writes will still use start_ms for legacy callers
	// that are in the legacy_timestamp_event_write_behavior_enabled
	// capability allowlist. New writers must use the calendar_day fields.
	StartMs int64 `json:"startMs,omitempty,string"`

	StartMsAsNumber int64 `json:"startMsAsNumber,omitempty,string"`

	// StringType: The type of the organization. The type can be free form
	// or one of these predefined values: * `work` * `school`
	StringType string `json:"stringType,omitempty"`

	Symbol string `json:"symbol,omitempty"`

	Title string `json:"title,omitempty"`

	// Possible values:
	//   "UNKNOWN"
	//   "WORK"
	//   "SCHOOL"
	//   "DOMAIN_ONLY" - Used for domains inferred from verified email
	// addresses. May be deprecated when/if we start mapping SCHOOL and WORK
	// Names to Domain.
	Type string `json:"type,omitempty"`

	YomiName string `json:"yomiName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Assignment") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Assignment") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiOrganization) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiOrganization
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *AppsPeopleOzExternalMergedpeopleapiOrganization) UnmarshalJSON(data []byte) error {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiOrganization
	var s1 struct {
		Importance gensupport.JSONFloat64 `json:"importance"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Importance = float64(s1.Importance)
	return nil
}

type AppsPeopleOzExternalMergedpeopleapiOrganizationAssignment struct {
	Name string `json:"name,omitempty"`

	Url string `json:"url,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiOrganizationAssignment) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiOrganizationAssignment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiOrganizationProject struct {
	Description string `json:"description,omitempty"`

	Name string `json:"name,omitempty"`

	Role string `json:"role,omitempty"`

	// Type: Mapped from StandardProjectTag / CustomProjectTag
	Type string `json:"type,omitempty"`

	Url string `json:"url,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiOrganizationProject) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiOrganizationProject
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiOtherKeyword struct {
	// FormattedType: The `type` translated and formatted in the request
	// locale. See go/people-api-howto/localization for details on how to
	// usage.
	FormattedType string `json:"formattedType,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// Possible values:
	//   "SOURCE_UNKNOWN"
	//   "OUTLOOK" - Following field is added to support Outlook schema.
	// This field is a general storage for Outlook string data that shall be
	// encoded as: "name:" + value strings where name of the Outlook field
	// cannot contain colons. Multiple Outlook fields shall be encoded as
	// multiple Keywords.
	//   "CUSTOM"
	Source string `json:"source,omitempty"`

	// Type: The type of the event. The type depends on the
	// `OtherKeyword.source`. `OUTLOOK` source fields must be one of: *
	// `billing_information` * `directory_server` * `keyword` * `mileage` *
	// `sensitivity` * `user` * `subject` All other fields are treated as a
	// `CUSTOM` source field. The value can be free form or one of these
	// predefined values: * `home` * `other` * `work`
	Type string `json:"type,omitempty"`

	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FormattedType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FormattedType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiOtherKeyword) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiOtherKeyword
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiPerson: Merged-person combines
// multiple sources of data like contacts and profiles. See
// go/people-api and go/understanding-merged-person NOTE: Why are all
// the fields repeated? See go/people-api-concepts#repeated
type AppsPeopleOzExternalMergedpeopleapiPerson struct {
	About []*AppsPeopleOzExternalMergedpeopleapiAbout `json:"about,omitempty"`

	Address []*AppsPeopleOzExternalMergedpeopleapiAddress `json:"address,omitempty"`

	// AgeRange: Deprecated. If age is needed use
	// `person.age_range_repeated` instead. Please see
	// go/people-api-howto:age on how to correctly get age data.
	//
	// Possible values:
	//   "UNKNOWN"
	//   "LESS_THAN_EIGHTEEN"
	//   "TWENTY_ONE_OR_OLDER"
	//   "EIGHTEEN_TO_TWENTY"
	AgeRange string `json:"ageRange,omitempty"`

	// AgeRangeRepeated: Data on the person's age range, adult status, and
	// age of consent. NOTE: Please read go/people-api-howto:age on how to
	// correctly get age data.
	AgeRangeRepeated []*AppsPeopleOzExternalMergedpeopleapiAgeRangeType `json:"ageRangeRepeated,omitempty"`

	Birthday []*AppsPeopleOzExternalMergedpeopleapiBirthday `json:"birthday,omitempty"`

	// BraggingRights: Used only by contacts, no data will be returned for
	// profiles.
	BraggingRights []*AppsPeopleOzExternalMergedpeopleapiBraggingRights `json:"braggingRights,omitempty"`

	// Calendar: b/145671020: Deprecated for Profiles, but not for Contacts.
	Calendar []*AppsPeopleOzExternalMergedpeopleapiCalendar `json:"calendar,omitempty"`

	CertifiedBornBefore []*AppsPeopleOzExternalMergedpeopleapiCertifiedBornBefore `json:"certifiedBornBefore,omitempty"`

	// CircleMembership: Circles that this person is a member of.
	CircleMembership []*AppsPeopleOzExternalMergedpeopleapiCircleMembership `json:"circleMembership,omitempty"`

	ClientData []*AppsPeopleOzExternalMergedpeopleapiClientData `json:"clientData,omitempty"`

	CommunicationEmail []*AppsPeopleOzExternalMergedpeopleapiCommunicationEmail `json:"communicationEmail,omitempty"`

	// ConnectionReminder: Reminder to connect with a Contact (part of
	// go/people-prompts). Also contains contact-level prompts settings.
	// Each Contact can have a single `connection_reminder` (but can have
	// multiple Prompts inside of it). Field is repeated per PeopleAPI data
	// model go/people-api-concepts#repeated. Only supported for CONTACT
	// container.
	ConnectionReminder []*AppsPeopleOzExternalMergedpeopleapiConnectionReminder `json:"connectionReminder,omitempty"`

	// ContactCreateContextInfo: ContactCreateContextInfo has a timestamp
	// timestamp and additional metadata (e.g. the source of the creation)
	// for when the contact was created. See also `ContactEditContextInfo`.
	ContactCreateContextInfo []*AppsPeopleOzExternalMergedpeopleapiContactCreateContextInfo `json:"contactCreateContextInfo,omitempty"`

	// ContactEditContextInfo: ContactEditContextInfo is a timestamp and
	// additional metadata (e.g. the source of the edit) for the last 'human
	// initiated edit'. See also `ContactCreateContextInfo`.
	ContactEditContextInfo []*AppsPeopleOzExternalMergedpeopleapiContactEditContextInfo `json:"contactEditContextInfo,omitempty"`

	// ContactGroupMembership: Contact groups that this person is a member
	// of.
	ContactGroupMembership []*AppsPeopleOzExternalMergedpeopleapiContactGroupMembership `json:"contactGroupMembership,omitempty"`

	ContactPromptSettingsInfo []*AppsPeopleOzExternalMergedpeopleapiContactPromptSettingsInfo `json:"contactPromptSettingsInfo,omitempty"`

	// ContactStateInfo: Contact state and related metadata. See
	// go/fbs-contacts-trash. If this field was requested but is not set on
	// the Person then the contact is in the DEFAULT contact state. This
	// field is read-only, and should not be set on a mutate (e.g.
	// UpdatePerson) call. Clients must call the explicit APIs (e.g.
	// UntrashPerson) to change contact state.
	ContactStateInfo []*AppsPeopleOzExternalMergedpeopleapiContactStateInfo `json:"contactStateInfo,omitempty"`

	// CoverPhoto: DEPRECATED. Now always returns a default cover photo. See
	// go/sunset-cover-photo.
	CoverPhoto []*AppsPeopleOzExternalMergedpeopleapiCoverPhoto `json:"coverPhoto,omitempty"`

	CustomSchemaField []*AppsPeopleOzExternalMergedpeopleapiCustomSchemaField `json:"customSchemaField,omitempty"`

	Email []*AppsPeopleOzExternalMergedpeopleapiEmail `json:"email,omitempty"`

	// EmergencyInfo: Emergency information. See
	// go/emergency-trusted-contacts-papi.
	EmergencyInfo []*AppsPeopleOzExternalMergedpeopleapiEmergencyInfo `json:"emergencyInfo,omitempty"`

	// Event: Event is currently in use by contacts.
	Event []*AppsPeopleOzExternalMergedpeopleapiEvent `json:"event,omitempty"`

	// ExtendedData: Data added by extensions that are not specific to a
	// particular field.
	ExtendedData *AppsPeopleOzExternalMergedpeopleapiPersonExtendedData `json:"extendedData,omitempty"`

	ExternalId []*AppsPeopleOzExternalMergedpeopleapiExternalId `json:"externalId,omitempty"`

	FileAs []*AppsPeopleOzExternalMergedpeopleapiFileAs `json:"fileAs,omitempty"`

	// Fingerprint: A fingerprint that can be used to reliably determine if
	// a resource has changed. Externally it is used as part of the etag.
	Fingerprint string `json:"fingerprint,omitempty"`

	Gender []*AppsPeopleOzExternalMergedpeopleapiGender `json:"gender,omitempty"`

	Im []*AppsPeopleOzExternalMergedpeopleapiIm `json:"im,omitempty"`

	// InAppNotificationTarget: Ways to send in-app notifications to this
	// person. See go/reachability. This field is read-only and ignored for
	// mutates.
	InAppNotificationTarget []*AppsPeopleOzExternalMergedpeopleapiInAppNotificationTarget `json:"inAppNotificationTarget,omitempty"`

	// InAppReachability: Used only by profile service, deprecated for
	// PeopleAPI and Sharpen. If you aren't sure, contact people-api-users@
	// and profile-service-eng@.
	InAppReachability []*AppsPeopleOzExternalMergedpeopleapiInAppReachability `json:"inAppReachability,omitempty"`

	// InteractionSettings: DEPRECATED. This field isn't populated in
	// people.list.
	InteractionSettings []*AppsPeopleOzExternalMergedpeopleapiInteractionSettings `json:"interactionSettings,omitempty"`

	Interest []*AppsPeopleOzExternalMergedpeopleapiInterest `json:"interest,omitempty"`

	Language []*AppsPeopleOzExternalMergedpeopleapiLanguage `json:"language,omitempty"`

	// LegacyFields: DEPRECATED. This field was only for backwards
	// compatibility with legacy GData callers, and should not be used by
	// new clients. Legacy fields used for mobile clients.
	LegacyFields *AppsPeopleOzExternalMergedpeopleapiLegacyFields `json:"legacyFields,omitempty"`

	// LimitedProfileSettings: Settings for the limited profile. See
	// go/limited-profiles-api.
	LimitedProfileSettings []*AppsPeopleOzExternalMergedpeopleapiLimitedProfileSettingsField `json:"limitedProfileSettings,omitempty"`

	// LinkedPerson: Other person resources linked indirectly by an edge.
	// The full person or just the IDs may be populated depending on request
	// parameters. We consider linked people distinct people, but they share
	// information. Example: A contact with two outgoing edges. The two
	// edges are considered separate, but linked people.
	LinkedPerson []*AppsPeopleOzExternalMergedpeopleapiPerson `json:"linkedPerson,omitempty"`

	Location []*AppsPeopleOzExternalMergedpeopleapiLocation `json:"location,omitempty"`

	ManagementUpchain []*AppsPeopleOzExternalMergedpeopleapiManagementUpchain `json:"managementUpchain,omitempty"`

	// MapsProfile: MapsProfile, see go/product-profiles-backend-api
	MapsProfile []*AppsPeopleOzExternalMergedpeopleapiMapsProfile `json:"mapsProfile,omitempty"`

	// Membership: DEPRECATED. Please use `circle_membership` or
	// `contact_group_membership` instead. Contact-groups and circles that
	// this person is a member of.
	Membership []*AppsPeopleOzExternalMergedpeopleapiMembership `json:"membership,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonMetadata `json:"metadata,omitempty"`

	Mission []*AppsPeopleOzExternalMergedpeopleapiMission `json:"mission,omitempty"`

	// Name: See go/people-api-howto:names for details about names in
	// PeopleAPI.
	Name []*AppsPeopleOzExternalMergedpeopleapiName `json:"name,omitempty"`

	// NamePronunciationAudioMetadataInfo: Metadata info for a user's name
	// pronunciation audio. See go/name-pronunication-backend.
	NamePronunciationAudioMetadataInfo []*AppsPeopleOzExternalMergedpeopleapiNamePronunciationAudioMetadataInfo `json:"namePronunciationAudioMetadataInfo,omitempty"`

	Nickname []*AppsPeopleOzExternalMergedpeopleapiNickname `json:"nickname,omitempty"`

	Occupation []*AppsPeopleOzExternalMergedpeopleapiOccupation `json:"occupation,omitempty"`

	Organization []*AppsPeopleOzExternalMergedpeopleapiOrganization `json:"organization,omitempty"`

	// OtherKeyword: Legacy arbitrary key value fields
	OtherKeyword []*AppsPeopleOzExternalMergedpeopleapiOtherKeyword `json:"otherKeyword,omitempty"`

	// PeopleInCommon: DEPRECATED. This feature was stubbed, but never
	// implemented. This field will not be populated with any results.
	PeopleInCommon []*AppsPeopleOzExternalMergedpeopleapiPerson `json:"peopleInCommon,omitempty"`

	// PersonAttribute: In order to request this field, the client must set
	// desired PersonAttributeKey in the dedicated RequestMask field
	// `person_attribute`. Unlike other person fields, this field cannot be
	// requested in the `include_field` field mask.
	PersonAttribute []*AppsPeopleOzExternalMergedpeopleapiPersonAttribute `json:"personAttribute,omitempty"`

	// PersonId: The ID of the person. This is determined by the backend, is
	// unstable, and may not be the same as a user_id. Internally referred
	// as 'personKey' to distinguish from the common PersonId pojo. See
	// go/people-api-concepts#person-id
	PersonId string `json:"personId,omitempty"`

	Phone []*AppsPeopleOzExternalMergedpeopleapiPhone `json:"phone,omitempty"`

	// Photo: See go/people-api-concepts/photos for usage details
	Photo []*AppsPeopleOzExternalMergedpeopleapiPhoto `json:"photo,omitempty"`

	// PlaceDetails: Data specific to places. Data which also applies to
	// contacts and profiles such as name, phone, photo, etc. are returned
	// in the corresponding Person fields.
	PlaceDetails []*AppsPeopleOzExternalMergedpeopleapiPlaceDetails `json:"placeDetails,omitempty"`

	// PlusPageInfo: DEPRECATED. Info about plus pages in the person.
	PlusPageInfo []*AppsPeopleOzExternalMergedpeopleapiPlusPageInfo `json:"plusPageInfo,omitempty"`

	PosixAccount []*AppsPeopleOzExternalMergedpeopleapiPosixAccount `json:"posixAccount,omitempty"`

	// ProfileUrl: DEPRECATED. No data is returned for this field anymore.
	// (go/people-api-concepts#repeated): Use person.profile_url_repeated
	// instead. Access to this field is restricted to a set of legacy
	// clients. This is a Google+-only field. See go/fbs-g+-deprecation.
	// NOTE: `Person.profile_url` is only populated for profile-centric
	// person.
	ProfileUrl string `json:"profileUrl,omitempty"`

	// ProfileUrlRepeated: DEPRECATED. No data is returned for this field
	// anymore. This is a Google+-only field. See go/fbs-g+-deprecation.
	ProfileUrlRepeated []*AppsPeopleOzExternalMergedpeopleapiProfileUrl `json:"profileUrlRepeated,omitempty"`

	// Pronoun: Pronouns are not supported for consumer profiles. See
	// go/pronouns-in-people-system-prd for more details.
	Pronoun []*AppsPeopleOzExternalMergedpeopleapiPronoun `json:"pronoun,omitempty"`

	// ReadOnlyProfileInfo: Information about the profiles that are a part
	// of this Person. This is only applicable to PROFILE and DOMAIN_PROFILE
	// containers.
	ReadOnlyProfileInfo []*AppsPeopleOzExternalMergedpeopleapiReadOnlyProfileInfo `json:"readOnlyProfileInfo,omitempty"`

	// Relation: See go/relation-vs-relationship for relation vs
	// relationship explanation.
	Relation []*AppsPeopleOzExternalMergedpeopleapiRelation `json:"relation,omitempty"`

	// RelationshipInterest: DEPRECATED. No data is returned for this field
	// anymore.
	RelationshipInterest []*AppsPeopleOzExternalMergedpeopleapiRelationshipInterest `json:"relationshipInterest,omitempty"`

	// RelationshipStatus: DEPRECATED. No data is returned for this field
	// anymore.
	RelationshipStatus []*AppsPeopleOzExternalMergedpeopleapiRelationshipStatus `json:"relationshipStatus,omitempty"`

	RightOfPublicityState []*AppsPeopleOzExternalMergedpeopleapiRightOfPublicityState `json:"rightOfPublicityState,omitempty"`

	// RosterDetails: Data specific to rosters (such as Google Groups and
	// Chat Rooms). Data which also applies to contacts and profiles such as
	// name, email, and photo, etc are returned in the corresponding Person
	// fields.
	RosterDetails []*AppsPeopleOzExternalMergedpeopleapiRosterDetails `json:"rosterDetails,omitempty"`

	// SearchProfile: Profile for Janata and Search.
	// go/janata-profile-in-sgbe
	SearchProfile []*AppsPeopleOzExternalMergedpeopleapiSearchProfile `json:"searchProfile,omitempty"`

	// SipAddress: SipAddress is currently in use by contacts.
	SipAddress []*AppsPeopleOzExternalMergedpeopleapiSipAddress `json:"sipAddress,omitempty"`

	Skills []*AppsPeopleOzExternalMergedpeopleapiSkills `json:"skills,omitempty"`

	// SocialConnection: NOTE: this is used by go/starlight, but not
	// actually used or returned in PeopleAPI. See b/27281119 for context.
	// Please reach out to people-api-eng@ if you have questions.
	SocialConnection []*AppsPeopleOzExternalMergedpeopleapiSocialConnection `json:"socialConnection,omitempty"`

	SortKeys *AppsPeopleOzExternalMergedpeopleapiSortKeys `json:"sortKeys,omitempty"`

	SshPublicKey []*AppsPeopleOzExternalMergedpeopleapiSshPublicKey `json:"sshPublicKey,omitempty"`

	// Tagline: Only supported for PLACE container results, no data will be
	// returned for profiles.
	Tagline []*AppsPeopleOzExternalMergedpeopleapiTagline `json:"tagline,omitempty"`

	// TeamsExtendedData: DEPRECATED. *UNSUPPORTED*. This field is never
	// populated.
	TeamsExtendedData *AppsPeopleOzExternalMergedpeopleapiTeamsExtendedData `json:"teamsExtendedData,omitempty"`

	// UserDefined: UserDefined is currently in use by contacts.
	UserDefined []*AppsPeopleOzExternalMergedpeopleapiUserDefined `json:"userDefined,omitempty"`

	// VisibleToGuests: Add annotation_id and metadata (product_source) for
	// visible to guests contacts go/visible-to-guests.
	VisibleToGuests []*AppsPeopleOzExternalMergedpeopleapiVisibleToGuests `json:"visibleToGuests,omitempty"`

	Website []*AppsPeopleOzExternalMergedpeopleapiWebsite `json:"website,omitempty"`

	// ForceSendFields is a list of field names (e.g. "About") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "About") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiPerson) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiPerson
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiPersonAttribute: Client-specific
// binary blob stored with Person data. This differs from ClientData,
// which stores structured, key-value pairs.
type AppsPeopleOzExternalMergedpeopleapiPersonAttribute struct {
	// Possible values:
	//   "PERSON_ATTRIBUTE_UNKNOWN"
	//   "REJECTED_CLEANUP_CARD_SUGGESTIONS" - The value field of a
	// PersonAttribute object with this key will contain a byte serialized
	// RejectedCleanupCardSuggestions proto, see http://shortn/_3KyFdhbZfW
	AttributeKey string `json:"attributeKey,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AttributeKey") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttributeKey") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiPersonAttribute) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiPersonAttribute
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiPersonExtendedData: Extension data
// for the whole person entity.
type AppsPeopleOzExternalMergedpeopleapiPersonExtendedData struct {
	// AboutMeExtendedData: For use by AboutMe and SmartProfile clients.
	AboutMeExtendedData *AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedData `json:"aboutMeExtendedData,omitempty"`

	// AppsWaldoExtendedData: For use with Apps Waldo Availability Data
	// extension
	AppsWaldoExtendedData *SocialGraphWireProtoPeopleapiExtensionAppsWaldoExtendedData `json:"appsWaldoExtendedData,omitempty"`

	// CallerIdExtendedData: For use with caller ID extension
	CallerIdExtendedData *AppsPeopleOzExternalMergedpeopleapiCallerIdExtendedData `json:"callerIdExtendedData,omitempty"`

	// ContactsExtendedData: For use with Contacts extension.
	ContactsExtendedData *AppsPeopleOzExternalMergedpeopleapiWebContactsExtendedData `json:"contactsExtendedData,omitempty"`

	// DomainName: Hosted domain this person is a member of. The domain_name
	// is also returned as part of the person's ReadOnlyProfileInfo, so
	// requesting it via this extension is no longer necessary.
	DomainName []string `json:"domainName,omitempty"`

	// DynamiteExtendedData: For use with Dynamite extension.
	DynamiteExtendedData *SocialGraphWireProtoPeopleapiExtensionDynamiteExtendedData `json:"dynamiteExtendedData,omitempty"`

	// GpayExtendedData: For use with Google Pay extension.
	GpayExtendedData *AppsPeopleOzExternalMergedpeopleapiGPayExtendedData `json:"gpayExtendedData,omitempty"`

	// GplusExtendedData: For use with Google+ extension.
	GplusExtendedData *AppsPeopleOzExternalMergedpeopleapiGplusExtendedData `json:"gplusExtendedData,omitempty"`

	// HangoutsExtendedData: For use with Hangouts extension.
	HangoutsExtendedData *AppsPeopleOzExternalMergedpeopleapiHangoutsExtendedData `json:"hangoutsExtendedData,omitempty"`

	// IsPlaceholder: For use with gmail extensions and lookup by email. If
	// true, no person was actually found using the specified email address,
	// but we want to return TLS info about the email address regardless.
	IsPlaceholder bool `json:"isPlaceholder,omitempty"`

	// MapsExtendedData: For use with Maps extension.
	MapsExtendedData *AppsPeopleOzExternalMergedpeopleapiMapsExtendedData `json:"mapsExtendedData,omitempty"`

	// PaisaExtendedData: For use with Paisa extension
	PaisaExtendedData *SocialGraphWireProtoPeopleapiExtensionPaisaExtendedData `json:"paisaExtendedData,omitempty"`

	// PeopleStackExtendedData: DEPRECATED: Use
	// people_stack_person_extended_data instead. For use with PeopleStack
	// extension.
	PeopleStackExtendedData *SocialGraphWireProtoPeopleapiExtensionPeopleStackExtendedData `json:"peopleStackExtendedData,omitempty"`

	// PeopleStackPersonExtendedData: For use with PeopleStack extension.
	PeopleStackPersonExtendedData *SocialGraphWireProtoPeopleapiExtensionPeopleStackPersonExtendedData `json:"peopleStackPersonExtendedData,omitempty"`

	// PlayGamesExtendedData: For use with Play Games Product Profile
	// extension. See go/jam-games-profile. The play games profile will be
	// returned only for profile-centric requests.
	PlayGamesExtendedData *AppsPeopleOzExternalMergedpeopleapiPlayGamesExtendedData `json:"playGamesExtendedData,omitempty"`

	// TlsIsPlaceholder: For use with the TLS extension and lookup by email.
	// If true, no person was actually found using the specified email
	// address, but we want to return TLS info about the email address
	// regardless. DEPRECATED: Use is_placeholder instead.
	TlsIsPlaceholder bool `json:"tlsIsPlaceholder,omitempty"`

	// YoutubeExtendedData: For use with Youtube extension.
	YoutubeExtendedData *AppsPeopleOzExternalMergedpeopleapiYoutubeExtendedData `json:"youtubeExtendedData,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AboutMeExtendedData")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AboutMeExtendedData") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiPersonExtendedData) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiPersonExtendedData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata: Metadata for
// a single Person field. See go/understanding-merged-person
type AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata struct {
	// AclChoices: When the container is PROFILE/DOMAIN_PROFILE and the
	// profile owner is the requester, this read-only, synthesized field
	// indicates which ACLs the user is allowed to set on the profile field.
	// This is distinct from field_acl, which is the field's currently set
	// ACL. field_acl will always be a valid ACL choice, except for the case
	// of default synthesized profile fields like monogram profile photos.
	// For those, field_acl does not represent a user-set field ACL, so it
	// may or may not be a valid choice. In all cases, default_acl_choice
	// will always be a valid choice. This is currently only populated on
	// the photo field when the "person.photo.metadata.acl_choices" mask is
	// set.
	AclChoices []*AppsPeopleOzExternalMergedpeopleapiFieldAcl `json:"aclChoices,omitempty"`

	// AdditionalContainerInfo: Additional information about the container
	// of this field.
	AdditionalContainerInfo *AppsPeopleOzExternalMergedpeopleapiAdditionalContainerInfo `json:"additionalContainerInfo,omitempty"`

	// Affinity: For field-level affinity scores. The affinity between the
	// requester and this particular field in the Person (e.g., frequency of
	// calling a particular phone number).
	Affinity []*AppsPeopleOzExternalMergedpeopleapiAffinity `json:"affinity,omitempty"`

	// ContactVisibility: Each field can have different visibility settings
	// Only returned when explicitly requested.
	//
	// Possible values:
	//   "CONTACT_VISIBILITY_UNSPECIFIED"
	//   "VISIBLE_TO_GUEST" - This can be set for annotation fields(e.g.
	// nicknames, relationship) that the user wants to expose to other
	// people in their household. Example use case: differentiate between
	// speed dial nicknames, regular nicknames and relationships
	ContactVisibility []string `json:"contactVisibility,omitempty"`

	// Container: DEPRECATED. Use container_type instead. Having the
	// Container be an enum at the PFM message level causes circular
	// dependency when other types try to refer to it. It breaks javascript
	// build targets.
	//
	// Possible values:
	//   "UNKNOWN"
	//   "PROFILE" - Google Profile. PROFILE fields are editable by the
	// profile owner, unless the field metadata includes writeable=false.
	//   "CONTACT" - Google Contact
	//   "CIRCLE" - Circle membership of non-g+ user.
	//   "PLACE" - A maps place
	//   "ACCOUNT" - The requester's own Gaia account. ACCOUNT fields are
	// not editable by anyone. They only occur when the requester is "me".
	// In the event an ACCOUNT field is ACLed non-private, it will be
	// returned as a PROFILE field when viewed by a requester who is not
	// "me".
	//   "EXTERNAL_ACCOUNT" - LinkedExternalSites
	// (go/PeopleApiConnectedSites)
	//   "DOMAIN_PROFILE" - Google-For-Work Profile. DOMAIN_PROFILE fields
	// are editable by the Dasher administrator of the domain. They are not
	// editable by the profile owner.
	//   "DOMAIN_CONTACT" - Domain shared contact
	//   "DEVICE_CONTACT" - To be deprecated in favor of RAW_DEVICE_CONTACT
	// See go/mergedperson-for-device-contacts Aggregation is represented
	// using person.metadata.device_contact_info
	//   "GOOGLE_GROUP" - Google group. Examples: sales@zara.es.
	//   "AFFINITY" - Data from the user's frequent interactions.
	//   "RAW_DEVICE_CONTACT" - Data from a raw (non-aggregated) device
	// contact. See go/mergedperson-for-device-contacts
	//   "CONTACT_ANNOTATION" - Data from contact annotation. Contact
	// annotations are currently generated and used by Google Assistant.
	//   "DELEGATED_CONTACT" - Data from delegated contacts. Delegated
	// contacts are the contacts delegated to the current requester. The
	// requester can then access those contacts. See go/ph-delegation.
	Container string `json:"container,omitempty"`

	// ContainerId: DEPRECATED. Use encoded_container_id instead. The
	// numeric id of the data source. The id is only unique within a single
	// container type. This is only set when the id of the container is
	// numeric, e.g. contact id.
	ContainerId int64 `json:"containerId,omitempty,string"`

	// ContainerPrimary: Indicates if this field is the primary field for
	// the container and container_id.
	ContainerPrimary bool `json:"containerPrimary,omitempty"`

	// ContainerType: The source for the data in the field.
	//
	// Possible values:
	//   "UNKNOWN_CONTAINER"
	//   "PROFILE" - Google Profile. PROFILE fields are editable by the
	// profile owner, unless the field metadata includes writeable=false.
	//   "CONTACT" - Google Contact
	//   "CIRCLE" - Deprecated. E-mail only circle membership should be
	// dead. E-mail only circle membership of non-g+ user.
	//   "PLACE" - A maps place
	//   "ACCOUNT" - The requester's own Gaia account. ACCOUNT fields are
	// not editable by anyone. They only occur when the requester is "me".
	// In the event an ACCOUNT field is ACLed non-private, it will be
	// returned as a PROFILE field when viewed by a requester who is not
	// "me".
	//   "EXTERNAL_ACCOUNT" - LinkedExternalSites
	// (go/PeopleApiConnectedSites)
	//   "DOMAIN_PROFILE" - Google-For-Work Profile. DOMAIN_PROFILE fields
	// are editable by the Dasher administrator of the domain. They are not
	// editable by the profile owner.
	//   "DOMAIN_CONTACT" - Domain shared contact. An entity that is owned
	// by a domain and represents a person, but is not a user in the domain.
	// For more details see https://support.google.com/a/answer/9281635.
	//   "DEVICE_CONTACT" - To be deprecated in favor of RAW_DEVICE_CONTACT
	// See go/mergedperson-for-device-contacts Aggregation is represented
	// using person.metadata.device_contact_info
	//   "GOOGLE_GROUP" - Google group. Examples: sales@zara.es.
	//   "NAMED_CHAT_ROOM" - Dynamite "Named Flat Room" (NFR). This is a
	// Baggins Roster with label DYNAMITE_SPACE *and* label
	// DYNAMITE_NAMED_SPACE. See go/people-api-concepts#chat-rooms
	//   "UNNAMED_CHAT_ROOM" - Dynamite "Unnamed Flat Room" (UFR). This is a
	// Baggins Roster with label DYNAMITE_SPACE but does *not* have label
	// DYNAMITE_NAMED_SPACE. See go/people-api-concepts#chat-rooms
	//   "AFFINITY" - Device contacts that are used in interaction ranking,
	// but have not been uploaded to Google. These are synthesized people
	// from interaction data. This container type is only used in
	// ListRankedPeople and ListRankedTargets actions. See
	// go/TopNWithClusteringPart1.
	//   "RAW_DEVICE_CONTACT" - Data from a raw (non-aggregated) device
	// contact. See go/mergedperson-for-device-contacts
	//   "CONTACT_ANNOTATION" - Data from contact annotation. Contact
	// annotations are currently generated and used by Google Assistant.
	//   "DELEGATED_CONTACT" - Data from delegated contacts. Delegated
	// contacts are the contacts delegated to the current requester. The
	// requester can then access those contacts. See go/ph-delegation.
	ContainerType string `json:"containerType,omitempty"`

	// CrossDeviceAllowed: True if this field can be used on other devices
	// than the one it originated from. Assigned by the server. Currently
	// only used for device contacts.
	CrossDeviceAllowed bool `json:"crossDeviceAllowed,omitempty"`

	// DefaultAclChoice: When the container is PROFILE/DOMAIN_PROFILE and
	// the profile owner is the requester, this read-only, synthesized field
	// contains the default ACL choice. This can be used to select a
	// preferred choice from acl_choices. Generally, default_acl_choice
	// should only be preferred for default synthesized profile fields like
	// monogram profile photos. Otherwise, the existing field_acl should be
	// preferred. This is currently only populated on the photo field when
	// the "person.photo.metadata.acl_choices" mask is set.
	DefaultAclChoice *AppsPeopleOzExternalMergedpeopleapiFieldAcl `json:"defaultAclChoice,omitempty"`

	// DeprecatedContactContainerId: DEPRECATED. Use container_id. Not
	// populated or used at all.
	DeprecatedContactContainerId int64 `json:"deprecatedContactContainerId,omitempty,string"`

	// EdgeKey: Field is an edge key for this person. Modifying it breaks
	// the link between data sources. This is equivalent to edge_key_info
	// having at least one entry with materialized = true.
	EdgeKey bool `json:"edgeKey,omitempty"`

	// EdgeKeyInfo: Edges that this field creates. This includes all edges
	// and not necessarily just the edge relevant to the joined entities.
	EdgeKeyInfo []*AppsPeopleOzExternalMergedpeopleapiEdgeKeyInfo `json:"edgeKeyInfo,omitempty"`

	// EncodedContainerId: The encoded id of the data source. The id is only
	// unique within a single container type. This field correlates to
	// person.metadata.identity_info.source_id.id. This field may not be
	// populated in some special cases, where the id is not visible to the
	// querying user. e.g. ListAutocompletions with full phone number query.
	// For value format, see
	// google3/social/graph/api/proto/main_merged_person.proto?q=symbol:Sourc
	// eIdentity.id
	EncodedContainerId string `json:"encodedContainerId,omitempty"`

	// FieldAcl: When the container is PROFILE and the profile owner is the
	// requester, this field indicates how the profile field is accessible.
	FieldAcl *AppsPeopleOzExternalMergedpeopleapiFieldAcl `json:"fieldAcl,omitempty"`

	// LastUpdateTime: Indicates the time that the field was added or last
	// edited. Currently this is populated for: (1) person.birthday with
	// ContainerType PROFILE, DOMAIN_PROFILE or ACCOUNT. (2) person.name,
	// person.address, person.relation, person.email and person.phone with
	// ContainerType CONTACT_ANNOTATION;
	LastUpdateTime string `json:"lastUpdateTime,omitempty"`

	// MatchingInfo: The matching informations if there was a query against
	// this field.
	MatchingInfo []*AppsPeopleOzExternalMergedpeopleapiMatchInfo `json:"matchingInfo,omitempty"`

	// OtherDedupedContainers: When deduping fields by value, list of
	// containers of the fields that where deduped.
	OtherDedupedContainers []*AppsPeopleOzExternalMergedpeopleapiDedupedContainerInfo `json:"otherDedupedContainers,omitempty"`

	// Primary: If true, indicates this field is the Person's primary field
	// eg. Contact, and (Profile) Person could have different Name fields,
	// and the Name represented by the Person is primary. For selecting a
	// primary field from RepeatedFields within a Person, use
	// container_primary.
	Primary bool `json:"primary,omitempty"`

	// ProductMetadata: The product(s) that generated the data in this
	// field. Empty is equivalent to DEFAULT. ST_USER_METADATA
	ProductMetadata []*AppsPeopleOzExternalMergedpeopleapiProductMetadata `json:"productMetadata,omitempty"`

	// Verified: Indicates whether this is a verified field. It is
	// synthesized from verification and is read-only. If there is at least
	// one verification with status PASSED, the field is considered
	// verified. Currently this is applicable to address, email, name, and
	// phone for PROFILE and DOMAIN_PROFILE. Use .metadata.verified in the
	// request mask.
	Verified bool `json:"verified,omitempty"`

	// Visibility: Currently, only people.get may set this value
	//
	// Possible values:
	//   "VISIBILITY_UNKNOWN"
	//   "PUBLIC" - The field is visible to every user.
	//   "USER" - The field is visible to the requester. The server cannot
	// provide additional indication beyond that. The field may or may not
	// be also visible to users other than the requester.
	Visibility string `json:"visibility,omitempty"`

	// Writeable: Whether the field is writeable to the requester.
	Writeable bool `json:"writeable,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AclChoices") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AclChoices") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiPersonListWithTotalNumber: A
// person list with total number specified.
type AppsPeopleOzExternalMergedpeopleapiPersonListWithTotalNumber struct {
	People []*AppsPeopleOzExternalMergedpeopleapiPerson `json:"people,omitempty"`

	// TotalNumber: The total number of people, which is aways no less than
	// the size of the above list.
	TotalNumber int64 `json:"totalNumber,omitempty"`

	// ForceSendFields is a list of field names (e.g. "People") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "People") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiPersonListWithTotalNumber) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiPersonListWithTotalNumber
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiPersonMetadata: Metadata for the
// entire Person resource.
type AppsPeopleOzExternalMergedpeopleapiPersonMetadata struct {
	// Affinity: Affinities associated with the person, with respect to the
	// requester.
	Affinity []*AppsPeopleOzExternalMergedpeopleapiAffinity `json:"affinity,omitempty"`

	// Attribution: Populated when the data for the MergedPerson comes from
	// a 3rd party provider or data source. Clients must display these
	// attributions to the user if they are present. NOTE: This field is
	// only relevant when requesting the following containers: - PLACE (data
	// read from Maps)
	Attribution []string `json:"attribution,omitempty"`

	// BestDisplayName: The best name to use for this person for user-facing
	// display. See go/people-api-howto:names for details about how this
	// field is computed. In many cases this will simply be Person.name[0].
	// However, Person.name returns only explicit Name fields, but other
	// fields maybe usable as a name (for example: nicknames, file_as, ...).
	// `best_display_name` will be calculated from all fields in storage
	// which are usable as a name, even fields which are not explicitly
	// requested in the MergedPerson result. See
	// go/javagoog/apps/tacotown/socialgraph/entity/PersonNameFormatter.java
	BestDisplayName *AppsPeopleOzExternalMergedpeopleapiBestDisplayName `json:"bestDisplayName,omitempty"`

	// BlockType: DEPRECATED. Indicates whether the profile owner has
	// blocked this person. Please use
	// `person.read_only_profile_info.block_type` instead.
	//
	// Possible values:
	//   "BLOCK_TYPE_UNKNOWN"
	//   "CIRCLE" - Profile-blocked users
	//   "LEGACY" - Chat-blocked users
	BlockType []string `json:"blockType,omitempty"`

	// CircleId: DEPRECATED. The circles the person belongs to.
	CircleId []string `json:"circleId,omitempty"`

	// ContactGroupId: DEPRECATED. Please use
	// `person.contact_group_memberships` instead. The contact groups the
	// person belongs to.
	ContactGroupId []string `json:"contactGroupId,omitempty"`

	// ContactId: The IDs of all contacts contributing to this person.
	ContactId googleapi.Int64s `json:"contactId,omitempty"`

	// CustomResponseMaskingType: DEPRECATED. Customized masking of the
	// response similar to the legacy People2RequestMask People2Params
	// request message. NOTE: This param is inherently client-specific,
	// limited to specific legacy clients, and not open to new usage. NOTE:
	// Effects may be applied to a subset of people in the response.
	//
	// Possible values:
	//   "UNKNOWN"
	//   "NONE" - No filtering of the response.
	//   "MENAGERIE" - Used by Menagerie to request menagerie-specific
	// custom filtering or masking on the response.
	CustomResponseMaskingType string `json:"customResponseMaskingType,omitempty"`

	// Deleted: For sync requests (i.e., changed since the provided
	// sync_token), indicates the resource is a tombstone for a Person
	// resource that has been entirely deleted.
	Deleted bool `json:"deleted,omitempty"`

	// DeprecatedBlocked: DEPRECATED. Please use
	// `person.read_only_profile_info.block_type` instead.
	DeprecatedBlocked bool `json:"deprecatedBlocked,omitempty"`

	// DeprecatedMembershipCircleId: DEPRECATED. This field is no longer
	// populated or read.
	DeprecatedMembershipCircleId googleapi.Int64s `json:"deprecatedMembershipCircleId,omitempty"`

	// DeprecatedMembershipContactGroupId: DEPRECATED. This field is no
	// longer populated or read.
	DeprecatedMembershipContactGroupId googleapi.Int64s `json:"deprecatedMembershipContactGroupId,omitempty"`

	// DeviceContactInfo: Info about the aggregated device contacts. When
	// the person contains RAW_DEVICE_CONTACT containers, each
	// DeviceContactInfo represents a single aggregate device contact made
	// up of one or more raw device contacts.
	DeviceContactInfo []*AppsPeopleOzExternalMergedpeopleapiDeviceContactInfo `json:"deviceContactInfo,omitempty"`

	// IdentityInfo: Detailed metadata about the lookup IDs and data sources
	// included in a MergedPerson result.
	IdentityInfo *AppsPeopleOzExternalMergedpeopleapiIdentityInfo `json:"identityInfo,omitempty"`

	// InViewerDomain: DEPRECATED. Indicates whether this person is in the
	// same domain as the viewer. For proxying trust between two users based
	// on organization membership, see: - go/flex-orgs-platform -
	// go/flex-orgs-compliance-handbook (especially
	// http://shortn/_ChwfAY36Ys)
	InViewerDomain bool `json:"inViewerDomain,omitempty"`

	// IncomingBlockType: DEPRECATED. Indicates whether this person is
	// blocking the profile owner. Please use
	// `person.read_only_profile_info.incoming_block_type` instead.
	//
	// Possible values:
	//   "BLOCK_TYPE_UNKNOWN"
	//   "CIRCLE" - Profile-blocked users
	//   "LEGACY" - Chat-blocked users
	IncomingBlockType []string `json:"incomingBlockType,omitempty"`

	// LastUpdateTimeMicros: DEPRECATED. The last update timestamps for the
	// constituent components of this person are available in
	// `identity_info.source_ids`. The time of the most recent change to
	// this person, in !!!NANOS!!! (due to a bug). May be a change to any of
	// the underlying parts of the person (profile, contact, etc.). Not
	// guaranteed to be the timestamp of the most recent change, due to
	// limitations in the backend. This field is not fully deprecated for
	// backend container-specific storage services like ProfileService which
	// lack identity_info. The use is still discouraged in such systems and
	// they should prefer to use the `last_update_time` field of this
	// message instead.
	LastUpdateTimeMicros int64 `json:"lastUpdateTimeMicros,omitempty,string"`

	// Model: The person model that is used to construct this person.
	//
	// Possible values:
	//   "PERSON_MODEL_UNKNOWN"
	//   "PROFILE_CENTRIC" - The default People API model where a person can
	// contain no more than one profile and potentially many contacts.
	//   "CONTACT_CENTRIC" - The inversion of the default profile-centric
	// model, i.e. a person can contain no more than one contact but
	// potentially many profiles. See go/contact-centric-person-model for
	// more details.
	Model string `json:"model,omitempty"`

	// ObjectType: DEPRECATED.
	//
	// Possible values:
	//   "OBJECT_TYPE_UNKNOWN"
	//   "PERSON"
	//   "PAGE"
	ObjectType string `json:"objectType,omitempty"`

	// OwnerId: DEPRECATED. Please use
	// `person.read_only_profile_info.owner_id` instead.
	OwnerId string `json:"ownerId,omitempty"`

	// OwnerUserType: DEPRECATED. See
	// `person.read_only_profile_info.owner_user_type` instead.
	//
	// Possible values:
	//   "OWNER_USER_TYPE_UNKNOWN"
	//   "GOOGLE_USER" - The owner is a Google user.
	//   "GPLUS_USER" - The owner is a Currents user.
	//   "GPLUS_DISABLED_BY_ADMIN" - Google+, i.e. INSServiceID::GOOGLE_ME
	// service, is disabled by dasher admin. Only returned for requester's
	// own profile.
	//   "GOOGLE_APPS_USER" - The owner is a Google Apps for Work user.
	//   "GOOGLE_APPS_SELF_MANAGED_USER" - The owner is a self-managed
	// Google Apps for Work user. Only returned for requester's own profile.
	//   "GOOGLE_FAMILY_USER" - The owner is a Google for Families user.
	// Only returned for requester's own profile.
	//   "GOOGLE_FAMILY_CHILD_USER" - The owner is a Google for Families
	// child user. Only returned for requester's own profile.
	//   "GOOGLE_APPS_ADMIN_DISABLED" - The owner has been disabled
	// (archived, suspended) by the G Suite admin.
	//   "GOOGLE_ONE_USER" - The owner is a Google One user (go/googleone).
	// Only returned for requester's own profile.
	//   "GOOGLE_FAMILY_CONVERTED_CHILD_USER" - The owner is a Google for
	// Families child user that was converted from an existing user. Only
	// returned for requester's own profile. (go/griffin-account)
	OwnerUserType []string `json:"ownerUserType,omitempty"`

	// PlusPageType: DEPRECATED. Please use `Person.plus_page_info` instead.
	//
	// Possible values:
	//   "PLUS_PAGE_TYPE_UNKNOWN"
	//   "LOCAL"
	//   "COMPANY"
	//   "BRAND"
	//   "CELEBRITY"
	//   "CAUSE"
	//   "ENTERTAINMENT"
	//   "OTHER"
	//   "OBSOLETE_PRIVATE" - Formerly a private madison
	// account(go/private-madison-account). Don't use it anymore.
	PlusPageType string `json:"plusPageType,omitempty"`

	// PreviousPersonId: DEPRECATED. This field is no longer populated or
	// read.
	PreviousPersonId []string `json:"previousPersonId,omitempty"`

	// ProfileOwnerStats: DEPRECATED. Stats/counters pertaining to followers
	// and incoming edges. Please use
	// `person.read_only_profile_info.profile_owner_stats` instead.
	ProfileOwnerStats *AppsPeopleOzExternalMergedpeopleapiProfileOwnerStats `json:"profileOwnerStats,omitempty"`

	// ScoringInfo: Contact people-directory-dev-team@ if you want to use
	// this field.
	ScoringInfo *AppsPeopleOzExternalMergedpeopleapiPersonMetadataScoringInfo `json:"scoringInfo,omitempty"`

	// UserVisibleStats: DEPRECATED. This field is no longer populated or
	// read.
	UserVisibleStats *AppsPeopleOzExternalMergedpeopleapiUserVisibleStats `json:"userVisibleStats,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Affinity") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Affinity") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiPersonMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiPersonMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiPersonMetadataScoringInfo struct {
	// RawMatchQualityScore: Only populated on a SearchDirectoryPeople call,
	// when results are scored. Contact people-directory-dev-team@ if you
	// want to use this field.
	RawMatchQualityScore float64 `json:"rawMatchQualityScore,omitempty"`

	// StExpressionResults: Only populated on a SearchDirectoryPeople call
	// that sends a request with StFieldSpecExpressions. - Used for linking
	// indexed terms with query terms for go/better-name-matching - Name
	// should be alphanumeric or underscores - Value should be an st
	// expression following the syntax at go/stsyntax Contact
	// people-directory-dev-team@ if you want to use this field.
	StExpressionResults []*AppsPeopleOzExternalMergedpeopleapiPersonMetadataScoringInfoStExpressionResult `json:"stExpressionResults,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "RawMatchQualityScore") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RawMatchQualityScore") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiPersonMetadataScoringInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiPersonMetadataScoringInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *AppsPeopleOzExternalMergedpeopleapiPersonMetadataScoringInfo) UnmarshalJSON(data []byte) error {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiPersonMetadataScoringInfo
	var s1 struct {
		RawMatchQualityScore gensupport.JSONFloat64 `json:"rawMatchQualityScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.RawMatchQualityScore = float64(s1.RawMatchQualityScore)
	return nil
}

type AppsPeopleOzExternalMergedpeopleapiPersonMetadataScoringInfoStExpressionResult struct {
	Name string `json:"name,omitempty"`

	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiPersonMetadataScoringInfoStExpressionResult) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiPersonMetadataScoringInfoStExpressionResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiPhone struct {
	// CanonicalizedForm: Canonicalized form that follows ITU-T E.164
	// international public telecommunication numbering plan.
	CanonicalizedForm string `json:"canonicalizedForm,omitempty"`

	// EmergencyInfo: Emergency information. See
	// go/emergency-trusted-contacts-papi.
	EmergencyInfo *AppsPeopleOzExternalMergedpeopleapiFieldEmergencyInfo `json:"emergencyInfo,omitempty"`

	// ExtendedData: Read-only. Field requested by specifying
	// `HANGOUTS_PHONE_DATA` in `extension_set.extension_names`.
	ExtendedData *AppsPeopleOzExternalMergedpeopleapiPhoneExtendedData `json:"extendedData,omitempty"`

	// FormattedType: The `type` translated and formatted in the request
	// locale. See go/people-api-howto/localization for details on how to
	// usage.
	FormattedType string `json:"formattedType,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// Type: The type of the phone number. The type can be free form or one
	// of these predefined values: * `home` * `work` * `mobile` * `homeFax`
	// * `workFax` * `otherFax` * `pager` * `workMobile` * `workPager` *
	// `main` * `googleVoice` * `other`
	Type string `json:"type,omitempty"`

	Uri string `json:"uri,omitempty"`

	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CanonicalizedForm")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CanonicalizedForm") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiPhone) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiPhone
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiPhoneExtendedData struct {
	// StructuredPhone: For use with Hangouts extension.
	StructuredPhone *AppsPeopleOzExternalMergedpeopleapiStructuredPhone `json:"structuredPhone,omitempty"`

	// ForceSendFields is a list of field names (e.g. "StructuredPhone") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "StructuredPhone") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiPhoneExtendedData) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiPhoneExtendedData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiPhoto struct {
	// Decoration: Read-only. Use UpdatePersonPhoto to change photo
	// decorations. If this photo is decorated, this field contains
	// information about its decorations. For now, this will contain at most
	// one entry.
	Decoration []*SocialGraphApiProtoDecorationOverlay `json:"decoration,omitempty"`

	// EmojiAvatarUrl: URL of an emoji avatar as an image. See go/emoji-cdn.
	// PeopleAPI will return the SVG format so that it can be scaled client
	// side and so that the images will not be animated. All clients that
	// use this field must also have fall-back handling for using the
	// `Photo.url` field if this is empty. When we have FIFE-compatible
	// emoji-image URLs we will drop this field and return the Photo.url
	// instead. Clients that have their own go/emoji-rendering integration
	// may prefer to render the emoji-avatar from `Photo.glyph` field using
	// their rendering system so that the emoji version/style match the rest
	// of the application. For further background, see
	// go/chatroom-avatar-as-roster-metadata. This field will only be
	// populated if all of: - The PersonFieldMetadata `container_type` for
	// the Photo is NAMED_CHAT_ROOM - The chat room has an emoji type avatar
	// image set
	EmojiAvatarUrl string `json:"emojiAvatarUrl,omitempty"`

	// Glyph: Unicode emoji representation of the chat room emoji avatar.
	// This can be used by clients that use go/emoji-rendering directly so
	// that they can present this with the same version/style as the rest of
	// their application. This value may also be useful to clients as
	// alt-text for the image. This field will only be populated if all of:
	// - The PersonFieldMetadata `container_type` for the Photo is
	// NAMED_CHAT_ROOM - The chat room has an emoji type avatar image set
	Glyph string `json:"glyph,omitempty"`

	// HtmlAttribution: A set of HTML data provider attributions that must
	// be shown with the result. Supported for PLACES photos only. See:
	// go/understanding-places-api-attribution-requirements
	HtmlAttribution []string `json:"htmlAttribution,omitempty"`

	// IsDefault: True when the photo is synthetic or generated (i.e. a
	// monogram or default photo), false when the person has a custom photo.
	IsDefault bool `json:"isDefault,omitempty"`

	// IsMonogram: Indicates if the photo is a monogram avatar. Combined
	// with is_default, the type of photo can be determined by:
	// is_default=true, is_monogram=true: Default monogram avatar.
	// is_default=true, is_monogram=false: Default silhouette avatar.
	// is_default=false: Custom photo. is_monogram is irrelevant in this
	// case.
	IsMonogram bool `json:"isMonogram,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// MonogramBackground: When is_monogram=true, this is the background
	// color of the monogram photo as a hex RGB formatted string "RRGGBB".
	MonogramBackground string `json:"monogramBackground,omitempty"`

	// OriginalPhoto: Read-only. A reference to the original, undecorated
	// profile photo in storage. This field is not stored. It is populated
	// by a live read to /SocialGraphImageService.GetActiveProfilePhoto.
	// This field is only returned when "person.photo.original_photo" is
	// specified in the request mask.
	OriginalPhoto *SocialGraphApiProtoImageReference `json:"originalPhoto,omitempty"`

	// PhotoId: For writes only. Indicates photo content for person
	// photo-field update. Currently only used for profile-photo updates
	// (not contact photos yet).
	PhotoId *AppsPeopleOzExternalMergedpeopleapiPhotoPhotoStorageId `json:"photoId,omitempty"`

	// PhotoToken: Most clients don't need to worry about this field and
	// should just use the `url` to fetch the photo. See
	// go/phototoken-migration-plan for some more context about this field.
	// If you think you want to use this please talk with people-api-eng@
	// first.
	PhotoToken string `json:"photoToken,omitempty"`

	// Url: See go/people-api-concepts/photos for info on the different
	// representations of URLs.
	Url string `json:"url,omitempty"`

	// ViewerUrl: A URL for a UI to view the photo in its original context.
	// For example, for a place photo, this is the url of a Google Maps page
	// displaying the photo. Supported for place photos only.
	ViewerUrl string `json:"viewerUrl,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Decoration") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Decoration") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiPhoto) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiPhoto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiPhotoPhotoStorageId: Info
// necessary for looking up a photo in storage.
type AppsPeopleOzExternalMergedpeopleapiPhotoPhotoStorageId struct {
	// MediaKey: For writes only, pass the media key that represents the
	// image in photos backend. Note, this is not populated on reads.
	MediaKey string `json:"mediaKey,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MediaKey") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MediaKey") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiPhotoPhotoStorageId) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiPhotoPhotoStorageId
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiPlaceDetails: Metadata specific to
// places.
type AppsPeopleOzExternalMergedpeopleapiPlaceDetails struct {
	// GoogleUrl: A URL hosted by Google providing more information about
	// this place This is the URL returned by Places API in the
	// Place.Url.google field
	GoogleUrl string `json:"googleUrl,omitempty"`

	LatLng *AppsPeopleOzExternalMergedpeopleapiLatLng `json:"latLng,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	OpeningHours *AppsPeopleOzExternalMergedpeopleapiOpeningHours `json:"openingHours,omitempty"`

	// PrimaryTypeName: The name of the primary type. Examples of primary
	// type are: "art_school", "clothing_wholesaler", etc. All primary types
	// can be found at http://shortn/_veqh6UwWdc
	PrimaryTypeName string `json:"primaryTypeName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GoogleUrl") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GoogleUrl") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiPlaceDetails) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiPlaceDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiPlayGamesExtendedData: Extension
// data for use in Play Games Product Profile. See go/jam-games-profile.
type AppsPeopleOzExternalMergedpeopleapiPlayGamesExtendedData struct {
	// Achievements: User's top achievements that are sorted for example by
	// rarity.
	Achievements []*AppsPeopleOzExternalMergedpeopleapiPlayGamesExtendedDataAchievement `json:"achievements,omitempty"`

	// AvatarImageUrl: The avatar image to display for the user.
	AvatarImageUrl string `json:"avatarImageUrl,omitempty"`

	// Failure: Failure type if there is an error when fetching product
	// profile data.
	Failure *AppsPeopleOzExternalMergedpeopleapiProductProfileFailure `json:"failure,omitempty"`

	// GamerTag: The gamer tag set by the user. Not set if the user hasn't
	// set a gamer tag yet.
	GamerTag string `json:"gamerTag,omitempty"`

	// PlayerLevel: User's level.
	PlayerLevel int64 `json:"playerLevel,omitempty"`

	// ProfileVisibility: Specifies the visibility of the player's profile.
	//
	// Possible values:
	//   "UNKNOWN_CLIENT_PLAYER_PROFILE_VISIBILITY" - Safe default.
	//   "PRIVATE_VISIBILITY" - The profile is not visible to anyone but the
	// player themselves.
	//   "PUBLIC_VISIBILITY" - The profile is visible to everyone.
	//   "FRIENDS_VISIBILITY" - The profile is visible to the player and
	// their PGS friends.
	ProfileVisibility string `json:"profileVisibility,omitempty"`

	// TotalFriendsCount: Total number of friends.
	TotalFriendsCount int64 `json:"totalFriendsCount,omitempty,string"`

	// TotalUnlockedAchievements: How many achievements this player has
	// unlocked.
	TotalUnlockedAchievements int64 `json:"totalUnlockedAchievements,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Achievements") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Achievements") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiPlayGamesExtendedData) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiPlayGamesExtendedData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiPlayGamesExtendedDataAchievement:
// Details of an achievement that the user has unlocked.
type AppsPeopleOzExternalMergedpeopleapiPlayGamesExtendedDataAchievement struct {
	// AchievementName: The name of the achievement.
	AchievementName string `json:"achievementName,omitempty"`

	// AchievementUnlockedIconUrl: The achievement icon url shown to the
	// user if it is unlocked.
	AchievementUnlockedIconUrl string `json:"achievementUnlockedIconUrl,omitempty"`

	// RarityPercentage: Rarity of unlocking this achievement (3% of players
	// unlocked would be 3)
	RarityPercentage float64 `json:"rarityPercentage,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AchievementName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AchievementName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiPlayGamesExtendedDataAchievement) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiPlayGamesExtendedDataAchievement
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *AppsPeopleOzExternalMergedpeopleapiPlayGamesExtendedDataAchievement) UnmarshalJSON(data []byte) error {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiPlayGamesExtendedDataAchievement
	var s1 struct {
		RarityPercentage gensupport.JSONFloat64 `json:"rarityPercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.RarityPercentage = float64(s1.RarityPercentage)
	return nil
}

// AppsPeopleOzExternalMergedpeopleapiPlusPageInfo: Information about a
// plus page and the entity it represents.
type AppsPeopleOzExternalMergedpeopleapiPlusPageInfo struct {
	// ApplicationId: Int64 ID of packaging-service entry; if set, the plus
	// page is associated with a third-party application.
	ApplicationId int64 `json:"applicationId,omitempty,string"`

	// Possible values:
	//   "ENTITY_TYPE_UNSPECIFIED"
	//   "LOCAL" - These are the top-level entity types for plus pages.
	//   "COMPANY"
	//   "BRAND"
	//   "CELEBRITY"
	//   "CAUSE"
	//   "ENTERTAINMENT"
	//   "OTHER"
	//   "OBSOLETE_PRIVATE" - Used to identify a private madison
	// account(go/private-madison-account). Don't use it anymore.
	EntityType string `json:"entityType,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ApplicationId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApplicationId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiPlusPageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiPlusPageInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiPointSpec: Map marker location for
// an address.
type AppsPeopleOzExternalMergedpeopleapiPointSpec struct {
	Bounds *GeostoreRectProto `json:"bounds,omitempty"`

	Point *GeostorePointProto `json:"point,omitempty"`

	// Possible values:
	//   "UNKNOWN_POINT_SOURCE"
	//   "POINT_SOURCE_UNSPECIFIED"
	//   "USER_PROVIDED" - User has explicitly moved the point.
	//   "SYSTEM_PROVIDED" - System has generated the marker.
	//   "USER_CONFIRMED" - System has generated the marker, but user has
	// viewed and saved it unchanged.
	PointSource string `json:"pointSource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Bounds") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Bounds") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiPointSpec) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiPointSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiPosixAccount: Custom field that
// represents POSIX account information. Description of the field
// family: go/fbs-posix. If account has non-empty Username or Uid we
// will enforce global uniqueness of (AccountNamespace, CustomerKey,
// SystemId, Uid) and (AccountNamespace, CustomerKey, SystemId,
// Username) tuples to ensure there are no duplicates.
type AppsPeopleOzExternalMergedpeopleapiPosixAccount struct {
	// AccountId: The user visible value is used to distinguish identical
	// posix account fields with different customer key values.
	AccountId string `json:"accountId,omitempty"`

	// AccountNamespace: Value indicates the uniqueness namespace that
	// applies to the POSIX information. The value is included in all POSIX
	// account uniqueness indices. The indexing prevents two accounts within
	// the same customer from having the same username. Namespacing allows
	// Windows and Linux users to share the same username.
	//
	// Possible values:
	//   "LINUX_GSUITE" - A Linux user for a G Suite domain.
	//   "LINUX_CONSUMER" - A Linux user for a Google account.
	//   "WINDOWS_GSUITE" - A Windows user for a G Suite domain.
	//   "WINDOWS_CONSUMER" - A Windows user for a Google account.
	AccountNamespace string `json:"accountNamespace,omitempty"`

	// AccountType: Value indicates whether the POSIX information is
	// associated with a non-human entity and the validation logic to apply
	// during PosixAccount mutation.
	//
	// Possible values:
	//   "LINUX_USER_ACCOUNT" - Linux account associated with a human user.
	//   "LINUX_SERVICE_ACCOUNT" - Linux account for a non-human entity.
	// Service accounts are used for unattended automation scripts. See
	// go/riseoftherobots for details.
	//   "LINUX_EXTERNAL_USER" - Linux account associated with a human user
	// where the owner of the POSIX data is granted access to resources
	// (VMs) owned by a different (external) organization.
	//   "WINDOWS_USER_ACCOUNT" - Windows account associated with a human
	// user.
	//   "WINDOWS_SERVICE_ACCOUNT" - Windows account for a non-human entity.
	// Service accounts are used for unattended automation scripts.
	//   "WINDOWS_EXTERNAL_USER" - Windows account associated with a human
	// user where the owner of the account data is granted access to
	// resources (VMs) owned by a different (external) organization.
	AccountType string `json:"accountType,omitempty"`

	// CustomerKey: The customer associated with the POSIX identity. If the
	// user is already associated with a G Suite Customer, this field has
	// the same value as
	// http://google3/ccc/hosted/policies/settings/dthree_customer_info.proto
	CustomerKey int64 `json:"customerKey,omitempty,string"`

	// Fingerprint: The value is automatically set to a SHA-256 fingerprint
	// of the POSIX account. A fingerprint should uniquely identify a POSIX
	// account entry.
	Fingerprint string `json:"fingerprint,omitempty"`

	// Gecos: The GECOS (user information) entry for this account.
	Gecos string `json:"gecos,omitempty"`

	// Gid: The default group ID.
	Gid uint64 `json:"gid,omitempty,string"`

	// HomeDirectory: The path to the home directory for this account.
	HomeDirectory string `json:"homeDirectory,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// OperatingSystemType: Value indicates whether to use Linux or Windows
	// specific validation logic during PosixAccount mutation.
	//
	// Possible values:
	//   "OPERATING_SYSTEM_TYPE_UNSPECIFIED" - The operating system type
	// associated with the user account information is unspecified.
	//   "LINUX" - Linux user account information.
	//   "WINDOWS" - Windows user account information.
	OperatingSystemType string `json:"operatingSystemType,omitempty"`

	// Shell: The path to the login shell for this account.
	Shell string `json:"shell,omitempty"`

	// SystemId: System identifier for which account Username or Uid apply
	// to. If not specified on mutate by a caller it will default to empty
	// value if either Username or Uid are being set. SystemId does require
	// to have a value (even an empty one) because it is included into
	// null-filtered Spanner index used to enforce uniqueness on Username
	// and Uid fields.
	SystemId string `json:"systemId,omitempty"`

	// Uid: The user ID.
	Uid uint64 `json:"uid,omitempty,string"`

	// Username: The username of the account.
	Username string `json:"username,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccountId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiPosixAccount) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiPosixAccount
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiProductMetadata struct {
	// Possible values:
	//   "PRODUCT_SOURCE_UNKNOWN"
	//   "PRODUCT_SOURCE_DEFAULT"
	//   "PRODUCT_SOURCE_ASSISTANT"
	//   "PRODUCT_SOURCE_JANATA" - The product for non-prominent people
	// creating their profiles and sharing contact info on Google search
	// (go/project-janata).
	//   "PRODUCT_SOURCE_SPEED_DIAL"
	ProductSource string `json:"productSource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ProductSource") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ProductSource") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiProductMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiProductMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiProductProfileFailure: Product
// profiles failure type: the status of the rpc to fetch the product
// profile.
type AppsPeopleOzExternalMergedpeopleapiProductProfileFailure struct {
	// Possible values:
	//   "PRODUCT_PROFILE_FAILURE_TYPE_UNKNOWN"
	//   "RPC_FAILURE"
	FailureType string `json:"failureType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FailureType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FailureType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiProductProfileFailure) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiProductProfileFailure
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiProfileOwnerStats: Stats
// pertaining to incoming edges and views, visible to the requester
// (with acls applied). Related to, but not equal to,
// com.google.focus.proto.Storage.UserVisibleStats.
type AppsPeopleOzExternalMergedpeopleapiProfileOwnerStats struct {
	// IncomingAnyCircleCount: Replacement for deprecated follower_count.
	// Comes from the EdgeSummary.
	IncomingAnyCircleCount int64 `json:"incomingAnyCircleCount,omitempty,string"`

	// ViewCount: Deprecated. This field is no longer populated by the
	// server.
	ViewCount int64 `json:"viewCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g.
	// "IncomingAnyCircleCount") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IncomingAnyCircleCount")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiProfileOwnerStats) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiProfileOwnerStats
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiProfileUrl: This is a Google+-only
// field (and thus does not exist for consumer users). See
// go/fbs-g+-deprecation.
type AppsPeopleOzExternalMergedpeopleapiProfileUrl struct {
	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	Url string `json:"url,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Metadata") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiProfileUrl) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiProfileUrl
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiPronoun: Message to represent a
// user's set of preferred pronouns, see go/pronouns-backend.
type AppsPeopleOzExternalMergedpeopleapiPronoun struct {
	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	PronounData *SocialGraphApiProtoPronounData `json:"pronounData,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Metadata") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiPronoun) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiPronoun
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiRawDeviceContactAnalyticalInfo struct {
	// DataSet: The data set within the account that this raw contact
	// belongs to.
	DataSet string `json:"dataSet,omitempty"`

	// Dirty: The CP2 dirty field which indicates the sync state of the raw
	// contact:
	// https://developer.android.com/reference/android/provider/ContactsContract.SyncColumns#DIRTY
	// True if the row is changed but not synced
	Dirty bool `json:"dirty,omitempty"`

	// SourceIdExist: Whether the source ID exists for non-Google contacts.
	// Won't set for Google contacts.
	SourceIdExist bool `json:"sourceIdExist,omitempty"`

	// SyncInfo: The Sync Info of a raw contact.
	SyncInfo *SocialGraphApiProtoSyncInfo `json:"syncInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DataSet") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataSet") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiRawDeviceContactAnalyticalInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiRawDeviceContactAnalyticalInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiRawDeviceContactInfo: Raw device
// contact information.
type AppsPeopleOzExternalMergedpeopleapiRawDeviceContactInfo struct {
	// AccountName: Account name of raw contact, e.g. "google@gmail.com".
	AccountName string `json:"accountName,omitempty"`

	// AccountType: Account type of raw contact, e.g. "com.google" or
	// "com.linkedin.android".
	AccountType string `json:"accountType,omitempty"`

	// AppContactData: The detailed app-specific endpoint data available for
	// the given RawDeviceContactInfo instance. This proto should be used to
	// obtain the list of actions and mimetypes supported by the third-party
	// app. Design: go/3p-contact-upload
	AppContactData []*SocialGraphApiAppContactData `json:"appContactData,omitempty"`

	// AppInfo: The app-specific endpoint data needed for app action
	// fulfillment. Usage of this field should be avoided on the
	// server-side, and should use the more detailed |full_app_info| field.
	AppInfo *AppsPeopleOzExternalMergedpeopleapiAppUniqueInfo `json:"appInfo,omitempty"`

	// CrossDeviceAllowed: If true, this raw contact can be used on other
	// devices than the one it originated from. Assigned by the server.
	CrossDeviceAllowed bool `json:"crossDeviceAllowed,omitempty"`

	// DeviceContactMetadata: Extra metadata for this raw contact.
	DeviceContactMetadata *AppsPeopleOzExternalMergedpeopleapiDeviceContactExtraMetadata `json:"deviceContactMetadata,omitempty"`

	// GoogleContactId: The focus contact id for Google contacts.
	GoogleContactId int64 `json:"googleContactId,omitempty,string"`

	// Id: The base64 serialized
	// social.graph.peopleapi.proto.internal.RawDeviceContactId. This id
	// should be used to correlate to field.metadata.encoded_container_id
	// when the field.metadata.container_type is RAW_DEVICE_CONTACT The id
	// also correlates to person.metadata.identity_info.source_id.id. For
	// value format, see
	// google3/social/graph/api/proto/main_merged_person.proto?q=symbol:Sourc
	// eIdentity.id
	Id string `json:"id,omitempty"`

	// PhotoType: The type of photo from the device (if any).
	//
	// Possible values:
	//   "PHOTO_TYPE_UNKNOWN"
	//   "NO_PHOTO" - This raw contact doesn't have a photo.
	//   "THUMBNAIL" - This raw contact only has a thumbnail.
	//   "FULL_SIZE_PHOTO" - This raw contact has a full size photo.
	PhotoType string `json:"photoType,omitempty"`

	// RawContactId: The id of the raw contact on the device.
	RawContactId int64 `json:"rawContactId,omitempty,string"`

	// RawDeviceContactAnalyticalInfo: Only to be used by Romanesco team
	// specifically for analytics.
	RawDeviceContactAnalyticalInfo *AppsPeopleOzExternalMergedpeopleapiRawDeviceContactAnalyticalInfo `json:"rawDeviceContactAnalyticalInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccountName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiRawDeviceContactInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiRawDeviceContactInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiReadOnlyProfileInfo: Metadata
// information about a profile. This message replaces legacy
// profile-specific singleton fields from the PersonMetadata proto
// (singleton top level Person fields are not compatible with
// non-profile-centric person results, which may include multiple
// profile containers).
type AppsPeopleOzExternalMergedpeopleapiReadOnlyProfileInfo struct {
	// AccountEmail: The account email linked to the profile, if any exists
	// and is visible to the requester.
	AccountEmail *AppsPeopleOzExternalMergedpeopleapiAccountEmail `json:"accountEmail,omitempty"`

	// BlockType: Indicates whether the profile owner has blocked this
	// person.
	//
	// Possible values:
	//   "BLOCK_TYPE_UNKNOWN"
	//   "CIRCLE" - Profile-blocked users
	//   "LEGACY" - Chat-blocked users
	BlockType []string `json:"blockType,omitempty"`

	// CustomerInfo: CustomerInfo for dasher user. The reader has to
	// explicitly request this in the field_mask as
	// 'read_only_profile_info.customer_info'
	CustomerInfo *AppsPeopleOzExternalMergedpeopleapiCustomerInfo `json:"customerInfo,omitempty"`

	// DomainInfo: DEPRECATED. Use the `ReadOnlyProfileInfo.customer_info`
	// field instead (b/138120418). Only populated if in_viewer_domain is
	// true.
	DomainInfo *AppsPeopleOzExternalMergedpeopleapiReadOnlyProfileInfoDomainInfo `json:"domainInfo,omitempty"`

	// InViewerDomain: DEPRECATED. Proxying trust between users in a domain
	// should use go/flex-orgs-platform. For more info see:
	// http://doc/18i0-C7vWcz2UuXYBsmulnriVCK3_EuMPpRlPa2OmMHw#heading=h.dobotdwx25kg
	// Indicates whether the profile owner is in the same domain as the
	// viewer.
	InViewerDomain bool `json:"inViewerDomain,omitempty"`

	// IncomingBlockType: Indicates whether this person is blocking the
	// profile owner.
	//
	// Possible values:
	//   "BLOCK_TYPE_UNKNOWN"
	//   "CIRCLE" - Profile-blocked users
	//   "LEGACY" - Chat-blocked users
	IncomingBlockType []string `json:"incomingBlockType,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// ObjectType: DEPRECATED.
	//
	// Possible values:
	//   "OBJECT_TYPE_UNKNOWN"
	//   "PERSON"
	//   "PAGE"
	ObjectType string `json:"objectType,omitempty"`

	// OwnerId: The Focus-obfuscated Gaia ID of the profile owner
	// (go/obfuscated-ids).
	OwnerId string `json:"ownerId,omitempty"`

	// Possible values:
	//   "OWNER_USER_TYPE_UNKNOWN"
	//   "GOOGLE_USER" - The owner is a Google user.
	//   "GPLUS_USER" - The owner is a Currents user.
	//   "GPLUS_DISABLED_BY_ADMIN" - Google+, i.e. INSServiceID::GOOGLE_ME
	// service, is disabled by dasher admin. Only returned for requester's
	// own profile.
	//   "GOOGLE_APPS_USER" - The owner is a Google Apps for Work user.
	//   "GOOGLE_APPS_SELF_MANAGED_USER" - The owner is a self-managed
	// Google Apps for Work user. Only returned for requester's own profile.
	//   "GOOGLE_FAMILY_USER" - The owner is a Google for Families user.
	// Only returned for requester's own profile.
	//   "GOOGLE_FAMILY_CHILD_USER" - The owner is a Google for Families
	// child user. Only returned for requester's own profile.
	//   "GOOGLE_APPS_ADMIN_DISABLED" - The owner has been disabled
	// (archived, suspended) by the G Suite admin.
	//   "GOOGLE_ONE_USER" - The owner is a Google One user (go/googleone).
	// Only returned for requester's own profile.
	//   "GOOGLE_FAMILY_CONVERTED_CHILD_USER" - The owner is a Google for
	// Families child user that was converted from an existing user. Only
	// returned for requester's own profile. (go/griffin-account)
	OwnerUserType []string `json:"ownerUserType,omitempty"`

	// PlusPageType: DEPRECATED. Please use `person.plus_page_info` instead.
	//
	// Possible values:
	//   "PLUS_PAGE_TYPE_UNKNOWN"
	//   "LOCAL"
	//   "COMPANY"
	//   "BRAND"
	//   "CELEBRITY"
	//   "CAUSE"
	//   "ENTERTAINMENT"
	//   "OTHER"
	//   "OBSOLETE_PRIVATE" - Formerly a private madison
	// account(go/private-madison-account). Don't use it anymore.
	PlusPageType string `json:"plusPageType,omitempty"`

	// ProfileOwnerStats: Stats/counters pertaining to followers and
	// incoming edges.
	ProfileOwnerStats *AppsPeopleOzExternalMergedpeopleapiProfileOwnerStats `json:"profileOwnerStats,omitempty"`

	// UnjoinedEmailCertificates: Returned only when explicitly requested in
	// the request mask as
	// read_only_profile_info.unjoined_email_certificates. Equivalent to
	// fetching the Emails & the Email Certificates with the acls ignored.
	UnjoinedEmailCertificates []*AppsPeopleOzExternalMergedpeopleapiEmail `json:"unjoinedEmailCertificates,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccountEmail") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountEmail") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiReadOnlyProfileInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiReadOnlyProfileInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiReadOnlyProfileInfoDomainInfo:
// DEPRECATED.
type AppsPeopleOzExternalMergedpeopleapiReadOnlyProfileInfoDomainInfo struct {
	// DomainBadge: DEPRECATED. Organization badge for the domain this
	// person is a member of. The badge is the primary hosted domain.
	DomainBadge []string `json:"domainBadge,omitempty"`

	// DomainName: DEPRECATED. Hosted domain this person is a member of.
	// Formerly only available via PersonExtendedData.
	DomainName []string `json:"domainName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DomainBadge") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DomainBadge") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiReadOnlyProfileInfoDomainInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiReadOnlyProfileInfoDomainInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiRelation: Relation stores the
// related person between the contact or profile and a third person. See
// go/relation-vs-relationship for relation vs relationship explanation.
// This field currently includes RelationshipToMe data in fields value
// and canonical_value for ContainerType CONTACT_ANNOTATION. This will
// be moved to RelationshipToMe in b/221081499.
type AppsPeopleOzExternalMergedpeopleapiRelation struct {
	// CanonicalValue: Canonicalized `value` of the relation from this
	// person to the user. This is currently used for data from contact
	// annotations. Possible canonical values are based from
	// http://google3/googledata/quality/aliases/relationship_en.config.
	CanonicalValue string `json:"canonicalValue,omitempty"`

	// FormattedType: The `type` translated and formatted in the request
	// locale. See go/people-api-howto/localization for details on how to
	// usage.
	FormattedType string `json:"formattedType,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// RelationDetails: The person whose email matches the Relation.value
	// field, if it is a valid email address. This field is read-only and
	// ignored on update.
	RelationDetails *AppsPeopleOzExternalMergedpeopleapiRelationRelationDetails `json:"relationDetails,omitempty"`

	// Type: The relation type. The type can be free form or one of these
	// predefined values: * `spouse` * `child` * `mother` * `father` *
	// `parent` * `brother` * `sister` * `friend` * `relative` *
	// `domesticPartner` * `manager` * `assistant` * `referredBy` *
	// `partner`
	Type string `json:"type,omitempty"`

	// Value: The person this relation applies to. Custom value provided by
	// the user.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CanonicalValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CanonicalValue") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiRelation) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiRelation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiRelationRelationDetails struct {
	// DisplayName: Equivalent to Name.display_name for the person_id
	// profile.
	DisplayName string `json:"displayName,omitempty"`

	// JobTitle: Equivalent to Organization.title for the primary
	// organization of the person_id profile.
	JobTitle string `json:"jobTitle,omitempty"`

	PersonId string `json:"personId,omitempty"`

	// PhotoUrl: Equivalent to Photo.url for the person_id profile.
	PhotoUrl string `json:"photoUrl,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiRelationRelationDetails) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiRelationRelationDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiRelationshipInterest: Deprecated
// in b/122464133. No data returned for this field.
type AppsPeopleOzExternalMergedpeopleapiRelationshipInterest struct {
	// FormattedType: The `type` translated and formatted in the request
	// locale. See go/people-api-howto/localization for details on how to
	// usage.
	FormattedType string `json:"formattedType,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// Type: These fields may give away the sexual orientation of the user.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FormattedType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FormattedType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiRelationshipInterest) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiRelationshipInterest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiRelationshipStatus: Deprecated in
// b/122464133. No data returned for this field.
type AppsPeopleOzExternalMergedpeopleapiRelationshipStatus struct {
	// FormattedType: The `type` translated and formatted in the request
	// locale. See go/people-api-howto/localization for details on how to
	// usage.
	FormattedType string `json:"formattedType,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FormattedType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FormattedType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiRelationshipStatus) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiRelationshipStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiRightOfPublicityState: User
// preference for shared endorsements. See go/se-devguide and
// go/sharedendorsements for details, including guidance on which
// contexts are which.
type AppsPeopleOzExternalMergedpeopleapiRightOfPublicityState struct {
	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "NOT_OK_TO_DISPLAY" - OK to display in non-commercial contexts, but
	// not in commercial ones.
	//   "OK_TO_DISPLAY" - Okay to display in commercial or advertising
	// contexts.
	//   "OK_TO_DISPLAY_IN_NON_ADS_COMMERCIAL_CONTEXT" - Okay to display in
	// commercial contexts other than advertising.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Metadata") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiRightOfPublicityState) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiRightOfPublicityState
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiRosterDetails: Information
// specific to rosters like Google Groups and Chatrooms.
type AppsPeopleOzExternalMergedpeopleapiRosterDetails struct {
	// AbridgedRosterMemberships: Abridged / sample subset of member details
	// of the roster. NOTE: This field is only returned if the request's
	// field mask includes
	// "person.roster_details.abridged_roster_memberships".
	// http://cs/symbol:google.apps.cloudidentity.groups.internal.GroupSummary.abridged_memberships
	AbridgedRosterMemberships []*AppsPeopleOzExternalMergedpeopleapiRosterMember `json:"abridgedRosterMemberships,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// RosterMemberCount: Indicates the number of members and sub-rosters of
	// the roster. Corresponds to
	// http://cs/symbol:google.apps.cloudidentity.groups.internal.Group.direct_member_count_per_type
	RosterMemberCount *AppsPeopleOzExternalMergedpeopleapiRosterMemberCount `json:"rosterMemberCount,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AbridgedRosterMemberships") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AbridgedRosterMemberships") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiRosterDetails) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiRosterDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiRosterMember: Represents details
// of a member of a roster. Used in RosterDetails. Corresponds to
// http://cs/symbol:google.apps.cloudidentity.groups.internal.Membership
type AppsPeopleOzExternalMergedpeopleapiRosterMember struct {
	// MemberType: Type of the member.
	//
	// Possible values:
	//   "ROSTER_MEMBER_TYPE_UNSPECIFIED"
	//   "PERSON" - CIG's Membership.Type.USER
	//   "ROSTER" - CIG's Membership.Type.GROUP
	MemberType string `json:"memberType,omitempty"`

	// PersonId: Focus-Obfuscated Gaia Id of the member.
	PersonId string `json:"personId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MemberType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MemberType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiRosterMember) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiRosterMember
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiRosterMemberCount: Represents the
// summary of member counts of a roster. Used in RosterDetails.
// Corresponds to
// http://cs/symbol:google.apps.cloudidentity.groups.internal.Group.DirectMemberCountPerType
type AppsPeopleOzExternalMergedpeopleapiRosterMemberCount struct {
	// DirectGroupCount: Indicates the number of direct sub-rosters of the
	// roster. This comes from
	// http://cs/symbol:google.apps.cloudidentity.groups.internal.Group.DirectMemberCountPerType.group_count
	DirectGroupCount int64 `json:"directGroupCount,omitempty,string"`

	// DirectUserCount: Indicates the number of direct, non-roster members
	// of the roster. This comes from
	// http://cs/symbol:google.apps.cloudidentity.groups.internal.Group.DirectMemberCountPerType.user_count
	DirectUserCount int64 `json:"directUserCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "DirectGroupCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DirectGroupCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiRosterMemberCount) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiRosterMemberCount
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiSearchProfile: Profile for Janata
// and Search. go/janata-profile-in-sgbe
type AppsPeopleOzExternalMergedpeopleapiSearchProfile struct {
	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	SearchProfileData *SocialGraphApiProtoSearchProfileData `json:"searchProfileData,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Metadata") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiSearchProfile) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiSearchProfile
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiSipAddress: As of 03/2018 is not
// supported for user Profile.
type AppsPeopleOzExternalMergedpeopleapiSipAddress struct {
	// FormattedType: The `type` translated and formatted in the request
	// locale. See go/people-api-howto/localization for details on how to
	// usage.
	FormattedType string `json:"formattedType,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// Type: The type of the SIP address. The type can be free form or or
	// one of these predefined values: * `home` * `work` * `mobile` *
	// `other`
	Type string `json:"type,omitempty"`

	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FormattedType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FormattedType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiSipAddress) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiSipAddress
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiSkills struct {
	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Metadata") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiSkills) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiSkills
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiSocialConnection: The social
// connection of this person to the viewer. NOTE: this is used by
// go/starlight, but not actually used or returned in PeopleAPI. See
// b/27281119 for context.
type AppsPeopleOzExternalMergedpeopleapiSocialConnection struct {
	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// Possible values:
	//   "SOCIAL_CONNECTION_UNKNOWN"
	//   "NO_CONNECTION" - This person is not connected to the viewer.
	//   "GPLUS_SECOND_HOP" - Google+ user is a second hop relative to
	// viewer.
	//   "DIRECT_CONNECTION" - User is a contact or in circles of the
	// viewer.
	//   "SELF" - This person is the viewer.
	Type []string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Metadata") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiSocialConnection) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiSocialConnection
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiSortKeys struct {
	Affinity []*AppsPeopleOzExternalMergedpeopleapiAffinity `json:"affinity,omitempty"`

	// InteractionRank: Deprecated. This field is only populated with 0.000
	// for legacy reasons. Clients should not use this field.
	InteractionRank string `json:"interactionRank,omitempty"`

	LastName string `json:"lastName,omitempty"`

	LastNameRaw string `json:"lastNameRaw,omitempty"`

	Name string `json:"name,omitempty"`

	// NameRaw: Raw name strings that were used to generate the name and
	// last_name sort keys fields above. Contacts+ need them to generate
	// section headers for list view (b/30642866).
	NameRaw string `json:"nameRaw,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Affinity") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Affinity") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiSortKeys) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiSortKeys
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiSourceIdentity: Id of a single
// source from the merged person.
type AppsPeopleOzExternalMergedpeopleapiSourceIdentity struct {
	// Container: The type of source. To be deprecated infavor of
	// container_type
	//
	// Possible values:
	//   "UNKNOWN"
	//   "PROFILE" - Google Profile. PROFILE fields are editable by the
	// profile owner, unless the field metadata includes writeable=false.
	//   "CONTACT" - Google Contact
	//   "CIRCLE" - Circle membership of non-g+ user.
	//   "PLACE" - A maps place
	//   "ACCOUNT" - The requester's own Gaia account. ACCOUNT fields are
	// not editable by anyone. They only occur when the requester is "me".
	// In the event an ACCOUNT field is ACLed non-private, it will be
	// returned as a PROFILE field when viewed by a requester who is not
	// "me".
	//   "EXTERNAL_ACCOUNT" - LinkedExternalSites
	// (go/PeopleApiConnectedSites)
	//   "DOMAIN_PROFILE" - Google-For-Work Profile. DOMAIN_PROFILE fields
	// are editable by the Dasher administrator of the domain. They are not
	// editable by the profile owner.
	//   "DOMAIN_CONTACT" - Domain shared contact
	//   "DEVICE_CONTACT" - To be deprecated in favor of RAW_DEVICE_CONTACT
	// See go/mergedperson-for-device-contacts Aggregation is represented
	// using person.metadata.device_contact_info
	//   "GOOGLE_GROUP" - Google group. Examples: sales@zara.es.
	//   "AFFINITY" - Data from the user's frequent interactions.
	//   "RAW_DEVICE_CONTACT" - Data from a raw (non-aggregated) device
	// contact. See go/mergedperson-for-device-contacts
	//   "CONTACT_ANNOTATION" - Data from contact annotation. Contact
	// annotations are currently generated and used by Google Assistant.
	//   "DELEGATED_CONTACT" - Data from delegated contacts. Delegated
	// contacts are the contacts delegated to the current requester. The
	// requester can then access those contacts. See go/ph-delegation.
	Container string `json:"container,omitempty"`

	// ContainerType: The type of the source.
	//
	// Possible values:
	//   "UNKNOWN_CONTAINER"
	//   "PROFILE" - Google Profile. PROFILE fields are editable by the
	// profile owner, unless the field metadata includes writeable=false.
	//   "CONTACT" - Google Contact
	//   "CIRCLE" - Deprecated. E-mail only circle membership should be
	// dead. E-mail only circle membership of non-g+ user.
	//   "PLACE" - A maps place
	//   "ACCOUNT" - The requester's own Gaia account. ACCOUNT fields are
	// not editable by anyone. They only occur when the requester is "me".
	// In the event an ACCOUNT field is ACLed non-private, it will be
	// returned as a PROFILE field when viewed by a requester who is not
	// "me".
	//   "EXTERNAL_ACCOUNT" - LinkedExternalSites
	// (go/PeopleApiConnectedSites)
	//   "DOMAIN_PROFILE" - Google-For-Work Profile. DOMAIN_PROFILE fields
	// are editable by the Dasher administrator of the domain. They are not
	// editable by the profile owner.
	//   "DOMAIN_CONTACT" - Domain shared contact. An entity that is owned
	// by a domain and represents a person, but is not a user in the domain.
	// For more details see https://support.google.com/a/answer/9281635.
	//   "DEVICE_CONTACT" - To be deprecated in favor of RAW_DEVICE_CONTACT
	// See go/mergedperson-for-device-contacts Aggregation is represented
	// using person.metadata.device_contact_info
	//   "GOOGLE_GROUP" - Google group. Examples: sales@zara.es.
	//   "NAMED_CHAT_ROOM" - Dynamite "Named Flat Room" (NFR). This is a
	// Baggins Roster with label DYNAMITE_SPACE *and* label
	// DYNAMITE_NAMED_SPACE. See go/people-api-concepts#chat-rooms
	//   "UNNAMED_CHAT_ROOM" - Dynamite "Unnamed Flat Room" (UFR). This is a
	// Baggins Roster with label DYNAMITE_SPACE but does *not* have label
	// DYNAMITE_NAMED_SPACE. See go/people-api-concepts#chat-rooms
	//   "AFFINITY" - Device contacts that are used in interaction ranking,
	// but have not been uploaded to Google. These are synthesized people
	// from interaction data. This container type is only used in
	// ListRankedPeople and ListRankedTargets actions. See
	// go/TopNWithClusteringPart1.
	//   "RAW_DEVICE_CONTACT" - Data from a raw (non-aggregated) device
	// contact. See go/mergedperson-for-device-contacts
	//   "CONTACT_ANNOTATION" - Data from contact annotation. Contact
	// annotations are currently generated and used by Google Assistant.
	//   "DELEGATED_CONTACT" - Data from delegated contacts. Delegated
	// contacts are the contacts delegated to the current requester. The
	// requester can then access those contacts. See go/ph-delegation.
	ContainerType string `json:"containerType,omitempty"`

	// Deleted: In sync responses, indicates whether the identity source has
	// been deleted. Not applicable to GOOGLE_GROUP.
	Deleted bool `json:"deleted,omitempty"`

	// Id: The encoded id of the data source. This field correlates to
	// PersonFieldMetadata.encoded_container_id. The possible values of this
	// `id` field are as follows based on the value of the `container_type`
	// field: CONTACT: Hex-encoded contact id. PROFILE: DOMAIN_PROFILE:
	// GOOGLE_GROUP: NAMED_CHAT_ROOM: Focus-obfuscated Gaia ID.
	// DOMAIN_CONTACT: Synthetic-contact id representing the domain shared
	// contact. PLACE: Encoded PlaceId
	// (go/javagoog/maps/api/places/util/PlaceIdEncoder.java)
	// RAW_DEVICE_CONTACT: Pair of device_id and raw_contact_id, encoded as
	// base64 serialized
	// social.graph.peopleapi.proto.internal.RawDeviceContactId proto.
	// CONTACT_ANNOTATION: Pair of annotation_id and event_timestamp,
	// encoded as base64 serialized
	// social.graph.peopleapi.proto.internal.ContactAnnotationId proto. --
	// DEPRECATED container types -- If the container is CIRCLE, then the id
	// is going to be the synthetic- contact id representing the email-only
	// circle member or gaia circle member for which the requester does not
	// have a contact for.
	Id string `json:"id,omitempty"`

	// LastUpdated: Last update timestamp of this source. NOTE: Only
	// populated for CONTACT container type in Java PeopleAPI. Populated for
	// CONTACT, PROFILE, DOMAIN_PROFILE in Sharpen implementation. NOTE: Not
	// populated for GOOGLE_GROUP.
	LastUpdated string `json:"lastUpdated,omitempty"`

	// LastUpdatedMicros: **DEPRECATED** Please use `last_updated` field
	// instead. Last update timestamp of this source in microseconds. NOTE:
	// Only populated for CONTACT container type.
	LastUpdatedMicros int64 `json:"lastUpdatedMicros,omitempty,string"`

	// SourceEtag: NOTE: Not populated for GOOGLE_GROUP.
	SourceEtag string `json:"sourceEtag,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Container") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Container") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiSourceIdentity) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiSourceIdentity
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiSshPublicKey: Custom field that
// represents SSH public keys associated with the user. We can treat the
// field as a map from a string fingerprint to the SSH public key
// information.
type AppsPeopleOzExternalMergedpeopleapiSshPublicKey struct {
	ExpirationTime string `json:"expirationTime,omitempty"`

	// Fingerprint: The value is automatically set to a SHA-256 fingerprint
	// of an SSH public key. A fingerprint should uniquely identify an SSH
	// public key.
	Fingerprint string `json:"fingerprint,omitempty"`

	Key string `json:"key,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExpirationTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExpirationTime") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiSshPublicKey) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiSshPublicKey
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiStructuredPhone: This message
// mirrors the ContactPhoneNumber message in
// ccc/grand_central/common/types.proto. For various reasons, we cannot
// take on a direct dependency. See other proto file for most recent
// documentation.
type AppsPeopleOzExternalMergedpeopleapiStructuredPhone struct {
	// FormattedType: The phone formatted type. See docs from mirrored
	// proto:
	// http://google3/ccc/grand_central/common/types.proto?l=128&rcl=241000760
	FormattedType string `json:"formattedType,omitempty"`

	PhoneNumber *AppsPeopleOzExternalMergedpeopleapiStructuredPhonePhoneNumber `json:"phoneNumber,omitempty"`

	ShortCode *AppsPeopleOzExternalMergedpeopleapiStructuredPhoneShortCode `json:"shortCode,omitempty"`

	// Type: The type of phone. See docs from mirrored proto:
	// http://google3/ccc/grand_central/common/types.proto?l=125&rcl=241000760
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FormattedType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FormattedType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiStructuredPhone) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiStructuredPhone
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiStructuredPhonePhoneNumber struct {
	E164 string `json:"e164,omitempty"`

	I18nData *AppsPeopleOzExternalMergedpeopleapiStructuredPhonePhoneNumberI18nData `json:"i18nData,omitempty"`

	// ForceSendFields is a list of field names (e.g. "E164") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "E164") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiStructuredPhonePhoneNumber) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiStructuredPhonePhoneNumber
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiStructuredPhonePhoneNumberI18nData struct {
	CountryCode int64 `json:"countryCode,omitempty"`

	InternationalNumber string `json:"internationalNumber,omitempty"`

	IsValid bool `json:"isValid,omitempty"`

	NationalNumber string `json:"nationalNumber,omitempty"`

	RegionCode string `json:"regionCode,omitempty"`

	// Possible values:
	//   "UNKNOWN"
	//   "IS_POSSIBLE"
	//   "INVALID_COUNTRY_CODE"
	//   "TOO_SHORT"
	//   "TOO_LONG"
	//   "IS_POSSIBLE_LOCAL_ONLY"
	//   "INVALID_LENGTH"
	ValidationResult string `json:"validationResult,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CountryCode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CountryCode") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiStructuredPhonePhoneNumberI18nData) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiStructuredPhonePhoneNumberI18nData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiStructuredPhoneShortCode struct {
	// Code: The phone code. See docs from mirrored proto:
	// http://google3/ccc/grand_central/common/types.proto?l=70&rcl=241000760
	Code string `json:"code,omitempty"`

	CountryCode string `json:"countryCode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiStructuredPhoneShortCode) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiStructuredPhoneShortCode
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiTagline struct {
	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Metadata") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiTagline) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiTagline
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiTeamsExtendedData: *UNSUPPORTED*.
// This message is never populated and is no longer used.
type AppsPeopleOzExternalMergedpeopleapiTeamsExtendedData struct {
	AdminTo []*AppsPeopleOzExternalMergedpeopleapiPerson `json:"adminTo,omitempty"`

	Admins []*AppsPeopleOzExternalMergedpeopleapiPerson `json:"admins,omitempty"`

	DottedLineManagers []*AppsPeopleOzExternalMergedpeopleapiPerson `json:"dottedLineManagers,omitempty"`

	DottedLineReports *AppsPeopleOzExternalMergedpeopleapiPersonListWithTotalNumber `json:"dottedLineReports,omitempty"`

	// Possible values:
	//   "UNKNOWN_FAILURE"
	//   "MANAGEMENT_CHAIN"
	//   "REPORTS"
	//   "DOTTED_LINE_REPORTS"
	//   "DOTTED_LINE_MANAGERS"
	//   "ADMINS"
	//   "ADMIN_TO"
	Failures []string `json:"failures,omitempty"`

	ManagementChain []*AppsPeopleOzExternalMergedpeopleapiPerson `json:"managementChain,omitempty"`

	Reports *AppsPeopleOzExternalMergedpeopleapiPersonListWithTotalNumber `json:"reports,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdminTo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdminTo") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiTeamsExtendedData) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiTeamsExtendedData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiUserDefined struct {
	Key string `json:"key,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiUserDefined) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiUserDefined
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiUserVisibleStats: DEPRECATED in
// favor of ProfileStats. Stats pertaining to incoming edges and views,
// visible to the requester (with acls applied). Related to, but not
// equal to, com.google.focus.proto.Storage.UserVisibleStats.
type AppsPeopleOzExternalMergedpeopleapiUserVisibleStats struct {
	// IncomingAnyCircleCount: Replacement for deprecated follower_count.
	// Comes from the EdgeSummary.
	IncomingAnyCircleCount int64 `json:"incomingAnyCircleCount,omitempty,string"`

	ViewCount int64 `json:"viewCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g.
	// "IncomingAnyCircleCount") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IncomingAnyCircleCount")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiUserVisibleStats) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiUserVisibleStats
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiVisibleToGuests: Store metadata
// information like annotation-id and product source for visible to
// guests contacts go/visible-to-guests.
type AppsPeopleOzExternalMergedpeopleapiVisibleToGuests struct {
	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Metadata") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiVisibleToGuests) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiVisibleToGuests
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiWebContactsExtendedData struct {
	// IsIncomplete: Used by Contacts client-side to indicate whether a
	// person is not completed.
	IsIncomplete bool `json:"isIncomplete,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IsIncomplete") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IsIncomplete") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiWebContactsExtendedData) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiWebContactsExtendedData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiWebsite struct {
	// FormattedType: The `type` translated and formatted in the request
	// locale. See go/people-api-howto/localization for details on how to
	// usage.
	FormattedType string `json:"formattedType,omitempty"`

	Metadata *AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata `json:"metadata,omitempty"`

	// Rel: Currently in Oz: "Links": Links with no rel. "Other profiles":
	// Links with rel=ME. "Contributor to": Links with rel=CONTRIBUTOR_TO or
	// PAST_CONTRIBUTOR_TO.
	Rel []*AppsPeopleOzExternalMergedpeopleapiWebsiteRelationshipInfo `json:"rel,omitempty"`

	// Type: The type of the website. The type can be free form or one of
	// these predefined values: * `home` * `work` * `blog` * `profile` *
	// `homePage` * `ftp` * `reservations` * `appInstallPage`: website for a
	// Currents application. * `other`
	Type string `json:"type,omitempty"`

	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FormattedType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FormattedType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiWebsite) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiWebsite
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AppsPeopleOzExternalMergedpeopleapiWebsiteRelationshipInfo struct {
	// Possible values:
	//   "UNKNOWN"
	//   "ME" - rel="me"
	//   "NOT_ME" - rel=""
	//   "CONTRIBUTOR_TO" - rel="contributor-to"
	//   "PAST_CONTRIBUTOR_TO" - rel="past-contributor-to"
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Type") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Type") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiWebsiteRelationshipInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiWebsiteRelationshipInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AppsPeopleOzExternalMergedpeopleapiYoutubeExtendedData: Extension
// data for use in Youtube Product Profile.
type AppsPeopleOzExternalMergedpeopleapiYoutubeExtendedData struct {
	// ChannelData: Information about a channel created by the user. A user
	// can create multiple Youtube channels.
	ChannelData []*AppsPeopleOzExternalMergedpeopleapiChannelData `json:"channelData,omitempty"`

	// Failure: Failure type if there is an error when fetching product
	// profile data.
	Failure *AppsPeopleOzExternalMergedpeopleapiProductProfileFailure `json:"failure,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ChannelData") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ChannelData") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AppsPeopleOzExternalMergedpeopleapiYoutubeExtendedData) MarshalJSON() ([]byte, error) {
	type NoMethod AppsPeopleOzExternalMergedpeopleapiYoutubeExtendedData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiActionV2SupportedFeatures: The features supported by the
// ActionV2 protocol. Note that after we move on to ConversationProto
// for all surfaces we can remove this message.
type AssistantApiActionV2SupportedFeatures struct {
	// ExpressUrlInSettingsResponseSupported: This flag is used to work
	// around a bug in AGSA 6.8 that got away. The bug prevents users from
	// accessing their shopping list if the URL of the shopping list is not
	// a keep.google.com URL. This will happen when switch the backend that
	// stores the shopping list from Keep to a backend maintained by the
	// Google Shopping Express team.
	ExpressUrlInSettingsResponseSupported bool `json:"expressUrlInSettingsResponseSupported,omitempty"`

	// ReconnectClientInputSupported: Whether client supports reconnect
	// client input in action v2 payload. This capability is needed to
	// determine if client supports parsing client input payload from
	// actionv2 proto for workflow purposes. See go/personal-workflow.
	// OWNER:nyzstar,vvvemuri.
	ReconnectClientInputSupported bool `json:"reconnectClientInputSupported,omitempty"`

	// SimpleActionV2PuntSupported: Whether or not the surface supports a
	// simple UnsupportedAction instead of a ModalState punt card for
	// rendering. For ActionV2 punt cards, the ModalState extension on the
	// ResourceSet is the canonical way of building punt cards. However,
	// while most all devices support the ActionV2 protocol, not all devices
	// handle the ModalState rendering as part of the ActionV2. For these
	// devices, we want to build a modified ActionV2 for punt cards which
	// omits this ModalState. At present, this is only Android Wear and
	// should not be used for other devices if they support ModalState or
	// Conversation protocol.
	SimpleActionV2PuntSupported bool `json:"simpleActionV2PuntSupported,omitempty"`

	// SupportedActionType: A list of all the action types supported by the
	// client. These should be the string representation of
	// majel.ActionTypes within "quality/majel/api/proto/action_v2.proto".
	SupportedActionType []string `json:"supportedActionType,omitempty"`

	// TakeScreenshotSupported: Checks if screenshots can be taken on the
	// client. This field is set on the client from AGSA 7.2 onwards.
	TakeScreenshotSupported bool `json:"takeScreenshotSupported,omitempty"`

	// VoiceDelightImmersiveUiSupported: If IMMERSIVE_ACTIONS UiType is
	// supported by the client.
	VoiceDelightImmersiveUiSupported bool `json:"voiceDelightImmersiveUiSupported,omitempty"`

	// VoiceDelightStickersSupported: If Voice Delight Stickers are
	// supported by the client. In order to support Voice Delight stickers,
	// the client should know how to extract sticker_url from
	// VoiceDelightSystemInteractionSegment.
	VoiceDelightStickersSupported bool `json:"voiceDelightStickersSupported,omitempty"`

	// VoiceDelightSuggestionsSupported: If Voice Delight Suggestion Chips
	// are supported by the client. In order to support Voice Delight
	// Suggestion Chips, the client should know how to extract suggestions
	// form VoiceDelightSystemInteraction.ResourceSet.
	VoiceDelightSuggestionsSupported bool `json:"voiceDelightSuggestionsSupported,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ExpressUrlInSettingsResponseSupported") to unconditionally include
	// in API requests. By default, fields with empty or default values are
	// omitted from API requests. However, any non-pointer, non-interface
	// field appearing in ForceSendFields will be sent to the server
	// regardless of whether the field is empty or not. This may be used to
	// include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "ExpressUrlInSettingsResponseSupported") to include in API requests
	// with the JSON null value. By default, fields with empty values are
	// omitted from API requests. However, any field with an empty value
	// appearing in NullFields will be sent to the server as null. It is an
	// error if a field in this list has a non-empty value. This may be used
	// to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiActionV2SupportedFeatures) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiActionV2SupportedFeatures
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiAndroidIntentCapabilities: Capabilities related to
// Android intent support. These capabilities can apply to any device on
// the Android platform. Provides the list of Android package names that
// support a given Android intent.
type AssistantApiAndroidIntentCapabilities struct {
	AndroidIntentCapability []*AssistantApiAndroidIntentCapabilitiesAndroidIntentCapability `json:"androidIntentCapability,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AndroidIntentCapability") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AndroidIntentCapability")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiAndroidIntentCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiAndroidIntentCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiAndroidIntentCapabilitiesAndroidIntentCapability struct {
	// IntentActionName: The Action name of the Android Intent in standard
	// notation
	// (https://developer.android.com/reference/android/content/Intent#getAction()).
	IntentActionName string `json:"intentActionName,omitempty"`

	// PackageNames: The Android provider packages that support the intent,
	// e.g. "com.google.android.deskclock".
	PackageNames []string `json:"packageNames,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IntentActionName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IntentActionName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiAndroidIntentCapabilitiesAndroidIntentCapability) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiAndroidIntentCapabilitiesAndroidIntentCapability
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiAppCapabilities: Used to describe app capabilities of the
// device installed apps reported to the server.
type AssistantApiAppCapabilities struct {
	// AllowlistedForMediaFulfillment: Indicates whether the provider is
	// compatible for media fulfillment on this surface. For example, Amazon
	// Music isn't compatible with the driving mode.
	AllowlistedForMediaFulfillment bool `json:"allowlistedForMediaFulfillment,omitempty"`

	// AppIntegrationsSettings: Currently unused. Will be used in the future
	// when integrating with incremental app capabilities.
	AppIntegrationsSettings *AssistantApiAppIntegrationsSettings `json:"appIntegrationsSettings,omitempty"`

	// DisabledSystemApp: This system app is disabled in settings.
	DisabledSystemApp bool `json:"disabledSystemApp,omitempty"`

	// Provider: The installed app of the provider.
	Provider *AssistantApiCoreTypesProvider `json:"provider,omitempty"`

	// RoutableToProviderCloud: This provider has integrated its cloud
	// backend with Google, and Google can route the user queries to the
	// provider's cloud.
	RoutableToProviderCloud bool `json:"routableToProviderCloud,omitempty"`

	// SearchableOnDevice: This provider has an app that supports on-device
	// search through the provider's own inventory.
	SearchableOnDevice bool `json:"searchableOnDevice,omitempty"`

	// SearchableOnServer: This provider has integrated its content with
	// Google, and Google has enabled to serve its content as a server-side
	// solution.
	SearchableOnServer bool `json:"searchableOnServer,omitempty"`

	// SupportsScreenlessInitiation: This provider has an app that supports
	// starting new media playback when there is no screen (e.g. by
	// integrating with the Bisto SDK).
	SupportsScreenlessInitiation bool `json:"supportsScreenlessInitiation,omitempty"`

	// WhitelistedForAnnotation: This provider is an app which should be
	// used for query annotations. This is useful for apps which may not be
	// already indexed by Google or are client specific.
	WhitelistedForAnnotation bool `json:"whitelistedForAnnotation,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AllowlistedForMediaFulfillment") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AllowlistedForMediaFulfillment") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiAppCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiAppCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiAppCapabilitiesDelta: Used to describe the incremental
// change of app capabilities of the device installed apps reported to
// the server.
type AssistantApiAppCapabilitiesDelta struct {
	// AppIntegrationsSettings: Currently unused. Will be used in the future
	// when integrating with incremental app capabilities.
	AppIntegrationsSettings *AssistantApiAppIntegrationsSettings `json:"appIntegrationsSettings,omitempty"`

	// ProviderDelta: The installed app of the provider.
	ProviderDelta *AssistantApiCoreTypesProviderDelta `json:"providerDelta,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AppIntegrationsSettings") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AppIntegrationsSettings")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiAppCapabilitiesDelta) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiAppCapabilitiesDelta
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiAppControlSupport struct {
	// Possible values:
	//   "DEFAULT_DISABLED" - Disable all app control capabilities.
	//   "ENABLED_WITH_SMART_DICTATION" - Enable app control SD-dependent
	// capabilities.
	Enabled string `json:"enabled,omitempty"`

	// SendMessageSuppressed: If true, disable send message AppControl/SD
	// flow. This is needed to suppress the feature for specific device. If
	// we decide to turn down this feature for all devices, then this field
	// will become obsolete and should be removed. See context in
	// b/275727627.
	SendMessageSuppressed bool `json:"sendMessageSuppressed,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Enabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiAppControlSupport) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiAppControlSupport
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiAppIntegrationsSettings: Contains the app privacy bits
// used for App Integrations implicit request.
// (go/app-privacy-settings-for-implicit-requests)
type AssistantApiAppIntegrationsSettings struct {
	// HandleRequestsWithPredictedApps: Whether to enable Assistant to
	// handle request with predicted apps.
	//
	// Possible values:
	//   "UNSET"
	//   "FALSE"
	//   "TRUE"
	HandleRequestsWithPredictedApps string `json:"handleRequestsWithPredictedApps,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "HandleRequestsWithPredictedApps") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "HandleRequestsWithPredictedApps") to include in API requests with
	// the JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiAppIntegrationsSettings) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiAppIntegrationsSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiAssistantContinuedPresenceSupport struct {
	// PlateSupport: Indicates in what cases assistant continued presence
	// can be shown as a plate. This field is white-listed as being
	// PII-free. Please do not add PII here.
	//
	// Possible values:
	//   "DEFAULT_NO_PLATE" - Assistant continued presence cannot be shown.
	//   "SEARCH_ONLY" - Assistant continued presence can be shown only in
	// SearchNowActivity. See go/lockhart-acp.
	PlateSupport string `json:"plateSupport,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PlateSupport") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PlateSupport") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiAssistantContinuedPresenceSupport) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiAssistantContinuedPresenceSupport
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiAudioInput: These capabilities represent the audio input
// features associated with the device. This includes what kind of audio
// input the device can handle, and what the privacy circumstances of
// that input are.
type AssistantApiAudioInput struct {
	// Possible values:
	//   "SURROUNDING_USERS" - Audio may be produced by or visible to any
	// users in the vicinity of the authenticated user -- e.g., a speaker.
	// NOTE that this is the default value since it's better to assume that
	// the user is in public when they're not than vice versa.
	//   "AUTHENTICATED_USER_ONLY" - Audio can be assumed to come from or go
	// to the authenticated user -- e.g., the mic or headphone on a phone or
	// headset.
	Environment string `json:"environment,omitempty"`

	// Possible values:
	//   "VOICE_QUALITY" - An audio device capable of handling audio at
	// fidelity high enough for voice use (TTS, speech recognition,
	// telephone) but insufficient for media playback.
	//   "MUSIC_QUALITY" - An audio device capable of handling high-fidelity
	// audio, suitable for use as a media device.
	Quality string `json:"quality,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Environment") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Environment") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiAudioInput) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiAudioInput
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiAudioOutput: These capabilities represent the audio
// output features associated with the device. This includes what kind
// of audio output the device can handle, and what the privacy
// circumstances of that output are.
type AssistantApiAudioOutput struct {
	// Possible values:
	//   "UNKNOWN" - The setting for always on speaker is unknown.
	//   "NOT_SUPPORTED" - Always on speaker is not supported.
	//   "SUPPORTED" - Always on speaker is supported.
	AlwaysOnSpeaker string `json:"alwaysOnSpeaker,omitempty"`

	// Possible values:
	//   "SURROUNDING_USERS" - Audio may be produced by or visible to any
	// users in the vicinity of the authenticated user -- e.g., a speaker.
	// NOTE that this is the default value since it's better to assume that
	// the user is in public when they're not than vice versa.
	//   "AUTHENTICATED_USER_ONLY" - Audio can be assumed to come from or go
	// to the authenticated user -- e.g., the mic or headphone on a phone or
	// headset.
	Environment string `json:"environment,omitempty"`

	// Possible values:
	//   "MEDIA_TTS_MIXABLE_UNKNOWN" - Unknown whether device supports
	// mixing TTS and device media.
	//   "MEDIA_TTS_MIXABLE_NOT_SUPPORTED" - Device cannot mix TTS and
	// device media.
	//   "MEDIA_TTS_MIXABLE_SUPPORTED" - Device can mix TTS and device
	// media.
	MediaTtsMixable string `json:"mediaTtsMixable,omitempty"`

	// Possible values:
	//   "VOICE_QUALITY" - An audio device capable of handling audio at
	// fidelity high enough for voice use (TTS, speech recognition,
	// telephone) but insufficient for media playback.
	//   "MUSIC_QUALITY" - An audio device capable of handling high-fidelity
	// audio, suitable for use as a media device.
	Quality string `json:"quality,omitempty"`

	VolumeProperties *AssistantApiVolumeProperties `json:"volumeProperties,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AlwaysOnSpeaker") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AlwaysOnSpeaker") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiAudioOutput) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiAudioOutput
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiBluetoothCapabilities: Bluetooth capabilities related to
// usage of a feature.
type AssistantApiBluetoothCapabilities struct {
	// IsBluetoothConnectedProfileRequired: If this surface needs to
	// bluetooth pair a phone before using a feature.
	IsBluetoothConnectedProfileRequired bool `json:"isBluetoothConnectedProfileRequired,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "IsBluetoothConnectedProfileRequired") to unconditionally include in
	// API requests. By default, fields with empty or default values are
	// omitted from API requests. However, any non-pointer, non-interface
	// field appearing in ForceSendFields will be sent to the server
	// regardless of whether the field is empty or not. This may be used to
	// include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "IsBluetoothConnectedProfileRequired") to include in API requests
	// with the JSON null value. By default, fields with empty values are
	// omitted from API requests. However, any field with an empty value
	// appearing in NullFields will be sent to the server as null. It is an
	// error if a field in this list has a non-empty value. This may be used
	// to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiBluetoothCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiBluetoothCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCallCapabilities: CallCapabilities supported by a
// surface. See go/call-capabilities. Next ID: 7
type AssistantApiCallCapabilities struct {
	// CallFormats: The supported call formats on the surface.
	//
	// Possible values:
	//   "UNSPECIFIED_FORMAT"
	//   "AUDIO"
	//   "VIDEO"
	//   "TEXT"
	CallFormats []string `json:"callFormats,omitempty"`

	// CallMediums: The supported call mediums on the surface.
	//
	// Possible values:
	//   "UNSPECIFIED_MEDIUM"
	//   "PSTN" - Public Switched Telephone Network.
	//   "VOIP" - Voice Over IP.
	//   "EMAIL"
	//   "ONLINE_CHAT"
	//   "TEXT_MESSAGING" - Super set of SMS and MMS
	//   "MESSAGE" - Super set of EMAIL, ONLINE_CHAT, TEXT_MESSAGING
	CallMediums []string `json:"callMediums,omitempty"`

	// CallOptions: The call options this surface can provide. For example,
	// SPEAKERPHONE is available on Android OPA while iOPA doesn't support
	// it yet.
	//
	// Possible values:
	//   "UNSPECIFIED_CALL_OPTION"
	//   "SPEAKERPHONE"
	//   "BLUETOOTH"
	//   "HEADSET"
	CallOptions []string `json:"callOptions,omitempty"`

	// FallbackToTetheredDeviceAppCapabilities: If true, APP_ID queries
	// initiated by this device should fall back to execution on the
	// tethered device if it's available and if the primary device cannot
	// perform the action (e.g. due to the app not being installed).
	FallbackToTetheredDeviceAppCapabilities bool `json:"fallbackToTetheredDeviceAppCapabilities,omitempty"`

	// SupportedRecipientTypes: Should only be checked if nonempty.
	//
	// Possible values:
	//   "UNSPECIFIED_ENDPOINT"
	//   "PHONE_NUMBER"
	//   "EMAIL_ADDRESS"
	//   "APP_UNIQUE_ID"
	//   "EMERGENCY_PHONE_NUMBER"
	//   "VOICEMAIL"
	SupportedRecipientTypes []string `json:"supportedRecipientTypes,omitempty"`

	SupportsDuoEmailEndpoint bool `json:"supportsDuoEmailEndpoint,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CallFormats") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CallFormats") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCallCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCallCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCameraCapabilities: These capabilities represent the
// camera features associated with the device.
type AssistantApiCameraCapabilities struct {
	// FaceMatchCapable: Whether the device supports Face Match.
	FaceMatchCapable bool `json:"faceMatchCapable,omitempty"`

	// HasCamera: Whether the device has a camera.
	HasCamera bool `json:"hasCamera,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FaceMatchCapable") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FaceMatchCapable") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCameraCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCameraCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCameraReceiverCapabilities: These capabilities present
// the capability of the device running camera receiver apps.
type AssistantApiCameraReceiverCapabilities struct {
	// HasLimitedCameraStreamCapability: Whether the device has limited
	// camera stream capability. If true, check supported_camera_receivers
	// for detailed supported cameras.
	HasLimitedCameraStreamCapability bool `json:"hasLimitedCameraStreamCapability,omitempty"`

	// SupportedCameraReceivers: The camera receiver cast apps the device
	// supports. Only used if has_limited_camera_stream_capability is true.
	SupportedCameraReceivers []*AssistantApiCoreTypesCastAppInfo `json:"supportedCameraReceivers,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "HasLimitedCameraStreamCapability") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "HasLimitedCameraStreamCapability") to include in API requests with
	// the JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCameraReceiverCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCameraReceiverCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCarAssistantCapabilities: Capabilities that are
// associated with Assistants on auto surfaces. This is different from
// other capabilities such as CarSettingsCapabilities,
// CloudCarCapabilities since they are specific to settings and 3P cloud
// information. All the auto/car Assistant specific capabilities should
// live here.
type AssistantApiCarAssistantCapabilities struct {
	// ShouldPuntMultiAssistantMode: Indicates whether the current Assistant
	// should provide a multi Assistant specific punt when there are
	// multiple Auto specific Google Assistants (Android Auto Projected
	// (AAP) and Android Auto Embedded (AAE)) in the same GAS enabled car.
	// This will be used by both AAP and AAE. Design doc: go/doubledash++
	ShouldPuntMultiAssistantMode bool `json:"shouldPuntMultiAssistantMode,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ShouldPuntMultiAssistantMode") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "ShouldPuntMultiAssistantMode") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCarAssistantCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCarAssistantCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCarSettingsCapabilities: Capabilities that are associated
// with Assistant Settings on auto surfaces.
type AssistantApiCarSettingsCapabilities struct {
	// PlayWarmerWelcome: If true, it indicates that the auto surface client
	// should receive a warmer welcome TTS for signed-out users. For
	// signed-in user, we will rely on server side metadata.
	// go/aaae:preview-lang
	PlayWarmerWelcome bool `json:"playWarmerWelcome,omitempty"`

	// SupportsAddingCars: If true, it indicates that the client can be used
	// to add cars after account linking with the OEM.
	SupportsAddingCars bool `json:"supportsAddingCars,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PlayWarmerWelcome")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PlayWarmerWelcome") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCarSettingsCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCarSettingsCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiCastAssistantSettingLinkingResult struct {
	// CastLinkingStatus: Cast linking status for ATV surfaces. This is
	// derived from error messages returned from Cast Orchestration Server
	// and will be used for data profiling
	// only(go/katniss-settings-dashboard).
	//
	// Possible values:
	//   "NOT_SET" - LINT.IfChange
	//   "SUCCEED"
	//   "DEVICE_CONFLICT"
	//   "DEVICE_NAME_EMPTY"
	//   "CLIENT_ID_MISSING_TAG"
	//   "INVALID_DEVICE_ID"
	//   "DATA_SYNC_THROTTLED"
	//   "CREATE_ROBOT_ACCOUNT_FAILED"
	//   "UNAUTHORIZED_CLIENT"
	//   "OTHER_ERROR" -
	// LINT.ThenChange(//depot/google3/logs/proto/assistant/capabilities_log.
	// proto)
	CastLinkingStatus string `json:"castLinkingStatus,omitempty"`

	// TruncatedErrorMsg: The error msg returned from COS, truncated in case
	// it's too large.
	TruncatedErrorMsg string `json:"truncatedErrorMsg,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CastLinkingStatus")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CastLinkingStatus") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCastAssistantSettingLinkingResult) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCastAssistantSettingLinkingResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCastCapabilities: These capabilities represent
// capabilities that have to do with casting that pertain to this
// device. Next ID: 9
type AssistantApiCastCapabilities struct {
	// CameraReceiverCapabilities: Whether the device has limited camera
	// stream capability and if yes, which receivers are supported.
	CameraReceiverCapabilities *AssistantApiCameraReceiverCapabilities `json:"cameraReceiverCapabilities,omitempty"`

	// CameraStreamSupportedProtocols: The supported protocols for camera
	// streaming. The value is used as string in
	// go/smarthome-internal-api#camera-stream, so using a string for this
	// field instead of an enum. Supported protocols: (align the definition
	// in go/smarthome-camerastream-trait) - "hls": HTTP Live Streaming -
	// "dash": Dynamic Adaptive Streaming over HTTP - "smooth_stream":
	// Smooth Streaming - "progressive_mp4": Progressive MP4 (will likely
	// only be used for Clips) - "webrtc": WebRTC (currently, only H.264 is
	// supported) - "nexustalk": Internal-only protocol used for Nest
	CameraStreamSupportedProtocols []string `json:"cameraStreamSupportedProtocols,omitempty"`

	// CanReceiveCast: True if we can cast things to this device.
	CanReceiveCast bool `json:"canReceiveCast,omitempty"`

	// DeviceId: Optional for primarily cast devices (e.g., Chirp,
	// Chromecast). For devices that are NOT primarily cast devices, but
	// having a cast receiver as secondary functionality, this field SHOULD
	// store the cast-device-id to be used to send remote casting commands
	// to the device. Example: Android TV, which supports both
	// Android-native actions as well as remote casting using its built-in
	// cast receiver. Android TV device id contains a DUSI id, which is not
	// a cast-device-id. When executing a cast command on the Android TV,
	// this field is used to route the cast command (through
	// CloudCastService) to the cast receiver on the device.
	DeviceId *AssistantApiCoreTypesDeviceId `json:"deviceId,omitempty"`

	// DynamicGroupsSupported: Whether this device supports dynamic groups
	// or not. It implies if a Stream Control operation (transfer,
	// expansion, and contraction) could be applied on this device since
	// Stream Control is implemented as part of dynamic groups (ie,
	// adding/removing devices from playback)
	DynamicGroupsSupported bool `json:"dynamicGroupsSupported,omitempty"`

	// Possible values:
	//   "NONE"
	//   "STATIC_GROUP" - Static group is created by the user through UI. It
	// contains two or more devices.
	//   "DYNAMIC_GROUP" - Dynamic group is a temporary group created when
	// devices are added to / removed from a playback. It should be torn
	// down after the playback is done.
	//   "STEREO_PAIR" - Stereo pair is created by the user through UI. It
	// contains exact two devices, a left device and a right device.
	GroupType string `json:"groupType,omitempty"`

	// OverlayApplicationsSupported: Whether UI overlay applications are
	// supported on this device. It's used by Chromecast only.
	OverlayApplicationsSupported bool `json:"overlayApplicationsSupported,omitempty"`

	// YetiGamingSupported: Whether the device supports playing games
	// through Yeti. This is set by the cast device when the device is
	// updated: Chromecast updates -> Chromecast registers its capabilities
	// with CCS -> CCS passes the capabilities to the
	// AssistantSettingsService -> AssistantSettingsService stores the
	// device's capabilities. go/yeti-gaming-supported-cast-capability
	YetiGamingSupported bool `json:"yetiGamingSupported,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "CameraReceiverCapabilities") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "CameraReceiverCapabilities") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCastCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCastCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiClientOpPropertiesDeviceModifySettingClientOpProperty:
// The properties of the client op device.MODIFY_SETTING. This proto is
// stored in the SupportedClientOp proto.
type AssistantApiClientOpPropertiesDeviceModifySettingClientOpProperty struct {
	// SkipAndroidAndGsaVersionCheck: Additional specific setting
	// capabilities. This boolean is used to indicate whether we want to
	// skip the Android and GSA version check in
	// CheckSettingSchemaAndMaybeGetUris() from
	// assistant/vertical/device/fulfillment/utils/setting_utils.h. Consider
	// setting this field to true if your device is neither Android or GSA
	// (especially when the UserAgent string of your device's TaskRequest
	// will not contain a valid/up-to-date Android/GSA version).
	SkipAndroidAndGsaVersionCheck bool `json:"skipAndroidAndGsaVersionCheck,omitempty"`

	// SupportedSettings: Uses DeviceSetting enum which corresponds to
	// setting_id. This indicates which specific settings are supported by
	// client. An empty list implies all settings are supported.
	//
	// Possible values:
	//   "UNSPECIFIED"
	//   "ABOUT_ME"
	//   "ACCESSIBILITY"
	//   "ACTIVE_EDGE"
	//   "ACTIVE_EDGE_SENSITIVITY"
	//   "ADAPTIVE_BATTERY"
	//   "ADAPTIVE_BRIGHTNESS"
	//   "ADAPTIVE_CHARGING"
	//   "ADAPTIVE_CONNECTIVITY"
	//   "ADAPTIVE_SOUND"
	//   "ADD_ACCOUNT"
	//   "ADD_BLUETOOTH_DEVICE" - Pair a bluetooth device.
	//   "ADD_DEVICE" - Link a device to Assistant/Google Home.
	//   "ADD_FINGERPRINT"
	//   "ADS_TRACKING"
	//   "AIRPLANE_MODE"
	//   "ALARM_VOLUME"
	//   "ALARM_SOUND" - Deprecated, use DEFAULT_ALARM_SOUND instead.
	//   "ALLOW_MULTIPLE_USERS"
	//   "AMBIENT_DISPLAY_ALWAYS_ON"
	//   "AMBIENT_DISPLAY_NEW_NOTIFICATION"
	//   "ANDROID_AUTO"
	//   "ANDROID_VERSION"
	//   "APP_BATTERY_USAGE"
	//   "APP_DATA_USAGE"
	//   "APP_DETAILS"
	//   "APP_SHORTCUT"
	//   "APPS_NOTIFICATIONS"
	//   "APPS_STORAGE"
	//   "ASSISTANT_ACCOUNT"
	//   "ASSISTANT_FACE_MATCH"
	//   "ASSISTANT_LANGUAGE"
	//   "ASSISTANT_VOICE_MATCH"
	//   "AUTO_ROTATE"
	//   "AUTO_ROTATE_FACE_DETECTION"
	//   "BACKUP"
	//   "BATTERY_HEALTH" - Denotes if the battery health is normal /
	// reduced / unknown.
	//   "BATTERY_LEVEL"
	//   "BATTERY_LOW"
	//   "BATTERY_PERCENTAGE"
	//   "BATTERY_PRESENT"
	//   "BATTERY_SAVER"
	//   "BATTERY_SAVER_SCHEDULE"
	//   "BATTERY_SHARE"
	//   "BATTERY_USAGE"
	//   "BIOMETRIC"
	//   "BLUETOOTH" - Bluetooth on/off toggle
	//   "BLUETOOTH_NAME"
	//   "BLUETOOTH_ADDRESS"
	//   "BLUETOOTH_SETTINGS" - Bluetooth preferences page
	//   "BRIGHTNESS_LEVEL"
	//   "BUBBLES"
	//   "CALL_VOLUME"
	//   "CAMERA_DOUBLE_TWIST"
	//   "CAST"
	//   "CAR_CRASH_DETECTION"
	//   "COLOR_INVERSION"
	//   "COLOR_CORRECTION"
	//   "CONVERSATIONS"
	//   "CHARGING_SOUNDS_AND_VIBRATION"
	//   "CHARGING_STATE"
	//   "CONNECTED_DEVICES"
	//   "CONTACTLESS_PAYMENTS"
	//   "DATA_ROAMING"
	//   "DATA_SAVER"
	//   "DATA_USAGE" - Cellular carrier (non-wifi) data usage statistics &
	// settings for the device.
	//   "DATA_LIMIT" - Toggle to enable data use limit
	//   "DATA_LIMIT_LEVEL" - The mobile data use after which mobile data is
	// automatically disabled.
	//   "DATA_WARNING" - Toggle to enable data use warning
	//   "DATA_WARNING_LEVEL" - The mobile data use after which a warning is
	// shown to the user.
	//   "DEFAULT_ALARM_SOUND"
	//   "DEFAULT_NOTIFICATION_SOUND"
	//   "DEFAULT_APPS"
	//   "DEVELOPER_OPTIONS"
	//   "DEVICE_ASSISTANT_APP" - Device's voice assistant app selection.
	//   "DEVICE_NAME"
	//   "DISPLAY_OVER_OTHER_APPS"
	//   "DISPLAY_SIZE"
	//   "DO_NOT_DISTURB"
	//   "DO_NOT_DISTURB_MESSAGES"
	//   "DO_NOT_DISTURB_CALLS"
	//   "DO_NOT_DISTURB_ALARMS"
	//   "DO_NOT_DISTURB_SCHEDULES"
	//   "DOUBLE_TAP_CHECK_PHONE"
	//   "DRIVING_MODE" - Special mode for using device hands-free while
	// driving.
	//   "EARTHQUAKE_ALERTS"
	//   "EMERGENCY" - Main emergency settings
	//   "EMERGENCY_ALERTS"
	//   "EMERGENCY_CONTACTS"
	//   "EMERGENCY_INFORMATION"
	//   "ETHERNET_TETHERING"
	//   "EXTRA_DIM" - Makes screen extra dark.
	//   "EXTREME_BATTERY_SAVER"
	//   "FACTORY_RESET"
	//   "FIND_MY_DEVICE"
	//   "FLASHLIGHT"
	//   "FOCUS_MODE"
	//   "FONT_SIZE"
	//   "FREE_UP_SPACE"
	//   "FINGERPRINT_MANAGER"
	//   "GESTURES" - A page for device gestures
	//   "HAPTIC_FEEDBACK_VIBRATION" - Slider that controls touch feedback
	// vibration
	//   "HARD_KEYBOARD"
	//   "HEADS_UP"
	//   "HIGH_REFRESH_RATE"
	//   "HOT_SPOT" - Toggle for internet sharing via WiFi.
	//   "HOTSPOT_TETHERING" - Common settings page for internet sharing via
	// various means.
	//   "HOT_WORD"
	//   "HUB_MODE" - See go/hubmodesettings-PRD.
	//   "IP_ADDRESS" - Show my IP address
	//   "IMPROVE_LOCATION_ACCURACY"
	//   "JUMP_TO_CAMERA"
	//   "KEYBOARD_SHORTCUTS"
	//   "LIFT_CHECK_PHONE"
	//   "LIVE_TRANSLATE"
	//   "LOCATION"
	//   "LOCATION_HISTORY"
	//   "LOCATION_BLUETOOTH_SCANNING"
	//   "LOCATION_WIFI_SCANNING"
	//   "LOCK_SCREEN" - Settings page for what is visible on the lock
	// screen.
	//   "LOCK_SCREEN_DEVICE_CONTROLS"
	//   "LOCK_SCREEN_WALLET"
	//   "MAC_ADDRESS" - Show my MAC address
	//   "MAGNIFICATION"
	//   "MAGNIFY_BUTTON"
	//   "MAGNIFY_TRIPLE_TAP"
	//   "MANIFY_BUTTON"
	//   "MANIFY_TRIPLE_TAP"
	//   "MEDIA"
	//   "MEDIA_VOLUME"
	//   "MICROPHONE_ACCESS" - Microphone Access is a toggleable setting
	// that controls if Microphone usage is allowed at the system level or
	// not. It is not the per-App Microphone permission page.
	// https://screenshot.googleplex.com/4hrskftPSur7hHh
	//   "MOBILE" - Wireless internet settings, including WiFi, Cellular,
	// etc.
	//   "MOBILE_DATA" - Setting to enable/disable cellular data connection
	// being used on the device.
	// https://screenshot.googleplex.com/jMSRtW3Aq4o
	//   "MUSIC"
	//   "MUTE_MODE"
	//   "NETWORK"
	//   "NETWORK_RESET" - Restarts the device network stack, no settings
	// are deleted.
	//   "NFC"
	//   "NIGHT_LIGHT_INTENSITY"
	//   "NIGHT_LIGHT_SWITCH"
	//   "NIGHT_MODE"
	//   "NOTIFICATION_BADGE"
	//   "NOTIFICATION_SOUND" - Deprecated, use DEFAULT_NOTIFICATION_SOUND
	// instead.
	//   "NOTIFICATION_ON_SCREEN"
	//   "NOTIFICATION_HISTORY"
	//   "NOTIFY_FOR_PUBLIC_NETWORKS"
	//   "ONEHANDED_MODE"
	//   "OS_VERSION"
	//   "PASSWORD" - Password manager
	//   "PERMISSION_MANAGER" - Shows permissions and allows add/remove
	// allowed apps.
	//   "PERMISSION_USAGE" - Shows usage of each permission by app.
	//   "PERSONALIZATION"
	//   "PRINTING"
	//   "PHONE_NUMBER"
	//   "PICTURE_IN_PICTURE"
	//   "POINTER_SPEED"
	//   "POWER_MENU"
	//   "REMINDERS"
	//   "REQUIRE_DEVICE_UNLOCK_FOR_NFC"
	//   "RINGTONE"
	//   "RING_VOLUME"
	//   "NEARBY_DEVICES_SCANNING"
	//   "NEARBY_SHARE"
	//   "SCREEN_LOCKING_SOUND"
	//   "SCREEN_MAGNIFICATION"
	//   "SCREEN_TIMEOUT"
	//   "SCREEN_LOCK" - Settings page for screen locking security methods.
	//   "SCREEN_SAVER"
	//   "SELECT_TO_SPEAK"
	//   "SET_TIME_AUTOMATICALLY"
	//   "SET_TIME_ZONE_AUTOMATICALLY"
	//   "SETTINGS"
	//   "SIM" - Currently active/primary SIM.
	//   "SIM_MANAGER"
	//   "SPEECH_RATE"
	//   "STORAGE_USAGE"
	//   "SWIPE_FOR_NOTIFICATION"
	//   "SWITCH_ACCESS"
	//   "SYSTEM_UPDATE" - Deprecated, use SYSTEM_UPDATES instead.
	//   "SYSTEM_UPDATES"
	//   "SYSTEM_NAVIGATION" - Settings page for configuring how navigation
	// between apps is done. Specifically android has choice between Buttons
	// of Gestures mode.
	//   "SYSTEM_NAVIGATION_GESTURES"
	//   "SYSTEM_NAVIGATION_BUTTONS"
	//   "TALKBACK_PASSWORDS"
	//   "TEXT_TO_SPEECH"
	//   "TIME_ZONE"
	//   "UNUSED_APPS"
	//   "USB"
	//   "USB_TETHERING"
	//   "VERBOSE_TTS"
	//   "VIBRATE" - Deprecated, use VIBRATION instead.
	//   "VIBRATION" - Vibration master toggle - controls all vibration
	// functions. Corresponds to "Vibration & haptics" toggle in the Android
	// settings app.
	//   "VIBRATION_MODE" - Controls whether the ringer mode will be silent
	// or will vibrate. Details in
	// https://developer.android.com/reference/android/media/AudioManager#RINGER_MODE_VIBRATE
	// Different from VIBRATION from above.
	//   "VOICE" - deprecated, use ASSISTANT_VOICE
	//   "VOLUME_LEVEL"
	//   "WAKE_SCREEN_FOR_NOTIFICATIONS"
	//   "WALLPAPERS"
	//   "WEBVIEW"
	//   "WIFI"
	//   "WIFI_ADD_NETWORK"
	//   "WIFI_ADD_NETWORK_QR_CODE"
	//   "WIFI_CALLING"
	//   "WIFI_HOTSPOT" - Duplicate, use HOT_SPOT instead
	//   "ACCESSIBILITY_SELECT_TO_SPEAK" - Accessibility > Select to Speak
	//   "CRISIS_ALERTS" - Safety > Crisis alerts
	//   "REGULATORY_LABELS" - Settings > About phone > Regulatory labels
	//   "SEND_FEEDBACK" - Settings > About phone > Send feedback about this
	// device
	//   "OS_BUILD_NUMBER"
	//   "ACCESSIBILITY_SHORTCUTS"
	//   "ACCESSIBILITY_MENU"
	//   "ACCESSIBILITY_SOUND_AMPLIFIER" - Settings > Accessibility >
	// Hearing > Sound Amplifier
	//   "ACCESSIBILITY_LIVE_TRANSCRIBE"
	//   "ACCESSIBILITY_SOUND_NOTIFICATIONS"
	//   "ACCESSIBILITY_TALKBACK" - Settings > Accessibility > TalkBack
	//   "ACCESSIBILITY_TIMEOUT" - Settings > Accessibility > Time to take
	// action (Accessibility timeout)
	//   "CAMERA_SETTINGS"
	//   "BATTERY_SAVER_TOGGLE"
	//   "COVID_NOTIFICATIONS" - Settings > Google > COVID-19 Exposure
	// Notifications
	//   "APP_LOCATION"
	//   "LOCATION_SERVICES"
	//   "PRIVATE_DNS"
	//   "UNRESTRICTED_DATA" - Settings > Network & Internet > Data Saver >
	// Unrestricted data
	//   "PREFERRED_NETWORK"
	//   "NETWORK_PREFERENCES"
	//   "PASSWORDS_AND_ACCOUNTS"
	//   "PRIVACY_DASHBOARD"
	//   "MORE_SECURITY"
	//   "APP_PINNING"
	//   "CONFIRM_SIM_DELETION"
	//   "ENCRYPT_PHONE" - Settings > Security > Encrypt phone
	//   "FACE_UNLOCK"
	//   "INSTALL_UNKNOWN_APPS"
	//   "NOW_PLAYING"
	//   "STAY_AWAKE"
	//   "ASSISTANT_VOICE"
	//   "RESET_BLUETOOTH_WIFI"
	//   "DEFAULT_PHONE_APP"
	//   "GOOGLE_ACCOUNT"
	//   "ACCESSIBILITY_CAPTION_SIZE_AND_STYLE" - Settings > Accessibility >
	// Caption preferences > Caption size and style
	//   "ACCESSIBILITY_CAPTION_STYLE" - Settings > Accessibility > Caption
	// preferences > Caption size and style > Caption Style
	//   "ACCESSIBILITY_CAPTION_TEXT" - Settings > Accessibility > Caption
	// preferences > Caption size and style > Text size
	//   "ACCESSIBILITY_CAPTION_PREFERENCES" - Settings > Accessibility >
	// Caption preferences
	//   "ACCESSIBILITY_COLOR_AND_MOTION" - Settings > Accessibility > Color
	// and motion
	//   "ACCESSIBILITY_BOLD_TEXT" - Settings > Accessibility > Display size
	// and text > Bold text
	//   "LIVE_CAPTION"
	//   "POWER_BUTTON_ENDS_CALL" - Settings > Accessibility > Power button
	// ends call
	//   "TOUCH_AND_HOLD_DELAY"
	//   "ACCESSIBILITY_VOICE_ACCESS"
	//   "SMS_PERMISSIONS"
	//   "SPECIAL_APP_ACCESS" - Settings > Apps & notifications > Advanced >
	// Special app access
	//   "DARK_THEME_SCHEDULE"
	//   "LOCK_SCREEN_TEXT" - Settings > Display > Lock screen > Add text on
	// lock screen
	//   "NIGHT_LIGHT_SCHEDULE"
	//   "AUTOFILL"
	//   "USAGE_AND_DIAGNOSTICS"
	//   "SENSITIVE_NOTIFICATIONS"
	//   "ENCRYPTION_AND_CREDENTIALS" - Settings > Security > Advanced
	// settings > Encryption & credentials
	//   "SPACIAL_AUDIO" - Settings > Sound & vibration > Spatial Audio
	//   "RESET_OPTIONS" - Settings > System > Advanced > Reset options
	//   "QUICK_TAP" - Settings > System > Gestures > Quick tap
	//   "TIPS_AND_SUPPORT" - Settings > Tips & support
	//   "SCREEN_ATTENTION" - Display > Screen timeout > Screen attention
	//   "BLUETOOTH_TETHERING"
	//   "ALL_APPS"
	//   "EXTEND_UNLOCK"
	//   "CLEAR_CALLING"
	//   "GOOGLE_SETTINGS"
	//   "APP_LANGUAGES"
	//   "SIM_STATUS"
	//   "MICROPHONE_PERMISSIONS" - Permission Manager > Microphone
	//   "GOOGLE_PLAY_UPDATE"
	//   "ADD_GOOGLE_ACCOUNT"
	//   "ASSISTANT_SPOKEN_NOTIFICATIONS" - Settings for assistant to
	// announce messages/notifications
	//   "ABOUT_PHONE" - Begin of NGA proto consistence
	//   "ACCOUNTS"
	//   "APPLICATION"
	//   "ASSISTANT"
	//   "AUDIO"
	//   "BATTERY"
	//   "BELL_SCHEDULE"
	//   "CONTINUED_CONVERSATION"
	//   "DATE_TIME"
	//   "DARK_THEME"
	//   "DEVICE_INFO"
	//   "DICTIONARY"
	//   "DIGITAL_WELLBEING"
	//   "DISPLAY"
	//   "LANGUAGE"
	//   "NIGHT_LIGHT" - Duplicate, use NIGHT_MODE instead
	//   "NOTIFICATION"
	//   "NOTIFICATION_VOLUME"
	//   "PHONE_RINGTONE"
	//   "PRIVACY"
	//   "ROAMING"
	//   "ROUTINES"
	//   "SEARCH"
	//   "SECURITY"
	//   "SOUND"
	//   "SPELL_CHECKER"
	//   "SYSTEM"
	//   "STORAGE"
	//   "VPN" - End of NGA proto consistence
	//   "AUTOCLICK" - Chrome OS specific accessibility settings
	//   "CARET_HIGHLIGHT"
	//   "CHROMEVOX"
	//   "CURSOR_HIGHLIGHT"
	//   "DOCKED_MAGNIFIER"
	//   "FOCUS_HIGHLIGHT"
	//   "FULLSCREEN_MAGNIFIER"
	//   "HIGH_CONTRAST_MODE"
	//   "LARGE_CURSOR"
	//   "MONO_AUDIO"
	//   "STICKY_KEYS"
	//   "TAP_DRAGGING"
	//   "VIRTUAL_KEYBOARD" - End of Chrome OS specific accessibility
	// settings
	//   "WEARABLE_AMBIENT" - Wearable device settings
	//   "WEARABLE_NOISE_CANCELLATION"
	//   "WEARABLE_TOUCH_CONTROLS"
	//   "RAISE_TO_TALK"
	//   "BEDTIME_MODE"
	//   "THEATER_MODE"
	//   "TOUCH_LOCK"
	//   "PRESS_AND_HOLD"
	//   "WATCH_FACE" - Settings > Display > Change watch face End of
	// Wearable device settings
	//   "NOTIFICATION_ANNOUNCEMENT" - Assistant Spoken Notification Setting
	SupportedSettings []string `json:"supportedSettings,omitempty"`

	// SupportsDoNotDisturbWithDuration: Additional specific setting
	// capabilities. This boolean is used to indicate if do not disturb with
	// duration is supported through device.MODIFY_SETTING clientop on a
	// client or not.
	SupportsDoNotDisturbWithDuration bool `json:"supportsDoNotDisturbWithDuration,omitempty"`

	// SupportsMuteUnmute: Additional specific setting capabilities. This
	// boolean is used to indicate if new unmute logic is enabled on a
	// client or not.
	SupportsMuteUnmute bool `json:"supportsMuteUnmute,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "SkipAndroidAndGsaVersionCheck") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "SkipAndroidAndGsaVersionCheck") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiClientOpPropertiesDeviceModifySettingClientOpProperty) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiClientOpPropertiesDeviceModifySettingClientOpProperty
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiClientOpPropertiesProviderOpenClientOpProperty: The
// properties of the provider.OPEN ClientOp. This proto is stored in the
// SupportedClientOp proto with the key provider.OPEN.
type AssistantApiClientOpPropertiesProviderOpenClientOpProperty struct {
	// KeepsConversationAliveAfterOpeningApp: Whether conversation is kept
	// alive after opening the app. See go/keep-opa-conversation-alive for
	// details.
	KeepsConversationAliveAfterOpeningApp bool `json:"keepsConversationAliveAfterOpeningApp,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "KeepsConversationAliveAfterOpeningApp") to unconditionally include
	// in API requests. By default, fields with empty or default values are
	// omitted from API requests. However, any non-pointer, non-interface
	// field appearing in ForceSendFields will be sent to the server
	// regardless of whether the field is empty or not. This may be used to
	// include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "KeepsConversationAliveAfterOpeningApp") to include in API requests
	// with the JSON null value. By default, fields with empty values are
	// omitted from API requests. However, any field with an empty value
	// appearing in NullFields will be sent to the server as null. It is an
	// error if a field in this list has a non-empty value. This may be used
	// to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiClientOpPropertiesProviderOpenClientOpProperty) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiClientOpPropertiesProviderOpenClientOpProperty
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiClockCapabilities: Used to describe clock capabilities of
// the device (for example, capabilities related to maximum number of
// supported alarms and timers that can be created on the device).
// Fields may be populated by clients or be backfilled by SAL (in case
// of Timon, for example).
type AssistantApiClockCapabilities struct {
	// MaxSupportedAlarms: Maximum number of alarms that can be created on
	// the client.
	MaxSupportedAlarms int64 `json:"maxSupportedAlarms,omitempty"`

	// MaxSupportedExtendedTimerDuration: Maximum extended timer duration
	// supported by the client. The extended timer duration is the total
	// start-to-finish duration after an AddTimeToTimer operation. E.g. if a
	// user sets a timer for 30 minutes, and later adds 10 minutes, the
	// extended duration is 40 minutes.
	MaxSupportedExtendedTimerDuration *AssistantApiDuration `json:"maxSupportedExtendedTimerDuration,omitempty"`

	// MaxSupportedTimerDuration: Maximum duration of timers that can be
	// created on the client.
	MaxSupportedTimerDuration *AssistantApiDuration `json:"maxSupportedTimerDuration,omitempty"`

	// MaxSupportedTimers: Maximum number of timers that can be created on
	// the client.
	MaxSupportedTimers int64 `json:"maxSupportedTimers,omitempty"`

	// PreferredStopwatchProvider: The preferred provider to use for
	// stopwatch related functionality.
	PreferredStopwatchProvider *AssistantApiCoreTypesProvider `json:"preferredStopwatchProvider,omitempty"`

	// RestrictAlarmsToNext24h: Whether the client restricts alarms to ring
	// within the next 24 hours.
	RestrictAlarmsToNext24h bool `json:"restrictAlarmsToNext24h,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MaxSupportedAlarms")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MaxSupportedAlarms") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiClockCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiClockCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCommunicationUiCapabilities: UI capabilities for the
// surfaces rendering Comms features. See
// go/rohan-comms-fluid-actions-customization.
type AssistantApiCommunicationUiCapabilities struct {
	// Possible values:
	//   "DEFAULT"
	//   "SIMPLIFIED" - Fluid actions output optimized for small devices,
	// with no on-device management of conversation state available.
	FluidActionsUiType string `json:"fluidActionsUiType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FluidActionsUiType")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FluidActionsUiType") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCommunicationUiCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCommunicationUiCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiContactLookupCapabilities struct {
	// FallbackToTetheredDevice: If true, contact.LOOKUP should be routed to
	// the tethered device (if present) if the tethered device supports
	// contact.LOOKUP and the primary device does not.
	FallbackToTetheredDevice bool `json:"fallbackToTetheredDevice,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "FallbackToTetheredDevice") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FallbackToTetheredDevice")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiContactLookupCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiContactLookupCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesAndroidAppInfo: The android app information of
// the provider. Like, Spotify. Next ID: 17 LINT.IfChange
type AssistantApiCoreTypesAndroidAppInfo struct {
	AccountType string `json:"accountType,omitempty"`

	ActivityInfo *AssistantApiCoreTypesAndroidAppInfoActivityInfo `json:"activityInfo,omitempty"`

	// AndroidIntent: Intent associated with the app. We include intents
	// here as different versions of the same app may support different
	// intents. In those cases, the package_name is not enough to identify
	// the app and we should use the combination of package_name and
	// android_intent. This field might contain sensitive data, if
	// represents ClientOp with encapsulated PII such as user query.
	AndroidIntent string `json:"androidIntent,omitempty"`

	// AppUniqueId: Store the app unique id endpoint. This will be passed
	// over to app to fulfill the action.
	AppUniqueId string `json:"appUniqueId,omitempty"`

	// AppVersion: The android app version. Deprecated because
	// https://developer.android.com/reference/android/content/pm/PackageInfo.html#getLongVersionCode
	AppVersion int64 `json:"appVersion,omitempty"`

	// DataMimetype: data_mimetype and account_type are the what AGSA uses
	// to filter which contacts support this Android app in ContactProvider.
	DataMimetype string `json:"dataMimetype,omitempty"`

	// IsBroadcastIntent: If true, client should broadcast the intent
	// instead of open the intent.
	IsBroadcastIntent bool `json:"isBroadcastIntent,omitempty"`

	// IsDefault: App is the default app for it's core functionality. For
	// example, it will be true for Android messages if it is the default
	// app to send and receive SMS on the phone.
	IsDefault bool `json:"isDefault,omitempty"`

	// LocalizedAppName: The localized app name.
	LocalizedAppName string `json:"localizedAppName,omitempty"`

	// LongVersionCode: The long android app version.
	LongVersionCode int64 `json:"longVersionCode,omitempty,string"`

	// Mimetype: Store mimetype of this endpoint. We will use this as the
	// differentiator for Assistant to know whether to use the RawContact
	// for messaging, call or video call. For example, send message mimetype
	// for whatsapp: "vnd.android.cursor.item/vnd.com.whatsapp.profile"
	// voice call mimetype for whatsapp:
	// "vnd.android.cursor.item/vnd.com.whatsapp.voip.call"
	Mimetype string `json:"mimetype,omitempty"`

	// PackageName: The android app package of the provider, like
	// "com.spotify.music".
	PackageName string `json:"packageName,omitempty"`

	// ProviderType: The OemProviderType is specific for OEM system Android
	// apps. For example, in Auto Embedded, the OEM will have a system
	// Radio/Media app. The system app’s capabilities/core functionalities
	// are captured here. For physical media sources, the OEM may decide to
	// implement one media app (thus, one package name) that handles
	// multiple physical media sources. For these cases, each physical media
	// source will be sent as different providers even though the package
	// name is the same.
	//
	// Possible values:
	//   "UNKNOWN_OEM_PROVIDER_TYPE"
	//   "RADIO_PROVIDER_TYPE" - Refers to an app that handles AM/FM Radio
	// via a physical radio tuner in the device. See
	// go/radio-assistant-for-auto.
	//   "SXM_RADIO_PROVIDER_TYPE" - Refers to an app that handles Satellite
	// (SiriusXM) Radio via a physical Satellite tuner in the device. See
	// go/sxm-on-gas.
	ProviderType string `json:"providerType,omitempty"`

	// ShortcutId: Id of the app's Android shortcut to be launched by
	// Assistant. The client is expected to use the Android LauncherApps API
	// to execute this shortcut which in turn will open the app. For
	// example, Whatsapp may create an Android shortcut for a frequently
	// messaged contact with an id "contact_123". This field will contain
	// that id and the client can execute it to open up the chat with that
	// particular contact. If this field is set, the package_name field must
	// also be set since both will be used by the LauncherApps API for
	// execution. If this field is set, the intent related fields will be
	// ignored and not used as a fallback. Design:
	// go/shortcut-id-in-provider-open-clientop This field should only be
	// set for devices with Android API level >= 25 (since that is the
	// version from which the LauncherApps startShortcut API is available)
	ShortcutId string `json:"shortcutId,omitempty"`

	// TargetClass: The fully qualified target class name of the provider,
	// like "com.example.myapp.GetOrderService".
	TargetClass string `json:"targetClass,omitempty"`

	// VersionName: The android app version name, like "4.1.091.05.40d",
	// "11.2.7.21.alpha". Android Docs:
	// https://developer.android.com/reference/android/content/pm/PackageInfo#versionName
	VersionName string `json:"versionName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccountType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesAndroidAppInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesAndroidAppInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesAndroidAppInfoActivityInfo: General information
// about activities in the app.
type AssistantApiCoreTypesAndroidAppInfoActivityInfo struct {
	// ActiveLaunchableActivities: Activities that are currently active and
	// tagged as ACTION_MAIN and CATEGORY_LAUNCHER. Includes the activity
	// corresponding to android_intent if it falls under CATEGORY_LAUNCHER.
	ActiveLaunchableActivities []*AssistantApiCoreTypesAndroidAppInfoActivityInfoActivity `json:"activeLaunchableActivities,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ActiveLaunchableActivities") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "ActiveLaunchableActivities") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesAndroidAppInfoActivityInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesAndroidAppInfoActivityInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesAndroidAppInfoActivityInfoActivity: Information
// about an individual activity.
type AssistantApiCoreTypesAndroidAppInfoActivityInfoActivity struct {
	// LocalizedActivityName: The localized user visible activity name.
	LocalizedActivityName string `json:"localizedActivityName,omitempty"`

	// ShortClassName: Short class name for activity, following
	// https://developer.android.com/reference/android/content/ComponentName#getShortClassName()
	ShortClassName string `json:"shortClassName,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "LocalizedActivityName") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LocalizedActivityName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesAndroidAppInfoActivityInfoActivity) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesAndroidAppInfoActivityInfoActivity
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesAndroidAppInfoDelta: The change of
// AndroidAppInfo, e.g. app installation or deletion for incremental
// delta app info upload.
type AssistantApiCoreTypesAndroidAppInfoDelta struct {
	// AndroidAppInfo: The android app information of the provider. Like,
	// Spotify.
	AndroidAppInfo *AssistantApiCoreTypesAndroidAppInfo `json:"androidAppInfo,omitempty"`

	// LastUpdateTimestamp: The client-side timestamp in millis when the app
	// is last updated, installed or deleted.
	LastUpdateTimestamp string `json:"lastUpdateTimestamp,omitempty"`

	// UpdateType: App is installed or deleted.
	//
	// Possible values:
	//   "UNKNOWN_TYPE"
	//   "IS_INSTALLED"
	//   "IS_DELETED"
	UpdateType string `json:"updateType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AndroidAppInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AndroidAppInfo") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesAndroidAppInfoDelta) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesAndroidAppInfoDelta
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesCalendarEvent: This proto contains the
// information of a calendar event, including title, start time, end
// time, etc. LINT.IfChange(CalendarEvent) NEXT_ID: 26
type AssistantApiCoreTypesCalendarEvent struct {
	// Attendees: Attendees invited to the event, usually includes also the
	// organizer.
	Attendees []*AssistantApiCoreTypesCalendarEventAttendee `json:"attendees,omitempty"`

	// BackgroundColor: The background color of the event, in RGB format.
	BackgroundColor int64 `json:"backgroundColor,omitempty"`

	// CalendarId: Optional calendar containing the event.
	CalendarId string `json:"calendarId,omitempty"`

	// Creator: The person who created this event.
	Creator *AssistantApiCoreTypesCalendarEventAttendee `json:"creator,omitempty"`

	// Description: Optional description of the event (plain text).
	Description string `json:"description,omitempty"`

	// End: The end time of the event. Start and end time must either both
	// be date or both be datetime. End is exclusive, ie. the first day /
	// first second when the event is over.
	End *AssistantApiDateTime `json:"end,omitempty"`

	// EventId: Optional event id provided by assistant server. Needs to be
	// unique, at least on a per-user and calendar level, ideally globally
	// unique. If none is given, the server will assign an id.
	EventId string `json:"eventId,omitempty"`

	// FlairName: The flair name, calculated according to the event title
	// (go/as-cal-flair). With the flair name, background images can be got
	// from gstatic (go/scs):
	// https://ssl.gstatic.com/tmly/f8944938hffheth4ew890ht4i8/flairs/
	FlairName string `json:"flairName,omitempty"`

	// ForegroundColor: The foreground color of the event, in RGB format.
	ForegroundColor int64 `json:"foregroundColor,omitempty"`

	// GuestsCanInviteOthers: Whether the guests can invite other guests.
	GuestsCanInviteOthers bool `json:"guestsCanInviteOthers,omitempty"`

	// GuestsCanModify: Whether the guests can modify the event.
	GuestsCanModify bool `json:"guestsCanModify,omitempty"`

	// GuestsCanSeeGuests: Whether the guests of the event can be seen. If
	// false, the user is reported as the only attendee to the event, even
	// though there may be more attendees.
	GuestsCanSeeGuests bool `json:"guestsCanSeeGuests,omitempty"`

	// HabitId: Optional id of the Habit (Calendar Goal) this event is
	// linked to
	HabitId string `json:"habitId,omitempty"`

	// HabitStatus: Optional status for this habit event instance.
	//
	// Possible values:
	//   "UNKNOWN_STATUS"
	//   "ACTIVE"
	//   "DEFERRAL_REQUESTED"
	//   "COMPLETE"
	//   "UNDEFERRABLE"
	HabitStatus string `json:"habitStatus,omitempty"`

	// HtmlLink: Absolute link to this event in the Calendar web UI.
	HtmlLink string `json:"htmlLink,omitempty"`

	// Location: Optional location of the event (plain text).
	Location string `json:"location,omitempty"`

	MeetingContacts []*AssistantApiCoreTypesCalendarEventMeetingContact `json:"meetingContacts,omitempty"`

	// Organizer: The organizer of this event.
	Organizer *AssistantApiCoreTypesCalendarEventAttendee `json:"organizer,omitempty"`

	// OtherAttendeesExcluded: Whether not all attendees are included in the
	// attendee list. This is set when the attendees list has been truncated
	// (e.g., when the number of attendees is beyond the maxAttendees
	// limitation).
	OtherAttendeesExcluded bool `json:"otherAttendeesExcluded,omitempty"`

	// ParticipationResponse: The user's response (the owner of this copy of
	// the event) to this event.
	//
	// Possible values:
	//   "RESPONSE_STATUS_UNSPECIFIED"
	//   "NEEDS_ACTION"
	//   "DECLINED"
	//   "TENTATIVE"
	//   "ACCEPTED"
	ParticipationResponse string `json:"participationResponse,omitempty"`

	// RecurringEventId: If this is an instance of a recurring event,
	// recurring_event_id identifies the recurring series as a whole.
	RecurringEventId string `json:"recurringEventId,omitempty"`

	// Rooms: Meeting rooms associated to this event.
	Rooms []*AssistantApiCoreTypesCalendarEventRoom `json:"rooms,omitempty"`

	// Start: The start time of the event. This event is an all-day event if
	// start has no time_of_day.
	Start *AssistantApiDateTime `json:"start,omitempty"`

	// Summary: The title of the event.
	Summary string `json:"summary,omitempty"`

	// Visibility: Optional visibility of the event.
	//
	// Possible values:
	//   "DEFAULT"
	//   "PUBLIC"
	//   "PRIVATE"
	//   "CONFIDENTIAL"
	//   "SECRET"
	//   "SHADOW"
	//   "UNKNOWN" - When we receive a value outside of this enum it will be
	// replaced with this UNKNOWN field. When trying to send UNKNOWN it will
	// be silently converted to DEFAULT.
	Visibility string `json:"visibility,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Attendees") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Attendees") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesCalendarEvent) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesCalendarEvent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesCalendarEventAttendee: Next id: 8
type AssistantApiCoreTypesCalendarEventAttendee struct {
	// DisplayName: Display name, present only if available.
	DisplayName string `json:"displayName,omitempty"`

	// Email: Email address of the attendee (calendar), for regular events.
	// For +Events, this field is not populated, instead "id" is used.
	Email string `json:"email,omitempty"`

	// GivenName: Given (first) name, present only if available. This is
	// used for generating meeting titles as given name is preferred over
	// display (full) name (ie: "Jeff : Sundar" is better than "Jeff Dean :
	// Sundar Pichai").
	GivenName string `json:"givenName,omitempty"`

	// Id: Profile ID of the principal, for +Events. For regular events,
	// this field is not populated, instead "email" is used.
	Id string `json:"id,omitempty"`

	// Organizer: Is this the organizer?
	Organizer bool `json:"organizer,omitempty"`

	// ResponseStatus: Attendees response status.
	//
	// Possible values:
	//   "RESPONSE_STATUS_UNSPECIFIED"
	//   "NEEDS_ACTION"
	//   "DECLINED"
	//   "TENTATIVE"
	//   "ACCEPTED"
	ResponseStatus string `json:"responseStatus,omitempty"`

	// Self: Is this the owner of this copy of the event?
	Self bool `json:"self,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesCalendarEventAttendee) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesCalendarEventAttendee
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesCalendarEventMeetingContact: Next id: 10
type AssistantApiCoreTypesCalendarEventMeetingContact struct {
	// ConferenceId: ID that corresponds to in ConferenceData.conference_id
	// in calendar.common.ConferenceData proto. For Meet, this is the
	// identifier used to join a meeting via URL.
	ConferenceId string `json:"conferenceId,omitempty"`

	// Possible values:
	//   "NUMBER_CLASS_UNSPECIFIED" - No number class has been specified.
	//   "LOW_COST" - The number has a low cost to receive calls on.
	//   "HIGH_COST" - The number has a high cost to receive calls on.
	//   "LEGACY" - Class for legacy numbers.
	DialInNumberClasses []string `json:"dialInNumberClasses,omitempty"`

	// PhoneNumberUri: Default meeting phone number, for example:
	// "tel:+1-475-777-1840"
	PhoneNumberUri string `json:"phoneNumberUri,omitempty"`

	// PinNumber: A PIN that the participant will need to input after
	// dialing in the conference.
	PinNumber string `json:"pinNumber,omitempty"`

	// Provider: Provider info for the meeting.
	Provider *AssistantApiCoreTypesProvider `json:"provider,omitempty"`

	// RegionCode: The region code for the default meeting phone number
	RegionCode string `json:"regionCode,omitempty"`

	// Possible values:
	//   "SOURCE_UNSPECIFIED" - The source is unknown.
	//   "STRUCTURED_DATA" - The conference information was retrieved from
	// structured fields.
	//   "UNSTRUCTURED_DATA" - The conference information was parsed and
	// extracted from unstructured fields (e.g. event description).
	Source string `json:"source,omitempty"`

	// UniversalPinNumber: The universal meeting PIN number for phone
	// numbers in all available countries
	UniversalPinNumber string `json:"universalPinNumber,omitempty"`

	// Url: URL that can be used to join the meeting.
	Url string `json:"url,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConferenceId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConferenceId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesCalendarEventMeetingContact) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesCalendarEventMeetingContact
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesCalendarEventRoom: A room that is available for
// a potential meeting or has been booked for a scheduled meeting. Next
// id: 4
type AssistantApiCoreTypesCalendarEventRoom struct {
	// Email: Room email that identifies the room and is used to book it.
	Email string `json:"email,omitempty"`

	// LocationDetails: Additional room details. Read-only, populated on
	// request.
	LocationDetails *AssistantApiCoreTypesCalendarEventRoomRoomLocationDetails `json:"locationDetails,omitempty"`

	// Name: Room name (ex: "MTV-PR55-5-A-Shadow 5K0 (13) GVC (No external
	// guests)").
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Email") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesCalendarEventRoom) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesCalendarEventRoom
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesCalendarEventRoomRoomLocationDetails: Room
// location details. Read-only, populated on request. Next id: 8
type AssistantApiCoreTypesCalendarEventRoomRoomLocationDetails struct {
	// Building: Building where the room is (ex: "PR55").
	Building string `json:"building,omitempty"`

	// City: City where the room is (ex: "MTV").
	City string `json:"city,omitempty"`

	// Floor: Floor where the room is (ex: "5").
	Floor string `json:"floor,omitempty"`

	// Latitude: The latitude in degrees.
	Latitude float64 `json:"latitude,omitempty"`

	// Longitude: The longitude in degrees.
	Longitude float64 `json:"longitude,omitempty"`

	// Section: Section in the floor (ex: "A").
	Section string `json:"section,omitempty"`

	// SimpleName: Room name (ex: "Shadow 5K0").
	SimpleName string `json:"simpleName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Building") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Building") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesCalendarEventRoomRoomLocationDetails) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesCalendarEventRoomRoomLocationDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *AssistantApiCoreTypesCalendarEventRoomRoomLocationDetails) UnmarshalJSON(data []byte) error {
	type NoMethod AssistantApiCoreTypesCalendarEventRoomRoomLocationDetails
	var s1 struct {
		Latitude  gensupport.JSONFloat64 `json:"latitude"`
		Longitude gensupport.JSONFloat64 `json:"longitude"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Latitude = float64(s1.Latitude)
	s.Longitude = float64(s1.Longitude)
	return nil
}

// AssistantApiCoreTypesCalendarEventWrapper: This empty type allows us
// to publish sensitive calendar events to go/attentional-entities,
// while maintaining BUILD visibility protection for their contents. The
// BUILD-visibility-protected extension to this message is defined at
// http://google3/assistant/verticals/calendar/proto/multi_account_calendar_event.proto
type AssistantApiCoreTypesCalendarEventWrapper struct {
}

// AssistantApiCoreTypesCastAppInfo: The cast app information of the
// provider.
type AssistantApiCoreTypesCastAppInfo struct {
	// CastAppId: The cast app id. |cast_app_id| is the ID of the cast app
	// used on the current device and |content_app_id| is the ID of the app
	// that provides the actual content. For example, in a group playback,
	// on a follower device, the |cast_app_id| is the follower cast app ID
	// and the |content_app_id| is the leader cast app ID.
	CastAppId string `json:"castAppId,omitempty"`

	// ContentAppId: The id of the cast app that provides the content in a
	// group. The field will always be filled. In the case of a group
	// playback and the current device is a follower, the |cast_app_id| has
	// the ID of the follower app, and |content_app_id| has ID of the actual
	// content app. In all other cases, |content_app_id| and |cast_app_id|
	// will be the same.
	ContentAppId string `json:"contentAppId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CastAppId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CastAppId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesCastAppInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesCastAppInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesChromeOsAppInfo: The ChromeOS app information of
// the provider. Next ID: 3
type AssistantApiCoreTypesChromeOsAppInfo struct {
	// LocalizedAppName: The localized app name.
	LocalizedAppName string `json:"localizedAppName,omitempty"`

	// PackageName: Unique package name that identifies a ChromeOS app of
	// the provider.
	PackageName string `json:"packageName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LocalizedAppName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LocalizedAppName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesChromeOsAppInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesChromeOsAppInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesCloudProviderInfo: The third party provider
// information.
type AssistantApiCoreTypesCloudProviderInfo struct {
	AgentStyle *AssistantApiCoreTypesCloudProviderInfoAgentStyle `json:"agentStyle,omitempty"`

	// DirectoryUrl: URL to a directory page about the third party agent in
	// Assistant HQ. This is a universal (https) URL that may be handled
	// natively by clients to show HQ or launch to the HQ directory web
	// page.
	DirectoryUrl string `json:"directoryUrl,omitempty"`

	// LogoUrl: The logo url for the third party provider.
	LogoUrl string `json:"logoUrl,omitempty"`

	// Name: The user visible name of the cloud provider, which may be used
	// for example in the chat header during a conversation with the third
	// party.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AgentStyle") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AgentStyle") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesCloudProviderInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesCloudProviderInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesCloudProviderInfoAgentStyle: The style
// customizations for the 3p agent.
type AssistantApiCoreTypesCloudProviderInfoAgentStyle struct {
	// BackgroundColor: The background color of the agent. Used if no
	// background image is specified for the given display orientation, or
	// if the provided background image does not fit.
	BackgroundColor *AssistantApiCoreTypesGovernedColor `json:"backgroundColor,omitempty"`

	// Possible values:
	//   "DEFAULT" - The client's default theme.
	//   "DARK" - The theme used when the card has a background image. See
	// go/aog-cards-header-theme-dark for details on applying this theme.
	//   "LIGHT" - The theme used when the card has a background color (and
	// no background image). See go/aog-cards-header-theme-light for details
	// on applying this theme.
	HeaderTheme string `json:"headerTheme,omitempty"`

	// LandscapeBackgroundImageUrl: URL for the background image of the
	// agent on landscape display.
	LandscapeBackgroundImageUrl string `json:"landscapeBackgroundImageUrl,omitempty"`

	// LogoUrl: URL for the image containing the 3p logo. This can include
	// logomark and logotype, or logotype only. If present, this can be used
	// in place of the square logo contained in the top level logo_url field
	// in CloudProviderInfo. See go/cards-logo-customization for details on
	// applying this logo.
	LogoUrl string `json:"logoUrl,omitempty"`

	// MaskColor: The color of the mask to apply to the background. See
	// go/aog-cards-background-mask for details on applying this mask.
	MaskColor *AssistantApiCoreTypesGovernedColor `json:"maskColor,omitempty"`

	// PortraitBackgroundImageUrl: URL for the background image of the agent
	// on portrait display.
	PortraitBackgroundImageUrl string `json:"portraitBackgroundImageUrl,omitempty"`

	// PrimaryColor: The primary color of the agent. Used by the client to
	// style the header and suggestion chips.
	PrimaryColor *AssistantApiCoreTypesGovernedColor `json:"primaryColor,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BackgroundColor") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BackgroundColor") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesCloudProviderInfoAgentStyle) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesCloudProviderInfoAgentStyle
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesDeviceConfig: The identification information for
// third party devices that integrates with the assistant. All of these
// fields will be populated by the third party when the query is sent
// from the third party device. Next Id: 5
type AssistantApiCoreTypesDeviceConfig struct {
	// AgentId: Pantheon Project ID that uniquely identifies the consumer
	// project ID. Required
	AgentId string `json:"agentId,omitempty"`

	// DeviceId: Unique identifier for the device. Example: DBCDW098234.
	// Required
	DeviceId string `json:"deviceId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AgentId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AgentId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesDeviceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesDeviceConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesDeviceId: LINT.IfChange(DeviceId) Specifies
// identifier of a device AKA surface. Note there may be multiple device
// ids for the same physical device E.g. Allo app and Assistant app on
// Nexus. Note: DeviceId usage is complicated. Please do not depend on
// it for surface specific logic. Please use
// google3/assistant/api/capabilities.proto instead. IMPORTANT: When
// checking for equality between two `DeviceId`s, you should always use
// an `isSameDevice{As}` function to check for equality, as deep
// equality between `DeviceId`'s is not guaranteed. * C++:
// http://google3/assistant/assistant_server/util/device_id_util.cc;l=23;rcl=421295740
// * Dart:
// http://google3/assistant/context/util/lib/device_id.dart;l=26;rcl=442126145
// * Java:
// http://google3/java/com/google/assistant/assistantserver/utils/DeviceIdHelper.java;l=9;rcl=390378522
// See http://go/deviceid-equality for more details. Next ID: 14
type AssistantApiCoreTypesDeviceId struct {
	// AgsaClientInstanceId: The client_instance_id on devices with GSA. See
	// 'client_instance_field' in go/androidids.
	AgsaClientInstanceId string `json:"agsaClientInstanceId,omitempty"`

	// AlloDeviceId: Allo Id. Corresponds to the GBotRequest.Sender.sender.
	// NOTE(dychen): This may change to standard android/ios physical device
	// ids in order to enable shared data (e.g. installed app on physical
	// device shared between Allo and Opa apps on Nexus).
	AlloDeviceId string `json:"alloDeviceId,omitempty"`

	// CanonicalDeviceId: A unique device ID for Assistant devices as
	// proposed by go/ocelot-team to solve the device id fragmentation
	// problem. The value of this id is the HomeGraph id of the device. See
	// go/ocelot-track-0-registry-design. New surfaces should use the
	// canonical_device_id instead of using other ids, and the registration
	// should utilize the DeviceDataLayer (go/ddl-v0). Please contact the
	// assistant-state-management@ team for guidance. Note: We didn't reuse
	// |home_graph_device_id| because in Assistant code base
	// |home_graph_device_id| is common to associate it with 3P devices. See
	// go/project-yellowstone for more context.
	CanonicalDeviceId string `json:"canonicalDeviceId,omitempty"`

	// CastDeviceId: If set, indicates that the device is a cast device, and
	// contains the UUID of the cast device. Corresponds to the device_id
	// field of the CastDevice proto.
	CastDeviceId string `json:"castDeviceId,omitempty"`

	// ClientInstanceId: DUSI (go/dusi) is used as the identifier here. This
	// identifier is unique to the user and device. This will help identify
	// which device or application the user's request originated from. This
	// is not to be confused with the client_instance_id that android
	// devices provide. This is currently used by surfaces that use the
	// assistant-legacy-nexus and assistant-legacy-clockwork pipelines. DUSI
	// is created and set in S3. This field is only filled for GAIA
	// requests.
	ClientInstanceId string `json:"clientInstanceId,omitempty"`

	// ConnectedDockId: A device ID produced by a connected dock, which is
	// registered in HomeGraph.
	ConnectedDockId string `json:"connectedDockId,omitempty"`

	// DeviceConfig: The unique DeviceConfig to the specific third party
	// device. It is also used by Android Auto Embedded first party device.
	// See go/opa-ids.
	DeviceConfig *AssistantApiCoreTypesDeviceConfig `json:"deviceConfig,omitempty"`

	// DeviceType: DEPRECATED.
	// assistant.api.core_types.governed.SurfaceIdentity.surface_type field
	// should be used instead. The device's surface type. This is the string
	// version of surface_type. The server should use the SurfaceType value
	// derived from this string. If the device_type isn't supported within
	// the SurfaceType enum, it will be set as UNKNOWN. Developers should
	// use the enum in ServerParams instead of this string. WARNING: Clients
	// are not actually setting this field. This field will be removed once
	// references to it within the code base have been removed.
	DeviceType string `json:"deviceType,omitempty"`

	// HomeGraphDeviceId: The unique device ID for HomeGraph devices. This
	// is the HomeGraph ID, created when the device is registered into
	// HomeGraph. It is immutable for the same device unless it is
	// completely deleted and recreated. See go/home-graph for details.
	HomeGraphDeviceId string `json:"homeGraphDeviceId,omitempty"`

	// LibassistantDeviceId: The unique ID for libassistant based devices.
	// See go/libassistant-id for details.
	LibassistantDeviceId string `json:"libassistantDeviceId,omitempty"`

	// MultiHotwordArbitrationDeviceId: If set, indicates that the device is
	// participating the multi-hotword arbitration and the id is an UUID to
	// distinguish it from other devices. It should also be consistent
	// between requests from a single device within a session (or short
	// duration).
	MultiHotwordArbitrationDeviceId string `json:"multiHotwordArbitrationDeviceId,omitempty"`

	// OpaIosDeviceId: The unique device ID for the Assistant App on iOS.
	// See go/opa-ios-design for details.
	OpaIosDeviceId string `json:"opaIosDeviceId,omitempty"`

	// QuartzDeviceId: The unique ID of a Quartz device. See
	// go/quartz-design-doc for more details. Quartz ID is a hash of
	// (android_id + gaia).
	QuartzDeviceId string `json:"quartzDeviceId,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AgsaClientInstanceId") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AgsaClientInstanceId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesDeviceId) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesDeviceId
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesDeviceUserIdentity: LINT.IfChange
type AssistantApiCoreTypesDeviceUserIdentity struct {
	// DeviceId: The identifier of the device.
	DeviceId *AssistantApiCoreTypesDeviceId `json:"deviceId,omitempty"`

	// GaiaId: The identifier of the user.
	GaiaId int64 `json:"gaiaId,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "DeviceId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeviceId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesDeviceUserIdentity) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesDeviceUserIdentity
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesGovernedColor: LINT.IfChange Represents a color
// in the RGBA color space. This message mirrors google.type.Color.
// IMPORTANT: The definition of Color proto is being moved to
// //assistant/api/core_types/color_type.proto. All existing references
// will be updated to point to the new location. If you are adding a
// reference, use the new one instead.
type AssistantApiCoreTypesGovernedColor struct {
	// Alpha: The fraction of this color that should be applied to the
	// pixel. That is, the final pixel color is defined by the equation:
	// pixel color = alpha * (this color) + (1.0 - alpha) * (background
	// color) This means that a value of 1.0 corresponds to a solid color,
	// whereas a value of 0.0 corresponds to a completely transparent color.
	// If omitted, this color object is to be rendered as a solid color (as
	// if the alpha value had been explicitly given with a value of 1.0).
	Alpha float64 `json:"alpha,omitempty"`

	// Blue: The amount of blue in the color as a value in the interval [0,
	// 1].
	Blue float64 `json:"blue,omitempty"`

	// Green: The amount of green in the color as a value in the interval
	// [0, 1].
	Green float64 `json:"green,omitempty"`

	// Red: The amount of red in the color as a value in the interval [0,
	// 1].
	Red float64 `json:"red,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Alpha") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Alpha") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesGovernedColor) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesGovernedColor
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *AssistantApiCoreTypesGovernedColor) UnmarshalJSON(data []byte) error {
	type NoMethod AssistantApiCoreTypesGovernedColor
	var s1 struct {
		Alpha gensupport.JSONFloat64 `json:"alpha"`
		Blue  gensupport.JSONFloat64 `json:"blue"`
		Green gensupport.JSONFloat64 `json:"green"`
		Red   gensupport.JSONFloat64 `json:"red"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Alpha = float64(s1.Alpha)
	s.Blue = float64(s1.Blue)
	s.Green = float64(s1.Green)
	s.Red = float64(s1.Red)
	return nil
}

// AssistantApiCoreTypesGovernedDeviceConfig: The identification
// information for third party devices that integrates with the
// assistant. All of these fields will be populated by the third party
// when the query is sent from the third party device. IMPORTANT: The
// definition of DeviceConfig proto is being moved to
// //assistant/api/core_types/device_type.proto. All existing references
// will be updated to point to the new location. If you are adding a
// reference, use the new one instead. Next Id: 5
type AssistantApiCoreTypesGovernedDeviceConfig struct {
	// AgentId: Pantheon Project ID that uniquely identifies the consumer
	// project ID. Required
	AgentId string `json:"agentId,omitempty"`

	// DeviceId: Unique identifier for the device. Example: DBCDW098234.
	// Required
	DeviceId string `json:"deviceId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AgentId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AgentId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesGovernedDeviceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesGovernedDeviceConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesGovernedDeviceId: LINT.IfChange Specifies
// identifier of a device AKA surface. Note there may be multiple device
// ids for the same physical device E.g. Allo app and Assistant app on
// Nexus. Note: DeviceId usage is complicated. Please do not depend on
// it for surface specific logic. Please use
// google3/assistant/api/capabilities.proto instead. IMPORTANT: When
// checking for equality between two `DeviceId`s, you should always use
// an `isSameDevice{As}` function to check for equality, as deep
// equality between `DeviceId`'s is not guaranteed. * C++:
// http://google3/assistant/assistant_server/util/device_id_util.cc;l=23;rcl=421295740
// * Dart:
// http://google3/assistant/context/util/lib/device_id.dart;l=26;rcl=442126145
// * Java:
// http://google3/java/com/google/assistant/assistantserver/utils/DeviceIdHelper.java;l=9;rcl=390378522
// See http://go/deviceid-equality for more details. IMPORTANT: The
// definition of DeviceId proto is being moved to
// //assistant/api/core_types/device_type.proto. All existing references
// will be updated to point to the new location. If you are adding a
// reference, use the new one instead. Next ID: 14
type AssistantApiCoreTypesGovernedDeviceId struct {
	// AgsaClientInstanceId: The client_instance_id on devices with GSA. See
	// 'client_instance_field' in go/androidids.
	AgsaClientInstanceId string `json:"agsaClientInstanceId,omitempty"`

	// AlloDeviceId: Allo Id. Corresponds to the GBotRequest.Sender.sender.
	// NOTE(dychen): This may change to standard android/ios physical device
	// ids in order to enable shared data (e.g. installed app on physical
	// device shared between Allo and Opa apps on Nexus).
	AlloDeviceId string `json:"alloDeviceId,omitempty"`

	// CanonicalDeviceId: A unique device ID for Assistant devices as
	// proposed by go/ocelot-team to solve the device id fragmentation
	// problem. The value of this id is the HomeGraph id of the device. See
	// go/ocelot-track-0-registry-design. New surfaces should use the
	// canonical_device_id instead of using other ids, and the registration
	// should utilize the DeviceDataLayer (go/ddl-v0). Please contact the
	// assistant-state-management@ team for guidance. Note: We didn't reuse
	// |home_graph_device_id| because in Assistant code base
	// |home_graph_device_id| is common to associate it with 3P devices. See
	// go/project-yellowstone for more context.
	CanonicalDeviceId string `json:"canonicalDeviceId,omitempty"`

	// CastDeviceId: If set, indicates that the device is a cast device, and
	// contains the UUID of the cast device. Corresponds to the device_id
	// field of the CastDevice proto.
	CastDeviceId string `json:"castDeviceId,omitempty"`

	// ClientInstanceId: DUSI (go/dusi) is used as the identifier here. This
	// identifier is unique to the user and device. This will help identify
	// which device or application the user's request originated from. This
	// is not to be confused with the client_instance_id that android
	// devices provide. This is currently used by surfaces that use the
	// assistant-legacy-nexus and assistant-legacy-clockwork pipelines. DUSI
	// is created and set in S3. This field is only filled for GAIA
	// requests.
	ClientInstanceId string `json:"clientInstanceId,omitempty"`

	// ConnectedDockId: A device ID produced by a connected dock, which is
	// registered in HomeGraph.
	ConnectedDockId string `json:"connectedDockId,omitempty"`

	// DeviceConfig: The unique DeviceConfig to the specific third party
	// device. It is also used by Android Auto Embedded first party device.
	// See go/opa-ids.
	DeviceConfig *AssistantApiCoreTypesGovernedDeviceConfig `json:"deviceConfig,omitempty"`

	// DeviceType: DEPRECATED.
	// assistant.api.core_types.governed.SurfaceIdentity.surface_type field
	// should be used instead. The device's surface type. This is the string
	// version of surface_type. The server should use the SurfaceType value
	// derived from this string. If the device_type isn't supported within
	// the SurfaceType enum, it will be set as UNKNOWN. Developers should
	// use the enum in ServerParams instead of this string. WARNING: Clients
	// are not actually setting this field. This field will be removed once
	// references to it within the code base have been removed.
	DeviceType string `json:"deviceType,omitempty"`

	// HomeGraphDeviceId: The unique device ID for HomeGraph devices. This
	// is the HomeGraph ID, created when the device is registered into
	// HomeGraph. It is immutable for the same device unless it is
	// completely deleted and recreated. See go/home-graph for details.
	HomeGraphDeviceId string `json:"homeGraphDeviceId,omitempty"`

	// LibassistantDeviceId: The unique ID for libassistant based devices.
	// See go/libassistant-id for details.
	LibassistantDeviceId string `json:"libassistantDeviceId,omitempty"`

	// MultiHotwordArbitrationDeviceId: If set, indicates that the device is
	// participating the multi-hotword arbitration and the id is an UUID to
	// distinguish it from other devices. It should also be consistent
	// between requests from a single device within a session (or short
	// duration).
	MultiHotwordArbitrationDeviceId string `json:"multiHotwordArbitrationDeviceId,omitempty"`

	// OpaIosDeviceId: The unique device ID for the Assistant App on iOS.
	// See go/opa-ios-design for details.
	OpaIosDeviceId string `json:"opaIosDeviceId,omitempty"`

	// QuartzDeviceId: The unique ID of a Quartz device. See
	// go/quartz-design-doc for more details. Quartz ID is a hash of
	// (android_id + gaia).
	QuartzDeviceId string `json:"quartzDeviceId,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AgsaClientInstanceId") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AgsaClientInstanceId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesGovernedDeviceId) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesGovernedDeviceId
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesGovernedRingtoneTaskMetadata: LINT.IfChange Task
// metadata information describing the ringtone. IMPORTANT: The
// definition of RingtoneTaskMetadata proto is being moved to
// //assistant/api/core_types/ringtone_task_metadata.proto. All existing
// references will be updated to point to the new location. If you are
// adding a reference, use the new one instead. Next id: 11
type AssistantApiCoreTypesGovernedRingtoneTaskMetadata struct {
	// Category: The category related with the ringtone. It's used to
	// generate ringtone related with the category if the entity_mid is not
	// be populated. E.g. for instrument, the ringtone may be piano sound.
	//
	// Possible values:
	//   "UNKNOWN_CATEGORY"
	//   "ANIMAL"
	//   "CHARACTER" - Character alarm is a kind of media alarm. CHARACTER
	// category should be removed. Use MEDIA for character alarms
	//   "EMOTION"
	//   "INSTRUMENT"
	//   "MEDIA"
	//   "SPORTS_EQUIPMENT"
	//   "VEHICLE"
	//   "ON_DEVICE" - An alarm sound that the user can select to play when
	// an alarm is firing, the alarm sound resource is located on device in
	// libassistant.
	//   "FUNTIME" - An alarm sound that is based upon the label that the
	// timer or alarm is invoked with (ie pizza timer invokes an Italian
	// accordian theme). The assets are streamed from web storage.
	Category string `json:"category,omitempty"`

	CharacterAlarmMetadata *AssistantApiCoreTypesGovernedRingtoneTaskMetadataCharacterAlarmMetadata `json:"characterAlarmMetadata,omitempty"`

	CharacterTag string `json:"characterTag,omitempty"`

	// EntityMid: The freebase mid of the entity related to the ringtone. It
	// will be used to generate the ringtone for the alarm or timer (with
	// support for i18n). For instance, for the "cat" mid, the related
	// ringtone will be a cat sound in some language, and for the "Beyonce"
	// mid, the ringtone will be, e.g., a playlist of Beyonce's best hits.
	EntityMid string `json:"entityMid,omitempty"`

	FuntimeMetadata *AssistantApiCoreTypesGovernedRingtoneTaskMetadataFuntimeMetadata `json:"funtimeMetadata,omitempty"`

	GenMlAlarmMetadata *AssistantApiCoreTypesGovernedRingtoneTaskMetadataGenMlAlarmMetadata `json:"genMlAlarmMetadata,omitempty"`

	// GentleWakeInfo: Gentle wake information for this alarm.
	GentleWakeInfo *AssistantApiCoreTypesGovernedRingtoneTaskMetadataGentleWakeInfo `json:"gentleWakeInfo,omitempty"`

	OnDeviceAlarmMetadata *AssistantApiCoreTypesGovernedRingtoneTaskMetadataOnDeviceAlarmMetadata `json:"onDeviceAlarmMetadata,omitempty"`

	// OnDeviceAlarmSound: Will be deprecated. Use OnDeviceAlarmMetadata.
	//
	// Possible values:
	//   "DEFAULT"
	//   "MELLOW"
	//   "MODERN_TIMES"
	//   "BEAUTIFUL_MIND"
	//   "LITTLE_SUNSHINE"
	//   "TOUCH_OF_ZEN"
	//   "ABOUT_TIME"
	//   "RANDOM"
	//   "BOROBUDUR"
	//   "PEBBLES"
	//   "BRIGHT_MORNING"
	//   "ACROSS_THE_VALLEY"
	//   "MORNING_SONG"
	//   "KYOTO"
	//   "AWAKEN"
	//   "CUCKOO"
	//   "DIGITAL_BLAST"
	//   "ACOUSTIC_SUNLIGHT"
	//   "SUNRISE_BOSSA"
	//   "CALM_GLOW"
	//   "ANTIQUE_CLOCK"
	//   "JUST_BIRDS"
	//   "JUNGLE_AMBIENCE"
	//   "QUAINT_VILLAGE"
	//   "BUBBLY_BOSSA"
	//   "ACOUSTIC_JAM"
	//   "EUPHORIC"
	OnDeviceAlarmSound string `json:"onDeviceAlarmSound,omitempty"`

	RoutineAlarmMetadata *AssistantApiCoreTypesGovernedRingtoneTaskMetadataRoutineAlarmMetadata `json:"routineAlarmMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Category") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Category") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesGovernedRingtoneTaskMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesGovernedRingtoneTaskMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiCoreTypesGovernedRingtoneTaskMetadataCharacterAlarmMetadata struct {
	// AgentIds: For character alarm, the media resources are provided
	// through AOG apps. During alarm trigger phase, aog apps with the
	// specified agent_ids are used to get the media resources. Multiple
	// "AoG agents" can satisfy a character_tag. So the user will select the
	// agents they want at alarm creation time. The chosen agents will be
	// recorded so that the resources only from those agents will be used at
	// trigger time. The number of selected agent_ids will not exceed 3. See
	// go/character-alarm-aog.
	AgentIds []string `json:"agentIds,omitempty"`

	// CharacterTags: The Character Alarm tag. Tags are needed to identify
	// the theme of the alarm. For example, if the tag is 'astronaut',
	// astronaut based audio is played during alarm ring. Note : We have
	// made it repeated so that the user can choose multiple character alarm
	// themes at one go. At present, the user is allowed to choose only one
	// theme during alarm creation.
	CharacterTags []string `json:"characterTags,omitempty"`

	// IconUrls: Icons urls corresponding to a character. Note : We have
	// made it repeated so that we can show different images when the alarm
	// rings. At present, we only support only one image.
	IconUrls []string `json:"iconUrls,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AgentIds") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AgentIds") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesGovernedRingtoneTaskMetadataCharacterAlarmMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesGovernedRingtoneTaskMetadataCharacterAlarmMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesGovernedRingtoneTaskMetadataFuntimeMetadata:
// Used to make timers and alarms more delightful. See
// go/funtime-engdesign for more details.
type AssistantApiCoreTypesGovernedRingtoneTaskMetadataFuntimeMetadata struct {
	// AgentIds: For FunTime alarms and timers, the media resources are
	// provided through AOG apps during their ringtone. Multiple AoG agents
	// can satisfy a label. So a random agent will be chosen from those that
	// are supplied. See go/funtime-engdesign.
	AgentIds []string `json:"agentIds,omitempty"`

	// AnimationBlob: These bytes may represent the blob of the Rive
	// animation that we pass to the Opal App. We will deprecate this field
	// if we figure out a solution to load the animation from the web.
	AnimationBlob string `json:"animationBlob,omitempty"`

	// AnimationUrl: Url for Rive animation that is brought up on ring. Rive
	// is a lightweight animation library that is compatible with Flutter on
	// Opal. See https://rive.app/.
	AnimationUrl string `json:"animationUrl,omitempty"`

	// TimerHeroUrl: The url used to load the image that is at the center of
	// the timer during timer countdown visuals.
	TimerHeroUrl string `json:"timerHeroUrl,omitempty"`

	// TtsServiceRequestBytes: This is used to call S3 to realize the TTS.
	// Is in the form of bytes because of a circular dependency issue in
	// libassistant protos. It is a serialized proto of type
	// speech.s3.TtsServiceRequest.
	TtsServiceRequestBytes string `json:"ttsServiceRequestBytes,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AgentIds") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AgentIds") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesGovernedRingtoneTaskMetadataFuntimeMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesGovernedRingtoneTaskMetadataFuntimeMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesGovernedRingtoneTaskMetadataGenMlAlarmMetadata:
// Metadata for machine learning generated audio samples. This will be
// similar to character alarms, Category will be set MEDIA but this
// metadata field will be used to identify the ringtone type on surface.
// (go/magenta-alarm-ringtones).
type AssistantApiCoreTypesGovernedRingtoneTaskMetadataGenMlAlarmMetadata struct {
	IsEnabled bool `json:"isEnabled,omitempty"`

	// RingtoneLabel: Label for the generated ringtone.
	RingtoneLabel string `json:"ringtoneLabel,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IsEnabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IsEnabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesGovernedRingtoneTaskMetadataGenMlAlarmMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesGovernedRingtoneTaskMetadataGenMlAlarmMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesGovernedRingtoneTaskMetadataGentleWakeInfo:
// Gentle wake actions like slowly brightening the room/device screen
// leading up to the alarm firing (go/cube-gentle-wake-up).
type AssistantApiCoreTypesGovernedRingtoneTaskMetadataGentleWakeInfo struct {
	// EffectDurationMs: Specifies how long the effect lasts. Allowed for
	// effect to last after the alarm has started ringing. If unset or
	// negative or 0, effect is assumed to last until alarm trigger time.
	EffectDurationMs int64 `json:"effectDurationMs,omitempty,string"`

	// IsEnabled: Indicates if gentle wake action is to be performed before
	// this alarm fires. This is enabled only if the device supports sunrise
	// alarm capability.
	// http://cs/symbol:assistant.api.SunriseFeaturesSupport
	IsEnabled bool `json:"isEnabled,omitempty"`

	// StartTimedeltaMs: Specifies how long before the alarm fire time, the
	// wakeup effect will start. ALWAYS POSITIVE.
	StartTimedeltaMs int64 `json:"startTimedeltaMs,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "EffectDurationMs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EffectDurationMs") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesGovernedRingtoneTaskMetadataGentleWakeInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesGovernedRingtoneTaskMetadataGentleWakeInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesGovernedRingtoneTaskMetadataOnDeviceAlarmMetadata
// : This describes the alarm sound resource enum and the alarm sound
// label for the on device alarm sound. On-device ringtones are product
// specific, hence Opal/UI layer will be responsible for populating this
// metadata at creation/edit. The enum map will be used to convert to an
// internal resource id used by libassistant for accessing the asset
// which are not exposed to UI.
type AssistantApiCoreTypesGovernedRingtoneTaskMetadataOnDeviceAlarmMetadata struct {
	// OnDeviceAlarmSound: Opal/UI layer will set this bit based on the user
	// selection.
	//
	// Possible values:
	//   "DEFAULT"
	//   "MELLOW"
	//   "MODERN_TIMES"
	//   "BEAUTIFUL_MIND"
	//   "LITTLE_SUNSHINE"
	//   "TOUCH_OF_ZEN"
	//   "ABOUT_TIME"
	//   "RANDOM"
	//   "BOROBUDUR"
	//   "PEBBLES"
	//   "BRIGHT_MORNING"
	//   "ACROSS_THE_VALLEY"
	//   "MORNING_SONG"
	//   "KYOTO"
	//   "AWAKEN"
	//   "CUCKOO"
	//   "DIGITAL_BLAST"
	//   "ACOUSTIC_SUNLIGHT"
	//   "SUNRISE_BOSSA"
	//   "CALM_GLOW"
	//   "ANTIQUE_CLOCK"
	//   "JUST_BIRDS"
	//   "JUNGLE_AMBIENCE"
	//   "QUAINT_VILLAGE"
	//   "BUBBLY_BOSSA"
	//   "ACOUSTIC_JAM"
	//   "EUPHORIC"
	OnDeviceAlarmSound string `json:"onDeviceAlarmSound,omitempty"`

	// OnDeviceAlarmSoundLabel: A string label to identify the alarm sound
	// name. Opal/UI layer will set this as per product definition. This
	// will be used to display the name of the selected ringtone.
	OnDeviceAlarmSoundLabel string `json:"onDeviceAlarmSoundLabel,omitempty"`

	// TtsServiceRequestBytes: This is used to call S3 to realize the TTS.
	// Is in the form of bytes because of a circular dependency issue in
	// libassistant protos. It is a serialized proto of type
	// speech.s3.TtsServiceRequest. This request will contain an ssml with
	// the url to the ringtone files hosted on gstatic.
	TtsServiceRequestBytes string `json:"ttsServiceRequestBytes,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OnDeviceAlarmSound")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OnDeviceAlarmSound") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesGovernedRingtoneTaskMetadataOnDeviceAlarmMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesGovernedRingtoneTaskMetadataOnDeviceAlarmMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiCoreTypesGovernedRingtoneTaskMetadataRoutineAlarmMetadata struct {
	// RoutineId: The unique id for each routine. When the alrm is
	// dismissed, it will trigger the routine of the routine alarm's creator
	// if feasible.
	RoutineId string `json:"routineId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RoutineId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RoutineId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesGovernedRingtoneTaskMetadataRoutineAlarmMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesGovernedRingtoneTaskMetadataRoutineAlarmMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesGovernedSurfaceIdentity: The set of information
// that helps the server identify the surface. This replaces the
// User-Agent string within the Assistant Server. Note: The
// SurfaceIdentity proto should only be used to derive the capabilities
// of a surface. It should not be accessed outside of the
// CapabilityBuilder or CapabilityChecker. IMPORTANT: The partial
// migration to the SurfaceIdentity and SurfaceVersion protos defined
// here is being rolled back (b/303012824). All existing references will
// be updated to point back to
// //assistant/api/core_types/surface_identity.proto. If you are adding
// a reference, use the SurfaceIdentity and SurfaceVersion protos
// defined there. NEXT ID: 6 LINT.IfChange
type AssistantApiCoreTypesGovernedSurfaceIdentity struct {
	// DeviceId: The identifier of the device.
	DeviceId *AssistantApiCoreTypesDeviceId `json:"deviceId,omitempty"`

	// LegacySurfaceType: DEPRECATED: The legacy device's surface type enum.
	// NOTE: Prefer using the ontological `surface_type` field above. If you
	// need to access the legacy surface type, please file a bug and add it
	// in your code to migrate to ontological surface type.
	//
	// Possible values:
	//   "UNKNOWN"
	//   "ANDROID_ALLO"
	//   "ANDROID_AUTO" - Deprecated (never used). Use OPA_ANDROID_AUTO
	// instead.
	//   "ANDROID_THINGS_CUBE" - Assistant on small screen stationary
	// device.
	//   "ANDROID_THINGS_JASPER"
	//   "ANDROID_TV"
	//   "ANDROID_TV_KIDS"
	//   "ANDROID_WEAR"
	//   "AR_GLASSES" - Assistant on AR Glasses with both visual and audio
	// experiences. Ask ar-assistant@ for details.
	//   "ASSISTANT_SDK" - For Assistant SDK gRPC client.
	//   "AUDIOWEAR"
	//   "BUBBLE_CHARACTERS_IOS" - go/assistant-lamda-overview-characters
	//   "CAPABILITY_BASED_SURFACE" - Surface for capability based testing.
	//   "CHROMECAST_ASSISTANT" - For chrome cast assistant web app.
	//   "CHROMECAST_MANHATTAN" - For chrome cast with assistant + screen
	// (e.g., Google Nest Hub).
	//   "CHROMECAST_SEARCH"
	//   "CLOUD_DEVICE" - Virtual device for event-based triggering, e.g.
	// executing time
	//   "COMPANION_SCREEN" - scheduled routines: go/routine-cloud-ex For
	// Quartz.
	//   "DYNAMITE_WEB"
	//   "ENSEMBLE"
	//   "EYESFREE_AGSA" - Deprecated. Please use OPA_ANDROID_SCREENLESS.
	//   "EYESFREE_GMM"
	//   "GBOARD" - For Gboard app
	//   "GLASS"
	//   "GOOGLE_HOME"
	//   "HANGOUTS_CHATBOT"
	//   "IOS_ALLO"
	//   "IOS_GSA"
	//   "IOS_WEAR"
	//   "LIBASSISTANT" - For standalone libassistant devices.
	//   "LINE_CHATBOT" - LINE 3P messaging app
	//   "MULTIMODAL_AGSA" - Deprecated.
	//   "NON_ASSISTANT_SURFACE" - Surfaces that do not speak to the
	// Assistant, i.e. web HQ
	//   "OPA_AGSA" - Assistant on Android phones accessed through the
	// Google App (velvet). This represents neither all of the assistant on
	// android phones (ANDROID_ALLO, VERILY_ONDUO, etc.) nor all of the
	// assistant built on top of AGSA (ANDROID_WEAR, OPA_ANDROID_SCREENLESS,
	// OPA_AGSA_CHROME_OS, etc.).
	//   "OPA_AGSA_CHROME_OS" - Deprecated. Please use OPA_CROS.
	//   "OPA_ANDROID_AUTO"
	//   "OPA_ANDROID_LITE" - This is OPA on Android Go (not part of AGSA)
	//   "OPA_ANDROID_SCREENLESS" - Assistant on Nexus with screen
	// off/locked. Use go/bisto device to trigger.
	//   "OPA_ANDROID_SMART_DISPLAY" - Assistant on Titan hub mode
	// (go/titan-hubmode-surface). This is OPA Android first party Smart
	// Display devices. The UI experience is built on Opal (Gallium and
	// Flutter) and native Android.
	//   "OPA_ANDROID_TABLET" - Assistant on Android tablet
	//   "OPA_CROS" - Assistant on native Chrome OS (go/croissant).
	//   "OPA_GACS" - For assistant on GACS devices (go/gacs-dd). Google
	// Assistant Conversation Service (GACS) defines intents the device
	// accepts. This surface serves the intents in the assistant response.
	//   "OPA_IOS"
	//   "OPA_IOS_SCREENLESS" - Assistant on iOS with screen off/locked. Use
	// go/bisto device to trigger.
	//   "OPA_KAIOS" - Assistant on KaiOS. go/kaiosama
	//   "OPA_MOBILE_WEB" - Assistant on Mobile Web. go/opa-spidey
	//   "RTOS_PHONE" - Assistant on low-cost RTOS phones (go/conceRTOS).
	//   "SMS_CHATBOT"
	//   "TELEGRAM_CHATBOT" - Telegram 3P messaging app
	//   "TELEPHONE_ASSISTANT" - Assistant on a phone call (go/telephone).
	//   "VERILY_ONDUO"
	//   "YOUTUBE_APP" - A Youtube app.
	//   "AGSA_BISTO_FOR_EVAL" - Eval-only surfaces. These surfaces are not
	// real surfaces. They are only used in intermediate steps of eval query
	// and request generation: 1. Eval samplers (OPA query sampler and
	// Cannery sampler) checks logs and temporarily assigns these surface
	// types to the logs, to put Bisto, Lockhart Mic, ... queries in the
	// correct query pools. 2. Request builders uses these surface types to
	// determine how TaskRequest for Bisto, Lockhart Mic, ... should be
	// built, like whether some user user agent should be used, whether some
	// entry source should be set. The surface types in the generated
	// TaskRequest is still the production surface types, like
	// OPA_ANDROID_SCREENLESS or OPA_AGSA. Temp surface for Bisto Android
	// eval. Will be merged with OPA_ANDROID_SCREENLESS in the future.
	//   "COGSWORTH_FOR_EVAL"
	//   "LOCKHART_MIC_FOR_EVAL"
	//   "OPA_ANDROID_AUTO_EMBEDDED_FAKE" - OPA_ANDROID_AUTO has another
	// sub-surface (embedded) that differs in the reported capabilities,
	// client-ops, flags but uses the same surface_type string of
	// OPA_ANDROID_AUTO. This fake surface would allow running turing2 tests
	// and evals for this embedded surface. Deprecated as of Feb 2019.
	// Please use "OPA_ANDROID_AUTO_EMBEDDED" client type for tests and
	// eval. See go/client-onboarding for more details.
	// https://cs.corp.google.com/piper///depot/google3/assistant/assistant_server/tools/util/consts.h?l=32&rcl=247481455
	//   "SPARK" - Unlaunched new surface prototype, ask spark-eng@.
	//   "WALLE" - Wall-E is an Area120 Project building assistant powered
	// robots. The surface is an extended joplin which have same
	// capabilities as a google home adding custom robot features. Currently
	// in active development. Please reach out walle-software@ or bingxin@
	// for questions. For details see go/walle-as-pipeline-1-pager.
	//   "UNIT_TESTING" - Surface used for unit-testing purposes. Unit-tests
	// might still require the existence of a "valid" SurfaceType to succeed
	// (eg. initialization of the CapabilityBuilder, proto matching, etc.).
	// With the move away from SurfaceType checks, a generic "TESTING"
	// SurfaceType can be used for such tests without affecting the test
	// behavior. Unlike the CAPABILITY_BASED_SURFACE, this proto does not
	// have any capabilities or ResponseType tied to it. It should only be
	// used for unit-tests and should not be exposed in the ASDebugger.
	LegacySurfaceType string `json:"legacySurfaceType,omitempty"`

	// SurfaceType: The device's surface type. The types are defined at
	// google3/assistant/api/core_types/surfaces.gcl.
	//
	// Possible values:
	//   "UNKNOWN_TYPE" - Unknown surface type.
	//   "ACCL" - Android conversation client library (go/accl) is an
	// Android library which implements the Conversation Protocol that
	// allows a surface to have conversations with the Assistant server.
	// OWNERS: surfaces-infra-core@
	//   "AGSA" - Android Google Search App (go/agsa). OWNERS:
	// surfaces-infra-core@
	//   "ANDROID" - Android. OWNERS: surfaces-infra-core@
	//   "ANDROID_AUTO" - Assistant on Android Auto (go/ast-auto). OWNERS:
	// opa-android-leads@
	//   "ANDROID_LITE" - Assistant on Android Go (not part of AGSA).
	// OWNERS: assistantgo-eng@
	//   "ANDROID_PHONE" - Assistant on Android phones accessed through the
	// Google App (velvet). This surface is formerly known as OPA_AGSA.
	// OWNERS: opa-android-leads@
	//   "ANDROID_SCREENLESS" - Assistant on Nexus with screen off/locked.
	// Use go/bisto device to trigger. OWNERS: opa-android-leads@
	//   "ANDROID_SMART_DISPLAY" - Assistant on Titan hub mode
	// (go/titan-hubmode-surface). This is OPA Android first party Smart
	// Display devices. The UI experience is built on Opal (Gallium and
	// Flutter) and native Android. OWNERS: opa-android-leads@
	//   "ANDROID_TABLET" - Assistant on Android tablet. OWNERS:
	// opa-android-leads@
	//   "ANDROID_THINGS" - Android Things (go/things). OWNERS:
	// surfaces-infra-core@
	//   "ANDROID_THINGS_CUBE" - Lenovo Smart Clock v1, a stationary smart
	// display device with a 4-inch screen, targeted for bedroom/bedside use
	// cases like alarm, sleep tracking. Based on Android Things. See
	// go/cube-home. OWNERS: cube-eng@
	//   "ANDROID_THINGS_JASPER" - Former codename for 3P 8-inch and 10-inch
	// Smart Displays from Lenovo, JBL and LG, targeted for use in the
	// kitchen. Based on Android Things. See go/jasper-home. OWNERS:
	// jasper-eng@
	//   "ANDROID_TV" - The Android platform that powers smart televisions,
	// set-top-boxes, and over-the-top devices. See go/atv-eng and
	// go/opa-tv. OWNERS: opa-tv-eng@
	//   "ANDROID_WEAR" - Legacy Wear OS Assistant. OWNERS:
	// wear-assistant-eng@
	//   "ASSISTANT_KIT" - AssistantKit (go/assistantkit) is a collection of
	// iOS libraries allowing first party apps to integrate Google Assistant
	// features. OWNERS: assistantkit-eng@
	//   "ASSISTANT_SDK" - Standalone gRPC based client. See go/easi.
	// OWNERS: assistant-sdk-service-eng@
	//   "AUTO" - Automobile. OWNERS: surfaces-infra-core@
	//   "CAST_OS" - Cast OS (go/opal-castos-docs#what-is-castos). OWNERS:
	// surfaces-infra-core@
	//   "CHROME_OS" - Chrome OS (go/chromsos) OWNERS: surfaces-infra-core@
	//   "CHROMECAST_MANHATTAN" - For chromecast with assistant + screen,
	// e.g. Newman. OWNERS: cast-eng-platform@
	//   "CLOUD_DEVICE" - Virtual device for event-based triggering, e.g.
	// executing time scheduled routines: go/scheduled-routines. OWNERS:
	// surfaces-infra-core@
	//   "CROS" - Assistant on native Chrome OS (go/croissant). OWNERS:
	// croissant@
	//   "FITBIT_OS_WATCH" - Assistant on Fitbit OS Watch. OWNERS:
	// assistant-wearable-team@
	//   "FITBIT_OS_WATCH_ANDROID" - Assistant on Fitbit Watch paired with
	// AGSA. OWNERS: assistant-wearable-team@
	//   "FITBIT_OS_WATCH_IOS" - Assistant on Fitbit Watch paired with iOPA.
	// OWNERS: assistant-wearable-team@
	//   "GOOGLE_HOME" - Google home speaker, i.e., Chirp devices. See
	// go/assistant-speakers. OWNERS: assistant-speaker-leads@
	//   "HEADPHONE" - Headphone. OWNERS: surfaces-infra-core@
	//   "HEADPHONE_ANDROID" - Assistant on headphones paired with AGSA.
	// OWNERS: assistant-wearable-team@
	//   "HEADPHONE_IOS" - Assistant on headphones paired with iOPA. OWNERS:
	// assistant-wearable-team@
	//   "IOPA" - Assistant on iOS devices (go/opa-ios). OWNERS:
	// opa-ios-eng@
	//   "IOS" - iOS. OWNERS: surfaces-infra-core@
	//   "IOS_SCREENLESS" - Assistant on iOS with screen off/locked. Use
	// go/bisto device to trigger. OWNERS: bisto-team@
	//   "IPAD" - iPad devices. OWNERS: surfaces-infra-core@
	//   "IPHONE" - iPhone devices. OWNERS: surfaces-infra-core@
	//   "KAI_OS" - Kai OS (go/kaios). OWNERS: surfaces-infra-core@
	//   "KAI_OS_AMA" - Assistant on KaiOS (go/kaiosama). OWNERS:
	// assistant-kaios-eng@
	//   "LIBASSISTANT" - LibAssistant (go/libassistant) C++ SDK that powers
	// Assistant experience on both 1P devices like Google Home and 3P
	// devices like Sonos. OWNERS: libassistant-core@
	//   "PHONE" - A phone. OWNERS: surfaces-infra-core@
	//   "PIXEL" - Pixel devices. OWNERS: surfaces-infra-core@
	//   "PIXEL5" - Pixel 5. OWNERS: surfaces-infra-core@
	//   "PIXEL6" - Pixel 6. OWNERS: surfaces-infra-core@
	//   "PIXEL7" - Pixel 7. OWNERS: surfaces-infra-core@
	//   "PIXEL8" - Pixel 8. OWNERS: surfaces-infra-core@
	//   "PIXEL_BUDS" - Assistant on Pixel Buds. OWNERS:
	// assistant-wearable-team@
	//   "PIXEL_TABLET" - Assistant on Pixel Tablet/Tangor (a.k.a, TK).
	// OWNERS: assistant-display-eng@
	//   "PIXEL_TABLET_HUB_MODE" - Assistant on Tangor running in Hub mode.
	// OWNERS: assistant-display-eng@
	//   "PIXEL_TABLET_PERSONAL_MODE" - Assistant on Tangor running in
	// Personal mode. OWNERS: assistant-display-eng@
	//   "PIXEL_WATCH" - Assistant on Pixel Watch (a.k.a., Rohan). OWNERS:
	// assistant-wearable-team@
	//   "SCREENLESS" - Devices with screen off or locked (go/bisto).
	// OWNERS: surfaces-infra-core@
	//   "SMART_DISPLAY" - Smart surface, such as Titan. OWNERS:
	// surfaces-infra-core@
	//   "SPEAKER" - A speaker. OWNERS: surfaces-infra-core@
	//   "TABLET" - A tablet. OWNERS: surfaces-infra-core@
	//   "TELEPHONE" - Assistant on a phone call (go/telephone). OWNERS:
	// telephone-assistant-eng@
	//   "THING" - IoT device. OWNERS: surfaces-infra-core@
	//   "WATCH" - Watch. OWNERS: surfaces-infra-core@
	//   "WEAR_OS" - Wear OS. OWNERS: surfaces-infra-core@
	//   "WEAR_OS_WATCH" - Assistant on Wear OS Watch (a.k.a., Edoras).
	// OWNERS: assistant-wearable-team@
	SurfaceType string `json:"surfaceType,omitempty"`

	// SurfaceVersion: The version of the surface/client. This is different
	// from the Conversation protocol version.
	SurfaceVersion *AssistantApiCoreTypesGovernedSurfaceVersion `json:"surfaceVersion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeviceId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeviceId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesGovernedSurfaceIdentity) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesGovernedSurfaceIdentity
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesGovernedSurfaceVersion: The version of the
// surface/client. New surfaces are encouraged to only use the
// “major” field to keep track of version number. The “minor”
// field may be used for surfaces that rely on both the “major” and
// “minor” fields to define their version.
type AssistantApiCoreTypesGovernedSurfaceVersion struct {
	Major int64 `json:"major,omitempty"`

	Minor int64 `json:"minor,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Major") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Major") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesGovernedSurfaceVersion) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesGovernedSurfaceVersion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesHomeAppInfo: The Home app information of the
// provider. Next ID: 3
type AssistantApiCoreTypesHomeAppInfo struct {
	// LocalizedAppName: The localized app name.
	LocalizedAppName string `json:"localizedAppName,omitempty"`

	// PackageName: Unique package name that identifies a Home app of the
	// provider.
	PackageName string `json:"packageName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LocalizedAppName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LocalizedAppName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesHomeAppInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesHomeAppInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesImage: An image represents the data about an
// image or a photo. LINT.IfChange NextId: 13
type AssistantApiCoreTypesImage struct {
	// AccessibilityText: A text description of the image to be used for
	// accessibility, e.g. screen readers.
	AccessibilityText string `json:"accessibilityText,omitempty"`

	// AppIconIdentifier: App identifier. This field is specific to mobile
	// surfaces and stands for app package name for Android surface, and app
	// bundle identifier for iOS. In case identifier is specified but
	// invalid, some default icon will be used, e.g.
	// PackageManager.getDefaultActivityIcon() for Android. If you want to
	// show image for AGSA versions which don't support this field, you can
	// specify source_url as backup.
	AppIconIdentifier string `json:"appIconIdentifier,omitempty"`

	// BadgeImage: This is the image that is displayed as the badge on the
	// main image.
	BadgeImage *AssistantApiCoreTypesImage `json:"badgeImage,omitempty"`

	// Content: Content of the image in bytes.
	Content string `json:"content,omitempty"`

	Height int64 `json:"height,omitempty"`

	// ImageSource: Indicate the data source where the image is fetched.
	//
	// Possible values:
	//   "UNKNOWN" - Unknown image source.
	//   "PLACEHOLDER" - Indicates this image is a default placeholder
	// because no valid image is found.
	//   "VISUAL_DICT" - Indicates the image is fetched from Visual
	// Dictionary.
	//   "LAVD" - Indicates the image is fetched from LAVD
	// (visual-dictionary-license-aware-requirements).
	//   "VISUAL_DICT_DEFAULT_LOCALE" - Indicates the image is fetched from
	// Visual Dictionary of default locale "en".
	ImageSource string `json:"imageSource,omitempty"`

	// JsonContent: Content of image in form of JSON representation.
	JsonContent string `json:"jsonContent,omitempty"`

	// LetterDrawableText: Text used to generate a letter drawable (a letter
	// icon with color). It will be the default icon if the source_url is
	// empty or cannot be rendered.
	LetterDrawableText string `json:"letterDrawableText,omitempty"`

	// ProviderUrl: Url of the image provider, which is the website
	// containing the image. For example, https://www.agentx.com.
	ProviderUrl string `json:"providerUrl,omitempty"`

	// SourceUrl: The source url of the image. For example,
	// https://www.agentx.com/logo.png
	SourceUrl string `json:"sourceUrl,omitempty"`

	// SourceUrlType: Type of the source url.
	//
	// Possible values:
	//   "DEFAULT_URL_TYPE"
	//   "LOTTIE" - Json url used to drive animation on surfaces using
	// Airbnb lottie library.
	//   "DUO_CLIENT" - Duo url specifying the Duo resource id to be used
	// ('duo://'). WARNING: This may not be supported on all clients. At the
	// moment, only Dragonglass surfaces are supporting this.
	//   "CONTACT_ID" - Contact ID specifying contact resource to be used.
	//   "GLIDE_CACHE_ID" - ID used for caching image with Glide.
	SourceUrlType string `json:"sourceUrlType,omitempty"`

	// Width: The width and height of the image in pixels.
	Width int64 `json:"width,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccessibilityText")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessibilityText") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesImage) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesImage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesInternalProviderInfo: Info for targeting a
// feature provided directly by the Assistant surface itself. i.e Could
// be pointing to AGSA audio player for AUDIO_PLAYER on AGSA.
type AssistantApiCoreTypesInternalProviderInfo struct {
	// Type: Specifying which type of internal provider.
	//
	// Possible values:
	//   "UNKNOWN_INTERNAL_PROVIDER_TYPE"
	//   "AUDIO_PLAYER" - Deprecated, because supported AGSA implementation
	// had a bug (b/72229328). Use AUDIO_PLAYER_V2 instead.
	//   "AUDIO_PLAYER_V2" - Internal provider for playing audio.
	//   "MEDIA_PLAYER" - Internal provider for playing audio and video for
	// AGSA.
	//   "MEDIA_PLAYER_IOS" - iOS MEDIA_PLAYER.
	//   "AUDIO_ONLY_PLAYER" - Internal provider for playing audio only,
	// different from MEDIA_PLAYER. It is used by KaiOS, for news vertical.
	// It is different from AUDIO_PLAYER_V2 which is for AGSA, and not
	// supported by news vertical.
	//   "NARRATED_WEB_MEDIA_PLAYER" - Internal provider for playing audio
	// narration of web pages.
	//   "LIBASSISTANT_MEDIA_PLAYER" - Internal provider for playing audio
	// for libassistant. Historically each enum represents a different media
	// player implementation. This one is meant for the playing media on the
	// libassistant enabled surfaces.
	//   "LENS_PLAYER" - Internal provider for playing audio using lens
	// audio player, for screenshot based readout.
	//   "NEWS_PLAYER" - Internal provider for news vertical on
	// AssistantMediaPlayer in AGSA.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Type") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Type") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesInternalProviderInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesInternalProviderInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesIosAppInfo: The iOS app information of the
// provider. Next ID: 4
type AssistantApiCoreTypesIosAppInfo struct {
	// BundleIdentifier: Bundle identifier that identifies an iOS app of the
	// provider.
	BundleIdentifier string `json:"bundleIdentifier,omitempty"`

	// LocalizedAppName: The localized app name.
	LocalizedAppName string `json:"localizedAppName,omitempty"`

	// OpenAppUrl: A URL to open the provider's app.
	OpenAppUrl string `json:"openAppUrl,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BundleIdentifier") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BundleIdentifier") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesIosAppInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesIosAppInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesKaiOsAppInfo: The KaiOS app information of the
// provider. Next ID: 4
type AssistantApiCoreTypesKaiOsAppInfo struct {
	// LocalizedAppName: The localized app name.
	LocalizedAppName string `json:"localizedAppName,omitempty"`

	// OpenAppUrl: A URL to open the provider's app.
	OpenAppUrl string `json:"openAppUrl,omitempty"`

	// PackageName: Unique package name that identifies a KaiOS app of the
	// provider.
	PackageName string `json:"packageName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LocalizedAppName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LocalizedAppName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesKaiOsAppInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesKaiOsAppInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesLocationCoordinates: Geographic coordinate
// information for location.
type AssistantApiCoreTypesLocationCoordinates struct {
	// AccuracyMeters: The accuracy of the coordinates in meters.
	AccuracyMeters float64 `json:"accuracyMeters,omitempty"`

	// LatDegrees: Latitude degrees.
	LatDegrees float64 `json:"latDegrees,omitempty"`

	// LngDegrees: Longitude degrees.
	LngDegrees float64 `json:"lngDegrees,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccuracyMeters") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccuracyMeters") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesLocationCoordinates) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesLocationCoordinates
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *AssistantApiCoreTypesLocationCoordinates) UnmarshalJSON(data []byte) error {
	type NoMethod AssistantApiCoreTypesLocationCoordinates
	var s1 struct {
		AccuracyMeters gensupport.JSONFloat64 `json:"accuracyMeters"`
		LatDegrees     gensupport.JSONFloat64 `json:"latDegrees"`
		LngDegrees     gensupport.JSONFloat64 `json:"lngDegrees"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AccuracyMeters = float64(s1.AccuracyMeters)
	s.LatDegrees = float64(s1.LatDegrees)
	s.LngDegrees = float64(s1.LngDegrees)
	return nil
}

// AssistantApiCoreTypesMessageNotification:
// LINT.IfChange(ungoverned_message_notification) This proto captures
// the contents of a messaging app notification that is typically part
// of a conversation thread. Next Id: 20
type AssistantApiCoreTypesMessageNotification struct {
	// AppName: App name of the message notification, e.g. Hangouts.
	AppName string `json:"appName,omitempty"`

	// BundleId: The key used to group this notification into a cluster.
	BundleId string `json:"bundleId,omitempty"`

	// DataUri: Uri for the attachment (image, audio, video etc.).
	DataUri string `json:"dataUri,omitempty"`

	// GroupName: Name of the group associated with the message
	// notification. This field is set iff this is a group message.
	GroupName string `json:"groupName,omitempty"`

	// GroupingKey: The group key of a proactive notification. Details in
	// assistant.api.client_op.NotificationArgs.grouping_key.
	GroupingKey string `json:"groupingKey,omitempty"`

	// Index: Index of the message notification.
	Index int64 `json:"index,omitempty"`

	// MarkAsReadActionAvailable: Boolean indicating if the mark_as_read
	// action is available for this message.
	MarkAsReadActionAvailable bool `json:"markAsReadActionAvailable,omitempty"`

	// MessageLength: Length of the message/notification content in
	// characters. Note: We can't send the full content because of privacy
	// restriction, preventing sending client content to our backends.
	// Concatenated message_length of all notification_entries.
	MessageLength int64 `json:"messageLength,omitempty"`

	// Possible values:
	//   "UNKNOWN"
	//   "INDIVIDUAL"
	//   "GROUP"
	MessageRecipientType string `json:"messageRecipientType,omitempty"`

	// MimeType: Mime type of the data_uri. e.g. 'audio/wav', 'video/mp4',
	// 'image/png'.
	MimeType string `json:"mimeType,omitempty"`

	NotificationEntries []*AssistantApiCoreTypesMessageNotificationNotificationEntry `json:"notificationEntries,omitempty"`

	// NotificationIconKey: On-device cache key for notification icon.
	NotificationIconKey string `json:"notificationIconKey,omitempty"`

	// NotificationKey: String key of the notification. It is the key from
	// original StatusBarNotification received from Android OS. It is used
	// to identify the original notification to send a reply.
	NotificationKey string `json:"notificationKey,omitempty"`

	// OpaqueToken: The opaque_token of a proactive notification. Details in
	// assistant.api.client_op.NotificationArgs.opaque_token.
	OpaqueToken string `json:"opaqueToken,omitempty"`

	// PackageName: App pkg of the message notification, e.g.
	// "com.google.android.talk".
	PackageName string `json:"packageName,omitempty"`

	// PostTime: Timestamp of the last notification's post time.
	PostTime int64 `json:"postTime,omitempty,string"`

	// ReplyActionAvailable: Boolean indicating if the reply action is
	// available for this message.
	ReplyActionAvailable bool `json:"replyActionAvailable,omitempty"`

	Sender *AssistantApiCoreTypesMessageNotificationPerson `json:"sender,omitempty"`

	// SenderName: Sender's name of the message notification, e.g. Elsa.
	// Last sender name in case of a group conversation.
	SenderName string `json:"senderName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AppName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AppName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesMessageNotification) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesMessageNotification
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesMessageNotificationNotificationEntry: Structure
// of each notification in the MessageNotification Bundle. Attribute
// sender_name could be different in case of group messages. Next Id: 8
type AssistantApiCoreTypesMessageNotificationNotificationEntry struct {
	// CharCount: Count of characters in the message body in the
	// notification.
	CharCount int64 `json:"charCount,omitempty"`

	// DataUri: Uri for the attachment (image, audio, video etc.).
	DataUri string `json:"dataUri,omitempty"`

	// MessageBody: Note that this is not present in production traffic.
	// Content of the message body in the notification.
	MessageBody string `json:"messageBody,omitempty"`

	// MimeType: Mime type of the data_uri. e.g. 'audio/wav', 'video/mp4',
	// 'image/png'.
	MimeType string `json:"mimeType,omitempty"`

	// PostTime: Timestamp of the notification's post time.
	PostTime string `json:"postTime,omitempty"`

	// Sender: Sender of the message notification.
	Sender *AssistantApiCoreTypesMessageNotificationPerson `json:"sender,omitempty"`

	// WordCount: Count of words in the message body in the notification.
	WordCount int64 `json:"wordCount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CharCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CharCount") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesMessageNotificationNotificationEntry) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesMessageNotificationNotificationEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesMessageNotificationPerson: Mirrors part of
// https://developer.android.com/reference/android/app/Person Next Id: 4
type AssistantApiCoreTypesMessageNotificationPerson struct {
	IsImportant bool `json:"isImportant,omitempty"`

	Key string `json:"key,omitempty"`

	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IsImportant") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IsImportant") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesMessageNotificationPerson) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesMessageNotificationPerson
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesProvider: Provider. Like, Spotify or
// iHeartRadio. Next ID: 13
type AssistantApiCoreTypesProvider struct {
	// AndroidAppInfo: The android app information of the provider.
	AndroidAppInfo *AssistantApiCoreTypesAndroidAppInfo `json:"androidAppInfo,omitempty"`

	// CastAppInfo: The cast app information of the provider.
	CastAppInfo *AssistantApiCoreTypesCastAppInfo `json:"castAppInfo,omitempty"`

	// ChromeosAppInfo: The ChromeOS app information of the provider.
	ChromeosAppInfo *AssistantApiCoreTypesChromeOsAppInfo `json:"chromeosAppInfo,omitempty"`

	// CloudProviderInfo: The third party provider information.
	CloudProviderInfo *AssistantApiCoreTypesCloudProviderInfo `json:"cloudProviderInfo,omitempty"`

	// FallbackUrl: A URL to fallback to if app can not be opened.
	FallbackUrl string `json:"fallbackUrl,omitempty"`

	HomeAppInfo *AssistantApiCoreTypesHomeAppInfo `json:"homeAppInfo,omitempty"`

	// IconImageUrl: Public URL pointing to an icon image for the provider.
	// e.g.
	// https://lh3.googleusercontent.com/UrY7BAZ-XfXGpfkeWg0zCCeo-7ras4DCoRalC_WXXWTK9q5b0Iw7B0YQMsVxZaNB7DM
	IconImageUrl string `json:"iconImageUrl,omitempty"`

	// InternalProviderInfo: The internal assistant provider information.
	InternalProviderInfo *AssistantApiCoreTypesInternalProviderInfo `json:"internalProviderInfo,omitempty"`

	// IosAppInfo: The iOS app information of the provider.
	IosAppInfo *AssistantApiCoreTypesIosAppInfo `json:"iosAppInfo,omitempty"`

	// KaiosAppInfo: The KaiOS app information of the provider.
	KaiosAppInfo *AssistantApiCoreTypesKaiOsAppInfo `json:"kaiosAppInfo,omitempty"`

	// SipProviderInfo: The sip information of the provider.
	SipProviderInfo *AssistantApiCoreTypesSipProviderInfo `json:"sipProviderInfo,omitempty"`

	// WebProviderInfo: The web provider information.
	WebProviderInfo *AssistantApiCoreTypesWebProviderInfo `json:"webProviderInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AndroidAppInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AndroidAppInfo") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesProvider) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesProvider
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesProviderDelta: ProviderDelta. The incremental
// change, e.g. installation or deletion for Spotify or iHeartRadio.
// Currently it is for Android only. A few considerations for edge
// cases: - If the app being deleted is not found from Footprints, it is
// ignored. - For Footprint upload through Geller, the gPRC response is
// available for client to retry in the next upload if the upload fails.
// - For Assistant Request, there is no upload status similar to the
// current AppCapabilities. Next ID: 4
type AssistantApiCoreTypesProviderDelta struct {
	// AndroidAppInfoDelta: The android app information of the provider.
	AndroidAppInfoDelta *AssistantApiCoreTypesAndroidAppInfoDelta `json:"androidAppInfoDelta,omitempty"`

	// FallbackUrl: A URL to fallback to if app can not be opened.
	FallbackUrl string `json:"fallbackUrl,omitempty"`

	// IconImageUrl: Public URL pointing to an icon image for the provider.
	// e.g.
	// https://lh3.googleusercontent.com/UrY7BAZ-XfXGpfkeWg0zCCeo-7ras4DCoRalC_WXXWTK9q5b0Iw7B0YQMsVxZaNB7DM
	IconImageUrl string `json:"iconImageUrl,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AndroidAppInfoDelta")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AndroidAppInfoDelta") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesProviderDelta) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesProviderDelta
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesSipProviderInfo: Session Initiation Protocol
// (SIP) information for providers that use SIP to initiate multimedia
// communication sessions, like Google Voice and Fi.
// https://en.wikipedia.org/wiki/Session_Initiation_Protocol
type AssistantApiCoreTypesSipProviderInfo struct {
	// ProviderId: The providers id (MID) which is the primary identifier
	// for a call provider within the Assistant. A MID, or machine
	// identifier, is a unique identifier issued by Knowledge Graph for all
	// entities contained in it's graph.
	ProviderId string `json:"providerId,omitempty"`

	// Realm: Calling realm to be use for each call. i.e. For anonymous,
	// this would be set to anonymous.chirp.google.com
	Realm string `json:"realm,omitempty"`

	// UseBirdsongTacl: If true, client should use the Birdsong TaCL API for
	// this call. Uses the VoiceCallManager API by default. For more
	// details: go/birdsong-migration-google-home
	UseBirdsongTacl bool `json:"useBirdsongTacl,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ProviderId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ProviderId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesSipProviderInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesSipProviderInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesSurfaceIdentity: The set of information that
// helps the server identify the surface. This replaces the User-Agent
// string within the Assistant Server. Note: The SurfaceIdentity proto
// should only be used to derive the capabilities of a surface. It
// should not be accessed outside of the CapabilityBuilder or
// CapabilityChecker. NEXT ID: 6 LINT.IfChange
type AssistantApiCoreTypesSurfaceIdentity struct {
	// DeviceId: The identifier of the device.
	DeviceId *AssistantApiCoreTypesDeviceId `json:"deviceId,omitempty"`

	// LegacySurfaceType: DEPRECATED: The legacy device's surface type enum.
	// NOTE: Prefer using the ontological `surface_type` field above. If you
	// need to access the legacy surface type, please file a bug and add it
	// in your code to migrate to ontological surface type.
	//
	// Possible values:
	//   "UNKNOWN"
	//   "ANDROID_ALLO"
	//   "ANDROID_AUTO" - Deprecated (never used). Use OPA_ANDROID_AUTO
	// instead.
	//   "ANDROID_THINGS_CUBE" - Assistant on small screen stationary
	// device.
	//   "ANDROID_THINGS_JASPER"
	//   "ANDROID_TV"
	//   "ANDROID_TV_KIDS"
	//   "ANDROID_WEAR"
	//   "AR_GLASSES" - Assistant on AR Glasses with both visual and audio
	// experiences. Ask ar-assistant@ for details.
	//   "ASSISTANT_SDK" - For Assistant SDK gRPC client.
	//   "AUDIOWEAR"
	//   "BUBBLE_CHARACTERS_IOS" - go/assistant-lamda-overview-characters
	//   "CAPABILITY_BASED_SURFACE" - Surface for capability based testing.
	//   "CHROMECAST_ASSISTANT" - For chrome cast assistant web app.
	//   "CHROMECAST_MANHATTAN" - For chrome cast with assistant + screen
	// (e.g., Google Nest Hub).
	//   "CHROMECAST_SEARCH"
	//   "CLOUD_DEVICE" - Virtual device for event-based triggering, e.g.
	// executing time
	//   "COMPANION_SCREEN" - scheduled routines: go/routine-cloud-ex For
	// Quartz.
	//   "DYNAMITE_WEB"
	//   "ENSEMBLE"
	//   "EYESFREE_AGSA" - Deprecated. Please use OPA_ANDROID_SCREENLESS.
	//   "EYESFREE_GMM"
	//   "GBOARD" - For Gboard app
	//   "GLASS"
	//   "GOOGLE_HOME"
	//   "HANGOUTS_CHATBOT"
	//   "IOS_ALLO"
	//   "IOS_GSA"
	//   "IOS_WEAR"
	//   "LIBASSISTANT" - For standalone libassistant devices.
	//   "LINE_CHATBOT" - LINE 3P messaging app
	//   "MULTIMODAL_AGSA" - Deprecated.
	//   "NON_ASSISTANT_SURFACE" - Surfaces that do not speak to the
	// Assistant, i.e. web HQ
	//   "OPA_AGSA" - Assistant on Android phones accessed through the
	// Google App (velvet). This represents neither all of the assistant on
	// android phones (ANDROID_ALLO, VERILY_ONDUO, etc.) nor all of the
	// assistant built on top of AGSA (ANDROID_WEAR, OPA_ANDROID_SCREENLESS,
	// OPA_AGSA_CHROME_OS, etc.).
	//   "OPA_AGSA_CHROME_OS" - Deprecated. Please use OPA_CROS.
	//   "OPA_ANDROID_AUTO"
	//   "OPA_ANDROID_LITE" - This is OPA on Android Go (not part of AGSA)
	//   "OPA_ANDROID_SCREENLESS" - Assistant on Nexus with screen
	// off/locked. Use go/bisto device to trigger.
	//   "OPA_ANDROID_SMART_DISPLAY" - Assistant on Titan hub mode
	// (go/titan-hubmode-surface). This is OPA Android first party Smart
	// Display devices. The UI experience is built on Opal (Gallium and
	// Flutter) and native Android.
	//   "OPA_ANDROID_TABLET" - Assistant on Android tablet
	//   "OPA_CROS" - Assistant on native Chrome OS (go/croissant).
	//   "OPA_GACS" - For assistant on GACS devices (go/gacs-dd). Google
	// Assistant Conversation Service (GACS) defines intents the device
	// accepts. This surface serves the intents in the assistant response.
	//   "OPA_IOS"
	//   "OPA_IOS_SCREENLESS" - Assistant on iOS with screen off/locked. Use
	// go/bisto device to trigger.
	//   "OPA_KAIOS" - Assistant on KaiOS. go/kaiosama
	//   "OPA_MOBILE_WEB" - Assistant on Mobile Web. go/opa-spidey
	//   "RTOS_PHONE" - Assistant on low-cost RTOS phones (go/conceRTOS).
	//   "SMS_CHATBOT"
	//   "TELEGRAM_CHATBOT" - Telegram 3P messaging app
	//   "TELEPHONE_ASSISTANT" - Assistant on a phone call (go/telephone).
	//   "VERILY_ONDUO"
	//   "YOUTUBE_APP" - A Youtube app.
	//   "AGSA_BISTO_FOR_EVAL" - Eval-only surfaces. These surfaces are not
	// real surfaces. They are only used in intermediate steps of eval query
	// and request generation: 1. Eval samplers (OPA query sampler and
	// Cannery sampler) checks logs and temporarily assigns these surface
	// types to the logs, to put Bisto, Lockhart Mic, ... queries in the
	// correct query pools. 2. Request builders uses these surface types to
	// determine how TaskRequest for Bisto, Lockhart Mic, ... should be
	// built, like whether some user user agent should be used, whether some
	// entry source should be set. The surface types in the generated
	// TaskRequest is still the production surface types, like
	// OPA_ANDROID_SCREENLESS or OPA_AGSA. Temp surface for Bisto Android
	// eval. Will be merged with OPA_ANDROID_SCREENLESS in the future.
	//   "COGSWORTH_FOR_EVAL"
	//   "LOCKHART_MIC_FOR_EVAL"
	//   "OPA_ANDROID_AUTO_EMBEDDED_FAKE" - OPA_ANDROID_AUTO has another
	// sub-surface (embedded) that differs in the reported capabilities,
	// client-ops, flags but uses the same surface_type string of
	// OPA_ANDROID_AUTO. This fake surface would allow running turing2 tests
	// and evals for this embedded surface. Deprecated as of Feb 2019.
	// Please use "OPA_ANDROID_AUTO_EMBEDDED" client type for tests and
	// eval. See go/client-onboarding for more details.
	// https://cs.corp.google.com/piper///depot/google3/assistant/assistant_server/tools/util/consts.h?l=32&rcl=247481455
	//   "SPARK" - Unlaunched new surface prototype, ask spark-eng@.
	//   "WALLE" - Wall-E is an Area120 Project building assistant powered
	// robots. The surface is an extended joplin which have same
	// capabilities as a google home adding custom robot features. Currently
	// in active development. Please reach out walle-software@ or bingxin@
	// for questions. For details see go/walle-as-pipeline-1-pager.
	//   "UNIT_TESTING" - Surface used for unit-testing purposes. Unit-tests
	// might still require the existence of a "valid" SurfaceType to succeed
	// (eg. initialization of the CapabilityBuilder, proto matching, etc.).
	// With the move away from SurfaceType checks, a generic "TESTING"
	// SurfaceType can be used for such tests without affecting the test
	// behavior. Unlike the CAPABILITY_BASED_SURFACE, this proto does not
	// have any capabilities or ResponseType tied to it. It should only be
	// used for unit-tests and should not be exposed in the ASDebugger.
	LegacySurfaceType string `json:"legacySurfaceType,omitempty"`

	// SurfaceType: The device's surface type. The types are defined at
	// google3/assistant/api/core_types/surfaces.gcl. For more details,
	// refer to go/ontologicalize-surface-type.
	//
	// Possible values:
	//   "UNKNOWN_TYPE" - Unknown surface type.
	//   "ACCL" - Android conversation client library (go/accl) is an
	// Android library which implements the Conversation Protocol that
	// allows a surface to have conversations with the Assistant server.
	// OWNERS: surfaces-infra-core@
	//   "AGSA" - Android Google Search App (go/agsa). OWNERS:
	// surfaces-infra-core@
	//   "ANDROID" - Android. OWNERS: surfaces-infra-core@
	//   "ANDROID_AUTO" - Assistant on Android Auto (go/ast-auto). OWNERS:
	// opa-android-leads@
	//   "ANDROID_LITE" - Assistant on Android Go (not part of AGSA).
	// OWNERS: assistantgo-eng@
	//   "ANDROID_PHONE" - Assistant on Android phones accessed through the
	// Google App (velvet). This surface is formerly known as OPA_AGSA.
	// OWNERS: opa-android-leads@
	//   "ANDROID_SCREENLESS" - Assistant on Nexus with screen off/locked.
	// Use go/bisto device to trigger. OWNERS: opa-android-leads@
	//   "ANDROID_SMART_DISPLAY" - Assistant on Titan hub mode
	// (go/titan-hubmode-surface). This is OPA Android first party Smart
	// Display devices. The UI experience is built on Opal (Gallium and
	// Flutter) and native Android. OWNERS: opa-android-leads@
	//   "ANDROID_TABLET" - Assistant on Android tablet. OWNERS:
	// opa-android-leads@
	//   "ANDROID_THINGS" - Android Things (go/things). OWNERS:
	// surfaces-infra-core@
	//   "ANDROID_THINGS_CUBE" - Lenovo Smart Clock v1, a stationary smart
	// display device with a 4-inch screen, targeted for bedroom/bedside use
	// cases like alarm, sleep tracking. Based on Android Things. See
	// go/cube-home. OWNERS: cube-eng@
	//   "ANDROID_THINGS_JASPER" - Former codename for 3P 8-inch and 10-inch
	// Smart Displays from Lenovo, JBL and LG, targeted for use in the
	// kitchen. Based on Android Things. See go/jasper-home. OWNERS:
	// jasper-eng@
	//   "ANDROID_TV" - The Android platform that powers smart televisions,
	// set-top-boxes, and over-the-top devices. See go/atv-eng and
	// go/opa-tv. OWNERS: opa-tv-eng@
	//   "ANDROID_WEAR" - Legacy Wear OS Assistant. OWNERS:
	// wear-assistant-eng@
	//   "ASSISTANT_KIT" - AssistantKit (go/assistantkit) is a collection of
	// iOS libraries allowing first party apps to integrate Google Assistant
	// features. OWNERS: assistantkit-eng@
	//   "ASSISTANT_SDK" - Standalone gRPC based client. See go/easi.
	// OWNERS: assistant-sdk-service-eng@
	//   "AUTO" - Automobile. OWNERS: surfaces-infra-core@
	//   "CAST_OS" - Cast OS (go/opal-castos-docs#what-is-castos). OWNERS:
	// surfaces-infra-core@
	//   "CHROME_OS" - Chrome OS (go/chromsos) OWNERS: surfaces-infra-core@
	//   "CHROMECAST_MANHATTAN" - For chromecast with assistant + screen,
	// e.g. Newman. OWNERS: cast-eng-platform@
	//   "CLOUD_DEVICE" - Virtual device for event-based triggering, e.g.
	// executing time scheduled routines: go/scheduled-routines. OWNERS:
	// surfaces-infra-core@
	//   "CROS" - Assistant on native Chrome OS (go/croissant). OWNERS:
	// croissant@
	//   "FITBIT_OS_WATCH" - Assistant on Fitbit OS Watch. OWNERS:
	// assistant-wearable-team@
	//   "FITBIT_OS_WATCH_ANDROID" - Assistant on Fitbit Watch paired with
	// AGSA. OWNERS: assistant-wearable-team@
	//   "FITBIT_OS_WATCH_IOS" - Assistant on Fitbit Watch paired with iOPA.
	// OWNERS: assistant-wearable-team@
	//   "GOOGLE_HOME" - Google home speaker, i.e., Chirp devices. See
	// go/assistant-speakers. OWNERS: assistant-speaker-leads@
	//   "HEADPHONE" - Headphone. OWNERS: surfaces-infra-core@
	//   "HEADPHONE_ANDROID" - Assistant on headphones paired with AGSA.
	// OWNERS: assistant-wearable-team@
	//   "HEADPHONE_IOS" - Assistant on headphones paired with iOPA. OWNERS:
	// assistant-wearable-team@
	//   "IOPA" - Assistant on iOS devices (go/opa-ios). OWNERS:
	// opa-ios-eng@
	//   "IOS" - iOS. OWNERS: surfaces-infra-core@
	//   "IOS_SCREENLESS" - Assistant on iOS with screen off/locked. Use
	// go/bisto device to trigger. OWNERS: bisto-team@
	//   "IPAD" - iPad devices. OWNERS: surfaces-infra-core@
	//   "IPHONE" - iPhone devices. OWNERS: surfaces-infra-core@
	//   "KAI_OS" - Kai OS (go/kaios). OWNERS: surfaces-infra-core@
	//   "KAI_OS_AMA" - Assistant on KaiOS (go/kaiosama). OWNERS:
	// assistant-kaios-eng@
	//   "LIBASSISTANT" - LibAssistant (go/libassistant) C++ SDK that powers
	// Assistant experience on both 1P devices like Google Home and 3P
	// devices like Sonos. OWNERS: libassistant-core@
	//   "PHONE" - A phone. OWNERS: surfaces-infra-core@
	//   "PIXEL" - Pixel devices. OWNERS: surfaces-infra-core@
	//   "PIXEL5" - Pixel 5. OWNERS: surfaces-infra-core@
	//   "PIXEL6" - Pixel 6. OWNERS: surfaces-infra-core@
	//   "PIXEL7" - Pixel 7. OWNERS: surfaces-infra-core@
	//   "PIXEL8" - Pixel 8. OWNERS: surfaces-infra-core@
	//   "PIXEL_BUDS" - Assistant on Pixel Buds. OWNERS:
	// assistant-wearable-team@
	//   "PIXEL_TABLET" - Assistant on Pixel Tablet/Tangor (a.k.a, TK).
	// OWNERS: assistant-display-eng@
	//   "PIXEL_TABLET_HUB_MODE" - Assistant on Tangor running in Hub mode.
	// OWNERS: assistant-display-eng@
	//   "PIXEL_TABLET_PERSONAL_MODE" - Assistant on Tangor running in
	// Personal mode. OWNERS: assistant-display-eng@
	//   "PIXEL_WATCH" - Assistant on Pixel Watch (a.k.a., Rohan). OWNERS:
	// assistant-wearable-team@
	//   "SCREENLESS" - Devices with screen off or locked (go/bisto).
	// OWNERS: surfaces-infra-core@
	//   "SMART_DISPLAY" - Smart surface, such as Titan. OWNERS:
	// surfaces-infra-core@
	//   "SPEAKER" - A speaker. OWNERS: surfaces-infra-core@
	//   "TABLET" - A tablet. OWNERS: surfaces-infra-core@
	//   "TELEPHONE" - Assistant on a phone call (go/telephone). OWNERS:
	// telephone-assistant-eng@
	//   "THING" - IoT device. OWNERS: surfaces-infra-core@
	//   "WATCH" - Watch. OWNERS: surfaces-infra-core@
	//   "WEAR_OS" - Wear OS. OWNERS: surfaces-infra-core@
	//   "WEAR_OS_WATCH" - Assistant on Wear OS Watch (a.k.a., Edoras).
	// OWNERS: assistant-wearable-team@
	SurfaceType string `json:"surfaceType,omitempty"`

	// SurfaceTypeString: DEPRECATED. The legacy device's surface type
	// string. NOTE: Prefer using the ontological `surface_type` field. The
	// device's surface type. This is the string version of the
	// assistant.api.core_types.SurfaceType enum. The server should not use
	// this field, rather it should use the SurfaceType value derived from
	// this string.
	SurfaceTypeString string `json:"surfaceTypeString,omitempty"`

	// SurfaceVersion: The version of the surface/client. This is different
	// from the Conversation protocol version.
	SurfaceVersion *AssistantApiCoreTypesSurfaceVersion `json:"surfaceVersion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeviceId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeviceId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesSurfaceIdentity) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesSurfaceIdentity
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesSurfaceType: Specifies the types of device
// surfaces. LINT.IfChange When adding new surface types make sure that
// My Activity (https://myactivity.google.com/product/assistant) will
// correctly render by adding your enum to
// http://cs/symbol:GetAssistSurfaceName%20f:%5C.cc$ If your type
// doesn't fit in to any of the existing surfaces messages, add a new
// message in
// http://google3/personalization/footprints/boq/uservisible/events/intl/smh_frontend_messages.h.
type AssistantApiCoreTypesSurfaceType struct {
	// Possible values:
	//   "UNKNOWN"
	//   "ANDROID_ALLO"
	//   "ANDROID_AUTO" - Deprecated (never used). Use OPA_ANDROID_AUTO
	// instead.
	//   "ANDROID_THINGS_CUBE" - Assistant on small screen stationary
	// device.
	//   "ANDROID_THINGS_JASPER"
	//   "ANDROID_TV"
	//   "ANDROID_TV_KIDS"
	//   "ANDROID_WEAR"
	//   "AR_GLASSES" - Assistant on AR Glasses with both visual and audio
	// experiences. Ask ar-assistant@ for details.
	//   "ASSISTANT_SDK" - For Assistant SDK gRPC client.
	//   "AUDIOWEAR"
	//   "BUBBLE_CHARACTERS_IOS" - go/assistant-lamda-overview-characters
	//   "CAPABILITY_BASED_SURFACE" - Surface for capability based testing.
	//   "CHROMECAST_ASSISTANT" - For chrome cast assistant web app.
	//   "CHROMECAST_MANHATTAN" - For chrome cast with assistant + screen
	// (e.g., Google Nest Hub).
	//   "CHROMECAST_SEARCH"
	//   "CLOUD_DEVICE" - Virtual device for event-based triggering, e.g.
	// executing time
	//   "COMPANION_SCREEN" - scheduled routines: go/routine-cloud-ex For
	// Quartz.
	//   "DYNAMITE_WEB"
	//   "ENSEMBLE"
	//   "EYESFREE_AGSA" - Deprecated. Please use OPA_ANDROID_SCREENLESS.
	//   "EYESFREE_GMM"
	//   "GBOARD" - For Gboard app
	//   "GLASS"
	//   "GOOGLE_HOME"
	//   "HANGOUTS_CHATBOT"
	//   "IOS_ALLO"
	//   "IOS_GSA"
	//   "IOS_WEAR"
	//   "LIBASSISTANT" - For standalone libassistant devices.
	//   "LINE_CHATBOT" - LINE 3P messaging app
	//   "MULTIMODAL_AGSA" - Deprecated.
	//   "NON_ASSISTANT_SURFACE" - Surfaces that do not speak to the
	// Assistant, i.e. web HQ
	//   "OPA_AGSA" - Assistant on Android phones accessed through the
	// Google App (velvet). This represents neither all of the assistant on
	// android phones (ANDROID_ALLO, VERILY_ONDUO, etc.) nor all of the
	// assistant built on top of AGSA (ANDROID_WEAR, OPA_ANDROID_SCREENLESS,
	// OPA_AGSA_CHROME_OS, etc.).
	//   "OPA_AGSA_CHROME_OS" - Deprecated. Please use OPA_CROS.
	//   "OPA_ANDROID_AUTO"
	//   "OPA_ANDROID_LITE" - This is OPA on Android Go (not part of AGSA)
	//   "OPA_ANDROID_SCREENLESS" - Assistant on Nexus with screen
	// off/locked. Use go/bisto device to trigger.
	//   "OPA_ANDROID_SMART_DISPLAY" - Assistant on Titan hub mode
	// (go/titan-hubmode-surface). This is OPA Android first party Smart
	// Display devices. The UI experience is built on Opal (Gallium and
	// Flutter) and native Android.
	//   "OPA_ANDROID_TABLET" - Assistant on Android tablet
	//   "OPA_CROS" - Assistant on native Chrome OS (go/croissant).
	//   "OPA_GACS" - For assistant on GACS devices (go/gacs-dd). Google
	// Assistant Conversation Service (GACS) defines intents the device
	// accepts. This surface serves the intents in the assistant response.
	//   "OPA_IOS"
	//   "OPA_IOS_SCREENLESS" - Assistant on iOS with screen off/locked. Use
	// go/bisto device to trigger.
	//   "OPA_KAIOS" - Assistant on KaiOS. go/kaiosama
	//   "OPA_MOBILE_WEB" - Assistant on Mobile Web. go/opa-spidey
	//   "RTOS_PHONE" - Assistant on low-cost RTOS phones (go/conceRTOS).
	//   "SMS_CHATBOT"
	//   "TELEGRAM_CHATBOT" - Telegram 3P messaging app
	//   "TELEPHONE_ASSISTANT" - Assistant on a phone call (go/telephone).
	//   "VERILY_ONDUO"
	//   "YOUTUBE_APP" - A Youtube app.
	//   "AGSA_BISTO_FOR_EVAL" - Eval-only surfaces. These surfaces are not
	// real surfaces. They are only used in intermediate steps of eval query
	// and request generation: 1. Eval samplers (OPA query sampler and
	// Cannery sampler) checks logs and temporarily assigns these surface
	// types to the logs, to put Bisto, Lockhart Mic, ... queries in the
	// correct query pools. 2. Request builders uses these surface types to
	// determine how TaskRequest for Bisto, Lockhart Mic, ... should be
	// built, like whether some user user agent should be used, whether some
	// entry source should be set. The surface types in the generated
	// TaskRequest is still the production surface types, like
	// OPA_ANDROID_SCREENLESS or OPA_AGSA. Temp surface for Bisto Android
	// eval. Will be merged with OPA_ANDROID_SCREENLESS in the future.
	//   "COGSWORTH_FOR_EVAL"
	//   "LOCKHART_MIC_FOR_EVAL"
	//   "OPA_ANDROID_AUTO_EMBEDDED_FAKE" - OPA_ANDROID_AUTO has another
	// sub-surface (embedded) that differs in the reported capabilities,
	// client-ops, flags but uses the same surface_type string of
	// OPA_ANDROID_AUTO. This fake surface would allow running turing2 tests
	// and evals for this embedded surface. Deprecated as of Feb 2019.
	// Please use "OPA_ANDROID_AUTO_EMBEDDED" client type for tests and
	// eval. See go/client-onboarding for more details.
	// https://cs.corp.google.com/piper///depot/google3/assistant/assistant_server/tools/util/consts.h?l=32&rcl=247481455
	//   "SPARK" - Unlaunched new surface prototype, ask spark-eng@.
	//   "WALLE" - Wall-E is an Area120 Project building assistant powered
	// robots. The surface is an extended joplin which have same
	// capabilities as a google home adding custom robot features. Currently
	// in active development. Please reach out walle-software@ or bingxin@
	// for questions. For details see go/walle-as-pipeline-1-pager.
	//   "UNIT_TESTING" - Surface used for unit-testing purposes. Unit-tests
	// might still require the existence of a "valid" SurfaceType to succeed
	// (eg. initialization of the CapabilityBuilder, proto matching, etc.).
	// With the move away from SurfaceType checks, a generic "TESTING"
	// SurfaceType can be used for such tests without affecting the test
	// behavior. Unlike the CAPABILITY_BASED_SURFACE, this proto does not
	// have any capabilities or ResponseType tied to it. It should only be
	// used for unit-tests and should not be exposed in the ASDebugger.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Type") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Type") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesSurfaceType) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesSurfaceType
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesSurfaceVersion: The version of the
// surface/client. New surfaces are encouraged to only use the
// “major” field to keep track of version number. The “minor”
// field may be used for surfaces that rely on both the “major” and
// “minor” fields to define their version.
type AssistantApiCoreTypesSurfaceVersion struct {
	Major int64 `json:"major,omitempty"`

	Minor int64 `json:"minor,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Major") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Major") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesSurfaceVersion) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesSurfaceVersion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiCoreTypesWebProviderInfo: The web information of the
// provider. Next ID: 5
type AssistantApiCoreTypesWebProviderInfo struct {
	// HomeStorage: Serialized storage (context) persisted and retrieved for
	// the app and home.
	HomeStorage string `json:"homeStorage,omitempty"`

	// LocalizedAppName: The localized app name.
	LocalizedAppName string `json:"localizedAppName,omitempty"`

	// OpenAppUrl: A URL to open the provider's app.
	OpenAppUrl string `json:"openAppUrl,omitempty"`

	// ThirdPartyCustomNluInfo: Info about 3P Custom NLU used in this web
	// provider. TODO(b/321644453) remove when QRewrite is able to call
	// SERoot.
	ThirdPartyCustomNluInfo *AssistantApiCoreTypesWebProviderInfoThirdPartyCustomNluInfo `json:"thirdPartyCustomNluInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HomeStorage") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HomeStorage") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesWebProviderInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesWebProviderInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiCoreTypesWebProviderInfoThirdPartyCustomNluInfo struct {
	// Locale: The locale of this agent version, represented by BCP-47
	// language strings, such as "en", "en-US", "fr", "fr-CA", "sr-Latn",
	// "zh-Hans-CN", etc.
	Locale string `json:"locale,omitempty"`

	// NluAgentId: Unique internal identifier of 3P Custom NLU agent. UUID.
	NluAgentId string `json:"nluAgentId,omitempty"`

	// NluAgentVersion: Identifies the 3P Custom NLU agent version.
	NluAgentVersion int64 `json:"nluAgentVersion,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Locale") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Locale") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCoreTypesWebProviderInfoThirdPartyCustomNluInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCoreTypesWebProviderInfoThirdPartyCustomNluInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiCrossDeviceExecutionCapability struct {
	// LocalConnectivityEnabled: Whether the device has torus/usonia
	// capabililities enabled or not.
	LocalConnectivityEnabled bool `json:"localConnectivityEnabled,omitempty"`

	// RemoteCastMediaEnabled: Whether the device supports cast media
	// originated from a remote device to be executed through local
	// execution and can upload results asynchronously. Needs to be checked
	// before sending remote media initiation through local channel since it
	// needs an async result upload path.
	RemoteCastMediaEnabled bool `json:"remoteCastMediaEnabled,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "LocalConnectivityEnabled") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LocalConnectivityEnabled")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiCrossDeviceExecutionCapability) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiCrossDeviceExecutionCapability
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiDate: A Gregorian calendar date.
type AssistantApiDate struct {
	// Day: The day, in 1...31.
	Day int64 `json:"day,omitempty"`

	// Month: The month, in 1...12.
	Month int64 `json:"month,omitempty"`

	// Year: The year, e.g. 2016.
	Year int64 `json:"year,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Day") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Day") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiDate) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiDate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiDateTime: A date-time specification, combining a date and
// civil time (relative to a given timezone).
type AssistantApiDateTime struct {
	// Date: A Gregorian calendar date.
	Date *AssistantApiDate `json:"date,omitempty"`

	// TimeOfDay: A civil time relative to a timezone.
	TimeOfDay *AssistantApiTimeOfDay `json:"timeOfDay,omitempty"`

	// TimeZone: A time zone in IANA format.
	TimeZone *AssistantApiTimeZone `json:"timeZone,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Date") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Date") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiDateTime) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiDateTime
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiDateTimeRange: A representation of a range of time with
// start and end datetime specified.
type AssistantApiDateTimeRange struct {
	// EndDate: End date of the range.
	EndDate *AssistantApiDateTime `json:"endDate,omitempty"`

	// StartDate: Start date of the range.
	StartDate *AssistantApiDateTime `json:"startDate,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EndDate") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndDate") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiDateTimeRange) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiDateTimeRange
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiDeviceCapabilities: This message describes roughly what a
// surface is capable of doing and metadata around those capabilities.
// These capabilities are determined based on: - device hardware -
// software - status (e.g. volume level, battery percentage) These
// capabilities refer to the surface and not the physical device. The
// list of supported surfaces can be found in the
// assistant.api.core_types.SurfaceType enum. A surface's capabilities
// can differ from the device's. An example would be ANDROID_ALLO
// running on Pixel. Allo does not support AudioInput while the Pixel
// does. In this case, audio_input will be set to false for Assistant
// Allo requests while it might be set to true for OPA_NEXUS requests.
// Next ID: 36
type AssistantApiDeviceCapabilities struct {
	// AndroidIntentCapabilities: Capabilites related to Android intent
	// support.
	AndroidIntentCapabilities *AssistantApiAndroidIntentCapabilities `json:"androidIntentCapabilities,omitempty"`

	// AssistantCapability: Capabilities if surface supports Google
	// Assistant.
	//
	// Possible values:
	//   "UNKNOWN"
	//   "SUPPORTED"
	//   "UNSUPPORTED" - Assistant is no longer supported(e.g., on legacy
	// surfaces).
	AssistantCapability string `json:"assistantCapability,omitempty"`

	// AudioInput: These capabilities are scoped to the ability to gather
	// audio. It includes information like the type of audio that can be
	// gathered (e.g. public, private).
	AudioInput *AssistantApiAudioInput `json:"audioInput,omitempty"`

	// AudioOutput: These capabilities are scoped to the ability to play
	// audio. It includes information like the type of audio that can be
	// played (e.g. public, private).
	AudioOutput *AssistantApiAudioOutput `json:"audioOutput,omitempty"`

	// BluetoothCapabilities: Bluetooth capabilities related to usage of a
	// feature.
	BluetoothCapabilities *AssistantApiBluetoothCapabilities `json:"bluetoothCapabilities,omitempty"`

	// CallCapabilities: The call capabilities of this device.
	// go/call-capabilities
	CallCapabilities *AssistantApiCallCapabilities `json:"callCapabilities,omitempty"`

	// Camera: These capabilities are scoped to the camera abilities of this
	// device.
	Camera *AssistantApiCameraCapabilities `json:"camera,omitempty"`

	// CarUxRestrictions: UX restrictions for Auto.
	//
	// Possible values:
	//   "UX_RESTRICTIONS_UNSPECIFIED" - This value should not be used.
	//   "UX_RESTRICTIONS_BASELINE" - No specific restrictions in place, but
	// baseline distraction optimization guidelines need to be adhered to
	// when CarUxRestrictions.isRequiresDistractionOptimization() returns
	// true.
	//   "UX_RESTRICTIONS_FULLY_RESTRICTED" - All restrictions are in
	// effect.
	//   "UX_RESTRICTIONS_NO_KEYBOARD" - No text entry for the purpose of
	// searching or other manual text string entry activities.
	//   "UX_RESTRICTIONS_NO_VIDEO" - No video - no animated frames > 1fps.
	CarUxRestrictions []string `json:"carUxRestrictions,omitempty"`

	// Cast: These capabilities are scoped to the cast abilities of this
	// device.
	Cast *AssistantApiCastCapabilities `json:"cast,omitempty"`

	CommunicationUiCapabilities *AssistantApiCommunicationUiCapabilities `json:"communicationUiCapabilities,omitempty"`

	ContactLookupCapabilities *AssistantApiContactLookupCapabilities `json:"contactLookupCapabilities,omitempty"`

	// DeviceId: This is the same device id that is specified in the
	// conversation protocol and should be unique to each device/user/model
	// combination. For example, if a request is coming from a watch through
	// AGSA the watch and AGSA should have different device_ids. Note: this
	// field should only be used to determine which device the capabilities
	// belong to and not to access the id of the device. Instead
	// DeviceProperties should be used and accessed through ParamsAccessor.
	DeviceId *AssistantApiCoreTypesDeviceId `json:"deviceId,omitempty"`

	// DeviceUxMode: Capabilities related to Android tablet UX experience.
	//
	// Possible values:
	//   "DEVICE_UX_MODE_DEFAULT"
	//   "DEVICE_UX_MODE_SUPPORT_LIMITED_SHARED_LOCKSCREEN" - Device
	// supports the Shared Lock Screen: a glanceable space that lets anyone
	// in the house use shared apps and the Assistant, without unlocking the
	// device. This is for devices which only support limited SLS, e.g. TKY.
	DeviceUxMode string `json:"deviceUxMode,omitempty"`

	// HasVoiceTelephony: Indicates that the device has connection to
	// cellular network that allows it to make voice calls. This is distinct
	// from device just being capable of voice telephony, because the device
	// can be capable yet miss the suitable SIM card (for example, it could
	// miss SIM card altogether, or have data-only SIM card).
	HasVoiceTelephony bool `json:"hasVoiceTelephony,omitempty"`

	// JwnCapabilities: Indicates if the client supports Javascript
	// Whatsnext (go/jwn). Also contains the Jwn libraries present on the
	// client along with their versions.
	JwnCapabilities *AssistantApiJwnCapabilities `json:"jwnCapabilities,omitempty"`

	// LensPerceptionCapabilities: Capabilities related to Lens Perception,
	// i.e. image understanding. See go/lens-perception-sdk.
	LensPerceptionCapabilities *AssistantApiLensPerceptionCapabilities `json:"lensPerceptionCapabilities,omitempty"`

	// Location: These capabilities are scoped to the location abilities of
	// this device.
	Location *AssistantApiLocationCapabilities `json:"location,omitempty"`

	// LoggingOnlyData: Data which is produced for logging and debugging.
	// Servers MUST NOT use this for any other purposes, such as branching
	// on it.
	LoggingOnlyData *AssistantApiLoggingOnlyData `json:"loggingOnlyData,omitempty"`

	MessageCapabilities *AssistantApiMessageCapabilities `json:"messageCapabilities,omitempty"`

	// Movement: These capabilities are scoped to abilities of the device to
	// move around.
	Movement *AssistantApiMovementCapabilities `json:"movement,omitempty"`

	// NotificationCapabilities: DEPRECATED: Use
	// SystemNotificationRestrictions instead. Specifies whether the surface
	// is able to display notifications. This field is superficially similar
	// to ProactiveNotificationOutput, but unlike that field which tracks a
	// per-user preference on the OPA side, this field captures whether the
	// surface is capable of displaying notifications.
	//
	// Possible values:
	//   "NO_NOTIFICATION_CAPABILITY" - The surface is not able to display
	// notifications.
	//   "NOTIFICATIONS_DISABLED" - The notifications are disabled on the
	// surface.
	//   "NOTIFICATIONS_ENABLED" - The notifications are enabled.
	NotificationCapabilities string `json:"notificationCapabilities,omitempty"`

	// NotificationOutputRestrictions: Settings, that reflect whether a
	// specific notification type is allowed for current device, e.g. if the
	// user opted out from notification category or category group. This
	// settings are server-side stored and evaluated unlike
	// SystemNotificationRestrictions field.
	NotificationOutputRestrictions *AssistantApiNotificationOutputRestrictions `json:"notificationOutputRestrictions,omitempty"`

	// OutputRestrictions: These are user configured restrictions indicating
	// what the device is allowed to output from the privacy point of view.
	OutputRestrictions *AssistantApiOutputRestrictions `json:"outputRestrictions,omitempty"`

	// PopOnLockscreenCapability: Capability to support Pop on lockscreen.
	//
	// Possible values:
	//   "POP_ON_LOCKSCREEN_DEFAULT" - Pop will default to enabled on
	// lockscreen.
	//   "POP_ON_LOCKSCREEN_ENABLED" - Pop is enabled on lockscreen.
	//   "POP_ON_LOCKSCREEN_DISABLED" - Pop is disabled on lockscreen.
	PopOnLockscreenCapability string `json:"popOnLockscreenCapability,omitempty"`

	// SafetyRestrictions: Indicates if the client has safety related
	// restriction.
	//
	// Possible values:
	//   "DEFAULT_NO_SAFETY_RESTRICTION" - The surface has no safety
	// restriction.
	//   "DISTRACTION_SAFETY_RESTRICTION" - The surface has safety
	// restriction due to any distraction.
	SafetyRestrictions string `json:"safetyRestrictions,omitempty"`

	// Screen: These capabilities are scoped to the ability to see and
	// interact with the Assistant through a screen. If the device has no
	// screen it should send an empty ScreenCapabilities. Sending no
	// ScreenCapabilities will cause this to be overridden with the surface
	// default.
	Screen *AssistantApiScreenCapabilities `json:"screen,omitempty"`

	// SodaCapabilities: Capabilities related to SODA (Speech On-Device
	// API).
	SodaCapabilities *AssistantApiSodaCapabilities `json:"sodaCapabilities,omitempty"`

	// Software: These capabilities are scoped to the software available on
	// the device as well as the set of supported Assistant features.
	Software *AssistantApiSoftwareCapabilities `json:"software,omitempty"`

	// SpeechCapabilities: DEPRECATED Capabilities related to speech
	// detection on devices.
	SpeechCapabilities *AssistantApiSpeechCapabilities `json:"speechCapabilities,omitempty"`

	// SupportedLocale: Locales supported by assistant settings for speaking
	// and display. This is independent from device language that is defined
	// in device setting. New locales are added based on rollout, whitelist
	// and app version releases because older versions does not have model
	// support. Currently supported locale list differs by surface type.
	SupportedLocale []string `json:"supportedLocale,omitempty"`

	// SurfaceIdentity: The set of information that helps the server
	// identify the surface.
	SurfaceIdentity *AssistantApiCoreTypesSurfaceIdentity `json:"surfaceIdentity,omitempty"`

	// SurfaceTypeString: DEPRECATED. surface_identity field below already
	// contains this information. The device's surface type. This is the
	// string version of the assistant.api.core_types.SurfaceType enum. The
	// server should not use this field, rather it should use the
	// SurfaceType value derived from this string.
	SurfaceTypeString string `json:"surfaceTypeString,omitempty"`

	// SystemNotificationRestrictions: Restrictions related to system-level
	// notifications. This field is superficially similar to
	// ProactiveNotificationOutput, but unlike that field which tracks a
	// per-user preference on the OPA side, this field captures system level
	// notifications restrictions. This field is not stored and is merged to
	// capabilities from conversation params. It exists mostly for logging
	// purposes of android channel state and global app-level notification
	// opt out.
	SystemNotificationRestrictions *AssistantApiSystemNotificationRestrictions `json:"systemNotificationRestrictions,omitempty"`

	// ThirdPartyCapabilities: Capabilities related to third party
	// integration.
	ThirdPartyCapabilities *AssistantApiThirdPartyCapabilities `json:"thirdPartyCapabilities,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AndroidIntentCapabilities") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AndroidIntentCapabilities") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiDeviceCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiDeviceCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiDuration: A Duration represents a signed, fixed-length
// span of time represented as a count of seconds and fractions of
// seconds at nanosecond resolution. It is independent of any calendar
// and concepts like "day" or "month". It is related to Timestamp in
// that the difference between two Timestamp values is a Duration and it
// can be added or subtracted from a Timestamp. Range is approximately
// +-10,000 years.
type AssistantApiDuration struct {
	// Nanos: Signed fractions of a second at nanosecond resolution of the
	// span of time. Durations less than one second are represented with a 0
	// `seconds` field and a positive or negative `nanos` field. For
	// durations of one second or more, a non-zero value for the `nanos`
	// field must be of the same sign as the `seconds` field. Must be from
	// -999,999,999 to +999,999,999 inclusive.
	Nanos int64 `json:"nanos,omitempty"`

	// Seconds: Signed seconds of the span of time. Must be from
	// -315,576,000,000 to +315,576,000,000 inclusive.
	Seconds int64 `json:"seconds,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Nanos") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Nanos") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiDuration) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiDuration
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiFeatureSpecificActionSupport struct {
	// ClarificationDataSupported: Whether client supports clarification
	// suggestion chip to be displayed see
	// |assistant.suggestions.ClarificationData|
	ClarificationDataSupported bool `json:"clarificationDataSupported,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ClarificationDataSupported") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "ClarificationDataSupported") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiFeatureSpecificActionSupport) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiFeatureSpecificActionSupport
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiFitnessFeatureSupport struct {
	// SupportedActivities: A list of fitness activity types supported by
	// this client.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - The type is unknown.
	//   "WALK" - Represents a walking activity type.
	//   "RUN" - Represents a running activity type.
	//   "ELLIPTICAL" - Represents an elliptical activity type.
	//   "SWIM" - Represents a swimming activity type.
	//   "WEIGHTS" - Represents a weightlifting activity type.
	//   "TREADMILL" - Represents a treadmill activity type (e.g.
	// walking/running on a treadmill).
	//   "BIKE" - Represents a cycling activity type.
	//   "YOGA" - Represents a yoga activity type.
	//   "WORKOUT" - Represents a generic workout activity.
	//   "BOOT_CAMP" - Represents a bootcamp activity type.
	//   "CIRCUIT_TRAINING" - Represents a circuit training activity type.
	//   "GOLF" - Represents a golf activity type.
	//   "HIKING" - Represents a hiking activity type.
	//   "INTERVAL_TRAINING" - Represents an interval training activity
	// type.
	//   "KICKBOXING" - Represents a kickboxing activity type.
	//   "MARTIAL_ARTS" - Represents a martial arts activity type.
	//   "PILATES" - Represents a pilates activity type.
	//   "SPINNING" - Represents a spinning(indoor cycling, stationary
	// biking) activity type.
	//   "STAIR_CLIMBING" - Represents a stair climbing activity type.
	//   "TENNIS" - Represents a tennis activity type.
	//   "AEROBICS" - Represents an aerobics activity type.
	//   "CORE_TRAINING" - Represents a core training activity type.
	//   "DANCING" - Represents a dancing activity type.
	//   "HIGH_INTENSITY_INTERVAL_TRAINING" - Represents a HIIT activity
	// type.
	//   "KAYAKING" - Represents a kayaking activity type.
	//   "ROWING" - Represents a rowing activity type.
	//   "SKIING" - Represents a skiing activity type.
	//   "STANDUP_PADDLEBOARDING" - Represents a standup paddleboading(SUP)
	// activity type.
	//   "STRENGTH_TRAINING" - Represents a strength training activity type.
	//   "SNOWBOARDING" - Represents a snowboarding activity type.
	SupportedActivities []string `json:"supportedActivities,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SupportedActivities")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SupportedActivities") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiFitnessFeatureSupport) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiFitnessFeatureSupport
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiFluidActionsSupport struct {
	// StateSyncMethod: Specifies the params proto that Fluid Actions uses
	// to sync state with server.
	//
	// Possible values:
	//   "STATE_SYNC_METHOD_UNSPECIFIED" - Unspecified state sync method.
	//   "DIALOG_STATE_PARAMS" - New params proto used to sync state between
	// client and server. New clients must use this value. For proto
	// details, see:
	// http://google3/assistant/api/params/dialog_state_params.proto
	StateSyncMethod string `json:"stateSyncMethod,omitempty"`

	// ForceSendFields is a list of field names (e.g. "StateSyncMethod") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "StateSyncMethod") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiFluidActionsSupport) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiFluidActionsSupport
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiGacsCapabilities: Capabilities of Google assistant
// conversation service(GACS) devices. These capabilites including
// supported GACS actions and response size limitations.
type AssistantApiGacsCapabilities struct {
	// DeviceId: DeviceId of the accessory device (eg. watch) Commonly the
	// go/dusi (eg. client_instance_id) is provided.
	DeviceId *AssistantApiCoreTypesDeviceId `json:"deviceId,omitempty"`

	// ResponseConfig: Configuration sent by device.
	ResponseConfig *GoogleAssistantAccessoryV1ResponseConfig `json:"responseConfig,omitempty"`

	// TtsEncoding: DEPRECATED: Format of TTS audio requested by the device.
	//
	// Possible values:
	//   "LINEAR_16BIT" - Signed 16-bit little-endian (a.k.a s16le) linear
	// PCM.
	//   "MULAW" - G.711 audio companding.
	// https://en.wikipedia.org/wiki/G.711 8-bit μ-law encoding according
	// to G.711
	//   "ALAW" - 8-bit A-law encoding according to G.711.
	//   "MP3" - The default MP3 encoding is 32kbps. Text-to-speech audio at
	// this bit rate has audible compression artifacts and is not
	// recommended. Please use OPUS_IN_OGG instead.
	//   "MP3_64KBPS" - MP3 at 64kbps sounds nearly identical to
	// uncompressed for 24kHz TTS audio, and sounds similar to OPUS_IN_OGG.
	//   "SPEEX" - Raw speex stream with each frame concatenated together.
	// The size of each frame will need to be communciated separately.
	// Variable bitrate encoding is unsupported using this output type.
	//   "SPEEX_WITH_HEADER_BYTE" - Similar to SPEEX, this mode will
	// concatenate together the speex frames. However, each frame will have
	// prepended a single byte that describes the length of the following
	// frame.
	//   "SPEEX_IN_OGG" - In this case, we'll wrap the speex contents in an
	// ogg container, resulting in a more generally decode-able format but
	// one with more storage overhead.
	//   "OPUS_IN_OGG" - Opus encoded audio wrapped in an ogg container. The
	// result will be a file which can be played natively on Android, and in
	// browsers (at least Chrome and Firefox). The quality of the encoding
	// is considerably higher than MP3 when using the same bitrate. At the
	// moment, this defaults to 32kbps but the TTS team reserves the right
	// to adjust the bitrate to provide the best experience.
	//   "OPUS_24KBPS_IN_OGG" - Opus encoded audio in 24kbps wrapped in an
	// ogg container. The result will be a file which can be played natively
	// on Android, and in browsers while reducing data consumption slightly.
	//   "OPUS_16KBPS_IN_OGG" - The following bitrates for Opus below 24kbps
	// are here only for special usecases; they result in a significant
	// reduction in quality. Please get in touch with the TTS team if you
	// think you might have a valid usecase. NOTE(staz): These bitrates are
	// not officially supported. TTS is to be served at a minimum of 24kbps
	// everywhere, including in NBU countries. See b/137234032#comment13 on
	// why lower bitrates don't help in tangible ways even in NBU markets.
	//   "OPUS_12KBPS_IN_OGG"
	//   "OPUS_16KBPS_CONTAINERLESS" - Opus encoded audio using the
	// specified bitrate without a container such as Ogg, RTP or WebM. The
	// response is a stream which can be played natively on low powered
	// wearable devices. Delivered as multiple frames per S3 response. These
	// frames need to be carefully byte-delimited (constant bitrate) by the
	// client. They use a statically defined frame duration of 20ms. Frame
	// size per bit-rate: 16kbps: each frame is of size 40 bytes 24kbps:
	// each frame is of size 60 bytes 32kbps: each frame is of size 80 bytes
	//   "OPUS_24KBPS_CONTAINERLESS"
	//   "OPUS_32KBPS_CONTAINERLESS"
	TtsEncoding string `json:"ttsEncoding,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeviceId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeviceId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiGacsCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiGacsCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiGcmCapabilities: Capabilities related to GCM.
type AssistantApiGcmCapabilities struct {
	// GcmRegistrationId: GCM registration id for the device. Used to pass
	// messages to the device.
	GcmRegistrationId string `json:"gcmRegistrationId,omitempty"`

	// SupportsAssistantGcm: Assistant supports GCM on the device. ClientOps
	// can be sent to it over GCM and will be executed.
	SupportsAssistantGcm bool `json:"supportsAssistantGcm,omitempty"`

	// SupportsClientInputOverGcm: If it is set to true, then it indicates
	// to server that device is capable of receiving a GCM payload with
	// serialized client input. The client input will be sent back to
	// Assistant Server over conversation protocol.
	SupportsClientInputOverGcm bool `json:"supportsClientInputOverGcm,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcmRegistrationId")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcmRegistrationId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiGcmCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiGcmCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiGestureCapabilities: The gesture capabilities related to
// Selina. Next ID: 4
type AssistantApiGestureCapabilities struct {
	// GestureSensing: Whether Gesture is supported. When false, override
	// the value for tap and omniswipe.
	GestureSensing bool `json:"gestureSensing,omitempty"`

	// OmniswipeGestureCapable: Whether omniswipe is supported
	OmniswipeGestureCapable bool `json:"omniswipeGestureCapable,omitempty"`

	// TapGestureCapable: Whether tap is supported
	TapGestureCapable bool `json:"tapGestureCapable,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GestureSensing") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GestureSensing") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiGestureCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiGestureCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiGuestAccessOutput: Access settings for guests.
type AssistantApiGuestAccessOutput struct {
	// Possible values:
	//   "UNKNOWN_GUEST_ACCESS"
	//   "USE_DEFAULT_ACCOUNT_FOR_GUEST" - Guests can access content using
	// linked users' account.
	//   "DISABLED_FOR_GUEST" - No access for guests.
	GuestAccessOnYoutube string `json:"guestAccessOnYoutube,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "GuestAccessOnYoutube") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GuestAccessOnYoutube") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiGuestAccessOutput) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiGuestAccessOutput
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiImmersiveCanvasSupport struct {
	// ConfirmationMessageSupported: Whether the client supports
	// confirmation messages in Immersive Canvas actions.
	ConfirmationMessageSupported bool `json:"confirmationMessageSupported,omitempty"`

	// PauseSignalSupported: Whether the client support canvas pause signal.
	// If true, the Assistant Server will send a signal when canvas
	// transitioning to pause mode.
	PauseSignalSupported bool `json:"pauseSignalSupported,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ConfirmationMessageSupported") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "ConfirmationMessageSupported") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiImmersiveCanvasSupport) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiImmersiveCanvasSupport
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiJwnCapabilities: These capabilities are used to determine
// the jwn libraries and their versions that are present on the client.
type AssistantApiJwnCapabilities struct {
	// LibrariesVersionMap: The name and version of the jwn libraries
	// currently stored on the client. These are the same that the server
	// communicated when the library was first sent down.
	LibrariesVersionMap map[string]string `json:"librariesVersionMap,omitempty"`

	// SupportedCompressionMode: Compression algorithms supported on the
	// client. Server can choose one of these to compress WhatsNext
	// Javascript programs and libraries.
	//
	// Possible values:
	//   "NONE" - jwn_program is not in compressed state.
	//   "BROTLI" - Brotli (google3/third_party/brotli) compression used.
	// Recommended compressor for Javascript.
	//   "FLATE" - Flate (google3/util/compression/flate) compression used.
	SupportedCompressionMode []string `json:"supportedCompressionMode,omitempty"`

	// SupportsJwn: Whether the client supports running jwn code.
	SupportsJwn bool `json:"supportsJwn,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LibrariesVersionMap")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LibrariesVersionMap") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiJwnCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiJwnCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiLensPerceptionCapabilities: Capabilities related to Lens
// Perception, i.e. image understanding. See
// go/loa-lens-device-capabilities. Next ID: 6
type AssistantApiLensPerceptionCapabilities struct {
	// HasLensPerception: Whether the device supports Lens Perception.
	HasLensPerception bool `json:"hasLensPerception,omitempty"`

	// IsLensDirectIntentAvailable: Indicates whether Lens supports Lens
	// Direct Intent (go/lensdirectintent).
	IsLensDirectIntentAvailable bool `json:"isLensDirectIntentAvailable,omitempty"`

	// IsLensLiveViewfinderAvailable: Indicates whether Lens supports Live
	// view-finder experience.
	IsLensLiveViewfinderAvailable bool `json:"isLensLiveViewfinderAvailable,omitempty"`

	// IsLensPostCaptureAvailable: Indicates whether Lens supports
	// Post-capture experience with an image payload.
	IsLensPostCaptureAvailable bool `json:"isLensPostCaptureAvailable,omitempty"`

	// LensCapabilities: Contains the capabilities that Lens can support.
	LensCapabilities *AssistantApiLensPerceptionCapabilitiesLensCapabilities `json:"lensCapabilities,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HasLensPerception")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HasLensPerception") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiLensPerceptionCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiLensPerceptionCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiLensPerceptionCapabilitiesLensCapabilities: The set of
// capabilities that Lens can support. This is the Assistant proto
// representation of Lens capabilities defined at
// j/c/g/android/apps/gsa/search/shared/service/proto/lens_service_event.
// proto Next ID: 7
type AssistantApiLensPerceptionCapabilitiesLensCapabilities struct {
	// Dining: The presence of this message means that Dining is supported.
	Dining *AssistantApiLensPerceptionCapabilitiesLensCapabilitiesDining `json:"dining,omitempty"`

	// Education: The presence of this message means that Education is
	// supported.
	Education *AssistantApiLensPerceptionCapabilitiesLensCapabilitiesEducation `json:"education,omitempty"`

	// Outdoor: The presence of this message means that Outdoor is
	// supported.
	Outdoor *AssistantApiLensPerceptionCapabilitiesLensCapabilitiesOutdoor `json:"outdoor,omitempty"`

	// Shopping: The presence of this message means that Shopping is
	// supported.
	Shopping *AssistantApiLensPerceptionCapabilitiesLensCapabilitiesShopping `json:"shopping,omitempty"`

	// Text: The presence of this message means that intenting directly into
	// the text filter is supported.
	Text *AssistantApiLensPerceptionCapabilitiesLensCapabilitiesText `json:"text,omitempty"`

	// Translate: The presence of this message means that Translation is
	// supported.
	Translate *AssistantApiLensPerceptionCapabilitiesLensCapabilitiesTranslate `json:"translate,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dining") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dining") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiLensPerceptionCapabilitiesLensCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiLensPerceptionCapabilitiesLensCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiLensPerceptionCapabilitiesLensCapabilitiesDining: Dining
// recognition capability. For example popular dishes on a given
// restaurant menu image.
type AssistantApiLensPerceptionCapabilitiesLensCapabilitiesDining struct {
}

// AssistantApiLensPerceptionCapabilitiesLensCapabilitiesEducation:
// Education recognition capability.
type AssistantApiLensPerceptionCapabilitiesLensCapabilitiesEducation struct {
}

// AssistantApiLensPerceptionCapabilitiesLensCapabilitiesOutdoor:
// Outdoor place recognition capability. For example recognizing
// storefronts.
type AssistantApiLensPerceptionCapabilitiesLensCapabilitiesOutdoor struct {
}

// AssistantApiLensPerceptionCapabilitiesLensCapabilitiesShopping:
// Shopping recognition capability.
type AssistantApiLensPerceptionCapabilitiesLensCapabilitiesShopping struct {
}

// AssistantApiLensPerceptionCapabilitiesLensCapabilitiesText: Text
// recognition capability.
type AssistantApiLensPerceptionCapabilitiesLensCapabilitiesText struct {
	// IsTextToSpeechSupported: Indicates whether text-to-speech is
	// supported.
	IsTextToSpeechSupported bool `json:"isTextToSpeechSupported,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "IsTextToSpeechSupported") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IsTextToSpeechSupported")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiLensPerceptionCapabilitiesLensCapabilitiesText) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiLensPerceptionCapabilitiesLensCapabilitiesText
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiLensPerceptionCapabilitiesLensCapabilitiesTranslate:
// Translation capability.
type AssistantApiLensPerceptionCapabilitiesLensCapabilitiesTranslate struct {
	// SupportedLanguageTags: The list of language IETF BCP 47 tags that are
	// supported. See the full details in the comment on the equivalent
	// field in:
	// http://google3/java/com/google/android/apps/gsa/search/shared/service/proto/lens_service_event.proto;l=55;rcl=355512559
	SupportedLanguageTags []string `json:"supportedLanguageTags,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "SupportedLanguageTags") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SupportedLanguageTags") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiLensPerceptionCapabilitiesLensCapabilitiesTranslate) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiLensPerceptionCapabilitiesLensCapabilitiesTranslate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiLiveTvChannelCapabilities struct {
	// ChannelsByProvider: A list of channel providers each of which
	// provides a list of its channels.
	ChannelsByProvider []*AssistantApiLiveTvChannelCapabilitiesChannelsByProvider `json:"channelsByProvider,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ChannelsByProvider")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ChannelsByProvider") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiLiveTvChannelCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiLiveTvChannelCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiLiveTvChannelCapabilitiesChannelsByProvider struct {
	// Channels: A list of channels provided by this input. Keep the
	// performance impact in mind when the number/size of the channels is
	// large. When there are too many channels, consider stripping out some
	// data.
	Channels []*AssistantApiLiveTvChannelCapabilitiesLiveTvChannel `json:"channels,omitempty"`

	// InputId: An identifier to identify the input source. For example for
	// TIF based channels, this will be the TIF input ID to differentiate
	// different tuner apps. See https://source.android.com/devices/tv
	InputId string `json:"inputId,omitempty"`

	// ProviderType: Type of provider who provides this channel input.
	//
	// Possible values:
	//   "UNKNOWN_PROVIDER_TYPE"
	//   "OTT_PROVIDER" - OTT providers providing live tv contents like
	// Sling, Youtube TV.
	//   "TUNER" - TV Tuner apps providing live tv contents.
	ProviderType string `json:"providerType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Channels") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Channels") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiLiveTvChannelCapabilitiesChannelsByProvider) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiLiveTvChannelCapabilitiesChannelsByProvider
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiLiveTvChannelCapabilitiesLiveTvChannel struct {
	// ChannelId: Unique channel identifier.
	ChannelId string `json:"channelId,omitempty"`

	// ChannelName: A list of channel names and synonyms.
	ChannelName []string `json:"channelName,omitempty"`

	// ChannelNumber: Channel number displayed to user. Optional.
	ChannelNumber string `json:"channelNumber,omitempty"`

	// Deeplink: A deep link into the Live player app that tunes to this
	// channel.
	Deeplink string `json:"deeplink,omitempty"`

	// Mid: KG mid of the channel if it exists in KG.
	Mid string `json:"mid,omitempty"`

	// NetworkMid: Network KG mid of the channel if it exists in KG
	NetworkMid string `json:"networkMid,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ChannelId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ChannelId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiLiveTvChannelCapabilitiesLiveTvChannel) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiLiveTvChannelCapabilitiesLiveTvChannel
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiLiveTvProvider struct {
	// ProviderInfo: Contains detailed provider information such as android
	// app package name.
	ProviderInfo *AssistantApiCoreTypesProvider `json:"providerInfo,omitempty"`

	// ProviderKey: A provider enum string for OTT providers. The available
	// key can be found in go/ump-provider-enum For Tuner provider, the
	// provider key would be an ID the tuner app uploaded from TIF. See
	// https://source.android.com/devices/tv
	ProviderKey string `json:"providerKey,omitempty"`

	// Possible values:
	//   "UNKNOWN_PROVIDER_TYPE"
	//   "OTT_PROVIDER" - OTT providers providing live tv contents like
	// Sling, Youtube TV.
	//   "TUNER" - TV Tuner apps providing live tv contents.
	ProviderType string `json:"providerType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ProviderInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ProviderInfo") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiLiveTvProvider) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiLiveTvProvider
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiLocationCapabilities struct {
	GpsAvailable bool `json:"gpsAvailable,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GpsAvailable") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GpsAvailable") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiLocationCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiLocationCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiLoggingOnlyData: Data which is produced for logging and
// debugging. Servers MUST NOT use this for any other purposes, such as
// branching on it. Next ID: 16
type AssistantApiLoggingOnlyData struct {
	// AcpVersion: A user-readable string describing the ACP version
	// (go/acp-version) of the client app used by the user to originate the
	// conversation.
	AcpVersion string `json:"acpVersion,omitempty"`

	// AndroidId: Random identifier assigned to Android mobile devices.
	// Older logs may have previously stored other kinds of android IDs in
	// this field, but all current logs should use the GServices Id. See
	// go/androidids.
	AndroidId int64 `json:"androidId,omitempty,string"`

	// AppVersion: A user-readable string describing the version of the
	// client app used by the user to originate the conversation.
	AppVersion string `json:"appVersion,omitempty"`

	// AssistantSettingsSource: An enum specifying when was this ATV
	// AssistantSettings entry initially created.
	//
	// Possible values:
	//   "NOT_SET" - LINT.IfChange
	//   "FIRST_SCREEN_DEVICE_OOBE" - Created during ATV Device
	// OOBE(setupwraith)
	//   "FIRST_SCREEN_KATNISS_OOBE" - Created within Katniss(Assistant
	// client on TV)
	//   "FIRST_SCREEN_DELEGATION_OOBE" - Created within Katniss delegation
	// path
	//   "FIRST_SCREEN_FIXER_JOB" - Created by fix settings job in katniss.
	//   "FIRST_SCREEN_FCM_JOB" - Created by FCM jobs in katnisss.
	//   "FIRST_SCREEN_HOME_GRAPH_JOB" - Created by home graph jobs in
	// katniss.
	//   "FIRST_SCREEN_PERSONAL_BIT" - Created by enable personal bit button
	// in Settings UI
	//   "FIRST_SCREEN_VOICE_INPUT_BIT" - Created by enable voice input bit
	// button in Settings UI
	//   "FIRST_SCREEN_OTHER" - Created by other parts in katniss
	//   "SECOND_SCREEN_AGSA" - Created by AGSA
	//   "SECOND_SCREEN_GHA_IOS" - Created by Google Home App IOS
	//   "SECOND_SCREEN_GHA_ANDROID" - Created by Google Home App Android
	// LINT.ThenChange(//depot/google3/logs/proto/assistant/capabilities_log.
	// proto)
	AssistantSettingsSource string `json:"assistantSettingsSource,omitempty"`

	// BoardName: The type of board used by manufacturer for this device
	BoardName string `json:"boardName,omitempty"`

	// BoardRevision: The revision of board used
	BoardRevision string `json:"boardRevision,omitempty"`

	// CastAssistantSettingLinkingResult: This field records the linking
	// status between Assistant setting entry and Cast setting entry.
	// Currently only ATV surface populates this field for profiling
	// purpose.
	CastAssistantSettingLinkingResult *AssistantApiCastAssistantSettingLinkingResult `json:"castAssistantSettingLinkingResult,omitempty"`

	// DeviceModel: A user-readable string describing the device's hardware
	// platform.
	DeviceModel string `json:"deviceModel,omitempty"`

	// EmbedderBuildInfo: Any relevant info concerning the build options of
	// the embedder (that is the software which runs as the 'driver' of an
	// Assistant library, such as libassistant. the embedder is typically
	// built by a third party)
	EmbedderBuildInfo string `json:"embedderBuildInfo,omitempty"`

	// InitialAppVersion: A string recording the app version that is
	// initially used to created this settings entry.
	InitialAppVersion string `json:"initialAppVersion,omitempty"`

	// IsPrimaryUser: Boolean field to indicate whether a certain user is
	// the primary user of a device or not. This is useful for
	// distinguishing the user0 from other users given user0 might have
	// certain privileges (Eg: Hubmode on Tangor)
	IsPrimaryUser bool `json:"isPrimaryUser,omitempty"`

	// MdnsDisplayName: default display name of device over mdns. This is
	// specified at the factory, not specified by the user.
	MdnsDisplayName string `json:"mdnsDisplayName,omitempty"`

	// PlatformBuild: A user-readable string describing the device's
	// software platform.
	PlatformBuild string `json:"platformBuild,omitempty"`

	// VirtualReleaseChannel: A string describing device's release channel.
	// For cast devices, the string will look like "qa-beta-channel",
	// "eng-no-update", etc.
	VirtualReleaseChannel string `json:"virtualReleaseChannel,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AcpVersion") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AcpVersion") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiLoggingOnlyData) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiLoggingOnlyData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiMediaControlSupport struct {
	// SkipConfirmationsWhilePlaying: Whether to prevent confirmations
	// (text, tts) for media control actions while media is playing so that
	// the media session is not interrupted.
	SkipConfirmationsWhilePlaying bool `json:"skipConfirmationsWhilePlaying,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "SkipConfirmationsWhilePlaying") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "SkipConfirmationsWhilePlaying") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiMediaControlSupport) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiMediaControlSupport
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiMessageCapabilities struct {
	// FallbackToTetheredDeviceAppCapabilities: If true, APP_ID queries
	// initiated by this device should fall back to execution on the
	// tethered device if it's available and if the primary device cannot
	// perform the action (e.g. due to the app not being installed).
	FallbackToTetheredDeviceAppCapabilities bool `json:"fallbackToTetheredDeviceAppCapabilities,omitempty"`

	// PreferTargetingPrimaryDevice: For chat_message.SEND targeting, when
	// either the primary or secondary (tethered) device is capable of
	// handling the chat_message.SEND action, prefer targeting it to the
	// primary device.
	PreferTargetingPrimaryDevice bool `json:"preferTargetingPrimaryDevice,omitempty"`

	// SupportedRecipientTypes: Should only be checked if nonempty.
	//
	// Possible values:
	//   "UNSPECIFIED_ENDPOINT"
	//   "PHONE_NUMBER"
	//   "EMAIL_ADDRESS"
	//   "APP_UNIQUE_ID"
	//   "EMERGENCY_PHONE_NUMBER"
	//   "VOICEMAIL"
	SupportedRecipientTypes []string `json:"supportedRecipientTypes,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "FallbackToTetheredDeviceAppCapabilities") to unconditionally include
	// in API requests. By default, fields with empty or default values are
	// omitted from API requests. However, any non-pointer, non-interface
	// field appearing in ForceSendFields will be sent to the server
	// regardless of whether the field is empty or not. This may be used to
	// include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "FallbackToTetheredDeviceAppCapabilities") to include in API requests
	// with the JSON null value. By default, fields with empty values are
	// omitted from API requests. However, any field with an empty value
	// appearing in NullFields will be sent to the server as null. It is an
	// error if a field in this list has a non-empty value. This may be used
	// to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiMessageCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiMessageCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiMovementCapabilities struct {
	// Mobility: Indicates how much the device moves around. E.g., TV has a
	// low mobility level, while Auto has a very high level.
	//
	// Possible values:
	//   "UNSPECIFIED"
	//   "LOW"
	//   "MEDIUM"
	//   "HIGH"
	//   "VERY_HIGH"
	Mobility string `json:"mobility,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Mobility") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Mobility") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiMovementCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiMovementCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiNotificationOutputRestrictions struct {
	OptOutState *AssistantApiNotificationOutputRestrictionsOptOutState `json:"optOutState,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OptOutState") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OptOutState") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiNotificationOutputRestrictions) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiNotificationOutputRestrictions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiNotificationOutputRestrictionsOptOutState: Per
// category/category group notification opt out settings.
type AssistantApiNotificationOutputRestrictionsOptOutState struct {
	CategoryGroupState []*AssistantApiNotificationOutputRestrictionsOptOutStateCategoryGroupState `json:"categoryGroupState,omitempty"`

	CategoryState []*AssistantApiNotificationOutputRestrictionsOptOutStateCategoryState `json:"categoryState,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CategoryGroupState")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CategoryGroupState") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiNotificationOutputRestrictionsOptOutState) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiNotificationOutputRestrictionsOptOutState
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiNotificationOutputRestrictionsOptOutStateCategoryGroupState struct {
	// Possible values:
	//   "UNSPECIFIED"
	//   "SYSTEM" - This is required, do not remove. Group for notification
	// categories that should not be displayed at all.
	//   "PROMOTIONAL" - Promotional notifications.
	//   "SUBSCRIPTIONS" - Notifications for Subscriptions.
	//   "PROACTIVE" - Proactive notifications
	//   "REMINDERS" - Reminders (including assigned reminders).
	//   "EXTENDED_ANSWERS" - Cross surface answers.
	//   "FEEDBACK" - Assistant asking for feedback from users.
	//   "ACTIONS_ON_GOOGLE" - AoG 3P notifications.
	//   "DUO_MISSED_CALLS" - Missed call notifications from DUO.
	//   "HOME_AUTOMATION" - Home Automation notifications.
	//   "GETTING_AROUND" - Getting around notifications.
	//   "UNIT_TESTING" - Always keep at the end.
	CategoryGroup string `json:"categoryGroup,omitempty"`

	// Possible values:
	//   "OPTED_IN" - Default value is intentionally set to opted in as all
	// categories/category groups are enabled by default.
	//   "OPTED_OUT"
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CategoryGroup") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CategoryGroup") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiNotificationOutputRestrictionsOptOutStateCategoryGroupState) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiNotificationOutputRestrictionsOptOutStateCategoryGroupState
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiNotificationOutputRestrictionsOptOutStateCategoryState struct {
	// Possible values:
	//   "UNSPECIFIED"
	//   "SYSTEM_REQUIRED_LOW_PRIORITY" - Categories required by Assistant &
	// won't be shown on settings page.
	//   "SYSTEM_REQUIRED_HIGH_PRIORITY"
	//   "DISCOVERY" - Promotional discovery notifications.
	//   "REALTIME_PROMOTIONAL"
	//   "SUBSCRIPTIONS" - Subscriptions (both event and time based).
	//   "FLIGHT_UPDATES" - Proactive notification categories.
	//   "TRANSPORT_UPDATES"
	//   "BILL_UPDATES"
	//   "PACKAGE_DELIVERY_UPDATES"
	//   "EVENT_UPDATES"
	//   "DUE_DATE_UPDATES"
	//   "CELEBRATION_UPDATES"
	//   "ROUTINE_UPDATES"
	//   "TASK_SUGGESTIONS"
	//   "AT_A_PLACE"
	//   "APP_RECOMMENDATIONS"
	//   "TRAVEL_UPDATES"
	//   "REMINDER_DUE" - Reminder notification categories.
	//   "NEW_REMINDER_ASSIGNMENT"
	//   "ASSIGNED_REMINDER_DUE" - We're probably going to deprecate
	// ASSIGNED_REMINDER_DUE.
	//   "ROUTINE_SETTINGS_UPDATES" - Routine related notification
	// categories.
	//   "MAPS_OR_DIRECTIONS" - Extended answer (cross device) notification
	// categories.
	//   "MOVIE_SHOWTIMES"
	//   "SPORTS_UPDATES"
	//   "NEWS_UPDATES"
	//   "SONGS_AND_ARTISTS"
	//   "TRANSLATIONS"
	//   "ANSWERS_TO_QUESTIONS"
	//   "SETTINGS_LINKS"
	//   "RESERVATION_UPDATES"
	//   "DEPRECATED_FEEDBACK_REQUESTS" - Feedback requests from Assistant.
	//   "FEEDBACK_REQUESTS"
	//   "ACTIONS_ON_GOOGLE" - Actions on Google (Third party)
	// notifications.
	//   "DUO_MISSED_CALLS" - Missed call notifications from DUO.
	//   "HOME_AUTOMATION" - Home Automation related notifications.
	//   "TIME_TO_LEAVE" - Getting around notifications.
	//   "COMMUTE"
	//   "OCCASIONALLY_REPEATED_ACTIONS" - Repeated actions. Having two
	// categories for occasionally and frequently repeated ones since the
	// FREQUENTLY_REPEATED_ACTIONS are buzzing.
	//   "FREQUENTLY_REPEATED_ACTIONS"
	//   "ASPIRE" - Assistant Aspire notifications.
	//   "ASSISTANT_DRIVING_MODE"
	//   "DISCOVERY_DEFAULT_PRIORITY" - Discovery notifications that shows
	// in status bar but doesn't make noise.
	//   "HOLIDAY_REMINDERS"
	//   "CROSS_DEVICE_TIMER"
	//   "LIVE_CARD" - Live cards, these are not real notifications but live
	// cards shown on Home App.
	//   "ASYNC_ACTION" - These are not really notifications, rather push
	// messages to initiate an asynchronous action.
	//   "UNIT_TESTING" - Always keep at the end.
	Category string `json:"category,omitempty"`

	// Possible values:
	//   "OPTED_IN" - Default value is intentionally set to opted in as all
	// categories/category groups are enabled by default.
	//   "OPTED_OUT"
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Category") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Category") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiNotificationOutputRestrictionsOptOutStateCategoryState) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiNotificationOutputRestrictionsOptOutStateCategoryState
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiOemCapabilities: Encapsulates the action capabilities of
// the OEM device. This data is merged from Device Model lookup,
// per-device registration, and per-request context. This data is sent
// to NLU layer for query understanding.
type AssistantApiOemCapabilities struct {
	// CloudCapability: The OEM Cloud execution capability of this device,
	// containing routing details for cloud fulfillment.
	CloudCapability *AssistantDevicesPlatformProtoCloudCapability `json:"cloudCapability,omitempty"`

	// CloudDeviceCapabilities: If fulfillment is done via 3P cloud and 3P
	// supports device capabilities, this field will be set.
	CloudDeviceCapabilities googleapi.RawMessage `json:"cloudDeviceCapabilities,omitempty"`

	// DeviceModelId: Device Model Id from DeviceModelPackage.
	DeviceModelId string `json:"deviceModelId,omitempty"`

	// DeviceModelRevisionId: Device Model Revision Id from
	// DeviceModelPackage.
	DeviceModelRevisionId int64 `json:"deviceModelRevisionId,omitempty,string"`

	// DeviceSpecificData: Opaque supported action data related to a
	// specific domain of devices, for example for car.
	// go/car-talk-registration-model
	DeviceSpecificData string `json:"deviceSpecificData,omitempty"`

	// InternalCapability: Internal-only config containing metadata about
	// the Device Model, for example to control the ranking behavior.
	InternalCapability *AssistantDevicesPlatformProtoInternalCapability `json:"internalCapability,omitempty"`

	// ThirdPartyActionConfig: 3P Action Metadata, populated from the Device
	// Model lookup and the client request parameters. For example, an
	// Assistant SDK request would have the billed project id of the
	// Assistant request added here in order to enable any Device Actions
	// developed using the same Google Cloud project. This data is sent to
	// Service Engine to mask triggering for Device Actions.
	ThirdPartyActionConfig *AssistantApiThirdPartyActionConfig `json:"thirdPartyActionConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CloudCapability") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CloudCapability") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiOemCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiOemCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiOnDeviceAssistantCapabilities: Definitions of on-device
// assistant capabilities.
type AssistantApiOnDeviceAssistantCapabilities struct {
	// IsLocalNetworkArbitrationSupported: Capabilities related to local
	// network arbitration (go/local-network-arbitration). Indicates if the
	// device is capable of being a host device in the LAN whiling doing
	// local network arbitration.
	IsLocalNetworkArbitrationSupported bool `json:"isLocalNetworkArbitrationSupported,omitempty"`

	// IsOnDeviceArbitrationSupported: Capabilities related to on-device
	// arbitration(go/arbitration-on-device).
	IsOnDeviceArbitrationSupported bool `json:"isOnDeviceArbitrationSupported,omitempty"`

	// IsOnDeviceAssistantSupported: Indicates if on-device assistant is
	// enabled on this device. Example usecases: NGA (go/nga) or Marble
	// (go/marble).
	IsOnDeviceAssistantSupported bool `json:"isOnDeviceAssistantSupported,omitempty"`

	// IsOnDeviceUnderstandingSupported: This may be used by NGA. E.g. if
	// understanding happens on device, we can have more aggressive logic
	// when fulfilling some features on the server side, like teleport.
	IsOnDeviceUnderstandingSupported bool `json:"isOnDeviceUnderstandingSupported,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "IsLocalNetworkArbitrationSupported") to unconditionally include in
	// API requests. By default, fields with empty or default values are
	// omitted from API requests. However, any non-pointer, non-interface
	// field appearing in ForceSendFields will be sent to the server
	// regardless of whether the field is empty or not. This may be used to
	// include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "IsLocalNetworkArbitrationSupported") to include in API requests with
	// the JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiOnDeviceAssistantCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiOnDeviceAssistantCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiOnDeviceSmartHomeCapabilities: Definitions of on-device
// Smart Home capabilities. Next ID: 2
type AssistantApiOnDeviceSmartHomeCapabilities struct {
	// IsOnDeviceSmartHomeSupported: Master bit for on-device Smart Home
	// features.
	IsOnDeviceSmartHomeSupported bool `json:"isOnDeviceSmartHomeSupported,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "IsOnDeviceSmartHomeSupported") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "IsOnDeviceSmartHomeSupported") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiOnDeviceSmartHomeCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiOnDeviceSmartHomeCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiOnDeviceStorageCapabilities: The on-device storage
// capabilities found on the device.
type AssistantApiOnDeviceStorageCapabilities struct {
	// IsSupported: Determines if an on-device storage is supported.
	IsSupported bool `json:"isSupported,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IsSupported") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IsSupported") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiOnDeviceStorageCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiOnDeviceStorageCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiOutputRestrictions: These are user configurable
// permissions representing what the device is allowed to output. Next
// ID: 11
type AssistantApiOutputRestrictions struct {
	// GooglePhotoContent: The type of Google Photo content which the device
	// can output.
	//
	// Possible values:
	//   "ALL_PHOTO_CONTENT" - All content can be output, including contents
	// from restricted categories (e.g. violent, racy).
	//   "NO_RESTRICTED_PHOTO_CONTENT" - Only content from non-restricted
	// categories can be output.
	GooglePhotoContent string `json:"googlePhotoContent,omitempty"`

	// GuestAccessOutput: Access settings for guests.
	GuestAccessOutput *AssistantApiGuestAccessOutput `json:"guestAccessOutput,omitempty"`

	// PersonalData: The level of personal data which the device can output.
	// See go/personal-readout for detail.
	//
	// Possible values:
	//   "PERSONAL_DATA_OUTPUT_UNKNOWN" - UNKNOWN.
	//   "ALL_PERSONAL_DATA_WITH_PROACTIVE" - DO NOT USE. This field has
	// been deprecated.
	//   "ALL_PERSONAL_DATA" - All personal data can be output.
	//   "NO_PERSONAL_DATA" - No personal data can be output.
	PersonalData string `json:"personalData,omitempty"`

	// ProactiveNotificationOutput: This controls if the server can
	// proactively send notification to users, and it does not affect
	// scenarios that users ask for information. The notification may
	// include TTS and lights. It could be only lights for chirp.
	//
	// Possible values:
	//   "UNKNOWN_PROACTIVE_NOTIFICATION" - The setting for proactive
	// notification is unknown
	//   "NO_PROACTIVE_NOTIFICATION" - No proactive notification can be
	// output
	//   "ALL_PROACTIVE_NOTIFICATIONS" - All proactive notifications can be
	// output
	ProactiveNotificationOutput string `json:"proactiveNotificationOutput,omitempty"`

	// ProactiveOutput: Restrictions on displaying and interacting with
	// content on proactive surfaces (e.g. Dragonglass home screen). Note:
	// NEVER access this field of OutputRestrictions directly, use the code
	// in assistant/assistant_server/settings/device/device_settings_util.h
	// instead.
	ProactiveOutput *AssistantApiProactiveOutput `json:"proactiveOutput,omitempty"`

	// YoutubeAutoplayRestriction: Whether YouTube autoplay is allowed for
	// queries from the user to this device. See
	// go/assistant-youtube-settings for details.
	//
	// Possible values:
	//   "AUTOPLAY_RESTRICTION_UNSPECIFIED"
	//   "AUTOPLAY_ALLOWED" - Autoplay can be applied to youtube queries to
	// the device from this user
	//   "AUTOPLAY_DISABLED" - Autoplay must not be enabled for youtube
	// queries to the device from this user
	YoutubeAutoplayRestriction string `json:"youtubeAutoplayRestriction,omitempty"`

	// YoutubeContent: The type of YouTube content which the device can
	// output.
	//
	// Possible values:
	//   "ALL_YOUTUBE_CONTENT" - All content can be output.
	//   "NO_RESTRICTED_CONTENT" - No restricted content can be output.
	YoutubeContent string `json:"youtubeContent,omitempty"`

	// YoutubeTvContent: The type of YouTube TV content which the device can
	// output.
	//
	// Possible values:
	//   "ALL_YOUTUBE_TV_CONTENT" - All YouTube TV content can be output.
	//   "NO_RESTRICTED_YOUTUBE_TV_CONTENT" - No restricted YouTube TV
	// content can be output.
	YoutubeTvContent string `json:"youtubeTvContent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GooglePhotoContent")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GooglePhotoContent") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiOutputRestrictions) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiOutputRestrictions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiProactiveOutput: Next ID: 7
type AssistantApiProactiveOutput struct {
	// AllowAllPersonalData: Allows displaying all personal data on
	// proactive surfaces with no face match capability.
	AllowAllPersonalData bool `json:"allowAllPersonalData,omitempty"`

	// AndroidTvAssistantSettingsSource: For ANDROID_TV devices, the
	// location that this setting was last changed from. Note: this
	// structure allows to extend to more per-vertical bits in the future.
	//
	// Possible values:
	//   "NOT_SET" - LINT.IfChange
	//   "FIRST_SCREEN_DEVICE_OOBE" - Created during ATV Device
	// OOBE(setupwraith)
	//   "FIRST_SCREEN_KATNISS_OOBE" - Created within Katniss(Assistant
	// client on TV)
	//   "FIRST_SCREEN_DELEGATION_OOBE" - Created within Katniss delegation
	// path
	//   "FIRST_SCREEN_FIXER_JOB" - Created by fix settings job in katniss.
	//   "FIRST_SCREEN_FCM_JOB" - Created by FCM jobs in katnisss.
	//   "FIRST_SCREEN_HOME_GRAPH_JOB" - Created by home graph jobs in
	// katniss.
	//   "FIRST_SCREEN_PERSONAL_BIT" - Created by enable personal bit button
	// in Settings UI
	//   "FIRST_SCREEN_VOICE_INPUT_BIT" - Created by enable voice input bit
	// button in Settings UI
	//   "FIRST_SCREEN_OTHER" - Created by other parts in katniss
	//   "SECOND_SCREEN_AGSA" - Created by AGSA
	//   "SECOND_SCREEN_GHA_IOS" - Created by Google Home App IOS
	//   "SECOND_SCREEN_GHA_ANDROID" - Created by Google Home App Android
	// LINT.ThenChange(//depot/google3/logs/proto/assistant/capabilities_log.
	// proto)
	AndroidTvAssistantSettingsSource string `json:"androidTvAssistantSettingsSource,omitempty"`

	// HealthAndFitnessProactive: Allows displaying Health and Fitness
	// content on proactive surfaces. This is a sub bit of the device-wide
	// PR bit - the device-wide PR bit must be enabled AND this vertical sub
	// bit must be enabled for H&F content to be shown. This bit will be
	// available on all surfaces that have the proactive-bit enabled. If the
	// proactive-bit is not enabled, then we do not show health and fitness
	// content at all (or even allow access to this setting).
	//
	// Possible values:
	//   "NO_HEALTH_AND_FITNESS_PROACTIVE_OUTPUT" - No health and fitness
	// proactive content can be output
	//   "ALL_HEALTH_AND_FITNESS_PROACTIVE_OUTPUT" - All health and fitness
	// proactive content can be output
	HealthAndFitnessProactive string `json:"healthAndFitnessProactive,omitempty"`

	// PhotosProactive: Allows displaying photos content on Dragonglass
	// proactive surfaces. This is a sub bit of the device-wide PR bit - the
	// device-wide PR bit must be enabled AND this vertical sub bit must be
	// enabled for photos content to be shown on Dragonglass surfaces. This
	// bit will be available on all Dragonglass surfaces that have the
	// proactive-bit enabled. If the proactive-bit is not enabled or it's
	// not a Dragonglass surface, then we do not show proactive photos
	// content at all, nor allow access to this setting. See
	// go/opa-photos-sg-settings for more details.
	//
	// Possible values:
	//   "UNKNOWN_PHOTOS_PROACTIVE_OUTPUT"
	//   "NO_PHOTOS_PROACTIVE_OUTPUT" - No photos proactive content can be
	// output. This indicates that user has explicitly disabled photos
	// proactive settings.
	//   "ALL_PHOTOS_PROACTIVE_OUTPUT" - All photos proactive content can be
	// output. This indicates that user has explicitly enabled photos
	// proactive settings.
	PhotosProactive string `json:"photosProactive,omitempty"`

	// UserMatchProactive: Settings for displaying personal data on
	// proactive surfaces with face match capability.
	//
	// Possible values:
	//   "UNKNOWN_USER_MATCH_PROACTIVE"
	//   "NEVER_SHOW" - Never show proactive content.
	//   "ONLY_SHOW_ON_USER_MATCH" - Only show proactive content on Face
	// Match.
	//   "ALWAYS_SHOW" - Always show proactive content.
	UserMatchProactive string `json:"userMatchProactive,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AllowAllPersonalData") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllowAllPersonalData") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiProactiveOutput) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiProactiveOutput
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiProtobuf: Also known as "Extensions Without Extensions"
// or "The Poor Man's Any", this simple proto is used to transmit
// arbitrary protocol buffers over the wire. Unlike extensions: - It
// does not require the proto type to be compiled into the binary.
// (Useful so that the proto declaration can be inside the conversation
// package) - It is compatible with all versions of proto, including
// proto3 and the wack-tastic version used on ChromecastOS. Server
// libraries for dealing with it live in
// google3/assistant/protocol/protobuf_lib.h.
type AssistantApiProtobuf struct {
	// ProtobufData: The serialized protocol buffer.
	ProtobufData string `json:"protobufData,omitempty"`

	// ProtobufType: The type of the protocol buffer to use. This must be a
	// resolvable name (Namespace.ProtoName) and refer to a proto which is
	// either compiled in to both client and server (e.g. a base proto type)
	// or to one which is part of the conversation package.
	ProtobufType string `json:"protobufType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ProtobufData") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ProtobufData") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiProtobuf) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiProtobuf
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiRecurrence: Date-based recurrences specify repeating
// events. Conceptually, a recurrence is a (possibly unbounded) sequence
// of dates on which an event falls, described by a list of constraints.
// A date is in a recurrence if and only if it satisfies all of the
// constraints. Note that devices may support some constraints, but not
// all.
type AssistantApiRecurrence struct {
	// Begin: The first day of the recurrence. If begin is not set, then the
	// reminder will start infinitely in the past.
	Begin *AssistantApiDate `json:"begin,omitempty"`

	// BlacklistedRanges: A list of blacklisted dates to skip the alarm on.
	BlacklistedRanges []*AssistantApiDateTimeRange `json:"blacklistedRanges,omitempty"`

	// DayOfMonth: Specifies the date in a month. For example, if
	// day_of_month is 15, then it represent the 15th day of the specified
	// month.
	DayOfMonth []int64 `json:"dayOfMonth,omitempty"`

	// DayOfWeek: Specifies a weekly or daily recurrence. Constraint: The
	// date falls on one of these days of the week, in 0...6
	// (Sunday...Saturday).
	DayOfWeek []int64 `json:"dayOfWeek,omitempty"`

	// End: The last day of the recurrence.
	End *AssistantApiDate `json:"end,omitempty"`

	// Every: Multiplier on the frequency of the recurrence. Use this to
	// specify patterns that recur every X days, months, years, etc.
	// Example: [remind me to call mom every 2nd week]. Default is 1 (every
	// day, every month, every year).
	Every int64 `json:"every,omitempty"`

	// MonthOfYear: Specifies the month in a year. Constrain: the month
	// falls on one of these months, in 1, 2, ... 12 (January...December).
	MonthOfYear []int64 `json:"monthOfYear,omitempty"`

	// NumOccurrences: The number of occurrences after which the recurrence
	// should end.
	NumOccurrences int64 `json:"numOccurrences,omitempty"`

	// WeekOfMonth: Specifies the index of week in a month. For example, the
	// second Tuesday every month, in this case, week_of_month should be 2.
	WeekOfMonth []int64 `json:"weekOfMonth,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Begin") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Begin") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiRecurrence) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiRecurrence
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiScreenCapabilities: These capabilities represent the
// tactile features associated with the device. This includes, for
// example, whether the device has a screen, how big the screen is, and
// privacy of the screen. Next ID: 11
type AssistantApiScreenCapabilities struct {
	// FontScaleFactor: The scale factor used to convert Scalable Pixel (SP)
	// units to Density-independent Pixel (DP) units (DP = SP * scale
	// factor). Fonts are measured in units of SP, and on some platforms
	// such as Android the SP to DP scale factor can be affected by the font
	// size a user selects in accessibility settings.
	FontScaleFactor float64 `json:"fontScaleFactor,omitempty"`

	// InputType: The types of input that this screen supports. Note that
	// this can be empty in which case the screen's input type is unknown.
	//
	// Possible values:
	//   "TOUCHSCREEN" - The device has a screen that support touch input.
	InputType []string `json:"inputType,omitempty"`

	// Mask: Mask defined for this device, if any.
	Mask *AssistantApiScreenCapabilitiesMask `json:"mask,omitempty"`

	// ProtoLayoutTargetedSchema: The targeted schema version for
	// ProtoLayout requests.
	ProtoLayoutTargetedSchema *AssistantApiScreenCapabilitiesProtoLayoutVersion `json:"protoLayoutTargetedSchema,omitempty"`

	// Resolution: If this field is absent, the resolution of the screen is
	// unknown.
	Resolution *AssistantApiScreenCapabilitiesResolution `json:"resolution,omitempty"`

	// ScreenOff: If screen is turned off.
	ScreenOff bool `json:"screenOff,omitempty"`

	// ScreenStateDetection: The ability of the client to correctly report
	// screen state.
	//
	// Possible values:
	//   "UNKNOWN_SCREEN_STATE_DETECTION"
	//   "UNRELIABLE_SCREEN_STATE_DETECTION" - The client reports screen
	// state but may be unreliable based on different remotes/inputs used to
	// turn the screen off. Example: Android TVs with soundbars.
	//   "RELIABLE_SCREEN_STATE_DETECTION"
	ScreenStateDetection string `json:"screenStateDetection,omitempty"`

	// SupportedRenderingFormat: The primary supported rendering format for
	// display on the device's screen. This may be used to determine what
	// format of card to be returned when rendering cards.
	//
	// Possible values:
	//   "UNKNOWN_RENDERING_FORMAT"
	//   "CONCISE_TEXT" - Concise Text go/concise-text-responses
	//   "PROTO_LAYOUT" - Proto Layout, the layout for Proto Tiles
	// go/prototiles
	//   "ELEMENTS" - Elements, the layout for xUIKit go/xuikit
	SupportedRenderingFormat string `json:"supportedRenderingFormat,omitempty"`

	// SupportedScreenStates: The screen states that the client supports.
	// The current screen state is specified in DeviceProperties.screen.
	//
	// Possible values:
	//   "UNKNOWN_SCREEN_STATE"
	//   "ON"
	//   "OFF"
	SupportedScreenStates []string `json:"supportedScreenStates,omitempty"`

	// VisionHelpEnabled: Whether the device enabled vision help features in
	// accessibility settings. The settings is config in Assistant App and
	// on-device settings, and stored in footprints. When enabled, font,
	// color and TTS will be adjusted.
	VisionHelpEnabled bool `json:"visionHelpEnabled,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FontScaleFactor") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FontScaleFactor") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiScreenCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiScreenCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *AssistantApiScreenCapabilities) UnmarshalJSON(data []byte) error {
	type NoMethod AssistantApiScreenCapabilities
	var s1 struct {
		FontScaleFactor gensupport.JSONFloat64 `json:"fontScaleFactor"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.FontScaleFactor = float64(s1.FontScaleFactor)
	return nil
}

// AssistantApiScreenCapabilitiesMask: A mask applied to the screen's
// pixel space to determine regions not visible on the physical device.
type AssistantApiScreenCapabilitiesMask struct {
	// Possible values:
	//   "UNKNOWN_MASK" - Default value.
	//   "NO_MASK" - Used for devices with no mask. In this case, every
	// point in the region defined by width_px and height_px corresponds to
	// a physical, visible pixel. This is distinct from rectangular screens
	// that DO have regions with no pixels, e.g. an inset or cutout that
	// occludes one or more sides of the screen.
	//   "ROUND_MASK" - Used for devices with oval or circular screens. The
	// vertical and horizontal resolution of the screen determines the
	// vertical and horizontal diameters of the oval. Pixels outside this
	// oval region are non-existent or physically occluded.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Type") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Type") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiScreenCapabilitiesMask) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiScreenCapabilitiesMask
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiScreenCapabilitiesProtoLayoutVersion: Version info for
// ProtoLayout requests.
type AssistantApiScreenCapabilitiesProtoLayoutVersion struct {
	Major int64 `json:"major,omitempty"`

	Minor int64 `json:"minor,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Major") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Major") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiScreenCapabilitiesProtoLayoutVersion) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiScreenCapabilitiesProtoLayoutVersion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiScreenCapabilitiesResolution: A Resolution proto
// indicates the size of the application window. All fields are
// required.
type AssistantApiScreenCapabilitiesResolution struct {
	// Dpi: Dots (pixels) per inch of the screen.
	Dpi int64 `json:"dpi,omitempty"`

	HeightPx int64 `json:"heightPx,omitempty"`

	// MSize: m_size is the smallest square box size to display a capital
	// letter M so that the user can still easily understand it.
	MSize int64 `json:"mSize,omitempty"`

	// NengSize: neng_size is the smallest square box size to display a
	// letter 螚 (Neng, U+879A) so that the user can easily understand it.
	// (Neng is a visually dense Chinese letter, and so may require a larger
	// box than an M.)
	NengSize int64 `json:"nengSize,omitempty"`

	// WidthPx: The dimensions of the application window, in pixels.
	WidthPx int64 `json:"widthPx,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dpi") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dpi") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiScreenCapabilitiesResolution) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiScreenCapabilitiesResolution
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSelinaCapabilites: The Soli capabilities on Elaine,
// including gestures and sleep sensing. go/dingo-dc-software Next ID: 4
type AssistantApiSelinaCapabilites struct {
	// GestureCapabilities: A list of gestures that selina supports
	GestureCapabilities *AssistantApiGestureCapabilities `json:"gestureCapabilities,omitempty"`

	// SelinaSupported: Whether the client supports selina.
	SelinaSupported bool `json:"selinaSupported,omitempty"`

	// SleepSensingSupported: Whether the client can monitor sleep. This
	// allows us to show sleep CUJ related information: go/TwilightDesign
	SleepSensingSupported bool `json:"sleepSensingSupported,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GestureCapabilities")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GestureCapabilities") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSelinaCapabilites) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSelinaCapabilites
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiSettingsAmbientSettings struct {
	// AnyUserHasSetPersonalPhotos: Whether any user sets personal photos on
	// this device. See go/ambient-setting-in-assistant-design.
	AnyUserHasSetPersonalPhotos bool `json:"anyUserHasSetPersonalPhotos,omitempty"`

	// RecentHighlightsEnabled: Whether or not the user's current selection
	// for their ambient photo frame includes the auto-generated "Recent
	// Highlights" album. This is used to determine which users to display
	// the go/opa-photos-memories-tile. See go/opa-photo-memories-imax-optin
	// for more discussion on why this bit was created.
	RecentHighlightsEnabled bool `json:"recentHighlightsEnabled,omitempty"`

	// ShowPersonalPhotoData: Whether to enable the personal photo data in
	// the ambient settings: https://screenshot.googleplex.com/Wd4OFkQfOyF
	// See go/opa-photos-ambient-location-date-dd#heading=h.5x4iaouuiett for
	// explanation.
	ShowPersonalPhotoData bool `json:"showPersonalPhotoData,omitempty"`

	// ShowPersonalPhotos: Whether current user sets personal photos on this
	// device. See go/ambient-setting-in-assistant-design.
	ShowPersonalPhotos bool `json:"showPersonalPhotos,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AnyUserHasSetPersonalPhotos") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AnyUserHasSetPersonalPhotos") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsAmbientSettings) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsAmbientSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsAppCapabilities: These capabilities are
// associated with Assistant Settings on devices.
type AssistantApiSettingsAppCapabilities struct {
	// CarSettingsCapabilities: Capabilities that are associated with
	// Assistant Settings on auto surfaces.
	CarSettingsCapabilities *AssistantApiCarSettingsCapabilities `json:"carSettingsCapabilities,omitempty"`

	// ReissueQueryAfterMusicSetup: Whether the client supports reissuing
	// query after setting up in Music Settings.
	ReissueQueryAfterMusicSetup bool `json:"reissueQueryAfterMusicSetup,omitempty"`

	// SupportsPaymentsSettingsUpdate: Whether the client supports updating
	// payments setting.
	SupportsPaymentsSettingsUpdate bool `json:"supportsPaymentsSettingsUpdate,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "CarSettingsCapabilities") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CarSettingsCapabilities")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsAppCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsAppCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsAutoFramingSettings: Settings pertaining to auto
// framing. See go/auto-framing-presentation.
type AssistantApiSettingsAutoFramingSettings struct {
	IsAutoFramingEnabled bool `json:"isAutoFramingEnabled,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "IsAutoFramingEnabled") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IsAutoFramingEnabled") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsAutoFramingSettings) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsAutoFramingSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsCarrierCallDeviceSettings: Carrier related call
// settings on the device.
type AssistantApiSettingsCarrierCallDeviceSettings struct {
	// AllowIncomingCalls: Whether this device is allowed to receive
	// incoming PSTN calls.
	AllowIncomingCalls bool `json:"allowIncomingCalls,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AllowIncomingCalls")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllowIncomingCalls") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsCarrierCallDeviceSettings) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsCarrierCallDeviceSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsCommunicationsFilter: Specification of which
// communication features can be used.
type AssistantApiSettingsCommunicationsFilter struct {
	// Possible values:
	//   "UNKNOWN_STATE"
	//   "ALLOW_ALL" - Allow all communication features.
	//   "BLOCK_CALLS_AND_MESSAGES" - Allow all communication features, with
	// the exception of calls and messages.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "State") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsCommunicationsFilter) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsCommunicationsFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsDeviceDowntimeSettings: Specification of times
// when most features on a device are disabled for certain users. During
// these periods, the device will respond to most interactions with
// something like "sorry, I'm sleeping right now". Design:
// go/home-ft-settings-storage PRD: go/home-family-tools-prd
type AssistantApiSettingsDeviceDowntimeSettings struct {
	Schedules []*AssistantApiSettingsLabeledDowntimeSchedule `json:"schedules,omitempty"`

	// Targets: The set of users of this device that will have these
	// downtime settings applied. Must have at least one element.
	//
	// Possible values:
	//   "UNKNOWN_DEVICE_SUPERVISION_TARGET"
	//   "EVERYONE" - All people that use the device.
	//   "KID_ACCOUNTS" - Users with a Unicorn account that are
	// voice-matched to the device.
	//   "GUESTS" - Users interacting with the device without being voice
	// matched. We cannot identify these users and don't know their ages.
	Targets []string `json:"targets,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Schedules") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Schedules") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsDeviceDowntimeSettings) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsDeviceDowntimeSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsDeviceFeatureFilters: Defines a set of
// restrictions on particular device features for a certain set of
// users. Design: go/home-ft-settings-storage PRD:
// go/home-family-tools-prd
type AssistantApiSettingsDeviceFeatureFilters struct {
	// Enabled: Enables/disables all the filters at the same time. For new
	// devices or non-Cast devices this is always false.
	Enabled bool `json:"enabled,omitempty"`

	// FeatureFilters: The filters (feature restrictions) to apply when
	// `enabled` is true.
	FeatureFilters *AssistantApiSettingsFeatureFilters `json:"featureFilters,omitempty"`

	// Targets: The set of users of this device that will have these
	// settings applied. Must have at least one element.
	//
	// Possible values:
	//   "UNKNOWN_DEVICE_SUPERVISION_TARGET"
	//   "EVERYONE" - All people that use the device.
	//   "KID_ACCOUNTS" - Users with a Unicorn account that are
	// voice-matched to the device.
	//   "GUESTS" - Users interacting with the device without being voice
	// matched. We cannot identify these users and don't know their ages.
	Targets []string `json:"targets,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Enabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsDeviceFeatureFilters) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsDeviceFeatureFilters
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiSettingsDeviceLogsOptIn struct {
	// OptInEnabled: Indicates whether the crash logs can be uploaded and
	// the device logs can be enabled
	OptInEnabled bool `json:"optInEnabled,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OptInEnabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OptInEnabled") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsDeviceLogsOptIn) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsDeviceLogsOptIn
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsDeviceSettings: Next ID: 73
type AssistantApiSettingsDeviceSettings struct {
	// AckStatus:
	// LINT.ThenChange(//depot/google3/assistant/ui/assistant_device_settings
	// _ui.proto)
	//
	// Possible values:
	//   "ACK_COMPLETED"
	//   "ACK_PENDING"
	AckStatus string `json:"ackStatus,omitempty"`

	// Address: A human-readable address string for the location; generally
	// a one-line address such as "34 Masonic Ave, San Francisco CA 94117,
	// United States". Set this field to empty string for deletion, in which
	// case the rest of the location related fields below will be cleared as
	// well.
	Address string `json:"address,omitempty"`

	// AliasName: The alias names of the device, e.g. my living room tv, tv,
	// living room and etc., which user will usually use to refer to the
	// device in addition to human_friendly_name. It can help speech biasing
	// and query understanding. This field is set by the user and already
	// localized.
	AliasName []string `json:"aliasName,omitempty"`

	// AllowIncomingCalls: Whether this device is allowed to receive
	// incoming calls.
	AllowIncomingCalls bool `json:"allowIncomingCalls,omitempty"`

	// AmbientSettings: Ambient settings contains the configuration of Photo
	// Frame on DG device. This field relies on IMAX service to do the
	// update, sync happenes after user updates IMAX device settings or a
	// device registers in CloudCastDevice. So it's more like a cached
	// version instead of definitive source-of-truth. More details at
	// go/ambient-setting-in-assistant-design.
	AmbientSettings *AssistantApiSettingsAmbientSettings `json:"ambientSettings,omitempty"`

	// AncillaryDeviceId: The additional device ids. Currently used only for
	// ATV. go/project-yellowstone Note: This field is for internal (Within
	// settings) use only.
	AncillaryDeviceId *AssistantApiSettingsInternalAncillaryDeviceId `json:"ancillaryDeviceId,omitempty"`

	// AutoFramingSettings: Auto framing settings associated with a device.
	// See go/auto-framing-presentation.
	AutoFramingSettings *AssistantApiSettingsAutoFramingSettings `json:"autoFramingSettings,omitempty"`

	// BlueSteelEnabled: Indicates whether the user has enabled Blue Steel.
	// See go/blue-steel for more info on this project.
	BlueSteelEnabled bool `json:"blueSteelEnabled,omitempty"`

	// Capabilities: Describes roughly what a device is capable of doing and
	// metadata around those capabilities. Note: this includes device
	// limitations as well as user configurable settings.
	Capabilities *AssistantApiDeviceCapabilities `json:"capabilities,omitempty"`

	// City: city and postal_code are sent to third party AoG Apps as
	// location when permission is granted for precise or coarse location.
	// https://developers.google.com/actions/reference/rest/Shared.Types/Permission
	// city and postal_code have the same description as in Proto Postal
	// Address:
	// https://cs.corp.google.com/piper///depot/google3/location/country/postaladdress.proto
	// city corresponds to locality_name, postal_code corresponds to
	// postal_code_number. These two fields are set in
	// assistant_settings_service by AddressConverter.
	// https://cs.corp.google.com/piper///depot/google3/location/addressformatter/public/addressconverter.h
	// See go/aog-i18n-address-parse for more information
	City string `json:"city,omitempty"`

	// ColocationStatus: Status of colocation. go/co-location-work-v2 Note:
	// this is a cache at the Assistant level. The source of truth is inside
	// CastAuthenticationServer, which is only used for Home devices.
	//
	// Possible values:
	//   "COLOCATION_UNKNOWN"
	//   "COLOCATION_ESTABLISHED"
	//   "COLOCATION_NOT_ESTABLISHED"
	//   "COLOCATION_NOT_SUPPORTED"
	ColocationStatus string `json:"colocationStatus,omitempty"`

	// CreationTimestampMs: The timestamp that the device is linked with the
	// user in milliseconds.
	CreationTimestampMs int64 `json:"creationTimestampMs,omitempty,string"`

	// CrossSurfaceAvailability: Availability of this device for Assistant
	// Cross-surface handoffs. (go/assistant-cross-surface)
	CrossSurfaceAvailability *AssistantApiSettingsDeviceSettingsCrossSurfaceAvailability `json:"crossSurfaceAvailability,omitempty"`

	// DefaultAudioDeviceId: The identification of the default device which
	// user want to output audio. See go/default-media-output-design for
	// more info.
	DefaultAudioDeviceId *AssistantApiCoreTypesDeviceId `json:"defaultAudioDeviceId,omitempty"`

	// DefaultVideoDeviceId: The identification of the default device which
	// user want to output video. Note that, we don't fallback to this for
	// audio playback when default_audio_device_id is not set. See
	// go/default-media-output-design for more info.
	DefaultVideoDeviceId *AssistantApiCoreTypesDeviceId `json:"defaultVideoDeviceId,omitempty"`

	// DeviceBrand: The brand of the device, populated from DeviceOemParams.
	// Examples: "google", "samsung".
	DeviceBrand string `json:"deviceBrand,omitempty"`

	// DeviceId: The identification of the device.
	DeviceId *AssistantApiCoreTypesDeviceId `json:"deviceId,omitempty"`

	// DeviceModelId: The model ID of the device. This should be globally
	// unique across manufactures/OEMs. Examples: "nest_cam_iq_2017",
	// "comcast_voice_box_2017".
	DeviceModelId string `json:"deviceModelId,omitempty"`

	// DeviceModelRevision: The Device Platform Service lookup revision.
	// (go/device-model-revision) For 1p devices, and most 3p devices with
	// no custom feature, this should be always 0, which means no lookup
	// needed. For 3p devices with custom assistant feature, this is
	// provided directly by OEM as incremental (e.g. 1, 2, 3, ...)
	DeviceModelRevision int64 `json:"deviceModelRevision,omitempty"`

	// Dusi: Only valid for ATV. Stores the android DUSI for the
	// corresponding user. More details: go/auto-logout-on-unlink.
	Dusi string `json:"dusi,omitempty"`

	// FaceEnrollmentErrors: List of errors that happened during the face
	// enrollment process if it failed. See go/face-match-enrollment-error
	// for more info.
	//
	// Possible values:
	//   "UNKNOWN_FACE_ENROLLMENT_ERROR"
	//   "MISSING_FRONTAL_POSE" - The gallery images don't have the required
	// frontal pose properties.
	//   "FACE_NOT_DETECTED" - Face was NOT detected in an image.
	//   "MULTIPLE_FACE_DETECTED" - Multiple faces detected in an image.
	//   "FACE_WITHOUT_SIGNATURE" - Cannot create signature for a detected
	// face.
	//   "FACE_DETECTION_LOW_CONFIDENCE" - Face detection confidence score
	// is too low.
	//   "FACE_LANDMARK_LOW_CONFIDENCE" - Face detection landmark confidence
	// score is too low.
	//   "FACE_WITHOUT_CONFIDENCE" - Face detection contains no confidence
	// score, which is invalid.
	//   "FACE_TOO_SMALL" - Face detection was too small for enrollment.
	//   "FAILED_TO_READ_IMAGE" - Unable to read the image file from the
	// gallery.
	//   "FAILED_TO_DECODE_IMAGE" - Unable to decode the jpeg image.
	//   "FACE_DETECTION_ERROR" - Unable to run face detector on the decoded
	// image.
	//   "FACE_WITHOUT_EMBEDDING_CONFIDENCE" - Face detection contains no
	// confidence score for embedding.
	FaceEnrollmentErrors []string `json:"faceEnrollmentErrors,omitempty"`

	// FaceEnrollmentStatus: Indicates whether the user's face has been
	// successfully enrolled on this device. See go/face-match-server-design
	// for more info.
	//
	// Possible values:
	//   "UNKNOWN_STATUS"
	//   "SUCCESS"
	//   "FAILURE"
	//   "PENDING"
	FaceEnrollmentStatus string `json:"faceEnrollmentStatus,omitempty"`

	// FaceMatchEnabled: Indicates whether the user has enabled Face Match
	// for this device. See go/face-match-server-design for more info on
	// this project.
	FaceMatchEnabled bool `json:"faceMatchEnabled,omitempty"`

	// GcmSettings: Stores GCM info associated with a device. See
	// go/quartz-design-doc for more info.
	GcmSettings *AssistantApiSettingsGcmSettings `json:"gcmSettings,omitempty"`

	// HomeGraphData: Holds the data that should be written to HomeGraph.
	// Note: this field is not persisted in Assistant Settings storage. It
	// is simply used for transporting data when client calls
	// UpdateSettings.
	HomeGraphData *AssistantApiSettingsHomeGraphData `json:"homeGraphData,omitempty"`

	// HomeGraphId: The home graph ID that can be used to lookup the
	// corresponding entry in HomeGraph. go/home-graph. Note: when this
	// field is empty, it doesn't necessarily mean that the device is not in
	// home graph. It just means that Assistant doesn't know about the
	// mapping.
	HomeGraphId string `json:"homeGraphId,omitempty"`

	// HospitalityModeStatus: Indicates whether the device is currently in
	// Hospitality mode. go/hospitality-mode-design. This is moved to a per
	// user setting in assistant settings. ref. go/hospitality-settings-v2
	HospitalityModeStatus *AssistantApiSettingsHospitalityMode `json:"hospitalityModeStatus,omitempty"`

	// HotwordSensitivity: The level of hotword sensitivity.
	// go/hotword-sensitivity-prd
	//
	// Possible values:
	//   "UNKNOWN_HOTWORD_SENSITIVITY"
	//   "HOTWORD_SENSITIVITY_LOW"
	//   "HOTWORD_SENSITIVITY_NORMAL"
	//   "HOTWORD_SENSITIVITY_HIGH"
	//   "HOTWORD_SENSITIVITY_LOW_2"
	//   "HOTWORD_SENSITIVITY_HIGH_2"
	HotwordSensitivity string `json:"hotwordSensitivity,omitempty"`

	// HotwordThresholdAdjustmentFactor: HotwordThresholdAdjustmentFactor
	// contains threshold_adjustment_factor, and it's validity. TAF is a
	// measure of adjustment applied to the hotword threshold as a result of
	// go/autotune. Currently, this is updated from query_settings_frame,
	// but if we move to updating it from the client, this could also
	// contain TAFs as a result of Hotword Sensitivity, in addition to
	// Autotune.
	HotwordThresholdAdjustmentFactor *AssistantApiSettingsHotwordThresholdAdjustmentFactor `json:"hotwordThresholdAdjustmentFactor,omitempty"`

	// HumanFriendlyName: The human-friendly name of the cast device, e.g.,
	// my living room tv. This field is set by the user and already
	// localized.
	HumanFriendlyName string `json:"humanFriendlyName,omitempty"`

	// InternalVersion: Internal version of the DeviceSettings for
	// measurement of the DeviceSettings mutation race conditions. See
	// go/consistent-assistant-settings-update.
	InternalVersion *AssistantApiSettingsInternalVersion `json:"internalVersion,omitempty"`

	// IsCloudSyncDevice: Indicates whether the device is also managed
	// through HA cloud sync. go/ha-dev-guide
	IsCloudSyncDevice bool `json:"isCloudSyncDevice,omitempty"`

	// IsDeviceActivationCacheEnabled: When true, the user has explicitly
	// allowed audio and visual data collection on this device
	IsDeviceActivationCacheEnabled bool `json:"isDeviceActivationCacheEnabled,omitempty"`

	// KidsMode: Specifies if kids-mode is enabled for the device. See
	// go/aff-parentalsupervision-dd.
	KidsMode *AssistantApiSettingsKidsMode `json:"kidsMode,omitempty"`

	// LastCastRegistrationTimestamp: Device's latest registration timestamp
	// provided by Cast side. This field is not necessarily up to date. The
	// update frequency is defined in
	// last_registration_update_frequency_in_days field of AssistantConfig
	// in
	// java/com/google/chrome/dongle/common/proto/home_assistant_config.proto
	// . go/cast-last-registration-time
	LastCastRegistrationTimestamp string `json:"lastCastRegistrationTimestamp,omitempty"`

	// LastUsedCoarseTimestamp: Coarsened hourly timestamp of when the
	// device was last used.
	LastUsedCoarseTimestamp string `json:"lastUsedCoarseTimestamp,omitempty"`

	// LinkedDeviceId: Stores pairing between different devices. See
	// go/quartz-design-doc for more info.
	LinkedDeviceId []*AssistantApiCoreTypesDeviceId `json:"linkedDeviceId,omitempty"`

	// LinkedUsers: Please do NOT use this field without prior approval from
	// PWG. Users who have signed in onto this device,
	// go/linked-users-in-pkg.
	LinkedUsers []*AssistantApiSettingsLinkedUser `json:"linkedUsers,omitempty"`

	// Locale: The locale for the device: language + region, i.e., en-US,
	// ja-JP.
	Locale string `json:"locale,omitempty"`

	// LocationCoordinates: Coordinate information of the device location.
	LocationCoordinates *AssistantApiCoreTypesLocationCoordinates `json:"locationCoordinates,omitempty"`

	// LocationFeature: The feature proto of the location of the device.
	// Note: client does not need to populate this. It will be
	// auto-populated based on "address" field on server side. Currently,
	// only "bound" and "type" are persisted, since the entire FeatureProto
	// is too big.
	LocationFeature *GeostoreFeatureProto `json:"locationFeature,omitempty"`

	// MarketplaceDisclosure: See go/marketplace-disclosure for more info.
	MarketplaceDisclosure *AssistantApiSettingsMarketplaceDisclosure `json:"marketplaceDisclosure,omitempty"`

	MasqueradeMode *AssistantApiSettingsMasqueradeMode `json:"masqueradeMode,omitempty"`

	// NotificationProfile: Information about how to send the user a
	// notification. This won't be populated for fb-conv users (allo group
	// chat users).
	NotificationProfile *AssistantApiSettingsNotificationProfile `json:"notificationProfile,omitempty"`

	// OauthClientId: OAuth client id for the device. This field is
	// available for Assistant SDK devices. It is written when the device is
	// registered to the user
	// (AssistantSettingsUiService.LinkAssistantDeviceUi). When user revokes
	// grant on the Assistant device, Assistant Devices Platform Service
	// will receive Pubsub notification with OAuth client id for the revoked
	// device, and we will compare that with this stored id to identity
	// device to remove.
	OauthClientId string `json:"oauthClientId,omitempty"`

	// OnDeviceAppSettings: Device specific app related settings.
	OnDeviceAppSettings *AssistantApiSettingsOnDeviceAppSettings `json:"onDeviceAppSettings,omitempty"`

	// OptInStatus: Specifies if device logs and crashes can be captured
	// during SendFeedback
	OptInStatus *AssistantApiSettingsDeviceLogsOptIn `json:"optInStatus,omitempty"`

	// PaymentsEnabled: DEPRECATED: Use
	// DeviceCapabilities.OutputRestrictions.personal_data instead. Whether
	// the user has enabled payments for this device.
	PaymentsEnabled bool `json:"paymentsEnabled,omitempty"`

	// PersonalizationMetadata: Metadata about how personalization settings
	// were configured.
	PersonalizationMetadata *AssistantApiSettingsPersonalizationMetadata `json:"personalizationMetadata,omitempty"`

	// PoliteMode: Specify whether polite mode is enabled for this device.
	// See go/pretty-please-dd.
	PoliteMode *AssistantApiSettingsPoliteMode `json:"politeMode,omitempty"`

	PostalCode string `json:"postalCode,omitempty"`

	// ReauthTrustedDeviceSettings: Trusted device preferences Assistant
	// reauth. go/assistant-reauth-verify-skip.
	ReauthTrustedDeviceSettings *AssistantApiSettingsReauthTrustedDeviceSettings `json:"reauthTrustedDeviceSettings,omitempty"`

	// ShortenedAddress: A human-readable shortened address. This is usually
	// the street address. Note: client does not need to populate this. It
	// will be auto-populated based on "address" field on server side.
	// Developers can use this field to avoid reading out the full address
	// everytime.
	ShortenedAddress string `json:"shortenedAddress,omitempty"`

	// SpeakerIdEnabled: Indicates whether the user has enabled speaker-id
	// for this device. See go/google-assistant-multi-user for more info on
	// this project.
	SpeakerIdEnabled bool `json:"speakerIdEnabled,omitempty"`

	// SpeechOutputSettings: Settings related to TTS output.
	SpeechOutputSettings *AssistantApiSettingsSpeechOutputSettings `json:"speechOutputSettings,omitempty"`

	// SpeechSettings: Speech/hotword detection related settings.
	SpeechSettings *AssistantApiSettingsSpeechSettings `json:"speechSettings,omitempty"`

	// SupervisionSettings: Restrictions on how and when certain users can
	// use a device. See go/home-ft-prd.
	SupervisionSettings *AssistantApiSettingsDeviceSupervisionSettings `json:"supervisionSettings,omitempty"`

	// SurfaceType: The type of assistant surface. Only use this field when
	// device type is ASSISTANT.
	SurfaceType *AssistantApiCoreTypesSurfaceType `json:"surfaceType,omitempty"`

	// TetheredInfo: Presence indicates a tethered wearable.
	// go/wearable-device-ids.
	TetheredInfo *AssistantApiSettingsTetheredInfo `json:"tetheredInfo,omitempty"`

	// TimeZone: Device time zone. It's mainly used for a one-time
	// notification for new users when they just bought and activated their
	// devices. They may not have used Search or Assistant before, so their
	// timezone info may not available elsewhere when we want to send a
	// notification. This should be used as a fallback only when other
	// timezone sources such as
	// assistant_settings:user_attribute#inferred_user_timezone are not
	// available. Also, when both |time_zone| and |location| are set, the
	// |location| should be preferred to derive the most up to date
	// timezone. This info directly comes from the device through early
	// device setting recording mechanism. See more details at
	// go/early-device-setting-recording.
	TimeZone *AssistantApiTimeZone `json:"timeZone,omitempty"`

	// TruncatedLocalNetworkId: Local network ID of the device (truncated to
	// obfuscate devices and households globally). This is a temporary
	// signal to determine proximity of Assistant devices in a house (HGS
	// place).
	TruncatedLocalNetworkId string `json:"truncatedLocalNetworkId,omitempty"`

	// Type: The type of the device. Note: this should only be used for
	// grouping devices for UI presentation purpose. Use |capabilities| to
	// decide what the device can do.
	//
	// Possible values:
	//   "UNKNOWN_DEVICE_TYPE"
	//   "ASSISTANT"
	//   "HOME_AUTOMATION"
	//   "CAST"
	//   "CAST_GROUP"
	//   "QUARTZ" - Quartz in AGSA
	//   "QUARTZ_IOS" - Quartz in iOPA
	//   "CLOUD_AUTO" - Non-assistant Auto devices from Cloud.
	Type string `json:"type,omitempty"`

	// VerboseTtsForChromecastEnabled: Indicates whether to play verbose tts
	// for Elementary on chirp. See: go/opa-cast-a11y-impl-design fore more
	// info on this project. Note: this should probably be in
	// SpeechOutputSetting below.
	VerboseTtsForChromecastEnabled bool `json:"verboseTtsForChromecastEnabled,omitempty"`

	// VmLastUsedCoarseTimestamp: Coarsened hourly timestamp of when the
	// user was last verified by VoiceMatch on this device. This is used for
	// enforcing VoiceMatch model TTL. go/voicematch-pdd-ttl
	VmLastUsedCoarseTimestamp string `json:"vmLastUsedCoarseTimestamp,omitempty"`

	// VoiceEnrollmentStatus: Indicates whether the user's voice has been
	// successfully enrolled on this device.
	//
	// Possible values:
	//   "VOICE_ENROLLMENT_UNKNOWN_STATUS" - User has no utterances and no
	// speaker id model.
	//   "VOICE_ENROLLMENT_SUCCESS" - User has speaker id model.
	//   "VOICE_ENROLLMENT_FAILURE" - User has utterances but no speaker id
	// model (for ex. hotword was not detected in utterances).
	//   "VOICE_ENROLLMENT_PENDING" - Speaker id model generation is
	// in-progress.
	VoiceEnrollmentStatus string `json:"voiceEnrollmentStatus,omitempty"`

	// VoiceInputEnabled: A boolean indicates whether voice input
	// (mic-button, hotword, etc) is enabled.
	VoiceInputEnabled bool `json:"voiceInputEnabled,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AckStatus") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AckStatus") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsDeviceSettings) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsDeviceSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiSettingsDeviceSettingsCrossSurfaceAvailability struct {
	// LastKnownClientLocale: Last known locale of the client.
	LastKnownClientLocale string `json:"lastKnownClientLocale,omitempty"`

	// LastParamsWriteTimestamp: This is the timestamp when the
	// AssistantRequestParams (in ASSISTANT_SNAPSHOT corpus) were last
	// written for this device.
	LastParamsWriteTimestamp string `json:"lastParamsWriteTimestamp,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "LastKnownClientLocale") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LastKnownClientLocale") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsDeviceSettingsCrossSurfaceAvailability) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsDeviceSettingsCrossSurfaceAvailability
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiSettingsDeviceSupervisionSettings struct {
	// DowntimeSettings: Specification of times that a device shouldn't
	// respond to certain users. See go/home-ft-prd.
	DowntimeSettings *AssistantApiSettingsDeviceDowntimeSettings `json:"downtimeSettings,omitempty"`

	// FeatureFilters: Restrictions on features that certain users can
	// access on a device. See go/home-ft-prd.
	FeatureFilters *AssistantApiSettingsDeviceFeatureFilters `json:"featureFilters,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DowntimeSettings") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DowntimeSettings") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsDeviceSupervisionSettings) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsDeviceSupervisionSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsDowntimePeriod: Specifies a period of up to 24
// hours when downtime should be enabled, starting at certain time on a
// certain day of the week, and ending at a later time on either that
// day or the following day.
type AssistantApiSettingsDowntimePeriod struct {
	// Enabled: True if downtime should be enabled during this period.
	Enabled bool `json:"enabled,omitempty"`

	// EndTime: Time of day that this downtime period should end. Required.
	// If end_time > start_time, end_time is relative to start_day.
	// Otherwise, end_time is relative to the day after start_day. For
	// example, start_day: MONDAY, start_time: 9 p.m., end_time: 6 a.m.
	// means that the downtime period starts at 9 p.m. on Monday and ends at
	// 6 a.m. on Tuesday.
	EndTime *GoogleTypeTimeOfDay `json:"endTime,omitempty"`

	// StartDay: The day of the week when this downtime period starts.
	// Required.
	//
	// Possible values:
	//   "DAY_OF_WEEK_UNSPECIFIED" - The day of the week is unspecified.
	//   "MONDAY" - Monday
	//   "TUESDAY" - Tuesday
	//   "WEDNESDAY" - Wednesday
	//   "THURSDAY" - Thursday
	//   "FRIDAY" - Friday
	//   "SATURDAY" - Saturday
	//   "SUNDAY" - Sunday
	StartDay string `json:"startDay,omitempty"`

	// StartTime: Time of day that this downtime period should start.
	// Required.
	StartTime *GoogleTypeTimeOfDay `json:"startTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Enabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsDowntimePeriod) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsDowntimePeriod
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsDowntimeSchedule: Specification of when downtime
// is enabled on different days of the week. Contains up to 7
// DowntimePeriod messages, up to one per day of the week.
type AssistantApiSettingsDowntimeSchedule struct {
	// Enabled: True if this downtime schedule should be enabled.
	Enabled bool `json:"enabled,omitempty"`

	// Periods: Downtime entries for the days of the week, in no particular
	// order. There can be at most one period defined for each day of the
	// week. Days of the week with no explicit period defined are treated as
	// disabled, so the device is available all day (modulo an end time that
	// may spill over from the previous day).
	Periods []*AssistantApiSettingsDowntimePeriod `json:"periods,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Enabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsDowntimeSchedule) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsDowntimeSchedule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsDuoCallDeviceSettings: Duo related call settings
// on the device. Next ID: 5
type AssistantApiSettingsDuoCallDeviceSettings struct {
	// AllowKnockKnock: True if Duo Knock Kncok feature is enabled on the
	// device.
	AllowKnockKnock bool `json:"allowKnockKnock,omitempty"`

	// ShouldBeLinked: Boolean indicating if user has explicitly marked this
	// device to be linked or not. This bit is used in case where unexpected
	// errors occur and we have to check for account/device status and mark
	// the device linked after verification.
	ShouldBeLinked bool `json:"shouldBeLinked,omitempty"`

	// State: The call state of the device (i.e. whether a Duo call account
	// has been setup on the device).
	//
	// Possible values:
	//   "UNKNOWN_LINK_STATE"
	//   "NOT_LINKED" - The user chose not to link the app.
	//   "LINKED" - The user completed linking the app.
	//   "LINKED_WAITING" - The user chose to link the app, but the linking
	// has not completed yet.
	//   "LINK_ERROR" - There was some error in link state and link state
	// should be refreshed by querying tachyon backend. But this does not
	// guarantee that state will be linked after this request.
	State string `json:"state,omitempty"`

	// TalkbackEnabled: Client device settings: settings which are populated
	// by client to give to duocore. TalkBack is an accessibility service
	// that helps blind and vision-impaired users interact with their
	// devices. Indicates whether talkback is enabled for the device. Note:
	// this is per device settings currently filled by client for all users.
	TalkbackEnabled bool `json:"talkbackEnabled,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AllowKnockKnock") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllowKnockKnock") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsDuoCallDeviceSettings) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsDuoCallDeviceSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsFeatureFilters: Specification of which assistant
// features are allowed for a particular device or user account.
type AssistantApiSettingsFeatureFilters struct {
	CommunicationsFilter *AssistantApiSettingsCommunicationsFilter `json:"communicationsFilter,omitempty"`

	MusicFilter *AssistantApiSettingsMusicFilter `json:"musicFilter,omitempty"`

	NewsFilter *AssistantApiSettingsNewsFilter `json:"newsFilter,omitempty"`

	PodcastFilter *AssistantApiSettingsPodcastFilter `json:"podcastFilter,omitempty"`

	SearchFilter *AssistantApiSettingsSearchFilter `json:"searchFilter,omitempty"`

	ThirdPartyAppsFilter *AssistantApiSettingsThirdPartyAppsFilter `json:"thirdPartyAppsFilter,omitempty"`

	VideoFilter *AssistantApiSettingsVideoFilter `json:"videoFilter,omitempty"`

	WebviewFilter *AssistantApiSettingsWebviewFilter `json:"webviewFilter,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "CommunicationsFilter") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CommunicationsFilter") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsFeatureFilters) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsFeatureFilters
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiSettingsGcmSettings struct {
	GcmId string `json:"gcmId,omitempty"`

	GcmPackage string `json:"gcmPackage,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcmId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcmId") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsGcmSettings) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsGcmSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsHomeGraphData: Next ID: 8
type AssistantApiSettingsHomeGraphData struct {
	// AgentId: Agent ID, aka project ID. Used as the AgentDeviceId.agent_id
	// of device when calling Home Graph Service.
	AgentId string `json:"agentId,omitempty"`

	// Attributes: See go/ha-dev-guide and HomeGraphItem.attribute in
	// //assistant/verticals/homeautomation/proto/home_graph.proto
	Attributes googleapi.RawMessage `json:"attributes,omitempty"`

	// DeviceId: Device ID, used as AgentDeviceId.device_id of device when
	// calling Home Graph Service.
	DeviceId string `json:"deviceId,omitempty"`

	// DeviceType: HGS device type. See
	// java/com/google/home/graph/service/config/protoconf.pi for the
	// exhaustive list of type strings.
	DeviceType string `json:"deviceType,omitempty"`

	// ShouldWriteToHomeGraph: Whether device data should be written to Home
	// Graph via Assistant device_settings. Assistant SDK and Google Home
	// write their devices into Home Graph through AssistantSettingsService,
	// while Home Automation Partner devices (e.g. SmartThings, Philips Hue,
	// Nest, TP-Link, etc.) don't need to be written to Home Graph through
	// AssistantSettingsService. This field decides whether
	// AssistantSettingsService writes devices to Home Graph or not.
	ShouldWriteToHomeGraph bool `json:"shouldWriteToHomeGraph,omitempty"`

	// SupportedTraits: Supported traits of the device. See
	// java/com/google/home/graph/service/config/protoconf.pi for the
	// exhaustive list of trait-strings.
	SupportedTraits []string `json:"supportedTraits,omitempty"`

	// SupportsDirectResponse: Whether the device supports direct response.
	// See HomeGraphItem.supports_direct_response in
	// //assistant/verticals/homeautomation/proto/home_graph.proto
	SupportsDirectResponse bool `json:"supportsDirectResponse,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AgentId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AgentId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsHomeGraphData) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsHomeGraphData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiSettingsHospitalityCardSettings struct {
	// CardConfig: Config for Hospitality UI modules.
	CardConfig []*AssistantApiSettingsHospitalityCardSettingsCardConfig `json:"cardConfig,omitempty"`

	// ShowMediaTapGestureTutorial: Toggle media tap gesture tutorial card.
	ShowMediaTapGestureTutorial bool `json:"showMediaTapGestureTutorial,omitempty"`

	// ShowPhotoSwipeGestureTutorial: Toggle photo swipe gesture tutorial
	// card.
	ShowPhotoSwipeGestureTutorial bool `json:"showPhotoSwipeGestureTutorial,omitempty"`

	// YoutubeCardConfig: Config for YouTube video cards.
	YoutubeCardConfig []*AssistantApiSettingsHospitalityCardSettingsYouTubeCardConfig `json:"youtubeCardConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CardConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CardConfig") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsHospitalityCardSettings) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsHospitalityCardSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsHospitalityCardSettingsCardConfig: Configuration
// for hospitality card.
type AssistantApiSettingsHospitalityCardSettingsCardConfig struct {
	// ActiveActionRequired: Whether the UI module requires user action. If
	// true, the UI module can peek on to the top of Ambient. See
	// SmartDisplayModuleState::ACTIVE_ACTION_REQUIRED.
	ActiveActionRequired bool `json:"activeActionRequired,omitempty"`

	// Dismissable: Whether the UI module is dismissable.
	Dismissable bool `json:"dismissable,omitempty"`

	// EffectiveTime: The time that the module is effective and visible to
	// the user. If not set, the module is effective immediately.
	EffectiveTime *AssistantApiTimestamp `json:"effectiveTime,omitempty"`

	// ExpiryTime: The time that the module is expired and invisible to the
	// user. If not set, the module never expires.
	ExpiryTime *AssistantApiTimestamp `json:"expiryTime,omitempty"`

	// ImageUrl: The image URL for the UI module.
	ImageUrl string `json:"imageUrl,omitempty"`

	// ModuleId: Module ID.
	//
	// Possible values:
	//   "UNKNOWN"
	//   "MID_STAY_SURVEY"
	//   "CHECK_OUT"
	//   "CHECK_IN"
	//   "RESET"
	ModuleId string `json:"moduleId,omitempty"`

	// PayloadQuery: Payload query to the partner AoG action when user
	// responds to UI Module, e.g. “Tell the hotel how my stay is
	// going”.
	PayloadQuery string `json:"payloadQuery,omitempty"`

	// Title: Title of the message to be shown to user at the top of the UI
	// Module.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ActiveActionRequired") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ActiveActionRequired") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsHospitalityCardSettingsCardConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsHospitalityCardSettingsCardConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsHospitalityCardSettingsYouTubeCardConfig:
// Configuration for YouTube video card (Stargazer tile).
type AssistantApiSettingsHospitalityCardSettingsYouTubeCardConfig struct {
	// ImageUrl: URL of image to go on card. The URL must be a public link
	// accessible from ZeroState.
	ImageUrl string `json:"imageUrl,omitempty"`

	// PlaylistId: ID of YouTube playlist to play on card tap. A playlist is
	// used instead of a single video id to avoid autoplaying related
	// videos. The playlist and the videos it contains must be public or
	// unlisted to be accessible from ZeroState.
	PlaylistId string `json:"playlistId,omitempty"`

	// Text: Text on card (i.e., video title).
	Text string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ImageUrl") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ImageUrl") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsHospitalityCardSettingsYouTubeCardConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsHospitalityCardSettingsYouTubeCardConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsHospitalityMode: Hospitality mode config for the
// current device. go/hospitality-mode-design. Next ID: 17
type AssistantApiSettingsHospitalityMode struct {
	// AogContextId: List of AOG app context ids that are linked to this
	// device. These apps will have access to the structure information for
	// the device.
	AogContextId []string `json:"aogContextId,omitempty"`

	// AogInvocationPhrase: Invocation phrase for hotel's AoG action. Used
	// for ZS promotion card and "talk to my hotel" rewrites. Setting this
	// to an empty value will mark it unset.
	AogInvocationPhrase string `json:"aogInvocationPhrase,omitempty"`

	Branding *AssistantApiSettingsHospitalityModeBranding `json:"branding,omitempty"`

	CardSettings *AssistantApiSettingsHospitalityCardSettings `json:"cardSettings,omitempty"`

	// DeviceClearRequest: The time when we received a request to reset the
	// device.
	DeviceClearRequest *AssistantApiTimestamp `json:"deviceClearRequest,omitempty"`

	// DialogTtlOverrideMicros: Should the dialog have a shorter ttl. See
	// go/ipp-consumer-prd#heading=h.ibu9b1ysdl4t and
	// go/interpreter-device-clear#bookmark=id.hw8ey1bzjadn for context.
	DialogTtlOverrideMicros int64 `json:"dialogTtlOverrideMicros,omitempty,string"`

	// EnterpriseId: Identifier for the enterprise which owns the device.
	// Setting this to an empty value will mark it unset.
	EnterpriseId string `json:"enterpriseId,omitempty"`

	// HospitalityModeEnabled: Indicates whether this device is in the
	// hospitality mode.
	HospitalityModeEnabled bool `json:"hospitalityModeEnabled,omitempty"`

	// LastDeviceClear: Last time the device was cleared and placed in
	// hospitality mode. Will be set when the switch is toggled on and reset
	// when a guest checks out. On the device this triggers removing alarms,
	// timers, etc.
	LastDeviceClear *AssistantApiTimestamp `json:"lastDeviceClear,omitempty"`

	// LastModifiedTimestamp: Indicates when hospitality settings were last
	// updated.
	LastModifiedTimestamp *AssistantApiTimestamp `json:"lastModifiedTimestamp,omitempty"`

	// LastWelcomed: Last time the welcome message was played for the guest.
	// If last_welcomed < welcome_request, the message should be replayed
	// and this time set.
	LastWelcomed *AssistantApiTimestamp `json:"lastWelcomed,omitempty"`

	// ManualResetRequired: Indicates whether or not the device must be
	// reset manually (by voice or touch), as opposed to being automatically
	// reset. go/hospitality-manual-reset
	ManualResetRequired bool `json:"manualResetRequired,omitempty"`

	// PromotedLanguages: In order promoted languages for interpreter
	// devices. This represents languages by BCP-47 language strings, such
	// as "en", "en-US", "fr", "fr-CA", "sr-Latn", "zh-Hans-CN",
	// "zh-Hant-HK",etc.
	PromotedLanguages []string `json:"promotedLanguages,omitempty"`

	// Possible values:
	//   "UNKNOWN_TYPE"
	//   "HOTEL_ROOM"
	//   "INTERPRETER" - go/hospitality-interpreter-mode
	//   "SENIOR_LIVING_ROOM" - go/merrill-prd
	//   "RETAIL_DEMO" - go/assistant-retail-demo
	Type string `json:"type,omitempty"`

	// VerbalResetSupported: Whether we allow users to initiate clearing the
	// device verbally. We generally allow this for private devices and not
	// for public ones.
	VerbalResetSupported bool `json:"verbalResetSupported,omitempty"`

	// WelcomeRequest: The time when we received a request to welcome the
	// user.
	WelcomeRequest *AssistantApiTimestamp `json:"welcomeRequest,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AogContextId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AogContextId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsHospitalityMode) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsHospitalityMode
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsHospitalityModeBranding: TODO(b/169423976)
// Consider moving Branding out of user level settings into enterprise
// level settings. Partner branding fields used to customize the ui.
// Next ID: 7
type AssistantApiSettingsHospitalityModeBranding struct {
	// DisplayName: Brand display in the UI
	DisplayName string `json:"displayName,omitempty"`

	// DisplayNameForLanguage: Brand display in the UI for languages that
	// the enterprise has a localized name that is different from its global
	// branding name. For example, Hilton is 'ヒルトン' in Japanese and
	// '希爾頓' in Chinese. The keys are hospitality supported display
	// locales, e.g. en, ja-JP, etc, defined in experiment parameter
	// Hospitality__hospitality_display_supported_locales.
	DisplayNameForLanguage map[string]string `json:"displayNameForLanguage,omitempty"`

	LargeLogoUrl string `json:"largeLogoUrl,omitempty"`

	SmallLogoUrl string `json:"smallLogoUrl,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsHospitalityModeBranding) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsHospitalityModeBranding
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsHotwordThresholdAdjustmentFactor:
// HotwordThresholdAdjustmentFactor contains
// threshold_adjustment_factor, and it's validity. value should only be
// considered when is_valid = true.
type AssistantApiSettingsHotwordThresholdAdjustmentFactor struct {
	// IsValid: Currently, is_valid is set to false whenever the TAF is not
	// an Autotune aware value. This includes hotword sensitivity users, or
	// devices not eligible for autotune.
	IsValid bool `json:"isValid,omitempty"`

	Value int64 `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IsValid") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IsValid") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsHotwordThresholdAdjustmentFactor) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsHotwordThresholdAdjustmentFactor
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsInternalAncillaryDeviceId: Represents supporting
// device ids.
type AssistantApiSettingsInternalAncillaryDeviceId struct {
	// DeviceId: Contains device ids known to devices. eg. For ATV, it
	// contains client_instance_id and cast_id.
	DeviceId *AssistantApiCoreTypesDeviceId `json:"deviceId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeviceId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeviceId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsInternalAncillaryDeviceId) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsInternalAncillaryDeviceId
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsInternalVersion: Represents a version of a
// specifit setting, e.g. DeviceSettings.
type AssistantApiSettingsInternalVersion struct {
	// GenerationTime: Contains the timestamp when this version was
	// generated.
	GenerationTime string `json:"generationTime,omitempty"`

	// Id: Integer value of the version, it is a monotonically increasing
	// number and starts at 0. On every update it is incremented by 1.
	Id int64 `json:"id,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "GenerationTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GenerationTime") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsInternalVersion) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsInternalVersion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsKidsMode: Kids mode config for the current
// device. go/aff-parentalsupervision-dd
type AssistantApiSettingsKidsMode struct {
	KidsModeEnabled bool `json:"kidsModeEnabled,omitempty"`

	// ObfuscatedGaiaId: Identifier of the account currently specified to be
	// used with kids mode.
	ObfuscatedGaiaId string `json:"obfuscatedGaiaId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "KidsModeEnabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "KidsModeEnabled") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsKidsMode) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsKidsMode
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiSettingsLabeledDowntimeSchedule struct {
	// DisplayName: User-provided name for this schedule.
	DisplayName string `json:"displayName,omitempty"`

	Schedule *AssistantApiSettingsDowntimeSchedule `json:"schedule,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsLabeledDowntimeSchedule) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsLabeledDowntimeSchedule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsLinkedUser: Represents the profile of the user
// who has signed in onto this device. Next id: 5
type AssistantApiSettingsLinkedUser struct {
	// CastLinkingTime: Time of linking of the device with the user provided
	// by Cast.
	CastLinkingTime string `json:"castLinkingTime,omitempty"`

	// Email: Primary email address of the user.
	Email string `json:"email,omitempty"`

	GaiaId int64 `json:"gaiaId,omitempty,string"`

	// Names: Supports features which depend on profile name, when no
	// matching contact is found.
	Names []*AppsPeopleOzExternalMergedpeopleapiName `json:"names,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CastLinkingTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CastLinkingTime") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsLinkedUser) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsLinkedUser
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiSettingsMarketplaceDisclosure struct {
	// Confirmed: True if the user has confirmed the marketplace disclosure.
	Confirmed bool `json:"confirmed,omitempty"`

	// TimestampMs: The time user confirmed the marketplace disclosure.
	TimestampMs int64 `json:"timestampMs,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Confirmed") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Confirmed") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsMarketplaceDisclosure) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsMarketplaceDisclosure
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsMasqueradeMode: Guest mode for the current
// device. go/assistant-guest-mode-summary
type AssistantApiSettingsMasqueradeMode struct {
	LastEnterGuestModeTimestamp *AssistantApiTimestamp `json:"lastEnterGuestModeTimestamp,omitempty"`

	LastExitGuestModeTimestamp *AssistantApiTimestamp `json:"lastExitGuestModeTimestamp,omitempty"`

	MasqueradeModeEnabled bool `json:"masqueradeModeEnabled,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "LastEnterGuestModeTimestamp") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "LastEnterGuestModeTimestamp") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsMasqueradeMode) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsMasqueradeMode
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsMusicFilter: Specification of which music
// features can be used.
type AssistantApiSettingsMusicFilter struct {
	// AvailableProviders: Providers available at the time user updated
	// settings.
	//
	// Possible values:
	//   "UNKNOWN_MUSIC_PROVIDER"
	//   "YOUTUBE_MUSIC"
	//   "GOOGLE_PLAY_MUSIC"
	//   "SPOTIFY"
	//   "APPLE_MUSIC"
	//   "PANDORA"
	AvailableProviders []string `json:"availableProviders,omitempty"`

	// ProviderFilterState: Represents the state for the music provider
	// filter.
	//
	// Possible values:
	//   "UNKNOWN_STATE"
	//   "ALLOW_ALL_PROVIDERS" - With this state, all music providers are
	// allowed.
	//   "ALLOW_WHITELISTED_PROVIDERS" - This limits the allowed providers
	// to the whitelisted ones. This means that we can block all providers
	// if the whitelist is empty.
	ProviderFilterState string `json:"providerFilterState,omitempty"`

	// Possible values:
	//   "UNKNOWN_STATE"
	//   "ALLOW_ALL" - Allow all music.
	//   "BLOCK_EXPLICIT" - Block music with explicit lyrics.
	//   "BLOCK_ALL" - Block all music.
	State string `json:"state,omitempty"`

	// WhitelistedProviders: Contains the list of whitelisted music
	// providers.
	//
	// Possible values:
	//   "UNKNOWN_MUSIC_PROVIDER"
	//   "YOUTUBE_MUSIC"
	//   "GOOGLE_PLAY_MUSIC"
	//   "SPOTIFY"
	//   "APPLE_MUSIC"
	//   "PANDORA"
	WhitelistedProviders []string `json:"whitelistedProviders,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AvailableProviders")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AvailableProviders") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsMusicFilter) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsMusicFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsNewsFilter: Specification of which news features
// can be used.
type AssistantApiSettingsNewsFilter struct {
	// Possible values:
	//   "UNKNOWN_STATE"
	//   "ALLOW_ALL_NEWS" - Allow all news.
	//   "BLOCK_ALL_NEWS" - Block all news.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "State") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsNewsFilter) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsNewsFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiSettingsNotificationProfile struct {
	// AlloNotificationProfile: Each device can have only one type of
	// notification profile.
	AlloNotificationProfile *AssistantApiSettingsNotificationProfileAlloNotificationProfile `json:"alloNotificationProfile,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AlloNotificationProfile") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AlloNotificationProfile")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsNotificationProfile) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsNotificationProfile
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiSettingsNotificationProfileAlloNotificationProfile struct {
	// BotSendToken: The send token of the conversation with the user.
	BotSendToken *ChatBotPlatformBotSendToken `json:"botSendToken,omitempty"`

	// Id: The fireball id of this user.
	Id *ChatBotPlatformFireballId `json:"id,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BotSendToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BotSendToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsNotificationProfileAlloNotificationProfile) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsNotificationProfileAlloNotificationProfile
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiSettingsOnDeviceAppSettings struct {
	// CarrierCallDeviceSettings: On device carrier call related settings.
	CarrierCallDeviceSettings *AssistantApiSettingsCarrierCallDeviceSettings `json:"carrierCallDeviceSettings,omitempty"`

	// DuoCallDeviceSettings: On device duo call related settings.
	DuoCallDeviceSettings *AssistantApiSettingsDuoCallDeviceSettings `json:"duoCallDeviceSettings,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "CarrierCallDeviceSettings") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "CarrierCallDeviceSettings") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsOnDeviceAppSettings) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsOnDeviceAppSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiSettingsPersonalizationMetadata struct {
	// Possible values:
	//   "PERSONALIZATION_FLOW_UNKNOWN"
	//   "PERSONALIZATION_FLOW_DEVICE"
	//   "PERSONALIZATION_FLOW_TWOOBE" - TWOOBE: go/twoobe-prd
	//   "PERSONALIZATION_FLOW_SLA" - SLA: go/sla-prd
	//   "PERSONALIZATION_FLOW_DEVICE_DELEGATED_CUSTODIO" - Custodio:
	// go/assistant-pc-prd
	FaceMatch string `json:"faceMatch,omitempty"`

	// Possible values:
	//   "PERSONALIZATION_FLOW_UNKNOWN"
	//   "PERSONALIZATION_FLOW_DEVICE"
	//   "PERSONALIZATION_FLOW_TWOOBE" - TWOOBE: go/twoobe-prd
	//   "PERSONALIZATION_FLOW_SLA" - SLA: go/sla-prd
	//   "PERSONALIZATION_FLOW_DEVICE_DELEGATED_CUSTODIO" - Custodio:
	// go/assistant-pc-prd
	PersonalResults string `json:"personalResults,omitempty"`

	// Possible values:
	//   "PERSONALIZATION_FLOW_UNKNOWN"
	//   "PERSONALIZATION_FLOW_DEVICE"
	//   "PERSONALIZATION_FLOW_TWOOBE" - TWOOBE: go/twoobe-prd
	//   "PERSONALIZATION_FLOW_SLA" - SLA: go/sla-prd
	//   "PERSONALIZATION_FLOW_DEVICE_DELEGATED_CUSTODIO" - Custodio:
	// go/assistant-pc-prd
	VoiceMatch string `json:"voiceMatch,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FaceMatch") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FaceMatch") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsPersonalizationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsPersonalizationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsPodcastFilter: Specification of which podcast
// features can be used.
type AssistantApiSettingsPodcastFilter struct {
	// Possible values:
	//   "UNKNOWN_STATE"
	//   "ALLOW_ALL_PODCASTS" - Allow all podcasts.
	//   "BLOCK_ALL_PODCASTS" - Block all podcasts.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "State") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsPodcastFilter) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsPodcastFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsPoliteMode: Polite mode config for the current
// device. go/polite-mode-dd
type AssistantApiSettingsPoliteMode struct {
	PoliteModeEnabled bool `json:"politeModeEnabled,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PoliteModeEnabled")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PoliteModeEnabled") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsPoliteMode) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsPoliteMode
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsReauthTrustedDeviceSettings: Settings related to
// Assistant reauth. go/assistant-reauth-verify-skip Next id: 2
type AssistantApiSettingsReauthTrustedDeviceSettings struct {
	// TrustSettingsForClient: Mapping from integrator client id to device's
	// trust settings. Id from
	// assistant/agent_platform/transactions/reauth/reauth_client.proto.
	TrustSettingsForClient map[string]AssistantApiSettingsReauthTrustedDeviceSettingsTrustSettings `json:"trustSettingsForClient,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "TrustSettingsForClient") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TrustSettingsForClient")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsReauthTrustedDeviceSettings) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsReauthTrustedDeviceSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsReauthTrustedDeviceSettingsTrustSettings: Next
// id: 6
type AssistantApiSettingsReauthTrustedDeviceSettingsTrustSettings struct {
	// NeverAskAgain: If true, don't ask user to trust this device again.
	NeverAskAgain bool `json:"neverAskAgain,omitempty"`

	// NeverAskExpirationTimestamp: DEPRECATED: Use never_ask_again instead.
	// Expiration timestamp of "never ask again" status. If this field is
	// set and is later than current timestamp, we should NOT ask the user
	// whether they'd like to trust this device.
	NeverAskExpirationTimestamp string `json:"neverAskExpirationTimestamp,omitempty"`

	// TrustDeviceExpirationTimestamp: Expiration timestamp of "trusted"
	// status. If this field is set and is later than current timestamp, we
	// can consider this device to be trusted.
	TrustDeviceExpirationTimestamp string `json:"trustDeviceExpirationTimestamp,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NeverAskAgain") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NeverAskAgain") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsReauthTrustedDeviceSettingsTrustSettings) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsReauthTrustedDeviceSettingsTrustSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsSearchFilter: Specification of which search
// features can be used.
type AssistantApiSettingsSearchFilter struct {
	// Possible values:
	//   "UNKNOWN_STATE"
	//   "ALLOW_SAFE_SEARCH" - Allow only safe search for the Assistant.
	//   "BLOCK_SEARCH" - Block (almost) all search features. Some "safe"
	// features that users wouldn't consider search (like calculator) are
	// still allowed in this mode.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "State") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsSearchFilter) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsSearchFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsSpeechOutputSettings: Settings related to TTS
// output.
type AssistantApiSettingsSpeechOutputSettings struct {
	// Possible values:
	//   "UNSPECIFIED"
	//   "VERBOSE" - Provide speech output most of the time.
	//   "MIN_VERBOSITY" - Optimize where to provide speech output.
	//   "HANDS_FREE_ONLY" - Provide speech output only in hands-free mode.
	// No TTS will be provided otherwise.
	SpeechOutput string `json:"speechOutput,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SpeechOutput") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SpeechOutput") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsSpeechOutputSettings) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsSpeechOutputSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsSpeechSettings: Settings related to speech
// detection. See go/hotword-settings-on-cloud for more info. Next ID:
// 16
type AssistantApiSettingsSpeechSettings struct {
	// ContinuedConversationEnabled: Indicates whether Continued
	// Conversation is enabled for this device.
	ContinuedConversationEnabled bool `json:"continuedConversationEnabled,omitempty"`

	// DeviceModelType: Stores the device model type e.g Pixel.
	DeviceModelType string `json:"deviceModelType,omitempty"`

	// DspAvailable: Whether the device has DSP chip to enable always on
	// hotword detection.
	DspAvailable bool `json:"dspAvailable,omitempty"`

	// HotwordInNavigationEnabled: Whether hotword has been enabled by the
	// user during navigation.
	//
	// Possible values:
	//   "UNAVAILABLE" - Setting is unavailable to the user.
	//   "ENABLED" - Setting is available and enabled by the user.
	//   "DISABLED" - Setting is available but disabled by the user.
	//   "UNDECIDED" - Setting is available, but user never touched this
	// setting.
	//   "OPA_DISABLED" - Setting is disabled because Opa is disabled by
	// user.
	//   "UNSUPPORTED_LOCALE" - Setting is unavailable because the locale is
	// unsupported. Deprecated, use voice_match_available
	//   "INCOMPLETE" - Setting is incomplete, see
	// go/hotword-incomplete-state
	//   "ENABLED_WITHOUT_OPA_AVAILABILITY" - Setting is enabled by user
	// without opa availability. go/no-opa-yes-vm
	HotwordInNavigationEnabled string `json:"hotwordInNavigationEnabled,omitempty"`

	// HotwordSetting: Stores hotword setting status for the locales which
	// don't support voice match.
	//
	// Possible values:
	//   "UNAVAILABLE" - Setting is unavailable to the user.
	//   "ENABLED" - Setting is available and enabled by the user.
	//   "DISABLED" - Setting is available but disabled by the user.
	//   "UNDECIDED" - Setting is available, but user never touched this
	// setting.
	//   "OPA_DISABLED" - Setting is disabled because Opa is disabled by
	// user.
	//   "UNSUPPORTED_LOCALE" - Setting is unavailable because the locale is
	// unsupported. Deprecated, use voice_match_available
	//   "INCOMPLETE" - Setting is incomplete, see
	// go/hotword-incomplete-state
	//   "ENABLED_WITHOUT_OPA_AVAILABILITY" - Setting is enabled by user
	// without opa availability. go/no-opa-yes-vm
	HotwordSetting string `json:"hotwordSetting,omitempty"`

	// LockscreenEnabled: Whether pin/pattern lockscreen has been enabled by
	// the user.
	LockscreenEnabled bool `json:"lockscreenEnabled,omitempty"`

	// OpaEligibilityState: Stores if Assistant is available for the user's
	// device/locale, where Enabled means it is available and disabled means
	// it is not.
	//
	// Possible values:
	//   "UNAVAILABLE" - Setting is unavailable to the user.
	//   "ENABLED" - Setting is available and enabled by the user.
	//   "DISABLED" - Setting is available but disabled by the user.
	//   "UNDECIDED" - Setting is available, but user never touched this
	// setting.
	//   "OPA_DISABLED" - Setting is disabled because Opa is disabled by
	// user.
	//   "UNSUPPORTED_LOCALE" - Setting is unavailable because the locale is
	// unsupported. Deprecated, use voice_match_available
	//   "INCOMPLETE" - Setting is incomplete, see
	// go/hotword-incomplete-state
	//   "ENABLED_WITHOUT_OPA_AVAILABILITY" - Setting is enabled by user
	// without opa availability. go/no-opa-yes-vm
	OpaEligibilityState string `json:"opaEligibilityState,omitempty"`

	// OpaEligible: Stores if Assistant is available for the user's
	// device/locale. Deprecated as bools do not give accurate true/false
	// ratios due to old clients reporting the default value.
	OpaEligible bool `json:"opaEligible,omitempty"`

	// SdkVersion: Stores the Android SDK version. This comes from
	// android.os.Build.VERSION.SDK_INT.
	SdkVersion int64 `json:"sdkVersion,omitempty"`

	// SpeakerIdModelPresent: Whether speaker ID model is present for the
	// user.
	SpeakerIdModelPresent bool `json:"speakerIdModelPresent,omitempty"`

	// SpeakerIdRecognitionEnabled: Indicates whether the user has enabled
	// speaker-id (fromAnyScreen/alwaysOn) for this device. Deprecated - use
	// voice_match_setting instead
	SpeakerIdRecognitionEnabled bool `json:"speakerIdRecognitionEnabled,omitempty"`

	// TrustedVoiceEnabled: Indicates whether the user has enabled trusted
	// voice for this device.
	TrustedVoiceEnabled bool `json:"trustedVoiceEnabled,omitempty"`

	// UnlockWithHotwordAvailable: A bool indicating whether device supports
	// unlocking device with hotword.
	UnlockWithHotwordAvailable bool `json:"unlockWithHotwordAvailable,omitempty"`

	// UserMigratedToDeclined: Stores if user was migrated from undecided to
	// declined as apart of Mariko project. Used for potential growth
	// targeting.
	UserMigratedToDeclined bool `json:"userMigratedToDeclined,omitempty"`

	// VoiceMatchSetting: Stores the hotword/voice match setting status for
	// the locales which support voice match.
	//
	// Possible values:
	//   "UNAVAILABLE" - Setting is unavailable to the user.
	//   "ENABLED" - Setting is available and enabled by the user.
	//   "DISABLED" - Setting is available but disabled by the user.
	//   "UNDECIDED" - Setting is available, but user never touched this
	// setting.
	//   "OPA_DISABLED" - Setting is disabled because Opa is disabled by
	// user.
	//   "UNSUPPORTED_LOCALE" - Setting is unavailable because the locale is
	// unsupported. Deprecated, use voice_match_available
	//   "INCOMPLETE" - Setting is incomplete, see
	// go/hotword-incomplete-state
	//   "ENABLED_WITHOUT_OPA_AVAILABILITY" - Setting is enabled by user
	// without opa availability. go/no-opa-yes-vm
	VoiceMatchSetting string `json:"voiceMatchSetting,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ContinuedConversationEnabled") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "ContinuedConversationEnabled") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsSpeechSettings) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsSpeechSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiSettingsTetheredInfo struct {
	// PrimaryHostDeviceId: The host this wearable is tethered to (e.g.
	// phone). When host is AGSA then this is agsa_client_instance_id. When
	// host is IOPA then this is opa_ios_device_id.
	PrimaryHostDeviceId string `json:"primaryHostDeviceId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PrimaryHostDeviceId")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PrimaryHostDeviceId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsTetheredInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsTetheredInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsThirdPartyAppsFilter: Specification of which
// third party apps can be used.
type AssistantApiSettingsThirdPartyAppsFilter struct {
	// Possible values:
	//   "UNKNOWN_STATE"
	//   "ALLOW_ALL" - Allow all third party apps.
	//   "ALLOW_CERTIFIED_FOR_FAMILIES" - Only allow certified Apps for
	// Families. See
	// https://developers.google.com/actions/apps-for-families/.
	//   "BLOCK_ALL" - Block all third party apps.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "State") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsThirdPartyAppsFilter) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsThirdPartyAppsFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsVideoFilter: Specification of which video
// features can be used.
type AssistantApiSettingsVideoFilter struct {
	// AutoplayToggleState: State that indicates whether autoplay is enabled
	// for youtube videos.
	//
	// Possible values:
	//   "UNKNOWN_STATE" - Default uninitialized state.
	//   "ENABLED" - Allow autoplay for youtube videos.
	//   "DISABLED" - Disable autoplay for youtube videos.
	AutoplayToggleState string `json:"autoplayToggleState,omitempty"`

	// AvailableProviders: Providers available at the time user updated
	// settings.
	//
	// Possible values:
	//   "UNKNOWN_VIDEO_PROVIDER"
	//   "YOUTUBE"
	//   "YOUTUBE_TV"
	//   "YOUTUBE_KIDS"
	AvailableProviders []string `json:"availableProviders,omitempty"`

	// ProviderFilterState: Represents the state for the video provider
	// filter.
	//
	// Possible values:
	//   "UNKNOWN_STATE"
	//   "ALLOW_ALL_PROVIDERS" - With this state, all video providers are
	// allowed.
	//   "ALLOW_WHITELISTED_PROVIDERS" - This limits the allowed providers
	// to the whitelisted ones. This means that we can block all providers
	// if the whitelist is empty.
	ProviderFilterState string `json:"providerFilterState,omitempty"`

	// Possible values:
	//   "UNKNOWN_STATE"
	//   "ALLOW_ALL" - Allow all videos.
	//   "BLOCK_MATURE_CONTENT" - Block videos with mature content.
	//   "BLOCK_ALL" - Block all videos.
	State string `json:"state,omitempty"`

	// WhitelistedProviders: Contains the list of whitelisted video
	// providers.
	//
	// Possible values:
	//   "UNKNOWN_VIDEO_PROVIDER"
	//   "YOUTUBE"
	//   "YOUTUBE_TV"
	//   "YOUTUBE_KIDS"
	WhitelistedProviders []string `json:"whitelistedProviders,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AutoplayToggleState")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AutoplayToggleState") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsVideoFilter) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsVideoFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSettingsWebviewFilter: Specification of which webview
// features can be used.
type AssistantApiSettingsWebviewFilter struct {
	// JasperWebviewConsent: Indicates if user has consented Jasper warning
	// message.
	JasperWebviewConsent bool `json:"jasperWebviewConsent,omitempty"`

	// Possible values:
	//   "UNKNOWN_STATE"
	//   "ALLOW_ALL_WEBSITES" - Allow all websites.
	//   "BLOCK_ALL_WEBSITES" - Block all websites.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "JasperWebviewConsent") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "JasperWebviewConsent") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSettingsWebviewFilter) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSettingsWebviewFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSignInMethod: The method of sign in which the client
// supports.
type AssistantApiSignInMethod struct {
	// Possible values:
	//   "UNSPECIFIED" - Unspecified value. Defaults to the same sign-in
	// behavior as PHONE_APP.
	//   "NOT_ALLOWED" - Sign in is not allowed, e.g., go/telephone.
	//   "PHONE_APP" - Sign in with Home app, e.g. Google Home.
	//   "ON_DEVICE_MENU" - Sign in with on device menu, e.g., LGTV,
	// go/web-assistant
	//   "WEB_APP" - Sign in with the Assistant sign in website. See
	// go/baird-web-based-sign-in.
	Method string `json:"method,omitempty"`

	// SignInRequired: Make Google sign-in mandatory for using Google
	// Assistant on the device.
	SignInRequired bool `json:"signInRequired,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Method") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Method") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSignInMethod) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSignInMethod
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSodaCapabilities: Capabilities related to SODA (Speech
// On-Device API). Next ID: 5
type AssistantApiSodaCapabilities struct {
	// SupportsHotwordSensitivity: Whether the device supports different
	// levels of hotword sensitivity. go/hotword-sensitivity-prd
	SupportsHotwordSensitivity bool `json:"supportsHotwordSensitivity,omitempty"`

	// SupportsSimpleStop: Whether Simple Stop (go/simple-stop) is enabled
	// on the device. Simple stop allows users to stop firing alarms and
	// timers by just saying "stop" without first saying the hotword.
	SupportsSimpleStop bool `json:"supportsSimpleStop,omitempty"`

	// SupportsSpeakerId: Whether the device supports speaker-id (speaker
	// identification based on hotword and/or spoken query - go/speaker-id).
	// Note: there are existing devices that support speaker-id but does not
	// have this capability set. Not having this field populated doesn't
	// necessarily mean the device doesn't support speaker-id.
	SupportsSpeakerId bool `json:"supportsSpeakerId,omitempty"`

	// SupportsWarmWords: Whether the device supports WarmWords
	// (go/warm-words-framework).
	SupportsWarmWords bool `json:"supportsWarmWords,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "SupportsHotwordSensitivity") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "SupportsHotwordSensitivity") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSodaCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSodaCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSoftwareCapabilities: These capabilities represent what
// software features the client supports. This should be determined
// based on the client's various software versions (OS, GSA version,
// etc). Next ID: 27
type AssistantApiSoftwareCapabilities struct {
	// AppCapabilities: IMPORTANT: Only one of AppCapabilities and
	// AppCapabilitiesDelta should be in the SoftwareCapabilities. In the
	// edge case if the client sends up both AppCapabilities and
	// AppCapabilitiesDelta, AppCapabilitiesDelta is ignored. Complete list
	// of app capabilities.
	AppCapabilities []*AssistantApiAppCapabilities `json:"appCapabilities,omitempty"`

	// AppCapabilitiesDelta: Incremental update for app capabilities.
	AppCapabilitiesDelta []*AssistantApiAppCapabilitiesDelta `json:"appCapabilitiesDelta,omitempty"`

	// AppIntegrationsSettings: App integrations settings for each packge
	// name.
	AppIntegrationsSettings map[string]AssistantApiAppIntegrationsSettings `json:"appIntegrationsSettings,omitempty"`

	// CarAssistantCapabilities: Capabilities related to Assistant on Auto
	// surfaces.
	CarAssistantCapabilities *AssistantApiCarAssistantCapabilities `json:"carAssistantCapabilities,omitempty"`

	// ClockCapabilities: Capabilities related to clock functionality, like
	// alarms, timers, etc.
	ClockCapabilities *AssistantApiClockCapabilities `json:"clockCapabilities,omitempty"`

	// ConversationVersion: A top-level version of Conversation protocol
	// where the versions are explicitly defined at
	// go/conversation-versions.
	ConversationVersion *AssistantApiSupportedConversationVersion `json:"conversationVersion,omitempty"`

	// CrossDeviceExecutionCapabilities: For torus x-device execution
	// support
	CrossDeviceExecutionCapabilities *AssistantApiCrossDeviceExecutionCapability `json:"crossDeviceExecutionCapabilities,omitempty"`

	GacsCapabilities *AssistantApiGacsCapabilities `json:"gacsCapabilities,omitempty"`

	GcmCapabilities *AssistantApiGcmCapabilities `json:"gcmCapabilities,omitempty"`

	// LiveTvChannelCapabilities: Capabilities related to live TV channels.
	LiveTvChannelCapabilities *AssistantApiLiveTvChannelCapabilities `json:"liveTvChannelCapabilities,omitempty"`

	// OemCapabilities: List of actions OEM supports. This includes built-in
	// actions and custom actions.
	OemCapabilities *AssistantApiOemCapabilities `json:"oemCapabilities,omitempty"`

	// OnDeviceAssistantCapabilities: on-device Assistant capabilities
	OnDeviceAssistantCapabilities *AssistantApiOnDeviceAssistantCapabilities `json:"onDeviceAssistantCapabilities,omitempty"`

	// OnDeviceSmartHomeCapabilities: Capability bits for on-device Smart
	// Home. go/framework-for-local-semex
	OnDeviceSmartHomeCapabilities *AssistantApiOnDeviceSmartHomeCapabilities `json:"onDeviceSmartHomeCapabilities,omitempty"`

	// OnDeviceStorageCapabilities: Reflects the storage capabilities on the
	// device.
	OnDeviceStorageCapabilities *AssistantApiOnDeviceStorageCapabilities `json:"onDeviceStorageCapabilities,omitempty"`

	// OperatingSystem: The operating system of the device.
	//
	// Possible values:
	//   "OS_TYPE_UNKNOWN"
	//   "OS_TYPE_ANDROID"
	//   "OS_TYPE_CAST"
	//   "OS_TYPE_FUCHSIA"
	//   "OS_TYPE_LINUX"
	OperatingSystem string `json:"operatingSystem,omitempty"`

	// OrderedLiveTvProviders: An ordered list containing the live tv
	// providers available in the client. The order of the providers
	// reflects the ranking in the client and will be respected by server as
	// well.
	OrderedLiveTvProviders []*AssistantApiLiveTvProvider `json:"orderedLiveTvProviders,omitempty"`

	// SelinaCapabilities: The Soli capabilities on Elaine.
	// go/dingo-dc-software
	SelinaCapabilities *AssistantApiSelinaCapabilites `json:"selinaCapabilities,omitempty"`

	SettingsAppCapabilities *AssistantApiSettingsAppCapabilities `json:"settingsAppCapabilities,omitempty"`

	SupportedClientOp []*AssistantApiSupportedClientOp `json:"supportedClientOp,omitempty"`

	SupportedFeatures *AssistantApiSupportedFeatures `json:"supportedFeatures,omitempty"`

	SupportedMsgVersion *AssistantApiSupportedProtocolVersion `json:"supportedMsgVersion,omitempty"`

	SupportedProviderTypes *AssistantApiSupportedProviderTypes `json:"supportedProviderTypes,omitempty"`

	SurfaceProperties *AssistantApiSurfaceProperties `json:"surfaceProperties,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AppCapabilities") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AppCapabilities") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSoftwareCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSoftwareCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSpeechCapabilities: DEPRECATED These capabilities are
// associated with speech detection on devices.
type AssistantApiSpeechCapabilities struct {
	// DspAvailable: A bool indicating whether device supports dsp based
	// hotword detection.
	DspAvailable bool `json:"dspAvailable,omitempty"`

	// UnlockWithHotwordAvailable: A bool indicating whether device supports
	// unlocking device with hotword.
	UnlockWithHotwordAvailable bool `json:"unlockWithHotwordAvailable,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DspAvailable") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DspAvailable") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSpeechCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSpeechCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSuggestionsSupport: Next ID: 18
type AssistantApiSuggestionsSupport struct {
	// ClickImpersonationSupported: Whether client supports user
	// impersonation on suggestion chip click.
	// go/suggestion-click-impersonation
	ClickImpersonationSupported bool `json:"clickImpersonationSupported,omitempty"`

	// DebugDataSupported: Whether client supports suggestions debug data to
	// be displayed.
	DebugDataSupported bool `json:"debugDataSupported,omitempty"`

	// DrlHistoryChipSupported: Whether DRL history chip is supported.
	// Related bug: http://b/241837879, http://b/171854732 Design doc:
	// http://go/panthera-history-chip-dd DRL history chip was originally
	// rolled out to Panthera in
	// http://google3/googledata/experiments/mobile/agsa/studies/agsa_nga/opa_panthera_one_input_ui_launch.gcl?l=55&rcl=384682900.
	// We plan to roll it out to NGA and TNG. drl_history_chip_supported bit
	// specifies whether the client support (and should have) DRL history
	// chip.
	DrlHistoryChipSupported bool `json:"drlHistoryChipSupported,omitempty"`

	// EscapeHatchSupported: Whether client supports escape hatches aka post
	// execution suggestions go/nga-escape-hatch-prd
	//
	// Possible values:
	//   "UNSUPPORTED"
	//   "NGA_ESCAPE_HATCH"
	EscapeHatchSupported string `json:"escapeHatchSupported,omitempty"`

	// ExecutedTextSupported: Whether the client can rewrite suggestion
	// query text into executed text, if the latter is present. If this
	// feature is disabled, the rewrite happens in Assistant Server.
	ExecutedTextSupported bool `json:"executedTextSupported,omitempty"`

	// ExecutionContextSupported: Whether the client supports passing back
	// `execution_context` from
	// |assistant.api.client_op.SuggestionProcessingParams| when the
	// suggestion is clicked or spoken.
	ExecutionContextSupported bool `json:"executionContextSupported,omitempty"`

	// FeatureSpecificActionSupport: Whether the client supports features in
	// |SuggestionFeatureSpecificAction|.
	FeatureSpecificActionSupport *AssistantApiFeatureSpecificActionSupport `json:"featureSpecificActionSupport,omitempty"`

	// FeatureSpecificAppActionsNotificationSupported: Whether the client
	// supports handling App Actions' notification when the suggestion is
	// clicked. This will allow the server to populate the
	// `app_actions_notification_data` extension field from
	// |SuggestionFeatureSpecificAction| proto message.
	FeatureSpecificAppActionsNotificationSupported bool `json:"featureSpecificAppActionsNotificationSupported,omitempty"`

	// MultiStepTrySayingSupported: Whether the multi-step try saying
	// suggestion feature is supported. dd: go/tng-multi-step-simplified
	MultiStepTrySayingSupported bool `json:"multiStepTrySayingSupported,omitempty"`

	// RuleIdInExecutionContextSupported: Whether the rule_id field in the
	// execution_context is supported. This is a temporary workaround to be
	// able to identify clicks on Person entity suggestions on Sabrina and
	// is expected to be eventually deprecated. TODO(b/185517153) :
	// Deprecate (but do not delete) once click tracking is correctly sent
	// up from the Katniss client.
	RuleIdInExecutionContextSupported bool `json:"ruleIdInExecutionContextSupported,omitempty"`

	// ShowExecutedTextSupported: Whether the client can show executed_text
	// after the click on the suggestion chip. Must be set to false on TNG.
	// TNG disregards |SuggestionProcessingParams.show_executed_text| field
	// and always treats it as if |show_executed_text=true|.
	ShowExecutedTextSupported bool `json:"showExecutedTextSupported,omitempty"`

	// ShowTranslationSupported: Whether the client can show chip as (text |
	// translation). go/lang-partner-doc
	ShowTranslationSupported bool `json:"showTranslationSupported,omitempty"`

	// SupportedDisplayTargets: A list of suggestions display targets
	// supported by this client. If unset only DEFAULT
	// SuggestionDisplayTarget is supported.
	SupportedDisplayTargets []*AssistantApiSuggestionsSupportDisplayTargetSupport `json:"supportedDisplayTargets,omitempty"`

	// WidgetDataSupported: Whether client supports widget suggestion chip
	// to be displayed.
	WidgetDataSupported bool `json:"widgetDataSupported,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ClickImpersonationSupported") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "ClickImpersonationSupported") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSuggestionsSupport) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSuggestionsSupport
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiSuggestionsSupportDisplayTargetSupport struct {
	// ExecutedTextSupported: Whether the client can rewrite suggestion
	// query text into executed text, if the latter is present for the
	// display target.
	ExecutedTextSupported bool `json:"executedTextSupported,omitempty"`

	// HeaderTextSupported: Whether PresentationParams.header_text is
	// supported for the display target.
	HeaderTextSupported bool `json:"headerTextSupported,omitempty"`

	// RepressImpressionSupported: Whether Suggestion.repress_impression is
	// supported. If not repressed suggestions are not returned.
	RepressImpressionSupported bool `json:"repressImpressionSupported,omitempty"`

	// Target: Display target that is supported.
	//
	// Possible values:
	//   "DEFAULT" - Use the default display target.
	//   "NGA_INPUT_PLATE" - Show Escape Hatch chips. The chips are
	// displayed outside of response layer for example over app that query
	// was fulfilled in.
	//   "CONVERSATION_STARTERS" - Show chips as Conversation Starters in
	// Opa and Panthera.
	//   "QUICK_ACTIONS" - Show chips as Panthera quick actions
	// (go/quick-actions-dd).
	//   "TACTILE_ASSISTANT_SUGGESTS" - Show chips in Tactile "Assistant
	// Suggests" section.
	//   "TACTILE_MY_ACTIONS" - Show chips in Tactile "My Actions" section.
	//   "TRY_SAYING" - Show chips as "Try Saying" suggestions.
	//   "RICH_SUGGESTIONS" - Show suggestions as rich suggestions and
	// chips; go/prs-redesign-dd
	Target string `json:"target,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ExecutedTextSupported") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExecutedTextSupported") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSuggestionsSupportDisplayTargetSupport) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSuggestionsSupportDisplayTargetSupport
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiSunriseFeaturesSupport struct {
	// SunriseSimulationSupported: If true, the device can slowly brighten
	// the screen and simulate sunrise experience. Alarms with sunrise field
	// enabled can be set on this device.
	SunriseSimulationSupported bool `json:"sunriseSimulationSupported,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "SunriseSimulationSupported") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "SunriseSimulationSupported") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSunriseFeaturesSupport) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSunriseFeaturesSupport
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSupportedClientOp: These are the set of ClientOps that
// are supported by the device.
type AssistantApiSupportedClientOp struct {
	// ClientOpName: This should be the same as the name of the
	// SemanticClientOp that is supported.
	ClientOpName string `json:"clientOpName,omitempty"`

	// ClientOpProperties: The properties associated with the ClientOp. This
	// proto should be associated with the client_op_name.
	ClientOpProperties *AssistantApiProtobuf `json:"clientOpProperties,omitempty"`

	SupportedExecution *AssistantApiSupportedClientOpSupportedExecution `json:"supportedExecution,omitempty"`

	// Version: A version of 0 is the equivalent to not having support for
	// that client_op type. Note that a client_op is also unsupported if it
	// is not included at all in the list of supported client_ops.
	Version int64 `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ClientOpName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ClientOpName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSupportedClientOp) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSupportedClientOp
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSupportedClientOpSupportedExecution: Additional
// properties that client can support for executing the client op. They
// are surface-specific execution properties and are unrelated to the
// execution model.
type AssistantApiSupportedClientOpSupportedExecution struct {
	// SupportsPartialFulfillment: ClientOp execution supports special
	// rendering behavior while the user is in the middle of expressing
	// their query. This behavior includes: 1) New partial output always
	// over-writes prior partial output. 2) Canceling the interaction
	// removes partial fulfilment from any user visible interaction history.
	// If this is true, whether to apply the special rendering behavior will
	// be determined by PartialFulfillmentRenderingParams. More details can
	// be found at go/ma-natcon-pf-api.
	SupportsPartialFulfillment bool `json:"supportsPartialFulfillment,omitempty"`

	// SupportsSynchronousExecution: Client can support synchronous
	// execution of the client op. For tts.OUTPUT client op it means that
	// client would honor |synchronous_playback_args| argument. Please see
	// more at go/synchronous-sounds-design.
	SupportsSynchronousExecution bool `json:"supportsSynchronousExecution,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "SupportsPartialFulfillment") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "SupportsPartialFulfillment") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSupportedClientOpSupportedExecution) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSupportedClientOpSupportedExecution
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSupportedConversationVersion: The overall Conversation
// Protocol version. As we make fundamental changes to Conversation
// protocol that are non-backwards compatible, we will increment the
// protocol version. By default, all clients will support version 0. All
// versions are documented at go/conversation-versions.
type AssistantApiSupportedConversationVersion struct {
	// SupportsConversationProtocol: Whether conversation protocol is
	// supported explicitly. If true,
	// SingleDeviceCapabilityChecker::SupportsConversationProtocol will
	// always return true.
	SupportsConversationProtocol bool `json:"supportsConversationProtocol,omitempty"`

	// Version: The supported version number.
	Version int64 `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "SupportsConversationProtocol") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "SupportsConversationProtocol") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSupportedConversationVersion) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSupportedConversationVersion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSupportedFeatures: These are the set of features that are
// supported by the device. It's a part of the SoftwareCapabilities of
// the device. Next ID: 68
type AssistantApiSupportedFeatures struct {
	// AaeNotificationSourceSupported: Whether the client supports the
	// alternative message notification sources on AAE, in which case
	// notification-related operations can access it.
	AaeNotificationSourceSupported bool `json:"aaeNotificationSourceSupported,omitempty"`

	// AcpSupport: In what way is assistant continued presence supported.
	// (go/opa-acp-prd)
	AcpSupport *AssistantApiAssistantContinuedPresenceSupport `json:"acpSupport,omitempty"`

	ActionV2SupportedFeatures *AssistantApiActionV2SupportedFeatures `json:"actionV2SupportedFeatures,omitempty"`

	// AlarmTimerManagerApiSupported: Whether the client supports
	// AlarmTimerManager API (go/alarm-timer-manager-api).
	AlarmTimerManagerApiSupported bool `json:"alarmTimerManagerApiSupported,omitempty"`

	// AppControlSupport: The client information for app control support.
	// More details in: go/acaia.
	AppControlSupport *AssistantApiAppControlSupport `json:"appControlSupport,omitempty"`

	// AssistantExploreSupported: Whether the client supports the assistant
	// explore section. This field will be active only when the Explore
	// section is available to the user. This means that the user is (a)
	// signed-in, (b) a IOPA / AGSA user, and (c) in a locale where explore
	// is available.
	AssistantExploreSupported bool `json:"assistantExploreSupported,omitempty"`

	// AssistantForKidsSupported: Whether Assistant for Kids (a.k.a.
	// Designed for Family) features are supported.
	AssistantForKidsSupported bool `json:"assistantForKidsSupported,omitempty"`

	// BypassDiDcCheckForComms: Whether communications flows for the client
	// can bypass the DI/DC check. The client will enforce some other
	// equivalent permission as necessary concerning access to device
	// contacts and apps.
	BypassDiDcCheckForComms bool `json:"bypassDiDcCheckForComms,omitempty"`

	// BypassMsgNotificationDismissal: Whether or not Assistant should
	// enforce the dismissal of communication notifications associated with
	// messages.
	BypassMsgNotificationDismissal bool `json:"bypassMsgNotificationDismissal,omitempty"`

	// Client1mProvidersSupported: Whether the client supports 1m providers
	// (go/1m-partner-expansion).
	Client1mProvidersSupported bool `json:"client1mProvidersSupported,omitempty"`

	// ClientOpResultBatchingSupported: Whether the client can batch client
	// op results before sending them to the server.
	ClientOpResultBatchingSupported bool `json:"clientOpResultBatchingSupported,omitempty"`

	// ConfirmationBeforeReadingMultipleMessagesSupported: Whether the
	// client supports confirmation flow before announcement of multiple
	// messages. If set to true the user will be prompted once and
	// confirmation will be taken before all the messages are announced.
	ConfirmationBeforeReadingMultipleMessagesSupported bool `json:"confirmationBeforeReadingMultipleMessagesSupported,omitempty"`

	// ConversationalCareSupported: Whether the client can render
	// conversational care responses. go/conversational-care
	ConversationalCareSupported bool `json:"conversationalCareSupported,omitempty"`

	// CrossDeviceBroadcastSupported: Whether the client supports
	// cross-device broadcast (i.e. on Torus).
	CrossDeviceBroadcastSupported bool `json:"crossDeviceBroadcastSupported,omitempty"`

	// CrossDeviceBroadcastVersion: The version of cross device broadcast
	// (ie; broadcast on torus) which the client supports.
	//
	// Possible values:
	//   "CROSS_DEVICE_BROADCAST_NOT_SUPPORTED" - Broadcast with torus is
	// not supported on this device.
	//   "CROSS_DEVICE_BROADCAST_V1" - This device supports the cross device
	// broadcast V1 features.
	CrossDeviceBroadcastVersion string `json:"crossDeviceBroadcastVersion,omitempty"`

	// CsatVisualOverlaySupported: Whether the client supports csat visual
	// overlay. (go/sd-od-csat)
	CsatVisualOverlaySupported bool `json:"csatVisualOverlaySupported,omitempty"`

	// DuoClientApiFeatures: The features set which duo client on the device
	// supports. This should be serialized from proto {@code
	// duo_client_api.DuoClientApiFeatures}.
	DuoClientApiFeatures string `json:"duoClientApiFeatures,omitempty"`

	// DuoGroupCallingSupported: Whether the client supports Duo group
	// calling.
	DuoGroupCallingSupported bool `json:"duoGroupCallingSupported,omitempty"`

	// FitnessFeatureSupport: Information about what support this device has
	// for fitness.
	FitnessFeatureSupport *AssistantApiFitnessFeatureSupport `json:"fitnessFeatureSupport,omitempty"`

	// FluidActionsSupport: Fluid Actions features supported by the client.
	// If this field is not set in the incoming request, it could mean that
	// the client does not support Fluid Actions. Alternatively, it could
	// mean that the client supports Fluid Actions, but syncs state with
	// server using the old protocol, namely ConversationStateParams. When
	// b/140733618 is resolved, Surface Adaptation Layer will add this field
	// for old clients that support Fluid Actions framework.
	FluidActionsSupport *AssistantApiFluidActionsSupport `json:"fluidActionsSupport,omitempty"`

	// FuntimeSupported: Whether the surface client op performer supports
	// Funtime alarms and timers. go/funtime-engdesign
	FuntimeSupported bool `json:"funtimeSupported,omitempty"`

	// GdiSupported: Whether account linking via Google Deep Integrations
	// (GDI) is supported. go/opa-gdi-design
	GdiSupported bool `json:"gdiSupported,omitempty"`

	// GearheadNotificationSourceSupported: Whether the client supports the
	// Gearhead message notification source, in which case
	// notification-related operations can access it.
	GearheadNotificationSourceSupported bool `json:"gearheadNotificationSourceSupported,omitempty"`

	// HasPhysicalRadio: Whether the client has a physical radio installed.
	HasPhysicalRadio bool `json:"hasPhysicalRadio,omitempty"`

	// ImmersiveCanvasConfirmationMessageSupported: Whether the client
	// supports confirmation messages in Immersive Canvas actions.
	// Deprecated: use the filed in immersive_canvas_support.
	ImmersiveCanvasConfirmationMessageSupported bool `json:"immersiveCanvasConfirmationMessageSupported,omitempty"`

	ImmersiveCanvasSupport *AssistantApiImmersiveCanvasSupport `json:"immersiveCanvasSupport,omitempty"`

	// InDialogAccountLinkingSupported: Whether the client supports account
	// linking in-dialog (askForSignIn). This is used before this feature is
	// moved to conversation protocol. To support this, the client needs to:
	// - Integrate with Google Deep Integrations. - Have logic to send the
	// result of account linking back to AS.
	InDialogAccountLinkingSupported bool `json:"inDialogAccountLinkingSupported,omitempty"`

	// IsPairedPhoneContactUploadNeededForComms: Whether paired-phone
	// contact upload is needed for communications queries to work (e.g. on
	// AAE).
	IsPairedPhoneContactUploadNeededForComms bool `json:"isPairedPhoneContactUploadNeededForComms,omitempty"`

	// IsPairedPhoneNeededForComms: Whether a Bluetooth-paired phone is a
	// core component of communications flows on the client.
	IsPairedPhoneNeededForComms bool `json:"isPairedPhoneNeededForComms,omitempty"`

	// JustInTimeSupported: Whether the client supports confirmation flow
	// when a permission is missing. If set to true, the user will be
	// prompted and on confirmation the original flow will continue.
	JustInTimeSupported bool `json:"justInTimeSupported,omitempty"`

	// LaunchKeyboardSupported: Which way of launching the keyboard the
	// client supports.
	//
	// Possible values:
	//   "LAUNCH_KEYBOARD_UNSUPPORTED" - Launching the keyboard from a
	// suggestion chip is not supported.
	//   "OPA_ANDROID_LAUNCH_KEYBOARD_URI" - The keyboard can be opened by
	// using the opa-android://launch_keyboard uri. Takes the url-encoded
	// parameters: - query: the string to prefill the keyboard with. -
	// start: (optional) the start position of the span to highlight. - end:
	// (optional) the end position of the span to highlight.
	LaunchKeyboardSupported string `json:"launchKeyboardSupported,omitempty"`

	// LensSupported: Whether the client has Google Lens (Assistant Eyes).
	LensSupported bool `json:"lensSupported,omitempty"`

	// LiveCardsSupported: Whether the surface supports LiveCards. In cases
	// where the user intent flow cannot be completed within the Assistant,
	// LiveCards are used to take the user to an external app or website.
	// These cards will be pushed to the Google Home app via the PushMessage
	// ClientOp.
	LiveCardsSupported bool `json:"liveCardsSupported,omitempty"`

	// LottieAnimationSupport: Whether the client supports the Lottie
	// animation library for the broadcast feature.
	//
	// Possible values:
	//   "LOTTIE_ANIMATION_UNKNOWN"
	//   "LOTTIE_ANIMATION_NOT_SUPPORTED"
	//   "LOTTIE_ANIMATION_SUPPORTED"
	LottieAnimationSupport string `json:"lottieAnimationSupport,omitempty"`

	// MapsDialogsSupported: Whether the client supports Assistant dialogs
	// within Maps. This field will be set only when the Maps on the surface
	// supports Assistant dialogs embedded within Maps. go/gsa-gmm.
	MapsDialogsSupported bool `json:"mapsDialogsSupported,omitempty"`

	// MasqueradeModeSupported: Whether the device supports masquerade mode
	// (go/masquerade).
	MasqueradeModeSupported bool `json:"masqueradeModeSupported,omitempty"`

	// MediaControlSupport: Information about how client handles media
	// controls (play, pause, skip ...)
	MediaControlSupport *AssistantApiMediaControlSupport `json:"mediaControlSupport,omitempty"`

	// MediaSessionDetection: The ability of the client to detect media
	// sessions on the device.
	//
	// Possible values:
	//   "UNKNOWN_MEDIA_SESSION_DETECTION"
	//   "RELIABLE_MEDIA_SESSION_DETECTION" - The client has perfect
	// knowledge of what is playing on the device. For example, Chirp falls
	// into this category. We can reliably choose to control or punt based
	// on media params.
	//   "UNRELIABLE_MEDIA_SESSION_DETECTION" - The client has some
	// knowledge about the media sessions on the device. For example, OPA TV
	// falls into this category. For these cases, we should probably always
	// try to return the media control client op to the client.
	//   "NO_MEDIA_SESSION_DETECTION" - The client has no idea about the
	// media playback on the device. For these cases, we should either punt
	// or attempt to control media and silently fail.
	//   "MEDIA_SESSION_DETECTION_DISABLED_SCREEN_CONTEXT" - Media session
	// detection is supported by the client but disabled by the user (for
	// example: OPA_CROS) by turning off screen context setting.
	MediaSessionDetection string `json:"mediaSessionDetection,omitempty"`

	// MeetSupported: Whether the client supports joining a Google Meet
	// meeting.
	MeetSupported bool `json:"meetSupported,omitempty"`

	// NoInputResponseSupported: Whether the client can render no input
	// response or just ignore it. No input response is returned when client
	// has a no speech input interaction, eg. user tapped mic but didn't say
	// anything.
	NoInputResponseSupported bool `json:"noInputResponseSupported,omitempty"`

	// OpaOnSearchSupported: When the entry source is search, whether the
	// client supports rendering a similar response as OPA one does. Entry
	// source is defined at
	// http://cs/symbol:assistant.api.params.DeviceProperties.EntrySource
	OpaOnSearchSupported bool `json:"opaOnSearchSupported,omitempty"`

	// ParentalControlsSupported: Whether or not the client supports
	// enabling parental controls. When a device to supports parental
	// controls, it has the software necessary to store the relevant
	// information required for parental controls to work. This information
	// includes a boolean "enabled bit" as well as the obfuscated gaia ID of
	// the kid account selected for use with parental controls. Devices
	// supportings kids mode send this information to S3 via S3ClientInfo in
	// every request. See go/aff-kidsproduct for details.
	ParentalControlsSupported bool `json:"parentalControlsSupported,omitempty"`

	// PersistentDisplaySupported: Whether the client supports persistent
	// display. The new feature allows Assistant devices with screen to
	// display a continuously updating permanent display, such as ambient
	// weather, without the need for a user to ask the Assistant. Design
	// doc: go/assistant-persistent-display.
	PersistentDisplaySupported bool `json:"persistentDisplaySupported,omitempty"`

	// PrivacyAwareLockscreenSupported: Whether the client supports the
	// privacy-aware lockscreen protocol (go/assistant-lockscreen-spec).
	PrivacyAwareLockscreenSupported bool `json:"privacyAwareLockscreenSupported,omitempty"`

	// ReadMessagesTtsTaperingSupported: Whether the client supports tts
	// tapering for the read messages flow. If set to true the tapered tts
	// variant would be used during the read messages flow.
	ReadMessagesTtsTaperingSupported bool `json:"readMessagesTtsTaperingSupported,omitempty"`

	// ReadNotificationSummarizationSupported: Whether the client supports
	// message summarization.
	ReadNotificationSummarizationSupported bool `json:"readNotificationSummarizationSupported,omitempty"`

	// RemoteCloudCastingEnabled: Whether the client has remote casting
	// enabled. For ex: we want to disable this for clients like Auto.
	RemoteCloudCastingEnabled bool `json:"remoteCloudCastingEnabled,omitempty"`

	// ServerGeneratedFeedbackChipsEnabled: Whether the Assistant Server
	// should generate feedback suggestion chips.
	ServerGeneratedFeedbackChipsEnabled bool `json:"serverGeneratedFeedbackChipsEnabled,omitempty"`

	// ShLockScreenSupported: Whether the client supports SmartHome lock
	// screen logic (i.e. on Tangor).
	ShLockScreenSupported bool `json:"shLockScreenSupported,omitempty"`

	// SignInMethod: Which kind of sign in the client supports.
	SignInMethod *AssistantApiSignInMethod `json:"signInMethod,omitempty"`

	// SleepSensingSupported: Whether the client can monitor sleep. This
	// allows us to show sleep CUJ related information: go/TwilightDesign
	// Use for development only, see the same field in
	// DeviceCapabilities.SoftwareCapabilities.SelinaCapabilities.
	SleepSensingSupported bool `json:"sleepSensingSupported,omitempty"`

	// SmartspaceCrossDeviceTimerSupported: Whether the client supports
	// smart space cross-device timers. (go/ss-x-device-timer)
	SmartspaceCrossDeviceTimerSupported bool `json:"smartspaceCrossDeviceTimerSupported,omitempty"`

	// SoliGestureDetectionSupported: Whether or not the client supports
	// gesture detection via soli chips. The reason to prepend the name with
	// soli is to distinguish it from computer vision based methods, e.g.
	// Newman devices.
	SoliGestureDetectionSupported bool `json:"soliGestureDetectionSupported,omitempty"`

	// SuggestionsSupport: Suggestion chips features, supported by the
	// client.
	SuggestionsSupport *AssistantApiSuggestionsSupport `json:"suggestionsSupport,omitempty"`

	// SunriseFeaturesSupport: Whether the client supports the sunrise
	// screen brightening feature before the alarm fires. This is used to
	// indicate whether sunrise alarms can be set on the device.
	// http://cs/symbol:assistant.api.core_types.governed.RingtoneTaskMetadata.GentleWakeInfo
	SunriseFeaturesSupport *AssistantApiSunriseFeaturesSupport `json:"sunriseFeaturesSupport,omitempty"`

	// TapToReadOptimizationSupported: Whether the client supports faster
	// optimization for tap_to_read feature.
	TapToReadOptimizationSupported bool `json:"tapToReadOptimizationSupported,omitempty"`

	// ThirdPartyGuiSupported: Whether the device supports the 3p GUI
	// framework, which allows third parties to enter the conversation with
	// the user, showing their logo next to their chat bubbles, etc.
	// go/3p-phone
	ThirdPartyGuiSupported bool `json:"thirdPartyGuiSupported,omitempty"`

	// TransactionFeaturesSupport: Transactions features, supported by the
	// client. Transactions feature may includes how Transactions team want
	// to populate additional information from the device to the server.
	TransactionFeaturesSupport *AssistantApiTransactionFeaturesSupport `json:"transactionFeaturesSupport,omitempty"`

	// TransactionsVersion: The version of transactions which the client
	// supports.
	//
	// Possible values:
	//   "NO_TRANSACTIONS" - Transactions are not supported on this device.
	//   "TRANSACTIONS_INITIAL_LAUNCH" - This device supports the client
	// features present at the initial consumer launch of transactions.
	//   "TRANSACTIONS_V2" - This device supports the transaction version v2
	// client features, includes transactions clientops. Deprecated given
	// there're some iOS version populate this enum but don't support
	// clientops.
	//   "TRANSACTIONS_V3" - This device supports the transaction version v3
	// client features, includes transactions clientops.
	TransactionsVersion string `json:"transactionsVersion,omitempty"`

	// UsesSeparateFullViewer: If set, it indicates that the client can open
	// a separate HTML browser/webviewer (full viewer) to display certain
	// visual results. These visual results usually require more memory to
	// render (e.g. high resolution photos). Compared to the regular viewer
	// that display all other Assistant result, the full viewer does not
	// have memory limit. The field is copied from the device model. See
	// http://google3/assistant/devices_platform/proto/device_model_capabilities.proto?l=225&rcl=312576471
	// Also see go/webassistant-full-card-viewer.
	UsesSeparateFullViewer bool `json:"usesSeparateFullViewer,omitempty"`

	// ViewReminderHubPageNotSupported: Whether the client supports viewing
	// of reminder hub page or not. Default is supported. Set to true to
	// disable returning reminder hub page url in reminder responses.
	ViewReminderHubPageNotSupported bool `json:"viewReminderHubPageNotSupported,omitempty"`

	// WarmWelcomeTutorialSupported: Whether the client supports the
	// programmatic warm welcome tutorial. Design doc: go/opal-pww-design.
	WarmWelcomeTutorialSupported bool `json:"warmWelcomeTutorialSupported,omitempty"`

	// WebBrowserSupported: Whether the supports opening a URL in a web
	// browser. For example, we want to disable this for clients like Chirp.
	WebBrowserSupported bool `json:"webBrowserSupported,omitempty"`

	// WhatsNextSupported: Whether or not the client supports WhatsNext in
	// the protocol.
	WhatsNextSupported bool `json:"whatsNextSupported,omitempty"`

	// ZoomSupported: Whether the client supports joining a Zoom meeting.
	ZoomSupported bool `json:"zoomSupported,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AaeNotificationSourceSupported") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AaeNotificationSourceSupported") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSupportedFeatures) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSupportedFeatures
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSupportedProtocolVersion: Contains versions of protocol
// buffer messages. This is the equivalence of a proto3 map, keyed by a
// protocol buffer message’s name, and the value is the version of
// this message. e.g. {"assistant.api.core_types.Timer": 2,
// "assistant.api.core_types.Alarm": 1} See
// go/assistant-protocol-versioning for more details.
type AssistantApiSupportedProtocolVersion struct {
	MessageVersion []*AssistantApiSupportedProtocolVersionMessageVersionPair `json:"messageVersion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MessageVersion") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MessageVersion") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSupportedProtocolVersion) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSupportedProtocolVersion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AssistantApiSupportedProtocolVersionMessageVersionPair struct {
	// MessageName: The full path of a message which should start from the
	// package name. e.g. "assistant.api.core_types.Timer".
	MessageName string `json:"messageName,omitempty"`

	// Version: The supported version number.
	Version int64 `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MessageName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MessageName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSupportedProtocolVersionMessageVersionPair) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSupportedProtocolVersionMessageVersionPair
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSupportedProviderTypes: Types of providers that are
// supported by the client. For example, ChromeOS support both web app
// and Android app (for eligible devices).
type AssistantApiSupportedProviderTypes struct {
	// Possible values:
	//   "PROVIDER_TYPE_UNSPECIFIED"
	//   "ANDROID_APP" - For AndroidAppInfo
	//   "CAST_APP" - For CastAppInfo
	//   "CLOUD_PROVIDER" - For CloudProviderInfo
	//   "SIP_PROVIDER" - For SipProviderInfo
	//   "IOS_APP" - For IosAppInfo
	//   "INTERNAL_PROVIDER" - For InternalProviderInfo
	//   "WEB_PROVIDER" - For WebProviderInfo
	//   "KAIOS_APP" - For KaiOsAppInfo
	//   "HOME_APP" - For HomeAppInfo
	//   "CHROMEOS_APP" - For ChromeOsAppInfo
	SupportedTypes []string `json:"supportedTypes,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SupportedTypes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SupportedTypes") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSupportedProviderTypes) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSupportedProviderTypes
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSurfaceProperties: Properties of the surface that are not
// hardware related or feature specific.
type AssistantApiSurfaceProperties struct {
	ExecutionCapabilities *AssistantApiSurfacePropertiesExecutionCapabilities `json:"executionCapabilities,omitempty"`

	// PrefersGlanceableUi: Indicates if the surface prefers glanceable UI
	// when rendering Assistant response. (see
	// go/mobile-dr-hbird-glanceable-comms-cuj for more context).
	PrefersGlanceableUi bool `json:"prefersGlanceableUi,omitempty"`

	// ResponseDisplayFormat: If this field is unset, the response format is
	// unknown
	//
	// Possible values:
	//   "SINGLE_ITEM" - The surface can only show a single item (card,
	// display text, etc) of the response at a time. For example, if both a
	// display text and a card are sent in a response, the surface may only
	// show the card to the user.
	//   "MULTIPLE_ITEMS" - The surface can show a simple multi item
	// response (e.g. both a display text and a card), but can't show
	// response items from a previous response.
	//   "FULL_HISTORY" - The surface can show complex multi item responses
	// (e.g. display text, card, display text) as well as a history of
	// previous responses.
	ResponseDisplayFormat string `json:"responseDisplayFormat,omitempty"`

	// SupportsMultiResponse: If true, the client supports receiving
	// multiple responses. See go/multiple-response-in-media-use-cases for
	// more details.
	SupportsMultiResponse bool `json:"supportsMultiResponse,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ExecutionCapabilities") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExecutionCapabilities") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSurfaceProperties) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSurfaceProperties
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSurfacePropertiesExecutionCapabilities: Describes the
// capabilities that are related to the execution of client ops on the
// device.
type AssistantApiSurfacePropertiesExecutionCapabilities struct {
	// SupportsClientOpPreloading: Completes the preloading ie., sets up the
	// stage for the execution of client ops on the device while the
	// previous conv delta is being executed. Refer to go/preload-convdelta
	// for more information.
	SupportsClientOpPreloading bool `json:"supportsClientOpPreloading,omitempty"`

	// SupportsNonFinalizedResponses: A value of true indicates that the
	// client supports streaming of non-finalized responses by use of
	// ClientExecutionParams.response_stream_id. and
	// ClientExecutionParams.to_be_finalized.
	SupportsNonFinalizedResponses bool `json:"supportsNonFinalizedResponses,omitempty"`

	// SupportsNonMaterializedInteractions: If true, the client supports
	// receiving non-materialized interactions
	// (go/as-streaming-protocol-nm).
	SupportsNonMaterializedInteractions bool `json:"supportsNonMaterializedInteractions,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "SupportsClientOpPreloading") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "SupportsClientOpPreloading") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSurfacePropertiesExecutionCapabilities) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSurfacePropertiesExecutionCapabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSystemNotificationRestrictions: Restrictions related to
// system-level notifications.
type AssistantApiSystemNotificationRestrictions struct {
	CategoryState []*AssistantApiSystemNotificationRestrictionsNotificationCategoryState `json:"categoryState,omitempty"`

	ChannelState []*AssistantApiSystemNotificationRestrictionsNotificationChannelState `json:"channelState,omitempty"`

	// NotificationCapabilities: Specifies whether the surface is able to
	// display notifications.
	//
	// Possible values:
	//   "NO_NOTIFICATION_CAPABILITY" - The surface is not able to display
	// notifications.
	//   "NOTIFICATIONS_DISABLED" - The notifications are disabled on the
	// surface.
	//   "NOTIFICATIONS_ENABLED" - The notifications are enabled.
	NotificationCapabilities string `json:"notificationCapabilities,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CategoryState") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CategoryState") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AssistantApiSystemNotificationRestrictions) MarshalJSON() ([]byte, error) {
	type NoMethod AssistantApiSystemNotificationRestrictions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AssistantApiSystemNotificationRestrictionsNotificationCategoryState:
// Notification channels state for the new server driven channels.
type AssistantApiSystemNotificationRestrictionsNotificationCategoryState struct {
	// CategoryId: Notification channel type.
	CategoryId int64 `json:"categoryId,omitempty"`

	// Disabled: Weather the notifications on this channel are disabled.
	Disabled bool `json:"disabled,omitempty"`

	// Possible values:
	//   "NONE"
	//   "ASSISTANT_CATEGORY_SETTING" - The category was turned off in
	// Assistant Notification Settings.
	//   "ASSISTANT_OVERALL_SETTING" - All notifications for Assistant was
	// turned off in settings.
	//   "OS_APP_DISABLED" - All notifications for the Assistant (GSA) app
	// was turned off.
	//   "OS_CHANNEL_GROUP_DISABLED" - Notifications for the channel group
	// was turned off.
	//   "OS_CHANNEL_DISABLED" - Notifications for the channel was turned
	// off.
	DisabledReason string `json:"disabledReason,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CategoryId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CategoryId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (