// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamesparks

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateGame = "CreateGame"

// CreateGameRequest generates a "aws/request.Request" representing the
// client's request for the CreateGame operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGame for more information on using the CreateGame
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateGameRequest method.
//	req, resp := client.CreateGameRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/CreateGame
func (c *GameSparks) CreateGameRequest(input *CreateGameInput) (req *request.Request, output *CreateGameOutput) {
	op := &request.Operation{
		Name:       opCreateGame,
		HTTPMethod: "POST",
		HTTPPath:   "/game",
	}

	if input == nil {
		input = &CreateGameInput{}
	}

	output = &CreateGameOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGame API operation for GameSparks.
//
// Creates a new game with an empty configuration. After creating your game,
// you can update the configuration using UpdateGameConfiguration or ImportGameConfiguration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for GameSparks's
// API operation CreateGame for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ConflictException
//     The resource already exists, or another operation is in progress.
//
//   - InternalServerException
//     The service encountered an internal error.
//
//   - ServiceQuotaExceededException
//     The request would result in exceeding service quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/CreateGame
func (c *GameSparks) CreateGame(input *CreateGameInput) (*CreateGameOutput, error) {
	req, out := c.CreateGameRequest(input)
	return out, req.Send()
}

// CreateGameWithContext is the same as CreateGame with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGame for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) CreateGameWithContext(ctx aws.Context, input *CreateGameInput, opts ...request.Option) (*CreateGameOutput, error) {
	req, out := c.CreateGameRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSnapshot = "CreateSnapshot"

// CreateSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSnapshot for more information on using the CreateSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSnapshotRequest method.
//	req, resp := client.CreateSnapshotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/CreateSnapshot
func (c *GameSparks) CreateSnapshotRequest(input *CreateSnapshotInput) (req *request.Request, output *CreateSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/game/{GameName}/snapshot",
	}

	if input == nil {
		input = &CreateSnapshotInput{}
	}

	output = &CreateSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSnapshot API operation for GameSparks.
//
// Creates a snapshot of the game configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for GameSparks's
// API operation CreateSnapshot for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ConflictException
//     The resource already exists, or another operation is in progress.
//
//   - ResourceNotFoundException
//     The resource specified in the request does not exist.
//
//   - InternalServerException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/CreateSnapshot
func (c *GameSparks) CreateSnapshot(input *CreateSnapshotInput) (*CreateSnapshotOutput, error) {
	req, out := c.CreateSnapshotRequest(input)
	return out, req.Send()
}

// CreateSnapshotWithContext is the same as CreateSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) CreateSnapshotWithContext(ctx aws.Context, input *CreateSnapshotInput, opts ...request.Option) (*CreateSnapshotOutput, error) {
	req, out := c.CreateSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStage = "CreateStage"

// CreateStageRequest generates a "aws/request.Request" representing the
// client's request for the CreateStage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStage for more information on using the CreateStage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateStageRequest method.
//	req, resp := client.CreateStageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/CreateStage
func (c *GameSparks) CreateStageRequest(input *CreateStageInput) (req *request.Request, output *CreateStageOutput) {
	op := &request.Operation{
		Name:       opCreateStage,
		HTTPMethod: "POST",
		HTTPPath:   "/game/{GameName}/stage",
	}

	if input == nil {
		input = &CreateStageInput{}
	}

	output = &CreateStageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStage API operation for GameSparks.
//
// Creates a new stage for stage-by-stage game development and deployment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for GameSparks's
// API operation CreateStage for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ConflictException
//     The resource already exists, or another operation is in progress.
//
//   - ResourceNotFoundException
//     The resource specified in the request does not exist.
//
//   - InternalServerException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/CreateStage
func (c *GameSparks) CreateStage(input *CreateStageInput) (*CreateStageOutput, error) {
	req, out := c.CreateStageRequest(input)
	return out, req.Send()
}

// CreateStageWithContext is the same as CreateStage with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) CreateStageWithContext(ctx aws.Context, input *CreateStageInput, opts ...request.Option) (*CreateStageOutput, error) {
	req, out := c.CreateStageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGame = "DeleteGame"

// DeleteGameRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGame operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGame for more information on using the DeleteGame
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteGameRequest method.
//	req, resp := client.DeleteGameRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/DeleteGame
func (c *GameSparks) DeleteGameRequest(input *DeleteGameInput) (req *request.Request, output *DeleteGameOutput) {
	op := &request.Operation{
		Name:       opDeleteGame,
		HTTPMethod: "DELETE",
		HTTPPath:   "/game/{GameName}",
	}

	if input == nil {
		input = &DeleteGameInput{}
	}

	output = &DeleteGameOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteGame API operation for GameSparks.
//
// Deletes a game.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for GameSparks's
// API operation DeleteGame for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ConflictException
//     The resource already exists, or another operation is in progress.
//
//   - InternalServerException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/DeleteGame
func (c *GameSparks) DeleteGame(input *DeleteGameInput) (*DeleteGameOutput, error) {
	req, out := c.DeleteGameRequest(input)
	return out, req.Send()
}

// DeleteGameWithContext is the same as DeleteGame with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGame for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) DeleteGameWithContext(ctx aws.Context, input *DeleteGameInput, opts ...request.Option) (*DeleteGameOutput, error) {
	req, out := c.DeleteGameRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStage = "DeleteStage"

// DeleteStageRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStage for more information on using the DeleteStage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteStageRequest method.
//	req, resp := client.DeleteStageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/DeleteStage
func (c *GameSparks) DeleteStageRequest(input *DeleteStageInput) (req *request.Request, output *DeleteStageOutput) {
	op := &request.Operation{
		Name:       opDeleteStage,
		HTTPMethod: "DELETE",
		HTTPPath:   "/game/{GameName}/stage/{StageName}",
	}

	if input == nil {
		input = &DeleteStageInput{}
	}

	output = &DeleteStageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteStage API operation for GameSparks.
//
// Deletes a stage from a game, along with the associated game runtime.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for GameSparks's
// API operation DeleteStage for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ConflictException
//     The resource already exists, or another operation is in progress.
//
//   - ResourceNotFoundException
//     The resource specified in the request does not exist.
//
//   - InternalServerException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/DeleteStage
func (c *GameSparks) DeleteStage(input *DeleteStageInput) (*DeleteStageOutput, error) {
	req, out := c.DeleteStageRequest(input)
	return out, req.Send()
}

// DeleteStageWithContext is the same as DeleteStage with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) DeleteStageWithContext(ctx aws.Context, input *DeleteStageInput, opts ...request.Option) (*DeleteStageOutput, error) {
	req, out := c.DeleteStageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisconnectPlayer = "DisconnectPlayer"

// DisconnectPlayerRequest generates a "aws/request.Request" representing the
// client's request for the DisconnectPlayer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisconnectPlayer for more information on using the DisconnectPlayer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisconnectPlayerRequest method.
//	req, resp := client.DisconnectPlayerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/DisconnectPlayer
func (c *GameSparks) DisconnectPlayerRequest(input *DisconnectPlayerInput) (req *request.Request, output *DisconnectPlayerOutput) {
	op := &request.Operation{
		Name:       opDisconnectPlayer,
		HTTPMethod: "POST",
		HTTPPath:   "/runtime/game/{GameName}/stage/{StageName}/player/{PlayerId}/disconnect",
	}

	if input == nil {
		input = &DisconnectPlayerInput{}
	}

	output = &DisconnectPlayerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisconnectPlayer API operation for GameSparks.
//
// Disconnects a player from the game runtime.
//
// If a player has multiple connections, this operation attempts to close all
// of them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for GameSparks's
// API operation DisconnectPlayer for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ResourceNotFoundException
//     The resource specified in the request does not exist.
//
//   - InternalServerException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/DisconnectPlayer
func (c *GameSparks) DisconnectPlayer(input *DisconnectPlayerInput) (*DisconnectPlayerOutput, error) {
	req, out := c.DisconnectPlayerRequest(input)
	return out, req.Send()
}

// DisconnectPlayerWithContext is the same as DisconnectPlayer with the addition of
// the ability to pass a context and additional request options.
//
// See DisconnectPlayer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) DisconnectPlayerWithContext(ctx aws.Context, input *DisconnectPlayerInput, opts ...request.Option) (*DisconnectPlayerOutput, error) {
	req, out := c.DisconnectPlayerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExportSnapshot = "ExportSnapshot"

// ExportSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the ExportSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExportSnapshot for more information on using the ExportSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ExportSnapshotRequest method.
//	req, resp := client.ExportSnapshotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ExportSnapshot
func (c *GameSparks) ExportSnapshotRequest(input *ExportSnapshotInput) (req *request.Request, output *ExportSnapshotOutput) {
	op := &request.Operation{
		Name:       opExportSnapshot,
		HTTPMethod: "GET",
		HTTPPath:   "/game/{GameName}/snapshot/{SnapshotId}/export",
	}

	if input == nil {
		input = &ExportSnapshotInput{}
	}

	output = &ExportSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExportSnapshot API operation for GameSparks.
//
// Exports a game configuration snapshot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for GameSparks's
// API operation ExportSnapshot for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ResourceNotFoundException
//     The resource specified in the request does not exist.
//
//   - InternalServerException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ExportSnapshot
func (c *GameSparks) ExportSnapshot(input *ExportSnapshotInput) (*ExportSnapshotOutput, error) {
	req, out := c.ExportSnapshotRequest(input)
	return out, req.Send()
}

// ExportSnapshotWithContext is the same as ExportSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See ExportSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) ExportSnapshotWithContext(ctx aws.Context, input *ExportSnapshotInput, opts ...request.Option) (*ExportSnapshotOutput, error) {
	req, out := c.ExportSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetExtension = "GetExtension"

// GetExtensionRequest generates a "aws/request.Request" representing the
// client's request for the GetExtension operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetExtension for more information on using the GetExtension
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetExtensionRequest method.
//	req, resp := client.GetExtensionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetExtension
func (c *GameSparks) GetExtensionRequest(input *GetExtensionInput) (req *request.Request, output *GetExtensionOutput) {
	op := &request.Operation{
		Name:       opGetExtension,
		HTTPMethod: "GET",
		HTTPPath:   "/extension/{Namespace}/{Name}",
	}

	if input == nil {
		input = &GetExtensionInput{}
	}

	output = &GetExtensionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetExtension API operation for GameSparks.
//
// Gets details about a specified extension.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for GameSparks's
// API operation GetExtension for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ResourceNotFoundException
//     The resource specified in the request does not exist.
//
//   - InternalServerException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetExtension
func (c *GameSparks) GetExtension(input *GetExtensionInput) (*GetExtensionOutput, error) {
	req, out := c.GetExtensionRequest(input)
	return out, req.Send()
}

// GetExtensionWithContext is the same as GetExtension with the addition of
// the ability to pass a context and additional request options.
//
// See GetExtension for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) GetExtensionWithContext(ctx aws.Context, input *GetExtensionInput, opts ...request.Option) (*GetExtensionOutput, error) {
	req, out := c.GetExtensionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetExtensionVersion = "GetExtensionVersion"

// GetExtensionVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetExtensionVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetExtensionVersion for more information on using the GetExtensionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetExtensionVersionRequest method.
//	req, resp := client.GetExtensionVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetExtensionVersion
func (c *GameSparks) GetExtensionVersionRequest(input *GetExtensionVersionInput) (req *request.Request, output *GetExtensionVersionOutput) {
	op := &request.Operation{
		Name:       opGetExtensionVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/extension/{Namespace}/{Name}/version/{ExtensionVersion}",
	}

	if input == nil {
		input = &GetExtensionVersionInput{}
	}

	output = &GetExtensionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetExtensionVersion API operation for GameSparks.
//
// Gets details about a specified extension version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for GameSparks's
// API operation GetExtensionVersion for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ResourceNotFoundException
//     The resource specified in the request does not exist.
//
//   - InternalServerException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetExtensionVersion
func (c *GameSparks) GetExtensionVersion(input *GetExtensionVersionInput) (*GetExtensionVersionOutput, error) {
	req, out := c.GetExtensionVersionRequest(input)
	return out, req.Send()
}

// GetExtensionVersionWithContext is the same as GetExtensionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetExtensionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) GetExtensionVersionWithContext(ctx aws.Context, input *GetExtensionVersionInput, opts ...request.Option) (*GetExtensionVersionOutput, error) {
	req, out := c.GetExtensionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGame = "GetGame"

// GetGameRequest generates a "aws/request.Request" representing the
// client's request for the GetGame operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGame for more information on using the GetGame
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetGameRequest method.
//	req, resp := client.GetGameRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetGame
func (c *GameSparks) GetGameRequest(input *GetGameInput) (req *request.Request, output *GetGameOutput) {
	op := &request.Operation{
		Name:       opGetGame,
		HTTPMethod: "GET",
		HTTPPath:   "/game/{GameName}",
	}

	if input == nil {
		input = &GetGameInput{}
	}

	output = &GetGameOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGame API operation for GameSparks.
//
// Gets details about a game.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for GameSparks's
// API operation GetGame for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ResourceNotFoundException
//     The resource specified in the request does not exist.
//
//   - InternalServerException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetGame
func (c *GameSparks) GetGame(input *GetGameInput) (*GetGameOutput, error) {
	req, out := c.GetGameRequest(input)
	return out, req.Send()
}

// GetGameWithContext is the same as GetGame with the addition of
// the ability to pass a context and additional request options.
//
// See GetGame for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) GetGameWithContext(ctx aws.Context, input *GetGameInput, opts ...request.Option) (*GetGameOutput, error) {
	req, out := c.GetGameRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGameConfiguration = "GetGameConfiguration"

// GetGameConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetGameConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGameConfiguration for more information on using the GetGameConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetGameConfigurationRequest method.
//	req, resp := client.GetGameConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetGameConfiguration
func (c *GameSparks) GetGameConfigurationRequest(input *GetGameConfigurationInput) (req *request.Request, output *GetGameConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetGameConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/game/{GameName}/configuration",
	}

	if input == nil {
		input = &GetGameConfigurationInput{}
	}

	output = &GetGameConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGameConfiguration API operation for GameSparks.
//
// Gets the configuration of the game.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for GameSparks's
// API operation GetGameConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ResourceNotFoundException
//     The resource specified in the request does not exist.
//
//   - InternalServerException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetGameConfiguration
func (c *GameSparks) GetGameConfiguration(input *GetGameConfigurationInput) (*GetGameConfigurationOutput, error) {
	req, out := c.GetGameConfigurationRequest(input)
	return out, req.Send()
}

// GetGameConfigurationWithContext is the same as GetGameConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetGameConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) GetGameConfigurationWithContext(ctx aws.Context, input *GetGameConfigurationInput, opts ...request.Option) (*GetGameConfigurationOutput, error) {
	req, out := c.GetGameConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGeneratedCodeJob = "GetGeneratedCodeJob"

// GetGeneratedCodeJobRequest generates a "aws/request.Request" representing the
// client's request for the GetGeneratedCodeJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGeneratedCodeJob for more information on using the GetGeneratedCodeJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetGeneratedCodeJobRequest method.
//	req, resp := client.GetGeneratedCodeJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetGeneratedCodeJob
func (c *GameSparks) GetGeneratedCodeJobRequest(input *GetGeneratedCodeJobInput) (req *request.Request, output *GetGeneratedCodeJobOutput) {
	op := &request.Operation{
		Name:       opGetGeneratedCodeJob,
		HTTPMethod: "GET",
		HTTPPath:   "/game/{GameName}/snapshot/{SnapshotId}/generated-sdk-code-job/{JobId}",
	}

	if input == nil {
		input = &GetGeneratedCodeJobInput{}
	}

	output = &GetGeneratedCodeJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGeneratedCodeJob API operation for GameSparks.
//
// Gets details about a job that is generating code for a snapshot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for GameSparks's
// API operation GetGeneratedCodeJob for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ResourceNotFoundException
//     The resource specified in the request does not exist.
//
//   - InternalServerException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetGeneratedCodeJob
func (c *GameSparks) GetGeneratedCodeJob(input *GetGeneratedCodeJobInput) (*GetGeneratedCodeJobOutput, error) {
	req, out := c.GetGeneratedCodeJobRequest(input)
	return out, req.Send()
}

// GetGeneratedCodeJobWithContext is the same as GetGeneratedCodeJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetGeneratedCodeJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) GetGeneratedCodeJobWithContext(ctx aws.Context, input *GetGeneratedCodeJobInput, opts ...request.Option) (*GetGeneratedCodeJobOutput, error) {
	req, out := c.GetGeneratedCodeJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPlayerConnectionStatus = "GetPlayerConnectionStatus"

// GetPlayerConnectionStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetPlayerConnectionStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPlayerConnectionStatus for more information on using the GetPlayerConnectionStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPlayerConnectionStatusRequest method.
//	req, resp := client.GetPlayerConnectionStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetPlayerConnectionStatus
func (c *GameSparks) GetPlayerConnectionStatusRequest(input *GetPlayerConnectionStatusInput) (req *request.Request, output *GetPlayerConnectionStatusOutput) {
	op := &request.Operation{
		Name:       opGetPlayerConnectionStatus,
		HTTPMethod: "GET",
		HTTPPath:   "/runtime/game/{GameName}/stage/{StageName}/player/{PlayerId}/connection",
	}

	if input == nil {
		input = &GetPlayerConnectionStatusInput{}
	}

	output = &GetPlayerConnectionStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPlayerConnectionStatus API operation for GameSparks.
//
// Gets the status of a player's connection to the game runtime.
//
// It's possible for a single player to have multiple connections to the game
// runtime. If a player is not connected, this operation returns an empty list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for GameSparks's
// API operation GetPlayerConnectionStatus for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ResourceNotFoundException
//     The resource specified in the request does not exist.
//
//   - InternalServerException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetPlayerConnectionStatus
func (c *GameSparks) GetPlayerConnectionStatus(input *GetPlayerConnectionStatusInput) (*GetPlayerConnectionStatusOutput, error) {
	req, out := c.GetPlayerConnectionStatusRequest(input)
	return out, req.Send()
}

// GetPlayerConnectionStatusWithContext is the same as GetPlayerConnectionStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetPlayerConnectionStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) GetPlayerConnectionStatusWithContext(ctx aws.Context, input *GetPlayerConnectionStatusInput, opts ...request.Option) (*GetPlayerConnectionStatusOutput, error) {
	req, out := c.GetPlayerConnectionStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSnapshot = "GetSnapshot"

// GetSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the GetSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSnapshot for more information on using the GetSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSnapshotRequest method.
//	req, resp := client.GetSnapshotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetSnapshot
func (c *GameSparks) GetSnapshotRequest(input *GetSnapshotInput) (req *request.Request, output *GetSnapshotOutput) {
	op := &request.Operation{
		Name:       opGetSnapshot,
		HTTPMethod: "GET",
		HTTPPath:   "/game/{GameName}/snapshot/{SnapshotId}",
	}

	if input == nil {
		input = &GetSnapshotInput{}
	}

	output = &GetSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSnapshot API operation for GameSparks.
//
// Gets a copy of the game configuration in a snapshot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for GameSparks's
// API operation GetSnapshot for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ResourceNotFoundException
//     The resource specified in the request does not exist.
//
//   - InternalServerException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetSnapshot
func (c *GameSparks) GetSnapshot(input *GetSnapshotInput) (*GetSnapshotOutput, error) {
	req, out := c.GetSnapshotRequest(input)
	return out, req.Send()
}

// GetSnapshotWithContext is the same as GetSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See GetSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) GetSnapshotWithContext(ctx aws.Context, input *GetSnapshotInput, opts ...request.Option) (*GetSnapshotOutput, error) {
	req, out := c.GetSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStage = "GetStage"

// GetStageRequest generates a "aws/request.Request" representing the
// client's request for the GetStage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStage for more information on using the GetStage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetStageRequest method.
//	req, resp := client.GetStageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetStage
func (c *GameSparks) GetStageRequest(input *GetStageInput) (req *request.Request, output *GetStageOutput) {
	op := &request.Operation{
		Name:       opGetStage,
		HTTPMethod: "GET",
		HTTPPath:   "/game/{GameName}/stage/{StageName}",
	}

	if input == nil {
		input = &GetStageInput{}
	}

	output = &GetStageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStage API operation for GameSparks.
//
// Gets information about a stage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for GameSparks's
// API operation GetStage for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ResourceNotFoundException
//     The resource specified in the request does not exist.
//
//   - InternalServerException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetStage
func (c *GameSparks) GetStage(input *GetStageInput) (*GetStageOutput, error) {
	req, out := c.GetStageRequest(input)
	return out, req.Send()
}

// GetStageWithContext is the same as GetStage with the addition of
// the ability to pass a context and additional request options.
//
// See GetStage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) GetStageWithContext(ctx aws.Context, input *GetStageInput, opts ...request.Option) (*GetStageOutput, error) {
	req, out := c.GetStageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStageDeployment = "GetStageDeployment"

// GetStageDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the GetStageDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStageDeployment for more information on using the GetStageDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetStageDeploymentRequest method.
//	req, resp := client.GetStageDeploymentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetStageDeployment
func (c *GameSparks) GetStageDeploymentRequest(input *GetStageDeploymentInput) (req *request.Request, output *GetStageDeploymentOutput) {
	op := &request.Operation{
		Name:       opGetStageDeployment,
		HTTPMethod: "GET",
		HTTPPath:   "/game/{GameName}/stage/{StageName}/deployment",
	}

	if input == nil {
		input = &GetStageDeploymentInput{}
	}

	output = &GetStageDeploymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStageDeployment API operation for GameSparks.
//
// Gets information about a stage deployment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for GameSparks's
// API operation GetStageDeployment for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ResourceNotFoundException
//     The resource specified in the request does not exist.
//
//   - InternalServerException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetStageDeployment
func (c *GameSparks) GetStageDeployment(input *GetStageDeploymentInput) (*GetStageDeploymentOutput, error) {
	req, out := c.GetStageDeploymentRequest(input)
	return out, req.Send()
}

// GetStageDeploymentWithContext is the same as GetStageDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See GetStageDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) GetStageDeploymentWithContext(ctx aws.Context, input *GetStageDeploymentInput, opts ...request.Option) (*GetStageDeploymentOutput, error) {
	req, out := c.GetStageDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportGameConfiguration = "ImportGameConfiguration"

// ImportGameConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the ImportGameConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportGameConfiguration for more information on using the ImportGameConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ImportGameConfigurationRequest method.
//	req, resp := client.ImportGameConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ImportGameConfiguration
func (c *GameSparks) ImportGameConfigurationRequest(input *ImportGameConfigurationInput) (req *request.Request, output *ImportGameConfigurationOutput) {
	op := &request.Operation{
		Name:       opImportGameConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/game/{GameName}/configuration",
	}

	if input == nil {
		input = &ImportGameConfigurationInput{}
	}

	output = &ImportGameConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportGameConfiguration API operation for GameSparks.
//
// Imports a game configuration.
//
// This operation replaces the current configuration of the game with the provided
// input. This is not a reversible operation. If you want to preserve the previous
// configuration, use CreateSnapshot to make a new snapshot before importing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for GameSparks's
// API operation ImportGameConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ResourceNotFoundException
//     The resource specified in the request does not exist.
//
//   - InternalServerException
//     The service encountered an internal error.
//
//   - ServiceQuotaExceededException
//     The request would result in exceeding service quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ImportGameConfiguration
func (c *GameSparks) ImportGameConfiguration(input *ImportGameConfigurationInput) (*ImportGameConfigurationOutput, error) {
	req, out := c.ImportGameConfigurationRequest(input)
	return out, req.Send()
}

// ImportGameConfigurationWithContext is the same as ImportGameConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See ImportGameConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) ImportGameConfigurationWithContext(ctx aws.Context, input *ImportGameConfigurationInput, opts ...request.Option) (*ImportGameConfigurationOutput, error) {
	req, out := c.ImportGameConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListExtensionVersions = "ListExtensionVersions"

// ListExtensionVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListExtensionVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListExtensionVersions for more information on using the ListExtensionVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListExtensionVersionsRequest method.
//	req, resp := client.ListExtensionVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListExtensionVersions
func (c *GameSparks) ListExtensionVersionsRequest(input *ListExtensionVersionsInput) (req *request.Request, output *ListExtensionVersionsOutput) {
	op := &request.Operation{
		Name:       opListExtensionVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/extension/{Namespace}/{Name}/version",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListExtensionVersionsInput{}
	}

	output = &ListExtensionVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListExtensionVersions API operation for GameSparks.
//
// Gets a paginated list of available versions for the extension.
//
// Each time an API change is made to an extension, the version is incremented.
// The list retrieved by this operation shows the versions that are currently
// available.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for GameSparks's
// API operation ListExtensionVersions for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ResourceNotFoundException
//     The resource specified in the request does not exist.
//
//   - InternalServerException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListExtensionVersions
func (c *GameSparks) ListExtensionVersions(input *ListExtensionVersionsInput) (*ListExtensionVersionsOutput, error) {
	req, out := c.ListExtensionVersionsRequest(input)
	return out, req.Send()
}

// ListExtensionVersionsWithContext is the same as ListExtensionVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListExtensionVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) ListExtensionVersionsWithContext(ctx aws.Context, input *ListExtensionVersionsInput, opts ...request.Option) (*ListExtensionVersionsOutput, error) {
	req, out := c.ListExtensionVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListExtensionVersionsPages iterates over the pages of a ListExtensionVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListExtensionVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListExtensionVersions operation.
//	pageNum := 0
//	err := client.ListExtensionVersionsPages(params,
//	    func(page *gamesparks.ListExtensionVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GameSparks) ListExtensionVersionsPages(input *ListExtensionVersionsInput, fn func(*ListExtensionVersionsOutput, bool) bool) error {
	return c.ListExtensionVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListExtensionVersionsPagesWithContext same as ListExtensionVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) ListExtensionVersionsPagesWithContext(ctx aws.Context, input *ListExtensionVersionsInput, fn func(*ListExtensionVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListExtensionVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListExtensionVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListExtensionVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListExtensions = "ListExtensions"

// ListExtensionsRequest generates a "aws/request.Request" representing the
// client's request for the ListExtensions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListExtensions for more information on using the ListExtensions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListExtensionsRequest method.
//	req, resp := client.ListExtensionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListExtensions
func (c *GameSparks) ListExtensionsRequest(input *ListExtensionsInput) (req *request.Request, output *ListExtensionsOutput) {
	op := &request.Operation{
		Name:       opListExtensions,
		HTTPMethod: "GET",
		HTTPPath:   "/extension",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListExtensionsInput{}
	}

	output = &ListExtensionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListExtensions API operation for GameSparks.
//
// Gets a paginated list of available extensions.
//
// Extensions provide features that games can use from scripts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for GameSparks's
// API operation ListExtensions for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - InternalServerException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListExtensions
func (c *GameSparks) ListExtensions(input *ListExtensionsInput) (*ListExtensionsOutput, error) {
	req, out := c.ListExtensionsRequest(input)
	return out, req.Send()
}

// ListExtensionsWithContext is the same as ListExtensions with the addition of
// the ability to pass a context and additional request options.
//
// See ListExtensions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) ListExtensionsWithContext(ctx aws.Context, input *ListExtensionsInput, opts ...request.Option) (*ListExtensionsOutput, error) {
	req, out := c.ListExtensionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListExtensionsPages iterates over the pages of a ListExtensions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListExtensions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListExtensions operation.
//	pageNum := 0
//	err := client.ListExtensionsPages(params,
//	    func(page *gamesparks.ListExtensionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GameSparks) ListExtensionsPages(input *ListExtensionsInput, fn func(*ListExtensionsOutput, bool) bool) error {
	return c.ListExtensionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListExtensionsPagesWithContext same as ListExtensionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) ListExtensionsPagesWithContext(ctx aws.Context, input *ListExtensionsInput, fn func(*ListExtensionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListExtensionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListExtensionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListExtensionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListGames = "ListGames"

// ListGamesRequest generates a "aws/request.Request" representing the
// client's request for the ListGames operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGames for more information on using the ListGames
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListGamesRequest method.
//	req, resp := client.ListGamesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListGames
func (c *GameSparks) ListGamesRequest(input *ListGamesInput) (req *request.Request, output *ListGamesOutput) {
	op := &request.Operation{
		Name:       opListGames,
		HTTPMethod: "GET",
		HTTPPath:   "/game",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGamesInput{}
	}

	output = &ListGamesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGames API operation for GameSparks.
//
// Gets a paginated list of games.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for GameSparks's
// API operation ListGames for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - InternalServerException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListGames
func (c *GameSparks) ListGames(input *ListGamesInput) (*ListGamesOutput, error) {
	req, out := c.ListGamesRequest(input)
	return out, req.Send()
}

// ListGamesWithContext is the same as ListGames with the addition of
// the ability to pass a context and additional request options.
//
// See ListGames for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) ListGamesWithContext(ctx aws.Context, input *ListGamesInput, opts ...request.Option) (*ListGamesOutput, error) {
	req, out := c.ListGamesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGamesPages iterates over the pages of a ListGames operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGames method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListGames operation.
//	pageNum := 0
//	err := client.ListGamesPages(params,
//	    func(page *gamesparks.ListGamesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GameSparks) ListGamesPages(input *ListGamesInput, fn func(*ListGamesOutput, bool) bool) error {
	return c.ListGamesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGamesPagesWithContext same as ListGamesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) ListGamesPagesWithContext(ctx aws.Context, input *ListGamesInput, fn func(*ListGamesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGamesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGamesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGamesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListGeneratedCodeJobs = "ListGeneratedCodeJobs"

// ListGeneratedCodeJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListGeneratedCodeJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGeneratedCodeJobs for more information on using the ListGeneratedCodeJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListGeneratedCodeJobsRequest method.
//	req, resp := client.ListGeneratedCodeJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListGeneratedCodeJobs
func (c *GameSparks) ListGeneratedCodeJobsRequest(input *ListGeneratedCodeJobsInput) (req *request.Request, output *ListGeneratedCodeJobsOutput) {
	op := &request.Operation{
		Name:       opListGeneratedCodeJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/game/{GameName}/snapshot/{SnapshotId}/generated-sdk-code-jobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGeneratedCodeJobsInput{}
	}

	output = &ListGeneratedCodeJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGeneratedCodeJobs API operation for GameSparks.
//
// Gets a paginated list of code generation jobs for a snapshot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for GameSparks's
// API operation ListGeneratedCodeJobs for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ResourceNotFoundException
//     The resource specified in the request does not exist.
//
//   - InternalServerException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListGeneratedCodeJobs
func (c *GameSparks) ListGeneratedCodeJobs(input *ListGeneratedCodeJobsInput) (*ListGeneratedCodeJobsOutput, error) {
	req, out := c.ListGeneratedCodeJobsRequest(input)
	return out, req.Send()
}

// ListGeneratedCodeJobsWithContext is the same as ListGeneratedCodeJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListGeneratedCodeJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) ListGeneratedCodeJobsWithContext(ctx aws.Context, input *ListGeneratedCodeJobsInput, opts ...request.Option) (*ListGeneratedCodeJobsOutput, error) {
	req, out := c.ListGeneratedCodeJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGeneratedCodeJobsPages iterates over the pages of a ListGeneratedCodeJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGeneratedCodeJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListGeneratedCodeJobs operation.
//	pageNum := 0
//	err := client.ListGeneratedCodeJobsPages(params,
//	    func(page *gamesparks.ListGeneratedCodeJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GameSparks) ListGeneratedCodeJobsPages(input *ListGeneratedCodeJobsInput, fn func(*ListGeneratedCodeJobsOutput, bool) bool) error {
	return c.ListGeneratedCodeJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGeneratedCodeJobsPagesWithContext same as ListGeneratedCodeJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) ListGeneratedCodeJobsPagesWithContext(ctx aws.Context, input *ListGeneratedCodeJobsInput, fn func(*ListGeneratedCodeJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGeneratedCodeJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGeneratedCodeJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGeneratedCodeJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSnapshots = "ListSnapshots"

// ListSnapshotsRequest generates a "aws/request.Request" representing the
// client's request for the ListSnapshots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSnapshots for more information on using the ListSnapshots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSnapshotsRequest method.
//	req, resp := client.ListSnapshotsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListSnapshots
func (c *GameSparks) ListSnapshotsRequest(input *ListSnapshotsInput) (req *request.Request, output *ListSnapshotsOutput) {
	op := &request.Operation{
		Name:       opListSnapshots,
		HTTPMethod: "GET",
		HTTPPath:   "/game/{GameName}/snapshot",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSnapshotsInput{}
	}

	output = &ListSnapshotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSnapshots API operation for GameSparks.
//
// Gets a paginated list of snapshot summaries from the game.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for GameSparks's
// API operation ListSnapshots for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ResourceNotFoundException
//     The resource specified in the request does not exist.
//
//   - InternalServerException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListSnapshots
func (c *GameSparks) ListSnapshots(input *ListSnapshotsInput) (*ListSnapshotsOutput, error) {
	req, out := c.ListSnapshotsRequest(input)
	return out, req.Send()
}

// ListSnapshotsWithContext is the same as ListSnapshots with the addition of
// the ability to pass a context and additional request options.
//
// See ListSnapshots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) ListSnapshotsWithContext(ctx aws.Context, input *ListSnapshotsInput, opts ...request.Option) (*ListSnapshotsOutput, error) {
	req, out := c.ListSnapshotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSnapshotsPages iterates over the pages of a ListSnapshots operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSnapshots method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSnapshots operation.
//	pageNum := 0
//	err := client.ListSnapshotsPages(params,
//	    func(page *gamesparks.ListSnapshotsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GameSparks) ListSnapshotsPages(input *ListSnapshotsInput, fn func(*ListSnapshotsOutput, bool) bool) error {
	return c.ListSnapshotsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSnapshotsPagesWithContext same as ListSnapshotsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) ListSnapshotsPagesWithContext(ctx aws.Context, input *ListSnapshotsInput, fn func(*ListSnapshotsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSnapshotsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSnapshotsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSnapshotsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStageDeployments = "ListStageDeployments"

// ListStageDeploymentsRequest generates a "aws/request.Request" representing the
// client's request for the ListStageDeployments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStageDeployments for more information on using the ListStageDeployments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStageDeploymentsRequest method.
//	req, resp := client.ListStageDeploymentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListStageDeployments
func (c *GameSparks) ListStageDeploymentsRequest(input *ListStageDeploymentsInput) (req *request.Request, output *ListStageDeploymentsOutput) {
	op := &request.Operation{
		Name:       opListStageDeployments,
		HTTPMethod: "GET",
		HTTPPath:   "/game/{GameName}/stage/{StageName}/deployments",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStageDeploymentsInput{}
	}

	output = &ListStageDeploymentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStageDeployments API operation for GameSparks.
//
// Gets a paginated list of stage deployment summaries from the game.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for GameSparks's
// API operation ListStageDeployments for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ResourceNotFoundException
//     The resource specified in the request does not exist.
//
//   - InternalServerException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListStageDeployments
func (c *GameSparks) ListStageDeployments(input *ListStageDeploymentsInput) (*ListStageDeploymentsOutput, error) {
	req, out := c.ListStageDeploymentsRequest(input)
	return out, req.Send()
}

// ListStageDeploymentsWithContext is the same as ListStageDeployments with the addition of
// the ability to pass a context and additional request options.
//
// See ListStageDeployments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) ListStageDeploymentsWithContext(ctx aws.Context, input *ListStageDeploymentsInput, opts ...request.Option) (*ListStageDeploymentsOutput, error) {
	req, out := c.ListStageDeploymentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStageDeploymentsPages iterates over the pages of a ListStageDeployments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStageDeployments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStageDeployments operation.
//	pageNum := 0
//	err := client.ListStageDeploymentsPages(params,
//	    func(page *gamesparks.ListStageDeploymentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GameSparks) ListStageDeploymentsPages(input *ListStageDeploymentsInput, fn func(*ListStageDeploymentsOutput, bool) bool) error {
	return c.ListStageDeploymentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStageDeploymentsPagesWithContext same as ListStageDeploymentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) ListStageDeploymentsPagesWithContext(ctx aws.Context, input *ListStageDeploymentsInput, fn func(*ListStageDeploymentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStageDeploymentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStageDeploymentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStageDeploymentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStages = "ListStages"

// ListStagesRequest generates a "aws/request.Request" representing the
// client's request for the ListStages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStages for more information on using the ListStages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStagesRequest method.
//	req, resp := client.ListStagesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListStages
func (c *GameSparks) ListStagesRequest(input *ListStagesInput) (req *request.Request, output *ListStagesOutput) {
	op := &request.Operation{
		Name:       opListStages,
		HTTPMethod: "GET",
		HTTPPath:   "/game/{GameName}/stage",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStagesInput{}
	}

	output = &ListStagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStages API operation for GameSparks.
//
// Gets a paginated list of stage summaries from the game.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for GameSparks's
// API operation ListStages for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ResourceNotFoundException
//     The resource specified in the request does not exist.
//
//   - InternalServerException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListStages
func (c *GameSparks) ListStages(input *ListStagesInput) (*ListStagesOutput, error) {
	req, out := c.ListStagesRequest(input)
	return out, req.Send()
}

// ListStagesWithContext is the same as ListStages with the addition of
// the ability to pass a context and additional request options.
//
// See ListStages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) ListStagesWithContext(ctx aws.Context, input *ListStagesInput, opts ...request.Option) (*ListStagesOutput, error) {
	req, out := c.ListStagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStagesPages iterates over the pages of a ListStages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStages operation.
//	pageNum := 0
//	err := client.ListStagesPages(params,
//	    func(page *gamesparks.ListStagesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GameSparks) ListStagesPages(input *ListStagesInput, fn func(*ListStagesOutput, bool) bool) error {
	return c.ListStagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStagesPagesWithContext same as ListStagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) ListStagesPagesWithContext(ctx aws.Context, input *ListStagesInput, fn func(*ListStagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStagesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListTagsForResource
func (c *GameSparks) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for GameSparks.
//
// Lists the tags associated with a GameSparks resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for GameSparks's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - ResourceNotFoundException
//     The resource specified in the request does not exist.
//
//   - InternalServerException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListTagsForResource
func (c *GameSparks) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartGeneratedCodeJob = "StartGeneratedCodeJob"

// StartGeneratedCodeJobRequest generates a "aws/request.Request" representing the
// client's request for the StartGeneratedCodeJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartGeneratedCodeJob for more information on using the StartGeneratedCodeJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartGeneratedCodeJobRequest method.
//	req, resp := client.StartGeneratedCodeJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/StartGeneratedCodeJob
func (c *GameSparks) StartGeneratedCodeJobRequest(input *StartGeneratedCodeJobInput) (req *request.Request, output *StartGeneratedCodeJobOutput) {
	op := &request.Operation{
		Name:       opStartGeneratedCodeJob,
		HTTPMethod: "POST",
		HTTPPath:   "/game/{GameName}/snapshot/{SnapshotId}/generated-sdk-code-job",
	}

	if input == nil {
		input = &StartGeneratedCodeJobInput{}
	}

	output = &StartGeneratedCodeJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartGeneratedCodeJob API operation for GameSparks.
//
// Starts an asynchronous process that generates client code for system-defined
// and custom messages. The resulting code is collected as a .zip file and uploaded
// to a pre-signed Amazon S3 URL.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for GameSparks's
// API operation StartGeneratedCodeJob for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ResourceNotFoundException
//     The resource specified in the request does not exist.
//
//   - InternalServerException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/StartGeneratedCodeJob
func (c *GameSparks) StartGeneratedCodeJob(input *StartGeneratedCodeJobInput) (*StartGeneratedCodeJobOutput, error) {
	req, out := c.StartGeneratedCodeJobRequest(input)
	return out, req.Send()
}

// StartGeneratedCodeJobWithContext is the same as StartGeneratedCodeJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartGeneratedCodeJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) StartGeneratedCodeJobWithContext(ctx aws.Context, input *StartGeneratedCodeJobInput, opts ...request.Option) (*StartGeneratedCodeJobOutput, error) {
	req, out := c.StartGeneratedCodeJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartStageDeployment = "StartStageDeployment"

// StartStageDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the StartStageDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartStageDeployment for more information on using the StartStageDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartStageDeploymentRequest method.
//	req, resp := client.StartStageDeploymentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/StartStageDeployment
func (c *GameSparks) StartStageDeploymentRequest(input *StartStageDeploymentInput) (req *request.Request, output *StartStageDeploymentOutput) {
	op := &request.Operation{
		Name:       opStartStageDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/game/{GameName}/stage/{StageName}/deployment",
	}

	if input == nil {
		input = &StartStageDeploymentInput{}
	}

	output = &StartStageDeploymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartStageDeployment API operation for GameSparks.
//
// Deploys a snapshot to the stage and creates a new game runtime.
//
// After you call this operation, you can check the deployment status by using
// GetStageDeployment.
//
// If there are any players connected to the previous game runtime, then both
// runtimes persist. Existing connections to the previous runtime are maintained.
// When players disconnect and reconnect, they connect to the new runtime. After
// there are no connections to the previous game runtime, it is deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for GameSparks's
// API operation StartStageDeployment for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ConflictException
//     The resource already exists, or another operation is in progress.
//
//   - ResourceNotFoundException
//     The resource specified in the request does not exist.
//
//   - InternalServerException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/StartStageDeployment
func (c *GameSparks) StartStageDeployment(input *StartStageDeploymentInput) (*StartStageDeploymentOutput, error) {
	req, out := c.StartStageDeploymentRequest(input)
	return out, req.Send()
}

// StartStageDeploymentWithContext is the same as StartStageDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See StartStageDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) StartStageDeploymentWithContext(ctx aws.Context, input *StartStageDeploymentInput, opts ...request.Option) (*StartStageDeploymentOutput, error) {
	req, out := c.StartStageDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/TagResource
func (c *GameSparks) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for GameSparks.
//
// Adds tags to a GameSparks resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for GameSparks's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - ResourceNotFoundException
//     The resource specified in the request does not exist.
//
//   - InternalServerException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/TagResource
func (c *GameSparks) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/UntagResource
func (c *GameSparks) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for GameSparks.
//
// Removes tags from a GameSparks resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for GameSparks's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - ResourceNotFoundException
//     The resource specified in the request does not exist.
//
//   - InternalServerException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/UntagResource
func (c *GameSparks) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGame = "UpdateGame"

// UpdateGameRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGame operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGame for more information on using the UpdateGame
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateGameRequest method.
//	req, resp := client.UpdateGameRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/UpdateGame
func (c *GameSparks) UpdateGameRequest(input *UpdateGameInput) (req *request.Request, output *UpdateGameOutput) {
	op := &request.Operation{
		Name:       opUpdateGame,
		HTTPMethod: "PATCH",
		HTTPPath:   "/game/{GameName}",
	}

	if input == nil {
		input = &UpdateGameInput{}
	}

	output = &UpdateGameOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGame API operation for GameSparks.
//
// Updates details of the game.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for GameSparks's
// API operation UpdateGame for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ResourceNotFoundException
//     The resource specified in the request does not exist.
//
//   - InternalServerException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/UpdateGame
func (c *GameSparks) UpdateGame(input *UpdateGameInput) (*UpdateGameOutput, error) {
	req, out := c.UpdateGameRequest(input)
	return out, req.Send()
}

// UpdateGameWithContext is the same as UpdateGame with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGame for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) UpdateGameWithContext(ctx aws.Context, input *UpdateGameInput, opts ...request.Option) (*UpdateGameOutput, error) {
	req, out := c.UpdateGameRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGameConfiguration = "UpdateGameConfiguration"

// UpdateGameConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGameConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGameConfiguration for more information on using the UpdateGameConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateGameConfigurationRequest method.
//	req, resp := client.UpdateGameConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/UpdateGameConfiguration
func (c *GameSparks) UpdateGameConfigurationRequest(input *UpdateGameConfigurationInput) (req *request.Request, output *UpdateGameConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateGameConfiguration,
		HTTPMethod: "PATCH",
		HTTPPath:   "/game/{GameName}/configuration",
	}

	if input == nil {
		input = &UpdateGameConfigurationInput{}
	}

	output = &UpdateGameConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGameConfiguration API operation for GameSparks.
//
// Updates one or more sections of the game configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for GameSparks's
// API operation UpdateGameConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ResourceNotFoundException
//     The resource specified in the request does not exist.
//
//   - InternalServerException
//     The service encountered an internal error.
//
//   - ServiceQuotaExceededException
//     The request would result in exceeding service quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/UpdateGameConfiguration
func (c *GameSparks) UpdateGameConfiguration(input *UpdateGameConfigurationInput) (*UpdateGameConfigurationOutput, error) {
	req, out := c.UpdateGameConfigurationRequest(input)
	return out, req.Send()
}

// UpdateGameConfigurationWithContext is the same as UpdateGameConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGameConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) UpdateGameConfigurationWithContext(ctx aws.Context, input *UpdateGameConfigurationInput, opts ...request.Option) (*UpdateGameConfigurationOutput, error) {
	req, out := c.UpdateGameConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSnapshot = "UpdateSnapshot"

// UpdateSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSnapshot for more information on using the UpdateSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSnapshotRequest method.
//	req, resp := client.UpdateSnapshotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/UpdateSnapshot
func (c *GameSparks) UpdateSnapshotRequest(input *UpdateSnapshotInput) (req *request.Request, output *UpdateSnapshotOutput) {
	op := &request.Operation{
		Name:       opUpdateSnapshot,
		HTTPMethod: "PATCH",
		HTTPPath:   "/game/{GameName}/snapshot/{SnapshotId}",
	}

	if input == nil {
		input = &UpdateSnapshotInput{}
	}

	output = &UpdateSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSnapshot API operation for GameSparks.
//
// Updates the metadata of a GameSparks snapshot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for GameSparks's
// API operation UpdateSnapshot for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ResourceNotFoundException
//     The resource specified in the request does not exist.
//
//   - InternalServerException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/UpdateSnapshot
func (c *GameSparks) UpdateSnapshot(input *UpdateSnapshotInput) (*UpdateSnapshotOutput, error) {
	req, out := c.UpdateSnapshotRequest(input)
	return out, req.Send()
}

// UpdateSnapshotWithContext is the same as UpdateSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) UpdateSnapshotWithContext(ctx aws.Context, input *UpdateSnapshotInput, opts ...request.Option) (*UpdateSnapshotOutput, error) {
	req, out := c.UpdateSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStage = "UpdateStage"

// UpdateStageRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStage for more information on using the UpdateStage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateStageRequest method.
//	req, resp := client.UpdateStageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/UpdateStage
func (c *GameSparks) UpdateStageRequest(input *UpdateStageInput) (req *request.Request, output *UpdateStageOutput) {
	op := &request.Operation{
		Name:       opUpdateStage,
		HTTPMethod: "PATCH",
		HTTPPath:   "/game/{GameName}/stage/{StageName}",
	}

	if input == nil {
		input = &UpdateStageInput{}
	}

	output = &UpdateStageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateStage API operation for GameSparks.
//
// Updates the metadata of a stage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for GameSparks's
// API operation UpdateStage for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the parameters in the request is invalid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ResourceNotFoundException
//     The resource specified in the request does not exist.
//
//   - InternalServerException
//     The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/UpdateStage
func (c *GameSparks) UpdateStage(input *UpdateStageInput) (*UpdateStageOutput, error) {
	req, out := c.UpdateStageRequest(input)
	return out, req.Send()
}

// UpdateStageWithContext is the same as UpdateStage with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameSparks) UpdateStageWithContext(ctx aws.Context, input *UpdateStageInput, opts ...request.Option) (*UpdateStageOutput, error) {
	req, out := c.UpdateStageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource already exists, or another operation is in progress.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Details about a WebSocket connection.
type Connection struct {
	_ struct{} `type:"structure"`

	// The date and time when the connection was created.
	Created *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The identifier used to indicate a specific WebSocket connection.
	Id *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Connection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Connection) GoString() string {
	return s.String()
}

// SetCreated sets the Created field's value.
func (s *Connection) SetCreated(v time.Time) *Connection {
	s.Created = &v
	return s
}

// SetId sets the Id field's value.
func (s *Connection) SetId(v string) *Connection {
	s.Id = &v
	return s
}

type CreateGameInput struct {
	_ struct{} `type:"structure"`

	// A client-defined token. With an active client token in the request, this
	// action is idempotent.
	ClientToken *string `min:"33" type:"string"`

	// The description of the game.
	Description *string `type:"string"`

	// The name of the game.
	//
	// GameName is a required field
	GameName *string `min:"1" type:"string" required:"true"`

	// The list of tags to apply to the game.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGameInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGameInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGameInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGameInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 33 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 33))
	}
	if s.GameName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameName"))
	}
	if s.GameName != nil && len(*s.GameName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateGameInput) SetClientToken(v string) *CreateGameInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateGameInput) SetDescription(v string) *CreateGameInput {
	s.Description = &v
	return s
}

// SetGameName sets the GameName field's value.
func (s *CreateGameInput) SetGameName(v string) *CreateGameInput {
	s.GameName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateGameInput) SetTags(v map[string]*string) *CreateGameInput {
	s.Tags = v
	return s
}

type CreateGameOutput struct {
	_ struct{} `type:"structure"`

	// Details about the game that was created.
	Game *GameDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGameOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGameOutput) GoString() string {
	return s.String()
}

// SetGame sets the Game field's value.
func (s *CreateGameOutput) SetGame(v *GameDetails) *CreateGameOutput {
	s.Game = v
	return s
}

type CreateSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The description of the snapshot.
	Description *string `type:"string"`

	// The name of the game.
	//
	// GameName is a required field
	GameName *string `location:"uri" locationName:"GameName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSnapshotInput"}
	if s.GameName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameName"))
	}
	if s.GameName != nil && len(*s.GameName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateSnapshotInput) SetDescription(v string) *CreateSnapshotInput {
	s.Description = &v
	return s
}

// SetGameName sets the GameName field's value.
func (s *CreateSnapshotInput) SetGameName(v string) *CreateSnapshotInput {
	s.GameName = &v
	return s
}

type CreateSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Properties that provide details of the created snapshot.
	Snapshot *SnapshotDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSnapshotOutput) GoString() string {
	return s.String()
}

// SetSnapshot sets the Snapshot field's value.
func (s *CreateSnapshotOutput) SetSnapshot(v *SnapshotDetails) *CreateSnapshotOutput {
	s.Snapshot = v
	return s
}

type CreateStageInput struct {
	_ struct{} `type:"structure"`

	// A client-defined token. With an active client token in the request, this
	// action is idempotent.
	ClientToken *string `min:"33" type:"string"`

	// The description of the stage.
	Description *string `type:"string"`

	// The name of the game.
	//
	// GameName is a required field
	GameName *string `location:"uri" locationName:"GameName" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the role to run the game with. This role
	// can be a game-defined role or the default role that GameSparks created.
	//
	// Role is a required field
	Role *string `min:"20" type:"string" required:"true"`

	// The name of the stage.
	//
	// StageName is a required field
	StageName *string `min:"1" type:"string" required:"true"`

	// The list of tags to apply to the stage.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStageInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 33 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 33))
	}
	if s.GameName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameName"))
	}
	if s.GameName != nil && len(*s.GameName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameName", 1))
	}
	if s.Role == nil {
		invalidParams.Add(request.NewErrParamRequired("Role"))
	}
	if s.Role != nil && len(*s.Role) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Role", 20))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateStageInput) SetClientToken(v string) *CreateStageInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateStageInput) SetDescription(v string) *CreateStageInput {
	s.Description = &v
	return s
}

// SetGameName sets the GameName field's value.
func (s *CreateStageInput) SetGameName(v string) *CreateStageInput {
	s.GameName = &v
	return s
}

// SetRole sets the Role field's value.
func (s *CreateStageInput) SetRole(v string) *CreateStageInput {
	s.Role = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *CreateStageInput) SetStageName(v string) *CreateStageInput {
	s.StageName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateStageInput) SetTags(v map[string]*string) *CreateStageInput {
	s.Tags = v
	return s
}

type CreateStageOutput struct {
	_ struct{} `type:"structure"`

	// Properties that describe the stage.
	Stage *StageDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStageOutput) GoString() string {
	return s.String()
}

// SetStage sets the Stage field's value.
func (s *CreateStageOutput) SetStage(v *StageDetails) *CreateStageOutput {
	s.Stage = v
	return s
}

type DeleteGameInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the game to delete.
	//
	// GameName is a required field
	GameName *string `location:"uri" locationName:"GameName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGameInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGameInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGameInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGameInput"}
	if s.GameName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameName"))
	}
	if s.GameName != nil && len(*s.GameName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameName sets the GameName field's value.
func (s *DeleteGameInput) SetGameName(v string) *DeleteGameInput {
	s.GameName = &v
	return s
}

type DeleteGameOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGameOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGameOutput) GoString() string {
	return s.String()
}

type DeleteStageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the game.
	//
	// GameName is a required field
	GameName *string `location:"uri" locationName:"GameName" min:"1" type:"string" required:"true"`

	// The name of the stage to delete.
	//
	// StageName is a required field
	StageName *string `location:"uri" locationName:"StageName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStageInput"}
	if s.GameName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameName"))
	}
	if s.GameName != nil && len(*s.GameName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameName", 1))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameName sets the GameName field's value.
func (s *DeleteStageInput) SetGameName(v string) *DeleteStageInput {
	s.GameName = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *DeleteStageInput) SetStageName(v string) *DeleteStageInput {
	s.StageName = &v
	return s
}

type DeleteStageOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStageOutput) GoString() string {
	return s.String()
}

// The result of the deployment.
type DeploymentResult struct {
	_ struct{} `type:"structure"`

	// Details about the deployment result.
	Message *string `type:"string"`

	// The type of deployment result.
	ResultCode *string `type:"string" enum:"ResultCode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentResult) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *DeploymentResult) SetMessage(v string) *DeploymentResult {
	s.Message = &v
	return s
}

// SetResultCode sets the ResultCode field's value.
func (s *DeploymentResult) SetResultCode(v string) *DeploymentResult {
	s.ResultCode = &v
	return s
}

type DisconnectPlayerInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the game.
	//
	// GameName is a required field
	GameName *string `location:"uri" locationName:"GameName" min:"1" type:"string" required:"true"`

	// The unique identifier representing a player.
	//
	// PlayerId is a required field
	PlayerId *string `location:"uri" locationName:"PlayerId" min:"1" type:"string" required:"true"`

	// The name of the stage.
	//
	// StageName is a required field
	StageName *string `location:"uri" locationName:"StageName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectPlayerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectPlayerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisconnectPlayerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisconnectPlayerInput"}
	if s.GameName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameName"))
	}
	if s.GameName != nil && len(*s.GameName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameName", 1))
	}
	if s.PlayerId == nil {
		invalidParams.Add(request.NewErrParamRequired("PlayerId"))
	}
	if s.PlayerId != nil && len(*s.PlayerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlayerId", 1))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameName sets the GameName field's value.
func (s *DisconnectPlayerInput) SetGameName(v string) *DisconnectPlayerInput {
	s.GameName = &v
	return s
}

// SetPlayerId sets the PlayerId field's value.
func (s *DisconnectPlayerInput) SetPlayerId(v string) *DisconnectPlayerInput {
	s.PlayerId = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *DisconnectPlayerInput) SetStageName(v string) *DisconnectPlayerInput {
	s.StageName = &v
	return s
}

type DisconnectPlayerOutput struct {
	_ struct{} `type:"structure"`

	// The list of the connection ids that could not be disconnected.
	DisconnectFailures []*string `type:"list"`

	// The list of the connection ids that were disconnected.
	DisconnectSuccesses []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectPlayerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectPlayerOutput) GoString() string {
	return s.String()
}

// SetDisconnectFailures sets the DisconnectFailures field's value.
func (s *DisconnectPlayerOutput) SetDisconnectFailures(v []*string) *DisconnectPlayerOutput {
	s.DisconnectFailures = v
	return s
}

// SetDisconnectSuccesses sets the DisconnectSuccesses field's value.
func (s *DisconnectPlayerOutput) SetDisconnectSuccesses(v []*string) *DisconnectPlayerOutput {
	s.DisconnectSuccesses = v
	return s
}

type ExportSnapshotInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the game.
	//
	// GameName is a required field
	GameName *string `location:"uri" locationName:"GameName" min:"1" type:"string" required:"true"`

	// The identifier of the snapshot to export.
	//
	// SnapshotId is a required field
	SnapshotId *string `location:"uri" locationName:"SnapshotId" min:"33" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportSnapshotInput"}
	if s.GameName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameName"))
	}
	if s.GameName != nil && len(*s.GameName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameName", 1))
	}
	if s.SnapshotId == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotId"))
	}
	if s.SnapshotId != nil && len(*s.SnapshotId) < 33 {
		invalidParams.Add(request.NewErrParamMinLen("SnapshotId", 33))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameName sets the GameName field's value.
func (s *ExportSnapshotInput) SetGameName(v string) *ExportSnapshotInput {
	s.GameName = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *ExportSnapshotInput) SetSnapshotId(v string) *ExportSnapshotInput {
	s.SnapshotId = &v
	return s
}

type ExportSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// The presigned URL for the snapshot data.
	//
	// This URL will be available for 10 minutes, and can be used to download the
	// snapshot content. If the URL expires, a new one can be requested using the
	// same operation.
	S3Url *string `min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportSnapshotOutput) GoString() string {
	return s.String()
}

// SetS3Url sets the S3Url field's value.
func (s *ExportSnapshotOutput) SetS3Url(v string) *ExportSnapshotOutput {
	s.S3Url = &v
	return s
}

// Details about the extension.
type ExtensionDetails struct {
	_ struct{} `type:"structure"`

	// The description of the extension.
	Description *string `type:"string"`

	// The name of the extension.
	Name *string `min:"1" type:"string"`

	// The namespace (qualifier) of the extension.
	Namespace *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExtensionDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExtensionDetails) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *ExtensionDetails) SetDescription(v string) *ExtensionDetails {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *ExtensionDetails) SetName(v string) *ExtensionDetails {
	s.Name = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *ExtensionDetails) SetNamespace(v string) *ExtensionDetails {
	s.Namespace = &v
	return s
}

// Details about the extension version.
type ExtensionVersionDetails struct {
	_ struct{} `type:"structure"`

	// The name of the extension.
	Name *string `min:"1" type:"string"`

	// The namespace (qualifier) of the extension.
	Namespace *string `min:"1" type:"string"`

	// The model that defines the interface for this extension version.
	Schema *string `type:"string"`

	// The version of the extension.
	Version *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExtensionVersionDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExtensionVersionDetails) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ExtensionVersionDetails) SetName(v string) *ExtensionVersionDetails {
	s.Name = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *ExtensionVersionDetails) SetNamespace(v string) *ExtensionVersionDetails {
	s.Namespace = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *ExtensionVersionDetails) SetSchema(v string) *ExtensionVersionDetails {
	s.Schema = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ExtensionVersionDetails) SetVersion(v string) *ExtensionVersionDetails {
	s.Version = &v
	return s
}

// Details about the game configuration.
//
// The game configuration is organized into named sections, where the schema
// of each section is defined by an extension. The schema for these sections
// can be retrieved using the GetExtensionVersion operation.
type GameConfigurationDetails struct {
	_ struct{} `type:"structure"`

	// The date when the game was created.
	Created *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The date when the game was last modified.
	LastUpdated *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Configuration data, organized by section name.
	Sections map[string]*Section `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GameConfigurationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GameConfigurationDetails) GoString() string {
	return s.String()
}

// SetCreated sets the Created field's value.
func (s *GameConfigurationDetails) SetCreated(v time.Time) *GameConfigurationDetails {
	s.Created = &v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *GameConfigurationDetails) SetLastUpdated(v time.Time) *GameConfigurationDetails {
	s.LastUpdated = &v
	return s
}

// SetSections sets the Sections field's value.
func (s *GameConfigurationDetails) SetSections(v map[string]*Section) *GameConfigurationDetails {
	s.Sections = v
	return s
}

// Details about a game.
type GameDetails struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of this game.
	Arn *string `min:"20" type:"string"`

	// The date when the game was created.
	Created *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The description of the game.
	Description *string `type:"string"`

	// Determines if the game can be deleted.
	EnableTerminationProtection *bool `type:"boolean"`

	// The date when the game was last modified.
	LastUpdated *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The name of the game.
	Name *string `min:"1" type:"string"`

	// The state of the game.
	State *string `type:"string" enum:"GameState"`

	// The tags associated with the game.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GameDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GameDetails) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GameDetails) SetArn(v string) *GameDetails {
	s.Arn = &v
	return s
}

// SetCreated sets the Created field's value.
func (s *GameDetails) SetCreated(v time.Time) *GameDetails {
	s.Created = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GameDetails) SetDescription(v string) *GameDetails {
	s.Description = &v
	return s
}

// SetEnableTerminationProtection sets the EnableTerminationProtection field's value.
func (s *GameDetails) SetEnableTerminationProtection(v bool) *GameDetails {
	s.EnableTerminationProtection = &v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *GameDetails) SetLastUpdated(v time.Time) *GameDetails {
	s.LastUpdated = &v
	return s
}

// SetName sets the Name field's value.
func (s *GameDetails) SetName(v string) *GameDetails {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *GameDetails) SetState(v string) *GameDetails {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GameDetails) SetTags(v map[string]*string) *GameDetails {
	s.Tags = v
	return s
}

// The summary of the properties of a game.
type GameSummary struct {
	_ struct{} `type:"structure"`

	// The description of the game.
	Description *string `type:"string"`

	// The name of the game.
	Name *string `min:"1" type:"string"`

	// The state of the game.
	State *string `type:"string" enum:"GameState"`

	// The tags associated with the game.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GameSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GameSummary) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *GameSummary) SetDescription(v string) *GameSummary {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *GameSummary) SetName(v string) *GameSummary {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *GameSummary) SetState(v string) *GameSummary {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GameSummary) SetTags(v map[string]*string) *GameSummary {
	s.Tags = v
	return s
}

// Details about a generated code job.
type GeneratedCodeJobDetails struct {
	_ struct{} `type:"structure"`

	// The description of the generated code job.
	Description *string `type:"string"`

	// The expiration date and time for the download URL.
	//
	// The download URL us guaranteed to be available until at least this time.
	ExpirationTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The identifier for the generated code job.
	GeneratedCodeJobId *string `type:"string"`

	// A presigned URL that can be used to download the generated code.
	S3Url *string `min:"10" type:"string"`

	// The status of the generated code job
	Status *string `type:"string" enum:"GeneratedCodeJobState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeneratedCodeJobDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeneratedCodeJobDetails) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *GeneratedCodeJobDetails) SetDescription(v string) *GeneratedCodeJobDetails {
	s.Description = &v
	return s
}

// SetExpirationTime sets the ExpirationTime field's value.
func (s *GeneratedCodeJobDetails) SetExpirationTime(v time.Time) *GeneratedCodeJobDetails {
	s.ExpirationTime = &v
	return s
}

// SetGeneratedCodeJobId sets the GeneratedCodeJobId field's value.
func (s *GeneratedCodeJobDetails) SetGeneratedCodeJobId(v string) *GeneratedCodeJobDetails {
	s.GeneratedCodeJobId = &v
	return s
}

// SetS3Url sets the S3Url field's value.
func (s *GeneratedCodeJobDetails) SetS3Url(v string) *GeneratedCodeJobDetails {
	s.S3Url = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GeneratedCodeJobDetails) SetStatus(v string) *GeneratedCodeJobDetails {
	s.Status = &v
	return s
}

// Properties that specify the code generator for a generated code job.
type Generator struct {
	_ struct{} `type:"structure"`

	// The target version of the GameSparks Game SDK.
	GameSdkVersion *string `min:"5" type:"string"`

	// The programming language for the generated code.
	//
	// Not all languages are supported for each platform. For cases where multiple
	// languages are supported, this parameter specifies the language to be used.
	// If this value is omitted, the default language for the target platform will
	// be used.
	Language *string `min:"1" type:"string"`

	// The platform that will be used to run the generated code.
	TargetPlatform *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Generator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Generator) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Generator) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Generator"}
	if s.GameSdkVersion != nil && len(*s.GameSdkVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("GameSdkVersion", 5))
	}
	if s.Language != nil && len(*s.Language) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Language", 1))
	}
	if s.TargetPlatform != nil && len(*s.TargetPlatform) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetPlatform", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameSdkVersion sets the GameSdkVersion field's value.
func (s *Generator) SetGameSdkVersion(v string) *Generator {
	s.GameSdkVersion = &v
	return s
}

// SetLanguage sets the Language field's value.
func (s *Generator) SetLanguage(v string) *Generator {
	s.Language = &v
	return s
}

// SetTargetPlatform sets the TargetPlatform field's value.
func (s *Generator) SetTargetPlatform(v string) *Generator {
	s.TargetPlatform = &v
	return s
}

type GetExtensionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the extension.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`

	// The namespace (qualifier) of the extension.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExtensionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExtensionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetExtensionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetExtensionInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetExtensionInput) SetName(v string) *GetExtensionInput {
	s.Name = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *GetExtensionInput) SetNamespace(v string) *GetExtensionInput {
	s.Namespace = &v
	return s
}

type GetExtensionOutput struct {
	_ struct{} `type:"structure"`

	// Details about the extension.
	Extension *ExtensionDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExtensionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExtensionOutput) GoString() string {
	return s.String()
}

// SetExtension sets the Extension field's value.
func (s *GetExtensionOutput) SetExtension(v *ExtensionDetails) *GetExtensionOutput {
	s.Extension = v
	return s
}

type GetExtensionVersionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The version of the extension.
	//
	// ExtensionVersion is a required field
	ExtensionVersion *string `location:"uri" locationName:"ExtensionVersion" type:"string" required:"true"`

	// The name of the extension.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`

	// The namespace (qualifier) of the extension.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExtensionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExtensionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetExtensionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetExtensionVersionInput"}
	if s.ExtensionVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ExtensionVersion"))
	}
	if s.ExtensionVersion != nil && len(*s.ExtensionVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExtensionVersion", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExtensionVersion sets the ExtensionVersion field's value.
func (s *GetExtensionVersionInput) SetExtensionVersion(v string) *GetExtensionVersionInput {
	s.ExtensionVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetExtensionVersionInput) SetName(v string) *GetExtensionVersionInput {
	s.Name = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *GetExtensionVersionInput) SetNamespace(v string) *GetExtensionVersionInput {
	s.Namespace = &v
	return s
}

type GetExtensionVersionOutput struct {
	_ struct{} `type:"structure"`

	// The version of the extension.
	ExtensionVersion *ExtensionVersionDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExtensionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExtensionVersionOutput) GoString() string {
	return s.String()
}

// SetExtensionVersion sets the ExtensionVersion field's value.
func (s *GetExtensionVersionOutput) SetExtensionVersion(v *ExtensionVersionDetails) *GetExtensionVersionOutput {
	s.ExtensionVersion = v
	return s
}

type GetGameConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the game.
	//
	// GameName is a required field
	GameName *string `location:"uri" locationName:"GameName" min:"1" type:"string" required:"true"`

	// The list of sections to return.
	Sections []*string `location:"querystring" locationName:"Sections" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGameConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGameConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGameConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGameConfigurationInput"}
	if s.GameName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameName"))
	}
	if s.GameName != nil && len(*s.GameName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameName", 1))
	}
	if s.Sections != nil && len(s.Sections) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Sections", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameName sets the GameName field's value.
func (s *GetGameConfigurationInput) SetGameName(v string) *GetGameConfigurationInput {
	s.GameName = &v
	return s
}

// SetSections sets the Sections field's value.
func (s *GetGameConfigurationInput) SetSections(v []*string) *GetGameConfigurationInput {
	s.Sections = v
	return s
}

type GetGameConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Details about the game configuration.
	GameConfiguration *GameConfigurationDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGameConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGameConfigurationOutput) GoString() string {
	return s.String()
}

// SetGameConfiguration sets the GameConfiguration field's value.
func (s *GetGameConfigurationOutput) SetGameConfiguration(v *GameConfigurationDetails) *GetGameConfigurationOutput {
	s.GameConfiguration = v
	return s
}

type GetGameInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the game.
	//
	// GameName is a required field
	GameName *string `location:"uri" locationName:"GameName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGameInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGameInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGameInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGameInput"}
	if s.GameName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameName"))
	}
	if s.GameName != nil && len(*s.GameName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameName sets the GameName field's value.
func (s *GetGameInput) SetGameName(v string) *GetGameInput {
	s.GameName = &v
	return s
}

type GetGameOutput struct {
	_ struct{} `type:"structure"`

	// The details of the game.
	Game *GameDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGameOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGameOutput) GoString() string {
	return s.String()
}

// SetGame sets the Game field's value.
func (s *GetGameOutput) SetGame(v *GameDetails) *GetGameOutput {
	s.Game = v
	return s
}

type GetGeneratedCodeJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the game.
	//
	// GameName is a required field
	GameName *string `location:"uri" locationName:"GameName" min:"1" type:"string" required:"true"`

	// The identifier of the code generation job.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"JobId" type:"string" required:"true"`

	// The identifier of the snapshot for the code generation job.
	//
	// SnapshotId is a required field
	SnapshotId *string `location:"uri" locationName:"SnapshotId" min:"33" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGeneratedCodeJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGeneratedCodeJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGeneratedCodeJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGeneratedCodeJobInput"}
	if s.GameName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameName"))
	}
	if s.GameName != nil && len(*s.GameName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameName", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.SnapshotId == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotId"))
	}
	if s.SnapshotId != nil && len(*s.SnapshotId) < 33 {
		invalidParams.Add(request.NewErrParamMinLen("SnapshotId", 33))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameName sets the GameName field's value.
func (s *GetGeneratedCodeJobInput) SetGameName(v string) *GetGeneratedCodeJobInput {
	s.GameName = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GetGeneratedCodeJobInput) SetJobId(v string) *GetGeneratedCodeJobInput {
	s.JobId = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *GetGeneratedCodeJobInput) SetSnapshotId(v string) *GetGeneratedCodeJobInput {
	s.SnapshotId = &v
	return s
}

type GetGeneratedCodeJobOutput struct {
	_ struct{} `type:"structure"`

	// Details about the generated code job.
	GeneratedCodeJob *GeneratedCodeJobDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGeneratedCodeJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGeneratedCodeJobOutput) GoString() string {
	return s.String()
}

// SetGeneratedCodeJob sets the GeneratedCodeJob field's value.
func (s *GetGeneratedCodeJobOutput) SetGeneratedCodeJob(v *GeneratedCodeJobDetails) *GetGeneratedCodeJobOutput {
	s.GeneratedCodeJob = v
	return s
}

type GetPlayerConnectionStatusInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the game.
	//
	// GameName is a required field
	GameName *string `location:"uri" locationName:"GameName" min:"1" type:"string" required:"true"`

	// The unique identifier representing a player.
	//
	// PlayerId is a required field
	PlayerId *string `location:"uri" locationName:"PlayerId" min:"1" type:"string" required:"true"`

	// The name of the stage.
	//
	// StageName is a required field
	StageName *string `location:"uri" locationName:"StageName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPlayerConnectionStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPlayerConnectionStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPlayerConnectionStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPlayerConnectionStatusInput"}
	if s.GameName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameName"))
	}
	if s.GameName != nil && len(*s.GameName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameName", 1))
	}
	if s.PlayerId == nil {
		invalidParams.Add(request.NewErrParamRequired("PlayerId"))
	}
	if s.PlayerId != nil && len(*s.PlayerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlayerId", 1))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameName sets the GameName field's value.
func (s *GetPlayerConnectionStatusInput) SetGameName(v string) *GetPlayerConnectionStatusInput {
	s.GameName = &v
	return s
}

// SetPlayerId sets the PlayerId field's value.
func (s *GetPlayerConnectionStatusInput) SetPlayerId(v string) *GetPlayerConnectionStatusInput {
	s.PlayerId = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *GetPlayerConnectionStatusInput) SetStageName(v string) *GetPlayerConnectionStatusInput {
	s.StageName = &v
	return s
}

type GetPlayerConnectionStatusOutput struct {
	_ struct{} `type:"structure"`

	// The list of connection ids, one for each connection in use by the player.
	Connections []*Connection `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPlayerConnectionStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPlayerConnectionStatusOutput) GoString() string {
	return s.String()
}

// SetConnections sets the Connections field's value.
func (s *GetPlayerConnectionStatusOutput) SetConnections(v []*Connection) *GetPlayerConnectionStatusOutput {
	s.Connections = v
	return s
}

type GetSnapshotInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the game.
	//
	// GameName is a required field
	GameName *string `location:"uri" locationName:"GameName" min:"1" type:"string" required:"true"`

	// The list of game configuration sections to be described.
	Sections []*string `location:"querystring" locationName:"Sections" min:"1" type:"list"`

	// The identifier of the snapshot.
	//
	// SnapshotId is a required field
	SnapshotId *string `location:"uri" locationName:"SnapshotId" min:"33" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSnapshotInput"}
	if s.GameName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameName"))
	}
	if s.GameName != nil && len(*s.GameName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameName", 1))
	}
	if s.Sections != nil && len(s.Sections) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Sections", 1))
	}
	if s.SnapshotId == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotId"))
	}
	if s.SnapshotId != nil && len(*s.SnapshotId) < 33 {
		invalidParams.Add(request.NewErrParamMinLen("SnapshotId", 33))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameName sets the GameName field's value.
func (s *GetSnapshotInput) SetGameName(v string) *GetSnapshotInput {
	s.GameName = &v
	return s
}

// SetSections sets the Sections field's value.
func (s *GetSnapshotInput) SetSections(v []*string) *GetSnapshotInput {
	s.Sections = v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *GetSnapshotInput) SetSnapshotId(v string) *GetSnapshotInput {
	s.SnapshotId = &v
	return s
}

type GetSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Properties that provide details of the snapshot.
	Snapshot *SnapshotDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSnapshotOutput) GoString() string {
	return s.String()
}

// SetSnapshot sets the Snapshot field's value.
func (s *GetSnapshotOutput) SetSnapshot(v *SnapshotDetails) *GetSnapshotOutput {
	s.Snapshot = v
	return s
}

type GetStageDeploymentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the stage deployment. StartStageDeployment returns the
	// identifier that you use here.
	DeploymentId *string `location:"querystring" locationName:"DeploymentId" min:"1" type:"string"`

	// The name of the game.
	//
	// GameName is a required field
	GameName *string `location:"uri" locationName:"GameName" min:"1" type:"string" required:"true"`

	// The name of the stage.
	//
	// StageName is a required field
	StageName *string `location:"uri" locationName:"StageName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStageDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStageDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStageDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStageDeploymentInput"}
	if s.DeploymentId != nil && len(*s.DeploymentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentId", 1))
	}
	if s.GameName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameName"))
	}
	if s.GameName != nil && len(*s.GameName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameName", 1))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *GetStageDeploymentInput) SetDeploymentId(v string) *GetStageDeploymentInput {
	s.DeploymentId = &v
	return s
}

// SetGameName sets the GameName field's value.
func (s *GetStageDeploymentInput) SetGameName(v string) *GetStageDeploymentInput {
	s.GameName = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *GetStageDeploymentInput) SetStageName(v string) *GetStageDeploymentInput {
	s.StageName = &v
	return s
}

type GetStageDeploymentOutput struct {
	_ struct{} `type:"structure"`

	// Properties that provide details of the stage deployment.
	StageDeployment *StageDeploymentDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStageDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStageDeploymentOutput) GoString() string {
	return s.String()
}

// SetStageDeployment sets the StageDeployment field's value.
func (s *GetStageDeploymentOutput) SetStageDeployment(v *StageDeploymentDetails) *GetStageDeploymentOutput {
	s.StageDeployment = v
	return s
}

type GetStageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the game.
	//
	// GameName is a required field
	GameName *string `location:"uri" locationName:"GameName" min:"1" type:"string" required:"true"`

	// The name of the stage.
	//
	// StageName is a required field
	StageName *string `location:"uri" locationName:"StageName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStageInput"}
	if s.GameName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameName"))
	}
	if s.GameName != nil && len(*s.GameName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameName", 1))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameName sets the GameName field's value.
func (s *GetStageInput) SetGameName(v string) *GetStageInput {
	s.GameName = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *GetStageInput) SetStageName(v string) *GetStageInput {
	s.StageName = &v
	return s
}

type GetStageOutput struct {
	_ struct{} `type:"structure"`

	// Properties that provide details of the stage.
	Stage *StageDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStageOutput) GoString() string {
	return s.String()
}

// SetStage sets the Stage field's value.
func (s *GetStageOutput) SetStage(v *StageDetails) *GetStageOutput {
	s.Stage = v
	return s
}

type ImportGameConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the game.
	//
	// GameName is a required field
	GameName *string `location:"uri" locationName:"GameName" min:"1" type:"string" required:"true"`

	// The source used to import configuration sections.
	//
	// ImportSource is a required field
	ImportSource *ImportGameConfigurationSource `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportGameConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportGameConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportGameConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportGameConfigurationInput"}
	if s.GameName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameName"))
	}
	if s.GameName != nil && len(*s.GameName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameName", 1))
	}
	if s.ImportSource == nil {
		invalidParams.Add(request.NewErrParamRequired("ImportSource"))
	}
	if s.ImportSource != nil {
		if err := s.ImportSource.Validate(); err != nil {
			invalidParams.AddNested("ImportSource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameName sets the GameName field's value.
func (s *ImportGameConfigurationInput) SetGameName(v string) *ImportGameConfigurationInput {
	s.GameName = &v
	return s
}

// SetImportSource sets the ImportSource field's value.
func (s *ImportGameConfigurationInput) SetImportSource(v *ImportGameConfigurationSource) *ImportGameConfigurationInput {
	s.ImportSource = v
	return s
}

type ImportGameConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Details about the game configuration.
	GameConfiguration *GameConfigurationDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportGameConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportGameConfigurationOutput) GoString() string {
	return s.String()
}

// SetGameConfiguration sets the GameConfiguration field's value.
func (s *ImportGameConfigurationOutput) SetGameConfiguration(v *GameConfigurationDetails) *ImportGameConfigurationOutput {
	s.GameConfiguration = v
	return s
}

// The source used to import configuration sections.
type ImportGameConfigurationSource struct {
	_ struct{} `type:"structure"`

	// The JSON string containing the configuration sections.
	// File is automatically base64 encoded/decoded by the SDK.
	//
	// File is a required field
	File []byte `min:"10" type:"blob" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportGameConfigurationSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportGameConfigurationSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportGameConfigurationSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportGameConfigurationSource"}
	if s.File == nil {
		invalidParams.Add(request.NewErrParamRequired("File"))
	}
	if s.File != nil && len(s.File) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("File", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFile sets the File field's value.
func (s *ImportGameConfigurationSource) SetFile(v []byte) *ImportGameConfigurationSource {
	s.File = v
	return s
}

// The service encountered an internal error.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListExtensionVersionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return.
	//
	// Use this parameter with NextToken to get results as a set of sequential pages.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The name of the extension.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`

	// The namespace (qualifier) of the extension.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" min:"1" type:"string" required:"true"`

	// The token that indicates the start of the next sequential page of results.
	//
	// Use the token that is returned with a previous call to this operation. To
	// start at the beginning of the result set, do not specify a value.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExtensionVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExtensionVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListExtensionVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListExtensionVersionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListExtensionVersionsInput) SetMaxResults(v int64) *ListExtensionVersionsInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListExtensionVersionsInput) SetName(v string) *ListExtensionVersionsInput {
	s.Name = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *ListExtensionVersionsInput) SetNamespace(v string) *ListExtensionVersionsInput {
	s.Namespace = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExtensionVersionsInput) SetNextToken(v string) *ListExtensionVersionsInput {
	s.NextToken = &v
	return s
}

type ListExtensionVersionsOutput struct {
	_ struct{} `type:"structure"`

	// The list of extension versions.
	ExtensionVersions []*ExtensionVersionDetails `type:"list"`

	// The token that indicates the start of the next sequential page of results.
	//
	// Use this value when making the next call to this operation to continue where
	// the last one finished.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExtensionVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExtensionVersionsOutput) GoString() string {
	return s.String()
}

// SetExtensionVersions sets the ExtensionVersions field's value.
func (s *ListExtensionVersionsOutput) SetExtensionVersions(v []*ExtensionVersionDetails) *ListExtensionVersionsOutput {
	s.ExtensionVersions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExtensionVersionsOutput) SetNextToken(v string) *ListExtensionVersionsOutput {
	s.NextToken = &v
	return s
}

type ListExtensionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return.
	//
	// Use this parameter with NextToken to get results as a set of sequential pages.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token that indicates the start of the next sequential page of results.
	//
	// Use the token that is returned with a previous call to this operation. To
	// start at the beginning of the result set, do not specify a value.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExtensionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExtensionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListExtensionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListExtensionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListExtensionsInput) SetMaxResults(v int64) *ListExtensionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExtensionsInput) SetNextToken(v string) *ListExtensionsInput {
	s.NextToken = &v
	return s
}

type ListExtensionsOutput struct {
	_ struct{} `type:"structure"`

	// The list of extensions.
	Extensions []*ExtensionDetails `type:"list"`

	// The token that indicates the start of the next sequential page of results.
	//
	// Use this value when making the next call to this operation to continue where
	// the last one finished.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExtensionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExtensionsOutput) GoString() string {
	return s.String()
}

// SetExtensions sets the Extensions field's value.
func (s *ListExtensionsOutput) SetExtensions(v []*ExtensionDetails) *ListExtensionsOutput {
	s.Extensions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExtensionsOutput) SetNextToken(v string) *ListExtensionsOutput {
	s.NextToken = &v
	return s
}

type ListGamesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return.
	//
	// Use this parameter with NextToken to get results as a set of sequential pages.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token that indicates the start of the next sequential page of results.
	//
	// Use the token that is returned with a previous call to this operation. To
	// start at the beginning of the result set, do not specify a value.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGamesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGamesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGamesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGamesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGamesInput) SetMaxResults(v int64) *ListGamesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGamesInput) SetNextToken(v string) *ListGamesInput {
	s.NextToken = &v
	return s
}

type ListGamesOutput struct {
	_ struct{} `type:"structure"`

	// The list of games.
	Games []*GameSummary `type:"list"`

	// The token that indicates the start of the next sequential page of results.
	//
	// Use this value when making the next call to this operation to continue where
	// the last one finished.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGamesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGamesOutput) GoString() string {
	return s.String()
}

// SetGames sets the Games field's value.
func (s *ListGamesOutput) SetGames(v []*GameSummary) *ListGamesOutput {
	s.Games = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGamesOutput) SetNextToken(v string) *ListGamesOutput {
	s.NextToken = &v
	return s
}

type ListGeneratedCodeJobsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the game.
	//
	// GameName is a required field
	GameName *string `location:"uri" locationName:"GameName" min:"1" type:"string" required:"true"`

	// The maximum number of results to return.
	//
	// Use this parameter with NextToken to get results as a set of sequential pages.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token that indicates the start of the next sequential page of results.
	//
	// Use the token that is returned with a previous call to this operation. To
	// start at the beginning of the result set, do not specify a value.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`

	// The identifier of the snapshot.
	//
	// SnapshotId is a required field
	SnapshotId *string `location:"uri" locationName:"SnapshotId" min:"33" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGeneratedCodeJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGeneratedCodeJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGeneratedCodeJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGeneratedCodeJobsInput"}
	if s.GameName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameName"))
	}
	if s.GameName != nil && len(*s.GameName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.SnapshotId == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotId"))
	}
	if s.SnapshotId != nil && len(*s.SnapshotId) < 33 {
		invalidParams.Add(request.NewErrParamMinLen("SnapshotId", 33))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameName sets the GameName field's value.
func (s *ListGeneratedCodeJobsInput) SetGameName(v string) *ListGeneratedCodeJobsInput {
	s.GameName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGeneratedCodeJobsInput) SetMaxResults(v int64) *ListGeneratedCodeJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGeneratedCodeJobsInput) SetNextToken(v string) *ListGeneratedCodeJobsInput {
	s.NextToken = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *ListGeneratedCodeJobsInput) SetSnapshotId(v string) *ListGeneratedCodeJobsInput {
	s.SnapshotId = &v
	return s
}

type ListGeneratedCodeJobsOutput struct {
	_ struct{} `type:"structure"`

	// The list of generated code jobs.
	GeneratedCodeJobs []*GeneratedCodeJobDetails `type:"list"`

	// The token that indicates the start of the next sequential page of results.
	//
	// Use this value when making the next call to this operation to continue where
	// the last one finished.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGeneratedCodeJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGeneratedCodeJobsOutput) GoString() string {
	return s.String()
}

// SetGeneratedCodeJobs sets the GeneratedCodeJobs field's value.
func (s *ListGeneratedCodeJobsOutput) SetGeneratedCodeJobs(v []*GeneratedCodeJobDetails) *ListGeneratedCodeJobsOutput {
	s.GeneratedCodeJobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGeneratedCodeJobsOutput) SetNextToken(v string) *ListGeneratedCodeJobsOutput {
	s.NextToken = &v
	return s
}

type ListSnapshotsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the game.
	//
	// GameName is a required field
	GameName *string `location:"uri" locationName:"GameName" min:"1" type:"string" required:"true"`

	// The maximum number of results to return.
	//
	// Use this parameter with NextToken to get results as a set of sequential pages.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token that indicates the start of the next sequential page of results.
	//
	// Use the token that is returned with a previous call to this operation. To
	// start at the beginning of the result set, do not specify a value.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSnapshotsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSnapshotsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSnapshotsInput"}
	if s.GameName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameName"))
	}
	if s.GameName != nil && len(*s.GameName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameName sets the GameName field's value.
func (s *ListSnapshotsInput) SetGameName(v string) *ListSnapshotsInput {
	s.GameName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSnapshotsInput) SetMaxResults(v int64) *ListSnapshotsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSnapshotsInput) SetNextToken(v string) *ListSnapshotsInput {
	s.NextToken = &v
	return s
}

type ListSnapshotsOutput struct {
	_ struct{} `type:"structure"`

	// The token that indicates the start of the next sequential page of results.
	//
	// Use this value when making the next call to this operation to continue where
	// the last one finished.
	NextToken *string `min:"1" type:"string"`

	// A list of snapshot summaries. You can use the returned snapshot IDs in the
	// UpdateSnapshot and GetSnapshot operations.
	Snapshots []*SnapshotSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSnapshotsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSnapshotsOutput) SetNextToken(v string) *ListSnapshotsOutput {
	s.NextToken = &v
	return s
}

// SetSnapshots sets the Snapshots field's value.
func (s *ListSnapshotsOutput) SetSnapshots(v []*SnapshotSummary) *ListSnapshotsOutput {
	s.Snapshots = v
	return s
}

type ListStageDeploymentsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the game.
	//
	// GameName is a required field
	GameName *string `location:"uri" locationName:"GameName" min:"1" type:"string" required:"true"`

	// The maximum number of results to return.
	//
	// Use this parameter with NextToken to get results as a set of sequential pages.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token that indicates the start of the next sequential page of results.
	//
	// Use the token that is returned with a previous call to this operation. To
	// start at the beginning of the result set, do not specify a value.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`

	// The name of the stage.
	//
	// StageName is a required field
	StageName *string `location:"uri" locationName:"StageName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStageDeploymentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStageDeploymentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStageDeploymentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStageDeploymentsInput"}
	if s.GameName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameName"))
	}
	if s.GameName != nil && len(*s.GameName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameName sets the GameName field's value.
func (s *ListStageDeploymentsInput) SetGameName(v string) *ListStageDeploymentsInput {
	s.GameName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStageDeploymentsInput) SetMaxResults(v int64) *ListStageDeploymentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStageDeploymentsInput) SetNextToken(v string) *ListStageDeploymentsInput {
	s.NextToken = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *ListStageDeploymentsInput) SetStageName(v string) *ListStageDeploymentsInput {
	s.StageName = &v
	return s
}

type ListStageDeploymentsOutput struct {
	_ struct{} `type:"structure"`

	// The token that indicates the start of the next sequential page of results.
	//
	// Use this value when making the next call to this operation to continue where
	// the last one finished.
	NextToken *string `min:"1" type:"string"`

	// A list of stage deployment summaries. You can use the deployment IDs in the
	// UpdateStageDeployment and GetStageDeployment actions.
	StageDeployments []*StageDeploymentSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStageDeploymentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStageDeploymentsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStageDeploymentsOutput) SetNextToken(v string) *ListStageDeploymentsOutput {
	s.NextToken = &v
	return s
}

// SetStageDeployments sets the StageDeployments field's value.
func (s *ListStageDeploymentsOutput) SetStageDeployments(v []*StageDeploymentSummary) *ListStageDeploymentsOutput {
	s.StageDeployments = v
	return s
}

type ListStagesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the game.
	//
	// GameName is a required field
	GameName *string `location:"uri" locationName:"GameName" min:"1" type:"string" required:"true"`

	// The maximum number of results to return.
	//
	// Use this parameter with NextToken to get results as a set of sequential pages.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token that indicates the start of the next sequential page of results.
	//
	// Use the token that is returned with a previous call to this operation. To
	// start at the beginning of the result set, do not specify a value.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStagesInput"}
	if s.GameName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameName"))
	}
	if s.GameName != nil && len(*s.GameName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameName sets the GameName field's value.
func (s *ListStagesInput) SetGameName(v string) *ListStagesInput {
	s.GameName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStagesInput) SetMaxResults(v int64) *ListStagesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStagesInput) SetNextToken(v string) *ListStagesInput {
	s.NextToken = &v
	return s
}

type ListStagesOutput struct {
	_ struct{} `type:"structure"`

	// The token that indicates the start of the next sequential page of results.
	//
	// Use this value when making the next call to this operation to continue where
	// the last one finished.
	NextToken *string `min:"1" type:"string"`

	// A list of stage summaries. You can use the stage names in the UpdateStage
	// and GetStage actions.
	Stages []*StageSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStagesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStagesOutput) SetNextToken(v string) *ListStagesOutput {
	s.NextToken = &v
	return s
}

// SetStages sets the Stages field's value.
func (s *ListStagesOutput) SetStages(v []*StageSummary) *ListStagesOutput {
	s.Stages = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the GameSparks resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags associated with the resource.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The resource specified in the request does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The configuration section.
type Section struct {
	_ struct{} `type:"structure"`

	// The name of the section.
	Name *string `min:"1" type:"string"`

	// The size, in bytes, of the section contents.
	Size *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Section) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Section) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *Section) SetName(v string) *Section {
	s.Name = &v
	return s
}

// SetSize sets the Size field's value.
func (s *Section) SetSize(v int64) *Section {
	s.Size = &v
	return s
}

// A single modification to the configuration section.
type SectionModification struct {
	_ struct{} `type:"structure"`

	// The operation to be performed on a configuration section.
	//
	// Content can be added, deleted, or replaced within a section.
	//
	// Operation is a required field
	Operation *string `type:"string" required:"true" enum:"Operation"`

	// The path within the section content to be modified.
	//
	// Path is a required field
	Path *string `min:"1" type:"string" required:"true"`

	// The name of the section to be modified.
	//
	// Section is a required field
	Section *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SectionModification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SectionModification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SectionModification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SectionModification"}
	if s.Operation == nil {
		invalidParams.Add(request.NewErrParamRequired("Operation"))
	}
	if s.Path == nil {
		invalidParams.Add(request.NewErrParamRequired("Path"))
	}
	if s.Path != nil && len(*s.Path) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Path", 1))
	}
	if s.Section == nil {
		invalidParams.Add(request.NewErrParamRequired("Section"))
	}
	if s.Section != nil && len(*s.Section) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Section", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOperation sets the Operation field's value.
func (s *SectionModification) SetOperation(v string) *SectionModification {
	s.Operation = &v
	return s
}

// SetPath sets the Path field's value.
func (s *SectionModification) SetPath(v string) *SectionModification {
	s.Path = &v
	return s
}

// SetSection sets the Section field's value.
func (s *SectionModification) SetSection(v string) *SectionModification {
	s.Section = &v
	return s
}

// The request would result in exceeding service quota.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Properties that provide details of a snapshot.
type SnapshotDetails struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the snapshot was created.
	Created *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The description of the snapshot.
	Description *string `type:"string"`

	// The identifier of the snapshot.
	Id *string `min:"33" type:"string"`

	// The timestamp of when the snapshot was last updated.
	LastUpdated *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The sections in the snapshot.
	Sections map[string]*Section `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnapshotDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnapshotDetails) GoString() string {
	return s.String()
}

// SetCreated sets the Created field's value.
func (s *SnapshotDetails) SetCreated(v time.Time) *SnapshotDetails {
	s.Created = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *SnapshotDetails) SetDescription(v string) *SnapshotDetails {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *SnapshotDetails) SetId(v string) *SnapshotDetails {
	s.Id = &v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *SnapshotDetails) SetLastUpdated(v time.Time) *SnapshotDetails {
	s.LastUpdated = &v
	return s
}

// SetSections sets the Sections field's value.
func (s *SnapshotDetails) SetSections(v map[string]*Section) *SnapshotDetails {
	s.Sections = v
	return s
}

// The summary of the properties of a snapshot.
type SnapshotSummary struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the snapshot was created.
	Created *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The description of the snapshot.
	Description *string `type:"string"`

	// The identifier of the snapshot.
	Id *string `min:"33" type:"string"`

	// Then timestamp of when the snapshot was last updated.
	LastUpdated *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnapshotSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnapshotSummary) GoString() string {
	return s.String()
}

// SetCreated sets the Created field's value.
func (s *SnapshotSummary) SetCreated(v time.Time) *SnapshotSummary {
	s.Created = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *SnapshotSummary) SetDescription(v string) *SnapshotSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *SnapshotSummary) SetId(v string) *SnapshotSummary {
	s.Id = &v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *SnapshotSummary) SetLastUpdated(v time.Time) *SnapshotSummary {
	s.LastUpdated = &v
	return s
}

// Properties that provide details of a stage deployment.
type StageDeploymentDetails struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the stage deployment was created.
	Created *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The type of action of the stage deployment.
	DeploymentAction *string `type:"string" enum:"DeploymentAction"`

	// The identifier of the deployment.
	DeploymentId *string `min:"1" type:"string"`

	// The result of the deployment.
	DeploymentResult *DeploymentResult `type:"structure"`

	// The state of the deployment.
	DeploymentState *string `type:"string" enum:"DeploymentState"`

	// The timestamp of when the deployment was last updated.
	LastUpdated *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The identifier of the snapshot associated with the stage deployment.
	SnapshotId *string `min:"33" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageDeploymentDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageDeploymentDetails) GoString() string {
	return s.String()
}

// SetCreated sets the Created field's value.
func (s *StageDeploymentDetails) SetCreated(v time.Time) *StageDeploymentDetails {
	s.Created = &v
	return s
}

// SetDeploymentAction sets the DeploymentAction field's value.
func (s *StageDeploymentDetails) SetDeploymentAction(v string) *StageDeploymentDetails {
	s.DeploymentAction = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *StageDeploymentDetails) SetDeploymentId(v string) *StageDeploymentDetails {
	s.DeploymentId = &v
	return s
}

// SetDeploymentResult sets the DeploymentResult field's value.
func (s *StageDeploymentDetails) SetDeploymentResult(v *DeploymentResult) *StageDeploymentDetails {
	s.DeploymentResult = v
	return s
}

// SetDeploymentState sets the DeploymentState field's value.
func (s *StageDeploymentDetails) SetDeploymentState(v string) *StageDeploymentDetails {
	s.DeploymentState = &v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *StageDeploymentDetails) SetLastUpdated(v time.Time) *StageDeploymentDetails {
	s.LastUpdated = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *StageDeploymentDetails) SetSnapshotId(v string) *StageDeploymentDetails {
	s.SnapshotId = &v
	return s
}

// The summary of the properties of a stage deployment.
type StageDeploymentSummary struct {
	_ struct{} `type:"structure"`

	// The type of action of the deployment.
	DeploymentAction *string `type:"string" enum:"DeploymentAction"`

	// The identifier of the deployment.
	DeploymentId *string `min:"1" type:"string"`

	// The result of the deployment.
	DeploymentResult *DeploymentResult `type:"structure"`

	// The state of the deployment.
	DeploymentState *string `type:"string" enum:"DeploymentState"`

	// The timestamp of when the deployment was last updated.
	LastUpdated *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The identifier of the snapshot associated with the stage deployment.
	SnapshotId *string `min:"33" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageDeploymentSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageDeploymentSummary) GoString() string {
	return s.String()
}

// SetDeploymentAction sets the DeploymentAction field's value.
func (s *StageDeploymentSummary) SetDeploymentAction(v string) *StageDeploymentSummary {
	s.DeploymentAction = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *StageDeploymentSummary) SetDeploymentId(v string) *StageDeploymentSummary {
	s.DeploymentId = &v
	return s
}

// SetDeploymentResult sets the DeploymentResult field's value.
func (s *StageDeploymentSummary) SetDeploymentResult(v *DeploymentResult) *StageDeploymentSummary {
	s.DeploymentResult = v
	return s
}

// SetDeploymentState sets the DeploymentState field's value.
func (s *StageDeploymentSummary) SetDeploymentState(v string) *StageDeploymentSummary {
	s.DeploymentState = &v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *StageDeploymentSummary) SetLastUpdated(v time.Time) *StageDeploymentSummary {
	s.LastUpdated = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *StageDeploymentSummary) SetSnapshotId(v string) *StageDeploymentSummary {
	s.SnapshotId = &v
	return s
}

// Properties that provide details of a stage.
type StageDetails struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the stage.
	Arn *string `min:"20" type:"string"`

	// The timestamp of when the stage was created.
	Created *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The description of the stage.
	Description *string `type:"string"`

	// The game key associated with the stage.
	//
	// The game key is a unique identifier that the game client uses to connect
	// to the GameSparks backend.
	GameKey *string `min:"1" type:"string"`

	// The timestamp of when the stage was last updated.
	LastUpdated *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The Amazon CloudWatch log group for game runtimes deployed to the stage.
	LogGroup *string `min:"1" type:"string"`

	// The name of the stage.
	Name *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the role used to run the game runtimes
	// deployed to the stage.
	Role *string `min:"20" type:"string"`

	// The state of the stage.
	State *string `type:"string" enum:"StageState"`

	// The tags associated with the stage.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageDetails) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *StageDetails) SetArn(v string) *StageDetails {
	s.Arn = &v
	return s
}

// SetCreated sets the Created field's value.
func (s *StageDetails) SetCreated(v time.Time) *StageDetails {
	s.Created = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *StageDetails) SetDescription(v string) *StageDetails {
	s.Description = &v
	return s
}

// SetGameKey sets the GameKey field's value.
func (s *StageDetails) SetGameKey(v string) *StageDetails {
	s.GameKey = &v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *StageDetails) SetLastUpdated(v time.Time) *StageDetails {
	s.LastUpdated = &v
	return s
}

// SetLogGroup sets the LogGroup field's value.
func (s *StageDetails) SetLogGroup(v string) *StageDetails {
	s.LogGroup = &v
	return s
}

// SetName sets the Name field's value.
func (s *StageDetails) SetName(v string) *StageDetails {
	s.Name = &v
	return s
}

// SetRole sets the Role field's value.
func (s *StageDetails) SetRole(v string) *StageDetails {
	s.Role = &v
	return s
}

// SetState sets the State field's value.
func (s *StageDetails) SetState(v string) *StageDetails {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StageDetails) SetTags(v map[string]*string) *StageDetails {
	s.Tags = v
	return s
}

// The summary of the properties of a stage.
type StageSummary struct {
	_ struct{} `type:"structure"`

	// The description of the stage.
	Description *string `type:"string"`

	// The game key associated with the stage.
	//
	// The game key is a unique identifier that the game client uses to connect
	// to the GameSparks backend.
	GameKey *string `min:"1" type:"string"`

	// The name of the stage.
	Name *string `min:"1" type:"string"`

	// The state of the stage.
	State *string `type:"string" enum:"StageState"`

	// The tags associated with the stage.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageSummary) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *StageSummary) SetDescription(v string) *StageSummary {
	s.Description = &v
	return s
}

// SetGameKey sets the GameKey field's value.
func (s *StageSummary) SetGameKey(v string) *StageSummary {
	s.GameKey = &v
	return s
}

// SetName sets the Name field's value.
func (s *StageSummary) SetName(v string) *StageSummary {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *StageSummary) SetState(v string) *StageSummary {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StageSummary) SetTags(v map[string]*string) *StageSummary {
	s.Tags = v
	return s
}

type StartGeneratedCodeJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the game.
	//
	// GameName is a required field
	GameName *string `location:"uri" locationName:"GameName" min:"1" type:"string" required:"true"`

	// Properties of the generator to use for the job.
	//
	// Generator is a required field
	Generator *Generator `type:"structure" required:"true"`

	// The identifier of the snapshot for which to generate code.
	//
	// SnapshotId is a required field
	SnapshotId *string `location:"uri" locationName:"SnapshotId" min:"33" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartGeneratedCodeJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartGeneratedCodeJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartGeneratedCodeJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartGeneratedCodeJobInput"}
	if s.GameName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameName"))
	}
	if s.GameName != nil && len(*s.GameName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameName", 1))
	}
	if s.Generator == nil {
		invalidParams.Add(request.NewErrParamRequired("Generator"))
	}
	if s.SnapshotId == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotId"))
	}
	if s.SnapshotId != nil && len(*s.SnapshotId) < 33 {
		invalidParams.Add(request.NewErrParamMinLen("SnapshotId", 33))
	}
	if s.Generator != nil {
		if err := s.Generator.Validate(); err != nil {
			invalidParams.AddNested("Generator", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameName sets the GameName field's value.
func (s *StartGeneratedCodeJobInput) SetGameName(v string) *StartGeneratedCodeJobInput {
	s.GameName = &v
	return s
}

// SetGenerator sets the Generator field's value.
func (s *StartGeneratedCodeJobInput) SetGenerator(v *Generator) *StartGeneratedCodeJobInput {
	s.Generator = v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *StartGeneratedCodeJobInput) SetSnapshotId(v string) *StartGeneratedCodeJobInput {
	s.SnapshotId = &v
	return s
}

type StartGeneratedCodeJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the code generation job. You can use this identifier in
	// the GetGeneratedCodeJob operation.
	GeneratedCodeJobId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartGeneratedCodeJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartGeneratedCodeJobOutput) GoString() string {
	return s.String()
}

// SetGeneratedCodeJobId sets the GeneratedCodeJobId field's value.
func (s *StartGeneratedCodeJobOutput) SetGeneratedCodeJobId(v string) *StartGeneratedCodeJobOutput {
	s.GeneratedCodeJobId = &v
	return s
}

type StartStageDeploymentInput struct {
	_ struct{} `type:"structure"`

	// A client-defined token. With an active client token in the request, this
	// action is idempotent.
	ClientToken *string `min:"33" type:"string"`

	// The name of the game.
	//
	// GameName is a required field
	GameName *string `location:"uri" locationName:"GameName" min:"1" type:"string" required:"true"`

	// The identifier of the snapshot to deploy.
	//
	// SnapshotId is a required field
	SnapshotId *string `min:"33" type:"string" required:"true"`

	// The name of the stage to deploy the snapshot onto.
	//
	// StageName is a required field
	StageName *string `location:"uri" locationName:"StageName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartStageDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartStageDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartStageDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartStageDeploymentInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 33 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 33))
	}
	if s.GameName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameName"))
	}
	if s.GameName != nil && len(*s.GameName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameName", 1))
	}
	if s.SnapshotId == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotId"))
	}
	if s.SnapshotId != nil && len(*s.SnapshotId) < 33 {
		invalidParams.Add(request.NewErrParamMinLen("SnapshotId", 33))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartStageDeploymentInput) SetClientToken(v string) *StartStageDeploymentInput {
	s.ClientToken = &v
	return s
}

// SetGameName sets the GameName field's value.
func (s *StartStageDeploymentInput) SetGameName(v string) *StartStageDeploymentInput {
	s.GameName = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *StartStageDeploymentInput) SetSnapshotId(v string) *StartStageDeploymentInput {
	s.SnapshotId = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *StartStageDeploymentInput) SetStageName(v string) *StartStageDeploymentInput {
	s.StageName = &v
	return s
}

type StartStageDeploymentOutput struct {
	_ struct{} `type:"structure"`

	// Properties that describe the stage deployment.
	StageDeployment *StageDeploymentDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartStageDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartStageDeploymentOutput) GoString() string {
	return s.String()
}

// SetStageDeployment sets the StageDeployment field's value.
func (s *StartStageDeploymentOutput) SetStageDeployment(v *StageDeploymentDetails) *StartStageDeploymentOutput {
	s.StageDeployment = v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to add the tags to.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" min:"20" type:"string" required:"true"`

	// The tags to add to the resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request throughput limit was exceeded.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource to remove the tags from.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" min:"20" type:"string" required:"true"`

	// The keys of the tags to remove.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateGameConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the game.
	//
	// GameName is a required field
	GameName *string `location:"uri" locationName:"GameName" min:"1" type:"string" required:"true"`

	// The list of modifications to make.
	//
	// Modifications is a required field
	Modifications []*SectionModification `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGameConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGameConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGameConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGameConfigurationInput"}
	if s.GameName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameName"))
	}
	if s.GameName != nil && len(*s.GameName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameName", 1))
	}
	if s.Modifications == nil {
		invalidParams.Add(request.NewErrParamRequired("Modifications"))
	}
	if s.Modifications != nil && len(s.Modifications) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Modifications", 1))
	}
	if s.Modifications != nil {
		for i, v := range s.Modifications {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Modifications", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameName sets the GameName field's value.
func (s *UpdateGameConfigurationInput) SetGameName(v string) *UpdateGameConfigurationInput {
	s.GameName = &v
	return s
}

// SetModifications sets the Modifications field's value.
func (s *UpdateGameConfigurationInput) SetModifications(v []*SectionModification) *UpdateGameConfigurationInput {
	s.Modifications = v
	return s
}

type UpdateGameConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Details about the game configuration.
	GameConfiguration *GameConfigurationDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGameConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGameConfigurationOutput) GoString() string {
	return s.String()
}

// SetGameConfiguration sets the GameConfiguration field's value.
func (s *UpdateGameConfigurationOutput) SetGameConfiguration(v *GameConfigurationDetails) *UpdateGameConfigurationOutput {
	s.GameConfiguration = v
	return s
}

type UpdateGameInput struct {
	_ struct{} `type:"structure"`

	// The description of the game.
	Description *string `type:"string"`

	// The name of the game.
	//
	// GameName is a required field
	GameName *string `location:"uri" locationName:"GameName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGameInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGameInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGameInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGameInput"}
	if s.GameName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameName"))
	}
	if s.GameName != nil && len(*s.GameName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateGameInput) SetDescription(v string) *UpdateGameInput {
	s.Description = &v
	return s
}

// SetGameName sets the GameName field's value.
func (s *UpdateGameInput) SetGameName(v string) *UpdateGameInput {
	s.GameName = &v
	return s
}

type UpdateGameOutput struct {
	_ struct{} `type:"structure"`

	// The details of the game.
	Game *GameDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGameOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGameOutput) GoString() string {
	return s.String()
}

// SetGame sets the Game field's value.
func (s *UpdateGameOutput) SetGame(v *GameDetails) *UpdateGameOutput {
	s.Game = v
	return s
}

type UpdateSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The description of the snapshot.
	Description *string `type:"string"`

	// The name of the game.
	//
	// GameName is a required field
	GameName *string `location:"uri" locationName:"GameName" min:"1" type:"string" required:"true"`

	// The identifier of the snapshot.
	//
	// SnapshotId is a required field
	SnapshotId *string `location:"uri" locationName:"SnapshotId" min:"33" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSnapshotInput"}
	if s.GameName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameName"))
	}
	if s.GameName != nil && len(*s.GameName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameName", 1))
	}
	if s.SnapshotId == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotId"))
	}
	if s.SnapshotId != nil && len(*s.SnapshotId) < 33 {
		invalidParams.Add(request.NewErrParamMinLen("SnapshotId", 33))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateSnapshotInput) SetDescription(v string) *UpdateSnapshotInput {
	s.Description = &v
	return s
}

// SetGameName sets the GameName field's value.
func (s *UpdateSnapshotInput) SetGameName(v string) *UpdateSnapshotInput {
	s.GameName = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *UpdateSnapshotInput) SetSnapshotId(v string) *UpdateSnapshotInput {
	s.SnapshotId = &v
	return s
}

type UpdateSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Properties that provide details of the updated snapshot.
	Snapshot *SnapshotDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSnapshotOutput) GoString() string {
	return s.String()
}

// SetSnapshot sets the Snapshot field's value.
func (s *UpdateSnapshotOutput) SetSnapshot(v *SnapshotDetails) *UpdateSnapshotOutput {
	s.Snapshot = v
	return s
}

type UpdateStageInput struct {
	_ struct{} `type:"structure"`

	// The description of the stage.
	Description *string `type:"string"`

	// The name of the game.
	//
	// GameName is a required field
	GameName *string `location:"uri" locationName:"GameName" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the role to use for the game snapshots
	// deployed to this stage.
	Role *string `min:"20" type:"string"`

	// The name of the stage.
	//
	// StageName is a required field
	StageName *string `location:"uri" locationName:"StageName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateStageInput"}
	if s.GameName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameName"))
	}
	if s.GameName != nil && len(*s.GameName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameName", 1))
	}
	if s.Role != nil && len(*s.Role) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Role", 20))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateStageInput) SetDescription(v string) *UpdateStageInput {
	s.Description = &v
	return s
}

// SetGameName sets the GameName field's value.
func (s *UpdateStageInput) SetGameName(v string) *UpdateStageInput {
	s.GameName = &v
	return s
}

// SetRole sets the Role field's value.
func (s *UpdateStageInput) SetRole(v string) *UpdateStageInput {
	s.Role = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *UpdateStageInput) SetStageName(v string) *UpdateStageInput {
	s.StageName = &v
	return s
}

type UpdateStageOutput struct {
	_ struct{} `type:"structure"`

	// Properties that provide details of the updated stage.
	Stage *StageDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStageOutput) GoString() string {
	return s.String()
}

// SetStage sets the Stage field's value.
func (s *UpdateStageOutput) SetStage(v *StageDetails) *UpdateStageOutput {
	s.Stage = v
	return s
}

// One of the parameters in the request is invalid.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// DeploymentActionDeploy is a DeploymentAction enum value
	DeploymentActionDeploy = "DEPLOY"

	// DeploymentActionUndeploy is a DeploymentAction enum value
	DeploymentActionUndeploy = "UNDEPLOY"
)

// DeploymentAction_Values returns all elements of the DeploymentAction enum
func DeploymentAction_Values() []string {
	return []string{
		DeploymentActionDeploy,
		DeploymentActionUndeploy,
	}
}

const (
	// DeploymentStatePending is a DeploymentState enum value
	DeploymentStatePending = "PENDING"

	// DeploymentStateInProgress is a DeploymentState enum value
	DeploymentStateInProgress = "IN_PROGRESS"

	// DeploymentStateCompleted is a DeploymentState enum value
	DeploymentStateCompleted = "COMPLETED"

	// DeploymentStateFailed is a DeploymentState enum value
	DeploymentStateFailed = "FAILED"
)

// DeploymentState_Values returns all elements of the DeploymentState enum
func DeploymentState_Values() []string {
	return []string{
		DeploymentStatePending,
		DeploymentStateInProgress,
		DeploymentStateCompleted,
		DeploymentStateFailed,
	}
}

const (
	// GameStateActive is a GameState enum value
	GameStateActive = "ACTIVE"

	// GameStateDeleting is a GameState enum value
	GameStateDeleting = "DELETING"
)

// GameState_Values returns all elements of the GameState enum
func GameState_Values() []string {
	return []string{
		GameStateActive,
		GameStateDeleting,
	}
}

const (
	// GeneratedCodeJobStateInProgress is a GeneratedCodeJobState enum value
	GeneratedCodeJobStateInProgress = "IN_PROGRESS"

	// GeneratedCodeJobStateCompleted is a GeneratedCodeJobState enum value
	GeneratedCodeJobStateCompleted = "COMPLETED"

	// GeneratedCodeJobStateFailed is a GeneratedCodeJobState enum value
	GeneratedCodeJobStateFailed = "FAILED"

	// GeneratedCodeJobStatePending is a GeneratedCodeJobState enum value
	GeneratedCodeJobStatePending = "PENDING"
)

// GeneratedCodeJobState_Values returns all elements of the GeneratedCodeJobState enum
func GeneratedCodeJobState_Values() []string {
	return []string{
		GeneratedCodeJobStateInProgress,
		GeneratedCodeJobStateCompleted,
		GeneratedCodeJobStateFailed,
		GeneratedCodeJobStatePending,
	}
}

const (
	// OperationAdd is a Operation enum value
	OperationAdd = "ADD"

	// OperationRemove is a Operation enum value
	OperationRemove = "REMOVE"

	// OperationReplace is a Operation enum value
	OperationReplace = "REPLACE"
)

// Operation_Values returns all elements of the Operation enum
func Operation_Values() []string {
	return []string{
		OperationAdd,
		OperationRemove,
		OperationReplace,
	}
}

const (
	// ResultCodeSuccess is a ResultCode enum value
	ResultCodeSuccess = "SUCCESS"

	// ResultCodeInvalidRoleFailure is a ResultCode enum value
	ResultCodeInvalidRoleFailure = "INVALID_ROLE_FAILURE"

	// ResultCodeUnspecifiedFailure is a ResultCode enum value
	ResultCodeUnspecifiedFailure = "UNSPECIFIED_FAILURE"
)

// ResultCode_Values returns all elements of the ResultCode enum
func ResultCode_Values() []string {
	return []string{
		ResultCodeSuccess,
		ResultCodeInvalidRoleFailure,
		ResultCodeUnspecifiedFailure,
	}
}

const (
	// StageStateActive is a StageState enum value
	StageStateActive = "ACTIVE"

	// StageStateDeleting is a StageState enum value
	StageStateDeleting = "DELETING"
)

// StageState_Values returns all elements of the StageState enum
func StageState_Values() []string {
	return []string{
		StageStateActive,
		StageStateDeleting,
	}
}
