// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/functions/v1/functions.proto

package functionspb

import (
	iampb "cloud.google.com/go/iam/apiv1/iampb"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	CloudFunctionsService_ListFunctions_FullMethodName       = "/google.cloud.functions.v1.CloudFunctionsService/ListFunctions"
	CloudFunctionsService_GetFunction_FullMethodName         = "/google.cloud.functions.v1.CloudFunctionsService/GetFunction"
	CloudFunctionsService_CreateFunction_FullMethodName      = "/google.cloud.functions.v1.CloudFunctionsService/CreateFunction"
	CloudFunctionsService_UpdateFunction_FullMethodName      = "/google.cloud.functions.v1.CloudFunctionsService/UpdateFunction"
	CloudFunctionsService_DeleteFunction_FullMethodName      = "/google.cloud.functions.v1.CloudFunctionsService/DeleteFunction"
	CloudFunctionsService_CallFunction_FullMethodName        = "/google.cloud.functions.v1.CloudFunctionsService/CallFunction"
	CloudFunctionsService_GenerateUploadUrl_FullMethodName   = "/google.cloud.functions.v1.CloudFunctionsService/GenerateUploadUrl"
	CloudFunctionsService_GenerateDownloadUrl_FullMethodName = "/google.cloud.functions.v1.CloudFunctionsService/GenerateDownloadUrl"
	CloudFunctionsService_SetIamPolicy_FullMethodName        = "/google.cloud.functions.v1.CloudFunctionsService/SetIamPolicy"
	CloudFunctionsService_GetIamPolicy_FullMethodName        = "/google.cloud.functions.v1.CloudFunctionsService/GetIamPolicy"
	CloudFunctionsService_TestIamPermissions_FullMethodName  = "/google.cloud.functions.v1.CloudFunctionsService/TestIamPermissions"
)

// CloudFunctionsServiceClient is the client API for CloudFunctionsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type CloudFunctionsServiceClient interface {
	// Returns a list of functions that belong to the requested project.
	ListFunctions(ctx context.Context, in *ListFunctionsRequest, opts ...grpc.CallOption) (*ListFunctionsResponse, error)
	// Returns a function with the given name from the requested project.
	GetFunction(ctx context.Context, in *GetFunctionRequest, opts ...grpc.CallOption) (*CloudFunction, error)
	// Creates a new function. If a function with the given name already exists in
	// the specified project, the long running operation will return
	// `ALREADY_EXISTS` error.
	CreateFunction(ctx context.Context, in *CreateFunctionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates existing function.
	UpdateFunction(ctx context.Context, in *UpdateFunctionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a function with the given name from the specified project. If the
	// given function is used by some trigger, the trigger will be updated to
	// remove this function.
	DeleteFunction(ctx context.Context, in *DeleteFunctionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Synchronously invokes a deployed Cloud Function. To be used for testing
	// purposes as very limited traffic is allowed. For more information on
	// the actual limits, refer to
	// [Rate Limits](https://cloud.google.com/functions/quotas#rate_limits).
	CallFunction(ctx context.Context, in *CallFunctionRequest, opts ...grpc.CallOption) (*CallFunctionResponse, error)
	// Returns a signed URL for uploading a function source code.
	// For more information about the signed URL usage see:
	// https://cloud.google.com/storage/docs/access-control/signed-urls.
	// Once the function source code upload is complete, the used signed
	// URL should be provided in CreateFunction or UpdateFunction request
	// as a reference to the function source code.
	//
	// When uploading source code to the generated signed URL, please follow
	// these restrictions:
	//
	//   - Source file type should be a zip file.
	//   - Source file size should not exceed 100MB limit.
	//   - No credentials should be attached - the signed URLs provide access to the
	//     target bucket using internal service identity; if credentials were
	//     attached, the identity from the credentials would be used, but that
	//     identity does not have permissions to upload files to the URL.
	//
	// When making a HTTP PUT request, these two headers need to be specified:
	//
	// * `content-type: application/zip`
	// * `x-goog-content-length-range: 0,104857600`
	//
	// And this header SHOULD NOT be specified:
	//
	// * `Authorization: Bearer YOUR_TOKEN`
	GenerateUploadUrl(ctx context.Context, in *GenerateUploadUrlRequest, opts ...grpc.CallOption) (*GenerateUploadUrlResponse, error)
	// Returns a signed URL for downloading deployed function source code.
	// The URL is only valid for a limited period and should be used within
	// minutes after generation.
	// For more information about the signed URL usage see:
	// https://cloud.google.com/storage/docs/access-control/signed-urls
	GenerateDownloadUrl(ctx context.Context, in *GenerateDownloadUrlRequest, opts ...grpc.CallOption) (*GenerateDownloadUrlResponse, error)
	// Sets the IAM access control policy on the specified function.
	// Replaces any existing policy.
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Gets the IAM access control policy for a function.
	// Returns an empty policy if the function exists and does not have a policy
	// set.
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Tests the specified permissions against the IAM access control policy
	// for a function.
	// If the function does not exist, this will return an empty set of
	// permissions, not a NOT_FOUND error.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
}

type cloudFunctionsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCloudFunctionsServiceClient(cc grpc.ClientConnInterface) CloudFunctionsServiceClient {
	return &cloudFunctionsServiceClient{cc}
}

func (c *cloudFunctionsServiceClient) ListFunctions(ctx context.Context, in *ListFunctionsRequest, opts ...grpc.CallOption) (*ListFunctionsResponse, error) {
	out := new(ListFunctionsResponse)
	err := c.cc.Invoke(ctx, CloudFunctionsService_ListFunctions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) GetFunction(ctx context.Context, in *GetFunctionRequest, opts ...grpc.CallOption) (*CloudFunction, error) {
	out := new(CloudFunction)
	err := c.cc.Invoke(ctx, CloudFunctionsService_GetFunction_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) CreateFunction(ctx context.Context, in *CreateFunctionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudFunctionsService_CreateFunction_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) UpdateFunction(ctx context.Context, in *UpdateFunctionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudFunctionsService_UpdateFunction_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) DeleteFunction(ctx context.Context, in *DeleteFunctionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudFunctionsService_DeleteFunction_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) CallFunction(ctx context.Context, in *CallFunctionRequest, opts ...grpc.CallOption) (*CallFunctionResponse, error) {
	out := new(CallFunctionResponse)
	err := c.cc.Invoke(ctx, CloudFunctionsService_CallFunction_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) GenerateUploadUrl(ctx context.Context, in *GenerateUploadUrlRequest, opts ...grpc.CallOption) (*GenerateUploadUrlResponse, error) {
	out := new(GenerateUploadUrlResponse)
	err := c.cc.Invoke(ctx, CloudFunctionsService_GenerateUploadUrl_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) GenerateDownloadUrl(ctx context.Context, in *GenerateDownloadUrlRequest, opts ...grpc.CallOption) (*GenerateDownloadUrlResponse, error) {
	out := new(GenerateDownloadUrlResponse)
	err := c.cc.Invoke(ctx, CloudFunctionsService_GenerateDownloadUrl_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, CloudFunctionsService_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, CloudFunctionsService_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, CloudFunctionsService_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudFunctionsServiceServer is the server API for CloudFunctionsService service.
// All implementations should embed UnimplementedCloudFunctionsServiceServer
// for forward compatibility
type CloudFunctionsServiceServer interface {
	// Returns a list of functions that belong to the requested project.
	ListFunctions(context.Context, *ListFunctionsRequest) (*ListFunctionsResponse, error)
	// Returns a function with the given name from the requested project.
	GetFunction(context.Context, *GetFunctionRequest) (*CloudFunction, error)
	// Creates a new function. If a function with the given name already exists in
	// the specified project, the long running operation will return
	// `ALREADY_EXISTS` error.
	CreateFunction(context.Context, *CreateFunctionRequest) (*longrunningpb.Operation, error)
	// Updates existing function.
	UpdateFunction(context.Context, *UpdateFunctionRequest) (*longrunningpb.Operation, error)
	// Deletes a function with the given name from the specified project. If the
	// given function is used by some trigger, the trigger will be updated to
	// remove this function.
	DeleteFunction(context.Context, *DeleteFunctionRequest) (*longrunningpb.Operation, error)
	// Synchronously invokes a deployed Cloud Function. To be used for testing
	// purposes as very limited traffic is allowed. For more information on
	// the actual limits, refer to
	// [Rate Limits](https://cloud.google.com/functions/quotas#rate_limits).
	CallFunction(context.Context, *CallFunctionRequest) (*CallFunctionResponse, error)
	// Returns a signed URL for uploading a function source code.
	// For more information about the signed URL usage see:
	// https://cloud.google.com/storage/docs/access-control/signed-urls.
	// Once the function source code upload is complete, the used signed
	// URL should be provided in CreateFunction or UpdateFunction request
	// as a reference to the function source code.
	//
	// When uploading source code to the generated signed URL, please follow
	// these restrictions:
	//
	//   - Source file type should be a zip file.
	//   - Source file size should not exceed 100MB limit.
	//   - No credentials should be attached - the signed URLs provide access to the
	//     target bucket using internal service identity; if credentials were
	//     attached, the identity from the credentials would be used, but that
	//     identity does not have permissions to upload files to the URL.
	//
	// When making a HTTP PUT request, these two headers need to be specified:
	//
	// * `content-type: application/zip`
	// * `x-goog-content-length-range: 0,104857600`
	//
	// And this header SHOULD NOT be specified:
	//
	// * `Authorization: Bearer YOUR_TOKEN`
	GenerateUploadUrl(context.Context, *GenerateUploadUrlRequest) (*GenerateUploadUrlResponse, error)
	// Returns a signed URL for downloading deployed function source code.
	// The URL is only valid for a limited period and should be used within
	// minutes after generation.
	// For more information about the signed URL usage see:
	// https://cloud.google.com/storage/docs/access-control/signed-urls
	GenerateDownloadUrl(context.Context, *GenerateDownloadUrlRequest) (*GenerateDownloadUrlResponse, error)
	// Sets the IAM access control policy on the specified function.
	// Replaces any existing policy.
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Gets the IAM access control policy for a function.
	// Returns an empty policy if the function exists and does not have a policy
	// set.
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Tests the specified permissions against the IAM access control policy
	// for a function.
	// If the function does not exist, this will return an empty set of
	// permissions, not a NOT_FOUND error.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
}

// UnimplementedCloudFunctionsServiceServer should be embedded to have forward compatible implementations.
type UnimplementedCloudFunctionsServiceServer struct {
}

func (UnimplementedCloudFunctionsServiceServer) ListFunctions(context.Context, *ListFunctionsRequest) (*ListFunctionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFunctions not implemented")
}
func (UnimplementedCloudFunctionsServiceServer) GetFunction(context.Context, *GetFunctionRequest) (*CloudFunction, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFunction not implemented")
}
func (UnimplementedCloudFunctionsServiceServer) CreateFunction(context.Context, *CreateFunctionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFunction not implemented")
}
func (UnimplementedCloudFunctionsServiceServer) UpdateFunction(context.Context, *UpdateFunctionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFunction not implemented")
}
func (UnimplementedCloudFunctionsServiceServer) DeleteFunction(context.Context, *DeleteFunctionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFunction not implemented")
}
func (UnimplementedCloudFunctionsServiceServer) CallFunction(context.Context, *CallFunctionRequest) (*CallFunctionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CallFunction not implemented")
}
func (UnimplementedCloudFunctionsServiceServer) GenerateUploadUrl(context.Context, *GenerateUploadUrlRequest) (*GenerateUploadUrlResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateUploadUrl not implemented")
}
func (UnimplementedCloudFunctionsServiceServer) GenerateDownloadUrl(context.Context, *GenerateDownloadUrlRequest) (*GenerateDownloadUrlResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateDownloadUrl not implemented")
}
func (UnimplementedCloudFunctionsServiceServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedCloudFunctionsServiceServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedCloudFunctionsServiceServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafeCloudFunctionsServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to CloudFunctionsServiceServer will
// result in compilation errors.
type UnsafeCloudFunctionsServiceServer interface {
	mustEmbedUnimplementedCloudFunctionsServiceServer()
}

func RegisterCloudFunctionsServiceServer(s grpc.ServiceRegistrar, srv CloudFunctionsServiceServer) {
	s.RegisterService(&CloudFunctionsService_ServiceDesc, srv)
}

func _CloudFunctionsService_ListFunctions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFunctionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).ListFunctions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudFunctionsService_ListFunctions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).ListFunctions(ctx, req.(*ListFunctionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_GetFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).GetFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudFunctionsService_GetFunction_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).GetFunction(ctx, req.(*GetFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_CreateFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).CreateFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudFunctionsService_CreateFunction_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).CreateFunction(ctx, req.(*CreateFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_UpdateFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).UpdateFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudFunctionsService_UpdateFunction_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).UpdateFunction(ctx, req.(*UpdateFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_DeleteFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).DeleteFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudFunctionsService_DeleteFunction_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).DeleteFunction(ctx, req.(*DeleteFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_CallFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CallFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).CallFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudFunctionsService_CallFunction_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).CallFunction(ctx, req.(*CallFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_GenerateUploadUrl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateUploadUrlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).GenerateUploadUrl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudFunctionsService_GenerateUploadUrl_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).GenerateUploadUrl(ctx, req.(*GenerateUploadUrlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_GenerateDownloadUrl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateDownloadUrlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).GenerateDownloadUrl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudFunctionsService_GenerateDownloadUrl_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).GenerateDownloadUrl(ctx, req.(*GenerateDownloadUrlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudFunctionsService_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudFunctionsService_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudFunctionsService_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// CloudFunctionsService_ServiceDesc is the grpc.ServiceDesc for CloudFunctionsService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var CloudFunctionsService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.functions.v1.CloudFunctionsService",
	HandlerType: (*CloudFunctionsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListFunctions",
			Handler:    _CloudFunctionsService_ListFunctions_Handler,
		},
		{
			MethodName: "GetFunction",
			Handler:    _CloudFunctionsService_GetFunction_Handler,
		},
		{
			MethodName: "CreateFunction",
			Handler:    _CloudFunctionsService_CreateFunction_Handler,
		},
		{
			MethodName: "UpdateFunction",
			Handler:    _CloudFunctionsService_UpdateFunction_Handler,
		},
		{
			MethodName: "DeleteFunction",
			Handler:    _CloudFunctionsService_DeleteFunction_Handler,
		},
		{
			MethodName: "CallFunction",
			Handler:    _CloudFunctionsService_CallFunction_Handler,
		},
		{
			MethodName: "GenerateUploadUrl",
			Handler:    _CloudFunctionsService_GenerateUploadUrl_Handler,
		},
		{
			MethodName: "GenerateDownloadUrl",
			Handler:    _CloudFunctionsService_GenerateDownloadUrl_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _CloudFunctionsService_SetIamPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _CloudFunctionsService_GetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _CloudFunctionsService_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/functions/v1/functions.proto",
}
