/*
 * Decompiled with CFR 0.152.
 */
package liquibase.statement.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import liquibase.statement.AbstractSqlStatement;
import liquibase.statement.core.DatabaseTableIdentifier;

public class UpdateStatement
extends AbstractSqlStatement {
    private final SortedMap<String, Object> newColumnValues = new TreeMap<String, Object>();
    private String whereClause;
    private final List<String> whereColumnNames = new ArrayList<String>();
    private final List<Object> whereParameters = new ArrayList<Object>();
    private DatabaseTableIdentifier databaseTableIdentifier = new DatabaseTableIdentifier(null, null, null);

    public UpdateStatement(String catalogName, String schemaName, String tableName) {
        this.databaseTableIdentifier.setCatalogName(catalogName);
        this.databaseTableIdentifier.setSchemaName(schemaName);
        this.databaseTableIdentifier.setTableName(tableName);
    }

    public String getCatalogName() {
        return this.databaseTableIdentifier.getCatalogName();
    }

    public String getSchemaName() {
        return this.databaseTableIdentifier.getSchemaName();
    }

    public String getTableName() {
        return this.databaseTableIdentifier.getTableName();
    }

    public UpdateStatement addNewColumnValue(String columnName, Object newValue) {
        this.newColumnValues.put(columnName, newValue);
        return this;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public UpdateStatement setWhereClause(String whereClause) {
        this.whereClause = whereClause;
        return this;
    }

    public UpdateStatement addWhereParameter(Object value) {
        this.whereParameters.add(value);
        return this;
    }

    public UpdateStatement addWhereParameters(Object ... value) {
        this.whereParameters.addAll(Arrays.asList(value));
        return this;
    }

    public UpdateStatement addWhereColumnName(String value) {
        this.whereColumnNames.add(value);
        return this;
    }

    public Map<String, Object> getNewColumnValues() {
        return this.newColumnValues;
    }

    public List<Object> getWhereParameters() {
        return this.whereParameters;
    }

    public List<String> getWhereColumnNames() {
        return this.whereColumnNames;
    }
}

