/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.newsclub.net.unix.AFProtocolFamily;
import org.newsclub.net.unix.AFSelectorProvider;
import org.newsclub.net.unix.AFServerSocket;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFSocketChannel;
import org.newsclub.net.unix.AFSocketCore;
import org.newsclub.net.unix.AFSocketOption;
import org.newsclub.net.unix.AFSomeSocketChannel;
import org.newsclub.net.unix.AFUNIXServerSocketChannel;
import org.newsclub.net.unix.FileDescriptorAccess;
import org.newsclub.net.unix.InterruptibleChannelUtil;
import org.newsclub.net.unix.SocketOptionsMapper;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class AFServerSocketChannel<A extends AFSocketAddress>
extends ServerSocketChannel
implements FileDescriptorAccess,
AFSomeSocketChannel {
    private final @NonNull AFServerSocket<A> afSocket;

    protected AFServerSocketChannel(AFServerSocket<A> socket, AFSelectorProvider<A> sp) {
        super(sp);
        this.afSocket = Objects.requireNonNull(socket);
    }

    @Override
    public <T> T getOption(SocketOption<T> name) throws IOException {
        if (name instanceof AFSocketOption) {
            return this.getAFCore().getOption((AFSocketOption)name);
        }
        Integer optionId = SocketOptionsMapper.resolve(name);
        if (optionId == null) {
            throw new UnsupportedOperationException("unsupported option");
        }
        return (T)this.afSocket.getAFImpl().getOption(optionId);
    }

    @Override
    public <T> AFServerSocketChannel<A> setOption(SocketOption<T> name, T value) throws IOException {
        if (name instanceof AFSocketOption) {
            this.getAFCore().setOption((AFSocketOption)name, value);
            return this;
        }
        Integer optionId = SocketOptionsMapper.resolve(name);
        if (optionId == null) {
            throw new UnsupportedOperationException("unsupported option");
        }
        this.afSocket.getAFImpl().setOption(optionId, value);
        return this;
    }

    @Override
    public final Set<SocketOption<?>> supportedOptions() {
        return SocketOptionsMapper.SUPPORTED_SOCKET_OPTIONS;
    }

    @Override
    public final AFServerSocketChannel<A> bind(SocketAddress local, int backlog) throws IOException {
        this.afSocket.bind(local, backlog);
        return this;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public final AFServerSocket<A> socket() {
        return this.afSocket;
    }

    @Override
    public AFSocketChannel<A> accept() throws IOException {
        boolean complete = false;
        Exception exception = null;
        try {
            this.begin();
            AFSocket<A> socket = this.afSocket.accept1(false);
            complete = true;
            SocketChannel socketChannel = socket == null ? null : socket.getChannel();
            return socketChannel;
        }
        catch (IOException e) {
            exception = InterruptibleChannelUtil.handleException(this, e);
            throw InterruptibleChannelUtil.ioExceptionOrThrowRuntimeException(exception);
        }
        finally {
            InterruptibleChannelUtil.endInterruptable(this, x$0 -> this.end(x$0), complete, exception);
        }
    }

    public final @Nullable A getLocalAddress() {
        return (A)this.getLocalSocketAddress();
    }

    public final @Nullable A getLocalSocketAddress() {
        return (A)this.afSocket.getLocalSocketAddress();
    }

    public final boolean isLocalSocketAddressValid() {
        return this.afSocket.isLocalSocketAddressValid();
    }

    @Override
    protected final void implCloseSelectableChannel() throws IOException {
        this.afSocket.close();
    }

    @Override
    protected final void implConfigureBlocking(boolean block) throws IOException {
        this.getAFCore().implConfigureBlocking(block);
    }

    final AFSocketCore getAFCore() {
        return this.afSocket.getAFImpl().getCore();
    }

    @Override
    public final FileDescriptor getFileDescriptor() throws IOException {
        return this.afSocket.getFileDescriptor();
    }

    public final boolean isDeleteOnClose() {
        return ((AFServerSocket)this.socket()).isDeleteOnClose();
    }

    public final void setDeleteOnClose(boolean b) {
        ((AFServerSocket)this.socket()).setDeleteOnClose(b);
    }

    @Override
    public void setShutdownOnClose(boolean enabled) {
        ((AFServerSocket)this.socket()).setShutdownOnClose(enabled);
    }

    public static ServerSocketChannel open(ProtocolFamily family) throws IOException {
        Objects.requireNonNull(family);
        if (family instanceof AFProtocolFamily) {
            return ((AFProtocolFamily)family).openServerSocketChannel();
        }
        if ("UNIX".equals(family.name())) {
            return AFUNIXServerSocketChannel.open();
        }
        if (family instanceof StandardProtocolFamily) {
            return ServerSocketChannel.open();
        }
        throw new UnsupportedOperationException("Protocol family not supported");
    }
}

