/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.aad.msal4j.ITokenCacheAccessAspect;
import com.microsoft.aad.msal4j.ITokenCacheAccessContext;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class PersistentTokenCacheAccessAspect
implements ITokenCacheAccessAspect {
    private static PersistentTokenCacheAccessAspect instance;
    private final Lock lock = new ReentrantLock();
    static final long TIME_TO_LIVE = 86400000L;
    private long expiryTime;
    private String cache = null;

    static PersistentTokenCacheAccessAspect getInstance() {
        if (instance == null) {
            instance = new PersistentTokenCacheAccessAspect();
        }
        return instance;
    }

    public void beforeCacheAccess(ITokenCacheAccessContext iTokenCacheAccessContext) {
        this.lock.lock();
        try {
            if (null != this.cache && null != iTokenCacheAccessContext && null != iTokenCacheAccessContext.tokenCache()) {
                iTokenCacheAccessContext.tokenCache().deserialize(this.cache);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void afterCacheAccess(ITokenCacheAccessContext iTokenCacheAccessContext) {
        this.lock.lock();
        try {
            if (null != iTokenCacheAccessContext && iTokenCacheAccessContext.hasCacheChanged() && null != iTokenCacheAccessContext.tokenCache()) {
                this.cache = iTokenCacheAccessContext.tokenCache().serialize();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(long expiryTime) {
        this.expiryTime = expiryTime;
    }

    static void clearUserTokenCache() {
        if (null != PersistentTokenCacheAccessAspect.instance.cache && !PersistentTokenCacheAccessAspect.instance.cache.isEmpty()) {
            PersistentTokenCacheAccessAspect.instance.cache = null;
        }
    }
}

