// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pi

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opDescribeDimensionKeys = "DescribeDimensionKeys"

// DescribeDimensionKeysRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDimensionKeys operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDimensionKeys for more information on using the DescribeDimensionKeys
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDimensionKeysRequest method.
//    req, resp := client.DescribeDimensionKeysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/DescribeDimensionKeys
func (c *PI) DescribeDimensionKeysRequest(input *DescribeDimensionKeysInput) (req *request.Request, output *DescribeDimensionKeysOutput) {
	op := &request.Operation{
		Name:       opDescribeDimensionKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDimensionKeysInput{}
	}

	output = &DescribeDimensionKeysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDimensionKeys API operation for AWS Performance Insights.
//
// For a specific time period, retrieve the top N dimension keys for a metric.
//
// Each response element returns a maximum of 500 bytes. For larger elements,
// such as SQL statements, only the first 500 bytes are returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Performance Insights's
// API operation DescribeDimensionKeys for usage and error information.
//
// Returned Error Types:
//   * InvalidArgumentException
//   One of the arguments provided is invalid for this request.
//
//   * InternalServiceError
//   The request failed due to an unknown error.
//
//   * NotAuthorizedException
//   The user is not authorized to perform this request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/DescribeDimensionKeys
func (c *PI) DescribeDimensionKeys(input *DescribeDimensionKeysInput) (*DescribeDimensionKeysOutput, error) {
	req, out := c.DescribeDimensionKeysRequest(input)
	return out, req.Send()
}

// DescribeDimensionKeysWithContext is the same as DescribeDimensionKeys with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDimensionKeys for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PI) DescribeDimensionKeysWithContext(ctx aws.Context, input *DescribeDimensionKeysInput, opts ...request.Option) (*DescribeDimensionKeysOutput, error) {
	req, out := c.DescribeDimensionKeysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDimensionKeyDetails = "GetDimensionKeyDetails"

// GetDimensionKeyDetailsRequest generates a "aws/request.Request" representing the
// client's request for the GetDimensionKeyDetails operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDimensionKeyDetails for more information on using the GetDimensionKeyDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDimensionKeyDetailsRequest method.
//    req, resp := client.GetDimensionKeyDetailsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/GetDimensionKeyDetails
func (c *PI) GetDimensionKeyDetailsRequest(input *GetDimensionKeyDetailsInput) (req *request.Request, output *GetDimensionKeyDetailsOutput) {
	op := &request.Operation{
		Name:       opGetDimensionKeyDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDimensionKeyDetailsInput{}
	}

	output = &GetDimensionKeyDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDimensionKeyDetails API operation for AWS Performance Insights.
//
// Get the attributes of the specified dimension group for a DB instance or
// data source. For example, if you specify a SQL ID, GetDimensionKeyDetails
// retrieves the full text of the dimension db.sql.statement associated with
// this ID. This operation is useful because GetResourceMetrics and DescribeDimensionKeys
// don't support retrieval of large SQL statement text.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Performance Insights's
// API operation GetDimensionKeyDetails for usage and error information.
//
// Returned Error Types:
//   * InvalidArgumentException
//   One of the arguments provided is invalid for this request.
//
//   * InternalServiceError
//   The request failed due to an unknown error.
//
//   * NotAuthorizedException
//   The user is not authorized to perform this request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/GetDimensionKeyDetails
func (c *PI) GetDimensionKeyDetails(input *GetDimensionKeyDetailsInput) (*GetDimensionKeyDetailsOutput, error) {
	req, out := c.GetDimensionKeyDetailsRequest(input)
	return out, req.Send()
}

// GetDimensionKeyDetailsWithContext is the same as GetDimensionKeyDetails with the addition of
// the ability to pass a context and additional request options.
//
// See GetDimensionKeyDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PI) GetDimensionKeyDetailsWithContext(ctx aws.Context, input *GetDimensionKeyDetailsInput, opts ...request.Option) (*GetDimensionKeyDetailsOutput, error) {
	req, out := c.GetDimensionKeyDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResourceMetrics = "GetResourceMetrics"

// GetResourceMetricsRequest generates a "aws/request.Request" representing the
// client's request for the GetResourceMetrics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourceMetrics for more information on using the GetResourceMetrics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResourceMetricsRequest method.
//    req, resp := client.GetResourceMetricsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/GetResourceMetrics
func (c *PI) GetResourceMetricsRequest(input *GetResourceMetricsInput) (req *request.Request, output *GetResourceMetricsOutput) {
	op := &request.Operation{
		Name:       opGetResourceMetrics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResourceMetricsInput{}
	}

	output = &GetResourceMetricsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourceMetrics API operation for AWS Performance Insights.
//
// Retrieve Performance Insights metrics for a set of data sources, over a time
// period. You can provide specific dimension groups and dimensions, and provide
// aggregation and filtering criteria for each group.
//
// Each response element returns a maximum of 500 bytes. For larger elements,
// such as SQL statements, only the first 500 bytes are returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Performance Insights's
// API operation GetResourceMetrics for usage and error information.
//
// Returned Error Types:
//   * InvalidArgumentException
//   One of the arguments provided is invalid for this request.
//
//   * InternalServiceError
//   The request failed due to an unknown error.
//
//   * NotAuthorizedException
//   The user is not authorized to perform this request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/GetResourceMetrics
func (c *PI) GetResourceMetrics(input *GetResourceMetricsInput) (*GetResourceMetricsOutput, error) {
	req, out := c.GetResourceMetricsRequest(input)
	return out, req.Send()
}

// GetResourceMetricsWithContext is the same as GetResourceMetrics with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourceMetrics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PI) GetResourceMetricsWithContext(ctx aws.Context, input *GetResourceMetricsInput, opts ...request.Option) (*GetResourceMetricsOutput, error) {
	req, out := c.GetResourceMetricsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// A timestamp, and a single numerical value, which together represent a measurement
// at a particular point in time.
type DataPoint struct {
	_ struct{} `type:"structure"`

	// The time, in epoch format, associated with a particular Value.
	//
	// Timestamp is a required field
	Timestamp *time.Time `type:"timestamp" required:"true"`

	// The actual value associated with a particular Timestamp.
	//
	// Value is a required field
	Value *float64 `type:"double" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataPoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataPoint) GoString() string {
	return s.String()
}

// SetTimestamp sets the Timestamp field's value.
func (s *DataPoint) SetTimestamp(v time.Time) *DataPoint {
	s.Timestamp = &v
	return s
}

// SetValue sets the Value field's value.
func (s *DataPoint) SetValue(v float64) *DataPoint {
	s.Value = &v
	return s
}

type DescribeDimensionKeysInput struct {
	_ struct{} `type:"structure"`

	// The date and time specifying the end of the requested time series data. The
	// value specified is exclusive, which means that data points less than (but
	// not equal to) EndTime are returned.
	//
	// The value for EndTime must be later than the value for StartTime.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// One or more filters to apply in the request. Restrictions:
	//
	//    * Any number of filters by the same dimension, as specified in the GroupBy
	//    or Partition parameters.
	//
	//    * A single filter for any other dimension in this dimension group.
	Filter map[string]*string `type:"map"`

	// A specification for how to aggregate the data points from a query result.
	// You must specify a valid dimension group. Performance Insights returns all
	// dimensions within this group, unless you provide the names of specific dimensions
	// within this group. You can also request that Performance Insights return
	// a limited number of values for a dimension.
	//
	// GroupBy is a required field
	GroupBy *DimensionGroup `type:"structure" required:"true"`

	// An immutable, AWS Region-unique identifier for a data source. Performance
	// Insights gathers metrics from this data source.
	//
	// To use an Amazon RDS instance as a data source, you specify its DbiResourceId
	// value. For example, specify db-FAIHNTYBKTGAUSUZQYPDS2GW4A
	//
	// Identifier is a required field
	Identifier *string `type:"string" required:"true"`

	// The maximum number of items to return in the response. If more items exist
	// than the specified MaxRecords value, a pagination token is included in the
	// response so that the remaining results can be retrieved.
	MaxResults *int64 `type:"integer"`

	// The name of a Performance Insights metric to be measured.
	//
	// Valid values for Metric are:
	//
	//    * db.load.avg - a scaled representation of the number of active sessions
	//    for the database engine.
	//
	//    * db.sampledload.avg - the raw number of active sessions for the database
	//    engine.
	//
	// If the number of active sessions is less than an internal Performance Insights
	// threshold, db.load.avg and db.sampledload.avg are the same value. If the
	// number of active sessions is greater than the internal threshold, Performance
	// Insights samples the active sessions, with db.load.avg showing the scaled
	// values, db.sampledload.avg showing the raw values, and db.sampledload.avg
	// less than db.load.avg. For most use cases, you can query db.load.avg only.
	//
	// Metric is a required field
	Metric *string `type:"string" required:"true"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the token, up to
	// the value specified by MaxRecords.
	NextToken *string `min:"1" type:"string"`

	// For each dimension specified in GroupBy, specify a secondary dimension to
	// further subdivide the partition keys in the response.
	PartitionBy *DimensionGroup `type:"structure"`

	// The granularity, in seconds, of the data points returned from Performance
	// Insights. A period can be as short as one second, or as long as one day (86400
	// seconds). Valid values are:
	//
	//    * 1 (one second)
	//
	//    * 60 (one minute)
	//
	//    * 300 (five minutes)
	//
	//    * 3600 (one hour)
	//
	//    * 86400 (twenty-four hours)
	//
	// If you don't specify PeriodInSeconds, then Performance Insights chooses a
	// value for you, with a goal of returning roughly 100-200 data points in the
	// response.
	PeriodInSeconds *int64 `type:"integer"`

	// The AWS service for which Performance Insights will return metrics. The only
	// valid value for ServiceType is RDS.
	//
	// ServiceType is a required field
	ServiceType *string `type:"string" required:"true" enum:"ServiceType"`

	// The date and time specifying the beginning of the requested time series data.
	// You must specify a StartTime within the past 7 days. The value specified
	// is inclusive, which means that data points equal to or greater than StartTime
	// are returned.
	//
	// The value for StartTime must be earlier than the value for EndTime.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDimensionKeysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDimensionKeysInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDimensionKeysInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDimensionKeysInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.GroupBy == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupBy"))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Metric == nil {
		invalidParams.Add(request.NewErrParamRequired("Metric"))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ServiceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceType"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}
	if s.GroupBy != nil {
		if err := s.GroupBy.Validate(); err != nil {
			invalidParams.AddNested("GroupBy", err.(request.ErrInvalidParams))
		}
	}
	if s.PartitionBy != nil {
		if err := s.PartitionBy.Validate(); err != nil {
			invalidParams.AddNested("PartitionBy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeDimensionKeysInput) SetEndTime(v time.Time) *DescribeDimensionKeysInput {
	s.EndTime = &v
	return s
}

// SetFilter sets the Filter field's value.
func (s *DescribeDimensionKeysInput) SetFilter(v map[string]*string) *DescribeDimensionKeysInput {
	s.Filter = v
	return s
}

// SetGroupBy sets the GroupBy field's value.
func (s *DescribeDimensionKeysInput) SetGroupBy(v *DimensionGroup) *DescribeDimensionKeysInput {
	s.GroupBy = v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *DescribeDimensionKeysInput) SetIdentifier(v string) *DescribeDimensionKeysInput {
	s.Identifier = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeDimensionKeysInput) SetMaxResults(v int64) *DescribeDimensionKeysInput {
	s.MaxResults = &v
	return s
}

// SetMetric sets the Metric field's value.
func (s *DescribeDimensionKeysInput) SetMetric(v string) *DescribeDimensionKeysInput {
	s.Metric = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDimensionKeysInput) SetNextToken(v string) *DescribeDimensionKeysInput {
	s.NextToken = &v
	return s
}

// SetPartitionBy sets the PartitionBy field's value.
func (s *DescribeDimensionKeysInput) SetPartitionBy(v *DimensionGroup) *DescribeDimensionKeysInput {
	s.PartitionBy = v
	return s
}

// SetPeriodInSeconds sets the PeriodInSeconds field's value.
func (s *DescribeDimensionKeysInput) SetPeriodInSeconds(v int64) *DescribeDimensionKeysInput {
	s.PeriodInSeconds = &v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *DescribeDimensionKeysInput) SetServiceType(v string) *DescribeDimensionKeysInput {
	s.ServiceType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeDimensionKeysInput) SetStartTime(v time.Time) *DescribeDimensionKeysInput {
	s.StartTime = &v
	return s
}

type DescribeDimensionKeysOutput struct {
	_ struct{} `type:"structure"`

	// The end time for the returned dimension keys, after alignment to a granular
	// boundary (as specified by PeriodInSeconds). AlignedEndTime will be greater
	// than or equal to the value of the user-specified Endtime.
	AlignedEndTime *time.Time `type:"timestamp"`

	// The start time for the returned dimension keys, after alignment to a granular
	// boundary (as specified by PeriodInSeconds). AlignedStartTime will be less
	// than or equal to the value of the user-specified StartTime.
	AlignedStartTime *time.Time `type:"timestamp"`

	// The dimension keys that were requested.
	Keys []*DimensionKeyDescription `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the token, up to
	// the value specified by MaxRecords.
	NextToken *string `min:"1" type:"string"`

	// If PartitionBy was present in the request, PartitionKeys contains the breakdown
	// of dimension keys by the specified partitions.
	PartitionKeys []*ResponsePartitionKey `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDimensionKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDimensionKeysOutput) GoString() string {
	return s.String()
}

// SetAlignedEndTime sets the AlignedEndTime field's value.
func (s *DescribeDimensionKeysOutput) SetAlignedEndTime(v time.Time) *DescribeDimensionKeysOutput {
	s.AlignedEndTime = &v
	return s
}

// SetAlignedStartTime sets the AlignedStartTime field's value.
func (s *DescribeDimensionKeysOutput) SetAlignedStartTime(v time.Time) *DescribeDimensionKeysOutput {
	s.AlignedStartTime = &v
	return s
}

// SetKeys sets the Keys field's value.
func (s *DescribeDimensionKeysOutput) SetKeys(v []*DimensionKeyDescription) *DescribeDimensionKeysOutput {
	s.Keys = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDimensionKeysOutput) SetNextToken(v string) *DescribeDimensionKeysOutput {
	s.NextToken = &v
	return s
}

// SetPartitionKeys sets the PartitionKeys field's value.
func (s *DescribeDimensionKeysOutput) SetPartitionKeys(v []*ResponsePartitionKey) *DescribeDimensionKeysOutput {
	s.PartitionKeys = v
	return s
}

// A logical grouping of Performance Insights metrics for a related subject
// area. For example, the db.sql dimension group consists of the following dimensions:
// db.sql.id, db.sql.db_id, db.sql.statement, and db.sql.tokenized_id.
//
// Each response element returns a maximum of 500 bytes. For larger elements,
// such as SQL statements, only the first 500 bytes are returned.
type DimensionGroup struct {
	_ struct{} `type:"structure"`

	// A list of specific dimensions from a dimension group. If this parameter is
	// not present, then it signifies that all of the dimensions in the group were
	// requested, or are present in the response.
	//
	// Valid values for elements in the Dimensions array are:
	//
	//    * db.application.name - The name of the application that is connected
	//    to the database (only Aurora PostgreSQL and RDS PostgreSQL)
	//
	//    * db.host.id - The host ID of the connected client (all engines)
	//
	//    * db.host.name - The host name of the connected client (all engines)
	//
	//    * db.name - The name of the database to which the client is connected
	//    (only Aurora PostgreSQL, RDS PostgreSQL, Aurora MySQL, RDS MySQL, and
	//    MariaDB)
	//
	//    * db.session_type.name - The type of the current session (only Aurora
	//    PostgreSQL and RDS PostgreSQL)
	//
	//    * db.sql.id - The SQL ID generated by Performance Insights (all engines)
	//
	//    * db.sql.db_id - The SQL ID generated by the database (all engines)
	//
	//    * db.sql.statement - The SQL text that is being executed (all engines)
	//
	//    * db.sql.tokenized_id
	//
	//    * db.sql_tokenized.id - The SQL digest ID generated by Performance Insights
	//    (all engines)
	//
	//    * db.sql_tokenized.db_id - SQL digest ID generated by the database (all
	//    engines)
	//
	//    * db.sql_tokenized.statement - The SQL digest text (all engines)
	//
	//    * db.user.id - The ID of the user logged in to the database (all engines)
	//
	//    * db.user.name - The name of the user logged in to the database (all engines)
	//
	//    * db.wait_event.name - The event for which the backend is waiting (all
	//    engines)
	//
	//    * db.wait_event.type - The type of event for which the backend is waiting
	//    (all engines)
	//
	//    * db.wait_event_type.name - The name of the event type for which the backend
	//    is waiting (all engines)
	Dimensions []*string `min:"1" type:"list"`

	// The name of the dimension group. Valid values are:
	//
	//    * db - The name of the database to which the client is connected (only
	//    Aurora PostgreSQL, RDS PostgreSQL, Aurora MySQL, RDS MySQL, and MariaDB)
	//
	//    * db.application - The name of the application that is connected to the
	//    database (only Aurora PostgreSQL and RDS PostgreSQL)
	//
	//    * db.host - The host name of the connected client (all engines)
	//
	//    * db.session_type - The type of the current session (only Aurora PostgreSQL
	//    and RDS PostgreSQL)
	//
	//    * db.sql - The SQL that is currently executing (all engines)
	//
	//    * db.sql_tokenized - The SQL digest (all engines)
	//
	//    * db.wait_event - The event for which the database backend is waiting
	//    (all engines)
	//
	//    * db.wait_event_type - The type of event for which the database backend
	//    is waiting (all engines)
	//
	//    * db.user - The user logged in to the database (all engines)
	//
	// Group is a required field
	Group *string `type:"string" required:"true"`

	// The maximum number of items to fetch for this dimension group.
	Limit *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionGroup) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DimensionGroup) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DimensionGroup"}
	if s.Dimensions != nil && len(s.Dimensions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Dimensions", 1))
	}
	if s.Group == nil {
		invalidParams.Add(request.NewErrParamRequired("Group"))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *DimensionGroup) SetDimensions(v []*string) *DimensionGroup {
	s.Dimensions = v
	return s
}

// SetGroup sets the Group field's value.
func (s *DimensionGroup) SetGroup(v string) *DimensionGroup {
	s.Group = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DimensionGroup) SetLimit(v int64) *DimensionGroup {
	s.Limit = &v
	return s
}

// An array of descriptions and aggregated values for each dimension within
// a dimension group.
type DimensionKeyDescription struct {
	_ struct{} `type:"structure"`

	// A map of name-value pairs for the dimensions in the group.
	Dimensions map[string]*string `type:"map"`

	// If PartitionBy was specified, PartitionKeys contains the dimensions that
	// were.
	Partitions []*float64 `type:"list"`

	// The aggregated metric value for the dimension(s), over the requested time
	// range.
	Total *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionKeyDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionKeyDescription) GoString() string {
	return s.String()
}

// SetDimensions sets the Dimensions field's value.
func (s *DimensionKeyDescription) SetDimensions(v map[string]*string) *DimensionKeyDescription {
	s.Dimensions = v
	return s
}

// SetPartitions sets the Partitions field's value.
func (s *DimensionKeyDescription) SetPartitions(v []*float64) *DimensionKeyDescription {
	s.Partitions = v
	return s
}

// SetTotal sets the Total field's value.
func (s *DimensionKeyDescription) SetTotal(v float64) *DimensionKeyDescription {
	s.Total = &v
	return s
}

// An object that describes the details for a specified dimension.
type DimensionKeyDetail struct {
	_ struct{} `type:"structure"`

	// The full name of the dimension. The full name includes the group name and
	// key name. The only valid value is db.sql.statement.
	Dimension *string `type:"string"`

	// The status of the dimension detail data. Possible values include the following:
	//
	//    * AVAILABLE - The dimension detail data is ready to be retrieved.
	//
	//    * PROCESSING - The dimension detail data isn't ready to be retrieved because
	//    more processing time is required. If the requested detail data for db.sql.statement
	//    has the status PROCESSING, Performance Insights returns the truncated
	//    query.
	//
	//    * UNAVAILABLE - The dimension detail data could not be collected successfully.
	Status *string `type:"string" enum:"DetailStatus"`

	// The value of the dimension detail data. For the db.sql.statement dimension,
	// this value is either the full or truncated SQL query, depending on the return
	// status.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionKeyDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionKeyDetail) GoString() string {
	return s.String()
}

// SetDimension sets the Dimension field's value.
func (s *DimensionKeyDetail) SetDimension(v string) *DimensionKeyDetail {
	s.Dimension = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DimensionKeyDetail) SetStatus(v string) *DimensionKeyDetail {
	s.Status = &v
	return s
}

// SetValue sets the Value field's value.
func (s *DimensionKeyDetail) SetValue(v string) *DimensionKeyDetail {
	s.Value = &v
	return s
}

type GetDimensionKeyDetailsInput struct {
	_ struct{} `type:"structure"`

	// The name of the dimension group. The only valid value is db.sql. Performance
	// Insights searches the specified group for the dimension group ID.
	//
	// Group is a required field
	Group *string `type:"string" required:"true"`

	// The ID of the dimension group from which to retrieve dimension details. For
	// dimension group db.sql, the group ID is db.sql.id.
	//
	// GroupIdentifier is a required field
	GroupIdentifier *string `type:"string" required:"true"`

	// The ID for a data source from which to gather dimension data. This ID must
	// be immutable and unique within an AWS Region. When a DB instance is the data
	// source, specify its DbiResourceId value. For example, specify db-ABCDEFGHIJKLMNOPQRSTU1VW2X.
	//
	// Identifier is a required field
	Identifier *string `type:"string" required:"true"`

	// A list of dimensions to retrieve the detail data for within the given dimension
	// group. For the dimension group db.sql, specify either the full dimension
	// name db.sql.statement or the short dimension name statement. If you don't
	// specify this parameter, Performance Insights returns all dimension data within
	// the specified dimension group.
	RequestedDimensions []*string `min:"1" type:"list"`

	// The AWS service for which Performance Insights returns data. The only valid
	// value is RDS.
	//
	// ServiceType is a required field
	ServiceType *string `type:"string" required:"true" enum:"ServiceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDimensionKeyDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDimensionKeyDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDimensionKeyDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDimensionKeyDetailsInput"}
	if s.Group == nil {
		invalidParams.Add(request.NewErrParamRequired("Group"))
	}
	if s.GroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupIdentifier"))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.RequestedDimensions != nil && len(s.RequestedDimensions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestedDimensions", 1))
	}
	if s.ServiceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroup sets the Group field's value.
func (s *GetDimensionKeyDetailsInput) SetGroup(v string) *GetDimensionKeyDetailsInput {
	s.Group = &v
	return s
}

// SetGroupIdentifier sets the GroupIdentifier field's value.
func (s *GetDimensionKeyDetailsInput) SetGroupIdentifier(v string) *GetDimensionKeyDetailsInput {
	s.GroupIdentifier = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *GetDimensionKeyDetailsInput) SetIdentifier(v string) *GetDimensionKeyDetailsInput {
	s.Identifier = &v
	return s
}

// SetRequestedDimensions sets the RequestedDimensions field's value.
func (s *GetDimensionKeyDetailsInput) SetRequestedDimensions(v []*string) *GetDimensionKeyDetailsInput {
	s.RequestedDimensions = v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *GetDimensionKeyDetailsInput) SetServiceType(v string) *GetDimensionKeyDetailsInput {
	s.ServiceType = &v
	return s
}

type GetDimensionKeyDetailsOutput struct {
	_ struct{} `type:"structure"`

	// The details for the requested dimensions.
	Dimensions []*DimensionKeyDetail `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDimensionKeyDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDimensionKeyDetailsOutput) GoString() string {
	return s.String()
}

// SetDimensions sets the Dimensions field's value.
func (s *GetDimensionKeyDetailsOutput) SetDimensions(v []*DimensionKeyDetail) *GetDimensionKeyDetailsOutput {
	s.Dimensions = v
	return s
}

type GetResourceMetricsInput struct {
	_ struct{} `type:"structure"`

	// The date and time specifying the end of the requested time series data. The
	// value specified is exclusive - data points less than (but not equal to) EndTime
	// will be returned.
	//
	// The value for EndTime must be later than the value for StartTime.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// An immutable, AWS Region-unique identifier for a data source. Performance
	// Insights gathers metrics from this data source.
	//
	// To use a DB instance as a data source, specify its DbiResourceId value. For
	// example, specify db-FAIHNTYBKTGAUSUZQYPDS2GW4A.
	//
	// Identifier is a required field
	Identifier *string `type:"string" required:"true"`

	// The maximum number of items to return in the response. If more items exist
	// than the specified MaxRecords value, a pagination token is included in the
	// response so that the remaining results can be retrieved.
	MaxResults *int64 `type:"integer"`

	// An array of one or more queries to perform. Each query must specify a Performance
	// Insights metric, and can optionally specify aggregation and filtering criteria.
	//
	// MetricQueries is a required field
	MetricQueries []*MetricQuery `min:"1" type:"list" required:"true"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the token, up to
	// the value specified by MaxRecords.
	NextToken *string `min:"1" type:"string"`

	// The granularity, in seconds, of the data points returned from Performance
	// Insights. A period can be as short as one second, or as long as one day (86400
	// seconds). Valid values are:
	//
	//    * 1 (one second)
	//
	//    * 60 (one minute)
	//
	//    * 300 (five minutes)
	//
	//    * 3600 (one hour)
	//
	//    * 86400 (twenty-four hours)
	//
	// If you don't specify PeriodInSeconds, then Performance Insights will choose
	// a value for you, with a goal of returning roughly 100-200 data points in
	// the response.
	PeriodInSeconds *int64 `type:"integer"`

	// The AWS service for which Performance Insights returns metrics. The only
	// valid value for ServiceType is RDS.
	//
	// ServiceType is a required field
	ServiceType *string `type:"string" required:"true" enum:"ServiceType"`

	// The date and time specifying the beginning of the requested time series data.
	// You can't specify a StartTime that's earlier than 7 days ago. The value specified
	// is inclusive - data points equal to or greater than StartTime will be returned.
	//
	// The value for StartTime must be earlier than the value for EndTime.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceMetricsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceMetricsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourceMetricsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourceMetricsInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.MetricQueries == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricQueries"))
	}
	if s.MetricQueries != nil && len(s.MetricQueries) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricQueries", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ServiceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceType"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}
	if s.MetricQueries != nil {
		for i, v := range s.MetricQueries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MetricQueries", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *GetResourceMetricsInput) SetEndTime(v time.Time) *GetResourceMetricsInput {
	s.EndTime = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *GetResourceMetricsInput) SetIdentifier(v string) *GetResourceMetricsInput {
	s.Identifier = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetResourceMetricsInput) SetMaxResults(v int64) *GetResourceMetricsInput {
	s.MaxResults = &v
	return s
}

// SetMetricQueries sets the MetricQueries field's value.
func (s *GetResourceMetricsInput) SetMetricQueries(v []*MetricQuery) *GetResourceMetricsInput {
	s.MetricQueries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourceMetricsInput) SetNextToken(v string) *GetResourceMetricsInput {
	s.NextToken = &v
	return s
}

// SetPeriodInSeconds sets the PeriodInSeconds field's value.
func (s *GetResourceMetricsInput) SetPeriodInSeconds(v int64) *GetResourceMetricsInput {
	s.PeriodInSeconds = &v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *GetResourceMetricsInput) SetServiceType(v string) *GetResourceMetricsInput {
	s.ServiceType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetResourceMetricsInput) SetStartTime(v time.Time) *GetResourceMetricsInput {
	s.StartTime = &v
	return s
}

type GetResourceMetricsOutput struct {
	_ struct{} `type:"structure"`

	// The end time for the returned metrics, after alignment to a granular boundary
	// (as specified by PeriodInSeconds). AlignedEndTime will be greater than or
	// equal to the value of the user-specified Endtime.
	AlignedEndTime *time.Time `type:"timestamp"`

	// The start time for the returned metrics, after alignment to a granular boundary
	// (as specified by PeriodInSeconds). AlignedStartTime will be less than or
	// equal to the value of the user-specified StartTime.
	AlignedStartTime *time.Time `type:"timestamp"`

	// An immutable, AWS Region-unique identifier for a data source. Performance
	// Insights gathers metrics from this data source.
	//
	// To use a DB instance as a data source, you specify its DbiResourceId value
	// - for example: db-FAIHNTYBKTGAUSUZQYPDS2GW4A
	Identifier *string `type:"string"`

	// An array of metric results,, where each array element contains all of the
	// data points for a particular dimension.
	MetricList []*MetricKeyDataPoints `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the token, up to
	// the value specified by MaxRecords.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceMetricsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceMetricsOutput) GoString() string {
	return s.String()
}

// SetAlignedEndTime sets the AlignedEndTime field's value.
func (s *GetResourceMetricsOutput) SetAlignedEndTime(v time.Time) *GetResourceMetricsOutput {
	s.AlignedEndTime = &v
	return s
}

// SetAlignedStartTime sets the AlignedStartTime field's value.
func (s *GetResourceMetricsOutput) SetAlignedStartTime(v time.Time) *GetResourceMetricsOutput {
	s.AlignedStartTime = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *GetResourceMetricsOutput) SetIdentifier(v string) *GetResourceMetricsOutput {
	s.Identifier = &v
	return s
}

// SetMetricList sets the MetricList field's value.
func (s *GetResourceMetricsOutput) SetMetricList(v []*MetricKeyDataPoints) *GetResourceMetricsOutput {
	s.MetricList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourceMetricsOutput) SetNextToken(v string) *GetResourceMetricsOutput {
	s.NextToken = &v
	return s
}

// The request failed due to an unknown error.
type InternalServiceError struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceError) GoString() string {
	return s.String()
}

func newErrorInternalServiceError(v protocol.ResponseMetadata) error {
	return &InternalServiceError{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServiceError) Code() string {
	return "InternalServiceError"
}

// Message returns the exception's message.
func (s *InternalServiceError) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServiceError) OrigErr() error {
	return nil
}

func (s *InternalServiceError) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServiceError) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServiceError) RequestID() string {
	return s.RespMetadata.RequestID
}

// One of the arguments provided is invalid for this request.
type InvalidArgumentException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidArgumentException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidArgumentException) GoString() string {
	return s.String()
}

func newErrorInvalidArgumentException(v protocol.ResponseMetadata) error {
	return &InvalidArgumentException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidArgumentException) Code() string {
	return "InvalidArgumentException"
}

// Message returns the exception's message.
func (s *InvalidArgumentException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidArgumentException) OrigErr() error {
	return nil
}

func (s *InvalidArgumentException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidArgumentException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidArgumentException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A time-ordered series of data points, corresponding to a dimension of a Performance
// Insights metric.
type MetricKeyDataPoints struct {
	_ struct{} `type:"structure"`

	// An array of timestamp-value pairs, representing measurements over a period
	// of time.
	DataPoints []*DataPoint `type:"list"`

	// The dimension(s) to which the data points apply.
	Key *ResponseResourceMetricKey `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricKeyDataPoints) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricKeyDataPoints) GoString() string {
	return s.String()
}

// SetDataPoints sets the DataPoints field's value.
func (s *MetricKeyDataPoints) SetDataPoints(v []*DataPoint) *MetricKeyDataPoints {
	s.DataPoints = v
	return s
}

// SetKey sets the Key field's value.
func (s *MetricKeyDataPoints) SetKey(v *ResponseResourceMetricKey) *MetricKeyDataPoints {
	s.Key = v
	return s
}

// A single query to be processed. You must provide the metric to query. If
// no other parameters are specified, Performance Insights returns all of the
// data points for that metric. You can optionally request that the data points
// be aggregated by dimension group ( GroupBy), and return only those data points
// that match your criteria (Filter).
type MetricQuery struct {
	_ struct{} `type:"structure"`

	// One or more filters to apply in the request. Restrictions:
	//
	//    * Any number of filters by the same dimension, as specified in the GroupBy
	//    parameter.
	//
	//    * A single filter for any other dimension in this dimension group.
	Filter map[string]*string `type:"map"`

	// A specification for how to aggregate the data points from a query result.
	// You must specify a valid dimension group. Performance Insights will return
	// all of the dimensions within that group, unless you provide the names of
	// specific dimensions within that group. You can also request that Performance
	// Insights return a limited number of values for a dimension.
	GroupBy *DimensionGroup `type:"structure"`

	// The name of a Performance Insights metric to be measured.
	//
	// Valid values for Metric are:
	//
	//    * db.load.avg - a scaled representation of the number of active sessions
	//    for the database engine.
	//
	//    * db.sampledload.avg - the raw number of active sessions for the database
	//    engine.
	//
	// If the number of active sessions is less than an internal Performance Insights
	// threshold, db.load.avg and db.sampledload.avg are the same value. If the
	// number of active sessions is greater than the internal threshold, Performance
	// Insights samples the active sessions, with db.load.avg showing the scaled
	// values, db.sampledload.avg showing the raw values, and db.sampledload.avg
	// less than db.load.avg. For most use cases, you can query db.load.avg only.
	//
	// Metric is a required field
	Metric *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricQuery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricQuery) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricQuery) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricQuery"}
	if s.Metric == nil {
		invalidParams.Add(request.NewErrParamRequired("Metric"))
	}
	if s.GroupBy != nil {
		if err := s.GroupBy.Validate(); err != nil {
			invalidParams.AddNested("GroupBy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *MetricQuery) SetFilter(v map[string]*string) *MetricQuery {
	s.Filter = v
	return s
}

// SetGroupBy sets the GroupBy field's value.
func (s *MetricQuery) SetGroupBy(v *DimensionGroup) *MetricQuery {
	s.GroupBy = v
	return s
}

// SetMetric sets the Metric field's value.
func (s *MetricQuery) SetMetric(v string) *MetricQuery {
	s.Metric = &v
	return s
}

// The user is not authorized to perform this request.
type NotAuthorizedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotAuthorizedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotAuthorizedException) GoString() string {
	return s.String()
}

func newErrorNotAuthorizedException(v protocol.ResponseMetadata) error {
	return &NotAuthorizedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotAuthorizedException) Code() string {
	return "NotAuthorizedException"
}

// Message returns the exception's message.
func (s *NotAuthorizedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotAuthorizedException) OrigErr() error {
	return nil
}

func (s *NotAuthorizedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotAuthorizedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotAuthorizedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// If PartitionBy was specified in a DescribeDimensionKeys request, the dimensions
// are returned in an array. Each element in the array specifies one dimension.
type ResponsePartitionKey struct {
	_ struct{} `type:"structure"`

	// A dimension map that contains the dimension(s) for this partition.
	//
	// Dimensions is a required field
	Dimensions map[string]*string `type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResponsePartitionKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResponsePartitionKey) GoString() string {
	return s.String()
}

// SetDimensions sets the Dimensions field's value.
func (s *ResponsePartitionKey) SetDimensions(v map[string]*string) *ResponsePartitionKey {
	s.Dimensions = v
	return s
}

// An object describing a Performance Insights metric and one or more dimensions
// for that metric.
type ResponseResourceMetricKey struct {
	_ struct{} `type:"structure"`

	// The valid dimensions for the metric.
	Dimensions map[string]*string `type:"map"`

	// The name of a Performance Insights metric to be measured.
	//
	// Valid values for Metric are:
	//
	//    * db.load.avg - a scaled representation of the number of active sessions
	//    for the database engine.
	//
	//    * db.sampledload.avg - the raw number of active sessions for the database
	//    engine.
	//
	// If the number of active sessions is less than an internal Performance Insights
	// threshold, db.load.avg and db.sampledload.avg are the same value. If the
	// number of active sessions is greater than the internal threshold, Performance
	// Insights samples the active sessions, with db.load.avg showing the scaled
	// values, db.sampledload.avg showing the raw values, and db.sampledload.avg
	// less than db.load.avg. For most use cases, you can query db.load.avg only.
	//
	// Metric is a required field
	Metric *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResponseResourceMetricKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResponseResourceMetricKey) GoString() string {
	return s.String()
}

// SetDimensions sets the Dimensions field's value.
func (s *ResponseResourceMetricKey) SetDimensions(v map[string]*string) *ResponseResourceMetricKey {
	s.Dimensions = v
	return s
}

// SetMetric sets the Metric field's value.
func (s *ResponseResourceMetricKey) SetMetric(v string) *ResponseResourceMetricKey {
	s.Metric = &v
	return s
}

const (
	// DetailStatusAvailable is a DetailStatus enum value
	DetailStatusAvailable = "AVAILABLE"

	// DetailStatusProcessing is a DetailStatus enum value
	DetailStatusProcessing = "PROCESSING"

	// DetailStatusUnavailable is a DetailStatus enum value
	DetailStatusUnavailable = "UNAVAILABLE"
)

// DetailStatus_Values returns all elements of the DetailStatus enum
func DetailStatus_Values() []string {
	return []string{
		DetailStatusAvailable,
		DetailStatusProcessing,
		DetailStatusUnavailable,
	}
}

const (
	// ServiceTypeRds is a ServiceType enum value
	ServiceTypeRds = "RDS"
)

// ServiceType_Values returns all elements of the ServiceType enum
func ServiceType_Values() []string {
	return []string{
		ServiceTypeRds,
	}
}
