// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/domains/v1beta1/domains.proto

package domainspb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Domains_SearchDomains_FullMethodName               = "/google.cloud.domains.v1beta1.Domains/SearchDomains"
	Domains_RetrieveRegisterParameters_FullMethodName  = "/google.cloud.domains.v1beta1.Domains/RetrieveRegisterParameters"
	Domains_RegisterDomain_FullMethodName              = "/google.cloud.domains.v1beta1.Domains/RegisterDomain"
	Domains_RetrieveTransferParameters_FullMethodName  = "/google.cloud.domains.v1beta1.Domains/RetrieveTransferParameters"
	Domains_TransferDomain_FullMethodName              = "/google.cloud.domains.v1beta1.Domains/TransferDomain"
	Domains_ListRegistrations_FullMethodName           = "/google.cloud.domains.v1beta1.Domains/ListRegistrations"
	Domains_GetRegistration_FullMethodName             = "/google.cloud.domains.v1beta1.Domains/GetRegistration"
	Domains_UpdateRegistration_FullMethodName          = "/google.cloud.domains.v1beta1.Domains/UpdateRegistration"
	Domains_ConfigureManagementSettings_FullMethodName = "/google.cloud.domains.v1beta1.Domains/ConfigureManagementSettings"
	Domains_ConfigureDnsSettings_FullMethodName        = "/google.cloud.domains.v1beta1.Domains/ConfigureDnsSettings"
	Domains_ConfigureContactSettings_FullMethodName    = "/google.cloud.domains.v1beta1.Domains/ConfigureContactSettings"
	Domains_ExportRegistration_FullMethodName          = "/google.cloud.domains.v1beta1.Domains/ExportRegistration"
	Domains_DeleteRegistration_FullMethodName          = "/google.cloud.domains.v1beta1.Domains/DeleteRegistration"
	Domains_RetrieveAuthorizationCode_FullMethodName   = "/google.cloud.domains.v1beta1.Domains/RetrieveAuthorizationCode"
	Domains_ResetAuthorizationCode_FullMethodName      = "/google.cloud.domains.v1beta1.Domains/ResetAuthorizationCode"
)

// DomainsClient is the client API for Domains service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type DomainsClient interface {
	// Searches for available domain names similar to the provided query.
	//
	// Availability results from this method are approximate; call
	// `RetrieveRegisterParameters` on a domain before registering to confirm
	// availability.
	SearchDomains(ctx context.Context, in *SearchDomainsRequest, opts ...grpc.CallOption) (*SearchDomainsResponse, error)
	// Gets parameters needed to register a new domain name, including price and
	// up-to-date availability. Use the returned values to call `RegisterDomain`.
	RetrieveRegisterParameters(ctx context.Context, in *RetrieveRegisterParametersRequest, opts ...grpc.CallOption) (*RetrieveRegisterParametersResponse, error)
	// Registers a new domain name and creates a corresponding `Registration`
	// resource.
	//
	// Call `RetrieveRegisterParameters` first to check availability of the domain
	// name and determine parameters like price that are needed to build a call to
	// this method.
	//
	// A successful call creates a `Registration` resource in state
	// `REGISTRATION_PENDING`, which resolves to `ACTIVE` within 1-2
	// minutes, indicating that the domain was successfully registered. If the
	// resource ends up in state `REGISTRATION_FAILED`, it indicates that the
	// domain was not registered successfully, and you can safely delete the
	// resource and retry registration.
	RegisterDomain(ctx context.Context, in *RegisterDomainRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets parameters needed to transfer a domain name from another registrar to
	// Cloud Domains. For domains managed by Google Domains, transferring to Cloud
	// Domains is not supported.
	//
	// Use the returned values to call `TransferDomain`.
	RetrieveTransferParameters(ctx context.Context, in *RetrieveTransferParametersRequest, opts ...grpc.CallOption) (*RetrieveTransferParametersResponse, error)
	// Transfers a domain name from another registrar to Cloud Domains.  For
	// domains managed by Google Domains, transferring to Cloud Domains is not
	// supported.
	//
	// Before calling this method, go to the domain's current registrar to unlock
	// the domain for transfer and retrieve the domain's transfer authorization
	// code. Then call `RetrieveTransferParameters` to confirm that the domain is
	// unlocked and to get values needed to build a call to this method.
	//
	// A successful call creates a `Registration` resource in state
	// `TRANSFER_PENDING`. It can take several days to complete the transfer
	// process. The registrant can often speed up this process by approving the
	// transfer through the current registrar, either by clicking a link in an
	// email from the registrar or by visiting the registrar's website.
	//
	// A few minutes after transfer approval, the resource transitions to state
	// `ACTIVE`, indicating that the transfer was successful. If the transfer is
	// rejected or the request expires without being approved, the resource can
	// end up in state `TRANSFER_FAILED`. If transfer fails, you can safely delete
	// the resource and retry the transfer.
	TransferDomain(ctx context.Context, in *TransferDomainRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists the `Registration` resources in a project.
	ListRegistrations(ctx context.Context, in *ListRegistrationsRequest, opts ...grpc.CallOption) (*ListRegistrationsResponse, error)
	// Gets the details of a `Registration` resource.
	GetRegistration(ctx context.Context, in *GetRegistrationRequest, opts ...grpc.CallOption) (*Registration, error)
	// Updates select fields of a `Registration` resource, notably `labels`. To
	// update other fields, use the appropriate custom update method:
	//
	// * To update management settings, see `ConfigureManagementSettings`
	// * To update DNS configuration, see `ConfigureDnsSettings`
	// * To update contact information, see `ConfigureContactSettings`
	UpdateRegistration(ctx context.Context, in *UpdateRegistrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a `Registration`'s management settings.
	ConfigureManagementSettings(ctx context.Context, in *ConfigureManagementSettingsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a `Registration`'s DNS settings.
	ConfigureDnsSettings(ctx context.Context, in *ConfigureDnsSettingsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a `Registration`'s contact settings. Some changes require
	// confirmation by the domain's registrant contact .
	ConfigureContactSettings(ctx context.Context, in *ConfigureContactSettingsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Exports a `Registration` resource, such that it is no longer managed by
	// Cloud Domains.
	//
	// When an active domain is successfully exported, you can continue to use the
	// domain in [Google Domains](https://domains.google/) until it expires. The
	// calling user becomes the domain's sole owner in Google Domains, and
	// permissions for the domain are subsequently managed there. The domain does
	// not renew automatically unless the new owner sets up billing in Google
	// Domains.
	ExportRegistration(ctx context.Context, in *ExportRegistrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a `Registration` resource.
	//
	// This method works on any `Registration` resource using [Subscription or
	// Commitment billing](/domains/pricing#billing-models), provided that the
	// resource was created at least 1 day in the past.
	//
	// For `Registration` resources using
	// [Monthly billing](/domains/pricing#billing-models), this method works if:
	//
	// * `state` is `EXPORTED` with `expire_time` in the past
	// * `state` is `REGISTRATION_FAILED`
	// * `state` is `TRANSFER_FAILED`
	//
	// When an active registration is successfully deleted, you can continue to
	// use the domain in [Google Domains](https://domains.google/) until it
	// expires. The calling user becomes the domain's sole owner in Google
	// Domains, and permissions for the domain are subsequently managed there. The
	// domain does not renew automatically unless the new owner sets up billing in
	// Google Domains.
	DeleteRegistration(ctx context.Context, in *DeleteRegistrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets the authorization code of the `Registration` for the purpose of
	// transferring the domain to another registrar.
	//
	// You can call this method only after 60 days have elapsed since the initial
	// domain registration.
	RetrieveAuthorizationCode(ctx context.Context, in *RetrieveAuthorizationCodeRequest, opts ...grpc.CallOption) (*AuthorizationCode, error)
	// Resets the authorization code of the `Registration` to a new random string.
	//
	// You can call this method only after 60 days have elapsed since the initial
	// domain registration.
	ResetAuthorizationCode(ctx context.Context, in *ResetAuthorizationCodeRequest, opts ...grpc.CallOption) (*AuthorizationCode, error)
}

type domainsClient struct {
	cc grpc.ClientConnInterface
}

func NewDomainsClient(cc grpc.ClientConnInterface) DomainsClient {
	return &domainsClient{cc}
}

func (c *domainsClient) SearchDomains(ctx context.Context, in *SearchDomainsRequest, opts ...grpc.CallOption) (*SearchDomainsResponse, error) {
	out := new(SearchDomainsResponse)
	err := c.cc.Invoke(ctx, Domains_SearchDomains_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *domainsClient) RetrieveRegisterParameters(ctx context.Context, in *RetrieveRegisterParametersRequest, opts ...grpc.CallOption) (*RetrieveRegisterParametersResponse, error) {
	out := new(RetrieveRegisterParametersResponse)
	err := c.cc.Invoke(ctx, Domains_RetrieveRegisterParameters_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *domainsClient) RegisterDomain(ctx context.Context, in *RegisterDomainRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Domains_RegisterDomain_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *domainsClient) RetrieveTransferParameters(ctx context.Context, in *RetrieveTransferParametersRequest, opts ...grpc.CallOption) (*RetrieveTransferParametersResponse, error) {
	out := new(RetrieveTransferParametersResponse)
	err := c.cc.Invoke(ctx, Domains_RetrieveTransferParameters_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *domainsClient) TransferDomain(ctx context.Context, in *TransferDomainRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Domains_TransferDomain_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *domainsClient) ListRegistrations(ctx context.Context, in *ListRegistrationsRequest, opts ...grpc.CallOption) (*ListRegistrationsResponse, error) {
	out := new(ListRegistrationsResponse)
	err := c.cc.Invoke(ctx, Domains_ListRegistrations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *domainsClient) GetRegistration(ctx context.Context, in *GetRegistrationRequest, opts ...grpc.CallOption) (*Registration, error) {
	out := new(Registration)
	err := c.cc.Invoke(ctx, Domains_GetRegistration_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *domainsClient) UpdateRegistration(ctx context.Context, in *UpdateRegistrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Domains_UpdateRegistration_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *domainsClient) ConfigureManagementSettings(ctx context.Context, in *ConfigureManagementSettingsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Domains_ConfigureManagementSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *domainsClient) ConfigureDnsSettings(ctx context.Context, in *ConfigureDnsSettingsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Domains_ConfigureDnsSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *domainsClient) ConfigureContactSettings(ctx context.Context, in *ConfigureContactSettingsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Domains_ConfigureContactSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *domainsClient) ExportRegistration(ctx context.Context, in *ExportRegistrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Domains_ExportRegistration_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *domainsClient) DeleteRegistration(ctx context.Context, in *DeleteRegistrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Domains_DeleteRegistration_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *domainsClient) RetrieveAuthorizationCode(ctx context.Context, in *RetrieveAuthorizationCodeRequest, opts ...grpc.CallOption) (*AuthorizationCode, error) {
	out := new(AuthorizationCode)
	err := c.cc.Invoke(ctx, Domains_RetrieveAuthorizationCode_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *domainsClient) ResetAuthorizationCode(ctx context.Context, in *ResetAuthorizationCodeRequest, opts ...grpc.CallOption) (*AuthorizationCode, error) {
	out := new(AuthorizationCode)
	err := c.cc.Invoke(ctx, Domains_ResetAuthorizationCode_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DomainsServer is the server API for Domains service.
// All implementations should embed UnimplementedDomainsServer
// for forward compatibility
type DomainsServer interface {
	// Searches for available domain names similar to the provided query.
	//
	// Availability results from this method are approximate; call
	// `RetrieveRegisterParameters` on a domain before registering to confirm
	// availability.
	SearchDomains(context.Context, *SearchDomainsRequest) (*SearchDomainsResponse, error)
	// Gets parameters needed to register a new domain name, including price and
	// up-to-date availability. Use the returned values to call `RegisterDomain`.
	RetrieveRegisterParameters(context.Context, *RetrieveRegisterParametersRequest) (*RetrieveRegisterParametersResponse, error)
	// Registers a new domain name and creates a corresponding `Registration`
	// resource.
	//
	// Call `RetrieveRegisterParameters` first to check availability of the domain
	// name and determine parameters like price that are needed to build a call to
	// this method.
	//
	// A successful call creates a `Registration` resource in state
	// `REGISTRATION_PENDING`, which resolves to `ACTIVE` within 1-2
	// minutes, indicating that the domain was successfully registered. If the
	// resource ends up in state `REGISTRATION_FAILED`, it indicates that the
	// domain was not registered successfully, and you can safely delete the
	// resource and retry registration.
	RegisterDomain(context.Context, *RegisterDomainRequest) (*longrunningpb.Operation, error)
	// Gets parameters needed to transfer a domain name from another registrar to
	// Cloud Domains. For domains managed by Google Domains, transferring to Cloud
	// Domains is not supported.
	//
	// Use the returned values to call `TransferDomain`.
	RetrieveTransferParameters(context.Context, *RetrieveTransferParametersRequest) (*RetrieveTransferParametersResponse, error)
	// Transfers a domain name from another registrar to Cloud Domains.  For
	// domains managed by Google Domains, transferring to Cloud Domains is not
	// supported.
	//
	// Before calling this method, go to the domain's current registrar to unlock
	// the domain for transfer and retrieve the domain's transfer authorization
	// code. Then call `RetrieveTransferParameters` to confirm that the domain is
	// unlocked and to get values needed to build a call to this method.
	//
	// A successful call creates a `Registration` resource in state
	// `TRANSFER_PENDING`. It can take several days to complete the transfer
	// process. The registrant can often speed up this process by approving the
	// transfer through the current registrar, either by clicking a link in an
	// email from the registrar or by visiting the registrar's website.
	//
	// A few minutes after transfer approval, the resource transitions to state
	// `ACTIVE`, indicating that the transfer was successful. If the transfer is
	// rejected or the request expires without being approved, the resource can
	// end up in state `TRANSFER_FAILED`. If transfer fails, you can safely delete
	// the resource and retry the transfer.
	TransferDomain(context.Context, *TransferDomainRequest) (*longrunningpb.Operation, error)
	// Lists the `Registration` resources in a project.
	ListRegistrations(context.Context, *ListRegistrationsRequest) (*ListRegistrationsResponse, error)
	// Gets the details of a `Registration` resource.
	GetRegistration(context.Context, *GetRegistrationRequest) (*Registration, error)
	// Updates select fields of a `Registration` resource, notably `labels`. To
	// update other fields, use the appropriate custom update method:
	//
	// * To update management settings, see `ConfigureManagementSettings`
	// * To update DNS configuration, see `ConfigureDnsSettings`
	// * To update contact information, see `ConfigureContactSettings`
	UpdateRegistration(context.Context, *UpdateRegistrationRequest) (*longrunningpb.Operation, error)
	// Updates a `Registration`'s management settings.
	ConfigureManagementSettings(context.Context, *ConfigureManagementSettingsRequest) (*longrunningpb.Operation, error)
	// Updates a `Registration`'s DNS settings.
	ConfigureDnsSettings(context.Context, *ConfigureDnsSettingsRequest) (*longrunningpb.Operation, error)
	// Updates a `Registration`'s contact settings. Some changes require
	// confirmation by the domain's registrant contact .
	ConfigureContactSettings(context.Context, *ConfigureContactSettingsRequest) (*longrunningpb.Operation, error)
	// Exports a `Registration` resource, such that it is no longer managed by
	// Cloud Domains.
	//
	// When an active domain is successfully exported, you can continue to use the
	// domain in [Google Domains](https://domains.google/) until it expires. The
	// calling user becomes the domain's sole owner in Google Domains, and
	// permissions for the domain are subsequently managed there. The domain does
	// not renew automatically unless the new owner sets up billing in Google
	// Domains.
	ExportRegistration(context.Context, *ExportRegistrationRequest) (*longrunningpb.Operation, error)
	// Deletes a `Registration` resource.
	//
	// This method works on any `Registration` resource using [Subscription or
	// Commitment billing](/domains/pricing#billing-models), provided that the
	// resource was created at least 1 day in the past.
	//
	// For `Registration` resources using
	// [Monthly billing](/domains/pricing#billing-models), this method works if:
	//
	// * `state` is `EXPORTED` with `expire_time` in the past
	// * `state` is `REGISTRATION_FAILED`
	// * `state` is `TRANSFER_FAILED`
	//
	// When an active registration is successfully deleted, you can continue to
	// use the domain in [Google Domains](https://domains.google/) until it
	// expires. The calling user becomes the domain's sole owner in Google
	// Domains, and permissions for the domain are subsequently managed there. The
	// domain does not renew automatically unless the new owner sets up billing in
	// Google Domains.
	DeleteRegistration(context.Context, *DeleteRegistrationRequest) (*longrunningpb.Operation, error)
	// Gets the authorization code of the `Registration` for the purpose of
	// transferring the domain to another registrar.
	//
	// You can call this method only after 60 days have elapsed since the initial
	// domain registration.
	RetrieveAuthorizationCode(context.Context, *RetrieveAuthorizationCodeRequest) (*AuthorizationCode, error)
	// Resets the authorization code of the `Registration` to a new random string.
	//
	// You can call this method only after 60 days have elapsed since the initial
	// domain registration.
	ResetAuthorizationCode(context.Context, *ResetAuthorizationCodeRequest) (*AuthorizationCode, error)
}

// UnimplementedDomainsServer should be embedded to have forward compatible implementations.
type UnimplementedDomainsServer struct {
}

func (UnimplementedDomainsServer) SearchDomains(context.Context, *SearchDomainsRequest) (*SearchDomainsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchDomains not implemented")
}
func (UnimplementedDomainsServer) RetrieveRegisterParameters(context.Context, *RetrieveRegisterParametersRequest) (*RetrieveRegisterParametersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RetrieveRegisterParameters not implemented")
}
func (UnimplementedDomainsServer) RegisterDomain(context.Context, *RegisterDomainRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RegisterDomain not implemented")
}
func (UnimplementedDomainsServer) RetrieveTransferParameters(context.Context, *RetrieveTransferParametersRequest) (*RetrieveTransferParametersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RetrieveTransferParameters not implemented")
}
func (UnimplementedDomainsServer) TransferDomain(context.Context, *TransferDomainRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TransferDomain not implemented")
}
func (UnimplementedDomainsServer) ListRegistrations(context.Context, *ListRegistrationsRequest) (*ListRegistrationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRegistrations not implemented")
}
func (UnimplementedDomainsServer) GetRegistration(context.Context, *GetRegistrationRequest) (*Registration, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRegistration not implemented")
}
func (UnimplementedDomainsServer) UpdateRegistration(context.Context, *UpdateRegistrationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateRegistration not implemented")
}
func (UnimplementedDomainsServer) ConfigureManagementSettings(context.Context, *ConfigureManagementSettingsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ConfigureManagementSettings not implemented")
}
func (UnimplementedDomainsServer) ConfigureDnsSettings(context.Context, *ConfigureDnsSettingsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ConfigureDnsSettings not implemented")
}
func (UnimplementedDomainsServer) ConfigureContactSettings(context.Context, *ConfigureContactSettingsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ConfigureContactSettings not implemented")
}
func (UnimplementedDomainsServer) ExportRegistration(context.Context, *ExportRegistrationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportRegistration not implemented")
}
func (UnimplementedDomainsServer) DeleteRegistration(context.Context, *DeleteRegistrationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRegistration not implemented")
}
func (UnimplementedDomainsServer) RetrieveAuthorizationCode(context.Context, *RetrieveAuthorizationCodeRequest) (*AuthorizationCode, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RetrieveAuthorizationCode not implemented")
}
func (UnimplementedDomainsServer) ResetAuthorizationCode(context.Context, *ResetAuthorizationCodeRequest) (*AuthorizationCode, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetAuthorizationCode not implemented")
}

// UnsafeDomainsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DomainsServer will
// result in compilation errors.
type UnsafeDomainsServer interface {
	mustEmbedUnimplementedDomainsServer()
}

func RegisterDomainsServer(s grpc.ServiceRegistrar, srv DomainsServer) {
	s.RegisterService(&Domains_ServiceDesc, srv)
}

func _Domains_SearchDomains_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchDomainsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainsServer).SearchDomains(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Domains_SearchDomains_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainsServer).SearchDomains(ctx, req.(*SearchDomainsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Domains_RetrieveRegisterParameters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RetrieveRegisterParametersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainsServer).RetrieveRegisterParameters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Domains_RetrieveRegisterParameters_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainsServer).RetrieveRegisterParameters(ctx, req.(*RetrieveRegisterParametersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Domains_RegisterDomain_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RegisterDomainRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainsServer).RegisterDomain(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Domains_RegisterDomain_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainsServer).RegisterDomain(ctx, req.(*RegisterDomainRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Domains_RetrieveTransferParameters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RetrieveTransferParametersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainsServer).RetrieveTransferParameters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Domains_RetrieveTransferParameters_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainsServer).RetrieveTransferParameters(ctx, req.(*RetrieveTransferParametersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Domains_TransferDomain_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TransferDomainRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainsServer).TransferDomain(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Domains_TransferDomain_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainsServer).TransferDomain(ctx, req.(*TransferDomainRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Domains_ListRegistrations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRegistrationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainsServer).ListRegistrations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Domains_ListRegistrations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainsServer).ListRegistrations(ctx, req.(*ListRegistrationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Domains_GetRegistration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRegistrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainsServer).GetRegistration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Domains_GetRegistration_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainsServer).GetRegistration(ctx, req.(*GetRegistrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Domains_UpdateRegistration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRegistrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainsServer).UpdateRegistration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Domains_UpdateRegistration_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainsServer).UpdateRegistration(ctx, req.(*UpdateRegistrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Domains_ConfigureManagementSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConfigureManagementSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainsServer).ConfigureManagementSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Domains_ConfigureManagementSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainsServer).ConfigureManagementSettings(ctx, req.(*ConfigureManagementSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Domains_ConfigureDnsSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConfigureDnsSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainsServer).ConfigureDnsSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Domains_ConfigureDnsSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainsServer).ConfigureDnsSettings(ctx, req.(*ConfigureDnsSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Domains_ConfigureContactSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConfigureContactSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainsServer).ConfigureContactSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Domains_ConfigureContactSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainsServer).ConfigureContactSettings(ctx, req.(*ConfigureContactSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Domains_ExportRegistration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportRegistrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainsServer).ExportRegistration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Domains_ExportRegistration_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainsServer).ExportRegistration(ctx, req.(*ExportRegistrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Domains_DeleteRegistration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRegistrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainsServer).DeleteRegistration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Domains_DeleteRegistration_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainsServer).DeleteRegistration(ctx, req.(*DeleteRegistrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Domains_RetrieveAuthorizationCode_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RetrieveAuthorizationCodeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainsServer).RetrieveAuthorizationCode(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Domains_RetrieveAuthorizationCode_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainsServer).RetrieveAuthorizationCode(ctx, req.(*RetrieveAuthorizationCodeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Domains_ResetAuthorizationCode_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetAuthorizationCodeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainsServer).ResetAuthorizationCode(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Domains_ResetAuthorizationCode_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainsServer).ResetAuthorizationCode(ctx, req.(*ResetAuthorizationCodeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Domains_ServiceDesc is the grpc.ServiceDesc for Domains service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Domains_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.domains.v1beta1.Domains",
	HandlerType: (*DomainsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SearchDomains",
			Handler:    _Domains_SearchDomains_Handler,
		},
		{
			MethodName: "RetrieveRegisterParameters",
			Handler:    _Domains_RetrieveRegisterParameters_Handler,
		},
		{
			MethodName: "RegisterDomain",
			Handler:    _Domains_RegisterDomain_Handler,
		},
		{
			MethodName: "RetrieveTransferParameters",
			Handler:    _Domains_RetrieveTransferParameters_Handler,
		},
		{
			MethodName: "TransferDomain",
			Handler:    _Domains_TransferDomain_Handler,
		},
		{
			MethodName: "ListRegistrations",
			Handler:    _Domains_ListRegistrations_Handler,
		},
		{
			MethodName: "GetRegistration",
			Handler:    _Domains_GetRegistration_Handler,
		},
		{
			MethodName: "UpdateRegistration",
			Handler:    _Domains_UpdateRegistration_Handler,
		},
		{
			MethodName: "ConfigureManagementSettings",
			Handler:    _Domains_ConfigureManagementSettings_Handler,
		},
		{
			MethodName: "ConfigureDnsSettings",
			Handler:    _Domains_ConfigureDnsSettings_Handler,
		},
		{
			MethodName: "ConfigureContactSettings",
			Handler:    _Domains_ConfigureContactSettings_Handler,
		},
		{
			MethodName: "ExportRegistration",
			Handler:    _Domains_ExportRegistration_Handler,
		},
		{
			MethodName: "DeleteRegistration",
			Handler:    _Domains_DeleteRegistration_Handler,
		},
		{
			MethodName: "RetrieveAuthorizationCode",
			Handler:    _Domains_RetrieveAuthorizationCode_Handler,
		},
		{
			MethodName: "ResetAuthorizationCode",
			Handler:    _Domains_ResetAuthorizationCode_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/domains/v1beta1/domains.proto",
}
