// SPDX-FileCopyrightText: Copyright 2015-2025 go-swagger maintainers
// SPDX-License-Identifier: Apache-2.0

//nolint:err113
package errors

import (
	"errors"
	"testing"

	"github.com/go-openapi/testify/v2/assert"
)

func TestParseError(t *testing.T) {
	err := NewParseError("Content-Type", "header", "application(", errors.New("unable to parse"))
	assert.EqualValues(t, 400, err.Code())
	assert.Equal(t, "parsing Content-Type header from \"application(\" failed, because unable to parse", err.Error())

	err = NewParseError("Content-Type", "", "application(", errors.New("unable to parse"))
	assert.EqualValues(t, 400, err.Code())
	assert.Equal(t, "parsing Content-Type from \"application(\" failed, because unable to parse", err.Error())
}
