// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/maps/routing/v2/polyline_details.proto

package routingpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Encapsulates the states of road features along a stretch of polyline.
type PolylineDetails_RoadFeatureState int32

const (
	// The road feature's state was not computed (default value).
	PolylineDetails_ROAD_FEATURE_STATE_UNSPECIFIED PolylineDetails_RoadFeatureState = 0
	// The road feature exists.
	PolylineDetails_EXISTS PolylineDetails_RoadFeatureState = 1
	// The road feature does not exist.
	PolylineDetails_DOES_NOT_EXIST PolylineDetails_RoadFeatureState = 2
)

// Enum value maps for PolylineDetails_RoadFeatureState.
var (
	PolylineDetails_RoadFeatureState_name = map[int32]string{
		0: "ROAD_FEATURE_STATE_UNSPECIFIED",
		1: "EXISTS",
		2: "DOES_NOT_EXIST",
	}
	PolylineDetails_RoadFeatureState_value = map[string]int32{
		"ROAD_FEATURE_STATE_UNSPECIFIED": 0,
		"EXISTS":                         1,
		"DOES_NOT_EXIST":                 2,
	}
)

func (x PolylineDetails_RoadFeatureState) Enum() *PolylineDetails_RoadFeatureState {
	p := new(PolylineDetails_RoadFeatureState)
	*p = x
	return p
}

func (x PolylineDetails_RoadFeatureState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PolylineDetails_RoadFeatureState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_maps_routing_v2_polyline_details_proto_enumTypes[0].Descriptor()
}

func (PolylineDetails_RoadFeatureState) Type() protoreflect.EnumType {
	return &file_google_maps_routing_v2_polyline_details_proto_enumTypes[0]
}

func (x PolylineDetails_RoadFeatureState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PolylineDetails_RoadFeatureState.Descriptor instead.
func (PolylineDetails_RoadFeatureState) EnumDescriptor() ([]byte, []int) {
	return file_google_maps_routing_v2_polyline_details_proto_rawDescGZIP(), []int{0, 0}
}

// Details corresponding to a given index or contiguous segment of a polyline.
// Given a polyline with points P_0, P_1, ... , P_N (zero-based index), the
// `PolylineDetails` defines an interval and associated metadata.
type PolylineDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Flyover details along the polyline.
	FlyoverInfo []*PolylineDetails_FlyoverInfo `protobuf:"bytes,12,rep,name=flyover_info,json=flyoverInfo,proto3" json:"flyover_info,omitempty"`
	// Narrow road details along the polyline.
	NarrowRoadInfo []*PolylineDetails_NarrowRoadInfo `protobuf:"bytes,13,rep,name=narrow_road_info,json=narrowRoadInfo,proto3" json:"narrow_road_info,omitempty"`
}

func (x *PolylineDetails) Reset() {
	*x = PolylineDetails{}
	mi := &file_google_maps_routing_v2_polyline_details_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PolylineDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolylineDetails) ProtoMessage() {}

func (x *PolylineDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_routing_v2_polyline_details_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolylineDetails.ProtoReflect.Descriptor instead.
func (*PolylineDetails) Descriptor() ([]byte, []int) {
	return file_google_maps_routing_v2_polyline_details_proto_rawDescGZIP(), []int{0}
}

func (x *PolylineDetails) GetFlyoverInfo() []*PolylineDetails_FlyoverInfo {
	if x != nil {
		return x.FlyoverInfo
	}
	return nil
}

func (x *PolylineDetails) GetNarrowRoadInfo() []*PolylineDetails_NarrowRoadInfo {
	if x != nil {
		return x.NarrowRoadInfo
	}
	return nil
}

// Encapsulates the start and end indexes for a polyline detail.
// For instances where the data corresponds to a single point, `start_index`
// and `end_index` will be equal.
type PolylineDetails_PolylinePointIndex struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The start index of this detail in the polyline.
	StartIndex *int32 `protobuf:"varint,1,opt,name=start_index,json=startIndex,proto3,oneof" json:"start_index,omitempty"`
	// The end index of this detail in the polyline.
	EndIndex *int32 `protobuf:"varint,2,opt,name=end_index,json=endIndex,proto3,oneof" json:"end_index,omitempty"`
}

func (x *PolylineDetails_PolylinePointIndex) Reset() {
	*x = PolylineDetails_PolylinePointIndex{}
	mi := &file_google_maps_routing_v2_polyline_details_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PolylineDetails_PolylinePointIndex) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolylineDetails_PolylinePointIndex) ProtoMessage() {}

func (x *PolylineDetails_PolylinePointIndex) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_routing_v2_polyline_details_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolylineDetails_PolylinePointIndex.ProtoReflect.Descriptor instead.
func (*PolylineDetails_PolylinePointIndex) Descriptor() ([]byte, []int) {
	return file_google_maps_routing_v2_polyline_details_proto_rawDescGZIP(), []int{0, 0}
}

func (x *PolylineDetails_PolylinePointIndex) GetStartIndex() int32 {
	if x != nil && x.StartIndex != nil {
		return *x.StartIndex
	}
	return 0
}

func (x *PolylineDetails_PolylinePointIndex) GetEndIndex() int32 {
	if x != nil && x.EndIndex != nil {
		return *x.EndIndex
	}
	return 0
}

// Encapsulates information about flyovers along the polyline.
type PolylineDetails_FlyoverInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Denotes whether a flyover exists for a given stretch of the
	// polyline.
	FlyoverPresence PolylineDetails_RoadFeatureState `protobuf:"varint,1,opt,name=flyover_presence,json=flyoverPresence,proto3,enum=google.maps.routing.v2.PolylineDetails_RoadFeatureState" json:"flyover_presence,omitempty"`
	// The location of flyover related information along the polyline.
	PolylinePointIndex *PolylineDetails_PolylinePointIndex `protobuf:"bytes,2,opt,name=polyline_point_index,json=polylinePointIndex,proto3" json:"polyline_point_index,omitempty"`
}

func (x *PolylineDetails_FlyoverInfo) Reset() {
	*x = PolylineDetails_FlyoverInfo{}
	mi := &file_google_maps_routing_v2_polyline_details_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PolylineDetails_FlyoverInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolylineDetails_FlyoverInfo) ProtoMessage() {}

func (x *PolylineDetails_FlyoverInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_routing_v2_polyline_details_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolylineDetails_FlyoverInfo.ProtoReflect.Descriptor instead.
func (*PolylineDetails_FlyoverInfo) Descriptor() ([]byte, []int) {
	return file_google_maps_routing_v2_polyline_details_proto_rawDescGZIP(), []int{0, 1}
}

func (x *PolylineDetails_FlyoverInfo) GetFlyoverPresence() PolylineDetails_RoadFeatureState {
	if x != nil {
		return x.FlyoverPresence
	}
	return PolylineDetails_ROAD_FEATURE_STATE_UNSPECIFIED
}

func (x *PolylineDetails_FlyoverInfo) GetPolylinePointIndex() *PolylineDetails_PolylinePointIndex {
	if x != nil {
		return x.PolylinePointIndex
	}
	return nil
}

// Encapsulates information about narrow roads along the polyline.
type PolylineDetails_NarrowRoadInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Denotes whether a narrow road exists for a given stretch of
	// the polyline.
	NarrowRoadPresence PolylineDetails_RoadFeatureState `protobuf:"varint,1,opt,name=narrow_road_presence,json=narrowRoadPresence,proto3,enum=google.maps.routing.v2.PolylineDetails_RoadFeatureState" json:"narrow_road_presence,omitempty"`
	// The location of narrow road related information along the polyline.
	PolylinePointIndex *PolylineDetails_PolylinePointIndex `protobuf:"bytes,2,opt,name=polyline_point_index,json=polylinePointIndex,proto3" json:"polyline_point_index,omitempty"`
}

func (x *PolylineDetails_NarrowRoadInfo) Reset() {
	*x = PolylineDetails_NarrowRoadInfo{}
	mi := &file_google_maps_routing_v2_polyline_details_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PolylineDetails_NarrowRoadInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolylineDetails_NarrowRoadInfo) ProtoMessage() {}

func (x *PolylineDetails_NarrowRoadInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_routing_v2_polyline_details_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolylineDetails_NarrowRoadInfo.ProtoReflect.Descriptor instead.
func (*PolylineDetails_NarrowRoadInfo) Descriptor() ([]byte, []int) {
	return file_google_maps_routing_v2_polyline_details_proto_rawDescGZIP(), []int{0, 2}
}

func (x *PolylineDetails_NarrowRoadInfo) GetNarrowRoadPresence() PolylineDetails_RoadFeatureState {
	if x != nil {
		return x.NarrowRoadPresence
	}
	return PolylineDetails_ROAD_FEATURE_STATE_UNSPECIFIED
}

func (x *PolylineDetails_NarrowRoadInfo) GetPolylinePointIndex() *PolylineDetails_PolylinePointIndex {
	if x != nil {
		return x.PolylinePointIndex
	}
	return nil
}

var File_google_maps_routing_v2_polyline_details_proto protoreflect.FileDescriptor

var file_google_maps_routing_v2_polyline_details_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x72, 0x6f,
	0x75, 0x74, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x32, 0x2f, 0x70, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e,
	0x65, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75,
	0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf9, 0x06, 0x0a, 0x0f, 0x50, 0x6f, 0x6c,
	0x79, 0x6c, 0x69, 0x6e, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x56, 0x0a, 0x0c,
	0x66, 0x6c, 0x79, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0c, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73,
	0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x6f, 0x6c, 0x79,
	0x6c, 0x69, 0x6e, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x46, 0x6c, 0x79, 0x6f,
	0x76, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0b, 0x66, 0x6c, 0x79, 0x6f, 0x76, 0x65, 0x72,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x60, 0x0a, 0x10, 0x6e, 0x61, 0x72, 0x72, 0x6f, 0x77, 0x5f, 0x72,
	0x6f, 0x61, 0x64, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75,
	0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x4e, 0x61, 0x72, 0x72, 0x6f, 0x77, 0x52, 0x6f,
	0x61, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0e, 0x6e, 0x61, 0x72, 0x72, 0x6f, 0x77, 0x52, 0x6f,
	0x61, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x1a, 0x7a, 0x0a, 0x12, 0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69,
	0x6e, 0x65, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x24, 0x0a, 0x0b,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x48, 0x00, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x88,
	0x01, 0x01, 0x12, 0x20, 0x0a, 0x09, 0x65, 0x6e, 0x64, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x48, 0x01, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x88, 0x01, 0x01, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x69, 0x6e, 0x64,
	0x65, 0x78, 0x1a, 0xe5, 0x01, 0x0a, 0x0b, 0x46, 0x6c, 0x79, 0x6f, 0x76, 0x65, 0x72, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x68, 0x0a, 0x10, 0x66, 0x6c, 0x79, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x70, 0x72,
	0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x52, 0x6f, 0x61, 0x64, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x66, 0x6c, 0x79,
	0x6f, 0x76, 0x65, 0x72, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x6c, 0x0a, 0x14,
	0x70, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x32, 0x2e, 0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x2e, 0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x50, 0x6f, 0x69, 0x6e,
	0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x12, 0x70, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65,
	0x50, 0x6f, 0x69, 0x6e, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x1a, 0xef, 0x01, 0x0a, 0x0e, 0x4e,
	0x61, 0x72, 0x72, 0x6f, 0x77, 0x52, 0x6f, 0x61, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x6f, 0x0a,
	0x14, 0x6e, 0x61, 0x72, 0x72, 0x6f, 0x77, 0x5f, 0x72, 0x6f, 0x61, 0x64, 0x5f, 0x70, 0x72, 0x65,
	0x73, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x2e, 0x52, 0x6f, 0x61, 0x64, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x6e, 0x61, 0x72, 0x72,
	0x6f, 0x77, 0x52, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x6c,
	0x0a, 0x14, 0x70, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x50, 0x6f,
	0x69, 0x6e, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x12, 0x70, 0x6f, 0x6c, 0x79, 0x6c, 0x69,
	0x6e, 0x65, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x22, 0x56, 0x0a, 0x10,
	0x52, 0x6f, 0x61, 0x64, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x22, 0x0a, 0x1e, 0x52, 0x4f, 0x41, 0x44, 0x5f, 0x46, 0x45, 0x41, 0x54, 0x55, 0x52, 0x45,
	0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x45, 0x58, 0x49, 0x53, 0x54, 0x53, 0x10, 0x01,
	0x12, 0x12, 0x0a, 0x0e, 0x44, 0x4f, 0x45, 0x53, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x45, 0x58, 0x49,
	0x53, 0x54, 0x10, 0x02, 0x42, 0xc6, 0x01, 0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x32, 0x42, 0x14, 0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3a, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f,
	0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x32, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x70, 0x62, 0x3b, 0x72, 0x6f,
	0x75, 0x74, 0x69, 0x6e, 0x67, 0x70, 0x62, 0xa2, 0x02, 0x05, 0x47, 0x4d, 0x52, 0x56, 0x32, 0xaa,
	0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x4d, 0x61, 0x70, 0x73, 0x2e, 0x52, 0x6f,
	0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x56, 0x32, 0xca, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x5c, 0x4d, 0x61, 0x70, 0x73, 0x5c, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x5c, 0x56,
	0x32, 0xea, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x4d, 0x61, 0x70, 0x73,
	0x3a, 0x3a, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_maps_routing_v2_polyline_details_proto_rawDescOnce sync.Once
	file_google_maps_routing_v2_polyline_details_proto_rawDescData = file_google_maps_routing_v2_polyline_details_proto_rawDesc
)

func file_google_maps_routing_v2_polyline_details_proto_rawDescGZIP() []byte {
	file_google_maps_routing_v2_polyline_details_proto_rawDescOnce.Do(func() {
		file_google_maps_routing_v2_polyline_details_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_maps_routing_v2_polyline_details_proto_rawDescData)
	})
	return file_google_maps_routing_v2_polyline_details_proto_rawDescData
}

var file_google_maps_routing_v2_polyline_details_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_maps_routing_v2_polyline_details_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_maps_routing_v2_polyline_details_proto_goTypes = []any{
	(PolylineDetails_RoadFeatureState)(0),      // 0: google.maps.routing.v2.PolylineDetails.RoadFeatureState
	(*PolylineDetails)(nil),                    // 1: google.maps.routing.v2.PolylineDetails
	(*PolylineDetails_PolylinePointIndex)(nil), // 2: google.maps.routing.v2.PolylineDetails.PolylinePointIndex
	(*PolylineDetails_FlyoverInfo)(nil),        // 3: google.maps.routing.v2.PolylineDetails.FlyoverInfo
	(*PolylineDetails_NarrowRoadInfo)(nil),     // 4: google.maps.routing.v2.PolylineDetails.NarrowRoadInfo
}
var file_google_maps_routing_v2_polyline_details_proto_depIdxs = []int32{
	3, // 0: google.maps.routing.v2.PolylineDetails.flyover_info:type_name -> google.maps.routing.v2.PolylineDetails.FlyoverInfo
	4, // 1: google.maps.routing.v2.PolylineDetails.narrow_road_info:type_name -> google.maps.routing.v2.PolylineDetails.NarrowRoadInfo
	0, // 2: google.maps.routing.v2.PolylineDetails.FlyoverInfo.flyover_presence:type_name -> google.maps.routing.v2.PolylineDetails.RoadFeatureState
	2, // 3: google.maps.routing.v2.PolylineDetails.FlyoverInfo.polyline_point_index:type_name -> google.maps.routing.v2.PolylineDetails.PolylinePointIndex
	0, // 4: google.maps.routing.v2.PolylineDetails.NarrowRoadInfo.narrow_road_presence:type_name -> google.maps.routing.v2.PolylineDetails.RoadFeatureState
	2, // 5: google.maps.routing.v2.PolylineDetails.NarrowRoadInfo.polyline_point_index:type_name -> google.maps.routing.v2.PolylineDetails.PolylinePointIndex
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_google_maps_routing_v2_polyline_details_proto_init() }
func file_google_maps_routing_v2_polyline_details_proto_init() {
	if File_google_maps_routing_v2_polyline_details_proto != nil {
		return
	}
	file_google_maps_routing_v2_polyline_details_proto_msgTypes[1].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_maps_routing_v2_polyline_details_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_maps_routing_v2_polyline_details_proto_goTypes,
		DependencyIndexes: file_google_maps_routing_v2_polyline_details_proto_depIdxs,
		EnumInfos:         file_google_maps_routing_v2_polyline_details_proto_enumTypes,
		MessageInfos:      file_google_maps_routing_v2_polyline_details_proto_msgTypes,
	}.Build()
	File_google_maps_routing_v2_polyline_details_proto = out.File
	file_google_maps_routing_v2_polyline_details_proto_rawDesc = nil
	file_google_maps_routing_v2_polyline_details_proto_goTypes = nil
	file_google_maps_routing_v2_polyline_details_proto_depIdxs = nil
}
