// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/spanner/admin/instance/v1/spanner_instance_admin.proto

package instancepb

import (
	reflect "reflect"
	sync "sync"

	iampb "cloud.google.com/go/iam/apiv1/iampb"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Indicates the type of replica.  See the [replica types
// documentation](https://cloud.google.com/spanner/docs/replication#replica_types)
// for more details.
type ReplicaInfo_ReplicaType int32

const (
	// Not specified.
	ReplicaInfo_TYPE_UNSPECIFIED ReplicaInfo_ReplicaType = 0
	// Read-write replicas support both reads and writes. These replicas:
	//
	// * Maintain a full copy of your data.
	// * Serve reads.
	// * Can vote whether to commit a write.
	// * Participate in leadership election.
	// * Are eligible to become a leader.
	ReplicaInfo_READ_WRITE ReplicaInfo_ReplicaType = 1
	// Read-only replicas only support reads (not writes). Read-only replicas:
	//
	// * Maintain a full copy of your data.
	// * Serve reads.
	// * Do not participate in voting to commit writes.
	// * Are not eligible to become a leader.
	ReplicaInfo_READ_ONLY ReplicaInfo_ReplicaType = 2
	// Witness replicas don't support reads but do participate in voting to
	// commit writes. Witness replicas:
	//
	// * Do not maintain a full copy of data.
	// * Do not serve reads.
	// * Vote whether to commit writes.
	// * Participate in leader election but are not eligible to become leader.
	ReplicaInfo_WITNESS ReplicaInfo_ReplicaType = 3
)

// Enum value maps for ReplicaInfo_ReplicaType.
var (
	ReplicaInfo_ReplicaType_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "READ_WRITE",
		2: "READ_ONLY",
		3: "WITNESS",
	}
	ReplicaInfo_ReplicaType_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"READ_WRITE":       1,
		"READ_ONLY":        2,
		"WITNESS":          3,
	}
)

func (x ReplicaInfo_ReplicaType) Enum() *ReplicaInfo_ReplicaType {
	p := new(ReplicaInfo_ReplicaType)
	*p = x
	return p
}

func (x ReplicaInfo_ReplicaType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReplicaInfo_ReplicaType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes[0].Descriptor()
}

func (ReplicaInfo_ReplicaType) Type() protoreflect.EnumType {
	return &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes[0]
}

func (x ReplicaInfo_ReplicaType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReplicaInfo_ReplicaType.Descriptor instead.
func (ReplicaInfo_ReplicaType) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{0, 0}
}

// The type of this configuration.
type InstanceConfig_Type int32

const (
	// Unspecified.
	InstanceConfig_TYPE_UNSPECIFIED InstanceConfig_Type = 0
	// Google-managed configuration.
	InstanceConfig_GOOGLE_MANAGED InstanceConfig_Type = 1
	// User-managed configuration.
	InstanceConfig_USER_MANAGED InstanceConfig_Type = 2
)

// Enum value maps for InstanceConfig_Type.
var (
	InstanceConfig_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "GOOGLE_MANAGED",
		2: "USER_MANAGED",
	}
	InstanceConfig_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"GOOGLE_MANAGED":   1,
		"USER_MANAGED":     2,
	}
)

func (x InstanceConfig_Type) Enum() *InstanceConfig_Type {
	p := new(InstanceConfig_Type)
	*p = x
	return p
}

func (x InstanceConfig_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceConfig_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes[1].Descriptor()
}

func (InstanceConfig_Type) Type() protoreflect.EnumType {
	return &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes[1]
}

func (x InstanceConfig_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceConfig_Type.Descriptor instead.
func (InstanceConfig_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{1, 0}
}

// Indicates the current state of the instance configuration.
type InstanceConfig_State int32

const (
	// Not specified.
	InstanceConfig_STATE_UNSPECIFIED InstanceConfig_State = 0
	// The instance configuration is still being created.
	InstanceConfig_CREATING InstanceConfig_State = 1
	// The instance configuration is fully created and ready to be used to
	// create instances.
	InstanceConfig_READY InstanceConfig_State = 2
)

// Enum value maps for InstanceConfig_State.
var (
	InstanceConfig_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "READY",
	}
	InstanceConfig_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"READY":             2,
	}
)

func (x InstanceConfig_State) Enum() *InstanceConfig_State {
	p := new(InstanceConfig_State)
	*p = x
	return p
}

func (x InstanceConfig_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceConfig_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes[2].Descriptor()
}

func (InstanceConfig_State) Type() protoreflect.EnumType {
	return &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes[2]
}

func (x InstanceConfig_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceConfig_State.Descriptor instead.
func (InstanceConfig_State) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{1, 1}
}

// Describes the availability for free instances to be created in an instance
// configuration.
type InstanceConfig_FreeInstanceAvailability int32

const (
	// Not specified.
	InstanceConfig_FREE_INSTANCE_AVAILABILITY_UNSPECIFIED InstanceConfig_FreeInstanceAvailability = 0
	// Indicates that free instances are available to be created in this
	// instance configuration.
	InstanceConfig_AVAILABLE InstanceConfig_FreeInstanceAvailability = 1
	// Indicates that free instances are not supported in this instance
	// configuration.
	InstanceConfig_UNSUPPORTED InstanceConfig_FreeInstanceAvailability = 2
	// Indicates that free instances are currently not available to be created
	// in this instance configuration.
	InstanceConfig_DISABLED InstanceConfig_FreeInstanceAvailability = 3
	// Indicates that additional free instances cannot be created in this
	// instance configuration because the project has reached its limit of free
	// instances.
	InstanceConfig_QUOTA_EXCEEDED InstanceConfig_FreeInstanceAvailability = 4
)

// Enum value maps for InstanceConfig_FreeInstanceAvailability.
var (
	InstanceConfig_FreeInstanceAvailability_name = map[int32]string{
		0: "FREE_INSTANCE_AVAILABILITY_UNSPECIFIED",
		1: "AVAILABLE",
		2: "UNSUPPORTED",
		3: "DISABLED",
		4: "QUOTA_EXCEEDED",
	}
	InstanceConfig_FreeInstanceAvailability_value = map[string]int32{
		"FREE_INSTANCE_AVAILABILITY_UNSPECIFIED": 0,
		"AVAILABLE":                              1,
		"UNSUPPORTED":                            2,
		"DISABLED":                               3,
		"QUOTA_EXCEEDED":                         4,
	}
)

func (x InstanceConfig_FreeInstanceAvailability) Enum() *InstanceConfig_FreeInstanceAvailability {
	p := new(InstanceConfig_FreeInstanceAvailability)
	*p = x
	return p
}

func (x InstanceConfig_FreeInstanceAvailability) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceConfig_FreeInstanceAvailability) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes[3].Descriptor()
}

func (InstanceConfig_FreeInstanceAvailability) Type() protoreflect.EnumType {
	return &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes[3]
}

func (x InstanceConfig_FreeInstanceAvailability) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceConfig_FreeInstanceAvailability.Descriptor instead.
func (InstanceConfig_FreeInstanceAvailability) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{1, 2}
}

// Indicates the quorum type of this instance configuration.
type InstanceConfig_QuorumType int32

const (
	// Quorum type not specified.
	InstanceConfig_QUORUM_TYPE_UNSPECIFIED InstanceConfig_QuorumType = 0
	// An instance configuration tagged with `REGION` quorum type forms a write
	// quorum in a single region.
	InstanceConfig_REGION InstanceConfig_QuorumType = 1
	// An instance configuration tagged with the `DUAL_REGION` quorum type forms
	// a write quorum with exactly two read-write regions in a multi-region
	// configuration.
	//
	// This instance configuration requires failover in the event of
	// regional failures.
	InstanceConfig_DUAL_REGION InstanceConfig_QuorumType = 2
	// An instance configuration tagged with the `MULTI_REGION` quorum type
	// forms a write quorum from replicas that are spread across more than one
	// region in a multi-region configuration.
	InstanceConfig_MULTI_REGION InstanceConfig_QuorumType = 3
)

// Enum value maps for InstanceConfig_QuorumType.
var (
	InstanceConfig_QuorumType_name = map[int32]string{
		0: "QUORUM_TYPE_UNSPECIFIED",
		1: "REGION",
		2: "DUAL_REGION",
		3: "MULTI_REGION",
	}
	InstanceConfig_QuorumType_value = map[string]int32{
		"QUORUM_TYPE_UNSPECIFIED": 0,
		"REGION":                  1,
		"DUAL_REGION":             2,
		"MULTI_REGION":            3,
	}
)

func (x InstanceConfig_QuorumType) Enum() *InstanceConfig_QuorumType {
	p := new(InstanceConfig_QuorumType)
	*p = x
	return p
}

func (x InstanceConfig_QuorumType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceConfig_QuorumType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes[4].Descriptor()
}

func (InstanceConfig_QuorumType) Type() protoreflect.EnumType {
	return &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes[4]
}

func (x InstanceConfig_QuorumType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceConfig_QuorumType.Descriptor instead.
func (InstanceConfig_QuorumType) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{1, 3}
}

// Indicates the current state of the instance.
type Instance_State int32

const (
	// Not specified.
	Instance_STATE_UNSPECIFIED Instance_State = 0
	// The instance is still being created. Resources may not be
	// available yet, and operations such as database creation may not
	// work.
	Instance_CREATING Instance_State = 1
	// The instance is fully created and ready to do work such as
	// creating databases.
	Instance_READY Instance_State = 2
)

// Enum value maps for Instance_State.
var (
	Instance_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "READY",
	}
	Instance_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"READY":             2,
	}
)

func (x Instance_State) Enum() *Instance_State {
	p := new(Instance_State)
	*p = x
	return p
}

func (x Instance_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes[5].Descriptor()
}

func (Instance_State) Type() protoreflect.EnumType {
	return &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes[5]
}

func (x Instance_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_State.Descriptor instead.
func (Instance_State) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{4, 0}
}

// The type of this instance. The type can be used to distinguish product
// variants, that can affect aspects like: usage restrictions, quotas and
// billing. Currently this is used to distinguish FREE_INSTANCE vs PROVISIONED
// instances.
type Instance_InstanceType int32

const (
	// Not specified.
	Instance_INSTANCE_TYPE_UNSPECIFIED Instance_InstanceType = 0
	// Provisioned instances have dedicated resources, standard usage limits and
	// support.
	Instance_PROVISIONED Instance_InstanceType = 1
	// Free instances provide no guarantee for dedicated resources,
	// [node_count, processing_units] should be 0. They come
	// with stricter usage limits and limited support.
	Instance_FREE_INSTANCE Instance_InstanceType = 2
)

// Enum value maps for Instance_InstanceType.
var (
	Instance_InstanceType_name = map[int32]string{
		0: "INSTANCE_TYPE_UNSPECIFIED",
		1: "PROVISIONED",
		2: "FREE_INSTANCE",
	}
	Instance_InstanceType_value = map[string]int32{
		"INSTANCE_TYPE_UNSPECIFIED": 0,
		"PROVISIONED":               1,
		"FREE_INSTANCE":             2,
	}
)

func (x Instance_InstanceType) Enum() *Instance_InstanceType {
	p := new(Instance_InstanceType)
	*p = x
	return p
}

func (x Instance_InstanceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_InstanceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes[6].Descriptor()
}

func (Instance_InstanceType) Type() protoreflect.EnumType {
	return &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes[6]
}

func (x Instance_InstanceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_InstanceType.Descriptor instead.
func (Instance_InstanceType) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{4, 1}
}

// The edition selected for this instance. Different editions provide
// different capabilities at different price points.
type Instance_Edition int32

const (
	// Edition not specified.
	Instance_EDITION_UNSPECIFIED Instance_Edition = 0
	// Standard edition.
	Instance_STANDARD Instance_Edition = 1
	// Enterprise edition.
	Instance_ENTERPRISE Instance_Edition = 2
	// Enterprise Plus edition.
	Instance_ENTERPRISE_PLUS Instance_Edition = 3
)

// Enum value maps for Instance_Edition.
var (
	Instance_Edition_name = map[int32]string{
		0: "EDITION_UNSPECIFIED",
		1: "STANDARD",
		2: "ENTERPRISE",
		3: "ENTERPRISE_PLUS",
	}
	Instance_Edition_value = map[string]int32{
		"EDITION_UNSPECIFIED": 0,
		"STANDARD":            1,
		"ENTERPRISE":          2,
		"ENTERPRISE_PLUS":     3,
	}
)

func (x Instance_Edition) Enum() *Instance_Edition {
	p := new(Instance_Edition)
	*p = x
	return p
}

func (x Instance_Edition) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_Edition) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes[7].Descriptor()
}

func (Instance_Edition) Type() protoreflect.EnumType {
	return &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes[7]
}

func (x Instance_Edition) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_Edition.Descriptor instead.
func (Instance_Edition) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{4, 2}
}

// Indicates the
// [default backup
// schedule](https://cloud.google.com/spanner/docs/backup#default-backup-schedules)
// behavior for new databases within the instance.
type Instance_DefaultBackupScheduleType int32

const (
	// Not specified.
	Instance_DEFAULT_BACKUP_SCHEDULE_TYPE_UNSPECIFIED Instance_DefaultBackupScheduleType = 0
	// A default backup schedule isn't created automatically when a new database
	// is created in the instance.
	Instance_NONE Instance_DefaultBackupScheduleType = 1
	// A default backup schedule is created automatically when a new database
	// is created in the instance. The default backup schedule creates a full
	// backup every 24 hours. These full backups are retained for 7 days.
	// You can edit or delete the default backup schedule once it's created.
	Instance_AUTOMATIC Instance_DefaultBackupScheduleType = 2
)

// Enum value maps for Instance_DefaultBackupScheduleType.
var (
	Instance_DefaultBackupScheduleType_name = map[int32]string{
		0: "DEFAULT_BACKUP_SCHEDULE_TYPE_UNSPECIFIED",
		1: "NONE",
		2: "AUTOMATIC",
	}
	Instance_DefaultBackupScheduleType_value = map[string]int32{
		"DEFAULT_BACKUP_SCHEDULE_TYPE_UNSPECIFIED": 0,
		"NONE":      1,
		"AUTOMATIC": 2,
	}
)

func (x Instance_DefaultBackupScheduleType) Enum() *Instance_DefaultBackupScheduleType {
	p := new(Instance_DefaultBackupScheduleType)
	*p = x
	return p
}

func (x Instance_DefaultBackupScheduleType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_DefaultBackupScheduleType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes[8].Descriptor()
}

func (Instance_DefaultBackupScheduleType) Type() protoreflect.EnumType {
	return &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes[8]
}

func (x Instance_DefaultBackupScheduleType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_DefaultBackupScheduleType.Descriptor instead.
func (Instance_DefaultBackupScheduleType) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{4, 3}
}

// Allows users to change behavior when a free instance expires.
type FreeInstanceMetadata_ExpireBehavior int32

const (
	// Not specified.
	FreeInstanceMetadata_EXPIRE_BEHAVIOR_UNSPECIFIED FreeInstanceMetadata_ExpireBehavior = 0
	// When the free instance expires, upgrade the instance to a provisioned
	// instance.
	FreeInstanceMetadata_FREE_TO_PROVISIONED FreeInstanceMetadata_ExpireBehavior = 1
	// When the free instance expires, disable the instance, and delete it
	// after the grace period passes if it has not been upgraded.
	FreeInstanceMetadata_REMOVE_AFTER_GRACE_PERIOD FreeInstanceMetadata_ExpireBehavior = 2
)

// Enum value maps for FreeInstanceMetadata_ExpireBehavior.
var (
	FreeInstanceMetadata_ExpireBehavior_name = map[int32]string{
		0: "EXPIRE_BEHAVIOR_UNSPECIFIED",
		1: "FREE_TO_PROVISIONED",
		2: "REMOVE_AFTER_GRACE_PERIOD",
	}
	FreeInstanceMetadata_ExpireBehavior_value = map[string]int32{
		"EXPIRE_BEHAVIOR_UNSPECIFIED": 0,
		"FREE_TO_PROVISIONED":         1,
		"REMOVE_AFTER_GRACE_PERIOD":   2,
	}
)

func (x FreeInstanceMetadata_ExpireBehavior) Enum() *FreeInstanceMetadata_ExpireBehavior {
	p := new(FreeInstanceMetadata_ExpireBehavior)
	*p = x
	return p
}

func (x FreeInstanceMetadata_ExpireBehavior) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FreeInstanceMetadata_ExpireBehavior) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes[9].Descriptor()
}

func (FreeInstanceMetadata_ExpireBehavior) Type() protoreflect.EnumType {
	return &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes[9]
}

func (x FreeInstanceMetadata_ExpireBehavior) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FreeInstanceMetadata_ExpireBehavior.Descriptor instead.
func (FreeInstanceMetadata_ExpireBehavior) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{21, 0}
}

// Indicates the current state of the instance partition.
type InstancePartition_State int32

const (
	// Not specified.
	InstancePartition_STATE_UNSPECIFIED InstancePartition_State = 0
	// The instance partition is still being created. Resources may not be
	// available yet, and operations such as creating placements using this
	// instance partition may not work.
	InstancePartition_CREATING InstancePartition_State = 1
	// The instance partition is fully created and ready to do work such as
	// creating placements and using in databases.
	InstancePartition_READY InstancePartition_State = 2
)

// Enum value maps for InstancePartition_State.
var (
	InstancePartition_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "READY",
	}
	InstancePartition_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"READY":             2,
	}
)

func (x InstancePartition_State) Enum() *InstancePartition_State {
	p := new(InstancePartition_State)
	*p = x
	return p
}

func (x InstancePartition_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstancePartition_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes[10].Descriptor()
}

func (InstancePartition_State) Type() protoreflect.EnumType {
	return &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes[10]
}

func (x InstancePartition_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstancePartition_State.Descriptor instead.
func (InstancePartition_State) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{24, 0}
}

type ReplicaInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The location of the serving resources, e.g., "us-central1".
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// The type of replica.
	Type ReplicaInfo_ReplicaType `protobuf:"varint,2,opt,name=type,proto3,enum=google.spanner.admin.instance.v1.ReplicaInfo_ReplicaType" json:"type,omitempty"`
	// If true, this location is designated as the default leader location where
	// leader replicas are placed. See the [region types
	// documentation](https://cloud.google.com/spanner/docs/instances#region_types)
	// for more details.
	DefaultLeaderLocation bool `protobuf:"varint,3,opt,name=default_leader_location,json=defaultLeaderLocation,proto3" json:"default_leader_location,omitempty"`
}

func (x *ReplicaInfo) Reset() {
	*x = ReplicaInfo{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReplicaInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicaInfo) ProtoMessage() {}

func (x *ReplicaInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicaInfo.ProtoReflect.Descriptor instead.
func (*ReplicaInfo) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{0}
}

func (x *ReplicaInfo) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *ReplicaInfo) GetType() ReplicaInfo_ReplicaType {
	if x != nil {
		return x.Type
	}
	return ReplicaInfo_TYPE_UNSPECIFIED
}

func (x *ReplicaInfo) GetDefaultLeaderLocation() bool {
	if x != nil {
		return x.DefaultLeaderLocation
	}
	return false
}

// A possible configuration for a Cloud Spanner instance. Configurations
// define the geographic placement of nodes and their replication.
type InstanceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique identifier for the instance configuration.  Values
	// are of the form
	// `projects/<project>/instanceConfigs/[a-z][-a-z0-9]*`.
	//
	// User instance configuration must start with `custom-`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The name of this instance configuration as it appears in UIs.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. Whether this instance configuration is a Google-managed or
	// user-managed configuration.
	ConfigType InstanceConfig_Type `protobuf:"varint,5,opt,name=config_type,json=configType,proto3,enum=google.spanner.admin.instance.v1.InstanceConfig_Type" json:"config_type,omitempty"`
	// The geographic placement of nodes in this instance configuration and their
	// replication properties.
	//
	// To create user-managed configurations, input
	// `replicas` must include all replicas in `replicas` of the `base_config`
	// and include one or more replicas in the `optional_replicas` of the
	// `base_config`.
	Replicas []*ReplicaInfo `protobuf:"bytes,3,rep,name=replicas,proto3" json:"replicas,omitempty"`
	// Output only. The available optional replicas to choose from for
	// user-managed configurations. Populated for Google-managed configurations.
	OptionalReplicas []*ReplicaInfo `protobuf:"bytes,6,rep,name=optional_replicas,json=optionalReplicas,proto3" json:"optional_replicas,omitempty"`
	// Base configuration name, e.g. projects/<project_name>/instanceConfigs/nam3,
	// based on which this configuration is created. Only set for user-managed
	// configurations. `base_config` must refer to a configuration of type
	// `GOOGLE_MANAGED` in the same project as this configuration.
	BaseConfig string `protobuf:"bytes,7,opt,name=base_config,json=baseConfig,proto3" json:"base_config,omitempty"`
	// Cloud Labels are a flexible and lightweight mechanism for organizing cloud
	// resources into groups that reflect a customer's organizational needs and
	// deployment strategies. Cloud Labels can be used to filter collections of
	// resources. They can be used to control how resource metrics are aggregated.
	// And they can be used as arguments to policy management rules (e.g. route,
	// firewall, load balancing, etc.).
	//
	//   - Label keys must be between 1 and 63 characters long and must conform to
	//     the following regular expression: `[a-z][a-z0-9_-]{0,62}`.
	//   - Label values must be between 0 and 63 characters long and must conform
	//     to the regular expression `[a-z0-9_-]{0,63}`.
	//   - No more than 64 labels can be associated with a given resource.
	//
	// See https://goo.gl/xmQnxf for more information on and examples of labels.
	//
	// If you plan to use labels in your own code, please note that additional
	// characters may be allowed in the future. Therefore, you are advised to use
	// an internal label representation, such as JSON, which doesn't rely upon
	// specific characters being disallowed.  For example, representing labels
	// as the string:  name + "_" + value  would prove problematic if we were to
	// allow "_" in a future release.
	Labels map[string]string `protobuf:"bytes,8,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// etag is used for optimistic concurrency control as a way
	// to help prevent simultaneous updates of a instance configuration from
	// overwriting each other. It is strongly suggested that systems make use of
	// the etag in the read-modify-write cycle to perform instance configuration
	// updates in order to avoid race conditions: An etag is returned in the
	// response which contains instance configurations, and systems are expected
	// to put that etag in the request to update instance configuration to ensure
	// that their change is applied to the same version of the instance
	// configuration. If no etag is provided in the call to update the instance
	// configuration, then the existing instance configuration is overwritten
	// blindly.
	Etag string `protobuf:"bytes,9,opt,name=etag,proto3" json:"etag,omitempty"`
	// Allowed values of the "default_leader" schema option for databases in
	// instances that use this instance configuration.
	LeaderOptions []string `protobuf:"bytes,4,rep,name=leader_options,json=leaderOptions,proto3" json:"leader_options,omitempty"`
	// Output only. If true, the instance configuration is being created or
	// updated. If false, there are no ongoing operations for the instance
	// configuration.
	Reconciling bool `protobuf:"varint,10,opt,name=reconciling,proto3" json:"reconciling,omitempty"`
	// Output only. The current instance configuration state. Applicable only for
	// `USER_MANAGED` configurations.
	State InstanceConfig_State `protobuf:"varint,11,opt,name=state,proto3,enum=google.spanner.admin.instance.v1.InstanceConfig_State" json:"state,omitempty"`
	// Output only. Describes whether free instances are available to be created
	// in this instance configuration.
	FreeInstanceAvailability InstanceConfig_FreeInstanceAvailability `protobuf:"varint,12,opt,name=free_instance_availability,json=freeInstanceAvailability,proto3,enum=google.spanner.admin.instance.v1.InstanceConfig_FreeInstanceAvailability" json:"free_instance_availability,omitempty"`
	// Output only. The `QuorumType` of the instance configuration.
	QuorumType InstanceConfig_QuorumType `protobuf:"varint,18,opt,name=quorum_type,json=quorumType,proto3,enum=google.spanner.admin.instance.v1.InstanceConfig_QuorumType" json:"quorum_type,omitempty"`
	// Output only. The storage limit in bytes per processing unit.
	StorageLimitPerProcessingUnit int64 `protobuf:"varint,19,opt,name=storage_limit_per_processing_unit,json=storageLimitPerProcessingUnit,proto3" json:"storage_limit_per_processing_unit,omitempty"`
}

func (x *InstanceConfig) Reset() {
	*x = InstanceConfig{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InstanceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstanceConfig) ProtoMessage() {}

func (x *InstanceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstanceConfig.ProtoReflect.Descriptor instead.
func (*InstanceConfig) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{1}
}

func (x *InstanceConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *InstanceConfig) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *InstanceConfig) GetConfigType() InstanceConfig_Type {
	if x != nil {
		return x.ConfigType
	}
	return InstanceConfig_TYPE_UNSPECIFIED
}

func (x *InstanceConfig) GetReplicas() []*ReplicaInfo {
	if x != nil {
		return x.Replicas
	}
	return nil
}

func (x *InstanceConfig) GetOptionalReplicas() []*ReplicaInfo {
	if x != nil {
		return x.OptionalReplicas
	}
	return nil
}

func (x *InstanceConfig) GetBaseConfig() string {
	if x != nil {
		return x.BaseConfig
	}
	return ""
}

func (x *InstanceConfig) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *InstanceConfig) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *InstanceConfig) GetLeaderOptions() []string {
	if x != nil {
		return x.LeaderOptions
	}
	return nil
}

func (x *InstanceConfig) GetReconciling() bool {
	if x != nil {
		return x.Reconciling
	}
	return false
}

func (x *InstanceConfig) GetState() InstanceConfig_State {
	if x != nil {
		return x.State
	}
	return InstanceConfig_STATE_UNSPECIFIED
}

func (x *InstanceConfig) GetFreeInstanceAvailability() InstanceConfig_FreeInstanceAvailability {
	if x != nil {
		return x.FreeInstanceAvailability
	}
	return InstanceConfig_FREE_INSTANCE_AVAILABILITY_UNSPECIFIED
}

func (x *InstanceConfig) GetQuorumType() InstanceConfig_QuorumType {
	if x != nil {
		return x.QuorumType
	}
	return InstanceConfig_QUORUM_TYPE_UNSPECIFIED
}

func (x *InstanceConfig) GetStorageLimitPerProcessingUnit() int64 {
	if x != nil {
		return x.StorageLimitPerProcessingUnit
	}
	return 0
}

// ReplicaComputeCapacity describes the amount of server resources that are
// allocated to each replica identified by the replica selection.
type ReplicaComputeCapacity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Identifies replicas by specified properties.
	// All replicas in the selection have the same amount of compute capacity.
	ReplicaSelection *ReplicaSelection `protobuf:"bytes,1,opt,name=replica_selection,json=replicaSelection,proto3" json:"replica_selection,omitempty"`
	// Compute capacity allocated to each replica identified by the specified
	// selection.
	// The unit is selected based on the unit used to specify the instance size
	// for non-autoscaling instances, or the unit used in autoscaling limit for
	// autoscaling instances.
	//
	// Types that are assignable to ComputeCapacity:
	//
	//	*ReplicaComputeCapacity_NodeCount
	//	*ReplicaComputeCapacity_ProcessingUnits
	ComputeCapacity isReplicaComputeCapacity_ComputeCapacity `protobuf_oneof:"compute_capacity"`
}

func (x *ReplicaComputeCapacity) Reset() {
	*x = ReplicaComputeCapacity{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReplicaComputeCapacity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicaComputeCapacity) ProtoMessage() {}

func (x *ReplicaComputeCapacity) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicaComputeCapacity.ProtoReflect.Descriptor instead.
func (*ReplicaComputeCapacity) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{2}
}

func (x *ReplicaComputeCapacity) GetReplicaSelection() *ReplicaSelection {
	if x != nil {
		return x.ReplicaSelection
	}
	return nil
}

func (m *ReplicaComputeCapacity) GetComputeCapacity() isReplicaComputeCapacity_ComputeCapacity {
	if m != nil {
		return m.ComputeCapacity
	}
	return nil
}

func (x *ReplicaComputeCapacity) GetNodeCount() int32 {
	if x, ok := x.GetComputeCapacity().(*ReplicaComputeCapacity_NodeCount); ok {
		return x.NodeCount
	}
	return 0
}

func (x *ReplicaComputeCapacity) GetProcessingUnits() int32 {
	if x, ok := x.GetComputeCapacity().(*ReplicaComputeCapacity_ProcessingUnits); ok {
		return x.ProcessingUnits
	}
	return 0
}

type isReplicaComputeCapacity_ComputeCapacity interface {
	isReplicaComputeCapacity_ComputeCapacity()
}

type ReplicaComputeCapacity_NodeCount struct {
	// The number of nodes allocated to each replica.
	//
	// This may be zero in API responses for instances that are not yet in
	// state `READY`.
	NodeCount int32 `protobuf:"varint,2,opt,name=node_count,json=nodeCount,proto3,oneof"`
}

type ReplicaComputeCapacity_ProcessingUnits struct {
	// The number of processing units allocated to each replica.
	//
	// This may be zero in API responses for instances that are not yet in
	// state `READY`.
	ProcessingUnits int32 `protobuf:"varint,3,opt,name=processing_units,json=processingUnits,proto3,oneof"`
}

func (*ReplicaComputeCapacity_NodeCount) isReplicaComputeCapacity_ComputeCapacity() {}

func (*ReplicaComputeCapacity_ProcessingUnits) isReplicaComputeCapacity_ComputeCapacity() {}

// Autoscaling configuration for an instance.
type AutoscalingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Autoscaling limits for an instance.
	AutoscalingLimits *AutoscalingConfig_AutoscalingLimits `protobuf:"bytes,1,opt,name=autoscaling_limits,json=autoscalingLimits,proto3" json:"autoscaling_limits,omitempty"`
	// Required. The autoscaling targets for an instance.
	AutoscalingTargets *AutoscalingConfig_AutoscalingTargets `protobuf:"bytes,2,opt,name=autoscaling_targets,json=autoscalingTargets,proto3" json:"autoscaling_targets,omitempty"`
	// Optional. Optional asymmetric autoscaling options.
	// Replicas matching the replica selection criteria will be autoscaled
	// independently from other replicas. The autoscaler will scale the replicas
	// based on the utilization of replicas identified by the replica selection.
	// Replica selections should not overlap with each other.
	//
	// Other replicas (those do not match any replica selection) will be
	// autoscaled together and will have the same compute capacity allocated to
	// them.
	AsymmetricAutoscalingOptions []*AutoscalingConfig_AsymmetricAutoscalingOption `protobuf:"bytes,3,rep,name=asymmetric_autoscaling_options,json=asymmetricAutoscalingOptions,proto3" json:"asymmetric_autoscaling_options,omitempty"`
}

func (x *AutoscalingConfig) Reset() {
	*x = AutoscalingConfig{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutoscalingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoscalingConfig) ProtoMessage() {}

func (x *AutoscalingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoscalingConfig.ProtoReflect.Descriptor instead.
func (*AutoscalingConfig) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{3}
}

func (x *AutoscalingConfig) GetAutoscalingLimits() *AutoscalingConfig_AutoscalingLimits {
	if x != nil {
		return x.AutoscalingLimits
	}
	return nil
}

func (x *AutoscalingConfig) GetAutoscalingTargets() *AutoscalingConfig_AutoscalingTargets {
	if x != nil {
		return x.AutoscalingTargets
	}
	return nil
}

func (x *AutoscalingConfig) GetAsymmetricAutoscalingOptions() []*AutoscalingConfig_AsymmetricAutoscalingOption {
	if x != nil {
		return x.AsymmetricAutoscalingOptions
	}
	return nil
}

// An isolated set of Cloud Spanner resources on which databases can be hosted.
type Instance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A unique identifier for the instance, which cannot be changed
	// after the instance is created. Values are of the form
	// `projects/<project>/instances/[a-z][-a-z0-9]*[a-z0-9]`. The final
	// segment of the name must be between 2 and 64 characters in length.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The name of the instance's configuration. Values are of the form
	// `projects/<project>/instanceConfigs/<configuration>`. See
	// also [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig] and
	// [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs].
	Config string `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// Required. The descriptive name for this instance as it appears in UIs.
	// Must be unique per project and between 4 and 30 characters in length.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The number of nodes allocated to this instance. At most, one of either
	// `node_count` or `processing_units` should be present in the message.
	//
	// Users can set the `node_count` field to specify the target number of nodes
	// allocated to the instance.
	//
	// If autoscaling is enabled, `node_count` is treated as an `OUTPUT_ONLY`
	// field and reflects the current number of nodes allocated to the instance.
	//
	// This might be zero in API responses for instances that are not yet in the
	// `READY` state.
	//
	// For more information, see
	// [Compute capacity, nodes, and processing
	// units](https://cloud.google.com/spanner/docs/compute-capacity).
	NodeCount int32 `protobuf:"varint,5,opt,name=node_count,json=nodeCount,proto3" json:"node_count,omitempty"`
	// The number of processing units allocated to this instance. At most, one of
	// either `processing_units` or `node_count` should be present in the message.
	//
	// Users can set the `processing_units` field to specify the target number of
	// processing units allocated to the instance.
	//
	// If autoscaling is enabled, `processing_units` is treated as an
	// `OUTPUT_ONLY` field and reflects the current number of processing units
	// allocated to the instance.
	//
	// This might be zero in API responses for instances that are not yet in the
	// `READY` state.
	//
	// For more information, see
	// [Compute capacity, nodes and processing
	// units](https://cloud.google.com/spanner/docs/compute-capacity).
	ProcessingUnits int32 `protobuf:"varint,9,opt,name=processing_units,json=processingUnits,proto3" json:"processing_units,omitempty"`
	// Output only. Lists the compute capacity per ReplicaSelection. A replica
	// selection identifies a set of replicas with common properties. Replicas
	// identified by a ReplicaSelection are scaled with the same compute capacity.
	ReplicaComputeCapacity []*ReplicaComputeCapacity `protobuf:"bytes,19,rep,name=replica_compute_capacity,json=replicaComputeCapacity,proto3" json:"replica_compute_capacity,omitempty"`
	// Optional. The autoscaling configuration. Autoscaling is enabled if this
	// field is set. When autoscaling is enabled, node_count and processing_units
	// are treated as OUTPUT_ONLY fields and reflect the current compute capacity
	// allocated to the instance.
	AutoscalingConfig *AutoscalingConfig `protobuf:"bytes,17,opt,name=autoscaling_config,json=autoscalingConfig,proto3" json:"autoscaling_config,omitempty"`
	// Output only. The current instance state. For
	// [CreateInstance][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstance],
	// the state must be either omitted or set to `CREATING`. For
	// [UpdateInstance][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstance],
	// the state must be either omitted or set to `READY`.
	State Instance_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.spanner.admin.instance.v1.Instance_State" json:"state,omitempty"`
	// Cloud Labels are a flexible and lightweight mechanism for organizing cloud
	// resources into groups that reflect a customer's organizational needs and
	// deployment strategies. Cloud Labels can be used to filter collections of
	// resources. They can be used to control how resource metrics are aggregated.
	// And they can be used as arguments to policy management rules (e.g. route,
	// firewall, load balancing, etc.).
	//
	//   - Label keys must be between 1 and 63 characters long and must conform to
	//     the following regular expression: `[a-z][a-z0-9_-]{0,62}`.
	//   - Label values must be between 0 and 63 characters long and must conform
	//     to the regular expression `[a-z0-9_-]{0,63}`.
	//   - No more than 64 labels can be associated with a given resource.
	//
	// See https://goo.gl/xmQnxf for more information on and examples of labels.
	//
	// If you plan to use labels in your own code, please note that additional
	// characters may be allowed in the future. And so you are advised to use an
	// internal label representation, such as JSON, which doesn't rely upon
	// specific characters being disallowed.  For example, representing labels
	// as the string:  name + "_" + value  would prove problematic if we were to
	// allow "_" in a future release.
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The `InstanceType` of the current instance.
	InstanceType Instance_InstanceType `protobuf:"varint,10,opt,name=instance_type,json=instanceType,proto3,enum=google.spanner.admin.instance.v1.Instance_InstanceType" json:"instance_type,omitempty"`
	// Deprecated. This field is not populated.
	EndpointUris []string `protobuf:"bytes,8,rep,name=endpoint_uris,json=endpointUris,proto3" json:"endpoint_uris,omitempty"`
	// Output only. The time at which the instance was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which the instance was most recently updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Free instance metadata. Only populated for free instances.
	FreeInstanceMetadata *FreeInstanceMetadata `protobuf:"bytes,13,opt,name=free_instance_metadata,json=freeInstanceMetadata,proto3" json:"free_instance_metadata,omitempty"`
	// Optional. The `Edition` of the current instance.
	Edition Instance_Edition `protobuf:"varint,20,opt,name=edition,proto3,enum=google.spanner.admin.instance.v1.Instance_Edition" json:"edition,omitempty"`
	// Optional. Controls the default backup schedule behavior for new databases
	// within the instance. By default, a backup schedule is created automatically
	// when a new database is created in a new instance.
	//
	// Note that the `AUTOMATIC` value isn't permitted for free instances,
	// as backups and backup schedules aren't supported for free instances.
	//
	// In the `GetInstance` or `ListInstances` response, if the value of
	// `default_backup_schedule_type` isn't set, or set to `NONE`, Spanner doesn't
	// create a default backup schedule for new databases in the instance.
	DefaultBackupScheduleType Instance_DefaultBackupScheduleType `protobuf:"varint,23,opt,name=default_backup_schedule_type,json=defaultBackupScheduleType,proto3,enum=google.spanner.admin.instance.v1.Instance_DefaultBackupScheduleType" json:"default_backup_schedule_type,omitempty"`
}

func (x *Instance) Reset() {
	*x = Instance{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Instance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Instance) ProtoMessage() {}

func (x *Instance) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Instance.ProtoReflect.Descriptor instead.
func (*Instance) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{4}
}

func (x *Instance) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Instance) GetConfig() string {
	if x != nil {
		return x.Config
	}
	return ""
}

func (x *Instance) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Instance) GetNodeCount() int32 {
	if x != nil {
		return x.NodeCount
	}
	return 0
}

func (x *Instance) GetProcessingUnits() int32 {
	if x != nil {
		return x.ProcessingUnits
	}
	return 0
}

func (x *Instance) GetReplicaComputeCapacity() []*ReplicaComputeCapacity {
	if x != nil {
		return x.ReplicaComputeCapacity
	}
	return nil
}

func (x *Instance) GetAutoscalingConfig() *AutoscalingConfig {
	if x != nil {
		return x.AutoscalingConfig
	}
	return nil
}

func (x *Instance) GetState() Instance_State {
	if x != nil {
		return x.State
	}
	return Instance_STATE_UNSPECIFIED
}

func (x *Instance) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Instance) GetInstanceType() Instance_InstanceType {
	if x != nil {
		return x.InstanceType
	}
	return Instance_INSTANCE_TYPE_UNSPECIFIED
}

func (x *Instance) GetEndpointUris() []string {
	if x != nil {
		return x.EndpointUris
	}
	return nil
}

func (x *Instance) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Instance) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Instance) GetFreeInstanceMetadata() *FreeInstanceMetadata {
	if x != nil {
		return x.FreeInstanceMetadata
	}
	return nil
}

func (x *Instance) GetEdition() Instance_Edition {
	if x != nil {
		return x.Edition
	}
	return Instance_EDITION_UNSPECIFIED
}

func (x *Instance) GetDefaultBackupScheduleType() Instance_DefaultBackupScheduleType {
	if x != nil {
		return x.DefaultBackupScheduleType
	}
	return Instance_DEFAULT_BACKUP_SCHEDULE_TYPE_UNSPECIFIED
}

// The request for
// [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs].
type ListInstanceConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project for which a list of supported instance
	// configurations is requested. Values are of the form
	// `projects/<project>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Number of instance configurations to be returned in the response. If 0 or
	// less, defaults to the server's maximum allowed page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If non-empty, `page_token` should contain a
	// [next_page_token][google.spanner.admin.instance.v1.ListInstanceConfigsResponse.next_page_token]
	// from a previous
	// [ListInstanceConfigsResponse][google.spanner.admin.instance.v1.ListInstanceConfigsResponse].
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListInstanceConfigsRequest) Reset() {
	*x = ListInstanceConfigsRequest{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListInstanceConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInstanceConfigsRequest) ProtoMessage() {}

func (x *ListInstanceConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInstanceConfigsRequest.ProtoReflect.Descriptor instead.
func (*ListInstanceConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{5}
}

func (x *ListInstanceConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListInstanceConfigsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListInstanceConfigsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response for
// [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs].
type ListInstanceConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of requested instance configurations.
	InstanceConfigs []*InstanceConfig `protobuf:"bytes,1,rep,name=instance_configs,json=instanceConfigs,proto3" json:"instance_configs,omitempty"`
	// `next_page_token` can be sent in a subsequent
	// [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs]
	// call to fetch more of the matching instance configurations.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListInstanceConfigsResponse) Reset() {
	*x = ListInstanceConfigsResponse{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListInstanceConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInstanceConfigsResponse) ProtoMessage() {}

func (x *ListInstanceConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInstanceConfigsResponse.ProtoReflect.Descriptor instead.
func (*ListInstanceConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{6}
}

func (x *ListInstanceConfigsResponse) GetInstanceConfigs() []*InstanceConfig {
	if x != nil {
		return x.InstanceConfigs
	}
	return nil
}

func (x *ListInstanceConfigsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for
// [GetInstanceConfigRequest][google.spanner.admin.instance.v1.InstanceAdmin.GetInstanceConfig].
type GetInstanceConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the requested instance configuration. Values are of
	// the form `projects/<project>/instanceConfigs/<config>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetInstanceConfigRequest) Reset() {
	*x = GetInstanceConfigRequest{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetInstanceConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetInstanceConfigRequest) ProtoMessage() {}

func (x *GetInstanceConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetInstanceConfigRequest.ProtoReflect.Descriptor instead.
func (*GetInstanceConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{7}
}

func (x *GetInstanceConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for
// [CreateInstanceConfig][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstanceConfig].
type CreateInstanceConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project in which to create the instance
	// configuration. Values are of the form `projects/<project>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the instance configuration to create. Valid identifiers
	// are of the form `custom-[-a-z0-9]*[a-z0-9]` and must be between 2 and 64
	// characters in length. The `custom-` prefix is required to avoid name
	// conflicts with Google-managed configurations.
	InstanceConfigId string `protobuf:"bytes,2,opt,name=instance_config_id,json=instanceConfigId,proto3" json:"instance_config_id,omitempty"`
	// Required. The `InstanceConfig` proto of the configuration to create.
	// `instance_config.name` must be
	// `<parent>/instanceConfigs/<instance_config_id>`.
	// `instance_config.base_config` must be a Google-managed configuration name,
	// e.g. <parent>/instanceConfigs/us-east1, <parent>/instanceConfigs/nam3.
	InstanceConfig *InstanceConfig `protobuf:"bytes,3,opt,name=instance_config,json=instanceConfig,proto3" json:"instance_config,omitempty"`
	// An option to validate, but not actually execute, a request,
	// and provide the same response.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateInstanceConfigRequest) Reset() {
	*x = CreateInstanceConfigRequest{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateInstanceConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateInstanceConfigRequest) ProtoMessage() {}

func (x *CreateInstanceConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateInstanceConfigRequest.ProtoReflect.Descriptor instead.
func (*CreateInstanceConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{8}
}

func (x *CreateInstanceConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateInstanceConfigRequest) GetInstanceConfigId() string {
	if x != nil {
		return x.InstanceConfigId
	}
	return ""
}

func (x *CreateInstanceConfigRequest) GetInstanceConfig() *InstanceConfig {
	if x != nil {
		return x.InstanceConfig
	}
	return nil
}

func (x *CreateInstanceConfigRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// The request for
// [UpdateInstanceConfig][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstanceConfig].
type UpdateInstanceConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The user instance configuration to update, which must always
	// include the instance configuration name. Otherwise, only fields mentioned
	// in
	// [update_mask][google.spanner.admin.instance.v1.UpdateInstanceConfigRequest.update_mask]
	// need be included. To prevent conflicts of concurrent updates,
	// [etag][google.spanner.admin.instance.v1.InstanceConfig.reconciling] can
	// be used.
	InstanceConfig *InstanceConfig `protobuf:"bytes,1,opt,name=instance_config,json=instanceConfig,proto3" json:"instance_config,omitempty"`
	// Required. A mask specifying which fields in
	// [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig] should be
	// updated. The field mask must always be specified; this prevents any future
	// fields in [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig]
	// from being erased accidentally by clients that do not know about them. Only
	// display_name and labels can be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// An option to validate, but not actually execute, a request,
	// and provide the same response.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *UpdateInstanceConfigRequest) Reset() {
	*x = UpdateInstanceConfigRequest{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateInstanceConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateInstanceConfigRequest) ProtoMessage() {}

func (x *UpdateInstanceConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateInstanceConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateInstanceConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{9}
}

func (x *UpdateInstanceConfigRequest) GetInstanceConfig() *InstanceConfig {
	if x != nil {
		return x.InstanceConfig
	}
	return nil
}

func (x *UpdateInstanceConfigRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateInstanceConfigRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// The request for
// [DeleteInstanceConfig][google.spanner.admin.instance.v1.InstanceAdmin.DeleteInstanceConfig].
type DeleteInstanceConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the instance configuration to be deleted.
	// Values are of the form
	// `projects/<project>/instanceConfigs/<instance_config>`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Used for optimistic concurrency control as a way to help prevent
	// simultaneous deletes of an instance configuration from overwriting each
	// other. If not empty, the API
	// only deletes the instance configuration when the etag provided matches the
	// current status of the requested instance configuration. Otherwise, deletes
	// the instance configuration without checking the current status of the
	// requested instance configuration.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// An option to validate, but not actually execute, a request,
	// and provide the same response.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *DeleteInstanceConfigRequest) Reset() {
	*x = DeleteInstanceConfigRequest{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteInstanceConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteInstanceConfigRequest) ProtoMessage() {}

func (x *DeleteInstanceConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteInstanceConfigRequest.ProtoReflect.Descriptor instead.
func (*DeleteInstanceConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{10}
}

func (x *DeleteInstanceConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteInstanceConfigRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *DeleteInstanceConfigRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// The request for
// [ListInstanceConfigOperations][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigOperations].
type ListInstanceConfigOperationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project of the instance configuration operations.
	// Values are of the form `projects/<project>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// An expression that filters the list of returned operations.
	//
	// A filter expression consists of a field name, a
	// comparison operator, and a value for filtering.
	// The value must be a string, a number, or a boolean. The comparison operator
	// must be one of: `<`, `>`, `<=`, `>=`, `!=`, `=`, or `:`.
	// Colon `:` is the contains operator. Filter rules are not case sensitive.
	//
	// The following fields in the Operation are eligible for filtering:
	//
	//   - `name` - The name of the long-running operation
	//   - `done` - False if the operation is in progress, else true.
	//   - `metadata.@type` - the type of metadata. For example, the type string
	//     for
	//     [CreateInstanceConfigMetadata][google.spanner.admin.instance.v1.CreateInstanceConfigMetadata]
	//     is
	//     `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstanceConfigMetadata`.
	//   - `metadata.<field_name>` - any field in metadata.value.
	//     `metadata.@type` must be specified first, if filtering on metadata
	//     fields.
	//   - `error` - Error associated with the long-running operation.
	//   - `response.@type` - the type of response.
	//   - `response.<field_name>` - any field in response.value.
	//
	// You can combine multiple expressions by enclosing each expression in
	// parentheses. By default, expressions are combined with AND logic. However,
	// you can specify AND, OR, and NOT logic explicitly.
	//
	// Here are a few examples:
	//
	//   - `done:true` - The operation is complete.
	//   - `(metadata.@type=` \
	//     `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstanceConfigMetadata)
	//     AND` \
	//     `(metadata.instance_config.name:custom-config) AND` \
	//     `(metadata.progress.start_time < \"2021-03-28T14:50:00Z\") AND` \
	//     `(error:*)` - Return operations where:
	//   - The operation's metadata type is
	//     [CreateInstanceConfigMetadata][google.spanner.admin.instance.v1.CreateInstanceConfigMetadata].
	//   - The instance configuration name contains "custom-config".
	//   - The operation started before 2021-03-28T14:50:00Z.
	//   - The operation resulted in an error.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Number of operations to be returned in the response. If 0 or
	// less, defaults to the server's maximum allowed page size.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If non-empty, `page_token` should contain a
	// [next_page_token][google.spanner.admin.instance.v1.ListInstanceConfigOperationsResponse.next_page_token]
	// from a previous
	// [ListInstanceConfigOperationsResponse][google.spanner.admin.instance.v1.ListInstanceConfigOperationsResponse]
	// to the same `parent` and with the same `filter`.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListInstanceConfigOperationsRequest) Reset() {
	*x = ListInstanceConfigOperationsRequest{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListInstanceConfigOperationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInstanceConfigOperationsRequest) ProtoMessage() {}

func (x *ListInstanceConfigOperationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInstanceConfigOperationsRequest.ProtoReflect.Descriptor instead.
func (*ListInstanceConfigOperationsRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{11}
}

func (x *ListInstanceConfigOperationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListInstanceConfigOperationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListInstanceConfigOperationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListInstanceConfigOperationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response for
// [ListInstanceConfigOperations][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigOperations].
type ListInstanceConfigOperationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of matching instance configuration long-running operations. Each
	// operation's name will be
	// prefixed by the name of the instance configuration. The operation's
	// metadata field type
	// `metadata.type_url` describes the type of the metadata.
	Operations []*longrunningpb.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// `next_page_token` can be sent in a subsequent
	// [ListInstanceConfigOperations][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigOperations]
	// call to fetch more of the matching metadata.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListInstanceConfigOperationsResponse) Reset() {
	*x = ListInstanceConfigOperationsResponse{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListInstanceConfigOperationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInstanceConfigOperationsResponse) ProtoMessage() {}

func (x *ListInstanceConfigOperationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInstanceConfigOperationsResponse.ProtoReflect.Descriptor instead.
func (*ListInstanceConfigOperationsResponse) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{12}
}

func (x *ListInstanceConfigOperationsResponse) GetOperations() []*longrunningpb.Operation {
	if x != nil {
		return x.Operations
	}
	return nil
}

func (x *ListInstanceConfigOperationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for
// [GetInstance][google.spanner.admin.instance.v1.InstanceAdmin.GetInstance].
type GetInstanceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the requested instance. Values are of the form
	// `projects/<project>/instances/<instance>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If field_mask is present, specifies the subset of
	// [Instance][google.spanner.admin.instance.v1.Instance] fields that should be
	// returned. If absent, all
	// [Instance][google.spanner.admin.instance.v1.Instance] fields are returned.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *GetInstanceRequest) Reset() {
	*x = GetInstanceRequest{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetInstanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetInstanceRequest) ProtoMessage() {}

func (x *GetInstanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetInstanceRequest.ProtoReflect.Descriptor instead.
func (*GetInstanceRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{13}
}

func (x *GetInstanceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetInstanceRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

// The request for
// [CreateInstance][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstance].
type CreateInstanceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project in which to create the instance. Values
	// are of the form `projects/<project>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the instance to create.  Valid identifiers are of the
	// form `[a-z][-a-z0-9]*[a-z0-9]` and must be between 2 and 64 characters in
	// length.
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Required. The instance to create.  The name may be omitted, but if
	// specified must be `<parent>/instances/<instance_id>`.
	Instance *Instance `protobuf:"bytes,3,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *CreateInstanceRequest) Reset() {
	*x = CreateInstanceRequest{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateInstanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateInstanceRequest) ProtoMessage() {}

func (x *CreateInstanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateInstanceRequest.ProtoReflect.Descriptor instead.
func (*CreateInstanceRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{14}
}

func (x *CreateInstanceRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateInstanceRequest) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *CreateInstanceRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

// The request for
// [ListInstances][google.spanner.admin.instance.v1.InstanceAdmin.ListInstances].
type ListInstancesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project for which a list of instances is
	// requested. Values are of the form `projects/<project>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Number of instances to be returned in the response. If 0 or less, defaults
	// to the server's maximum allowed page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If non-empty, `page_token` should contain a
	// [next_page_token][google.spanner.admin.instance.v1.ListInstancesResponse.next_page_token]
	// from a previous
	// [ListInstancesResponse][google.spanner.admin.instance.v1.ListInstancesResponse].
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// An expression for filtering the results of the request. Filter rules are
	// case insensitive. The fields eligible for filtering are:
	//
	//   - `name`
	//   - `display_name`
	//   - `labels.key` where key is the name of a label
	//
	// Some examples of using filters are:
	//
	//   - `name:*` --> The instance has a name.
	//   - `name:Howl` --> The instance's name contains the string "howl".
	//   - `name:HOWL` --> Equivalent to above.
	//   - `NAME:howl` --> Equivalent to above.
	//   - `labels.env:*` --> The instance has the label "env".
	//   - `labels.env:dev` --> The instance has the label "env" and the value of
	//     the label contains the string "dev".
	//   - `name:howl labels.env:dev` --> The instance's name contains "howl" and
	//     it has the label "env" with its value
	//     containing "dev".
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Deadline used while retrieving metadata for instances.
	// Instances whose metadata cannot be retrieved within this deadline will be
	// added to
	// [unreachable][google.spanner.admin.instance.v1.ListInstancesResponse.unreachable]
	// in
	// [ListInstancesResponse][google.spanner.admin.instance.v1.ListInstancesResponse].
	InstanceDeadline *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=instance_deadline,json=instanceDeadline,proto3" json:"instance_deadline,omitempty"`
}

func (x *ListInstancesRequest) Reset() {
	*x = ListInstancesRequest{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListInstancesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInstancesRequest) ProtoMessage() {}

func (x *ListInstancesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInstancesRequest.ProtoReflect.Descriptor instead.
func (*ListInstancesRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{15}
}

func (x *ListInstancesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListInstancesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListInstancesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListInstancesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListInstancesRequest) GetInstanceDeadline() *timestamppb.Timestamp {
	if x != nil {
		return x.InstanceDeadline
	}
	return nil
}

// The response for
// [ListInstances][google.spanner.admin.instance.v1.InstanceAdmin.ListInstances].
type ListInstancesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of requested instances.
	Instances []*Instance `protobuf:"bytes,1,rep,name=instances,proto3" json:"instances,omitempty"`
	// `next_page_token` can be sent in a subsequent
	// [ListInstances][google.spanner.admin.instance.v1.InstanceAdmin.ListInstances]
	// call to fetch more of the matching instances.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The list of unreachable instances.
	// It includes the names of instances whose metadata could not be retrieved
	// within
	// [instance_deadline][google.spanner.admin.instance.v1.ListInstancesRequest.instance_deadline].
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListInstancesResponse) Reset() {
	*x = ListInstancesResponse{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListInstancesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInstancesResponse) ProtoMessage() {}

func (x *ListInstancesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInstancesResponse.ProtoReflect.Descriptor instead.
func (*ListInstancesResponse) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{16}
}

func (x *ListInstancesResponse) GetInstances() []*Instance {
	if x != nil {
		return x.Instances
	}
	return nil
}

func (x *ListInstancesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListInstancesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// The request for
// [UpdateInstance][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstance].
type UpdateInstanceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The instance to update, which must always include the instance
	// name.  Otherwise, only fields mentioned in
	// [field_mask][google.spanner.admin.instance.v1.UpdateInstanceRequest.field_mask]
	// need be included.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Required. A mask specifying which fields in
	// [Instance][google.spanner.admin.instance.v1.Instance] should be updated.
	// The field mask must always be specified; this prevents any future fields in
	// [Instance][google.spanner.admin.instance.v1.Instance] from being erased
	// accidentally by clients that do not know about them.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *UpdateInstanceRequest) Reset() {
	*x = UpdateInstanceRequest{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateInstanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateInstanceRequest) ProtoMessage() {}

func (x *UpdateInstanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateInstanceRequest.ProtoReflect.Descriptor instead.
func (*UpdateInstanceRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{17}
}

func (x *UpdateInstanceRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *UpdateInstanceRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

// The request for
// [DeleteInstance][google.spanner.admin.instance.v1.InstanceAdmin.DeleteInstance].
type DeleteInstanceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the instance to be deleted. Values are of the form
	// `projects/<project>/instances/<instance>`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteInstanceRequest) Reset() {
	*x = DeleteInstanceRequest{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteInstanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteInstanceRequest) ProtoMessage() {}

func (x *DeleteInstanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteInstanceRequest.ProtoReflect.Descriptor instead.
func (*DeleteInstanceRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{18}
}

func (x *DeleteInstanceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Metadata type for the operation returned by
// [CreateInstance][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstance].
type CreateInstanceMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The instance being created.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// The time at which the
	// [CreateInstance][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstance]
	// request was received.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time at which this operation was cancelled. If set, this operation is
	// in the process of undoing itself (which is guaranteed to succeed) and
	// cannot be cancelled again.
	CancelTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=cancel_time,json=cancelTime,proto3" json:"cancel_time,omitempty"`
	// The time at which this operation failed or was completed successfully.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The expected fulfillment period of this create operation.
	ExpectedFulfillmentPeriod FulfillmentPeriod `protobuf:"varint,5,opt,name=expected_fulfillment_period,json=expectedFulfillmentPeriod,proto3,enum=google.spanner.admin.instance.v1.FulfillmentPeriod" json:"expected_fulfillment_period,omitempty"`
}

func (x *CreateInstanceMetadata) Reset() {
	*x = CreateInstanceMetadata{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateInstanceMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateInstanceMetadata) ProtoMessage() {}

func (x *CreateInstanceMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateInstanceMetadata.ProtoReflect.Descriptor instead.
func (*CreateInstanceMetadata) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{19}
}

func (x *CreateInstanceMetadata) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *CreateInstanceMetadata) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *CreateInstanceMetadata) GetCancelTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CancelTime
	}
	return nil
}

func (x *CreateInstanceMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *CreateInstanceMetadata) GetExpectedFulfillmentPeriod() FulfillmentPeriod {
	if x != nil {
		return x.ExpectedFulfillmentPeriod
	}
	return FulfillmentPeriod_FULFILLMENT_PERIOD_UNSPECIFIED
}

// Metadata type for the operation returned by
// [UpdateInstance][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstance].
type UpdateInstanceMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The desired end state of the update.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// The time at which
	// [UpdateInstance][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstance]
	// request was received.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time at which this operation was cancelled. If set, this operation is
	// in the process of undoing itself (which is guaranteed to succeed) and
	// cannot be cancelled again.
	CancelTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=cancel_time,json=cancelTime,proto3" json:"cancel_time,omitempty"`
	// The time at which this operation failed or was completed successfully.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The expected fulfillment period of this update operation.
	ExpectedFulfillmentPeriod FulfillmentPeriod `protobuf:"varint,5,opt,name=expected_fulfillment_period,json=expectedFulfillmentPeriod,proto3,enum=google.spanner.admin.instance.v1.FulfillmentPeriod" json:"expected_fulfillment_period,omitempty"`
}

func (x *UpdateInstanceMetadata) Reset() {
	*x = UpdateInstanceMetadata{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateInstanceMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateInstanceMetadata) ProtoMessage() {}

func (x *UpdateInstanceMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateInstanceMetadata.ProtoReflect.Descriptor instead.
func (*UpdateInstanceMetadata) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{20}
}

func (x *UpdateInstanceMetadata) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *UpdateInstanceMetadata) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *UpdateInstanceMetadata) GetCancelTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CancelTime
	}
	return nil
}

func (x *UpdateInstanceMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *UpdateInstanceMetadata) GetExpectedFulfillmentPeriod() FulfillmentPeriod {
	if x != nil {
		return x.ExpectedFulfillmentPeriod
	}
	return FulfillmentPeriod_FULFILLMENT_PERIOD_UNSPECIFIED
}

// Free instance specific metadata that is kept even after an instance has been
// upgraded for tracking purposes.
type FreeInstanceMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Timestamp after which the instance will either be upgraded or
	// scheduled for deletion after a grace period. ExpireBehavior is used to
	// choose between upgrading or scheduling the free instance for deletion. This
	// timestamp is set during the creation of a free instance.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// Output only. If present, the timestamp at which the free instance was
	// upgraded to a provisioned instance.
	UpgradeTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=upgrade_time,json=upgradeTime,proto3" json:"upgrade_time,omitempty"`
	// Specifies the expiration behavior of a free instance. The default of
	// ExpireBehavior is `REMOVE_AFTER_GRACE_PERIOD`. This can be modified during
	// or after creation, and before expiration.
	ExpireBehavior FreeInstanceMetadata_ExpireBehavior `protobuf:"varint,3,opt,name=expire_behavior,json=expireBehavior,proto3,enum=google.spanner.admin.instance.v1.FreeInstanceMetadata_ExpireBehavior" json:"expire_behavior,omitempty"`
}

func (x *FreeInstanceMetadata) Reset() {
	*x = FreeInstanceMetadata{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FreeInstanceMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FreeInstanceMetadata) ProtoMessage() {}

func (x *FreeInstanceMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FreeInstanceMetadata.ProtoReflect.Descriptor instead.
func (*FreeInstanceMetadata) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{21}
}

func (x *FreeInstanceMetadata) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

func (x *FreeInstanceMetadata) GetUpgradeTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpgradeTime
	}
	return nil
}

func (x *FreeInstanceMetadata) GetExpireBehavior() FreeInstanceMetadata_ExpireBehavior {
	if x != nil {
		return x.ExpireBehavior
	}
	return FreeInstanceMetadata_EXPIRE_BEHAVIOR_UNSPECIFIED
}

// Metadata type for the operation returned by
// [CreateInstanceConfig][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstanceConfig].
type CreateInstanceConfigMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The target instance configuration end state.
	InstanceConfig *InstanceConfig `protobuf:"bytes,1,opt,name=instance_config,json=instanceConfig,proto3" json:"instance_config,omitempty"`
	// The progress of the
	// [CreateInstanceConfig][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstanceConfig]
	// operation.
	Progress *OperationProgress `protobuf:"bytes,2,opt,name=progress,proto3" json:"progress,omitempty"`
	// The time at which this operation was cancelled.
	CancelTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=cancel_time,json=cancelTime,proto3" json:"cancel_time,omitempty"`
}

func (x *CreateInstanceConfigMetadata) Reset() {
	*x = CreateInstanceConfigMetadata{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateInstanceConfigMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateInstanceConfigMetadata) ProtoMessage() {}

func (x *CreateInstanceConfigMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateInstanceConfigMetadata.ProtoReflect.Descriptor instead.
func (*CreateInstanceConfigMetadata) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{22}
}

func (x *CreateInstanceConfigMetadata) GetInstanceConfig() *InstanceConfig {
	if x != nil {
		return x.InstanceConfig
	}
	return nil
}

func (x *CreateInstanceConfigMetadata) GetProgress() *OperationProgress {
	if x != nil {
		return x.Progress
	}
	return nil
}

func (x *CreateInstanceConfigMetadata) GetCancelTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CancelTime
	}
	return nil
}

// Metadata type for the operation returned by
// [UpdateInstanceConfig][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstanceConfig].
type UpdateInstanceConfigMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The desired instance configuration after updating.
	InstanceConfig *InstanceConfig `protobuf:"bytes,1,opt,name=instance_config,json=instanceConfig,proto3" json:"instance_config,omitempty"`
	// The progress of the
	// [UpdateInstanceConfig][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstanceConfig]
	// operation.
	Progress *OperationProgress `protobuf:"bytes,2,opt,name=progress,proto3" json:"progress,omitempty"`
	// The time at which this operation was cancelled.
	CancelTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=cancel_time,json=cancelTime,proto3" json:"cancel_time,omitempty"`
}

func (x *UpdateInstanceConfigMetadata) Reset() {
	*x = UpdateInstanceConfigMetadata{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateInstanceConfigMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateInstanceConfigMetadata) ProtoMessage() {}

func (x *UpdateInstanceConfigMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateInstanceConfigMetadata.ProtoReflect.Descriptor instead.
func (*UpdateInstanceConfigMetadata) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{23}
}

func (x *UpdateInstanceConfigMetadata) GetInstanceConfig() *InstanceConfig {
	if x != nil {
		return x.InstanceConfig
	}
	return nil
}

func (x *UpdateInstanceConfigMetadata) GetProgress() *OperationProgress {
	if x != nil {
		return x.Progress
	}
	return nil
}

func (x *UpdateInstanceConfigMetadata) GetCancelTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CancelTime
	}
	return nil
}

// An isolated set of Cloud Spanner resources that databases can define
// placements on.
type InstancePartition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A unique identifier for the instance partition. Values are of the
	// form
	// `projects/<project>/instances/<instance>/instancePartitions/[a-z][-a-z0-9]*[a-z0-9]`.
	// The final segment of the name must be between 2 and 64 characters in
	// length. An instance partition's name cannot be changed after the instance
	// partition is created.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The name of the instance partition's configuration. Values are of
	// the form `projects/<project>/instanceConfigs/<configuration>`. See also
	// [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig] and
	// [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs].
	Config string `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// Required. The descriptive name for this instance partition as it appears in
	// UIs. Must be unique per project and between 4 and 30 characters in length.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Compute capacity defines amount of server and storage resources that are
	// available to the databases in an instance partition. At most, one of either
	// `node_count` or` processing_units` should be present in the message. For
	// more information, see
	// [Compute capacity, nodes, and processing
	// units](https://cloud.google.com/spanner/docs/compute-capacity).
	//
	// Types that are assignable to ComputeCapacity:
	//
	//	*InstancePartition_NodeCount
	//	*InstancePartition_ProcessingUnits
	ComputeCapacity isInstancePartition_ComputeCapacity `protobuf_oneof:"compute_capacity"`
	// Optional. The autoscaling configuration. Autoscaling is enabled if this
	// field is set. When autoscaling is enabled, fields in compute_capacity are
	// treated as OUTPUT_ONLY fields and reflect the current compute capacity
	// allocated to the instance partition.
	AutoscalingConfig *AutoscalingConfig `protobuf:"bytes,13,opt,name=autoscaling_config,json=autoscalingConfig,proto3" json:"autoscaling_config,omitempty"`
	// Output only. The current instance partition state.
	State InstancePartition_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.spanner.admin.instance.v1.InstancePartition_State" json:"state,omitempty"`
	// Output only. The time at which the instance partition was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which the instance partition was most recently
	// updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The names of the databases that reference this
	// instance partition. Referencing databases should share the parent instance.
	// The existence of any referencing database prevents the instance partition
	// from being deleted.
	ReferencingDatabases []string `protobuf:"bytes,10,rep,name=referencing_databases,json=referencingDatabases,proto3" json:"referencing_databases,omitempty"`
	// Output only. Deprecated: This field is not populated.
	// Output only. The names of the backups that reference this instance
	// partition. Referencing backups should share the parent instance. The
	// existence of any referencing backup prevents the instance partition from
	// being deleted.
	//
	// Deprecated: Marked as deprecated in google/spanner/admin/instance/v1/spanner_instance_admin.proto.
	ReferencingBackups []string `protobuf:"bytes,11,rep,name=referencing_backups,json=referencingBackups,proto3" json:"referencing_backups,omitempty"`
	// Used for optimistic concurrency control as a way
	// to help prevent simultaneous updates of a instance partition from
	// overwriting each other. It is strongly suggested that systems make use of
	// the etag in the read-modify-write cycle to perform instance partition
	// updates in order to avoid race conditions: An etag is returned in the
	// response which contains instance partitions, and systems are expected to
	// put that etag in the request to update instance partitions to ensure that
	// their change will be applied to the same version of the instance partition.
	// If no etag is provided in the call to update instance partition, then the
	// existing instance partition is overwritten blindly.
	Etag string `protobuf:"bytes,12,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *InstancePartition) Reset() {
	*x = InstancePartition{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InstancePartition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstancePartition) ProtoMessage() {}

func (x *InstancePartition) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstancePartition.ProtoReflect.Descriptor instead.
func (*InstancePartition) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{24}
}

func (x *InstancePartition) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *InstancePartition) GetConfig() string {
	if x != nil {
		return x.Config
	}
	return ""
}

func (x *InstancePartition) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (m *InstancePartition) GetComputeCapacity() isInstancePartition_ComputeCapacity {
	if m != nil {
		return m.ComputeCapacity
	}
	return nil
}

func (x *InstancePartition) GetNodeCount() int32 {
	if x, ok := x.GetComputeCapacity().(*InstancePartition_NodeCount); ok {
		return x.NodeCount
	}
	return 0
}

func (x *InstancePartition) GetProcessingUnits() int32 {
	if x, ok := x.GetComputeCapacity().(*InstancePartition_ProcessingUnits); ok {
		return x.ProcessingUnits
	}
	return 0
}

func (x *InstancePartition) GetAutoscalingConfig() *AutoscalingConfig {
	if x != nil {
		return x.AutoscalingConfig
	}
	return nil
}

func (x *InstancePartition) GetState() InstancePartition_State {
	if x != nil {
		return x.State
	}
	return InstancePartition_STATE_UNSPECIFIED
}

func (x *InstancePartition) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *InstancePartition) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *InstancePartition) GetReferencingDatabases() []string {
	if x != nil {
		return x.ReferencingDatabases
	}
	return nil
}

// Deprecated: Marked as deprecated in google/spanner/admin/instance/v1/spanner_instance_admin.proto.
func (x *InstancePartition) GetReferencingBackups() []string {
	if x != nil {
		return x.ReferencingBackups
	}
	return nil
}

func (x *InstancePartition) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

type isInstancePartition_ComputeCapacity interface {
	isInstancePartition_ComputeCapacity()
}

type InstancePartition_NodeCount struct {
	// The number of nodes allocated to this instance partition.
	//
	// Users can set the `node_count` field to specify the target number of
	// nodes allocated to the instance partition.
	//
	// This may be zero in API responses for instance partitions that are not
	// yet in state `READY`.
	NodeCount int32 `protobuf:"varint,5,opt,name=node_count,json=nodeCount,proto3,oneof"`
}

type InstancePartition_ProcessingUnits struct {
	// The number of processing units allocated to this instance partition.
	//
	// Users can set the `processing_units` field to specify the target number
	// of processing units allocated to the instance partition.
	//
	// This might be zero in API responses for instance partitions that are not
	// yet in the `READY` state.
	ProcessingUnits int32 `protobuf:"varint,6,opt,name=processing_units,json=processingUnits,proto3,oneof"`
}

func (*InstancePartition_NodeCount) isInstancePartition_ComputeCapacity() {}

func (*InstancePartition_ProcessingUnits) isInstancePartition_ComputeCapacity() {}

// Metadata type for the operation returned by
// [CreateInstancePartition][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstancePartition].
type CreateInstancePartitionMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The instance partition being created.
	InstancePartition *InstancePartition `protobuf:"bytes,1,opt,name=instance_partition,json=instancePartition,proto3" json:"instance_partition,omitempty"`
	// The time at which the
	// [CreateInstancePartition][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstancePartition]
	// request was received.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time at which this operation was cancelled. If set, this operation is
	// in the process of undoing itself (which is guaranteed to succeed) and
	// cannot be cancelled again.
	CancelTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=cancel_time,json=cancelTime,proto3" json:"cancel_time,omitempty"`
	// The time at which this operation failed or was completed successfully.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *CreateInstancePartitionMetadata) Reset() {
	*x = CreateInstancePartitionMetadata{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateInstancePartitionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateInstancePartitionMetadata) ProtoMessage() {}

func (x *CreateInstancePartitionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateInstancePartitionMetadata.ProtoReflect.Descriptor instead.
func (*CreateInstancePartitionMetadata) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{25}
}

func (x *CreateInstancePartitionMetadata) GetInstancePartition() *InstancePartition {
	if x != nil {
		return x.InstancePartition
	}
	return nil
}

func (x *CreateInstancePartitionMetadata) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *CreateInstancePartitionMetadata) GetCancelTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CancelTime
	}
	return nil
}

func (x *CreateInstancePartitionMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// The request for
// [CreateInstancePartition][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstancePartition].
type CreateInstancePartitionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the instance in which to create the instance
	// partition. Values are of the form
	// `projects/<project>/instances/<instance>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the instance partition to create. Valid identifiers are
	// of the form `[a-z][-a-z0-9]*[a-z0-9]` and must be between 2 and 64
	// characters in length.
	InstancePartitionId string `protobuf:"bytes,2,opt,name=instance_partition_id,json=instancePartitionId,proto3" json:"instance_partition_id,omitempty"`
	// Required. The instance partition to create. The instance_partition.name may
	// be omitted, but if specified must be
	// `<parent>/instancePartitions/<instance_partition_id>`.
	InstancePartition *InstancePartition `protobuf:"bytes,3,opt,name=instance_partition,json=instancePartition,proto3" json:"instance_partition,omitempty"`
}

func (x *CreateInstancePartitionRequest) Reset() {
	*x = CreateInstancePartitionRequest{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateInstancePartitionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateInstancePartitionRequest) ProtoMessage() {}

func (x *CreateInstancePartitionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateInstancePartitionRequest.ProtoReflect.Descriptor instead.
func (*CreateInstancePartitionRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{26}
}

func (x *CreateInstancePartitionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateInstancePartitionRequest) GetInstancePartitionId() string {
	if x != nil {
		return x.InstancePartitionId
	}
	return ""
}

func (x *CreateInstancePartitionRequest) GetInstancePartition() *InstancePartition {
	if x != nil {
		return x.InstancePartition
	}
	return nil
}

// The request for
// [DeleteInstancePartition][google.spanner.admin.instance.v1.InstanceAdmin.DeleteInstancePartition].
type DeleteInstancePartitionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the instance partition to be deleted.
	// Values are of the form
	// `projects/{project}/instances/{instance}/instancePartitions/{instance_partition}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. If not empty, the API only deletes the instance partition when
	// the etag provided matches the current status of the requested instance
	// partition. Otherwise, deletes the instance partition without checking the
	// current status of the requested instance partition.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteInstancePartitionRequest) Reset() {
	*x = DeleteInstancePartitionRequest{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteInstancePartitionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteInstancePartitionRequest) ProtoMessage() {}

func (x *DeleteInstancePartitionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteInstancePartitionRequest.ProtoReflect.Descriptor instead.
func (*DeleteInstancePartitionRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{27}
}

func (x *DeleteInstancePartitionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteInstancePartitionRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// The request for
// [GetInstancePartition][google.spanner.admin.instance.v1.InstanceAdmin.GetInstancePartition].
type GetInstancePartitionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the requested instance partition. Values are of
	// the form
	// `projects/{project}/instances/{instance}/instancePartitions/{instance_partition}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetInstancePartitionRequest) Reset() {
	*x = GetInstancePartitionRequest{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetInstancePartitionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetInstancePartitionRequest) ProtoMessage() {}

func (x *GetInstancePartitionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetInstancePartitionRequest.ProtoReflect.Descriptor instead.
func (*GetInstancePartitionRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{28}
}

func (x *GetInstancePartitionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for
// [UpdateInstancePartition][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstancePartition].
type UpdateInstancePartitionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The instance partition to update, which must always include the
	// instance partition name. Otherwise, only fields mentioned in
	// [field_mask][google.spanner.admin.instance.v1.UpdateInstancePartitionRequest.field_mask]
	// need be included.
	InstancePartition *InstancePartition `protobuf:"bytes,1,opt,name=instance_partition,json=instancePartition,proto3" json:"instance_partition,omitempty"`
	// Required. A mask specifying which fields in
	// [InstancePartition][google.spanner.admin.instance.v1.InstancePartition]
	// should be updated. The field mask must always be specified; this prevents
	// any future fields in
	// [InstancePartition][google.spanner.admin.instance.v1.InstancePartition]
	// from being erased accidentally by clients that do not know about them.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *UpdateInstancePartitionRequest) Reset() {
	*x = UpdateInstancePartitionRequest{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateInstancePartitionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateInstancePartitionRequest) ProtoMessage() {}

func (x *UpdateInstancePartitionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateInstancePartitionRequest.ProtoReflect.Descriptor instead.
func (*UpdateInstancePartitionRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{29}
}

func (x *UpdateInstancePartitionRequest) GetInstancePartition() *InstancePartition {
	if x != nil {
		return x.InstancePartition
	}
	return nil
}

func (x *UpdateInstancePartitionRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

// Metadata type for the operation returned by
// [UpdateInstancePartition][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstancePartition].
type UpdateInstancePartitionMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The desired end state of the update.
	InstancePartition *InstancePartition `protobuf:"bytes,1,opt,name=instance_partition,json=instancePartition,proto3" json:"instance_partition,omitempty"`
	// The time at which
	// [UpdateInstancePartition][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstancePartition]
	// request was received.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time at which this operation was cancelled. If set, this operation is
	// in the process of undoing itself (which is guaranteed to succeed) and
	// cannot be cancelled again.
	CancelTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=cancel_time,json=cancelTime,proto3" json:"cancel_time,omitempty"`
	// The time at which this operation failed or was completed successfully.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *UpdateInstancePartitionMetadata) Reset() {
	*x = UpdateInstancePartitionMetadata{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateInstancePartitionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateInstancePartitionMetadata) ProtoMessage() {}

func (x *UpdateInstancePartitionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateInstancePartitionMetadata.ProtoReflect.Descriptor instead.
func (*UpdateInstancePartitionMetadata) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{30}
}

func (x *UpdateInstancePartitionMetadata) GetInstancePartition() *InstancePartition {
	if x != nil {
		return x.InstancePartition
	}
	return nil
}

func (x *UpdateInstancePartitionMetadata) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *UpdateInstancePartitionMetadata) GetCancelTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CancelTime
	}
	return nil
}

func (x *UpdateInstancePartitionMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// The request for
// [ListInstancePartitions][google.spanner.admin.instance.v1.InstanceAdmin.ListInstancePartitions].
type ListInstancePartitionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The instance whose instance partitions should be listed. Values
	// are of the form `projects/<project>/instances/<instance>`. Use `{instance}
	// = '-'` to list instance partitions for all Instances in a project, e.g.,
	// `projects/myproject/instances/-`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Number of instance partitions to be returned in the response. If 0 or less,
	// defaults to the server's maximum allowed page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If non-empty, `page_token` should contain a
	// [next_page_token][google.spanner.admin.instance.v1.ListInstancePartitionsResponse.next_page_token]
	// from a previous
	// [ListInstancePartitionsResponse][google.spanner.admin.instance.v1.ListInstancePartitionsResponse].
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Deadline used while retrieving metadata for instance partitions.
	// Instance partitions whose metadata cannot be retrieved within this deadline
	// will be added to
	// [unreachable][google.spanner.admin.instance.v1.ListInstancePartitionsResponse.unreachable]
	// in
	// [ListInstancePartitionsResponse][google.spanner.admin.instance.v1.ListInstancePartitionsResponse].
	InstancePartitionDeadline *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=instance_partition_deadline,json=instancePartitionDeadline,proto3" json:"instance_partition_deadline,omitempty"`
}

func (x *ListInstancePartitionsRequest) Reset() {
	*x = ListInstancePartitionsRequest{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListInstancePartitionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInstancePartitionsRequest) ProtoMessage() {}

func (x *ListInstancePartitionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInstancePartitionsRequest.ProtoReflect.Descriptor instead.
func (*ListInstancePartitionsRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{31}
}

func (x *ListInstancePartitionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListInstancePartitionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListInstancePartitionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListInstancePartitionsRequest) GetInstancePartitionDeadline() *timestamppb.Timestamp {
	if x != nil {
		return x.InstancePartitionDeadline
	}
	return nil
}

// The response for
// [ListInstancePartitions][google.spanner.admin.instance.v1.InstanceAdmin.ListInstancePartitions].
type ListInstancePartitionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of requested instancePartitions.
	InstancePartitions []*InstancePartition `protobuf:"bytes,1,rep,name=instance_partitions,json=instancePartitions,proto3" json:"instance_partitions,omitempty"`
	// `next_page_token` can be sent in a subsequent
	// [ListInstancePartitions][google.spanner.admin.instance.v1.InstanceAdmin.ListInstancePartitions]
	// call to fetch more of the matching instance partitions.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The list of unreachable instances or instance partitions.
	// It includes the names of instances or instance partitions whose metadata
	// could not be retrieved within
	// [instance_partition_deadline][google.spanner.admin.instance.v1.ListInstancePartitionsRequest.instance_partition_deadline].
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListInstancePartitionsResponse) Reset() {
	*x = ListInstancePartitionsResponse{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListInstancePartitionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInstancePartitionsResponse) ProtoMessage() {}

func (x *ListInstancePartitionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInstancePartitionsResponse.ProtoReflect.Descriptor instead.
func (*ListInstancePartitionsResponse) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{32}
}

func (x *ListInstancePartitionsResponse) GetInstancePartitions() []*InstancePartition {
	if x != nil {
		return x.InstancePartitions
	}
	return nil
}

func (x *ListInstancePartitionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListInstancePartitionsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// The request for
// [ListInstancePartitionOperations][google.spanner.admin.instance.v1.InstanceAdmin.ListInstancePartitionOperations].
type ListInstancePartitionOperationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent instance of the instance partition operations.
	// Values are of the form `projects/<project>/instances/<instance>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. An expression that filters the list of returned operations.
	//
	// A filter expression consists of a field name, a
	// comparison operator, and a value for filtering.
	// The value must be a string, a number, or a boolean. The comparison operator
	// must be one of: `<`, `>`, `<=`, `>=`, `!=`, `=`, or `:`.
	// Colon `:` is the contains operator. Filter rules are not case sensitive.
	//
	// The following fields in the Operation are eligible for filtering:
	//
	//   - `name` - The name of the long-running operation
	//   - `done` - False if the operation is in progress, else true.
	//   - `metadata.@type` - the type of metadata. For example, the type string
	//     for
	//     [CreateInstancePartitionMetadata][google.spanner.admin.instance.v1.CreateInstancePartitionMetadata]
	//     is
	//     `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstancePartitionMetadata`.
	//   - `metadata.<field_name>` - any field in metadata.value.
	//     `metadata.@type` must be specified first, if filtering on metadata
	//     fields.
	//   - `error` - Error associated with the long-running operation.
	//   - `response.@type` - the type of response.
	//   - `response.<field_name>` - any field in response.value.
	//
	// You can combine multiple expressions by enclosing each expression in
	// parentheses. By default, expressions are combined with AND logic. However,
	// you can specify AND, OR, and NOT logic explicitly.
	//
	// Here are a few examples:
	//
	//   - `done:true` - The operation is complete.
	//   - `(metadata.@type=` \
	//     `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstancePartitionMetadata)
	//     AND` \
	//     `(metadata.instance_partition.name:custom-instance-partition) AND` \
	//     `(metadata.start_time < \"2021-03-28T14:50:00Z\") AND` \
	//     `(error:*)` - Return operations where:
	//   - The operation's metadata type is
	//     [CreateInstancePartitionMetadata][google.spanner.admin.instance.v1.CreateInstancePartitionMetadata].
	//   - The instance partition name contains "custom-instance-partition".
	//   - The operation started before 2021-03-28T14:50:00Z.
	//   - The operation resulted in an error.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Number of operations to be returned in the response. If 0 or
	// less, defaults to the server's maximum allowed page size.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. If non-empty, `page_token` should contain a
	// [next_page_token][google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse.next_page_token]
	// from a previous
	// [ListInstancePartitionOperationsResponse][google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse]
	// to the same `parent` and with the same `filter`.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Deadline used while retrieving metadata for instance partition
	// operations. Instance partitions whose operation metadata cannot be
	// retrieved within this deadline will be added to
	// [unreachable_instance_partitions][google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse.unreachable_instance_partitions]
	// in
	// [ListInstancePartitionOperationsResponse][google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse].
	InstancePartitionDeadline *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=instance_partition_deadline,json=instancePartitionDeadline,proto3" json:"instance_partition_deadline,omitempty"`
}

func (x *ListInstancePartitionOperationsRequest) Reset() {
	*x = ListInstancePartitionOperationsRequest{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListInstancePartitionOperationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInstancePartitionOperationsRequest) ProtoMessage() {}

func (x *ListInstancePartitionOperationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInstancePartitionOperationsRequest.ProtoReflect.Descriptor instead.
func (*ListInstancePartitionOperationsRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{33}
}

func (x *ListInstancePartitionOperationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListInstancePartitionOperationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListInstancePartitionOperationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListInstancePartitionOperationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListInstancePartitionOperationsRequest) GetInstancePartitionDeadline() *timestamppb.Timestamp {
	if x != nil {
		return x.InstancePartitionDeadline
	}
	return nil
}

// The response for
// [ListInstancePartitionOperations][google.spanner.admin.instance.v1.InstanceAdmin.ListInstancePartitionOperations].
type ListInstancePartitionOperationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of matching instance partition long-running operations. Each
	// operation's name will be
	// prefixed by the instance partition's name. The operation's
	// metadata field type
	// `metadata.type_url` describes the type of the metadata.
	Operations []*longrunningpb.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// `next_page_token` can be sent in a subsequent
	// [ListInstancePartitionOperations][google.spanner.admin.instance.v1.InstanceAdmin.ListInstancePartitionOperations]
	// call to fetch more of the matching metadata.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The list of unreachable instance partitions.
	// It includes the names of instance partitions whose operation metadata could
	// not be retrieved within
	// [instance_partition_deadline][google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest.instance_partition_deadline].
	UnreachableInstancePartitions []string `protobuf:"bytes,3,rep,name=unreachable_instance_partitions,json=unreachableInstancePartitions,proto3" json:"unreachable_instance_partitions,omitempty"`
}

func (x *ListInstancePartitionOperationsResponse) Reset() {
	*x = ListInstancePartitionOperationsResponse{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListInstancePartitionOperationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInstancePartitionOperationsResponse) ProtoMessage() {}

func (x *ListInstancePartitionOperationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInstancePartitionOperationsResponse.ProtoReflect.Descriptor instead.
func (*ListInstancePartitionOperationsResponse) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{34}
}

func (x *ListInstancePartitionOperationsResponse) GetOperations() []*longrunningpb.Operation {
	if x != nil {
		return x.Operations
	}
	return nil
}

func (x *ListInstancePartitionOperationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListInstancePartitionOperationsResponse) GetUnreachableInstancePartitions() []string {
	if x != nil {
		return x.UnreachableInstancePartitions
	}
	return nil
}

// The request for
// [MoveInstance][google.spanner.admin.instance.v1.InstanceAdmin.MoveInstance].
type MoveInstanceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The instance to move.
	// Values are of the form `projects/<project>/instances/<instance>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The target instance configuration where to move the instance.
	// Values are of the form `projects/<project>/instanceConfigs/<config>`.
	TargetConfig string `protobuf:"bytes,2,opt,name=target_config,json=targetConfig,proto3" json:"target_config,omitempty"`
}

func (x *MoveInstanceRequest) Reset() {
	*x = MoveInstanceRequest{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MoveInstanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MoveInstanceRequest) ProtoMessage() {}

func (x *MoveInstanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MoveInstanceRequest.ProtoReflect.Descriptor instead.
func (*MoveInstanceRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{35}
}

func (x *MoveInstanceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MoveInstanceRequest) GetTargetConfig() string {
	if x != nil {
		return x.TargetConfig
	}
	return ""
}

// The response for
// [MoveInstance][google.spanner.admin.instance.v1.InstanceAdmin.MoveInstance].
type MoveInstanceResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *MoveInstanceResponse) Reset() {
	*x = MoveInstanceResponse{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MoveInstanceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MoveInstanceResponse) ProtoMessage() {}

func (x *MoveInstanceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MoveInstanceResponse.ProtoReflect.Descriptor instead.
func (*MoveInstanceResponse) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{36}
}

// Metadata type for the operation returned by
// [MoveInstance][google.spanner.admin.instance.v1.InstanceAdmin.MoveInstance].
type MoveInstanceMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The target instance configuration where to move the instance.
	// Values are of the form `projects/<project>/instanceConfigs/<config>`.
	TargetConfig string `protobuf:"bytes,1,opt,name=target_config,json=targetConfig,proto3" json:"target_config,omitempty"`
	// The progress of the
	// [MoveInstance][google.spanner.admin.instance.v1.InstanceAdmin.MoveInstance]
	// operation.
	// [progress_percent][google.spanner.admin.instance.v1.OperationProgress.progress_percent]
	// is reset when cancellation is requested.
	Progress *OperationProgress `protobuf:"bytes,2,opt,name=progress,proto3" json:"progress,omitempty"`
	// The time at which this operation was cancelled.
	CancelTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=cancel_time,json=cancelTime,proto3" json:"cancel_time,omitempty"`
}

func (x *MoveInstanceMetadata) Reset() {
	*x = MoveInstanceMetadata{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MoveInstanceMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MoveInstanceMetadata) ProtoMessage() {}

func (x *MoveInstanceMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MoveInstanceMetadata.ProtoReflect.Descriptor instead.
func (*MoveInstanceMetadata) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{37}
}

func (x *MoveInstanceMetadata) GetTargetConfig() string {
	if x != nil {
		return x.TargetConfig
	}
	return ""
}

func (x *MoveInstanceMetadata) GetProgress() *OperationProgress {
	if x != nil {
		return x.Progress
	}
	return nil
}

func (x *MoveInstanceMetadata) GetCancelTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CancelTime
	}
	return nil
}

// The autoscaling limits for the instance. Users can define the minimum and
// maximum compute capacity allocated to the instance, and the autoscaler will
// only scale within that range. Users can either use nodes or processing
// units to specify the limits, but should use the same unit to set both the
// min_limit and max_limit.
type AutoscalingConfig_AutoscalingLimits struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The minimum compute capacity for the instance.
	//
	// Types that are assignable to MinLimit:
	//
	//	*AutoscalingConfig_AutoscalingLimits_MinNodes
	//	*AutoscalingConfig_AutoscalingLimits_MinProcessingUnits
	MinLimit isAutoscalingConfig_AutoscalingLimits_MinLimit `protobuf_oneof:"min_limit"`
	// The maximum compute capacity for the instance. The maximum compute
	// capacity should be less than or equal to 10X the minimum compute
	// capacity.
	//
	// Types that are assignable to MaxLimit:
	//
	//	*AutoscalingConfig_AutoscalingLimits_MaxNodes
	//	*AutoscalingConfig_AutoscalingLimits_MaxProcessingUnits
	MaxLimit isAutoscalingConfig_AutoscalingLimits_MaxLimit `protobuf_oneof:"max_limit"`
}

func (x *AutoscalingConfig_AutoscalingLimits) Reset() {
	*x = AutoscalingConfig_AutoscalingLimits{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutoscalingConfig_AutoscalingLimits) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoscalingConfig_AutoscalingLimits) ProtoMessage() {}

func (x *AutoscalingConfig_AutoscalingLimits) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoscalingConfig_AutoscalingLimits.ProtoReflect.Descriptor instead.
func (*AutoscalingConfig_AutoscalingLimits) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{3, 0}
}

func (m *AutoscalingConfig_AutoscalingLimits) GetMinLimit() isAutoscalingConfig_AutoscalingLimits_MinLimit {
	if m != nil {
		return m.MinLimit
	}
	return nil
}

func (x *AutoscalingConfig_AutoscalingLimits) GetMinNodes() int32 {
	if x, ok := x.GetMinLimit().(*AutoscalingConfig_AutoscalingLimits_MinNodes); ok {
		return x.MinNodes
	}
	return 0
}

func (x *AutoscalingConfig_AutoscalingLimits) GetMinProcessingUnits() int32 {
	if x, ok := x.GetMinLimit().(*AutoscalingConfig_AutoscalingLimits_MinProcessingUnits); ok {
		return x.MinProcessingUnits
	}
	return 0
}

func (m *AutoscalingConfig_AutoscalingLimits) GetMaxLimit() isAutoscalingConfig_AutoscalingLimits_MaxLimit {
	if m != nil {
		return m.MaxLimit
	}
	return nil
}

func (x *AutoscalingConfig_AutoscalingLimits) GetMaxNodes() int32 {
	if x, ok := x.GetMaxLimit().(*AutoscalingConfig_AutoscalingLimits_MaxNodes); ok {
		return x.MaxNodes
	}
	return 0
}

func (x *AutoscalingConfig_AutoscalingLimits) GetMaxProcessingUnits() int32 {
	if x, ok := x.GetMaxLimit().(*AutoscalingConfig_AutoscalingLimits_MaxProcessingUnits); ok {
		return x.MaxProcessingUnits
	}
	return 0
}

type isAutoscalingConfig_AutoscalingLimits_MinLimit interface {
	isAutoscalingConfig_AutoscalingLimits_MinLimit()
}

type AutoscalingConfig_AutoscalingLimits_MinNodes struct {
	// Minimum number of nodes allocated to the instance. If set, this number
	// should be greater than or equal to 1.
	MinNodes int32 `protobuf:"varint,1,opt,name=min_nodes,json=minNodes,proto3,oneof"`
}

type AutoscalingConfig_AutoscalingLimits_MinProcessingUnits struct {
	// Minimum number of processing units allocated to the instance. If set,
	// this number should be multiples of 1000.
	MinProcessingUnits int32 `protobuf:"varint,2,opt,name=min_processing_units,json=minProcessingUnits,proto3,oneof"`
}

func (*AutoscalingConfig_AutoscalingLimits_MinNodes) isAutoscalingConfig_AutoscalingLimits_MinLimit() {
}

func (*AutoscalingConfig_AutoscalingLimits_MinProcessingUnits) isAutoscalingConfig_AutoscalingLimits_MinLimit() {
}

type isAutoscalingConfig_AutoscalingLimits_MaxLimit interface {
	isAutoscalingConfig_AutoscalingLimits_MaxLimit()
}

type AutoscalingConfig_AutoscalingLimits_MaxNodes struct {
	// Maximum number of nodes allocated to the instance. If set, this number
	// should be greater than or equal to min_nodes.
	MaxNodes int32 `protobuf:"varint,3,opt,name=max_nodes,json=maxNodes,proto3,oneof"`
}

type AutoscalingConfig_AutoscalingLimits_MaxProcessingUnits struct {
	// Maximum number of processing units allocated to the instance. If set,
	// this number should be multiples of 1000 and be greater than or equal to
	// min_processing_units.
	MaxProcessingUnits int32 `protobuf:"varint,4,opt,name=max_processing_units,json=maxProcessingUnits,proto3,oneof"`
}

func (*AutoscalingConfig_AutoscalingLimits_MaxNodes) isAutoscalingConfig_AutoscalingLimits_MaxLimit() {
}

func (*AutoscalingConfig_AutoscalingLimits_MaxProcessingUnits) isAutoscalingConfig_AutoscalingLimits_MaxLimit() {
}

// The autoscaling targets for an instance.
type AutoscalingConfig_AutoscalingTargets struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The target high priority cpu utilization percentage that the
	// autoscaler should be trying to achieve for the instance. This number is
	// on a scale from 0 (no utilization) to 100 (full utilization). The valid
	// range is [10, 90] inclusive.
	HighPriorityCpuUtilizationPercent int32 `protobuf:"varint,1,opt,name=high_priority_cpu_utilization_percent,json=highPriorityCpuUtilizationPercent,proto3" json:"high_priority_cpu_utilization_percent,omitempty"`
	// Required. The target storage utilization percentage that the autoscaler
	// should be trying to achieve for the instance. This number is on a scale
	// from 0 (no utilization) to 100 (full utilization). The valid range is
	// [10, 99] inclusive.
	StorageUtilizationPercent int32 `protobuf:"varint,2,opt,name=storage_utilization_percent,json=storageUtilizationPercent,proto3" json:"storage_utilization_percent,omitempty"`
}

func (x *AutoscalingConfig_AutoscalingTargets) Reset() {
	*x = AutoscalingConfig_AutoscalingTargets{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutoscalingConfig_AutoscalingTargets) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoscalingConfig_AutoscalingTargets) ProtoMessage() {}

func (x *AutoscalingConfig_AutoscalingTargets) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoscalingConfig_AutoscalingTargets.ProtoReflect.Descriptor instead.
func (*AutoscalingConfig_AutoscalingTargets) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{3, 1}
}

func (x *AutoscalingConfig_AutoscalingTargets) GetHighPriorityCpuUtilizationPercent() int32 {
	if x != nil {
		return x.HighPriorityCpuUtilizationPercent
	}
	return 0
}

func (x *AutoscalingConfig_AutoscalingTargets) GetStorageUtilizationPercent() int32 {
	if x != nil {
		return x.StorageUtilizationPercent
	}
	return 0
}

// AsymmetricAutoscalingOption specifies the scaling of replicas identified by
// the given selection.
type AutoscalingConfig_AsymmetricAutoscalingOption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Selects the replicas to which this AsymmetricAutoscalingOption
	// applies. Only read-only replicas are supported.
	ReplicaSelection *ReplicaSelection `protobuf:"bytes,1,opt,name=replica_selection,json=replicaSelection,proto3" json:"replica_selection,omitempty"`
	// Optional. Overrides applied to the top-level autoscaling configuration
	// for the selected replicas.
	Overrides *AutoscalingConfig_AsymmetricAutoscalingOption_AutoscalingConfigOverrides `protobuf:"bytes,2,opt,name=overrides,proto3" json:"overrides,omitempty"`
}

func (x *AutoscalingConfig_AsymmetricAutoscalingOption) Reset() {
	*x = AutoscalingConfig_AsymmetricAutoscalingOption{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutoscalingConfig_AsymmetricAutoscalingOption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoscalingConfig_AsymmetricAutoscalingOption) ProtoMessage() {}

func (x *AutoscalingConfig_AsymmetricAutoscalingOption) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoscalingConfig_AsymmetricAutoscalingOption.ProtoReflect.Descriptor instead.
func (*AutoscalingConfig_AsymmetricAutoscalingOption) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{3, 2}
}

func (x *AutoscalingConfig_AsymmetricAutoscalingOption) GetReplicaSelection() *ReplicaSelection {
	if x != nil {
		return x.ReplicaSelection
	}
	return nil
}

func (x *AutoscalingConfig_AsymmetricAutoscalingOption) GetOverrides() *AutoscalingConfig_AsymmetricAutoscalingOption_AutoscalingConfigOverrides {
	if x != nil {
		return x.Overrides
	}
	return nil
}

// Overrides the top-level autoscaling configuration for the replicas
// identified by `replica_selection`. All fields in this message are
// optional. Any unspecified fields will use the corresponding values from
// the top-level autoscaling configuration.
type AutoscalingConfig_AsymmetricAutoscalingOption_AutoscalingConfigOverrides struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. If specified, overrides the min/max limit in the top-level
	// autoscaling configuration for the selected replicas.
	AutoscalingLimits *AutoscalingConfig_AutoscalingLimits `protobuf:"bytes,1,opt,name=autoscaling_limits,json=autoscalingLimits,proto3" json:"autoscaling_limits,omitempty"`
	// Optional. If specified, overrides the autoscaling target
	// high_priority_cpu_utilization_percent in the top-level autoscaling
	// configuration for the selected replicas.
	AutoscalingTargetHighPriorityCpuUtilizationPercent int32 `protobuf:"varint,2,opt,name=autoscaling_target_high_priority_cpu_utilization_percent,json=autoscalingTargetHighPriorityCpuUtilizationPercent,proto3" json:"autoscaling_target_high_priority_cpu_utilization_percent,omitempty"`
}

func (x *AutoscalingConfig_AsymmetricAutoscalingOption_AutoscalingConfigOverrides) Reset() {
	*x = AutoscalingConfig_AsymmetricAutoscalingOption_AutoscalingConfigOverrides{}
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutoscalingConfig_AsymmetricAutoscalingOption_AutoscalingConfigOverrides) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoscalingConfig_AsymmetricAutoscalingOption_AutoscalingConfigOverrides) ProtoMessage() {}

func (x *AutoscalingConfig_AsymmetricAutoscalingOption_AutoscalingConfigOverrides) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoscalingConfig_AsymmetricAutoscalingOption_AutoscalingConfigOverrides.ProtoReflect.Descriptor instead.
func (*AutoscalingConfig_AsymmetricAutoscalingOption_AutoscalingConfigOverrides) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{3, 2, 0}
}

func (x *AutoscalingConfig_AsymmetricAutoscalingOption_AutoscalingConfigOverrides) GetAutoscalingLimits() *AutoscalingConfig_AutoscalingLimits {
	if x != nil {
		return x.AutoscalingLimits
	}
	return nil
}

func (x *AutoscalingConfig_AsymmetricAutoscalingOption_AutoscalingConfigOverrides) GetAutoscalingTargetHighPriorityCpuUtilizationPercent() int32 {
	if x != nil {
		return x.AutoscalingTargetHighPriorityCpuUtilizationPercent
	}
	return 0
}

var File_google_spanner_admin_instance_v1_spanner_instance_admin_proto protoreflect.FileDescriptor

var file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDesc = []byte{
	0x0a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2f,
	0x76, 0x31, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76,
	0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d,
	0x2f, 0x76, 0x31, 0x2f, 0x69, 0x61, 0x6d, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d,
	0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x81, 0x02, 0x0a, 0x0b, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x4d, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x52, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12,
	0x36, 0x0a, 0x17, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x6c, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x15, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x4f, 0x0a, 0x0b, 0x52, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a,
	0x52, 0x45, 0x41, 0x44, 0x5f, 0x57, 0x52, 0x49, 0x54, 0x45, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09,
	0x52, 0x45, 0x41, 0x44, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x57,
	0x49, 0x54, 0x4e, 0x45, 0x53, 0x53, 0x10, 0x03, 0x22, 0x8a, 0x0c, 0x0a, 0x0e, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x5b, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x49, 0x0a, 0x08, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x49, 0x6e, 0x66, 0x6f,
	0x52, 0x08, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x12, 0x5f, 0x0a, 0x11, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x18,
	0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x6f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x61, 0x6c, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x12, 0x4b, 0x0a, 0x0b, 0x62,
	0x61, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2a, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0a, 0x62, 0x61,
	0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x54, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x12,
	0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74,
	0x61, 0x67, 0x12, 0x25, 0x0a, 0x0e, 0x6c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x6f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x6c, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x25, 0x0a, 0x0b, 0x72, 0x65, 0x63,
	0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67,
	0x12, 0x51, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x8c, 0x01, 0x0a, 0x1a, 0x66, 0x72, 0x65, 0x65, 0x5f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x46, 0x72, 0x65, 0x65, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x18, 0x66, 0x72, 0x65, 0x65, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x12, 0x61, 0x0a, 0x0b, 0x71, 0x75, 0x6f, 0x72, 0x75, 0x6d, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x51, 0x75, 0x6f, 0x72, 0x75, 0x6d,
	0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x71, 0x75, 0x6f, 0x72, 0x75,
	0x6d, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4d, 0x0a, 0x21, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x75, 0x6e, 0x69, 0x74, 0x18, 0x13, 0x20, 0x01, 0x28, 0x03,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x4c, 0x69,
	0x6d, 0x69, 0x74, 0x50, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67,
	0x55, 0x6e, 0x69, 0x74, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x42, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a,
	0x0e, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x44, 0x10,
	0x01, 0x12, 0x10, 0x0a, 0x0c, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45,
	0x44, 0x10, 0x02, 0x22, 0x37, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10,
	0x01, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x02, 0x22, 0x88, 0x01, 0x0a,
	0x18, 0x46, 0x72, 0x65, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x41, 0x76, 0x61,
	0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x2a, 0x0a, 0x26, 0x46, 0x52, 0x45,
	0x45, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x41, 0x56, 0x41, 0x49, 0x4c,
	0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42,
	0x4c, 0x45, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52,
	0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45,
	0x44, 0x10, 0x03, 0x12, 0x12, 0x0a, 0x0e, 0x51, 0x55, 0x4f, 0x54, 0x41, 0x5f, 0x45, 0x58, 0x43,
	0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x04, 0x22, 0x58, 0x0a, 0x0a, 0x51, 0x75, 0x6f, 0x72, 0x75,
	0x6d, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x51, 0x55, 0x4f, 0x52, 0x55, 0x4d, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x52, 0x45, 0x47, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x0f,
	0x0a, 0x0b, 0x44, 0x55, 0x41, 0x4c, 0x5f, 0x52, 0x45, 0x47, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12,
	0x10, 0x0a, 0x0c, 0x4d, 0x55, 0x4c, 0x54, 0x49, 0x5f, 0x52, 0x45, 0x47, 0x49, 0x4f, 0x4e, 0x10,
	0x03, 0x3a, 0x81, 0x01, 0xea, 0x41, 0x7e, 0x0a, 0x25, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x34,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x7d, 0x2a, 0x0f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x32, 0x0e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xe0, 0x01, 0x0a, 0x16, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79,
	0x12, 0x64, 0x0a, 0x11, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x73, 0x65, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x53, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x09, 0x6e, 0x6f,
	0x64, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2b, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x75, 0x6e, 0x69, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x05, 0x48, 0x00, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x55,
	0x6e, 0x69, 0x74, 0x73, 0x42, 0x12, 0x0a, 0x10, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f,
	0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x22, 0xdd, 0x0a, 0x0a, 0x11, 0x41, 0x75, 0x74,
	0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x79,
	0x0a, 0x12, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x69,
	0x6d, 0x69, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75,
	0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x6d, 0x69, 0x74,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c,
	0x69, 0x6e, 0x67, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x7c, 0x0a, 0x13, 0x61, 0x75, 0x74,
	0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63,
	0x61, 0x6c, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x75, 0x74, 0x6f,
	0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x12, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x12, 0x9a, 0x01, 0x0a, 0x1e, 0x61, 0x73, 0x79, 0x6d,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69,
	0x6e, 0x67, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x73, 0x79, 0x6d, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1c, 0x61, 0x73, 0x79, 0x6d, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x1a, 0xd3, 0x01, 0x0a, 0x11, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61,
	0x6c, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x1d, 0x0a, 0x09, 0x6d, 0x69,
	0x6e, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52,
	0x08, 0x6d, 0x69, 0x6e, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x32, 0x0a, 0x14, 0x6d, 0x69, 0x6e,
	0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x75, 0x6e, 0x69, 0x74,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x12, 0x6d, 0x69, 0x6e, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x55, 0x6e, 0x69, 0x74, 0x73, 0x12, 0x1d, 0x0a,
	0x09, 0x6d, 0x61, 0x78, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05,
	0x48, 0x01, 0x52, 0x08, 0x6d, 0x61, 0x78, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x32, 0x0a, 0x14,
	0x6d, 0x61, 0x78, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x75,
	0x6e, 0x69, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x48, 0x01, 0x52, 0x12, 0x6d, 0x61,
	0x78, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x55, 0x6e, 0x69, 0x74, 0x73,
	0x42, 0x0b, 0x0a, 0x09, 0x6d, 0x69, 0x6e, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x42, 0x0b, 0x0a,
	0x09, 0x6d, 0x61, 0x78, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x1a, 0xb0, 0x01, 0x0a, 0x12, 0x41,
	0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x73, 0x12, 0x55, 0x0a, 0x25, 0x68, 0x69, 0x67, 0x68, 0x5f, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69,
	0x74, 0x79, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x21, 0x68, 0x69, 0x67, 0x68, 0x50, 0x72, 0x69, 0x6f, 0x72,
	0x69, 0x74, 0x79, 0x43, 0x70, 0x75, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x12, 0x43, 0x0a, 0x1b, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x5f, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x19, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x55, 0x74, 0x69, 0x6c, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x1a, 0xa8, 0x04,
	0x0a, 0x1b, 0x41, 0x73, 0x79, 0x6d, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x41, 0x75, 0x74, 0x6f,
	0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x64, 0x0a,
	0x11, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x10, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x8d, 0x01, 0x0a, 0x09, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x6a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x73,
	0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x73, 0x79,
	0x6d, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69,
	0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61,
	0x6c, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69,
	0x64, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69,
	0x64, 0x65, 0x73, 0x1a, 0x92, 0x02, 0x0a, 0x1a, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64,
	0x65, 0x73, 0x12, 0x79, 0x0a, 0x12, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e,
	0x67, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x4c,
	0x69, 0x6d, 0x69, 0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x61, 0x75, 0x74, 0x6f,
	0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x79, 0x0a,
	0x38, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x5f, 0x68, 0x69, 0x67, 0x68, 0x5f, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74,
	0x79, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x32, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e,
	0x67, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x48, 0x69, 0x67, 0x68, 0x50, 0x72, 0x69, 0x6f, 0x72,
	0x69, 0x74, 0x79, 0x43, 0x70, 0x75, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x22, 0x96, 0x0d, 0x0a, 0x08, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x45,
	0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x29, 0x0a, 0x10,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x75, 0x6e, 0x69, 0x74, 0x73,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69,
	0x6e, 0x67, 0x55, 0x6e, 0x69, 0x74, 0x73, 0x12, 0x77, 0x0a, 0x18, 0x72, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x63,
	0x69, 0x74, 0x79, 0x18, 0x13, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x43, 0x61, 0x70, 0x61, 0x63,
	0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79,
	0x12, 0x67, 0x0a, 0x12, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4b, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x4e, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x5c, 0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x5f, 0x75, 0x72, 0x69, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x55, 0x72, 0x69, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x6c, 0x0a,
	0x16, 0x66, 0x72, 0x65, 0x65, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x46, 0x72, 0x65, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x14, 0x66, 0x72, 0x65, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x51, 0x0a, 0x07, 0x65,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x45, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x65, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x8a,
	0x01, 0x0a, 0x1c, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x17, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x2e, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x53,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x19, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x53,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x37, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x02, 0x22,
	0x51, 0x0a, 0x0c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x1d, 0x0a, 0x19, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f,
	0x0a, 0x0b, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x45, 0x44, 0x10, 0x01, 0x12,
	0x11, 0x0a, 0x0d, 0x46, 0x52, 0x45, 0x45, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45,
	0x10, 0x02, 0x22, 0x55, 0x0a, 0x07, 0x45, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a,
	0x13, 0x45, 0x44, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41,
	0x52, 0x44, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x45, 0x4e, 0x54, 0x45, 0x52, 0x50, 0x52, 0x49,
	0x53, 0x45, 0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f, 0x45, 0x4e, 0x54, 0x45, 0x52, 0x50, 0x52, 0x49,
	0x53, 0x45, 0x5f, 0x50, 0x4c, 0x55, 0x53, 0x10, 0x03, 0x22, 0x62, 0x0a, 0x19, 0x44, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75,
	0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2c, 0x0a, 0x28, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c,
	0x54, 0x5f, 0x42, 0x41, 0x43, 0x4b, 0x55, 0x50, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c,
	0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x01, 0x12, 0x0d,
	0x0a, 0x09, 0x41, 0x55, 0x54, 0x4f, 0x4d, 0x41, 0x54, 0x49, 0x43, 0x10, 0x02, 0x3a, 0x62, 0xea,
	0x41, 0x5f, 0x0a, 0x1f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x12, 0x27, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2a, 0x09, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x32, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x22, 0xa5, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa2, 0x01, 0x0a, 0x1b, 0x4c, 0x69,
	0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5b, 0x0a, 0x10, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5d,
	0x0a, 0x18, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27,
	0x0a, 0x25, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa2, 0x02,
	0x0a, 0x1b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x31, 0x0a, 0x12, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x12, 0x5e, 0x0a,
	0x0f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x23, 0x0a,
	0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e,
	0x6c, 0x79, 0x22, 0xe4, 0x01, 0x0a, 0x1b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x5e, 0x0a, 0x0f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x73, 0x6b, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x99, 0x01, 0x0a, 0x1b, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a,
	0x25, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x65, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67,
	0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c,
	0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xc6, 0x01, 0x0a, 0x23, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8d,
	0x01, 0x0a, 0x24, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3d, 0x0a, 0x0a, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8c,
	0x01, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xd7, 0x01,
	0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a,
	0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x4b, 0x0a, 0x08, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0x80, 0x02, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x47, 0x0a, 0x11, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x64, 0x65,
	0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x10, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x44, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x22, 0xab, 0x01, 0x0a, 0x15, 0x4c,
	0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x52, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63,
	0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72,
	0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0xa4, 0x01, 0x0a, 0x15, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4b, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x3e, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22,
	0x54, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x84, 0x03, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x46, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07,
	0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x73, 0x0a, 0x1b, 0x65, 0x78, 0x70, 0x65, 0x63,
	0x74, 0x65, 0x64, 0x5f, 0x66, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x65, 0x72, 0x69, 0x6f,
	0x64, 0x52, 0x19, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x46, 0x75, 0x6c, 0x66, 0x69,
	0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x22, 0x84, 0x03, 0x0a,
	0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x46, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x61,
	0x6e, 0x63, 0x65, 0x6c, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x61, 0x6e,
	0x63, 0x65, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x73,
	0x0a, 0x1b, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x66, 0x75, 0x6c, 0x66, 0x69,
	0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65,
	0x6e, 0x74, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x52, 0x19, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74,
	0x65, 0x64, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x65, 0x72,
	0x69, 0x6f, 0x64, 0x22, 0xf7, 0x02, 0x0a, 0x14, 0x46, 0x72, 0x65, 0x65, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b,
	0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x42,
	0x0a, 0x0c, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x6e, 0x0a, 0x0f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x45, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46,
	0x72, 0x65, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x45, 0x78, 0x70, 0x69, 0x72, 0x65, 0x42, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x52, 0x0e, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x42, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x22, 0x69, 0x0a, 0x0e, 0x45, 0x78, 0x70, 0x69, 0x72, 0x65, 0x42, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x12, 0x1f, 0x0a, 0x1b, 0x45, 0x58, 0x50, 0x49, 0x52, 0x45, 0x5f, 0x42,
	0x45, 0x48, 0x41, 0x56, 0x49, 0x4f, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x46, 0x52, 0x45, 0x45, 0x5f, 0x54, 0x4f,
	0x5f, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x45, 0x44, 0x10, 0x01, 0x12, 0x1d,
	0x0a, 0x19, 0x52, 0x45, 0x4d, 0x4f, 0x56, 0x45, 0x5f, 0x41, 0x46, 0x54, 0x45, 0x52, 0x5f, 0x47,
	0x52, 0x41, 0x43, 0x45, 0x5f, 0x50, 0x45, 0x52, 0x49, 0x4f, 0x44, 0x10, 0x02, 0x22, 0x87, 0x02,
	0x0a, 0x1c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x59,
	0x0a, 0x0f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0e, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4f, 0x0a, 0x08, 0x70, 0x72, 0x6f,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x52, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x61,
	0x6e, 0x63, 0x65, 0x6c, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x61, 0x6e,
	0x63, 0x65, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x87, 0x02, 0x0a, 0x1c, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x59, 0x0a, 0x0f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x0e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x4f, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x67,
	0x72, 0x65, 0x73, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x54, 0x69, 0x6d,
	0x65, 0x22, 0xa8, 0x07, 0x0a, 0x11, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x45, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x1f, 0x0a, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x2b, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x75,
	0x6e, 0x69, 0x74, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x0f, 0x70, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x55, 0x6e, 0x69, 0x74, 0x73, 0x12, 0x67, 0x0a,
	0x12, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74,
	0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x11, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x54, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x38, 0x0a, 0x15, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x5f,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x69, 0x6e,
	0x67, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x12, 0x36, 0x0a, 0x13, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x09, 0x42, 0x05, 0xe0, 0x41, 0x03, 0x18, 0x01, 0x52, 0x12,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0x37, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x02, 0x3a,
	0xa6, 0x01, 0xea, 0x41, 0xa2, 0x01, 0x0a, 0x28, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x4f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2a, 0x12, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x32, 0x11, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x12, 0x0a, 0x10, 0x63, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x65, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x22, 0xb4, 0x02, 0x0a,
	0x1f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x62, 0x0a, 0x12, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x11, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x3b, 0x0a, 0x0b, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0a, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08,
	0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x22, 0x83, 0x02, 0x0a, 0x1e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x37, 0x0a, 0x15, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64,
	0x12, 0x67, 0x0a, 0x12, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7a, 0x0a, 0x1e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2a, 0x0a, 0x28, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0x63, 0x0a, 0x1b, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc9, 0x01, 0x0a, 0x1e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x67, 0x0a,
	0x12, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x11, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xb4, 0x02, 0x0a, 0x1f, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x62, 0x0a, 0x12, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39,
	0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x61, 0x6e,
	0x63, 0x65, 0x6c, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x61, 0x6e, 0x63,
	0x65, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xfd, 0x01,
	0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x5f, 0x0a, 0x1b,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x19, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x22, 0xd0, 0x01,
	0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x64, 0x0a, 0x13, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x12, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20,
	0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x22, 0xad, 0x02, 0x0a, 0x26, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x5f, 0x0a, 0x1b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x19, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65,
	0x22, 0xd8, 0x01, 0x0a, 0x27, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3d, 0x0a, 0x0a,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0a, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x46, 0x0a, 0x1f, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x1d, 0x75, 0x6e,
	0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xa6, 0x01, 0x0a, 0x13,
	0x4d, 0x6f, 0x76, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x52, 0x0a, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a,
	0x25, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x22, 0x16, 0x0a, 0x14, 0x4d, 0x6f, 0x76, 0x65, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xc9, 0x01, 0x0a,
	0x14, 0x4d, 0x6f, 0x76, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x23, 0x0a, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4f, 0x0a, 0x08, 0x70, 0x72,
	0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x63,
	0x61, 0x6e, 0x63, 0x65, 0x6c, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x61,
	0x6e, 0x63, 0x65, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x32, 0xda, 0x27, 0x0a, 0x0d, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x12, 0xcc, 0x01, 0x0a, 0x13, 0x4c,
	0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x38, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x29,
	0x12, 0x27, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0xb9, 0x01, 0x0a, 0x11, 0x47, 0x65,
	0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x36, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x29, 0x12, 0x27, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc8, 0x02, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xd1, 0x01, 0xca,
	0x41, 0x70, 0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x29, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x2c, 0x3a, 0x01, 0x2a, 0x22, 0x27, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x12, 0xca, 0x02, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xd3, 0x01, 0xca, 0x41, 0x70, 0x0a, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3d,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1b,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x3c, 0x3a, 0x01, 0x2a, 0x32, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa5, 0x01,
	0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x36, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x29, 0x2a, 0x27, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf0, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x46, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x41, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xb4, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73,
	0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x32, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x23, 0x12, 0x21, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12,
	0xe4, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x47, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x12, 0x36,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xa1, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0x30, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x23, 0x12, 0x21, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x9c, 0x02, 0x0a, 0x0e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb1, 0x01, 0xca, 0x41, 0x64, 0x0a, 0x29, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda,
	0x41, 0x1b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x5f, 0x69, 0x64, 0x2c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x26, 0x3a, 0x01, 0x2a, 0x22, 0x21, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x9d, 0x02, 0x0a, 0x0e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb2, 0x01, 0xca, 0x41, 0x64, 0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x13, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2c, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x3a, 0x01, 0x2a, 0x32, 0x2a, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x93, 0x01, 0x0a, 0x0e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x30, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x23, 0x2a, 0x21, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0x9a, 0x01, 0x0a, 0x0c, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x4f, 0xda, 0x41, 0x0f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x37, 0x3a, 0x01, 0x2a, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x73, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x93, 0x01, 0x0a,
	0x0c, 0x47, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x22, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x48, 0xda, 0x41, 0x08, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x3a, 0x01, 0x2a, 0x22, 0x32,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0xc5, 0x01, 0x0a, 0x12, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65,
	0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61,
	0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5a,
	0xda, 0x41, 0x14, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x70, 0x65, 0x72, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x3a, 0x01, 0x2a,
	0x22, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x74, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50,
	0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xd1, 0x01, 0x0a, 0x14, 0x47,
	0x65, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x45, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe9,
	0x02, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xec, 0x01, 0xca, 0x41,
	0x76, 0x0a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x2f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x2c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x3a,
	0x01, 0x2a, 0x22, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xba, 0x01, 0x0a, 0x17, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x22, 0x45, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x2a,
	0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xea, 0x02, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0xed, 0x01, 0xca, 0x41, 0x76, 0x0a, 0x32, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0xda, 0x41, 0x1d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x3a, 0x01, 0x2a, 0x32, 0x49, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x88, 0x02, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x50, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x12, 0x3f,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x89, 0x02, 0x0a, 0x0c, 0x4d, 0x6f, 0x76, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x76, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa2, 0x01, 0xca, 0x41, 0x6e, 0x0a, 0x35, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x6f, 0x76, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x76, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2b,
	0x3a, 0x01, 0x2a, 0x22, 0x26, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6d, 0x6f, 0x76, 0x65, 0x1a, 0x78, 0xca, 0x41, 0x16,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x5c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
	0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x42, 0x8b, 0x02, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x42, 0x19,
	0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x41,
	0x64, 0x6d, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x46, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f,
	0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x70, 0x62, 0x3b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x70, 0x62, 0xaa, 0x02, 0x26, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x41, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x26, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x53, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x5c, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x5c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x2b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x3a, 0x3a,
	0x41, 0x64, 0x6d, 0x69, 0x6e, 0x3a, 0x3a, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x3a,
	0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescOnce sync.Once
	file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescData = file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDesc
)

func file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP() []byte {
	file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescOnce.Do(func() {
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescData)
	})
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescData
}

var file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes = make([]protoimpl.EnumInfo, 11)
var file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes = make([]protoimpl.MessageInfo, 44)
var file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_goTypes = []any{
	(ReplicaInfo_ReplicaType)(0),                          // 0: google.spanner.admin.instance.v1.ReplicaInfo.ReplicaType
	(InstanceConfig_Type)(0),                              // 1: google.spanner.admin.instance.v1.InstanceConfig.Type
	(InstanceConfig_State)(0),                             // 2: google.spanner.admin.instance.v1.InstanceConfig.State
	(InstanceConfig_FreeInstanceAvailability)(0),          // 3: google.spanner.admin.instance.v1.InstanceConfig.FreeInstanceAvailability
	(InstanceConfig_QuorumType)(0),                        // 4: google.spanner.admin.instance.v1.InstanceConfig.QuorumType
	(Instance_State)(0),                                   // 5: google.spanner.admin.instance.v1.Instance.State
	(Instance_InstanceType)(0),                            // 6: google.spanner.admin.instance.v1.Instance.InstanceType
	(Instance_Edition)(0),                                 // 7: google.spanner.admin.instance.v1.Instance.Edition
	(Instance_DefaultBackupScheduleType)(0),               // 8: google.spanner.admin.instance.v1.Instance.DefaultBackupScheduleType
	(FreeInstanceMetadata_ExpireBehavior)(0),              // 9: google.spanner.admin.instance.v1.FreeInstanceMetadata.ExpireBehavior
	(InstancePartition_State)(0),                          // 10: google.spanner.admin.instance.v1.InstancePartition.State
	(*ReplicaInfo)(nil),                                   // 11: google.spanner.admin.instance.v1.ReplicaInfo
	(*InstanceConfig)(nil),                                // 12: google.spanner.admin.instance.v1.InstanceConfig
	(*ReplicaComputeCapacity)(nil),                        // 13: google.spanner.admin.instance.v1.ReplicaComputeCapacity
	(*AutoscalingConfig)(nil),                             // 14: google.spanner.admin.instance.v1.AutoscalingConfig
	(*Instance)(nil),                                      // 15: google.spanner.admin.instance.v1.Instance
	(*ListInstanceConfigsRequest)(nil),                    // 16: google.spanner.admin.instance.v1.ListInstanceConfigsRequest
	(*ListInstanceConfigsResponse)(nil),                   // 17: google.spanner.admin.instance.v1.ListInstanceConfigsResponse
	(*GetInstanceConfigRequest)(nil),                      // 18: google.spanner.admin.instance.v1.GetInstanceConfigRequest
	(*CreateInstanceConfigRequest)(nil),                   // 19: google.spanner.admin.instance.v1.CreateInstanceConfigRequest
	(*UpdateInstanceConfigRequest)(nil),                   // 20: google.spanner.admin.instance.v1.UpdateInstanceConfigRequest
	(*DeleteInstanceConfigRequest)(nil),                   // 21: google.spanner.admin.instance.v1.DeleteInstanceConfigRequest
	(*ListInstanceConfigOperationsRequest)(nil),           // 22: google.spanner.admin.instance.v1.ListInstanceConfigOperationsRequest
	(*ListInstanceConfigOperationsResponse)(nil),          // 23: google.spanner.admin.instance.v1.ListInstanceConfigOperationsResponse
	(*GetInstanceRequest)(nil),                            // 24: google.spanner.admin.instance.v1.GetInstanceRequest
	(*CreateInstanceRequest)(nil),                         // 25: google.spanner.admin.instance.v1.CreateInstanceRequest
	(*ListInstancesRequest)(nil),                          // 26: google.spanner.admin.instance.v1.ListInstancesRequest
	(*ListInstancesResponse)(nil),                         // 27: google.spanner.admin.instance.v1.ListInstancesResponse
	(*UpdateInstanceRequest)(nil),                         // 28: google.spanner.admin.instance.v1.UpdateInstanceRequest
	(*DeleteInstanceRequest)(nil),                         // 29: google.spanner.admin.instance.v1.DeleteInstanceRequest
	(*CreateInstanceMetadata)(nil),                        // 30: google.spanner.admin.instance.v1.CreateInstanceMetadata
	(*UpdateInstanceMetadata)(nil),                        // 31: google.spanner.admin.instance.v1.UpdateInstanceMetadata
	(*FreeInstanceMetadata)(nil),                          // 32: google.spanner.admin.instance.v1.FreeInstanceMetadata
	(*CreateInstanceConfigMetadata)(nil),                  // 33: google.spanner.admin.instance.v1.CreateInstanceConfigMetadata
	(*UpdateInstanceConfigMetadata)(nil),                  // 34: google.spanner.admin.instance.v1.UpdateInstanceConfigMetadata
	(*InstancePartition)(nil),                             // 35: google.spanner.admin.instance.v1.InstancePartition
	(*CreateInstancePartitionMetadata)(nil),               // 36: google.spanner.admin.instance.v1.CreateInstancePartitionMetadata
	(*CreateInstancePartitionRequest)(nil),                // 37: google.spanner.admin.instance.v1.CreateInstancePartitionRequest
	(*DeleteInstancePartitionRequest)(nil),                // 38: google.spanner.admin.instance.v1.DeleteInstancePartitionRequest
	(*GetInstancePartitionRequest)(nil),                   // 39: google.spanner.admin.instance.v1.GetInstancePartitionRequest
	(*UpdateInstancePartitionRequest)(nil),                // 40: google.spanner.admin.instance.v1.UpdateInstancePartitionRequest
	(*UpdateInstancePartitionMetadata)(nil),               // 41: google.spanner.admin.instance.v1.UpdateInstancePartitionMetadata
	(*ListInstancePartitionsRequest)(nil),                 // 42: google.spanner.admin.instance.v1.ListInstancePartitionsRequest
	(*ListInstancePartitionsResponse)(nil),                // 43: google.spanner.admin.instance.v1.ListInstancePartitionsResponse
	(*ListInstancePartitionOperationsRequest)(nil),        // 44: google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest
	(*ListInstancePartitionOperationsResponse)(nil),       // 45: google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse
	(*MoveInstanceRequest)(nil),                           // 46: google.spanner.admin.instance.v1.MoveInstanceRequest
	(*MoveInstanceResponse)(nil),                          // 47: google.spanner.admin.instance.v1.MoveInstanceResponse
	(*MoveInstanceMetadata)(nil),                          // 48: google.spanner.admin.instance.v1.MoveInstanceMetadata
	nil,                                                   // 49: google.spanner.admin.instance.v1.InstanceConfig.LabelsEntry
	(*AutoscalingConfig_AutoscalingLimits)(nil),           // 50: google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
	(*AutoscalingConfig_AutoscalingTargets)(nil),          // 51: google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets
	(*AutoscalingConfig_AsymmetricAutoscalingOption)(nil), // 52: google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
	(*AutoscalingConfig_AsymmetricAutoscalingOption_AutoscalingConfigOverrides)(nil), // 53: google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption.AutoscalingConfigOverrides
	nil,                                      // 54: google.spanner.admin.instance.v1.Instance.LabelsEntry
	(*ReplicaSelection)(nil),                 // 55: google.spanner.admin.instance.v1.ReplicaSelection
	(*timestamppb.Timestamp)(nil),            // 56: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),            // 57: google.protobuf.FieldMask
	(*longrunningpb.Operation)(nil),          // 58: google.longrunning.Operation
	(FulfillmentPeriod)(0),                   // 59: google.spanner.admin.instance.v1.FulfillmentPeriod
	(*OperationProgress)(nil),                // 60: google.spanner.admin.instance.v1.OperationProgress
	(*iampb.SetIamPolicyRequest)(nil),        // 61: google.iam.v1.SetIamPolicyRequest
	(*iampb.GetIamPolicyRequest)(nil),        // 62: google.iam.v1.GetIamPolicyRequest
	(*iampb.TestIamPermissionsRequest)(nil),  // 63: google.iam.v1.TestIamPermissionsRequest
	(*emptypb.Empty)(nil),                    // 64: google.protobuf.Empty
	(*iampb.Policy)(nil),                     // 65: google.iam.v1.Policy
	(*iampb.TestIamPermissionsResponse)(nil), // 66: google.iam.v1.TestIamPermissionsResponse
}
var file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_depIdxs = []int32{
	0,  // 0: google.spanner.admin.instance.v1.ReplicaInfo.type:type_name -> google.spanner.admin.instance.v1.ReplicaInfo.ReplicaType
	1,  // 1: google.spanner.admin.instance.v1.InstanceConfig.config_type:type_name -> google.spanner.admin.instance.v1.InstanceConfig.Type
	11, // 2: google.spanner.admin.instance.v1.InstanceConfig.replicas:type_name -> google.spanner.admin.instance.v1.ReplicaInfo
	11, // 3: google.spanner.admin.instance.v1.InstanceConfig.optional_replicas:type_name -> google.spanner.admin.instance.v1.ReplicaInfo
	49, // 4: google.spanner.admin.instance.v1.InstanceConfig.labels:type_name -> google.spanner.admin.instance.v1.InstanceConfig.LabelsEntry
	2,  // 5: google.spanner.admin.instance.v1.InstanceConfig.state:type_name -> google.spanner.admin.instance.v1.InstanceConfig.State
	3,  // 6: google.spanner.admin.instance.v1.InstanceConfig.free_instance_availability:type_name -> google.spanner.admin.instance.v1.InstanceConfig.FreeInstanceAvailability
	4,  // 7: google.spanner.admin.instance.v1.InstanceConfig.quorum_type:type_name -> google.spanner.admin.instance.v1.InstanceConfig.QuorumType
	55, // 8: google.spanner.admin.instance.v1.ReplicaComputeCapacity.replica_selection:type_name -> google.spanner.admin.instance.v1.ReplicaSelection
	50, // 9: google.spanner.admin.instance.v1.AutoscalingConfig.autoscaling_limits:type_name -> google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
	51, // 10: google.spanner.admin.instance.v1.AutoscalingConfig.autoscaling_targets:type_name -> google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets
	52, // 11: google.spanner.admin.instance.v1.AutoscalingConfig.asymmetric_autoscaling_options:type_name -> google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
	13, // 12: google.spanner.admin.instance.v1.Instance.replica_compute_capacity:type_name -> google.spanner.admin.instance.v1.ReplicaComputeCapacity
	14, // 13: google.spanner.admin.instance.v1.Instance.autoscaling_config:type_name -> google.spanner.admin.instance.v1.AutoscalingConfig
	5,  // 14: google.spanner.admin.instance.v1.Instance.state:type_name -> google.spanner.admin.instance.v1.Instance.State
	54, // 15: google.spanner.admin.instance.v1.Instance.labels:type_name -> google.spanner.admin.instance.v1.Instance.LabelsEntry
	6,  // 16: google.spanner.admin.instance.v1.Instance.instance_type:type_name -> google.spanner.admin.instance.v1.Instance.InstanceType
	56, // 17: google.spanner.admin.instance.v1.Instance.create_time:type_name -> google.protobuf.Timestamp
	56, // 18: google.spanner.admin.instance.v1.Instance.update_time:type_name -> google.protobuf.Timestamp
	32, // 19: google.spanner.admin.instance.v1.Instance.free_instance_metadata:type_name -> google.spanner.admin.instance.v1.FreeInstanceMetadata
	7,  // 20: google.spanner.admin.instance.v1.Instance.edition:type_name -> google.spanner.admin.instance.v1.Instance.Edition
	8,  // 21: google.spanner.admin.instance.v1.Instance.default_backup_schedule_type:type_name -> google.spanner.admin.instance.v1.Instance.DefaultBackupScheduleType
	12, // 22: google.spanner.admin.instance.v1.ListInstanceConfigsResponse.instance_configs:type_name -> google.spanner.admin.instance.v1.InstanceConfig
	12, // 23: google.spanner.admin.instance.v1.CreateInstanceConfigRequest.instance_config:type_name -> google.spanner.admin.instance.v1.InstanceConfig
	12, // 24: google.spanner.admin.instance.v1.UpdateInstanceConfigRequest.instance_config:type_name -> google.spanner.admin.instance.v1.InstanceConfig
	57, // 25: google.spanner.admin.instance.v1.UpdateInstanceConfigRequest.update_mask:type_name -> google.protobuf.FieldMask
	58, // 26: google.spanner.admin.instance.v1.ListInstanceConfigOperationsResponse.operations:type_name -> google.longrunning.Operation
	57, // 27: google.spanner.admin.instance.v1.GetInstanceRequest.field_mask:type_name -> google.protobuf.FieldMask
	15, // 28: google.spanner.admin.instance.v1.CreateInstanceRequest.instance:type_name -> google.spanner.admin.instance.v1.Instance
	56, // 29: google.spanner.admin.instance.v1.ListInstancesRequest.instance_deadline:type_name -> google.protobuf.Timestamp
	15, // 30: google.spanner.admin.instance.v1.ListInstancesResponse.instances:type_name -> google.spanner.admin.instance.v1.Instance
	15, // 31: google.spanner.admin.instance.v1.UpdateInstanceRequest.instance:type_name -> google.spanner.admin.instance.v1.Instance
	57, // 32: google.spanner.admin.instance.v1.UpdateInstanceRequest.field_mask:type_name -> google.protobuf.FieldMask
	15, // 33: google.spanner.admin.instance.v1.CreateInstanceMetadata.instance:type_name -> google.spanner.admin.instance.v1.Instance
	56, // 34: google.spanner.admin.instance.v1.CreateInstanceMetadata.start_time:type_name -> google.protobuf.Timestamp
	56, // 35: google.spanner.admin.instance.v1.CreateInstanceMetadata.cancel_time:type_name -> google.protobuf.Timestamp
	56, // 36: google.spanner.admin.instance.v1.CreateInstanceMetadata.end_time:type_name -> google.protobuf.Timestamp
	59, // 37: google.spanner.admin.instance.v1.CreateInstanceMetadata.expected_fulfillment_period:type_name -> google.spanner.admin.instance.v1.FulfillmentPeriod
	15, // 38: google.spanner.admin.instance.v1.UpdateInstanceMetadata.instance:type_name -> google.spanner.admin.instance.v1.Instance
	56, // 39: google.spanner.admin.instance.v1.UpdateInstanceMetadata.start_time:type_name -> google.protobuf.Timestamp
	56, // 40: google.spanner.admin.instance.v1.UpdateInstanceMetadata.cancel_time:type_name -> google.protobuf.Timestamp
	56, // 41: google.spanner.admin.instance.v1.UpdateInstanceMetadata.end_time:type_name -> google.protobuf.Timestamp
	59, // 42: google.spanner.admin.instance.v1.UpdateInstanceMetadata.expected_fulfillment_period:type_name -> google.spanner.admin.instance.v1.FulfillmentPeriod
	56, // 43: google.spanner.admin.instance.v1.FreeInstanceMetadata.expire_time:type_name -> google.protobuf.Timestamp
	56, // 44: google.spanner.admin.instance.v1.FreeInstanceMetadata.upgrade_time:type_name -> google.protobuf.Timestamp
	9,  // 45: google.spanner.admin.instance.v1.FreeInstanceMetadata.expire_behavior:type_name -> google.spanner.admin.instance.v1.FreeInstanceMetadata.ExpireBehavior
	12, // 46: google.spanner.admin.instance.v1.CreateInstanceConfigMetadata.instance_config:type_name -> google.spanner.admin.instance.v1.InstanceConfig
	60, // 47: google.spanner.admin.instance.v1.CreateInstanceConfigMetadata.progress:type_name -> google.spanner.admin.instance.v1.OperationProgress
	56, // 48: google.spanner.admin.instance.v1.CreateInstanceConfigMetadata.cancel_time:type_name -> google.protobuf.Timestamp
	12, // 49: google.spanner.admin.instance.v1.UpdateInstanceConfigMetadata.instance_config:type_name -> google.spanner.admin.instance.v1.InstanceConfig
	60, // 50: google.spanner.admin.instance.v1.UpdateInstanceConfigMetadata.progress:type_name -> google.spanner.admin.instance.v1.OperationProgress
	56, // 51: google.spanner.admin.instance.v1.UpdateInstanceConfigMetadata.cancel_time:type_name -> google.protobuf.Timestamp
	14, // 52: google.spanner.admin.instance.v1.InstancePartition.autoscaling_config:type_name -> google.spanner.admin.instance.v1.AutoscalingConfig
	10, // 53: google.spanner.admin.instance.v1.InstancePartition.state:type_name -> google.spanner.admin.instance.v1.InstancePartition.State
	56, // 54: google.spanner.admin.instance.v1.InstancePartition.create_time:type_name -> google.protobuf.Timestamp
	56, // 55: google.spanner.admin.instance.v1.InstancePartition.update_time:type_name -> google.protobuf.Timestamp
	35, // 56: google.spanner.admin.instance.v1.CreateInstancePartitionMetadata.instance_partition:type_name -> google.spanner.admin.instance.v1.InstancePartition
	56, // 57: google.spanner.admin.instance.v1.CreateInstancePartitionMetadata.start_time:type_name -> google.protobuf.Timestamp
	56, // 58: google.spanner.admin.instance.v1.CreateInstancePartitionMetadata.cancel_time:type_name -> google.protobuf.Timestamp
	56, // 59: google.spanner.admin.instance.v1.CreateInstancePartitionMetadata.end_time:type_name -> google.protobuf.Timestamp
	35, // 60: google.spanner.admin.instance.v1.CreateInstancePartitionRequest.instance_partition:type_name -> google.spanner.admin.instance.v1.InstancePartition
	35, // 61: google.spanner.admin.instance.v1.UpdateInstancePartitionRequest.instance_partition:type_name -> google.spanner.admin.instance.v1.InstancePartition
	57, // 62: google.spanner.admin.instance.v1.UpdateInstancePartitionRequest.field_mask:type_name -> google.protobuf.FieldMask
	35, // 63: google.spanner.admin.instance.v1.UpdateInstancePartitionMetadata.instance_partition:type_name -> google.spanner.admin.instance.v1.InstancePartition
	56, // 64: google.spanner.admin.instance.v1.UpdateInstancePartitionMetadata.start_time:type_name -> google.protobuf.Timestamp
	56, // 65: google.spanner.admin.instance.v1.UpdateInstancePartitionMetadata.cancel_time:type_name -> google.protobuf.Timestamp
	56, // 66: google.spanner.admin.instance.v1.UpdateInstancePartitionMetadata.end_time:type_name -> google.protobuf.Timestamp
	56, // 67: google.spanner.admin.instance.v1.ListInstancePartitionsRequest.instance_partition_deadline:type_name -> google.protobuf.Timestamp
	35, // 68: google.spanner.admin.instance.v1.ListInstancePartitionsResponse.instance_partitions:type_name -> google.spanner.admin.instance.v1.InstancePartition
	56, // 69: google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest.instance_partition_deadline:type_name -> google.protobuf.Timestamp
	58, // 70: google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse.operations:type_name -> google.longrunning.Operation
	60, // 71: google.spanner.admin.instance.v1.MoveInstanceMetadata.progress:type_name -> google.spanner.admin.instance.v1.OperationProgress
	56, // 72: google.spanner.admin.instance.v1.MoveInstanceMetadata.cancel_time:type_name -> google.protobuf.Timestamp
	55, // 73: google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption.replica_selection:type_name -> google.spanner.admin.instance.v1.ReplicaSelection
	53, // 74: google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption.overrides:type_name -> google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption.AutoscalingConfigOverrides
	50, // 75: google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption.AutoscalingConfigOverrides.autoscaling_limits:type_name -> google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
	16, // 76: google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs:input_type -> google.spanner.admin.instance.v1.ListInstanceConfigsRequest
	18, // 77: google.spanner.admin.instance.v1.InstanceAdmin.GetInstanceConfig:input_type -> google.spanner.admin.instance.v1.GetInstanceConfigRequest
	19, // 78: google.spanner.admin.instance.v1.InstanceAdmin.CreateInstanceConfig:input_type -> google.spanner.admin.instance.v1.CreateInstanceConfigRequest
	20, // 79: google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstanceConfig:input_type -> google.spanner.admin.instance.v1.UpdateInstanceConfigRequest
	21, // 80: google.spanner.admin.instance.v1.InstanceAdmin.DeleteInstanceConfig:input_type -> google.spanner.admin.instance.v1.DeleteInstanceConfigRequest
	22, // 81: google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigOperations:input_type -> google.spanner.admin.instance.v1.ListInstanceConfigOperationsRequest
	26, // 82: google.spanner.admin.instance.v1.InstanceAdmin.ListInstances:input_type -> google.spanner.admin.instance.v1.ListInstancesRequest
	42, // 83: google.spanner.admin.instance.v1.InstanceAdmin.ListInstancePartitions:input_type -> google.spanner.admin.instance.v1.ListInstancePartitionsRequest
	24, // 84: google.spanner.admin.instance.v1.InstanceAdmin.GetInstance:input_type -> google.spanner.admin.instance.v1.GetInstanceRequest
	25, // 85: google.spanner.admin.instance.v1.InstanceAdmin.CreateInstance:input_type -> google.spanner.admin.instance.v1.CreateInstanceRequest
	28, // 86: google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstance:input_type -> google.spanner.admin.instance.v1.UpdateInstanceRequest
	29, // 87: google.spanner.admin.instance.v1.InstanceAdmin.DeleteInstance:input_type -> google.spanner.admin.instance.v1.DeleteInstanceRequest
	61, // 88: google.spanner.admin.instance.v1.InstanceAdmin.SetIamPolicy:input_type -> google.iam.v1.SetIamPolicyRequest
	62, // 89: google.spanner.admin.instance.v1.InstanceAdmin.GetIamPolicy:input_type -> google.iam.v1.GetIamPolicyRequest
	63, // 90: google.spanner.admin.instance.v1.InstanceAdmin.TestIamPermissions:input_type -> google.iam.v1.TestIamPermissionsRequest
	39, // 91: google.spanner.admin.instance.v1.InstanceAdmin.GetInstancePartition:input_type -> google.spanner.admin.instance.v1.GetInstancePartitionRequest
	37, // 92: google.spanner.admin.instance.v1.InstanceAdmin.CreateInstancePartition:input_type -> google.spanner.admin.instance.v1.CreateInstancePartitionRequest
	38, // 93: google.spanner.admin.instance.v1.InstanceAdmin.DeleteInstancePartition:input_type -> google.spanner.admin.instance.v1.DeleteInstancePartitionRequest
	40, // 94: google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstancePartition:input_type -> google.spanner.admin.instance.v1.UpdateInstancePartitionRequest
	44, // 95: google.spanner.admin.instance.v1.InstanceAdmin.ListInstancePartitionOperations:input_type -> google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest
	46, // 96: google.spanner.admin.instance.v1.InstanceAdmin.MoveInstance:input_type -> google.spanner.admin.instance.v1.MoveInstanceRequest
	17, // 97: google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs:output_type -> google.spanner.admin.instance.v1.ListInstanceConfigsResponse
	12, // 98: google.spanner.admin.instance.v1.InstanceAdmin.GetInstanceConfig:output_type -> google.spanner.admin.instance.v1.InstanceConfig
	58, // 99: google.spanner.admin.instance.v1.InstanceAdmin.CreateInstanceConfig:output_type -> google.longrunning.Operation
	58, // 100: google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstanceConfig:output_type -> google.longrunning.Operation
	64, // 101: google.spanner.admin.instance.v1.InstanceAdmin.DeleteInstanceConfig:output_type -> google.protobuf.Empty
	23, // 102: google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigOperations:output_type -> google.spanner.admin.instance.v1.ListInstanceConfigOperationsResponse
	27, // 103: google.spanner.admin.instance.v1.InstanceAdmin.ListInstances:output_type -> google.spanner.admin.instance.v1.ListInstancesResponse
	43, // 104: google.spanner.admin.instance.v1.InstanceAdmin.ListInstancePartitions:output_type -> google.spanner.admin.instance.v1.ListInstancePartitionsResponse
	15, // 105: google.spanner.admin.instance.v1.InstanceAdmin.GetInstance:output_type -> google.spanner.admin.instance.v1.Instance
	58, // 106: google.spanner.admin.instance.v1.InstanceAdmin.CreateInstance:output_type -> google.longrunning.Operation
	58, // 107: google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstance:output_type -> google.longrunning.Operation
	64, // 108: google.spanner.admin.instance.v1.InstanceAdmin.DeleteInstance:output_type -> google.protobuf.Empty
	65, // 109: google.spanner.admin.instance.v1.InstanceAdmin.SetIamPolicy:output_type -> google.iam.v1.Policy
	65, // 110: google.spanner.admin.instance.v1.InstanceAdmin.GetIamPolicy:output_type -> google.iam.v1.Policy
	66, // 111: google.spanner.admin.instance.v1.InstanceAdmin.TestIamPermissions:output_type -> google.iam.v1.TestIamPermissionsResponse
	35, // 112: google.spanner.admin.instance.v1.InstanceAdmin.GetInstancePartition:output_type -> google.spanner.admin.instance.v1.InstancePartition
	58, // 113: google.spanner.admin.instance.v1.InstanceAdmin.CreateInstancePartition:output_type -> google.longrunning.Operation
	64, // 114: google.spanner.admin.instance.v1.InstanceAdmin.DeleteInstancePartition:output_type -> google.protobuf.Empty
	58, // 115: google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstancePartition:output_type -> google.longrunning.Operation
	45, // 116: google.spanner.admin.instance.v1.InstanceAdmin.ListInstancePartitionOperations:output_type -> google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse
	58, // 117: google.spanner.admin.instance.v1.InstanceAdmin.MoveInstance:output_type -> google.longrunning.Operation
	97, // [97:118] is the sub-list for method output_type
	76, // [76:97] is the sub-list for method input_type
	76, // [76:76] is the sub-list for extension type_name
	76, // [76:76] is the sub-list for extension extendee
	0,  // [0:76] is the sub-list for field type_name
}

func init() { file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_init() }
func file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_init() {
	if File_google_spanner_admin_instance_v1_spanner_instance_admin_proto != nil {
		return
	}
	file_google_spanner_admin_instance_v1_common_proto_init()
	file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[2].OneofWrappers = []any{
		(*ReplicaComputeCapacity_NodeCount)(nil),
		(*ReplicaComputeCapacity_ProcessingUnits)(nil),
	}
	file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[24].OneofWrappers = []any{
		(*InstancePartition_NodeCount)(nil),
		(*InstancePartition_ProcessingUnits)(nil),
	}
	file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[39].OneofWrappers = []any{
		(*AutoscalingConfig_AutoscalingLimits_MinNodes)(nil),
		(*AutoscalingConfig_AutoscalingLimits_MinProcessingUnits)(nil),
		(*AutoscalingConfig_AutoscalingLimits_MaxNodes)(nil),
		(*AutoscalingConfig_AutoscalingLimits_MaxProcessingUnits)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDesc,
			NumEnums:      11,
			NumMessages:   44,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_goTypes,
		DependencyIndexes: file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_depIdxs,
		EnumInfos:         file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes,
		MessageInfos:      file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes,
	}.Build()
	File_google_spanner_admin_instance_v1_spanner_instance_admin_proto = out.File
	file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDesc = nil
	file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_goTypes = nil
	file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_depIdxs = nil
}
