// SPDX-License-Identifier: Unlicense OR BSD-3-Clause

package tables

import (
	"encoding/binary"
	"fmt"
)

// Code generated by binarygen from glyphs_glyf_src.go. DO NOT EDIT

func (item *CompositeGlyphPart) mustParse(src []byte) {
	_ = src[23] // early bound checking
	item.Flags = binary.BigEndian.Uint16(src[0:])
	item.GlyphIndex = binary.BigEndian.Uint16(src[2:])
	item.arg1 = binary.BigEndian.Uint16(src[4:])
	item.arg2 = binary.BigEndian.Uint16(src[6:])
	item.Scale[0] = float32(binary.BigEndian.Uint32(src[8:]))
	item.Scale[1] = float32(binary.BigEndian.Uint32(src[12:]))
	item.Scale[2] = float32(binary.BigEndian.Uint32(src[16:]))
	item.Scale[3] = float32(binary.BigEndian.Uint32(src[20:]))
}

func (item *GlyphContourPoint) mustParse(src []byte) {
	_ = src[4] // early bound checking
	item.Flag = src[0]
	item.X = int16(binary.BigEndian.Uint16(src[1:]))
	item.Y = int16(binary.BigEndian.Uint16(src[3:]))
}

func ParseCompositeGlyph(src []byte) (CompositeGlyph, int, error) {
	var item CompositeGlyph
	n := 0
	{

		err := item.parseGlyphs(src[:])
		if err != nil {
			return item, 0, fmt.Errorf("reading CompositeGlyph: %s", err)
		}
	}
	{

		err := item.parseInstructions(src[:])
		if err != nil {
			return item, 0, fmt.Errorf("reading CompositeGlyph: %s", err)
		}
	}
	return item, n, nil
}

func ParseCompositeGlyphPart(src []byte) (CompositeGlyphPart, int, error) {
	var item CompositeGlyphPart
	n := 0
	if L := len(src); L < 24 {
		return item, 0, fmt.Errorf("reading CompositeGlyphPart: "+"EOF: expected length: 24, got %d", L)
	}
	item.mustParse(src)
	n += 24
	return item, n, nil
}

func ParseGlyph(src []byte) (Glyph, int, error) {
	var item Glyph
	n := 0
	if L := len(src); L < 10 {
		return item, 0, fmt.Errorf("reading Glyph: "+"EOF: expected length: 10, got %d", L)
	}
	_ = src[9] // early bound checking
	item.numberOfContours = int16(binary.BigEndian.Uint16(src[0:]))
	item.XMin = int16(binary.BigEndian.Uint16(src[2:]))
	item.YMin = int16(binary.BigEndian.Uint16(src[4:]))
	item.XMax = int16(binary.BigEndian.Uint16(src[6:]))
	item.YMax = int16(binary.BigEndian.Uint16(src[8:]))
	n += 10

	{

		err := item.parseData(src[10:])
		if err != nil {
			return item, 0, fmt.Errorf("reading Glyph: %s", err)
		}
	}
	return item, n, nil
}

func ParseGlyphContourPoint(src []byte) (GlyphContourPoint, int, error) {
	var item GlyphContourPoint
	n := 0
	if L := len(src); L < 5 {
		return item, 0, fmt.Errorf("reading GlyphContourPoint: "+"EOF: expected length: 5, got %d", L)
	}
	item.mustParse(src)
	n += 5
	return item, n, nil
}

func ParseSimpleGlyph(src []byte, endPtsOfContoursCount int) (SimpleGlyph, int, error) {
	var item SimpleGlyph
	n := 0
	{

		if L := len(src); L < endPtsOfContoursCount*2 {
			return item, 0, fmt.Errorf("reading SimpleGlyph: "+"EOF: expected length: %d, got %d", endPtsOfContoursCount*2, L)
		}

		item.EndPtsOfContours = make([]uint16, endPtsOfContoursCount) // allocation guarded by the previous check
		for i := range item.EndPtsOfContours {
			item.EndPtsOfContours[i] = binary.BigEndian.Uint16(src[i*2:])
		}
		n += endPtsOfContoursCount * 2
	}
	if L := len(src); L < n+2 {
		return item, 0, fmt.Errorf("reading SimpleGlyph: "+"EOF: expected length: n + 2, got %d", L)
	}
	arrayLengthInstructions := int(binary.BigEndian.Uint16(src[n:]))
	n += 2

	{

		L := int(n + arrayLengthInstructions)
		if len(src) < L {
			return item, 0, fmt.Errorf("reading SimpleGlyph: "+"EOF: expected length: %d, got %d", L, len(src))
		}
		item.Instructions = src[n:L]
		n = L
	}
	{

		err := item.parsePoints(src[n:], endPtsOfContoursCount)
		if err != nil {
			return item, 0, fmt.Errorf("reading SimpleGlyph: %s", err)
		}
	}
	return item, n, nil
}
