// © Broadcom. All Rights Reserved.
// The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
// SPDX-License-Identifier: Apache-2.0

package esx

var MetricData = map[string]map[int32][]int64{
	"VirtualMachine": VmMetricData,
	"HostSystem":     HostMetricData,
	"ResourcePool":   ResourcePoolMetricData,
}

var VmMetricData = map[int32][]int64{
	131078: []int64{105, 91, 90, 120, 103, 65, 84, 486, 377, 483, 268, 3788, 5638, 417, 114, 51, 50, 31, 388, 22,
		19, 24, 83, 69, 22, 21, 47, 9, 68, 22, 12, 34, 137, 94, 68, 82, 53, 88, 73, 24,
		45, 35, 42, 52, 104, 103, 112, 124, 91, 111, 183, 82, 85, 40, 54, 27, 29, 17, 30, 23,
		32, 20, 30, 17, 38, 16, 14, 134, 92, 27, 16, 34, 28, 45, 39, 21, 37, 46, 65, 187,
		122, 551, 295, 121, 130, 84, 207, 128, 57, 34, 18, 38, 25, 25, 42, 21, 16, 117, 78, 20,
	},
	262144: []int64{2953459, 2953479, 2953499, 2953519, 2953539, 2953559, 2953579, 2953599, 2953619, 2953639, 2953659, 2953679, 2953699, 2953719, 2953739, 2953759, 2953779, 2953799, 2953819, 2953839,
		2953859, 2953879, 2953899, 2953919, 2953939, 2953959, 2953979, 2953999, 2954019, 2954039, 2954059, 2954079, 2954099, 2954119, 2954139, 2954159, 2954179, 2954199, 2954219, 2954239,
		2954259, 2954279, 2954299, 2954319, 2954339, 2954359, 2954379, 2954399, 2954419, 2954439, 2954459, 2954479, 2954499, 2954519, 2954539, 2954559, 2954579, 2954599, 2954619, 2954639,
		2954659, 2954679, 2954699, 2954719, 2954739, 2954759, 2954779, 2954799, 2954819, 2954839, 2954859, 2954879, 2954899, 2954919, 2954939, 2954959, 2954979, 2954999, 2955019, 2955039,
		2955059, 2955079, 2955099, 2955119, 2955139, 2955159, 2955179, 2955199, 2955219, 2955239, 2955259, 2955279, 2955299, 2955319, 2955339, 2955359, 2955379, 2955399, 2955419, 2955439,
	},
	589826: []int64{0, 1, 0, 23, 0, 0, 0, 62, 2, 5, 2, 3134, 4717, 81, 3, 0, 2, 0, 73, 0,
		1, 0, 4, 0, 0, 3, 0, 0, 1, 0, 0, 4, 0, 0, 0, 0, 10, 0, 0, 0,
		0, 3, 5, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 3, 0, 0, 2, 0,
		0, 1, 0, 0, 1, 0, 0, 4, 0, 0, 1, 3, 2, 0, 1, 1, 1, 0, 0, 0,
		0, 352, 62, 0, 0, 0, 17, 1, 0, 1, 1, 0, 0, 0, 0, 2, 0, 5, 0, 0,
	},
	27: []int64{0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	327684: []int64{2100, 1900, 2100, 2100, 2100, 2100, 2100, 2500, 3900, 4000, 4200, 4500, 4600, 7200, 7200, 7200, 7200, 7200, 7200, 7200,
		7200, 7200, 5700, 5700, 5700, 5700, 5100, 3800, 2300, 1900, 1900, 2100, 2100, 2000, 2000, 2000, 2000, 2000, 2100, 2000,
		2000, 2000, 2000, 2000, 2000, 2000, 1800, 1800, 1800, 1800, 1800, 1800, 1700, 1700, 1800, 1800, 1800, 1800, 1800, 1800,
		1800, 1900, 2000, 2000, 2000, 2000, 2000, 2600, 3700, 3700, 3700, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000,
		4000, 6400, 2200, 2100, 2100, 2100, 2100, 2100, 2100, 2100, 2100, 2100, 2100, 2100, 2100, 2100, 1900, 2100, 2100, 2100,
	},
	589827: []int64{185, 221, 201, 190, 213, 180, 183, 3167, 675, 806, 640, 1307, 1853, 985, 283, 202, 244, 188, 189, 223,
		190, 193, 516, 150, 100, 135, 127, 92, 160, 103, 101, 160, 203, 188, 238, 195, 206, 1006, 215, 168,
		234, 202, 185, 238, 197, 195, 229, 199, 207, 244, 696, 179, 231, 155, 122, 100, 153, 107, 107, 140,
		107, 91, 145, 100, 120, 147, 99, 3340, 2031, 123, 101, 153, 103, 120, 152, 89, 123, 236, 194, 234,
		181, 397, 536, 205, 210, 238, 201, 188, 205, 234, 183, 192, 222, 183, 238, 189, 185, 2573, 269, 168,
	},
	65591: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	262145: []int64{30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30,
		30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30,
		30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 28, 30, 30, 30, 30, 30,
		30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30,
		30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30,
	},
	131095: []int64{0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0,
		0, 0, 0, 1, 0, 1, 1, 1, 3, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0,
		0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 13, 0, 1, 1, 1, 1, 1,
		1, 0, 1, 1, 0, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1,
		0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 1,
	},
	327680: []int64{900, 900, 1100, 1200, 1200, 1000, 900, 2100, 3100, 4200, 4000, 4300, 4500, 6200, 5300, 3900, 1400, 1000, 1100, 1100,
		1000, 900, 1100, 1100, 1300, 1000, 1400, 1200, 1400, 1000, 1000, 900, 1000, 1100, 1000, 1000, 900, 1000, 1200, 1100,
		1000, 1200, 1200, 1300, 900, 900, 900, 900, 1100, 1000, 1100, 900, 900, 1200, 1400, 1300, 1300, 1100, 1200, 900,
		1000, 900, 1000, 1100, 1200, 1000, 900, 2600, 4400, 4400, 2600, 1300, 1200, 1300, 1000, 1000, 1000, 900, 1100, 1000,
		1000, 1500, 1700, 1800, 1200, 1000, 1300, 1300, 1400, 1000, 1000, 900, 1000, 1100, 1000, 1000, 900, 1800, 1900, 1900,
	},
	65628: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	196612: []int64{2225, 3281, 1618, 2063, 1848, 1873, 2184, 7480, 8118, 10104, 10870, 9808, 10400, 13222, 2843, 2012, 3354, 1841, 2146, 1756,
		1978, 2008, 1907, 1994, 2224, 3298, 2051, 2094, 1828, 2006, 2211, 3199, 1709, 1954, 1759, 1851, 2318, 1896, 1896, 2121,
		3276, 1983, 2205, 1779, 1689, 2019, 3311, 1876, 2034, 1907, 1961, 2015, 1749, 1927, 2294, 3313, 2048, 1981, 1967, 1848,
		2192, 3359, 1871, 1895, 1966, 1923, 2129, 3255, 1851, 1869, 3261, 1965, 2286, 1853, 1894, 1937, 3358, 1834, 2190, 1876,
		1949, 2031, 1892, 1787, 2014, 3183, 1621, 1724, 1817, 1774, 2141, 3293, 1798, 2044, 1798, 1832, 2108, 1780, 1946, 2000,
	},
	196619: []int64{338, 541, 275, 276, 274, 277, 338, 518, 546, 597, 677, 545, 606, 600, 305, 280, 542, 274, 351, 275,
		276, 275, 277, 276, 339, 391, 292, 275, 274, 276, 337, 541, 275, 275, 275, 276, 340, 277, 276, 276,
		389, 292, 337, 274, 276, 275, 542, 274, 339, 275, 274, 275, 278, 274, 340, 389, 293, 276, 274, 277,
		339, 543, 289, 274, 277, 275, 337, 280, 274, 274, 390, 290, 339, 276, 274, 277, 542, 276, 339, 275,
		274, 277, 277, 274, 340, 404, 275, 274, 277, 275, 338, 541, 274, 275, 275, 274, 340, 275, 276, 275,
	},
	196628: []int64{346, 555, 281, 282, 280, 283, 347, 528, 557, 609, 691, 554, 618, 611, 312, 286, 556, 280, 360, 281,
		282, 281, 281, 282, 347, 400, 298, 282, 280, 282, 346, 555, 281, 281, 281, 282, 348, 283, 282, 282,
		399, 298, 345, 280, 282, 281, 556, 281, 348, 282, 281, 281, 284, 280, 348, 398, 300, 283, 280, 283,
		347, 557, 295, 280, 284, 282, 345, 286, 280, 280, 399, 297, 347, 282, 280, 283, 556, 282, 347, 281,
		280, 283, 283, 280, 348, 414, 281, 280, 283, 282, 347, 555, 280, 282, 282, 281, 348, 281, 282, 282,
	},
	196613: []int64{1045, 1729, 698, 934, 692, 804, 938, 5133, 5837, 7138, 7639, 7081, 7420, 9237, 1494, 953, 1727, 787, 1039, 739,
		801, 815, 800, 881, 1148, 1807, 970, 803, 770, 845, 1084, 1932, 824, 883, 844, 832, 1204, 818, 873, 810,
		1834, 920, 972, 857, 841, 804, 1671, 793, 1068, 782, 832, 851, 831, 776, 1161, 1701, 922, 809, 777, 765,
		1029, 1893, 788, 772, 790, 815, 1050, 1463, 736, 768, 1782, 864, 1144, 923, 780, 890, 1645, 766, 1146, 827,
		829, 938, 914, 787, 1153, 1815, 786, 735, 752, 821, 1070, 1742, 773, 760, 759, 850, 1071, 798, 809, 788,
	},
	1: []int64{459, 568, 565, 667, 468, 400, 428, 2434, 1844, 1903, 2087, 2129, 2462, 4030, 755, 424, 599, 426, 669, 421,
		421, 458, 761, 611, 443, 740, 651, 400, 594, 441, 430, 545, 481, 579, 452, 435, 462, 584, 708, 389,
		765, 566, 439, 554, 417, 402, 579, 414, 645, 412, 538, 417, 465, 1149, 429, 746, 521, 388, 596, 389,
		445, 556, 566, 592, 488, 399, 457, 3707, 2176, 486, 774, 638, 457, 560, 475, 405, 579, 405, 663, 406,
		388, 1451, 624, 592, 474, 771, 662, 429, 588, 387, 452, 564, 452, 586, 451, 404, 444, 1771, 690, 397,
	},
	196614: []int64{246, 416, 202, 245, 203, 203, 245, 510, 474, 664, 776, 792, 927, 1261, 318, 259, 416, 203, 245, 203,
		217, 245, 218, 218, 246, 309, 216, 245, 203, 203, 246, 415, 203, 245, 203, 203, 260, 204, 203, 245,
		309, 215, 245, 203, 203, 245, 416, 203, 248, 203, 203, 245, 203, 203, 246, 308, 216, 245, 203, 203,
		246, 416, 203, 244, 203, 203, 245, 562, 203, 244, 308, 215, 246, 203, 203, 244, 416, 203, 245, 203,
		203, 245, 204, 203, 245, 320, 203, 244, 203, 203, 245, 416, 203, 245, 203, 203, 245, 203, 203, 245,
	},
	30: []int64{1889, 2375, 2401, 2804, 2005, 1726, 1848, 10236, 7642, 7872, 8787, 8676, 10432, 16327, 3168, 1797, 2525, 1766, 2769, 1788,
		1770, 1909, 3236, 2649, 1853, 3209, 2727, 1711, 2510, 1865, 1802, 2296, 2000, 2470, 1920, 1817, 1960, 2477, 2940, 1641,
		3366, 2229, 1820, 2288, 1733, 1693, 2534, 1742, 2643, 1721, 2257, 1705, 1966, 4724, 1806, 3226, 2100, 1688, 2475, 1648,
		1920, 2305, 2364, 2465, 1997, 1649, 1950, 15409, 8946, 2036, 3316, 2566, 1886, 2273, 2041, 1687, 2450, 1777, 2788, 1725,
		1647, 5924, 2638, 2466, 1963, 3281, 2712, 1828, 2480, 1654, 1898, 2356, 1888, 2469, 1915, 1691, 1840, 7415, 2902, 1648,
	},
	327683: []int64{1000, 1000, 1100, 1100, 1100, 1100, 1100, 1300, 1500, 1700, 1900, 2100, 2400, 2900, 3000, 3000, 3000, 2900, 2900, 2900,
		2900, 2900, 2700, 2500, 2300, 2200, 2000, 1700, 1200, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100,
		1100, 1100, 1100, 1100, 1100, 1100, 1100, 1000, 1100, 1000, 1100, 1100, 1000, 1100, 1100, 1100, 1100, 1100, 1100, 1100,
		1100, 1100, 1100, 1100, 1100, 1100, 1100, 1400, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700,
		1700, 1800, 1500, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1100, 1200, 1200, 1200,
	},
	65627: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	655379: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	196622: []int64{20, 20, 20, 20, 21, 20, 20, 24, 20, 20, 22, 20, 20, 20, 20, 20, 20, 21, 20, 20,
		20, 20, 20, 21, 20, 20, 20, 20, 20, 21, 20, 20, 20, 20, 20, 22, 20, 24, 20, 20,
		20, 20, 21, 20, 20, 20, 20, 20, 21, 20, 20, 20, 20, 20, 21, 20, 20, 20, 21, 20,
		21, 20, 20, 20, 20, 20, 20, 25, 20, 20, 20, 20, 20, 21, 20, 20, 20, 20, 20, 21,
		20, 20, 20, 20, 20, 21, 21, 20, 20, 20, 19, 20, 21, 20, 20, 20, 20, 20, 21, 20,
	},
	65603: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	327685: []int64{1000, 1000, 1000, 1000, 1000, 1000, 1000, 1200, 1400, 1600, 1800, 2000, 2200, 2700, 2800, 2800, 2800, 2800, 2800, 2800,
		2800, 2800, 2600, 2400, 2200, 2000, 1800, 1600, 1100, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000,
		1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000,
		1000, 1000, 1100, 1000, 1100, 1000, 1000, 1400, 1600, 1600, 1600, 1600, 1600, 1600, 1700, 1600, 1700, 1600, 1600, 1600,
		1600, 1800, 1400, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1000, 1200, 1200, 1200,
	},
	196615: []int64{338, 541, 275, 276, 274, 277, 338, 518, 546, 597, 677, 545, 606, 600, 305, 280, 542, 274, 351, 275,
		276, 275, 277, 276, 339, 391, 292, 275, 274, 276, 337, 541, 275, 275, 275, 276, 340, 277, 276, 276,
		389, 292, 337, 274, 276, 275, 542, 274, 339, 275, 274, 275, 278, 274, 340, 389, 293, 276, 274, 277,
		339, 543, 289, 274, 277, 275, 337, 280, 274, 274, 390, 290, 339, 276, 274, 277, 542, 276, 339, 275,
		274, 277, 277, 274, 340, 404, 275, 274, 277, 275, 338, 541, 274, 275, 275, 274, 340, 275, 276, 275,
	},
	327689: []int64{1300, 1700, 2000, 2200, 2200, 2200, 1200, 7000, 7000, 7000, 4800, 7500, 7500, 11300, 11300, 11300, 4800, 1800, 2300, 2300,
		2300, 1300, 2600, 2600, 2600, 2200, 3700, 3700, 3700, 1900, 1900, 1900, 1900, 1900, 1800, 1800, 1500, 2100, 2600, 2600,
		2600, 3700, 3700, 3700, 1800, 1800, 1700, 1700, 1900, 1900, 1900, 1500, 1500, 4100, 4100, 4100, 3700, 3700, 3700, 1800,
		1800, 1900, 1900, 1900, 1900, 1700, 1500, 11100, 11100, 11100, 10400, 4000, 4000, 4000, 1800, 1800, 2100, 2100, 2100, 2100,
		2100, 7600, 7600, 7600, 2000, 2000, 3800, 3800, 3800, 1900, 1900, 1900, 1900, 2000, 2000, 2000, 1500, 9100, 9100, 9100,
	},
	196609: []int64{584, 957, 478, 521, 477, 480, 584, 1029, 1020, 1261, 1453, 1337, 1533, 1861, 624, 539, 959, 477, 597, 478,
		494, 520, 496, 494, 585, 700, 508, 521, 477, 480, 583, 957, 478, 520, 478, 479, 600, 481, 479, 521,
		699, 507, 583, 477, 479, 520, 958, 478, 588, 479, 478, 520, 481, 478, 586, 698, 509, 521, 478, 480,
		585, 959, 492, 519, 481, 479, 583, 843, 478, 519, 699, 506, 585, 479, 478, 522, 958, 479, 585, 478,
		478, 522, 481, 478, 585, 724, 478, 518, 480, 479, 584, 958, 478, 520, 479, 478, 586, 478, 480, 520,
	},
	196627: []int64{240, 397, 197, 239, 197, 198, 239, 491, 467, 656, 767, 778, 921, 1255, 312, 253, 398, 197, 239, 197,
		212, 239, 198, 212, 240, 301, 204, 239, 197, 198, 240, 397, 197, 239, 197, 198, 254, 198, 198, 239,
		301, 204, 239, 197, 197, 239, 398, 198, 242, 198, 198, 239, 197, 198, 240, 301, 205, 239, 198, 198,
		240, 398, 198, 238, 198, 198, 239, 547, 198, 238, 301, 204, 240, 197, 198, 238, 398, 197, 239, 198,
		198, 239, 198, 197, 239, 307, 197, 238, 197, 197, 239, 398, 197, 239, 197, 197, 239, 198, 198, 239,
	},
	327691: []int64{1900, 1700, 2000, 2000, 2000, 2000, 2000, 2300, 3600, 3900, 3900, 4200, 4300, 6900, 6900, 6900, 6900, 6900, 6900, 6900,
		6900, 6900, 5200, 5200, 5200, 5200, 4800, 3700, 2200, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900,
		1900, 1900, 1900, 1800, 1800, 1800, 1800, 1800, 1800, 1800, 1800, 1800, 1700, 1700, 1800, 1800, 1800, 1800, 1800, 1800,
		1800, 1900, 1900, 1900, 1900, 1900, 1900, 2500, 3700, 3700, 3700, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000,
		4000, 6000, 2100, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900,
	},
	196623: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	65549: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	327688: []int64{2300, 2300, 2300, 2300, 2300, 2400, 2400, 2400, 2400, 2200, 2100, 1900, 1800, 1700, 1800, 1800, 1800, 1800, 1800, 1800,
		1800, 1800, 1700, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600,
		1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1500, 1500, 1400, 1400, 1300, 1200, 1000, 1000,
		1000, 1000, 1000, 1000, 1000, 1000, 1000, 1100, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200,
		1200, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300,
	},
	65582: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	32: []int64{25, 24, 26, 25, 30, 27, 29, 68, 43, 51, 54, 65, 48, 46, 30, 24, 28, 26, 25, 29,
		24, 27, 35, 28, 28, 36, 34, 23, 32, 24, 22, 28, 20, 24, 25, 26, 27, 24, 26, 24,
		29, 25, 26, 23, 24, 29, 26, 25, 26, 22, 23, 26, 28, 22, 23, 25, 26, 24, 20, 25,
		31, 25, 19, 21, 22, 21, 30, 35, 32, 29, 27, 27, 24, 25, 24, 24, 23, 24, 25, 24,
		26, 26, 24, 23, 21, 30, 34, 23, 25, 25, 28, 29, 23, 22, 28, 24, 26, 33, 27, 23,
	},
	196616: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	26: []int64{217, 224, 259, 290, 282, 249, 216, 489, 724, 988, 925, 1006, 1057, 1432, 1233, 916, 342, 231, 273, 255,
		244, 208, 264, 269, 299, 239, 325, 290, 323, 235, 240, 228, 238, 259, 249, 239, 221, 242, 286, 273,
		247, 282, 293, 311, 229, 221, 218, 225, 260, 242, 254, 220, 229, 297, 330, 318, 300, 265, 296, 227,
		232, 217, 252, 276, 276, 240, 222, 617, 1020, 1019, 617, 300, 299, 315, 241, 230, 231, 229, 272, 249,
		236, 357, 392, 426, 276, 246, 305, 300, 326, 233, 231, 225, 242, 262, 248, 233, 213, 417, 449, 458,
	},
	31: []int64{43400, 44800, 51800, 58000, 56400, 49800, 43200, 97800, 144800, 197600, 185000, 201200, 211400, 286400, 246600, 183200, 68400, 46200, 54600, 51000,
		48800, 41600, 52800, 53800, 59800, 47800, 65000, 58000, 64600, 47000, 48000, 45600, 47600, 51800, 49800, 47800, 44200, 48400, 57200, 54600,
		49400, 56400, 58600, 62200, 45800, 44200, 43600, 45000, 52000, 48400, 50800, 44000, 45800, 59400, 66000, 63600, 60000, 53000, 59200, 45400,
		46400, 43400, 50400, 55200, 55200, 48000, 44400, 123400, 204000, 203800, 123400, 60000, 59800, 63000, 48200, 46000, 46200, 45800, 54400, 49800,
		47200, 71400, 78400, 85200, 55200, 49200, 61000, 60000, 65200, 46600, 46200, 45000, 48400, 52400, 49600, 46600, 42600, 83400, 89800, 91600,
	},
	25: []int64{50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
		50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
		50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
		50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
		50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
	},
	65553: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	65607: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	28: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	327681: []int64{1400, 1900, 2100, 2200, 2200, 2200, 1300, 7200, 7200, 7200, 5200, 8000, 8000, 11800, 11800, 11800, 5100, 1800, 2300, 2300,
		2300, 1400, 2700, 2700, 2700, 2300, 3800, 3800, 3800, 1900, 1900, 2100, 2100, 2100, 2000, 2000, 1600, 2100, 2700, 2700,
		2700, 4100, 4100, 4100, 1800, 1800, 1700, 1700, 1900, 1900, 1900, 1600, 1600, 4100, 4100, 4100, 3700, 3700, 3700, 1800,
		1800, 2000, 2000, 2000, 2000, 1800, 1600, 11400, 11400, 11400, 10900, 4000, 4000, 4000, 1800, 1800, 2200, 2200, 2200, 2200,
		2200, 7700, 7700, 7700, 2100, 2100, 3800, 3800, 3800, 1900, 1900, 2200, 2200, 2200, 2100, 2100, 1600, 9400, 9400, 9400,
	},
	262170: []int64{2861015, 2861045, 2861045, 2861075, 2861105, 2861105, 2861135, 2861165, 2861165, 2861195, 2861225, 2861225, 2861255, 2861285, 2861285, 2861315, 2861345, 2861345, 2861375, 2861405,
		2861405, 2861435, 2861465, 2861465, 2861495, 2861525, 2861525, 2861555, 2861585, 2861585, 2861615, 2861645, 2861645, 2861675, 2861705, 2861705, 2861735, 2861765, 2861765, 2861795,
		2861825, 2861825, 2861855, 2861885, 2861885, 2861915, 2861945, 2861945, 2861975, 2862005, 2862005, 2862035, 2862065, 2862065, 2862095, 2862125, 2862125, 2862155, 2862185, 2862185,
		2862215, 2862245, 2862245, 2862275, 2862305, 2862305, 2862335, 2862365, 2862365, 2862395, 2862425, 2862425, 2862455, 2862485, 2862485, 2862515, 2862545, 2862545, 2862575, 2862605,
		2862605, 2862635, 2862665, 2862665, 2862695, 2862725, 2862725, 2862755, 2862785, 2862785, 2862815, 2862845, 2862845, 2862875, 2862905, 2862905, 2862935, 2862965, 2862965, 2862995,
	},
	327686: []int64{2500, 2500, 2500, 2500, 2500, 2500, 2500, 2500, 2500, 2300, 2200, 2100, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900,
		1900, 1900, 1800, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700,
		1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1600, 1600, 1500, 1400, 1400, 1300, 1100, 1100,
		1100, 1100, 1100, 1100, 1100, 1100, 1100, 1200, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300,
		1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1400, 1400, 1400,
	},
	327690: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	327694: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	720898: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	65619: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	5: []int64{211, 261, 260, 307, 215, 184, 197, 1121, 849, 876, 961, 980, 1134, 1856, 347, 195, 276, 196, 308, 193,
		194, 211, 350, 281, 204, 341, 300, 184, 273, 203, 198, 251, 221, 267, 208, 200, 212, 269, 326, 179,
		352, 260, 202, 255, 192, 185, 266, 191, 297, 189, 248, 192, 214, 529, 198, 344, 240, 178, 274, 179,
		205, 256, 260, 273, 225, 183, 210, 1708, 1002, 224, 356, 294, 211, 258, 218, 186, 266, 186, 305, 187,
		179, 668, 287, 273, 218, 355, 305, 197, 271, 178, 208, 260, 208, 270, 208, 186, 204, 816, 317, 183,
	},
	12: []int64{1711, 2153, 2171, 2558, 1771, 1503, 1598, 9515, 7128, 7337, 8062, 8181, 9498, 15824, 2927, 1603, 2297, 1593, 2559, 1573,
		1578, 1731, 2944, 2338, 1647, 2816, 2499, 1511, 2280, 1659, 1629, 2050, 1832, 2202, 1711, 1617, 1743, 2257, 2729, 1455,
		2939, 2164, 1645, 2127, 1545, 1509, 2199, 1561, 2466, 1539, 2068, 1561, 1767, 4473, 1625, 2855, 1997, 1445, 2282, 1465,
		1664, 2104, 2168, 2258, 1855, 1498, 1716, 14725, 8581, 1833, 2979, 2449, 1722, 2119, 1846, 1524, 2224, 1522, 2550, 1509,
		1477, 5683, 2386, 2276, 1781, 2955, 2527, 1618, 2245, 1464, 1687, 2148, 1688, 2238, 1720, 1516, 1656, 6995, 2664, 1458,
	},
	131079: []int64{185, 221, 201, 190, 213, 180, 183, 3168, 675, 806, 641, 1307, 1853, 985, 283, 202, 244, 188, 189, 223,
		190, 193, 516, 150, 100, 135, 127, 92, 160, 103, 101, 160, 203, 188, 238, 195, 206, 1006, 215, 168,
		234, 202, 185, 238, 197, 195, 229, 199, 207, 244, 700, 179, 231, 155, 122, 100, 153, 107, 107, 140,
		107, 91, 145, 100, 120, 147, 99, 3340, 2031, 123, 101, 153, 103, 120, 152, 89, 123, 236, 194, 234,
		181, 397, 544, 197, 221, 227, 201, 188, 205, 234, 183, 192, 222, 183, 238, 189, 185, 2573, 269, 168,
	},
	29: []int64{9, 10, 10, 10, 11, 8, 10, 43, 34, 38, 34, 67, 101, 52, 14, 8, 10, 9, 16, 7,
		8, 7, 14, 9, 8, 11, 12, 6, 9, 8, 7, 8, 10, 8, 9, 10, 9, 11, 11, 7,
		10, 9, 7, 9, 10, 8, 12, 9, 10, 10, 13, 9, 9, 10, 8, 9, 9, 5, 8, 7,
		8, 8, 8, 7, 9, 6, 7, 27, 19, 7, 10, 9, 7, 8, 8, 6, 9, 8, 9, 11,
		9, 19, 15, 10, 10, 11, 13, 10, 9, 9, 7, 8, 9, 7, 8, 7, 8, 18, 10, 7,
	},
	65537: []int64{3500, 3500, 3500, 3199, 3199, 3199, 3699, 3699, 3699, 3799, 3799, 3799, 3799, 3799, 3799, 3500, 3500, 3500, 3299, 3299,
		3299, 3399, 3399, 3399, 3399, 3399, 3399, 3199, 3199, 3199, 3299, 3299, 3299, 3299, 3299, 3299, 3199, 3199, 3199, 3199,
		3199, 3199, 3399, 3399, 3399, 3399, 3399, 3399, 3099, 3099, 3099, 3299, 3299, 3299, 3799, 3799, 3799, 3099, 3099, 3099,
		3500, 3500, 3500, 3399, 3399, 3399, 3399, 3399, 3399, 3699, 3699, 3699, 3699, 3699, 3699, 4000, 4000, 4000, 3899, 3899,
		3899, 3500, 3500, 3500, 3299, 3299, 3299, 3599, 3599, 3599, 3299, 3299, 3299, 3199, 3199, 3199, 3199, 3199, 3199, 3099,
	},
	65635: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	65611: []int64{10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760,
		10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760,
		10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760,
		10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760,
		10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760,
	},
	65622: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	14: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	65541: []int64{10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760,
		10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760,
		10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760,
		10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760,
		10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760, 10485760,
	},
	327687: []int64{10500, 10500, 10500, 10500, 10500, 10500, 10500, 10500, 10500, 9400, 6400, 4600, 4400, 4400, 4500, 4500, 4500, 4500, 4500, 4500,
		4500, 4500, 4200, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000,
		4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 3900, 3800, 2700, 2600, 2100, 1900, 1800,
		1800, 1900, 1900, 1900, 1900, 1900, 1900, 2000, 2100, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2100, 2100,
		2100, 2200, 2200, 2100, 2100, 2100, 2100, 2100, 2100, 2100, 2100, 2200, 2200, 2200, 2200, 2200, 2200, 2200, 2200, 2200,
	},
	65545: []int64{3670016, 3670016, 3670016, 3355440, 3355440, 3355440, 3879728, 3879728, 3879728, 3984588, 3984588, 3984588, 3984588, 3984588, 3984588, 3670016, 3670016, 3670016, 3460300, 3460300,
		3460300, 3565156, 3565156, 3565156, 3565156, 3565156, 3565156, 3355440, 3355440, 3355440, 3460300, 3460300, 3460300, 3460300, 3460300, 3460300, 3355440, 3355440, 3355440, 3355440,
		3355440, 3355440, 3565156, 3565156, 3565156, 3565156, 3565156, 3565156, 3250584, 3250584, 3250584, 3460300, 3460300, 3460300, 3984588, 3984588, 3984588, 3250584, 3250584, 3250584,
		3670016, 3670016, 3670016, 3565156, 3565156, 3565156, 3565156, 3565156, 3565156, 3879728, 3879728, 3879728, 3879728, 3879728, 3879728, 4194304, 4194304, 4194304, 4089444, 4089444,
		4089444, 3670016, 3670016, 3670016, 3460300, 3460300, 3460300, 3774872, 3774872, 3774872, 3460300, 3460300, 3460300, 3355440, 3355440, 3355440, 3355440, 3355440, 3355440, 3250584,
	},
	65586: []int64{57744, 57744, 57744, 57760, 57760, 57760, 57760, 57760, 57760, 57792, 57792, 57792, 57712, 57712, 57712, 57824, 57824, 57824, 57840, 57840,
		57840, 57856, 57856, 57856, 57776, 57776, 57776, 57888, 57888, 57888, 57696, 57696, 57696, 57712, 57712, 57712, 57824, 57824, 57824, 57856,
		57856, 57856, 57888, 57888, 57888, 57904, 57904, 57904, 57904, 57904, 57904, 57920, 57920, 57920, 57936, 57936, 57936, 57856, 57856, 57856,
		57968, 57968, 57872, 57984, 57984, 57984, 58000, 57904, 57904, 57824, 57824, 57824, 57840, 57840, 57840, 57760, 57760, 57760, 57776, 57888,
		57888, 57696, 57696, 57696, 57808, 57808, 57808, 57712, 57936, 57936, 57840, 57840, 57840, 57840, 57952, 57952, 57760, 57872, 57872, 57872,
	},
	65624: []int64{84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252,
		84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252,
		84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252,
		84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252,
		84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252, 84252,
	},
	65634: []int64{57744, 57744, 57744, 57760, 57760, 57760, 57760, 57760, 57760, 57792, 57792, 57792, 57712, 57712, 57712, 57824, 57824, 57824, 57840, 57840,
		57840, 57856, 57856, 57856, 57776, 57776, 57776, 57888, 57888, 57888, 57696, 57696, 57696, 57712, 57712, 57712, 57824, 57824, 57824, 57856,
		57856, 57856, 57888, 57888, 57888, 57904, 57904, 57904, 57904, 57904, 57904, 57920, 57920, 57920, 57936, 57936, 57936, 57856, 57856, 57856,
		57968, 57968, 57872, 57984, 57984, 57984, 58000, 57904, 57904, 57824, 57824, 57824, 57840, 57840, 57840, 57760, 57760, 57760, 57776, 57888,
		57888, 57696, 57696, 57696, 57808, 57808, 57808, 57712, 57936, 57936, 57840, 57840, 57840, 57840, 57952, 57952, 57760, 57872, 57872, 57872,
	},
	65626: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	65629: []int64{10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208,
		10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208,
		10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208,
		10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208,
		10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208, 10502208,
	},
	65621: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	65623: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	327695: []int64{160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160,
		160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160,
		160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160,
		160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160,
		160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160,
	},
	13: []int64{37978, 37501, 37462, 37066, 37839, 38140, 38011, 29354, 32106, 31822, 30939, 30913, 29139, 23406, 36679, 38089, 37345, 38110, 37061, 38081,
		38120, 37966, 36595, 37207, 38021, 36634, 37109, 38187, 37335, 38029, 38098, 37573, 37880, 37394, 37941, 38053, 37909, 37384, 36931, 38248,
		36492, 37654, 38055, 37596, 38126, 38157, 37319, 38123, 37220, 38150, 37587, 38157, 37893, 32654, 38076, 36665, 37776, 38207, 37424, 38241,
		37941, 37582, 37542, 37439, 37894, 38254, 37917, 24375, 30881, 37834, 36563, 37313, 37999, 37605, 37848, 38206, 37440, 38100, 37089, 38127,
		38208, 33912, 37191, 37407, 37916, 36568, 37091, 38034, 37393, 38237, 37976, 37508, 38001, 37419, 37956, 38192, 38043, 32389, 36953, 38248,
	},
	327682: []int64{800, 900, 1000, 1200, 1100, 1000, 800, 1900, 2900, 4000, 3700, 4000, 4200, 5800, 5000, 3700, 1400, 900, 1100, 1000,
		1000, 800, 1000, 1100, 1200, 900, 1300, 1100, 1300, 900, 900, 900, 900, 1000, 1000, 900, 800, 900, 1100, 1100,
		1000, 1100, 1100, 1200, 900, 900, 900, 900, 1000, 1000, 1000, 900, 900, 1200, 1300, 1300, 1200, 1100, 1200, 900,
		900, 800, 1000, 1100, 1100, 900, 800, 2500, 4200, 4200, 2500, 1200, 1200, 1300, 1000, 900, 900, 900, 1100, 1000,
		900, 1400, 1600, 1700, 1100, 900, 1200, 1200, 1300, 900, 900, 900, 900, 1000, 1000, 900, 800, 1700, 1800, 1900,
	},
	65595: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	65618: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	196621: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	196620: []int64{53, 31, 40, 39, 38, 34, 42, 276, 414, 530, 550, 290, 179, 96, 38, 51, 46, 34, 40, 35,
		43, 38, 42, 31, 47, 47, 34, 43, 42, 39, 39, 36, 35, 42, 42, 41, 42, 47, 43, 41,
		36, 32, 40, 50, 36, 38, 43, 39, 36, 32, 35, 41, 45, 35, 36, 43, 42, 35, 43, 36,
		49, 41, 32, 51, 44, 45, 38, 49, 34, 47, 38, 42, 45, 49, 40, 28, 48, 34, 40, 34,
		47, 34, 48, 43, 33, 39, 34, 39, 39, 46, 36, 49, 38, 34, 33, 44, 40, 37, 51, 36,
	},
	24: []int64{83, 108, 82, 102, 104, 96, 105, 276, 193, 208, 261, 221, 312, 203, 105, 85, 105, 79, 92, 103,
		85, 85, 122, 120, 94, 151, 106, 87, 104, 91, 79, 106, 76, 104, 93, 89, 96, 93, 94, 84,
		150, 54, 83, 77, 85, 88, 130, 83, 84, 79, 82, 74, 89, 97, 81, 132, 65, 97, 82, 84,
		108, 89, 81, 86, 71, 71, 104, 225, 136, 94, 128, 72, 77, 78, 87, 79, 95, 100, 98, 90,
		83, 102, 99, 84, 82, 123, 100, 90, 98, 85, 95, 109, 74, 92, 91, 82, 86, 152, 98, 84,
	},
	65632: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	65633: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	131073: []int64{290, 313, 292, 310, 317, 245, 267, 3654, 1052, 1289, 909, 5095, 7491, 1402, 397, 253, 294, 220, 577, 245,
		210, 217, 600, 219, 122, 157, 175, 101, 229, 125, 113, 194, 340, 282, 306, 277, 259, 1095, 289, 192,
		280, 238, 227, 291, 301, 299, 341, 324, 299, 355, 884, 262, 316, 195, 176, 127, 183, 124, 137, 164,
		139, 111, 175, 117, 159, 163, 114, 3475, 2124, 150, 117, 187, 132, 166, 192, 111, 160, 282, 259, 421,
		304, 948, 840, 318, 352, 312, 408, 316, 263, 269, 201, 230, 248, 208, 281, 211, 202, 2690, 347, 189,
	},
	10: []int64{38008, 37528, 37491, 37093, 37873, 38166, 38033, 29492, 32179, 31921, 30994, 31066, 29370, 23484, 36708, 38107, 37359, 38126, 37127, 38097,
		38132, 37979, 36623, 37238, 38032, 36645, 37131, 38194, 37359, 38040, 38105, 37590, 37920, 37431, 37973, 38079, 37929, 37422, 36953, 38261,
		36518, 37666, 38075, 37616, 38170, 38191, 37362, 38155, 37250, 38189, 37648, 38186, 37925, 35180, 38096, 36675, 37795, 38213, 37441, 38251,
		37950, 37594, 37558, 37443, 37914, 38263, 37927, 24447, 30924, 37848, 36574, 37326, 38012, 37623, 37861, 38214, 37454, 38126, 37111, 38178,
		38246, 33970, 37262, 37439, 37949, 36598, 37151, 38072, 37418, 38245, 37985, 37527, 38015, 37441, 37972, 38208, 38054, 32457, 36985, 38260,
	},
	327696: []int64{6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000,
		6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000,
		6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000,
		6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000,
		6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000,
	},
	196618: []int64{246, 416, 202, 245, 203, 203, 245, 510, 474, 664, 776, 792, 927, 1261, 318, 259, 416, 203, 245, 203,
		217, 245, 218, 218, 246, 309, 216, 245, 203, 203, 246, 415, 203, 245, 203, 203, 260, 204, 203, 245,
		309, 215, 245, 203, 203, 245, 416, 203, 248, 203, 203, 245, 203, 203, 246, 308, 216, 245, 203, 203,
		246, 416, 203, 244, 203, 203, 245, 562, 203, 244, 308, 215, 246, 203, 203, 244, 416, 203, 245, 203,
		203, 245, 204, 203, 245, 320, 203, 244, 203, 203, 245, 416, 203, 245, 203, 203, 245, 203, 203, 245,
	},
	65620: []int64{3145728, 3145728, 3145728, 2831152, 2831152, 2831152, 3145728, 3145728, 3145728, 3145728, 3145728, 3145728, 3145728, 3145728, 3145728, 2831152, 2831152, 2831152, 2621440, 2621440,
		2621440, 2516580, 2516580, 2516580, 2411724, 2411724, 2516580, 2516580, 2516580, 2516580, 2516580, 2516580, 2516580, 2726296, 2726296, 2726296, 2726296, 2726296, 2726296, 2411724,
		2411724, 2411724, 2621440, 2726296, 2726296, 2831152, 2831152, 2831152, 2411724, 2411724, 2411724, 2516580, 2516580, 2516580, 3040868, 3040868, 3040868, 2411724, 2621440, 2621440,
		2936012, 2936012, 2936012, 2936012, 2936012, 2936012, 2411724, 2411724, 2411724, 2936012, 2936012, 2936012, 2936012, 2936012, 2936012, 2621440, 2621440, 2621440, 2621440, 2621440,
		2621440, 2411724, 2411724, 2411724, 2306864, 2306864, 2306864, 2726296, 2726296, 2726296, 2306864, 2411724, 2621440, 2621440, 2621440, 2621440, 2411724, 2411724, 2411724, 2411724,
	},
	720896: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	65599: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	327693: []int64{10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 9300, 6200, 4300, 4100, 4100, 4200, 4200, 4200, 4200, 4200, 4200,
		4200, 4200, 3900, 3800, 3800, 3800, 3800, 3800, 3800, 3800, 3800, 3800, 3800, 3800, 3800, 3800, 3800, 3800, 3800, 3800,
		3800, 3700, 3700, 3700, 3700, 3700, 3700, 3700, 3700, 3700, 3700, 3700, 3700, 3600, 3500, 2600, 2500, 1900, 1800, 1800,
		1800, 1800, 1900, 1800, 1800, 1800, 1800, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 2100, 2100,
		2100, 2100, 2100, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2100, 2100, 2000,
	},
	327692: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	196617: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	9: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	11: []int64{102, 98, 107, 101, 122, 108, 120, 272, 175, 206, 218, 262, 194, 187, 120, 97, 115, 108, 103, 117,
		97, 111, 140, 113, 115, 145, 140, 92, 130, 97, 90, 114, 80, 100, 103, 108, 109, 100, 106, 98,
		117, 103, 104, 95, 97, 116, 105, 101, 107, 91, 93, 108, 113, 92, 96, 101, 104, 97, 84, 102,
		127, 102, 80, 87, 91, 88, 123, 143, 128, 116, 109, 109, 98, 104, 99, 99, 95, 97, 101, 96,
		107, 105, 99, 94, 88, 121, 138, 95, 104, 100, 115, 118, 96, 90, 113, 98, 105, 133, 108, 94,
	},
}

var HostMetricData = map[int32][]int64{
	786434: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	786433: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	196621: []int64{12, 6, 12, 14, 14, 3, 9, 10, 8, 8, 7, 4, 13, 10, 2, 10, 12, 5, 8, 14,
		4, 10, 10, 5, 7, 13, 4, 9, 13, 6, 10, 11, 5, 5, 15, 6, 7, 8, 6, 11,
		11, 3, 6, 16, 4, 5, 9, 11, 9, 9, 6, 10, 14, 4, 4, 13, 11, 4, 14, 7,
		10, 12, 4, 7, 14, 9, 3, 12, 9, 8, 9, 9, 3, 14, 9, 4, 11, 9, 5, 12,
		10, 3, 13, 10, 4, 8, 12, 7, 10, 8, 4, 14, 11, 2, 8, 15, 7, 6, 8, 9,
	},
	65648: []int64{125627793408, 125627793408, 129922760704, 129922760704, 132070244352, 132070244352, 133143986176, 133143986176, 133143986176, 134217728000, 134217728000, 134217728000, 134217728000, 134217728000, 134217728000, 134217728000, 134217728000, 134217728000, 134217728000, 134217728000,
		134217728000, 134217728000, 134217728000, 134217728000, 134217728000, 134217728000, 134217728000, 134217728000, 135291469824, 135291469824, 135291469824, 135291469824, 135291469824, 135291469824, 135291469824, 135291469824, 135291469824, 135291469824, 135291469824, 135291469824,
		135291469824, 135291469824, 135291469824, 135291469824, 135291469824, 135291469824, 135291469824, 135291469824, 135291469824, 135291469824, 135291469824, 135291469824, 135291469824, 135291469824, 135291469824, 135291469824, 135291469824, 135291469824, 135291469824, 135291469824,
		136365211648, 136365211648, 136365211648, 136365211648, 136365211648, 136365211648, 136365211648, 136365211648, 136365211648, 136365211648, 136365211648, 136365211648, 136365211648, 136365211648, 136365211648, 136365211648, 136365211648, 136365211648, 136365211648, 136365211648,
		136365211648, 136365211648, 136365211648, 136365211648, 136365211648, 136365211648, 136365211648, 136365211648, 136365211648, 136365211648, 136365211648, 136365211648, 136365211648, 136365211648, 136365211648, 136365211648, 136365211648, 136365211648, 136365211648, 136365211648,
	},
	196617: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	720897: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	655379: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	786432: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	65580: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	65553: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	327688: []int64{3000, 2800, 2700, 2500, 2500, 2500, 2500, 2500, 2500, 2500, 2500, 2500, 2500, 2400, 2300, 2300, 2300, 2300, 2300, 2400,
		2400, 2400, 2400, 2400, 2400, 2400, 2400, 2400, 2400, 2400, 2400, 2400, 2400, 2300, 2400, 2400, 2300, 2400, 2300, 2300,
		2300, 2300, 2300, 2300, 2200, 2200, 2100, 2000, 2000, 1800, 1800, 1800, 1800, 1800, 1800, 1800, 1800, 1800, 1900, 2000,
		2000, 2000, 2000, 2000, 1900, 2000, 1900, 1900, 1900, 1900, 1900, 1900, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000,
		2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2100, 2000, 2000, 2000, 2000, 2000, 2100, 2100, 2100, 2100, 2000, 2000,
	},
	65569: []int64{8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
		8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
		8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
		8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
		8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
	},
	65618: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	65599: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	65651: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	65623: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	65621: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	65545: []int64{5148100, 5152036, 5152036, 5068216, 5066748, 5066748, 4668288, 4667468, 4667532, 4415832, 4414556, 4414556, 4645244, 4643896, 4643832, 4476060, 4477808, 4477328, 4393504, 4394380,
		4394380, 4415352, 4414368, 4414368, 4582080, 4667244, 4709192, 4604396, 4601648, 4601236, 4223616, 4266064, 4308068, 4517720, 4517808, 4517808, 4895296, 4894212, 4894148, 4160148,
		4160652, 4160716, 4496260, 4497200, 4497260, 4895660, 4894568, 4894504, 4160500, 4160176, 4160176, 4789388, 4790264, 4790264, 4517628, 4559080, 4601088, 4601024, 4601032, 4601032,
		4831780, 4833388, 4833324, 4833324, 4831012, 4831076, 5313912, 5314316, 5314316, 4999740, 5003640, 5003544, 4584148, 4622376, 4622376, 4412724, 4580436, 4664320, 5146664, 5147684,
		5147684, 4833048, 4411892, 4453836, 4349040, 4394232, 4394168, 4394168, 4770512, 4770576, 4665656, 4202908, 4202908, 4832052, 5002572, 5002508, 4583080, 4498160, 4498224, 4707940,
	},
	5: []int64{1092, 1227, 1198, 1351, 2006, 529, 356, 461, 353, 508, 352, 354, 418, 546, 477, 362, 521, 476, 472, 467,
		369, 363, 431, 383, 462, 367, 360, 372, 469, 509, 343, 534, 408, 402, 416, 353, 346, 445, 390, 461,
		353, 411, 357, 437, 690, 353, 508, 424, 482, 434, 339, 363, 479, 426, 430, 387, 342, 406, 1875, 1155,
		393, 520, 501, 373, 419, 381, 366, 466, 353, 465, 344, 378, 822, 463, 435, 380, 575, 460, 481, 428,
		342, 409, 444, 367, 427, 374, 386, 366, 982, 485, 364, 584, 411, 372, 568, 374, 341, 454, 345, 445,
	},
	14: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	65622: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	65628: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	65537: []int64{5407, 5407, 5407, 5407, 5411, 5407, 5407, 5407, 5407, 5410, 5407, 5407, 5407, 5407, 5410, 5407, 5407, 5407, 5407, 5407,
		5407, 5407, 5407, 5407, 5407, 5407, 5407, 5407, 5409, 5406, 5406, 5406, 5406, 5409, 5406, 5406, 5406, 5406, 5407, 5406,
		5406, 5406, 5406, 5406, 5406, 5406, 5406, 5409, 5406, 5406, 5406, 5406, 5411, 5406, 5406, 5406, 5406, 5408, 5406, 5406,
		5406, 5406, 5406, 5406, 5406, 5406, 5411, 5407, 5407, 5407, 5407, 5412, 5407, 5407, 5407, 5407, 5409, 5407, 5407, 5407,
		5407, 5407, 5407, 5407, 5407, 5407, 5407, 5407, 5407, 5407, 5409, 5407, 5407, 5407, 5407, 5411, 5407, 5407, 5407, 5407,
	},
	65643: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	65649: []int64{35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832,
		35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832,
		35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832,
		35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832,
		35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832, 35184372088832,
	},
	11: []int64{442, 507, 594, 440, 424, 313, 293, 343, 303, 291, 355, 295, 320, 387, 294, 337, 379, 376, 322, 354,
		304, 291, 320, 275, 295, 307, 327, 336, 316, 316, 327, 311, 310, 310, 279, 324, 311, 311, 310, 297,
		280, 279, 313, 325, 283, 316, 303, 305, 340, 324, 308, 342, 322, 292, 292, 287, 278, 332, 401, 322,
		341, 342, 318, 296, 319, 300, 309, 337, 290, 313, 301, 327, 343, 293, 309, 272, 342, 365, 353, 315,
		308, 317, 362, 266, 291, 334, 325, 319, 352, 302, 333, 362, 308, 302, 315, 320, 291, 325, 337, 340,
	},
	24: []int64{201, 234, 226, 256, 192, 156, 146, 161, 149, 153, 164, 147, 150, 169, 162, 154, 186, 161, 153, 162,
		154, 143, 157, 143, 158, 153, 155, 155, 154, 149, 149, 180, 136, 152, 149, 150, 152, 171, 153, 146,
		149, 147, 144, 148, 146, 150, 168, 141, 161, 153, 152, 161, 153, 148, 146, 143, 145, 162, 200, 161,
		151, 169, 143, 145, 149, 150, 148, 158, 159, 152, 156, 152, 154, 155, 149, 148, 168, 157, 159, 158,
		150, 152, 166, 143, 151, 155, 148, 146, 180, 154, 151, 171, 152, 148, 204, 149, 148, 153, 149, 159,
	},
	196620: []int64{527, 555, 283, 168, 82, 35, 43, 38, 26, 32, 28, 39, 25, 32, 29, 37, 37, 29, 36, 28,
		35, 30, 26, 30, 35, 29, 37, 33, 34, 37, 31, 26, 27, 35, 35, 30, 31, 35, 33, 25,
		21, 32, 35, 29, 31, 31, 34, 31, 26, 34, 31, 39, 27, 28, 47, 31, 34, 34, 35, 27,
		37, 26, 38, 38, 35, 31, 25, 36, 25, 32, 25, 38, 32, 33, 34, 29, 28, 25, 34, 27,
		36, 33, 36, 28, 31, 25, 32, 33, 27, 44, 32, 36, 24, 38, 33, 24, 37, 28, 41, 27,
	},
	65586: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	524295: []int64{1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 10, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
		1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	65639: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	720898: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	196613: []int64{12359, 13847, 11628, 12730, 13984, 5095, 4435, 8374, 4211, 5373, 4141, 4239, 4236, 4183, 4305, 5360, 7261, 5387, 4253, 4244,
		4291, 5295, 8625, 4227, 4310, 4256, 4233, 5376, 4226, 4323, 4232, 6436, 4482, 5155, 4311, 4271, 4243, 8395, 4262, 5290,
		4203, 4287, 4263, 4216, 4202, 5297, 6340, 4482, 4240, 4213, 4195, 5192, 8610, 4389, 4234, 4243, 4247, 5229, 4940, 4221,
		4192, 6390, 4424, 5325, 4357, 4193, 4315, 8399, 4195, 5331, 4307, 4246, 4339, 4309, 4229, 5336, 6628, 4303, 4215, 4213,
		4307, 5349, 8433, 4218, 4244, 4217, 4311, 5227, 4256, 4254, 4257, 7483, 4206, 5174, 4195, 4301, 4249, 8539, 4218, 5243,
	},
	1: []int64{2371, 2663, 2602, 2933, 4356, 1149, 773, 1002, 766, 1103, 764, 769, 908, 1187, 1035, 787, 1132, 1034, 1025, 1014,
		801, 789, 937, 832, 1004, 796, 783, 808, 1018, 1105, 745, 1161, 886, 874, 904, 766, 752, 967, 847, 1002,
		766, 893, 775, 950, 1499, 766, 1102, 920, 1047, 943, 737, 790, 1040, 926, 935, 840, 744, 883, 4070, 2508,
		853, 1129, 1088, 809, 909, 828, 795, 1012, 766, 1010, 748, 820, 1784, 1005, 944, 825, 1248, 1000, 1045, 929,
		743, 888, 965, 796, 927, 813, 838, 795, 2131, 1053, 790, 1269, 892, 807, 1233, 813, 742, 985, 749, 967,
	},
	720896: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	65577: []int64{30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618,
		30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618,
		30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618,
		30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618,
		30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618, 30618,
	},
	65620: []int64{4099524, 4103460, 4103460, 4061584, 4060116, 4060116, 3619708, 3618888, 3618952, 3451144, 3449868, 3449868, 3428896, 3427548, 3427484, 3196796, 3282432, 3386808, 3386872, 3387748,
		3387748, 3387748, 3386764, 3386764, 3764188, 3807412, 3807416, 3807480, 3804732, 3804320, 3196012, 3196516, 3238524, 3448176, 3553120, 3553120, 3909636, 3908552, 3908488, 3195456,
		3279848, 3279912, 3384768, 3385708, 3385768, 3826108, 3825016, 3824952, 3237752, 3447144, 3447144, 3887608, 3888484, 3888484, 3720712, 3887992, 3888056, 3363704, 3363712, 3363712,
		3762236, 3763844, 3763780, 3679896, 3677584, 3677648, 3573272, 3573676, 3573676, 3363964, 3367864, 3367768, 3116140, 3280200, 3280200, 3175404, 3343112, 3343112, 3804488, 3805508,
		3805508, 3386012, 3279432, 3489148, 3489212, 3492460, 3492396, 3282680, 3533196, 3533260, 3533196, 3196276, 3196276, 3615704, 3744280, 3744216, 3534504, 3491528, 3596448, 3596448,
	},
	65633: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	196625: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	196615: []int64{608, 692, 553, 618, 611, 312, 287, 556, 280, 360, 281, 282, 282, 281, 282, 347, 459, 357, 282, 280,
		282, 346, 555, 282, 281, 281, 282, 348, 283, 282, 282, 399, 299, 345, 281, 282, 281, 556, 281, 348,
		282, 281, 281, 284, 280, 348, 398, 300, 283, 280, 283, 347, 557, 296, 280, 284, 282, 345, 287, 281,
		280, 399, 297, 347, 282, 280, 283, 556, 282, 347, 282, 281, 283, 283, 281, 349, 414, 282, 280, 283,
		282, 347, 555, 281, 282, 282, 281, 348, 281, 282, 282, 470, 282, 347, 280, 282, 281, 558, 280, 347,
	},
	65630: []int64{961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912,
		961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912,
		961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912,
		961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912,
		961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912, 961912,
	},
	65541: []int64{14892144, 14892144, 14892144, 14892144, 14892144, 14892144, 14892144, 14892144, 14892144, 14892148, 14892144, 14892132, 14892144, 14892144, 14892144, 14892144, 14892916, 14892208, 14892208, 14892208,
		14892196, 14892208, 14892208, 14892208, 14892196, 14892208, 14892208, 14892208, 14892208, 14890776, 14890304, 14890304, 14890304, 14890292, 14890304, 14890304, 14890304, 14890292, 14890304, 14890304,
		14890304, 14890304, 14890304, 14890304, 14890504, 14890304, 14890292, 14890304, 14890304, 14890304, 14890292, 14890304, 14890304, 14890304, 14890304, 14890304, 14890304, 14890304, 14890304, 14890292,
		14890304, 14890304, 14890304, 14890292, 14890304, 14890304, 14891100, 14893012, 14893012, 14893012, 14893012, 14892932, 14893000, 14893012, 14893012, 14893012, 14893000, 14893012, 14893012, 14893012,
		14893012, 14893012, 14893012, 14893012, 14893012, 14893000, 14893012, 14893012, 14893012, 14893012, 14893012, 14893012, 14893012, 14893012, 14893012, 14893012, 14893012, 14893012, 14893000, 14893012,
	},
	65647: []int64{268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268,
		268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268,
		268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268,
		268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268,
		268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268, 268,
	},
	131078: []int64{489, 365, 4041, 5640, 417, 114, 51, 51, 31, 388, 22, 19, 26, 83, 81, 28, 23, 48, 9, 68,
		22, 13, 156, 137, 94, 69, 83, 53, 88, 86, 31, 46, 36, 42, 52, 105, 103, 112, 124, 92,
		111, 183, 82, 87, 55, 60, 27, 29, 18, 30, 23, 32, 20, 31, 17, 38, 16, 15, 136, 104,
		34, 16, 37, 28, 45, 39, 23, 37, 46, 65, 187, 123, 551, 296, 134, 136, 86, 208, 128, 57,
		36, 18, 38, 25, 25, 43, 21, 16, 117, 91, 27, 51, 31, 13, 118, 23, 8, 18, 20, 10,
	},
	65632: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	65635: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	196609: []int64{1283, 1482, 1350, 1564, 1898, 633, 548, 966, 484, 607, 485, 501, 529, 486, 501, 595, 773, 571, 529, 484,
		487, 593, 965, 485, 528, 485, 486, 610, 487, 487, 529, 709, 509, 593, 484, 486, 528, 966, 485, 598,
		486, 485, 528, 488, 485, 596, 709, 511, 529, 485, 488, 594, 967, 500, 527, 488, 486, 593, 850, 485,
		526, 710, 508, 595, 487, 485, 530, 966, 486, 594, 486, 485, 530, 488, 485, 596, 730, 485, 526, 487,
		486, 594, 965, 485, 529, 486, 485, 595, 485, 487, 528, 791, 486, 594, 484, 486, 528, 967, 485, 593,
	},
	65582: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	26: []int64{1144, 1078, 1165, 1217, 1592, 1383, 1058, 480, 367, 409, 392, 381, 359, 415, 420, 435, 374, 462, 470, 503,
		416, 378, 368, 376, 396, 384, 374, 357, 381, 425, 411, 385, 421, 435, 450, 367, 358, 355, 362, 396,
		379, 391, 358, 367, 434, 465, 452, 436, 446, 477, 407, 369, 354, 390, 414, 413, 375, 358, 755, 1160,
		1158, 755, 437, 438, 454, 380, 367, 368, 367, 411, 388, 373, 493, 529, 564, 415, 384, 444, 486, 512,
		417, 368, 364, 380, 400, 384, 370, 349, 554, 587, 597, 394, 435, 430, 505, 427, 414, 346, 357, 398,
	},
	196616: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	65611: []int64{18083012, 18083020, 18082672, 18082320, 18096832, 18082492, 18082612, 18082524, 18082524, 18094536, 18082572, 18082408, 18082572, 18082524, 18091984, 18082412, 18083304, 18082412, 18082488, 18082560,
		18082556, 18082328, 18082328, 18082284, 18082288, 18082452, 18082412, 18082580, 18091268, 18081104, 18080724, 18080880, 18080836, 18088572, 18080924, 18080884, 18080764, 18080712, 18084604, 18080908,
		18080908, 18080864, 18080828, 18080828, 18081120, 18080800, 18080680, 18090892, 18080764, 18080764, 18080556, 18080876, 18095260, 18080768, 18080844, 18080848, 18080800, 18085776, 18080908, 18080480,
		18080556, 18080468, 18080424, 18080408, 18080532, 18080488, 18097776, 18083388, 18083248, 18083168, 18083548, 18099296, 18083164, 18083484, 18083440, 18083264, 18089172, 18083424, 18083264, 18083420,
		18083376, 18083632, 18083432, 18083388, 18083420, 18083300, 18083420, 18083340, 18083400, 18083356, 18091760, 18083240, 18083196, 18083212, 18083080, 18096856, 18083148, 18083208, 18083116, 18083196,
	},
	65557: []int64{26247692, 26247660, 26247884, 26247936, 26247912, 26247896, 26247884, 26248064, 26248056, 26247924, 26247980, 26248084, 26247812, 26247964, 26247916, 26247912, 26247996, 26248112, 26248032, 26248068,
		26248188, 26248088, 26247940, 26248096, 26248200, 26248040, 26248044, 26248052, 26248092, 26248084, 26248036, 26248056, 26248096, 26248080, 26248056, 26248052, 26248104, 26248164, 26248020, 26247996,
		26248016, 26248084, 26247964, 26247956, 26247908, 26247840, 26247932, 26247888, 26247920, 26247812, 26247900, 26247864, 26247840, 26247900, 26247916, 26247768, 26247876, 26247864, 26247660, 26248168,
		26248068, 26248104, 26248184, 26248232, 26248032, 26248144, 26247996, 26248160, 26248172, 26248112, 26248140, 26248100, 26248176, 26248064, 26248072, 26248076, 26248100, 26248084, 26248156, 26248076,
		26248180, 26248100, 26248064, 26248184, 26248076, 26248112, 26248100, 26248164, 26248012, 26248072, 26248100, 26247996, 26248064, 26248116, 26248068, 26248112, 26248084, 26248016, 26248144, 26248148,
	},
	327695: []int64{160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160,
		160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160,
		160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160,
		160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160,
		160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160,
	},
	27: []int64{0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	327690: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	65561: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	327685: []int64{2400, 2500, 2800, 3000, 3500, 3600, 3600, 3600, 3500, 3500, 3500, 3500, 3500, 3400, 3200, 3000, 2800, 2600, 2400, 1900,
		1800, 1800, 1800, 1800, 1800, 1800, 1800, 1800, 1800, 1800, 1800, 1800, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700,
		1700, 1700, 1700, 1700, 1700, 1800, 1700, 1700, 1800, 1800, 1800, 1800, 1800, 1800, 1800, 1800, 1800, 1800, 2100, 2400,
		2400, 2400, 2400, 2400, 2400, 2400, 2400, 2400, 2300, 2400, 2300, 2300, 2500, 2200, 1900, 1800, 1800, 1800, 1900, 1900,
		1900, 1900, 1900, 1900, 1900, 1900, 1900, 1700, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900,
	},
	23: []int64{114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114,
		114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114,
		114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114,
		114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114,
		114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114,
	},
	327680: []int64{5200, 4900, 5300, 5600, 7200, 6200, 4800, 2300, 1800, 2000, 1900, 1800, 1700, 2000, 2000, 2100, 1800, 2200, 2300, 2400,
		2000, 1800, 1800, 1800, 1900, 1900, 1800, 1700, 1800, 2000, 2000, 1800, 2000, 2100, 2100, 1800, 1700, 1700, 1800, 1900,
		1800, 1900, 1700, 1800, 2100, 2200, 2100, 2100, 2100, 2200, 1900, 1800, 1700, 1900, 2000, 2000, 1800, 1700, 3500, 5200,
		5200, 3400, 2100, 2100, 2200, 1800, 1800, 1800, 1800, 2000, 1800, 1800, 2300, 2500, 2600, 2000, 1800, 2100, 2300, 2400,
		2000, 1800, 1800, 1800, 1900, 1800, 1800, 1700, 2600, 2700, 2800, 1900, 2100, 2100, 2400, 2000, 2000, 1700, 1700, 1900,
	},
	327682: []int64{4800, 4500, 4900, 5100, 6700, 5800, 4500, 2100, 1600, 1800, 1700, 1600, 1600, 1800, 1900, 1900, 1600, 2000, 2100, 2200,
		1800, 1600, 1600, 1700, 1800, 1700, 1600, 1500, 1600, 1800, 1800, 1700, 1800, 1800, 1900, 1600, 1600, 1600, 1600, 1800,
		1700, 1700, 1600, 1600, 1900, 2000, 2000, 1900, 2000, 2100, 1800, 1600, 1600, 1700, 1800, 1800, 1600, 1500, 3200, 4900,
		4900, 3200, 1900, 1900, 2000, 1700, 1600, 1600, 1600, 1800, 1700, 1600, 2200, 2300, 2400, 1800, 1600, 1900, 2100, 2200,
		1800, 1600, 1600, 1700, 1700, 1700, 1600, 1500, 2400, 2500, 2600, 1700, 1900, 1900, 2200, 1800, 1800, 1500, 1600, 1700,
	},
	13: []int64{30507, 29370, 29577, 28286, 22549, 35395, 36907, 35994, 36930, 35587, 36940, 36931, 36357, 35252, 35857, 36852, 35470, 35858, 35896, 35942,
		36795, 36838, 36254, 36675, 35972, 36812, 36872, 36765, 35918, 35578, 37015, 35361, 36446, 36500, 36382, 36939, 36991, 36129, 36612, 35981,
		36941, 36419, 36901, 36198, 34003, 36927, 35597, 36310, 35809, 36222, 37054, 36835, 35841, 36294, 36256, 36635, 37025, 36485, 23728, 29935,
		36589, 35483, 35638, 36758, 36361, 36690, 36815, 35951, 36933, 35958, 37004, 36727, 32864, 35963, 36220, 36703, 35029, 35973, 35809, 36283,
		37029, 36442, 36143, 36809, 36288, 36751, 36645, 36831, 31459, 35776, 36844, 34924, 36427, 36770, 35067, 36742, 37038, 36052, 37007, 36133,
	},
	327696: []int64{6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000,
		6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000,
		6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000,
		6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000,
		6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000, 6000,
	},
	327684: []int64{5000, 5300, 5500, 5600, 8100, 8100, 8100, 8100, 8100, 8100, 8100, 8100, 8100, 6600, 6600, 6600, 6600, 6300, 5000, 3000,
		3000, 3000, 3000, 3000, 3000, 3000, 3000, 3000, 3000, 3100, 3000, 3000, 3000, 2800, 2800, 2800, 2800, 2800, 2800, 2800,
		2800, 2800, 2800, 2600, 2600, 2800, 2800, 2800, 2800, 2800, 2800, 2800, 2800, 2800, 2800, 2800, 2800, 2800, 3600, 4800,
		4800, 4800, 5200, 5200, 5200, 5200, 5200, 5200, 5200, 5200, 5200, 5200, 7100, 3300, 2900, 2900, 2900, 2900, 2900, 2900,
		2900, 2900, 2900, 2900, 2900, 2900, 2900, 2800, 2900, 2900, 2900, 2900, 2900, 2800, 3100, 3100, 3100, 3100, 3100, 3100,
	},
	327691: []int64{4900, 4900, 5000, 5200, 7700, 7700, 7700, 7700, 7700, 7700, 7700, 7700, 7700, 6000, 6000, 6000, 6000, 5700, 4800, 2900,
		2800, 2800, 2900, 2900, 2900, 2900, 2900, 2900, 2900, 2900, 2900, 2900, 2900, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
		2600, 2600, 2600, 2500, 2500, 2600, 2600, 2600, 2700, 2700, 2700, 2700, 2700, 2700, 2700, 2700, 2700, 2700, 3300, 4600,
		4600, 4600, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 6800, 3100, 2700, 2700, 2700, 2700, 2700, 2700,
		2700, 2700, 2700, 2700, 2700, 2700, 2700, 2600, 2700, 2800, 2800, 2800, 2800, 2600, 2900, 2900, 2900, 2900, 2900, 2900,
	},
	327692: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	65549: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	10: []int64{70023, 69041, 68994, 67423, 61621, 74879, 76270, 75520, 76292, 75277, 76212, 76328, 75767, 74735, 75448, 76202, 74760, 75242, 75240, 75507,
		76158, 76286, 75747, 76105, 75603, 76122, 76222, 76086, 75538, 75135, 76414, 74674, 75772, 76192, 75750, 76329, 76346, 75522, 76299, 75414,
		76309, 75807, 76331, 76055, 73442, 76254, 74847, 75925, 75240, 75555, 76395, 76106, 75712, 75715, 75632, 76070, 76416, 76057, 62685, 69153,
		75966, 74759, 75466, 76168, 75749, 76032, 76373, 75576, 76225, 75289, 76308, 76384, 72178, 75402, 75594, 76098, 74719, 75249, 75086, 75570,
		76411, 76151, 75617, 76196, 75625, 76105, 76373, 76233, 70604, 75121, 76386, 74489, 75778, 76169, 73856, 76442, 76439, 75576, 76432, 75432,
	},
	196623: []int64{0, 5, 4, 5, 2, 0, 1, 4, 3, 0, 0, 0, 0, 4, 3, 0, 0, 0, 0, 4,
		2, 0, 0, 0, 4, 6, 2, 3, 8, 0, 0, 4, 0, 3, 0, 0, 0, 4, 0, 3,
		0, 0, 0, 4, 0, 2, 7, 1, 0, 5, 0, 1, 2, 0, 0, 4, 0, 0, 10, 0,
		0, 4, 0, 0, 3, 0, 0, 9, 1, 1, 4, 0, 0, 4, 0, 0, 1, 1, 0, 4,
		0, 0, 0, 3, 0, 4, 0, 0, 3, 5, 1, 4, 1, 0, 0, 2, 1, 4, 0, 0,
	},
	65646: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	262144: []int64{2953795, 2953815, 2953835, 2953855, 2953875, 2953895, 2953915, 2953935, 2953955, 2953975, 2953995, 2954015, 2954035, 2954055, 2954075, 2954095, 2954115, 2954135, 2954155, 2954175,
		2954195, 2954215, 2954235, 2954255, 2954275, 2954295, 2954315, 2954335, 2954355, 2954375, 2954395, 2954415, 2954435, 2954455, 2954475, 2954495, 2954515, 2954535, 2954555, 2954575,
		2954595, 2954615, 2954635, 2954655, 2954675, 2954695, 2954715, 2954735, 2954755, 2954775, 2954795, 2954815, 2954835, 2954855, 2954875, 2954895, 2954915, 2954935, 2954955, 2954975,
		2954995, 2955015, 2955035, 2955055, 2955075, 2955095, 2955115, 2955135, 2955155, 2955175, 2955195, 2955215, 2955235, 2955255, 2955275, 2955295, 2955315, 2955335, 2955355, 2955375,
		2955395, 2955415, 2955435, 2955455, 2955475, 2955495, 2955515, 2955535, 2955555, 2955575, 2955595, 2955615, 2955635, 2955655, 2955675, 2955695, 2955715, 2955735, 2955755, 2955775,
	},
	8: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	131079: []int64{807, 777, 1425, 1861, 991, 291, 217, 255, 197, 198, 231, 200, 611, 546, 162, 101, 143, 145, 102, 168,
		126, 113, 166, 213, 189, 245, 205, 206, 1023, 228, 170, 242, 219, 193, 245, 207, 196, 236, 209, 212,
		252, 710, 180, 253, 167, 124, 108, 171, 117, 122, 152, 112, 98, 156, 107, 127, 156, 100, 3353, 2054,
		129, 119, 173, 110, 130, 163, 90, 131, 247, 198, 244, 191, 398, 575, 209, 230, 234, 218, 203, 224,
		251, 188, 199, 233, 185, 250, 199, 186, 2582, 315, 176, 231, 266, 201, 256, 244, 190, 111, 158, 106,
	},
	131073: []int64{1296, 1143, 5467, 7501, 1409, 406, 269, 306, 228, 587, 254, 220, 638, 630, 243, 130, 167, 194, 111, 237,
		148, 126, 323, 350, 283, 315, 288, 259, 1112, 315, 202, 288, 255, 236, 298, 312, 299, 348, 334, 305,
		364, 894, 263, 340, 222, 184, 136, 200, 136, 153, 175, 144, 119, 187, 124, 166, 172, 116, 3489, 2158,
		163, 135, 210, 138, 175, 203, 114, 168, 293, 263, 431, 315, 949, 871, 343, 366, 321, 427, 331, 281,
		287, 206, 237, 258, 211, 294, 221, 203, 2699, 406, 203, 283, 297, 215, 374, 267, 199, 129, 179, 116,
	},
	65589: []int64{131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131,
		131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131,
		131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131,
		131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131,
		131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 131,
	},
	65625: []int64{25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763,
		25763, 25763, 25763, 25763, 25764, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763,
		25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763,
		25763, 25763, 25763, 25764, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763,
		25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763, 25763,
	},
	196612: []int64{16073, 18141, 16872, 19194, 25039, 6049, 4761, 7618, 3957, 4738, 3863, 4232, 4595, 3991, 4294, 4812, 7141, 4722, 4705, 3940,
		4134, 4807, 7470, 3830, 4575, 3872, 3968, 5070, 3991, 4036, 4699, 6582, 4164, 4810, 3901, 3809, 4601, 7575, 4003, 4657,
		4015, 4071, 4631, 3860, 4051, 4897, 6622, 4210, 4588, 4105, 4011, 4776, 7653, 3964, 4498, 4075, 4043, 4714, 9240, 3980,
		4452, 6584, 4162, 4865, 3995, 3999, 4528, 7621, 3956, 4759, 3999, 4062, 4604, 4019, 3924, 4620, 6589, 3762, 4330, 3922,
		3887, 4735, 7568, 3912, 4638, 3918, 3941, 4691, 3897, 4093, 4584, 7166, 3790, 4669, 3988, 3857, 4563, 7553, 3992, 4641,
	},
	196619: []int64{608, 692, 553, 618, 611, 312, 287, 556, 280, 360, 281, 282, 282, 281, 282, 347, 459, 357, 282, 280,
		282, 346, 555, 282, 281, 281, 282, 348, 283, 282, 282, 399, 299, 345, 281, 282, 281, 556, 281, 348,
		282, 281, 281, 284, 280, 348, 398, 300, 283, 280, 283, 347, 557, 296, 280, 284, 282, 345, 287, 281,
		280, 399, 297, 347, 282, 280, 283, 556, 282, 347, 282, 281, 283, 283, 281, 349, 414, 282, 280, 283,
		282, 347, 555, 281, 282, 282, 281, 348, 281, 282, 282, 470, 282, 347, 280, 282, 281, 558, 280, 347,
	},
	196622: []int64{65, 61, 48, 47, 49, 52, 55, 36, 53, 43, 38, 36, 60, 53, 67, 50, 53, 59, 58, 39,
		70, 71, 48, 62, 86, 46, 47, 71, 40, 44, 62, 42, 37, 77, 57, 39, 53, 45, 48, 72,
		40, 49, 82, 55, 45, 78, 69, 55, 65, 58, 91, 59, 67, 45, 67, 51, 50, 46, 57, 48,
		54, 41, 40, 47, 71, 39, 53, 39, 46, 52, 55, 41, 51, 61, 38, 51, 60, 53, 54, 37,
		37, 43, 42, 53, 62, 40, 40, 43, 48, 55, 51, 52, 39, 43, 40, 76, 52, 38, 62, 44,
	},
	65603: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	196626: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	327689: []int64{8200, 5600, 9100, 9100, 12000, 12000, 12000, 5700, 2700, 2800, 2800, 2800, 2000, 3600, 3600, 3600, 3000, 4800, 4800, 4800,
		2900, 2600, 2900, 2900, 2900, 2400, 2400, 2200, 2900, 3400, 3400, 3400, 4800, 4800, 4800, 2600, 2600, 2700, 2700, 2700,
		2500, 2500, 2300, 2300, 4800, 4800, 4800, 4600, 4600, 4600, 2700, 2500, 2900, 2900, 2900, 2600, 2300, 2200, 11900, 11900,
		11900, 11300, 5000, 5000, 5000, 2600, 2600, 3100, 3100, 3100, 2700, 2700, 8200, 8200, 8200, 2700, 2700, 4700, 4700, 4700,
		2800, 2600, 2900, 2900, 2900, 2600, 2600, 2200, 9900, 9900, 9900, 2900, 4700, 4700, 5100, 5100, 5100, 3000, 3000, 3000,
	},
	16: []int64{1450, 1649, 1581, 1756, 2475, 782, 586, 716, 585, 756, 591, 582, 652, 816, 737, 597, 810, 731, 710, 720,
		604, 594, 686, 614, 715, 606, 595, 611, 711, 756, 571, 803, 651, 642, 653, 580, 580, 710, 629, 698,
		583, 647, 579, 673, 943, 586, 781, 651, 736, 674, 570, 603, 731, 667, 669, 612, 570, 676, 2294, 1460,
		626, 790, 736, 602, 651, 614, 597, 722, 596, 709, 580, 620, 1087, 713, 672, 611, 846, 704, 728, 672,
		572, 647, 693, 602, 666, 605, 615, 599, 1292, 736, 596, 864, 650, 605, 889, 610, 569, 703, 571, 688,
	},
	196624: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	65573: []int64{14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336,
		14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336,
		14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336,
		14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336,
		14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336, 14336,
	},
	458759: []int64{1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 10, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
		1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	327681: []int64{8600, 6200, 9900, 9900, 12600, 12600, 12600, 6300, 2900, 3000, 3000, 3000, 2200, 3800, 3800, 3800, 3200, 5000, 5000, 5000,
		3000, 2800, 3200, 3200, 3200, 2600, 2600, 2400, 3100, 3600, 3600, 3600, 5300, 5300, 5300, 2800, 2800, 2900, 2900, 2900,
		2600, 2600, 2400, 2400, 4900, 4900, 4900, 4800, 4800, 4800, 2800, 2700, 3100, 3100, 3100, 2800, 2400, 2500, 12200, 12200,
		12200, 12000, 5200, 5200, 5200, 2700, 2700, 3300, 3300, 3300, 2900, 2900, 8400, 8400, 8400, 2900, 2900, 5000, 5000, 5000,
		2900, 2800, 3400, 3400, 3400, 2800, 2800, 2400, 10300, 10300, 10300, 3100, 4900, 4900, 5600, 5600, 5600, 3300, 3300, 3300,
	},
	131095: []int64{1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 15, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
		1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	65650: []int64{5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
		5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
		5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
		5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
		5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
	},
	65615: []int64{1747308, 1747308, 1746928, 1746884, 1746996, 1746840, 1746928, 1746840, 1746840, 1747020, 1746840, 1746704, 1746884, 1746840, 1746840, 1746884, 1746976, 1746708, 1746752, 1746752,
		1746708, 1746752, 1746752, 1746708, 1746616, 1746752, 1746708, 1746752, 1746752, 1746708, 1746752, 1746796, 1746752, 1746796, 1746796, 1746752, 1746796, 1746660, 1746752, 1746796,
		1746796, 1746752, 1746796, 1746796, 1746884, 1746928, 1746836, 1746928, 1746972, 1746972, 1746792, 1746972, 1746972, 1746928, 1746972, 1746972, 1746928, 1746972, 1746972, 1746572,
		1746752, 1746708, 1746664, 1746664, 1746708, 1746664, 1746912, 1746708, 1746664, 1746664, 1746708, 1746664, 1746528, 1746708, 1746664, 1746664, 1746752, 1746708, 1746708, 1746752,
		1746708, 1746708, 1746752, 1746708, 1746708, 1746616, 1746708, 1746708, 1746752, 1746708, 1746708, 1746752, 1746708, 1746708, 1746752, 1746708, 1746708, 1746752, 1746616, 1746708,
	},
	327694: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	327683: []int64{2600, 2800, 3000, 3200, 3800, 3900, 3900, 3900, 3800, 3800, 3800, 3800, 3900, 3600, 3400, 3200, 3000, 2800, 2600, 2100,
		2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 1900, 2000, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900,
		1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 2000, 1900, 2000, 1900, 1900, 2300, 2600,
		2600, 2600, 2600, 2600, 2500, 2600, 2600, 2600, 2500, 2500, 2500, 2500, 2700, 2300, 2000, 2000, 2000, 2000, 2100, 2100,
		2100, 2100, 2100, 2100, 2100, 2100, 2100, 1900, 2100, 2100, 2100, 2100, 2100, 2000, 2100, 2100, 2100, 2100, 2100, 2100,
	},
	327693: []int64{10000, 6800, 5200, 4900, 4900, 4900, 4900, 4900, 4900, 4900, 4900, 4900, 4900, 4900, 4700, 4700, 4700, 4700, 4700, 4700,
		4700, 4700, 4700, 4700, 4700, 4700, 4700, 4700, 4700, 4700, 4700, 4700, 4700, 4700, 4700, 4700, 4700, 4700, 4700, 4700,
		4700, 4700, 4700, 4500, 4400, 4200, 3600, 3300, 2900, 2700, 2700, 2700, 2700, 2700, 2600, 2600, 2600, 2600, 2700, 2900,
		2900, 2900, 2900, 2900, 2900, 2900, 2900, 2900, 2900, 2900, 2900, 2900, 2900, 2900, 2700, 2700, 2700, 2700, 2800, 2800,
		2800, 2800, 2900, 2900, 2900, 2900, 2900, 2900, 2900, 2900, 2900, 2900, 2900, 2900, 2900, 2900, 2900, 2900, 2900, 2900,
	},
	12: []int64{9486, 10654, 10409, 11735, 17425, 4598, 3092, 4011, 3066, 4413, 3059, 3076, 3635, 4749, 4143, 3150, 4531, 4138, 4101, 4058,
		3206, 3159, 3748, 3332, 4018, 3188, 3132, 3236, 4073, 4423, 2984, 4644, 3548, 3498, 3617, 3065, 3011, 3870, 3391, 4010,
		3066, 3575, 3102, 3801, 5998, 3066, 4411, 3683, 4191, 3775, 2950, 3160, 4163, 3706, 3741, 3364, 2977, 3533, 16280, 10036,
		3415, 4519, 4354, 3240, 3639, 3314, 3183, 4051, 3065, 4041, 2994, 3283, 7138, 4024, 3780, 3302, 4995, 4000, 4182, 3719,
		2974, 3554, 3863, 3186, 3710, 3254, 3354, 3184, 8526, 4216, 3161, 5076, 3568, 3231, 4932, 3254, 2968, 3942, 2997, 3871,
	},
	327687: []int64{10200, 7100, 5600, 5300, 5300, 5500, 5500, 5500, 5500, 5500, 5500, 5500, 5500, 5200, 4900, 4900, 4900, 5000, 5000, 5000,
		5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000, 5000,
		5000, 5000, 5000, 4800, 4800, 4700, 3800, 3600, 3000, 2900, 2800, 2800, 2800, 2800, 2800, 2800, 2800, 2800, 2900, 3100,
		3100, 3100, 3100, 3100, 3100, 3100, 3100, 3100, 3100, 3100, 3100, 3100, 3100, 3100, 2900, 2900, 2900, 2900, 2900, 2900,
		2900, 2900, 3100, 3100, 3100, 3100, 3100, 3100, 3100, 3100, 3100, 3100, 3100, 3100, 3100, 3100, 3100, 3100, 3100, 3100,
	},
	65619: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	32: []int64{55, 63, 74, 55, 53, 39, 36, 42, 37, 36, 44, 36, 40, 48, 36, 42, 47, 47, 40, 44,
		38, 36, 40, 34, 36, 38, 40, 42, 39, 39, 40, 38, 38, 38, 34, 40, 38, 38, 38, 37,
		35, 34, 39, 40, 35, 39, 37, 38, 42, 40, 38, 42, 40, 36, 36, 35, 34, 41, 50, 40,
		42, 42, 39, 37, 39, 37, 38, 42, 36, 39, 37, 40, 42, 36, 38, 34, 42, 45, 44, 39,
		38, 39, 45, 33, 36, 41, 40, 39, 44, 37, 41, 45, 38, 37, 39, 40, 36, 40, 42, 42,
	},
	196618: []int64{674, 789, 796, 945, 1287, 321, 261, 410, 203, 247, 203, 218, 246, 204, 219, 247, 314, 214, 247, 203,
		204, 247, 409, 203, 246, 203, 204, 262, 204, 204, 246, 310, 210, 247, 203, 203, 246, 409, 204, 250,
		204, 204, 246, 204, 204, 247, 310, 211, 246, 204, 204, 247, 410, 204, 246, 204, 204, 247, 563, 204,
		246, 310, 210, 247, 204, 204, 246, 409, 204, 247, 204, 204, 246, 204, 204, 247, 316, 203, 246, 203,
		203, 247, 409, 204, 246, 203, 203, 247, 204, 204, 246, 320, 203, 247, 204, 203, 247, 409, 204, 246,
	},
	196614: []int64{674, 789, 796, 945, 1287, 321, 261, 410, 203, 247, 203, 218, 246, 204, 219, 247, 314, 214, 247, 203,
		204, 247, 409, 203, 246, 203, 204, 262, 204, 204, 246, 310, 210, 247, 203, 203, 246, 409, 204, 250,
		204, 204, 246, 204, 204, 247, 310, 211, 246, 204, 204, 247, 410, 204, 246, 204, 204, 247, 563, 204,
		246, 310, 210, 247, 204, 204, 246, 409, 204, 247, 204, 204, 246, 204, 204, 247, 316, 203, 246, 203,
		203, 247, 409, 204, 246, 203, 203, 247, 204, 204, 246, 320, 203, 247, 204, 203, 247, 409, 204, 246,
	},
	20: []int64{2651, 2993, 2857, 3209, 4556, 1453, 1097, 1315, 1091, 1417, 1095, 1082, 1225, 1503, 1371, 1105, 1499, 1360, 1335, 1345,
		1119, 1109, 1261, 1150, 1332, 1129, 1105, 1138, 1324, 1407, 1063, 1485, 1207, 1186, 1221, 1078, 1082, 1317, 1174, 1316,
		1090, 1213, 1084, 1259, 1786, 1093, 1448, 1209, 1372, 1262, 1070, 1118, 1359, 1244, 1247, 1152, 1066, 1215, 4266, 2733,
		1167, 1466, 1366, 1122, 1225, 1146, 1113, 1333, 1104, 1325, 1076, 1151, 2059, 1314, 1256, 1142, 1566, 1299, 1363, 1257,
		1063, 1205, 1289, 1123, 1250, 1128, 1155, 1119, 2410, 1370, 1113, 1592, 1193, 1122, 1559, 1138, 1063, 1292, 1069, 1281,
	},
	327686: []int64{3200, 3000, 2900, 2700, 2700, 2800, 2800, 2800, 2800, 2800, 2800, 2800, 2800, 2700, 2600, 2600, 2600, 2600, 2600, 2600,
		2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600, 2600,
		2600, 2600, 2600, 2500, 2400, 2400, 2300, 2200, 2100, 2000, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 1900, 2000, 2100,
		2100, 2100, 2100, 2100, 2100, 2100, 2100, 2100, 2100, 2100, 2100, 2100, 2200, 2200, 2200, 2200, 2200, 2200, 2200, 2200,
		2200, 2200, 2200, 2200, 2200, 2200, 2200, 2200, 2200, 2200, 2200, 2200, 2200, 2200, 2200, 2200, 2200, 2200, 2200, 2200,
	},
}

var ResourcePoolMetricData = map[int32][]int64{
	65586: []int64{100088, 100088, 100088, 100120, 100136, 100136, 100088, 100088, 100088, 99928, 100040, 100040, 100072, 100184, 100184, 99912, 99912, 99912, 100040, 100040,
		100040, 100168, 100168, 100168, 100216, 100328, 100328, 100376, 100376, 100376, 100216, 100328, 100328, 100360, 100360, 100360, 100280, 100280, 100280, 100120,
		100120, 100120, 100040, 100040, 100040, 100152, 100184, 100088, 100120, 100120, 100120, 100056, 100184, 100184, 100104, 100008, 100008, 99960, 100072, 100072,
		100104, 100216, 100120, 100136, 100376, 100376, 100088, 100312, 100312, 100328, 100248, 100248, 100152, 100200, 100200, 100104, 100216, 100216, 100216, 100248,
		100248, 100056, 100184, 100184, 100184, 100024, 100024, 100024, 99864, 99864, 99976, 99992, 100104, 99912, 99944, 99944, 99752, 100008, 100008, 99912,
	},
	65582: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	65591: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	65545: []int64{4675424, 4674976, 4674976, 4423348, 4422168, 4422168, 4652808, 4652812, 4652812, 4484880, 4484988, 4484988, 4401132, 4401248, 4401248, 4421948, 4421944, 4421944, 4589848, 4673740,
		4715684, 4610952, 4610976, 4610976, 4233536, 4275568, 4317508, 4527272, 4527268, 4527268, 4904596, 4904704, 4904704, 4170736, 4170740, 4170740, 4506204, 4506196, 4506196, 4904496,
		4904508, 4904508, 4170424, 4170416, 4170416, 4799676, 4799708, 4799612, 4527008, 4568956, 4610900, 4610836, 4610956, 4610956, 4841560, 4841508, 4841508, 4841460, 4841536, 4841536,
		5323920, 5324036, 5323940, 5009380, 5009608, 5009608, 4589892, 4632056, 4632056, 4422356, 4590056, 4673940, 5156188, 5156236, 5156236, 4841568, 4422256, 4464200, 4359340, 4401308,
		4401308, 4401116, 4778724, 4778724, 4673868, 4212344, 4212344, 4841488, 5009132, 5009132, 4589816, 4505964, 4506076, 4715600, 4547796, 4547796, 4337888, 4338148, 4338148, 4233192,
	},
	65553: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	65541: []int64{14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240,
		14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240,
		14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240,
		14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240,
		14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240, 14712240,
	},
	65549: []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	},
	5: []int64{311, 393, 308, 427, 310, 310, 370, 475, 399, 319, 460, 422, 426, 389, 327, 315, 372, 336, 386, 326,
		316, 328, 391, 446, 296, 489, 366, 319, 372, 308, 302, 386, 304, 417, 309, 367, 311, 340, 646, 307,
		467, 357, 422, 391, 296, 324, 376, 378, 389, 342, 300, 328, 1836, 1120, 349, 471, 419, 327, 374, 338,
		300, 386, 312, 422, 304, 296, 783, 409, 389, 337, 486, 421, 438, 389, 293, 328, 381, 324, 387, 328,
		302, 323, 937, 437, 301, 503, 369, 327, 539, 295, 297, 392, 293, 403, 323, 341, 337, 506, 397, 318,
	},
}
