// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/alert"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/machine"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/predicate"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/schema"
)

// MachineUpdate is the builder for updating Machine entities.
type MachineUpdate struct {
	config
	hooks    []Hook
	mutation *MachineMutation
}

// Where appends a list predicates to the MachineUpdate builder.
func (mu *MachineUpdate) Where(ps ...predicate.Machine) *MachineUpdate {
	mu.mutation.Where(ps...)
	return mu
}

// SetUpdatedAt sets the "updated_at" field.
func (mu *MachineUpdate) SetUpdatedAt(t time.Time) *MachineUpdate {
	mu.mutation.SetUpdatedAt(t)
	return mu
}

// SetLastPush sets the "last_push" field.
func (mu *MachineUpdate) SetLastPush(t time.Time) *MachineUpdate {
	mu.mutation.SetLastPush(t)
	return mu
}

// SetNillableLastPush sets the "last_push" field if the given value is not nil.
func (mu *MachineUpdate) SetNillableLastPush(t *time.Time) *MachineUpdate {
	if t != nil {
		mu.SetLastPush(*t)
	}
	return mu
}

// ClearLastPush clears the value of the "last_push" field.
func (mu *MachineUpdate) ClearLastPush() *MachineUpdate {
	mu.mutation.ClearLastPush()
	return mu
}

// SetLastHeartbeat sets the "last_heartbeat" field.
func (mu *MachineUpdate) SetLastHeartbeat(t time.Time) *MachineUpdate {
	mu.mutation.SetLastHeartbeat(t)
	return mu
}

// SetNillableLastHeartbeat sets the "last_heartbeat" field if the given value is not nil.
func (mu *MachineUpdate) SetNillableLastHeartbeat(t *time.Time) *MachineUpdate {
	if t != nil {
		mu.SetLastHeartbeat(*t)
	}
	return mu
}

// ClearLastHeartbeat clears the value of the "last_heartbeat" field.
func (mu *MachineUpdate) ClearLastHeartbeat() *MachineUpdate {
	mu.mutation.ClearLastHeartbeat()
	return mu
}

// SetPassword sets the "password" field.
func (mu *MachineUpdate) SetPassword(s string) *MachineUpdate {
	mu.mutation.SetPassword(s)
	return mu
}

// SetNillablePassword sets the "password" field if the given value is not nil.
func (mu *MachineUpdate) SetNillablePassword(s *string) *MachineUpdate {
	if s != nil {
		mu.SetPassword(*s)
	}
	return mu
}

// SetIpAddress sets the "ipAddress" field.
func (mu *MachineUpdate) SetIpAddress(s string) *MachineUpdate {
	mu.mutation.SetIpAddress(s)
	return mu
}

// SetNillableIpAddress sets the "ipAddress" field if the given value is not nil.
func (mu *MachineUpdate) SetNillableIpAddress(s *string) *MachineUpdate {
	if s != nil {
		mu.SetIpAddress(*s)
	}
	return mu
}

// SetScenarios sets the "scenarios" field.
func (mu *MachineUpdate) SetScenarios(s string) *MachineUpdate {
	mu.mutation.SetScenarios(s)
	return mu
}

// SetNillableScenarios sets the "scenarios" field if the given value is not nil.
func (mu *MachineUpdate) SetNillableScenarios(s *string) *MachineUpdate {
	if s != nil {
		mu.SetScenarios(*s)
	}
	return mu
}

// ClearScenarios clears the value of the "scenarios" field.
func (mu *MachineUpdate) ClearScenarios() *MachineUpdate {
	mu.mutation.ClearScenarios()
	return mu
}

// SetVersion sets the "version" field.
func (mu *MachineUpdate) SetVersion(s string) *MachineUpdate {
	mu.mutation.SetVersion(s)
	return mu
}

// SetNillableVersion sets the "version" field if the given value is not nil.
func (mu *MachineUpdate) SetNillableVersion(s *string) *MachineUpdate {
	if s != nil {
		mu.SetVersion(*s)
	}
	return mu
}

// ClearVersion clears the value of the "version" field.
func (mu *MachineUpdate) ClearVersion() *MachineUpdate {
	mu.mutation.ClearVersion()
	return mu
}

// SetIsValidated sets the "isValidated" field.
func (mu *MachineUpdate) SetIsValidated(b bool) *MachineUpdate {
	mu.mutation.SetIsValidated(b)
	return mu
}

// SetNillableIsValidated sets the "isValidated" field if the given value is not nil.
func (mu *MachineUpdate) SetNillableIsValidated(b *bool) *MachineUpdate {
	if b != nil {
		mu.SetIsValidated(*b)
	}
	return mu
}

// SetAuthType sets the "auth_type" field.
func (mu *MachineUpdate) SetAuthType(s string) *MachineUpdate {
	mu.mutation.SetAuthType(s)
	return mu
}

// SetNillableAuthType sets the "auth_type" field if the given value is not nil.
func (mu *MachineUpdate) SetNillableAuthType(s *string) *MachineUpdate {
	if s != nil {
		mu.SetAuthType(*s)
	}
	return mu
}

// SetOsname sets the "osname" field.
func (mu *MachineUpdate) SetOsname(s string) *MachineUpdate {
	mu.mutation.SetOsname(s)
	return mu
}

// SetNillableOsname sets the "osname" field if the given value is not nil.
func (mu *MachineUpdate) SetNillableOsname(s *string) *MachineUpdate {
	if s != nil {
		mu.SetOsname(*s)
	}
	return mu
}

// ClearOsname clears the value of the "osname" field.
func (mu *MachineUpdate) ClearOsname() *MachineUpdate {
	mu.mutation.ClearOsname()
	return mu
}

// SetOsversion sets the "osversion" field.
func (mu *MachineUpdate) SetOsversion(s string) *MachineUpdate {
	mu.mutation.SetOsversion(s)
	return mu
}

// SetNillableOsversion sets the "osversion" field if the given value is not nil.
func (mu *MachineUpdate) SetNillableOsversion(s *string) *MachineUpdate {
	if s != nil {
		mu.SetOsversion(*s)
	}
	return mu
}

// ClearOsversion clears the value of the "osversion" field.
func (mu *MachineUpdate) ClearOsversion() *MachineUpdate {
	mu.mutation.ClearOsversion()
	return mu
}

// SetFeatureflags sets the "featureflags" field.
func (mu *MachineUpdate) SetFeatureflags(s string) *MachineUpdate {
	mu.mutation.SetFeatureflags(s)
	return mu
}

// SetNillableFeatureflags sets the "featureflags" field if the given value is not nil.
func (mu *MachineUpdate) SetNillableFeatureflags(s *string) *MachineUpdate {
	if s != nil {
		mu.SetFeatureflags(*s)
	}
	return mu
}

// ClearFeatureflags clears the value of the "featureflags" field.
func (mu *MachineUpdate) ClearFeatureflags() *MachineUpdate {
	mu.mutation.ClearFeatureflags()
	return mu
}

// SetHubstate sets the "hubstate" field.
func (mu *MachineUpdate) SetHubstate(ms map[string][]schema.ItemState) *MachineUpdate {
	mu.mutation.SetHubstate(ms)
	return mu
}

// ClearHubstate clears the value of the "hubstate" field.
func (mu *MachineUpdate) ClearHubstate() *MachineUpdate {
	mu.mutation.ClearHubstate()
	return mu
}

// SetDatasources sets the "datasources" field.
func (mu *MachineUpdate) SetDatasources(m map[string]int64) *MachineUpdate {
	mu.mutation.SetDatasources(m)
	return mu
}

// ClearDatasources clears the value of the "datasources" field.
func (mu *MachineUpdate) ClearDatasources() *MachineUpdate {
	mu.mutation.ClearDatasources()
	return mu
}

// AddAlertIDs adds the "alerts" edge to the Alert entity by IDs.
func (mu *MachineUpdate) AddAlertIDs(ids ...int) *MachineUpdate {
	mu.mutation.AddAlertIDs(ids...)
	return mu
}

// AddAlerts adds the "alerts" edges to the Alert entity.
func (mu *MachineUpdate) AddAlerts(a ...*Alert) *MachineUpdate {
	ids := make([]int, len(a))
	for i := range a {
		ids[i] = a[i].ID
	}
	return mu.AddAlertIDs(ids...)
}

// Mutation returns the MachineMutation object of the builder.
func (mu *MachineUpdate) Mutation() *MachineMutation {
	return mu.mutation
}

// ClearAlerts clears all "alerts" edges to the Alert entity.
func (mu *MachineUpdate) ClearAlerts() *MachineUpdate {
	mu.mutation.ClearAlerts()
	return mu
}

// RemoveAlertIDs removes the "alerts" edge to Alert entities by IDs.
func (mu *MachineUpdate) RemoveAlertIDs(ids ...int) *MachineUpdate {
	mu.mutation.RemoveAlertIDs(ids...)
	return mu
}

// RemoveAlerts removes "alerts" edges to Alert entities.
func (mu *MachineUpdate) RemoveAlerts(a ...*Alert) *MachineUpdate {
	ids := make([]int, len(a))
	for i := range a {
		ids[i] = a[i].ID
	}
	return mu.RemoveAlertIDs(ids...)
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (mu *MachineUpdate) Save(ctx context.Context) (int, error) {
	mu.defaults()
	return withHooks(ctx, mu.sqlSave, mu.mutation, mu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (mu *MachineUpdate) SaveX(ctx context.Context) int {
	affected, err := mu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (mu *MachineUpdate) Exec(ctx context.Context) error {
	_, err := mu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (mu *MachineUpdate) ExecX(ctx context.Context) {
	if err := mu.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (mu *MachineUpdate) defaults() {
	if _, ok := mu.mutation.UpdatedAt(); !ok {
		v := machine.UpdateDefaultUpdatedAt()
		mu.mutation.SetUpdatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (mu *MachineUpdate) check() error {
	if v, ok := mu.mutation.Scenarios(); ok {
		if err := machine.ScenariosValidator(v); err != nil {
			return &ValidationError{Name: "scenarios", err: fmt.Errorf(`ent: validator failed for field "Machine.scenarios": %w`, err)}
		}
	}
	return nil
}

func (mu *MachineUpdate) sqlSave(ctx context.Context) (n int, err error) {
	if err := mu.check(); err != nil {
		return n, err
	}
	_spec := sqlgraph.NewUpdateSpec(machine.Table, machine.Columns, sqlgraph.NewFieldSpec(machine.FieldID, field.TypeInt))
	if ps := mu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := mu.mutation.UpdatedAt(); ok {
		_spec.SetField(machine.FieldUpdatedAt, field.TypeTime, value)
	}
	if value, ok := mu.mutation.LastPush(); ok {
		_spec.SetField(machine.FieldLastPush, field.TypeTime, value)
	}
	if mu.mutation.LastPushCleared() {
		_spec.ClearField(machine.FieldLastPush, field.TypeTime)
	}
	if value, ok := mu.mutation.LastHeartbeat(); ok {
		_spec.SetField(machine.FieldLastHeartbeat, field.TypeTime, value)
	}
	if mu.mutation.LastHeartbeatCleared() {
		_spec.ClearField(machine.FieldLastHeartbeat, field.TypeTime)
	}
	if value, ok := mu.mutation.Password(); ok {
		_spec.SetField(machine.FieldPassword, field.TypeString, value)
	}
	if value, ok := mu.mutation.IpAddress(); ok {
		_spec.SetField(machine.FieldIpAddress, field.TypeString, value)
	}
	if value, ok := mu.mutation.Scenarios(); ok {
		_spec.SetField(machine.FieldScenarios, field.TypeString, value)
	}
	if mu.mutation.ScenariosCleared() {
		_spec.ClearField(machine.FieldScenarios, field.TypeString)
	}
	if value, ok := mu.mutation.Version(); ok {
		_spec.SetField(machine.FieldVersion, field.TypeString, value)
	}
	if mu.mutation.VersionCleared() {
		_spec.ClearField(machine.FieldVersion, field.TypeString)
	}
	if value, ok := mu.mutation.IsValidated(); ok {
		_spec.SetField(machine.FieldIsValidated, field.TypeBool, value)
	}
	if value, ok := mu.mutation.AuthType(); ok {
		_spec.SetField(machine.FieldAuthType, field.TypeString, value)
	}
	if value, ok := mu.mutation.Osname(); ok {
		_spec.SetField(machine.FieldOsname, field.TypeString, value)
	}
	if mu.mutation.OsnameCleared() {
		_spec.ClearField(machine.FieldOsname, field.TypeString)
	}
	if value, ok := mu.mutation.Osversion(); ok {
		_spec.SetField(machine.FieldOsversion, field.TypeString, value)
	}
	if mu.mutation.OsversionCleared() {
		_spec.ClearField(machine.FieldOsversion, field.TypeString)
	}
	if value, ok := mu.mutation.Featureflags(); ok {
		_spec.SetField(machine.FieldFeatureflags, field.TypeString, value)
	}
	if mu.mutation.FeatureflagsCleared() {
		_spec.ClearField(machine.FieldFeatureflags, field.TypeString)
	}
	if value, ok := mu.mutation.Hubstate(); ok {
		_spec.SetField(machine.FieldHubstate, field.TypeJSON, value)
	}
	if mu.mutation.HubstateCleared() {
		_spec.ClearField(machine.FieldHubstate, field.TypeJSON)
	}
	if value, ok := mu.mutation.Datasources(); ok {
		_spec.SetField(machine.FieldDatasources, field.TypeJSON, value)
	}
	if mu.mutation.DatasourcesCleared() {
		_spec.ClearField(machine.FieldDatasources, field.TypeJSON)
	}
	if mu.mutation.AlertsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   machine.AlertsTable,
			Columns: []string{machine.AlertsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(alert.FieldID, field.TypeInt),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := mu.mutation.RemovedAlertsIDs(); len(nodes) > 0 && !mu.mutation.AlertsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   machine.AlertsTable,
			Columns: []string{machine.AlertsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(alert.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := mu.mutation.AlertsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   machine.AlertsTable,
			Columns: []string{machine.AlertsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(alert.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if n, err = sqlgraph.UpdateNodes(ctx, mu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{machine.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	mu.mutation.done = true
	return n, nil
}

// MachineUpdateOne is the builder for updating a single Machine entity.
type MachineUpdateOne struct {
	config
	fields   []string
	hooks    []Hook
	mutation *MachineMutation
}

// SetUpdatedAt sets the "updated_at" field.
func (muo *MachineUpdateOne) SetUpdatedAt(t time.Time) *MachineUpdateOne {
	muo.mutation.SetUpdatedAt(t)
	return muo
}

// SetLastPush sets the "last_push" field.
func (muo *MachineUpdateOne) SetLastPush(t time.Time) *MachineUpdateOne {
	muo.mutation.SetLastPush(t)
	return muo
}

// SetNillableLastPush sets the "last_push" field if the given value is not nil.
func (muo *MachineUpdateOne) SetNillableLastPush(t *time.Time) *MachineUpdateOne {
	if t != nil {
		muo.SetLastPush(*t)
	}
	return muo
}

// ClearLastPush clears the value of the "last_push" field.
func (muo *MachineUpdateOne) ClearLastPush() *MachineUpdateOne {
	muo.mutation.ClearLastPush()
	return muo
}

// SetLastHeartbeat sets the "last_heartbeat" field.
func (muo *MachineUpdateOne) SetLastHeartbeat(t time.Time) *MachineUpdateOne {
	muo.mutation.SetLastHeartbeat(t)
	return muo
}

// SetNillableLastHeartbeat sets the "last_heartbeat" field if the given value is not nil.
func (muo *MachineUpdateOne) SetNillableLastHeartbeat(t *time.Time) *MachineUpdateOne {
	if t != nil {
		muo.SetLastHeartbeat(*t)
	}
	return muo
}

// ClearLastHeartbeat clears the value of the "last_heartbeat" field.
func (muo *MachineUpdateOne) ClearLastHeartbeat() *MachineUpdateOne {
	muo.mutation.ClearLastHeartbeat()
	return muo
}

// SetPassword sets the "password" field.
func (muo *MachineUpdateOne) SetPassword(s string) *MachineUpdateOne {
	muo.mutation.SetPassword(s)
	return muo
}

// SetNillablePassword sets the "password" field if the given value is not nil.
func (muo *MachineUpdateOne) SetNillablePassword(s *string) *MachineUpdateOne {
	if s != nil {
		muo.SetPassword(*s)
	}
	return muo
}

// SetIpAddress sets the "ipAddress" field.
func (muo *MachineUpdateOne) SetIpAddress(s string) *MachineUpdateOne {
	muo.mutation.SetIpAddress(s)
	return muo
}

// SetNillableIpAddress sets the "ipAddress" field if the given value is not nil.
func (muo *MachineUpdateOne) SetNillableIpAddress(s *string) *MachineUpdateOne {
	if s != nil {
		muo.SetIpAddress(*s)
	}
	return muo
}

// SetScenarios sets the "scenarios" field.
func (muo *MachineUpdateOne) SetScenarios(s string) *MachineUpdateOne {
	muo.mutation.SetScenarios(s)
	return muo
}

// SetNillableScenarios sets the "scenarios" field if the given value is not nil.
func (muo *MachineUpdateOne) SetNillableScenarios(s *string) *MachineUpdateOne {
	if s != nil {
		muo.SetScenarios(*s)
	}
	return muo
}

// ClearScenarios clears the value of the "scenarios" field.
func (muo *MachineUpdateOne) ClearScenarios() *MachineUpdateOne {
	muo.mutation.ClearScenarios()
	return muo
}

// SetVersion sets the "version" field.
func (muo *MachineUpdateOne) SetVersion(s string) *MachineUpdateOne {
	muo.mutation.SetVersion(s)
	return muo
}

// SetNillableVersion sets the "version" field if the given value is not nil.
func (muo *MachineUpdateOne) SetNillableVersion(s *string) *MachineUpdateOne {
	if s != nil {
		muo.SetVersion(*s)
	}
	return muo
}

// ClearVersion clears the value of the "version" field.
func (muo *MachineUpdateOne) ClearVersion() *MachineUpdateOne {
	muo.mutation.ClearVersion()
	return muo
}

// SetIsValidated sets the "isValidated" field.
func (muo *MachineUpdateOne) SetIsValidated(b bool) *MachineUpdateOne {
	muo.mutation.SetIsValidated(b)
	return muo
}

// SetNillableIsValidated sets the "isValidated" field if the given value is not nil.
func (muo *MachineUpdateOne) SetNillableIsValidated(b *bool) *MachineUpdateOne {
	if b != nil {
		muo.SetIsValidated(*b)
	}
	return muo
}

// SetAuthType sets the "auth_type" field.
func (muo *MachineUpdateOne) SetAuthType(s string) *MachineUpdateOne {
	muo.mutation.SetAuthType(s)
	return muo
}

// SetNillableAuthType sets the "auth_type" field if the given value is not nil.
func (muo *MachineUpdateOne) SetNillableAuthType(s *string) *MachineUpdateOne {
	if s != nil {
		muo.SetAuthType(*s)
	}
	return muo
}

// SetOsname sets the "osname" field.
func (muo *MachineUpdateOne) SetOsname(s string) *MachineUpdateOne {
	muo.mutation.SetOsname(s)
	return muo
}

// SetNillableOsname sets the "osname" field if the given value is not nil.
func (muo *MachineUpdateOne) SetNillableOsname(s *string) *MachineUpdateOne {
	if s != nil {
		muo.SetOsname(*s)
	}
	return muo
}

// ClearOsname clears the value of the "osname" field.
func (muo *MachineUpdateOne) ClearOsname() *MachineUpdateOne {
	muo.mutation.ClearOsname()
	return muo
}

// SetOsversion sets the "osversion" field.
func (muo *MachineUpdateOne) SetOsversion(s string) *MachineUpdateOne {
	muo.mutation.SetOsversion(s)
	return muo
}

// SetNillableOsversion sets the "osversion" field if the given value is not nil.
func (muo *MachineUpdateOne) SetNillableOsversion(s *string) *MachineUpdateOne {
	if s != nil {
		muo.SetOsversion(*s)
	}
	return muo
}

// ClearOsversion clears the value of the "osversion" field.
func (muo *MachineUpdateOne) ClearOsversion() *MachineUpdateOne {
	muo.mutation.ClearOsversion()
	return muo
}

// SetFeatureflags sets the "featureflags" field.
func (muo *MachineUpdateOne) SetFeatureflags(s string) *MachineUpdateOne {
	muo.mutation.SetFeatureflags(s)
	return muo
}

// SetNillableFeatureflags sets the "featureflags" field if the given value is not nil.
func (muo *MachineUpdateOne) SetNillableFeatureflags(s *string) *MachineUpdateOne {
	if s != nil {
		muo.SetFeatureflags(*s)
	}
	return muo
}

// ClearFeatureflags clears the value of the "featureflags" field.
func (muo *MachineUpdateOne) ClearFeatureflags() *MachineUpdateOne {
	muo.mutation.ClearFeatureflags()
	return muo
}

// SetHubstate sets the "hubstate" field.
func (muo *MachineUpdateOne) SetHubstate(ms map[string][]schema.ItemState) *MachineUpdateOne {
	muo.mutation.SetHubstate(ms)
	return muo
}

// ClearHubstate clears the value of the "hubstate" field.
func (muo *MachineUpdateOne) ClearHubstate() *MachineUpdateOne {
	muo.mutation.ClearHubstate()
	return muo
}

// SetDatasources sets the "datasources" field.
func (muo *MachineUpdateOne) SetDatasources(m map[string]int64) *MachineUpdateOne {
	muo.mutation.SetDatasources(m)
	return muo
}

// ClearDatasources clears the value of the "datasources" field.
func (muo *MachineUpdateOne) ClearDatasources() *MachineUpdateOne {
	muo.mutation.ClearDatasources()
	return muo
}

// AddAlertIDs adds the "alerts" edge to the Alert entity by IDs.
func (muo *MachineUpdateOne) AddAlertIDs(ids ...int) *MachineUpdateOne {
	muo.mutation.AddAlertIDs(ids...)
	return muo
}

// AddAlerts adds the "alerts" edges to the Alert entity.
func (muo *MachineUpdateOne) AddAlerts(a ...*Alert) *MachineUpdateOne {
	ids := make([]int, len(a))
	for i := range a {
		ids[i] = a[i].ID
	}
	return muo.AddAlertIDs(ids...)
}

// Mutation returns the MachineMutation object of the builder.
func (muo *MachineUpdateOne) Mutation() *MachineMutation {
	return muo.mutation
}

// ClearAlerts clears all "alerts" edges to the Alert entity.
func (muo *MachineUpdateOne) ClearAlerts() *MachineUpdateOne {
	muo.mutation.ClearAlerts()
	return muo
}

// RemoveAlertIDs removes the "alerts" edge to Alert entities by IDs.
func (muo *MachineUpdateOne) RemoveAlertIDs(ids ...int) *MachineUpdateOne {
	muo.mutation.RemoveAlertIDs(ids...)
	return muo
}

// RemoveAlerts removes "alerts" edges to Alert entities.
func (muo *MachineUpdateOne) RemoveAlerts(a ...*Alert) *MachineUpdateOne {
	ids := make([]int, len(a))
	for i := range a {
		ids[i] = a[i].ID
	}
	return muo.RemoveAlertIDs(ids...)
}

// Where appends a list predicates to the MachineUpdate builder.
func (muo *MachineUpdateOne) Where(ps ...predicate.Machine) *MachineUpdateOne {
	muo.mutation.Where(ps...)
	return muo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (muo *MachineUpdateOne) Select(field string, fields ...string) *MachineUpdateOne {
	muo.fields = append([]string{field}, fields...)
	return muo
}

// Save executes the query and returns the updated Machine entity.
func (muo *MachineUpdateOne) Save(ctx context.Context) (*Machine, error) {
	muo.defaults()
	return withHooks(ctx, muo.sqlSave, muo.mutation, muo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (muo *MachineUpdateOne) SaveX(ctx context.Context) *Machine {
	node, err := muo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (muo *MachineUpdateOne) Exec(ctx context.Context) error {
	_, err := muo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (muo *MachineUpdateOne) ExecX(ctx context.Context) {
	if err := muo.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (muo *MachineUpdateOne) defaults() {
	if _, ok := muo.mutation.UpdatedAt(); !ok {
		v := machine.UpdateDefaultUpdatedAt()
		muo.mutation.SetUpdatedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (muo *MachineUpdateOne) check() error {
	if v, ok := muo.mutation.Scenarios(); ok {
		if err := machine.ScenariosValidator(v); err != nil {
			return &ValidationError{Name: "scenarios", err: fmt.Errorf(`ent: validator failed for field "Machine.scenarios": %w`, err)}
		}
	}
	return nil
}

func (muo *MachineUpdateOne) sqlSave(ctx context.Context) (_node *Machine, err error) {
	if err := muo.check(); err != nil {
		return _node, err
	}
	_spec := sqlgraph.NewUpdateSpec(machine.Table, machine.Columns, sqlgraph.NewFieldSpec(machine.FieldID, field.TypeInt))
	id, ok := muo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`ent: missing "Machine.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := muo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, machine.FieldID)
		for _, f := range fields {
			if !machine.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("ent: invalid field %q for query", f)}
			}
			if f != machine.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := muo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := muo.mutation.UpdatedAt(); ok {
		_spec.SetField(machine.FieldUpdatedAt, field.TypeTime, value)
	}
	if value, ok := muo.mutation.LastPush(); ok {
		_spec.SetField(machine.FieldLastPush, field.TypeTime, value)
	}
	if muo.mutation.LastPushCleared() {
		_spec.ClearField(machine.FieldLastPush, field.TypeTime)
	}
	if value, ok := muo.mutation.LastHeartbeat(); ok {
		_spec.SetField(machine.FieldLastHeartbeat, field.TypeTime, value)
	}
	if muo.mutation.LastHeartbeatCleared() {
		_spec.ClearField(machine.FieldLastHeartbeat, field.TypeTime)
	}
	if value, ok := muo.mutation.Password(); ok {
		_spec.SetField(machine.FieldPassword, field.TypeString, value)
	}
	if value, ok := muo.mutation.IpAddress(); ok {
		_spec.SetField(machine.FieldIpAddress, field.TypeString, value)
	}
	if value, ok := muo.mutation.Scenarios(); ok {
		_spec.SetField(machine.FieldScenarios, field.TypeString, value)
	}
	if muo.mutation.ScenariosCleared() {
		_spec.ClearField(machine.FieldScenarios, field.TypeString)
	}
	if value, ok := muo.mutation.Version(); ok {
		_spec.SetField(machine.FieldVersion, field.TypeString, value)
	}
	if muo.mutation.VersionCleared() {
		_spec.ClearField(machine.FieldVersion, field.TypeString)
	}
	if value, ok := muo.mutation.IsValidated(); ok {
		_spec.SetField(machine.FieldIsValidated, field.TypeBool, value)
	}
	if value, ok := muo.mutation.AuthType(); ok {
		_spec.SetField(machine.FieldAuthType, field.TypeString, value)
	}
	if value, ok := muo.mutation.Osname(); ok {
		_spec.SetField(machine.FieldOsname, field.TypeString, value)
	}
	if muo.mutation.OsnameCleared() {
		_spec.ClearField(machine.FieldOsname, field.TypeString)
	}
	if value, ok := muo.mutation.Osversion(); ok {
		_spec.SetField(machine.FieldOsversion, field.TypeString, value)
	}
	if muo.mutation.OsversionCleared() {
		_spec.ClearField(machine.FieldOsversion, field.TypeString)
	}
	if value, ok := muo.mutation.Featureflags(); ok {
		_spec.SetField(machine.FieldFeatureflags, field.TypeString, value)
	}
	if muo.mutation.FeatureflagsCleared() {
		_spec.ClearField(machine.FieldFeatureflags, field.TypeString)
	}
	if value, ok := muo.mutation.Hubstate(); ok {
		_spec.SetField(machine.FieldHubstate, field.TypeJSON, value)
	}
	if muo.mutation.HubstateCleared() {
		_spec.ClearField(machine.FieldHubstate, field.TypeJSON)
	}
	if value, ok := muo.mutation.Datasources(); ok {
		_spec.SetField(machine.FieldDatasources, field.TypeJSON, value)
	}
	if muo.mutation.DatasourcesCleared() {
		_spec.ClearField(machine.FieldDatasources, field.TypeJSON)
	}
	if muo.mutation.AlertsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   machine.AlertsTable,
			Columns: []string{machine.AlertsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(alert.FieldID, field.TypeInt),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := muo.mutation.RemovedAlertsIDs(); len(nodes) > 0 && !muo.mutation.AlertsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   machine.AlertsTable,
			Columns: []string{machine.AlertsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(alert.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := muo.mutation.AlertsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   machine.AlertsTable,
			Columns: []string{machine.AlertsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(alert.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_node = &Machine{config: muo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, muo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{machine.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	muo.mutation.done = true
	return _node, nil
}
