// Code generated by go generate. DO NOT EDIT.

package opt

import (
	"encoding/json"
	"reflect"
)

// ExtraOptionsOption is a wrapper for an ExtraOptions option parameter. It holds
// the actual value of the option that can be accessed by calling Get.
type ExtraOptionsOption struct {
	value map[string]interface{}
}

// ExtraOptions wraps the given value into a ExtraOptionsOption.
func ExtraOptions(v map[string]interface{}) *ExtraOptionsOption {
	return &ExtraOptionsOption{v}
}

// Get retrieves the actual value of the option parameter.
func (o *ExtraOptionsOption) Get() map[string]interface{} {
	if o == nil {
		return map[string]interface{}{}
	}
	return o.value
}

// MarshalJSON implements the json.Marshaler interface for
// ExtraOptionsOption.
func (o ExtraOptionsOption) MarshalJSON() ([]byte, error) {
	return json.Marshal(o.value)
}

// UnmarshalJSON implements the json.Unmarshaler interface for
// ExtraOptionsOption.
func (o *ExtraOptionsOption) UnmarshalJSON(data []byte) error {
	if string(data) == "null" {
		o.value = map[string]interface{}{}
		return nil
	}
	return json.Unmarshal(data, &o.value)
}

// Equal returns true if the given option is equal to the instance one. In case
// the given option is nil, we checked the instance one is set to the default
// value of the option.
func (o *ExtraOptionsOption) Equal(o2 *ExtraOptionsOption) bool {
	if o == nil {
		return o2 == nil || reflect.DeepEqual(o2.value, map[string]interface{}{})
	}
	if o2 == nil {
		return o == nil || reflect.DeepEqual(o.value, map[string]interface{}{})
	}
	return reflect.DeepEqual(o.value, o2.value)
}

// ExtraOptionsEqual returns true if the two options are equal.
// In case of one option being nil, the value of the other must be nil as well
// or be set to the default value of this option.
func ExtraOptionsEqual(o1, o2 *ExtraOptionsOption) bool {
	return o1.Equal(o2)
}
