// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.6.1
// - protoc             v3.21.12
// source: yandex/cloud/organizationmanager/v1/idp/user_service.proto

package idp

import (
	context "context"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	UserService_Get_FullMethodName                     = "/yandex.cloud.organizationmanager.v1.idp.UserService/Get"
	UserService_List_FullMethodName                    = "/yandex.cloud.organizationmanager.v1.idp.UserService/List"
	UserService_Create_FullMethodName                  = "/yandex.cloud.organizationmanager.v1.idp.UserService/Create"
	UserService_Update_FullMethodName                  = "/yandex.cloud.organizationmanager.v1.idp.UserService/Update"
	UserService_Delete_FullMethodName                  = "/yandex.cloud.organizationmanager.v1.idp.UserService/Delete"
	UserService_SetOwnPassword_FullMethodName          = "/yandex.cloud.organizationmanager.v1.idp.UserService/SetOwnPassword"
	UserService_SetOthersPassword_FullMethodName       = "/yandex.cloud.organizationmanager.v1.idp.UserService/SetOthersPassword"
	UserService_Suspend_FullMethodName                 = "/yandex.cloud.organizationmanager.v1.idp.UserService/Suspend"
	UserService_Reactivate_FullMethodName              = "/yandex.cloud.organizationmanager.v1.idp.UserService/Reactivate"
	UserService_GeneratePassword_FullMethodName        = "/yandex.cloud.organizationmanager.v1.idp.UserService/GeneratePassword"
	UserService_GetSelfPasswordMetadata_FullMethodName = "/yandex.cloud.organizationmanager.v1.idp.UserService/GetSelfPasswordMetadata"
	UserService_ConvertToExternal_FullMethodName       = "/yandex.cloud.organizationmanager.v1.idp.UserService/ConvertToExternal"
	UserService_SetPasswordHash_FullMethodName         = "/yandex.cloud.organizationmanager.v1.idp.UserService/SetPasswordHash"
	UserService_ResolveExternalIds_FullMethodName      = "/yandex.cloud.organizationmanager.v1.idp.UserService/ResolveExternalIds"
)

// UserServiceClient is the client API for UserService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// A set of methods for managing users in the Identity Provider system.
type UserServiceClient interface {
	// Returns the specified user.
	//
	// To get the list of available users, make a [List] request.
	Get(ctx context.Context, in *GetUserRequest, opts ...grpc.CallOption) (*User, error)
	// Retrieves the list of users in the specified userpool.
	List(ctx context.Context, in *ListUsersRequest, opts ...grpc.CallOption) (*ListUsersResponse, error)
	// Creates a user in the specified userpool.
	Create(ctx context.Context, in *CreateUserRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified user.
	Update(ctx context.Context, in *UpdateUserRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified user.
	Delete(ctx context.Context, in *DeleteUserRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Sets the password for the authenticated user.
	SetOwnPassword(ctx context.Context, in *SetOwnPasswordRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Sets the password for another user.
	SetOthersPassword(ctx context.Context, in *SetOthersPasswordRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Suspends the specified user.
	Suspend(ctx context.Context, in *SuspendUserRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Reactivates a previously suspended user.
	Reactivate(ctx context.Context, in *ReactivateUserRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Generates a new password.
	GeneratePassword(ctx context.Context, in *GeneratePasswordRequest, opts ...grpc.CallOption) (*GeneratePasswordResponse, error)
	// Returns metadata about the authenticated user's password.
	GetSelfPasswordMetadata(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*PasswordMetadata, error)
	// Converts a user to use external authentication.
	ConvertToExternal(ctx context.Context, in *ConvertToExternalUserRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Sets a password hash for the specified user.
	SetPasswordHash(ctx context.Context, in *SetPasswordHashRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Resolves external IDs to internal user IDs.
	ResolveExternalIds(ctx context.Context, in *ResolveExternalIdsRequest, opts ...grpc.CallOption) (*ResolveExternalIdsResponse, error)
}

type userServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewUserServiceClient(cc grpc.ClientConnInterface) UserServiceClient {
	return &userServiceClient{cc}
}

func (c *userServiceClient) Get(ctx context.Context, in *GetUserRequest, opts ...grpc.CallOption) (*User, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(User)
	err := c.cc.Invoke(ctx, UserService_Get_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userServiceClient) List(ctx context.Context, in *ListUsersRequest, opts ...grpc.CallOption) (*ListUsersResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListUsersResponse)
	err := c.cc.Invoke(ctx, UserService_List_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userServiceClient) Create(ctx context.Context, in *CreateUserRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, UserService_Create_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userServiceClient) Update(ctx context.Context, in *UpdateUserRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, UserService_Update_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userServiceClient) Delete(ctx context.Context, in *DeleteUserRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, UserService_Delete_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userServiceClient) SetOwnPassword(ctx context.Context, in *SetOwnPasswordRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, UserService_SetOwnPassword_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userServiceClient) SetOthersPassword(ctx context.Context, in *SetOthersPasswordRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, UserService_SetOthersPassword_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userServiceClient) Suspend(ctx context.Context, in *SuspendUserRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, UserService_Suspend_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userServiceClient) Reactivate(ctx context.Context, in *ReactivateUserRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, UserService_Reactivate_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userServiceClient) GeneratePassword(ctx context.Context, in *GeneratePasswordRequest, opts ...grpc.CallOption) (*GeneratePasswordResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GeneratePasswordResponse)
	err := c.cc.Invoke(ctx, UserService_GeneratePassword_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userServiceClient) GetSelfPasswordMetadata(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*PasswordMetadata, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(PasswordMetadata)
	err := c.cc.Invoke(ctx, UserService_GetSelfPasswordMetadata_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userServiceClient) ConvertToExternal(ctx context.Context, in *ConvertToExternalUserRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, UserService_ConvertToExternal_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userServiceClient) SetPasswordHash(ctx context.Context, in *SetPasswordHashRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, UserService_SetPasswordHash_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userServiceClient) ResolveExternalIds(ctx context.Context, in *ResolveExternalIdsRequest, opts ...grpc.CallOption) (*ResolveExternalIdsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ResolveExternalIdsResponse)
	err := c.cc.Invoke(ctx, UserService_ResolveExternalIds_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// UserServiceServer is the server API for UserService service.
// All implementations should embed UnimplementedUserServiceServer
// for forward compatibility.
//
// A set of methods for managing users in the Identity Provider system.
type UserServiceServer interface {
	// Returns the specified user.
	//
	// To get the list of available users, make a [List] request.
	Get(context.Context, *GetUserRequest) (*User, error)
	// Retrieves the list of users in the specified userpool.
	List(context.Context, *ListUsersRequest) (*ListUsersResponse, error)
	// Creates a user in the specified userpool.
	Create(context.Context, *CreateUserRequest) (*operation.Operation, error)
	// Updates the specified user.
	Update(context.Context, *UpdateUserRequest) (*operation.Operation, error)
	// Deletes the specified user.
	Delete(context.Context, *DeleteUserRequest) (*operation.Operation, error)
	// Sets the password for the authenticated user.
	SetOwnPassword(context.Context, *SetOwnPasswordRequest) (*operation.Operation, error)
	// Sets the password for another user.
	SetOthersPassword(context.Context, *SetOthersPasswordRequest) (*operation.Operation, error)
	// Suspends the specified user.
	Suspend(context.Context, *SuspendUserRequest) (*operation.Operation, error)
	// Reactivates a previously suspended user.
	Reactivate(context.Context, *ReactivateUserRequest) (*operation.Operation, error)
	// Generates a new password.
	GeneratePassword(context.Context, *GeneratePasswordRequest) (*GeneratePasswordResponse, error)
	// Returns metadata about the authenticated user's password.
	GetSelfPasswordMetadata(context.Context, *emptypb.Empty) (*PasswordMetadata, error)
	// Converts a user to use external authentication.
	ConvertToExternal(context.Context, *ConvertToExternalUserRequest) (*operation.Operation, error)
	// Sets a password hash for the specified user.
	SetPasswordHash(context.Context, *SetPasswordHashRequest) (*operation.Operation, error)
	// Resolves external IDs to internal user IDs.
	ResolveExternalIds(context.Context, *ResolveExternalIdsRequest) (*ResolveExternalIdsResponse, error)
}

// UnimplementedUserServiceServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedUserServiceServer struct{}

func (UnimplementedUserServiceServer) Get(context.Context, *GetUserRequest) (*User, error) {
	return nil, status.Error(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedUserServiceServer) List(context.Context, *ListUsersRequest) (*ListUsersResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedUserServiceServer) Create(context.Context, *CreateUserRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method Create not implemented")
}
func (UnimplementedUserServiceServer) Update(context.Context, *UpdateUserRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method Update not implemented")
}
func (UnimplementedUserServiceServer) Delete(context.Context, *DeleteUserRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedUserServiceServer) SetOwnPassword(context.Context, *SetOwnPasswordRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method SetOwnPassword not implemented")
}
func (UnimplementedUserServiceServer) SetOthersPassword(context.Context, *SetOthersPasswordRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method SetOthersPassword not implemented")
}
func (UnimplementedUserServiceServer) Suspend(context.Context, *SuspendUserRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method Suspend not implemented")
}
func (UnimplementedUserServiceServer) Reactivate(context.Context, *ReactivateUserRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method Reactivate not implemented")
}
func (UnimplementedUserServiceServer) GeneratePassword(context.Context, *GeneratePasswordRequest) (*GeneratePasswordResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method GeneratePassword not implemented")
}
func (UnimplementedUserServiceServer) GetSelfPasswordMetadata(context.Context, *emptypb.Empty) (*PasswordMetadata, error) {
	return nil, status.Error(codes.Unimplemented, "method GetSelfPasswordMetadata not implemented")
}
func (UnimplementedUserServiceServer) ConvertToExternal(context.Context, *ConvertToExternalUserRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method ConvertToExternal not implemented")
}
func (UnimplementedUserServiceServer) SetPasswordHash(context.Context, *SetPasswordHashRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method SetPasswordHash not implemented")
}
func (UnimplementedUserServiceServer) ResolveExternalIds(context.Context, *ResolveExternalIdsRequest) (*ResolveExternalIdsResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method ResolveExternalIds not implemented")
}
func (UnimplementedUserServiceServer) testEmbeddedByValue() {}

// UnsafeUserServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to UserServiceServer will
// result in compilation errors.
type UnsafeUserServiceServer interface {
	mustEmbedUnimplementedUserServiceServer()
}

func RegisterUserServiceServer(s grpc.ServiceRegistrar, srv UserServiceServer) {
	// If the following call panics, it indicates UnimplementedUserServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&UserService_ServiceDesc, srv)
}

func _UserService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetUserRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserService_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServiceServer).Get(ctx, req.(*GetUserRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListUsersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserService_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServiceServer).List(ctx, req.(*ListUsersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateUserRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserService_Create_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServiceServer).Create(ctx, req.(*CreateUserRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateUserRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserService_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServiceServer).Update(ctx, req.(*UpdateUserRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteUserRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserService_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServiceServer).Delete(ctx, req.(*DeleteUserRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserService_SetOwnPassword_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetOwnPasswordRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServiceServer).SetOwnPassword(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserService_SetOwnPassword_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServiceServer).SetOwnPassword(ctx, req.(*SetOwnPasswordRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserService_SetOthersPassword_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetOthersPasswordRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServiceServer).SetOthersPassword(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserService_SetOthersPassword_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServiceServer).SetOthersPassword(ctx, req.(*SetOthersPasswordRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserService_Suspend_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SuspendUserRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServiceServer).Suspend(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserService_Suspend_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServiceServer).Suspend(ctx, req.(*SuspendUserRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserService_Reactivate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReactivateUserRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServiceServer).Reactivate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserService_Reactivate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServiceServer).Reactivate(ctx, req.(*ReactivateUserRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserService_GeneratePassword_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GeneratePasswordRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServiceServer).GeneratePassword(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserService_GeneratePassword_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServiceServer).GeneratePassword(ctx, req.(*GeneratePasswordRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserService_GetSelfPasswordMetadata_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServiceServer).GetSelfPasswordMetadata(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserService_GetSelfPasswordMetadata_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServiceServer).GetSelfPasswordMetadata(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserService_ConvertToExternal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConvertToExternalUserRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServiceServer).ConvertToExternal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserService_ConvertToExternal_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServiceServer).ConvertToExternal(ctx, req.(*ConvertToExternalUserRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserService_SetPasswordHash_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetPasswordHashRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServiceServer).SetPasswordHash(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserService_SetPasswordHash_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServiceServer).SetPasswordHash(ctx, req.(*SetPasswordHashRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _UserService_ResolveExternalIds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResolveExternalIdsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UserServiceServer).ResolveExternalIds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: UserService_ResolveExternalIds_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UserServiceServer).ResolveExternalIds(ctx, req.(*ResolveExternalIdsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// UserService_ServiceDesc is the grpc.ServiceDesc for UserService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var UserService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.organizationmanager.v1.idp.UserService",
	HandlerType: (*UserServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _UserService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _UserService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _UserService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _UserService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _UserService_Delete_Handler,
		},
		{
			MethodName: "SetOwnPassword",
			Handler:    _UserService_SetOwnPassword_Handler,
		},
		{
			MethodName: "SetOthersPassword",
			Handler:    _UserService_SetOthersPassword_Handler,
		},
		{
			MethodName: "Suspend",
			Handler:    _UserService_Suspend_Handler,
		},
		{
			MethodName: "Reactivate",
			Handler:    _UserService_Reactivate_Handler,
		},
		{
			MethodName: "GeneratePassword",
			Handler:    _UserService_GeneratePassword_Handler,
		},
		{
			MethodName: "GetSelfPasswordMetadata",
			Handler:    _UserService_GetSelfPasswordMetadata_Handler,
		},
		{
			MethodName: "ConvertToExternal",
			Handler:    _UserService_ConvertToExternal_Handler,
		},
		{
			MethodName: "SetPasswordHash",
			Handler:    _UserService_SetPasswordHash_Handler,
		},
		{
			MethodName: "ResolveExternalIds",
			Handler:    _UserService_ResolveExternalIds_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/organizationmanager/v1/idp/user_service.proto",
}
