// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        v3.21.12
// source: yandex/cloud/airflow/v1/cluster.proto

package airflow

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	v1 "github.com/yandex-cloud/go-genproto/yandex/cloud/logging/v1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Cluster_Status int32

const (
	// Cluster state is unknown.
	Cluster_STATUS_UNKNOWN Cluster_Status = 0
	// Cluster is being created.
	Cluster_CREATING Cluster_Status = 1
	// Cluster is running normally.
	Cluster_RUNNING Cluster_Status = 2
	// Cluster encountered a problem and cannot operate.
	Cluster_ERROR Cluster_Status = 3
	// Cluster is stopping.
	Cluster_STOPPING Cluster_Status = 4
	// Cluster is stopped.
	Cluster_STOPPED Cluster_Status = 5
	// Cluster is starting.
	Cluster_STARTING Cluster_Status = 6
	// Cluster is being updated.
	Cluster_UPDATING Cluster_Status = 7
)

// Enum value maps for Cluster_Status.
var (
	Cluster_Status_name = map[int32]string{
		0: "STATUS_UNKNOWN",
		1: "CREATING",
		2: "RUNNING",
		3: "ERROR",
		4: "STOPPING",
		5: "STOPPED",
		6: "STARTING",
		7: "UPDATING",
	}
	Cluster_Status_value = map[string]int32{
		"STATUS_UNKNOWN": 0,
		"CREATING":       1,
		"RUNNING":        2,
		"ERROR":          3,
		"STOPPING":       4,
		"STOPPED":        5,
		"STARTING":       6,
		"UPDATING":       7,
	}
)

func (x Cluster_Status) Enum() *Cluster_Status {
	p := new(Cluster_Status)
	*p = x
	return p
}

func (x Cluster_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_airflow_v1_cluster_proto_enumTypes[0].Descriptor()
}

func (Cluster_Status) Type() protoreflect.EnumType {
	return &file_yandex_cloud_airflow_v1_cluster_proto_enumTypes[0]
}

func (x Cluster_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Status.Descriptor instead.
func (Cluster_Status) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP(), []int{0, 0}
}

// Apache Airflow cluster.
type Cluster struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Unique ID of the Apache Airflow cluster.
	// This ID is assigned by Cloud during cluster creation.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the Apache Airflow cluster belongs to.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The time when the Apache Airflow cluster was created.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the Apache Airflow cluster.
	// The name is unique within the folder. 1-64 characters long.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the Apache Airflow cluster. 0-256 characters long.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `key:value` pairs. Maximum of 64 per resource.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Monitoring systems relevant to the Apache Airflow cluster.
	Monitoring []*Monitoring `protobuf:"bytes,8,rep,name=monitoring,proto3" json:"monitoring,omitempty"`
	// Configuration of Apache Airflow components.
	Config *ClusterConfig `protobuf:"bytes,9,opt,name=config,proto3" json:"config,omitempty"`
	// Aggregated cluster health.
	Health Health `protobuf:"varint,10,opt,name=health,proto3,enum=yandex.cloud.airflow.v1.Health" json:"health,omitempty"`
	// Cluster status.
	Status Cluster_Status `protobuf:"varint,11,opt,name=status,proto3,enum=yandex.cloud.airflow.v1.Cluster_Status" json:"status,omitempty"`
	// Network related configuration options.
	Network *NetworkConfig `protobuf:"bytes,12,opt,name=network,proto3" json:"network,omitempty"`
	// Parameters of the location and access to the code that will be executed in the cluster.
	CodeSync *CodeSyncConfig `protobuf:"bytes,13,opt,name=code_sync,json=codeSync,proto3" json:"code_sync,omitempty"`
	// Deletion Protection inhibits deletion of the cluster.
	DeletionProtection bool `protobuf:"varint,14,opt,name=deletion_protection,json=deletionProtection,proto3" json:"deletion_protection,omitempty"`
	// Address of Apache Airflow web UI.
	WebserverUrl string `protobuf:"bytes,15,opt,name=webserver_url,json=webserverUrl,proto3" json:"webserver_url,omitempty"`
	// Service account used to access Cloud resources.
	// For more information, see [documentation](/docs/managed-airflow/concepts/impersonation).
	ServiceAccountId string `protobuf:"bytes,16,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// Cloud Logging configuration.
	Logging *LoggingConfig `protobuf:"bytes,17,opt,name=logging,proto3" json:"logging,omitempty"`
	// Window of maintenance operations.
	MaintenanceWindow *MaintenanceWindow `protobuf:"bytes,18,opt,name=maintenance_window,json=maintenanceWindow,proto3" json:"maintenance_window,omitempty"`
	// Maintenance operation planned at nearest maintenance_window.
	PlannedOperation *MaintenanceOperation `protobuf:"bytes,19,opt,name=planned_operation,json=plannedOperation,proto3" json:"planned_operation,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *Cluster) Reset() {
	*x = Cluster{}
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Cluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster) ProtoMessage() {}

func (x *Cluster) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster.ProtoReflect.Descriptor instead.
func (*Cluster) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP(), []int{0}
}

func (x *Cluster) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Cluster) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *Cluster) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *Cluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Cluster) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Cluster) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Cluster) GetMonitoring() []*Monitoring {
	if x != nil {
		return x.Monitoring
	}
	return nil
}

func (x *Cluster) GetConfig() *ClusterConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Cluster) GetHealth() Health {
	if x != nil {
		return x.Health
	}
	return Health_HEALTH_UNKNOWN
}

func (x *Cluster) GetStatus() Cluster_Status {
	if x != nil {
		return x.Status
	}
	return Cluster_STATUS_UNKNOWN
}

func (x *Cluster) GetNetwork() *NetworkConfig {
	if x != nil {
		return x.Network
	}
	return nil
}

func (x *Cluster) GetCodeSync() *CodeSyncConfig {
	if x != nil {
		return x.CodeSync
	}
	return nil
}

func (x *Cluster) GetDeletionProtection() bool {
	if x != nil {
		return x.DeletionProtection
	}
	return false
}

func (x *Cluster) GetWebserverUrl() string {
	if x != nil {
		return x.WebserverUrl
	}
	return ""
}

func (x *Cluster) GetServiceAccountId() string {
	if x != nil {
		return x.ServiceAccountId
	}
	return ""
}

func (x *Cluster) GetLogging() *LoggingConfig {
	if x != nil {
		return x.Logging
	}
	return nil
}

func (x *Cluster) GetMaintenanceWindow() *MaintenanceWindow {
	if x != nil {
		return x.MaintenanceWindow
	}
	return nil
}

func (x *Cluster) GetPlannedOperation() *MaintenanceOperation {
	if x != nil {
		return x.PlannedOperation
	}
	return nil
}

// Monitoring system.
type Monitoring struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the monitoring system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the monitoring system.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Link to the monitoring system.
	Link          string `protobuf:"bytes,3,opt,name=link,proto3" json:"link,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Monitoring) Reset() {
	*x = Monitoring{}
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Monitoring) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Monitoring) ProtoMessage() {}

func (x *Monitoring) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Monitoring.ProtoReflect.Descriptor instead.
func (*Monitoring) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP(), []int{1}
}

func (x *Monitoring) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Monitoring) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Monitoring) GetLink() string {
	if x != nil {
		return x.Link
	}
	return ""
}

type ClusterConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Version of Apache Airflow that runs on the cluster.
	// Use `airflow_version` instead.
	//
	// Deprecated: Marked as deprecated in yandex/cloud/airflow/v1/cluster.proto.
	VersionId string `protobuf:"bytes,1,opt,name=version_id,json=versionId,proto3" json:"version_id,omitempty"`
	// Configuration of the Apache Airflow application itself.
	Airflow *AirflowConfig `protobuf:"bytes,2,opt,name=airflow,proto3" json:"airflow,omitempty"`
	// Configuration of webserver instances.
	Webserver *WebserverConfig `protobuf:"bytes,3,opt,name=webserver,proto3" json:"webserver,omitempty"`
	// Configuration of scheduler instances.
	Scheduler *SchedulerConfig `protobuf:"bytes,4,opt,name=scheduler,proto3" json:"scheduler,omitempty"`
	// Configuration of triggerer instances.
	Triggerer *TriggererConfig `protobuf:"bytes,5,opt,name=triggerer,proto3" json:"triggerer,omitempty"`
	// Configuration of worker instances.
	Worker *WorkerConfig `protobuf:"bytes,6,opt,name=worker,proto3" json:"worker,omitempty"`
	// The list of additional packages installed in the cluster.
	Dependencies *Dependencies `protobuf:"bytes,7,opt,name=dependencies,proto3" json:"dependencies,omitempty"`
	// Configuration of Lockbox Secret Backend.
	Lockbox *LockboxConfig `protobuf:"bytes,8,opt,name=lockbox,proto3" json:"lockbox,omitempty"`
	// Apache Airflow version. Format: "Major.Minor"
	AirflowVersion string `protobuf:"bytes,9,opt,name=airflow_version,json=airflowVersion,proto3" json:"airflow_version,omitempty"`
	// Python version. Format: "Major.Minor"
	PythonVersion string `protobuf:"bytes,10,opt,name=python_version,json=pythonVersion,proto3" json:"python_version,omitempty"`
	// Configuration of dag-processor instances.
	DagProcessor  *DagProcessorConfig `protobuf:"bytes,11,opt,name=dag_processor,json=dagProcessor,proto3" json:"dag_processor,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ClusterConfig) Reset() {
	*x = ClusterConfig{}
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClusterConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterConfig) ProtoMessage() {}

func (x *ClusterConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterConfig.ProtoReflect.Descriptor instead.
func (*ClusterConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP(), []int{2}
}

// Deprecated: Marked as deprecated in yandex/cloud/airflow/v1/cluster.proto.
func (x *ClusterConfig) GetVersionId() string {
	if x != nil {
		return x.VersionId
	}
	return ""
}

func (x *ClusterConfig) GetAirflow() *AirflowConfig {
	if x != nil {
		return x.Airflow
	}
	return nil
}

func (x *ClusterConfig) GetWebserver() *WebserverConfig {
	if x != nil {
		return x.Webserver
	}
	return nil
}

func (x *ClusterConfig) GetScheduler() *SchedulerConfig {
	if x != nil {
		return x.Scheduler
	}
	return nil
}

func (x *ClusterConfig) GetTriggerer() *TriggererConfig {
	if x != nil {
		return x.Triggerer
	}
	return nil
}

func (x *ClusterConfig) GetWorker() *WorkerConfig {
	if x != nil {
		return x.Worker
	}
	return nil
}

func (x *ClusterConfig) GetDependencies() *Dependencies {
	if x != nil {
		return x.Dependencies
	}
	return nil
}

func (x *ClusterConfig) GetLockbox() *LockboxConfig {
	if x != nil {
		return x.Lockbox
	}
	return nil
}

func (x *ClusterConfig) GetAirflowVersion() string {
	if x != nil {
		return x.AirflowVersion
	}
	return ""
}

func (x *ClusterConfig) GetPythonVersion() string {
	if x != nil {
		return x.PythonVersion
	}
	return ""
}

func (x *ClusterConfig) GetDagProcessor() *DagProcessorConfig {
	if x != nil {
		return x.DagProcessor
	}
	return nil
}

type AirflowConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Properties to be passed to Apache Airflow configuration file.
	Config        map[string]string `protobuf:"bytes,1,rep,name=config,proto3" json:"config,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AirflowConfig) Reset() {
	*x = AirflowConfig{}
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AirflowConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AirflowConfig) ProtoMessage() {}

func (x *AirflowConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AirflowConfig.ProtoReflect.Descriptor instead.
func (*AirflowConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP(), []int{3}
}

func (x *AirflowConfig) GetConfig() map[string]string {
	if x != nil {
		return x.Config
	}
	return nil
}

type WebserverConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The number of webserver instances in the cluster.
	Count int64 `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	// Resources allocated to webserver instances.
	Resources     *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WebserverConfig) Reset() {
	*x = WebserverConfig{}
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WebserverConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebserverConfig) ProtoMessage() {}

func (x *WebserverConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebserverConfig.ProtoReflect.Descriptor instead.
func (*WebserverConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP(), []int{4}
}

func (x *WebserverConfig) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (x *WebserverConfig) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

type SchedulerConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The number of scheduler instances in the cluster.
	Count int64 `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	// Resources allocated to scheduler instances.
	Resources     *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SchedulerConfig) Reset() {
	*x = SchedulerConfig{}
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SchedulerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SchedulerConfig) ProtoMessage() {}

func (x *SchedulerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SchedulerConfig.ProtoReflect.Descriptor instead.
func (*SchedulerConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP(), []int{5}
}

func (x *SchedulerConfig) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (x *SchedulerConfig) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

type DagProcessorConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The number of dag-processor instances in the cluster.
	Count int64 `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	// Resources allocated to dag-processor instances.
	Resources     *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DagProcessorConfig) Reset() {
	*x = DagProcessorConfig{}
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DagProcessorConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DagProcessorConfig) ProtoMessage() {}

func (x *DagProcessorConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DagProcessorConfig.ProtoReflect.Descriptor instead.
func (*DagProcessorConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP(), []int{6}
}

func (x *DagProcessorConfig) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (x *DagProcessorConfig) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

type TriggererConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The number of triggerer instances in the cluster.
	Count int64 `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	// Resources allocated to triggerer instances.
	Resources     *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TriggererConfig) Reset() {
	*x = TriggererConfig{}
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TriggererConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TriggererConfig) ProtoMessage() {}

func (x *TriggererConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TriggererConfig.ProtoReflect.Descriptor instead.
func (*TriggererConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP(), []int{7}
}

func (x *TriggererConfig) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (x *TriggererConfig) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

type WorkerConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The minimum number of worker instances in the cluster.
	MinCount int64 `protobuf:"varint,1,opt,name=min_count,json=minCount,proto3" json:"min_count,omitempty"`
	// The maximum number of worker instances in the cluster.
	MaxCount int64 `protobuf:"varint,2,opt,name=max_count,json=maxCount,proto3" json:"max_count,omitempty"`
	// Resources allocated to worker instances.
	Resources     *Resources `protobuf:"bytes,3,opt,name=resources,proto3" json:"resources,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WorkerConfig) Reset() {
	*x = WorkerConfig{}
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WorkerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkerConfig) ProtoMessage() {}

func (x *WorkerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkerConfig.ProtoReflect.Descriptor instead.
func (*WorkerConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP(), []int{8}
}

func (x *WorkerConfig) GetMinCount() int64 {
	if x != nil {
		return x.MinCount
	}
	return 0
}

func (x *WorkerConfig) GetMaxCount() int64 {
	if x != nil {
		return x.MaxCount
	}
	return 0
}

func (x *WorkerConfig) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

type Dependencies struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Python packages that are installed in the cluster.
	PipPackages []string `protobuf:"bytes,1,rep,name=pip_packages,json=pipPackages,proto3" json:"pip_packages,omitempty"`
	// System packages that are installed in the cluster.
	DebPackages   []string `protobuf:"bytes,2,rep,name=deb_packages,json=debPackages,proto3" json:"deb_packages,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Dependencies) Reset() {
	*x = Dependencies{}
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Dependencies) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Dependencies) ProtoMessage() {}

func (x *Dependencies) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Dependencies.ProtoReflect.Descriptor instead.
func (*Dependencies) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP(), []int{9}
}

func (x *Dependencies) GetPipPackages() []string {
	if x != nil {
		return x.PipPackages
	}
	return nil
}

func (x *Dependencies) GetDebPackages() []string {
	if x != nil {
		return x.DebPackages
	}
	return nil
}

type NetworkConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// IDs of VPC network subnets where instances of the cluster are attached.
	SubnetIds []string `protobuf:"bytes,1,rep,name=subnet_ids,json=subnetIds,proto3" json:"subnet_ids,omitempty"`
	// User security groups.
	SecurityGroupIds []string `protobuf:"bytes,2,rep,name=security_group_ids,json=securityGroupIds,proto3" json:"security_group_ids,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *NetworkConfig) Reset() {
	*x = NetworkConfig{}
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NetworkConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkConfig) ProtoMessage() {}

func (x *NetworkConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkConfig.ProtoReflect.Descriptor instead.
func (*NetworkConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP(), []int{10}
}

func (x *NetworkConfig) GetSubnetIds() []string {
	if x != nil {
		return x.SubnetIds
	}
	return nil
}

func (x *NetworkConfig) GetSecurityGroupIds() []string {
	if x != nil {
		return x.SecurityGroupIds
	}
	return nil
}

type S3Config struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The name of the Object Storage bucket that stores DAG files used in the cluster.
	Bucket        string `protobuf:"bytes,3,opt,name=bucket,proto3" json:"bucket,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *S3Config) Reset() {
	*x = S3Config{}
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *S3Config) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*S3Config) ProtoMessage() {}

func (x *S3Config) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use S3Config.ProtoReflect.Descriptor instead.
func (*S3Config) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP(), []int{11}
}

func (x *S3Config) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

type GitSyncConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Git repository URL.
	Repo string `protobuf:"bytes,1,opt,name=repo,proto3" json:"repo,omitempty"`
	// Git branch name to sync from.
	Branch string `protobuf:"bytes,2,opt,name=branch,proto3" json:"branch,omitempty"`
	// Subdirectory path within the repository containing DAG files.
	SubPath string `protobuf:"bytes,3,opt,name=sub_path,json=subPath,proto3" json:"sub_path,omitempty"`
	// SSH private key for repository authentication.
	SshKey        string `protobuf:"bytes,4,opt,name=ssh_key,json=sshKey,proto3" json:"ssh_key,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GitSyncConfig) Reset() {
	*x = GitSyncConfig{}
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GitSyncConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GitSyncConfig) ProtoMessage() {}

func (x *GitSyncConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GitSyncConfig.ProtoReflect.Descriptor instead.
func (*GitSyncConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP(), []int{12}
}

func (x *GitSyncConfig) GetRepo() string {
	if x != nil {
		return x.Repo
	}
	return ""
}

func (x *GitSyncConfig) GetBranch() string {
	if x != nil {
		return x.Branch
	}
	return ""
}

func (x *GitSyncConfig) GetSubPath() string {
	if x != nil {
		return x.SubPath
	}
	return ""
}

func (x *GitSyncConfig) GetSshKey() string {
	if x != nil {
		return x.SshKey
	}
	return ""
}

type CodeSyncConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Source:
	//
	//	*CodeSyncConfig_S3
	//	*CodeSyncConfig_GitSync
	Source        isCodeSyncConfig_Source `protobuf_oneof:"source"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CodeSyncConfig) Reset() {
	*x = CodeSyncConfig{}
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CodeSyncConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CodeSyncConfig) ProtoMessage() {}

func (x *CodeSyncConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CodeSyncConfig.ProtoReflect.Descriptor instead.
func (*CodeSyncConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP(), []int{13}
}

func (x *CodeSyncConfig) GetSource() isCodeSyncConfig_Source {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *CodeSyncConfig) GetS3() *S3Config {
	if x != nil {
		if x, ok := x.Source.(*CodeSyncConfig_S3); ok {
			return x.S3
		}
	}
	return nil
}

func (x *CodeSyncConfig) GetGitSync() *GitSyncConfig {
	if x != nil {
		if x, ok := x.Source.(*CodeSyncConfig_GitSync); ok {
			return x.GitSync
		}
	}
	return nil
}

type isCodeSyncConfig_Source interface {
	isCodeSyncConfig_Source()
}

type CodeSyncConfig_S3 struct {
	S3 *S3Config `protobuf:"bytes,1,opt,name=s3,proto3,oneof"`
}

type CodeSyncConfig_GitSync struct {
	GitSync *GitSyncConfig `protobuf:"bytes,2,opt,name=git_sync,json=gitSync,proto3,oneof"`
}

func (*CodeSyncConfig_S3) isCodeSyncConfig_Source() {}

func (*CodeSyncConfig_GitSync) isCodeSyncConfig_Source() {}

type LoggingConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Logs generated by the Airflow components are delivered to Cloud Logging.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Destination of log records.
	//
	// Types that are valid to be assigned to Destination:
	//
	//	*LoggingConfig_FolderId
	//	*LoggingConfig_LogGroupId
	Destination isLoggingConfig_Destination `protobuf_oneof:"destination"`
	// Minimum log entry level.
	//
	// See [LogLevel.Level] for details.
	MinLevel      v1.LogLevel_Level `protobuf:"varint,4,opt,name=min_level,json=minLevel,proto3,enum=yandex.cloud.logging.v1.LogLevel_Level" json:"min_level,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LoggingConfig) Reset() {
	*x = LoggingConfig{}
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoggingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoggingConfig) ProtoMessage() {}

func (x *LoggingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoggingConfig.ProtoReflect.Descriptor instead.
func (*LoggingConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP(), []int{14}
}

func (x *LoggingConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *LoggingConfig) GetDestination() isLoggingConfig_Destination {
	if x != nil {
		return x.Destination
	}
	return nil
}

func (x *LoggingConfig) GetFolderId() string {
	if x != nil {
		if x, ok := x.Destination.(*LoggingConfig_FolderId); ok {
			return x.FolderId
		}
	}
	return ""
}

func (x *LoggingConfig) GetLogGroupId() string {
	if x != nil {
		if x, ok := x.Destination.(*LoggingConfig_LogGroupId); ok {
			return x.LogGroupId
		}
	}
	return ""
}

func (x *LoggingConfig) GetMinLevel() v1.LogLevel_Level {
	if x != nil {
		return x.MinLevel
	}
	return v1.LogLevel_Level(0)
}

type isLoggingConfig_Destination interface {
	isLoggingConfig_Destination()
}

type LoggingConfig_FolderId struct {
	// Logs should be written to default log group for specified folder.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3,oneof"`
}

type LoggingConfig_LogGroupId struct {
	// Logs should be written to log group resolved by ID.
	LogGroupId string `protobuf:"bytes,3,opt,name=log_group_id,json=logGroupId,proto3,oneof"`
}

func (*LoggingConfig_FolderId) isLoggingConfig_Destination() {}

func (*LoggingConfig_LogGroupId) isLoggingConfig_Destination() {}

type LockboxConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The setting allows to enable Lockbox Secret Backend.
	Enabled       bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LockboxConfig) Reset() {
	*x = LockboxConfig{}
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LockboxConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LockboxConfig) ProtoMessage() {}

func (x *LockboxConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LockboxConfig.ProtoReflect.Descriptor instead.
func (*LockboxConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP(), []int{15}
}

func (x *LockboxConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

var File_yandex_cloud_airflow_v1_cluster_proto protoreflect.FileDescriptor

const file_yandex_cloud_airflow_v1_cluster_proto_rawDesc = "" +
	"\n" +
	"%yandex/cloud/airflow/v1/cluster.proto\x12\x17yandex.cloud.airflow.v1\x1a$yandex/cloud/airflow/v1/common.proto\x1a)yandex/cloud/airflow/v1/maintenance.proto\x1a\x1dyandex/cloud/validation.proto\x1a'yandex/cloud/logging/v1/log_entry.proto\x1a\x1fgoogle/protobuf/timestamp.proto\"\xb7\t\n" +
	"\aCluster\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x1b\n" +
	"\tfolder_id\x18\x02 \x01(\tR\bfolderId\x129\n" +
	"\n" +
	"created_at\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampR\tcreatedAt\x12\x12\n" +
	"\x04name\x18\x04 \x01(\tR\x04name\x12 \n" +
	"\vdescription\x18\x05 \x01(\tR\vdescription\x12D\n" +
	"\x06labels\x18\x06 \x03(\v2,.yandex.cloud.airflow.v1.Cluster.LabelsEntryR\x06labels\x12C\n" +
	"\n" +
	"monitoring\x18\b \x03(\v2#.yandex.cloud.airflow.v1.MonitoringR\n" +
	"monitoring\x12>\n" +
	"\x06config\x18\t \x01(\v2&.yandex.cloud.airflow.v1.ClusterConfigR\x06config\x127\n" +
	"\x06health\x18\n" +
	" \x01(\x0e2\x1f.yandex.cloud.airflow.v1.HealthR\x06health\x12?\n" +
	"\x06status\x18\v \x01(\x0e2'.yandex.cloud.airflow.v1.Cluster.StatusR\x06status\x12@\n" +
	"\anetwork\x18\f \x01(\v2&.yandex.cloud.airflow.v1.NetworkConfigR\anetwork\x12D\n" +
	"\tcode_sync\x18\r \x01(\v2'.yandex.cloud.airflow.v1.CodeSyncConfigR\bcodeSync\x12/\n" +
	"\x13deletion_protection\x18\x0e \x01(\bR\x12deletionProtection\x12#\n" +
	"\rwebserver_url\x18\x0f \x01(\tR\fwebserverUrl\x126\n" +
	"\x12service_account_id\x18\x10 \x01(\tB\b\x8a\xc81\x04<=50R\x10serviceAccountId\x12@\n" +
	"\alogging\x18\x11 \x01(\v2&.yandex.cloud.airflow.v1.LoggingConfigR\alogging\x12Y\n" +
	"\x12maintenance_window\x18\x12 \x01(\v2*.yandex.cloud.airflow.v1.MaintenanceWindowR\x11maintenanceWindow\x12Z\n" +
	"\x11planned_operation\x18\x13 \x01(\v2-.yandex.cloud.airflow.v1.MaintenanceOperationR\x10plannedOperation\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"y\n" +
	"\x06Status\x12\x12\n" +
	"\x0eSTATUS_UNKNOWN\x10\x00\x12\f\n" +
	"\bCREATING\x10\x01\x12\v\n" +
	"\aRUNNING\x10\x02\x12\t\n" +
	"\x05ERROR\x10\x03\x12\f\n" +
	"\bSTOPPING\x10\x04\x12\v\n" +
	"\aSTOPPED\x10\x05\x12\f\n" +
	"\bSTARTING\x10\x06\x12\f\n" +
	"\bUPDATING\x10\aJ\x04\b\a\x10\b\"V\n" +
	"\n" +
	"Monitoring\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12 \n" +
	"\vdescription\x18\x02 \x01(\tR\vdescription\x12\x12\n" +
	"\x04link\x18\x03 \x01(\tR\x04link\"\xcc\x05\n" +
	"\rClusterConfig\x12!\n" +
	"\n" +
	"version_id\x18\x01 \x01(\tB\x02\x18\x01R\tversionId\x12@\n" +
	"\aairflow\x18\x02 \x01(\v2&.yandex.cloud.airflow.v1.AirflowConfigR\aairflow\x12L\n" +
	"\twebserver\x18\x03 \x01(\v2(.yandex.cloud.airflow.v1.WebserverConfigB\x04\xe8\xc71\x01R\twebserver\x12L\n" +
	"\tscheduler\x18\x04 \x01(\v2(.yandex.cloud.airflow.v1.SchedulerConfigB\x04\xe8\xc71\x01R\tscheduler\x12F\n" +
	"\ttriggerer\x18\x05 \x01(\v2(.yandex.cloud.airflow.v1.TriggererConfigR\ttriggerer\x12C\n" +
	"\x06worker\x18\x06 \x01(\v2%.yandex.cloud.airflow.v1.WorkerConfigB\x04\xe8\xc71\x01R\x06worker\x12I\n" +
	"\fdependencies\x18\a \x01(\v2%.yandex.cloud.airflow.v1.DependenciesR\fdependencies\x12@\n" +
	"\alockbox\x18\b \x01(\v2&.yandex.cloud.airflow.v1.LockboxConfigR\alockbox\x12'\n" +
	"\x0fairflow_version\x18\t \x01(\tR\x0eairflowVersion\x12%\n" +
	"\x0epython_version\x18\n" +
	" \x01(\tR\rpythonVersion\x12P\n" +
	"\rdag_processor\x18\v \x01(\v2+.yandex.cloud.airflow.v1.DagProcessorConfigR\fdagProcessor\"\x96\x01\n" +
	"\rAirflowConfig\x12J\n" +
	"\x06config\x18\x01 \x03(\v22.yandex.cloud.airflow.v1.AirflowConfig.ConfigEntryR\x06config\x1a9\n" +
	"\vConfigEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"t\n" +
	"\x0fWebserverConfig\x12\x1f\n" +
	"\x05count\x18\x01 \x01(\x03B\t\xfa\xc71\x051-512R\x05count\x12@\n" +
	"\tresources\x18\x02 \x01(\v2\".yandex.cloud.airflow.v1.ResourcesR\tresources\"t\n" +
	"\x0fSchedulerConfig\x12\x1f\n" +
	"\x05count\x18\x01 \x01(\x03B\t\xfa\xc71\x051-512R\x05count\x12@\n" +
	"\tresources\x18\x02 \x01(\v2\".yandex.cloud.airflow.v1.ResourcesR\tresources\"w\n" +
	"\x12DagProcessorConfig\x12\x1f\n" +
	"\x05count\x18\x01 \x01(\x03B\t\xfa\xc71\x051-512R\x05count\x12@\n" +
	"\tresources\x18\x02 \x01(\v2\".yandex.cloud.airflow.v1.ResourcesR\tresources\"t\n" +
	"\x0fTriggererConfig\x12\x1f\n" +
	"\x05count\x18\x01 \x01(\x03B\t\xfa\xc71\x050-512R\x05count\x12@\n" +
	"\tresources\x18\x02 \x01(\v2\".yandex.cloud.airflow.v1.ResourcesR\tresources\"\xa0\x01\n" +
	"\fWorkerConfig\x12&\n" +
	"\tmin_count\x18\x01 \x01(\x03B\t\xfa\xc71\x050-512R\bminCount\x12&\n" +
	"\tmax_count\x18\x02 \x01(\x03B\t\xfa\xc71\x051-512R\bmaxCount\x12@\n" +
	"\tresources\x18\x03 \x01(\v2\".yandex.cloud.airflow.v1.ResourcesR\tresources\"T\n" +
	"\fDependencies\x12!\n" +
	"\fpip_packages\x18\x01 \x03(\tR\vpipPackages\x12!\n" +
	"\fdeb_packages\x18\x02 \x03(\tR\vdebPackages\"\\\n" +
	"\rNetworkConfig\x12\x1d\n" +
	"\n" +
	"subnet_ids\x18\x01 \x03(\tR\tsubnetIds\x12,\n" +
	"\x12security_group_ids\x18\x02 \x03(\tR\x10securityGroupIds\"\"\n" +
	"\bS3Config\x12\x16\n" +
	"\x06bucket\x18\x03 \x01(\tR\x06bucket\"{\n" +
	"\rGitSyncConfig\x12\x18\n" +
	"\x04repo\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\x04repo\x12\x1c\n" +
	"\x06branch\x18\x02 \x01(\tB\x04\xe8\xc71\x01R\x06branch\x12\x19\n" +
	"\bsub_path\x18\x03 \x01(\tR\asubPath\x12\x17\n" +
	"\assh_key\x18\x04 \x01(\tR\x06sshKey\"\x9a\x01\n" +
	"\x0eCodeSyncConfig\x123\n" +
	"\x02s3\x18\x01 \x01(\v2!.yandex.cloud.airflow.v1.S3ConfigH\x00R\x02s3\x12C\n" +
	"\bgit_sync\x18\x02 \x01(\v2&.yandex.cloud.airflow.v1.GitSyncConfigH\x00R\agitSyncB\x0e\n" +
	"\x06source\x12\x04\xc0\xc11\x01\"\x8b\x02\n" +
	"\rLoggingConfig\x12\x18\n" +
	"\aenabled\x18\x01 \x01(\bR\aenabled\x12B\n" +
	"\tfolder_id\x18\x02 \x01(\tB#\xf2\xc71\x1f([a-zA-Z][-a-zA-Z0-9_.]{0,63})?H\x00R\bfolderId\x12G\n" +
	"\flog_group_id\x18\x03 \x01(\tB#\xf2\xc71\x1f([a-zA-Z][-a-zA-Z0-9_.]{0,63})?H\x00R\n" +
	"logGroupId\x12D\n" +
	"\tmin_level\x18\x04 \x01(\x0e2'.yandex.cloud.logging.v1.LogLevel.LevelR\bminLevelB\r\n" +
	"\vdestination\")\n" +
	"\rLockboxConfig\x12\x18\n" +
	"\aenabled\x18\x01 \x01(\bR\aenabledBb\n" +
	"\x1byandex.cloud.api.airflow.v1ZCgithub.com/yandex-cloud/go-genproto/yandex/cloud/airflow/v1;airflowb\x06proto3"

var (
	file_yandex_cloud_airflow_v1_cluster_proto_rawDescOnce sync.Once
	file_yandex_cloud_airflow_v1_cluster_proto_rawDescData []byte
)

func file_yandex_cloud_airflow_v1_cluster_proto_rawDescGZIP() []byte {
	file_yandex_cloud_airflow_v1_cluster_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_airflow_v1_cluster_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_airflow_v1_cluster_proto_rawDesc), len(file_yandex_cloud_airflow_v1_cluster_proto_rawDesc)))
	})
	return file_yandex_cloud_airflow_v1_cluster_proto_rawDescData
}

var file_yandex_cloud_airflow_v1_cluster_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_yandex_cloud_airflow_v1_cluster_proto_msgTypes = make([]protoimpl.MessageInfo, 18)
var file_yandex_cloud_airflow_v1_cluster_proto_goTypes = []any{
	(Cluster_Status)(0),           // 0: yandex.cloud.airflow.v1.Cluster.Status
	(*Cluster)(nil),               // 1: yandex.cloud.airflow.v1.Cluster
	(*Monitoring)(nil),            // 2: yandex.cloud.airflow.v1.Monitoring
	(*ClusterConfig)(nil),         // 3: yandex.cloud.airflow.v1.ClusterConfig
	(*AirflowConfig)(nil),         // 4: yandex.cloud.airflow.v1.AirflowConfig
	(*WebserverConfig)(nil),       // 5: yandex.cloud.airflow.v1.WebserverConfig
	(*SchedulerConfig)(nil),       // 6: yandex.cloud.airflow.v1.SchedulerConfig
	(*DagProcessorConfig)(nil),    // 7: yandex.cloud.airflow.v1.DagProcessorConfig
	(*TriggererConfig)(nil),       // 8: yandex.cloud.airflow.v1.TriggererConfig
	(*WorkerConfig)(nil),          // 9: yandex.cloud.airflow.v1.WorkerConfig
	(*Dependencies)(nil),          // 10: yandex.cloud.airflow.v1.Dependencies
	(*NetworkConfig)(nil),         // 11: yandex.cloud.airflow.v1.NetworkConfig
	(*S3Config)(nil),              // 12: yandex.cloud.airflow.v1.S3Config
	(*GitSyncConfig)(nil),         // 13: yandex.cloud.airflow.v1.GitSyncConfig
	(*CodeSyncConfig)(nil),        // 14: yandex.cloud.airflow.v1.CodeSyncConfig
	(*LoggingConfig)(nil),         // 15: yandex.cloud.airflow.v1.LoggingConfig
	(*LockboxConfig)(nil),         // 16: yandex.cloud.airflow.v1.LockboxConfig
	nil,                           // 17: yandex.cloud.airflow.v1.Cluster.LabelsEntry
	nil,                           // 18: yandex.cloud.airflow.v1.AirflowConfig.ConfigEntry
	(*timestamppb.Timestamp)(nil), // 19: google.protobuf.Timestamp
	(Health)(0),                   // 20: yandex.cloud.airflow.v1.Health
	(*MaintenanceWindow)(nil),     // 21: yandex.cloud.airflow.v1.MaintenanceWindow
	(*MaintenanceOperation)(nil),  // 22: yandex.cloud.airflow.v1.MaintenanceOperation
	(*Resources)(nil),             // 23: yandex.cloud.airflow.v1.Resources
	(v1.LogLevel_Level)(0),        // 24: yandex.cloud.logging.v1.LogLevel.Level
}
var file_yandex_cloud_airflow_v1_cluster_proto_depIdxs = []int32{
	19, // 0: yandex.cloud.airflow.v1.Cluster.created_at:type_name -> google.protobuf.Timestamp
	17, // 1: yandex.cloud.airflow.v1.Cluster.labels:type_name -> yandex.cloud.airflow.v1.Cluster.LabelsEntry
	2,  // 2: yandex.cloud.airflow.v1.Cluster.monitoring:type_name -> yandex.cloud.airflow.v1.Monitoring
	3,  // 3: yandex.cloud.airflow.v1.Cluster.config:type_name -> yandex.cloud.airflow.v1.ClusterConfig
	20, // 4: yandex.cloud.airflow.v1.Cluster.health:type_name -> yandex.cloud.airflow.v1.Health
	0,  // 5: yandex.cloud.airflow.v1.Cluster.status:type_name -> yandex.cloud.airflow.v1.Cluster.Status
	11, // 6: yandex.cloud.airflow.v1.Cluster.network:type_name -> yandex.cloud.airflow.v1.NetworkConfig
	14, // 7: yandex.cloud.airflow.v1.Cluster.code_sync:type_name -> yandex.cloud.airflow.v1.CodeSyncConfig
	15, // 8: yandex.cloud.airflow.v1.Cluster.logging:type_name -> yandex.cloud.airflow.v1.LoggingConfig
	21, // 9: yandex.cloud.airflow.v1.Cluster.maintenance_window:type_name -> yandex.cloud.airflow.v1.MaintenanceWindow
	22, // 10: yandex.cloud.airflow.v1.Cluster.planned_operation:type_name -> yandex.cloud.airflow.v1.MaintenanceOperation
	4,  // 11: yandex.cloud.airflow.v1.ClusterConfig.airflow:type_name -> yandex.cloud.airflow.v1.AirflowConfig
	5,  // 12: yandex.cloud.airflow.v1.ClusterConfig.webserver:type_name -> yandex.cloud.airflow.v1.WebserverConfig
	6,  // 13: yandex.cloud.airflow.v1.ClusterConfig.scheduler:type_name -> yandex.cloud.airflow.v1.SchedulerConfig
	8,  // 14: yandex.cloud.airflow.v1.ClusterConfig.triggerer:type_name -> yandex.cloud.airflow.v1.TriggererConfig
	9,  // 15: yandex.cloud.airflow.v1.ClusterConfig.worker:type_name -> yandex.cloud.airflow.v1.WorkerConfig
	10, // 16: yandex.cloud.airflow.v1.ClusterConfig.dependencies:type_name -> yandex.cloud.airflow.v1.Dependencies
	16, // 17: yandex.cloud.airflow.v1.ClusterConfig.lockbox:type_name -> yandex.cloud.airflow.v1.LockboxConfig
	7,  // 18: yandex.cloud.airflow.v1.ClusterConfig.dag_processor:type_name -> yandex.cloud.airflow.v1.DagProcessorConfig
	18, // 19: yandex.cloud.airflow.v1.AirflowConfig.config:type_name -> yandex.cloud.airflow.v1.AirflowConfig.ConfigEntry
	23, // 20: yandex.cloud.airflow.v1.WebserverConfig.resources:type_name -> yandex.cloud.airflow.v1.Resources
	23, // 21: yandex.cloud.airflow.v1.SchedulerConfig.resources:type_name -> yandex.cloud.airflow.v1.Resources
	23, // 22: yandex.cloud.airflow.v1.DagProcessorConfig.resources:type_name -> yandex.cloud.airflow.v1.Resources
	23, // 23: yandex.cloud.airflow.v1.TriggererConfig.resources:type_name -> yandex.cloud.airflow.v1.Resources
	23, // 24: yandex.cloud.airflow.v1.WorkerConfig.resources:type_name -> yandex.cloud.airflow.v1.Resources
	12, // 25: yandex.cloud.airflow.v1.CodeSyncConfig.s3:type_name -> yandex.cloud.airflow.v1.S3Config
	13, // 26: yandex.cloud.airflow.v1.CodeSyncConfig.git_sync:type_name -> yandex.cloud.airflow.v1.GitSyncConfig
	24, // 27: yandex.cloud.airflow.v1.LoggingConfig.min_level:type_name -> yandex.cloud.logging.v1.LogLevel.Level
	28, // [28:28] is the sub-list for method output_type
	28, // [28:28] is the sub-list for method input_type
	28, // [28:28] is the sub-list for extension type_name
	28, // [28:28] is the sub-list for extension extendee
	0,  // [0:28] is the sub-list for field type_name
}

func init() { file_yandex_cloud_airflow_v1_cluster_proto_init() }
func file_yandex_cloud_airflow_v1_cluster_proto_init() {
	if File_yandex_cloud_airflow_v1_cluster_proto != nil {
		return
	}
	file_yandex_cloud_airflow_v1_common_proto_init()
	file_yandex_cloud_airflow_v1_maintenance_proto_init()
	file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[13].OneofWrappers = []any{
		(*CodeSyncConfig_S3)(nil),
		(*CodeSyncConfig_GitSync)(nil),
	}
	file_yandex_cloud_airflow_v1_cluster_proto_msgTypes[14].OneofWrappers = []any{
		(*LoggingConfig_FolderId)(nil),
		(*LoggingConfig_LogGroupId)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_airflow_v1_cluster_proto_rawDesc), len(file_yandex_cloud_airflow_v1_cluster_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   18,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_airflow_v1_cluster_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_airflow_v1_cluster_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_airflow_v1_cluster_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_airflow_v1_cluster_proto_msgTypes,
	}.Build()
	File_yandex_cloud_airflow_v1_cluster_proto = out.File
	file_yandex_cloud_airflow_v1_cluster_proto_goTypes = nil
	file_yandex_cloud_airflow_v1_cluster_proto_depIdxs = nil
}
