// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        v3.21.12
// source: yandex/cloud/cdn/v1/resource.proto

package cdn

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This option defines the protocol that will be used by CDN servers to request
// content from an origin source. If not specified, we will use HTTP to connect
// to an origin server.
type OriginProtocol int32

const (
	OriginProtocol_ORIGIN_PROTOCOL_UNSPECIFIED OriginProtocol = 0
	// CDN servers will connect to your origin via HTTP.
	OriginProtocol_HTTP OriginProtocol = 1
	// CDN servers will connect to your origin via HTTPS.
	OriginProtocol_HTTPS OriginProtocol = 2
	// Connection protocol will be chosen automatically (content on the
	// origin source should be available for the CDN both through HTTP and HTTPS).
	OriginProtocol_MATCH OriginProtocol = 3
)

// Enum value maps for OriginProtocol.
var (
	OriginProtocol_name = map[int32]string{
		0: "ORIGIN_PROTOCOL_UNSPECIFIED",
		1: "HTTP",
		2: "HTTPS",
		3: "MATCH",
	}
	OriginProtocol_value = map[string]int32{
		"ORIGIN_PROTOCOL_UNSPECIFIED": 0,
		"HTTP":                        1,
		"HTTPS":                       2,
		"MATCH":                       3,
	}
)

func (x OriginProtocol) Enum() *OriginProtocol {
	p := new(OriginProtocol)
	*p = x
	return p
}

func (x OriginProtocol) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OriginProtocol) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_cdn_v1_resource_proto_enumTypes[0].Descriptor()
}

func (OriginProtocol) Type() protoreflect.EnumType {
	return &file_yandex_cloud_cdn_v1_resource_proto_enumTypes[0]
}

func (x OriginProtocol) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OriginProtocol.Descriptor instead.
func (OriginProtocol) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{0}
}

// RewriteFlag defines flag for the Rewrite option.
type RewriteFlag int32

const (
	RewriteFlag_REWRITE_FLAG_UNSPECIFIED RewriteFlag = 0
	// Stops processing of the current set of ngx_http_rewrite_module directives and
	// starts a search for a new location matching changed URI.
	RewriteFlag_LAST RewriteFlag = 1
	// Stops processing of the current set of the Rewrite option.
	RewriteFlag_BREAK RewriteFlag = 2
	// Returns a temporary redirect with the 302 code; It is used when a replacement string does not start
	// with "http://", "https://", or "$scheme".
	RewriteFlag_REDIRECT RewriteFlag = 3
	// Returns a permanent redirect with the 301 code.
	RewriteFlag_PERMANENT RewriteFlag = 4
)

// Enum value maps for RewriteFlag.
var (
	RewriteFlag_name = map[int32]string{
		0: "REWRITE_FLAG_UNSPECIFIED",
		1: "LAST",
		2: "BREAK",
		3: "REDIRECT",
		4: "PERMANENT",
	}
	RewriteFlag_value = map[string]int32{
		"REWRITE_FLAG_UNSPECIFIED": 0,
		"LAST":                     1,
		"BREAK":                    2,
		"REDIRECT":                 3,
		"PERMANENT":                4,
	}
)

func (x RewriteFlag) Enum() *RewriteFlag {
	p := new(RewriteFlag)
	*p = x
	return p
}

func (x RewriteFlag) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RewriteFlag) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_cdn_v1_resource_proto_enumTypes[1].Descriptor()
}

func (RewriteFlag) Type() protoreflect.EnumType {
	return &file_yandex_cloud_cdn_v1_resource_proto_enumTypes[1]
}

func (x RewriteFlag) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RewriteFlag.Descriptor instead.
func (RewriteFlag) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{1}
}

// SecureKeyURLType defines type of the URL signing.
type SecureKeyURLType int32

const (
	SecureKeyURLType_SECURE_KEY_URL_TYPE_UNSPECIFIED SecureKeyURLType = 0
	// Use scpecific IP address in URL signing. URL will be availible only for this IP.
	SecureKeyURLType_ENABLE_IP_SIGNING SecureKeyURLType = 1
	// Sign URL without using IP address. URL will be available for all IP addresses.
	SecureKeyURLType_DISABLE_IP_SIGNING SecureKeyURLType = 2
)

// Enum value maps for SecureKeyURLType.
var (
	SecureKeyURLType_name = map[int32]string{
		0: "SECURE_KEY_URL_TYPE_UNSPECIFIED",
		1: "ENABLE_IP_SIGNING",
		2: "DISABLE_IP_SIGNING",
	}
	SecureKeyURLType_value = map[string]int32{
		"SECURE_KEY_URL_TYPE_UNSPECIFIED": 0,
		"ENABLE_IP_SIGNING":               1,
		"DISABLE_IP_SIGNING":              2,
	}
)

func (x SecureKeyURLType) Enum() *SecureKeyURLType {
	p := new(SecureKeyURLType)
	*p = x
	return p
}

func (x SecureKeyURLType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SecureKeyURLType) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_cdn_v1_resource_proto_enumTypes[2].Descriptor()
}

func (SecureKeyURLType) Type() protoreflect.EnumType {
	return &file_yandex_cloud_cdn_v1_resource_proto_enumTypes[2]
}

func (x SecureKeyURLType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SecureKeyURLType.Descriptor instead.
func (SecureKeyURLType) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2}
}

// PolicyType defines type of the policy in IP address acl rules.
type PolicyType int32

const (
	PolicyType_POLICY_TYPE_UNSPECIFIED PolicyType = 0
	// Allow access to all IP addresses except the ones specified in the excepted_values field.
	PolicyType_POLICY_TYPE_ALLOW PolicyType = 1
	// Block access to all IP addresses except the ones specified in the excepted_values field.
	PolicyType_POLICY_TYPE_DENY PolicyType = 2
)

// Enum value maps for PolicyType.
var (
	PolicyType_name = map[int32]string{
		0: "POLICY_TYPE_UNSPECIFIED",
		1: "POLICY_TYPE_ALLOW",
		2: "POLICY_TYPE_DENY",
	}
	PolicyType_value = map[string]int32{
		"POLICY_TYPE_UNSPECIFIED": 0,
		"POLICY_TYPE_ALLOW":       1,
		"POLICY_TYPE_DENY":        2,
	}
)

func (x PolicyType) Enum() *PolicyType {
	p := new(PolicyType)
	*p = x
	return p
}

func (x PolicyType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PolicyType) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_cdn_v1_resource_proto_enumTypes[3].Descriptor()
}

func (PolicyType) Type() protoreflect.EnumType {
	return &file_yandex_cloud_cdn_v1_resource_proto_enumTypes[3]
}

func (x PolicyType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PolicyType.Descriptor instead.
func (PolicyType) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{3}
}

// A certificate type parameters.
type SSLCertificateType int32

const (
	// SSL certificate is unspecified.
	SSLCertificateType_SSL_CERTIFICATE_TYPE_UNSPECIFIED SSLCertificateType = 0
	// No SSL certificate is added, the requests are sent via HTTP.
	SSLCertificateType_DONT_USE SSLCertificateType = 1
	// The option is deprecated. Works only if you have already pointed your domain name to the protected IP address in your DNS.
	//
	// Deprecated: Marked as deprecated in yandex/cloud/cdn/v1/resource.proto.
	SSLCertificateType_LETS_ENCRYPT_GCORE SSLCertificateType = 2
	// Add your SSL certificate by uploading the certificate in PEM format and your private key.
	SSLCertificateType_CM SSLCertificateType = 3
)

// Enum value maps for SSLCertificateType.
var (
	SSLCertificateType_name = map[int32]string{
		0: "SSL_CERTIFICATE_TYPE_UNSPECIFIED",
		1: "DONT_USE",
		2: "LETS_ENCRYPT_GCORE",
		3: "CM",
	}
	SSLCertificateType_value = map[string]int32{
		"SSL_CERTIFICATE_TYPE_UNSPECIFIED": 0,
		"DONT_USE":                         1,
		"LETS_ENCRYPT_GCORE":               2,
		"CM":                               3,
	}
)

func (x SSLCertificateType) Enum() *SSLCertificateType {
	p := new(SSLCertificateType)
	*p = x
	return p
}

func (x SSLCertificateType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SSLCertificateType) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_cdn_v1_resource_proto_enumTypes[4].Descriptor()
}

func (SSLCertificateType) Type() protoreflect.EnumType {
	return &file_yandex_cloud_cdn_v1_resource_proto_enumTypes[4]
}

func (x SSLCertificateType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SSLCertificateType.Descriptor instead.
func (SSLCertificateType) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{4}
}

// A certificate status parameters.
type SSLCertificateStatus int32

const (
	// SSL certificate is unspecified.
	SSLCertificateStatus_SSL_CERTIFICATE_STATUS_UNSPECIFIED SSLCertificateStatus = 0
	// SSL certificate is ready to use.
	SSLCertificateStatus_READY SSLCertificateStatus = 1
	// The option is deprecated. SSL certificate is creating.
	//
	// Deprecated: Marked as deprecated in yandex/cloud/cdn/v1/resource.proto.
	SSLCertificateStatus_CREATING SSLCertificateStatus = 2
)

// Enum value maps for SSLCertificateStatus.
var (
	SSLCertificateStatus_name = map[int32]string{
		0: "SSL_CERTIFICATE_STATUS_UNSPECIFIED",
		1: "READY",
		2: "CREATING",
	}
	SSLCertificateStatus_value = map[string]int32{
		"SSL_CERTIFICATE_STATUS_UNSPECIFIED": 0,
		"READY":                              1,
		"CREATING":                           2,
	}
)

func (x SSLCertificateStatus) Enum() *SSLCertificateStatus {
	p := new(SSLCertificateStatus)
	*p = x
	return p
}

func (x SSLCertificateStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SSLCertificateStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_cdn_v1_resource_proto_enumTypes[5].Descriptor()
}

func (SSLCertificateStatus) Type() protoreflect.EnumType {
	return &file_yandex_cloud_cdn_v1_resource_proto_enumTypes[5]
}

func (x SSLCertificateStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SSLCertificateStatus.Descriptor instead.
func (SSLCertificateStatus) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{5}
}

// List of secondary (alternative) CNAMEs.
type SecondaryHostnames struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of secondary hostname values.
	Values        []string `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SecondaryHostnames) Reset() {
	*x = SecondaryHostnames{}
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SecondaryHostnames) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecondaryHostnames) ProtoMessage() {}

func (x *SecondaryHostnames) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecondaryHostnames.ProtoReflect.Descriptor instead.
func (*SecondaryHostnames) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{0}
}

func (x *SecondaryHostnames) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

// A CDN resource - representation of providers resource.
type Resource struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the resource.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Folder id.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// CDN endpoint CNAME, must be unique among resources.
	Cname string `protobuf:"bytes,3,opt,name=cname,proto3" json:"cname,omitempty"`
	// Creation timestamp.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Update timestamp.
	UpdatedAt *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	// Flag to create Resource either in active or disabled state.
	// True - the content from CDN is available to clients.
	// False - the content from CDN isn't available to clients.
	Active bool `protobuf:"varint,6,opt,name=active,proto3" json:"active,omitempty"`
	// Resource settings and options to tune CDN edge behavior.
	Options *ResourceOptions `protobuf:"bytes,7,opt,name=options,proto3" json:"options,omitempty"`
	// List of secondary hostname strings.
	SecondaryHostnames []string `protobuf:"bytes,8,rep,name=secondary_hostnames,json=secondaryHostnames,proto3" json:"secondary_hostnames,omitempty"`
	// ID of the origin group.
	OriginGroupId int64 `protobuf:"varint,9,opt,name=origin_group_id,json=originGroupId,proto3" json:"origin_group_id,omitempty"`
	// Name of the origin group.
	OriginGroupName string `protobuf:"bytes,10,opt,name=origin_group_name,json=originGroupName,proto3" json:"origin_group_name,omitempty"`
	// Specify the protocol schema to be used in communication with origin.
	OriginProtocol OriginProtocol `protobuf:"varint,11,opt,name=origin_protocol,json=originProtocol,proto3,enum=yandex.cloud.cdn.v1.OriginProtocol" json:"origin_protocol,omitempty"`
	// SSL certificate options.
	SslCertificate *SSLCertificate `protobuf:"bytes,12,opt,name=ssl_certificate,json=sslCertificate,proto3" json:"ssl_certificate,omitempty"`
	// Labels of the resource.
	Labels map[string]string `protobuf:"bytes,13,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Type of the CDN provider for this resource.
	ProviderType string `protobuf:"bytes,14,opt,name=provider_type,json=providerType,proto3" json:"provider_type,omitempty"`
	// CNAME provided by the CDN provider for this resource.
	ProviderCname string `protobuf:"bytes,15,opt,name=provider_cname,json=providerCname,proto3" json:"provider_cname,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Resource) Reset() {
	*x = Resource{}
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Resource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Resource) ProtoMessage() {}

func (x *Resource) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Resource.ProtoReflect.Descriptor instead.
func (*Resource) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{1}
}

func (x *Resource) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Resource) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *Resource) GetCname() string {
	if x != nil {
		return x.Cname
	}
	return ""
}

func (x *Resource) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *Resource) GetUpdatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedAt
	}
	return nil
}

func (x *Resource) GetActive() bool {
	if x != nil {
		return x.Active
	}
	return false
}

func (x *Resource) GetOptions() *ResourceOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *Resource) GetSecondaryHostnames() []string {
	if x != nil {
		return x.SecondaryHostnames
	}
	return nil
}

func (x *Resource) GetOriginGroupId() int64 {
	if x != nil {
		return x.OriginGroupId
	}
	return 0
}

func (x *Resource) GetOriginGroupName() string {
	if x != nil {
		return x.OriginGroupName
	}
	return ""
}

func (x *Resource) GetOriginProtocol() OriginProtocol {
	if x != nil {
		return x.OriginProtocol
	}
	return OriginProtocol_ORIGIN_PROTOCOL_UNSPECIFIED
}

func (x *Resource) GetSslCertificate() *SSLCertificate {
	if x != nil {
		return x.SslCertificate
	}
	return nil
}

func (x *Resource) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Resource) GetProviderType() string {
	if x != nil {
		return x.ProviderType
	}
	return ""
}

func (x *Resource) GetProviderCname() string {
	if x != nil {
		return x.ProviderCname
	}
	return ""
}

// A major set of various resource options.
type ResourceOptions struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Set up a cache status.
	DisableCache *ResourceOptions_BoolOption `protobuf:"bytes,1,opt,name=disable_cache,json=disableCache,proto3" json:"disable_cache,omitempty"`
	// Set up [EdgeCacheSettings].
	EdgeCacheSettings *ResourceOptions_EdgeCacheSettings `protobuf:"bytes,2,opt,name=edge_cache_settings,json=edgeCacheSettings,proto3" json:"edge_cache_settings,omitempty"`
	// Using [Int64Option]. Set up a cache period for the end-users browser.
	// Content will be cached due to origin settings.
	// If there are no cache settings on your origin, the content will not be cached.
	// The list of HTTP response codes that can be cached in browsers: 200, 201, 204, 206, 301, 302, 303, 304, 307, 308.
	// Other response codes will not be cached.
	// The default value is 4 days.
	BrowserCacheSettings *ResourceOptions_Int64Option `protobuf:"bytes,3,opt,name=browser_cache_settings,json=browserCacheSettings,proto3" json:"browser_cache_settings,omitempty"`
	// List HTTP headers that must be included in responses to clients.
	CacheHttpHeaders *ResourceOptions_StringsListOption `protobuf:"bytes,4,opt,name=cache_http_headers,json=cacheHttpHeaders,proto3" json:"cache_http_headers,omitempty"`
	// Set up [QueryParamsOptions].
	QueryParamsOptions *ResourceOptions_QueryParamsOptions `protobuf:"bytes,5,opt,name=query_params_options,json=queryParamsOptions,proto3" json:"query_params_options,omitempty"`
	// Files larger than 10 MB will be requested and cached in parts (no larger than 10 MB each part). It reduces time to first byte.
	//
	// The origin must support HTTP Range requests.
	//
	// By default the option is disabled.
	Slice *ResourceOptions_BoolOption `protobuf:"bytes,6,opt,name=slice,proto3" json:"slice,omitempty"`
	// Set up compression variant.
	CompressionOptions *ResourceOptions_CompressionOptions `protobuf:"bytes,7,opt,name=compression_options,json=compressionOptions,proto3" json:"compression_options,omitempty"`
	// Set up redirects.
	RedirectOptions *ResourceOptions_RedirectOptions `protobuf:"bytes,8,opt,name=redirect_options,json=redirectOptions,proto3" json:"redirect_options,omitempty"`
	// Set up host parameters.
	HostOptions *ResourceOptions_HostOptions `protobuf:"bytes,9,opt,name=host_options,json=hostOptions,proto3" json:"host_options,omitempty"`
	// Set up static headers that CDN servers send in responses to clients.
	StaticHeaders *ResourceOptions_StringsMapOption `protobuf:"bytes,10,opt,name=static_headers,json=staticHeaders,proto3" json:"static_headers,omitempty"`
	// Parameter that lets browsers get access to selected resources from a domain
	// different to a domain from which the request is received.
	// [Read more](/docs/cdn/concepts/cors).
	Cors *ResourceOptions_StringsListOption `protobuf:"bytes,11,opt,name=cors,proto3" json:"cors,omitempty"`
	// List of errors which instruct CDN servers to serve stale content to clients.
	//
	// Possible values: `error`, `http_403`, `http_404`, `http_429`, `http_500`, `http_502`, `http_503`, `http_504`, `invalid_header`, `timeout`, `updating`.
	Stale *ResourceOptions_StringsListOption `protobuf:"bytes,12,opt,name=stale,proto3" json:"stale,omitempty"`
	// HTTP methods for your CDN content. By default the following methods
	// are allowed: GET, HEAD, POST, PUT, PATCH, DELETE, OPTIONS.
	// In case some methods are not allowed to the user, they will get the 405
	// (Method Not Allowed) response. If the method is not supported,
	// the user gets the 501 (Not Implemented) response.
	AllowedHttpMethods *ResourceOptions_StringsListOption `protobuf:"bytes,13,opt,name=allowed_http_methods,json=allowedHttpMethods,proto3" json:"allowed_http_methods,omitempty"`
	// Allows caching for GET, HEAD and POST requests.
	ProxyCacheMethodsSet *ResourceOptions_BoolOption `protobuf:"bytes,14,opt,name=proxy_cache_methods_set,json=proxyCacheMethodsSet,proto3" json:"proxy_cache_methods_set,omitempty"`
	// Disabling proxy force ranges.
	DisableProxyForceRanges *ResourceOptions_BoolOption `protobuf:"bytes,15,opt,name=disable_proxy_force_ranges,json=disableProxyForceRanges,proto3" json:"disable_proxy_force_ranges,omitempty"`
	// Set up custom headers that CDN servers send in requests to origins.
	// The Header name field can contain letters (A-Z, a-z), numbers (0-9), dashes (-) and underscores (_).
	// The Value field can contain letters (A-Z, a-z), numbers (0-9), dashes (-),
	// underscores (_), slashes (/), colons (:), equal (=), dots (.), and spaces.
	StaticRequestHeaders *ResourceOptions_StringsMapOption `protobuf:"bytes,16,opt,name=static_request_headers,json=staticRequestHeaders,proto3" json:"static_request_headers,omitempty"`
	// Wildcard additional CNAME.
	// If a resource has a wildcard additional CNAME, you can use your own certificate for content delivery via HTTPS. Read-only.
	CustomServerName *ResourceOptions_StringOption `protobuf:"bytes,17,opt,name=custom_server_name,json=customServerName,proto3" json:"custom_server_name,omitempty"`
	// Using [BoolOption] for ignoring cookie.
	IgnoreCookie *ResourceOptions_BoolOption `protobuf:"bytes,18,opt,name=ignore_cookie,json=ignoreCookie,proto3" json:"ignore_cookie,omitempty"`
	// Changing or redirecting query paths.
	Rewrite *ResourceOptions_RewriteOption `protobuf:"bytes,19,opt,name=rewrite,proto3" json:"rewrite,omitempty"`
	// Secure token to protect contect and limit access by IP addresses and time limits.
	SecureKey *ResourceOptions_SecureKeyOption `protobuf:"bytes,20,opt,name=secure_key,json=secureKey,proto3" json:"secure_key,omitempty"`
	// Manage the state of the IP access policy option.
	// The option controls access to content from the specified IP addresses.
	IpAddressAcl *ResourceOptions_IPAddressACLOption `protobuf:"bytes,21,opt,name=ip_address_acl,json=ipAddressAcl,proto3" json:"ip_address_acl,omitempty"`
	// Manage the state of the Redirection from origin option.
	// If the source returns a redirect, the option lets CDN pull the requested content from the source that was returned in the redirect.
	FollowRedirects *ResourceOptions_FollowRedirectsOption `protobuf:"bytes,22,opt,name=follow_redirects,json=followRedirects,proto3" json:"follow_redirects,omitempty"`
	// Configuration for WebSocket protocol support.
	Websockets *ResourceOptions_WebsocketsOption `protobuf:"bytes,23,opt,name=websockets,proto3" json:"websockets,omitempty"`
	// Configuration for HTTP response header filtering.
	// This feature allows controlling which headers from the origin are passed to end users.
	HeaderFilter  *ResourceOptions_HeaderFilterOption `protobuf:"bytes,24,opt,name=header_filter,json=headerFilter,proto3" json:"header_filter,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ResourceOptions) Reset() {
	*x = ResourceOptions{}
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions) ProtoMessage() {}

func (x *ResourceOptions) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions.ProtoReflect.Descriptor instead.
func (*ResourceOptions) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2}
}

func (x *ResourceOptions) GetDisableCache() *ResourceOptions_BoolOption {
	if x != nil {
		return x.DisableCache
	}
	return nil
}

func (x *ResourceOptions) GetEdgeCacheSettings() *ResourceOptions_EdgeCacheSettings {
	if x != nil {
		return x.EdgeCacheSettings
	}
	return nil
}

func (x *ResourceOptions) GetBrowserCacheSettings() *ResourceOptions_Int64Option {
	if x != nil {
		return x.BrowserCacheSettings
	}
	return nil
}

func (x *ResourceOptions) GetCacheHttpHeaders() *ResourceOptions_StringsListOption {
	if x != nil {
		return x.CacheHttpHeaders
	}
	return nil
}

func (x *ResourceOptions) GetQueryParamsOptions() *ResourceOptions_QueryParamsOptions {
	if x != nil {
		return x.QueryParamsOptions
	}
	return nil
}

func (x *ResourceOptions) GetSlice() *ResourceOptions_BoolOption {
	if x != nil {
		return x.Slice
	}
	return nil
}

func (x *ResourceOptions) GetCompressionOptions() *ResourceOptions_CompressionOptions {
	if x != nil {
		return x.CompressionOptions
	}
	return nil
}

func (x *ResourceOptions) GetRedirectOptions() *ResourceOptions_RedirectOptions {
	if x != nil {
		return x.RedirectOptions
	}
	return nil
}

func (x *ResourceOptions) GetHostOptions() *ResourceOptions_HostOptions {
	if x != nil {
		return x.HostOptions
	}
	return nil
}

func (x *ResourceOptions) GetStaticHeaders() *ResourceOptions_StringsMapOption {
	if x != nil {
		return x.StaticHeaders
	}
	return nil
}

func (x *ResourceOptions) GetCors() *ResourceOptions_StringsListOption {
	if x != nil {
		return x.Cors
	}
	return nil
}

func (x *ResourceOptions) GetStale() *ResourceOptions_StringsListOption {
	if x != nil {
		return x.Stale
	}
	return nil
}

func (x *ResourceOptions) GetAllowedHttpMethods() *ResourceOptions_StringsListOption {
	if x != nil {
		return x.AllowedHttpMethods
	}
	return nil
}

func (x *ResourceOptions) GetProxyCacheMethodsSet() *ResourceOptions_BoolOption {
	if x != nil {
		return x.ProxyCacheMethodsSet
	}
	return nil
}

func (x *ResourceOptions) GetDisableProxyForceRanges() *ResourceOptions_BoolOption {
	if x != nil {
		return x.DisableProxyForceRanges
	}
	return nil
}

func (x *ResourceOptions) GetStaticRequestHeaders() *ResourceOptions_StringsMapOption {
	if x != nil {
		return x.StaticRequestHeaders
	}
	return nil
}

func (x *ResourceOptions) GetCustomServerName() *ResourceOptions_StringOption {
	if x != nil {
		return x.CustomServerName
	}
	return nil
}

func (x *ResourceOptions) GetIgnoreCookie() *ResourceOptions_BoolOption {
	if x != nil {
		return x.IgnoreCookie
	}
	return nil
}

func (x *ResourceOptions) GetRewrite() *ResourceOptions_RewriteOption {
	if x != nil {
		return x.Rewrite
	}
	return nil
}

func (x *ResourceOptions) GetSecureKey() *ResourceOptions_SecureKeyOption {
	if x != nil {
		return x.SecureKey
	}
	return nil
}

func (x *ResourceOptions) GetIpAddressAcl() *ResourceOptions_IPAddressACLOption {
	if x != nil {
		return x.IpAddressAcl
	}
	return nil
}

func (x *ResourceOptions) GetFollowRedirects() *ResourceOptions_FollowRedirectsOption {
	if x != nil {
		return x.FollowRedirects
	}
	return nil
}

func (x *ResourceOptions) GetWebsockets() *ResourceOptions_WebsocketsOption {
	if x != nil {
		return x.Websockets
	}
	return nil
}

func (x *ResourceOptions) GetHeaderFilter() *ResourceOptions_HeaderFilterOption {
	if x != nil {
		return x.HeaderFilter
	}
	return nil
}

// A set of the personal SSL certificate parameters.
type SSLTargetCertificate struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Type of the certificate.
	Type SSLCertificateType `protobuf:"varint,1,opt,name=type,proto3,enum=yandex.cloud.cdn.v1.SSLCertificateType" json:"type,omitempty"`
	// Certificate data.
	Data          *SSLCertificateData `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SSLTargetCertificate) Reset() {
	*x = SSLTargetCertificate{}
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SSLTargetCertificate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SSLTargetCertificate) ProtoMessage() {}

func (x *SSLTargetCertificate) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SSLTargetCertificate.ProtoReflect.Descriptor instead.
func (*SSLTargetCertificate) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{3}
}

func (x *SSLTargetCertificate) GetType() SSLCertificateType {
	if x != nil {
		return x.Type
	}
	return SSLCertificateType_SSL_CERTIFICATE_TYPE_UNSPECIFIED
}

func (x *SSLTargetCertificate) GetData() *SSLCertificateData {
	if x != nil {
		return x.Data
	}
	return nil
}

// A SSL certificate parameters.
type SSLCertificate struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Type of the certificate.
	Type SSLCertificateType `protobuf:"varint,1,opt,name=type,proto3,enum=yandex.cloud.cdn.v1.SSLCertificateType" json:"type,omitempty"`
	// Active status.
	Status SSLCertificateStatus `protobuf:"varint,2,opt,name=status,proto3,enum=yandex.cloud.cdn.v1.SSLCertificateStatus" json:"status,omitempty"`
	// Certificate data.
	Data          *SSLCertificateData `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SSLCertificate) Reset() {
	*x = SSLCertificate{}
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SSLCertificate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SSLCertificate) ProtoMessage() {}

func (x *SSLCertificate) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SSLCertificate.ProtoReflect.Descriptor instead.
func (*SSLCertificate) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{4}
}

func (x *SSLCertificate) GetType() SSLCertificateType {
	if x != nil {
		return x.Type
	}
	return SSLCertificateType_SSL_CERTIFICATE_TYPE_UNSPECIFIED
}

func (x *SSLCertificate) GetStatus() SSLCertificateStatus {
	if x != nil {
		return x.Status
	}
	return SSLCertificateStatus_SSL_CERTIFICATE_STATUS_UNSPECIFIED
}

func (x *SSLCertificate) GetData() *SSLCertificateData {
	if x != nil {
		return x.Data
	}
	return nil
}

// A certificate data parameters.
type SSLCertificateData struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to SslCertificateDataVariant:
	//
	//	*SSLCertificateData_Cm
	SslCertificateDataVariant isSSLCertificateData_SslCertificateDataVariant `protobuf_oneof:"ssl_certificate_data_variant"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *SSLCertificateData) Reset() {
	*x = SSLCertificateData{}
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SSLCertificateData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SSLCertificateData) ProtoMessage() {}

func (x *SSLCertificateData) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SSLCertificateData.ProtoReflect.Descriptor instead.
func (*SSLCertificateData) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{5}
}

func (x *SSLCertificateData) GetSslCertificateDataVariant() isSSLCertificateData_SslCertificateDataVariant {
	if x != nil {
		return x.SslCertificateDataVariant
	}
	return nil
}

func (x *SSLCertificateData) GetCm() *SSLCertificateCMData {
	if x != nil {
		if x, ok := x.SslCertificateDataVariant.(*SSLCertificateData_Cm); ok {
			return x.Cm
		}
	}
	return nil
}

type isSSLCertificateData_SslCertificateDataVariant interface {
	isSSLCertificateData_SslCertificateDataVariant()
}

type SSLCertificateData_Cm struct {
	// Custom (add your SSL certificate by uploading the certificate
	// in PEM format and your private key).
	Cm *SSLCertificateCMData `protobuf:"bytes,1,opt,name=cm,proto3,oneof"`
}

func (*SSLCertificateData_Cm) isSSLCertificateData_SslCertificateDataVariant() {}

// A certificate data custom parameters.
type SSLCertificateCMData struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the custom certificate.
	Id            string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SSLCertificateCMData) Reset() {
	*x = SSLCertificateCMData{}
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SSLCertificateCMData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SSLCertificateCMData) ProtoMessage() {}

func (x *SSLCertificateCMData) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SSLCertificateCMData.ProtoReflect.Descriptor instead.
func (*SSLCertificateCMData) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{6}
}

func (x *SSLCertificateCMData) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

// Set up bool values.
type ResourceOptions_BoolOption struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// True - the option is enabled and its [value] is applied to the resource.
	// False - the option is disabled and its default value is used for the resource.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Value of the option.
	Value         bool `protobuf:"varint,2,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ResourceOptions_BoolOption) Reset() {
	*x = ResourceOptions_BoolOption{}
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceOptions_BoolOption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions_BoolOption) ProtoMessage() {}

func (x *ResourceOptions_BoolOption) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions_BoolOption.ProtoReflect.Descriptor instead.
func (*ResourceOptions_BoolOption) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2, 0}
}

func (x *ResourceOptions_BoolOption) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *ResourceOptions_BoolOption) GetValue() bool {
	if x != nil {
		return x.Value
	}
	return false
}

// A set of the string parameters.
type ResourceOptions_StringOption struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// True - the option is enabled and its [value] is applied to the resource.
	// False - the option is disabled and its default value is used for the resource.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Value of the option.
	Value         string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ResourceOptions_StringOption) Reset() {
	*x = ResourceOptions_StringOption{}
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceOptions_StringOption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions_StringOption) ProtoMessage() {}

func (x *ResourceOptions_StringOption) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions_StringOption.ProtoReflect.Descriptor instead.
func (*ResourceOptions_StringOption) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2, 1}
}

func (x *ResourceOptions_StringOption) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *ResourceOptions_StringOption) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// A set of the numeric parameters.
type ResourceOptions_Int64Option struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// True - the option is enabled and its [value] is applied to the resource.
	// False - the option is disabled and its default value is used for the resource.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Value of the option.
	Value         int64 `protobuf:"varint,2,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ResourceOptions_Int64Option) Reset() {
	*x = ResourceOptions_Int64Option{}
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceOptions_Int64Option) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions_Int64Option) ProtoMessage() {}

func (x *ResourceOptions_Int64Option) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions_Int64Option.ProtoReflect.Descriptor instead.
func (*ResourceOptions_Int64Option) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2, 2}
}

func (x *ResourceOptions_Int64Option) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *ResourceOptions_Int64Option) GetValue() int64 {
	if x != nil {
		return x.Value
	}
	return 0
}

// A set of the string list parameters.
type ResourceOptions_StringsListOption struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// True - the option is enabled and its [value] is applied to the resource.
	// False - the option is disabled and its default value is used for the resource.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Value of the option.
	Value         []string `protobuf:"bytes,2,rep,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ResourceOptions_StringsListOption) Reset() {
	*x = ResourceOptions_StringsListOption{}
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceOptions_StringsListOption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions_StringsListOption) ProtoMessage() {}

func (x *ResourceOptions_StringsListOption) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions_StringsListOption.ProtoReflect.Descriptor instead.
func (*ResourceOptions_StringsListOption) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2, 3}
}

func (x *ResourceOptions_StringsListOption) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *ResourceOptions_StringsListOption) GetValue() []string {
	if x != nil {
		return x.Value
	}
	return nil
}

// A set of the strings map parameters.
type ResourceOptions_StringsMapOption struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// True - the option is enabled and its [value] is applied to the resource.
	// False - the option is disabled and its default value is used for the resource.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Value of the option.
	Value         map[string]string `protobuf:"bytes,2,rep,name=value,proto3" json:"value,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ResourceOptions_StringsMapOption) Reset() {
	*x = ResourceOptions_StringsMapOption{}
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceOptions_StringsMapOption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions_StringsMapOption) ProtoMessage() {}

func (x *ResourceOptions_StringsMapOption) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions_StringsMapOption.ProtoReflect.Descriptor instead.
func (*ResourceOptions_StringsMapOption) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2, 4}
}

func (x *ResourceOptions_StringsMapOption) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *ResourceOptions_StringsMapOption) GetValue() map[string]string {
	if x != nil {
		return x.Value
	}
	return nil
}

// A set of the caching response time parameters.
type ResourceOptions_CachingTimes struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Caching time for a response with codes 200, 206, 301, 302.
	// Responses with codes 4xx, 5xx will not be cached. Use `0s` disable to caching.
	// Use [custom_values] field to specify a custom caching time for a response with specific codes.
	SimpleValue int64 `protobuf:"varint,1,opt,name=simple_value,json=simpleValue,proto3" json:"simple_value,omitempty"`
	// Caching time for a response with specific codes. These settings have a higher priority than the value field.
	// Response code (`304`, `404` for example). Use `any` to specify caching time for all response codes.
	// Caching time in seconds (`0s`, `600s` for example). Use `0s` to disable caching for a specific response code.
	CustomValues  map[string]int64 `protobuf:"bytes,2,rep,name=custom_values,json=customValues,proto3" json:"custom_values,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ResourceOptions_CachingTimes) Reset() {
	*x = ResourceOptions_CachingTimes{}
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceOptions_CachingTimes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions_CachingTimes) ProtoMessage() {}

func (x *ResourceOptions_CachingTimes) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions_CachingTimes.ProtoReflect.Descriptor instead.
func (*ResourceOptions_CachingTimes) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2, 5}
}

func (x *ResourceOptions_CachingTimes) GetSimpleValue() int64 {
	if x != nil {
		return x.SimpleValue
	}
	return 0
}

func (x *ResourceOptions_CachingTimes) GetCustomValues() map[string]int64 {
	if x != nil {
		return x.CustomValues
	}
	return nil
}

// A set of the edge cache parameters.
type ResourceOptions_EdgeCacheSettings struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// True - the option is enabled and its `values_variant` is applied to the resource.
	// False - the option is disabled and its default value is used for the resource.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Types that are valid to be assigned to ValuesVariant:
	//
	//	*ResourceOptions_EdgeCacheSettings_Value
	//	*ResourceOptions_EdgeCacheSettings_DefaultValue
	ValuesVariant isResourceOptions_EdgeCacheSettings_ValuesVariant `protobuf_oneof:"values_variant"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ResourceOptions_EdgeCacheSettings) Reset() {
	*x = ResourceOptions_EdgeCacheSettings{}
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceOptions_EdgeCacheSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions_EdgeCacheSettings) ProtoMessage() {}

func (x *ResourceOptions_EdgeCacheSettings) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions_EdgeCacheSettings.ProtoReflect.Descriptor instead.
func (*ResourceOptions_EdgeCacheSettings) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2, 6}
}

func (x *ResourceOptions_EdgeCacheSettings) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *ResourceOptions_EdgeCacheSettings) GetValuesVariant() isResourceOptions_EdgeCacheSettings_ValuesVariant {
	if x != nil {
		return x.ValuesVariant
	}
	return nil
}

func (x *ResourceOptions_EdgeCacheSettings) GetValue() *ResourceOptions_CachingTimes {
	if x != nil {
		if x, ok := x.ValuesVariant.(*ResourceOptions_EdgeCacheSettings_Value); ok {
			return x.Value
		}
	}
	return nil
}

func (x *ResourceOptions_EdgeCacheSettings) GetDefaultValue() int64 {
	if x != nil {
		if x, ok := x.ValuesVariant.(*ResourceOptions_EdgeCacheSettings_DefaultValue); ok {
			return x.DefaultValue
		}
	}
	return 0
}

type isResourceOptions_EdgeCacheSettings_ValuesVariant interface {
	isResourceOptions_EdgeCacheSettings_ValuesVariant()
}

type ResourceOptions_EdgeCacheSettings_Value struct {
	// Value of the option.
	Value *ResourceOptions_CachingTimes `protobuf:"bytes,2,opt,name=value,proto3,oneof"`
}

type ResourceOptions_EdgeCacheSettings_DefaultValue struct {
	// Content will be cached according to origin cache settings.
	// The value applies for a response with codes 200, 201, 204, 206, 301, 302, 303, 304, 307, 308
	// if an origin server does not have caching HTTP headers.
	// Responses with other codes will not be cached.
	DefaultValue int64 `protobuf:"varint,3,opt,name=default_value,json=defaultValue,proto3,oneof"`
}

func (*ResourceOptions_EdgeCacheSettings_Value) isResourceOptions_EdgeCacheSettings_ValuesVariant() {}

func (*ResourceOptions_EdgeCacheSettings_DefaultValue) isResourceOptions_EdgeCacheSettings_ValuesVariant() {
}

// A set of the string variable map parameters.
type ResourceOptions_StringVariableMapOption struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// True - the option is enabled and its [value] is applied to the resource.
	// False - the option is disabled and its default value is used for the resource.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Value of the option.
	Value         map[string]*ResourceOptions_StringVariableMapOption_OneofString `protobuf:"bytes,2,rep,name=value,proto3" json:"value,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ResourceOptions_StringVariableMapOption) Reset() {
	*x = ResourceOptions_StringVariableMapOption{}
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceOptions_StringVariableMapOption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions_StringVariableMapOption) ProtoMessage() {}

func (x *ResourceOptions_StringVariableMapOption) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions_StringVariableMapOption.ProtoReflect.Descriptor instead.
func (*ResourceOptions_StringVariableMapOption) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2, 7}
}

func (x *ResourceOptions_StringVariableMapOption) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *ResourceOptions_StringVariableMapOption) GetValue() map[string]*ResourceOptions_StringVariableMapOption_OneofString {
	if x != nil {
		return x.Value
	}
	return nil
}

// A set of the query parameters.
type ResourceOptions_QueryParamsOptions struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to QueryParamsVariant:
	//
	//	*ResourceOptions_QueryParamsOptions_IgnoreQueryString
	//	*ResourceOptions_QueryParamsOptions_QueryParamsWhitelist
	//	*ResourceOptions_QueryParamsOptions_QueryParamsBlacklist
	QueryParamsVariant isResourceOptions_QueryParamsOptions_QueryParamsVariant `protobuf_oneof:"query_params_variant"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *ResourceOptions_QueryParamsOptions) Reset() {
	*x = ResourceOptions_QueryParamsOptions{}
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceOptions_QueryParamsOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions_QueryParamsOptions) ProtoMessage() {}

func (x *ResourceOptions_QueryParamsOptions) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions_QueryParamsOptions.ProtoReflect.Descriptor instead.
func (*ResourceOptions_QueryParamsOptions) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2, 8}
}

func (x *ResourceOptions_QueryParamsOptions) GetQueryParamsVariant() isResourceOptions_QueryParamsOptions_QueryParamsVariant {
	if x != nil {
		return x.QueryParamsVariant
	}
	return nil
}

func (x *ResourceOptions_QueryParamsOptions) GetIgnoreQueryString() *ResourceOptions_BoolOption {
	if x != nil {
		if x, ok := x.QueryParamsVariant.(*ResourceOptions_QueryParamsOptions_IgnoreQueryString); ok {
			return x.IgnoreQueryString
		}
	}
	return nil
}

func (x *ResourceOptions_QueryParamsOptions) GetQueryParamsWhitelist() *ResourceOptions_StringsListOption {
	if x != nil {
		if x, ok := x.QueryParamsVariant.(*ResourceOptions_QueryParamsOptions_QueryParamsWhitelist); ok {
			return x.QueryParamsWhitelist
		}
	}
	return nil
}

func (x *ResourceOptions_QueryParamsOptions) GetQueryParamsBlacklist() *ResourceOptions_StringsListOption {
	if x != nil {
		if x, ok := x.QueryParamsVariant.(*ResourceOptions_QueryParamsOptions_QueryParamsBlacklist); ok {
			return x.QueryParamsBlacklist
		}
	}
	return nil
}

type isResourceOptions_QueryParamsOptions_QueryParamsVariant interface {
	isResourceOptions_QueryParamsOptions_QueryParamsVariant()
}

type ResourceOptions_QueryParamsOptions_IgnoreQueryString struct {
	// Using [BoolOption]. Selected by default. Files with different query parameters are cached as objects with the same key regardless of the parameter value.
	IgnoreQueryString *ResourceOptions_BoolOption `protobuf:"bytes,1,opt,name=ignore_query_string,json=ignoreQueryString,proto3,oneof"`
}

type ResourceOptions_QueryParamsOptions_QueryParamsWhitelist struct {
	// Ignore All Except.
	// Files with the specified query parameters are cached as objects with different keys,
	// files with other parameters are cached as objects with the same key.
	QueryParamsWhitelist *ResourceOptions_StringsListOption `protobuf:"bytes,2,opt,name=query_params_whitelist,json=queryParamsWhitelist,proto3,oneof"`
}

type ResourceOptions_QueryParamsOptions_QueryParamsBlacklist struct {
	// Ignore only. Files with the specified query parameters are cached as objects with the same key,
	// files with other parameters are cached as objects with different keys.
	QueryParamsBlacklist *ResourceOptions_StringsListOption `protobuf:"bytes,3,opt,name=query_params_blacklist,json=queryParamsBlacklist,proto3,oneof"`
}

func (*ResourceOptions_QueryParamsOptions_IgnoreQueryString) isResourceOptions_QueryParamsOptions_QueryParamsVariant() {
}

func (*ResourceOptions_QueryParamsOptions_QueryParamsWhitelist) isResourceOptions_QueryParamsOptions_QueryParamsVariant() {
}

func (*ResourceOptions_QueryParamsOptions_QueryParamsBlacklist) isResourceOptions_QueryParamsOptions_QueryParamsVariant() {
}

// A set of the redirect parameters.
type ResourceOptions_RedirectOptions struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to RedirectVariant:
	//
	//	*ResourceOptions_RedirectOptions_RedirectHttpToHttps
	//	*ResourceOptions_RedirectOptions_RedirectHttpsToHttp
	RedirectVariant isResourceOptions_RedirectOptions_RedirectVariant `protobuf_oneof:"redirect_variant"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *ResourceOptions_RedirectOptions) Reset() {
	*x = ResourceOptions_RedirectOptions{}
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceOptions_RedirectOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions_RedirectOptions) ProtoMessage() {}

func (x *ResourceOptions_RedirectOptions) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions_RedirectOptions.ProtoReflect.Descriptor instead.
func (*ResourceOptions_RedirectOptions) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2, 9}
}

func (x *ResourceOptions_RedirectOptions) GetRedirectVariant() isResourceOptions_RedirectOptions_RedirectVariant {
	if x != nil {
		return x.RedirectVariant
	}
	return nil
}

func (x *ResourceOptions_RedirectOptions) GetRedirectHttpToHttps() *ResourceOptions_BoolOption {
	if x != nil {
		if x, ok := x.RedirectVariant.(*ResourceOptions_RedirectOptions_RedirectHttpToHttps); ok {
			return x.RedirectHttpToHttps
		}
	}
	return nil
}

func (x *ResourceOptions_RedirectOptions) GetRedirectHttpsToHttp() *ResourceOptions_BoolOption {
	if x != nil {
		if x, ok := x.RedirectVariant.(*ResourceOptions_RedirectOptions_RedirectHttpsToHttp); ok {
			return x.RedirectHttpsToHttp
		}
	}
	return nil
}

type isResourceOptions_RedirectOptions_RedirectVariant interface {
	isResourceOptions_RedirectOptions_RedirectVariant()
}

type ResourceOptions_RedirectOptions_RedirectHttpToHttps struct {
	// Using [BoolOption]. Set up a redirect from HTTPS to HTTP.
	RedirectHttpToHttps *ResourceOptions_BoolOption `protobuf:"bytes,1,opt,name=redirect_http_to_https,json=redirectHttpToHttps,proto3,oneof"`
}

type ResourceOptions_RedirectOptions_RedirectHttpsToHttp struct {
	// Using [BoolOption]. Set up a redirect from HTTP to HTTPS.
	RedirectHttpsToHttp *ResourceOptions_BoolOption `protobuf:"bytes,2,opt,name=redirect_https_to_http,json=redirectHttpsToHttp,proto3,oneof"`
}

func (*ResourceOptions_RedirectOptions_RedirectHttpToHttps) isResourceOptions_RedirectOptions_RedirectVariant() {
}

func (*ResourceOptions_RedirectOptions_RedirectHttpsToHttp) isResourceOptions_RedirectOptions_RedirectVariant() {
}

// A set of the host parameters.
type ResourceOptions_HostOptions struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to HostVariant:
	//
	//	*ResourceOptions_HostOptions_Host
	//	*ResourceOptions_HostOptions_ForwardHostHeader
	HostVariant   isResourceOptions_HostOptions_HostVariant `protobuf_oneof:"host_variant"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ResourceOptions_HostOptions) Reset() {
	*x = ResourceOptions_HostOptions{}
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceOptions_HostOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions_HostOptions) ProtoMessage() {}

func (x *ResourceOptions_HostOptions) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions_HostOptions.ProtoReflect.Descriptor instead.
func (*ResourceOptions_HostOptions) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2, 10}
}

func (x *ResourceOptions_HostOptions) GetHostVariant() isResourceOptions_HostOptions_HostVariant {
	if x != nil {
		return x.HostVariant
	}
	return nil
}

func (x *ResourceOptions_HostOptions) GetHost() *ResourceOptions_StringOption {
	if x != nil {
		if x, ok := x.HostVariant.(*ResourceOptions_HostOptions_Host); ok {
			return x.Host
		}
	}
	return nil
}

func (x *ResourceOptions_HostOptions) GetForwardHostHeader() *ResourceOptions_BoolOption {
	if x != nil {
		if x, ok := x.HostVariant.(*ResourceOptions_HostOptions_ForwardHostHeader); ok {
			return x.ForwardHostHeader
		}
	}
	return nil
}

type isResourceOptions_HostOptions_HostVariant interface {
	isResourceOptions_HostOptions_HostVariant()
}

type ResourceOptions_HostOptions_Host struct {
	// Custom value for the Host header.
	//
	// Your server must be able to process requests with the chosen header.
	//
	// Default value (if [StringOption.enabled] is `false`) is [Resource.cname].
	Host *ResourceOptions_StringOption `protobuf:"bytes,1,opt,name=host,proto3,oneof"`
}

type ResourceOptions_HostOptions_ForwardHostHeader struct {
	// Using [BoolOption]. Choose the Forward Host header option if is important to send in the request to the Origin
	// the same Host header as was sent in the request to CDN server.
	ForwardHostHeader *ResourceOptions_BoolOption `protobuf:"bytes,2,opt,name=forward_host_header,json=forwardHostHeader,proto3,oneof"`
}

func (*ResourceOptions_HostOptions_Host) isResourceOptions_HostOptions_HostVariant() {}

func (*ResourceOptions_HostOptions_ForwardHostHeader) isResourceOptions_HostOptions_HostVariant() {}

// A set of the compression variant parameters.
type ResourceOptions_CompressionOptions struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to CompressionVariant:
	//
	//	*ResourceOptions_CompressionOptions_FetchCompressed
	//	*ResourceOptions_CompressionOptions_GzipOn
	//	*ResourceOptions_CompressionOptions_BrotliCompression
	CompressionVariant isResourceOptions_CompressionOptions_CompressionVariant `protobuf_oneof:"compression_variant"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *ResourceOptions_CompressionOptions) Reset() {
	*x = ResourceOptions_CompressionOptions{}
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceOptions_CompressionOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions_CompressionOptions) ProtoMessage() {}

func (x *ResourceOptions_CompressionOptions) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions_CompressionOptions.ProtoReflect.Descriptor instead.
func (*ResourceOptions_CompressionOptions) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2, 11}
}

func (x *ResourceOptions_CompressionOptions) GetCompressionVariant() isResourceOptions_CompressionOptions_CompressionVariant {
	if x != nil {
		return x.CompressionVariant
	}
	return nil
}

func (x *ResourceOptions_CompressionOptions) GetFetchCompressed() *ResourceOptions_BoolOption {
	if x != nil {
		if x, ok := x.CompressionVariant.(*ResourceOptions_CompressionOptions_FetchCompressed); ok {
			return x.FetchCompressed
		}
	}
	return nil
}

func (x *ResourceOptions_CompressionOptions) GetGzipOn() *ResourceOptions_BoolOption {
	if x != nil {
		if x, ok := x.CompressionVariant.(*ResourceOptions_CompressionOptions_GzipOn); ok {
			return x.GzipOn
		}
	}
	return nil
}

func (x *ResourceOptions_CompressionOptions) GetBrotliCompression() *ResourceOptions_StringsListOption {
	if x != nil {
		if x, ok := x.CompressionVariant.(*ResourceOptions_CompressionOptions_BrotliCompression); ok {
			return x.BrotliCompression
		}
	}
	return nil
}

type isResourceOptions_CompressionOptions_CompressionVariant interface {
	isResourceOptions_CompressionOptions_CompressionVariant()
}

type ResourceOptions_CompressionOptions_FetchCompressed struct {
	// The Fetch compressed option helps you to reduce
	// the bandwidth between origin and CDN servers.
	// Also, content delivery speed becomes higher because of reducing the time
	// for compressing files in a CDN.
	FetchCompressed *ResourceOptions_BoolOption `protobuf:"bytes,1,opt,name=fetch_compressed,json=fetchCompressed,proto3,oneof"`
}

type ResourceOptions_CompressionOptions_GzipOn struct {
	// Using [BoolOption]. GZip compression at CDN servers reduces file size by 70% and can be as high as 90%.
	GzipOn *ResourceOptions_BoolOption `protobuf:"bytes,2,opt,name=gzip_on,json=gzipOn,proto3,oneof"`
}

type ResourceOptions_CompressionOptions_BrotliCompression struct {
	// The option allows to compress content with brotli on the CDN's end.
	//
	// Compression is performed on the Origin Shielding. If a pre-cache server doesn't active for a resource, compression does not occur even if the option is enabled.
	//
	// Specify the content-type for each type of content you wish to have compressed. CDN servers will request only uncompressed content from the origin.
	BrotliCompression *ResourceOptions_StringsListOption `protobuf:"bytes,3,opt,name=brotli_compression,json=brotliCompression,proto3,oneof"`
}

func (*ResourceOptions_CompressionOptions_FetchCompressed) isResourceOptions_CompressionOptions_CompressionVariant() {
}

func (*ResourceOptions_CompressionOptions_GzipOn) isResourceOptions_CompressionOptions_CompressionVariant() {
}

func (*ResourceOptions_CompressionOptions_BrotliCompression) isResourceOptions_CompressionOptions_CompressionVariant() {
}

// An option for changing or redirecting query paths.
type ResourceOptions_RewriteOption struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// True - the option is enabled and its [flag] is applied to the resource.
	// False - the option is disabled and its default value of the [flag] is used for the resource.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Pattern for rewrite.
	//
	// The value must have the following format: `<source path> <destination path>`, where both paths are regular expressions which use at least one group. E.g., `/foo/(.*) /bar/$1`.
	Body string `protobuf:"bytes,2,opt,name=body,proto3" json:"body,omitempty"`
	// Break flag is applied to the option by default.
	// It is not shown in the field.
	Flag          RewriteFlag `protobuf:"varint,3,opt,name=flag,proto3,enum=yandex.cloud.cdn.v1.RewriteFlag" json:"flag,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ResourceOptions_RewriteOption) Reset() {
	*x = ResourceOptions_RewriteOption{}
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceOptions_RewriteOption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions_RewriteOption) ProtoMessage() {}

func (x *ResourceOptions_RewriteOption) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions_RewriteOption.ProtoReflect.Descriptor instead.
func (*ResourceOptions_RewriteOption) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2, 12}
}

func (x *ResourceOptions_RewriteOption) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *ResourceOptions_RewriteOption) GetBody() string {
	if x != nil {
		return x.Body
	}
	return ""
}

func (x *ResourceOptions_RewriteOption) GetFlag() RewriteFlag {
	if x != nil {
		return x.Flag
	}
	return RewriteFlag_REWRITE_FLAG_UNSPECIFIED
}

type ResourceOptions_SecureKeyOption struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// True - the option is enabled and its [flag] is applied to the resource.
	// False - the option is disabled and its default value of the [flag] is used for the resource.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// The key for the URL signing.
	Key string `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	// The type of the URL signing. The URL could be available for all IP addresses or for the only one IP.
	Type          SecureKeyURLType `protobuf:"varint,3,opt,name=type,proto3,enum=yandex.cloud.cdn.v1.SecureKeyURLType" json:"type,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ResourceOptions_SecureKeyOption) Reset() {
	*x = ResourceOptions_SecureKeyOption{}
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceOptions_SecureKeyOption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions_SecureKeyOption) ProtoMessage() {}

func (x *ResourceOptions_SecureKeyOption) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions_SecureKeyOption.ProtoReflect.Descriptor instead.
func (*ResourceOptions_SecureKeyOption) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2, 13}
}

func (x *ResourceOptions_SecureKeyOption) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *ResourceOptions_SecureKeyOption) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *ResourceOptions_SecureKeyOption) GetType() SecureKeyURLType {
	if x != nil {
		return x.Type
	}
	return SecureKeyURLType_SECURE_KEY_URL_TYPE_UNSPECIFIED
}

type ResourceOptions_IPAddressACLOption struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// True - the option is enabled and its [flag] is applied to the resource.
	// False - the option is disabled and its default value of the [flag] is used for the resource.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// The policy type. One of allow or deny value.
	PolicyType PolicyType `protobuf:"varint,2,opt,name=policy_type,json=policyType,proto3,enum=yandex.cloud.cdn.v1.PolicyType" json:"policy_type,omitempty"`
	// The list of IP addresses to be allowed or denied.
	ExceptedValues []string `protobuf:"bytes,3,rep,name=excepted_values,json=exceptedValues,proto3" json:"excepted_values,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *ResourceOptions_IPAddressACLOption) Reset() {
	*x = ResourceOptions_IPAddressACLOption{}
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceOptions_IPAddressACLOption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions_IPAddressACLOption) ProtoMessage() {}

func (x *ResourceOptions_IPAddressACLOption) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions_IPAddressACLOption.ProtoReflect.Descriptor instead.
func (*ResourceOptions_IPAddressACLOption) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2, 14}
}

func (x *ResourceOptions_IPAddressACLOption) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *ResourceOptions_IPAddressACLOption) GetPolicyType() PolicyType {
	if x != nil {
		return x.PolicyType
	}
	return PolicyType_POLICY_TYPE_UNSPECIFIED
}

func (x *ResourceOptions_IPAddressACLOption) GetExceptedValues() []string {
	if x != nil {
		return x.ExceptedValues
	}
	return nil
}

type ResourceOptions_FollowRedirectsOption struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// True - the option is enabled and its [flag] is applied to the resource.
	// False - the option is disabled and its default value of the [flag] is used for the resource.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Add the redirect HTTP status codes that the source returns.
	Codes []int64 `protobuf:"varint,2,rep,packed,name=codes,proto3" json:"codes,omitempty"`
	// Use the redirect target domain as a Host header, or leave it the same as the value of the Change Host header option.
	UseCustomHost bool `protobuf:"varint,3,opt,name=use_custom_host,json=useCustomHost,proto3" json:"use_custom_host,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ResourceOptions_FollowRedirectsOption) Reset() {
	*x = ResourceOptions_FollowRedirectsOption{}
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceOptions_FollowRedirectsOption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions_FollowRedirectsOption) ProtoMessage() {}

func (x *ResourceOptions_FollowRedirectsOption) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions_FollowRedirectsOption.ProtoReflect.Descriptor instead.
func (*ResourceOptions_FollowRedirectsOption) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2, 15}
}

func (x *ResourceOptions_FollowRedirectsOption) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *ResourceOptions_FollowRedirectsOption) GetCodes() []int64 {
	if x != nil {
		return x.Codes
	}
	return nil
}

func (x *ResourceOptions_FollowRedirectsOption) GetUseCustomHost() bool {
	if x != nil {
		return x.UseCustomHost
	}
	return false
}

type ResourceOptions_WebsocketsOption struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Enables or disables feature.
	Enabled       bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ResourceOptions_WebsocketsOption) Reset() {
	*x = ResourceOptions_WebsocketsOption{}
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceOptions_WebsocketsOption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions_WebsocketsOption) ProtoMessage() {}

func (x *ResourceOptions_WebsocketsOption) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions_WebsocketsOption.ProtoReflect.Descriptor instead.
func (*ResourceOptions_WebsocketsOption) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2, 16}
}

func (x *ResourceOptions_WebsocketsOption) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

type ResourceOptions_HeaderFilterOption struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Enables or disables feature.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Whitelist of headers.
	Headers       []string `protobuf:"bytes,2,rep,name=headers,proto3" json:"headers,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ResourceOptions_HeaderFilterOption) Reset() {
	*x = ResourceOptions_HeaderFilterOption{}
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceOptions_HeaderFilterOption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions_HeaderFilterOption) ProtoMessage() {}

func (x *ResourceOptions_HeaderFilterOption) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions_HeaderFilterOption.ProtoReflect.Descriptor instead.
func (*ResourceOptions_HeaderFilterOption) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2, 17}
}

func (x *ResourceOptions_HeaderFilterOption) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *ResourceOptions_HeaderFilterOption) GetHeaders() []string {
	if x != nil {
		return x.Headers
	}
	return nil
}

type ResourceOptions_StringVariableMapOption_OneofString struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to StringOption:
	//
	//	*ResourceOptions_StringVariableMapOption_OneofString_Value
	//	*ResourceOptions_StringVariableMapOption_OneofString_Values
	StringOption  isResourceOptions_StringVariableMapOption_OneofString_StringOption `protobuf_oneof:"string_option"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ResourceOptions_StringVariableMapOption_OneofString) Reset() {
	*x = ResourceOptions_StringVariableMapOption_OneofString{}
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceOptions_StringVariableMapOption_OneofString) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions_StringVariableMapOption_OneofString) ProtoMessage() {}

func (x *ResourceOptions_StringVariableMapOption_OneofString) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions_StringVariableMapOption_OneofString.ProtoReflect.Descriptor instead.
func (*ResourceOptions_StringVariableMapOption_OneofString) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2, 7, 0}
}

func (x *ResourceOptions_StringVariableMapOption_OneofString) GetStringOption() isResourceOptions_StringVariableMapOption_OneofString_StringOption {
	if x != nil {
		return x.StringOption
	}
	return nil
}

func (x *ResourceOptions_StringVariableMapOption_OneofString) GetValue() *ResourceOptions_StringOption {
	if x != nil {
		if x, ok := x.StringOption.(*ResourceOptions_StringVariableMapOption_OneofString_Value); ok {
			return x.Value
		}
	}
	return nil
}

func (x *ResourceOptions_StringVariableMapOption_OneofString) GetValues() *ResourceOptions_StringsListOption {
	if x != nil {
		if x, ok := x.StringOption.(*ResourceOptions_StringVariableMapOption_OneofString_Values); ok {
			return x.Values
		}
	}
	return nil
}

type isResourceOptions_StringVariableMapOption_OneofString_StringOption interface {
	isResourceOptions_StringVariableMapOption_OneofString_StringOption()
}

type ResourceOptions_StringVariableMapOption_OneofString_Value struct {
	// Using [StringOption] to set value.
	Value *ResourceOptions_StringOption `protobuf:"bytes,1,opt,name=value,proto3,oneof"`
}

type ResourceOptions_StringVariableMapOption_OneofString_Values struct {
	// Using [StringsListOption] to set values.
	Values *ResourceOptions_StringsListOption `protobuf:"bytes,2,opt,name=values,proto3,oneof"`
}

func (*ResourceOptions_StringVariableMapOption_OneofString_Value) isResourceOptions_StringVariableMapOption_OneofString_StringOption() {
}

func (*ResourceOptions_StringVariableMapOption_OneofString_Values) isResourceOptions_StringVariableMapOption_OneofString_StringOption() {
}

var File_yandex_cloud_cdn_v1_resource_proto protoreflect.FileDescriptor

const file_yandex_cloud_cdn_v1_resource_proto_rawDesc = "" +
	"\n" +
	"\"yandex/cloud/cdn/v1/resource.proto\x12\x13yandex.cloud.cdn.v1\x1a\x1fgoogle/protobuf/timestamp.proto\",\n" +
	"\x12SecondaryHostnames\x12\x16\n" +
	"\x06values\x18\x01 \x03(\tR\x06values\"\x86\x06\n" +
	"\bResource\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x1b\n" +
	"\tfolder_id\x18\x02 \x01(\tR\bfolderId\x12\x14\n" +
	"\x05cname\x18\x03 \x01(\tR\x05cname\x129\n" +
	"\n" +
	"created_at\x18\x04 \x01(\v2\x1a.google.protobuf.TimestampR\tcreatedAt\x129\n" +
	"\n" +
	"updated_at\x18\x05 \x01(\v2\x1a.google.protobuf.TimestampR\tupdatedAt\x12\x16\n" +
	"\x06active\x18\x06 \x01(\bR\x06active\x12>\n" +
	"\aoptions\x18\a \x01(\v2$.yandex.cloud.cdn.v1.ResourceOptionsR\aoptions\x12/\n" +
	"\x13secondary_hostnames\x18\b \x03(\tR\x12secondaryHostnames\x12&\n" +
	"\x0forigin_group_id\x18\t \x01(\x03R\roriginGroupId\x12*\n" +
	"\x11origin_group_name\x18\n" +
	" \x01(\tR\x0foriginGroupName\x12L\n" +
	"\x0forigin_protocol\x18\v \x01(\x0e2#.yandex.cloud.cdn.v1.OriginProtocolR\x0eoriginProtocol\x12L\n" +
	"\x0fssl_certificate\x18\f \x01(\v2#.yandex.cloud.cdn.v1.SSLCertificateR\x0esslCertificate\x12A\n" +
	"\x06labels\x18\r \x03(\v2).yandex.cloud.cdn.v1.Resource.LabelsEntryR\x06labels\x12#\n" +
	"\rprovider_type\x18\x0e \x01(\tR\fproviderType\x12%\n" +
	"\x0eprovider_cname\x18\x0f \x01(\tR\rproviderCname\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"\x82*\n" +
	"\x0fResourceOptions\x12T\n" +
	"\rdisable_cache\x18\x01 \x01(\v2/.yandex.cloud.cdn.v1.ResourceOptions.BoolOptionR\fdisableCache\x12f\n" +
	"\x13edge_cache_settings\x18\x02 \x01(\v26.yandex.cloud.cdn.v1.ResourceOptions.EdgeCacheSettingsR\x11edgeCacheSettings\x12f\n" +
	"\x16browser_cache_settings\x18\x03 \x01(\v20.yandex.cloud.cdn.v1.ResourceOptions.Int64OptionR\x14browserCacheSettings\x12d\n" +
	"\x12cache_http_headers\x18\x04 \x01(\v26.yandex.cloud.cdn.v1.ResourceOptions.StringsListOptionR\x10cacheHttpHeaders\x12i\n" +
	"\x14query_params_options\x18\x05 \x01(\v27.yandex.cloud.cdn.v1.ResourceOptions.QueryParamsOptionsR\x12queryParamsOptions\x12E\n" +
	"\x05slice\x18\x06 \x01(\v2/.yandex.cloud.cdn.v1.ResourceOptions.BoolOptionR\x05slice\x12h\n" +
	"\x13compression_options\x18\a \x01(\v27.yandex.cloud.cdn.v1.ResourceOptions.CompressionOptionsR\x12compressionOptions\x12_\n" +
	"\x10redirect_options\x18\b \x01(\v24.yandex.cloud.cdn.v1.ResourceOptions.RedirectOptionsR\x0fredirectOptions\x12S\n" +
	"\fhost_options\x18\t \x01(\v20.yandex.cloud.cdn.v1.ResourceOptions.HostOptionsR\vhostOptions\x12\\\n" +
	"\x0estatic_headers\x18\n" +
	" \x01(\v25.yandex.cloud.cdn.v1.ResourceOptions.StringsMapOptionR\rstaticHeaders\x12J\n" +
	"\x04cors\x18\v \x01(\v26.yandex.cloud.cdn.v1.ResourceOptions.StringsListOptionR\x04cors\x12L\n" +
	"\x05stale\x18\f \x01(\v26.yandex.cloud.cdn.v1.ResourceOptions.StringsListOptionR\x05stale\x12h\n" +
	"\x14allowed_http_methods\x18\r \x01(\v26.yandex.cloud.cdn.v1.ResourceOptions.StringsListOptionR\x12allowedHttpMethods\x12f\n" +
	"\x17proxy_cache_methods_set\x18\x0e \x01(\v2/.yandex.cloud.cdn.v1.ResourceOptions.BoolOptionR\x14proxyCacheMethodsSet\x12l\n" +
	"\x1adisable_proxy_force_ranges\x18\x0f \x01(\v2/.yandex.cloud.cdn.v1.ResourceOptions.BoolOptionR\x17disableProxyForceRanges\x12k\n" +
	"\x16static_request_headers\x18\x10 \x01(\v25.yandex.cloud.cdn.v1.ResourceOptions.StringsMapOptionR\x14staticRequestHeaders\x12_\n" +
	"\x12custom_server_name\x18\x11 \x01(\v21.yandex.cloud.cdn.v1.ResourceOptions.StringOptionR\x10customServerName\x12T\n" +
	"\rignore_cookie\x18\x12 \x01(\v2/.yandex.cloud.cdn.v1.ResourceOptions.BoolOptionR\fignoreCookie\x12L\n" +
	"\arewrite\x18\x13 \x01(\v22.yandex.cloud.cdn.v1.ResourceOptions.RewriteOptionR\arewrite\x12S\n" +
	"\n" +
	"secure_key\x18\x14 \x01(\v24.yandex.cloud.cdn.v1.ResourceOptions.SecureKeyOptionR\tsecureKey\x12]\n" +
	"\x0eip_address_acl\x18\x15 \x01(\v27.yandex.cloud.cdn.v1.ResourceOptions.IPAddressACLOptionR\fipAddressAcl\x12e\n" +
	"\x10follow_redirects\x18\x16 \x01(\v2:.yandex.cloud.cdn.v1.ResourceOptions.FollowRedirectsOptionR\x0ffollowRedirects\x12U\n" +
	"\n" +
	"websockets\x18\x17 \x01(\v25.yandex.cloud.cdn.v1.ResourceOptions.WebsocketsOptionR\n" +
	"websockets\x12\\\n" +
	"\rheader_filter\x18\x18 \x01(\v27.yandex.cloud.cdn.v1.ResourceOptions.HeaderFilterOptionR\fheaderFilter\x1a<\n" +
	"\n" +
	"BoolOption\x12\x18\n" +
	"\aenabled\x18\x01 \x01(\bR\aenabled\x12\x14\n" +
	"\x05value\x18\x02 \x01(\bR\x05value\x1a>\n" +
	"\fStringOption\x12\x18\n" +
	"\aenabled\x18\x01 \x01(\bR\aenabled\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value\x1a=\n" +
	"\vInt64Option\x12\x18\n" +
	"\aenabled\x18\x01 \x01(\bR\aenabled\x12\x14\n" +
	"\x05value\x18\x02 \x01(\x03R\x05value\x1aC\n" +
	"\x11StringsListOption\x12\x18\n" +
	"\aenabled\x18\x01 \x01(\bR\aenabled\x12\x14\n" +
	"\x05value\x18\x02 \x03(\tR\x05value\x1a\xbe\x01\n" +
	"\x10StringsMapOption\x12\x18\n" +
	"\aenabled\x18\x01 \x01(\bR\aenabled\x12V\n" +
	"\x05value\x18\x02 \x03(\v2@.yandex.cloud.cdn.v1.ResourceOptions.StringsMapOption.ValueEntryR\x05value\x1a8\n" +
	"\n" +
	"ValueEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\x1a\xdc\x01\n" +
	"\fCachingTimes\x12!\n" +
	"\fsimple_value\x18\x01 \x01(\x03R\vsimpleValue\x12h\n" +
	"\rcustom_values\x18\x02 \x03(\v2C.yandex.cloud.cdn.v1.ResourceOptions.CachingTimes.CustomValuesEntryR\fcustomValues\x1a?\n" +
	"\x11CustomValuesEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\x03R\x05value:\x028\x01\x1a\xb1\x01\n" +
	"\x11EdgeCacheSettings\x12\x18\n" +
	"\aenabled\x18\x01 \x01(\bR\aenabled\x12I\n" +
	"\x05value\x18\x02 \x01(\v21.yandex.cloud.cdn.v1.ResourceOptions.CachingTimesH\x00R\x05value\x12%\n" +
	"\rdefault_value\x18\x03 \x01(\x03H\x00R\fdefaultValueB\x10\n" +
	"\x0evalues_variant\x1a\xd5\x03\n" +
	"\x17StringVariableMapOption\x12\x18\n" +
	"\aenabled\x18\x01 \x01(\bR\aenabled\x12]\n" +
	"\x05value\x18\x02 \x03(\v2G.yandex.cloud.cdn.v1.ResourceOptions.StringVariableMapOption.ValueEntryR\x05value\x1a\xbb\x01\n" +
	"\vOneofString\x12I\n" +
	"\x05value\x18\x01 \x01(\v21.yandex.cloud.cdn.v1.ResourceOptions.StringOptionH\x00R\x05value\x12P\n" +
	"\x06values\x18\x02 \x01(\v26.yandex.cloud.cdn.v1.ResourceOptions.StringsListOptionH\x00R\x06valuesB\x0f\n" +
	"\rstring_option\x1a\x82\x01\n" +
	"\n" +
	"ValueEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12^\n" +
	"\x05value\x18\x02 \x01(\v2H.yandex.cloud.cdn.v1.ResourceOptions.StringVariableMapOption.OneofStringR\x05value:\x028\x01\x1a\xef\x02\n" +
	"\x12QueryParamsOptions\x12a\n" +
	"\x13ignore_query_string\x18\x01 \x01(\v2/.yandex.cloud.cdn.v1.ResourceOptions.BoolOptionH\x00R\x11ignoreQueryString\x12n\n" +
	"\x16query_params_whitelist\x18\x02 \x01(\v26.yandex.cloud.cdn.v1.ResourceOptions.StringsListOptionH\x00R\x14queryParamsWhitelist\x12n\n" +
	"\x16query_params_blacklist\x18\x03 \x01(\v26.yandex.cloud.cdn.v1.ResourceOptions.StringsListOptionH\x00R\x14queryParamsBlacklistB\x16\n" +
	"\x14query_params_variant\x1a\xf5\x01\n" +
	"\x0fRedirectOptions\x12f\n" +
	"\x16redirect_http_to_https\x18\x01 \x01(\v2/.yandex.cloud.cdn.v1.ResourceOptions.BoolOptionH\x00R\x13redirectHttpToHttps\x12f\n" +
	"\x16redirect_https_to_http\x18\x02 \x01(\v2/.yandex.cloud.cdn.v1.ResourceOptions.BoolOptionH\x00R\x13redirectHttpsToHttpB\x12\n" +
	"\x10redirect_variant\x1a\xc9\x01\n" +
	"\vHostOptions\x12G\n" +
	"\x04host\x18\x01 \x01(\v21.yandex.cloud.cdn.v1.ResourceOptions.StringOptionH\x00R\x04host\x12a\n" +
	"\x13forward_host_header\x18\x02 \x01(\v2/.yandex.cloud.cdn.v1.ResourceOptions.BoolOptionH\x00R\x11forwardHostHeaderB\x0e\n" +
	"\fhost_variant\x1a\xbe\x02\n" +
	"\x12CompressionOptions\x12\\\n" +
	"\x10fetch_compressed\x18\x01 \x01(\v2/.yandex.cloud.cdn.v1.ResourceOptions.BoolOptionH\x00R\x0ffetchCompressed\x12J\n" +
	"\agzip_on\x18\x02 \x01(\v2/.yandex.cloud.cdn.v1.ResourceOptions.BoolOptionH\x00R\x06gzipOn\x12g\n" +
	"\x12brotli_compression\x18\x03 \x01(\v26.yandex.cloud.cdn.v1.ResourceOptions.StringsListOptionH\x00R\x11brotliCompressionB\x15\n" +
	"\x13compression_variant\x1as\n" +
	"\rRewriteOption\x12\x18\n" +
	"\aenabled\x18\x01 \x01(\bR\aenabled\x12\x12\n" +
	"\x04body\x18\x02 \x01(\tR\x04body\x124\n" +
	"\x04flag\x18\x03 \x01(\x0e2 .yandex.cloud.cdn.v1.RewriteFlagR\x04flag\x1ax\n" +
	"\x0fSecureKeyOption\x12\x18\n" +
	"\aenabled\x18\x01 \x01(\bR\aenabled\x12\x10\n" +
	"\x03key\x18\x02 \x01(\tR\x03key\x129\n" +
	"\x04type\x18\x03 \x01(\x0e2%.yandex.cloud.cdn.v1.SecureKeyURLTypeR\x04type\x1a\x99\x01\n" +
	"\x12IPAddressACLOption\x12\x18\n" +
	"\aenabled\x18\x01 \x01(\bR\aenabled\x12@\n" +
	"\vpolicy_type\x18\x02 \x01(\x0e2\x1f.yandex.cloud.cdn.v1.PolicyTypeR\n" +
	"policyType\x12'\n" +
	"\x0fexcepted_values\x18\x03 \x03(\tR\x0eexceptedValues\x1ao\n" +
	"\x15FollowRedirectsOption\x12\x18\n" +
	"\aenabled\x18\x01 \x01(\bR\aenabled\x12\x14\n" +
	"\x05codes\x18\x02 \x03(\x03R\x05codes\x12&\n" +
	"\x0fuse_custom_host\x18\x03 \x01(\bR\ruseCustomHost\x1a,\n" +
	"\x10WebsocketsOption\x12\x18\n" +
	"\aenabled\x18\x01 \x01(\bR\aenabled\x1aH\n" +
	"\x12HeaderFilterOption\x12\x18\n" +
	"\aenabled\x18\x01 \x01(\bR\aenabled\x12\x18\n" +
	"\aheaders\x18\x02 \x03(\tR\aheaders\"\x90\x01\n" +
	"\x14SSLTargetCertificate\x12;\n" +
	"\x04type\x18\x01 \x01(\x0e2'.yandex.cloud.cdn.v1.SSLCertificateTypeR\x04type\x12;\n" +
	"\x04data\x18\x02 \x01(\v2'.yandex.cloud.cdn.v1.SSLCertificateDataR\x04data\"\xcd\x01\n" +
	"\x0eSSLCertificate\x12;\n" +
	"\x04type\x18\x01 \x01(\x0e2'.yandex.cloud.cdn.v1.SSLCertificateTypeR\x04type\x12A\n" +
	"\x06status\x18\x02 \x01(\x0e2).yandex.cloud.cdn.v1.SSLCertificateStatusR\x06status\x12;\n" +
	"\x04data\x18\x03 \x01(\v2'.yandex.cloud.cdn.v1.SSLCertificateDataR\x04data\"q\n" +
	"\x12SSLCertificateData\x12;\n" +
	"\x02cm\x18\x01 \x01(\v2).yandex.cloud.cdn.v1.SSLCertificateCMDataH\x00R\x02cmB\x1e\n" +
	"\x1cssl_certificate_data_variant\"&\n" +
	"\x14SSLCertificateCMData\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id*Q\n" +
	"\x0eOriginProtocol\x12\x1f\n" +
	"\x1bORIGIN_PROTOCOL_UNSPECIFIED\x10\x00\x12\b\n" +
	"\x04HTTP\x10\x01\x12\t\n" +
	"\x05HTTPS\x10\x02\x12\t\n" +
	"\x05MATCH\x10\x03*]\n" +
	"\vRewriteFlag\x12\x1c\n" +
	"\x18REWRITE_FLAG_UNSPECIFIED\x10\x00\x12\b\n" +
	"\x04LAST\x10\x01\x12\t\n" +
	"\x05BREAK\x10\x02\x12\f\n" +
	"\bREDIRECT\x10\x03\x12\r\n" +
	"\tPERMANENT\x10\x04*f\n" +
	"\x10SecureKeyURLType\x12#\n" +
	"\x1fSECURE_KEY_URL_TYPE_UNSPECIFIED\x10\x00\x12\x15\n" +
	"\x11ENABLE_IP_SIGNING\x10\x01\x12\x16\n" +
	"\x12DISABLE_IP_SIGNING\x10\x02*V\n" +
	"\n" +
	"PolicyType\x12\x1b\n" +
	"\x17POLICY_TYPE_UNSPECIFIED\x10\x00\x12\x15\n" +
	"\x11POLICY_TYPE_ALLOW\x10\x01\x12\x14\n" +
	"\x10POLICY_TYPE_DENY\x10\x02*l\n" +
	"\x12SSLCertificateType\x12$\n" +
	" SSL_CERTIFICATE_TYPE_UNSPECIFIED\x10\x00\x12\f\n" +
	"\bDONT_USE\x10\x01\x12\x1a\n" +
	"\x12LETS_ENCRYPT_GCORE\x10\x02\x1a\x02\b\x01\x12\x06\n" +
	"\x02CM\x10\x03*[\n" +
	"\x14SSLCertificateStatus\x12&\n" +
	"\"SSL_CERTIFICATE_STATUS_UNSPECIFIED\x10\x00\x12\t\n" +
	"\x05READY\x10\x01\x12\x10\n" +
	"\bCREATING\x10\x02\x1a\x02\b\x01BV\n" +
	"\x17yandex.cloud.api.cdn.v1Z;github.com/yandex-cloud/go-genproto/yandex/cloud/cdn/v1;cdnb\x06proto3"

var (
	file_yandex_cloud_cdn_v1_resource_proto_rawDescOnce sync.Once
	file_yandex_cloud_cdn_v1_resource_proto_rawDescData []byte
)

func file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP() []byte {
	file_yandex_cloud_cdn_v1_resource_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_cdn_v1_resource_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_cdn_v1_resource_proto_rawDesc), len(file_yandex_cloud_cdn_v1_resource_proto_rawDesc)))
	})
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescData
}

var file_yandex_cloud_cdn_v1_resource_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_yandex_cloud_cdn_v1_resource_proto_msgTypes = make([]protoimpl.MessageInfo, 30)
var file_yandex_cloud_cdn_v1_resource_proto_goTypes = []any{
	(OriginProtocol)(0),                             // 0: yandex.cloud.cdn.v1.OriginProtocol
	(RewriteFlag)(0),                                // 1: yandex.cloud.cdn.v1.RewriteFlag
	(SecureKeyURLType)(0),                           // 2: yandex.cloud.cdn.v1.SecureKeyURLType
	(PolicyType)(0),                                 // 3: yandex.cloud.cdn.v1.PolicyType
	(SSLCertificateType)(0),                         // 4: yandex.cloud.cdn.v1.SSLCertificateType
	(SSLCertificateStatus)(0),                       // 5: yandex.cloud.cdn.v1.SSLCertificateStatus
	(*SecondaryHostnames)(nil),                      // 6: yandex.cloud.cdn.v1.SecondaryHostnames
	(*Resource)(nil),                                // 7: yandex.cloud.cdn.v1.Resource
	(*ResourceOptions)(nil),                         // 8: yandex.cloud.cdn.v1.ResourceOptions
	(*SSLTargetCertificate)(nil),                    // 9: yandex.cloud.cdn.v1.SSLTargetCertificate
	(*SSLCertificate)(nil),                          // 10: yandex.cloud.cdn.v1.SSLCertificate
	(*SSLCertificateData)(nil),                      // 11: yandex.cloud.cdn.v1.SSLCertificateData
	(*SSLCertificateCMData)(nil),                    // 12: yandex.cloud.cdn.v1.SSLCertificateCMData
	nil,                                             // 13: yandex.cloud.cdn.v1.Resource.LabelsEntry
	(*ResourceOptions_BoolOption)(nil),              // 14: yandex.cloud.cdn.v1.ResourceOptions.BoolOption
	(*ResourceOptions_StringOption)(nil),            // 15: yandex.cloud.cdn.v1.ResourceOptions.StringOption
	(*ResourceOptions_Int64Option)(nil),             // 16: yandex.cloud.cdn.v1.ResourceOptions.Int64Option
	(*ResourceOptions_StringsListOption)(nil),       // 17: yandex.cloud.cdn.v1.ResourceOptions.StringsListOption
	(*ResourceOptions_StringsMapOption)(nil),        // 18: yandex.cloud.cdn.v1.ResourceOptions.StringsMapOption
	(*ResourceOptions_CachingTimes)(nil),            // 19: yandex.cloud.cdn.v1.ResourceOptions.CachingTimes
	(*ResourceOptions_EdgeCacheSettings)(nil),       // 20: yandex.cloud.cdn.v1.ResourceOptions.EdgeCacheSettings
	(*ResourceOptions_StringVariableMapOption)(nil), // 21: yandex.cloud.cdn.v1.ResourceOptions.StringVariableMapOption
	(*ResourceOptions_QueryParamsOptions)(nil),      // 22: yandex.cloud.cdn.v1.ResourceOptions.QueryParamsOptions
	(*ResourceOptions_RedirectOptions)(nil),         // 23: yandex.cloud.cdn.v1.ResourceOptions.RedirectOptions
	(*ResourceOptions_HostOptions)(nil),             // 24: yandex.cloud.cdn.v1.ResourceOptions.HostOptions
	(*ResourceOptions_CompressionOptions)(nil),      // 25: yandex.cloud.cdn.v1.ResourceOptions.CompressionOptions
	(*ResourceOptions_RewriteOption)(nil),           // 26: yandex.cloud.cdn.v1.ResourceOptions.RewriteOption
	(*ResourceOptions_SecureKeyOption)(nil),         // 27: yandex.cloud.cdn.v1.ResourceOptions.SecureKeyOption
	(*ResourceOptions_IPAddressACLOption)(nil),      // 28: yandex.cloud.cdn.v1.ResourceOptions.IPAddressACLOption
	(*ResourceOptions_FollowRedirectsOption)(nil),   // 29: yandex.cloud.cdn.v1.ResourceOptions.FollowRedirectsOption
	(*ResourceOptions_WebsocketsOption)(nil),        // 30: yandex.cloud.cdn.v1.ResourceOptions.WebsocketsOption
	(*ResourceOptions_HeaderFilterOption)(nil),      // 31: yandex.cloud.cdn.v1.ResourceOptions.HeaderFilterOption
	nil, // 32: yandex.cloud.cdn.v1.ResourceOptions.StringsMapOption.ValueEntry
	nil, // 33: yandex.cloud.cdn.v1.ResourceOptions.CachingTimes.CustomValuesEntry
	(*ResourceOptions_StringVariableMapOption_OneofString)(nil), // 34: yandex.cloud.cdn.v1.ResourceOptions.StringVariableMapOption.OneofString
	nil,                           // 35: yandex.cloud.cdn.v1.ResourceOptions.StringVariableMapOption.ValueEntry
	(*timestamppb.Timestamp)(nil), // 36: google.protobuf.Timestamp
}
var file_yandex_cloud_cdn_v1_resource_proto_depIdxs = []int32{
	36, // 0: yandex.cloud.cdn.v1.Resource.created_at:type_name -> google.protobuf.Timestamp
	36, // 1: yandex.cloud.cdn.v1.Resource.updated_at:type_name -> google.protobuf.Timestamp
	8,  // 2: yandex.cloud.cdn.v1.Resource.options:type_name -> yandex.cloud.cdn.v1.ResourceOptions
	0,  // 3: yandex.cloud.cdn.v1.Resource.origin_protocol:type_name -> yandex.cloud.cdn.v1.OriginProtocol
	10, // 4: yandex.cloud.cdn.v1.Resource.ssl_certificate:type_name -> yandex.cloud.cdn.v1.SSLCertificate
	13, // 5: yandex.cloud.cdn.v1.Resource.labels:type_name -> yandex.cloud.cdn.v1.Resource.LabelsEntry
	14, // 6: yandex.cloud.cdn.v1.ResourceOptions.disable_cache:type_name -> yandex.cloud.cdn.v1.ResourceOptions.BoolOption
	20, // 7: yandex.cloud.cdn.v1.ResourceOptions.edge_cache_settings:type_name -> yandex.cloud.cdn.v1.ResourceOptions.EdgeCacheSettings
	16, // 8: yandex.cloud.cdn.v1.ResourceOptions.browser_cache_settings:type_name -> yandex.cloud.cdn.v1.ResourceOptions.Int64Option
	17, // 9: yandex.cloud.cdn.v1.ResourceOptions.cache_http_headers:type_name -> yandex.cloud.cdn.v1.ResourceOptions.StringsListOption
	22, // 10: yandex.cloud.cdn.v1.ResourceOptions.query_params_options:type_name -> yandex.cloud.cdn.v1.ResourceOptions.QueryParamsOptions
	14, // 11: yandex.cloud.cdn.v1.ResourceOptions.slice:type_name -> yandex.cloud.cdn.v1.ResourceOptions.BoolOption
	25, // 12: yandex.cloud.cdn.v1.ResourceOptions.compression_options:type_name -> yandex.cloud.cdn.v1.ResourceOptions.CompressionOptions
	23, // 13: yandex.cloud.cdn.v1.ResourceOptions.redirect_options:type_name -> yandex.cloud.cdn.v1.ResourceOptions.RedirectOptions
	24, // 14: yandex.cloud.cdn.v1.ResourceOptions.host_options:type_name -> yandex.cloud.cdn.v1.ResourceOptions.HostOptions
	18, // 15: yandex.cloud.cdn.v1.ResourceOptions.static_headers:type_name -> yandex.cloud.cdn.v1.ResourceOptions.StringsMapOption
	17, // 16: yandex.cloud.cdn.v1.ResourceOptions.cors:type_name -> yandex.cloud.cdn.v1.ResourceOptions.StringsListOption
	17, // 17: yandex.cloud.cdn.v1.ResourceOptions.stale:type_name -> yandex.cloud.cdn.v1.ResourceOptions.StringsListOption
	17, // 18: yandex.cloud.cdn.v1.ResourceOptions.allowed_http_methods:type_name -> yandex.cloud.cdn.v1.ResourceOptions.StringsListOption
	14, // 19: yandex.cloud.cdn.v1.ResourceOptions.proxy_cache_methods_set:type_name -> yandex.cloud.cdn.v1.ResourceOptions.BoolOption
	14, // 20: yandex.cloud.cdn.v1.ResourceOptions.disable_proxy_force_ranges:type_name -> yandex.cloud.cdn.v1.ResourceOptions.BoolOption
	18, // 21: yandex.cloud.cdn.v1.ResourceOptions.static_request_headers:type_name -> yandex.cloud.cdn.v1.ResourceOptions.StringsMapOption
	15, // 22: yandex.cloud.cdn.v1.ResourceOptions.custom_server_name:type_name -> yandex.cloud.cdn.v1.ResourceOptions.StringOption
	14, // 23: yandex.cloud.cdn.v1.ResourceOptions.ignore_cookie:type_name -> yandex.cloud.cdn.v1.ResourceOptions.BoolOption
	26, // 24: yandex.cloud.cdn.v1.ResourceOptions.rewrite:type_name -> yandex.cloud.cdn.v1.ResourceOptions.RewriteOption
	27, // 25: yandex.cloud.cdn.v1.ResourceOptions.secure_key:type_name -> yandex.cloud.cdn.v1.ResourceOptions.SecureKeyOption
	28, // 26: yandex.cloud.cdn.v1.ResourceOptions.ip_address_acl:type_name -> yandex.cloud.cdn.v1.ResourceOptions.IPAddressACLOption
	29, // 27: yandex.cloud.cdn.v1.ResourceOptions.follow_redirects:type_name -> yandex.cloud.cdn.v1.ResourceOptions.FollowRedirectsOption
	30, // 28: yandex.cloud.cdn.v1.ResourceOptions.websockets:type_name -> yandex.cloud.cdn.v1.ResourceOptions.WebsocketsOption
	31, // 29: yandex.cloud.cdn.v1.ResourceOptions.header_filter:type_name -> yandex.cloud.cdn.v1.ResourceOptions.HeaderFilterOption
	4,  // 30: yandex.cloud.cdn.v1.SSLTargetCertificate.type:type_name -> yandex.cloud.cdn.v1.SSLCertificateType
	11, // 31: yandex.cloud.cdn.v1.SSLTargetCertificate.data:type_name -> yandex.cloud.cdn.v1.SSLCertificateData
	4,  // 32: yandex.cloud.cdn.v1.SSLCertificate.type:type_name -> yandex.cloud.cdn.v1.SSLCertificateType
	5,  // 33: yandex.cloud.cdn.v1.SSLCertificate.status:type_name -> yandex.cloud.cdn.v1.SSLCertificateStatus
	11, // 34: yandex.cloud.cdn.v1.SSLCertificate.data:type_name -> yandex.cloud.cdn.v1.SSLCertificateData
	12, // 35: yandex.cloud.cdn.v1.SSLCertificateData.cm:type_name -> yandex.cloud.cdn.v1.SSLCertificateCMData
	32, // 36: yandex.cloud.cdn.v1.ResourceOptions.StringsMapOption.value:type_name -> yandex.cloud.cdn.v1.ResourceOptions.StringsMapOption.ValueEntry
	33, // 37: yandex.cloud.cdn.v1.ResourceOptions.CachingTimes.custom_values:type_name -> yandex.cloud.cdn.v1.ResourceOptions.CachingTimes.CustomValuesEntry
	19, // 38: yandex.cloud.cdn.v1.ResourceOptions.EdgeCacheSettings.value:type_name -> yandex.cloud.cdn.v1.ResourceOptions.CachingTimes
	35, // 39: yandex.cloud.cdn.v1.ResourceOptions.StringVariableMapOption.value:type_name -> yandex.cloud.cdn.v1.ResourceOptions.StringVariableMapOption.ValueEntry
	14, // 40: yandex.cloud.cdn.v1.ResourceOptions.QueryParamsOptions.ignore_query_string:type_name -> yandex.cloud.cdn.v1.ResourceOptions.BoolOption
	17, // 41: yandex.cloud.cdn.v1.ResourceOptions.QueryParamsOptions.query_params_whitelist:type_name -> yandex.cloud.cdn.v1.ResourceOptions.StringsListOption
	17, // 42: yandex.cloud.cdn.v1.ResourceOptions.QueryParamsOptions.query_params_blacklist:type_name -> yandex.cloud.cdn.v1.ResourceOptions.StringsListOption
	14, // 43: yandex.cloud.cdn.v1.ResourceOptions.RedirectOptions.redirect_http_to_https:type_name -> yandex.cloud.cdn.v1.ResourceOptions.BoolOption
	14, // 44: yandex.cloud.cdn.v1.ResourceOptions.RedirectOptions.redirect_https_to_http:type_name -> yandex.cloud.cdn.v1.ResourceOptions.BoolOption
	15, // 45: yandex.cloud.cdn.v1.ResourceOptions.HostOptions.host:type_name -> yandex.cloud.cdn.v1.ResourceOptions.StringOption
	14, // 46: yandex.cloud.cdn.v1.ResourceOptions.HostOptions.forward_host_header:type_name -> yandex.cloud.cdn.v1.ResourceOptions.BoolOption
	14, // 47: yandex.cloud.cdn.v1.ResourceOptions.CompressionOptions.fetch_compressed:type_name -> yandex.cloud.cdn.v1.ResourceOptions.BoolOption
	14, // 48: yandex.cloud.cdn.v1.ResourceOptions.CompressionOptions.gzip_on:type_name -> yandex.cloud.cdn.v1.ResourceOptions.BoolOption
	17, // 49: yandex.cloud.cdn.v1.ResourceOptions.CompressionOptions.brotli_compression:type_name -> yandex.cloud.cdn.v1.ResourceOptions.StringsListOption
	1,  // 50: yandex.cloud.cdn.v1.ResourceOptions.RewriteOption.flag:type_name -> yandex.cloud.cdn.v1.RewriteFlag
	2,  // 51: yandex.cloud.cdn.v1.ResourceOptions.SecureKeyOption.type:type_name -> yandex.cloud.cdn.v1.SecureKeyURLType
	3,  // 52: yandex.cloud.cdn.v1.ResourceOptions.IPAddressACLOption.policy_type:type_name -> yandex.cloud.cdn.v1.PolicyType
	15, // 53: yandex.cloud.cdn.v1.ResourceOptions.StringVariableMapOption.OneofString.value:type_name -> yandex.cloud.cdn.v1.ResourceOptions.StringOption
	17, // 54: yandex.cloud.cdn.v1.ResourceOptions.StringVariableMapOption.OneofString.values:type_name -> yandex.cloud.cdn.v1.ResourceOptions.StringsListOption
	34, // 55: yandex.cloud.cdn.v1.ResourceOptions.StringVariableMapOption.ValueEntry.value:type_name -> yandex.cloud.cdn.v1.ResourceOptions.StringVariableMapOption.OneofString
	56, // [56:56] is the sub-list for method output_type
	56, // [56:56] is the sub-list for method input_type
	56, // [56:56] is the sub-list for extension type_name
	56, // [56:56] is the sub-list for extension extendee
	0,  // [0:56] is the sub-list for field type_name
}

func init() { file_yandex_cloud_cdn_v1_resource_proto_init() }
func file_yandex_cloud_cdn_v1_resource_proto_init() {
	if File_yandex_cloud_cdn_v1_resource_proto != nil {
		return
	}
	file_yandex_cloud_cdn_v1_resource_proto_msgTypes[5].OneofWrappers = []any{
		(*SSLCertificateData_Cm)(nil),
	}
	file_yandex_cloud_cdn_v1_resource_proto_msgTypes[14].OneofWrappers = []any{
		(*ResourceOptions_EdgeCacheSettings_Value)(nil),
		(*ResourceOptions_EdgeCacheSettings_DefaultValue)(nil),
	}
	file_yandex_cloud_cdn_v1_resource_proto_msgTypes[16].OneofWrappers = []any{
		(*ResourceOptions_QueryParamsOptions_IgnoreQueryString)(nil),
		(*ResourceOptions_QueryParamsOptions_QueryParamsWhitelist)(nil),
		(*ResourceOptions_QueryParamsOptions_QueryParamsBlacklist)(nil),
	}
	file_yandex_cloud_cdn_v1_resource_proto_msgTypes[17].OneofWrappers = []any{
		(*ResourceOptions_RedirectOptions_RedirectHttpToHttps)(nil),
		(*ResourceOptions_RedirectOptions_RedirectHttpsToHttp)(nil),
	}
	file_yandex_cloud_cdn_v1_resource_proto_msgTypes[18].OneofWrappers = []any{
		(*ResourceOptions_HostOptions_Host)(nil),
		(*ResourceOptions_HostOptions_ForwardHostHeader)(nil),
	}
	file_yandex_cloud_cdn_v1_resource_proto_msgTypes[19].OneofWrappers = []any{
		(*ResourceOptions_CompressionOptions_FetchCompressed)(nil),
		(*ResourceOptions_CompressionOptions_GzipOn)(nil),
		(*ResourceOptions_CompressionOptions_BrotliCompression)(nil),
	}
	file_yandex_cloud_cdn_v1_resource_proto_msgTypes[28].OneofWrappers = []any{
		(*ResourceOptions_StringVariableMapOption_OneofString_Value)(nil),
		(*ResourceOptions_StringVariableMapOption_OneofString_Values)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_cdn_v1_resource_proto_rawDesc), len(file_yandex_cloud_cdn_v1_resource_proto_rawDesc)),
			NumEnums:      6,
			NumMessages:   30,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_cdn_v1_resource_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_cdn_v1_resource_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_cdn_v1_resource_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_cdn_v1_resource_proto_msgTypes,
	}.Build()
	File_yandex_cloud_cdn_v1_resource_proto = out.File
	file_yandex_cloud_cdn_v1_resource_proto_goTypes = nil
	file_yandex_cloud_cdn_v1_resource_proto_depIdxs = nil
}
