// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.6.1
// - protoc             v3.21.12
// source: yandex/cloud/cloudregistry/v1/registry_service.proto

package cloudregistry

import (
	context "context"
	access "github.com/yandex-cloud/go-genproto/yandex/cloud/access"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	RegistryService_Get_FullMethodName                  = "/yandex.cloud.cloudregistry.v1.RegistryService/Get"
	RegistryService_List_FullMethodName                 = "/yandex.cloud.cloudregistry.v1.RegistryService/List"
	RegistryService_Create_FullMethodName               = "/yandex.cloud.cloudregistry.v1.RegistryService/Create"
	RegistryService_Update_FullMethodName               = "/yandex.cloud.cloudregistry.v1.RegistryService/Update"
	RegistryService_Delete_FullMethodName               = "/yandex.cloud.cloudregistry.v1.RegistryService/Delete"
	RegistryService_ForceDelete_FullMethodName          = "/yandex.cloud.cloudregistry.v1.RegistryService/ForceDelete"
	RegistryService_ListAccessBindings_FullMethodName   = "/yandex.cloud.cloudregistry.v1.RegistryService/ListAccessBindings"
	RegistryService_SetAccessBindings_FullMethodName    = "/yandex.cloud.cloudregistry.v1.RegistryService/SetAccessBindings"
	RegistryService_UpdateAccessBindings_FullMethodName = "/yandex.cloud.cloudregistry.v1.RegistryService/UpdateAccessBindings"
	RegistryService_ListIpPermissions_FullMethodName    = "/yandex.cloud.cloudregistry.v1.RegistryService/ListIpPermissions"
	RegistryService_SetIpPermissions_FullMethodName     = "/yandex.cloud.cloudregistry.v1.RegistryService/SetIpPermissions"
	RegistryService_UpdateIpPermissions_FullMethodName  = "/yandex.cloud.cloudregistry.v1.RegistryService/UpdateIpPermissions"
	RegistryService_ListArtifacts_FullMethodName        = "/yandex.cloud.cloudregistry.v1.RegistryService/ListArtifacts"
)

// RegistryServiceClient is the client API for RegistryService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// A set of methods for managing Registry resources.
type RegistryServiceClient interface {
	// Returns the specified Registry resource.
	//
	// To get the list of available Registry resources, make a [RegistryService.List] request.
	Get(ctx context.Context, in *GetRegistryRequest, opts ...grpc.CallOption) (*Registry, error)
	// Retrieves the list of Registry resources in the specified folder.
	List(ctx context.Context, in *ListRegistriesRequest, opts ...grpc.CallOption) (*ListRegistriesResponse, error)
	// Creates a registry in the specified folder.
	Create(ctx context.Context, in *CreateRegistryRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified registry.
	Update(ctx context.Context, in *UpdateRegistryRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified registry.
	Delete(ctx context.Context, in *DeleteRegistryRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Forcefully deletes the specified registry along with all its repositories and data.
	ForceDelete(ctx context.Context, in *DeleteRegistryRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Lists access bindings for the specified registry.
	ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error)
	// Sets access bindings for the specified registry.
	SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates access bindings for the specified registry.
	UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// List ip permissions for the specified registry.
	ListIpPermissions(ctx context.Context, in *ListIpPermissionsRequest, opts ...grpc.CallOption) (*ListIpPermissionsResponse, error)
	// Set ip permissions for the specified registry.
	SetIpPermissions(ctx context.Context, in *SetIpPermissionsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Update ip permissions for the specified registry.
	UpdateIpPermissions(ctx context.Context, in *UpdateIpPermissionsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Retrieves the list of registry artifact resources in the specified registry.
	ListArtifacts(ctx context.Context, in *ListArtifactsRequest, opts ...grpc.CallOption) (*ListArtifactsResponse, error)
}

type registryServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewRegistryServiceClient(cc grpc.ClientConnInterface) RegistryServiceClient {
	return &registryServiceClient{cc}
}

func (c *registryServiceClient) Get(ctx context.Context, in *GetRegistryRequest, opts ...grpc.CallOption) (*Registry, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Registry)
	err := c.cc.Invoke(ctx, RegistryService_Get_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryServiceClient) List(ctx context.Context, in *ListRegistriesRequest, opts ...grpc.CallOption) (*ListRegistriesResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListRegistriesResponse)
	err := c.cc.Invoke(ctx, RegistryService_List_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryServiceClient) Create(ctx context.Context, in *CreateRegistryRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, RegistryService_Create_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryServiceClient) Update(ctx context.Context, in *UpdateRegistryRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, RegistryService_Update_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryServiceClient) Delete(ctx context.Context, in *DeleteRegistryRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, RegistryService_Delete_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryServiceClient) ForceDelete(ctx context.Context, in *DeleteRegistryRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, RegistryService_ForceDelete_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryServiceClient) ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(access.ListAccessBindingsResponse)
	err := c.cc.Invoke(ctx, RegistryService_ListAccessBindings_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryServiceClient) SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, RegistryService_SetAccessBindings_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryServiceClient) UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, RegistryService_UpdateAccessBindings_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryServiceClient) ListIpPermissions(ctx context.Context, in *ListIpPermissionsRequest, opts ...grpc.CallOption) (*ListIpPermissionsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListIpPermissionsResponse)
	err := c.cc.Invoke(ctx, RegistryService_ListIpPermissions_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryServiceClient) SetIpPermissions(ctx context.Context, in *SetIpPermissionsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, RegistryService_SetIpPermissions_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryServiceClient) UpdateIpPermissions(ctx context.Context, in *UpdateIpPermissionsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, RegistryService_UpdateIpPermissions_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryServiceClient) ListArtifacts(ctx context.Context, in *ListArtifactsRequest, opts ...grpc.CallOption) (*ListArtifactsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListArtifactsResponse)
	err := c.cc.Invoke(ctx, RegistryService_ListArtifacts_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RegistryServiceServer is the server API for RegistryService service.
// All implementations should embed UnimplementedRegistryServiceServer
// for forward compatibility.
//
// A set of methods for managing Registry resources.
type RegistryServiceServer interface {
	// Returns the specified Registry resource.
	//
	// To get the list of available Registry resources, make a [RegistryService.List] request.
	Get(context.Context, *GetRegistryRequest) (*Registry, error)
	// Retrieves the list of Registry resources in the specified folder.
	List(context.Context, *ListRegistriesRequest) (*ListRegistriesResponse, error)
	// Creates a registry in the specified folder.
	Create(context.Context, *CreateRegistryRequest) (*operation.Operation, error)
	// Updates the specified registry.
	Update(context.Context, *UpdateRegistryRequest) (*operation.Operation, error)
	// Deletes the specified registry.
	Delete(context.Context, *DeleteRegistryRequest) (*operation.Operation, error)
	// Forcefully deletes the specified registry along with all its repositories and data.
	ForceDelete(context.Context, *DeleteRegistryRequest) (*operation.Operation, error)
	// Lists access bindings for the specified registry.
	ListAccessBindings(context.Context, *access.ListAccessBindingsRequest) (*access.ListAccessBindingsResponse, error)
	// Sets access bindings for the specified registry.
	SetAccessBindings(context.Context, *access.SetAccessBindingsRequest) (*operation.Operation, error)
	// Updates access bindings for the specified registry.
	UpdateAccessBindings(context.Context, *access.UpdateAccessBindingsRequest) (*operation.Operation, error)
	// List ip permissions for the specified registry.
	ListIpPermissions(context.Context, *ListIpPermissionsRequest) (*ListIpPermissionsResponse, error)
	// Set ip permissions for the specified registry.
	SetIpPermissions(context.Context, *SetIpPermissionsRequest) (*operation.Operation, error)
	// Update ip permissions for the specified registry.
	UpdateIpPermissions(context.Context, *UpdateIpPermissionsRequest) (*operation.Operation, error)
	// Retrieves the list of registry artifact resources in the specified registry.
	ListArtifacts(context.Context, *ListArtifactsRequest) (*ListArtifactsResponse, error)
}

// UnimplementedRegistryServiceServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedRegistryServiceServer struct{}

func (UnimplementedRegistryServiceServer) Get(context.Context, *GetRegistryRequest) (*Registry, error) {
	return nil, status.Error(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedRegistryServiceServer) List(context.Context, *ListRegistriesRequest) (*ListRegistriesResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedRegistryServiceServer) Create(context.Context, *CreateRegistryRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method Create not implemented")
}
func (UnimplementedRegistryServiceServer) Update(context.Context, *UpdateRegistryRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method Update not implemented")
}
func (UnimplementedRegistryServiceServer) Delete(context.Context, *DeleteRegistryRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedRegistryServiceServer) ForceDelete(context.Context, *DeleteRegistryRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method ForceDelete not implemented")
}
func (UnimplementedRegistryServiceServer) ListAccessBindings(context.Context, *access.ListAccessBindingsRequest) (*access.ListAccessBindingsResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method ListAccessBindings not implemented")
}
func (UnimplementedRegistryServiceServer) SetAccessBindings(context.Context, *access.SetAccessBindingsRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method SetAccessBindings not implemented")
}
func (UnimplementedRegistryServiceServer) UpdateAccessBindings(context.Context, *access.UpdateAccessBindingsRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method UpdateAccessBindings not implemented")
}
func (UnimplementedRegistryServiceServer) ListIpPermissions(context.Context, *ListIpPermissionsRequest) (*ListIpPermissionsResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method ListIpPermissions not implemented")
}
func (UnimplementedRegistryServiceServer) SetIpPermissions(context.Context, *SetIpPermissionsRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method SetIpPermissions not implemented")
}
func (UnimplementedRegistryServiceServer) UpdateIpPermissions(context.Context, *UpdateIpPermissionsRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method UpdateIpPermissions not implemented")
}
func (UnimplementedRegistryServiceServer) ListArtifacts(context.Context, *ListArtifactsRequest) (*ListArtifactsResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method ListArtifacts not implemented")
}
func (UnimplementedRegistryServiceServer) testEmbeddedByValue() {}

// UnsafeRegistryServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to RegistryServiceServer will
// result in compilation errors.
type UnsafeRegistryServiceServer interface {
	mustEmbedUnimplementedRegistryServiceServer()
}

func RegisterRegistryServiceServer(s grpc.ServiceRegistrar, srv RegistryServiceServer) {
	// If the following call panics, it indicates UnimplementedRegistryServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&RegistryService_ServiceDesc, srv)
}

func _RegistryService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRegistryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RegistryService_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).Get(ctx, req.(*GetRegistryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistryService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRegistriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RegistryService_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).List(ctx, req.(*ListRegistriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistryService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRegistryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RegistryService_Create_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).Create(ctx, req.(*CreateRegistryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistryService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRegistryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RegistryService_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).Update(ctx, req.(*UpdateRegistryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistryService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRegistryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RegistryService_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).Delete(ctx, req.(*DeleteRegistryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistryService_ForceDelete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRegistryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).ForceDelete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RegistryService_ForceDelete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).ForceDelete(ctx, req.(*DeleteRegistryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistryService_ListAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.ListAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).ListAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RegistryService_ListAccessBindings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).ListAccessBindings(ctx, req.(*access.ListAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistryService_SetAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.SetAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).SetAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RegistryService_SetAccessBindings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).SetAccessBindings(ctx, req.(*access.SetAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistryService_UpdateAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.UpdateAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).UpdateAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RegistryService_UpdateAccessBindings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).UpdateAccessBindings(ctx, req.(*access.UpdateAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistryService_ListIpPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListIpPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).ListIpPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RegistryService_ListIpPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).ListIpPermissions(ctx, req.(*ListIpPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistryService_SetIpPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetIpPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).SetIpPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RegistryService_SetIpPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).SetIpPermissions(ctx, req.(*SetIpPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistryService_UpdateIpPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateIpPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).UpdateIpPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RegistryService_UpdateIpPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).UpdateIpPermissions(ctx, req.(*UpdateIpPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistryService_ListArtifacts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListArtifactsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).ListArtifacts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RegistryService_ListArtifacts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).ListArtifacts(ctx, req.(*ListArtifactsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// RegistryService_ServiceDesc is the grpc.ServiceDesc for RegistryService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var RegistryService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.cloudregistry.v1.RegistryService",
	HandlerType: (*RegistryServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _RegistryService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _RegistryService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _RegistryService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _RegistryService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _RegistryService_Delete_Handler,
		},
		{
			MethodName: "ForceDelete",
			Handler:    _RegistryService_ForceDelete_Handler,
		},
		{
			MethodName: "ListAccessBindings",
			Handler:    _RegistryService_ListAccessBindings_Handler,
		},
		{
			MethodName: "SetAccessBindings",
			Handler:    _RegistryService_SetAccessBindings_Handler,
		},
		{
			MethodName: "UpdateAccessBindings",
			Handler:    _RegistryService_UpdateAccessBindings_Handler,
		},
		{
			MethodName: "ListIpPermissions",
			Handler:    _RegistryService_ListIpPermissions_Handler,
		},
		{
			MethodName: "SetIpPermissions",
			Handler:    _RegistryService_SetIpPermissions_Handler,
		},
		{
			MethodName: "UpdateIpPermissions",
			Handler:    _RegistryService_UpdateIpPermissions_Handler,
		},
		{
			MethodName: "ListArtifacts",
			Handler:    _RegistryService_ListArtifacts_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/cloudregistry/v1/registry_service.proto",
}
