// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        v3.21.12
// source: yandex/cloud/compute/v1/image_service.proto

package compute

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	access "github.com/yandex-cloud/go-genproto/yandex/cloud/access"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type GetImageRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the Image resource to return.
	// To get the image ID, use a [ImageService.List] request.
	ImageId       string `protobuf:"bytes,1,opt,name=image_id,json=imageId,proto3" json:"image_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetImageRequest) Reset() {
	*x = GetImageRequest{}
	mi := &file_yandex_cloud_compute_v1_image_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetImageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetImageRequest) ProtoMessage() {}

func (x *GetImageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_image_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetImageRequest.ProtoReflect.Descriptor instead.
func (*GetImageRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_image_service_proto_rawDescGZIP(), []int{0}
}

func (x *GetImageRequest) GetImageId() string {
	if x != nil {
		return x.ImageId
	}
	return ""
}

type GetImageLatestByFamilyRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the folder to get the image from.
	// To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Name of the image family to search for.
	Family        string `protobuf:"bytes,2,opt,name=family,proto3" json:"family,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetImageLatestByFamilyRequest) Reset() {
	*x = GetImageLatestByFamilyRequest{}
	mi := &file_yandex_cloud_compute_v1_image_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetImageLatestByFamilyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetImageLatestByFamilyRequest) ProtoMessage() {}

func (x *GetImageLatestByFamilyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_image_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetImageLatestByFamilyRequest.ProtoReflect.Descriptor instead.
func (*GetImageLatestByFamilyRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_image_service_proto_rawDescGZIP(), []int{1}
}

func (x *GetImageLatestByFamilyRequest) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *GetImageLatestByFamilyRequest) GetFamily() string {
	if x != nil {
		return x.Family
	}
	return ""
}

type ListImagesRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the folder to list images in.
	// To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListImagesResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListImagesResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// The expression consists of one or more conditions united by `AND` operator: `<condition1> [AND <condition2> [<...> AND <conditionN>]]`.
	//
	// Each condition has the form `<field> <operator> <value>`, where:
	// 1. `<field>` is the field name. Currently you can use filtering only on the limited number of fields.
	// 2. `<operator>` is a logical operator, one of `=`, `!=`, `IN`, `NOT IN`.
	// 3. `<value>` represents a value.
	// String values should be written in double (`"`) or single (`'`) quotes. C-style escape sequences are supported (`\"` turns to `"`, `\'` to `'`, `\\` to backslash).
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// By which column the listing should be ordered and in which direction,
	// format is "createdAt desc". "id asc" if omitted.
	// The default sorting order is ascending
	OrderBy       string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListImagesRequest) Reset() {
	*x = ListImagesRequest{}
	mi := &file_yandex_cloud_compute_v1_image_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListImagesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListImagesRequest) ProtoMessage() {}

func (x *ListImagesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_image_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListImagesRequest.ProtoReflect.Descriptor instead.
func (*ListImagesRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_image_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListImagesRequest) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *ListImagesRequest) GetPageSize() int64 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListImagesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListImagesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListImagesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

type ListImagesResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of images.
	Images []*Image `protobuf:"bytes,1,rep,name=images,proto3" json:"images,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListSnapshotsRequest.page_size], use
	// the [next_page_token] as the value
	// for the [ListSnapshotsRequest.page_token] query parameter
	// in the next list request. Each subsequent list request will have its own
	// [next_page_token] to continue paging through the results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListImagesResponse) Reset() {
	*x = ListImagesResponse{}
	mi := &file_yandex_cloud_compute_v1_image_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListImagesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListImagesResponse) ProtoMessage() {}

func (x *ListImagesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_image_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListImagesResponse.ProtoReflect.Descriptor instead.
func (*ListImagesResponse) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_image_service_proto_rawDescGZIP(), []int{3}
}

func (x *ListImagesResponse) GetImages() []*Image {
	if x != nil {
		return x.Images
	}
	return nil
}

func (x *ListImagesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

type CreateImageRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the folder to create an image in.
	// To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Name of the image.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the image.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `key:value` pairs.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// The name of the image family to which this image belongs. For more information, see [Image family](/docs/compute/concepts/image#family).
	//
	// To get an information about the most recent image from a family, use a [ImageService.GetLatestByFamily] request.
	Family string `protobuf:"bytes,5,opt,name=family,proto3" json:"family,omitempty"`
	// Minimum size of the disk that will be created from this image.
	// Specified in bytes. Should be more than the volume of source data.
	MinDiskSize int64 `protobuf:"varint,6,opt,name=min_disk_size,json=minDiskSize,proto3" json:"min_disk_size,omitempty"` // optional, should be > source data
	// License IDs that indicate which licenses are attached to this resource.
	// License IDs are used to calculate additional charges for the use of the virtual machine.
	//
	// The correct license ID is generated by the platform. IDs are inherited by new resources created from this resource.
	//
	// If you know the license IDs, specify them when you create the image.
	// For example, if you create a disk image using a third-party utility and load it into Object Storage, the license IDs will be lost.
	// You can specify them in this request.
	ProductIds []string `protobuf:"bytes,7,rep,name=product_ids,json=productIds,proto3" json:"product_ids,omitempty"`
	// Types that are valid to be assigned to Source:
	//
	//	*CreateImageRequest_ImageId
	//	*CreateImageRequest_DiskId
	//	*CreateImageRequest_SnapshotId
	//	*CreateImageRequest_Uri
	Source isCreateImageRequest_Source `protobuf_oneof:"source"`
	// Operating system that is contained in the image.
	//
	// If not specified and you used the `image_id` or `disk_id` field to set the source, then the value can be inherited from the source resource.
	Os *Os `protobuf:"bytes,12,opt,name=os,proto3" json:"os,omitempty"`
	// When true, an image pool will be created for fast creation disks from the image.
	Pooled bool `protobuf:"varint,17,opt,name=pooled,proto3" json:"pooled,omitempty"`
	// Specify the overrides to hardware_generation of a source disk, image or snapshot,
	// or to the default values if the source does not define it.
	HardwareGeneration *HardwareGeneration `protobuf:"bytes,18,opt,name=hardware_generation,json=hardwareGeneration,proto3" json:"hardware_generation,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *CreateImageRequest) Reset() {
	*x = CreateImageRequest{}
	mi := &file_yandex_cloud_compute_v1_image_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateImageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateImageRequest) ProtoMessage() {}

func (x *CreateImageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_image_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateImageRequest.ProtoReflect.Descriptor instead.
func (*CreateImageRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_image_service_proto_rawDescGZIP(), []int{4}
}

func (x *CreateImageRequest) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *CreateImageRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateImageRequest) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CreateImageRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *CreateImageRequest) GetFamily() string {
	if x != nil {
		return x.Family
	}
	return ""
}

func (x *CreateImageRequest) GetMinDiskSize() int64 {
	if x != nil {
		return x.MinDiskSize
	}
	return 0
}

func (x *CreateImageRequest) GetProductIds() []string {
	if x != nil {
		return x.ProductIds
	}
	return nil
}

func (x *CreateImageRequest) GetSource() isCreateImageRequest_Source {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *CreateImageRequest) GetImageId() string {
	if x != nil {
		if x, ok := x.Source.(*CreateImageRequest_ImageId); ok {
			return x.ImageId
		}
	}
	return ""
}

func (x *CreateImageRequest) GetDiskId() string {
	if x != nil {
		if x, ok := x.Source.(*CreateImageRequest_DiskId); ok {
			return x.DiskId
		}
	}
	return ""
}

func (x *CreateImageRequest) GetSnapshotId() string {
	if x != nil {
		if x, ok := x.Source.(*CreateImageRequest_SnapshotId); ok {
			return x.SnapshotId
		}
	}
	return ""
}

func (x *CreateImageRequest) GetUri() string {
	if x != nil {
		if x, ok := x.Source.(*CreateImageRequest_Uri); ok {
			return x.Uri
		}
	}
	return ""
}

func (x *CreateImageRequest) GetOs() *Os {
	if x != nil {
		return x.Os
	}
	return nil
}

func (x *CreateImageRequest) GetPooled() bool {
	if x != nil {
		return x.Pooled
	}
	return false
}

func (x *CreateImageRequest) GetHardwareGeneration() *HardwareGeneration {
	if x != nil {
		return x.HardwareGeneration
	}
	return nil
}

type isCreateImageRequest_Source interface {
	isCreateImageRequest_Source()
}

type CreateImageRequest_ImageId struct {
	// ID of the source image to create the new image from.
	ImageId string `protobuf:"bytes,8,opt,name=image_id,json=imageId,proto3,oneof"`
}

type CreateImageRequest_DiskId struct {
	// ID of the disk to create the image from.
	DiskId string `protobuf:"bytes,9,opt,name=disk_id,json=diskId,proto3,oneof"`
}

type CreateImageRequest_SnapshotId struct {
	// ID of the snapshot to create the image from.
	SnapshotId string `protobuf:"bytes,10,opt,name=snapshot_id,json=snapshotId,proto3,oneof"`
}

type CreateImageRequest_Uri struct {
	// URI of the source image to create the new image from.
	// Currently only supports links to images that are stored in Object Storage.
	// Must be a valid [pre-signed URL](/docs/storage/concepts/pre-signed-urls).
	// Currently only supports Qcow2, VMDK, and RAW image formats.
	Uri string `protobuf:"bytes,11,opt,name=uri,proto3,oneof"`
}

func (*CreateImageRequest_ImageId) isCreateImageRequest_Source() {}

func (*CreateImageRequest_DiskId) isCreateImageRequest_Source() {}

func (*CreateImageRequest_SnapshotId) isCreateImageRequest_Source() {}

func (*CreateImageRequest_Uri) isCreateImageRequest_Source() {}

type CreateImageMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the image that is being created.
	ImageId       string `protobuf:"bytes,1,opt,name=image_id,json=imageId,proto3" json:"image_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateImageMetadata) Reset() {
	*x = CreateImageMetadata{}
	mi := &file_yandex_cloud_compute_v1_image_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateImageMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateImageMetadata) ProtoMessage() {}

func (x *CreateImageMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_image_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateImageMetadata.ProtoReflect.Descriptor instead.
func (*CreateImageMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_image_service_proto_rawDescGZIP(), []int{5}
}

func (x *CreateImageMetadata) GetImageId() string {
	if x != nil {
		return x.ImageId
	}
	return ""
}

type UpdateImageRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the Image resource to update.
	// To get the image ID, use a [ImageService.List] request.
	ImageId string `protobuf:"bytes,1,opt,name=image_id,json=imageId,proto3" json:"image_id,omitempty"`
	// Field mask that specifies which fields of the Image resource are going to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Name of the image.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the image.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Minimum size of the disk that can be created from this image.
	// Specified in bytes. Should be more than the volume of source data and more than the virtual disk size.
	MinDiskSize int64 `protobuf:"varint,5,opt,name=min_disk_size,json=minDiskSize,proto3" json:"min_disk_size,omitempty"`
	// Resource labels as `key:value` pairs.
	//
	// Existing set of `labels` is completely replaced by the provided set.
	Labels        map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateImageRequest) Reset() {
	*x = UpdateImageRequest{}
	mi := &file_yandex_cloud_compute_v1_image_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateImageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateImageRequest) ProtoMessage() {}

func (x *UpdateImageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_image_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateImageRequest.ProtoReflect.Descriptor instead.
func (*UpdateImageRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_image_service_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateImageRequest) GetImageId() string {
	if x != nil {
		return x.ImageId
	}
	return ""
}

func (x *UpdateImageRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateImageRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateImageRequest) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *UpdateImageRequest) GetMinDiskSize() int64 {
	if x != nil {
		return x.MinDiskSize
	}
	return 0
}

func (x *UpdateImageRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

type UpdateImageMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the Image resource that is being updated.
	ImageId       string `protobuf:"bytes,1,opt,name=image_id,json=imageId,proto3" json:"image_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateImageMetadata) Reset() {
	*x = UpdateImageMetadata{}
	mi := &file_yandex_cloud_compute_v1_image_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateImageMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateImageMetadata) ProtoMessage() {}

func (x *UpdateImageMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_image_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateImageMetadata.ProtoReflect.Descriptor instead.
func (*UpdateImageMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_image_service_proto_rawDescGZIP(), []int{7}
}

func (x *UpdateImageMetadata) GetImageId() string {
	if x != nil {
		return x.ImageId
	}
	return ""
}

type DeleteImageRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the image to delete.
	// To get the image ID, use a [ImageService.List] request.
	ImageId       string `protobuf:"bytes,1,opt,name=image_id,json=imageId,proto3" json:"image_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteImageRequest) Reset() {
	*x = DeleteImageRequest{}
	mi := &file_yandex_cloud_compute_v1_image_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteImageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteImageRequest) ProtoMessage() {}

func (x *DeleteImageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_image_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteImageRequest.ProtoReflect.Descriptor instead.
func (*DeleteImageRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_image_service_proto_rawDescGZIP(), []int{8}
}

func (x *DeleteImageRequest) GetImageId() string {
	if x != nil {
		return x.ImageId
	}
	return ""
}

type DeleteImageMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the image that is being deleted.
	ImageId       string `protobuf:"bytes,1,opt,name=image_id,json=imageId,proto3" json:"image_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteImageMetadata) Reset() {
	*x = DeleteImageMetadata{}
	mi := &file_yandex_cloud_compute_v1_image_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteImageMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteImageMetadata) ProtoMessage() {}

func (x *DeleteImageMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_image_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteImageMetadata.ProtoReflect.Descriptor instead.
func (*DeleteImageMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_image_service_proto_rawDescGZIP(), []int{9}
}

func (x *DeleteImageMetadata) GetImageId() string {
	if x != nil {
		return x.ImageId
	}
	return ""
}

type ListImageOperationsRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the Image resource to list operations for.
	ImageId string `protobuf:"bytes,1,opt,name=image_id,json=imageId,proto3" json:"image_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListImageOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListImageOperationsResponse.next_page_token] returned by a previous list request.
	PageToken     string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListImageOperationsRequest) Reset() {
	*x = ListImageOperationsRequest{}
	mi := &file_yandex_cloud_compute_v1_image_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListImageOperationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListImageOperationsRequest) ProtoMessage() {}

func (x *ListImageOperationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_image_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListImageOperationsRequest.ProtoReflect.Descriptor instead.
func (*ListImageOperationsRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_image_service_proto_rawDescGZIP(), []int{10}
}

func (x *ListImageOperationsRequest) GetImageId() string {
	if x != nil {
		return x.ImageId
	}
	return ""
}

func (x *ListImageOperationsRequest) GetPageSize() int64 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListImageOperationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

type ListImageOperationsResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of operations for the specified image.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListImageOperationsRequest.page_size], use the [next_page_token] as the value
	// for the [ListImageOperationsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListImageOperationsResponse) Reset() {
	*x = ListImageOperationsResponse{}
	mi := &file_yandex_cloud_compute_v1_image_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListImageOperationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListImageOperationsResponse) ProtoMessage() {}

func (x *ListImageOperationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_image_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListImageOperationsResponse.ProtoReflect.Descriptor instead.
func (*ListImageOperationsResponse) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_image_service_proto_rawDescGZIP(), []int{11}
}

func (x *ListImageOperationsResponse) GetOperations() []*operation.Operation {
	if x != nil {
		return x.Operations
	}
	return nil
}

func (x *ListImageOperationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_yandex_cloud_compute_v1_image_service_proto protoreflect.FileDescriptor

const file_yandex_cloud_compute_v1_image_service_proto_rawDesc = "" +
	"\n" +
	"+yandex/cloud/compute/v1/image_service.proto\x12\x17yandex.cloud.compute.v1\x1a\x1cgoogle/api/annotations.proto\x1a google/protobuf/field_mask.proto\x1a yandex/cloud/access/access.proto\x1a yandex/cloud/api/operation.proto\x1a1yandex/cloud/compute/v1/hardware_generation.proto\x1a#yandex/cloud/compute/v1/image.proto\x1a&yandex/cloud/operation/operation.proto\x1a\x1dyandex/cloud/validation.proto\":\n" +
	"\x0fGetImageRequest\x12'\n" +
	"\bimage_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\aimageId\"\x85\x01\n" +
	"\x1dGetImageLatestByFamilyRequest\x12)\n" +
	"\tfolder_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\bfolderId\x129\n" +
	"\x06family\x18\x02 \x01(\tB!\xf2\xc71\x1d|[a-z][-a-z0-9]{1,61}[a-z0-9]R\x06family\"\xdb\x01\n" +
	"\x11ListImagesRequest\x12)\n" +
	"\tfolder_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\bfolderId\x12'\n" +
	"\tpage_size\x18\x02 \x01(\x03B\n" +
	"\xfa\xc71\x06<=1000R\bpageSize\x12(\n" +
	"\n" +
	"page_token\x18\x03 \x01(\tB\t\x8a\xc81\x05<=100R\tpageToken\x12\"\n" +
	"\x06filter\x18\x04 \x01(\tB\n" +
	"\x8a\xc81\x06<=1000R\x06filter\x12$\n" +
	"\border_by\x18\x05 \x01(\tB\t\x8a\xc81\x05<=100R\aorderBy\"t\n" +
	"\x12ListImagesResponse\x126\n" +
	"\x06images\x18\x01 \x03(\v2\x1e.yandex.cloud.compute.v1.ImageR\x06images\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"\xe4\x06\n" +
	"\x12CreateImageRequest\x12)\n" +
	"\tfolder_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\bfolderId\x129\n" +
	"\x04name\x18\x02 \x01(\tB%\xf2\xc71!|[a-z]([-_a-z0-9]{0,61}[a-z0-9])?R\x04name\x12+\n" +
	"\vdescription\x18\x03 \x01(\tB\t\x8a\xc81\x05<=256R\vdescription\x12\x94\x01\n" +
	"\x06labels\x18\x04 \x03(\v27.yandex.cloud.compute.v1.CreateImageRequest.LabelsEntryBC\xf2\xc71\x0f[-_./\\@0-9a-z]*\x82\xc81\x04<=64\x8a\xc81\x04<=63\xb2\xc81\x1c\x12\x14[a-z][-_./\\@0-9a-z]*\x1a\x041-63R\x06labels\x129\n" +
	"\x06family\x18\x05 \x01(\tB!\xf2\xc71\x1d|[a-z][-a-z0-9]{1,61}[a-z0-9]R\x06family\x12=\n" +
	"\rmin_disk_size\x18\x06 \x01(\x03B\x19\xfa\xc71\x154194304-4398046511104R\vminDiskSize\x12)\n" +
	"\vproduct_ids\x18\a \x03(\tB\b\x8a\xc81\x04<=50R\n" +
	"productIds\x12%\n" +
	"\bimage_id\x18\b \x01(\tB\b\x8a\xc81\x04<=50H\x00R\aimageId\x12#\n" +
	"\adisk_id\x18\t \x01(\tB\b\x8a\xc81\x04<=50H\x00R\x06diskId\x12+\n" +
	"\vsnapshot_id\x18\n" +
	" \x01(\tB\b\x8a\xc81\x04<=50H\x00R\n" +
	"snapshotId\x12\x12\n" +
	"\x03uri\x18\v \x01(\tH\x00R\x03uri\x12+\n" +
	"\x02os\x18\f \x01(\v2\x1b.yandex.cloud.compute.v1.OsR\x02os\x12\x16\n" +
	"\x06pooled\x18\x11 \x01(\bR\x06pooled\x12\\\n" +
	"\x13hardware_generation\x18\x12 \x01(\v2+.yandex.cloud.compute.v1.HardwareGenerationR\x12hardwareGeneration\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01B\x0e\n" +
	"\x06source\x12\x04\xc0\xc11\x01J\x04\b\r\x10\x11\"0\n" +
	"\x13CreateImageMetadata\x12\x19\n" +
	"\bimage_id\x18\x01 \x01(\tR\aimageId\"\xf3\x03\n" +
	"\x12UpdateImageRequest\x12'\n" +
	"\bimage_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\aimageId\x12;\n" +
	"\vupdate_mask\x18\x02 \x01(\v2\x1a.google.protobuf.FieldMaskR\n" +
	"updateMask\x129\n" +
	"\x04name\x18\x03 \x01(\tB%\xf2\xc71!|[a-z]([-_a-z0-9]{0,61}[a-z0-9])?R\x04name\x12+\n" +
	"\vdescription\x18\x04 \x01(\tB\t\x8a\xc81\x05<=256R\vdescription\x12=\n" +
	"\rmin_disk_size\x18\x05 \x01(\x03B\x19\xfa\xc71\x154194304-4398046511104R\vminDiskSize\x12\x94\x01\n" +
	"\x06labels\x18\x06 \x03(\v27.yandex.cloud.compute.v1.UpdateImageRequest.LabelsEntryBC\xf2\xc71\x0f[-_./\\@0-9a-z]*\x82\xc81\x04<=64\x8a\xc81\x04<=63\xb2\xc81\x1c\x12\x14[a-z][-_./\\@0-9a-z]*\x1a\x041-63R\x06labels\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"0\n" +
	"\x13UpdateImageMetadata\x12\x19\n" +
	"\bimage_id\x18\x01 \x01(\tR\aimageId\"=\n" +
	"\x12DeleteImageRequest\x12'\n" +
	"\bimage_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\aimageId\"0\n" +
	"\x13DeleteImageMetadata\x12\x19\n" +
	"\bimage_id\x18\x01 \x01(\tR\aimageId\"\x98\x01\n" +
	"\x1aListImageOperationsRequest\x12'\n" +
	"\bimage_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\aimageId\x12'\n" +
	"\tpage_size\x18\x02 \x01(\x03B\n" +
	"\xfa\xc71\x06<=1000R\bpageSize\x12(\n" +
	"\n" +
	"page_token\x18\x03 \x01(\tB\t\x8a\xc81\x05<=100R\tpageToken\"\x88\x01\n" +
	"\x1bListImageOperationsResponse\x12A\n" +
	"\n" +
	"operations\x18\x01 \x03(\v2!.yandex.cloud.operation.OperationR\n" +
	"operations\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken2\xe6\r\n" +
	"\fImageService\x12v\n" +
	"\x03Get\x12(.yandex.cloud.compute.v1.GetImageRequest\x1a\x1e.yandex.cloud.compute.v1.Image\"%\x82\xd3\xe4\x93\x02\x1f\x12\x1d/compute/v1/images/{image_id}\x12\x96\x01\n" +
	"\x11GetLatestByFamily\x126.yandex.cloud.compute.v1.GetImageLatestByFamilyRequest\x1a\x1e.yandex.cloud.compute.v1.Image\")\x82\xd3\xe4\x93\x02#\x12!/compute/v1/images:latestByFamily\x12{\n" +
	"\x04List\x12*.yandex.cloud.compute.v1.ListImagesRequest\x1a+.yandex.cloud.compute.v1.ListImagesResponse\"\x1a\x82\xd3\xe4\x93\x02\x14\x12\x12/compute/v1/images\x12\x97\x01\n" +
	"\x06Create\x12+.yandex.cloud.compute.v1.CreateImageRequest\x1a!.yandex.cloud.operation.Operation\"=\xb2\xd2*\x1c\n" +
	"\x13CreateImageMetadata\x12\x05Image\x82\xd3\xe4\x93\x02\x17:\x01*\"\x12/compute/v1/images\x12\xa2\x01\n" +
	"\x06Update\x12+.yandex.cloud.compute.v1.UpdateImageRequest\x1a!.yandex.cloud.operation.Operation\"H\xb2\xd2*\x1c\n" +
	"\x13UpdateImageMetadata\x12\x05Image\x82\xd3\xe4\x93\x02\":\x01*2\x1d/compute/v1/images/{image_id}\x12\xaf\x01\n" +
	"\x06Delete\x12+.yandex.cloud.compute.v1.DeleteImageRequest\x1a!.yandex.cloud.operation.Operation\"U\xb2\xd2*,\n" +
	"\x13DeleteImageMetadata\x12\x15google.protobuf.Empty\x82\xd3\xe4\x93\x02\x1f*\x1d/compute/v1/images/{image_id}\x12\xad\x01\n" +
	"\x0eListOperations\x123.yandex.cloud.compute.v1.ListImageOperationsRequest\x1a4.yandex.cloud.compute.v1.ListImageOperationsResponse\"0\x82\xd3\xe4\x93\x02*\x12(/compute/v1/images/{image_id}/operations\x12\xb2\x01\n" +
	"\x12ListAccessBindings\x12..yandex.cloud.access.ListAccessBindingsRequest\x1a/.yandex.cloud.access.ListAccessBindingsResponse\";\x82\xd3\xe4\x93\x025\x123/compute/v1/images/{resource_id}:listAccessBindings\x12\xf1\x01\n" +
	"\x11SetAccessBindings\x12-.yandex.cloud.access.SetAccessBindingsRequest\x1a!.yandex.cloud.operation.Operation\"\x89\x01\xb2\xd2*H\n" +
	" access.SetAccessBindingsMetadata\x12$access.AccessBindingsOperationResult\x82\xd3\xe4\x93\x027:\x01*\"2/compute/v1/images/{resource_id}:setAccessBindings\x12\xfd\x01\n" +
	"\x14UpdateAccessBindings\x120.yandex.cloud.access.UpdateAccessBindingsRequest\x1a!.yandex.cloud.operation.Operation\"\x8f\x01\xb2\xd2*K\n" +
	"#access.UpdateAccessBindingsMetadata\x12$access.AccessBindingsOperationResult\x82\xd3\xe4\x93\x02::\x01*\"5/compute/v1/images/{resource_id}:updateAccessBindingsBb\n" +
	"\x1byandex.cloud.api.compute.v1ZCgithub.com/yandex-cloud/go-genproto/yandex/cloud/compute/v1;computeb\x06proto3"

var (
	file_yandex_cloud_compute_v1_image_service_proto_rawDescOnce sync.Once
	file_yandex_cloud_compute_v1_image_service_proto_rawDescData []byte
)

func file_yandex_cloud_compute_v1_image_service_proto_rawDescGZIP() []byte {
	file_yandex_cloud_compute_v1_image_service_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_compute_v1_image_service_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_compute_v1_image_service_proto_rawDesc), len(file_yandex_cloud_compute_v1_image_service_proto_rawDesc)))
	})
	return file_yandex_cloud_compute_v1_image_service_proto_rawDescData
}

var file_yandex_cloud_compute_v1_image_service_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_yandex_cloud_compute_v1_image_service_proto_goTypes = []any{
	(*GetImageRequest)(nil),                    // 0: yandex.cloud.compute.v1.GetImageRequest
	(*GetImageLatestByFamilyRequest)(nil),      // 1: yandex.cloud.compute.v1.GetImageLatestByFamilyRequest
	(*ListImagesRequest)(nil),                  // 2: yandex.cloud.compute.v1.ListImagesRequest
	(*ListImagesResponse)(nil),                 // 3: yandex.cloud.compute.v1.ListImagesResponse
	(*CreateImageRequest)(nil),                 // 4: yandex.cloud.compute.v1.CreateImageRequest
	(*CreateImageMetadata)(nil),                // 5: yandex.cloud.compute.v1.CreateImageMetadata
	(*UpdateImageRequest)(nil),                 // 6: yandex.cloud.compute.v1.UpdateImageRequest
	(*UpdateImageMetadata)(nil),                // 7: yandex.cloud.compute.v1.UpdateImageMetadata
	(*DeleteImageRequest)(nil),                 // 8: yandex.cloud.compute.v1.DeleteImageRequest
	(*DeleteImageMetadata)(nil),                // 9: yandex.cloud.compute.v1.DeleteImageMetadata
	(*ListImageOperationsRequest)(nil),         // 10: yandex.cloud.compute.v1.ListImageOperationsRequest
	(*ListImageOperationsResponse)(nil),        // 11: yandex.cloud.compute.v1.ListImageOperationsResponse
	nil,                                        // 12: yandex.cloud.compute.v1.CreateImageRequest.LabelsEntry
	nil,                                        // 13: yandex.cloud.compute.v1.UpdateImageRequest.LabelsEntry
	(*Image)(nil),                              // 14: yandex.cloud.compute.v1.Image
	(*Os)(nil),                                 // 15: yandex.cloud.compute.v1.Os
	(*HardwareGeneration)(nil),                 // 16: yandex.cloud.compute.v1.HardwareGeneration
	(*fieldmaskpb.FieldMask)(nil),              // 17: google.protobuf.FieldMask
	(*operation.Operation)(nil),                // 18: yandex.cloud.operation.Operation
	(*access.ListAccessBindingsRequest)(nil),   // 19: yandex.cloud.access.ListAccessBindingsRequest
	(*access.SetAccessBindingsRequest)(nil),    // 20: yandex.cloud.access.SetAccessBindingsRequest
	(*access.UpdateAccessBindingsRequest)(nil), // 21: yandex.cloud.access.UpdateAccessBindingsRequest
	(*access.ListAccessBindingsResponse)(nil),  // 22: yandex.cloud.access.ListAccessBindingsResponse
}
var file_yandex_cloud_compute_v1_image_service_proto_depIdxs = []int32{
	14, // 0: yandex.cloud.compute.v1.ListImagesResponse.images:type_name -> yandex.cloud.compute.v1.Image
	12, // 1: yandex.cloud.compute.v1.CreateImageRequest.labels:type_name -> yandex.cloud.compute.v1.CreateImageRequest.LabelsEntry
	15, // 2: yandex.cloud.compute.v1.CreateImageRequest.os:type_name -> yandex.cloud.compute.v1.Os
	16, // 3: yandex.cloud.compute.v1.CreateImageRequest.hardware_generation:type_name -> yandex.cloud.compute.v1.HardwareGeneration
	17, // 4: yandex.cloud.compute.v1.UpdateImageRequest.update_mask:type_name -> google.protobuf.FieldMask
	13, // 5: yandex.cloud.compute.v1.UpdateImageRequest.labels:type_name -> yandex.cloud.compute.v1.UpdateImageRequest.LabelsEntry
	18, // 6: yandex.cloud.compute.v1.ListImageOperationsResponse.operations:type_name -> yandex.cloud.operation.Operation
	0,  // 7: yandex.cloud.compute.v1.ImageService.Get:input_type -> yandex.cloud.compute.v1.GetImageRequest
	1,  // 8: yandex.cloud.compute.v1.ImageService.GetLatestByFamily:input_type -> yandex.cloud.compute.v1.GetImageLatestByFamilyRequest
	2,  // 9: yandex.cloud.compute.v1.ImageService.List:input_type -> yandex.cloud.compute.v1.ListImagesRequest
	4,  // 10: yandex.cloud.compute.v1.ImageService.Create:input_type -> yandex.cloud.compute.v1.CreateImageRequest
	6,  // 11: yandex.cloud.compute.v1.ImageService.Update:input_type -> yandex.cloud.compute.v1.UpdateImageRequest
	8,  // 12: yandex.cloud.compute.v1.ImageService.Delete:input_type -> yandex.cloud.compute.v1.DeleteImageRequest
	10, // 13: yandex.cloud.compute.v1.ImageService.ListOperations:input_type -> yandex.cloud.compute.v1.ListImageOperationsRequest
	19, // 14: yandex.cloud.compute.v1.ImageService.ListAccessBindings:input_type -> yandex.cloud.access.ListAccessBindingsRequest
	20, // 15: yandex.cloud.compute.v1.ImageService.SetAccessBindings:input_type -> yandex.cloud.access.SetAccessBindingsRequest
	21, // 16: yandex.cloud.compute.v1.ImageService.UpdateAccessBindings:input_type -> yandex.cloud.access.UpdateAccessBindingsRequest
	14, // 17: yandex.cloud.compute.v1.ImageService.Get:output_type -> yandex.cloud.compute.v1.Image
	14, // 18: yandex.cloud.compute.v1.ImageService.GetLatestByFamily:output_type -> yandex.cloud.compute.v1.Image
	3,  // 19: yandex.cloud.compute.v1.ImageService.List:output_type -> yandex.cloud.compute.v1.ListImagesResponse
	18, // 20: yandex.cloud.compute.v1.ImageService.Create:output_type -> yandex.cloud.operation.Operation
	18, // 21: yandex.cloud.compute.v1.ImageService.Update:output_type -> yandex.cloud.operation.Operation
	18, // 22: yandex.cloud.compute.v1.ImageService.Delete:output_type -> yandex.cloud.operation.Operation
	11, // 23: yandex.cloud.compute.v1.ImageService.ListOperations:output_type -> yandex.cloud.compute.v1.ListImageOperationsResponse
	22, // 24: yandex.cloud.compute.v1.ImageService.ListAccessBindings:output_type -> yandex.cloud.access.ListAccessBindingsResponse
	18, // 25: yandex.cloud.compute.v1.ImageService.SetAccessBindings:output_type -> yandex.cloud.operation.Operation
	18, // 26: yandex.cloud.compute.v1.ImageService.UpdateAccessBindings:output_type -> yandex.cloud.operation.Operation
	17, // [17:27] is the sub-list for method output_type
	7,  // [7:17] is the sub-list for method input_type
	7,  // [7:7] is the sub-list for extension type_name
	7,  // [7:7] is the sub-list for extension extendee
	0,  // [0:7] is the sub-list for field type_name
}

func init() { file_yandex_cloud_compute_v1_image_service_proto_init() }
func file_yandex_cloud_compute_v1_image_service_proto_init() {
	if File_yandex_cloud_compute_v1_image_service_proto != nil {
		return
	}
	file_yandex_cloud_compute_v1_hardware_generation_proto_init()
	file_yandex_cloud_compute_v1_image_proto_init()
	file_yandex_cloud_compute_v1_image_service_proto_msgTypes[4].OneofWrappers = []any{
		(*CreateImageRequest_ImageId)(nil),
		(*CreateImageRequest_DiskId)(nil),
		(*CreateImageRequest_SnapshotId)(nil),
		(*CreateImageRequest_Uri)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_compute_v1_image_service_proto_rawDesc), len(file_yandex_cloud_compute_v1_image_service_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_yandex_cloud_compute_v1_image_service_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_compute_v1_image_service_proto_depIdxs,
		MessageInfos:      file_yandex_cloud_compute_v1_image_service_proto_msgTypes,
	}.Build()
	File_yandex_cloud_compute_v1_image_service_proto = out.File
	file_yandex_cloud_compute_v1_image_service_proto_goTypes = nil
	file_yandex_cloud_compute_v1_image_service_proto_depIdxs = nil
}
