// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        v3.21.12
// source: yandex/cloud/dataproc/v1/job.proto

package dataproc

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Job_Status int32

const (
	Job_STATUS_UNSPECIFIED Job_Status = 0
	// Job is logged in the database and is waiting for the agent to run it.
	Job_PROVISIONING Job_Status = 1
	// Job is acquired by the agent and is in the queue for execution.
	Job_PENDING Job_Status = 2
	// Job is being run in the cluster.
	Job_RUNNING Job_Status = 3
	// Job failed to finish the run properly.
	Job_ERROR Job_Status = 4
	// Job is finished.
	Job_DONE Job_Status = 5
	// Job is cancelled.
	Job_CANCELLED Job_Status = 6
	// Job is waiting for cancellation.
	Job_CANCELLING Job_Status = 7
)

// Enum value maps for Job_Status.
var (
	Job_Status_name = map[int32]string{
		0: "STATUS_UNSPECIFIED",
		1: "PROVISIONING",
		2: "PENDING",
		3: "RUNNING",
		4: "ERROR",
		5: "DONE",
		6: "CANCELLED",
		7: "CANCELLING",
	}
	Job_Status_value = map[string]int32{
		"STATUS_UNSPECIFIED": 0,
		"PROVISIONING":       1,
		"PENDING":            2,
		"RUNNING":            3,
		"ERROR":              4,
		"DONE":               5,
		"CANCELLED":          6,
		"CANCELLING":         7,
	}
)

func (x Job_Status) Enum() *Job_Status {
	p := new(Job_Status)
	*p = x
	return p
}

func (x Job_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Job_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_dataproc_v1_job_proto_enumTypes[0].Descriptor()
}

func (Job_Status) Type() protoreflect.EnumType {
	return &file_yandex_cloud_dataproc_v1_job_proto_enumTypes[0]
}

func (x Job_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Job_Status.Descriptor instead.
func (Job_Status) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_dataproc_v1_job_proto_rawDescGZIP(), []int{0, 0}
}

// A Yandex Data Processing job. For details about the concept, see [documentation](/docs/data-proc/concepts/jobs).
type Job struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the job. Generated at creation time.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the Yandex Data Processing cluster that the job belongs to.
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Creation timestamp.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The time when the job was started.
	StartedAt *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=started_at,json=startedAt,proto3" json:"started_at,omitempty"`
	// The time when the job was finished.
	FinishedAt *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=finished_at,json=finishedAt,proto3" json:"finished_at,omitempty"`
	// Name of the job, specified in the [JobService.Create] request.
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	// The id of the user who created the job
	CreatedBy string `protobuf:"bytes,12,opt,name=created_by,json=createdBy,proto3" json:"created_by,omitempty"`
	// Job status.
	Status Job_Status `protobuf:"varint,7,opt,name=status,proto3,enum=yandex.cloud.dataproc.v1.Job_Status" json:"status,omitempty"`
	// Specification for the job.
	//
	// Types that are valid to be assigned to JobSpec:
	//
	//	*Job_MapreduceJob
	//	*Job_SparkJob
	//	*Job_PysparkJob
	//	*Job_HiveJob
	JobSpec isJob_JobSpec `protobuf_oneof:"job_spec"`
	// Attributes of YARN application.
	ApplicationInfo *ApplicationInfo `protobuf:"bytes,13,opt,name=application_info,json=applicationInfo,proto3" json:"application_info,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *Job) Reset() {
	*x = Job{}
	mi := &file_yandex_cloud_dataproc_v1_job_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Job) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Job) ProtoMessage() {}

func (x *Job) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_dataproc_v1_job_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Job.ProtoReflect.Descriptor instead.
func (*Job) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_dataproc_v1_job_proto_rawDescGZIP(), []int{0}
}

func (x *Job) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Job) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *Job) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *Job) GetStartedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.StartedAt
	}
	return nil
}

func (x *Job) GetFinishedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.FinishedAt
	}
	return nil
}

func (x *Job) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Job) GetCreatedBy() string {
	if x != nil {
		return x.CreatedBy
	}
	return ""
}

func (x *Job) GetStatus() Job_Status {
	if x != nil {
		return x.Status
	}
	return Job_STATUS_UNSPECIFIED
}

func (x *Job) GetJobSpec() isJob_JobSpec {
	if x != nil {
		return x.JobSpec
	}
	return nil
}

func (x *Job) GetMapreduceJob() *MapreduceJob {
	if x != nil {
		if x, ok := x.JobSpec.(*Job_MapreduceJob); ok {
			return x.MapreduceJob
		}
	}
	return nil
}

func (x *Job) GetSparkJob() *SparkJob {
	if x != nil {
		if x, ok := x.JobSpec.(*Job_SparkJob); ok {
			return x.SparkJob
		}
	}
	return nil
}

func (x *Job) GetPysparkJob() *PysparkJob {
	if x != nil {
		if x, ok := x.JobSpec.(*Job_PysparkJob); ok {
			return x.PysparkJob
		}
	}
	return nil
}

func (x *Job) GetHiveJob() *HiveJob {
	if x != nil {
		if x, ok := x.JobSpec.(*Job_HiveJob); ok {
			return x.HiveJob
		}
	}
	return nil
}

func (x *Job) GetApplicationInfo() *ApplicationInfo {
	if x != nil {
		return x.ApplicationInfo
	}
	return nil
}

type isJob_JobSpec interface {
	isJob_JobSpec()
}

type Job_MapreduceJob struct {
	// Specification for a MapReduce job.
	MapreduceJob *MapreduceJob `protobuf:"bytes,8,opt,name=mapreduce_job,json=mapreduceJob,proto3,oneof"`
}

type Job_SparkJob struct {
	// Specification for a Spark job.
	SparkJob *SparkJob `protobuf:"bytes,9,opt,name=spark_job,json=sparkJob,proto3,oneof"`
}

type Job_PysparkJob struct {
	// Specification for a PySpark job.
	PysparkJob *PysparkJob `protobuf:"bytes,10,opt,name=pyspark_job,json=pysparkJob,proto3,oneof"`
}

type Job_HiveJob struct {
	// Specification for a Hive job.
	HiveJob *HiveJob `protobuf:"bytes,11,opt,name=hive_job,json=hiveJob,proto3,oneof"`
}

func (*Job_MapreduceJob) isJob_JobSpec() {}

func (*Job_SparkJob) isJob_JobSpec() {}

func (*Job_PysparkJob) isJob_JobSpec() {}

func (*Job_HiveJob) isJob_JobSpec() {}

type ApplicationAttempt struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of YARN application attempt
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of YARN Application Master container
	AmContainerId string `protobuf:"bytes,2,opt,name=am_container_id,json=amContainerId,proto3" json:"am_container_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ApplicationAttempt) Reset() {
	*x = ApplicationAttempt{}
	mi := &file_yandex_cloud_dataproc_v1_job_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApplicationAttempt) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationAttempt) ProtoMessage() {}

func (x *ApplicationAttempt) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_dataproc_v1_job_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationAttempt.ProtoReflect.Descriptor instead.
func (*ApplicationAttempt) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_dataproc_v1_job_proto_rawDescGZIP(), []int{1}
}

func (x *ApplicationAttempt) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ApplicationAttempt) GetAmContainerId() string {
	if x != nil {
		return x.AmContainerId
	}
	return ""
}

type ApplicationInfo struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of YARN application
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// YARN application attempts
	ApplicationAttempts []*ApplicationAttempt `protobuf:"bytes,2,rep,name=application_attempts,json=applicationAttempts,proto3" json:"application_attempts,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *ApplicationInfo) Reset() {
	*x = ApplicationInfo{}
	mi := &file_yandex_cloud_dataproc_v1_job_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApplicationInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationInfo) ProtoMessage() {}

func (x *ApplicationInfo) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_dataproc_v1_job_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationInfo.ProtoReflect.Descriptor instead.
func (*ApplicationInfo) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_dataproc_v1_job_proto_rawDescGZIP(), []int{2}
}

func (x *ApplicationInfo) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ApplicationInfo) GetApplicationAttempts() []*ApplicationAttempt {
	if x != nil {
		return x.ApplicationAttempts
	}
	return nil
}

type MapreduceJob struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Optional arguments to pass to the driver.
	Args []string `protobuf:"bytes,1,rep,name=args,proto3" json:"args,omitempty"`
	// JAR file URIs to add to CLASSPATH of the Yandex Data Processing driver and each task.
	JarFileUris []string `protobuf:"bytes,2,rep,name=jar_file_uris,json=jarFileUris,proto3" json:"jar_file_uris,omitempty"`
	// URIs of resource files to be copied to the working directory of Yandex Data Processing drivers
	// and distributed Hadoop tasks.
	FileUris []string `protobuf:"bytes,3,rep,name=file_uris,json=fileUris,proto3" json:"file_uris,omitempty"`
	// URIs of archives to be extracted to the working directory of Yandex Data Processing drivers and tasks.
	ArchiveUris []string `protobuf:"bytes,4,rep,name=archive_uris,json=archiveUris,proto3" json:"archive_uris,omitempty"`
	// Property names and values, used to configure Yandex Data Processing and MapReduce.
	Properties map[string]string `protobuf:"bytes,5,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Types that are valid to be assigned to Driver:
	//
	//	*MapreduceJob_MainJarFileUri
	//	*MapreduceJob_MainClass
	Driver        isMapreduceJob_Driver `protobuf_oneof:"driver"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MapreduceJob) Reset() {
	*x = MapreduceJob{}
	mi := &file_yandex_cloud_dataproc_v1_job_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MapreduceJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MapreduceJob) ProtoMessage() {}

func (x *MapreduceJob) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_dataproc_v1_job_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MapreduceJob.ProtoReflect.Descriptor instead.
func (*MapreduceJob) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_dataproc_v1_job_proto_rawDescGZIP(), []int{3}
}

func (x *MapreduceJob) GetArgs() []string {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *MapreduceJob) GetJarFileUris() []string {
	if x != nil {
		return x.JarFileUris
	}
	return nil
}

func (x *MapreduceJob) GetFileUris() []string {
	if x != nil {
		return x.FileUris
	}
	return nil
}

func (x *MapreduceJob) GetArchiveUris() []string {
	if x != nil {
		return x.ArchiveUris
	}
	return nil
}

func (x *MapreduceJob) GetProperties() map[string]string {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *MapreduceJob) GetDriver() isMapreduceJob_Driver {
	if x != nil {
		return x.Driver
	}
	return nil
}

func (x *MapreduceJob) GetMainJarFileUri() string {
	if x != nil {
		if x, ok := x.Driver.(*MapreduceJob_MainJarFileUri); ok {
			return x.MainJarFileUri
		}
	}
	return ""
}

func (x *MapreduceJob) GetMainClass() string {
	if x != nil {
		if x, ok := x.Driver.(*MapreduceJob_MainClass); ok {
			return x.MainClass
		}
	}
	return ""
}

type isMapreduceJob_Driver interface {
	isMapreduceJob_Driver()
}

type MapreduceJob_MainJarFileUri struct {
	// HCFS URI of the .jar file containing the driver class.
	MainJarFileUri string `protobuf:"bytes,6,opt,name=main_jar_file_uri,json=mainJarFileUri,proto3,oneof"`
}

type MapreduceJob_MainClass struct {
	// The name of the driver class.
	MainClass string `protobuf:"bytes,7,opt,name=main_class,json=mainClass,proto3,oneof"`
}

func (*MapreduceJob_MainJarFileUri) isMapreduceJob_Driver() {}

func (*MapreduceJob_MainClass) isMapreduceJob_Driver() {}

type SparkJob struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Optional arguments to pass to the driver.
	Args []string `protobuf:"bytes,1,rep,name=args,proto3" json:"args,omitempty"`
	// JAR file URIs to add to CLASSPATH of the Yandex Data Processing driver and each task.
	JarFileUris []string `protobuf:"bytes,2,rep,name=jar_file_uris,json=jarFileUris,proto3" json:"jar_file_uris,omitempty"`
	// URIs of resource files to be copied to the working directory of Yandex Data Processing drivers
	// and distributed Hadoop tasks.
	FileUris []string `protobuf:"bytes,3,rep,name=file_uris,json=fileUris,proto3" json:"file_uris,omitempty"`
	// URIs of archives to be extracted to the working directory of Yandex Data Processing drivers and tasks.
	ArchiveUris []string `protobuf:"bytes,4,rep,name=archive_uris,json=archiveUris,proto3" json:"archive_uris,omitempty"`
	// Property names and values, used to configure Yandex Data Processing and Spark.
	Properties map[string]string `protobuf:"bytes,5,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// The HCFS URI of the JAR file containing the `main` class for the job.
	MainJarFileUri string `protobuf:"bytes,6,opt,name=main_jar_file_uri,json=mainJarFileUri,proto3" json:"main_jar_file_uri,omitempty"`
	// The name of the driver class.
	MainClass string `protobuf:"bytes,7,opt,name=main_class,json=mainClass,proto3" json:"main_class,omitempty"`
	// List of maven coordinates of jars to include on the driver and executor classpaths.
	Packages []string `protobuf:"bytes,8,rep,name=packages,proto3" json:"packages,omitempty"`
	// List of additional remote repositories to search for the maven coordinates given with --packages.
	Repositories []string `protobuf:"bytes,9,rep,name=repositories,proto3" json:"repositories,omitempty"`
	// List of groupId:artifactId, to exclude while resolving the dependencies provided in --packages to avoid dependency conflicts.
	ExcludePackages []string `protobuf:"bytes,10,rep,name=exclude_packages,json=excludePackages,proto3" json:"exclude_packages,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *SparkJob) Reset() {
	*x = SparkJob{}
	mi := &file_yandex_cloud_dataproc_v1_job_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SparkJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SparkJob) ProtoMessage() {}

func (x *SparkJob) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_dataproc_v1_job_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SparkJob.ProtoReflect.Descriptor instead.
func (*SparkJob) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_dataproc_v1_job_proto_rawDescGZIP(), []int{4}
}

func (x *SparkJob) GetArgs() []string {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *SparkJob) GetJarFileUris() []string {
	if x != nil {
		return x.JarFileUris
	}
	return nil
}

func (x *SparkJob) GetFileUris() []string {
	if x != nil {
		return x.FileUris
	}
	return nil
}

func (x *SparkJob) GetArchiveUris() []string {
	if x != nil {
		return x.ArchiveUris
	}
	return nil
}

func (x *SparkJob) GetProperties() map[string]string {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *SparkJob) GetMainJarFileUri() string {
	if x != nil {
		return x.MainJarFileUri
	}
	return ""
}

func (x *SparkJob) GetMainClass() string {
	if x != nil {
		return x.MainClass
	}
	return ""
}

func (x *SparkJob) GetPackages() []string {
	if x != nil {
		return x.Packages
	}
	return nil
}

func (x *SparkJob) GetRepositories() []string {
	if x != nil {
		return x.Repositories
	}
	return nil
}

func (x *SparkJob) GetExcludePackages() []string {
	if x != nil {
		return x.ExcludePackages
	}
	return nil
}

type PysparkJob struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Optional arguments to pass to the driver.
	Args []string `protobuf:"bytes,1,rep,name=args,proto3" json:"args,omitempty"`
	// JAR file URIs to add to CLASSPATH of the Yandex Data Processing driver and each task.
	JarFileUris []string `protobuf:"bytes,2,rep,name=jar_file_uris,json=jarFileUris,proto3" json:"jar_file_uris,omitempty"`
	// URIs of resource files to be copied to the working directory of Yandex Data Processing drivers
	// and distributed Hadoop tasks.
	FileUris []string `protobuf:"bytes,3,rep,name=file_uris,json=fileUris,proto3" json:"file_uris,omitempty"`
	// URIs of archives to be extracted to the working directory of Yandex Data Processing drivers and tasks.
	ArchiveUris []string `protobuf:"bytes,4,rep,name=archive_uris,json=archiveUris,proto3" json:"archive_uris,omitempty"`
	// Property names and values, used to configure Yandex Data Processing and PySpark.
	Properties map[string]string `protobuf:"bytes,5,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// URI of the file with the driver code. Must be a .py file.
	MainPythonFileUri string `protobuf:"bytes,6,opt,name=main_python_file_uri,json=mainPythonFileUri,proto3" json:"main_python_file_uri,omitempty"`
	// URIs of Python files to pass to the PySpark framework.
	PythonFileUris []string `protobuf:"bytes,7,rep,name=python_file_uris,json=pythonFileUris,proto3" json:"python_file_uris,omitempty"`
	// List of maven coordinates of jars to include on the driver and executor classpaths.
	Packages []string `protobuf:"bytes,8,rep,name=packages,proto3" json:"packages,omitempty"`
	// List of additional remote repositories to search for the maven coordinates given with --packages.
	Repositories []string `protobuf:"bytes,9,rep,name=repositories,proto3" json:"repositories,omitempty"`
	// List of groupId:artifactId, to exclude while resolving the dependencies provided in --packages to avoid dependency conflicts.
	ExcludePackages []string `protobuf:"bytes,10,rep,name=exclude_packages,json=excludePackages,proto3" json:"exclude_packages,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *PysparkJob) Reset() {
	*x = PysparkJob{}
	mi := &file_yandex_cloud_dataproc_v1_job_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PysparkJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PysparkJob) ProtoMessage() {}

func (x *PysparkJob) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_dataproc_v1_job_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PysparkJob.ProtoReflect.Descriptor instead.
func (*PysparkJob) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_dataproc_v1_job_proto_rawDescGZIP(), []int{5}
}

func (x *PysparkJob) GetArgs() []string {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *PysparkJob) GetJarFileUris() []string {
	if x != nil {
		return x.JarFileUris
	}
	return nil
}

func (x *PysparkJob) GetFileUris() []string {
	if x != nil {
		return x.FileUris
	}
	return nil
}

func (x *PysparkJob) GetArchiveUris() []string {
	if x != nil {
		return x.ArchiveUris
	}
	return nil
}

func (x *PysparkJob) GetProperties() map[string]string {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *PysparkJob) GetMainPythonFileUri() string {
	if x != nil {
		return x.MainPythonFileUri
	}
	return ""
}

func (x *PysparkJob) GetPythonFileUris() []string {
	if x != nil {
		return x.PythonFileUris
	}
	return nil
}

func (x *PysparkJob) GetPackages() []string {
	if x != nil {
		return x.Packages
	}
	return nil
}

func (x *PysparkJob) GetRepositories() []string {
	if x != nil {
		return x.Repositories
	}
	return nil
}

func (x *PysparkJob) GetExcludePackages() []string {
	if x != nil {
		return x.ExcludePackages
	}
	return nil
}

type QueryList struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of Hive queries.
	Queries       []string `protobuf:"bytes,1,rep,name=queries,proto3" json:"queries,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *QueryList) Reset() {
	*x = QueryList{}
	mi := &file_yandex_cloud_dataproc_v1_job_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryList) ProtoMessage() {}

func (x *QueryList) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_dataproc_v1_job_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryList.ProtoReflect.Descriptor instead.
func (*QueryList) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_dataproc_v1_job_proto_rawDescGZIP(), []int{6}
}

func (x *QueryList) GetQueries() []string {
	if x != nil {
		return x.Queries
	}
	return nil
}

type HiveJob struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Property names and values, used to configure Yandex Data Processing and Hive.
	Properties map[string]string `protobuf:"bytes,1,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Flag indicating whether a job should continue to run if a query fails.
	ContinueOnFailure bool `protobuf:"varint,2,opt,name=continue_on_failure,json=continueOnFailure,proto3" json:"continue_on_failure,omitempty"`
	// Query variables and their values.
	ScriptVariables map[string]string `protobuf:"bytes,3,rep,name=script_variables,json=scriptVariables,proto3" json:"script_variables,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// JAR file URIs to add to CLASSPATH of the Hive driver and each task.
	JarFileUris []string `protobuf:"bytes,4,rep,name=jar_file_uris,json=jarFileUris,proto3" json:"jar_file_uris,omitempty"`
	// Types that are valid to be assigned to QueryType:
	//
	//	*HiveJob_QueryFileUri
	//	*HiveJob_QueryList
	QueryType     isHiveJob_QueryType `protobuf_oneof:"query_type"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HiveJob) Reset() {
	*x = HiveJob{}
	mi := &file_yandex_cloud_dataproc_v1_job_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HiveJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HiveJob) ProtoMessage() {}

func (x *HiveJob) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_dataproc_v1_job_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HiveJob.ProtoReflect.Descriptor instead.
func (*HiveJob) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_dataproc_v1_job_proto_rawDescGZIP(), []int{7}
}

func (x *HiveJob) GetProperties() map[string]string {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *HiveJob) GetContinueOnFailure() bool {
	if x != nil {
		return x.ContinueOnFailure
	}
	return false
}

func (x *HiveJob) GetScriptVariables() map[string]string {
	if x != nil {
		return x.ScriptVariables
	}
	return nil
}

func (x *HiveJob) GetJarFileUris() []string {
	if x != nil {
		return x.JarFileUris
	}
	return nil
}

func (x *HiveJob) GetQueryType() isHiveJob_QueryType {
	if x != nil {
		return x.QueryType
	}
	return nil
}

func (x *HiveJob) GetQueryFileUri() string {
	if x != nil {
		if x, ok := x.QueryType.(*HiveJob_QueryFileUri); ok {
			return x.QueryFileUri
		}
	}
	return ""
}

func (x *HiveJob) GetQueryList() *QueryList {
	if x != nil {
		if x, ok := x.QueryType.(*HiveJob_QueryList); ok {
			return x.QueryList
		}
	}
	return nil
}

type isHiveJob_QueryType interface {
	isHiveJob_QueryType()
}

type HiveJob_QueryFileUri struct {
	// URI of the script with all the necessary Hive queries.
	QueryFileUri string `protobuf:"bytes,5,opt,name=query_file_uri,json=queryFileUri,proto3,oneof"`
}

type HiveJob_QueryList struct {
	// List of Hive queries to be used in the job.
	QueryList *QueryList `protobuf:"bytes,6,opt,name=query_list,json=queryList,proto3,oneof"`
}

func (*HiveJob_QueryFileUri) isHiveJob_QueryType() {}

func (*HiveJob_QueryList) isHiveJob_QueryType() {}

var File_yandex_cloud_dataproc_v1_job_proto protoreflect.FileDescriptor

const file_yandex_cloud_dataproc_v1_job_proto_rawDesc = "" +
	"\n" +
	"\"yandex/cloud/dataproc/v1/job.proto\x12\x18yandex.cloud.dataproc.v1\x1a\x1fgoogle/protobuf/timestamp.proto\"\xd8\x06\n" +
	"\x03Job\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x1d\n" +
	"\n" +
	"cluster_id\x18\x02 \x01(\tR\tclusterId\x129\n" +
	"\n" +
	"created_at\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampR\tcreatedAt\x129\n" +
	"\n" +
	"started_at\x18\x04 \x01(\v2\x1a.google.protobuf.TimestampR\tstartedAt\x12;\n" +
	"\vfinished_at\x18\x05 \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"finishedAt\x12\x12\n" +
	"\x04name\x18\x06 \x01(\tR\x04name\x12\x1d\n" +
	"\n" +
	"created_by\x18\f \x01(\tR\tcreatedBy\x12<\n" +
	"\x06status\x18\a \x01(\x0e2$.yandex.cloud.dataproc.v1.Job.StatusR\x06status\x12M\n" +
	"\rmapreduce_job\x18\b \x01(\v2&.yandex.cloud.dataproc.v1.MapreduceJobH\x00R\fmapreduceJob\x12A\n" +
	"\tspark_job\x18\t \x01(\v2\".yandex.cloud.dataproc.v1.SparkJobH\x00R\bsparkJob\x12G\n" +
	"\vpyspark_job\x18\n" +
	" \x01(\v2$.yandex.cloud.dataproc.v1.PysparkJobH\x00R\n" +
	"pysparkJob\x12>\n" +
	"\bhive_job\x18\v \x01(\v2!.yandex.cloud.dataproc.v1.HiveJobH\x00R\ahiveJob\x12T\n" +
	"\x10application_info\x18\r \x01(\v2).yandex.cloud.dataproc.v1.ApplicationInfoR\x0fapplicationInfo\"\x80\x01\n" +
	"\x06Status\x12\x16\n" +
	"\x12STATUS_UNSPECIFIED\x10\x00\x12\x10\n" +
	"\fPROVISIONING\x10\x01\x12\v\n" +
	"\aPENDING\x10\x02\x12\v\n" +
	"\aRUNNING\x10\x03\x12\t\n" +
	"\x05ERROR\x10\x04\x12\b\n" +
	"\x04DONE\x10\x05\x12\r\n" +
	"\tCANCELLED\x10\x06\x12\x0e\n" +
	"\n" +
	"CANCELLING\x10\aB\n" +
	"\n" +
	"\bjob_spec\"L\n" +
	"\x12ApplicationAttempt\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12&\n" +
	"\x0fam_container_id\x18\x02 \x01(\tR\ramContainerId\"\x82\x01\n" +
	"\x0fApplicationInfo\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12_\n" +
	"\x14application_attempts\x18\x02 \x03(\v2,.yandex.cloud.dataproc.v1.ApplicationAttemptR\x13applicationAttempts\"\xf5\x02\n" +
	"\fMapreduceJob\x12\x12\n" +
	"\x04args\x18\x01 \x03(\tR\x04args\x12\"\n" +
	"\rjar_file_uris\x18\x02 \x03(\tR\vjarFileUris\x12\x1b\n" +
	"\tfile_uris\x18\x03 \x03(\tR\bfileUris\x12!\n" +
	"\farchive_uris\x18\x04 \x03(\tR\varchiveUris\x12V\n" +
	"\n" +
	"properties\x18\x05 \x03(\v26.yandex.cloud.dataproc.v1.MapreduceJob.PropertiesEntryR\n" +
	"properties\x12+\n" +
	"\x11main_jar_file_uri\x18\x06 \x01(\tH\x00R\x0emainJarFileUri\x12\x1f\n" +
	"\n" +
	"main_class\x18\a \x01(\tH\x00R\tmainClass\x1a=\n" +
	"\x0fPropertiesEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01B\b\n" +
	"\x06driver\"\xca\x03\n" +
	"\bSparkJob\x12\x12\n" +
	"\x04args\x18\x01 \x03(\tR\x04args\x12\"\n" +
	"\rjar_file_uris\x18\x02 \x03(\tR\vjarFileUris\x12\x1b\n" +
	"\tfile_uris\x18\x03 \x03(\tR\bfileUris\x12!\n" +
	"\farchive_uris\x18\x04 \x03(\tR\varchiveUris\x12R\n" +
	"\n" +
	"properties\x18\x05 \x03(\v22.yandex.cloud.dataproc.v1.SparkJob.PropertiesEntryR\n" +
	"properties\x12)\n" +
	"\x11main_jar_file_uri\x18\x06 \x01(\tR\x0emainJarFileUri\x12\x1d\n" +
	"\n" +
	"main_class\x18\a \x01(\tR\tmainClass\x12\x1a\n" +
	"\bpackages\x18\b \x03(\tR\bpackages\x12\"\n" +
	"\frepositories\x18\t \x03(\tR\frepositories\x12)\n" +
	"\x10exclude_packages\x18\n" +
	" \x03(\tR\x0fexcludePackages\x1a=\n" +
	"\x0fPropertiesEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"\xdf\x03\n" +
	"\n" +
	"PysparkJob\x12\x12\n" +
	"\x04args\x18\x01 \x03(\tR\x04args\x12\"\n" +
	"\rjar_file_uris\x18\x02 \x03(\tR\vjarFileUris\x12\x1b\n" +
	"\tfile_uris\x18\x03 \x03(\tR\bfileUris\x12!\n" +
	"\farchive_uris\x18\x04 \x03(\tR\varchiveUris\x12T\n" +
	"\n" +
	"properties\x18\x05 \x03(\v24.yandex.cloud.dataproc.v1.PysparkJob.PropertiesEntryR\n" +
	"properties\x12/\n" +
	"\x14main_python_file_uri\x18\x06 \x01(\tR\x11mainPythonFileUri\x12(\n" +
	"\x10python_file_uris\x18\a \x03(\tR\x0epythonFileUris\x12\x1a\n" +
	"\bpackages\x18\b \x03(\tR\bpackages\x12\"\n" +
	"\frepositories\x18\t \x03(\tR\frepositories\x12)\n" +
	"\x10exclude_packages\x18\n" +
	" \x03(\tR\x0fexcludePackages\x1a=\n" +
	"\x0fPropertiesEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"%\n" +
	"\tQueryList\x12\x18\n" +
	"\aqueries\x18\x01 \x03(\tR\aqueries\"\x92\x04\n" +
	"\aHiveJob\x12Q\n" +
	"\n" +
	"properties\x18\x01 \x03(\v21.yandex.cloud.dataproc.v1.HiveJob.PropertiesEntryR\n" +
	"properties\x12.\n" +
	"\x13continue_on_failure\x18\x02 \x01(\bR\x11continueOnFailure\x12a\n" +
	"\x10script_variables\x18\x03 \x03(\v26.yandex.cloud.dataproc.v1.HiveJob.ScriptVariablesEntryR\x0fscriptVariables\x12\"\n" +
	"\rjar_file_uris\x18\x04 \x03(\tR\vjarFileUris\x12&\n" +
	"\x0equery_file_uri\x18\x05 \x01(\tH\x00R\fqueryFileUri\x12D\n" +
	"\n" +
	"query_list\x18\x06 \x01(\v2#.yandex.cloud.dataproc.v1.QueryListH\x00R\tqueryList\x1a=\n" +
	"\x0fPropertiesEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\x1aB\n" +
	"\x14ScriptVariablesEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01B\f\n" +
	"\n" +
	"query_typeBj\n" +
	"\x1cyandex.cloud.api.dataproc.v1B\x03PHJZEgithub.com/yandex-cloud/go-genproto/yandex/cloud/dataproc/v1;dataprocb\x06proto3"

var (
	file_yandex_cloud_dataproc_v1_job_proto_rawDescOnce sync.Once
	file_yandex_cloud_dataproc_v1_job_proto_rawDescData []byte
)

func file_yandex_cloud_dataproc_v1_job_proto_rawDescGZIP() []byte {
	file_yandex_cloud_dataproc_v1_job_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_dataproc_v1_job_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_dataproc_v1_job_proto_rawDesc), len(file_yandex_cloud_dataproc_v1_job_proto_rawDesc)))
	})
	return file_yandex_cloud_dataproc_v1_job_proto_rawDescData
}

var file_yandex_cloud_dataproc_v1_job_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_yandex_cloud_dataproc_v1_job_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_yandex_cloud_dataproc_v1_job_proto_goTypes = []any{
	(Job_Status)(0),               // 0: yandex.cloud.dataproc.v1.Job.Status
	(*Job)(nil),                   // 1: yandex.cloud.dataproc.v1.Job
	(*ApplicationAttempt)(nil),    // 2: yandex.cloud.dataproc.v1.ApplicationAttempt
	(*ApplicationInfo)(nil),       // 3: yandex.cloud.dataproc.v1.ApplicationInfo
	(*MapreduceJob)(nil),          // 4: yandex.cloud.dataproc.v1.MapreduceJob
	(*SparkJob)(nil),              // 5: yandex.cloud.dataproc.v1.SparkJob
	(*PysparkJob)(nil),            // 6: yandex.cloud.dataproc.v1.PysparkJob
	(*QueryList)(nil),             // 7: yandex.cloud.dataproc.v1.QueryList
	(*HiveJob)(nil),               // 8: yandex.cloud.dataproc.v1.HiveJob
	nil,                           // 9: yandex.cloud.dataproc.v1.MapreduceJob.PropertiesEntry
	nil,                           // 10: yandex.cloud.dataproc.v1.SparkJob.PropertiesEntry
	nil,                           // 11: yandex.cloud.dataproc.v1.PysparkJob.PropertiesEntry
	nil,                           // 12: yandex.cloud.dataproc.v1.HiveJob.PropertiesEntry
	nil,                           // 13: yandex.cloud.dataproc.v1.HiveJob.ScriptVariablesEntry
	(*timestamppb.Timestamp)(nil), // 14: google.protobuf.Timestamp
}
var file_yandex_cloud_dataproc_v1_job_proto_depIdxs = []int32{
	14, // 0: yandex.cloud.dataproc.v1.Job.created_at:type_name -> google.protobuf.Timestamp
	14, // 1: yandex.cloud.dataproc.v1.Job.started_at:type_name -> google.protobuf.Timestamp
	14, // 2: yandex.cloud.dataproc.v1.Job.finished_at:type_name -> google.protobuf.Timestamp
	0,  // 3: yandex.cloud.dataproc.v1.Job.status:type_name -> yandex.cloud.dataproc.v1.Job.Status
	4,  // 4: yandex.cloud.dataproc.v1.Job.mapreduce_job:type_name -> yandex.cloud.dataproc.v1.MapreduceJob
	5,  // 5: yandex.cloud.dataproc.v1.Job.spark_job:type_name -> yandex.cloud.dataproc.v1.SparkJob
	6,  // 6: yandex.cloud.dataproc.v1.Job.pyspark_job:type_name -> yandex.cloud.dataproc.v1.PysparkJob
	8,  // 7: yandex.cloud.dataproc.v1.Job.hive_job:type_name -> yandex.cloud.dataproc.v1.HiveJob
	3,  // 8: yandex.cloud.dataproc.v1.Job.application_info:type_name -> yandex.cloud.dataproc.v1.ApplicationInfo
	2,  // 9: yandex.cloud.dataproc.v1.ApplicationInfo.application_attempts:type_name -> yandex.cloud.dataproc.v1.ApplicationAttempt
	9,  // 10: yandex.cloud.dataproc.v1.MapreduceJob.properties:type_name -> yandex.cloud.dataproc.v1.MapreduceJob.PropertiesEntry
	10, // 11: yandex.cloud.dataproc.v1.SparkJob.properties:type_name -> yandex.cloud.dataproc.v1.SparkJob.PropertiesEntry
	11, // 12: yandex.cloud.dataproc.v1.PysparkJob.properties:type_name -> yandex.cloud.dataproc.v1.PysparkJob.PropertiesEntry
	12, // 13: yandex.cloud.dataproc.v1.HiveJob.properties:type_name -> yandex.cloud.dataproc.v1.HiveJob.PropertiesEntry
	13, // 14: yandex.cloud.dataproc.v1.HiveJob.script_variables:type_name -> yandex.cloud.dataproc.v1.HiveJob.ScriptVariablesEntry
	7,  // 15: yandex.cloud.dataproc.v1.HiveJob.query_list:type_name -> yandex.cloud.dataproc.v1.QueryList
	16, // [16:16] is the sub-list for method output_type
	16, // [16:16] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_yandex_cloud_dataproc_v1_job_proto_init() }
func file_yandex_cloud_dataproc_v1_job_proto_init() {
	if File_yandex_cloud_dataproc_v1_job_proto != nil {
		return
	}
	file_yandex_cloud_dataproc_v1_job_proto_msgTypes[0].OneofWrappers = []any{
		(*Job_MapreduceJob)(nil),
		(*Job_SparkJob)(nil),
		(*Job_PysparkJob)(nil),
		(*Job_HiveJob)(nil),
	}
	file_yandex_cloud_dataproc_v1_job_proto_msgTypes[3].OneofWrappers = []any{
		(*MapreduceJob_MainJarFileUri)(nil),
		(*MapreduceJob_MainClass)(nil),
	}
	file_yandex_cloud_dataproc_v1_job_proto_msgTypes[7].OneofWrappers = []any{
		(*HiveJob_QueryFileUri)(nil),
		(*HiveJob_QueryList)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_dataproc_v1_job_proto_rawDesc), len(file_yandex_cloud_dataproc_v1_job_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_dataproc_v1_job_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_dataproc_v1_job_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_dataproc_v1_job_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_dataproc_v1_job_proto_msgTypes,
	}.Build()
	File_yandex_cloud_dataproc_v1_job_proto = out.File
	file_yandex_cloud_dataproc_v1_job_proto_goTypes = nil
	file_yandex_cloud_dataproc_v1_job_proto_depIdxs = nil
}
