// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.6.1
// - protoc             v3.21.12
// source: yandex/cloud/lockbox/v1/secret_service.proto

package lockbox

import (
	context "context"
	access "github.com/yandex-cloud/go-genproto/yandex/cloud/access"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	SecretService_Get_FullMethodName                        = "/yandex.cloud.lockbox.v1.SecretService/Get"
	SecretService_List_FullMethodName                       = "/yandex.cloud.lockbox.v1.SecretService/List"
	SecretService_Create_FullMethodName                     = "/yandex.cloud.lockbox.v1.SecretService/Create"
	SecretService_Update_FullMethodName                     = "/yandex.cloud.lockbox.v1.SecretService/Update"
	SecretService_Delete_FullMethodName                     = "/yandex.cloud.lockbox.v1.SecretService/Delete"
	SecretService_Activate_FullMethodName                   = "/yandex.cloud.lockbox.v1.SecretService/Activate"
	SecretService_Deactivate_FullMethodName                 = "/yandex.cloud.lockbox.v1.SecretService/Deactivate"
	SecretService_ListVersions_FullMethodName               = "/yandex.cloud.lockbox.v1.SecretService/ListVersions"
	SecretService_AddVersion_FullMethodName                 = "/yandex.cloud.lockbox.v1.SecretService/AddVersion"
	SecretService_ScheduleVersionDestruction_FullMethodName = "/yandex.cloud.lockbox.v1.SecretService/ScheduleVersionDestruction"
	SecretService_CancelVersionDestruction_FullMethodName   = "/yandex.cloud.lockbox.v1.SecretService/CancelVersionDestruction"
	SecretService_ListOperations_FullMethodName             = "/yandex.cloud.lockbox.v1.SecretService/ListOperations"
	SecretService_ListAccessBindings_FullMethodName         = "/yandex.cloud.lockbox.v1.SecretService/ListAccessBindings"
	SecretService_SetAccessBindings_FullMethodName          = "/yandex.cloud.lockbox.v1.SecretService/SetAccessBindings"
	SecretService_UpdateAccessBindings_FullMethodName       = "/yandex.cloud.lockbox.v1.SecretService/UpdateAccessBindings"
)

// SecretServiceClient is the client API for SecretService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// A set of methods for managing secrets.
type SecretServiceClient interface {
	// Returns the specified secret.
	//
	// To get the list of all available secrets, make a [List] request.
	// Use [PayloadService.Get] to get the payload (confidential data themselves) of the secret.
	Get(ctx context.Context, in *GetSecretRequest, opts ...grpc.CallOption) (*Secret, error)
	// Retrieves the list of secrets in the specified folder.
	List(ctx context.Context, in *ListSecretsRequest, opts ...grpc.CallOption) (*ListSecretsResponse, error)
	// Creates a secret in the specified folder.
	Create(ctx context.Context, in *CreateSecretRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified secret.
	Update(ctx context.Context, in *UpdateSecretRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified secret.
	Delete(ctx context.Context, in *DeleteSecretRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Activates the specified secret.
	Activate(ctx context.Context, in *ActivateSecretRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deactivates the specified secret.
	Deactivate(ctx context.Context, in *DeactivateSecretRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Retrieves the list of versions of the specified secret.
	ListVersions(ctx context.Context, in *ListVersionsRequest, opts ...grpc.CallOption) (*ListVersionsResponse, error)
	// Adds new version based on a previous one.
	AddVersion(ctx context.Context, in *AddVersionRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Schedules the specified version for destruction.
	//
	// Scheduled destruction can be cancelled with the [SecretService.CancelVersionDestruction] method.
	ScheduleVersionDestruction(ctx context.Context, in *ScheduleVersionDestructionRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Cancels previously scheduled version destruction, if the version hasn't been destroyed yet.
	CancelVersionDestruction(ctx context.Context, in *CancelVersionDestructionRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Lists operations for the specified secret.
	ListOperations(ctx context.Context, in *ListSecretOperationsRequest, opts ...grpc.CallOption) (*ListSecretOperationsResponse, error)
	// Lists existing access bindings for the specified secret.
	ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error)
	// Sets access bindings for the secret.
	SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates access bindings for the secret.
	UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
}

type secretServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSecretServiceClient(cc grpc.ClientConnInterface) SecretServiceClient {
	return &secretServiceClient{cc}
}

func (c *secretServiceClient) Get(ctx context.Context, in *GetSecretRequest, opts ...grpc.CallOption) (*Secret, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Secret)
	err := c.cc.Invoke(ctx, SecretService_Get_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretServiceClient) List(ctx context.Context, in *ListSecretsRequest, opts ...grpc.CallOption) (*ListSecretsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListSecretsResponse)
	err := c.cc.Invoke(ctx, SecretService_List_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretServiceClient) Create(ctx context.Context, in *CreateSecretRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, SecretService_Create_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretServiceClient) Update(ctx context.Context, in *UpdateSecretRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, SecretService_Update_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretServiceClient) Delete(ctx context.Context, in *DeleteSecretRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, SecretService_Delete_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretServiceClient) Activate(ctx context.Context, in *ActivateSecretRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, SecretService_Activate_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretServiceClient) Deactivate(ctx context.Context, in *DeactivateSecretRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, SecretService_Deactivate_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretServiceClient) ListVersions(ctx context.Context, in *ListVersionsRequest, opts ...grpc.CallOption) (*ListVersionsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListVersionsResponse)
	err := c.cc.Invoke(ctx, SecretService_ListVersions_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretServiceClient) AddVersion(ctx context.Context, in *AddVersionRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, SecretService_AddVersion_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretServiceClient) ScheduleVersionDestruction(ctx context.Context, in *ScheduleVersionDestructionRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, SecretService_ScheduleVersionDestruction_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretServiceClient) CancelVersionDestruction(ctx context.Context, in *CancelVersionDestructionRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, SecretService_CancelVersionDestruction_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretServiceClient) ListOperations(ctx context.Context, in *ListSecretOperationsRequest, opts ...grpc.CallOption) (*ListSecretOperationsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListSecretOperationsResponse)
	err := c.cc.Invoke(ctx, SecretService_ListOperations_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretServiceClient) ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(access.ListAccessBindingsResponse)
	err := c.cc.Invoke(ctx, SecretService_ListAccessBindings_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretServiceClient) SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, SecretService_SetAccessBindings_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *secretServiceClient) UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, SecretService_UpdateAccessBindings_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SecretServiceServer is the server API for SecretService service.
// All implementations should embed UnimplementedSecretServiceServer
// for forward compatibility.
//
// A set of methods for managing secrets.
type SecretServiceServer interface {
	// Returns the specified secret.
	//
	// To get the list of all available secrets, make a [List] request.
	// Use [PayloadService.Get] to get the payload (confidential data themselves) of the secret.
	Get(context.Context, *GetSecretRequest) (*Secret, error)
	// Retrieves the list of secrets in the specified folder.
	List(context.Context, *ListSecretsRequest) (*ListSecretsResponse, error)
	// Creates a secret in the specified folder.
	Create(context.Context, *CreateSecretRequest) (*operation.Operation, error)
	// Updates the specified secret.
	Update(context.Context, *UpdateSecretRequest) (*operation.Operation, error)
	// Deletes the specified secret.
	Delete(context.Context, *DeleteSecretRequest) (*operation.Operation, error)
	// Activates the specified secret.
	Activate(context.Context, *ActivateSecretRequest) (*operation.Operation, error)
	// Deactivates the specified secret.
	Deactivate(context.Context, *DeactivateSecretRequest) (*operation.Operation, error)
	// Retrieves the list of versions of the specified secret.
	ListVersions(context.Context, *ListVersionsRequest) (*ListVersionsResponse, error)
	// Adds new version based on a previous one.
	AddVersion(context.Context, *AddVersionRequest) (*operation.Operation, error)
	// Schedules the specified version for destruction.
	//
	// Scheduled destruction can be cancelled with the [SecretService.CancelVersionDestruction] method.
	ScheduleVersionDestruction(context.Context, *ScheduleVersionDestructionRequest) (*operation.Operation, error)
	// Cancels previously scheduled version destruction, if the version hasn't been destroyed yet.
	CancelVersionDestruction(context.Context, *CancelVersionDestructionRequest) (*operation.Operation, error)
	// Lists operations for the specified secret.
	ListOperations(context.Context, *ListSecretOperationsRequest) (*ListSecretOperationsResponse, error)
	// Lists existing access bindings for the specified secret.
	ListAccessBindings(context.Context, *access.ListAccessBindingsRequest) (*access.ListAccessBindingsResponse, error)
	// Sets access bindings for the secret.
	SetAccessBindings(context.Context, *access.SetAccessBindingsRequest) (*operation.Operation, error)
	// Updates access bindings for the secret.
	UpdateAccessBindings(context.Context, *access.UpdateAccessBindingsRequest) (*operation.Operation, error)
}

// UnimplementedSecretServiceServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedSecretServiceServer struct{}

func (UnimplementedSecretServiceServer) Get(context.Context, *GetSecretRequest) (*Secret, error) {
	return nil, status.Error(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedSecretServiceServer) List(context.Context, *ListSecretsRequest) (*ListSecretsResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedSecretServiceServer) Create(context.Context, *CreateSecretRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method Create not implemented")
}
func (UnimplementedSecretServiceServer) Update(context.Context, *UpdateSecretRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method Update not implemented")
}
func (UnimplementedSecretServiceServer) Delete(context.Context, *DeleteSecretRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedSecretServiceServer) Activate(context.Context, *ActivateSecretRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method Activate not implemented")
}
func (UnimplementedSecretServiceServer) Deactivate(context.Context, *DeactivateSecretRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method Deactivate not implemented")
}
func (UnimplementedSecretServiceServer) ListVersions(context.Context, *ListVersionsRequest) (*ListVersionsResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method ListVersions not implemented")
}
func (UnimplementedSecretServiceServer) AddVersion(context.Context, *AddVersionRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method AddVersion not implemented")
}
func (UnimplementedSecretServiceServer) ScheduleVersionDestruction(context.Context, *ScheduleVersionDestructionRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method ScheduleVersionDestruction not implemented")
}
func (UnimplementedSecretServiceServer) CancelVersionDestruction(context.Context, *CancelVersionDestructionRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method CancelVersionDestruction not implemented")
}
func (UnimplementedSecretServiceServer) ListOperations(context.Context, *ListSecretOperationsRequest) (*ListSecretOperationsResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method ListOperations not implemented")
}
func (UnimplementedSecretServiceServer) ListAccessBindings(context.Context, *access.ListAccessBindingsRequest) (*access.ListAccessBindingsResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method ListAccessBindings not implemented")
}
func (UnimplementedSecretServiceServer) SetAccessBindings(context.Context, *access.SetAccessBindingsRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method SetAccessBindings not implemented")
}
func (UnimplementedSecretServiceServer) UpdateAccessBindings(context.Context, *access.UpdateAccessBindingsRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method UpdateAccessBindings not implemented")
}
func (UnimplementedSecretServiceServer) testEmbeddedByValue() {}

// UnsafeSecretServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SecretServiceServer will
// result in compilation errors.
type UnsafeSecretServiceServer interface {
	mustEmbedUnimplementedSecretServiceServer()
}

func RegisterSecretServiceServer(s grpc.ServiceRegistrar, srv SecretServiceServer) {
	// If the following call panics, it indicates UnimplementedSecretServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&SecretService_ServiceDesc, srv)
}

func _SecretService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecretService_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretServiceServer).Get(ctx, req.(*GetSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSecretsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecretService_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretServiceServer).List(ctx, req.(*ListSecretsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecretService_Create_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretServiceServer).Create(ctx, req.(*CreateSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecretService_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretServiceServer).Update(ctx, req.(*UpdateSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecretService_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretServiceServer).Delete(ctx, req.(*DeleteSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretService_Activate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ActivateSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretServiceServer).Activate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecretService_Activate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretServiceServer).Activate(ctx, req.(*ActivateSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretService_Deactivate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeactivateSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretServiceServer).Deactivate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecretService_Deactivate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretServiceServer).Deactivate(ctx, req.(*DeactivateSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretService_ListVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretServiceServer).ListVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecretService_ListVersions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretServiceServer).ListVersions(ctx, req.(*ListVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretService_AddVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretServiceServer).AddVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecretService_AddVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretServiceServer).AddVersion(ctx, req.(*AddVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretService_ScheduleVersionDestruction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ScheduleVersionDestructionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretServiceServer).ScheduleVersionDestruction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecretService_ScheduleVersionDestruction_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretServiceServer).ScheduleVersionDestruction(ctx, req.(*ScheduleVersionDestructionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretService_CancelVersionDestruction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelVersionDestructionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretServiceServer).CancelVersionDestruction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecretService_CancelVersionDestruction_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretServiceServer).CancelVersionDestruction(ctx, req.(*CancelVersionDestructionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSecretOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecretService_ListOperations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretServiceServer).ListOperations(ctx, req.(*ListSecretOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretService_ListAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.ListAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretServiceServer).ListAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecretService_ListAccessBindings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretServiceServer).ListAccessBindings(ctx, req.(*access.ListAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretService_SetAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.SetAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretServiceServer).SetAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecretService_SetAccessBindings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretServiceServer).SetAccessBindings(ctx, req.(*access.SetAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecretService_UpdateAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.UpdateAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecretServiceServer).UpdateAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecretService_UpdateAccessBindings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecretServiceServer).UpdateAccessBindings(ctx, req.(*access.UpdateAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// SecretService_ServiceDesc is the grpc.ServiceDesc for SecretService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var SecretService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.lockbox.v1.SecretService",
	HandlerType: (*SecretServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _SecretService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _SecretService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _SecretService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _SecretService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _SecretService_Delete_Handler,
		},
		{
			MethodName: "Activate",
			Handler:    _SecretService_Activate_Handler,
		},
		{
			MethodName: "Deactivate",
			Handler:    _SecretService_Deactivate_Handler,
		},
		{
			MethodName: "ListVersions",
			Handler:    _SecretService_ListVersions_Handler,
		},
		{
			MethodName: "AddVersion",
			Handler:    _SecretService_AddVersion_Handler,
		},
		{
			MethodName: "ScheduleVersionDestruction",
			Handler:    _SecretService_ScheduleVersionDestruction_Handler,
		},
		{
			MethodName: "CancelVersionDestruction",
			Handler:    _SecretService_CancelVersionDestruction_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _SecretService_ListOperations_Handler,
		},
		{
			MethodName: "ListAccessBindings",
			Handler:    _SecretService_ListAccessBindings_Handler,
		},
		{
			MethodName: "SetAccessBindings",
			Handler:    _SecretService_SetAccessBindings_Handler,
		},
		{
			MethodName: "UpdateAccessBindings",
			Handler:    _SecretService_UpdateAccessBindings_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/lockbox/v1/secret_service.proto",
}
