// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        v3.21.12
// source: yandex/cloud/mdb/mongodb/v1/cluster.proto

package mongodb

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	config "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/mongodb/v1/config"
	timeofday "google.golang.org/genproto/googleapis/type/timeofday"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Cluster_Environment int32

const (
	Cluster_ENVIRONMENT_UNSPECIFIED Cluster_Environment = 0
	// Stable environment with a conservative update policy: only hotfixes
	// are applied during regular maintenance.
	Cluster_PRODUCTION Cluster_Environment = 1
	// Environment with more aggressive update policy: new versions
	// are rolled out irrespective of backward compatibility.
	Cluster_PRESTABLE Cluster_Environment = 2
)

// Enum value maps for Cluster_Environment.
var (
	Cluster_Environment_name = map[int32]string{
		0: "ENVIRONMENT_UNSPECIFIED",
		1: "PRODUCTION",
		2: "PRESTABLE",
	}
	Cluster_Environment_value = map[string]int32{
		"ENVIRONMENT_UNSPECIFIED": 0,
		"PRODUCTION":              1,
		"PRESTABLE":               2,
	}
)

func (x Cluster_Environment) Enum() *Cluster_Environment {
	p := new(Cluster_Environment)
	*p = x
	return p
}

func (x Cluster_Environment) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Environment) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[0].Descriptor()
}

func (Cluster_Environment) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[0]
}

func (x Cluster_Environment) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Environment.Descriptor instead.
func (Cluster_Environment) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{0, 0}
}

type Cluster_Health int32

const (
	// State of the cluster is unknown ([Host.health] for every host in the cluster is UNKNOWN).
	Cluster_HEALTH_UNKNOWN Cluster_Health = 0
	// Cluster is alive and well ([Host.health] for every host in the cluster is ALIVE).
	Cluster_ALIVE Cluster_Health = 1
	// Cluster is inoperable ([Host.health] for every host in the cluster is DEAD).
	Cluster_DEAD Cluster_Health = 2
	// Cluster is working below capacity ([Host.health] for at least one host in the cluster is not ALIVE).
	Cluster_DEGRADED Cluster_Health = 3
)

// Enum value maps for Cluster_Health.
var (
	Cluster_Health_name = map[int32]string{
		0: "HEALTH_UNKNOWN",
		1: "ALIVE",
		2: "DEAD",
		3: "DEGRADED",
	}
	Cluster_Health_value = map[string]int32{
		"HEALTH_UNKNOWN": 0,
		"ALIVE":          1,
		"DEAD":           2,
		"DEGRADED":       3,
	}
)

func (x Cluster_Health) Enum() *Cluster_Health {
	p := new(Cluster_Health)
	*p = x
	return p
}

func (x Cluster_Health) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Health) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[1].Descriptor()
}

func (Cluster_Health) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[1]
}

func (x Cluster_Health) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Health.Descriptor instead.
func (Cluster_Health) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{0, 1}
}

type Cluster_Status int32

const (
	// Cluster state is unknown.
	Cluster_STATUS_UNKNOWN Cluster_Status = 0
	// Cluster is being created.
	Cluster_CREATING Cluster_Status = 1
	// Cluster is running normally.
	Cluster_RUNNING Cluster_Status = 2
	// Cluster encountered a problem and cannot operate.
	Cluster_ERROR Cluster_Status = 3
	// Cluster is being updated.
	Cluster_UPDATING Cluster_Status = 4
	// Cluster is stopping.
	Cluster_STOPPING Cluster_Status = 5
	// Cluster stopped.
	Cluster_STOPPED Cluster_Status = 6
	// Cluster is starting.
	Cluster_STARTING Cluster_Status = 7
)

// Enum value maps for Cluster_Status.
var (
	Cluster_Status_name = map[int32]string{
		0: "STATUS_UNKNOWN",
		1: "CREATING",
		2: "RUNNING",
		3: "ERROR",
		4: "UPDATING",
		5: "STOPPING",
		6: "STOPPED",
		7: "STARTING",
	}
	Cluster_Status_value = map[string]int32{
		"STATUS_UNKNOWN": 0,
		"CREATING":       1,
		"RUNNING":        2,
		"ERROR":          3,
		"UPDATING":       4,
		"STOPPING":       5,
		"STOPPED":        6,
		"STARTING":       7,
	}
)

func (x Cluster_Status) Enum() *Cluster_Status {
	p := new(Cluster_Status)
	*p = x
	return p
}

func (x Cluster_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[2].Descriptor()
}

func (Cluster_Status) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[2]
}

func (x Cluster_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Status.Descriptor instead.
func (Cluster_Status) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{0, 2}
}

type Host_Type int32

const (
	// Type of the host is unspecified. Default value.
	Host_TYPE_UNSPECIFIED Host_Type = 0
	// A mongod host.
	Host_MONGOD Host_Type = 1
	// A mongos host.
	Host_MONGOS Host_Type = 2
	// A mongocfg host.
	Host_MONGOCFG Host_Type = 3
	// A mongoinfra (mongos+mongocfg) host.
	Host_MONGOINFRA Host_Type = 4
)

// Enum value maps for Host_Type.
var (
	Host_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "MONGOD",
		2: "MONGOS",
		3: "MONGOCFG",
		4: "MONGOINFRA",
	}
	Host_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"MONGOD":           1,
		"MONGOS":           2,
		"MONGOCFG":         3,
		"MONGOINFRA":       4,
	}
)

func (x Host_Type) Enum() *Host_Type {
	p := new(Host_Type)
	*p = x
	return p
}

func (x Host_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Host_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[3].Descriptor()
}

func (Host_Type) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[3]
}

func (x Host_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Host_Type.Descriptor instead.
func (Host_Type) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{14, 0}
}

type Host_Role int32

const (
	// Role of the host in the cluster is unknown. Default value.
	Host_ROLE_UNKNOWN Host_Role = 0
	// Host is the primary MongoDB server in the cluster.
	Host_PRIMARY Host_Role = 1
	// Host is a secondary MongoDB server in the cluster.
	Host_SECONDARY Host_Role = 2
)

// Enum value maps for Host_Role.
var (
	Host_Role_name = map[int32]string{
		0: "ROLE_UNKNOWN",
		1: "PRIMARY",
		2: "SECONDARY",
	}
	Host_Role_value = map[string]int32{
		"ROLE_UNKNOWN": 0,
		"PRIMARY":      1,
		"SECONDARY":    2,
	}
)

func (x Host_Role) Enum() *Host_Role {
	p := new(Host_Role)
	*p = x
	return p
}

func (x Host_Role) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Host_Role) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[4].Descriptor()
}

func (Host_Role) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[4]
}

func (x Host_Role) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Host_Role.Descriptor instead.
func (Host_Role) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{14, 1}
}

type Host_Health int32

const (
	// Health of the host is unknown. Default value.
	Host_HEALTH_UNKNOWN Host_Health = 0
	// The host is performing all its functions normally.
	Host_ALIVE Host_Health = 1
	// The host is inoperable, and cannot perform any of its essential functions.
	Host_DEAD Host_Health = 2
	// The host is degraded, and can perform only some of its essential functions.
	Host_DEGRADED Host_Health = 3
)

// Enum value maps for Host_Health.
var (
	Host_Health_name = map[int32]string{
		0: "HEALTH_UNKNOWN",
		1: "ALIVE",
		2: "DEAD",
		3: "DEGRADED",
	}
	Host_Health_value = map[string]int32{
		"HEALTH_UNKNOWN": 0,
		"ALIVE":          1,
		"DEAD":           2,
		"DEGRADED":       3,
	}
)

func (x Host_Health) Enum() *Host_Health {
	p := new(Host_Health)
	*p = x
	return p
}

func (x Host_Health) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Host_Health) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[5].Descriptor()
}

func (Host_Health) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[5]
}

func (x Host_Health) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Host_Health.Descriptor instead.
func (Host_Health) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{14, 2}
}

type Service_Type int32

const (
	// Service type of the host is unspecified. Default value.
	Service_TYPE_UNSPECIFIED Service_Type = 0
	// The host is running a mongod daemon.
	Service_MONGOD Service_Type = 1
	// The host is running a mongos daemon.
	Service_MONGOS Service_Type = 2
	// The host is running a MongoDB config server.
	Service_MONGOCFG Service_Type = 3
)

// Enum value maps for Service_Type.
var (
	Service_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "MONGOD",
		2: "MONGOS",
		3: "MONGOCFG",
	}
	Service_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"MONGOD":           1,
		"MONGOS":           2,
		"MONGOCFG":         3,
	}
)

func (x Service_Type) Enum() *Service_Type {
	p := new(Service_Type)
	*p = x
	return p
}

func (x Service_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Service_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[6].Descriptor()
}

func (Service_Type) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[6]
}

func (x Service_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Service_Type.Descriptor instead.
func (Service_Type) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{15, 0}
}

type Service_Health int32

const (
	// Health of the server is unknown.
	Service_HEALTH_UNKNOWN Service_Health = 0
	// The server is working normally.
	Service_ALIVE Service_Health = 1
	// The server is dead or unresponsive.
	Service_DEAD Service_Health = 2
)

// Enum value maps for Service_Health.
var (
	Service_Health_name = map[int32]string{
		0: "HEALTH_UNKNOWN",
		1: "ALIVE",
		2: "DEAD",
	}
	Service_Health_value = map[string]int32{
		"HEALTH_UNKNOWN": 0,
		"ALIVE":          1,
		"DEAD":           2,
	}
)

func (x Service_Health) Enum() *Service_Health {
	p := new(Service_Health)
	*p = x
	return p
}

func (x Service_Health) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Service_Health) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[7].Descriptor()
}

func (Service_Health) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[7]
}

func (x Service_Health) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Service_Health.Descriptor instead.
func (Service_Health) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{15, 1}
}

// A managed MongoDB cluster. For more information, see the [documentation](/docs/managed-mongodb/concepts).
type Cluster struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the MongoDB cluster.
	// This ID is assigned by MDB at creation time.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the MongoDB cluster belongs to.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the MongoDB cluster.
	// The name is unique within the folder. 1-63 characters long.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the MongoDB cluster. 0-256 characters long.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the MongoDB cluster as “ key:value “ pairs. Maximum 64 per resource.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Deployment environment of the MongoDB cluster.
	Environment Cluster_Environment `protobuf:"varint,7,opt,name=environment,proto3,enum=yandex.cloud.mdb.mongodb.v1.Cluster_Environment" json:"environment,omitempty"`
	// Description of monitoring systems relevant to the MongoDB cluster.
	Monitoring []*Monitoring `protobuf:"bytes,8,rep,name=monitoring,proto3" json:"monitoring,omitempty"`
	// Configuration of the MongoDB cluster.
	Config *ClusterConfig `protobuf:"bytes,9,opt,name=config,proto3" json:"config,omitempty"`
	// ID of the network that the cluster belongs to.
	NetworkId string `protobuf:"bytes,10,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// Aggregated cluster health.
	Health Cluster_Health `protobuf:"varint,11,opt,name=health,proto3,enum=yandex.cloud.mdb.mongodb.v1.Cluster_Health" json:"health,omitempty"`
	// Current state of the cluster.
	Status Cluster_Status `protobuf:"varint,12,opt,name=status,proto3,enum=yandex.cloud.mdb.mongodb.v1.Cluster_Status" json:"status,omitempty"`
	// Indicates current sharding status of the cluster.
	Sharded bool `protobuf:"varint,13,opt,name=sharded,proto3" json:"sharded,omitempty"`
	// Maintenance window for the cluster.
	MaintenanceWindow *MaintenanceWindow `protobuf:"bytes,14,opt,name=maintenance_window,json=maintenanceWindow,proto3" json:"maintenance_window,omitempty"`
	// Planned maintenance operation to be started for the cluster within the nearest [maintenance_window].
	PlannedOperation *MaintenanceOperation `protobuf:"bytes,15,opt,name=planned_operation,json=plannedOperation,proto3" json:"planned_operation,omitempty"`
	// User security groups
	SecurityGroupIds []string `protobuf:"bytes,16,rep,name=security_group_ids,json=securityGroupIds,proto3" json:"security_group_ids,omitempty"`
	// Deletion Protection inhibits deletion of the cluster
	DeletionProtection bool `protobuf:"varint,17,opt,name=deletion_protection,json=deletionProtection,proto3" json:"deletion_protection,omitempty"`
	// ID of the key to encrypt cluster disks.
	DiskEncryptionKeyId *wrapperspb.StringValue `protobuf:"bytes,18,opt,name=disk_encryption_key_id,json=diskEncryptionKeyId,proto3" json:"disk_encryption_key_id,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Cluster) Reset() {
	*x = Cluster{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Cluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster) ProtoMessage() {}

func (x *Cluster) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster.ProtoReflect.Descriptor instead.
func (*Cluster) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{0}
}

func (x *Cluster) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Cluster) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *Cluster) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *Cluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Cluster) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Cluster) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Cluster) GetEnvironment() Cluster_Environment {
	if x != nil {
		return x.Environment
	}
	return Cluster_ENVIRONMENT_UNSPECIFIED
}

func (x *Cluster) GetMonitoring() []*Monitoring {
	if x != nil {
		return x.Monitoring
	}
	return nil
}

func (x *Cluster) GetConfig() *ClusterConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Cluster) GetNetworkId() string {
	if x != nil {
		return x.NetworkId
	}
	return ""
}

func (x *Cluster) GetHealth() Cluster_Health {
	if x != nil {
		return x.Health
	}
	return Cluster_HEALTH_UNKNOWN
}

func (x *Cluster) GetStatus() Cluster_Status {
	if x != nil {
		return x.Status
	}
	return Cluster_STATUS_UNKNOWN
}

func (x *Cluster) GetSharded() bool {
	if x != nil {
		return x.Sharded
	}
	return false
}

func (x *Cluster) GetMaintenanceWindow() *MaintenanceWindow {
	if x != nil {
		return x.MaintenanceWindow
	}
	return nil
}

func (x *Cluster) GetPlannedOperation() *MaintenanceOperation {
	if x != nil {
		return x.PlannedOperation
	}
	return nil
}

func (x *Cluster) GetSecurityGroupIds() []string {
	if x != nil {
		return x.SecurityGroupIds
	}
	return nil
}

func (x *Cluster) GetDeletionProtection() bool {
	if x != nil {
		return x.DeletionProtection
	}
	return false
}

func (x *Cluster) GetDiskEncryptionKeyId() *wrapperspb.StringValue {
	if x != nil {
		return x.DiskEncryptionKeyId
	}
	return nil
}

// Monitoring system.
type Monitoring struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the monitoring system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the monitoring system.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Link to the monitoring system charts for the MongoDB cluster.
	Link          string `protobuf:"bytes,3,opt,name=link,proto3" json:"link,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Monitoring) Reset() {
	*x = Monitoring{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Monitoring) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Monitoring) ProtoMessage() {}

func (x *Monitoring) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Monitoring.ProtoReflect.Descriptor instead.
func (*Monitoring) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{1}
}

func (x *Monitoring) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Monitoring) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Monitoring) GetLink() string {
	if x != nil {
		return x.Link
	}
	return ""
}

type ClusterConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Version of MongoDB server software. Possible values: `3.6`, `4.0`, `4.2`, `4.4`, `4.4-enterprise`, `5.0`, `5.0-enterprise`, `6.0`, `6.0-enterprise`, `7.0`, `7.0-enterprise`.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// MongoDB feature compatibility version. See usage details in [MongoDB documentation](https://docs.mongodb.com/manual/reference/command/setFeatureCompatibilityVersion/).
	//
	// Possible values:
	// * `3.6` - persist data compatibility for version 3.6. After setting this option the data will not be compatible with 3.4 or lower.
	// * `4.0` - persist data compatibility for version 4.0. After setting this option the data will not be compatible with 3.6 or lower.
	// * `4.2` - persist data compatibility for version 4.2. After setting this option the data will not be compatible with 4.0 or lower.
	// * `4.4` - persist data compatibility for version 4.4. After setting this option the data will not be compatible with 4.2 or lower.
	// * `5.0` - persist data compatibility for version 5.0. After setting this option the data will not be compatible with 5.0 or lower.
	// * `6.0` - persist data compatibility for version 6.0. After setting this option the data will not be compatible with 6.0 or lower.
	FeatureCompatibilityVersion string `protobuf:"bytes,5,opt,name=feature_compatibility_version,json=featureCompatibilityVersion,proto3" json:"feature_compatibility_version,omitempty"`
	// Configuration for MongoDB servers in the cluster.
	//
	// Types that are valid to be assigned to Mongodb:
	//
	//	*ClusterConfig_Mongodb_3_6
	//	*ClusterConfig_Mongodb_4_0
	//	*ClusterConfig_Mongodb_4_2
	//	*ClusterConfig_Mongodb_4_4
	//	*ClusterConfig_Mongodb_5_0
	//	*ClusterConfig_Mongodb_6_0
	//	*ClusterConfig_Mongodb_4_4Enterprise
	//	*ClusterConfig_Mongodb_5_0Enterprise
	//	*ClusterConfig_Mongodb_6_0Enterprise
	Mongodb isClusterConfig_Mongodb `protobuf_oneof:"mongodb"`
	// Time to start the daily backup, in the UTC timezone.
	BackupWindowStart *timeofday.TimeOfDay `protobuf:"bytes,3,opt,name=backup_window_start,json=backupWindowStart,proto3" json:"backup_window_start,omitempty"`
	// Retain period of automatically created backup in days
	BackupRetainPeriodDays *wrapperspb.Int64Value `protobuf:"bytes,9,opt,name=backup_retain_period_days,json=backupRetainPeriodDays,proto3" json:"backup_retain_period_days,omitempty"`
	// Performance Diagnostic
	PerformanceDiagnostics *PerformanceDiagnosticsConfig `protobuf:"bytes,13,opt,name=performance_diagnostics,json=performanceDiagnostics,proto3" json:"performance_diagnostics,omitempty"`
	// Access policy to DB
	Access *Access `protobuf:"bytes,6,opt,name=access,proto3" json:"access,omitempty"`
	// Configuration and resource allocation for a MongoDB Enterprise cluster.
	MongodbConfig *Mongodb `protobuf:"bytes,19,opt,name=mongodb_config,json=mongodbConfig,proto3" json:"mongodb_config,omitempty"`
	// Full version
	FullVersion   string `protobuf:"bytes,20,opt,name=full_version,json=fullVersion,proto3" json:"full_version,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ClusterConfig) Reset() {
	*x = ClusterConfig{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClusterConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterConfig) ProtoMessage() {}

func (x *ClusterConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterConfig.ProtoReflect.Descriptor instead.
func (*ClusterConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{2}
}

func (x *ClusterConfig) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *ClusterConfig) GetFeatureCompatibilityVersion() string {
	if x != nil {
		return x.FeatureCompatibilityVersion
	}
	return ""
}

func (x *ClusterConfig) GetMongodb() isClusterConfig_Mongodb {
	if x != nil {
		return x.Mongodb
	}
	return nil
}

func (x *ClusterConfig) GetMongodb_3_6() *Mongodb3_6 {
	if x != nil {
		if x, ok := x.Mongodb.(*ClusterConfig_Mongodb_3_6); ok {
			return x.Mongodb_3_6
		}
	}
	return nil
}

func (x *ClusterConfig) GetMongodb_4_0() *Mongodb4_0 {
	if x != nil {
		if x, ok := x.Mongodb.(*ClusterConfig_Mongodb_4_0); ok {
			return x.Mongodb_4_0
		}
	}
	return nil
}

func (x *ClusterConfig) GetMongodb_4_2() *Mongodb4_2 {
	if x != nil {
		if x, ok := x.Mongodb.(*ClusterConfig_Mongodb_4_2); ok {
			return x.Mongodb_4_2
		}
	}
	return nil
}

func (x *ClusterConfig) GetMongodb_4_4() *Mongodb4_4 {
	if x != nil {
		if x, ok := x.Mongodb.(*ClusterConfig_Mongodb_4_4); ok {
			return x.Mongodb_4_4
		}
	}
	return nil
}

func (x *ClusterConfig) GetMongodb_5_0() *Mongodb5_0 {
	if x != nil {
		if x, ok := x.Mongodb.(*ClusterConfig_Mongodb_5_0); ok {
			return x.Mongodb_5_0
		}
	}
	return nil
}

func (x *ClusterConfig) GetMongodb_6_0() *Mongodb6_0 {
	if x != nil {
		if x, ok := x.Mongodb.(*ClusterConfig_Mongodb_6_0); ok {
			return x.Mongodb_6_0
		}
	}
	return nil
}

func (x *ClusterConfig) GetMongodb_4_4Enterprise() *Mongodb4_4Enterprise {
	if x != nil {
		if x, ok := x.Mongodb.(*ClusterConfig_Mongodb_4_4Enterprise); ok {
			return x.Mongodb_4_4Enterprise
		}
	}
	return nil
}

func (x *ClusterConfig) GetMongodb_5_0Enterprise() *Mongodb5_0Enterprise {
	if x != nil {
		if x, ok := x.Mongodb.(*ClusterConfig_Mongodb_5_0Enterprise); ok {
			return x.Mongodb_5_0Enterprise
		}
	}
	return nil
}

func (x *ClusterConfig) GetMongodb_6_0Enterprise() *Mongodb6_0Enterprise {
	if x != nil {
		if x, ok := x.Mongodb.(*ClusterConfig_Mongodb_6_0Enterprise); ok {
			return x.Mongodb_6_0Enterprise
		}
	}
	return nil
}

func (x *ClusterConfig) GetBackupWindowStart() *timeofday.TimeOfDay {
	if x != nil {
		return x.BackupWindowStart
	}
	return nil
}

func (x *ClusterConfig) GetBackupRetainPeriodDays() *wrapperspb.Int64Value {
	if x != nil {
		return x.BackupRetainPeriodDays
	}
	return nil
}

func (x *ClusterConfig) GetPerformanceDiagnostics() *PerformanceDiagnosticsConfig {
	if x != nil {
		return x.PerformanceDiagnostics
	}
	return nil
}

func (x *ClusterConfig) GetAccess() *Access {
	if x != nil {
		return x.Access
	}
	return nil
}

func (x *ClusterConfig) GetMongodbConfig() *Mongodb {
	if x != nil {
		return x.MongodbConfig
	}
	return nil
}

func (x *ClusterConfig) GetFullVersion() string {
	if x != nil {
		return x.FullVersion
	}
	return ""
}

type isClusterConfig_Mongodb interface {
	isClusterConfig_Mongodb()
}

type ClusterConfig_Mongodb_3_6 struct {
	// Configuration and resource allocation for a MongoDB 3.6 cluster.
	Mongodb_3_6 *Mongodb3_6 `protobuf:"bytes,2,opt,name=mongodb_3_6,proto3,oneof"`
}

type ClusterConfig_Mongodb_4_0 struct {
	// Configuration and resource allocation for a MongoDB 4.0 cluster.
	Mongodb_4_0 *Mongodb4_0 `protobuf:"bytes,4,opt,name=mongodb_4_0,proto3,oneof"`
}

type ClusterConfig_Mongodb_4_2 struct {
	// Configuration and resource allocation for a MongoDB 4.2 cluster.
	Mongodb_4_2 *Mongodb4_2 `protobuf:"bytes,7,opt,name=mongodb_4_2,proto3,oneof"`
}

type ClusterConfig_Mongodb_4_4 struct {
	// Configuration and resource allocation for a MongoDB 4.4 cluster.
	Mongodb_4_4 *Mongodb4_4 `protobuf:"bytes,8,opt,name=mongodb_4_4,proto3,oneof"`
}

type ClusterConfig_Mongodb_5_0 struct {
	// Configuration and resource allocation for a MongoDB 5.0 cluster.
	Mongodb_5_0 *Mongodb5_0 `protobuf:"bytes,10,opt,name=mongodb_5_0,proto3,oneof"`
}

type ClusterConfig_Mongodb_6_0 struct {
	// Configuration and resource allocation for a MongoDB 6.0 cluster.
	Mongodb_6_0 *Mongodb6_0 `protobuf:"bytes,14,opt,name=mongodb_6_0,proto3,oneof"`
}

type ClusterConfig_Mongodb_4_4Enterprise struct {
	// Configuration and resource allocation for a MongoDB 4.4 Enterprise cluster.
	Mongodb_4_4Enterprise *Mongodb4_4Enterprise `protobuf:"bytes,11,opt,name=mongodb_4_4_enterprise,proto3,oneof"`
}

type ClusterConfig_Mongodb_5_0Enterprise struct {
	// Configuration and resource allocation for a MongoDB 5.0 Enterprise cluster.
	Mongodb_5_0Enterprise *Mongodb5_0Enterprise `protobuf:"bytes,12,opt,name=mongodb_5_0_enterprise,proto3,oneof"`
}

type ClusterConfig_Mongodb_6_0Enterprise struct {
	// Configuration and resource allocation for a MongoDB 6.0 Enterprise cluster.
	Mongodb_6_0Enterprise *Mongodb6_0Enterprise `protobuf:"bytes,15,opt,name=mongodb_6_0_enterprise,proto3,oneof"`
}

func (*ClusterConfig_Mongodb_3_6) isClusterConfig_Mongodb() {}

func (*ClusterConfig_Mongodb_4_0) isClusterConfig_Mongodb() {}

func (*ClusterConfig_Mongodb_4_2) isClusterConfig_Mongodb() {}

func (*ClusterConfig_Mongodb_4_4) isClusterConfig_Mongodb() {}

func (*ClusterConfig_Mongodb_5_0) isClusterConfig_Mongodb() {}

func (*ClusterConfig_Mongodb_6_0) isClusterConfig_Mongodb() {}

func (*ClusterConfig_Mongodb_4_4Enterprise) isClusterConfig_Mongodb() {}

func (*ClusterConfig_Mongodb_5_0Enterprise) isClusterConfig_Mongodb() {}

func (*ClusterConfig_Mongodb_6_0Enterprise) isClusterConfig_Mongodb() {}

type Mongodb3_6 struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration and resource allocation for mongod in a MongoDB 3.6 cluster.
	Mongod *Mongodb3_6_Mongod `protobuf:"bytes,1,opt,name=mongod,proto3" json:"mongod,omitempty"`
	// Configuration and resource allocation for mongocfg in a MongoDB 3.6 cluster.
	Mongocfg *Mongodb3_6_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	// Configuration and resource allocation for mongos in a MongoDB 3.6 cluster.
	Mongos *Mongodb3_6_Mongos `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	// Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB 3.6 cluster.
	Mongoinfra    *Mongodb3_6_MongoInfra `protobuf:"bytes,4,opt,name=mongoinfra,proto3" json:"mongoinfra,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Mongodb3_6) Reset() {
	*x = Mongodb3_6{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb3_6) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb3_6) ProtoMessage() {}

func (x *Mongodb3_6) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb3_6.ProtoReflect.Descriptor instead.
func (*Mongodb3_6) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{3}
}

func (x *Mongodb3_6) GetMongod() *Mongodb3_6_Mongod {
	if x != nil {
		return x.Mongod
	}
	return nil
}

func (x *Mongodb3_6) GetMongocfg() *Mongodb3_6_MongoCfg {
	if x != nil {
		return x.Mongocfg
	}
	return nil
}

func (x *Mongodb3_6) GetMongos() *Mongodb3_6_Mongos {
	if x != nil {
		return x.Mongos
	}
	return nil
}

func (x *Mongodb3_6) GetMongoinfra() *Mongodb3_6_MongoInfra {
	if x != nil {
		return x.Mongoinfra
	}
	return nil
}

type Mongodb4_0 struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration and resource allocation for mongod in a MongoDB 4.0 cluster.
	Mongod *Mongodb4_0_Mongod `protobuf:"bytes,1,opt,name=mongod,proto3" json:"mongod,omitempty"`
	// Configuration and resource allocation for mongocfg in a MongoDB 4.0 cluster.
	Mongocfg *Mongodb4_0_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	// Configuration and resource allocation for mongos in a MongoDB 4.0 cluster.
	Mongos *Mongodb4_0_Mongos `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	// Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB 4.0 cluster.
	Mongoinfra    *Mongodb4_0_MongoInfra `protobuf:"bytes,4,opt,name=mongoinfra,proto3" json:"mongoinfra,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Mongodb4_0) Reset() {
	*x = Mongodb4_0{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb4_0) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_0) ProtoMessage() {}

func (x *Mongodb4_0) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_0.ProtoReflect.Descriptor instead.
func (*Mongodb4_0) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{4}
}

func (x *Mongodb4_0) GetMongod() *Mongodb4_0_Mongod {
	if x != nil {
		return x.Mongod
	}
	return nil
}

func (x *Mongodb4_0) GetMongocfg() *Mongodb4_0_MongoCfg {
	if x != nil {
		return x.Mongocfg
	}
	return nil
}

func (x *Mongodb4_0) GetMongos() *Mongodb4_0_Mongos {
	if x != nil {
		return x.Mongos
	}
	return nil
}

func (x *Mongodb4_0) GetMongoinfra() *Mongodb4_0_MongoInfra {
	if x != nil {
		return x.Mongoinfra
	}
	return nil
}

type Mongodb4_2 struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration and resource allocation for mongod in a MongoDB 4.2 cluster.
	Mongod *Mongodb4_2_Mongod `protobuf:"bytes,1,opt,name=mongod,proto3" json:"mongod,omitempty"`
	// Configuration and resource allocation for mongocfg in a MongoDB 4.2 cluster.
	Mongocfg *Mongodb4_2_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	// Configuration and resource allocation for mongos in a MongoDB 4.2 cluster.
	Mongos *Mongodb4_2_Mongos `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	// Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB 4.2 cluster.
	Mongoinfra    *Mongodb4_2_MongoInfra `protobuf:"bytes,4,opt,name=mongoinfra,proto3" json:"mongoinfra,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Mongodb4_2) Reset() {
	*x = Mongodb4_2{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb4_2) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_2) ProtoMessage() {}

func (x *Mongodb4_2) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_2.ProtoReflect.Descriptor instead.
func (*Mongodb4_2) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{5}
}

func (x *Mongodb4_2) GetMongod() *Mongodb4_2_Mongod {
	if x != nil {
		return x.Mongod
	}
	return nil
}

func (x *Mongodb4_2) GetMongocfg() *Mongodb4_2_MongoCfg {
	if x != nil {
		return x.Mongocfg
	}
	return nil
}

func (x *Mongodb4_2) GetMongos() *Mongodb4_2_Mongos {
	if x != nil {
		return x.Mongos
	}
	return nil
}

func (x *Mongodb4_2) GetMongoinfra() *Mongodb4_2_MongoInfra {
	if x != nil {
		return x.Mongoinfra
	}
	return nil
}

type Mongodb4_4 struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration and resource allocation for mongod in a MongoDB 4.4 cluster.
	Mongod *Mongodb4_4_Mongod `protobuf:"bytes,1,opt,name=mongod,proto3" json:"mongod,omitempty"`
	// Configuration and resource allocation for mongocfg in a MongoDB 4.4 cluster.
	Mongocfg *Mongodb4_4_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	// Configuration and resource allocation for mongos in a MongoDB 4.4 cluster.
	Mongos *Mongodb4_4_Mongos `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	// Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB 4.4 cluster.
	Mongoinfra    *Mongodb4_4_MongoInfra `protobuf:"bytes,4,opt,name=mongoinfra,proto3" json:"mongoinfra,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Mongodb4_4) Reset() {
	*x = Mongodb4_4{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb4_4) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_4) ProtoMessage() {}

func (x *Mongodb4_4) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_4.ProtoReflect.Descriptor instead.
func (*Mongodb4_4) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{6}
}

func (x *Mongodb4_4) GetMongod() *Mongodb4_4_Mongod {
	if x != nil {
		return x.Mongod
	}
	return nil
}

func (x *Mongodb4_4) GetMongocfg() *Mongodb4_4_MongoCfg {
	if x != nil {
		return x.Mongocfg
	}
	return nil
}

func (x *Mongodb4_4) GetMongos() *Mongodb4_4_Mongos {
	if x != nil {
		return x.Mongos
	}
	return nil
}

func (x *Mongodb4_4) GetMongoinfra() *Mongodb4_4_MongoInfra {
	if x != nil {
		return x.Mongoinfra
	}
	return nil
}

type Mongodb4_4Enterprise struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration and resource allocation for mongod in a MongoDB 4.4 cluster.
	Mongod *Mongodb4_4Enterprise_Mongod `protobuf:"bytes,1,opt,name=mongod,proto3" json:"mongod,omitempty"`
	// Configuration and resource allocation for mongocfg in a MongoDB 4.4 cluster.
	Mongocfg *Mongodb4_4Enterprise_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	// Configuration and resource allocation for mongos in a MongoDB 4.4 cluster.
	Mongos *Mongodb4_4Enterprise_Mongos `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	// Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB 4.4 cluster.
	Mongoinfra    *Mongodb4_4Enterprise_MongoInfra `protobuf:"bytes,4,opt,name=mongoinfra,proto3" json:"mongoinfra,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Mongodb4_4Enterprise) Reset() {
	*x = Mongodb4_4Enterprise{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb4_4Enterprise) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_4Enterprise) ProtoMessage() {}

func (x *Mongodb4_4Enterprise) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_4Enterprise.ProtoReflect.Descriptor instead.
func (*Mongodb4_4Enterprise) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{7}
}

func (x *Mongodb4_4Enterprise) GetMongod() *Mongodb4_4Enterprise_Mongod {
	if x != nil {
		return x.Mongod
	}
	return nil
}

func (x *Mongodb4_4Enterprise) GetMongocfg() *Mongodb4_4Enterprise_MongoCfg {
	if x != nil {
		return x.Mongocfg
	}
	return nil
}

func (x *Mongodb4_4Enterprise) GetMongos() *Mongodb4_4Enterprise_Mongos {
	if x != nil {
		return x.Mongos
	}
	return nil
}

func (x *Mongodb4_4Enterprise) GetMongoinfra() *Mongodb4_4Enterprise_MongoInfra {
	if x != nil {
		return x.Mongoinfra
	}
	return nil
}

type Mongodb5_0 struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration and resource allocation for mongod in a MongoDB 5.0 cluster.
	Mongod *Mongodb5_0_Mongod `protobuf:"bytes,1,opt,name=mongod,proto3" json:"mongod,omitempty"`
	// Configuration and resource allocation for mongocfg in a MongoDB 5.0 cluster.
	Mongocfg *Mongodb5_0_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	// Configuration and resource allocation for mongos in a MongoDB 5.0 cluster.
	Mongos *Mongodb5_0_Mongos `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	// Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB 5.0 cluster.
	Mongoinfra    *Mongodb5_0_MongoInfra `protobuf:"bytes,4,opt,name=mongoinfra,proto3" json:"mongoinfra,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Mongodb5_0) Reset() {
	*x = Mongodb5_0{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb5_0) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb5_0) ProtoMessage() {}

func (x *Mongodb5_0) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb5_0.ProtoReflect.Descriptor instead.
func (*Mongodb5_0) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{8}
}

func (x *Mongodb5_0) GetMongod() *Mongodb5_0_Mongod {
	if x != nil {
		return x.Mongod
	}
	return nil
}

func (x *Mongodb5_0) GetMongocfg() *Mongodb5_0_MongoCfg {
	if x != nil {
		return x.Mongocfg
	}
	return nil
}

func (x *Mongodb5_0) GetMongos() *Mongodb5_0_Mongos {
	if x != nil {
		return x.Mongos
	}
	return nil
}

func (x *Mongodb5_0) GetMongoinfra() *Mongodb5_0_MongoInfra {
	if x != nil {
		return x.Mongoinfra
	}
	return nil
}

type Mongodb5_0Enterprise struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration and resource allocation for mongod in a MongoDB 5.0 cluster.
	Mongod *Mongodb5_0Enterprise_Mongod `protobuf:"bytes,1,opt,name=mongod,proto3" json:"mongod,omitempty"`
	// Configuration and resource allocation for mongocfg in a MongoDB 5.0 cluster.
	Mongocfg *Mongodb5_0Enterprise_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	// Configuration and resource allocation for mongos in a MongoDB 5.0 cluster.
	Mongos *Mongodb5_0Enterprise_Mongos `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	// Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB 5.0 cluster.
	Mongoinfra    *Mongodb5_0Enterprise_MongoInfra `protobuf:"bytes,4,opt,name=mongoinfra,proto3" json:"mongoinfra,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Mongodb5_0Enterprise) Reset() {
	*x = Mongodb5_0Enterprise{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb5_0Enterprise) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb5_0Enterprise) ProtoMessage() {}

func (x *Mongodb5_0Enterprise) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb5_0Enterprise.ProtoReflect.Descriptor instead.
func (*Mongodb5_0Enterprise) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{9}
}

func (x *Mongodb5_0Enterprise) GetMongod() *Mongodb5_0Enterprise_Mongod {
	if x != nil {
		return x.Mongod
	}
	return nil
}

func (x *Mongodb5_0Enterprise) GetMongocfg() *Mongodb5_0Enterprise_MongoCfg {
	if x != nil {
		return x.Mongocfg
	}
	return nil
}

func (x *Mongodb5_0Enterprise) GetMongos() *Mongodb5_0Enterprise_Mongos {
	if x != nil {
		return x.Mongos
	}
	return nil
}

func (x *Mongodb5_0Enterprise) GetMongoinfra() *Mongodb5_0Enterprise_MongoInfra {
	if x != nil {
		return x.Mongoinfra
	}
	return nil
}

type Mongodb6_0 struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration and resource allocation for mongod in a MongoDB 6.0 cluster.
	Mongod *Mongodb6_0_Mongod `protobuf:"bytes,1,opt,name=mongod,proto3" json:"mongod,omitempty"`
	// Configuration and resource allocation for mongocfg in a MongoDB 6.0 cluster.
	Mongocfg *Mongodb6_0_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	// Configuration and resource allocation for mongos in a MongoDB 6.0 cluster.
	Mongos *Mongodb6_0_Mongos `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	// Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB 6.0 cluster.
	Mongoinfra    *Mongodb6_0_MongoInfra `protobuf:"bytes,4,opt,name=mongoinfra,proto3" json:"mongoinfra,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Mongodb6_0) Reset() {
	*x = Mongodb6_0{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb6_0) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb6_0) ProtoMessage() {}

func (x *Mongodb6_0) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb6_0.ProtoReflect.Descriptor instead.
func (*Mongodb6_0) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{10}
}

func (x *Mongodb6_0) GetMongod() *Mongodb6_0_Mongod {
	if x != nil {
		return x.Mongod
	}
	return nil
}

func (x *Mongodb6_0) GetMongocfg() *Mongodb6_0_MongoCfg {
	if x != nil {
		return x.Mongocfg
	}
	return nil
}

func (x *Mongodb6_0) GetMongos() *Mongodb6_0_Mongos {
	if x != nil {
		return x.Mongos
	}
	return nil
}

func (x *Mongodb6_0) GetMongoinfra() *Mongodb6_0_MongoInfra {
	if x != nil {
		return x.Mongoinfra
	}
	return nil
}

type Mongodb6_0Enterprise struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration and resource allocation for mongod in a MongoDB 6.0 cluster.
	Mongod *Mongodb6_0Enterprise_Mongod `protobuf:"bytes,1,opt,name=mongod,proto3" json:"mongod,omitempty"`
	// Configuration and resource allocation for mongocfg in a MongoDB 6.0 cluster.
	Mongocfg *Mongodb6_0Enterprise_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	// Configuration and resource allocation for mongos in a MongoDB 6.0 cluster.
	Mongos *Mongodb6_0Enterprise_Mongos `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	// Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB 6.0 cluster.
	Mongoinfra    *Mongodb6_0Enterprise_MongoInfra `protobuf:"bytes,4,opt,name=mongoinfra,proto3" json:"mongoinfra,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Mongodb6_0Enterprise) Reset() {
	*x = Mongodb6_0Enterprise{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb6_0Enterprise) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb6_0Enterprise) ProtoMessage() {}

func (x *Mongodb6_0Enterprise) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb6_0Enterprise.ProtoReflect.Descriptor instead.
func (*Mongodb6_0Enterprise) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{11}
}

func (x *Mongodb6_0Enterprise) GetMongod() *Mongodb6_0Enterprise_Mongod {
	if x != nil {
		return x.Mongod
	}
	return nil
}

func (x *Mongodb6_0Enterprise) GetMongocfg() *Mongodb6_0Enterprise_MongoCfg {
	if x != nil {
		return x.Mongocfg
	}
	return nil
}

func (x *Mongodb6_0Enterprise) GetMongos() *Mongodb6_0Enterprise_Mongos {
	if x != nil {
		return x.Mongos
	}
	return nil
}

func (x *Mongodb6_0Enterprise) GetMongoinfra() *Mongodb6_0Enterprise_MongoInfra {
	if x != nil {
		return x.Mongoinfra
	}
	return nil
}

type Mongodb struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration and resource allocation for mongod in a MongoDB cluster.
	Mongod *Mongodb_Mongod `protobuf:"bytes,1,opt,name=mongod,proto3" json:"mongod,omitempty"`
	// Configuration and resource allocation for mongocfg in a MongoDB cluster.
	Mongocfg *Mongodb_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	// Configuration and resource allocation for mongos in a MongoDB cluster.
	Mongos *Mongodb_Mongos `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	// Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB cluster.
	Mongoinfra    *Mongodb_MongoInfra `protobuf:"bytes,4,opt,name=mongoinfra,proto3" json:"mongoinfra,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Mongodb) Reset() {
	*x = Mongodb{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb) ProtoMessage() {}

func (x *Mongodb) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb.ProtoReflect.Descriptor instead.
func (*Mongodb) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{12}
}

func (x *Mongodb) GetMongod() *Mongodb_Mongod {
	if x != nil {
		return x.Mongod
	}
	return nil
}

func (x *Mongodb) GetMongocfg() *Mongodb_MongoCfg {
	if x != nil {
		return x.Mongocfg
	}
	return nil
}

func (x *Mongodb) GetMongos() *Mongodb_Mongos {
	if x != nil {
		return x.Mongos
	}
	return nil
}

func (x *Mongodb) GetMongoinfra() *Mongodb_MongoInfra {
	if x != nil {
		return x.Mongoinfra
	}
	return nil
}

type Shard struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the shard.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the cluster that the shard belongs to.
	ClusterId     string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Shard) Reset() {
	*x = Shard{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Shard) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Shard) ProtoMessage() {}

func (x *Shard) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Shard.ProtoReflect.Descriptor instead.
func (*Shard) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{13}
}

func (x *Shard) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Shard) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

type Host struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the MongoDB host. The host name is assigned by MDB at creation time, and cannot be changed.
	// 1-63 characters long.
	//
	// The name is unique across all MDB hosts that exist on the platform, as it defines the FQDN of the host.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the MongoDB host. The ID is assigned by MDB at creation time.
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the availability zone where the MongoDB host resides.
	ZoneId string `protobuf:"bytes,3,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// Resources allocated to the MongoDB host.
	Resources *Resources `protobuf:"bytes,4,opt,name=resources,proto3" json:"resources,omitempty"`
	// Role of the host in the cluster. If the field has default value, it is not returned in the response.
	Role Host_Role `protobuf:"varint,5,opt,name=role,proto3,enum=yandex.cloud.mdb.mongodb.v1.Host_Role" json:"role,omitempty"`
	// Aggregated health of the host. If the field has default value, it is not returned in the response.
	Health Host_Health `protobuf:"varint,6,opt,name=health,proto3,enum=yandex.cloud.mdb.mongodb.v1.Host_Health" json:"health,omitempty"`
	// Services provided by the host.
	Services []*Service `protobuf:"bytes,7,rep,name=services,proto3" json:"services,omitempty"`
	// ID of the subnet that the host belongs to.
	SubnetId string `protobuf:"bytes,8,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Flag showing public IP assignment status to this host.
	AssignPublicIp bool `protobuf:"varint,9,opt,name=assign_public_ip,json=assignPublicIp,proto3" json:"assign_public_ip,omitempty"`
	// Shard which this host belongs to.
	ShardName string `protobuf:"bytes,10,opt,name=shard_name,json=shardName,proto3" json:"shard_name,omitempty"`
	// Host type. If the field has default value, it is not returned in the response.
	Type Host_Type `protobuf:"varint,11,opt,name=type,proto3,enum=yandex.cloud.mdb.mongodb.v1.Host_Type" json:"type,omitempty"`
	// Host parameters
	HostParameters *Host_HostParameters `protobuf:"bytes,12,opt,name=host_parameters,json=hostParameters,proto3" json:"host_parameters,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *Host) Reset() {
	*x = Host{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Host) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Host) ProtoMessage() {}

func (x *Host) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Host.ProtoReflect.Descriptor instead.
func (*Host) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{14}
}

func (x *Host) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Host) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *Host) GetZoneId() string {
	if x != nil {
		return x.ZoneId
	}
	return ""
}

func (x *Host) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Host) GetRole() Host_Role {
	if x != nil {
		return x.Role
	}
	return Host_ROLE_UNKNOWN
}

func (x *Host) GetHealth() Host_Health {
	if x != nil {
		return x.Health
	}
	return Host_HEALTH_UNKNOWN
}

func (x *Host) GetServices() []*Service {
	if x != nil {
		return x.Services
	}
	return nil
}

func (x *Host) GetSubnetId() string {
	if x != nil {
		return x.SubnetId
	}
	return ""
}

func (x *Host) GetAssignPublicIp() bool {
	if x != nil {
		return x.AssignPublicIp
	}
	return false
}

func (x *Host) GetShardName() string {
	if x != nil {
		return x.ShardName
	}
	return ""
}

func (x *Host) GetType() Host_Type {
	if x != nil {
		return x.Type
	}
	return Host_TYPE_UNSPECIFIED
}

func (x *Host) GetHostParameters() *Host_HostParameters {
	if x != nil {
		return x.HostParameters
	}
	return nil
}

type Service struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Type of the service provided by the host. If the field has default value, it is not returned in the response.
	Type Service_Type `protobuf:"varint,1,opt,name=type,proto3,enum=yandex.cloud.mdb.mongodb.v1.Service_Type" json:"type,omitempty"`
	// Aggregated health of the service. If the field has default value, it is not returned in the response.
	Health        Service_Health `protobuf:"varint,2,opt,name=health,proto3,enum=yandex.cloud.mdb.mongodb.v1.Service_Health" json:"health,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Service) Reset() {
	*x = Service{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Service) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Service) ProtoMessage() {}

func (x *Service) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Service.ProtoReflect.Descriptor instead.
func (*Service) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{15}
}

func (x *Service) GetType() Service_Type {
	if x != nil {
		return x.Type
	}
	return Service_TYPE_UNSPECIFIED
}

func (x *Service) GetHealth() Service_Health {
	if x != nil {
		return x.Health
	}
	return Service_HEALTH_UNKNOWN
}

type Resources struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the preset for computational resources available to a host (CPU, memory etc.).
	// All available presets are listed in the [documentation](/docs/managed-mongodb/concepts/instance-types).
	ResourcePresetId string `protobuf:"bytes,1,opt,name=resource_preset_id,json=resourcePresetId,proto3" json:"resource_preset_id,omitempty"`
	// Volume of the storage available to a host, in bytes.
	DiskSize int64 `protobuf:"varint,2,opt,name=disk_size,json=diskSize,proto3" json:"disk_size,omitempty"`
	// Type of the storage environment for the host.
	// Possible values:
	// * network-hdd - network HDD drive,
	// * network-ssd - network SSD drive,
	// * local-ssd - local SSD storage.
	DiskTypeId    string `protobuf:"bytes,3,opt,name=disk_type_id,json=diskTypeId,proto3" json:"disk_type_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Resources) Reset() {
	*x = Resources{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Resources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Resources) ProtoMessage() {}

func (x *Resources) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Resources.ProtoReflect.Descriptor instead.
func (*Resources) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{16}
}

func (x *Resources) GetResourcePresetId() string {
	if x != nil {
		return x.ResourcePresetId
	}
	return ""
}

func (x *Resources) GetDiskSize() int64 {
	if x != nil {
		return x.DiskSize
	}
	return 0
}

func (x *Resources) GetDiskTypeId() string {
	if x != nil {
		return x.DiskTypeId
	}
	return ""
}

type Access struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Allow access for DataLens.
	DataLens bool `protobuf:"varint,1,opt,name=data_lens,json=dataLens,proto3" json:"data_lens,omitempty"`
	// Allow access for Web SQL.
	WebSql bool `protobuf:"varint,2,opt,name=web_sql,json=webSql,proto3" json:"web_sql,omitempty"`
	// Allow access for DataTransfer.
	DataTransfer  bool `protobuf:"varint,3,opt,name=data_transfer,json=dataTransfer,proto3" json:"data_transfer,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Access) Reset() {
	*x = Access{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Access) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Access) ProtoMessage() {}

func (x *Access) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Access.ProtoReflect.Descriptor instead.
func (*Access) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{17}
}

func (x *Access) GetDataLens() bool {
	if x != nil {
		return x.DataLens
	}
	return false
}

func (x *Access) GetWebSql() bool {
	if x != nil {
		return x.WebSql
	}
	return false
}

func (x *Access) GetDataTransfer() bool {
	if x != nil {
		return x.DataTransfer
	}
	return false
}

type PerformanceDiagnosticsConfig struct {
	state            protoimpl.MessageState `protogen:"open.v1"`
	ProfilingEnabled bool                   `protobuf:"varint,1,opt,name=profiling_enabled,json=profilingEnabled,proto3" json:"profiling_enabled,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *PerformanceDiagnosticsConfig) Reset() {
	*x = PerformanceDiagnosticsConfig{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PerformanceDiagnosticsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PerformanceDiagnosticsConfig) ProtoMessage() {}

func (x *PerformanceDiagnosticsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PerformanceDiagnosticsConfig.ProtoReflect.Descriptor instead.
func (*PerformanceDiagnosticsConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{18}
}

func (x *PerformanceDiagnosticsConfig) GetProfilingEnabled() bool {
	if x != nil {
		return x.ProfilingEnabled
	}
	return false
}

type DiskSizeAutoscaling struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Amount of used storage for automatic disk scaling in the maintenance window, 0 means disabled, in percent.
	PlannedUsageThreshold *wrapperspb.Int64Value `protobuf:"bytes,1,opt,name=planned_usage_threshold,json=plannedUsageThreshold,proto3" json:"planned_usage_threshold,omitempty"`
	// Amount of used storage for immediately  automatic disk scaling, 0 means disabled, in percent.
	EmergencyUsageThreshold *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=emergency_usage_threshold,json=emergencyUsageThreshold,proto3" json:"emergency_usage_threshold,omitempty"`
	// Limit on how large the storage for database instances can automatically grow, in bytes.
	DiskSizeLimit *wrapperspb.Int64Value `protobuf:"bytes,3,opt,name=disk_size_limit,json=diskSizeLimit,proto3" json:"disk_size_limit,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DiskSizeAutoscaling) Reset() {
	*x = DiskSizeAutoscaling{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DiskSizeAutoscaling) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskSizeAutoscaling) ProtoMessage() {}

func (x *DiskSizeAutoscaling) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskSizeAutoscaling.ProtoReflect.Descriptor instead.
func (*DiskSizeAutoscaling) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{19}
}

func (x *DiskSizeAutoscaling) GetPlannedUsageThreshold() *wrapperspb.Int64Value {
	if x != nil {
		return x.PlannedUsageThreshold
	}
	return nil
}

func (x *DiskSizeAutoscaling) GetEmergencyUsageThreshold() *wrapperspb.Int64Value {
	if x != nil {
		return x.EmergencyUsageThreshold
	}
	return nil
}

func (x *DiskSizeAutoscaling) GetDiskSizeLimit() *wrapperspb.Int64Value {
	if x != nil {
		return x.DiskSizeLimit
	}
	return nil
}

type Mongodb3_6_Mongod struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for a mongod 3.6 hosts.
	Config *config.MongodConfigSet3_6 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to MongoDB hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb3_6_Mongod) Reset() {
	*x = Mongodb3_6_Mongod{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb3_6_Mongod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb3_6_Mongod) ProtoMessage() {}

func (x *Mongodb3_6_Mongod) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb3_6_Mongod.ProtoReflect.Descriptor instead.
func (*Mongodb3_6_Mongod) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{3, 0}
}

func (x *Mongodb3_6_Mongod) GetConfig() *config.MongodConfigSet3_6 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb3_6_Mongod) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb3_6_Mongod) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb3_6_MongoCfg struct {
	state  protoimpl.MessageState       `protogen:"open.v1"`
	Config *config.MongoCfgConfigSet3_6 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb3_6_MongoCfg) Reset() {
	*x = Mongodb3_6_MongoCfg{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb3_6_MongoCfg) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb3_6_MongoCfg) ProtoMessage() {}

func (x *Mongodb3_6_MongoCfg) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb3_6_MongoCfg.ProtoReflect.Descriptor instead.
func (*Mongodb3_6_MongoCfg) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{3, 1}
}

func (x *Mongodb3_6_MongoCfg) GetConfig() *config.MongoCfgConfigSet3_6 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb3_6_MongoCfg) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb3_6_MongoCfg) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb3_6_Mongos struct {
	state  protoimpl.MessageState     `protogen:"open.v1"`
	Config *config.MongosConfigSet3_6 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongos hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb3_6_Mongos) Reset() {
	*x = Mongodb3_6_Mongos{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb3_6_Mongos) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb3_6_Mongos) ProtoMessage() {}

func (x *Mongodb3_6_Mongos) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb3_6_Mongos.ProtoReflect.Descriptor instead.
func (*Mongodb3_6_Mongos) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{3, 2}
}

func (x *Mongodb3_6_Mongos) GetConfig() *config.MongosConfigSet3_6 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb3_6_Mongos) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb3_6_Mongos) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb3_6_MongoInfra struct {
	state          protoimpl.MessageState       `protogen:"open.v1"`
	ConfigMongos   *config.MongosConfigSet3_6   `protobuf:"bytes,1,opt,name=config_mongos,json=configMongos,proto3" json:"config_mongos,omitempty"`
	ConfigMongocfg *config.MongoCfgConfigSet3_6 `protobuf:"bytes,2,opt,name=config_mongocfg,json=configMongocfg,proto3" json:"config_mongocfg,omitempty"`
	// Resources allocated to mongoinfra (mongos+mongocfg) hosts.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,4,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb3_6_MongoInfra) Reset() {
	*x = Mongodb3_6_MongoInfra{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb3_6_MongoInfra) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb3_6_MongoInfra) ProtoMessage() {}

func (x *Mongodb3_6_MongoInfra) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb3_6_MongoInfra.ProtoReflect.Descriptor instead.
func (*Mongodb3_6_MongoInfra) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{3, 3}
}

func (x *Mongodb3_6_MongoInfra) GetConfigMongos() *config.MongosConfigSet3_6 {
	if x != nil {
		return x.ConfigMongos
	}
	return nil
}

func (x *Mongodb3_6_MongoInfra) GetConfigMongocfg() *config.MongoCfgConfigSet3_6 {
	if x != nil {
		return x.ConfigMongocfg
	}
	return nil
}

func (x *Mongodb3_6_MongoInfra) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb3_6_MongoInfra) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb4_0_Mongod struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for mongod 4.0 hosts.
	Config *config.MongodConfigSet4_0 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongod hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb4_0_Mongod) Reset() {
	*x = Mongodb4_0_Mongod{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb4_0_Mongod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_0_Mongod) ProtoMessage() {}

func (x *Mongodb4_0_Mongod) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_0_Mongod.ProtoReflect.Descriptor instead.
func (*Mongodb4_0_Mongod) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{4, 0}
}

func (x *Mongodb4_0_Mongod) GetConfig() *config.MongodConfigSet4_0 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb4_0_Mongod) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb4_0_Mongod) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb4_0_MongoCfg struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for mongocfg 4.0 hosts.
	Config *config.MongoCfgConfigSet4_0 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb4_0_MongoCfg) Reset() {
	*x = Mongodb4_0_MongoCfg{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb4_0_MongoCfg) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_0_MongoCfg) ProtoMessage() {}

func (x *Mongodb4_0_MongoCfg) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_0_MongoCfg.ProtoReflect.Descriptor instead.
func (*Mongodb4_0_MongoCfg) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{4, 1}
}

func (x *Mongodb4_0_MongoCfg) GetConfig() *config.MongoCfgConfigSet4_0 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb4_0_MongoCfg) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb4_0_MongoCfg) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb4_0_Mongos struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for mongos 4.0 hosts.
	Config *config.MongosConfigSet4_0 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongos hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb4_0_Mongos) Reset() {
	*x = Mongodb4_0_Mongos{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb4_0_Mongos) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_0_Mongos) ProtoMessage() {}

func (x *Mongodb4_0_Mongos) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_0_Mongos.ProtoReflect.Descriptor instead.
func (*Mongodb4_0_Mongos) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{4, 2}
}

func (x *Mongodb4_0_Mongos) GetConfig() *config.MongosConfigSet4_0 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb4_0_Mongos) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb4_0_Mongos) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb4_0_MongoInfra struct {
	state          protoimpl.MessageState       `protogen:"open.v1"`
	ConfigMongos   *config.MongosConfigSet4_0   `protobuf:"bytes,1,opt,name=config_mongos,json=configMongos,proto3" json:"config_mongos,omitempty"`
	ConfigMongocfg *config.MongoCfgConfigSet4_0 `protobuf:"bytes,2,opt,name=config_mongocfg,json=configMongocfg,proto3" json:"config_mongocfg,omitempty"`
	// Resources allocated to mongoinfra (mongos+mongocfg) hosts.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,4,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb4_0_MongoInfra) Reset() {
	*x = Mongodb4_0_MongoInfra{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb4_0_MongoInfra) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_0_MongoInfra) ProtoMessage() {}

func (x *Mongodb4_0_MongoInfra) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_0_MongoInfra.ProtoReflect.Descriptor instead.
func (*Mongodb4_0_MongoInfra) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{4, 3}
}

func (x *Mongodb4_0_MongoInfra) GetConfigMongos() *config.MongosConfigSet4_0 {
	if x != nil {
		return x.ConfigMongos
	}
	return nil
}

func (x *Mongodb4_0_MongoInfra) GetConfigMongocfg() *config.MongoCfgConfigSet4_0 {
	if x != nil {
		return x.ConfigMongocfg
	}
	return nil
}

func (x *Mongodb4_0_MongoInfra) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb4_0_MongoInfra) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb4_2_Mongod struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for mongod 4.2 hosts.
	Config *config.MongodConfigSet4_2 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongod hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb4_2_Mongod) Reset() {
	*x = Mongodb4_2_Mongod{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb4_2_Mongod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_2_Mongod) ProtoMessage() {}

func (x *Mongodb4_2_Mongod) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_2_Mongod.ProtoReflect.Descriptor instead.
func (*Mongodb4_2_Mongod) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{5, 0}
}

func (x *Mongodb4_2_Mongod) GetConfig() *config.MongodConfigSet4_2 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb4_2_Mongod) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb4_2_Mongod) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb4_2_MongoCfg struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for mongocfg 4.2 hosts.
	Config *config.MongoCfgConfigSet4_2 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb4_2_MongoCfg) Reset() {
	*x = Mongodb4_2_MongoCfg{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb4_2_MongoCfg) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_2_MongoCfg) ProtoMessage() {}

func (x *Mongodb4_2_MongoCfg) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_2_MongoCfg.ProtoReflect.Descriptor instead.
func (*Mongodb4_2_MongoCfg) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{5, 1}
}

func (x *Mongodb4_2_MongoCfg) GetConfig() *config.MongoCfgConfigSet4_2 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb4_2_MongoCfg) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb4_2_MongoCfg) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb4_2_Mongos struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for mongos 4.2 hosts.
	Config *config.MongosConfigSet4_2 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongos hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb4_2_Mongos) Reset() {
	*x = Mongodb4_2_Mongos{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb4_2_Mongos) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_2_Mongos) ProtoMessage() {}

func (x *Mongodb4_2_Mongos) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_2_Mongos.ProtoReflect.Descriptor instead.
func (*Mongodb4_2_Mongos) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{5, 2}
}

func (x *Mongodb4_2_Mongos) GetConfig() *config.MongosConfigSet4_2 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb4_2_Mongos) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb4_2_Mongos) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb4_2_MongoInfra struct {
	state          protoimpl.MessageState       `protogen:"open.v1"`
	ConfigMongos   *config.MongosConfigSet4_2   `protobuf:"bytes,1,opt,name=config_mongos,json=configMongos,proto3" json:"config_mongos,omitempty"`
	ConfigMongocfg *config.MongoCfgConfigSet4_2 `protobuf:"bytes,2,opt,name=config_mongocfg,json=configMongocfg,proto3" json:"config_mongocfg,omitempty"`
	// Resources allocated to mongoinfra (mongos+mongocfg) hosts.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,4,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb4_2_MongoInfra) Reset() {
	*x = Mongodb4_2_MongoInfra{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb4_2_MongoInfra) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_2_MongoInfra) ProtoMessage() {}

func (x *Mongodb4_2_MongoInfra) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_2_MongoInfra.ProtoReflect.Descriptor instead.
func (*Mongodb4_2_MongoInfra) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{5, 3}
}

func (x *Mongodb4_2_MongoInfra) GetConfigMongos() *config.MongosConfigSet4_2 {
	if x != nil {
		return x.ConfigMongos
	}
	return nil
}

func (x *Mongodb4_2_MongoInfra) GetConfigMongocfg() *config.MongoCfgConfigSet4_2 {
	if x != nil {
		return x.ConfigMongocfg
	}
	return nil
}

func (x *Mongodb4_2_MongoInfra) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb4_2_MongoInfra) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb4_4_Mongod struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for mongod 4.4 hosts.
	Config *config.MongodConfigSet4_4 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongod hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb4_4_Mongod) Reset() {
	*x = Mongodb4_4_Mongod{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb4_4_Mongod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_4_Mongod) ProtoMessage() {}

func (x *Mongodb4_4_Mongod) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_4_Mongod.ProtoReflect.Descriptor instead.
func (*Mongodb4_4_Mongod) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{6, 0}
}

func (x *Mongodb4_4_Mongod) GetConfig() *config.MongodConfigSet4_4 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb4_4_Mongod) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb4_4_Mongod) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb4_4_MongoCfg struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for mongocfg 4.4 hosts.
	Config *config.MongoCfgConfigSet4_4 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb4_4_MongoCfg) Reset() {
	*x = Mongodb4_4_MongoCfg{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb4_4_MongoCfg) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_4_MongoCfg) ProtoMessage() {}

func (x *Mongodb4_4_MongoCfg) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_4_MongoCfg.ProtoReflect.Descriptor instead.
func (*Mongodb4_4_MongoCfg) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{6, 1}
}

func (x *Mongodb4_4_MongoCfg) GetConfig() *config.MongoCfgConfigSet4_4 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb4_4_MongoCfg) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb4_4_MongoCfg) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb4_4_Mongos struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for mongos 4.4 hosts.
	Config *config.MongosConfigSet4_4 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongos hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb4_4_Mongos) Reset() {
	*x = Mongodb4_4_Mongos{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb4_4_Mongos) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_4_Mongos) ProtoMessage() {}

func (x *Mongodb4_4_Mongos) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_4_Mongos.ProtoReflect.Descriptor instead.
func (*Mongodb4_4_Mongos) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{6, 2}
}

func (x *Mongodb4_4_Mongos) GetConfig() *config.MongosConfigSet4_4 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb4_4_Mongos) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb4_4_Mongos) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb4_4_MongoInfra struct {
	state          protoimpl.MessageState       `protogen:"open.v1"`
	ConfigMongos   *config.MongosConfigSet4_4   `protobuf:"bytes,1,opt,name=config_mongos,json=configMongos,proto3" json:"config_mongos,omitempty"`
	ConfigMongocfg *config.MongoCfgConfigSet4_4 `protobuf:"bytes,2,opt,name=config_mongocfg,json=configMongocfg,proto3" json:"config_mongocfg,omitempty"`
	// Resources allocated to mongoinfra (mongos+mongocfg) hosts.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,4,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb4_4_MongoInfra) Reset() {
	*x = Mongodb4_4_MongoInfra{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb4_4_MongoInfra) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_4_MongoInfra) ProtoMessage() {}

func (x *Mongodb4_4_MongoInfra) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_4_MongoInfra.ProtoReflect.Descriptor instead.
func (*Mongodb4_4_MongoInfra) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{6, 3}
}

func (x *Mongodb4_4_MongoInfra) GetConfigMongos() *config.MongosConfigSet4_4 {
	if x != nil {
		return x.ConfigMongos
	}
	return nil
}

func (x *Mongodb4_4_MongoInfra) GetConfigMongocfg() *config.MongoCfgConfigSet4_4 {
	if x != nil {
		return x.ConfigMongocfg
	}
	return nil
}

func (x *Mongodb4_4_MongoInfra) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb4_4_MongoInfra) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb4_4Enterprise_Mongod struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for mongod 4.4 hosts.
	Config *config.MongodConfigSet4_4Enterprise `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongod hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb4_4Enterprise_Mongod) Reset() {
	*x = Mongodb4_4Enterprise_Mongod{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb4_4Enterprise_Mongod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_4Enterprise_Mongod) ProtoMessage() {}

func (x *Mongodb4_4Enterprise_Mongod) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_4Enterprise_Mongod.ProtoReflect.Descriptor instead.
func (*Mongodb4_4Enterprise_Mongod) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{7, 0}
}

func (x *Mongodb4_4Enterprise_Mongod) GetConfig() *config.MongodConfigSet4_4Enterprise {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb4_4Enterprise_Mongod) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb4_4Enterprise_Mongod) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb4_4Enterprise_MongoCfg struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for mongocfg 4.4 hosts.
	Config *config.MongoCfgConfigSet4_4Enterprise `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb4_4Enterprise_MongoCfg) Reset() {
	*x = Mongodb4_4Enterprise_MongoCfg{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb4_4Enterprise_MongoCfg) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_4Enterprise_MongoCfg) ProtoMessage() {}

func (x *Mongodb4_4Enterprise_MongoCfg) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_4Enterprise_MongoCfg.ProtoReflect.Descriptor instead.
func (*Mongodb4_4Enterprise_MongoCfg) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{7, 1}
}

func (x *Mongodb4_4Enterprise_MongoCfg) GetConfig() *config.MongoCfgConfigSet4_4Enterprise {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb4_4Enterprise_MongoCfg) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb4_4Enterprise_MongoCfg) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb4_4Enterprise_Mongos struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for mongos 4.4 hosts.
	Config *config.MongosConfigSet4_4Enterprise `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongos hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb4_4Enterprise_Mongos) Reset() {
	*x = Mongodb4_4Enterprise_Mongos{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb4_4Enterprise_Mongos) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_4Enterprise_Mongos) ProtoMessage() {}

func (x *Mongodb4_4Enterprise_Mongos) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_4Enterprise_Mongos.ProtoReflect.Descriptor instead.
func (*Mongodb4_4Enterprise_Mongos) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{7, 2}
}

func (x *Mongodb4_4Enterprise_Mongos) GetConfig() *config.MongosConfigSet4_4Enterprise {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb4_4Enterprise_Mongos) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb4_4Enterprise_Mongos) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb4_4Enterprise_MongoInfra struct {
	state          protoimpl.MessageState                 `protogen:"open.v1"`
	ConfigMongos   *config.MongosConfigSet4_4Enterprise   `protobuf:"bytes,1,opt,name=config_mongos,json=configMongos,proto3" json:"config_mongos,omitempty"`
	ConfigMongocfg *config.MongoCfgConfigSet4_4Enterprise `protobuf:"bytes,2,opt,name=config_mongocfg,json=configMongocfg,proto3" json:"config_mongocfg,omitempty"`
	// Resources allocated to mongoinfra (mongos+mongocfg) hosts.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,4,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb4_4Enterprise_MongoInfra) Reset() {
	*x = Mongodb4_4Enterprise_MongoInfra{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb4_4Enterprise_MongoInfra) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_4Enterprise_MongoInfra) ProtoMessage() {}

func (x *Mongodb4_4Enterprise_MongoInfra) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_4Enterprise_MongoInfra.ProtoReflect.Descriptor instead.
func (*Mongodb4_4Enterprise_MongoInfra) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{7, 3}
}

func (x *Mongodb4_4Enterprise_MongoInfra) GetConfigMongos() *config.MongosConfigSet4_4Enterprise {
	if x != nil {
		return x.ConfigMongos
	}
	return nil
}

func (x *Mongodb4_4Enterprise_MongoInfra) GetConfigMongocfg() *config.MongoCfgConfigSet4_4Enterprise {
	if x != nil {
		return x.ConfigMongocfg
	}
	return nil
}

func (x *Mongodb4_4Enterprise_MongoInfra) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb4_4Enterprise_MongoInfra) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb5_0_Mongod struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for mongod 5.0 hosts.
	Config *config.MongodConfigSet5_0 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongod hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb5_0_Mongod) Reset() {
	*x = Mongodb5_0_Mongod{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb5_0_Mongod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb5_0_Mongod) ProtoMessage() {}

func (x *Mongodb5_0_Mongod) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb5_0_Mongod.ProtoReflect.Descriptor instead.
func (*Mongodb5_0_Mongod) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{8, 0}
}

func (x *Mongodb5_0_Mongod) GetConfig() *config.MongodConfigSet5_0 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb5_0_Mongod) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb5_0_Mongod) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb5_0_MongoCfg struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for mongocfg 5.0 hosts.
	Config *config.MongoCfgConfigSet5_0 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb5_0_MongoCfg) Reset() {
	*x = Mongodb5_0_MongoCfg{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb5_0_MongoCfg) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb5_0_MongoCfg) ProtoMessage() {}

func (x *Mongodb5_0_MongoCfg) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb5_0_MongoCfg.ProtoReflect.Descriptor instead.
func (*Mongodb5_0_MongoCfg) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{8, 1}
}

func (x *Mongodb5_0_MongoCfg) GetConfig() *config.MongoCfgConfigSet5_0 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb5_0_MongoCfg) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb5_0_MongoCfg) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb5_0_Mongos struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for mongos 5.0 hosts.
	Config *config.MongosConfigSet5_0 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongos hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb5_0_Mongos) Reset() {
	*x = Mongodb5_0_Mongos{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb5_0_Mongos) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb5_0_Mongos) ProtoMessage() {}

func (x *Mongodb5_0_Mongos) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb5_0_Mongos.ProtoReflect.Descriptor instead.
func (*Mongodb5_0_Mongos) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{8, 2}
}

func (x *Mongodb5_0_Mongos) GetConfig() *config.MongosConfigSet5_0 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb5_0_Mongos) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb5_0_Mongos) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb5_0_MongoInfra struct {
	state          protoimpl.MessageState       `protogen:"open.v1"`
	ConfigMongos   *config.MongosConfigSet5_0   `protobuf:"bytes,1,opt,name=config_mongos,json=configMongos,proto3" json:"config_mongos,omitempty"`
	ConfigMongocfg *config.MongoCfgConfigSet5_0 `protobuf:"bytes,2,opt,name=config_mongocfg,json=configMongocfg,proto3" json:"config_mongocfg,omitempty"`
	// Resources allocated to mongoinfra (mongos+mongocfg) hosts.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,4,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb5_0_MongoInfra) Reset() {
	*x = Mongodb5_0_MongoInfra{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb5_0_MongoInfra) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb5_0_MongoInfra) ProtoMessage() {}

func (x *Mongodb5_0_MongoInfra) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb5_0_MongoInfra.ProtoReflect.Descriptor instead.
func (*Mongodb5_0_MongoInfra) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{8, 3}
}

func (x *Mongodb5_0_MongoInfra) GetConfigMongos() *config.MongosConfigSet5_0 {
	if x != nil {
		return x.ConfigMongos
	}
	return nil
}

func (x *Mongodb5_0_MongoInfra) GetConfigMongocfg() *config.MongoCfgConfigSet5_0 {
	if x != nil {
		return x.ConfigMongocfg
	}
	return nil
}

func (x *Mongodb5_0_MongoInfra) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb5_0_MongoInfra) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb5_0Enterprise_Mongod struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for mongod 5.0 hosts.
	Config *config.MongodConfigSet5_0Enterprise `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongod hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb5_0Enterprise_Mongod) Reset() {
	*x = Mongodb5_0Enterprise_Mongod{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb5_0Enterprise_Mongod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb5_0Enterprise_Mongod) ProtoMessage() {}

func (x *Mongodb5_0Enterprise_Mongod) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb5_0Enterprise_Mongod.ProtoReflect.Descriptor instead.
func (*Mongodb5_0Enterprise_Mongod) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{9, 0}
}

func (x *Mongodb5_0Enterprise_Mongod) GetConfig() *config.MongodConfigSet5_0Enterprise {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb5_0Enterprise_Mongod) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb5_0Enterprise_Mongod) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb5_0Enterprise_MongoCfg struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for mongocfg 5.0 hosts.
	Config *config.MongoCfgConfigSet5_0Enterprise `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb5_0Enterprise_MongoCfg) Reset() {
	*x = Mongodb5_0Enterprise_MongoCfg{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb5_0Enterprise_MongoCfg) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb5_0Enterprise_MongoCfg) ProtoMessage() {}

func (x *Mongodb5_0Enterprise_MongoCfg) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb5_0Enterprise_MongoCfg.ProtoReflect.Descriptor instead.
func (*Mongodb5_0Enterprise_MongoCfg) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{9, 1}
}

func (x *Mongodb5_0Enterprise_MongoCfg) GetConfig() *config.MongoCfgConfigSet5_0Enterprise {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb5_0Enterprise_MongoCfg) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb5_0Enterprise_MongoCfg) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb5_0Enterprise_Mongos struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for mongos 5.0 hosts.
	Config *config.MongosConfigSet5_0Enterprise `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongos hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb5_0Enterprise_Mongos) Reset() {
	*x = Mongodb5_0Enterprise_Mongos{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb5_0Enterprise_Mongos) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb5_0Enterprise_Mongos) ProtoMessage() {}

func (x *Mongodb5_0Enterprise_Mongos) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb5_0Enterprise_Mongos.ProtoReflect.Descriptor instead.
func (*Mongodb5_0Enterprise_Mongos) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{9, 2}
}

func (x *Mongodb5_0Enterprise_Mongos) GetConfig() *config.MongosConfigSet5_0Enterprise {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb5_0Enterprise_Mongos) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb5_0Enterprise_Mongos) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb5_0Enterprise_MongoInfra struct {
	state          protoimpl.MessageState                 `protogen:"open.v1"`
	ConfigMongos   *config.MongosConfigSet5_0Enterprise   `protobuf:"bytes,1,opt,name=config_mongos,json=configMongos,proto3" json:"config_mongos,omitempty"`
	ConfigMongocfg *config.MongoCfgConfigSet5_0Enterprise `protobuf:"bytes,2,opt,name=config_mongocfg,json=configMongocfg,proto3" json:"config_mongocfg,omitempty"`
	// Resources allocated to mongoinfra (mongos+mongocfg) hosts.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,4,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb5_0Enterprise_MongoInfra) Reset() {
	*x = Mongodb5_0Enterprise_MongoInfra{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb5_0Enterprise_MongoInfra) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb5_0Enterprise_MongoInfra) ProtoMessage() {}

func (x *Mongodb5_0Enterprise_MongoInfra) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb5_0Enterprise_MongoInfra.ProtoReflect.Descriptor instead.
func (*Mongodb5_0Enterprise_MongoInfra) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{9, 3}
}

func (x *Mongodb5_0Enterprise_MongoInfra) GetConfigMongos() *config.MongosConfigSet5_0Enterprise {
	if x != nil {
		return x.ConfigMongos
	}
	return nil
}

func (x *Mongodb5_0Enterprise_MongoInfra) GetConfigMongocfg() *config.MongoCfgConfigSet5_0Enterprise {
	if x != nil {
		return x.ConfigMongocfg
	}
	return nil
}

func (x *Mongodb5_0Enterprise_MongoInfra) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb5_0Enterprise_MongoInfra) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb6_0_Mongod struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for mongod 6.0 hosts.
	Config *config.MongodConfigSet6_0 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongod hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb6_0_Mongod) Reset() {
	*x = Mongodb6_0_Mongod{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb6_0_Mongod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb6_0_Mongod) ProtoMessage() {}

func (x *Mongodb6_0_Mongod) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb6_0_Mongod.ProtoReflect.Descriptor instead.
func (*Mongodb6_0_Mongod) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{10, 0}
}

func (x *Mongodb6_0_Mongod) GetConfig() *config.MongodConfigSet6_0 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb6_0_Mongod) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb6_0_Mongod) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb6_0_MongoCfg struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for mongocfg 6.0 hosts.
	Config *config.MongoCfgConfigSet6_0 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb6_0_MongoCfg) Reset() {
	*x = Mongodb6_0_MongoCfg{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb6_0_MongoCfg) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb6_0_MongoCfg) ProtoMessage() {}

func (x *Mongodb6_0_MongoCfg) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb6_0_MongoCfg.ProtoReflect.Descriptor instead.
func (*Mongodb6_0_MongoCfg) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{10, 1}
}

func (x *Mongodb6_0_MongoCfg) GetConfig() *config.MongoCfgConfigSet6_0 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb6_0_MongoCfg) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb6_0_MongoCfg) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb6_0_Mongos struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for mongos 6.0 hosts.
	Config *config.MongosConfigSet6_0 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongos hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb6_0_Mongos) Reset() {
	*x = Mongodb6_0_Mongos{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[51]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb6_0_Mongos) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb6_0_Mongos) ProtoMessage() {}

func (x *Mongodb6_0_Mongos) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[51]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb6_0_Mongos.ProtoReflect.Descriptor instead.
func (*Mongodb6_0_Mongos) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{10, 2}
}

func (x *Mongodb6_0_Mongos) GetConfig() *config.MongosConfigSet6_0 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb6_0_Mongos) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb6_0_Mongos) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb6_0_MongoInfra struct {
	state          protoimpl.MessageState       `protogen:"open.v1"`
	ConfigMongos   *config.MongosConfigSet6_0   `protobuf:"bytes,1,opt,name=config_mongos,json=configMongos,proto3" json:"config_mongos,omitempty"`
	ConfigMongocfg *config.MongoCfgConfigSet6_0 `protobuf:"bytes,2,opt,name=config_mongocfg,json=configMongocfg,proto3" json:"config_mongocfg,omitempty"`
	// Resources allocated to mongoinfra (mongos+mongocfg) hosts.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,4,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb6_0_MongoInfra) Reset() {
	*x = Mongodb6_0_MongoInfra{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[52]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb6_0_MongoInfra) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb6_0_MongoInfra) ProtoMessage() {}

func (x *Mongodb6_0_MongoInfra) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[52]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb6_0_MongoInfra.ProtoReflect.Descriptor instead.
func (*Mongodb6_0_MongoInfra) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{10, 3}
}

func (x *Mongodb6_0_MongoInfra) GetConfigMongos() *config.MongosConfigSet6_0 {
	if x != nil {
		return x.ConfigMongos
	}
	return nil
}

func (x *Mongodb6_0_MongoInfra) GetConfigMongocfg() *config.MongoCfgConfigSet6_0 {
	if x != nil {
		return x.ConfigMongocfg
	}
	return nil
}

func (x *Mongodb6_0_MongoInfra) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb6_0_MongoInfra) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb6_0Enterprise_Mongod struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for mongod 6.0 hosts.
	Config *config.MongodConfigSet6_0Enterprise `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongod hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb6_0Enterprise_Mongod) Reset() {
	*x = Mongodb6_0Enterprise_Mongod{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[53]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb6_0Enterprise_Mongod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb6_0Enterprise_Mongod) ProtoMessage() {}

func (x *Mongodb6_0Enterprise_Mongod) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[53]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb6_0Enterprise_Mongod.ProtoReflect.Descriptor instead.
func (*Mongodb6_0Enterprise_Mongod) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{11, 0}
}

func (x *Mongodb6_0Enterprise_Mongod) GetConfig() *config.MongodConfigSet6_0Enterprise {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb6_0Enterprise_Mongod) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb6_0Enterprise_Mongod) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb6_0Enterprise_MongoCfg struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for mongocfg 6.0 hosts.
	Config *config.MongoCfgConfigSet6_0Enterprise `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb6_0Enterprise_MongoCfg) Reset() {
	*x = Mongodb6_0Enterprise_MongoCfg{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[54]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb6_0Enterprise_MongoCfg) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb6_0Enterprise_MongoCfg) ProtoMessage() {}

func (x *Mongodb6_0Enterprise_MongoCfg) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[54]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb6_0Enterprise_MongoCfg.ProtoReflect.Descriptor instead.
func (*Mongodb6_0Enterprise_MongoCfg) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{11, 1}
}

func (x *Mongodb6_0Enterprise_MongoCfg) GetConfig() *config.MongoCfgConfigSet6_0Enterprise {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb6_0Enterprise_MongoCfg) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb6_0Enterprise_MongoCfg) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb6_0Enterprise_Mongos struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for mongos 6.0 hosts.
	Config *config.MongosConfigSet6_0Enterprise `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongos hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb6_0Enterprise_Mongos) Reset() {
	*x = Mongodb6_0Enterprise_Mongos{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[55]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb6_0Enterprise_Mongos) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb6_0Enterprise_Mongos) ProtoMessage() {}

func (x *Mongodb6_0Enterprise_Mongos) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[55]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb6_0Enterprise_Mongos.ProtoReflect.Descriptor instead.
func (*Mongodb6_0Enterprise_Mongos) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{11, 2}
}

func (x *Mongodb6_0Enterprise_Mongos) GetConfig() *config.MongosConfigSet6_0Enterprise {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb6_0Enterprise_Mongos) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb6_0Enterprise_Mongos) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb6_0Enterprise_MongoInfra struct {
	state          protoimpl.MessageState                 `protogen:"open.v1"`
	ConfigMongos   *config.MongosConfigSet6_0Enterprise   `protobuf:"bytes,1,opt,name=config_mongos,json=configMongos,proto3" json:"config_mongos,omitempty"`
	ConfigMongocfg *config.MongoCfgConfigSet6_0Enterprise `protobuf:"bytes,2,opt,name=config_mongocfg,json=configMongocfg,proto3" json:"config_mongocfg,omitempty"`
	// Resources allocated to mongoinfra (mongos+mongocfg) hosts.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,4,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb6_0Enterprise_MongoInfra) Reset() {
	*x = Mongodb6_0Enterprise_MongoInfra{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[56]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb6_0Enterprise_MongoInfra) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb6_0Enterprise_MongoInfra) ProtoMessage() {}

func (x *Mongodb6_0Enterprise_MongoInfra) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[56]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb6_0Enterprise_MongoInfra.ProtoReflect.Descriptor instead.
func (*Mongodb6_0Enterprise_MongoInfra) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{11, 3}
}

func (x *Mongodb6_0Enterprise_MongoInfra) GetConfigMongos() *config.MongosConfigSet6_0Enterprise {
	if x != nil {
		return x.ConfigMongos
	}
	return nil
}

func (x *Mongodb6_0Enterprise_MongoInfra) GetConfigMongocfg() *config.MongoCfgConfigSet6_0Enterprise {
	if x != nil {
		return x.ConfigMongocfg
	}
	return nil
}

func (x *Mongodb6_0Enterprise_MongoInfra) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb6_0Enterprise_MongoInfra) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb_Mongod struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for mongod hosts.
	Config *config.MongodConfigSet `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongod hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb_Mongod) Reset() {
	*x = Mongodb_Mongod{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[57]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb_Mongod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb_Mongod) ProtoMessage() {}

func (x *Mongodb_Mongod) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[57]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb_Mongod.ProtoReflect.Descriptor instead.
func (*Mongodb_Mongod) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{12, 0}
}

func (x *Mongodb_Mongod) GetConfig() *config.MongodConfigSet {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb_Mongod) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb_Mongod) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb_MongoCfg struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for mongocfg hosts.
	Config *config.MongoCfgConfigSet `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb_MongoCfg) Reset() {
	*x = Mongodb_MongoCfg{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[58]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb_MongoCfg) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb_MongoCfg) ProtoMessage() {}

func (x *Mongodb_MongoCfg) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[58]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb_MongoCfg.ProtoReflect.Descriptor instead.
func (*Mongodb_MongoCfg) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{12, 1}
}

func (x *Mongodb_MongoCfg) GetConfig() *config.MongoCfgConfigSet {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb_MongoCfg) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb_MongoCfg) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb_Mongos struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for mongos hosts.
	Config *config.MongosConfigSet `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongos hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb_Mongos) Reset() {
	*x = Mongodb_Mongos{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[59]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb_Mongos) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb_Mongos) ProtoMessage() {}

func (x *Mongodb_Mongos) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[59]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb_Mongos.ProtoReflect.Descriptor instead.
func (*Mongodb_Mongos) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{12, 2}
}

func (x *Mongodb_Mongos) GetConfig() *config.MongosConfigSet {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb_Mongos) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb_Mongos) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb_MongoInfra struct {
	state          protoimpl.MessageState    `protogen:"open.v1"`
	ConfigMongos   *config.MongosConfigSet   `protobuf:"bytes,1,opt,name=config_mongos,json=configMongos,proto3" json:"config_mongos,omitempty"`
	ConfigMongocfg *config.MongoCfgConfigSet `protobuf:"bytes,2,opt,name=config_mongocfg,json=configMongocfg,proto3" json:"config_mongocfg,omitempty"`
	// Resources allocated to mongoinfra (mongos+mongocfg) hosts.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,4,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Mongodb_MongoInfra) Reset() {
	*x = Mongodb_MongoInfra{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[60]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mongodb_MongoInfra) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb_MongoInfra) ProtoMessage() {}

func (x *Mongodb_MongoInfra) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[60]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb_MongoInfra.ProtoReflect.Descriptor instead.
func (*Mongodb_MongoInfra) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{12, 3}
}

func (x *Mongodb_MongoInfra) GetConfigMongos() *config.MongosConfigSet {
	if x != nil {
		return x.ConfigMongos
	}
	return nil
}

func (x *Mongodb_MongoInfra) GetConfigMongocfg() *config.MongoCfgConfigSet {
	if x != nil {
		return x.ConfigMongocfg
	}
	return nil
}

func (x *Mongodb_MongoInfra) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb_MongoInfra) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Host_HostParameters struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	Hidden             bool                   `protobuf:"varint,1,opt,name=hidden,proto3" json:"hidden,omitempty"`
	SecondaryDelaySecs int64                  `protobuf:"varint,2,opt,name=secondary_delay_secs,json=secondaryDelaySecs,proto3" json:"secondary_delay_secs,omitempty"`
	Priority           float64                `protobuf:"fixed64,3,opt,name=priority,proto3" json:"priority,omitempty"`
	Tags               map[string]string      `protobuf:"bytes,4,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *Host_HostParameters) Reset() {
	*x = Host_HostParameters{}
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[61]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Host_HostParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Host_HostParameters) ProtoMessage() {}

func (x *Host_HostParameters) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[61]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Host_HostParameters.ProtoReflect.Descriptor instead.
func (*Host_HostParameters) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{14, 0}
}

func (x *Host_HostParameters) GetHidden() bool {
	if x != nil {
		return x.Hidden
	}
	return false
}

func (x *Host_HostParameters) GetSecondaryDelaySecs() int64 {
	if x != nil {
		return x.SecondaryDelaySecs
	}
	return 0
}

func (x *Host_HostParameters) GetPriority() float64 {
	if x != nil {
		return x.Priority
	}
	return 0
}

func (x *Host_HostParameters) GetTags() map[string]string {
	if x != nil {
		return x.Tags
	}
	return nil
}

var File_yandex_cloud_mdb_mongodb_v1_cluster_proto protoreflect.FileDescriptor

const file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDesc = "" +
	"\n" +
	")yandex/cloud/mdb/mongodb/v1/cluster.proto\x12\x1byandex.cloud.mdb.mongodb.v1\x1a\x1fgoogle/protobuf/timestamp.proto\x1a\x1egoogle/protobuf/wrappers.proto\x1a\x1bgoogle/type/timeofday.proto\x1a0yandex/cloud/mdb/mongodb/v1/config/mongodb.proto\x1a3yandex/cloud/mdb/mongodb/v1/config/mongodb3_6.proto\x1a3yandex/cloud/mdb/mongodb/v1/config/mongodb4_0.proto\x1a3yandex/cloud/mdb/mongodb/v1/config/mongodb4_2.proto\x1a3yandex/cloud/mdb/mongodb/v1/config/mongodb4_4.proto\x1a>yandex/cloud/mdb/mongodb/v1/config/mongodb4_4_enterprise.proto\x1a3yandex/cloud/mdb/mongodb/v1/config/mongodb5_0.proto\x1a>yandex/cloud/mdb/mongodb/v1/config/mongodb5_0_enterprise.proto\x1a3yandex/cloud/mdb/mongodb/v1/config/mongodb6_0.proto\x1a>yandex/cloud/mdb/mongodb/v1/config/mongodb6_0_enterprise.proto\x1a-yandex/cloud/mdb/mongodb/v1/maintenance.proto\x1a\x1dyandex/cloud/validation.proto\"\xc8\n" +
	"\n" +
	"\aCluster\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x1b\n" +
	"\tfolder_id\x18\x02 \x01(\tR\bfolderId\x129\n" +
	"\n" +
	"created_at\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampR\tcreatedAt\x12\x12\n" +
	"\x04name\x18\x04 \x01(\tR\x04name\x12 \n" +
	"\vdescription\x18\x05 \x01(\tR\vdescription\x12H\n" +
	"\x06labels\x18\x06 \x03(\v20.yandex.cloud.mdb.mongodb.v1.Cluster.LabelsEntryR\x06labels\x12R\n" +
	"\venvironment\x18\a \x01(\x0e20.yandex.cloud.mdb.mongodb.v1.Cluster.EnvironmentR\venvironment\x12G\n" +
	"\n" +
	"monitoring\x18\b \x03(\v2'.yandex.cloud.mdb.mongodb.v1.MonitoringR\n" +
	"monitoring\x12B\n" +
	"\x06config\x18\t \x01(\v2*.yandex.cloud.mdb.mongodb.v1.ClusterConfigR\x06config\x12\x1d\n" +
	"\n" +
	"network_id\x18\n" +
	" \x01(\tR\tnetworkId\x12C\n" +
	"\x06health\x18\v \x01(\x0e2+.yandex.cloud.mdb.mongodb.v1.Cluster.HealthR\x06health\x12C\n" +
	"\x06status\x18\f \x01(\x0e2+.yandex.cloud.mdb.mongodb.v1.Cluster.StatusR\x06status\x12\x18\n" +
	"\asharded\x18\r \x01(\bR\asharded\x12]\n" +
	"\x12maintenance_window\x18\x0e \x01(\v2..yandex.cloud.mdb.mongodb.v1.MaintenanceWindowR\x11maintenanceWindow\x12^\n" +
	"\x11planned_operation\x18\x0f \x01(\v21.yandex.cloud.mdb.mongodb.v1.MaintenanceOperationR\x10plannedOperation\x12,\n" +
	"\x12security_group_ids\x18\x10 \x03(\tR\x10securityGroupIds\x12/\n" +
	"\x13deletion_protection\x18\x11 \x01(\bR\x12deletionProtection\x12Q\n" +
	"\x16disk_encryption_key_id\x18\x12 \x01(\v2\x1c.google.protobuf.StringValueR\x13diskEncryptionKeyId\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"I\n" +
	"\vEnvironment\x12\x1b\n" +
	"\x17ENVIRONMENT_UNSPECIFIED\x10\x00\x12\x0e\n" +
	"\n" +
	"PRODUCTION\x10\x01\x12\r\n" +
	"\tPRESTABLE\x10\x02\"?\n" +
	"\x06Health\x12\x12\n" +
	"\x0eHEALTH_UNKNOWN\x10\x00\x12\t\n" +
	"\x05ALIVE\x10\x01\x12\b\n" +
	"\x04DEAD\x10\x02\x12\f\n" +
	"\bDEGRADED\x10\x03\"y\n" +
	"\x06Status\x12\x12\n" +
	"\x0eSTATUS_UNKNOWN\x10\x00\x12\f\n" +
	"\bCREATING\x10\x01\x12\v\n" +
	"\aRUNNING\x10\x02\x12\t\n" +
	"\x05ERROR\x10\x03\x12\f\n" +
	"\bUPDATING\x10\x04\x12\f\n" +
	"\bSTOPPING\x10\x05\x12\v\n" +
	"\aSTOPPED\x10\x06\x12\f\n" +
	"\bSTARTING\x10\a\"V\n" +
	"\n" +
	"Monitoring\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12 \n" +
	"\vdescription\x18\x02 \x01(\tR\vdescription\x12\x12\n" +
	"\x04link\x18\x03 \x01(\tR\x04link\"\xd7\n" +
	"\n" +
	"\rClusterConfig\x12\x18\n" +
	"\aversion\x18\x01 \x01(\tR\aversion\x12B\n" +
	"\x1dfeature_compatibility_version\x18\x05 \x01(\tR\x1bfeatureCompatibilityVersion\x12K\n" +
	"\vmongodb_3_6\x18\x02 \x01(\v2'.yandex.cloud.mdb.mongodb.v1.Mongodb3_6H\x00R\vmongodb_3_6\x12K\n" +
	"\vmongodb_4_0\x18\x04 \x01(\v2'.yandex.cloud.mdb.mongodb.v1.Mongodb4_0H\x00R\vmongodb_4_0\x12K\n" +
	"\vmongodb_4_2\x18\a \x01(\v2'.yandex.cloud.mdb.mongodb.v1.Mongodb4_2H\x00R\vmongodb_4_2\x12K\n" +
	"\vmongodb_4_4\x18\b \x01(\v2'.yandex.cloud.mdb.mongodb.v1.Mongodb4_4H\x00R\vmongodb_4_4\x12K\n" +
	"\vmongodb_5_0\x18\n" +
	" \x01(\v2'.yandex.cloud.mdb.mongodb.v1.Mongodb5_0H\x00R\vmongodb_5_0\x12K\n" +
	"\vmongodb_6_0\x18\x0e \x01(\v2'.yandex.cloud.mdb.mongodb.v1.Mongodb6_0H\x00R\vmongodb_6_0\x12l\n" +
	"\x16mongodb_4_4_enterprise\x18\v \x01(\v22.yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterpriseH\x00R\x16mongodb_4_4_enterprise\x12l\n" +
	"\x16mongodb_5_0_enterprise\x18\f \x01(\v22.yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterpriseH\x00R\x16mongodb_5_0_enterprise\x12l\n" +
	"\x16mongodb_6_0_enterprise\x18\x0f \x01(\v22.yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterpriseH\x00R\x16mongodb_6_0_enterprise\x12F\n" +
	"\x13backup_window_start\x18\x03 \x01(\v2\x16.google.type.TimeOfDayR\x11backupWindowStart\x12V\n" +
	"\x19backup_retain_period_days\x18\t \x01(\v2\x1b.google.protobuf.Int64ValueR\x16backupRetainPeriodDays\x12r\n" +
	"\x17performance_diagnostics\x18\r \x01(\v29.yandex.cloud.mdb.mongodb.v1.PerformanceDiagnosticsConfigR\x16performanceDiagnostics\x12;\n" +
	"\x06access\x18\x06 \x01(\v2#.yandex.cloud.mdb.mongodb.v1.AccessR\x06access\x12K\n" +
	"\x0emongodb_config\x18\x13 \x01(\v2$.yandex.cloud.mdb.mongodb.v1.MongodbR\rmongodbConfig\x12!\n" +
	"\ffull_version\x18\x14 \x01(\tR\vfullVersionB\t\n" +
	"\amongodbJ\x04\b\x10\x10\x13\"\xd2\v\n" +
	"\n" +
	"Mongodb3_6\x12F\n" +
	"\x06mongod\x18\x01 \x01(\v2..yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongodR\x06mongod\x12L\n" +
	"\bmongocfg\x18\x02 \x01(\v20.yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoCfgR\bmongocfg\x12F\n" +
	"\x06mongos\x18\x03 \x01(\v2..yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongosR\x06mongos\x12R\n" +
	"\n" +
	"mongoinfra\x18\x04 \x01(\v22.yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoInfraR\n" +
	"mongoinfra\x1a\x84\x02\n" +
	"\x06Mongod\x12N\n" +
	"\x06config\x18\x01 \x01(\v26.yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet3_6R\x06config\x12D\n" +
	"\tresources\x18\x02 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x03 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\x1a\x88\x02\n" +
	"\bMongoCfg\x12P\n" +
	"\x06config\x18\x01 \x01(\v28.yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet3_6R\x06config\x12D\n" +
	"\tresources\x18\x02 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x03 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\x1a\x84\x02\n" +
	"\x06Mongos\x12N\n" +
	"\x06config\x18\x01 \x01(\v26.yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet3_6R\x06config\x12D\n" +
	"\tresources\x18\x02 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x03 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\x1a\xf8\x02\n" +
	"\n" +
	"MongoInfra\x12[\n" +
	"\rconfig_mongos\x18\x01 \x01(\v26.yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet3_6R\fconfigMongos\x12a\n" +
	"\x0fconfig_mongocfg\x18\x02 \x01(\v28.yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet3_6R\x0econfigMongocfg\x12D\n" +
	"\tresources\x18\x03 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x04 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\"\xd2\v\n" +
	"\n" +
	"Mongodb4_0\x12F\n" +
	"\x06mongod\x18\x01 \x01(\v2..yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongodR\x06mongod\x12L\n" +
	"\bmongocfg\x18\x02 \x01(\v20.yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoCfgR\bmongocfg\x12F\n" +
	"\x06mongos\x18\x03 \x01(\v2..yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongosR\x06mongos\x12R\n" +
	"\n" +
	"mongoinfra\x18\x04 \x01(\v22.yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoInfraR\n" +
	"mongoinfra\x1a\x84\x02\n" +
	"\x06Mongod\x12N\n" +
	"\x06config\x18\x01 \x01(\v26.yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet4_0R\x06config\x12D\n" +
	"\tresources\x18\x02 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x03 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\x1a\x88\x02\n" +
	"\bMongoCfg\x12P\n" +
	"\x06config\x18\x01 \x01(\v28.yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_0R\x06config\x12D\n" +
	"\tresources\x18\x02 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x03 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\x1a\x84\x02\n" +
	"\x06Mongos\x12N\n" +
	"\x06config\x18\x01 \x01(\v26.yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_0R\x06config\x12D\n" +
	"\tresources\x18\x02 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x03 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\x1a\xf8\x02\n" +
	"\n" +
	"MongoInfra\x12[\n" +
	"\rconfig_mongos\x18\x01 \x01(\v26.yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_0R\fconfigMongos\x12a\n" +
	"\x0fconfig_mongocfg\x18\x02 \x01(\v28.yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_0R\x0econfigMongocfg\x12D\n" +
	"\tresources\x18\x03 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x04 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\"\xd2\v\n" +
	"\n" +
	"Mongodb4_2\x12F\n" +
	"\x06mongod\x18\x01 \x01(\v2..yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongodR\x06mongod\x12L\n" +
	"\bmongocfg\x18\x02 \x01(\v20.yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoCfgR\bmongocfg\x12F\n" +
	"\x06mongos\x18\x03 \x01(\v2..yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongosR\x06mongos\x12R\n" +
	"\n" +
	"mongoinfra\x18\x04 \x01(\v22.yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoInfraR\n" +
	"mongoinfra\x1a\x84\x02\n" +
	"\x06Mongod\x12N\n" +
	"\x06config\x18\x01 \x01(\v26.yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet4_2R\x06config\x12D\n" +
	"\tresources\x18\x02 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x03 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\x1a\x88\x02\n" +
	"\bMongoCfg\x12P\n" +
	"\x06config\x18\x01 \x01(\v28.yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_2R\x06config\x12D\n" +
	"\tresources\x18\x02 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x03 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\x1a\x84\x02\n" +
	"\x06Mongos\x12N\n" +
	"\x06config\x18\x01 \x01(\v26.yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_2R\x06config\x12D\n" +
	"\tresources\x18\x02 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x03 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\x1a\xf8\x02\n" +
	"\n" +
	"MongoInfra\x12[\n" +
	"\rconfig_mongos\x18\x01 \x01(\v26.yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_2R\fconfigMongos\x12a\n" +
	"\x0fconfig_mongocfg\x18\x02 \x01(\v28.yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_2R\x0econfigMongocfg\x12D\n" +
	"\tresources\x18\x03 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x04 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\"\xd2\v\n" +
	"\n" +
	"Mongodb4_4\x12F\n" +
	"\x06mongod\x18\x01 \x01(\v2..yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongodR\x06mongod\x12L\n" +
	"\bmongocfg\x18\x02 \x01(\v20.yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongoCfgR\bmongocfg\x12F\n" +
	"\x06mongos\x18\x03 \x01(\v2..yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongosR\x06mongos\x12R\n" +
	"\n" +
	"mongoinfra\x18\x04 \x01(\v22.yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongoInfraR\n" +
	"mongoinfra\x1a\x84\x02\n" +
	"\x06Mongod\x12N\n" +
	"\x06config\x18\x01 \x01(\v26.yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet4_4R\x06config\x12D\n" +
	"\tresources\x18\x02 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x03 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\x1a\x88\x02\n" +
	"\bMongoCfg\x12P\n" +
	"\x06config\x18\x01 \x01(\v28.yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_4R\x06config\x12D\n" +
	"\tresources\x18\x02 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x03 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\x1a\x84\x02\n" +
	"\x06Mongos\x12N\n" +
	"\x06config\x18\x01 \x01(\v26.yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_4R\x06config\x12D\n" +
	"\tresources\x18\x02 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x03 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\x1a\xf8\x02\n" +
	"\n" +
	"MongoInfra\x12[\n" +
	"\rconfig_mongos\x18\x01 \x01(\v26.yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_4R\fconfigMongos\x12a\n" +
	"\x0fconfig_mongocfg\x18\x02 \x01(\v28.yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_4R\x0econfigMongocfg\x12D\n" +
	"\tresources\x18\x03 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x04 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\"\xc0\f\n" +
	"\x15Mongodb4_4_enterprise\x12Q\n" +
	"\x06mongod\x18\x01 \x01(\v29.yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.MongodR\x06mongod\x12W\n" +
	"\bmongocfg\x18\x02 \x01(\v2;.yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.MongoCfgR\bmongocfg\x12Q\n" +
	"\x06mongos\x18\x03 \x01(\v29.yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.MongosR\x06mongos\x12]\n" +
	"\n" +
	"mongoinfra\x18\x04 \x01(\v2=.yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.MongoInfraR\n" +
	"mongoinfra\x1a\x8f\x02\n" +
	"\x06Mongod\x12Y\n" +
	"\x06config\x18\x01 \x01(\v2A.yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet4_4_enterpriseR\x06config\x12D\n" +
	"\tresources\x18\x02 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x03 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\x1a\x93\x02\n" +
	"\bMongoCfg\x12[\n" +
	"\x06config\x18\x01 \x01(\v2C.yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_4_enterpriseR\x06config\x12D\n" +
	"\tresources\x18\x02 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x03 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\x1a\x8f\x02\n" +
	"\x06Mongos\x12Y\n" +
	"\x06config\x18\x01 \x01(\v2A.yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_4_enterpriseR\x06config\x12D\n" +
	"\tresources\x18\x02 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x03 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\x1a\x8e\x03\n" +
	"\n" +
	"MongoInfra\x12f\n" +
	"\rconfig_mongos\x18\x01 \x01(\v2A.yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_4_enterpriseR\fconfigMongos\x12l\n" +
	"\x0fconfig_mongocfg\x18\x02 \x01(\v2C.yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_4_enterpriseR\x0econfigMongocfg\x12D\n" +
	"\tresources\x18\x03 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x04 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\"\xd2\v\n" +
	"\n" +
	"Mongodb5_0\x12F\n" +
	"\x06mongod\x18\x01 \x01(\v2..yandex.cloud.mdb.mongodb.v1.Mongodb5_0.MongodR\x06mongod\x12L\n" +
	"\bmongocfg\x18\x02 \x01(\v20.yandex.cloud.mdb.mongodb.v1.Mongodb5_0.MongoCfgR\bmongocfg\x12F\n" +
	"\x06mongos\x18\x03 \x01(\v2..yandex.cloud.mdb.mongodb.v1.Mongodb5_0.MongosR\x06mongos\x12R\n" +
	"\n" +
	"mongoinfra\x18\x04 \x01(\v22.yandex.cloud.mdb.mongodb.v1.Mongodb5_0.MongoInfraR\n" +
	"mongoinfra\x1a\x84\x02\n" +
	"\x06Mongod\x12N\n" +
	"\x06config\x18\x01 \x01(\v26.yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet5_0R\x06config\x12D\n" +
	"\tresources\x18\x02 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x03 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\x1a\x88\x02\n" +
	"\bMongoCfg\x12P\n" +
	"\x06config\x18\x01 \x01(\v28.yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet5_0R\x06config\x12D\n" +
	"\tresources\x18\x02 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x03 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\x1a\x84\x02\n" +
	"\x06Mongos\x12N\n" +
	"\x06config\x18\x01 \x01(\v26.yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet5_0R\x06config\x12D\n" +
	"\tresources\x18\x02 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x03 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\x1a\xf8\x02\n" +
	"\n" +
	"MongoInfra\x12[\n" +
	"\rconfig_mongos\x18\x01 \x01(\v26.yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet5_0R\fconfigMongos\x12a\n" +
	"\x0fconfig_mongocfg\x18\x02 \x01(\v28.yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet5_0R\x0econfigMongocfg\x12D\n" +
	"\tresources\x18\x03 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x04 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\"\xc0\f\n" +
	"\x15Mongodb5_0_enterprise\x12Q\n" +
	"\x06mongod\x18\x01 \x01(\v29.yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.MongodR\x06mongod\x12W\n" +
	"\bmongocfg\x18\x02 \x01(\v2;.yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.MongoCfgR\bmongocfg\x12Q\n" +
	"\x06mongos\x18\x03 \x01(\v29.yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.MongosR\x06mongos\x12]\n" +
	"\n" +
	"mongoinfra\x18\x04 \x01(\v2=.yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.MongoInfraR\n" +
	"mongoinfra\x1a\x8f\x02\n" +
	"\x06Mongod\x12Y\n" +
	"\x06config\x18\x01 \x01(\v2A.yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet5_0_enterpriseR\x06config\x12D\n" +
	"\tresources\x18\x02 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x03 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\x1a\x93\x02\n" +
	"\bMongoCfg\x12[\n" +
	"\x06config\x18\x01 \x01(\v2C.yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet5_0_enterpriseR\x06config\x12D\n" +
	"\tresources\x18\x02 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x03 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\x1a\x8f\x02\n" +
	"\x06Mongos\x12Y\n" +
	"\x06config\x18\x01 \x01(\v2A.yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet5_0_enterpriseR\x06config\x12D\n" +
	"\tresources\x18\x02 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x03 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\x1a\x8e\x03\n" +
	"\n" +
	"MongoInfra\x12f\n" +
	"\rconfig_mongos\x18\x01 \x01(\v2A.yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet5_0_enterpriseR\fconfigMongos\x12l\n" +
	"\x0fconfig_mongocfg\x18\x02 \x01(\v2C.yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet5_0_enterpriseR\x0econfigMongocfg\x12D\n" +
	"\tresources\x18\x03 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x04 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\"\xd2\v\n" +
	"\n" +
	"Mongodb6_0\x12F\n" +
	"\x06mongod\x18\x01 \x01(\v2..yandex.cloud.mdb.mongodb.v1.Mongodb6_0.MongodR\x06mongod\x12L\n" +
	"\bmongocfg\x18\x02 \x01(\v20.yandex.cloud.mdb.mongodb.v1.Mongodb6_0.MongoCfgR\bmongocfg\x12F\n" +
	"\x06mongos\x18\x03 \x01(\v2..yandex.cloud.mdb.mongodb.v1.Mongodb6_0.MongosR\x06mongos\x12R\n" +
	"\n" +
	"mongoinfra\x18\x04 \x01(\v22.yandex.cloud.mdb.mongodb.v1.Mongodb6_0.MongoInfraR\n" +
	"mongoinfra\x1a\x84\x02\n" +
	"\x06Mongod\x12N\n" +
	"\x06config\x18\x01 \x01(\v26.yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet6_0R\x06config\x12D\n" +
	"\tresources\x18\x02 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x03 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\x1a\x88\x02\n" +
	"\bMongoCfg\x12P\n" +
	"\x06config\x18\x01 \x01(\v28.yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet6_0R\x06config\x12D\n" +
	"\tresources\x18\x02 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x03 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\x1a\x84\x02\n" +
	"\x06Mongos\x12N\n" +
	"\x06config\x18\x01 \x01(\v26.yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet6_0R\x06config\x12D\n" +
	"\tresources\x18\x02 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x03 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\x1a\xf8\x02\n" +
	"\n" +
	"MongoInfra\x12[\n" +
	"\rconfig_mongos\x18\x01 \x01(\v26.yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet6_0R\fconfigMongos\x12a\n" +
	"\x0fconfig_mongocfg\x18\x02 \x01(\v28.yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet6_0R\x0econfigMongocfg\x12D\n" +
	"\tresources\x18\x03 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x04 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\"\xc0\f\n" +
	"\x15Mongodb6_0_enterprise\x12Q\n" +
	"\x06mongod\x18\x01 \x01(\v29.yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.MongodR\x06mongod\x12W\n" +
	"\bmongocfg\x18\x02 \x01(\v2;.yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.MongoCfgR\bmongocfg\x12Q\n" +
	"\x06mongos\x18\x03 \x01(\v29.yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.MongosR\x06mongos\x12]\n" +
	"\n" +
	"mongoinfra\x18\x04 \x01(\v2=.yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.MongoInfraR\n" +
	"mongoinfra\x1a\x8f\x02\n" +
	"\x06Mongod\x12Y\n" +
	"\x06config\x18\x01 \x01(\v2A.yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet6_0_enterpriseR\x06config\x12D\n" +
	"\tresources\x18\x02 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x03 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\x1a\x93\x02\n" +
	"\bMongoCfg\x12[\n" +
	"\x06config\x18\x01 \x01(\v2C.yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet6_0_enterpriseR\x06config\x12D\n" +
	"\tresources\x18\x02 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x03 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\x1a\x8f\x02\n" +
	"\x06Mongos\x12Y\n" +
	"\x06config\x18\x01 \x01(\v2A.yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet6_0_enterpriseR\x06config\x12D\n" +
	"\tresources\x18\x02 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x03 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\x1a\x8e\x03\n" +
	"\n" +
	"MongoInfra\x12f\n" +
	"\rconfig_mongos\x18\x01 \x01(\v2A.yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet6_0_enterpriseR\fconfigMongos\x12l\n" +
	"\x0fconfig_mongocfg\x18\x02 \x01(\v2C.yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet6_0_enterpriseR\x0econfigMongocfg\x12D\n" +
	"\tresources\x18\x03 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x04 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\"\xb4\v\n" +
	"\aMongodb\x12C\n" +
	"\x06mongod\x18\x01 \x01(\v2+.yandex.cloud.mdb.mongodb.v1.Mongodb.MongodR\x06mongod\x12I\n" +
	"\bmongocfg\x18\x02 \x01(\v2-.yandex.cloud.mdb.mongodb.v1.Mongodb.MongoCfgR\bmongocfg\x12C\n" +
	"\x06mongos\x18\x03 \x01(\v2+.yandex.cloud.mdb.mongodb.v1.Mongodb.MongosR\x06mongos\x12O\n" +
	"\n" +
	"mongoinfra\x18\x04 \x01(\v2/.yandex.cloud.mdb.mongodb.v1.Mongodb.MongoInfraR\n" +
	"mongoinfra\x1a\x81\x02\n" +
	"\x06Mongod\x12K\n" +
	"\x06config\x18\x01 \x01(\v23.yandex.cloud.mdb.mongodb.v1.config.MongodConfigSetR\x06config\x12D\n" +
	"\tresources\x18\x02 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x03 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\x1a\x85\x02\n" +
	"\bMongoCfg\x12M\n" +
	"\x06config\x18\x01 \x01(\v25.yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSetR\x06config\x12D\n" +
	"\tresources\x18\x02 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x03 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\x1a\x81\x02\n" +
	"\x06Mongos\x12K\n" +
	"\x06config\x18\x01 \x01(\v23.yandex.cloud.mdb.mongodb.v1.config.MongosConfigSetR\x06config\x12D\n" +
	"\tresources\x18\x02 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x03 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\x1a\xf2\x02\n" +
	"\n" +
	"MongoInfra\x12X\n" +
	"\rconfig_mongos\x18\x01 \x01(\v23.yandex.cloud.mdb.mongodb.v1.config.MongosConfigSetR\fconfigMongos\x12^\n" +
	"\x0fconfig_mongocfg\x18\x02 \x01(\v25.yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSetR\x0econfigMongocfg\x12D\n" +
	"\tresources\x18\x03 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12d\n" +
	"\x15disk_size_autoscaling\x18\x04 \x01(\v20.yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscalingR\x13diskSizeAutoscaling\":\n" +
	"\x05Shard\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x1d\n" +
	"\n" +
	"cluster_id\x18\x02 \x01(\tR\tclusterId\"\xa2\b\n" +
	"\x04Host\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x1d\n" +
	"\n" +
	"cluster_id\x18\x02 \x01(\tR\tclusterId\x12\x17\n" +
	"\azone_id\x18\x03 \x01(\tR\x06zoneId\x12D\n" +
	"\tresources\x18\x04 \x01(\v2&.yandex.cloud.mdb.mongodb.v1.ResourcesR\tresources\x12:\n" +
	"\x04role\x18\x05 \x01(\x0e2&.yandex.cloud.mdb.mongodb.v1.Host.RoleR\x04role\x12@\n" +
	"\x06health\x18\x06 \x01(\x0e2(.yandex.cloud.mdb.mongodb.v1.Host.HealthR\x06health\x12@\n" +
	"\bservices\x18\a \x03(\v2$.yandex.cloud.mdb.mongodb.v1.ServiceR\bservices\x12\x1b\n" +
	"\tsubnet_id\x18\b \x01(\tR\bsubnetId\x12(\n" +
	"\x10assign_public_ip\x18\t \x01(\bR\x0eassignPublicIp\x12\x1d\n" +
	"\n" +
	"shard_name\x18\n" +
	" \x01(\tR\tshardName\x12:\n" +
	"\x04type\x18\v \x01(\x0e2&.yandex.cloud.mdb.mongodb.v1.Host.TypeR\x04type\x12Y\n" +
	"\x0fhost_parameters\x18\f \x01(\v20.yandex.cloud.mdb.mongodb.v1.Host.HostParametersR\x0ehostParameters\x1a\xff\x01\n" +
	"\x0eHostParameters\x12\x16\n" +
	"\x06hidden\x18\x01 \x01(\bR\x06hidden\x120\n" +
	"\x14secondary_delay_secs\x18\x02 \x01(\x03R\x12secondaryDelaySecs\x12\x1a\n" +
	"\bpriority\x18\x03 \x01(\x01R\bpriority\x12N\n" +
	"\x04tags\x18\x04 \x03(\v2:.yandex.cloud.mdb.mongodb.v1.Host.HostParameters.TagsEntryR\x04tags\x1a7\n" +
	"\tTagsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"R\n" +
	"\x04Type\x12\x14\n" +
	"\x10TYPE_UNSPECIFIED\x10\x00\x12\n" +
	"\n" +
	"\x06MONGOD\x10\x01\x12\n" +
	"\n" +
	"\x06MONGOS\x10\x02\x12\f\n" +
	"\bMONGOCFG\x10\x03\x12\x0e\n" +
	"\n" +
	"MONGOINFRA\x10\x04\"4\n" +
	"\x04Role\x12\x10\n" +
	"\fROLE_UNKNOWN\x10\x00\x12\v\n" +
	"\aPRIMARY\x10\x01\x12\r\n" +
	"\tSECONDARY\x10\x02\"?\n" +
	"\x06Health\x12\x12\n" +
	"\x0eHEALTH_UNKNOWN\x10\x00\x12\t\n" +
	"\x05ALIVE\x10\x01\x12\b\n" +
	"\x04DEAD\x10\x02\x12\f\n" +
	"\bDEGRADED\x10\x03\"\x84\x02\n" +
	"\aService\x12=\n" +
	"\x04type\x18\x01 \x01(\x0e2).yandex.cloud.mdb.mongodb.v1.Service.TypeR\x04type\x12C\n" +
	"\x06health\x18\x02 \x01(\x0e2+.yandex.cloud.mdb.mongodb.v1.Service.HealthR\x06health\"B\n" +
	"\x04Type\x12\x14\n" +
	"\x10TYPE_UNSPECIFIED\x10\x00\x12\n" +
	"\n" +
	"\x06MONGOD\x10\x01\x12\n" +
	"\n" +
	"\x06MONGOS\x10\x02\x12\f\n" +
	"\bMONGOCFG\x10\x03\"1\n" +
	"\x06Health\x12\x12\n" +
	"\x0eHEALTH_UNKNOWN\x10\x00\x12\t\n" +
	"\x05ALIVE\x10\x01\x12\b\n" +
	"\x04DEAD\x10\x02\"x\n" +
	"\tResources\x12,\n" +
	"\x12resource_preset_id\x18\x01 \x01(\tR\x10resourcePresetId\x12\x1b\n" +
	"\tdisk_size\x18\x02 \x01(\x03R\bdiskSize\x12 \n" +
	"\fdisk_type_id\x18\x03 \x01(\tR\n" +
	"diskTypeId\"c\n" +
	"\x06Access\x12\x1b\n" +
	"\tdata_lens\x18\x01 \x01(\bR\bdataLens\x12\x17\n" +
	"\aweb_sql\x18\x02 \x01(\bR\x06webSql\x12#\n" +
	"\rdata_transfer\x18\x03 \x01(\bR\fdataTransfer\"K\n" +
	"\x1cPerformanceDiagnosticsConfig\x12+\n" +
	"\x11profiling_enabled\x18\x01 \x01(\bR\x10profilingEnabled\"\xa6\x02\n" +
	"\x13DiskSizeAutoscaling\x12b\n" +
	"\x17planned_usage_threshold\x18\x01 \x01(\v2\x1b.google.protobuf.Int64ValueB\r\xe8\xc71\x00\xfa\xc71\x050-100R\x15plannedUsageThreshold\x12f\n" +
	"\x19emergency_usage_threshold\x18\x02 \x01(\v2\x1b.google.protobuf.Int64ValueB\r\xe8\xc71\x00\xfa\xc71\x050-100R\x17emergencyUsageThreshold\x12C\n" +
	"\x0fdisk_size_limit\x18\x03 \x01(\v2\x1b.google.protobuf.Int64ValueR\rdiskSizeLimitBj\n" +
	"\x1fyandex.cloud.api.mdb.mongodb.v1ZGgithub.com/yandex-cloud/go-genproto/yandex/cloud/mdb/mongodb/v1;mongodbb\x06proto3"

var (
	file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescOnce sync.Once
	file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescData []byte
)

func file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP() []byte {
	file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDesc), len(file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDesc)))
	})
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescData
}

var file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes = make([]protoimpl.EnumInfo, 8)
var file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes = make([]protoimpl.MessageInfo, 63)
var file_yandex_cloud_mdb_mongodb_v1_cluster_proto_goTypes = []any{
	(Cluster_Environment)(0),                      // 0: yandex.cloud.mdb.mongodb.v1.Cluster.Environment
	(Cluster_Health)(0),                           // 1: yandex.cloud.mdb.mongodb.v1.Cluster.Health
	(Cluster_Status)(0),                           // 2: yandex.cloud.mdb.mongodb.v1.Cluster.Status
	(Host_Type)(0),                                // 3: yandex.cloud.mdb.mongodb.v1.Host.Type
	(Host_Role)(0),                                // 4: yandex.cloud.mdb.mongodb.v1.Host.Role
	(Host_Health)(0),                              // 5: yandex.cloud.mdb.mongodb.v1.Host.Health
	(Service_Type)(0),                             // 6: yandex.cloud.mdb.mongodb.v1.Service.Type
	(Service_Health)(0),                           // 7: yandex.cloud.mdb.mongodb.v1.Service.Health
	(*Cluster)(nil),                               // 8: yandex.cloud.mdb.mongodb.v1.Cluster
	(*Monitoring)(nil),                            // 9: yandex.cloud.mdb.mongodb.v1.Monitoring
	(*ClusterConfig)(nil),                         // 10: yandex.cloud.mdb.mongodb.v1.ClusterConfig
	(*Mongodb3_6)(nil),                            // 11: yandex.cloud.mdb.mongodb.v1.Mongodb3_6
	(*Mongodb4_0)(nil),                            // 12: yandex.cloud.mdb.mongodb.v1.Mongodb4_0
	(*Mongodb4_2)(nil),                            // 13: yandex.cloud.mdb.mongodb.v1.Mongodb4_2
	(*Mongodb4_4)(nil),                            // 14: yandex.cloud.mdb.mongodb.v1.Mongodb4_4
	(*Mongodb4_4Enterprise)(nil),                  // 15: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise
	(*Mongodb5_0)(nil),                            // 16: yandex.cloud.mdb.mongodb.v1.Mongodb5_0
	(*Mongodb5_0Enterprise)(nil),                  // 17: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise
	(*Mongodb6_0)(nil),                            // 18: yandex.cloud.mdb.mongodb.v1.Mongodb6_0
	(*Mongodb6_0Enterprise)(nil),                  // 19: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise
	(*Mongodb)(nil),                               // 20: yandex.cloud.mdb.mongodb.v1.Mongodb
	(*Shard)(nil),                                 // 21: yandex.cloud.mdb.mongodb.v1.Shard
	(*Host)(nil),                                  // 22: yandex.cloud.mdb.mongodb.v1.Host
	(*Service)(nil),                               // 23: yandex.cloud.mdb.mongodb.v1.Service
	(*Resources)(nil),                             // 24: yandex.cloud.mdb.mongodb.v1.Resources
	(*Access)(nil),                                // 25: yandex.cloud.mdb.mongodb.v1.Access
	(*PerformanceDiagnosticsConfig)(nil),          // 26: yandex.cloud.mdb.mongodb.v1.PerformanceDiagnosticsConfig
	(*DiskSizeAutoscaling)(nil),                   // 27: yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	nil,                                           // 28: yandex.cloud.mdb.mongodb.v1.Cluster.LabelsEntry
	(*Mongodb3_6_Mongod)(nil),                     // 29: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongod
	(*Mongodb3_6_MongoCfg)(nil),                   // 30: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoCfg
	(*Mongodb3_6_Mongos)(nil),                     // 31: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongos
	(*Mongodb3_6_MongoInfra)(nil),                 // 32: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoInfra
	(*Mongodb4_0_Mongod)(nil),                     // 33: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.Mongod
	(*Mongodb4_0_MongoCfg)(nil),                   // 34: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoCfg
	(*Mongodb4_0_Mongos)(nil),                     // 35: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.Mongos
	(*Mongodb4_0_MongoInfra)(nil),                 // 36: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoInfra
	(*Mongodb4_2_Mongod)(nil),                     // 37: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.Mongod
	(*Mongodb4_2_MongoCfg)(nil),                   // 38: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoCfg
	(*Mongodb4_2_Mongos)(nil),                     // 39: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.Mongos
	(*Mongodb4_2_MongoInfra)(nil),                 // 40: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoInfra
	(*Mongodb4_4_Mongod)(nil),                     // 41: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.Mongod
	(*Mongodb4_4_MongoCfg)(nil),                   // 42: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongoCfg
	(*Mongodb4_4_Mongos)(nil),                     // 43: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.Mongos
	(*Mongodb4_4_MongoInfra)(nil),                 // 44: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongoInfra
	(*Mongodb4_4Enterprise_Mongod)(nil),           // 45: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.Mongod
	(*Mongodb4_4Enterprise_MongoCfg)(nil),         // 46: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.MongoCfg
	(*Mongodb4_4Enterprise_Mongos)(nil),           // 47: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.Mongos
	(*Mongodb4_4Enterprise_MongoInfra)(nil),       // 48: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.MongoInfra
	(*Mongodb5_0_Mongod)(nil),                     // 49: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.Mongod
	(*Mongodb5_0_MongoCfg)(nil),                   // 50: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.MongoCfg
	(*Mongodb5_0_Mongos)(nil),                     // 51: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.Mongos
	(*Mongodb5_0_MongoInfra)(nil),                 // 52: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.MongoInfra
	(*Mongodb5_0Enterprise_Mongod)(nil),           // 53: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.Mongod
	(*Mongodb5_0Enterprise_MongoCfg)(nil),         // 54: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.MongoCfg
	(*Mongodb5_0Enterprise_Mongos)(nil),           // 55: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.Mongos
	(*Mongodb5_0Enterprise_MongoInfra)(nil),       // 56: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.MongoInfra
	(*Mongodb6_0_Mongod)(nil),                     // 57: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.Mongod
	(*Mongodb6_0_MongoCfg)(nil),                   // 58: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.MongoCfg
	(*Mongodb6_0_Mongos)(nil),                     // 59: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.Mongos
	(*Mongodb6_0_MongoInfra)(nil),                 // 60: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.MongoInfra
	(*Mongodb6_0Enterprise_Mongod)(nil),           // 61: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.Mongod
	(*Mongodb6_0Enterprise_MongoCfg)(nil),         // 62: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.MongoCfg
	(*Mongodb6_0Enterprise_Mongos)(nil),           // 63: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.Mongos
	(*Mongodb6_0Enterprise_MongoInfra)(nil),       // 64: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.MongoInfra
	(*Mongodb_Mongod)(nil),                        // 65: yandex.cloud.mdb.mongodb.v1.Mongodb.Mongod
	(*Mongodb_MongoCfg)(nil),                      // 66: yandex.cloud.mdb.mongodb.v1.Mongodb.MongoCfg
	(*Mongodb_Mongos)(nil),                        // 67: yandex.cloud.mdb.mongodb.v1.Mongodb.Mongos
	(*Mongodb_MongoInfra)(nil),                    // 68: yandex.cloud.mdb.mongodb.v1.Mongodb.MongoInfra
	(*Host_HostParameters)(nil),                   // 69: yandex.cloud.mdb.mongodb.v1.Host.HostParameters
	nil,                                           // 70: yandex.cloud.mdb.mongodb.v1.Host.HostParameters.TagsEntry
	(*timestamppb.Timestamp)(nil),                 // 71: google.protobuf.Timestamp
	(*MaintenanceWindow)(nil),                     // 72: yandex.cloud.mdb.mongodb.v1.MaintenanceWindow
	(*MaintenanceOperation)(nil),                  // 73: yandex.cloud.mdb.mongodb.v1.MaintenanceOperation
	(*wrapperspb.StringValue)(nil),                // 74: google.protobuf.StringValue
	(*timeofday.TimeOfDay)(nil),                   // 75: google.type.TimeOfDay
	(*wrapperspb.Int64Value)(nil),                 // 76: google.protobuf.Int64Value
	(*config.MongodConfigSet3_6)(nil),             // 77: yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet3_6
	(*config.MongoCfgConfigSet3_6)(nil),           // 78: yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet3_6
	(*config.MongosConfigSet3_6)(nil),             // 79: yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet3_6
	(*config.MongodConfigSet4_0)(nil),             // 80: yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet4_0
	(*config.MongoCfgConfigSet4_0)(nil),           // 81: yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_0
	(*config.MongosConfigSet4_0)(nil),             // 82: yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_0
	(*config.MongodConfigSet4_2)(nil),             // 83: yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet4_2
	(*config.MongoCfgConfigSet4_2)(nil),           // 84: yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_2
	(*config.MongosConfigSet4_2)(nil),             // 85: yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_2
	(*config.MongodConfigSet4_4)(nil),             // 86: yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet4_4
	(*config.MongoCfgConfigSet4_4)(nil),           // 87: yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_4
	(*config.MongosConfigSet4_4)(nil),             // 88: yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_4
	(*config.MongodConfigSet4_4Enterprise)(nil),   // 89: yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet4_4_enterprise
	(*config.MongoCfgConfigSet4_4Enterprise)(nil), // 90: yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_4_enterprise
	(*config.MongosConfigSet4_4Enterprise)(nil),   // 91: yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_4_enterprise
	(*config.MongodConfigSet5_0)(nil),             // 92: yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet5_0
	(*config.MongoCfgConfigSet5_0)(nil),           // 93: yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet5_0
	(*config.MongosConfigSet5_0)(nil),             // 94: yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet5_0
	(*config.MongodConfigSet5_0Enterprise)(nil),   // 95: yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet5_0_enterprise
	(*config.MongoCfgConfigSet5_0Enterprise)(nil), // 96: yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet5_0_enterprise
	(*config.MongosConfigSet5_0Enterprise)(nil),   // 97: yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet5_0_enterprise
	(*config.MongodConfigSet6_0)(nil),             // 98: yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet6_0
	(*config.MongoCfgConfigSet6_0)(nil),           // 99: yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet6_0
	(*config.MongosConfigSet6_0)(nil),             // 100: yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet6_0
	(*config.MongodConfigSet6_0Enterprise)(nil),   // 101: yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet6_0_enterprise
	(*config.MongoCfgConfigSet6_0Enterprise)(nil), // 102: yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet6_0_enterprise
	(*config.MongosConfigSet6_0Enterprise)(nil),   // 103: yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet6_0_enterprise
	(*config.MongodConfigSet)(nil),                // 104: yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet
	(*config.MongoCfgConfigSet)(nil),              // 105: yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet
	(*config.MongosConfigSet)(nil),                // 106: yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet
}
var file_yandex_cloud_mdb_mongodb_v1_cluster_proto_depIdxs = []int32{
	71,  // 0: yandex.cloud.mdb.mongodb.v1.Cluster.created_at:type_name -> google.protobuf.Timestamp
	28,  // 1: yandex.cloud.mdb.mongodb.v1.Cluster.labels:type_name -> yandex.cloud.mdb.mongodb.v1.Cluster.LabelsEntry
	0,   // 2: yandex.cloud.mdb.mongodb.v1.Cluster.environment:type_name -> yandex.cloud.mdb.mongodb.v1.Cluster.Environment
	9,   // 3: yandex.cloud.mdb.mongodb.v1.Cluster.monitoring:type_name -> yandex.cloud.mdb.mongodb.v1.Monitoring
	10,  // 4: yandex.cloud.mdb.mongodb.v1.Cluster.config:type_name -> yandex.cloud.mdb.mongodb.v1.ClusterConfig
	1,   // 5: yandex.cloud.mdb.mongodb.v1.Cluster.health:type_name -> yandex.cloud.mdb.mongodb.v1.Cluster.Health
	2,   // 6: yandex.cloud.mdb.mongodb.v1.Cluster.status:type_name -> yandex.cloud.mdb.mongodb.v1.Cluster.Status
	72,  // 7: yandex.cloud.mdb.mongodb.v1.Cluster.maintenance_window:type_name -> yandex.cloud.mdb.mongodb.v1.MaintenanceWindow
	73,  // 8: yandex.cloud.mdb.mongodb.v1.Cluster.planned_operation:type_name -> yandex.cloud.mdb.mongodb.v1.MaintenanceOperation
	74,  // 9: yandex.cloud.mdb.mongodb.v1.Cluster.disk_encryption_key_id:type_name -> google.protobuf.StringValue
	11,  // 10: yandex.cloud.mdb.mongodb.v1.ClusterConfig.mongodb_3_6:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb3_6
	12,  // 11: yandex.cloud.mdb.mongodb.v1.ClusterConfig.mongodb_4_0:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_0
	13,  // 12: yandex.cloud.mdb.mongodb.v1.ClusterConfig.mongodb_4_2:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_2
	14,  // 13: yandex.cloud.mdb.mongodb.v1.ClusterConfig.mongodb_4_4:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_4
	16,  // 14: yandex.cloud.mdb.mongodb.v1.ClusterConfig.mongodb_5_0:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb5_0
	18,  // 15: yandex.cloud.mdb.mongodb.v1.ClusterConfig.mongodb_6_0:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb6_0
	15,  // 16: yandex.cloud.mdb.mongodb.v1.ClusterConfig.mongodb_4_4_enterprise:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise
	17,  // 17: yandex.cloud.mdb.mongodb.v1.ClusterConfig.mongodb_5_0_enterprise:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise
	19,  // 18: yandex.cloud.mdb.mongodb.v1.ClusterConfig.mongodb_6_0_enterprise:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise
	75,  // 19: yandex.cloud.mdb.mongodb.v1.ClusterConfig.backup_window_start:type_name -> google.type.TimeOfDay
	76,  // 20: yandex.cloud.mdb.mongodb.v1.ClusterConfig.backup_retain_period_days:type_name -> google.protobuf.Int64Value
	26,  // 21: yandex.cloud.mdb.mongodb.v1.ClusterConfig.performance_diagnostics:type_name -> yandex.cloud.mdb.mongodb.v1.PerformanceDiagnosticsConfig
	25,  // 22: yandex.cloud.mdb.mongodb.v1.ClusterConfig.access:type_name -> yandex.cloud.mdb.mongodb.v1.Access
	20,  // 23: yandex.cloud.mdb.mongodb.v1.ClusterConfig.mongodb_config:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb
	29,  // 24: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.mongod:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongod
	30,  // 25: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoCfg
	31,  // 26: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.mongos:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongos
	32,  // 27: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.mongoinfra:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoInfra
	33,  // 28: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.mongod:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_0.Mongod
	34,  // 29: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoCfg
	35,  // 30: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.mongos:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_0.Mongos
	36,  // 31: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.mongoinfra:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoInfra
	37,  // 32: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.mongod:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_2.Mongod
	38,  // 33: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoCfg
	39,  // 34: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.mongos:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_2.Mongos
	40,  // 35: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.mongoinfra:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoInfra
	41,  // 36: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.mongod:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_4.Mongod
	42,  // 37: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongoCfg
	43,  // 38: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.mongos:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_4.Mongos
	44,  // 39: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.mongoinfra:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongoInfra
	45,  // 40: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.mongod:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.Mongod
	46,  // 41: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.MongoCfg
	47,  // 42: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.mongos:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.Mongos
	48,  // 43: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.mongoinfra:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.MongoInfra
	49,  // 44: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.mongod:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb5_0.Mongod
	50,  // 45: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb5_0.MongoCfg
	51,  // 46: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.mongos:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb5_0.Mongos
	52,  // 47: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.mongoinfra:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb5_0.MongoInfra
	53,  // 48: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.mongod:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.Mongod
	54,  // 49: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.MongoCfg
	55,  // 50: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.mongos:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.Mongos
	56,  // 51: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.mongoinfra:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.MongoInfra
	57,  // 52: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.mongod:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb6_0.Mongod
	58,  // 53: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb6_0.MongoCfg
	59,  // 54: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.mongos:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb6_0.Mongos
	60,  // 55: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.mongoinfra:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb6_0.MongoInfra
	61,  // 56: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.mongod:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.Mongod
	62,  // 57: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.MongoCfg
	63,  // 58: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.mongos:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.Mongos
	64,  // 59: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.mongoinfra:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.MongoInfra
	65,  // 60: yandex.cloud.mdb.mongodb.v1.Mongodb.mongod:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb.Mongod
	66,  // 61: yandex.cloud.mdb.mongodb.v1.Mongodb.mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb.MongoCfg
	67,  // 62: yandex.cloud.mdb.mongodb.v1.Mongodb.mongos:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb.Mongos
	68,  // 63: yandex.cloud.mdb.mongodb.v1.Mongodb.mongoinfra:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb.MongoInfra
	24,  // 64: yandex.cloud.mdb.mongodb.v1.Host.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	4,   // 65: yandex.cloud.mdb.mongodb.v1.Host.role:type_name -> yandex.cloud.mdb.mongodb.v1.Host.Role
	5,   // 66: yandex.cloud.mdb.mongodb.v1.Host.health:type_name -> yandex.cloud.mdb.mongodb.v1.Host.Health
	23,  // 67: yandex.cloud.mdb.mongodb.v1.Host.services:type_name -> yandex.cloud.mdb.mongodb.v1.Service
	3,   // 68: yandex.cloud.mdb.mongodb.v1.Host.type:type_name -> yandex.cloud.mdb.mongodb.v1.Host.Type
	69,  // 69: yandex.cloud.mdb.mongodb.v1.Host.host_parameters:type_name -> yandex.cloud.mdb.mongodb.v1.Host.HostParameters
	6,   // 70: yandex.cloud.mdb.mongodb.v1.Service.type:type_name -> yandex.cloud.mdb.mongodb.v1.Service.Type
	7,   // 71: yandex.cloud.mdb.mongodb.v1.Service.health:type_name -> yandex.cloud.mdb.mongodb.v1.Service.Health
	76,  // 72: yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling.planned_usage_threshold:type_name -> google.protobuf.Int64Value
	76,  // 73: yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling.emergency_usage_threshold:type_name -> google.protobuf.Int64Value
	76,  // 74: yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling.disk_size_limit:type_name -> google.protobuf.Int64Value
	77,  // 75: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongod.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet3_6
	24,  // 76: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongod.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 77: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongod.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	78,  // 78: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoCfg.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet3_6
	24,  // 79: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoCfg.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 80: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoCfg.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	79,  // 81: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongos.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet3_6
	24,  // 82: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongos.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 83: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongos.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	79,  // 84: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoInfra.config_mongos:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet3_6
	78,  // 85: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoInfra.config_mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet3_6
	24,  // 86: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoInfra.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 87: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoInfra.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	80,  // 88: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.Mongod.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet4_0
	24,  // 89: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.Mongod.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 90: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.Mongod.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	81,  // 91: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoCfg.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_0
	24,  // 92: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoCfg.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 93: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoCfg.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	82,  // 94: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.Mongos.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_0
	24,  // 95: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.Mongos.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 96: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.Mongos.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	82,  // 97: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoInfra.config_mongos:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_0
	81,  // 98: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoInfra.config_mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_0
	24,  // 99: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoInfra.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 100: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoInfra.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	83,  // 101: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.Mongod.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet4_2
	24,  // 102: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.Mongod.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 103: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.Mongod.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	84,  // 104: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoCfg.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_2
	24,  // 105: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoCfg.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 106: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoCfg.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	85,  // 107: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.Mongos.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_2
	24,  // 108: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.Mongos.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 109: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.Mongos.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	85,  // 110: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoInfra.config_mongos:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_2
	84,  // 111: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoInfra.config_mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_2
	24,  // 112: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoInfra.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 113: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoInfra.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	86,  // 114: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.Mongod.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet4_4
	24,  // 115: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.Mongod.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 116: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.Mongod.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	87,  // 117: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongoCfg.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_4
	24,  // 118: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongoCfg.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 119: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongoCfg.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	88,  // 120: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.Mongos.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_4
	24,  // 121: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.Mongos.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 122: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.Mongos.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	88,  // 123: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongoInfra.config_mongos:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_4
	87,  // 124: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongoInfra.config_mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_4
	24,  // 125: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongoInfra.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 126: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongoInfra.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	89,  // 127: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.Mongod.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet4_4_enterprise
	24,  // 128: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.Mongod.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 129: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.Mongod.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	90,  // 130: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.MongoCfg.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_4_enterprise
	24,  // 131: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.MongoCfg.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 132: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.MongoCfg.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	91,  // 133: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.Mongos.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_4_enterprise
	24,  // 134: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.Mongos.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 135: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.Mongos.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	91,  // 136: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.MongoInfra.config_mongos:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_4_enterprise
	90,  // 137: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.MongoInfra.config_mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_4_enterprise
	24,  // 138: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.MongoInfra.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 139: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.MongoInfra.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	92,  // 140: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.Mongod.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet5_0
	24,  // 141: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.Mongod.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 142: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.Mongod.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	93,  // 143: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.MongoCfg.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet5_0
	24,  // 144: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.MongoCfg.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 145: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.MongoCfg.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	94,  // 146: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.Mongos.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet5_0
	24,  // 147: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.Mongos.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 148: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.Mongos.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	94,  // 149: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.MongoInfra.config_mongos:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet5_0
	93,  // 150: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.MongoInfra.config_mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet5_0
	24,  // 151: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.MongoInfra.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 152: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.MongoInfra.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	95,  // 153: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.Mongod.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet5_0_enterprise
	24,  // 154: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.Mongod.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 155: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.Mongod.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	96,  // 156: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.MongoCfg.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet5_0_enterprise
	24,  // 157: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.MongoCfg.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 158: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.MongoCfg.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	97,  // 159: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.Mongos.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet5_0_enterprise
	24,  // 160: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.Mongos.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 161: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.Mongos.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	97,  // 162: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.MongoInfra.config_mongos:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet5_0_enterprise
	96,  // 163: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.MongoInfra.config_mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet5_0_enterprise
	24,  // 164: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.MongoInfra.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 165: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.MongoInfra.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	98,  // 166: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.Mongod.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet6_0
	24,  // 167: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.Mongod.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 168: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.Mongod.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	99,  // 169: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.MongoCfg.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet6_0
	24,  // 170: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.MongoCfg.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 171: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.MongoCfg.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	100, // 172: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.Mongos.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet6_0
	24,  // 173: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.Mongos.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 174: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.Mongos.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	100, // 175: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.MongoInfra.config_mongos:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet6_0
	99,  // 176: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.MongoInfra.config_mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet6_0
	24,  // 177: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.MongoInfra.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 178: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.MongoInfra.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	101, // 179: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.Mongod.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet6_0_enterprise
	24,  // 180: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.Mongod.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 181: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.Mongod.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	102, // 182: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.MongoCfg.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet6_0_enterprise
	24,  // 183: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.MongoCfg.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 184: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.MongoCfg.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	103, // 185: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.Mongos.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet6_0_enterprise
	24,  // 186: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.Mongos.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 187: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.Mongos.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	103, // 188: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.MongoInfra.config_mongos:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet6_0_enterprise
	102, // 189: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.MongoInfra.config_mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet6_0_enterprise
	24,  // 190: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.MongoInfra.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 191: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.MongoInfra.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	104, // 192: yandex.cloud.mdb.mongodb.v1.Mongodb.Mongod.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet
	24,  // 193: yandex.cloud.mdb.mongodb.v1.Mongodb.Mongod.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 194: yandex.cloud.mdb.mongodb.v1.Mongodb.Mongod.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	105, // 195: yandex.cloud.mdb.mongodb.v1.Mongodb.MongoCfg.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet
	24,  // 196: yandex.cloud.mdb.mongodb.v1.Mongodb.MongoCfg.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 197: yandex.cloud.mdb.mongodb.v1.Mongodb.MongoCfg.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	106, // 198: yandex.cloud.mdb.mongodb.v1.Mongodb.Mongos.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet
	24,  // 199: yandex.cloud.mdb.mongodb.v1.Mongodb.Mongos.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 200: yandex.cloud.mdb.mongodb.v1.Mongodb.Mongos.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	106, // 201: yandex.cloud.mdb.mongodb.v1.Mongodb.MongoInfra.config_mongos:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet
	105, // 202: yandex.cloud.mdb.mongodb.v1.Mongodb.MongoInfra.config_mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet
	24,  // 203: yandex.cloud.mdb.mongodb.v1.Mongodb.MongoInfra.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 204: yandex.cloud.mdb.mongodb.v1.Mongodb.MongoInfra.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	70,  // 205: yandex.cloud.mdb.mongodb.v1.Host.HostParameters.tags:type_name -> yandex.cloud.mdb.mongodb.v1.Host.HostParameters.TagsEntry
	206, // [206:206] is the sub-list for method output_type
	206, // [206:206] is the sub-list for method input_type
	206, // [206:206] is the sub-list for extension type_name
	206, // [206:206] is the sub-list for extension extendee
	0,   // [0:206] is the sub-list for field type_name
}

func init() { file_yandex_cloud_mdb_mongodb_v1_cluster_proto_init() }
func file_yandex_cloud_mdb_mongodb_v1_cluster_proto_init() {
	if File_yandex_cloud_mdb_mongodb_v1_cluster_proto != nil {
		return
	}
	file_yandex_cloud_mdb_mongodb_v1_maintenance_proto_init()
	file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[2].OneofWrappers = []any{
		(*ClusterConfig_Mongodb_3_6)(nil),
		(*ClusterConfig_Mongodb_4_0)(nil),
		(*ClusterConfig_Mongodb_4_2)(nil),
		(*ClusterConfig_Mongodb_4_4)(nil),
		(*ClusterConfig_Mongodb_5_0)(nil),
		(*ClusterConfig_Mongodb_6_0)(nil),
		(*ClusterConfig_Mongodb_4_4Enterprise)(nil),
		(*ClusterConfig_Mongodb_5_0Enterprise)(nil),
		(*ClusterConfig_Mongodb_6_0Enterprise)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDesc), len(file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDesc)),
			NumEnums:      8,
			NumMessages:   63,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_mdb_mongodb_v1_cluster_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_mdb_mongodb_v1_cluster_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes,
	}.Build()
	File_yandex_cloud_mdb_mongodb_v1_cluster_proto = out.File
	file_yandex_cloud_mdb_mongodb_v1_cluster_proto_goTypes = nil
	file_yandex_cloud_mdb_mongodb_v1_cluster_proto_depIdxs = nil
}
