// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        v3.21.12
// source: yandex/cloud/video/v1/stream_line.proto

package video

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enum representing the status of an automatic stream line.
// Indicates whether the automatic line is active or deactivated.
type AutoLine_AutoLineStatus int32

const (
	// Auto line status unspecified.
	AutoLine_AUTO_LINE_STATUS_UNSPECIFIED AutoLine_AutoLineStatus = 0
	// The automatic line is deactivated and not currently active.
	AutoLine_DEACTIVATED AutoLine_AutoLineStatus = 1
	// The automatic line is active and operational.
	AutoLine_ACTIVE AutoLine_AutoLineStatus = 2
)

// Enum value maps for AutoLine_AutoLineStatus.
var (
	AutoLine_AutoLineStatus_name = map[int32]string{
		0: "AUTO_LINE_STATUS_UNSPECIFIED",
		1: "DEACTIVATED",
		2: "ACTIVE",
	}
	AutoLine_AutoLineStatus_value = map[string]int32{
		"AUTO_LINE_STATUS_UNSPECIFIED": 0,
		"DEACTIVATED":                  1,
		"ACTIVE":                       2,
	}
)

func (x AutoLine_AutoLineStatus) Enum() *AutoLine_AutoLineStatus {
	p := new(AutoLine_AutoLineStatus)
	*p = x
	return p
}

func (x AutoLine_AutoLineStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutoLine_AutoLineStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_video_v1_stream_line_proto_enumTypes[0].Descriptor()
}

func (AutoLine_AutoLineStatus) Type() protoreflect.EnumType {
	return &file_yandex_cloud_video_v1_stream_line_proto_enumTypes[0]
}

func (x AutoLine_AutoLineStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutoLine_AutoLineStatus.Descriptor instead.
func (AutoLine_AutoLineStatus) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_video_v1_stream_line_proto_rawDescGZIP(), []int{6, 0}
}

// Entity representing the incoming video signal settings.
type StreamLine struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the line.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the channel to which this stream line belongs.
	ChannelId string `protobuf:"bytes,2,opt,name=channel_id,json=channelId,proto3" json:"channel_id,omitempty"`
	// Title of the stream line.
	Title string `protobuf:"bytes,3,opt,name=title,proto3" json:"title,omitempty"`
	// Specifies the input type and settings for the video signal source.
	//
	// Types that are valid to be assigned to InputType:
	//
	//	*StreamLine_RtmpPush
	//	*StreamLine_RtmpPull
	//	*StreamLine_SrtPull
	InputType isStreamLine_InputType `protobuf_oneof:"input_type"`
	// Specifies the control type of the stream line.
	//
	// Types that are valid to be assigned to LineType:
	//
	//	*StreamLine_ManualLine
	//	*StreamLine_AutoLine
	LineType isStreamLine_LineType `protobuf_oneof:"line_type"`
	// Timestamp when the stream line was initially created in the system.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,100,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Timestamp of the last modification to the stream line or its metadata.
	UpdatedAt *timestamppb.Timestamp `protobuf:"bytes,101,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	// Custom user-defined labels as `key:value` pairs.
	// Maximum 64 labels per stream line.
	// Labels can be used for organization, filtering, and metadata purposes.
	Labels        map[string]string `protobuf:"bytes,200,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StreamLine) Reset() {
	*x = StreamLine{}
	mi := &file_yandex_cloud_video_v1_stream_line_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamLine) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamLine) ProtoMessage() {}

func (x *StreamLine) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_video_v1_stream_line_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamLine.ProtoReflect.Descriptor instead.
func (*StreamLine) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_video_v1_stream_line_proto_rawDescGZIP(), []int{0}
}

func (x *StreamLine) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *StreamLine) GetChannelId() string {
	if x != nil {
		return x.ChannelId
	}
	return ""
}

func (x *StreamLine) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *StreamLine) GetInputType() isStreamLine_InputType {
	if x != nil {
		return x.InputType
	}
	return nil
}

func (x *StreamLine) GetRtmpPush() *RTMPPushInput {
	if x != nil {
		if x, ok := x.InputType.(*StreamLine_RtmpPush); ok {
			return x.RtmpPush
		}
	}
	return nil
}

func (x *StreamLine) GetRtmpPull() *RTMPPullInput {
	if x != nil {
		if x, ok := x.InputType.(*StreamLine_RtmpPull); ok {
			return x.RtmpPull
		}
	}
	return nil
}

func (x *StreamLine) GetSrtPull() *SRTPullInput {
	if x != nil {
		if x, ok := x.InputType.(*StreamLine_SrtPull); ok {
			return x.SrtPull
		}
	}
	return nil
}

func (x *StreamLine) GetLineType() isStreamLine_LineType {
	if x != nil {
		return x.LineType
	}
	return nil
}

func (x *StreamLine) GetManualLine() *ManualLine {
	if x != nil {
		if x, ok := x.LineType.(*StreamLine_ManualLine); ok {
			return x.ManualLine
		}
	}
	return nil
}

func (x *StreamLine) GetAutoLine() *AutoLine {
	if x != nil {
		if x, ok := x.LineType.(*StreamLine_AutoLine); ok {
			return x.AutoLine
		}
	}
	return nil
}

func (x *StreamLine) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *StreamLine) GetUpdatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedAt
	}
	return nil
}

func (x *StreamLine) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

type isStreamLine_InputType interface {
	isStreamLine_InputType()
}

type StreamLine_RtmpPush struct {
	// Real-Time Messaging Protocol (RTMP) push input type.
	RtmpPush *RTMPPushInput `protobuf:"bytes,1000,opt,name=rtmp_push,json=rtmpPush,proto3,oneof"`
}

type StreamLine_RtmpPull struct {
	// Real-Time Messaging Protocol (RTMP) pull input type.
	RtmpPull *RTMPPullInput `protobuf:"bytes,1002,opt,name=rtmp_pull,json=rtmpPull,proto3,oneof"`
}

type StreamLine_SrtPull struct {
	// Secure Reliable Transport (SRT) pull input type.
	SrtPull *SRTPullInput `protobuf:"bytes,1003,opt,name=srt_pull,json=srtPull,proto3,oneof"`
}

func (*StreamLine_RtmpPush) isStreamLine_InputType() {}

func (*StreamLine_RtmpPull) isStreamLine_InputType() {}

func (*StreamLine_SrtPull) isStreamLine_InputType() {}

type isStreamLine_LineType interface {
	isStreamLine_LineType()
}

type StreamLine_ManualLine struct {
	// Manual stream control.
	ManualLine *ManualLine `protobuf:"bytes,2000,opt,name=manual_line,json=manualLine,proto3,oneof"`
}

type StreamLine_AutoLine struct {
	// Automatic stream control.
	AutoLine *AutoLine `protobuf:"bytes,2001,opt,name=auto_line,json=autoLine,proto3,oneof"`
}

func (*StreamLine_ManualLine) isStreamLine_LineType() {}

func (*StreamLine_AutoLine) isStreamLine_LineType() {}

// Represents the stream key used for pushing video streams.
type PushStreamKey struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The unique stream key.
	Key           string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PushStreamKey) Reset() {
	*x = PushStreamKey{}
	mi := &file_yandex_cloud_video_v1_stream_line_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PushStreamKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PushStreamKey) ProtoMessage() {}

func (x *PushStreamKey) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_video_v1_stream_line_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PushStreamKey.ProtoReflect.Descriptor instead.
func (*PushStreamKey) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_video_v1_stream_line_proto_rawDescGZIP(), []int{1}
}

func (x *PushStreamKey) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

// Settings for an RTMP (Real-Time Messaging Protocol) push input.
// Used when the video stream is pushed to an RTMP server.
// @see https://en.wikipedia.org/wiki/Real-Time_Messaging_Protocol
type RTMPPushInput struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// RTMP server url.
	Url           string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RTMPPushInput) Reset() {
	*x = RTMPPushInput{}
	mi := &file_yandex_cloud_video_v1_stream_line_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RTMPPushInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RTMPPushInput) ProtoMessage() {}

func (x *RTMPPushInput) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_video_v1_stream_line_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RTMPPushInput.ProtoReflect.Descriptor instead.
func (*RTMPPushInput) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_video_v1_stream_line_proto_rawDescGZIP(), []int{2}
}

func (x *RTMPPushInput) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

// Settings for an RTMP pull input.
// Used when the service pulls the video stream from an RTMP source.
// @see https://en.wikipedia.org/wiki/Real-Time_Messaging_Protocol
type RTMPPullInput struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// RTMP url for receiving video signal.
	Url           string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RTMPPullInput) Reset() {
	*x = RTMPPullInput{}
	mi := &file_yandex_cloud_video_v1_stream_line_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RTMPPullInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RTMPPullInput) ProtoMessage() {}

func (x *RTMPPullInput) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_video_v1_stream_line_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RTMPPullInput.ProtoReflect.Descriptor instead.
func (*RTMPPullInput) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_video_v1_stream_line_proto_rawDescGZIP(), []int{3}
}

func (x *RTMPPullInput) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

// Settings for an SRT pull input.
// Used when the service pulls the video stream from an SRT source.
// @see https://en.wikipedia.org/wiki/Secure_Reliable_Transport
type SRTPullInput struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// SRT url for receiving video signal.
	Url           string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SRTPullInput) Reset() {
	*x = SRTPullInput{}
	mi := &file_yandex_cloud_video_v1_stream_line_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SRTPullInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SRTPullInput) ProtoMessage() {}

func (x *SRTPullInput) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_video_v1_stream_line_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SRTPullInput.ProtoReflect.Descriptor instead.
func (*SRTPullInput) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_video_v1_stream_line_proto_rawDescGZIP(), []int{4}
}

func (x *SRTPullInput) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

// Represents a manual line type where the stream control is handled manually.
// This means that stream start/stop actions are performed by the user.
type ManualLine struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ManualLine) Reset() {
	*x = ManualLine{}
	mi := &file_yandex_cloud_video_v1_stream_line_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ManualLine) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManualLine) ProtoMessage() {}

func (x *ManualLine) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_video_v1_stream_line_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManualLine.ProtoReflect.Descriptor instead.
func (*ManualLine) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_video_v1_stream_line_proto_rawDescGZIP(), []int{5}
}

// Represents an automatic line type where the stream control is handled automatically.
type AutoLine struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The status of the automatic line.
	Status        AutoLine_AutoLineStatus `protobuf:"varint,1,opt,name=status,proto3,enum=yandex.cloud.video.v1.AutoLine_AutoLineStatus" json:"status,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AutoLine) Reset() {
	*x = AutoLine{}
	mi := &file_yandex_cloud_video_v1_stream_line_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutoLine) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoLine) ProtoMessage() {}

func (x *AutoLine) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_video_v1_stream_line_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoLine.ProtoReflect.Descriptor instead.
func (*AutoLine) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_video_v1_stream_line_proto_rawDescGZIP(), []int{6}
}

func (x *AutoLine) GetStatus() AutoLine_AutoLineStatus {
	if x != nil {
		return x.Status
	}
	return AutoLine_AUTO_LINE_STATUS_UNSPECIFIED
}

var File_yandex_cloud_video_v1_stream_line_proto protoreflect.FileDescriptor

const file_yandex_cloud_video_v1_stream_line_proto_rawDesc = "" +
	"\n" +
	"'yandex/cloud/video/v1/stream_line.proto\x12\x15yandex.cloud.video.v1\x1a\x1fgoogle/protobuf/timestamp.proto\"\xe7\x05\n" +
	"\n" +
	"StreamLine\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x1d\n" +
	"\n" +
	"channel_id\x18\x02 \x01(\tR\tchannelId\x12\x14\n" +
	"\x05title\x18\x03 \x01(\tR\x05title\x12D\n" +
	"\trtmp_push\x18\xe8\a \x01(\v2$.yandex.cloud.video.v1.RTMPPushInputH\x00R\brtmpPush\x12D\n" +
	"\trtmp_pull\x18\xea\a \x01(\v2$.yandex.cloud.video.v1.RTMPPullInputH\x00R\brtmpPull\x12A\n" +
	"\bsrt_pull\x18\xeb\a \x01(\v2#.yandex.cloud.video.v1.SRTPullInputH\x00R\asrtPull\x12E\n" +
	"\vmanual_line\x18\xd0\x0f \x01(\v2!.yandex.cloud.video.v1.ManualLineH\x01R\n" +
	"manualLine\x12?\n" +
	"\tauto_line\x18\xd1\x0f \x01(\v2\x1f.yandex.cloud.video.v1.AutoLineH\x01R\bautoLine\x129\n" +
	"\n" +
	"created_at\x18d \x01(\v2\x1a.google.protobuf.TimestampR\tcreatedAt\x129\n" +
	"\n" +
	"updated_at\x18e \x01(\v2\x1a.google.protobuf.TimestampR\tupdatedAt\x12F\n" +
	"\x06labels\x18\xc8\x01 \x03(\v2-.yandex.cloud.video.v1.StreamLine.LabelsEntryR\x06labels\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01B\f\n" +
	"\n" +
	"input_typeB\v\n" +
	"\tline_typeJ\x04\b\x04\x10\x05J\x04\b\x05\x10dJ\x05\bf\x10\xc8\x01J\x06\b\xc9\x01\x10\xe8\aJ\x06\b\xe9\a\x10\xea\aJ\x06\b\xec\a\x10\xd0\x0f\"!\n" +
	"\rPushStreamKey\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\"!\n" +
	"\rRTMPPushInput\x12\x10\n" +
	"\x03url\x18\x01 \x01(\tR\x03url\"!\n" +
	"\rRTMPPullInput\x12\x10\n" +
	"\x03url\x18\x01 \x01(\tR\x03url\" \n" +
	"\fSRTPullInput\x12\x10\n" +
	"\x03url\x18\x01 \x01(\tR\x03url\"\f\n" +
	"\n" +
	"ManualLine\"\xa3\x01\n" +
	"\bAutoLine\x12F\n" +
	"\x06status\x18\x01 \x01(\x0e2..yandex.cloud.video.v1.AutoLine.AutoLineStatusR\x06status\"O\n" +
	"\x0eAutoLineStatus\x12 \n" +
	"\x1cAUTO_LINE_STATUS_UNSPECIFIED\x10\x00\x12\x0f\n" +
	"\vDEACTIVATED\x10\x01\x12\n" +
	"\n" +
	"\x06ACTIVE\x10\x02B\\\n" +
	"\x19yandex.cloud.api.video.v1Z?github.com/yandex-cloud/go-genproto/yandex/cloud/video/v1;videob\x06proto3"

var (
	file_yandex_cloud_video_v1_stream_line_proto_rawDescOnce sync.Once
	file_yandex_cloud_video_v1_stream_line_proto_rawDescData []byte
)

func file_yandex_cloud_video_v1_stream_line_proto_rawDescGZIP() []byte {
	file_yandex_cloud_video_v1_stream_line_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_video_v1_stream_line_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_video_v1_stream_line_proto_rawDesc), len(file_yandex_cloud_video_v1_stream_line_proto_rawDesc)))
	})
	return file_yandex_cloud_video_v1_stream_line_proto_rawDescData
}

var file_yandex_cloud_video_v1_stream_line_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_yandex_cloud_video_v1_stream_line_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_yandex_cloud_video_v1_stream_line_proto_goTypes = []any{
	(AutoLine_AutoLineStatus)(0),  // 0: yandex.cloud.video.v1.AutoLine.AutoLineStatus
	(*StreamLine)(nil),            // 1: yandex.cloud.video.v1.StreamLine
	(*PushStreamKey)(nil),         // 2: yandex.cloud.video.v1.PushStreamKey
	(*RTMPPushInput)(nil),         // 3: yandex.cloud.video.v1.RTMPPushInput
	(*RTMPPullInput)(nil),         // 4: yandex.cloud.video.v1.RTMPPullInput
	(*SRTPullInput)(nil),          // 5: yandex.cloud.video.v1.SRTPullInput
	(*ManualLine)(nil),            // 6: yandex.cloud.video.v1.ManualLine
	(*AutoLine)(nil),              // 7: yandex.cloud.video.v1.AutoLine
	nil,                           // 8: yandex.cloud.video.v1.StreamLine.LabelsEntry
	(*timestamppb.Timestamp)(nil), // 9: google.protobuf.Timestamp
}
var file_yandex_cloud_video_v1_stream_line_proto_depIdxs = []int32{
	3, // 0: yandex.cloud.video.v1.StreamLine.rtmp_push:type_name -> yandex.cloud.video.v1.RTMPPushInput
	4, // 1: yandex.cloud.video.v1.StreamLine.rtmp_pull:type_name -> yandex.cloud.video.v1.RTMPPullInput
	5, // 2: yandex.cloud.video.v1.StreamLine.srt_pull:type_name -> yandex.cloud.video.v1.SRTPullInput
	6, // 3: yandex.cloud.video.v1.StreamLine.manual_line:type_name -> yandex.cloud.video.v1.ManualLine
	7, // 4: yandex.cloud.video.v1.StreamLine.auto_line:type_name -> yandex.cloud.video.v1.AutoLine
	9, // 5: yandex.cloud.video.v1.StreamLine.created_at:type_name -> google.protobuf.Timestamp
	9, // 6: yandex.cloud.video.v1.StreamLine.updated_at:type_name -> google.protobuf.Timestamp
	8, // 7: yandex.cloud.video.v1.StreamLine.labels:type_name -> yandex.cloud.video.v1.StreamLine.LabelsEntry
	0, // 8: yandex.cloud.video.v1.AutoLine.status:type_name -> yandex.cloud.video.v1.AutoLine.AutoLineStatus
	9, // [9:9] is the sub-list for method output_type
	9, // [9:9] is the sub-list for method input_type
	9, // [9:9] is the sub-list for extension type_name
	9, // [9:9] is the sub-list for extension extendee
	0, // [0:9] is the sub-list for field type_name
}

func init() { file_yandex_cloud_video_v1_stream_line_proto_init() }
func file_yandex_cloud_video_v1_stream_line_proto_init() {
	if File_yandex_cloud_video_v1_stream_line_proto != nil {
		return
	}
	file_yandex_cloud_video_v1_stream_line_proto_msgTypes[0].OneofWrappers = []any{
		(*StreamLine_RtmpPush)(nil),
		(*StreamLine_RtmpPull)(nil),
		(*StreamLine_SrtPull)(nil),
		(*StreamLine_ManualLine)(nil),
		(*StreamLine_AutoLine)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_video_v1_stream_line_proto_rawDesc), len(file_yandex_cloud_video_v1_stream_line_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_video_v1_stream_line_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_video_v1_stream_line_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_video_v1_stream_line_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_video_v1_stream_line_proto_msgTypes,
	}.Build()
	File_yandex_cloud_video_v1_stream_line_proto = out.File
	file_yandex_cloud_video_v1_stream_line_proto_goTypes = nil
	file_yandex_cloud_video_v1_stream_line_proto_depIdxs = nil
}
