// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        v3.21.12
// source: yandex/cloud/vpc/v1/security_group.proto

package vpc

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type SecurityGroup_Status int32

const (
	SecurityGroup_STATUS_UNSPECIFIED SecurityGroup_Status = 0
	// Security group is being created.
	SecurityGroup_CREATING SecurityGroup_Status = 1
	// Security is active and it's rules are applied to the network interfaces.
	SecurityGroup_ACTIVE SecurityGroup_Status = 2
	// Security group is updating. Updating is a long operation because we must update all instances in SG.
	SecurityGroup_UPDATING SecurityGroup_Status = 3
	// Instance is being deleted.
	SecurityGroup_DELETING SecurityGroup_Status = 4
)

// Enum value maps for SecurityGroup_Status.
var (
	SecurityGroup_Status_name = map[int32]string{
		0: "STATUS_UNSPECIFIED",
		1: "CREATING",
		2: "ACTIVE",
		3: "UPDATING",
		4: "DELETING",
	}
	SecurityGroup_Status_value = map[string]int32{
		"STATUS_UNSPECIFIED": 0,
		"CREATING":           1,
		"ACTIVE":             2,
		"UPDATING":           3,
		"DELETING":           4,
	}
)

func (x SecurityGroup_Status) Enum() *SecurityGroup_Status {
	p := new(SecurityGroup_Status)
	*p = x
	return p
}

func (x SecurityGroup_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SecurityGroup_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_vpc_v1_security_group_proto_enumTypes[0].Descriptor()
}

func (SecurityGroup_Status) Type() protoreflect.EnumType {
	return &file_yandex_cloud_vpc_v1_security_group_proto_enumTypes[0]
}

func (x SecurityGroup_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SecurityGroup_Status.Descriptor instead.
func (SecurityGroup_Status) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_vpc_v1_security_group_proto_rawDescGZIP(), []int{0, 0}
}

type SecurityGroupRule_Direction int32

const (
	SecurityGroupRule_DIRECTION_UNSPECIFIED SecurityGroupRule_Direction = 0
	// Allows ingress traffic.
	SecurityGroupRule_INGRESS SecurityGroupRule_Direction = 1
	// Allows egress traffic.
	SecurityGroupRule_EGRESS SecurityGroupRule_Direction = 2
)

// Enum value maps for SecurityGroupRule_Direction.
var (
	SecurityGroupRule_Direction_name = map[int32]string{
		0: "DIRECTION_UNSPECIFIED",
		1: "INGRESS",
		2: "EGRESS",
	}
	SecurityGroupRule_Direction_value = map[string]int32{
		"DIRECTION_UNSPECIFIED": 0,
		"INGRESS":               1,
		"EGRESS":                2,
	}
)

func (x SecurityGroupRule_Direction) Enum() *SecurityGroupRule_Direction {
	p := new(SecurityGroupRule_Direction)
	*p = x
	return p
}

func (x SecurityGroupRule_Direction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SecurityGroupRule_Direction) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_vpc_v1_security_group_proto_enumTypes[1].Descriptor()
}

func (SecurityGroupRule_Direction) Type() protoreflect.EnumType {
	return &file_yandex_cloud_vpc_v1_security_group_proto_enumTypes[1]
}

func (x SecurityGroupRule_Direction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SecurityGroupRule_Direction.Descriptor instead.
func (SecurityGroupRule_Direction) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_vpc_v1_security_group_proto_rawDescGZIP(), []int{1, 0}
}

type SecurityGroup struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the security group.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the security group belongs to.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the security group.
	// The name must be unique within the folder.
	// Value must match the regular expression “\|[a-zA-Z]([-_a-zA-Z0-9]{0,61}[a-zA-Z0-9])?“.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the security group. 0-256 characters long.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `key:value` pairs.
	// No more than 64 per resource.
	// The maximum string length in characters for each value is 63.
	// Each value must match the regular expression `[-_./\\@0-9a-z]*`.
	// The string length in characters for each key must be 1-63.
	// Each key must match the regular expression `[a-z][-_./\\@0-9a-z]*`.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// ID of the network that the security group belongs to.
	NetworkId string `protobuf:"bytes,7,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// Security group status.
	Status SecurityGroup_Status `protobuf:"varint,8,opt,name=status,proto3,enum=yandex.cloud.vpc.v1.SecurityGroup_Status" json:"status,omitempty"`
	// List of the security group rules.
	Rules []*SecurityGroupRule `protobuf:"bytes,9,rep,name=rules,proto3" json:"rules,omitempty"`
	// Flag that indicates that the security group is the default for the network.
	DefaultForNetwork bool `protobuf:"varint,10,opt,name=default_for_network,json=defaultForNetwork,proto3" json:"default_for_network,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *SecurityGroup) Reset() {
	*x = SecurityGroup{}
	mi := &file_yandex_cloud_vpc_v1_security_group_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SecurityGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecurityGroup) ProtoMessage() {}

func (x *SecurityGroup) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_vpc_v1_security_group_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecurityGroup.ProtoReflect.Descriptor instead.
func (*SecurityGroup) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_vpc_v1_security_group_proto_rawDescGZIP(), []int{0}
}

func (x *SecurityGroup) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *SecurityGroup) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *SecurityGroup) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *SecurityGroup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SecurityGroup) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *SecurityGroup) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *SecurityGroup) GetNetworkId() string {
	if x != nil {
		return x.NetworkId
	}
	return ""
}

func (x *SecurityGroup) GetStatus() SecurityGroup_Status {
	if x != nil {
		return x.Status
	}
	return SecurityGroup_STATUS_UNSPECIFIED
}

func (x *SecurityGroup) GetRules() []*SecurityGroupRule {
	if x != nil {
		return x.Rules
	}
	return nil
}

func (x *SecurityGroup) GetDefaultForNetwork() bool {
	if x != nil {
		return x.DefaultForNetwork
	}
	return false
}

type SecurityGroupRule struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the rule.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"` //generated by api server after rule creation
	// Description of the rule. 0-256 characters long.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as “ key:value “ pairs. Maximum of 64 per resource.
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// The direction of network traffic allowed by this rule.
	Direction SecurityGroupRule_Direction `protobuf:"varint,4,opt,name=direction,proto3,enum=yandex.cloud.vpc.v1.SecurityGroupRule_Direction" json:"direction,omitempty"`
	// The range of ports that allow traffic to pass through. Null value means any.
	Ports *PortRange `protobuf:"bytes,5,opt,name=ports,proto3" json:"ports,omitempty"`
	// Protocol name. Null value means any protocol.
	// Values from [IANA](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml).
	ProtocolName string `protobuf:"bytes,6,opt,name=protocol_name,json=protocolName,proto3" json:"protocol_name,omitempty"`
	// Protocol number from [IANA protocol numbers](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml).
	ProtocolNumber int64 `protobuf:"varint,7,opt,name=protocol_number,json=protocolNumber,proto3" json:"protocol_number,omitempty"`
	// Types that are valid to be assigned to Target:
	//
	//	*SecurityGroupRule_CidrBlocks
	//	*SecurityGroupRule_SecurityGroupId
	//	*SecurityGroupRule_PredefinedTarget
	Target        isSecurityGroupRule_Target `protobuf_oneof:"target"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SecurityGroupRule) Reset() {
	*x = SecurityGroupRule{}
	mi := &file_yandex_cloud_vpc_v1_security_group_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SecurityGroupRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecurityGroupRule) ProtoMessage() {}

func (x *SecurityGroupRule) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_vpc_v1_security_group_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecurityGroupRule.ProtoReflect.Descriptor instead.
func (*SecurityGroupRule) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_vpc_v1_security_group_proto_rawDescGZIP(), []int{1}
}

func (x *SecurityGroupRule) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *SecurityGroupRule) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *SecurityGroupRule) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *SecurityGroupRule) GetDirection() SecurityGroupRule_Direction {
	if x != nil {
		return x.Direction
	}
	return SecurityGroupRule_DIRECTION_UNSPECIFIED
}

func (x *SecurityGroupRule) GetPorts() *PortRange {
	if x != nil {
		return x.Ports
	}
	return nil
}

func (x *SecurityGroupRule) GetProtocolName() string {
	if x != nil {
		return x.ProtocolName
	}
	return ""
}

func (x *SecurityGroupRule) GetProtocolNumber() int64 {
	if x != nil {
		return x.ProtocolNumber
	}
	return 0
}

func (x *SecurityGroupRule) GetTarget() isSecurityGroupRule_Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *SecurityGroupRule) GetCidrBlocks() *CidrBlocks {
	if x != nil {
		if x, ok := x.Target.(*SecurityGroupRule_CidrBlocks); ok {
			return x.CidrBlocks
		}
	}
	return nil
}

func (x *SecurityGroupRule) GetSecurityGroupId() string {
	if x != nil {
		if x, ok := x.Target.(*SecurityGroupRule_SecurityGroupId); ok {
			return x.SecurityGroupId
		}
	}
	return ""
}

func (x *SecurityGroupRule) GetPredefinedTarget() string {
	if x != nil {
		if x, ok := x.Target.(*SecurityGroupRule_PredefinedTarget); ok {
			return x.PredefinedTarget
		}
	}
	return ""
}

type isSecurityGroupRule_Target interface {
	isSecurityGroupRule_Target()
}

type SecurityGroupRule_CidrBlocks struct {
	// CIDR blocks to allow to recieve or send traffic.
	CidrBlocks *CidrBlocks `protobuf:"bytes,8,opt,name=cidr_blocks,json=cidrBlocks,proto3,oneof"`
}

type SecurityGroupRule_SecurityGroupId struct {
	// ID of the security group to add rule to.
	SecurityGroupId string `protobuf:"bytes,9,opt,name=security_group_id,json=securityGroupId,proto3,oneof"`
}

type SecurityGroupRule_PredefinedTarget struct {
	// Predefined target. See [security groups rules](/docs/vpc/concepts/security-groups#security-groups-rules) for more information.
	PredefinedTarget string `protobuf:"bytes,10,opt,name=predefined_target,json=predefinedTarget,proto3,oneof"`
}

func (*SecurityGroupRule_CidrBlocks) isSecurityGroupRule_Target() {}

func (*SecurityGroupRule_SecurityGroupId) isSecurityGroupRule_Target() {}

func (*SecurityGroupRule_PredefinedTarget) isSecurityGroupRule_Target() {}

type PortRange struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The lowest port in the range.
	FromPort int64 `protobuf:"varint,1,opt,name=from_port,json=fromPort,proto3" json:"from_port,omitempty"`
	// The highest port in the range.
	ToPort        int64 `protobuf:"varint,2,opt,name=to_port,json=toPort,proto3" json:"to_port,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PortRange) Reset() {
	*x = PortRange{}
	mi := &file_yandex_cloud_vpc_v1_security_group_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PortRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PortRange) ProtoMessage() {}

func (x *PortRange) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_vpc_v1_security_group_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PortRange.ProtoReflect.Descriptor instead.
func (*PortRange) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_vpc_v1_security_group_proto_rawDescGZIP(), []int{2}
}

func (x *PortRange) GetFromPort() int64 {
	if x != nil {
		return x.FromPort
	}
	return 0
}

func (x *PortRange) GetToPort() int64 {
	if x != nil {
		return x.ToPort
	}
	return 0
}

type CidrBlocks struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// IPv4 CIDR blocks to allow traffic to.
	V4CidrBlocks []string `protobuf:"bytes,1,rep,name=v4_cidr_blocks,json=v4CidrBlocks,proto3" json:"v4_cidr_blocks,omitempty"`
	// IPv6 CIDR blocks to allow traffic to.
	V6CidrBlocks  []string `protobuf:"bytes,2,rep,name=v6_cidr_blocks,json=v6CidrBlocks,proto3" json:"v6_cidr_blocks,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CidrBlocks) Reset() {
	*x = CidrBlocks{}
	mi := &file_yandex_cloud_vpc_v1_security_group_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CidrBlocks) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CidrBlocks) ProtoMessage() {}

func (x *CidrBlocks) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_vpc_v1_security_group_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CidrBlocks.ProtoReflect.Descriptor instead.
func (*CidrBlocks) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_vpc_v1_security_group_proto_rawDescGZIP(), []int{3}
}

func (x *CidrBlocks) GetV4CidrBlocks() []string {
	if x != nil {
		return x.V4CidrBlocks
	}
	return nil
}

func (x *CidrBlocks) GetV6CidrBlocks() []string {
	if x != nil {
		return x.V6CidrBlocks
	}
	return nil
}

var File_yandex_cloud_vpc_v1_security_group_proto protoreflect.FileDescriptor

const file_yandex_cloud_vpc_v1_security_group_proto_rawDesc = "" +
	"\n" +
	"(yandex/cloud/vpc/v1/security_group.proto\x12\x13yandex.cloud.vpc.v1\x1a\x1fgoogle/protobuf/timestamp.proto\x1a\x1dyandex/cloud/validation.proto\"\xd8\x04\n" +
	"\rSecurityGroup\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x1b\n" +
	"\tfolder_id\x18\x02 \x01(\tR\bfolderId\x129\n" +
	"\n" +
	"created_at\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampR\tcreatedAt\x12\x12\n" +
	"\x04name\x18\x04 \x01(\tR\x04name\x12 \n" +
	"\vdescription\x18\x05 \x01(\tR\vdescription\x12F\n" +
	"\x06labels\x18\x06 \x03(\v2..yandex.cloud.vpc.v1.SecurityGroup.LabelsEntryR\x06labels\x12\x1d\n" +
	"\n" +
	"network_id\x18\a \x01(\tR\tnetworkId\x12A\n" +
	"\x06status\x18\b \x01(\x0e2).yandex.cloud.vpc.v1.SecurityGroup.StatusR\x06status\x12<\n" +
	"\x05rules\x18\t \x03(\v2&.yandex.cloud.vpc.v1.SecurityGroupRuleR\x05rules\x12.\n" +
	"\x13default_for_network\x18\n" +
	" \x01(\bR\x11defaultForNetwork\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"V\n" +
	"\x06Status\x12\x16\n" +
	"\x12STATUS_UNSPECIFIED\x10\x00\x12\f\n" +
	"\bCREATING\x10\x01\x12\n" +
	"\n" +
	"\x06ACTIVE\x10\x02\x12\f\n" +
	"\bUPDATING\x10\x03\x12\f\n" +
	"\bDELETING\x10\x04\"\x98\x05\n" +
	"\x11SecurityGroupRule\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12 \n" +
	"\vdescription\x18\x02 \x01(\tR\vdescription\x12J\n" +
	"\x06labels\x18\x03 \x03(\v22.yandex.cloud.vpc.v1.SecurityGroupRule.LabelsEntryR\x06labels\x12T\n" +
	"\tdirection\x18\x04 \x01(\x0e20.yandex.cloud.vpc.v1.SecurityGroupRule.DirectionB\x04\xe8\xc71\x01R\tdirection\x124\n" +
	"\x05ports\x18\x05 \x01(\v2\x1e.yandex.cloud.vpc.v1.PortRangeR\x05ports\x12#\n" +
	"\rprotocol_name\x18\x06 \x01(\tR\fprotocolName\x12'\n" +
	"\x0fprotocol_number\x18\a \x01(\x03R\x0eprotocolNumber\x12B\n" +
	"\vcidr_blocks\x18\b \x01(\v2\x1f.yandex.cloud.vpc.v1.CidrBlocksH\x00R\n" +
	"cidrBlocks\x12,\n" +
	"\x11security_group_id\x18\t \x01(\tH\x00R\x0fsecurityGroupId\x12-\n" +
	"\x11predefined_target\x18\n" +
	" \x01(\tH\x00R\x10predefinedTarget\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"?\n" +
	"\tDirection\x12\x19\n" +
	"\x15DIRECTION_UNSPECIFIED\x10\x00\x12\v\n" +
	"\aINGRESS\x10\x01\x12\n" +
	"\n" +
	"\x06EGRESS\x10\x02B\x0e\n" +
	"\x06target\x12\x04\xc0\xc11\x01\"[\n" +
	"\tPortRange\x12(\n" +
	"\tfrom_port\x18\x01 \x01(\x03B\v\xfa\xc71\a0-65535R\bfromPort\x12$\n" +
	"\ato_port\x18\x02 \x01(\x03B\v\xfa\xc71\a0-65535R\x06toPort\"X\n" +
	"\n" +
	"CidrBlocks\x12$\n" +
	"\x0ev4_cidr_blocks\x18\x01 \x03(\tR\fv4CidrBlocks\x12$\n" +
	"\x0ev6_cidr_blocks\x18\x02 \x03(\tR\fv6CidrBlocksBV\n" +
	"\x17yandex.cloud.api.vpc.v1Z;github.com/yandex-cloud/go-genproto/yandex/cloud/vpc/v1;vpcb\x06proto3"

var (
	file_yandex_cloud_vpc_v1_security_group_proto_rawDescOnce sync.Once
	file_yandex_cloud_vpc_v1_security_group_proto_rawDescData []byte
)

func file_yandex_cloud_vpc_v1_security_group_proto_rawDescGZIP() []byte {
	file_yandex_cloud_vpc_v1_security_group_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_vpc_v1_security_group_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_vpc_v1_security_group_proto_rawDesc), len(file_yandex_cloud_vpc_v1_security_group_proto_rawDesc)))
	})
	return file_yandex_cloud_vpc_v1_security_group_proto_rawDescData
}

var file_yandex_cloud_vpc_v1_security_group_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_yandex_cloud_vpc_v1_security_group_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_yandex_cloud_vpc_v1_security_group_proto_goTypes = []any{
	(SecurityGroup_Status)(0),        // 0: yandex.cloud.vpc.v1.SecurityGroup.Status
	(SecurityGroupRule_Direction)(0), // 1: yandex.cloud.vpc.v1.SecurityGroupRule.Direction
	(*SecurityGroup)(nil),            // 2: yandex.cloud.vpc.v1.SecurityGroup
	(*SecurityGroupRule)(nil),        // 3: yandex.cloud.vpc.v1.SecurityGroupRule
	(*PortRange)(nil),                // 4: yandex.cloud.vpc.v1.PortRange
	(*CidrBlocks)(nil),               // 5: yandex.cloud.vpc.v1.CidrBlocks
	nil,                              // 6: yandex.cloud.vpc.v1.SecurityGroup.LabelsEntry
	nil,                              // 7: yandex.cloud.vpc.v1.SecurityGroupRule.LabelsEntry
	(*timestamppb.Timestamp)(nil),    // 8: google.protobuf.Timestamp
}
var file_yandex_cloud_vpc_v1_security_group_proto_depIdxs = []int32{
	8, // 0: yandex.cloud.vpc.v1.SecurityGroup.created_at:type_name -> google.protobuf.Timestamp
	6, // 1: yandex.cloud.vpc.v1.SecurityGroup.labels:type_name -> yandex.cloud.vpc.v1.SecurityGroup.LabelsEntry
	0, // 2: yandex.cloud.vpc.v1.SecurityGroup.status:type_name -> yandex.cloud.vpc.v1.SecurityGroup.Status
	3, // 3: yandex.cloud.vpc.v1.SecurityGroup.rules:type_name -> yandex.cloud.vpc.v1.SecurityGroupRule
	7, // 4: yandex.cloud.vpc.v1.SecurityGroupRule.labels:type_name -> yandex.cloud.vpc.v1.SecurityGroupRule.LabelsEntry
	1, // 5: yandex.cloud.vpc.v1.SecurityGroupRule.direction:type_name -> yandex.cloud.vpc.v1.SecurityGroupRule.Direction
	4, // 6: yandex.cloud.vpc.v1.SecurityGroupRule.ports:type_name -> yandex.cloud.vpc.v1.PortRange
	5, // 7: yandex.cloud.vpc.v1.SecurityGroupRule.cidr_blocks:type_name -> yandex.cloud.vpc.v1.CidrBlocks
	8, // [8:8] is the sub-list for method output_type
	8, // [8:8] is the sub-list for method input_type
	8, // [8:8] is the sub-list for extension type_name
	8, // [8:8] is the sub-list for extension extendee
	0, // [0:8] is the sub-list for field type_name
}

func init() { file_yandex_cloud_vpc_v1_security_group_proto_init() }
func file_yandex_cloud_vpc_v1_security_group_proto_init() {
	if File_yandex_cloud_vpc_v1_security_group_proto != nil {
		return
	}
	file_yandex_cloud_vpc_v1_security_group_proto_msgTypes[1].OneofWrappers = []any{
		(*SecurityGroupRule_CidrBlocks)(nil),
		(*SecurityGroupRule_SecurityGroupId)(nil),
		(*SecurityGroupRule_PredefinedTarget)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_vpc_v1_security_group_proto_rawDesc), len(file_yandex_cloud_vpc_v1_security_group_proto_rawDesc)),
			NumEnums:      2,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_vpc_v1_security_group_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_vpc_v1_security_group_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_vpc_v1_security_group_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_vpc_v1_security_group_proto_msgTypes,
	}.Build()
	File_yandex_cloud_vpc_v1_security_group_proto = out.File
	file_yandex_cloud_vpc_v1_security_group_proto_goTypes = nil
	file_yandex_cloud_vpc_v1_security_group_proto_depIdxs = nil
}
