---
title: "Visibility of Sections"
description: "How to control visibility of terraform-docs sections"
menu:
  docs:
    parent: "how-to"
weight: 203
toc: false
---

Since `v0.10.0`

Output generated by `terraform-docs` consists of different [sections] which are
visible by default. The visibility of these can be controlled by one of the following
options:

- `--show <name>`
- `--hide <name>`
- `--show-all` (deprecated in `v0.13.0`, removed in `v0.15.0`)
- `--hide-all` (deprecated in `v0.13.0`, removed in `v0.15.0`)

As of `v0.13.0` flags `--show-all` and `--hide-all` are deprecated in favor of
explicit use of `--show` and `--hide`. In other words when `--show <section>` is
used, only `<section>` will be shown. If you want to show multiple sections and
hide the rest you can specify `--show` flag multiple times. The same logic is also
applied to `--hide`.

```bash
# show 'inputs' and hide everything else
$ terraform-docs --show inputs <formatter>

# show 'inputs' and show 'outputs' and hide everything else
$ terraform-docs --show inputs --show outputs <formatter>

# hide 'header' and show everything else
$ terraform-docs --hide header <formatter>

# hide 'header' and hide 'providers' and show everything else
$ terraform-docs --hide header --hide providers <formatter>
```

{{< alert type="info" >}}
Using `--show` or `--hide` CLI flag will completely override the values
from `.terraform-docs.yml`.
{{< /alert >}}

```bash
$ cat .terraform-docs.yml
sections:
  show:
    - inputs
    - outputs

# example 1: this will only show 'providers'
$ terraform-docs --show providers .

# example 2: this will hide 'inputs' and hide 'providers' and show everything else
$ terraform-docs --hide inputs --hide providers .
```

[sections]: {{< ref "sections" >}}
