// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/dataplex/v1/data_quality.proto

package dataplexpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Execution state for the exporting.
type DataQualityResult_PostScanActionsResult_BigQueryExportResult_State int32

const (
	// The exporting state is unspecified.
	DataQualityResult_PostScanActionsResult_BigQueryExportResult_STATE_UNSPECIFIED DataQualityResult_PostScanActionsResult_BigQueryExportResult_State = 0
	// The exporting completed successfully.
	DataQualityResult_PostScanActionsResult_BigQueryExportResult_SUCCEEDED DataQualityResult_PostScanActionsResult_BigQueryExportResult_State = 1
	// The exporting is no longer running due to an error.
	DataQualityResult_PostScanActionsResult_BigQueryExportResult_FAILED DataQualityResult_PostScanActionsResult_BigQueryExportResult_State = 2
	// The exporting is skipped due to no valid scan result to export
	// (usually caused by scan failed).
	DataQualityResult_PostScanActionsResult_BigQueryExportResult_SKIPPED DataQualityResult_PostScanActionsResult_BigQueryExportResult_State = 3
)

// Enum value maps for DataQualityResult_PostScanActionsResult_BigQueryExportResult_State.
var (
	DataQualityResult_PostScanActionsResult_BigQueryExportResult_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "SUCCEEDED",
		2: "FAILED",
		3: "SKIPPED",
	}
	DataQualityResult_PostScanActionsResult_BigQueryExportResult_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"SUCCEEDED":         1,
		"FAILED":            2,
		"SKIPPED":           3,
	}
)

func (x DataQualityResult_PostScanActionsResult_BigQueryExportResult_State) Enum() *DataQualityResult_PostScanActionsResult_BigQueryExportResult_State {
	p := new(DataQualityResult_PostScanActionsResult_BigQueryExportResult_State)
	*p = x
	return p
}

func (x DataQualityResult_PostScanActionsResult_BigQueryExportResult_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataQualityResult_PostScanActionsResult_BigQueryExportResult_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_data_quality_proto_enumTypes[0].Descriptor()
}

func (DataQualityResult_PostScanActionsResult_BigQueryExportResult_State) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_data_quality_proto_enumTypes[0]
}

func (x DataQualityResult_PostScanActionsResult_BigQueryExportResult_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataQualityResult_PostScanActionsResult_BigQueryExportResult_State.Descriptor instead.
func (DataQualityResult_PostScanActionsResult_BigQueryExportResult_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{1, 0, 0, 0}
}

// The list of aggregate metrics a rule can be evaluated against.
type DataQualityRule_StatisticRangeExpectation_ColumnStatistic int32

const (
	// Unspecified statistic type
	DataQualityRule_StatisticRangeExpectation_STATISTIC_UNDEFINED DataQualityRule_StatisticRangeExpectation_ColumnStatistic = 0
	// Evaluate the column mean
	DataQualityRule_StatisticRangeExpectation_MEAN DataQualityRule_StatisticRangeExpectation_ColumnStatistic = 1
	// Evaluate the column min
	DataQualityRule_StatisticRangeExpectation_MIN DataQualityRule_StatisticRangeExpectation_ColumnStatistic = 2
	// Evaluate the column max
	DataQualityRule_StatisticRangeExpectation_MAX DataQualityRule_StatisticRangeExpectation_ColumnStatistic = 3
)

// Enum value maps for DataQualityRule_StatisticRangeExpectation_ColumnStatistic.
var (
	DataQualityRule_StatisticRangeExpectation_ColumnStatistic_name = map[int32]string{
		0: "STATISTIC_UNDEFINED",
		1: "MEAN",
		2: "MIN",
		3: "MAX",
	}
	DataQualityRule_StatisticRangeExpectation_ColumnStatistic_value = map[string]int32{
		"STATISTIC_UNDEFINED": 0,
		"MEAN":                1,
		"MIN":                 2,
		"MAX":                 3,
	}
)

func (x DataQualityRule_StatisticRangeExpectation_ColumnStatistic) Enum() *DataQualityRule_StatisticRangeExpectation_ColumnStatistic {
	p := new(DataQualityRule_StatisticRangeExpectation_ColumnStatistic)
	*p = x
	return p
}

func (x DataQualityRule_StatisticRangeExpectation_ColumnStatistic) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataQualityRule_StatisticRangeExpectation_ColumnStatistic) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_data_quality_proto_enumTypes[1].Descriptor()
}

func (DataQualityRule_StatisticRangeExpectation_ColumnStatistic) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_data_quality_proto_enumTypes[1]
}

func (x DataQualityRule_StatisticRangeExpectation_ColumnStatistic) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataQualityRule_StatisticRangeExpectation_ColumnStatistic.Descriptor instead.
func (DataQualityRule_StatisticRangeExpectation_ColumnStatistic) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{5, 5, 0}
}

// DataQualityScan related setting.
type DataQualitySpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The list of rules to evaluate against a data source. At least one
	// rule is required.
	Rules []*DataQualityRule `protobuf:"bytes,1,rep,name=rules,proto3" json:"rules,omitempty"`
	// Optional. The percentage of the records to be selected from the dataset for
	// DataScan.
	//
	// * Value can range between 0.0 and 100.0 with up to 3 significant decimal
	// digits.
	// * Sampling is not applied if `sampling_percent` is not specified, 0 or
	// 100.
	SamplingPercent float32 `protobuf:"fixed32,4,opt,name=sampling_percent,json=samplingPercent,proto3" json:"sampling_percent,omitempty"`
	// Optional. A filter applied to all rows in a single DataScan job.
	// The filter needs to be a valid SQL expression for a [WHERE clause in
	// GoogleSQL
	// syntax](https://cloud.google.com/bigquery/docs/reference/standard-sql/query-syntax#where_clause).
	//
	// Example: col1 >= 0 AND col2 < 10
	RowFilter string `protobuf:"bytes,5,opt,name=row_filter,json=rowFilter,proto3" json:"row_filter,omitempty"`
	// Optional. Actions to take upon job completion.
	PostScanActions *DataQualitySpec_PostScanActions `protobuf:"bytes,6,opt,name=post_scan_actions,json=postScanActions,proto3" json:"post_scan_actions,omitempty"`
	// Optional. If set, the latest DataScan job result will be published as
	// Dataplex Universal Catalog metadata.
	CatalogPublishingEnabled bool `protobuf:"varint,8,opt,name=catalog_publishing_enabled,json=catalogPublishingEnabled,proto3" json:"catalog_publishing_enabled,omitempty"`
}

func (x *DataQualitySpec) Reset() {
	*x = DataQualitySpec{}
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataQualitySpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualitySpec) ProtoMessage() {}

func (x *DataQualitySpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualitySpec.ProtoReflect.Descriptor instead.
func (*DataQualitySpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{0}
}

func (x *DataQualitySpec) GetRules() []*DataQualityRule {
	if x != nil {
		return x.Rules
	}
	return nil
}

func (x *DataQualitySpec) GetSamplingPercent() float32 {
	if x != nil {
		return x.SamplingPercent
	}
	return 0
}

func (x *DataQualitySpec) GetRowFilter() string {
	if x != nil {
		return x.RowFilter
	}
	return ""
}

func (x *DataQualitySpec) GetPostScanActions() *DataQualitySpec_PostScanActions {
	if x != nil {
		return x.PostScanActions
	}
	return nil
}

func (x *DataQualitySpec) GetCatalogPublishingEnabled() bool {
	if x != nil {
		return x.CatalogPublishingEnabled
	}
	return false
}

// The output of a DataQualityScan.
type DataQualityResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Overall data quality result -- `true` if all rules passed.
	Passed bool `protobuf:"varint,5,opt,name=passed,proto3" json:"passed,omitempty"`
	// Output only. The overall data quality score.
	//
	// The score ranges between [0, 100] (up to two decimal points).
	Score *float32 `protobuf:"fixed32,9,opt,name=score,proto3,oneof" json:"score,omitempty"`
	// Output only. A list of results at the dimension level.
	//
	// A dimension will have a corresponding `DataQualityDimensionResult` if and
	// only if there is at least one rule with the 'dimension' field set to it.
	Dimensions []*DataQualityDimensionResult `protobuf:"bytes,2,rep,name=dimensions,proto3" json:"dimensions,omitempty"`
	// Output only. A list of results at the column level.
	//
	// A column will have a corresponding `DataQualityColumnResult` if and only if
	// there is at least one rule with the 'column' field set to it.
	Columns []*DataQualityColumnResult `protobuf:"bytes,10,rep,name=columns,proto3" json:"columns,omitempty"`
	// Output only. A list of all the rules in a job, and their results.
	Rules []*DataQualityRuleResult `protobuf:"bytes,3,rep,name=rules,proto3" json:"rules,omitempty"`
	// Output only. The count of rows processed.
	RowCount int64 `protobuf:"varint,4,opt,name=row_count,json=rowCount,proto3" json:"row_count,omitempty"`
	// Output only. The data scanned for this result.
	ScannedData *ScannedData `protobuf:"bytes,7,opt,name=scanned_data,json=scannedData,proto3" json:"scanned_data,omitempty"`
	// Output only. The result of post scan actions.
	PostScanActionsResult *DataQualityResult_PostScanActionsResult `protobuf:"bytes,8,opt,name=post_scan_actions_result,json=postScanActionsResult,proto3" json:"post_scan_actions_result,omitempty"`
	// Output only. The status of publishing the data scan as Dataplex Universal
	// Catalog metadata.
	CatalogPublishingStatus *DataScanCatalogPublishingStatus `protobuf:"bytes,11,opt,name=catalog_publishing_status,json=catalogPublishingStatus,proto3" json:"catalog_publishing_status,omitempty"`
	// Output only. The generated assets for anomaly detection.
	AnomalyDetectionGeneratedAssets *DataQualityResult_AnomalyDetectionGeneratedAssets `protobuf:"bytes,12,opt,name=anomaly_detection_generated_assets,json=anomalyDetectionGeneratedAssets,proto3" json:"anomaly_detection_generated_assets,omitempty"`
}

func (x *DataQualityResult) Reset() {
	*x = DataQualityResult{}
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataQualityResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualityResult) ProtoMessage() {}

func (x *DataQualityResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualityResult.ProtoReflect.Descriptor instead.
func (*DataQualityResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{1}
}

func (x *DataQualityResult) GetPassed() bool {
	if x != nil {
		return x.Passed
	}
	return false
}

func (x *DataQualityResult) GetScore() float32 {
	if x != nil && x.Score != nil {
		return *x.Score
	}
	return 0
}

func (x *DataQualityResult) GetDimensions() []*DataQualityDimensionResult {
	if x != nil {
		return x.Dimensions
	}
	return nil
}

func (x *DataQualityResult) GetColumns() []*DataQualityColumnResult {
	if x != nil {
		return x.Columns
	}
	return nil
}

func (x *DataQualityResult) GetRules() []*DataQualityRuleResult {
	if x != nil {
		return x.Rules
	}
	return nil
}

func (x *DataQualityResult) GetRowCount() int64 {
	if x != nil {
		return x.RowCount
	}
	return 0
}

func (x *DataQualityResult) GetScannedData() *ScannedData {
	if x != nil {
		return x.ScannedData
	}
	return nil
}

func (x *DataQualityResult) GetPostScanActionsResult() *DataQualityResult_PostScanActionsResult {
	if x != nil {
		return x.PostScanActionsResult
	}
	return nil
}

func (x *DataQualityResult) GetCatalogPublishingStatus() *DataScanCatalogPublishingStatus {
	if x != nil {
		return x.CatalogPublishingStatus
	}
	return nil
}

func (x *DataQualityResult) GetAnomalyDetectionGeneratedAssets() *DataQualityResult_AnomalyDetectionGeneratedAssets {
	if x != nil {
		return x.AnomalyDetectionGeneratedAssets
	}
	return nil
}

// DataQualityRuleResult provides a more detailed, per-rule view of the results.
type DataQualityRuleResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The rule specified in the DataQualitySpec, as is.
	Rule *DataQualityRule `protobuf:"bytes,1,opt,name=rule,proto3" json:"rule,omitempty"`
	// Output only. Whether the rule passed or failed.
	Passed bool `protobuf:"varint,7,opt,name=passed,proto3" json:"passed,omitempty"`
	// Output only. The number of rows a rule was evaluated against.
	//
	// This field is only valid for row-level type rules.
	//
	// # Evaluated count can be configured to either
	//
	// * include all rows (default) - with `null` rows automatically failing rule
	// evaluation, or
	// * exclude `null` rows from the `evaluated_count`, by setting
	// `ignore_nulls = true`.
	//
	// This field is not set for rule SqlAssertion.
	EvaluatedCount int64 `protobuf:"varint,9,opt,name=evaluated_count,json=evaluatedCount,proto3" json:"evaluated_count,omitempty"`
	// Output only. The number of rows which passed a rule evaluation.
	//
	// This field is only valid for row-level type rules.
	//
	// This field is not set for rule SqlAssertion.
	PassedCount int64 `protobuf:"varint,8,opt,name=passed_count,json=passedCount,proto3" json:"passed_count,omitempty"`
	// Output only. The number of rows with null values in the specified column.
	NullCount int64 `protobuf:"varint,5,opt,name=null_count,json=nullCount,proto3" json:"null_count,omitempty"`
	// Output only. The ratio of **passed_count / evaluated_count**.
	//
	// This field is only valid for row-level type rules.
	PassRatio float64 `protobuf:"fixed64,6,opt,name=pass_ratio,json=passRatio,proto3" json:"pass_ratio,omitempty"`
	// Output only. The query to find rows that did not pass this rule.
	//
	// This field is only valid for row-level type rules.
	FailingRowsQuery string `protobuf:"bytes,10,opt,name=failing_rows_query,json=failingRowsQuery,proto3" json:"failing_rows_query,omitempty"`
	// Output only. The number of rows returned by the SQL statement in a SQL
	// assertion rule.
	//
	// This field is only valid for SQL assertion rules.
	AssertionRowCount int64 `protobuf:"varint,11,opt,name=assertion_row_count,json=assertionRowCount,proto3" json:"assertion_row_count,omitempty"`
}

func (x *DataQualityRuleResult) Reset() {
	*x = DataQualityRuleResult{}
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataQualityRuleResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualityRuleResult) ProtoMessage() {}

func (x *DataQualityRuleResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualityRuleResult.ProtoReflect.Descriptor instead.
func (*DataQualityRuleResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{2}
}

func (x *DataQualityRuleResult) GetRule() *DataQualityRule {
	if x != nil {
		return x.Rule
	}
	return nil
}

func (x *DataQualityRuleResult) GetPassed() bool {
	if x != nil {
		return x.Passed
	}
	return false
}

func (x *DataQualityRuleResult) GetEvaluatedCount() int64 {
	if x != nil {
		return x.EvaluatedCount
	}
	return 0
}

func (x *DataQualityRuleResult) GetPassedCount() int64 {
	if x != nil {
		return x.PassedCount
	}
	return 0
}

func (x *DataQualityRuleResult) GetNullCount() int64 {
	if x != nil {
		return x.NullCount
	}
	return 0
}

func (x *DataQualityRuleResult) GetPassRatio() float64 {
	if x != nil {
		return x.PassRatio
	}
	return 0
}

func (x *DataQualityRuleResult) GetFailingRowsQuery() string {
	if x != nil {
		return x.FailingRowsQuery
	}
	return ""
}

func (x *DataQualityRuleResult) GetAssertionRowCount() int64 {
	if x != nil {
		return x.AssertionRowCount
	}
	return 0
}

// DataQualityDimensionResult provides a more detailed, per-dimension view of
// the results.
type DataQualityDimensionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The dimension config specified in the DataQualitySpec, as is.
	Dimension *DataQualityDimension `protobuf:"bytes,1,opt,name=dimension,proto3" json:"dimension,omitempty"`
	// Output only. Whether the dimension passed or failed.
	Passed bool `protobuf:"varint,3,opt,name=passed,proto3" json:"passed,omitempty"`
	// Output only. The dimension-level data quality score for this data scan job
	// if and only if the 'dimension' field is set.
	//
	// The score ranges between [0, 100] (up to two decimal
	// points).
	Score *float32 `protobuf:"fixed32,4,opt,name=score,proto3,oneof" json:"score,omitempty"`
}

func (x *DataQualityDimensionResult) Reset() {
	*x = DataQualityDimensionResult{}
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataQualityDimensionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualityDimensionResult) ProtoMessage() {}

func (x *DataQualityDimensionResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualityDimensionResult.ProtoReflect.Descriptor instead.
func (*DataQualityDimensionResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{3}
}

func (x *DataQualityDimensionResult) GetDimension() *DataQualityDimension {
	if x != nil {
		return x.Dimension
	}
	return nil
}

func (x *DataQualityDimensionResult) GetPassed() bool {
	if x != nil {
		return x.Passed
	}
	return false
}

func (x *DataQualityDimensionResult) GetScore() float32 {
	if x != nil && x.Score != nil {
		return *x.Score
	}
	return 0
}

// A dimension captures data quality intent about a defined subset of the rules
// specified.
type DataQualityDimension struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The dimension name a rule belongs to. Custom dimension name is
	// supported with all uppercase letters and maximum length of 30 characters.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DataQualityDimension) Reset() {
	*x = DataQualityDimension{}
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataQualityDimension) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualityDimension) ProtoMessage() {}

func (x *DataQualityDimension) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualityDimension.ProtoReflect.Descriptor instead.
func (*DataQualityDimension) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{4}
}

func (x *DataQualityDimension) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A rule captures data quality intent about a data source.
type DataQualityRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The rule-specific configuration.
	//
	// Types that are assignable to RuleType:
	//
	//	*DataQualityRule_RangeExpectation_
	//	*DataQualityRule_NonNullExpectation_
	//	*DataQualityRule_SetExpectation_
	//	*DataQualityRule_RegexExpectation_
	//	*DataQualityRule_UniquenessExpectation_
	//	*DataQualityRule_StatisticRangeExpectation_
	//	*DataQualityRule_RowConditionExpectation_
	//	*DataQualityRule_TableConditionExpectation_
	//	*DataQualityRule_SqlAssertion_
	RuleType isDataQualityRule_RuleType `protobuf_oneof:"rule_type"`
	// Optional. The unnested column which this rule is evaluated against.
	Column string `protobuf:"bytes,500,opt,name=column,proto3" json:"column,omitempty"`
	// Optional. Rows with `null` values will automatically fail a rule, unless
	// `ignore_null` is `true`. In that case, such `null` rows are trivially
	// considered passing.
	//
	// This field is only valid for the following type of rules:
	//
	// * RangeExpectation
	// * RegexExpectation
	// * SetExpectation
	// * UniquenessExpectation
	IgnoreNull bool `protobuf:"varint,501,opt,name=ignore_null,json=ignoreNull,proto3" json:"ignore_null,omitempty"`
	// Required. The dimension a rule belongs to. Results are also aggregated at
	// the dimension level. Custom dimension name is supported with all uppercase
	// letters and maximum length of 30 characters.
	Dimension string `protobuf:"bytes,502,opt,name=dimension,proto3" json:"dimension,omitempty"`
	// Optional. The minimum ratio of **passing_rows / total_rows** required to
	// pass this rule, with a range of [0.0, 1.0].
	//
	// 0 indicates default value (i.e. 1.0).
	//
	// This field is only valid for row-level type rules.
	Threshold float64 `protobuf:"fixed64,503,opt,name=threshold,proto3" json:"threshold,omitempty"`
	// Optional. A mutable name for the rule.
	//
	// * The name must contain only letters (a-z, A-Z), numbers (0-9), or
	// hyphens (-).
	// * The maximum length is 63 characters.
	// * Must start with a letter.
	// * Must end with a number or a letter.
	Name string `protobuf:"bytes,504,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Description of the rule.
	//
	// * The maximum length is 1,024 characters.
	Description string `protobuf:"bytes,505,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. Whether the Rule is active or suspended.
	// Default is false.
	Suspended bool `protobuf:"varint,506,opt,name=suspended,proto3" json:"suspended,omitempty"`
}

func (x *DataQualityRule) Reset() {
	*x = DataQualityRule{}
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataQualityRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualityRule) ProtoMessage() {}

func (x *DataQualityRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualityRule.ProtoReflect.Descriptor instead.
func (*DataQualityRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{5}
}

func (m *DataQualityRule) GetRuleType() isDataQualityRule_RuleType {
	if m != nil {
		return m.RuleType
	}
	return nil
}

func (x *DataQualityRule) GetRangeExpectation() *DataQualityRule_RangeExpectation {
	if x, ok := x.GetRuleType().(*DataQualityRule_RangeExpectation_); ok {
		return x.RangeExpectation
	}
	return nil
}

func (x *DataQualityRule) GetNonNullExpectation() *DataQualityRule_NonNullExpectation {
	if x, ok := x.GetRuleType().(*DataQualityRule_NonNullExpectation_); ok {
		return x.NonNullExpectation
	}
	return nil
}

func (x *DataQualityRule) GetSetExpectation() *DataQualityRule_SetExpectation {
	if x, ok := x.GetRuleType().(*DataQualityRule_SetExpectation_); ok {
		return x.SetExpectation
	}
	return nil
}

func (x *DataQualityRule) GetRegexExpectation() *DataQualityRule_RegexExpectation {
	if x, ok := x.GetRuleType().(*DataQualityRule_RegexExpectation_); ok {
		return x.RegexExpectation
	}
	return nil
}

func (x *DataQualityRule) GetUniquenessExpectation() *DataQualityRule_UniquenessExpectation {
	if x, ok := x.GetRuleType().(*DataQualityRule_UniquenessExpectation_); ok {
		return x.UniquenessExpectation
	}
	return nil
}

func (x *DataQualityRule) GetStatisticRangeExpectation() *DataQualityRule_StatisticRangeExpectation {
	if x, ok := x.GetRuleType().(*DataQualityRule_StatisticRangeExpectation_); ok {
		return x.StatisticRangeExpectation
	}
	return nil
}

func (x *DataQualityRule) GetRowConditionExpectation() *DataQualityRule_RowConditionExpectation {
	if x, ok := x.GetRuleType().(*DataQualityRule_RowConditionExpectation_); ok {
		return x.RowConditionExpectation
	}
	return nil
}

func (x *DataQualityRule) GetTableConditionExpectation() *DataQualityRule_TableConditionExpectation {
	if x, ok := x.GetRuleType().(*DataQualityRule_TableConditionExpectation_); ok {
		return x.TableConditionExpectation
	}
	return nil
}

func (x *DataQualityRule) GetSqlAssertion() *DataQualityRule_SqlAssertion {
	if x, ok := x.GetRuleType().(*DataQualityRule_SqlAssertion_); ok {
		return x.SqlAssertion
	}
	return nil
}

func (x *DataQualityRule) GetColumn() string {
	if x != nil {
		return x.Column
	}
	return ""
}

func (x *DataQualityRule) GetIgnoreNull() bool {
	if x != nil {
		return x.IgnoreNull
	}
	return false
}

func (x *DataQualityRule) GetDimension() string {
	if x != nil {
		return x.Dimension
	}
	return ""
}

func (x *DataQualityRule) GetThreshold() float64 {
	if x != nil {
		return x.Threshold
	}
	return 0
}

func (x *DataQualityRule) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DataQualityRule) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *DataQualityRule) GetSuspended() bool {
	if x != nil {
		return x.Suspended
	}
	return false
}

type isDataQualityRule_RuleType interface {
	isDataQualityRule_RuleType()
}

type DataQualityRule_RangeExpectation_ struct {
	// Row-level rule which evaluates whether each column value lies between a
	// specified range.
	RangeExpectation *DataQualityRule_RangeExpectation `protobuf:"bytes,1,opt,name=range_expectation,json=rangeExpectation,proto3,oneof"`
}

type DataQualityRule_NonNullExpectation_ struct {
	// Row-level rule which evaluates whether each column value is null.
	NonNullExpectation *DataQualityRule_NonNullExpectation `protobuf:"bytes,2,opt,name=non_null_expectation,json=nonNullExpectation,proto3,oneof"`
}

type DataQualityRule_SetExpectation_ struct {
	// Row-level rule which evaluates whether each column value is contained by
	// a specified set.
	SetExpectation *DataQualityRule_SetExpectation `protobuf:"bytes,3,opt,name=set_expectation,json=setExpectation,proto3,oneof"`
}

type DataQualityRule_RegexExpectation_ struct {
	// Row-level rule which evaluates whether each column value matches a
	// specified regex.
	RegexExpectation *DataQualityRule_RegexExpectation `protobuf:"bytes,4,opt,name=regex_expectation,json=regexExpectation,proto3,oneof"`
}

type DataQualityRule_UniquenessExpectation_ struct {
	// Row-level rule which evaluates whether each column value is unique.
	UniquenessExpectation *DataQualityRule_UniquenessExpectation `protobuf:"bytes,100,opt,name=uniqueness_expectation,json=uniquenessExpectation,proto3,oneof"`
}

type DataQualityRule_StatisticRangeExpectation_ struct {
	// Aggregate rule which evaluates whether the column aggregate
	// statistic lies between a specified range.
	StatisticRangeExpectation *DataQualityRule_StatisticRangeExpectation `protobuf:"bytes,101,opt,name=statistic_range_expectation,json=statisticRangeExpectation,proto3,oneof"`
}

type DataQualityRule_RowConditionExpectation_ struct {
	// Row-level rule which evaluates whether each row in a table passes the
	// specified condition.
	RowConditionExpectation *DataQualityRule_RowConditionExpectation `protobuf:"bytes,200,opt,name=row_condition_expectation,json=rowConditionExpectation,proto3,oneof"`
}

type DataQualityRule_TableConditionExpectation_ struct {
	// Aggregate rule which evaluates whether the provided expression is true
	// for a table.
	TableConditionExpectation *DataQualityRule_TableConditionExpectation `protobuf:"bytes,201,opt,name=table_condition_expectation,json=tableConditionExpectation,proto3,oneof"`
}

type DataQualityRule_SqlAssertion_ struct {
	// Aggregate rule which evaluates the number of rows returned for the
	// provided statement. If any rows are returned, this rule fails.
	SqlAssertion *DataQualityRule_SqlAssertion `protobuf:"bytes,202,opt,name=sql_assertion,json=sqlAssertion,proto3,oneof"`
}

func (*DataQualityRule_RangeExpectation_) isDataQualityRule_RuleType() {}

func (*DataQualityRule_NonNullExpectation_) isDataQualityRule_RuleType() {}

func (*DataQualityRule_SetExpectation_) isDataQualityRule_RuleType() {}

func (*DataQualityRule_RegexExpectation_) isDataQualityRule_RuleType() {}

func (*DataQualityRule_UniquenessExpectation_) isDataQualityRule_RuleType() {}

func (*DataQualityRule_StatisticRangeExpectation_) isDataQualityRule_RuleType() {}

func (*DataQualityRule_RowConditionExpectation_) isDataQualityRule_RuleType() {}

func (*DataQualityRule_TableConditionExpectation_) isDataQualityRule_RuleType() {}

func (*DataQualityRule_SqlAssertion_) isDataQualityRule_RuleType() {}

// DataQualityColumnResult provides a more detailed, per-column view of
// the results.
type DataQualityColumnResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The column specified in the DataQualityRule.
	Column string `protobuf:"bytes,1,opt,name=column,proto3" json:"column,omitempty"`
	// Output only. The column-level data quality score for this data scan job if
	// and only if the 'column' field is set.
	//
	// The score ranges between between [0, 100] (up to two decimal
	// points).
	Score *float32 `protobuf:"fixed32,2,opt,name=score,proto3,oneof" json:"score,omitempty"`
	// Output only. Whether the column passed or failed.
	Passed bool `protobuf:"varint,3,opt,name=passed,proto3" json:"passed,omitempty"`
	// Output only. The dimension-level results for this column.
	Dimensions []*DataQualityDimensionResult `protobuf:"bytes,4,rep,name=dimensions,proto3" json:"dimensions,omitempty"`
}

func (x *DataQualityColumnResult) Reset() {
	*x = DataQualityColumnResult{}
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataQualityColumnResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualityColumnResult) ProtoMessage() {}

func (x *DataQualityColumnResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualityColumnResult.ProtoReflect.Descriptor instead.
func (*DataQualityColumnResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{6}
}

func (x *DataQualityColumnResult) GetColumn() string {
	if x != nil {
		return x.Column
	}
	return ""
}

func (x *DataQualityColumnResult) GetScore() float32 {
	if x != nil && x.Score != nil {
		return *x.Score
	}
	return 0
}

func (x *DataQualityColumnResult) GetPassed() bool {
	if x != nil {
		return x.Passed
	}
	return false
}

func (x *DataQualityColumnResult) GetDimensions() []*DataQualityDimensionResult {
	if x != nil {
		return x.Dimensions
	}
	return nil
}

// The configuration of post scan actions of DataQualityScan.
type DataQualitySpec_PostScanActions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. If set, results will be exported to the provided BigQuery
	// table.
	BigqueryExport *DataQualitySpec_PostScanActions_BigQueryExport `protobuf:"bytes,1,opt,name=bigquery_export,json=bigqueryExport,proto3" json:"bigquery_export,omitempty"`
	// Optional. If set, results will be sent to the provided notification
	// receipts upon triggers.
	NotificationReport *DataQualitySpec_PostScanActions_NotificationReport `protobuf:"bytes,2,opt,name=notification_report,json=notificationReport,proto3" json:"notification_report,omitempty"`
}

func (x *DataQualitySpec_PostScanActions) Reset() {
	*x = DataQualitySpec_PostScanActions{}
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataQualitySpec_PostScanActions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualitySpec_PostScanActions) ProtoMessage() {}

func (x *DataQualitySpec_PostScanActions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualitySpec_PostScanActions.ProtoReflect.Descriptor instead.
func (*DataQualitySpec_PostScanActions) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{0, 0}
}

func (x *DataQualitySpec_PostScanActions) GetBigqueryExport() *DataQualitySpec_PostScanActions_BigQueryExport {
	if x != nil {
		return x.BigqueryExport
	}
	return nil
}

func (x *DataQualitySpec_PostScanActions) GetNotificationReport() *DataQualitySpec_PostScanActions_NotificationReport {
	if x != nil {
		return x.NotificationReport
	}
	return nil
}

// The configuration of BigQuery export post scan action.
type DataQualitySpec_PostScanActions_BigQueryExport struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The BigQuery table to export DataQualityScan results to.
	// Format:
	// //bigquery.googleapis.com/projects/PROJECT_ID/datasets/DATASET_ID/tables/TABLE_ID
	// or
	// projects/PROJECT_ID/datasets/DATASET_ID/tables/TABLE_ID
	ResultsTable string `protobuf:"bytes,1,opt,name=results_table,json=resultsTable,proto3" json:"results_table,omitempty"`
}

func (x *DataQualitySpec_PostScanActions_BigQueryExport) Reset() {
	*x = DataQualitySpec_PostScanActions_BigQueryExport{}
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataQualitySpec_PostScanActions_BigQueryExport) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualitySpec_PostScanActions_BigQueryExport) ProtoMessage() {}

func (x *DataQualitySpec_PostScanActions_BigQueryExport) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualitySpec_PostScanActions_BigQueryExport.ProtoReflect.Descriptor instead.
func (*DataQualitySpec_PostScanActions_BigQueryExport) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *DataQualitySpec_PostScanActions_BigQueryExport) GetResultsTable() string {
	if x != nil {
		return x.ResultsTable
	}
	return ""
}

// The individuals or groups who are designated to receive notifications
// upon triggers.
type DataQualitySpec_PostScanActions_Recipients struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The email recipients who will receive the DataQualityScan
	// results report.
	Emails []string `protobuf:"bytes,1,rep,name=emails,proto3" json:"emails,omitempty"`
}

func (x *DataQualitySpec_PostScanActions_Recipients) Reset() {
	*x = DataQualitySpec_PostScanActions_Recipients{}
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataQualitySpec_PostScanActions_Recipients) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualitySpec_PostScanActions_Recipients) ProtoMessage() {}

func (x *DataQualitySpec_PostScanActions_Recipients) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualitySpec_PostScanActions_Recipients.ProtoReflect.Descriptor instead.
func (*DataQualitySpec_PostScanActions_Recipients) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{0, 0, 1}
}

func (x *DataQualitySpec_PostScanActions_Recipients) GetEmails() []string {
	if x != nil {
		return x.Emails
	}
	return nil
}

// This trigger is triggered when the DQ score in the job result is less
// than a specified input score.
type DataQualitySpec_PostScanActions_ScoreThresholdTrigger struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The score range is in [0,100].
	ScoreThreshold float32 `protobuf:"fixed32,2,opt,name=score_threshold,json=scoreThreshold,proto3" json:"score_threshold,omitempty"`
}

func (x *DataQualitySpec_PostScanActions_ScoreThresholdTrigger) Reset() {
	*x = DataQualitySpec_PostScanActions_ScoreThresholdTrigger{}
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataQualitySpec_PostScanActions_ScoreThresholdTrigger) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualitySpec_PostScanActions_ScoreThresholdTrigger) ProtoMessage() {}

func (x *DataQualitySpec_PostScanActions_ScoreThresholdTrigger) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualitySpec_PostScanActions_ScoreThresholdTrigger.ProtoReflect.Descriptor instead.
func (*DataQualitySpec_PostScanActions_ScoreThresholdTrigger) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{0, 0, 2}
}

func (x *DataQualitySpec_PostScanActions_ScoreThresholdTrigger) GetScoreThreshold() float32 {
	if x != nil {
		return x.ScoreThreshold
	}
	return 0
}

// This trigger is triggered when the scan job itself fails, regardless of
// the result.
type DataQualitySpec_PostScanActions_JobFailureTrigger struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DataQualitySpec_PostScanActions_JobFailureTrigger) Reset() {
	*x = DataQualitySpec_PostScanActions_JobFailureTrigger{}
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataQualitySpec_PostScanActions_JobFailureTrigger) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualitySpec_PostScanActions_JobFailureTrigger) ProtoMessage() {}

func (x *DataQualitySpec_PostScanActions_JobFailureTrigger) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualitySpec_PostScanActions_JobFailureTrigger.ProtoReflect.Descriptor instead.
func (*DataQualitySpec_PostScanActions_JobFailureTrigger) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{0, 0, 3}
}

// This trigger is triggered whenever a scan job run ends, regardless
// of the result.
type DataQualitySpec_PostScanActions_JobEndTrigger struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DataQualitySpec_PostScanActions_JobEndTrigger) Reset() {
	*x = DataQualitySpec_PostScanActions_JobEndTrigger{}
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataQualitySpec_PostScanActions_JobEndTrigger) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualitySpec_PostScanActions_JobEndTrigger) ProtoMessage() {}

func (x *DataQualitySpec_PostScanActions_JobEndTrigger) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualitySpec_PostScanActions_JobEndTrigger.ProtoReflect.Descriptor instead.
func (*DataQualitySpec_PostScanActions_JobEndTrigger) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{0, 0, 4}
}

// The configuration of notification report post scan action.
type DataQualitySpec_PostScanActions_NotificationReport struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The recipients who will receive the notification report.
	Recipients *DataQualitySpec_PostScanActions_Recipients `protobuf:"bytes,1,opt,name=recipients,proto3" json:"recipients,omitempty"`
	// Optional. If set, report will be sent when score threshold is met.
	ScoreThresholdTrigger *DataQualitySpec_PostScanActions_ScoreThresholdTrigger `protobuf:"bytes,2,opt,name=score_threshold_trigger,json=scoreThresholdTrigger,proto3" json:"score_threshold_trigger,omitempty"`
	// Optional. If set, report will be sent when a scan job fails.
	JobFailureTrigger *DataQualitySpec_PostScanActions_JobFailureTrigger `protobuf:"bytes,4,opt,name=job_failure_trigger,json=jobFailureTrigger,proto3" json:"job_failure_trigger,omitempty"`
	// Optional. If set, report will be sent when a scan job ends.
	JobEndTrigger *DataQualitySpec_PostScanActions_JobEndTrigger `protobuf:"bytes,5,opt,name=job_end_trigger,json=jobEndTrigger,proto3" json:"job_end_trigger,omitempty"`
}

func (x *DataQualitySpec_PostScanActions_NotificationReport) Reset() {
	*x = DataQualitySpec_PostScanActions_NotificationReport{}
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataQualitySpec_PostScanActions_NotificationReport) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualitySpec_PostScanActions_NotificationReport) ProtoMessage() {}

func (x *DataQualitySpec_PostScanActions_NotificationReport) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualitySpec_PostScanActions_NotificationReport.ProtoReflect.Descriptor instead.
func (*DataQualitySpec_PostScanActions_NotificationReport) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{0, 0, 5}
}

func (x *DataQualitySpec_PostScanActions_NotificationReport) GetRecipients() *DataQualitySpec_PostScanActions_Recipients {
	if x != nil {
		return x.Recipients
	}
	return nil
}

func (x *DataQualitySpec_PostScanActions_NotificationReport) GetScoreThresholdTrigger() *DataQualitySpec_PostScanActions_ScoreThresholdTrigger {
	if x != nil {
		return x.ScoreThresholdTrigger
	}
	return nil
}

func (x *DataQualitySpec_PostScanActions_NotificationReport) GetJobFailureTrigger() *DataQualitySpec_PostScanActions_JobFailureTrigger {
	if x != nil {
		return x.JobFailureTrigger
	}
	return nil
}

func (x *DataQualitySpec_PostScanActions_NotificationReport) GetJobEndTrigger() *DataQualitySpec_PostScanActions_JobEndTrigger {
	if x != nil {
		return x.JobEndTrigger
	}
	return nil
}

// The result of post scan actions of DataQualityScan job.
type DataQualityResult_PostScanActionsResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The result of BigQuery export post scan action.
	BigqueryExportResult *DataQualityResult_PostScanActionsResult_BigQueryExportResult `protobuf:"bytes,1,opt,name=bigquery_export_result,json=bigqueryExportResult,proto3" json:"bigquery_export_result,omitempty"`
}

func (x *DataQualityResult_PostScanActionsResult) Reset() {
	*x = DataQualityResult_PostScanActionsResult{}
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataQualityResult_PostScanActionsResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualityResult_PostScanActionsResult) ProtoMessage() {}

func (x *DataQualityResult_PostScanActionsResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualityResult_PostScanActionsResult.ProtoReflect.Descriptor instead.
func (*DataQualityResult_PostScanActionsResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{1, 0}
}

func (x *DataQualityResult_PostScanActionsResult) GetBigqueryExportResult() *DataQualityResult_PostScanActionsResult_BigQueryExportResult {
	if x != nil {
		return x.BigqueryExportResult
	}
	return nil
}

// The assets generated by Anomaly Detection Data Scan.
type DataQualityResult_AnomalyDetectionGeneratedAssets struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The result table for anomaly detection.
	// Format:
	// PROJECT_ID.DATASET_ID.TABLE_ID
	// If the result table is set at AnomalyDetectionAssets, the result table
	// here would be the same as the one set in the
	// AnomalyDetectionAssets.result_table.
	ResultTable string `protobuf:"bytes,1,opt,name=result_table,json=resultTable,proto3" json:"result_table,omitempty"`
	// Output only. The intermediate table for data anomaly detection.
	// Format:
	// PROJECT_ID.DATASET_ID.TABLE_ID
	DataIntermediateTable string `protobuf:"bytes,2,opt,name=data_intermediate_table,json=dataIntermediateTable,proto3" json:"data_intermediate_table,omitempty"`
	// Output only. The intermediate table for freshness anomaly detection.
	// Format:
	// PROJECT_ID.DATASET_ID.TABLE_ID
	FreshnessIntermediateTable string `protobuf:"bytes,3,opt,name=freshness_intermediate_table,json=freshnessIntermediateTable,proto3" json:"freshness_intermediate_table,omitempty"`
	// Output only. The intermediate table for volume anomaly detection.
	// Format:
	// PROJECT_ID.DATASET_ID.TABLE_ID
	VolumeIntermediateTable string `protobuf:"bytes,4,opt,name=volume_intermediate_table,json=volumeIntermediateTable,proto3" json:"volume_intermediate_table,omitempty"`
}

func (x *DataQualityResult_AnomalyDetectionGeneratedAssets) Reset() {
	*x = DataQualityResult_AnomalyDetectionGeneratedAssets{}
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataQualityResult_AnomalyDetectionGeneratedAssets) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualityResult_AnomalyDetectionGeneratedAssets) ProtoMessage() {}

func (x *DataQualityResult_AnomalyDetectionGeneratedAssets) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualityResult_AnomalyDetectionGeneratedAssets.ProtoReflect.Descriptor instead.
func (*DataQualityResult_AnomalyDetectionGeneratedAssets) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{1, 1}
}

func (x *DataQualityResult_AnomalyDetectionGeneratedAssets) GetResultTable() string {
	if x != nil {
		return x.ResultTable
	}
	return ""
}

func (x *DataQualityResult_AnomalyDetectionGeneratedAssets) GetDataIntermediateTable() string {
	if x != nil {
		return x.DataIntermediateTable
	}
	return ""
}

func (x *DataQualityResult_AnomalyDetectionGeneratedAssets) GetFreshnessIntermediateTable() string {
	if x != nil {
		return x.FreshnessIntermediateTable
	}
	return ""
}

func (x *DataQualityResult_AnomalyDetectionGeneratedAssets) GetVolumeIntermediateTable() string {
	if x != nil {
		return x.VolumeIntermediateTable
	}
	return ""
}

// The result of BigQuery export post scan action.
type DataQualityResult_PostScanActionsResult_BigQueryExportResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Execution state for the BigQuery exporting.
	State DataQualityResult_PostScanActionsResult_BigQueryExportResult_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.dataplex.v1.DataQualityResult_PostScanActionsResult_BigQueryExportResult_State" json:"state,omitempty"`
	// Output only. Additional information about the BigQuery exporting.
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *DataQualityResult_PostScanActionsResult_BigQueryExportResult) Reset() {
	*x = DataQualityResult_PostScanActionsResult_BigQueryExportResult{}
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataQualityResult_PostScanActionsResult_BigQueryExportResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualityResult_PostScanActionsResult_BigQueryExportResult) ProtoMessage() {}

func (x *DataQualityResult_PostScanActionsResult_BigQueryExportResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualityResult_PostScanActionsResult_BigQueryExportResult.ProtoReflect.Descriptor instead.
func (*DataQualityResult_PostScanActionsResult_BigQueryExportResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{1, 0, 0}
}

func (x *DataQualityResult_PostScanActionsResult_BigQueryExportResult) GetState() DataQualityResult_PostScanActionsResult_BigQueryExportResult_State {
	if x != nil {
		return x.State
	}
	return DataQualityResult_PostScanActionsResult_BigQueryExportResult_STATE_UNSPECIFIED
}

func (x *DataQualityResult_PostScanActionsResult_BigQueryExportResult) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

// Evaluates whether each column value lies between a specified range.
type DataQualityRule_RangeExpectation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The minimum column value allowed for a row to pass this
	// validation. At least one of `min_value` and `max_value` need to be
	// provided.
	MinValue string `protobuf:"bytes,1,opt,name=min_value,json=minValue,proto3" json:"min_value,omitempty"`
	// Optional. The maximum column value allowed for a row to pass this
	// validation. At least one of `min_value` and `max_value` need to be
	// provided.
	MaxValue string `protobuf:"bytes,2,opt,name=max_value,json=maxValue,proto3" json:"max_value,omitempty"`
	// Optional. Whether each value needs to be strictly greater than ('>') the
	// minimum, or if equality is allowed.
	//
	// Only relevant if a `min_value` has been defined. Default = false.
	StrictMinEnabled bool `protobuf:"varint,3,opt,name=strict_min_enabled,json=strictMinEnabled,proto3" json:"strict_min_enabled,omitempty"`
	// Optional. Whether each value needs to be strictly lesser than ('<') the
	// maximum, or if equality is allowed.
	//
	// Only relevant if a `max_value` has been defined. Default = false.
	StrictMaxEnabled bool `protobuf:"varint,4,opt,name=strict_max_enabled,json=strictMaxEnabled,proto3" json:"strict_max_enabled,omitempty"`
}

func (x *DataQualityRule_RangeExpectation) Reset() {
	*x = DataQualityRule_RangeExpectation{}
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataQualityRule_RangeExpectation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualityRule_RangeExpectation) ProtoMessage() {}

func (x *DataQualityRule_RangeExpectation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualityRule_RangeExpectation.ProtoReflect.Descriptor instead.
func (*DataQualityRule_RangeExpectation) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{5, 0}
}

func (x *DataQualityRule_RangeExpectation) GetMinValue() string {
	if x != nil {
		return x.MinValue
	}
	return ""
}

func (x *DataQualityRule_RangeExpectation) GetMaxValue() string {
	if x != nil {
		return x.MaxValue
	}
	return ""
}

func (x *DataQualityRule_RangeExpectation) GetStrictMinEnabled() bool {
	if x != nil {
		return x.StrictMinEnabled
	}
	return false
}

func (x *DataQualityRule_RangeExpectation) GetStrictMaxEnabled() bool {
	if x != nil {
		return x.StrictMaxEnabled
	}
	return false
}

// Evaluates whether each column value is null.
type DataQualityRule_NonNullExpectation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DataQualityRule_NonNullExpectation) Reset() {
	*x = DataQualityRule_NonNullExpectation{}
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataQualityRule_NonNullExpectation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualityRule_NonNullExpectation) ProtoMessage() {}

func (x *DataQualityRule_NonNullExpectation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualityRule_NonNullExpectation.ProtoReflect.Descriptor instead.
func (*DataQualityRule_NonNullExpectation) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{5, 1}
}

// Evaluates whether each column value is contained by a specified set.
type DataQualityRule_SetExpectation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Expected values for the column value.
	Values []string `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *DataQualityRule_SetExpectation) Reset() {
	*x = DataQualityRule_SetExpectation{}
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataQualityRule_SetExpectation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualityRule_SetExpectation) ProtoMessage() {}

func (x *DataQualityRule_SetExpectation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualityRule_SetExpectation.ProtoReflect.Descriptor instead.
func (*DataQualityRule_SetExpectation) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{5, 2}
}

func (x *DataQualityRule_SetExpectation) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

// Evaluates whether each column value matches a specified regex.
type DataQualityRule_RegexExpectation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A regular expression the column value is expected to match.
	Regex string `protobuf:"bytes,1,opt,name=regex,proto3" json:"regex,omitempty"`
}

func (x *DataQualityRule_RegexExpectation) Reset() {
	*x = DataQualityRule_RegexExpectation{}
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataQualityRule_RegexExpectation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualityRule_RegexExpectation) ProtoMessage() {}

func (x *DataQualityRule_RegexExpectation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualityRule_RegexExpectation.ProtoReflect.Descriptor instead.
func (*DataQualityRule_RegexExpectation) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{5, 3}
}

func (x *DataQualityRule_RegexExpectation) GetRegex() string {
	if x != nil {
		return x.Regex
	}
	return ""
}

// Evaluates whether the column has duplicates.
type DataQualityRule_UniquenessExpectation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DataQualityRule_UniquenessExpectation) Reset() {
	*x = DataQualityRule_UniquenessExpectation{}
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataQualityRule_UniquenessExpectation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualityRule_UniquenessExpectation) ProtoMessage() {}

func (x *DataQualityRule_UniquenessExpectation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualityRule_UniquenessExpectation.ProtoReflect.Descriptor instead.
func (*DataQualityRule_UniquenessExpectation) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{5, 4}
}

// Evaluates whether the column aggregate statistic lies between a specified
// range.
type DataQualityRule_StatisticRangeExpectation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The aggregate metric to evaluate.
	Statistic DataQualityRule_StatisticRangeExpectation_ColumnStatistic `protobuf:"varint,1,opt,name=statistic,proto3,enum=google.cloud.dataplex.v1.DataQualityRule_StatisticRangeExpectation_ColumnStatistic" json:"statistic,omitempty"`
	// Optional. The minimum column statistic value allowed for a row to pass
	// this validation.
	//
	// At least one of `min_value` and `max_value` need to be provided.
	MinValue string `protobuf:"bytes,2,opt,name=min_value,json=minValue,proto3" json:"min_value,omitempty"`
	// Optional. The maximum column statistic value allowed for a row to pass
	// this validation.
	//
	// At least one of `min_value` and `max_value` need to be provided.
	MaxValue string `protobuf:"bytes,3,opt,name=max_value,json=maxValue,proto3" json:"max_value,omitempty"`
	// Optional. Whether column statistic needs to be strictly greater than
	// ('>') the minimum, or if equality is allowed.
	//
	// Only relevant if a `min_value` has been defined. Default = false.
	StrictMinEnabled bool `protobuf:"varint,4,opt,name=strict_min_enabled,json=strictMinEnabled,proto3" json:"strict_min_enabled,omitempty"`
	// Optional. Whether column statistic needs to be strictly lesser than ('<')
	// the maximum, or if equality is allowed.
	//
	// Only relevant if a `max_value` has been defined. Default = false.
	StrictMaxEnabled bool `protobuf:"varint,5,opt,name=strict_max_enabled,json=strictMaxEnabled,proto3" json:"strict_max_enabled,omitempty"`
}

func (x *DataQualityRule_StatisticRangeExpectation) Reset() {
	*x = DataQualityRule_StatisticRangeExpectation{}
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataQualityRule_StatisticRangeExpectation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualityRule_StatisticRangeExpectation) ProtoMessage() {}

func (x *DataQualityRule_StatisticRangeExpectation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualityRule_StatisticRangeExpectation.ProtoReflect.Descriptor instead.
func (*DataQualityRule_StatisticRangeExpectation) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{5, 5}
}

func (x *DataQualityRule_StatisticRangeExpectation) GetStatistic() DataQualityRule_StatisticRangeExpectation_ColumnStatistic {
	if x != nil {
		return x.Statistic
	}
	return DataQualityRule_StatisticRangeExpectation_STATISTIC_UNDEFINED
}

func (x *DataQualityRule_StatisticRangeExpectation) GetMinValue() string {
	if x != nil {
		return x.MinValue
	}
	return ""
}

func (x *DataQualityRule_StatisticRangeExpectation) GetMaxValue() string {
	if x != nil {
		return x.MaxValue
	}
	return ""
}

func (x *DataQualityRule_StatisticRangeExpectation) GetStrictMinEnabled() bool {
	if x != nil {
		return x.StrictMinEnabled
	}
	return false
}

func (x *DataQualityRule_StatisticRangeExpectation) GetStrictMaxEnabled() bool {
	if x != nil {
		return x.StrictMaxEnabled
	}
	return false
}

// Evaluates whether each row passes the specified condition.
//
// The SQL expression needs to use [GoogleSQL
// syntax](https://cloud.google.com/bigquery/docs/reference/standard-sql/query-syntax)
// and should produce a boolean value per row as the result.
//
// Example: col1 >= 0 AND col2 < 10
type DataQualityRule_RowConditionExpectation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The SQL expression.
	SqlExpression string `protobuf:"bytes,1,opt,name=sql_expression,json=sqlExpression,proto3" json:"sql_expression,omitempty"`
}

func (x *DataQualityRule_RowConditionExpectation) Reset() {
	*x = DataQualityRule_RowConditionExpectation{}
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataQualityRule_RowConditionExpectation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualityRule_RowConditionExpectation) ProtoMessage() {}

func (x *DataQualityRule_RowConditionExpectation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualityRule_RowConditionExpectation.ProtoReflect.Descriptor instead.
func (*DataQualityRule_RowConditionExpectation) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{5, 6}
}

func (x *DataQualityRule_RowConditionExpectation) GetSqlExpression() string {
	if x != nil {
		return x.SqlExpression
	}
	return ""
}

// Evaluates whether the provided expression is true.
//
// The SQL expression needs to use [GoogleSQL
// syntax](https://cloud.google.com/bigquery/docs/reference/standard-sql/query-syntax)
// and should produce a scalar boolean result.
//
// Example: MIN(col1) >= 0
type DataQualityRule_TableConditionExpectation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The SQL expression.
	SqlExpression string `protobuf:"bytes,1,opt,name=sql_expression,json=sqlExpression,proto3" json:"sql_expression,omitempty"`
}

func (x *DataQualityRule_TableConditionExpectation) Reset() {
	*x = DataQualityRule_TableConditionExpectation{}
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataQualityRule_TableConditionExpectation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualityRule_TableConditionExpectation) ProtoMessage() {}

func (x *DataQualityRule_TableConditionExpectation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualityRule_TableConditionExpectation.ProtoReflect.Descriptor instead.
func (*DataQualityRule_TableConditionExpectation) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{5, 7}
}

func (x *DataQualityRule_TableConditionExpectation) GetSqlExpression() string {
	if x != nil {
		return x.SqlExpression
	}
	return ""
}

// A SQL statement that is evaluated to return rows that match an invalid
// state. If any rows are are returned, this rule fails.
//
// The SQL statement must use [GoogleSQL
// syntax](https://cloud.google.com/bigquery/docs/reference/standard-sql/query-syntax),
// and must not contain any semicolons.
//
// You can use the data reference parameter `${data()}` to reference the
// source table with all of its precondition filters applied. Examples of
// precondition filters include row filters, incremental data filters, and
// sampling. For more information, see [Data reference
// parameter](https://cloud.google.com/dataplex/docs/auto-data-quality-overview#data-reference-parameter).
//
// Example: `SELECT * FROM ${data()} WHERE price < 0`
type DataQualityRule_SqlAssertion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The SQL statement.
	SqlStatement string `protobuf:"bytes,1,opt,name=sql_statement,json=sqlStatement,proto3" json:"sql_statement,omitempty"`
}

func (x *DataQualityRule_SqlAssertion) Reset() {
	*x = DataQualityRule_SqlAssertion{}
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataQualityRule_SqlAssertion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataQualityRule_SqlAssertion) ProtoMessage() {}

func (x *DataQualityRule_SqlAssertion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataQualityRule_SqlAssertion.ProtoReflect.Descriptor instead.
func (*DataQualityRule_SqlAssertion) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP(), []int{5, 8}
}

func (x *DataQualityRule_SqlAssertion) GetSqlStatement() string {
	if x != nil {
		return x.SqlStatement
	}
	return ""
}

var File_google_cloud_dataplex_v1_data_quality_proto protoreflect.FileDescriptor

var file_google_cloud_dataplex_v1_data_quality_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x63, 0x61, 0x6e, 0x73, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x76, 0x31, 0x2f, 0x70,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xc9, 0x0a, 0x0a, 0x0f, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53,
	0x70, 0x65, 0x63, 0x12, 0x44, 0x0a, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x2e, 0x0a, 0x10, 0x73, 0x61, 0x6d,
	0x70, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x69,
	0x6e, 0x67, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x6f, 0x77,
	0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x72, 0x6f, 0x77, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x6a, 0x0a,
	0x11, 0x70, 0x6f, 0x73, 0x74, 0x5f, 0x73, 0x63, 0x61, 0x6e, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53,
	0x70, 0x65, 0x63, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x53, 0x63, 0x61, 0x6e, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x70, 0x6f, 0x73, 0x74, 0x53, 0x63,
	0x61, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x41, 0x0a, 0x1a, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x69, 0x6e, 0x67, 0x5f,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x18, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x50, 0x75, 0x62, 0x6c, 0x69,
	0x73, 0x68, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x1a, 0xec, 0x07, 0x0a,
	0x0f, 0x50, 0x6f, 0x73, 0x74, 0x53, 0x63, 0x61, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x76, 0x0a, 0x0f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79,
	0x53, 0x70, 0x65, 0x63, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x53, 0x63, 0x61, 0x6e, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x82, 0x01, 0x0a, 0x13, 0x6e, 0x6f, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x70, 0x65,
	0x63, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x53, 0x63, 0x61, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x6e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x1a, 0x3a, 0x0a,
	0x0e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x12,
	0x28, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x1a, 0x29, 0x0a, 0x0a, 0x52, 0x65, 0x63,
	0x69, 0x70, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x1b, 0x0a, 0x06, 0x65, 0x6d, 0x61, 0x69, 0x6c,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x65, 0x6d,
	0x61, 0x69, 0x6c, 0x73, 0x1a, 0x45, 0x0a, 0x15, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x54, 0x68, 0x72,
	0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0x2c, 0x0a,
	0x0f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x63, 0x6f,
	0x72, 0x65, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x1a, 0x13, 0x0a, 0x11, 0x4a,
	0x6f, 0x62, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72,
	0x1a, 0x0f, 0x0a, 0x0d, 0x4a, 0x6f, 0x62, 0x45, 0x6e, 0x64, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65,
	0x72, 0x1a, 0x87, 0x04, 0x0a, 0x12, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x69, 0x0a, 0x0a, 0x72, 0x65, 0x63, 0x69,
	0x70, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c,
	0x69, 0x74, 0x79, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x53, 0x63, 0x61, 0x6e,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x52, 0x65, 0x63, 0x69, 0x70, 0x69, 0x65, 0x6e,
	0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x72, 0x65, 0x63, 0x69, 0x70, 0x69, 0x65,
	0x6e, 0x74, 0x73, 0x12, 0x8c, 0x01, 0x0a, 0x17, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x74, 0x68,
	0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x5f, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x70, 0x65, 0x63,
	0x2e, 0x50, 0x6f, 0x73, 0x74, 0x53, 0x63, 0x61, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x54,
	0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x73, 0x63, 0x6f,
	0x72, 0x65, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x54, 0x72, 0x69, 0x67, 0x67,
	0x65, 0x72, 0x12, 0x80, 0x01, 0x0a, 0x13, 0x6a, 0x6f, 0x62, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75,
	0x72, 0x65, 0x5f, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x50, 0x6f, 0x73, 0x74,
	0x53, 0x63, 0x61, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x4a, 0x6f, 0x62, 0x46,
	0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x11, 0x6a, 0x6f, 0x62, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x54, 0x72,
	0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0x74, 0x0a, 0x0f, 0x6a, 0x6f, 0x62, 0x5f, 0x65, 0x6e, 0x64,
	0x5f, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75,
	0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x53, 0x63,
	0x61, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x4a, 0x6f, 0x62, 0x45, 0x6e, 0x64,
	0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x6a, 0x6f,
	0x62, 0x45, 0x6e, 0x64, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x22, 0x99, 0x0c, 0x0a, 0x11,
	0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x73, 0x73, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x70, 0x61, 0x73, 0x73, 0x65, 0x64, 0x12, 0x1e,
	0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x48, 0x00, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x59,
	0x0a, 0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x64,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x50, 0x0a, 0x07, 0x63, 0x6f, 0x6c,
	0x75, 0x6d, 0x6e, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74,
	0x79, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x12, 0x4a, 0x0a, 0x05, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74,
	0x79, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x20, 0x0a, 0x09, 0x72, 0x6f, 0x77, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x08, 0x72, 0x6f, 0x77, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x4d, 0x0a, 0x0c, 0x73, 0x63, 0x61,
	0x6e, 0x6e, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x61, 0x6e, 0x6e,
	0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x73, 0x63, 0x61,
	0x6e, 0x6e, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x12, 0x7f, 0x0a, 0x18, 0x70, 0x6f, 0x73, 0x74,
	0x5f, 0x73, 0x63, 0x61, 0x6e, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74,
	0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x53, 0x63, 0x61, 0x6e,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x15, 0x70, 0x6f, 0x73, 0x74, 0x53, 0x63, 0x61, 0x6e, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x7a, 0x0a, 0x19, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x69, 0x6e, 0x67, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e,
	0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x69, 0x6e,
	0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x69, 0x6e, 0x67, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x9d, 0x01, 0x0a, 0x22, 0x61, 0x6e, 0x6f, 0x6d, 0x61, 0x6c,
	0x79, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e,
	0x41, 0x6e, 0x6f, 0x6d, 0x61, 0x6c, 0x79, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x1f, 0x61, 0x6e, 0x6f, 0x6d, 0x61, 0x6c, 0x79, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x73, 0x1a, 0xa4, 0x03, 0x0a, 0x15, 0x50, 0x6f, 0x73, 0x74, 0x53, 0x63,
	0x61, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12,
	0x91, 0x01, 0x0a, 0x16, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x50, 0x6f,
	0x73, 0x74, 0x53, 0x63, 0x61, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x1a, 0xf6, 0x01, 0x0a, 0x14, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x77, 0x0a, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x5c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69,
	0x74, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x53, 0x63, 0x61,
	0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x42,
	0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x22, 0x46, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a,
	0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45,
	0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12,
	0x0b, 0x0a, 0x07, 0x53, 0x4b, 0x49, 0x50, 0x50, 0x45, 0x44, 0x10, 0x03, 0x1a, 0x8e, 0x02, 0x0a,
	0x1f, 0x41, 0x6e, 0x6f, 0x6d, 0x61, 0x6c, 0x79, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73,
	0x12, 0x26, 0x0a, 0x0c, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x3b, 0x0a, 0x17, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15,
	0x64, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x45, 0x0a, 0x1c, 0x66, 0x72, 0x65, 0x73, 0x68, 0x6e, 0x65,
	0x73, 0x73, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x1a, 0x66, 0x72, 0x65, 0x73, 0x68, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x74, 0x65, 0x72,
	0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x3f, 0x0a, 0x19,
	0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x65, 0x64, 0x69,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x49, 0x6e, 0x74, 0x65,
	0x72, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x08, 0x0a,
	0x06, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x22, 0xfe, 0x02, 0x0a, 0x15, 0x44, 0x61, 0x74, 0x61,
	0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x12, 0x42, 0x0a, 0x04, 0x72, 0x75, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51,
	0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x04, 0x72, 0x75, 0x6c, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x73, 0x73, 0x65, 0x64, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x70, 0x61, 0x73, 0x73,
	0x65, 0x64, 0x12, 0x2c, 0x0a, 0x0f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x64, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0e, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x26, 0x0a, 0x0c, 0x70, 0x61, 0x73, 0x73, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x70, 0x61, 0x73,
	0x73, 0x65, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x6e, 0x75, 0x6c, 0x6c,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x09, 0x6e, 0x75, 0x6c, 0x6c, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a,
	0x70, 0x61, 0x73, 0x73, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x18, 0x06, 0x20, 0x01, 0x28, 0x01,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x70, 0x61, 0x73, 0x73, 0x52, 0x61, 0x74, 0x69, 0x6f,
	0x12, 0x31, 0x0a, 0x12, 0x66, 0x61, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x6f, 0x77, 0x73,
	0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x10, 0x66, 0x61, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x6f, 0x77, 0x73, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x12, 0x33, 0x0a, 0x13, 0x61, 0x73, 0x73, 0x65, 0x72, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x72, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x03,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x61, 0x73, 0x73, 0x65, 0x72, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x6f, 0x77, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xb6, 0x01, 0x0a, 0x1a, 0x44, 0x61, 0x74,
	0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x51, 0x0a, 0x09, 0x64, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74,
	0x79, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x09, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61,
	0x73, 0x73, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x06, 0x70, 0x61, 0x73, 0x73, 0x65, 0x64, 0x12, 0x1e, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x05, 0x73,
	0x63, 0x6f, 0x72, 0x65, 0x88, 0x01, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x73, 0x63, 0x6f, 0x72,
	0x65, 0x22, 0x2f, 0x0a, 0x14, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79,
	0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xca, 0x11, 0x0a, 0x0f, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69,
	0x74, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x69, 0x0a, 0x11, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x5f,
	0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52,
	0x10, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x70, 0x0a, 0x14, 0x6e, 0x6f, 0x6e, 0x5f, 0x6e, 0x75, 0x6c, 0x6c, 0x5f, 0x65, 0x78,
	0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51,
	0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x4e, 0x6f, 0x6e, 0x4e, 0x75,
	0x6c, 0x6c, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52,
	0x12, 0x6e, 0x6f, 0x6e, 0x4e, 0x75, 0x6c, 0x6c, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x63, 0x0a, 0x0f, 0x73, 0x65, 0x74, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x63,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c,
	0x69, 0x74, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x53, 0x65, 0x74, 0x45, 0x78, 0x70, 0x65, 0x63,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0e, 0x73, 0x65, 0x74, 0x45, 0x78, 0x70,
	0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x69, 0x0a, 0x11, 0x72, 0x65, 0x67, 0x65,
	0x78, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x52,
	0x65, 0x67, 0x65, 0x78, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x00, 0x52, 0x10, 0x72, 0x65, 0x67, 0x65, 0x78, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x78, 0x0a, 0x16, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x6e, 0x65, 0x73,
	0x73, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x64, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x55,
	0x6e, 0x69, 0x71, 0x75, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x15, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x6e, 0x65,
	0x73, 0x73, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x85, 0x01,
	0x0a, 0x1b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x5f, 0x72, 0x61, 0x6e, 0x67,
	0x65, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x65, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x45, 0x78, 0x70,
	0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x19, 0x73, 0x74, 0x61, 0x74,
	0x69, 0x73, 0x74, 0x69, 0x63, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x80, 0x01, 0x0a, 0x19, 0x72, 0x6f, 0x77, 0x5f, 0x63, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0xc8, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74,
	0x79, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x52, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52,
	0x17, 0x72, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x70,
	0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x86, 0x01, 0x0a, 0x1b, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x78, 0x70,
	0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0xc9, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51,
	0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65,
	0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x19, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x5e, 0x0a, 0x0d, 0x73, 0x71, 0x6c, 0x5f, 0x61, 0x73, 0x73, 0x65, 0x72, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0xca, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79,
	0x52, 0x75, 0x6c, 0x65, 0x2e, 0x53, 0x71, 0x6c, 0x41, 0x73, 0x73, 0x65, 0x72, 0x74, 0x69, 0x6f,
	0x6e, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x71, 0x6c, 0x41, 0x73, 0x73, 0x65, 0x72, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x1c, 0x0a, 0x06, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0xf4, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12,
	0x25, 0x0a, 0x0b, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x5f, 0x6e, 0x75, 0x6c, 0x6c, 0x18, 0xf5,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x69, 0x67, 0x6e, 0x6f,
	0x72, 0x65, 0x4e, 0x75, 0x6c, 0x6c, 0x12, 0x22, 0x0a, 0x09, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0xf6, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x09, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x09, 0x74, 0x68,
	0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0xf7, 0x03, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x18,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0xf8, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0xf9, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x22, 0x0a, 0x09, 0x73, 0x75, 0x73, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x18, 0xfa, 0x03,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x73, 0x75, 0x73, 0x70, 0x65,
	0x6e, 0x64, 0x65, 0x64, 0x1a, 0xbc, 0x01, 0x0a, 0x10, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x45, 0x78,
	0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x69, 0x6e,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x08, 0x6d, 0x69, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x6d,
	0x61, 0x78, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x6d, 0x61, 0x78, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x31, 0x0a,
	0x12, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x5f, 0x6d, 0x69, 0x6e, 0x5f, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10,
	0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x4d, 0x69, 0x6e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x12, 0x31, 0x0a, 0x12, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x10, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x4d, 0x61, 0x78, 0x45, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x1a, 0x14, 0x0a, 0x12, 0x4e, 0x6f, 0x6e, 0x4e, 0x75, 0x6c, 0x6c, 0x45, 0x78,
	0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x2d, 0x0a, 0x0e, 0x53, 0x65, 0x74,
	0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0x2d, 0x0a, 0x10, 0x52, 0x65, 0x67, 0x65,
	0x78, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x05,
	0x72, 0x65, 0x67, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x05, 0x72, 0x65, 0x67, 0x65, 0x78, 0x1a, 0x17, 0x0a, 0x15, 0x55, 0x6e, 0x69, 0x71, 0x75,
	0x65, 0x6e, 0x65, 0x73, 0x73, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x1a, 0x85, 0x03, 0x0a, 0x19, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x52, 0x61,
	0x6e, 0x67, 0x65, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x76,
	0x0a, 0x09, 0x73, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x45, 0x78, 0x70, 0x65, 0x63,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x53, 0x74, 0x61,
	0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x69, 0x6e, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x6d, 0x69, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x6d, 0x61, 0x78, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x31, 0x0a, 0x12, 0x73, 0x74,
	0x72, 0x69, 0x63, 0x74, 0x5f, 0x6d, 0x69, 0x6e, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x73, 0x74, 0x72,
	0x69, 0x63, 0x74, 0x4d, 0x69, 0x6e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x31, 0x0a,
	0x12, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10,
	0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x4d, 0x61, 0x78, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x22, 0x46, 0x0a, 0x0f, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73,
	0x74, 0x69, 0x63, 0x12, 0x17, 0x0a, 0x13, 0x53, 0x54, 0x41, 0x54, 0x49, 0x53, 0x54, 0x49, 0x43,
	0x5f, 0x55, 0x4e, 0x44, 0x45, 0x46, 0x49, 0x4e, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04,
	0x4d, 0x45, 0x41, 0x4e, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x4d, 0x49, 0x4e, 0x10, 0x02, 0x12,
	0x07, 0x0a, 0x03, 0x4d, 0x41, 0x58, 0x10, 0x03, 0x1a, 0x45, 0x0a, 0x17, 0x52, 0x6f, 0x77, 0x43,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x71, 0x6c, 0x5f, 0x65, 0x78, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0d, 0x73, 0x71, 0x6c, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x1a,
	0x47, 0x0a, 0x19, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x45, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x0e,
	0x73, 0x71, 0x6c, 0x5f, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x73, 0x71, 0x6c, 0x45, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x38, 0x0a, 0x0c, 0x53, 0x71, 0x6c, 0x41,
	0x73, 0x73, 0x65, 0x72, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x71, 0x6c, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x73, 0x71, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x42, 0x0b, 0x0a, 0x09, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22,
	0xd8, 0x01, 0x0a, 0x17, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x43,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x63,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x06, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x1e, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x05,
	0x73, 0x63, 0x6f, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x73, 0x73,
	0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x70,
	0x61, 0x73, 0x73, 0x65, 0x64, 0x12, 0x59, 0x0a, 0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79,
	0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x42, 0x08, 0x0a, 0x06, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x42, 0xc4, 0x01, 0xea, 0x41, 0x55,
	0x0a, 0x1d, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12,
	0x34, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x7d, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x7d, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2e, 0x76, 0x31, 0x42, 0x10, 0x44, 0x61, 0x74, 0x61, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x38, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x70, 0x62, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x70,
	0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dataplex_v1_data_quality_proto_rawDescOnce sync.Once
	file_google_cloud_dataplex_v1_data_quality_proto_rawDescData = file_google_cloud_dataplex_v1_data_quality_proto_rawDesc
)

func file_google_cloud_dataplex_v1_data_quality_proto_rawDescGZIP() []byte {
	file_google_cloud_dataplex_v1_data_quality_proto_rawDescOnce.Do(func() {
		file_google_cloud_dataplex_v1_data_quality_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dataplex_v1_data_quality_proto_rawDescData)
	})
	return file_google_cloud_dataplex_v1_data_quality_proto_rawDescData
}

var file_google_cloud_dataplex_v1_data_quality_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_dataplex_v1_data_quality_proto_msgTypes = make([]protoimpl.MessageInfo, 26)
var file_google_cloud_dataplex_v1_data_quality_proto_goTypes = []any{
	(DataQualityResult_PostScanActionsResult_BigQueryExportResult_State)(0), // 0: google.cloud.dataplex.v1.DataQualityResult.PostScanActionsResult.BigQueryExportResult.State
	(DataQualityRule_StatisticRangeExpectation_ColumnStatistic)(0),          // 1: google.cloud.dataplex.v1.DataQualityRule.StatisticRangeExpectation.ColumnStatistic
	(*DataQualitySpec)(nil),                                              // 2: google.cloud.dataplex.v1.DataQualitySpec
	(*DataQualityResult)(nil),                                            // 3: google.cloud.dataplex.v1.DataQualityResult
	(*DataQualityRuleResult)(nil),                                        // 4: google.cloud.dataplex.v1.DataQualityRuleResult
	(*DataQualityDimensionResult)(nil),                                   // 5: google.cloud.dataplex.v1.DataQualityDimensionResult
	(*DataQualityDimension)(nil),                                         // 6: google.cloud.dataplex.v1.DataQualityDimension
	(*DataQualityRule)(nil),                                              // 7: google.cloud.dataplex.v1.DataQualityRule
	(*DataQualityColumnResult)(nil),                                      // 8: google.cloud.dataplex.v1.DataQualityColumnResult
	(*DataQualitySpec_PostScanActions)(nil),                              // 9: google.cloud.dataplex.v1.DataQualitySpec.PostScanActions
	(*DataQualitySpec_PostScanActions_BigQueryExport)(nil),               // 10: google.cloud.dataplex.v1.DataQualitySpec.PostScanActions.BigQueryExport
	(*DataQualitySpec_PostScanActions_Recipients)(nil),                   // 11: google.cloud.dataplex.v1.DataQualitySpec.PostScanActions.Recipients
	(*DataQualitySpec_PostScanActions_ScoreThresholdTrigger)(nil),        // 12: google.cloud.dataplex.v1.DataQualitySpec.PostScanActions.ScoreThresholdTrigger
	(*DataQualitySpec_PostScanActions_JobFailureTrigger)(nil),            // 13: google.cloud.dataplex.v1.DataQualitySpec.PostScanActions.JobFailureTrigger
	(*DataQualitySpec_PostScanActions_JobEndTrigger)(nil),                // 14: google.cloud.dataplex.v1.DataQualitySpec.PostScanActions.JobEndTrigger
	(*DataQualitySpec_PostScanActions_NotificationReport)(nil),           // 15: google.cloud.dataplex.v1.DataQualitySpec.PostScanActions.NotificationReport
	(*DataQualityResult_PostScanActionsResult)(nil),                      // 16: google.cloud.dataplex.v1.DataQualityResult.PostScanActionsResult
	(*DataQualityResult_AnomalyDetectionGeneratedAssets)(nil),            // 17: google.cloud.dataplex.v1.DataQualityResult.AnomalyDetectionGeneratedAssets
	(*DataQualityResult_PostScanActionsResult_BigQueryExportResult)(nil), // 18: google.cloud.dataplex.v1.DataQualityResult.PostScanActionsResult.BigQueryExportResult
	(*DataQualityRule_RangeExpectation)(nil),                             // 19: google.cloud.dataplex.v1.DataQualityRule.RangeExpectation
	(*DataQualityRule_NonNullExpectation)(nil),                           // 20: google.cloud.dataplex.v1.DataQualityRule.NonNullExpectation
	(*DataQualityRule_SetExpectation)(nil),                               // 21: google.cloud.dataplex.v1.DataQualityRule.SetExpectation
	(*DataQualityRule_RegexExpectation)(nil),                             // 22: google.cloud.dataplex.v1.DataQualityRule.RegexExpectation
	(*DataQualityRule_UniquenessExpectation)(nil),                        // 23: google.cloud.dataplex.v1.DataQualityRule.UniquenessExpectation
	(*DataQualityRule_StatisticRangeExpectation)(nil),                    // 24: google.cloud.dataplex.v1.DataQualityRule.StatisticRangeExpectation
	(*DataQualityRule_RowConditionExpectation)(nil),                      // 25: google.cloud.dataplex.v1.DataQualityRule.RowConditionExpectation
	(*DataQualityRule_TableConditionExpectation)(nil),                    // 26: google.cloud.dataplex.v1.DataQualityRule.TableConditionExpectation
	(*DataQualityRule_SqlAssertion)(nil),                                 // 27: google.cloud.dataplex.v1.DataQualityRule.SqlAssertion
	(*ScannedData)(nil),                                                  // 28: google.cloud.dataplex.v1.ScannedData
	(*DataScanCatalogPublishingStatus)(nil),                              // 29: google.cloud.dataplex.v1.DataScanCatalogPublishingStatus
}
var file_google_cloud_dataplex_v1_data_quality_proto_depIdxs = []int32{
	7,  // 0: google.cloud.dataplex.v1.DataQualitySpec.rules:type_name -> google.cloud.dataplex.v1.DataQualityRule
	9,  // 1: google.cloud.dataplex.v1.DataQualitySpec.post_scan_actions:type_name -> google.cloud.dataplex.v1.DataQualitySpec.PostScanActions
	5,  // 2: google.cloud.dataplex.v1.DataQualityResult.dimensions:type_name -> google.cloud.dataplex.v1.DataQualityDimensionResult
	8,  // 3: google.cloud.dataplex.v1.DataQualityResult.columns:type_name -> google.cloud.dataplex.v1.DataQualityColumnResult
	4,  // 4: google.cloud.dataplex.v1.DataQualityResult.rules:type_name -> google.cloud.dataplex.v1.DataQualityRuleResult
	28, // 5: google.cloud.dataplex.v1.DataQualityResult.scanned_data:type_name -> google.cloud.dataplex.v1.ScannedData
	16, // 6: google.cloud.dataplex.v1.DataQualityResult.post_scan_actions_result:type_name -> google.cloud.dataplex.v1.DataQualityResult.PostScanActionsResult
	29, // 7: google.cloud.dataplex.v1.DataQualityResult.catalog_publishing_status:type_name -> google.cloud.dataplex.v1.DataScanCatalogPublishingStatus
	17, // 8: google.cloud.dataplex.v1.DataQualityResult.anomaly_detection_generated_assets:type_name -> google.cloud.dataplex.v1.DataQualityResult.AnomalyDetectionGeneratedAssets
	7,  // 9: google.cloud.dataplex.v1.DataQualityRuleResult.rule:type_name -> google.cloud.dataplex.v1.DataQualityRule
	6,  // 10: google.cloud.dataplex.v1.DataQualityDimensionResult.dimension:type_name -> google.cloud.dataplex.v1.DataQualityDimension
	19, // 11: google.cloud.dataplex.v1.DataQualityRule.range_expectation:type_name -> google.cloud.dataplex.v1.DataQualityRule.RangeExpectation
	20, // 12: google.cloud.dataplex.v1.DataQualityRule.non_null_expectation:type_name -> google.cloud.dataplex.v1.DataQualityRule.NonNullExpectation
	21, // 13: google.cloud.dataplex.v1.DataQualityRule.set_expectation:type_name -> google.cloud.dataplex.v1.DataQualityRule.SetExpectation
	22, // 14: google.cloud.dataplex.v1.DataQualityRule.regex_expectation:type_name -> google.cloud.dataplex.v1.DataQualityRule.RegexExpectation
	23, // 15: google.cloud.dataplex.v1.DataQualityRule.uniqueness_expectation:type_name -> google.cloud.dataplex.v1.DataQualityRule.UniquenessExpectation
	24, // 16: google.cloud.dataplex.v1.DataQualityRule.statistic_range_expectation:type_name -> google.cloud.dataplex.v1.DataQualityRule.StatisticRangeExpectation
	25, // 17: google.cloud.dataplex.v1.DataQualityRule.row_condition_expectation:type_name -> google.cloud.dataplex.v1.DataQualityRule.RowConditionExpectation
	26, // 18: google.cloud.dataplex.v1.DataQualityRule.table_condition_expectation:type_name -> google.cloud.dataplex.v1.DataQualityRule.TableConditionExpectation
	27, // 19: google.cloud.dataplex.v1.DataQualityRule.sql_assertion:type_name -> google.cloud.dataplex.v1.DataQualityRule.SqlAssertion
	5,  // 20: google.cloud.dataplex.v1.DataQualityColumnResult.dimensions:type_name -> google.cloud.dataplex.v1.DataQualityDimensionResult
	10, // 21: google.cloud.dataplex.v1.DataQualitySpec.PostScanActions.bigquery_export:type_name -> google.cloud.dataplex.v1.DataQualitySpec.PostScanActions.BigQueryExport
	15, // 22: google.cloud.dataplex.v1.DataQualitySpec.PostScanActions.notification_report:type_name -> google.cloud.dataplex.v1.DataQualitySpec.PostScanActions.NotificationReport
	11, // 23: google.cloud.dataplex.v1.DataQualitySpec.PostScanActions.NotificationReport.recipients:type_name -> google.cloud.dataplex.v1.DataQualitySpec.PostScanActions.Recipients
	12, // 24: google.cloud.dataplex.v1.DataQualitySpec.PostScanActions.NotificationReport.score_threshold_trigger:type_name -> google.cloud.dataplex.v1.DataQualitySpec.PostScanActions.ScoreThresholdTrigger
	13, // 25: google.cloud.dataplex.v1.DataQualitySpec.PostScanActions.NotificationReport.job_failure_trigger:type_name -> google.cloud.dataplex.v1.DataQualitySpec.PostScanActions.JobFailureTrigger
	14, // 26: google.cloud.dataplex.v1.DataQualitySpec.PostScanActions.NotificationReport.job_end_trigger:type_name -> google.cloud.dataplex.v1.DataQualitySpec.PostScanActions.JobEndTrigger
	18, // 27: google.cloud.dataplex.v1.DataQualityResult.PostScanActionsResult.bigquery_export_result:type_name -> google.cloud.dataplex.v1.DataQualityResult.PostScanActionsResult.BigQueryExportResult
	0,  // 28: google.cloud.dataplex.v1.DataQualityResult.PostScanActionsResult.BigQueryExportResult.state:type_name -> google.cloud.dataplex.v1.DataQualityResult.PostScanActionsResult.BigQueryExportResult.State
	1,  // 29: google.cloud.dataplex.v1.DataQualityRule.StatisticRangeExpectation.statistic:type_name -> google.cloud.dataplex.v1.DataQualityRule.StatisticRangeExpectation.ColumnStatistic
	30, // [30:30] is the sub-list for method output_type
	30, // [30:30] is the sub-list for method input_type
	30, // [30:30] is the sub-list for extension type_name
	30, // [30:30] is the sub-list for extension extendee
	0,  // [0:30] is the sub-list for field type_name
}

func init() { file_google_cloud_dataplex_v1_data_quality_proto_init() }
func file_google_cloud_dataplex_v1_data_quality_proto_init() {
	if File_google_cloud_dataplex_v1_data_quality_proto != nil {
		return
	}
	file_google_cloud_dataplex_v1_datascans_common_proto_init()
	file_google_cloud_dataplex_v1_processing_proto_init()
	file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[1].OneofWrappers = []any{}
	file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[3].OneofWrappers = []any{}
	file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[5].OneofWrappers = []any{
		(*DataQualityRule_RangeExpectation_)(nil),
		(*DataQualityRule_NonNullExpectation_)(nil),
		(*DataQualityRule_SetExpectation_)(nil),
		(*DataQualityRule_RegexExpectation_)(nil),
		(*DataQualityRule_UniquenessExpectation_)(nil),
		(*DataQualityRule_StatisticRangeExpectation_)(nil),
		(*DataQualityRule_RowConditionExpectation_)(nil),
		(*DataQualityRule_TableConditionExpectation_)(nil),
		(*DataQualityRule_SqlAssertion_)(nil),
	}
	file_google_cloud_dataplex_v1_data_quality_proto_msgTypes[6].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dataplex_v1_data_quality_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   26,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_dataplex_v1_data_quality_proto_goTypes,
		DependencyIndexes: file_google_cloud_dataplex_v1_data_quality_proto_depIdxs,
		EnumInfos:         file_google_cloud_dataplex_v1_data_quality_proto_enumTypes,
		MessageInfos:      file_google_cloud_dataplex_v1_data_quality_proto_msgTypes,
	}.Build()
	File_google_cloud_dataplex_v1_data_quality_proto = out.File
	file_google_cloud_dataplex_v1_data_quality_proto_rawDesc = nil
	file_google_cloud_dataplex_v1_data_quality_proto_goTypes = nil
	file_google_cloud_dataplex_v1_data_quality_proto_depIdxs = nil
}
