// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/aiplatform/v1beta1/reservation_affinity.proto

package aiplatformpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Identifies a type of reservation affinity.
type ReservationAffinity_Type int32

const (
	// Default value. This should not be used.
	ReservationAffinity_TYPE_UNSPECIFIED ReservationAffinity_Type = 0
	// Do not consume from any reserved capacity, only use on-demand.
	ReservationAffinity_NO_RESERVATION ReservationAffinity_Type = 1
	// Consume any reservation available, falling back to on-demand.
	ReservationAffinity_ANY_RESERVATION ReservationAffinity_Type = 2
	// Consume from a specific reservation. When chosen, the reservation
	// must be identified via the `key` and `values` fields.
	ReservationAffinity_SPECIFIC_RESERVATION ReservationAffinity_Type = 3
)

// Enum value maps for ReservationAffinity_Type.
var (
	ReservationAffinity_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "NO_RESERVATION",
		2: "ANY_RESERVATION",
		3: "SPECIFIC_RESERVATION",
	}
	ReservationAffinity_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":     0,
		"NO_RESERVATION":       1,
		"ANY_RESERVATION":      2,
		"SPECIFIC_RESERVATION": 3,
	}
)

func (x ReservationAffinity_Type) Enum() *ReservationAffinity_Type {
	p := new(ReservationAffinity_Type)
	*p = x
	return p
}

func (x ReservationAffinity_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReservationAffinity_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_reservation_affinity_proto_enumTypes[0].Descriptor()
}

func (ReservationAffinity_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_reservation_affinity_proto_enumTypes[0]
}

func (x ReservationAffinity_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReservationAffinity_Type.Descriptor instead.
func (ReservationAffinity_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_reservation_affinity_proto_rawDescGZIP(), []int{0, 0}
}

// A ReservationAffinity can be used to configure a Vertex AI resource (e.g., a
// DeployedModel) to draw its Compute Engine resources from a Shared
// Reservation, or exclusively from on-demand capacity.
type ReservationAffinity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Specifies the reservation affinity type.
	ReservationAffinityType ReservationAffinity_Type `protobuf:"varint,1,opt,name=reservation_affinity_type,json=reservationAffinityType,proto3,enum=google.cloud.aiplatform.v1beta1.ReservationAffinity_Type" json:"reservation_affinity_type,omitempty"`
	// Optional. Corresponds to the label key of a reservation resource. To target
	// a SPECIFIC_RESERVATION by name, use
	// `compute.googleapis.com/reservation-name` as the key and specify the name
	// of your reservation as its value.
	Key string `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	// Optional. Corresponds to the label values of a reservation resource. This
	// must be the full resource name of the reservation.
	Values []string `protobuf:"bytes,3,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *ReservationAffinity) Reset() {
	*x = ReservationAffinity{}
	mi := &file_google_cloud_aiplatform_v1beta1_reservation_affinity_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReservationAffinity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReservationAffinity) ProtoMessage() {}

func (x *ReservationAffinity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_reservation_affinity_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReservationAffinity.ProtoReflect.Descriptor instead.
func (*ReservationAffinity) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_reservation_affinity_proto_rawDescGZIP(), []int{0}
}

func (x *ReservationAffinity) GetReservationAffinityType() ReservationAffinity_Type {
	if x != nil {
		return x.ReservationAffinityType
	}
	return ReservationAffinity_TYPE_UNSPECIFIED
}

func (x *ReservationAffinity) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *ReservationAffinity) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

var File_google_cloud_aiplatform_v1beta1_reservation_affinity_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_reservation_affinity_proto_rawDesc = []byte{
	0x0a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x66,
	0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xcd, 0x02, 0x0a, 0x13, 0x52, 0x65,
	0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x79, 0x12, 0x7a, 0x0a, 0x19, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x61, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x17, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x15, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x42, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x63, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x5f, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x4e, 0x4f, 0x5f, 0x52, 0x45, 0x53,
	0x45, 0x52, 0x56, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x41, 0x4e,
	0x59, 0x5f, 0x52, 0x45, 0x53, 0x45, 0x52, 0x56, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12,
	0x18, 0x0a, 0x14, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x43, 0x5f, 0x52, 0x45, 0x53, 0x45,
	0x52, 0x56, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x42, 0xe4, 0x02, 0xea, 0x41, 0x72, 0x0a,
	0x22, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x4c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x5f, 0x6f, 0x72, 0x5f, 0x6e, 0x75, 0x6d,
	0x62, 0x65, 0x72, 0x7d, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a, 0x6f, 0x6e, 0x65,
	0x7d, 0x2f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x7d, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x18, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x43, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_reservation_affinity_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_reservation_affinity_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_reservation_affinity_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_reservation_affinity_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_reservation_affinity_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_reservation_affinity_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_reservation_affinity_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_reservation_affinity_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_reservation_affinity_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_aiplatform_v1beta1_reservation_affinity_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_cloud_aiplatform_v1beta1_reservation_affinity_proto_goTypes = []any{
	(ReservationAffinity_Type)(0), // 0: google.cloud.aiplatform.v1beta1.ReservationAffinity.Type
	(*ReservationAffinity)(nil),   // 1: google.cloud.aiplatform.v1beta1.ReservationAffinity
}
var file_google_cloud_aiplatform_v1beta1_reservation_affinity_proto_depIdxs = []int32{
	0, // 0: google.cloud.aiplatform.v1beta1.ReservationAffinity.reservation_affinity_type:type_name -> google.cloud.aiplatform.v1beta1.ReservationAffinity.Type
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_reservation_affinity_proto_init() }
func file_google_cloud_aiplatform_v1beta1_reservation_affinity_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_reservation_affinity_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_reservation_affinity_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_reservation_affinity_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_reservation_affinity_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1beta1_reservation_affinity_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_reservation_affinity_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_reservation_affinity_proto = out.File
	file_google_cloud_aiplatform_v1beta1_reservation_affinity_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_reservation_affinity_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_reservation_affinity_proto_depIdxs = nil
}
