// Code generated by yy. DO NOT EDIT.

// Copyright 2022 The CC Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package cc

import (
	"fmt"

	"modernc.org/token"
)

// AbstractDeclaratorCase represents case numbers of production AbstractDeclarator
type AbstractDeclaratorCase int

// Values of type AbstractDeclaratorCase
const (
	AbstractDeclaratorPtr AbstractDeclaratorCase = iota
	AbstractDeclaratorDecl
)

// String implements fmt.Stringer
func (n AbstractDeclaratorCase) String() string {
	switch n {
	case AbstractDeclaratorPtr:
		return "AbstractDeclaratorPtr"
	case AbstractDeclaratorDecl:
		return "AbstractDeclaratorDecl"
	default:
		return fmt.Sprintf("AbstractDeclaratorCase(%v)", int(n))
	}
}

// AbstractDeclarator represents data reduced by productions:
//
//	AbstractDeclarator:
//	        Pointer                           // Case AbstractDeclaratorPtr
//	|       Pointer DirectAbstractDeclarator  // Case AbstractDeclaratorDecl
type AbstractDeclarator struct {
	typer
	Case                     AbstractDeclaratorCase `PrettyPrint:"stringer,zero"`
	DirectAbstractDeclarator *DirectAbstractDeclarator
	Pointer                  *Pointer
}

// String implements fmt.Stringer.
func (n *AbstractDeclarator) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *AbstractDeclarator) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 0:
		return n.Pointer.Position()
	case 1:
		if p := n.Pointer.Position(); p.IsValid() {
			return p
		}

		return n.DirectAbstractDeclarator.Position()
	default:
		panic("internal error")
	}
}

// AdditiveExpressionCase represents case numbers of production AdditiveExpression
type AdditiveExpressionCase int

// Values of type AdditiveExpressionCase
const (
	AdditiveExpressionMul AdditiveExpressionCase = iota
	AdditiveExpressionAdd
	AdditiveExpressionSub
)

// String implements fmt.Stringer
func (n AdditiveExpressionCase) String() string {
	switch n {
	case AdditiveExpressionMul:
		return "AdditiveExpressionMul"
	case AdditiveExpressionAdd:
		return "AdditiveExpressionAdd"
	case AdditiveExpressionSub:
		return "AdditiveExpressionSub"
	default:
		return fmt.Sprintf("AdditiveExpressionCase(%v)", int(n))
	}
}

// AdditiveExpression represents data reduced by productions:
//
//	AdditiveExpression:
//	        MultiplicativeExpression                         // Case AdditiveExpressionMul
//	|       AdditiveExpression '+' MultiplicativeExpression  // Case AdditiveExpressionAdd
//	|       AdditiveExpression '-' MultiplicativeExpression  // Case AdditiveExpressionSub
type AdditiveExpression struct {
	typer
	valuer
	purer
	AdditiveExpression       ExpressionNode
	Case                     AdditiveExpressionCase `PrettyPrint:"stringer,zero"`
	MultiplicativeExpression ExpressionNode
	Token                    Token
}

// String implements fmt.Stringer.
func (n *AdditiveExpression) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *AdditiveExpression) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 1, 2:
		if p := n.AdditiveExpression.Position(); p.IsValid() {
			return p
		}

		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		return n.MultiplicativeExpression.Position()
	case 0:
		return n.MultiplicativeExpression.Position()
	default:
		panic("internal error")
	}
}

// AlignmentSpecifierCase represents case numbers of production AlignmentSpecifier
type AlignmentSpecifierCase int

// Values of type AlignmentSpecifierCase
const (
	AlignmentSpecifierType AlignmentSpecifierCase = iota
	AlignmentSpecifierExpr
)

// String implements fmt.Stringer
func (n AlignmentSpecifierCase) String() string {
	switch n {
	case AlignmentSpecifierType:
		return "AlignmentSpecifierType"
	case AlignmentSpecifierExpr:
		return "AlignmentSpecifierExpr"
	default:
		return fmt.Sprintf("AlignmentSpecifierCase(%v)", int(n))
	}
}

// AlignmentSpecifier represents data reduced by productions:
//
//	AlignmentSpecifier:
//	        "_Alignas" '(' TypeName ')'            // Case AlignmentSpecifierType
//	|       "_Alignas" '(' ConstantExpression ')'  // Case AlignmentSpecifierExpr
type AlignmentSpecifier struct {
	Case               AlignmentSpecifierCase `PrettyPrint:"stringer,zero"`
	ConstantExpression ExpressionNode
	Token              Token
	Token2             Token
	Token3             Token
	TypeName           *TypeName
}

// String implements fmt.Stringer.
func (n *AlignmentSpecifier) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *AlignmentSpecifier) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 1:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		if p := n.ConstantExpression.Position(); p.IsValid() {
			return p
		}

		return n.Token3.Position()
	case 0:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		if p := n.TypeName.Position(); p.IsValid() {
			return p
		}

		return n.Token3.Position()
	default:
		panic("internal error")
	}
}

// AndExpressionCase represents case numbers of production AndExpression
type AndExpressionCase int

// Values of type AndExpressionCase
const (
	AndExpressionEq AndExpressionCase = iota
	AndExpressionAnd
)

// String implements fmt.Stringer
func (n AndExpressionCase) String() string {
	switch n {
	case AndExpressionEq:
		return "AndExpressionEq"
	case AndExpressionAnd:
		return "AndExpressionAnd"
	default:
		return fmt.Sprintf("AndExpressionCase(%v)", int(n))
	}
}

// AndExpression represents data reduced by productions:
//
//	AndExpression:
//	        EqualityExpression                    // Case AndExpressionEq
//	|       AndExpression '&' EqualityExpression  // Case AndExpressionAnd
type AndExpression struct {
	typer
	valuer
	purer
	AndExpression      ExpressionNode
	Case               AndExpressionCase `PrettyPrint:"stringer,zero"`
	EqualityExpression ExpressionNode
	Token              Token
}

// String implements fmt.Stringer.
func (n *AndExpression) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *AndExpression) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 1:
		if p := n.AndExpression.Position(); p.IsValid() {
			return p
		}

		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		return n.EqualityExpression.Position()
	case 0:
		return n.EqualityExpression.Position()
	default:
		panic("internal error")
	}
}

// ArgumentExpressionList represents data reduced by productions:
//
//	ArgumentExpressionList:
//	        AssignmentExpression
//	|       ArgumentExpressionList ',' AssignmentExpression
type ArgumentExpressionList struct {
	ArgumentExpressionList *ArgumentExpressionList
	AssignmentExpression   ExpressionNode
	Token                  Token
}

// String implements fmt.Stringer.
func (n *ArgumentExpressionList) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *ArgumentExpressionList) Position() (r token.Position) {
	if n == nil {
		return r
	}

	return n.AssignmentExpression.Position()
}

// Asm represents data reduced by production:
//
//	Asm:
//	        "__asm__" AsmQualifierList '(' STRINGLITERAL AsmArgList ')'
type Asm struct {
	AsmArgList       *AsmArgList
	AsmQualifierList *AsmQualifierList
	Token            Token
	Token2           Token
	Token3           Token
	Token4           Token
}

// String implements fmt.Stringer.
func (n *Asm) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *Asm) Position() (r token.Position) {
	if n == nil {
		return r
	}

	if p := n.Token.Position(); p.IsValid() {
		return p
	}

	if p := n.AsmQualifierList.Position(); p.IsValid() {
		return p
	}

	if p := n.Token2.Position(); p.IsValid() {
		return p
	}

	if p := n.Token3.Position(); p.IsValid() {
		return p
	}

	if p := n.AsmArgList.Position(); p.IsValid() {
		return p
	}

	return n.Token4.Position()
}

// AsmArgList represents data reduced by productions:
//
//	AsmArgList:
//	        ':' AsmExpressionList
//	|       AsmArgList ':' AsmExpressionList
type AsmArgList struct {
	AsmArgList        *AsmArgList
	AsmExpressionList *AsmExpressionList
	Token             Token
}

// String implements fmt.Stringer.
func (n *AsmArgList) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *AsmArgList) Position() (r token.Position) {
	if n == nil {
		return r
	}

	if p := n.Token.Position(); p.IsValid() {
		return p
	}

	return n.AsmExpressionList.Position()
}

// AsmExpressionList represents data reduced by productions:
//
//	AsmExpressionList:
//	        AsmIndex AssignmentExpression
//	|       AsmExpressionList ',' AsmIndex AssignmentExpression
type AsmExpressionList struct {
	AsmExpressionList    *AsmExpressionList
	AsmIndex             *AsmIndex
	AssignmentExpression ExpressionNode
	Token                Token
}

// String implements fmt.Stringer.
func (n *AsmExpressionList) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *AsmExpressionList) Position() (r token.Position) {
	if n == nil {
		return r
	}

	if p := n.AsmIndex.Position(); p.IsValid() {
		return p
	}

	return n.AssignmentExpression.Position()
}

// AsmIndex represents data reduced by production:
//
//	AsmIndex:
//	        '[' ExpressionList ']'
type AsmIndex struct {
	ExpressionList ExpressionNode
	Token          Token
	Token2         Token
}

// String implements fmt.Stringer.
func (n *AsmIndex) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *AsmIndex) Position() (r token.Position) {
	if n == nil {
		return r
	}

	if p := n.Token.Position(); p.IsValid() {
		return p
	}

	if p := n.ExpressionList.Position(); p.IsValid() {
		return p
	}

	return n.Token2.Position()
}

// AsmQualifierCase represents case numbers of production AsmQualifier
type AsmQualifierCase int

// Values of type AsmQualifierCase
const (
	AsmQualifierVolatile AsmQualifierCase = iota
	AsmQualifierInline
	AsmQualifierGoto
)

// String implements fmt.Stringer
func (n AsmQualifierCase) String() string {
	switch n {
	case AsmQualifierVolatile:
		return "AsmQualifierVolatile"
	case AsmQualifierInline:
		return "AsmQualifierInline"
	case AsmQualifierGoto:
		return "AsmQualifierGoto"
	default:
		return fmt.Sprintf("AsmQualifierCase(%v)", int(n))
	}
}

// AsmQualifier represents data reduced by productions:
//
//	AsmQualifier:
//	        "volatile"  // Case AsmQualifierVolatile
//	|       "inline"    // Case AsmQualifierInline
//	|       "goto"      // Case AsmQualifierGoto
type AsmQualifier struct {
	Case  AsmQualifierCase `PrettyPrint:"stringer,zero"`
	Token Token
}

// String implements fmt.Stringer.
func (n *AsmQualifier) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *AsmQualifier) Position() (r token.Position) {
	if n == nil {
		return r
	}

	return n.Token.Position()
}

// AsmQualifierList represents data reduced by productions:
//
//	AsmQualifierList:
//	        AsmQualifier
//	|       AsmQualifierList AsmQualifier
type AsmQualifierList struct {
	AsmQualifier     *AsmQualifier
	AsmQualifierList *AsmQualifierList
}

// String implements fmt.Stringer.
func (n *AsmQualifierList) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *AsmQualifierList) Position() (r token.Position) {
	if n == nil {
		return r
	}

	return n.AsmQualifier.Position()
}

// AsmStatement represents data reduced by production:
//
//	AsmStatement:
//	        Asm ';'
type AsmStatement struct {
	Asm   *Asm
	Token Token
}

// String implements fmt.Stringer.
func (n *AsmStatement) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *AsmStatement) Position() (r token.Position) {
	if n == nil {
		return r
	}

	if p := n.Asm.Position(); p.IsValid() {
		return p
	}

	return n.Token.Position()
}

// AssignmentExpressionCase represents case numbers of production AssignmentExpression
type AssignmentExpressionCase int

// Values of type AssignmentExpressionCase
const (
	AssignmentExpressionCond AssignmentExpressionCase = iota
	AssignmentExpressionAssign
	AssignmentExpressionMul
	AssignmentExpressionDiv
	AssignmentExpressionMod
	AssignmentExpressionAdd
	AssignmentExpressionSub
	AssignmentExpressionLsh
	AssignmentExpressionRsh
	AssignmentExpressionAnd
	AssignmentExpressionXor
	AssignmentExpressionOr
)

// String implements fmt.Stringer
func (n AssignmentExpressionCase) String() string {
	switch n {
	case AssignmentExpressionCond:
		return "AssignmentExpressionCond"
	case AssignmentExpressionAssign:
		return "AssignmentExpressionAssign"
	case AssignmentExpressionMul:
		return "AssignmentExpressionMul"
	case AssignmentExpressionDiv:
		return "AssignmentExpressionDiv"
	case AssignmentExpressionMod:
		return "AssignmentExpressionMod"
	case AssignmentExpressionAdd:
		return "AssignmentExpressionAdd"
	case AssignmentExpressionSub:
		return "AssignmentExpressionSub"
	case AssignmentExpressionLsh:
		return "AssignmentExpressionLsh"
	case AssignmentExpressionRsh:
		return "AssignmentExpressionRsh"
	case AssignmentExpressionAnd:
		return "AssignmentExpressionAnd"
	case AssignmentExpressionXor:
		return "AssignmentExpressionXor"
	case AssignmentExpressionOr:
		return "AssignmentExpressionOr"
	default:
		return fmt.Sprintf("AssignmentExpressionCase(%v)", int(n))
	}
}

// AssignmentExpression represents data reduced by productions:
//
//	AssignmentExpression:
//	        ConditionalExpression                       // Case AssignmentExpressionCond
//	|       UnaryExpression '=' AssignmentExpression    // Case AssignmentExpressionAssign
//	|       UnaryExpression "*=" AssignmentExpression   // Case AssignmentExpressionMul
//	|       UnaryExpression "/=" AssignmentExpression   // Case AssignmentExpressionDiv
//	|       UnaryExpression "%=" AssignmentExpression   // Case AssignmentExpressionMod
//	|       UnaryExpression "+=" AssignmentExpression   // Case AssignmentExpressionAdd
//	|       UnaryExpression "-=" AssignmentExpression   // Case AssignmentExpressionSub
//	|       UnaryExpression "<<=" AssignmentExpression  // Case AssignmentExpressionLsh
//	|       UnaryExpression ">>=" AssignmentExpression  // Case AssignmentExpressionRsh
//	|       UnaryExpression "&=" AssignmentExpression   // Case AssignmentExpressionAnd
//	|       UnaryExpression "^=" AssignmentExpression   // Case AssignmentExpressionXor
//	|       UnaryExpression "|=" AssignmentExpression   // Case AssignmentExpressionOr
type AssignmentExpression struct {
	typer
	valuer
	purer
	AssignmentExpression  ExpressionNode
	Case                  AssignmentExpressionCase `PrettyPrint:"stringer,zero"`
	ConditionalExpression ExpressionNode
	Token                 Token
	UnaryExpression       ExpressionNode
}

// String implements fmt.Stringer.
func (n *AssignmentExpression) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *AssignmentExpression) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 0:
		return n.ConditionalExpression.Position()
	case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11:
		if p := n.UnaryExpression.Position(); p.IsValid() {
			return p
		}

		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		return n.AssignmentExpression.Position()
	default:
		panic("internal error")
	}
}

// AtomicTypeSpecifier represents data reduced by production:
//
//	AtomicTypeSpecifier:
//	        "_Atomic" '(' TypeName ')'
type AtomicTypeSpecifier struct {
	Token    Token
	Token2   Token
	Token3   Token
	TypeName *TypeName
}

// String implements fmt.Stringer.
func (n *AtomicTypeSpecifier) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *AtomicTypeSpecifier) Position() (r token.Position) {
	if n == nil {
		return r
	}

	if p := n.Token.Position(); p.IsValid() {
		return p
	}

	if p := n.Token2.Position(); p.IsValid() {
		return p
	}

	if p := n.TypeName.Position(); p.IsValid() {
		return p
	}

	return n.Token3.Position()
}

// AttributeSpecifier represents data reduced by production:
//
//	AttributeSpecifier:
//	        "__attribute__" '(' '(' AttributeValueList ')' ')'
type AttributeSpecifier struct {
	AttributeValueList *AttributeValueList
	Token              Token
	Token2             Token
	Token3             Token
	Token4             Token
	Token5             Token
}

// String implements fmt.Stringer.
func (n *AttributeSpecifier) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *AttributeSpecifier) Position() (r token.Position) {
	if n == nil {
		return r
	}

	if p := n.Token.Position(); p.IsValid() {
		return p
	}

	if p := n.Token2.Position(); p.IsValid() {
		return p
	}

	if p := n.Token3.Position(); p.IsValid() {
		return p
	}

	if p := n.AttributeValueList.Position(); p.IsValid() {
		return p
	}

	if p := n.Token4.Position(); p.IsValid() {
		return p
	}

	return n.Token5.Position()
}

// AttributeSpecifierList represents data reduced by productions:
//
//	AttributeSpecifierList:
//	        AttributeSpecifier
//	|       AttributeSpecifierList AttributeSpecifier
type AttributeSpecifierList struct {
	AttributeSpecifier     *AttributeSpecifier
	AttributeSpecifierList *AttributeSpecifierList
}

// String implements fmt.Stringer.
func (n *AttributeSpecifierList) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *AttributeSpecifierList) Position() (r token.Position) {
	if n == nil {
		return r
	}

	return n.AttributeSpecifier.Position()
}

// AttributeValueCase represents case numbers of production AttributeValue
type AttributeValueCase int

// Values of type AttributeValueCase
const (
	AttributeValueIdent AttributeValueCase = iota
	AttributeValueExpr
)

// String implements fmt.Stringer
func (n AttributeValueCase) String() string {
	switch n {
	case AttributeValueIdent:
		return "AttributeValueIdent"
	case AttributeValueExpr:
		return "AttributeValueExpr"
	default:
		return fmt.Sprintf("AttributeValueCase(%v)", int(n))
	}
}

// AttributeValue represents data reduced by productions:
//
//	AttributeValue:
//	        IDENTIFIER                                 // Case AttributeValueIdent
//	|       IDENTIFIER '(' ArgumentExpressionList ')'  // Case AttributeValueExpr
type AttributeValue struct {
	ArgumentExpressionList *ArgumentExpressionList
	Case                   AttributeValueCase `PrettyPrint:"stringer,zero"`
	Token                  Token
	Token2                 Token
	Token3                 Token
}

// String implements fmt.Stringer.
func (n *AttributeValue) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *AttributeValue) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 0:
		return n.Token.Position()
	case 1:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		if p := n.ArgumentExpressionList.Position(); p.IsValid() {
			return p
		}

		return n.Token3.Position()
	default:
		panic("internal error")
	}
}

// AttributeValueList represents data reduced by productions:
//
//	AttributeValueList:
//	        AttributeValue
//	|       AttributeValueList ',' AttributeValue
type AttributeValueList struct {
	AttributeValue     *AttributeValue
	AttributeValueList *AttributeValueList
	Token              Token
}

// String implements fmt.Stringer.
func (n *AttributeValueList) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *AttributeValueList) Position() (r token.Position) {
	if n == nil {
		return r
	}

	return n.AttributeValue.Position()
}

// BlockItemCase represents case numbers of production BlockItem
type BlockItemCase int

// Values of type BlockItemCase
const (
	BlockItemDecl BlockItemCase = iota
	BlockItemLabel
	BlockItemStmt
	BlockItemFuncDef
)

// String implements fmt.Stringer
func (n BlockItemCase) String() string {
	switch n {
	case BlockItemDecl:
		return "BlockItemDecl"
	case BlockItemLabel:
		return "BlockItemLabel"
	case BlockItemStmt:
		return "BlockItemStmt"
	case BlockItemFuncDef:
		return "BlockItemFuncDef"
	default:
		return fmt.Sprintf("BlockItemCase(%v)", int(n))
	}
}

// BlockItem represents data reduced by productions:
//
//	BlockItem:
//	        Declaration                                         // Case BlockItemDecl
//	|       LabelDeclaration                                    // Case BlockItemLabel
//	|       Statement                                           // Case BlockItemStmt
//	|       DeclarationSpecifiers Declarator CompoundStatement  // Case BlockItemFuncDef
type BlockItem struct {
	Case                  BlockItemCase `PrettyPrint:"stringer,zero"`
	CompoundStatement     *CompoundStatement
	Declaration           *Declaration
	DeclarationSpecifiers *DeclarationSpecifiers
	Declarator            *Declarator
	LabelDeclaration      *LabelDeclaration
	Statement             *Statement
}

// String implements fmt.Stringer.
func (n *BlockItem) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *BlockItem) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 0:
		return n.Declaration.Position()
	case 3:
		if p := n.DeclarationSpecifiers.Position(); p.IsValid() {
			return p
		}

		if p := n.Declarator.Position(); p.IsValid() {
			return p
		}

		return n.CompoundStatement.Position()
	case 1:
		return n.LabelDeclaration.Position()
	case 2:
		return n.Statement.Position()
	default:
		panic("internal error")
	}
}

// BlockItemList represents data reduced by productions:
//
//	BlockItemList:
//	        BlockItem
//	|       BlockItemList BlockItem
type BlockItemList struct {
	BlockItem     *BlockItem
	BlockItemList *BlockItemList
}

// String implements fmt.Stringer.
func (n *BlockItemList) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *BlockItemList) Position() (r token.Position) {
	if n == nil {
		return r
	}

	return n.BlockItem.Position()
}

// CastExpressionCase represents case numbers of production CastExpression
type CastExpressionCase int

// Values of type CastExpressionCase
const (
	CastExpressionUnary CastExpressionCase = iota
	CastExpressionCast
)

// String implements fmt.Stringer
func (n CastExpressionCase) String() string {
	switch n {
	case CastExpressionUnary:
		return "CastExpressionUnary"
	case CastExpressionCast:
		return "CastExpressionCast"
	default:
		return fmt.Sprintf("CastExpressionCase(%v)", int(n))
	}
}

// CastExpression represents data reduced by productions:
//
//	CastExpression:
//	        UnaryExpression                  // Case CastExpressionUnary
//	|       '(' TypeName ')' CastExpression  // Case CastExpressionCast
type CastExpression struct {
	typer
	valuer
	purer
	Case            CastExpressionCase `PrettyPrint:"stringer,zero"`
	CastExpression  ExpressionNode
	Token           Token
	Token2          Token
	TypeName        *TypeName
	UnaryExpression ExpressionNode
}

// String implements fmt.Stringer.
func (n *CastExpression) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *CastExpression) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 1:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.TypeName.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		return n.CastExpression.Position()
	case 0:
		return n.UnaryExpression.Position()
	default:
		panic("internal error")
	}
}

// CompoundStatement represents data reduced by production:
//
//	CompoundStatement:
//	        '{' BlockItemList '}'
type CompoundStatement struct {
	*lexicalScope
	gotos         []*JumpStatement
	BlockItemList *BlockItemList
	Token         Token
	Token2        Token
}

// String implements fmt.Stringer.
func (n *CompoundStatement) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *CompoundStatement) Position() (r token.Position) {
	if n == nil {
		return r
	}

	if p := n.Token.Position(); p.IsValid() {
		return p
	}

	if p := n.BlockItemList.Position(); p.IsValid() {
		return p
	}

	return n.Token2.Position()
}

// ConditionalExpressionCase represents case numbers of production ConditionalExpression
type ConditionalExpressionCase int

// Values of type ConditionalExpressionCase
const (
	ConditionalExpressionLOr ConditionalExpressionCase = iota
	ConditionalExpressionCond
)

// String implements fmt.Stringer
func (n ConditionalExpressionCase) String() string {
	switch n {
	case ConditionalExpressionLOr:
		return "ConditionalExpressionLOr"
	case ConditionalExpressionCond:
		return "ConditionalExpressionCond"
	default:
		return fmt.Sprintf("ConditionalExpressionCase(%v)", int(n))
	}
}

// ConditionalExpression represents data reduced by productions:
//
//	ConditionalExpression:
//	        LogicalOrExpression                                               // Case ConditionalExpressionLOr
//	|       LogicalOrExpression '?' ExpressionList ':' ConditionalExpression  // Case ConditionalExpressionCond
type ConditionalExpression struct {
	typer
	valuer
	purer
	Case                  ConditionalExpressionCase `PrettyPrint:"stringer,zero"`
	ConditionalExpression ExpressionNode
	ExpressionList        ExpressionNode
	LogicalOrExpression   ExpressionNode
	Token                 Token
	Token2                Token
}

// String implements fmt.Stringer.
func (n *ConditionalExpression) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *ConditionalExpression) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 0:
		return n.LogicalOrExpression.Position()
	case 1:
		if p := n.LogicalOrExpression.Position(); p.IsValid() {
			return p
		}

		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.ExpressionList.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		return n.ConditionalExpression.Position()
	default:
		panic("internal error")
	}
}

// ConstantExpression represents data reduced by production:
//
//	ConstantExpression:
//	        ConditionalExpression
type ConstantExpression struct {
	typer
	valuer
	purer
	ConditionalExpression ExpressionNode
}

// String implements fmt.Stringer.
func (n *ConstantExpression) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *ConstantExpression) Position() (r token.Position) {
	if n == nil {
		return r
	}

	return n.ConditionalExpression.Position()
}

// DeclarationCase represents case numbers of production Declaration
type DeclarationCase int

// Values of type DeclarationCase
const (
	DeclarationDecl DeclarationCase = iota
	DeclarationAssert
	DeclarationAuto
)

// String implements fmt.Stringer
func (n DeclarationCase) String() string {
	switch n {
	case DeclarationDecl:
		return "DeclarationDecl"
	case DeclarationAssert:
		return "DeclarationAssert"
	case DeclarationAuto:
		return "DeclarationAuto"
	default:
		return fmt.Sprintf("DeclarationCase(%v)", int(n))
	}
}

// Declaration represents data reduced by productions:
//
//	Declaration:
//	        DeclarationSpecifiers InitDeclaratorList AttributeSpecifierList ';'  // Case DeclarationDecl
//	|       StaticAssertDeclaration                                              // Case DeclarationAssert
//	|       "__auto_type" Declarator '=' Initializer ';'                         // Case DeclarationAuto
type Declaration struct {
	AttributeSpecifierList  *AttributeSpecifierList
	Case                    DeclarationCase `PrettyPrint:"stringer,zero"`
	DeclarationSpecifiers   *DeclarationSpecifiers
	Declarator              *Declarator
	InitDeclaratorList      *InitDeclaratorList
	Initializer             *Initializer
	StaticAssertDeclaration *StaticAssertDeclaration
	Token                   Token
	Token2                  Token
	Token3                  Token
}

// String implements fmt.Stringer.
func (n *Declaration) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *Declaration) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 0:
		if p := n.DeclarationSpecifiers.Position(); p.IsValid() {
			return p
		}

		if p := n.InitDeclaratorList.Position(); p.IsValid() {
			return p
		}

		if p := n.AttributeSpecifierList.Position(); p.IsValid() {
			return p
		}

		return n.Token.Position()
	case 1:
		return n.StaticAssertDeclaration.Position()
	case 2:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.Declarator.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		if p := n.Initializer.Position(); p.IsValid() {
			return p
		}

		return n.Token3.Position()
	default:
		panic("internal error")
	}
}

// DeclarationList represents data reduced by productions:
//
//	DeclarationList:
//	        Declaration
//	|       DeclarationList Declaration
type DeclarationList struct {
	Declaration     *Declaration
	DeclarationList *DeclarationList
}

// String implements fmt.Stringer.
func (n *DeclarationList) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *DeclarationList) Position() (r token.Position) {
	if n == nil {
		return r
	}

	return n.Declaration.Position()
}

// DeclarationSpecifiersCase represents case numbers of production DeclarationSpecifiers
type DeclarationSpecifiersCase int

// Values of type DeclarationSpecifiersCase
const (
	DeclarationSpecifiersStorage DeclarationSpecifiersCase = iota
	DeclarationSpecifiersTypeSpec
	DeclarationSpecifiersTypeQual
	DeclarationSpecifiersFunc
	DeclarationSpecifiersAlignSpec
	DeclarationSpecifiersAttr
)

// String implements fmt.Stringer
func (n DeclarationSpecifiersCase) String() string {
	switch n {
	case DeclarationSpecifiersStorage:
		return "DeclarationSpecifiersStorage"
	case DeclarationSpecifiersTypeSpec:
		return "DeclarationSpecifiersTypeSpec"
	case DeclarationSpecifiersTypeQual:
		return "DeclarationSpecifiersTypeQual"
	case DeclarationSpecifiersFunc:
		return "DeclarationSpecifiersFunc"
	case DeclarationSpecifiersAlignSpec:
		return "DeclarationSpecifiersAlignSpec"
	case DeclarationSpecifiersAttr:
		return "DeclarationSpecifiersAttr"
	default:
		return fmt.Sprintf("DeclarationSpecifiersCase(%v)", int(n))
	}
}

// DeclarationSpecifiers represents data reduced by productions:
//
//	DeclarationSpecifiers:
//	        StorageClassSpecifier DeclarationSpecifiers  // Case DeclarationSpecifiersStorage
//	|       TypeSpecifier DeclarationSpecifiers          // Case DeclarationSpecifiersTypeSpec
//	|       TypeQualifier DeclarationSpecifiers          // Case DeclarationSpecifiersTypeQual
//	|       FunctionSpecifier DeclarationSpecifiers      // Case DeclarationSpecifiersFunc
//	|       AlignmentSpecifier DeclarationSpecifiers     // Case DeclarationSpecifiersAlignSpec
//	|       "__attribute__"                              // Case DeclarationSpecifiersAttr
type DeclarationSpecifiers struct {
	AttributeSpecifierList *AttributeSpecifierList
	typer
	isTypedef             bool
	AlignmentSpecifier    *AlignmentSpecifier
	Case                  DeclarationSpecifiersCase `PrettyPrint:"stringer,zero"`
	DeclarationSpecifiers *DeclarationSpecifiers
	FunctionSpecifier     *FunctionSpecifier
	StorageClassSpecifier *StorageClassSpecifier
	Token                 Token
	TypeQualifier         *TypeQualifier
	TypeSpecifier         *TypeSpecifier
}

// String implements fmt.Stringer.
func (n *DeclarationSpecifiers) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *DeclarationSpecifiers) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 4:
		if p := n.AlignmentSpecifier.Position(); p.IsValid() {
			return p
		}

		return n.DeclarationSpecifiers.Position()
	case 3:
		if p := n.FunctionSpecifier.Position(); p.IsValid() {
			return p
		}

		return n.DeclarationSpecifiers.Position()
	case 0:
		if p := n.StorageClassSpecifier.Position(); p.IsValid() {
			return p
		}

		return n.DeclarationSpecifiers.Position()
	case 5:
		return n.Token.Position()
	case 2:
		if p := n.TypeQualifier.Position(); p.IsValid() {
			return p
		}

		return n.DeclarationSpecifiers.Position()
	case 1:
		if p := n.TypeSpecifier.Position(); p.IsValid() {
			return p
		}

		return n.DeclarationSpecifiers.Position()
	default:
		panic("internal error")
	}
}

// Declarator represents data reduced by production:
//
//	Declarator:
//	        Pointer DirectDeclarator
type Declarator struct {
	*lexicalScope
	typer
	visible
	resolver
	alignas          int
	read             int
	sizeof           int
	write            int
	addrTaken        bool
	hasInitializer   bool
	isAtomic         bool
	isAuto           bool
	isConst          bool
	isExtern         bool
	isFuncDef        bool
	isInline         bool
	isNoreturn       bool
	isParam          bool
	isRegister       bool
	isRestrict       bool
	isStatic         bool
	isSynthetic      bool
	isThreadLocal    bool
	isTypename       bool
	isVolatile       bool
	DirectDeclarator *DirectDeclarator
	Pointer          *Pointer
}

// String implements fmt.Stringer.
func (n *Declarator) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *Declarator) Position() (r token.Position) {
	if n == nil {
		return r
	}

	if p := n.Pointer.Position(); p.IsValid() {
		return p
	}

	return n.DirectDeclarator.Position()
}

// Designation represents data reduced by production:
//
//	Designation:
//	        DesignatorList '='
type Designation struct {
	DesignatorList *DesignatorList
	Token          Token
}

// String implements fmt.Stringer.
func (n *Designation) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *Designation) Position() (r token.Position) {
	if n == nil {
		return r
	}

	if p := n.DesignatorList.Position(); p.IsValid() {
		return p
	}

	return n.Token.Position()
}

// DesignatorCase represents case numbers of production Designator
type DesignatorCase int

// Values of type DesignatorCase
const (
	DesignatorIndex DesignatorCase = iota
	DesignatorIndex2
	DesignatorField
	DesignatorField2
)

// String implements fmt.Stringer
func (n DesignatorCase) String() string {
	switch n {
	case DesignatorIndex:
		return "DesignatorIndex"
	case DesignatorIndex2:
		return "DesignatorIndex2"
	case DesignatorField:
		return "DesignatorField"
	case DesignatorField2:
		return "DesignatorField2"
	default:
		return fmt.Sprintf("DesignatorCase(%v)", int(n))
	}
}

// Designator represents data reduced by productions:
//
//	Designator:
//	        '[' ConstantExpression ']'                           // Case DesignatorIndex
//	|       '[' ConstantExpression "..." ConstantExpression ']'  // Case DesignatorIndex2
//	|       '.' IDENTIFIER                                       // Case DesignatorField
//	|       IDENTIFIER ':'                                       // Case DesignatorField2
type Designator struct {
	typer
	Case                DesignatorCase `PrettyPrint:"stringer,zero"`
	ConstantExpression  ExpressionNode
	ConstantExpression2 ExpressionNode
	Token               Token
	Token2              Token
	Token3              Token
}

// String implements fmt.Stringer.
func (n *Designator) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *Designator) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 0:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.ConstantExpression.Position(); p.IsValid() {
			return p
		}

		return n.Token2.Position()
	case 1:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.ConstantExpression.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		if p := n.ConstantExpression2.Position(); p.IsValid() {
			return p
		}

		return n.Token3.Position()
	case 2, 3:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		return n.Token2.Position()
	default:
		panic("internal error")
	}
}

// DesignatorList represents data reduced by productions:
//
//	DesignatorList:
//	        Designator
//	|       DesignatorList Designator
type DesignatorList struct {
	Designator     *Designator
	DesignatorList *DesignatorList
}

// String implements fmt.Stringer.
func (n *DesignatorList) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *DesignatorList) Position() (r token.Position) {
	if n == nil {
		return r
	}

	return n.Designator.Position()
}

// DirectAbstractDeclaratorCase represents case numbers of production DirectAbstractDeclarator
type DirectAbstractDeclaratorCase int

// Values of type DirectAbstractDeclaratorCase
const (
	DirectAbstractDeclaratorDecl DirectAbstractDeclaratorCase = iota
	DirectAbstractDeclaratorArr
	DirectAbstractDeclaratorStaticArr
	DirectAbstractDeclaratorArrStatic
	DirectAbstractDeclaratorArrStar
	DirectAbstractDeclaratorFunc
)

// String implements fmt.Stringer
func (n DirectAbstractDeclaratorCase) String() string {
	switch n {
	case DirectAbstractDeclaratorDecl:
		return "DirectAbstractDeclaratorDecl"
	case DirectAbstractDeclaratorArr:
		return "DirectAbstractDeclaratorArr"
	case DirectAbstractDeclaratorStaticArr:
		return "DirectAbstractDeclaratorStaticArr"
	case DirectAbstractDeclaratorArrStatic:
		return "DirectAbstractDeclaratorArrStatic"
	case DirectAbstractDeclaratorArrStar:
		return "DirectAbstractDeclaratorArrStar"
	case DirectAbstractDeclaratorFunc:
		return "DirectAbstractDeclaratorFunc"
	default:
		return fmt.Sprintf("DirectAbstractDeclaratorCase(%v)", int(n))
	}
}

// DirectAbstractDeclarator represents data reduced by productions:
//
//	DirectAbstractDeclarator:
//	        '(' AbstractDeclarator ')'                                                     // Case DirectAbstractDeclaratorDecl
//	|       DirectAbstractDeclarator '[' TypeQualifiers AssignmentExpression ']'           // Case DirectAbstractDeclaratorArr
//	|       DirectAbstractDeclarator '[' "static" TypeQualifiers AssignmentExpression ']'  // Case DirectAbstractDeclaratorStaticArr
//	|       DirectAbstractDeclarator '[' TypeQualifiers "static" AssignmentExpression ']'  // Case DirectAbstractDeclaratorArrStatic
//	|       DirectAbstractDeclarator '[' '*' ']'                                           // Case DirectAbstractDeclaratorArrStar
//	|       DirectAbstractDeclarator '(' ParameterTypeList ')'                             // Case DirectAbstractDeclaratorFunc
type DirectAbstractDeclarator struct {
	params                   *Scope
	AbstractDeclarator       *AbstractDeclarator
	AssignmentExpression     ExpressionNode
	Case                     DirectAbstractDeclaratorCase `PrettyPrint:"stringer,zero"`
	DirectAbstractDeclarator *DirectAbstractDeclarator
	ParameterTypeList        *ParameterTypeList
	Token                    Token
	Token2                   Token
	Token3                   Token
	TypeQualifiers           *TypeQualifiers
}

// String implements fmt.Stringer.
func (n *DirectAbstractDeclarator) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *DirectAbstractDeclarator) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 5:
		if p := n.DirectAbstractDeclarator.Position(); p.IsValid() {
			return p
		}

		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.ParameterTypeList.Position(); p.IsValid() {
			return p
		}

		return n.Token2.Position()
	case 4:
		if p := n.DirectAbstractDeclarator.Position(); p.IsValid() {
			return p
		}

		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		return n.Token3.Position()
	case 2:
		if p := n.DirectAbstractDeclarator.Position(); p.IsValid() {
			return p
		}

		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		if p := n.TypeQualifiers.Position(); p.IsValid() {
			return p
		}

		if p := n.AssignmentExpression.Position(); p.IsValid() {
			return p
		}

		return n.Token3.Position()
	case 1:
		if p := n.DirectAbstractDeclarator.Position(); p.IsValid() {
			return p
		}

		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.TypeQualifiers.Position(); p.IsValid() {
			return p
		}

		if p := n.AssignmentExpression.Position(); p.IsValid() {
			return p
		}

		return n.Token2.Position()
	case 3:
		if p := n.DirectAbstractDeclarator.Position(); p.IsValid() {
			return p
		}

		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.TypeQualifiers.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		if p := n.AssignmentExpression.Position(); p.IsValid() {
			return p
		}

		return n.Token3.Position()
	case 0:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.AbstractDeclarator.Position(); p.IsValid() {
			return p
		}

		return n.Token2.Position()
	default:
		panic("internal error")
	}
}

// DirectDeclaratorCase represents case numbers of production DirectDeclarator
type DirectDeclaratorCase int

// Values of type DirectDeclaratorCase
const (
	DirectDeclaratorIdent DirectDeclaratorCase = iota
	DirectDeclaratorDecl
	DirectDeclaratorArr
	DirectDeclaratorStaticArr
	DirectDeclaratorArrStatic
	DirectDeclaratorStar
	DirectDeclaratorFuncParam
	DirectDeclaratorFuncIdent
)

// String implements fmt.Stringer
func (n DirectDeclaratorCase) String() string {
	switch n {
	case DirectDeclaratorIdent:
		return "DirectDeclaratorIdent"
	case DirectDeclaratorDecl:
		return "DirectDeclaratorDecl"
	case DirectDeclaratorArr:
		return "DirectDeclaratorArr"
	case DirectDeclaratorStaticArr:
		return "DirectDeclaratorStaticArr"
	case DirectDeclaratorArrStatic:
		return "DirectDeclaratorArrStatic"
	case DirectDeclaratorStar:
		return "DirectDeclaratorStar"
	case DirectDeclaratorFuncParam:
		return "DirectDeclaratorFuncParam"
	case DirectDeclaratorFuncIdent:
		return "DirectDeclaratorFuncIdent"
	default:
		return fmt.Sprintf("DirectDeclaratorCase(%v)", int(n))
	}
}

// DirectDeclarator represents data reduced by productions:
//
//	DirectDeclarator:
//	        IDENTIFIER                                                             // Case DirectDeclaratorIdent
//	|       '(' Declarator ')'                                                     // Case DirectDeclaratorDecl
//	|       DirectDeclarator '[' TypeQualifiers AssignmentExpression ']'           // Case DirectDeclaratorArr
//	|       DirectDeclarator '[' "static" TypeQualifiers AssignmentExpression ']'  // Case DirectDeclaratorStaticArr
//	|       DirectDeclarator '[' TypeQualifiers "static" AssignmentExpression ']'  // Case DirectDeclaratorArrStatic
//	|       DirectDeclarator '[' TypeQualifiers '*' ']'                            // Case DirectDeclaratorStar
//	|       DirectDeclarator '(' ParameterTypeList ')'                             // Case DirectDeclaratorFuncParam
//	|       DirectDeclarator '(' IdentifierList ')'                                // Case DirectDeclaratorFuncIdent
type DirectDeclarator struct {
	params               *Scope
	AssignmentExpression ExpressionNode
	Case                 DirectDeclaratorCase `PrettyPrint:"stringer,zero"`
	Declarator           *Declarator
	DirectDeclarator     *DirectDeclarator
	IdentifierList       *IdentifierList
	ParameterTypeList    *ParameterTypeList
	Token                Token
	Token2               Token
	Token3               Token
	TypeQualifiers       *TypeQualifiers
}

// String implements fmt.Stringer.
func (n *DirectDeclarator) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *DirectDeclarator) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 7:
		if p := n.DirectDeclarator.Position(); p.IsValid() {
			return p
		}

		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.IdentifierList.Position(); p.IsValid() {
			return p
		}

		return n.Token2.Position()
	case 6:
		if p := n.DirectDeclarator.Position(); p.IsValid() {
			return p
		}

		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.ParameterTypeList.Position(); p.IsValid() {
			return p
		}

		return n.Token2.Position()
	case 3:
		if p := n.DirectDeclarator.Position(); p.IsValid() {
			return p
		}

		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		if p := n.TypeQualifiers.Position(); p.IsValid() {
			return p
		}

		if p := n.AssignmentExpression.Position(); p.IsValid() {
			return p
		}

		return n.Token3.Position()
	case 2:
		if p := n.DirectDeclarator.Position(); p.IsValid() {
			return p
		}

		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.TypeQualifiers.Position(); p.IsValid() {
			return p
		}

		if p := n.AssignmentExpression.Position(); p.IsValid() {
			return p
		}

		return n.Token2.Position()
	case 4:
		if p := n.DirectDeclarator.Position(); p.IsValid() {
			return p
		}

		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.TypeQualifiers.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		if p := n.AssignmentExpression.Position(); p.IsValid() {
			return p
		}

		return n.Token3.Position()
	case 5:
		if p := n.DirectDeclarator.Position(); p.IsValid() {
			return p
		}

		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.TypeQualifiers.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		return n.Token3.Position()
	case 0:
		return n.Token.Position()
	case 1:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.Declarator.Position(); p.IsValid() {
			return p
		}

		return n.Token2.Position()
	default:
		panic("internal error")
	}
}

// EnumSpecifierCase represents case numbers of production EnumSpecifier
type EnumSpecifierCase int

// Values of type EnumSpecifierCase
const (
	EnumSpecifierDef EnumSpecifierCase = iota
	EnumSpecifierTag
)

// String implements fmt.Stringer
func (n EnumSpecifierCase) String() string {
	switch n {
	case EnumSpecifierDef:
		return "EnumSpecifierDef"
	case EnumSpecifierTag:
		return "EnumSpecifierTag"
	default:
		return fmt.Sprintf("EnumSpecifierCase(%v)", int(n))
	}
}

// EnumSpecifier represents data reduced by productions:
//
//	EnumSpecifier:
//	        "enum" IDENTIFIER '{' EnumeratorList ',' '}'  // Case EnumSpecifierDef
//	|       "enum" IDENTIFIER                             // Case EnumSpecifierTag
type EnumSpecifier struct {
	*lexicalScope
	visible
	typer
	Case           EnumSpecifierCase `PrettyPrint:"stringer,zero"`
	EnumeratorList *EnumeratorList
	Token          Token
	Token2         Token
	Token3         Token
	Token4         Token
	Token5         Token
}

// String implements fmt.Stringer.
func (n *EnumSpecifier) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *EnumSpecifier) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 1:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		return n.Token2.Position()
	case 0:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		if p := n.Token3.Position(); p.IsValid() {
			return p
		}

		if p := n.EnumeratorList.Position(); p.IsValid() {
			return p
		}

		if p := n.Token4.Position(); p.IsValid() {
			return p
		}

		return n.Token5.Position()
	default:
		panic("internal error")
	}
}

// EnumeratorCase represents case numbers of production Enumerator
type EnumeratorCase int

// Values of type EnumeratorCase
const (
	EnumeratorIdent EnumeratorCase = iota
	EnumeratorExpr
)

// String implements fmt.Stringer
func (n EnumeratorCase) String() string {
	switch n {
	case EnumeratorIdent:
		return "EnumeratorIdent"
	case EnumeratorExpr:
		return "EnumeratorExpr"
	default:
		return fmt.Sprintf("EnumeratorCase(%v)", int(n))
	}
}

// Enumerator represents data reduced by productions:
//
//	Enumerator:
//	        IDENTIFIER                         // Case EnumeratorIdent
//	|       IDENTIFIER '=' ConstantExpression  // Case EnumeratorExpr
type Enumerator struct {
	typer
	resolver
	valuer
	visible
	Case               EnumeratorCase `PrettyPrint:"stringer,zero"`
	ConstantExpression ExpressionNode
	Token              Token
	Token2             Token
}

// String implements fmt.Stringer.
func (n *Enumerator) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *Enumerator) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 0:
		return n.Token.Position()
	case 1:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		return n.ConstantExpression.Position()
	default:
		panic("internal error")
	}
}

// EnumeratorList represents data reduced by productions:
//
//	EnumeratorList:
//	        Enumerator
//	|       EnumeratorList ',' Enumerator
type EnumeratorList struct {
	Enumerator     *Enumerator
	EnumeratorList *EnumeratorList
	Token          Token
}

// String implements fmt.Stringer.
func (n *EnumeratorList) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *EnumeratorList) Position() (r token.Position) {
	if n == nil {
		return r
	}

	return n.Enumerator.Position()
}

// EqualityExpressionCase represents case numbers of production EqualityExpression
type EqualityExpressionCase int

// Values of type EqualityExpressionCase
const (
	EqualityExpressionRel EqualityExpressionCase = iota
	EqualityExpressionEq
	EqualityExpressionNeq
)

// String implements fmt.Stringer
func (n EqualityExpressionCase) String() string {
	switch n {
	case EqualityExpressionRel:
		return "EqualityExpressionRel"
	case EqualityExpressionEq:
		return "EqualityExpressionEq"
	case EqualityExpressionNeq:
		return "EqualityExpressionNeq"
	default:
		return fmt.Sprintf("EqualityExpressionCase(%v)", int(n))
	}
}

// EqualityExpression represents data reduced by productions:
//
//	EqualityExpression:
//	        RelationalExpression                          // Case EqualityExpressionRel
//	|       EqualityExpression "==" RelationalExpression  // Case EqualityExpressionEq
//	|       EqualityExpression "!=" RelationalExpression  // Case EqualityExpressionNeq
type EqualityExpression struct {
	typer
	valuer
	purer
	Case                 EqualityExpressionCase `PrettyPrint:"stringer,zero"`
	EqualityExpression   ExpressionNode
	RelationalExpression ExpressionNode
	Token                Token
}

// String implements fmt.Stringer.
func (n *EqualityExpression) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *EqualityExpression) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 1, 2:
		if p := n.EqualityExpression.Position(); p.IsValid() {
			return p
		}

		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		return n.RelationalExpression.Position()
	case 0:
		return n.RelationalExpression.Position()
	default:
		panic("internal error")
	}
}

// ExclusiveOrExpressionCase represents case numbers of production ExclusiveOrExpression
type ExclusiveOrExpressionCase int

// Values of type ExclusiveOrExpressionCase
const (
	ExclusiveOrExpressionAnd ExclusiveOrExpressionCase = iota
	ExclusiveOrExpressionXor
)

// String implements fmt.Stringer
func (n ExclusiveOrExpressionCase) String() string {
	switch n {
	case ExclusiveOrExpressionAnd:
		return "ExclusiveOrExpressionAnd"
	case ExclusiveOrExpressionXor:
		return "ExclusiveOrExpressionXor"
	default:
		return fmt.Sprintf("ExclusiveOrExpressionCase(%v)", int(n))
	}
}

// ExclusiveOrExpression represents data reduced by productions:
//
//	ExclusiveOrExpression:
//	        AndExpression                            // Case ExclusiveOrExpressionAnd
//	|       ExclusiveOrExpression '^' AndExpression  // Case ExclusiveOrExpressionXor
type ExclusiveOrExpression struct {
	typer
	valuer
	purer
	AndExpression         ExpressionNode
	Case                  ExclusiveOrExpressionCase `PrettyPrint:"stringer,zero"`
	ExclusiveOrExpression ExpressionNode
	Token                 Token
}

// String implements fmt.Stringer.
func (n *ExclusiveOrExpression) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *ExclusiveOrExpression) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 0:
		return n.AndExpression.Position()
	case 1:
		if p := n.ExclusiveOrExpression.Position(); p.IsValid() {
			return p
		}

		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		return n.AndExpression.Position()
	default:
		panic("internal error")
	}
}

// ExpressionListCase represents case numbers of production ExpressionList
type ExpressionListCase int

// Values of type ExpressionListCase
const (
	ExpressionListAssign ExpressionListCase = iota
	ExpressionListComma
)

// String implements fmt.Stringer
func (n ExpressionListCase) String() string {
	switch n {
	case ExpressionListAssign:
		return "ExpressionListAssign"
	case ExpressionListComma:
		return "ExpressionListComma"
	default:
		return fmt.Sprintf("ExpressionListCase(%v)", int(n))
	}
}

// ExpressionList represents data reduced by productions:
//
//	ExpressionList:
//	        AssignmentExpression
//	|       ExpressionList ',' AssignmentExpression
type ExpressionList struct {
	typer
	valuer
	purer
	AssignmentExpression ExpressionNode
	ExpressionList       *ExpressionList
	Token                Token
}

// String implements fmt.Stringer.
func (n *ExpressionList) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *ExpressionList) Position() (r token.Position) {
	if n == nil {
		return r
	}

	return n.AssignmentExpression.Position()
}

// ExpressionStatement represents data reduced by production:
//
//	ExpressionStatement:
//	        ExpressionList ';'
type ExpressionStatement struct {
	AttributeSpecifierList *AttributeSpecifierList
	declarationSpecifiers  *DeclarationSpecifiers
	ExpressionList         ExpressionNode
	Token                  Token
}

// String implements fmt.Stringer.
func (n *ExpressionStatement) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *ExpressionStatement) Position() (r token.Position) {
	if n == nil {
		return r
	}

	if n.ExpressionList != nil {
		if p := n.ExpressionList.Position(); p.IsValid() {
			return p
		}
	}

	return n.Token.Position()
}

// ExternalDeclarationCase represents case numbers of production ExternalDeclaration
type ExternalDeclarationCase int

// Values of type ExternalDeclarationCase
const (
	ExternalDeclarationFuncDef ExternalDeclarationCase = iota
	ExternalDeclarationDecl
	ExternalDeclarationAsmStmt
	ExternalDeclarationEmpty
)

// String implements fmt.Stringer
func (n ExternalDeclarationCase) String() string {
	switch n {
	case ExternalDeclarationFuncDef:
		return "ExternalDeclarationFuncDef"
	case ExternalDeclarationDecl:
		return "ExternalDeclarationDecl"
	case ExternalDeclarationAsmStmt:
		return "ExternalDeclarationAsmStmt"
	case ExternalDeclarationEmpty:
		return "ExternalDeclarationEmpty"
	default:
		return fmt.Sprintf("ExternalDeclarationCase(%v)", int(n))
	}
}

// ExternalDeclaration represents data reduced by productions:
//
//	ExternalDeclaration:
//	        FunctionDefinition  // Case ExternalDeclarationFuncDef
//	|       Declaration         // Case ExternalDeclarationDecl
//	|       AsmStatement        // Case ExternalDeclarationAsmStmt
//	|       ';'                 // Case ExternalDeclarationEmpty
type ExternalDeclaration struct {
	AsmStatement       *AsmStatement
	Case               ExternalDeclarationCase `PrettyPrint:"stringer,zero"`
	Declaration        *Declaration
	FunctionDefinition *FunctionDefinition
	Token              Token
}

// String implements fmt.Stringer.
func (n *ExternalDeclaration) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *ExternalDeclaration) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 2:
		return n.AsmStatement.Position()
	case 1:
		return n.Declaration.Position()
	case 0:
		return n.FunctionDefinition.Position()
	case 3:
		return n.Token.Position()
	default:
		panic("internal error")
	}
}

// FunctionDefinition represents data reduced by production:
//
//	FunctionDefinition:
//	        DeclarationSpecifiers Declarator DeclarationList CompoundStatement
type FunctionDefinition struct {
	scope                 *Scope
	usesVectors           bool
	CompoundStatement     *CompoundStatement
	DeclarationList       *DeclarationList
	DeclarationSpecifiers *DeclarationSpecifiers
	Declarator            *Declarator
}

// String implements fmt.Stringer.
func (n *FunctionDefinition) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *FunctionDefinition) Position() (r token.Position) {
	if n == nil {
		return r
	}

	if p := n.DeclarationSpecifiers.Position(); p.IsValid() {
		return p
	}

	if p := n.Declarator.Position(); p.IsValid() {
		return p
	}

	if p := n.DeclarationList.Position(); p.IsValid() {
		return p
	}

	return n.CompoundStatement.Position()
}

// FunctionSpecifierCase represents case numbers of production FunctionSpecifier
type FunctionSpecifierCase int

// Values of type FunctionSpecifierCase
const (
	FunctionSpecifierInline FunctionSpecifierCase = iota
	FunctionSpecifierNoreturn
)

// String implements fmt.Stringer
func (n FunctionSpecifierCase) String() string {
	switch n {
	case FunctionSpecifierInline:
		return "FunctionSpecifierInline"
	case FunctionSpecifierNoreturn:
		return "FunctionSpecifierNoreturn"
	default:
		return fmt.Sprintf("FunctionSpecifierCase(%v)", int(n))
	}
}

// FunctionSpecifier represents data reduced by productions:
//
//	FunctionSpecifier:
//	        "inline"     // Case FunctionSpecifierInline
//	|       "_Noreturn"  // Case FunctionSpecifierNoreturn
type FunctionSpecifier struct {
	Case  FunctionSpecifierCase `PrettyPrint:"stringer,zero"`
	Token Token
}

// String implements fmt.Stringer.
func (n *FunctionSpecifier) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *FunctionSpecifier) Position() (r token.Position) {
	if n == nil {
		return r
	}

	return n.Token.Position()
}

// GenericAssociationCase represents case numbers of production GenericAssociation
type GenericAssociationCase int

// Values of type GenericAssociationCase
const (
	GenericAssociationType GenericAssociationCase = iota
	GenericAssociationDefault
)

// String implements fmt.Stringer
func (n GenericAssociationCase) String() string {
	switch n {
	case GenericAssociationType:
		return "GenericAssociationType"
	case GenericAssociationDefault:
		return "GenericAssociationDefault"
	default:
		return fmt.Sprintf("GenericAssociationCase(%v)", int(n))
	}
}

// GenericAssociation represents data reduced by productions:
//
//	GenericAssociation:
//	        TypeName ':' AssignmentExpression   // Case GenericAssociationType
//	|       "default" ':' AssignmentExpression  // Case GenericAssociationDefault
type GenericAssociation struct {
	AssignmentExpression ExpressionNode
	Case                 GenericAssociationCase `PrettyPrint:"stringer,zero"`
	Token                Token
	Token2               Token
	TypeName             *TypeName
}

// String implements fmt.Stringer.
func (n *GenericAssociation) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *GenericAssociation) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 1:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		return n.AssignmentExpression.Position()
	case 0:
		if p := n.TypeName.Position(); p.IsValid() {
			return p
		}

		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		return n.AssignmentExpression.Position()
	default:
		panic("internal error")
	}
}

// GenericAssociationList represents data reduced by productions:
//
//	GenericAssociationList:
//	        GenericAssociation
//	|       GenericAssociationList ',' GenericAssociation
type GenericAssociationList struct {
	GenericAssociation     *GenericAssociation
	GenericAssociationList *GenericAssociationList
	Token                  Token
}

// String implements fmt.Stringer.
func (n *GenericAssociationList) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *GenericAssociationList) Position() (r token.Position) {
	if n == nil {
		return r
	}

	return n.GenericAssociation.Position()
}

// GenericSelection represents data reduced by production:
//
//	GenericSelection:
//	        "_Generic" '(' AssignmentExpression ',' GenericAssociationList ')'
type GenericSelection struct {
	assoc *GenericAssociation
	typer
	AssignmentExpression   ExpressionNode
	GenericAssociationList *GenericAssociationList
	Token                  Token
	Token2                 Token
	Token3                 Token
	Token4                 Token
}

// String implements fmt.Stringer.
func (n *GenericSelection) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *GenericSelection) Position() (r token.Position) {
	if n == nil {
		return r
	}

	if p := n.Token.Position(); p.IsValid() {
		return p
	}

	if p := n.Token2.Position(); p.IsValid() {
		return p
	}

	if p := n.AssignmentExpression.Position(); p.IsValid() {
		return p
	}

	if p := n.Token3.Position(); p.IsValid() {
		return p
	}

	if p := n.GenericAssociationList.Position(); p.IsValid() {
		return p
	}

	return n.Token4.Position()
}

// IdentifierList represents data reduced by productions:
//
//	IdentifierList:
//	        IDENTIFIER
//	|       IdentifierList ',' IDENTIFIER
type IdentifierList struct {
	parameters     []*Parameter
	IdentifierList *IdentifierList
	Token          Token
	Token2         Token
}

// String implements fmt.Stringer.
func (n *IdentifierList) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *IdentifierList) Position() (r token.Position) {
	if n == nil {
		return r
	}

	return n.Token.Position()
}

// InclusiveOrExpressionCase represents case numbers of production InclusiveOrExpression
type InclusiveOrExpressionCase int

// Values of type InclusiveOrExpressionCase
const (
	InclusiveOrExpressionXor InclusiveOrExpressionCase = iota
	InclusiveOrExpressionOr
)

// String implements fmt.Stringer
func (n InclusiveOrExpressionCase) String() string {
	switch n {
	case InclusiveOrExpressionXor:
		return "InclusiveOrExpressionXor"
	case InclusiveOrExpressionOr:
		return "InclusiveOrExpressionOr"
	default:
		return fmt.Sprintf("InclusiveOrExpressionCase(%v)", int(n))
	}
}

// InclusiveOrExpression represents data reduced by productions:
//
//	InclusiveOrExpression:
//	        ExclusiveOrExpression                            // Case InclusiveOrExpressionXor
//	|       InclusiveOrExpression '|' ExclusiveOrExpression  // Case InclusiveOrExpressionOr
type InclusiveOrExpression struct {
	typer
	valuer
	purer
	Case                  InclusiveOrExpressionCase `PrettyPrint:"stringer,zero"`
	ExclusiveOrExpression ExpressionNode
	InclusiveOrExpression ExpressionNode
	Token                 Token
}

// String implements fmt.Stringer.
func (n *InclusiveOrExpression) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *InclusiveOrExpression) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 0:
		return n.ExclusiveOrExpression.Position()
	case 1:
		if p := n.InclusiveOrExpression.Position(); p.IsValid() {
			return p
		}

		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		return n.ExclusiveOrExpression.Position()
	default:
		panic("internal error")
	}
}

// InitDeclaratorCase represents case numbers of production InitDeclarator
type InitDeclaratorCase int

// Values of type InitDeclaratorCase
const (
	InitDeclaratorDecl InitDeclaratorCase = iota
	InitDeclaratorInit
)

// String implements fmt.Stringer
func (n InitDeclaratorCase) String() string {
	switch n {
	case InitDeclaratorDecl:
		return "InitDeclaratorDecl"
	case InitDeclaratorInit:
		return "InitDeclaratorInit"
	default:
		return fmt.Sprintf("InitDeclaratorCase(%v)", int(n))
	}
}

// InitDeclarator represents data reduced by productions:
//
//	InitDeclarator:
//	        Declarator Asm                  // Case InitDeclaratorDecl
//	|       Declarator Asm '=' Initializer  // Case InitDeclaratorInit
type InitDeclarator struct {
	AttributeSpecifierList *AttributeSpecifierList
	Asm                    *Asm
	Case                   InitDeclaratorCase `PrettyPrint:"stringer,zero"`
	Declarator             *Declarator
	Initializer            *Initializer
	Token                  Token
}

// String implements fmt.Stringer.
func (n *InitDeclarator) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *InitDeclarator) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 0:
		if p := n.Declarator.Position(); p.IsValid() {
			return p
		}

		return n.Asm.Position()
	case 1:
		if p := n.Declarator.Position(); p.IsValid() {
			return p
		}

		if p := n.Asm.Position(); p.IsValid() {
			return p
		}

		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		return n.Initializer.Position()
	default:
		panic("internal error")
	}
}

// InitDeclaratorList represents data reduced by productions:
//
//	InitDeclaratorList:
//	        InitDeclarator
//	|       InitDeclaratorList ',' InitDeclarator
type InitDeclaratorList struct {
	AttributeSpecifierList *AttributeSpecifierList
	InitDeclarator         *InitDeclarator
	InitDeclaratorList     *InitDeclaratorList
	Token                  Token
}

// String implements fmt.Stringer.
func (n *InitDeclaratorList) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *InitDeclaratorList) Position() (r token.Position) {
	if n == nil {
		return r
	}

	return n.InitDeclarator.Position()
}

// InitializerCase represents case numbers of production Initializer
type InitializerCase int

// Values of type InitializerCase
const (
	InitializerExpr InitializerCase = iota
	InitializerInitList
)

// String implements fmt.Stringer
func (n InitializerCase) String() string {
	switch n {
	case InitializerExpr:
		return "InitializerExpr"
	case InitializerInitList:
		return "InitializerInitList"
	default:
		return fmt.Sprintf("InitializerCase(%v)", int(n))
	}
}

// Initializer represents data reduced by productions:
//
//	Initializer:
//	        AssignmentExpression         // Case InitializerExpr
//	|       '{' InitializerList ',' '}'  // Case InitializerInitList
type Initializer struct {
	field  *Field
	nelems int64
	off    int64
	order  int64
	parent *Initializer
	typer
	valuer
	AssignmentExpression ExpressionNode
	Case                 InitializerCase `PrettyPrint:"stringer,zero"`
	InitializerList      *InitializerList
	Token                Token
	Token2               Token
	Token3               Token
}

// String implements fmt.Stringer.
func (n *Initializer) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *Initializer) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 0:
		return n.AssignmentExpression.Position()
	case 1:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.InitializerList.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		return n.Token3.Position()
	default:
		panic("internal error")
	}
}

// InitializerList represents data reduced by productions:
//
//	InitializerList:
//	        Designation Initializer
//	|       InitializerList ',' Designation Initializer
type InitializerList struct {
	unionField *Field
	typer
	Designation     *Designation
	Initializer     *Initializer
	InitializerList *InitializerList
	Token           Token
}

// String implements fmt.Stringer.
func (n *InitializerList) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *InitializerList) Position() (r token.Position) {
	if n == nil {
		return r
	}

	if p := n.Designation.Position(); p.IsValid() {
		return p
	}

	return n.Initializer.Position()
}

// IterationStatementCase represents case numbers of production IterationStatement
type IterationStatementCase int

// Values of type IterationStatementCase
const (
	IterationStatementWhile IterationStatementCase = iota
	IterationStatementDo
	IterationStatementFor
	IterationStatementForDecl
)

// String implements fmt.Stringer
func (n IterationStatementCase) String() string {
	switch n {
	case IterationStatementWhile:
		return "IterationStatementWhile"
	case IterationStatementDo:
		return "IterationStatementDo"
	case IterationStatementFor:
		return "IterationStatementFor"
	case IterationStatementForDecl:
		return "IterationStatementForDecl"
	default:
		return fmt.Sprintf("IterationStatementCase(%v)", int(n))
	}
}

// IterationStatement represents data reduced by productions:
//
//	IterationStatement:
//	        "while" '(' ExpressionList ')' Statement                                      // Case IterationStatementWhile
//	|       "do" Statement "while" '(' ExpressionList ')' ';'                             // Case IterationStatementDo
//	|       "for" '(' ExpressionList ';' ExpressionList ';' ExpressionList ')' Statement  // Case IterationStatementFor
//	|       "for" '(' Declaration ExpressionList ';' ExpressionList ')' Statement         // Case IterationStatementForDecl
type IterationStatement struct {
	*lexicalScope
	Case            IterationStatementCase `PrettyPrint:"stringer,zero"`
	Declaration     *Declaration
	ExpressionList  ExpressionNode
	ExpressionList2 ExpressionNode
	ExpressionList3 ExpressionNode
	Statement       *Statement
	Token           Token
	Token2          Token
	Token3          Token
	Token4          Token
	Token5          Token
}

// String implements fmt.Stringer.
func (n *IterationStatement) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *IterationStatement) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 1:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.Statement.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		if p := n.Token3.Position(); p.IsValid() {
			return p
		}

		if p := n.ExpressionList.Position(); p.IsValid() {
			return p
		}

		if p := n.Token4.Position(); p.IsValid() {
			return p
		}

		return n.Token5.Position()
	case 3:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		if p := n.Declaration.Position(); p.IsValid() {
			return p
		}

		if p := n.ExpressionList.Position(); p.IsValid() {
			return p
		}

		if p := n.Token3.Position(); p.IsValid() {
			return p
		}

		if p := n.ExpressionList2.Position(); p.IsValid() {
			return p
		}

		if p := n.Token4.Position(); p.IsValid() {
			return p
		}

		return n.Statement.Position()
	case 2:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		if p := n.ExpressionList.Position(); p.IsValid() {
			return p
		}

		if p := n.Token3.Position(); p.IsValid() {
			return p
		}

		if p := n.ExpressionList2.Position(); p.IsValid() {
			return p
		}

		if p := n.Token4.Position(); p.IsValid() {
			return p
		}

		if p := n.ExpressionList3.Position(); p.IsValid() {
			return p
		}

		if p := n.Token5.Position(); p.IsValid() {
			return p
		}

		return n.Statement.Position()
	case 0:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		if p := n.ExpressionList.Position(); p.IsValid() {
			return p
		}

		if p := n.Token3.Position(); p.IsValid() {
			return p
		}

		return n.Statement.Position()
	default:
		panic("internal error")
	}
}

// JumpStatementCase represents case numbers of production JumpStatement
type JumpStatementCase int

// Values of type JumpStatementCase
const (
	JumpStatementGoto JumpStatementCase = iota
	JumpStatementGotoExpr
	JumpStatementContinue
	JumpStatementBreak
	JumpStatementReturn
)

// String implements fmt.Stringer
func (n JumpStatementCase) String() string {
	switch n {
	case JumpStatementGoto:
		return "JumpStatementGoto"
	case JumpStatementGotoExpr:
		return "JumpStatementGotoExpr"
	case JumpStatementContinue:
		return "JumpStatementContinue"
	case JumpStatementBreak:
		return "JumpStatementBreak"
	case JumpStatementReturn:
		return "JumpStatementReturn"
	default:
		return fmt.Sprintf("JumpStatementCase(%v)", int(n))
	}
}

// JumpStatement represents data reduced by productions:
//
//	JumpStatement:
//	        "goto" IDENTIFIER ';'          // Case JumpStatementGoto
//	|       "goto" '*' ExpressionList ';'  // Case JumpStatementGotoExpr
//	|       "continue" ';'                 // Case JumpStatementContinue
//	|       "break" ';'                    // Case JumpStatementBreak
//	|       "return" ExpressionList ';'    // Case JumpStatementReturn
type JumpStatement struct {
	*lexicalScope
	label          Node
	Case           JumpStatementCase `PrettyPrint:"stringer,zero"`
	ExpressionList ExpressionNode
	Token          Token
	Token2         Token
	Token3         Token
}

// String implements fmt.Stringer.
func (n *JumpStatement) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *JumpStatement) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 4:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.ExpressionList.Position(); p.IsValid() {
			return p
		}

		return n.Token2.Position()
	case 2, 3:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		return n.Token2.Position()
	case 1:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		if p := n.ExpressionList.Position(); p.IsValid() {
			return p
		}

		return n.Token3.Position()
	case 0:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		return n.Token3.Position()
	default:
		panic("internal error")
	}
}

// LabelDeclaration represents data reduced by production:
//
//	LabelDeclaration:
//	        "__label__" IdentifierList ';'
type LabelDeclaration struct {
	IdentifierList *IdentifierList
	Token          Token
	Token2         Token
}

// String implements fmt.Stringer.
func (n *LabelDeclaration) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *LabelDeclaration) Position() (r token.Position) {
	if n == nil {
		return r
	}

	if p := n.Token.Position(); p.IsValid() {
		return p
	}

	if p := n.IdentifierList.Position(); p.IsValid() {
		return p
	}

	return n.Token2.Position()
}

// LabeledStatementCase represents case numbers of production LabeledStatement
type LabeledStatementCase int

// Values of type LabeledStatementCase
const (
	LabeledStatementLabel LabeledStatementCase = iota
	LabeledStatementCaseLabel
	LabeledStatementRange
	LabeledStatementDefault
)

// String implements fmt.Stringer
func (n LabeledStatementCase) String() string {
	switch n {
	case LabeledStatementLabel:
		return "LabeledStatementLabel"
	case LabeledStatementCaseLabel:
		return "LabeledStatementCaseLabel"
	case LabeledStatementRange:
		return "LabeledStatementRange"
	case LabeledStatementDefault:
		return "LabeledStatementDefault"
	default:
		return fmt.Sprintf("LabeledStatementCase(%v)", int(n))
	}
}

// LabeledStatement represents data reduced by productions:
//
//	LabeledStatement:
//	        IDENTIFIER ':' Statement                                          // Case LabeledStatementLabel
//	|       "case" ConstantExpression ':' Statement                           // Case LabeledStatementCaseLabel
//	|       "case" ConstantExpression "..." ConstantExpression ':' Statement  // Case LabeledStatementRange
//	|       "default" ':' Statement                                           // Case LabeledStatementDefault
type LabeledStatement struct {
	caseOrdinal int
	*lexicalScope
	switchCtx           *SelectionStatement
	Case                LabeledStatementCase `PrettyPrint:"stringer,zero"`
	ConstantExpression  ExpressionNode
	ConstantExpression2 ExpressionNode
	Statement           *Statement
	Token               Token
	Token2              Token
	Token3              Token
}

// String implements fmt.Stringer.
func (n *LabeledStatement) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *LabeledStatement) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 2:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.ConstantExpression.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		if p := n.ConstantExpression2.Position(); p.IsValid() {
			return p
		}

		if p := n.Token3.Position(); p.IsValid() {
			return p
		}

		return n.Statement.Position()
	case 1:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.ConstantExpression.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		return n.Statement.Position()
	case 0, 3:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		return n.Statement.Position()
	default:
		panic("internal error")
	}
}

// LogicalAndExpressionCase represents case numbers of production LogicalAndExpression
type LogicalAndExpressionCase int

// Values of type LogicalAndExpressionCase
const (
	LogicalAndExpressionOr LogicalAndExpressionCase = iota
	LogicalAndExpressionLAnd
)

// String implements fmt.Stringer
func (n LogicalAndExpressionCase) String() string {
	switch n {
	case LogicalAndExpressionOr:
		return "LogicalAndExpressionOr"
	case LogicalAndExpressionLAnd:
		return "LogicalAndExpressionLAnd"
	default:
		return fmt.Sprintf("LogicalAndExpressionCase(%v)", int(n))
	}
}

// LogicalAndExpression represents data reduced by productions:
//
//	LogicalAndExpression:
//	        InclusiveOrExpression                            // Case LogicalAndExpressionOr
//	|       LogicalAndExpression "&&" InclusiveOrExpression  // Case LogicalAndExpressionLAnd
type LogicalAndExpression struct {
	typer
	valuer
	purer
	Case                  LogicalAndExpressionCase `PrettyPrint:"stringer,zero"`
	InclusiveOrExpression ExpressionNode
	LogicalAndExpression  ExpressionNode
	Token                 Token
}

// String implements fmt.Stringer.
func (n *LogicalAndExpression) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *LogicalAndExpression) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 0:
		return n.InclusiveOrExpression.Position()
	case 1:
		if p := n.LogicalAndExpression.Position(); p.IsValid() {
			return p
		}

		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		return n.InclusiveOrExpression.Position()
	default:
		panic("internal error")
	}
}

// LogicalOrExpressionCase represents case numbers of production LogicalOrExpression
type LogicalOrExpressionCase int

// Values of type LogicalOrExpressionCase
const (
	LogicalOrExpressionLAnd LogicalOrExpressionCase = iota
	LogicalOrExpressionLOr
)

// String implements fmt.Stringer
func (n LogicalOrExpressionCase) String() string {
	switch n {
	case LogicalOrExpressionLAnd:
		return "LogicalOrExpressionLAnd"
	case LogicalOrExpressionLOr:
		return "LogicalOrExpressionLOr"
	default:
		return fmt.Sprintf("LogicalOrExpressionCase(%v)", int(n))
	}
}

// LogicalOrExpression represents data reduced by productions:
//
//	LogicalOrExpression:
//	        LogicalAndExpression                           // Case LogicalOrExpressionLAnd
//	|       LogicalOrExpression "||" LogicalAndExpression  // Case LogicalOrExpressionLOr
type LogicalOrExpression struct {
	typer
	valuer
	purer
	Case                 LogicalOrExpressionCase `PrettyPrint:"stringer,zero"`
	LogicalAndExpression ExpressionNode
	LogicalOrExpression  ExpressionNode
	Token                Token
}

// String implements fmt.Stringer.
func (n *LogicalOrExpression) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *LogicalOrExpression) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 0:
		return n.LogicalAndExpression.Position()
	case 1:
		if p := n.LogicalOrExpression.Position(); p.IsValid() {
			return p
		}

		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		return n.LogicalAndExpression.Position()
	default:
		panic("internal error")
	}
}

// MultiplicativeExpressionCase represents case numbers of production MultiplicativeExpression
type MultiplicativeExpressionCase int

// Values of type MultiplicativeExpressionCase
const (
	MultiplicativeExpressionCast MultiplicativeExpressionCase = iota
	MultiplicativeExpressionMul
	MultiplicativeExpressionDiv
	MultiplicativeExpressionMod
)

// String implements fmt.Stringer
func (n MultiplicativeExpressionCase) String() string {
	switch n {
	case MultiplicativeExpressionCast:
		return "MultiplicativeExpressionCast"
	case MultiplicativeExpressionMul:
		return "MultiplicativeExpressionMul"
	case MultiplicativeExpressionDiv:
		return "MultiplicativeExpressionDiv"
	case MultiplicativeExpressionMod:
		return "MultiplicativeExpressionMod"
	default:
		return fmt.Sprintf("MultiplicativeExpressionCase(%v)", int(n))
	}
}

// MultiplicativeExpression represents data reduced by productions:
//
//	MultiplicativeExpression:
//	        CastExpression                               // Case MultiplicativeExpressionCast
//	|       MultiplicativeExpression '*' CastExpression  // Case MultiplicativeExpressionMul
//	|       MultiplicativeExpression '/' CastExpression  // Case MultiplicativeExpressionDiv
//	|       MultiplicativeExpression '%' CastExpression  // Case MultiplicativeExpressionMod
type MultiplicativeExpression struct {
	typer
	valuer
	purer
	Case                     MultiplicativeExpressionCase `PrettyPrint:"stringer,zero"`
	CastExpression           ExpressionNode
	MultiplicativeExpression ExpressionNode
	Token                    Token
}

// String implements fmt.Stringer.
func (n *MultiplicativeExpression) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *MultiplicativeExpression) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 0:
		return n.CastExpression.Position()
	case 1, 2, 3:
		if p := n.MultiplicativeExpression.Position(); p.IsValid() {
			return p
		}

		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		return n.CastExpression.Position()
	default:
		panic("internal error")
	}
}

// ParameterDeclarationCase represents case numbers of production ParameterDeclaration
type ParameterDeclarationCase int

// Values of type ParameterDeclarationCase
const (
	ParameterDeclarationDecl ParameterDeclarationCase = iota
	ParameterDeclarationAbstract
)

// String implements fmt.Stringer
func (n ParameterDeclarationCase) String() string {
	switch n {
	case ParameterDeclarationDecl:
		return "ParameterDeclarationDecl"
	case ParameterDeclarationAbstract:
		return "ParameterDeclarationAbstract"
	default:
		return fmt.Sprintf("ParameterDeclarationCase(%v)", int(n))
	}
}

// ParameterDeclaration represents data reduced by productions:
//
//	ParameterDeclaration:
//	        DeclarationSpecifiers Declarator          // Case ParameterDeclarationDecl
//	|       DeclarationSpecifiers AbstractDeclarator  // Case ParameterDeclarationAbstract
type ParameterDeclaration struct {
	AttributeSpecifierList *AttributeSpecifierList
	typer
	AbstractDeclarator    *AbstractDeclarator
	Case                  ParameterDeclarationCase `PrettyPrint:"stringer,zero"`
	DeclarationSpecifiers *DeclarationSpecifiers
	Declarator            *Declarator
}

// String implements fmt.Stringer.
func (n *ParameterDeclaration) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *ParameterDeclaration) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 1:
		if p := n.DeclarationSpecifiers.Position(); p.IsValid() {
			return p
		}

		return n.AbstractDeclarator.Position()
	case 0:
		if p := n.DeclarationSpecifiers.Position(); p.IsValid() {
			return p
		}

		return n.Declarator.Position()
	default:
		panic("internal error")
	}
}

// ParameterList represents data reduced by productions:
//
//	ParameterList:
//	        ParameterDeclaration
//	|       ParameterList ',' ParameterDeclaration
type ParameterList struct {
	ParameterDeclaration *ParameterDeclaration
	ParameterList        *ParameterList
	Token                Token
}

// String implements fmt.Stringer.
func (n *ParameterList) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *ParameterList) Position() (r token.Position) {
	if n == nil {
		return r
	}

	return n.ParameterDeclaration.Position()
}

// ParameterTypeListCase represents case numbers of production ParameterTypeList
type ParameterTypeListCase int

// Values of type ParameterTypeListCase
const (
	ParameterTypeListList ParameterTypeListCase = iota
	ParameterTypeListVar
)

// String implements fmt.Stringer
func (n ParameterTypeListCase) String() string {
	switch n {
	case ParameterTypeListList:
		return "ParameterTypeListList"
	case ParameterTypeListVar:
		return "ParameterTypeListVar"
	default:
		return fmt.Sprintf("ParameterTypeListCase(%v)", int(n))
	}
}

// ParameterTypeList represents data reduced by productions:
//
//	ParameterTypeList:
//	        ParameterList            // Case ParameterTypeListList
//	|       ParameterList ',' "..."  // Case ParameterTypeListVar
type ParameterTypeList struct {
	Case          ParameterTypeListCase `PrettyPrint:"stringer,zero"`
	ParameterList *ParameterList
	Token         Token
	Token2        Token
}

// String implements fmt.Stringer.
func (n *ParameterTypeList) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *ParameterTypeList) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 0:
		return n.ParameterList.Position()
	case 1:
		if p := n.ParameterList.Position(); p.IsValid() {
			return p
		}

		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		return n.Token2.Position()
	default:
		panic("internal error")
	}
}

// PointerCase represents case numbers of production Pointer
type PointerCase int

// Values of type PointerCase
const (
	PointerTypeQual PointerCase = iota
	PointerPtr
	PointerBlock
)

// String implements fmt.Stringer
func (n PointerCase) String() string {
	switch n {
	case PointerTypeQual:
		return "PointerTypeQual"
	case PointerPtr:
		return "PointerPtr"
	case PointerBlock:
		return "PointerBlock"
	default:
		return fmt.Sprintf("PointerCase(%v)", int(n))
	}
}

// Pointer represents data reduced by productions:
//
//	Pointer:
//	        '*' TypeQualifiers          // Case PointerTypeQual
//	|       '*' TypeQualifiers Pointer  // Case PointerPtr
//	|       '^' TypeQualifiers          // Case PointerBlock
type Pointer struct {
	*lexicalScope
	Case           PointerCase `PrettyPrint:"stringer,zero"`
	Pointer        *Pointer
	Token          Token
	TypeQualifiers *TypeQualifiers
}

// String implements fmt.Stringer.
func (n *Pointer) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *Pointer) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 0, 2:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		return n.TypeQualifiers.Position()
	case 1:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.TypeQualifiers.Position(); p.IsValid() {
			return p
		}

		return n.Pointer.Position()
	default:
		panic("internal error")
	}
}

// PostfixExpressionCase represents case numbers of production PostfixExpression
type PostfixExpressionCase int

// Values of type PostfixExpressionCase
const (
	PostfixExpressionPrimary PostfixExpressionCase = iota
	PostfixExpressionIndex
	PostfixExpressionCall
	PostfixExpressionSelect
	PostfixExpressionPSelect
	PostfixExpressionInc
	PostfixExpressionDec
	PostfixExpressionComplit
)

// String implements fmt.Stringer
func (n PostfixExpressionCase) String() string {
	switch n {
	case PostfixExpressionPrimary:
		return "PostfixExpressionPrimary"
	case PostfixExpressionIndex:
		return "PostfixExpressionIndex"
	case PostfixExpressionCall:
		return "PostfixExpressionCall"
	case PostfixExpressionSelect:
		return "PostfixExpressionSelect"
	case PostfixExpressionPSelect:
		return "PostfixExpressionPSelect"
	case PostfixExpressionInc:
		return "PostfixExpressionInc"
	case PostfixExpressionDec:
		return "PostfixExpressionDec"
	case PostfixExpressionComplit:
		return "PostfixExpressionComplit"
	default:
		return fmt.Sprintf("PostfixExpressionCase(%v)", int(n))
	}
}

// PostfixExpression represents data reduced by productions:
//
//	PostfixExpression:
//	        PrimaryExpression                                 // Case PostfixExpressionPrimary
//	|       PostfixExpression '[' ExpressionList ']'          // Case PostfixExpressionIndex
//	|       PostfixExpression '(' ArgumentExpressionList ')'  // Case PostfixExpressionCall
//	|       PostfixExpression '.' IDENTIFIER                  // Case PostfixExpressionSelect
//	|       PostfixExpression "->" IDENTIFIER                 // Case PostfixExpressionPSelect
//	|       PostfixExpression "++"                            // Case PostfixExpressionInc
//	|       PostfixExpression "--"                            // Case PostfixExpressionDec
//	|       '(' TypeName ')' '{' InitializerList ',' '}'      // Case PostfixExpressionComplit
type PostfixExpression struct {
	typer
	valuer
	field *Field
	purer
	ArgumentExpressionList *ArgumentExpressionList
	Case                   PostfixExpressionCase `PrettyPrint:"stringer,zero"`
	ExpressionList         ExpressionNode
	InitializerList        *InitializerList
	PostfixExpression      ExpressionNode
	PrimaryExpression      ExpressionNode
	Token                  Token
	Token2                 Token
	Token3                 Token
	Token4                 Token
	Token5                 Token
	TypeName               *TypeName
}

// String implements fmt.Stringer.
func (n *PostfixExpression) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *PostfixExpression) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 5, 6:
		if p := n.PostfixExpression.Position(); p.IsValid() {
			return p
		}

		return n.Token.Position()
	case 2:
		if p := n.PostfixExpression.Position(); p.IsValid() {
			return p
		}

		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.ArgumentExpressionList.Position(); p.IsValid() {
			return p
		}

		return n.Token2.Position()
	case 1:
		if p := n.PostfixExpression.Position(); p.IsValid() {
			return p
		}

		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.ExpressionList.Position(); p.IsValid() {
			return p
		}

		return n.Token2.Position()
	case 3, 4:
		if p := n.PostfixExpression.Position(); p.IsValid() {
			return p
		}

		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		return n.Token2.Position()
	case 0:
		return n.PrimaryExpression.Position()
	case 7:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.TypeName.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		if p := n.Token3.Position(); p.IsValid() {
			return p
		}

		if p := n.InitializerList.Position(); p.IsValid() {
			return p
		}

		if p := n.Token4.Position(); p.IsValid() {
			return p
		}

		return n.Token5.Position()
	default:
		panic("internal error")
	}
}

// PrimaryExpressionCase represents case numbers of production PrimaryExpression
type PrimaryExpressionCase int

// Values of type PrimaryExpressionCase
const (
	PrimaryExpressionIdent PrimaryExpressionCase = iota
	PrimaryExpressionInt
	PrimaryExpressionFloat
	PrimaryExpressionChar
	PrimaryExpressionLChar
	PrimaryExpressionString
	PrimaryExpressionLString
	PrimaryExpressionExpr
	PrimaryExpressionStmt
	PrimaryExpressionGeneric
)

// String implements fmt.Stringer
func (n PrimaryExpressionCase) String() string {
	switch n {
	case PrimaryExpressionIdent:
		return "PrimaryExpressionIdent"
	case PrimaryExpressionInt:
		return "PrimaryExpressionInt"
	case PrimaryExpressionFloat:
		return "PrimaryExpressionFloat"
	case PrimaryExpressionChar:
		return "PrimaryExpressionChar"
	case PrimaryExpressionLChar:
		return "PrimaryExpressionLChar"
	case PrimaryExpressionString:
		return "PrimaryExpressionString"
	case PrimaryExpressionLString:
		return "PrimaryExpressionLString"
	case PrimaryExpressionExpr:
		return "PrimaryExpressionExpr"
	case PrimaryExpressionStmt:
		return "PrimaryExpressionStmt"
	case PrimaryExpressionGeneric:
		return "PrimaryExpressionGeneric"
	default:
		return fmt.Sprintf("PrimaryExpressionCase(%v)", int(n))
	}
}

// PrimaryExpression represents data reduced by productions:
//
//	PrimaryExpression:
//	        IDENTIFIER                 // Case PrimaryExpressionIdent
//	|       INTCONST                   // Case PrimaryExpressionInt
//	|       FLOATCONST                 // Case PrimaryExpressionFloat
//	|       CHARCONST                  // Case PrimaryExpressionChar
//	|       LONGCHARCONST              // Case PrimaryExpressionLChar
//	|       STRINGLITERAL              // Case PrimaryExpressionString
//	|       LONGSTRINGLITERAL          // Case PrimaryExpressionLString
//	|       '(' ExpressionList ')'     // Case PrimaryExpressionExpr
//	|       '(' CompoundStatement ')'  // Case PrimaryExpressionStmt
//	|       GenericSelection           // Case PrimaryExpressionGeneric
type PrimaryExpression struct {
	m *Macro
	*lexicalScope
	resolvedTo Node
	typer
	valuer
	purer
	Case              PrimaryExpressionCase `PrettyPrint:"stringer,zero"`
	CompoundStatement *CompoundStatement
	ExpressionList    ExpressionNode
	GenericSelection  *GenericSelection
	Token             Token
	Token2            Token
}

// String implements fmt.Stringer.
func (n *PrimaryExpression) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *PrimaryExpression) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 9:
		return n.GenericSelection.Position()
	case 0, 1, 2, 3, 4, 5, 6:
		return n.Token.Position()
	case 8:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.CompoundStatement.Position(); p.IsValid() {
			return p
		}

		return n.Token2.Position()
	case 7:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.ExpressionList.Position(); p.IsValid() {
			return p
		}

		return n.Token2.Position()
	default:
		panic("internal error")
	}
}

// RelationalExpressionCase represents case numbers of production RelationalExpression
type RelationalExpressionCase int

// Values of type RelationalExpressionCase
const (
	RelationalExpressionShift RelationalExpressionCase = iota
	RelationalExpressionLt
	RelationalExpressionGt
	RelationalExpressionLeq
	RelationalExpressionGeq
)

// String implements fmt.Stringer
func (n RelationalExpressionCase) String() string {
	switch n {
	case RelationalExpressionShift:
		return "RelationalExpressionShift"
	case RelationalExpressionLt:
		return "RelationalExpressionLt"
	case RelationalExpressionGt:
		return "RelationalExpressionGt"
	case RelationalExpressionLeq:
		return "RelationalExpressionLeq"
	case RelationalExpressionGeq:
		return "RelationalExpressionGeq"
	default:
		return fmt.Sprintf("RelationalExpressionCase(%v)", int(n))
	}
}

// RelationalExpression represents data reduced by productions:
//
//	RelationalExpression:
//	        ShiftExpression                            // Case RelationalExpressionShift
//	|       RelationalExpression '<' ShiftExpression   // Case RelationalExpressionLt
//	|       RelationalExpression '>' ShiftExpression   // Case RelationalExpressionGt
//	|       RelationalExpression "<=" ShiftExpression  // Case RelationalExpressionLeq
//	|       RelationalExpression ">=" ShiftExpression  // Case RelationalExpressionGeq
type RelationalExpression struct {
	typer
	valuer
	purer
	Case                 RelationalExpressionCase `PrettyPrint:"stringer,zero"`
	RelationalExpression ExpressionNode
	ShiftExpression      ExpressionNode
	Token                Token
}

// String implements fmt.Stringer.
func (n *RelationalExpression) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *RelationalExpression) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 1, 2, 3, 4:
		if p := n.RelationalExpression.Position(); p.IsValid() {
			return p
		}

		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		return n.ShiftExpression.Position()
	case 0:
		return n.ShiftExpression.Position()
	default:
		panic("internal error")
	}
}

// SelectionStatementCase represents case numbers of production SelectionStatement
type SelectionStatementCase int

// Values of type SelectionStatementCase
const (
	SelectionStatementIf SelectionStatementCase = iota
	SelectionStatementIfElse
	SelectionStatementSwitch
)

// String implements fmt.Stringer
func (n SelectionStatementCase) String() string {
	switch n {
	case SelectionStatementIf:
		return "SelectionStatementIf"
	case SelectionStatementIfElse:
		return "SelectionStatementIfElse"
	case SelectionStatementSwitch:
		return "SelectionStatementSwitch"
	default:
		return fmt.Sprintf("SelectionStatementCase(%v)", int(n))
	}
}

// SelectionStatement represents data reduced by productions:
//
//	SelectionStatement:
//	        "if" '(' ExpressionList ')' Statement                   // Case SelectionStatementIf
//	|       "if" '(' ExpressionList ')' Statement "else" Statement  // Case SelectionStatementIfElse
//	|       "switch" '(' ExpressionList ')' Statement               // Case SelectionStatementSwitch
type SelectionStatement struct {
	switchCases int
	*lexicalScope
	labeled        []*LabeledStatement
	Case           SelectionStatementCase `PrettyPrint:"stringer,zero"`
	ExpressionList ExpressionNode
	Statement      *Statement
	Statement2     *Statement
	Token          Token
	Token2         Token
	Token3         Token
	Token4         Token
}

// String implements fmt.Stringer.
func (n *SelectionStatement) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *SelectionStatement) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 0, 2:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		if p := n.ExpressionList.Position(); p.IsValid() {
			return p
		}

		if p := n.Token3.Position(); p.IsValid() {
			return p
		}

		return n.Statement.Position()
	case 1:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		if p := n.ExpressionList.Position(); p.IsValid() {
			return p
		}

		if p := n.Token3.Position(); p.IsValid() {
			return p
		}

		if p := n.Statement.Position(); p.IsValid() {
			return p
		}

		if p := n.Token4.Position(); p.IsValid() {
			return p
		}

		return n.Statement2.Position()
	default:
		panic("internal error")
	}
}

// ShiftExpressionCase represents case numbers of production ShiftExpression
type ShiftExpressionCase int

// Values of type ShiftExpressionCase
const (
	ShiftExpressionAdd ShiftExpressionCase = iota
	ShiftExpressionLsh
	ShiftExpressionRsh
)

// String implements fmt.Stringer
func (n ShiftExpressionCase) String() string {
	switch n {
	case ShiftExpressionAdd:
		return "ShiftExpressionAdd"
	case ShiftExpressionLsh:
		return "ShiftExpressionLsh"
	case ShiftExpressionRsh:
		return "ShiftExpressionRsh"
	default:
		return fmt.Sprintf("ShiftExpressionCase(%v)", int(n))
	}
}

// ShiftExpression represents data reduced by productions:
//
//	ShiftExpression:
//	        AdditiveExpression                       // Case ShiftExpressionAdd
//	|       ShiftExpression "<<" AdditiveExpression  // Case ShiftExpressionLsh
//	|       ShiftExpression ">>" AdditiveExpression  // Case ShiftExpressionRsh
type ShiftExpression struct {
	typer
	valuer
	purer
	AdditiveExpression ExpressionNode
	Case               ShiftExpressionCase `PrettyPrint:"stringer,zero"`
	ShiftExpression    ExpressionNode
	Token              Token
}

// String implements fmt.Stringer.
func (n *ShiftExpression) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *ShiftExpression) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 0:
		return n.AdditiveExpression.Position()
	case 1, 2:
		if p := n.ShiftExpression.Position(); p.IsValid() {
			return p
		}

		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		return n.AdditiveExpression.Position()
	default:
		panic("internal error")
	}
}

// SpecifierQualifierListCase represents case numbers of production SpecifierQualifierList
type SpecifierQualifierListCase int

// Values of type SpecifierQualifierListCase
const (
	SpecifierQualifierListTypeSpec SpecifierQualifierListCase = iota
	SpecifierQualifierListTypeQual
	SpecifierQualifierListAlignSpec
)

// String implements fmt.Stringer
func (n SpecifierQualifierListCase) String() string {
	switch n {
	case SpecifierQualifierListTypeSpec:
		return "SpecifierQualifierListTypeSpec"
	case SpecifierQualifierListTypeQual:
		return "SpecifierQualifierListTypeQual"
	case SpecifierQualifierListAlignSpec:
		return "SpecifierQualifierListAlignSpec"
	default:
		return fmt.Sprintf("SpecifierQualifierListCase(%v)", int(n))
	}
}

// SpecifierQualifierList represents data reduced by productions:
//
//	SpecifierQualifierList:
//	        TypeSpecifier SpecifierQualifierList       // Case SpecifierQualifierListTypeSpec
//	|       TypeQualifier SpecifierQualifierList       // Case SpecifierQualifierListTypeQual
//	|       AlignmentSpecifier SpecifierQualifierList  // Case SpecifierQualifierListAlignSpec
type SpecifierQualifierList struct {
	AttributeSpecifierList *AttributeSpecifierList
	AlignmentSpecifier     *AlignmentSpecifier
	Case                   SpecifierQualifierListCase `PrettyPrint:"stringer,zero"`
	SpecifierQualifierList *SpecifierQualifierList
	TypeQualifier          *TypeQualifier
	TypeSpecifier          *TypeSpecifier
}

// String implements fmt.Stringer.
func (n *SpecifierQualifierList) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *SpecifierQualifierList) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 2:
		if p := n.AlignmentSpecifier.Position(); p.IsValid() {
			return p
		}

		return n.SpecifierQualifierList.Position()
	case 1:
		if p := n.TypeQualifier.Position(); p.IsValid() {
			return p
		}

		return n.SpecifierQualifierList.Position()
	case 0:
		if p := n.TypeSpecifier.Position(); p.IsValid() {
			return p
		}

		return n.SpecifierQualifierList.Position()
	default:
		panic("internal error")
	}
}

// StatementCase represents case numbers of production Statement
type StatementCase int

// Values of type StatementCase
const (
	StatementLabeled StatementCase = iota
	StatementCompound
	StatementExpr
	StatementSelection
	StatementIteration
	StatementJump
	StatementAsm
)

// String implements fmt.Stringer
func (n StatementCase) String() string {
	switch n {
	case StatementLabeled:
		return "StatementLabeled"
	case StatementCompound:
		return "StatementCompound"
	case StatementExpr:
		return "StatementExpr"
	case StatementSelection:
		return "StatementSelection"
	case StatementIteration:
		return "StatementIteration"
	case StatementJump:
		return "StatementJump"
	case StatementAsm:
		return "StatementAsm"
	default:
		return fmt.Sprintf("StatementCase(%v)", int(n))
	}
}

// Statement represents data reduced by productions:
//
//	Statement:
//	        LabeledStatement     // Case StatementLabeled
//	|       CompoundStatement    // Case StatementCompound
//	|       ExpressionStatement  // Case StatementExpr
//	|       SelectionStatement   // Case StatementSelection
//	|       IterationStatement   // Case StatementIteration
//	|       JumpStatement        // Case StatementJump
//	|       AsmStatement         // Case StatementAsm
type Statement struct {
	AsmStatement        *AsmStatement
	Case                StatementCase `PrettyPrint:"stringer,zero"`
	CompoundStatement   *CompoundStatement
	ExpressionStatement *ExpressionStatement
	IterationStatement  *IterationStatement
	JumpStatement       *JumpStatement
	LabeledStatement    *LabeledStatement
	SelectionStatement  *SelectionStatement
}

// String implements fmt.Stringer.
func (n *Statement) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *Statement) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 6:
		return n.AsmStatement.Position()
	case 1:
		return n.CompoundStatement.Position()
	case 2:
		return n.ExpressionStatement.Position()
	case 4:
		return n.IterationStatement.Position()
	case 5:
		return n.JumpStatement.Position()
	case 0:
		return n.LabeledStatement.Position()
	case 3:
		return n.SelectionStatement.Position()
	default:
		panic("internal error")
	}
}

// StaticAssertDeclaration represents data reduced by production:
//
//	StaticAssertDeclaration:
//	        "_Static_assert" '(' ConstantExpression ',' STRINGLITERAL ')'
type StaticAssertDeclaration struct {
	ConstantExpression ExpressionNode
	Token              Token
	Token2             Token
	Token3             Token
	Token4             Token
	Token5             Token
}

// String implements fmt.Stringer.
func (n *StaticAssertDeclaration) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *StaticAssertDeclaration) Position() (r token.Position) {
	if n == nil {
		return r
	}

	if p := n.Token.Position(); p.IsValid() {
		return p
	}

	if p := n.Token2.Position(); p.IsValid() {
		return p
	}

	if p := n.ConstantExpression.Position(); p.IsValid() {
		return p
	}

	if p := n.Token3.Position(); p.IsValid() {
		return p
	}

	if p := n.Token4.Position(); p.IsValid() {
		return p
	}

	return n.Token5.Position()
}

// StorageClassSpecifierCase represents case numbers of production StorageClassSpecifier
type StorageClassSpecifierCase int

// Values of type StorageClassSpecifierCase
const (
	StorageClassSpecifierTypedef StorageClassSpecifierCase = iota
	StorageClassSpecifierExtern
	StorageClassSpecifierStatic
	StorageClassSpecifierAuto
	StorageClassSpecifierRegister
	StorageClassSpecifierThreadLocal
	StorageClassSpecifierDeclspec
)

// String implements fmt.Stringer
func (n StorageClassSpecifierCase) String() string {
	switch n {
	case StorageClassSpecifierTypedef:
		return "StorageClassSpecifierTypedef"
	case StorageClassSpecifierExtern:
		return "StorageClassSpecifierExtern"
	case StorageClassSpecifierStatic:
		return "StorageClassSpecifierStatic"
	case StorageClassSpecifierAuto:
		return "StorageClassSpecifierAuto"
	case StorageClassSpecifierRegister:
		return "StorageClassSpecifierRegister"
	case StorageClassSpecifierThreadLocal:
		return "StorageClassSpecifierThreadLocal"
	case StorageClassSpecifierDeclspec:
		return "StorageClassSpecifierDeclspec"
	default:
		return fmt.Sprintf("StorageClassSpecifierCase(%v)", int(n))
	}
}

// StorageClassSpecifier represents data reduced by productions:
//
//	StorageClassSpecifier:
//	        "typedef"             // Case StorageClassSpecifierTypedef
//	|       "extern"              // Case StorageClassSpecifierExtern
//	|       "static"              // Case StorageClassSpecifierStatic
//	|       "auto"                // Case StorageClassSpecifierAuto
//	|       "register"            // Case StorageClassSpecifierRegister
//	|       "_Thread_local"       // Case StorageClassSpecifierThreadLocal
//	|       "__declspec" '(' ')'  // Case StorageClassSpecifierDeclspec
type StorageClassSpecifier struct {
	Declspecs []Token
	Case      StorageClassSpecifierCase `PrettyPrint:"stringer,zero"`
	Token     Token
	Token2    Token
	Token3    Token
}

// String implements fmt.Stringer.
func (n *StorageClassSpecifier) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *StorageClassSpecifier) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 0, 1, 2, 3, 4, 5:
		return n.Token.Position()
	case 6:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		return n.Token3.Position()
	default:
		panic("internal error")
	}
}

// StructDeclarationCase represents case numbers of production StructDeclaration
type StructDeclarationCase int

// Values of type StructDeclarationCase
const (
	StructDeclarationDecl StructDeclarationCase = iota
	StructDeclarationAssert
)

// String implements fmt.Stringer
func (n StructDeclarationCase) String() string {
	switch n {
	case StructDeclarationDecl:
		return "StructDeclarationDecl"
	case StructDeclarationAssert:
		return "StructDeclarationAssert"
	default:
		return fmt.Sprintf("StructDeclarationCase(%v)", int(n))
	}
}

// StructDeclaration represents data reduced by productions:
//
//	StructDeclaration:
//	        SpecifierQualifierList StructDeclaratorList ';'  // Case StructDeclarationDecl
//	|       StaticAssertDeclaration                          // Case StructDeclarationAssert
type StructDeclaration struct {
	AttributeSpecifierList  *AttributeSpecifierList
	Case                    StructDeclarationCase `PrettyPrint:"stringer,zero"`
	SpecifierQualifierList  *SpecifierQualifierList
	StaticAssertDeclaration *StaticAssertDeclaration
	StructDeclaratorList    *StructDeclaratorList
	Token                   Token
}

// String implements fmt.Stringer.
func (n *StructDeclaration) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *StructDeclaration) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 0:
		if p := n.SpecifierQualifierList.Position(); p.IsValid() {
			return p
		}

		if p := n.StructDeclaratorList.Position(); p.IsValid() {
			return p
		}

		return n.Token.Position()
	case 1:
		return n.StaticAssertDeclaration.Position()
	default:
		panic("internal error")
	}
}

// StructDeclarationList represents data reduced by productions:
//
//	StructDeclarationList:
//	        StructDeclaration
//	|       StructDeclarationList StructDeclaration
type StructDeclarationList struct {
	StructDeclaration     *StructDeclaration
	StructDeclarationList *StructDeclarationList
}

// String implements fmt.Stringer.
func (n *StructDeclarationList) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *StructDeclarationList) Position() (r token.Position) {
	if n == nil {
		return r
	}

	return n.StructDeclaration.Position()
}

// StructDeclaratorCase represents case numbers of production StructDeclarator
type StructDeclaratorCase int

// Values of type StructDeclaratorCase
const (
	StructDeclaratorDecl StructDeclaratorCase = iota
	StructDeclaratorBitField
)

// String implements fmt.Stringer
func (n StructDeclaratorCase) String() string {
	switch n {
	case StructDeclaratorDecl:
		return "StructDeclaratorDecl"
	case StructDeclaratorBitField:
		return "StructDeclaratorBitField"
	default:
		return fmt.Sprintf("StructDeclaratorCase(%v)", int(n))
	}
}

// StructDeclarator represents data reduced by productions:
//
//	StructDeclarator:
//	        Declarator                         // Case StructDeclaratorDecl
//	|       Declarator ':' ConstantExpression  // Case StructDeclaratorBitField
type StructDeclarator struct {
	Case               StructDeclaratorCase `PrettyPrint:"stringer,zero"`
	ConstantExpression ExpressionNode
	Declarator         *Declarator
	Token              Token
}

// String implements fmt.Stringer.
func (n *StructDeclarator) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *StructDeclarator) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 0:
		return n.Declarator.Position()
	case 1:
		if p := n.Declarator.Position(); p.IsValid() {
			return p
		}

		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		return n.ConstantExpression.Position()
	default:
		panic("internal error")
	}
}

// StructDeclaratorList represents data reduced by productions:
//
//	StructDeclaratorList:
//	        StructDeclarator
//	|       StructDeclaratorList ',' StructDeclarator
type StructDeclaratorList struct {
	StructDeclarator     *StructDeclarator
	StructDeclaratorList *StructDeclaratorList
	Token                Token
}

// String implements fmt.Stringer.
func (n *StructDeclaratorList) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *StructDeclaratorList) Position() (r token.Position) {
	if n == nil {
		return r
	}

	return n.StructDeclarator.Position()
}

// StructOrUnionCase represents case numbers of production StructOrUnion
type StructOrUnionCase int

// Values of type StructOrUnionCase
const (
	StructOrUnionStruct StructOrUnionCase = iota
	StructOrUnionUnion
)

// String implements fmt.Stringer
func (n StructOrUnionCase) String() string {
	switch n {
	case StructOrUnionStruct:
		return "StructOrUnionStruct"
	case StructOrUnionUnion:
		return "StructOrUnionUnion"
	default:
		return fmt.Sprintf("StructOrUnionCase(%v)", int(n))
	}
}

// StructOrUnion represents data reduced by productions:
//
//	StructOrUnion:
//	        "struct"  // Case StructOrUnionStruct
//	|       "union"   // Case StructOrUnionUnion
type StructOrUnion struct {
	Case  StructOrUnionCase `PrettyPrint:"stringer,zero"`
	Token Token
}

// String implements fmt.Stringer.
func (n *StructOrUnion) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *StructOrUnion) Position() (r token.Position) {
	if n == nil {
		return r
	}

	return n.Token.Position()
}

// StructOrUnionSpecifierCase represents case numbers of production StructOrUnionSpecifier
type StructOrUnionSpecifierCase int

// Values of type StructOrUnionSpecifierCase
const (
	StructOrUnionSpecifierDef StructOrUnionSpecifierCase = iota
	StructOrUnionSpecifierTag
)

// String implements fmt.Stringer
func (n StructOrUnionSpecifierCase) String() string {
	switch n {
	case StructOrUnionSpecifierDef:
		return "StructOrUnionSpecifierDef"
	case StructOrUnionSpecifierTag:
		return "StructOrUnionSpecifierTag"
	default:
		return fmt.Sprintf("StructOrUnionSpecifierCase(%v)", int(n))
	}
}

// StructOrUnionSpecifier represents data reduced by productions:
//
//	StructOrUnionSpecifier:
//	        StructOrUnion IDENTIFIER '{' StructDeclarationList '}'  // Case StructOrUnionSpecifierDef
//	|       StructOrUnion IDENTIFIER                                // Case StructOrUnionSpecifierTag
type StructOrUnionSpecifier struct {
	AttributeSpecifierList  *AttributeSpecifierList
	AttributeSpecifierList2 *AttributeSpecifierList
	*lexicalScope
	visible
	typer
	Case                  StructOrUnionSpecifierCase `PrettyPrint:"stringer,zero"`
	StructDeclarationList *StructDeclarationList
	StructOrUnion         *StructOrUnion
	Token                 Token
	Token2                Token
	Token3                Token
}

// String implements fmt.Stringer.
func (n *StructOrUnionSpecifier) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *StructOrUnionSpecifier) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 1:
		if p := n.StructOrUnion.Position(); p.IsValid() {
			return p
		}

		return n.Token.Position()
	case 0:
		if p := n.StructOrUnion.Position(); p.IsValid() {
			return p
		}

		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		if p := n.StructDeclarationList.Position(); p.IsValid() {
			return p
		}

		return n.Token3.Position()
	default:
		panic("internal error")
	}
}

// TranslationUnit represents data reduced by productions:
//
//	TranslationUnit:
//	        ExternalDeclaration
//	|       TranslationUnit ExternalDeclaration
type TranslationUnit struct {
	ExternalDeclaration *ExternalDeclaration
	TranslationUnit     *TranslationUnit
}

// String implements fmt.Stringer.
func (n *TranslationUnit) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *TranslationUnit) Position() (r token.Position) {
	if n == nil {
		return r
	}

	return n.ExternalDeclaration.Position()
}

// TypeName represents data reduced by production:
//
//	TypeName:
//	        SpecifierQualifierList AbstractDeclarator
type TypeName struct {
	typer
	AbstractDeclarator     *AbstractDeclarator
	SpecifierQualifierList *SpecifierQualifierList
}

// String implements fmt.Stringer.
func (n *TypeName) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *TypeName) Position() (r token.Position) {
	if n == nil {
		return r
	}

	if p := n.SpecifierQualifierList.Position(); p.IsValid() {
		return p
	}

	return n.AbstractDeclarator.Position()
}

// TypeQualifierCase represents case numbers of production TypeQualifier
type TypeQualifierCase int

// Values of type TypeQualifierCase
const (
	TypeQualifierConst TypeQualifierCase = iota
	TypeQualifierRestrict
	TypeQualifierVolatile
	TypeQualifierAtomic
	TypeQualifierNonnull
	TypeQualifierAttr
)

// String implements fmt.Stringer
func (n TypeQualifierCase) String() string {
	switch n {
	case TypeQualifierConst:
		return "TypeQualifierConst"
	case TypeQualifierRestrict:
		return "TypeQualifierRestrict"
	case TypeQualifierVolatile:
		return "TypeQualifierVolatile"
	case TypeQualifierAtomic:
		return "TypeQualifierAtomic"
	case TypeQualifierNonnull:
		return "TypeQualifierNonnull"
	case TypeQualifierAttr:
		return "TypeQualifierAttr"
	default:
		return fmt.Sprintf("TypeQualifierCase(%v)", int(n))
	}
}

// TypeQualifier represents data reduced by productions:
//
//	TypeQualifier:
//	        "const"          // Case TypeQualifierConst
//	|       "restrict"       // Case TypeQualifierRestrict
//	|       "volatile"       // Case TypeQualifierVolatile
//	|       "_Atomic"        // Case TypeQualifierAtomic
//	|       "_Nonnull"       // Case TypeQualifierNonnull
//	|       "__attribute__"  // Case TypeQualifierAttr
type TypeQualifier struct {
	AttributeSpecifierList *AttributeSpecifierList
	Case                   TypeQualifierCase `PrettyPrint:"stringer,zero"`
	Token                  Token
}

// String implements fmt.Stringer.
func (n *TypeQualifier) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *TypeQualifier) Position() (r token.Position) {
	if n == nil {
		return r
	}

	return n.Token.Position()
}

// TypeQualifiersCase represents case numbers of production TypeQualifiers
type TypeQualifiersCase int

// Values of type TypeQualifiersCase
const (
	TypeQualifiersTypeQual TypeQualifiersCase = iota
	_
)

// String implements fmt.Stringer
func (n TypeQualifiersCase) String() string {
	switch n {
	case TypeQualifiersTypeQual:
		return "TypeQualifiersTypeQual"
	default:
		return fmt.Sprintf("TypeQualifiersCase(%v)", int(n))
	}
}

// TypeQualifiers represents data reduced by productions:
//
//	TypeQualifiers:
//	        TypeQualifier                 // Case TypeQualifiersTypeQual
//	|       TypeQualifiers TypeQualifier  // Case 1
type TypeQualifiers struct {
	Case           TypeQualifiersCase `PrettyPrint:"stringer,zero"`
	TypeQualifier  *TypeQualifier
	TypeQualifiers *TypeQualifiers
}

// String implements fmt.Stringer.
func (n *TypeQualifiers) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *TypeQualifiers) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 0:
		return n.TypeQualifier.Position()
	case 1:
		if p := n.TypeQualifiers.Position(); p.IsValid() {
			return p
		}

		return n.TypeQualifier.Position()
	default:
		panic("internal error")
	}
}

// TypeSpecifierCase represents case numbers of production TypeSpecifier
type TypeSpecifierCase int

// Values of type TypeSpecifierCase
const (
	TypeSpecifierVoid TypeSpecifierCase = iota
	TypeSpecifierChar
	TypeSpecifierShort
	TypeSpecifierInt
	TypeSpecifierInt128
	TypeSpecifierUint128
	TypeSpecifierLong
	TypeSpecifierFloat
	TypeSpecifierFloat16
	TypeSpecifierDecimal32
	TypeSpecifierDecimal64
	TypeSpecifierDecimal128
	TypeSpecifierFloat128
	TypeSpecifierFloat128x
	TypeSpecifierDouble
	TypeSpecifierSigned
	TypeSpecifierUnsigned
	TypeSpecifierBool
	TypeSpecifierComplex
	TypeSpecifierImaginary
	TypeSpecifierStructOrUnion
	TypeSpecifierEnum
	TypeSpecifierTypeName
	TypeSpecifierTypeofExpr
	TypeSpecifierTypeofType
	TypeSpecifierAtomic
	TypeSpecifierFloat32
	TypeSpecifierFloat64
	TypeSpecifierFloat32x
	TypeSpecifierFloat64x
)

// String implements fmt.Stringer
func (n TypeSpecifierCase) String() string {
	switch n {
	case TypeSpecifierVoid:
		return "TypeSpecifierVoid"
	case TypeSpecifierChar:
		return "TypeSpecifierChar"
	case TypeSpecifierShort:
		return "TypeSpecifierShort"
	case TypeSpecifierInt:
		return "TypeSpecifierInt"
	case TypeSpecifierInt128:
		return "TypeSpecifierInt128"
	case TypeSpecifierUint128:
		return "TypeSpecifierUint128"
	case TypeSpecifierLong:
		return "TypeSpecifierLong"
	case TypeSpecifierFloat:
		return "TypeSpecifierFloat"
	case TypeSpecifierFloat16:
		return "TypeSpecifierFloat16"
	case TypeSpecifierDecimal32:
		return "TypeSpecifierDecimal32"
	case TypeSpecifierDecimal64:
		return "TypeSpecifierDecimal64"
	case TypeSpecifierDecimal128:
		return "TypeSpecifierDecimal128"
	case TypeSpecifierFloat128:
		return "TypeSpecifierFloat128"
	case TypeSpecifierFloat128x:
		return "TypeSpecifierFloat128x"
	case TypeSpecifierDouble:
		return "TypeSpecifierDouble"
	case TypeSpecifierSigned:
		return "TypeSpecifierSigned"
	case TypeSpecifierUnsigned:
		return "TypeSpecifierUnsigned"
	case TypeSpecifierBool:
		return "TypeSpecifierBool"
	case TypeSpecifierComplex:
		return "TypeSpecifierComplex"
	case TypeSpecifierImaginary:
		return "TypeSpecifierImaginary"
	case TypeSpecifierStructOrUnion:
		return "TypeSpecifierStructOrUnion"
	case TypeSpecifierEnum:
		return "TypeSpecifierEnum"
	case TypeSpecifierTypeName:
		return "TypeSpecifierTypeName"
	case TypeSpecifierTypeofExpr:
		return "TypeSpecifierTypeofExpr"
	case TypeSpecifierTypeofType:
		return "TypeSpecifierTypeofType"
	case TypeSpecifierAtomic:
		return "TypeSpecifierAtomic"
	case TypeSpecifierFloat32:
		return "TypeSpecifierFloat32"
	case TypeSpecifierFloat64:
		return "TypeSpecifierFloat64"
	case TypeSpecifierFloat32x:
		return "TypeSpecifierFloat32x"
	case TypeSpecifierFloat64x:
		return "TypeSpecifierFloat64x"
	default:
		return fmt.Sprintf("TypeSpecifierCase(%v)", int(n))
	}
}

// TypeSpecifier represents data reduced by productions:
//
//	TypeSpecifier:
//	        "void"                           // Case TypeSpecifierVoid
//	|       "char"                           // Case TypeSpecifierChar
//	|       "short"                          // Case TypeSpecifierShort
//	|       "int"                            // Case TypeSpecifierInt
//	|       "__int128"                       // Case TypeSpecifierInt128
//	|       "__uint128_t"                    // Case TypeSpecifierUint128
//	|       "long"                           // Case TypeSpecifierLong
//	|       "float"                          // Case TypeSpecifierFloat
//	|       "_Float16"                       // Case TypeSpecifierFloat16
//	|       "_Decimal32"                     // Case TypeSpecifierDecimal32
//	|       "_Decimal64"                     // Case TypeSpecifierDecimal64
//	|       "_Decimal128"                    // Case TypeSpecifierDecimal128
//	|       "_Float128"                      // Case TypeSpecifierFloat128
//	|       "_Float128x"                     // Case TypeSpecifierFloat128x
//	|       "double"                         // Case TypeSpecifierDouble
//	|       "signed"                         // Case TypeSpecifierSigned
//	|       "unsigned"                       // Case TypeSpecifierUnsigned
//	|       "_Bool"                          // Case TypeSpecifierBool
//	|       "_Complex"                       // Case TypeSpecifierComplex
//	|       "_Imaginary"                     // Case TypeSpecifierImaginary
//	|       StructOrUnionSpecifier           // Case TypeSpecifierStructOrUnion
//	|       EnumSpecifier                    // Case TypeSpecifierEnum
//	|       TYPENAME                         // Case TypeSpecifierTypeName
//	|       "typeof" '(' ExpressionList ')'  // Case TypeSpecifierTypeofExpr
//	|       "typeof" '(' TypeName ')'        // Case TypeSpecifierTypeofType
//	|       AtomicTypeSpecifier              // Case TypeSpecifierAtomic
//	|       "_Float32"                       // Case TypeSpecifierFloat32
//	|       "_Float64"                       // Case TypeSpecifierFloat64
//	|       "_Float32x"                      // Case TypeSpecifierFloat32x
//	|       "_Float64x"                      // Case TypeSpecifierFloat64x
type TypeSpecifier struct {
	*lexicalScope
	AtomicTypeSpecifier    *AtomicTypeSpecifier
	Case                   TypeSpecifierCase `PrettyPrint:"stringer,zero"`
	EnumSpecifier          *EnumSpecifier
	ExpressionList         ExpressionNode
	StructOrUnionSpecifier *StructOrUnionSpecifier
	Token                  Token
	Token2                 Token
	Token3                 Token
	TypeName               *TypeName
}

// String implements fmt.Stringer.
func (n *TypeSpecifier) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *TypeSpecifier) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 25:
		return n.AtomicTypeSpecifier.Position()
	case 21:
		return n.EnumSpecifier.Position()
	case 20:
		return n.StructOrUnionSpecifier.Position()
	case 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 22, 26, 27, 28, 29:
		return n.Token.Position()
	case 23:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		if p := n.ExpressionList.Position(); p.IsValid() {
			return p
		}

		return n.Token3.Position()
	case 24:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		if p := n.TypeName.Position(); p.IsValid() {
			return p
		}

		return n.Token3.Position()
	default:
		panic("internal error")
	}
}

// UnaryExpressionCase represents case numbers of production UnaryExpression
type UnaryExpressionCase int

// Values of type UnaryExpressionCase
const (
	UnaryExpressionPostfix UnaryExpressionCase = iota
	UnaryExpressionInc
	UnaryExpressionDec
	UnaryExpressionAddrof
	UnaryExpressionDeref
	UnaryExpressionPlus
	UnaryExpressionMinus
	UnaryExpressionCpl
	UnaryExpressionNot
	UnaryExpressionSizeofExpr
	UnaryExpressionSizeofType
	UnaryExpressionLabelAddr
	UnaryExpressionAlignofExpr
	UnaryExpressionAlignofType
	UnaryExpressionImag
	UnaryExpressionReal
)

// String implements fmt.Stringer
func (n UnaryExpressionCase) String() string {
	switch n {
	case UnaryExpressionPostfix:
		return "UnaryExpressionPostfix"
	case UnaryExpressionInc:
		return "UnaryExpressionInc"
	case UnaryExpressionDec:
		return "UnaryExpressionDec"
	case UnaryExpressionAddrof:
		return "UnaryExpressionAddrof"
	case UnaryExpressionDeref:
		return "UnaryExpressionDeref"
	case UnaryExpressionPlus:
		return "UnaryExpressionPlus"
	case UnaryExpressionMinus:
		return "UnaryExpressionMinus"
	case UnaryExpressionCpl:
		return "UnaryExpressionCpl"
	case UnaryExpressionNot:
		return "UnaryExpressionNot"
	case UnaryExpressionSizeofExpr:
		return "UnaryExpressionSizeofExpr"
	case UnaryExpressionSizeofType:
		return "UnaryExpressionSizeofType"
	case UnaryExpressionLabelAddr:
		return "UnaryExpressionLabelAddr"
	case UnaryExpressionAlignofExpr:
		return "UnaryExpressionAlignofExpr"
	case UnaryExpressionAlignofType:
		return "UnaryExpressionAlignofType"
	case UnaryExpressionImag:
		return "UnaryExpressionImag"
	case UnaryExpressionReal:
		return "UnaryExpressionReal"
	default:
		return fmt.Sprintf("UnaryExpressionCase(%v)", int(n))
	}
}

// UnaryExpression represents data reduced by productions:
//
//	UnaryExpression:
//	        PostfixExpression            // Case UnaryExpressionPostfix
//	|       "++" UnaryExpression         // Case UnaryExpressionInc
//	|       "--" UnaryExpression         // Case UnaryExpressionDec
//	|       '&' CastExpression           // Case UnaryExpressionAddrof
//	|       '*' CastExpression           // Case UnaryExpressionDeref
//	|       '+' CastExpression           // Case UnaryExpressionPlus
//	|       '-' CastExpression           // Case UnaryExpressionMinus
//	|       '~' CastExpression           // Case UnaryExpressionCpl
//	|       '!' CastExpression           // Case UnaryExpressionNot
//	|       "sizeof" UnaryExpression     // Case UnaryExpressionSizeofExpr
//	|       "sizeof" '(' TypeName ')'    // Case UnaryExpressionSizeofType
//	|       "&&" IDENTIFIER              // Case UnaryExpressionLabelAddr
//	|       "_Alignof" UnaryExpression   // Case UnaryExpressionAlignofExpr
//	|       "_Alignof" '(' TypeName ')'  // Case UnaryExpressionAlignofType
//	|       "__imag__" UnaryExpression   // Case UnaryExpressionImag
//	|       "__real__" UnaryExpression   // Case UnaryExpressionReal
type UnaryExpression struct {
	typer
	valuer
	purer
	Case              UnaryExpressionCase `PrettyPrint:"stringer,zero"`
	CastExpression    ExpressionNode
	PostfixExpression ExpressionNode
	Token             Token
	Token2            Token
	Token3            Token
	TypeName          *TypeName
	UnaryExpression   ExpressionNode
}

// String implements fmt.Stringer.
func (n *UnaryExpression) String() string { return PrettyString(n) }

// Position reports the position of the first component of n, if available.
func (n *UnaryExpression) Position() (r token.Position) {
	if n == nil {
		return r
	}

	switch n.Case {
	case 0:
		return n.PostfixExpression.Position()
	case 3, 4, 5, 6, 7, 8:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		return n.CastExpression.Position()
	case 11:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		return n.Token2.Position()
	case 10, 13:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		if p := n.Token2.Position(); p.IsValid() {
			return p
		}

		if p := n.TypeName.Position(); p.IsValid() {
			return p
		}

		return n.Token3.Position()
	case 1, 2, 9, 12, 14, 15:
		if p := n.Token.Position(); p.IsValid() {
			return p
		}

		return n.UnaryExpression.Position()
	default:
		panic("internal error")
	}
}
