// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/asset/v1/asset_service.proto

package assetpb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	AssetService_ExportAssets_FullMethodName                       = "/google.cloud.asset.v1.AssetService/ExportAssets"
	AssetService_ListAssets_FullMethodName                         = "/google.cloud.asset.v1.AssetService/ListAssets"
	AssetService_BatchGetAssetsHistory_FullMethodName              = "/google.cloud.asset.v1.AssetService/BatchGetAssetsHistory"
	AssetService_CreateFeed_FullMethodName                         = "/google.cloud.asset.v1.AssetService/CreateFeed"
	AssetService_GetFeed_FullMethodName                            = "/google.cloud.asset.v1.AssetService/GetFeed"
	AssetService_ListFeeds_FullMethodName                          = "/google.cloud.asset.v1.AssetService/ListFeeds"
	AssetService_UpdateFeed_FullMethodName                         = "/google.cloud.asset.v1.AssetService/UpdateFeed"
	AssetService_DeleteFeed_FullMethodName                         = "/google.cloud.asset.v1.AssetService/DeleteFeed"
	AssetService_SearchAllResources_FullMethodName                 = "/google.cloud.asset.v1.AssetService/SearchAllResources"
	AssetService_SearchAllIamPolicies_FullMethodName               = "/google.cloud.asset.v1.AssetService/SearchAllIamPolicies"
	AssetService_AnalyzeIamPolicy_FullMethodName                   = "/google.cloud.asset.v1.AssetService/AnalyzeIamPolicy"
	AssetService_AnalyzeIamPolicyLongrunning_FullMethodName        = "/google.cloud.asset.v1.AssetService/AnalyzeIamPolicyLongrunning"
	AssetService_AnalyzeMove_FullMethodName                        = "/google.cloud.asset.v1.AssetService/AnalyzeMove"
	AssetService_QueryAssets_FullMethodName                        = "/google.cloud.asset.v1.AssetService/QueryAssets"
	AssetService_CreateSavedQuery_FullMethodName                   = "/google.cloud.asset.v1.AssetService/CreateSavedQuery"
	AssetService_GetSavedQuery_FullMethodName                      = "/google.cloud.asset.v1.AssetService/GetSavedQuery"
	AssetService_ListSavedQueries_FullMethodName                   = "/google.cloud.asset.v1.AssetService/ListSavedQueries"
	AssetService_UpdateSavedQuery_FullMethodName                   = "/google.cloud.asset.v1.AssetService/UpdateSavedQuery"
	AssetService_DeleteSavedQuery_FullMethodName                   = "/google.cloud.asset.v1.AssetService/DeleteSavedQuery"
	AssetService_BatchGetEffectiveIamPolicies_FullMethodName       = "/google.cloud.asset.v1.AssetService/BatchGetEffectiveIamPolicies"
	AssetService_AnalyzeOrgPolicies_FullMethodName                 = "/google.cloud.asset.v1.AssetService/AnalyzeOrgPolicies"
	AssetService_AnalyzeOrgPolicyGovernedContainers_FullMethodName = "/google.cloud.asset.v1.AssetService/AnalyzeOrgPolicyGovernedContainers"
	AssetService_AnalyzeOrgPolicyGovernedAssets_FullMethodName     = "/google.cloud.asset.v1.AssetService/AnalyzeOrgPolicyGovernedAssets"
)

// AssetServiceClient is the client API for AssetService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AssetServiceClient interface {
	// Exports assets with time and resource types to a given Cloud Storage
	// location/BigQuery table. For Cloud Storage location destinations, the
	// output format is newline-delimited JSON. Each line represents a
	// [google.cloud.asset.v1.Asset][google.cloud.asset.v1.Asset] in the JSON
	// format; for BigQuery table destinations, the output table stores the fields
	// in asset Protobuf as columns. This API implements the
	// [google.longrunning.Operation][google.longrunning.Operation] API, which
	// allows you to keep track of the export. We recommend intervals of at least
	// 2 seconds with exponential retry to poll the export operation result. For
	// regular-size resource parent, the export operation usually finishes within
	// 5 minutes.
	ExportAssets(ctx context.Context, in *ExportAssetsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists assets with time and resource types and returns paged results in
	// response.
	ListAssets(ctx context.Context, in *ListAssetsRequest, opts ...grpc.CallOption) (*ListAssetsResponse, error)
	// Batch gets the update history of assets that overlap a time window.
	// For IAM_POLICY content, this API outputs history when the asset and its
	// attached IAM POLICY both exist. This can create gaps in the output history.
	// Otherwise, this API outputs history with asset in both non-delete or
	// deleted status.
	// If a specified asset does not exist, this API returns an INVALID_ARGUMENT
	// error.
	BatchGetAssetsHistory(ctx context.Context, in *BatchGetAssetsHistoryRequest, opts ...grpc.CallOption) (*BatchGetAssetsHistoryResponse, error)
	// Creates a feed in a parent project/folder/organization to listen to its
	// asset updates.
	CreateFeed(ctx context.Context, in *CreateFeedRequest, opts ...grpc.CallOption) (*Feed, error)
	// Gets details about an asset feed.
	GetFeed(ctx context.Context, in *GetFeedRequest, opts ...grpc.CallOption) (*Feed, error)
	// Lists all asset feeds in a parent project/folder/organization.
	ListFeeds(ctx context.Context, in *ListFeedsRequest, opts ...grpc.CallOption) (*ListFeedsResponse, error)
	// Updates an asset feed configuration.
	UpdateFeed(ctx context.Context, in *UpdateFeedRequest, opts ...grpc.CallOption) (*Feed, error)
	// Deletes an asset feed.
	DeleteFeed(ctx context.Context, in *DeleteFeedRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Searches all Google Cloud resources within the specified scope, such as a
	// project, folder, or organization. The caller must be granted the
	// `cloudasset.assets.searchAllResources` permission on the desired scope,
	// otherwise the request will be rejected.
	SearchAllResources(ctx context.Context, in *SearchAllResourcesRequest, opts ...grpc.CallOption) (*SearchAllResourcesResponse, error)
	// Searches all IAM policies within the specified scope, such as a project,
	// folder, or organization. The caller must be granted the
	// `cloudasset.assets.searchAllIamPolicies` permission on the desired scope,
	// otherwise the request will be rejected.
	SearchAllIamPolicies(ctx context.Context, in *SearchAllIamPoliciesRequest, opts ...grpc.CallOption) (*SearchAllIamPoliciesResponse, error)
	// Analyzes IAM policies to answer which identities have what accesses on
	// which resources.
	AnalyzeIamPolicy(ctx context.Context, in *AnalyzeIamPolicyRequest, opts ...grpc.CallOption) (*AnalyzeIamPolicyResponse, error)
	// Analyzes IAM policies asynchronously to answer which identities have what
	// accesses on which resources, and writes the analysis results to a Google
	// Cloud Storage or a BigQuery destination. For Cloud Storage destination, the
	// output format is the JSON format that represents a
	// [AnalyzeIamPolicyResponse][google.cloud.asset.v1.AnalyzeIamPolicyResponse].
	// This method implements the
	// [google.longrunning.Operation][google.longrunning.Operation], which allows
	// you to track the operation status. We recommend intervals of at least 2
	// seconds with exponential backoff retry to poll the operation result. The
	// metadata contains the metadata for the long-running operation.
	AnalyzeIamPolicyLongrunning(ctx context.Context, in *AnalyzeIamPolicyLongrunningRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Analyze moving a resource to a specified destination without kicking off
	// the actual move. The analysis is best effort depending on the user's
	// permissions of viewing different hierarchical policies and configurations.
	// The policies and configuration are subject to change before the actual
	// resource migration takes place.
	AnalyzeMove(ctx context.Context, in *AnalyzeMoveRequest, opts ...grpc.CallOption) (*AnalyzeMoveResponse, error)
	// Issue a job that queries assets using a SQL statement compatible with
	// [BigQuery SQL](https://cloud.google.com/bigquery/docs/introduction-sql).
	//
	// If the query execution finishes within timeout and there's no pagination,
	// the full query results will be returned in the `QueryAssetsResponse`.
	//
	// Otherwise, full query results can be obtained by issuing extra requests
	// with the `job_reference` from the a previous `QueryAssets` call.
	//
	// Note, the query result has approximately 10 GB limitation enforced by
	// [BigQuery](https://cloud.google.com/bigquery/docs/best-practices-performance-output).
	// Queries return larger results will result in errors.
	QueryAssets(ctx context.Context, in *QueryAssetsRequest, opts ...grpc.CallOption) (*QueryAssetsResponse, error)
	// Creates a saved query in a parent project/folder/organization.
	CreateSavedQuery(ctx context.Context, in *CreateSavedQueryRequest, opts ...grpc.CallOption) (*SavedQuery, error)
	// Gets details about a saved query.
	GetSavedQuery(ctx context.Context, in *GetSavedQueryRequest, opts ...grpc.CallOption) (*SavedQuery, error)
	// Lists all saved queries in a parent project/folder/organization.
	ListSavedQueries(ctx context.Context, in *ListSavedQueriesRequest, opts ...grpc.CallOption) (*ListSavedQueriesResponse, error)
	// Updates a saved query.
	UpdateSavedQuery(ctx context.Context, in *UpdateSavedQueryRequest, opts ...grpc.CallOption) (*SavedQuery, error)
	// Deletes a saved query.
	DeleteSavedQuery(ctx context.Context, in *DeleteSavedQueryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets effective IAM policies for a batch of resources.
	BatchGetEffectiveIamPolicies(ctx context.Context, in *BatchGetEffectiveIamPoliciesRequest, opts ...grpc.CallOption) (*BatchGetEffectiveIamPoliciesResponse, error)
	// Analyzes organization policies under a scope.
	AnalyzeOrgPolicies(ctx context.Context, in *AnalyzeOrgPoliciesRequest, opts ...grpc.CallOption) (*AnalyzeOrgPoliciesResponse, error)
	// Analyzes organization policies governed containers (projects, folders or
	// organization) under a scope.
	AnalyzeOrgPolicyGovernedContainers(ctx context.Context, in *AnalyzeOrgPolicyGovernedContainersRequest, opts ...grpc.CallOption) (*AnalyzeOrgPolicyGovernedContainersResponse, error)
	// Analyzes organization policies governed assets (Google Cloud resources or
	// policies) under a scope. This RPC supports custom constraints and the
	// following canned constraints:
	//
	// * constraints/ainotebooks.accessMode
	// * constraints/ainotebooks.disableFileDownloads
	// * constraints/ainotebooks.disableRootAccess
	// * constraints/ainotebooks.disableTerminal
	// * constraints/ainotebooks.environmentOptions
	// * constraints/ainotebooks.requireAutoUpgradeSchedule
	// * constraints/ainotebooks.restrictVpcNetworks
	// * constraints/compute.disableGuestAttributesAccess
	// * constraints/compute.disableInstanceDataAccessApis
	// * constraints/compute.disableNestedVirtualization
	// * constraints/compute.disableSerialPortAccess
	// * constraints/compute.disableSerialPortLogging
	// * constraints/compute.disableVpcExternalIpv6
	// * constraints/compute.requireOsLogin
	// * constraints/compute.requireShieldedVm
	// * constraints/compute.restrictLoadBalancerCreationForTypes
	// * constraints/compute.restrictProtocolForwardingCreationForTypes
	// * constraints/compute.restrictXpnProjectLienRemoval
	// * constraints/compute.setNewProjectDefaultToZonalDNSOnly
	// * constraints/compute.skipDefaultNetworkCreation
	// * constraints/compute.trustedImageProjects
	// * constraints/compute.vmCanIpForward
	// * constraints/compute.vmExternalIpAccess
	// * constraints/gcp.detailedAuditLoggingMode
	// * constraints/gcp.resourceLocations
	// * constraints/iam.allowedPolicyMemberDomains
	// * constraints/iam.automaticIamGrantsForDefaultServiceAccounts
	// * constraints/iam.disableServiceAccountCreation
	// * constraints/iam.disableServiceAccountKeyCreation
	// * constraints/iam.disableServiceAccountKeyUpload
	// * constraints/iam.restrictCrossProjectServiceAccountLienRemoval
	// * constraints/iam.serviceAccountKeyExpiryHours
	// * constraints/resourcemanager.accessBoundaries
	// * constraints/resourcemanager.allowedExportDestinations
	// * constraints/sql.restrictAuthorizedNetworks
	// * constraints/sql.restrictNoncompliantDiagnosticDataAccess
	// * constraints/sql.restrictNoncompliantResourceCreation
	// * constraints/sql.restrictPublicIp
	// * constraints/storage.publicAccessPrevention
	// * constraints/storage.restrictAuthTypes
	// * constraints/storage.uniformBucketLevelAccess
	//
	// This RPC only returns either resources of types [supported by search
	// APIs](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
	// or IAM policies.
	AnalyzeOrgPolicyGovernedAssets(ctx context.Context, in *AnalyzeOrgPolicyGovernedAssetsRequest, opts ...grpc.CallOption) (*AnalyzeOrgPolicyGovernedAssetsResponse, error)
}

type assetServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAssetServiceClient(cc grpc.ClientConnInterface) AssetServiceClient {
	return &assetServiceClient{cc}
}

func (c *assetServiceClient) ExportAssets(ctx context.Context, in *ExportAssetsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AssetService_ExportAssets_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) ListAssets(ctx context.Context, in *ListAssetsRequest, opts ...grpc.CallOption) (*ListAssetsResponse, error) {
	out := new(ListAssetsResponse)
	err := c.cc.Invoke(ctx, AssetService_ListAssets_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) BatchGetAssetsHistory(ctx context.Context, in *BatchGetAssetsHistoryRequest, opts ...grpc.CallOption) (*BatchGetAssetsHistoryResponse, error) {
	out := new(BatchGetAssetsHistoryResponse)
	err := c.cc.Invoke(ctx, AssetService_BatchGetAssetsHistory_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) CreateFeed(ctx context.Context, in *CreateFeedRequest, opts ...grpc.CallOption) (*Feed, error) {
	out := new(Feed)
	err := c.cc.Invoke(ctx, AssetService_CreateFeed_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) GetFeed(ctx context.Context, in *GetFeedRequest, opts ...grpc.CallOption) (*Feed, error) {
	out := new(Feed)
	err := c.cc.Invoke(ctx, AssetService_GetFeed_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) ListFeeds(ctx context.Context, in *ListFeedsRequest, opts ...grpc.CallOption) (*ListFeedsResponse, error) {
	out := new(ListFeedsResponse)
	err := c.cc.Invoke(ctx, AssetService_ListFeeds_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) UpdateFeed(ctx context.Context, in *UpdateFeedRequest, opts ...grpc.CallOption) (*Feed, error) {
	out := new(Feed)
	err := c.cc.Invoke(ctx, AssetService_UpdateFeed_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) DeleteFeed(ctx context.Context, in *DeleteFeedRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AssetService_DeleteFeed_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) SearchAllResources(ctx context.Context, in *SearchAllResourcesRequest, opts ...grpc.CallOption) (*SearchAllResourcesResponse, error) {
	out := new(SearchAllResourcesResponse)
	err := c.cc.Invoke(ctx, AssetService_SearchAllResources_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) SearchAllIamPolicies(ctx context.Context, in *SearchAllIamPoliciesRequest, opts ...grpc.CallOption) (*SearchAllIamPoliciesResponse, error) {
	out := new(SearchAllIamPoliciesResponse)
	err := c.cc.Invoke(ctx, AssetService_SearchAllIamPolicies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) AnalyzeIamPolicy(ctx context.Context, in *AnalyzeIamPolicyRequest, opts ...grpc.CallOption) (*AnalyzeIamPolicyResponse, error) {
	out := new(AnalyzeIamPolicyResponse)
	err := c.cc.Invoke(ctx, AssetService_AnalyzeIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) AnalyzeIamPolicyLongrunning(ctx context.Context, in *AnalyzeIamPolicyLongrunningRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AssetService_AnalyzeIamPolicyLongrunning_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) AnalyzeMove(ctx context.Context, in *AnalyzeMoveRequest, opts ...grpc.CallOption) (*AnalyzeMoveResponse, error) {
	out := new(AnalyzeMoveResponse)
	err := c.cc.Invoke(ctx, AssetService_AnalyzeMove_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) QueryAssets(ctx context.Context, in *QueryAssetsRequest, opts ...grpc.CallOption) (*QueryAssetsResponse, error) {
	out := new(QueryAssetsResponse)
	err := c.cc.Invoke(ctx, AssetService_QueryAssets_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) CreateSavedQuery(ctx context.Context, in *CreateSavedQueryRequest, opts ...grpc.CallOption) (*SavedQuery, error) {
	out := new(SavedQuery)
	err := c.cc.Invoke(ctx, AssetService_CreateSavedQuery_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) GetSavedQuery(ctx context.Context, in *GetSavedQueryRequest, opts ...grpc.CallOption) (*SavedQuery, error) {
	out := new(SavedQuery)
	err := c.cc.Invoke(ctx, AssetService_GetSavedQuery_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) ListSavedQueries(ctx context.Context, in *ListSavedQueriesRequest, opts ...grpc.CallOption) (*ListSavedQueriesResponse, error) {
	out := new(ListSavedQueriesResponse)
	err := c.cc.Invoke(ctx, AssetService_ListSavedQueries_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) UpdateSavedQuery(ctx context.Context, in *UpdateSavedQueryRequest, opts ...grpc.CallOption) (*SavedQuery, error) {
	out := new(SavedQuery)
	err := c.cc.Invoke(ctx, AssetService_UpdateSavedQuery_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) DeleteSavedQuery(ctx context.Context, in *DeleteSavedQueryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AssetService_DeleteSavedQuery_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) BatchGetEffectiveIamPolicies(ctx context.Context, in *BatchGetEffectiveIamPoliciesRequest, opts ...grpc.CallOption) (*BatchGetEffectiveIamPoliciesResponse, error) {
	out := new(BatchGetEffectiveIamPoliciesResponse)
	err := c.cc.Invoke(ctx, AssetService_BatchGetEffectiveIamPolicies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) AnalyzeOrgPolicies(ctx context.Context, in *AnalyzeOrgPoliciesRequest, opts ...grpc.CallOption) (*AnalyzeOrgPoliciesResponse, error) {
	out := new(AnalyzeOrgPoliciesResponse)
	err := c.cc.Invoke(ctx, AssetService_AnalyzeOrgPolicies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) AnalyzeOrgPolicyGovernedContainers(ctx context.Context, in *AnalyzeOrgPolicyGovernedContainersRequest, opts ...grpc.CallOption) (*AnalyzeOrgPolicyGovernedContainersResponse, error) {
	out := new(AnalyzeOrgPolicyGovernedContainersResponse)
	err := c.cc.Invoke(ctx, AssetService_AnalyzeOrgPolicyGovernedContainers_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) AnalyzeOrgPolicyGovernedAssets(ctx context.Context, in *AnalyzeOrgPolicyGovernedAssetsRequest, opts ...grpc.CallOption) (*AnalyzeOrgPolicyGovernedAssetsResponse, error) {
	out := new(AnalyzeOrgPolicyGovernedAssetsResponse)
	err := c.cc.Invoke(ctx, AssetService_AnalyzeOrgPolicyGovernedAssets_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AssetServiceServer is the server API for AssetService service.
// All implementations should embed UnimplementedAssetServiceServer
// for forward compatibility
type AssetServiceServer interface {
	// Exports assets with time and resource types to a given Cloud Storage
	// location/BigQuery table. For Cloud Storage location destinations, the
	// output format is newline-delimited JSON. Each line represents a
	// [google.cloud.asset.v1.Asset][google.cloud.asset.v1.Asset] in the JSON
	// format; for BigQuery table destinations, the output table stores the fields
	// in asset Protobuf as columns. This API implements the
	// [google.longrunning.Operation][google.longrunning.Operation] API, which
	// allows you to keep track of the export. We recommend intervals of at least
	// 2 seconds with exponential retry to poll the export operation result. For
	// regular-size resource parent, the export operation usually finishes within
	// 5 minutes.
	ExportAssets(context.Context, *ExportAssetsRequest) (*longrunningpb.Operation, error)
	// Lists assets with time and resource types and returns paged results in
	// response.
	ListAssets(context.Context, *ListAssetsRequest) (*ListAssetsResponse, error)
	// Batch gets the update history of assets that overlap a time window.
	// For IAM_POLICY content, this API outputs history when the asset and its
	// attached IAM POLICY both exist. This can create gaps in the output history.
	// Otherwise, this API outputs history with asset in both non-delete or
	// deleted status.
	// If a specified asset does not exist, this API returns an INVALID_ARGUMENT
	// error.
	BatchGetAssetsHistory(context.Context, *BatchGetAssetsHistoryRequest) (*BatchGetAssetsHistoryResponse, error)
	// Creates a feed in a parent project/folder/organization to listen to its
	// asset updates.
	CreateFeed(context.Context, *CreateFeedRequest) (*Feed, error)
	// Gets details about an asset feed.
	GetFeed(context.Context, *GetFeedRequest) (*Feed, error)
	// Lists all asset feeds in a parent project/folder/organization.
	ListFeeds(context.Context, *ListFeedsRequest) (*ListFeedsResponse, error)
	// Updates an asset feed configuration.
	UpdateFeed(context.Context, *UpdateFeedRequest) (*Feed, error)
	// Deletes an asset feed.
	DeleteFeed(context.Context, *DeleteFeedRequest) (*emptypb.Empty, error)
	// Searches all Google Cloud resources within the specified scope, such as a
	// project, folder, or organization. The caller must be granted the
	// `cloudasset.assets.searchAllResources` permission on the desired scope,
	// otherwise the request will be rejected.
	SearchAllResources(context.Context, *SearchAllResourcesRequest) (*SearchAllResourcesResponse, error)
	// Searches all IAM policies within the specified scope, such as a project,
	// folder, or organization. The caller must be granted the
	// `cloudasset.assets.searchAllIamPolicies` permission on the desired scope,
	// otherwise the request will be rejected.
	SearchAllIamPolicies(context.Context, *SearchAllIamPoliciesRequest) (*SearchAllIamPoliciesResponse, error)
	// Analyzes IAM policies to answer which identities have what accesses on
	// which resources.
	AnalyzeIamPolicy(context.Context, *AnalyzeIamPolicyRequest) (*AnalyzeIamPolicyResponse, error)
	// Analyzes IAM policies asynchronously to answer which identities have what
	// accesses on which resources, and writes the analysis results to a Google
	// Cloud Storage or a BigQuery destination. For Cloud Storage destination, the
	// output format is the JSON format that represents a
	// [AnalyzeIamPolicyResponse][google.cloud.asset.v1.AnalyzeIamPolicyResponse].
	// This method implements the
	// [google.longrunning.Operation][google.longrunning.Operation], which allows
	// you to track the operation status. We recommend intervals of at least 2
	// seconds with exponential backoff retry to poll the operation result. The
	// metadata contains the metadata for the long-running operation.
	AnalyzeIamPolicyLongrunning(context.Context, *AnalyzeIamPolicyLongrunningRequest) (*longrunningpb.Operation, error)
	// Analyze moving a resource to a specified destination without kicking off
	// the actual move. The analysis is best effort depending on the user's
	// permissions of viewing different hierarchical policies and configurations.
	// The policies and configuration are subject to change before the actual
	// resource migration takes place.
	AnalyzeMove(context.Context, *AnalyzeMoveRequest) (*AnalyzeMoveResponse, error)
	// Issue a job that queries assets using a SQL statement compatible with
	// [BigQuery SQL](https://cloud.google.com/bigquery/docs/introduction-sql).
	//
	// If the query execution finishes within timeout and there's no pagination,
	// the full query results will be returned in the `QueryAssetsResponse`.
	//
	// Otherwise, full query results can be obtained by issuing extra requests
	// with the `job_reference` from the a previous `QueryAssets` call.
	//
	// Note, the query result has approximately 10 GB limitation enforced by
	// [BigQuery](https://cloud.google.com/bigquery/docs/best-practices-performance-output).
	// Queries return larger results will result in errors.
	QueryAssets(context.Context, *QueryAssetsRequest) (*QueryAssetsResponse, error)
	// Creates a saved query in a parent project/folder/organization.
	CreateSavedQuery(context.Context, *CreateSavedQueryRequest) (*SavedQuery, error)
	// Gets details about a saved query.
	GetSavedQuery(context.Context, *GetSavedQueryRequest) (*SavedQuery, error)
	// Lists all saved queries in a parent project/folder/organization.
	ListSavedQueries(context.Context, *ListSavedQueriesRequest) (*ListSavedQueriesResponse, error)
	// Updates a saved query.
	UpdateSavedQuery(context.Context, *UpdateSavedQueryRequest) (*SavedQuery, error)
	// Deletes a saved query.
	DeleteSavedQuery(context.Context, *DeleteSavedQueryRequest) (*emptypb.Empty, error)
	// Gets effective IAM policies for a batch of resources.
	BatchGetEffectiveIamPolicies(context.Context, *BatchGetEffectiveIamPoliciesRequest) (*BatchGetEffectiveIamPoliciesResponse, error)
	// Analyzes organization policies under a scope.
	AnalyzeOrgPolicies(context.Context, *AnalyzeOrgPoliciesRequest) (*AnalyzeOrgPoliciesResponse, error)
	// Analyzes organization policies governed containers (projects, folders or
	// organization) under a scope.
	AnalyzeOrgPolicyGovernedContainers(context.Context, *AnalyzeOrgPolicyGovernedContainersRequest) (*AnalyzeOrgPolicyGovernedContainersResponse, error)
	// Analyzes organization policies governed assets (Google Cloud resources or
	// policies) under a scope. This RPC supports custom constraints and the
	// following canned constraints:
	//
	// * constraints/ainotebooks.accessMode
	// * constraints/ainotebooks.disableFileDownloads
	// * constraints/ainotebooks.disableRootAccess
	// * constraints/ainotebooks.disableTerminal
	// * constraints/ainotebooks.environmentOptions
	// * constraints/ainotebooks.requireAutoUpgradeSchedule
	// * constraints/ainotebooks.restrictVpcNetworks
	// * constraints/compute.disableGuestAttributesAccess
	// * constraints/compute.disableInstanceDataAccessApis
	// * constraints/compute.disableNestedVirtualization
	// * constraints/compute.disableSerialPortAccess
	// * constraints/compute.disableSerialPortLogging
	// * constraints/compute.disableVpcExternalIpv6
	// * constraints/compute.requireOsLogin
	// * constraints/compute.requireShieldedVm
	// * constraints/compute.restrictLoadBalancerCreationForTypes
	// * constraints/compute.restrictProtocolForwardingCreationForTypes
	// * constraints/compute.restrictXpnProjectLienRemoval
	// * constraints/compute.setNewProjectDefaultToZonalDNSOnly
	// * constraints/compute.skipDefaultNetworkCreation
	// * constraints/compute.trustedImageProjects
	// * constraints/compute.vmCanIpForward
	// * constraints/compute.vmExternalIpAccess
	// * constraints/gcp.detailedAuditLoggingMode
	// * constraints/gcp.resourceLocations
	// * constraints/iam.allowedPolicyMemberDomains
	// * constraints/iam.automaticIamGrantsForDefaultServiceAccounts
	// * constraints/iam.disableServiceAccountCreation
	// * constraints/iam.disableServiceAccountKeyCreation
	// * constraints/iam.disableServiceAccountKeyUpload
	// * constraints/iam.restrictCrossProjectServiceAccountLienRemoval
	// * constraints/iam.serviceAccountKeyExpiryHours
	// * constraints/resourcemanager.accessBoundaries
	// * constraints/resourcemanager.allowedExportDestinations
	// * constraints/sql.restrictAuthorizedNetworks
	// * constraints/sql.restrictNoncompliantDiagnosticDataAccess
	// * constraints/sql.restrictNoncompliantResourceCreation
	// * constraints/sql.restrictPublicIp
	// * constraints/storage.publicAccessPrevention
	// * constraints/storage.restrictAuthTypes
	// * constraints/storage.uniformBucketLevelAccess
	//
	// This RPC only returns either resources of types [supported by search
	// APIs](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
	// or IAM policies.
	AnalyzeOrgPolicyGovernedAssets(context.Context, *AnalyzeOrgPolicyGovernedAssetsRequest) (*AnalyzeOrgPolicyGovernedAssetsResponse, error)
}

// UnimplementedAssetServiceServer should be embedded to have forward compatible implementations.
type UnimplementedAssetServiceServer struct {
}

func (UnimplementedAssetServiceServer) ExportAssets(context.Context, *ExportAssetsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportAssets not implemented")
}
func (UnimplementedAssetServiceServer) ListAssets(context.Context, *ListAssetsRequest) (*ListAssetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAssets not implemented")
}
func (UnimplementedAssetServiceServer) BatchGetAssetsHistory(context.Context, *BatchGetAssetsHistoryRequest) (*BatchGetAssetsHistoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchGetAssetsHistory not implemented")
}
func (UnimplementedAssetServiceServer) CreateFeed(context.Context, *CreateFeedRequest) (*Feed, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFeed not implemented")
}
func (UnimplementedAssetServiceServer) GetFeed(context.Context, *GetFeedRequest) (*Feed, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFeed not implemented")
}
func (UnimplementedAssetServiceServer) ListFeeds(context.Context, *ListFeedsRequest) (*ListFeedsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFeeds not implemented")
}
func (UnimplementedAssetServiceServer) UpdateFeed(context.Context, *UpdateFeedRequest) (*Feed, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFeed not implemented")
}
func (UnimplementedAssetServiceServer) DeleteFeed(context.Context, *DeleteFeedRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFeed not implemented")
}
func (UnimplementedAssetServiceServer) SearchAllResources(context.Context, *SearchAllResourcesRequest) (*SearchAllResourcesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchAllResources not implemented")
}
func (UnimplementedAssetServiceServer) SearchAllIamPolicies(context.Context, *SearchAllIamPoliciesRequest) (*SearchAllIamPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchAllIamPolicies not implemented")
}
func (UnimplementedAssetServiceServer) AnalyzeIamPolicy(context.Context, *AnalyzeIamPolicyRequest) (*AnalyzeIamPolicyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AnalyzeIamPolicy not implemented")
}
func (UnimplementedAssetServiceServer) AnalyzeIamPolicyLongrunning(context.Context, *AnalyzeIamPolicyLongrunningRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AnalyzeIamPolicyLongrunning not implemented")
}
func (UnimplementedAssetServiceServer) AnalyzeMove(context.Context, *AnalyzeMoveRequest) (*AnalyzeMoveResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AnalyzeMove not implemented")
}
func (UnimplementedAssetServiceServer) QueryAssets(context.Context, *QueryAssetsRequest) (*QueryAssetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryAssets not implemented")
}
func (UnimplementedAssetServiceServer) CreateSavedQuery(context.Context, *CreateSavedQueryRequest) (*SavedQuery, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSavedQuery not implemented")
}
func (UnimplementedAssetServiceServer) GetSavedQuery(context.Context, *GetSavedQueryRequest) (*SavedQuery, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSavedQuery not implemented")
}
func (UnimplementedAssetServiceServer) ListSavedQueries(context.Context, *ListSavedQueriesRequest) (*ListSavedQueriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSavedQueries not implemented")
}
func (UnimplementedAssetServiceServer) UpdateSavedQuery(context.Context, *UpdateSavedQueryRequest) (*SavedQuery, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSavedQuery not implemented")
}
func (UnimplementedAssetServiceServer) DeleteSavedQuery(context.Context, *DeleteSavedQueryRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSavedQuery not implemented")
}
func (UnimplementedAssetServiceServer) BatchGetEffectiveIamPolicies(context.Context, *BatchGetEffectiveIamPoliciesRequest) (*BatchGetEffectiveIamPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchGetEffectiveIamPolicies not implemented")
}
func (UnimplementedAssetServiceServer) AnalyzeOrgPolicies(context.Context, *AnalyzeOrgPoliciesRequest) (*AnalyzeOrgPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AnalyzeOrgPolicies not implemented")
}
func (UnimplementedAssetServiceServer) AnalyzeOrgPolicyGovernedContainers(context.Context, *AnalyzeOrgPolicyGovernedContainersRequest) (*AnalyzeOrgPolicyGovernedContainersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AnalyzeOrgPolicyGovernedContainers not implemented")
}
func (UnimplementedAssetServiceServer) AnalyzeOrgPolicyGovernedAssets(context.Context, *AnalyzeOrgPolicyGovernedAssetsRequest) (*AnalyzeOrgPolicyGovernedAssetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AnalyzeOrgPolicyGovernedAssets not implemented")
}

// UnsafeAssetServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AssetServiceServer will
// result in compilation errors.
type UnsafeAssetServiceServer interface {
	mustEmbedUnimplementedAssetServiceServer()
}

func RegisterAssetServiceServer(s grpc.ServiceRegistrar, srv AssetServiceServer) {
	s.RegisterService(&AssetService_ServiceDesc, srv)
}

func _AssetService_ExportAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).ExportAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssetService_ExportAssets_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).ExportAssets(ctx, req.(*ExportAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_ListAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).ListAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssetService_ListAssets_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).ListAssets(ctx, req.(*ListAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_BatchGetAssetsHistory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchGetAssetsHistoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).BatchGetAssetsHistory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssetService_BatchGetAssetsHistory_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).BatchGetAssetsHistory(ctx, req.(*BatchGetAssetsHistoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_CreateFeed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFeedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).CreateFeed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssetService_CreateFeed_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).CreateFeed(ctx, req.(*CreateFeedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_GetFeed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFeedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).GetFeed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssetService_GetFeed_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).GetFeed(ctx, req.(*GetFeedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_ListFeeds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFeedsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).ListFeeds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssetService_ListFeeds_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).ListFeeds(ctx, req.(*ListFeedsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_UpdateFeed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFeedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).UpdateFeed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssetService_UpdateFeed_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).UpdateFeed(ctx, req.(*UpdateFeedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_DeleteFeed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFeedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).DeleteFeed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssetService_DeleteFeed_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).DeleteFeed(ctx, req.(*DeleteFeedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_SearchAllResources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchAllResourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).SearchAllResources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssetService_SearchAllResources_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).SearchAllResources(ctx, req.(*SearchAllResourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_SearchAllIamPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchAllIamPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).SearchAllIamPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssetService_SearchAllIamPolicies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).SearchAllIamPolicies(ctx, req.(*SearchAllIamPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_AnalyzeIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).AnalyzeIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssetService_AnalyzeIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).AnalyzeIamPolicy(ctx, req.(*AnalyzeIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_AnalyzeIamPolicyLongrunning_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeIamPolicyLongrunningRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).AnalyzeIamPolicyLongrunning(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssetService_AnalyzeIamPolicyLongrunning_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).AnalyzeIamPolicyLongrunning(ctx, req.(*AnalyzeIamPolicyLongrunningRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_AnalyzeMove_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeMoveRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).AnalyzeMove(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssetService_AnalyzeMove_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).AnalyzeMove(ctx, req.(*AnalyzeMoveRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_QueryAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).QueryAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssetService_QueryAssets_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).QueryAssets(ctx, req.(*QueryAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_CreateSavedQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSavedQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).CreateSavedQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssetService_CreateSavedQuery_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).CreateSavedQuery(ctx, req.(*CreateSavedQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_GetSavedQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSavedQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).GetSavedQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssetService_GetSavedQuery_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).GetSavedQuery(ctx, req.(*GetSavedQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_ListSavedQueries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSavedQueriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).ListSavedQueries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssetService_ListSavedQueries_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).ListSavedQueries(ctx, req.(*ListSavedQueriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_UpdateSavedQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSavedQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).UpdateSavedQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssetService_UpdateSavedQuery_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).UpdateSavedQuery(ctx, req.(*UpdateSavedQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_DeleteSavedQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSavedQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).DeleteSavedQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssetService_DeleteSavedQuery_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).DeleteSavedQuery(ctx, req.(*DeleteSavedQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_BatchGetEffectiveIamPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchGetEffectiveIamPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).BatchGetEffectiveIamPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssetService_BatchGetEffectiveIamPolicies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).BatchGetEffectiveIamPolicies(ctx, req.(*BatchGetEffectiveIamPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_AnalyzeOrgPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeOrgPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).AnalyzeOrgPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssetService_AnalyzeOrgPolicies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).AnalyzeOrgPolicies(ctx, req.(*AnalyzeOrgPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_AnalyzeOrgPolicyGovernedContainers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeOrgPolicyGovernedContainersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).AnalyzeOrgPolicyGovernedContainers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssetService_AnalyzeOrgPolicyGovernedContainers_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).AnalyzeOrgPolicyGovernedContainers(ctx, req.(*AnalyzeOrgPolicyGovernedContainersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_AnalyzeOrgPolicyGovernedAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeOrgPolicyGovernedAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).AnalyzeOrgPolicyGovernedAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssetService_AnalyzeOrgPolicyGovernedAssets_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).AnalyzeOrgPolicyGovernedAssets(ctx, req.(*AnalyzeOrgPolicyGovernedAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// AssetService_ServiceDesc is the grpc.ServiceDesc for AssetService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var AssetService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.asset.v1.AssetService",
	HandlerType: (*AssetServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ExportAssets",
			Handler:    _AssetService_ExportAssets_Handler,
		},
		{
			MethodName: "ListAssets",
			Handler:    _AssetService_ListAssets_Handler,
		},
		{
			MethodName: "BatchGetAssetsHistory",
			Handler:    _AssetService_BatchGetAssetsHistory_Handler,
		},
		{
			MethodName: "CreateFeed",
			Handler:    _AssetService_CreateFeed_Handler,
		},
		{
			MethodName: "GetFeed",
			Handler:    _AssetService_GetFeed_Handler,
		},
		{
			MethodName: "ListFeeds",
			Handler:    _AssetService_ListFeeds_Handler,
		},
		{
			MethodName: "UpdateFeed",
			Handler:    _AssetService_UpdateFeed_Handler,
		},
		{
			MethodName: "DeleteFeed",
			Handler:    _AssetService_DeleteFeed_Handler,
		},
		{
			MethodName: "SearchAllResources",
			Handler:    _AssetService_SearchAllResources_Handler,
		},
		{
			MethodName: "SearchAllIamPolicies",
			Handler:    _AssetService_SearchAllIamPolicies_Handler,
		},
		{
			MethodName: "AnalyzeIamPolicy",
			Handler:    _AssetService_AnalyzeIamPolicy_Handler,
		},
		{
			MethodName: "AnalyzeIamPolicyLongrunning",
			Handler:    _AssetService_AnalyzeIamPolicyLongrunning_Handler,
		},
		{
			MethodName: "AnalyzeMove",
			Handler:    _AssetService_AnalyzeMove_Handler,
		},
		{
			MethodName: "QueryAssets",
			Handler:    _AssetService_QueryAssets_Handler,
		},
		{
			MethodName: "CreateSavedQuery",
			Handler:    _AssetService_CreateSavedQuery_Handler,
		},
		{
			MethodName: "GetSavedQuery",
			Handler:    _AssetService_GetSavedQuery_Handler,
		},
		{
			MethodName: "ListSavedQueries",
			Handler:    _AssetService_ListSavedQueries_Handler,
		},
		{
			MethodName: "UpdateSavedQuery",
			Handler:    _AssetService_UpdateSavedQuery_Handler,
		},
		{
			MethodName: "DeleteSavedQuery",
			Handler:    _AssetService_DeleteSavedQuery_Handler,
		},
		{
			MethodName: "BatchGetEffectiveIamPolicies",
			Handler:    _AssetService_BatchGetEffectiveIamPolicies_Handler,
		},
		{
			MethodName: "AnalyzeOrgPolicies",
			Handler:    _AssetService_AnalyzeOrgPolicies_Handler,
		},
		{
			MethodName: "AnalyzeOrgPolicyGovernedContainers",
			Handler:    _AssetService_AnalyzeOrgPolicyGovernedContainers_Handler,
		},
		{
			MethodName: "AnalyzeOrgPolicyGovernedAssets",
			Handler:    _AssetService_AnalyzeOrgPolicyGovernedAssets_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/asset/v1/asset_service.proto",
}
