// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: checks.proto

package synthetic_monitoring

import (
	context "context"
	encoding_binary "encoding/binary"
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// StatusCode represents the result of registering a probe with the API.
type StatusCode int32

const (
	StatusCode_OK               StatusCode = 0
	StatusCode_NOT_FOUND        StatusCode = 1
	StatusCode_INVALID_ARGUMENT StatusCode = 2
	StatusCode_ALREADY_EXISTS   StatusCode = 3
	StatusCode_INTERNAL_ERROR   StatusCode = 4
	StatusCode_NOT_AUTHORIZED   StatusCode = 5
)

var StatusCode_name = map[int32]string{
	0: "OK",
	1: "NOT_FOUND",
	2: "INVALID_ARGUMENT",
	3: "ALREADY_EXISTS",
	4: "INTERNAL_ERROR",
	5: "NOT_AUTHORIZED",
}

var StatusCode_value = map[string]int32{
	"OK":               0,
	"NOT_FOUND":        1,
	"INVALID_ARGUMENT": 2,
	"ALREADY_EXISTS":   3,
	"INTERNAL_ERROR":   4,
	"NOT_AUTHORIZED":   5,
}

func (x StatusCode) String() string {
	return proto.EnumName(StatusCode_name, int32(x))
}

func (StatusCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{0}
}

// TenantStatus represents the status associated to particular tenant.
type TenantStatus int32

const (
	TenantStatus_ACTIVE   TenantStatus = 0
	TenantStatus_DISABLED TenantStatus = 1
)

var TenantStatus_name = map[int32]string{
	0: "ACTIVE",
	1: "DISABLED",
}

var TenantStatus_value = map[string]int32{
	"ACTIVE":   0,
	"DISABLED": 1,
}

func (x TenantStatus) String() string {
	return proto.EnumName(TenantStatus_name, int32(x))
}

func (TenantStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{1}
}

// CheckOperation represents an operation to be performed on a
// particular check.
type CheckOperation int32

const (
	CheckOperation_CHECK_ADD    CheckOperation = 0
	CheckOperation_CHECK_UPDATE CheckOperation = 1
	CheckOperation_CHECK_DELETE CheckOperation = 2
)

var CheckOperation_name = map[int32]string{
	0: "CHECK_ADD",
	1: "CHECK_UPDATE",
	2: "CHECK_DELETE",
}

var CheckOperation_value = map[string]int32{
	"CHECK_ADD":    0,
	"CHECK_UPDATE": 1,
	"CHECK_DELETE": 2,
}

func (x CheckOperation) String() string {
	return proto.EnumName(CheckOperation_name, int32(x))
}

func (CheckOperation) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{2}
}

// HttpMethod represents the HTTP method used when making HTTP requests.
type HttpMethod int32

const (
	HttpMethod_GET     HttpMethod = 0
	HttpMethod_CONNECT HttpMethod = 1
	HttpMethod_DELETE  HttpMethod = 2
	HttpMethod_HEAD    HttpMethod = 3
	HttpMethod_OPTIONS HttpMethod = 4
	HttpMethod_POST    HttpMethod = 5
	HttpMethod_PUT     HttpMethod = 6
	HttpMethod_TRACE   HttpMethod = 7
)

var HttpMethod_name = map[int32]string{
	0: "GET",
	1: "CONNECT",
	2: "DELETE",
	3: "HEAD",
	4: "OPTIONS",
	5: "POST",
	6: "PUT",
	7: "TRACE",
}

var HttpMethod_value = map[string]int32{
	"GET":     0,
	"CONNECT": 1,
	"DELETE":  2,
	"HEAD":    3,
	"OPTIONS": 4,
	"POST":    5,
	"PUT":     6,
	"TRACE":   7,
}

func (x HttpMethod) String() string {
	return proto.EnumName(HttpMethod_name, int32(x))
}

func (HttpMethod) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{3}
}

// DnsRecordType represents the DNS record types to be queried in DNS
// checks.
type DnsRecordType int32

const (
	DnsRecordType_ANY   DnsRecordType = 0
	DnsRecordType_A     DnsRecordType = 1
	DnsRecordType_AAAA  DnsRecordType = 2
	DnsRecordType_CNAME DnsRecordType = 3
	DnsRecordType_MX    DnsRecordType = 4
	DnsRecordType_NS    DnsRecordType = 5
	DnsRecordType_PTR   DnsRecordType = 6
	DnsRecordType_SOA   DnsRecordType = 7
	DnsRecordType_SRV   DnsRecordType = 8
	DnsRecordType_TXT   DnsRecordType = 9
)

var DnsRecordType_name = map[int32]string{
	0: "ANY",
	1: "A",
	2: "AAAA",
	3: "CNAME",
	4: "MX",
	5: "NS",
	6: "PTR",
	7: "SOA",
	8: "SRV",
	9: "TXT",
}

var DnsRecordType_value = map[string]int32{
	"ANY":   0,
	"A":     1,
	"AAAA":  2,
	"CNAME": 3,
	"MX":    4,
	"NS":    5,
	"PTR":   6,
	"SOA":   7,
	"SRV":   8,
	"TXT":   9,
}

func (x DnsRecordType) String() string {
	return proto.EnumName(DnsRecordType_name, int32(x))
}

func (DnsRecordType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{4}
}

// DnsProtocol represents the IP protocol to use for DNS queries.
type DnsProtocol int32

const (
	DnsProtocol_TCP DnsProtocol = 0
	DnsProtocol_UDP DnsProtocol = 1
)

var DnsProtocol_name = map[int32]string{
	0: "TCP",
	1: "UDP",
}

var DnsProtocol_value = map[string]int32{
	"TCP": 0,
	"UDP": 1,
}

func (x DnsProtocol) String() string {
	return proto.EnumName(DnsProtocol_name, int32(x))
}

func (DnsProtocol) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{5}
}

// IpVersion represents the version of the IP protocol to be used in
// checks.
type IpVersion int32

const (
	IpVersion_Any IpVersion = 0
	IpVersion_V4  IpVersion = 1
	IpVersion_V6  IpVersion = 2
)

var IpVersion_name = map[int32]string{
	0: "Any",
	1: "V4",
	2: "V6",
}

var IpVersion_value = map[string]int32{
	"Any": 0,
	"V4":  1,
	"V6":  2,
}

func (x IpVersion) String() string {
	return proto.EnumName(IpVersion_name, int32(x))
}

func (IpVersion) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{6}
}

// CompressionAlgorithm represents the compression algorithm to use.
type CompressionAlgorithm int32

const (
	CompressionAlgorithm_none     CompressionAlgorithm = 0
	CompressionAlgorithm_identity CompressionAlgorithm = 1
	CompressionAlgorithm_gzip     CompressionAlgorithm = 2
	CompressionAlgorithm_br       CompressionAlgorithm = 3
	CompressionAlgorithm_deflate  CompressionAlgorithm = 4
)

var CompressionAlgorithm_name = map[int32]string{
	0: "none",
	1: "identity",
	2: "gzip",
	3: "br",
	4: "deflate",
}

var CompressionAlgorithm_value = map[string]int32{
	"none":     0,
	"identity": 1,
	"gzip":     2,
	"br":       3,
	"deflate":  4,
}

func (x CompressionAlgorithm) String() string {
	return proto.EnumName(CompressionAlgorithm_name, int32(x))
}

func (CompressionAlgorithm) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{7}
}

// MultiHttpEntryAssertionType represents the type of assertion to be made.
type MultiHttpEntryAssertionType int32

const (
	MultiHttpEntryAssertionType_TEXT                MultiHttpEntryAssertionType = 0
	MultiHttpEntryAssertionType_JSON_PATH_VALUE     MultiHttpEntryAssertionType = 1
	MultiHttpEntryAssertionType_JSON_PATH_ASSERTION MultiHttpEntryAssertionType = 2
	MultiHttpEntryAssertionType_REGEX_ASSERTION     MultiHttpEntryAssertionType = 3
)

var MultiHttpEntryAssertionType_name = map[int32]string{
	0: "TEXT",
	1: "JSON_PATH_VALUE",
	2: "JSON_PATH_ASSERTION",
	3: "REGEX_ASSERTION",
}

var MultiHttpEntryAssertionType_value = map[string]int32{
	"TEXT":                0,
	"JSON_PATH_VALUE":     1,
	"JSON_PATH_ASSERTION": 2,
	"REGEX_ASSERTION":     3,
}

func (MultiHttpEntryAssertionType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{8}
}

// MultiHttpEntryAssertionSubjectVariant represents the subject of the assertion.
type MultiHttpEntryAssertionSubjectVariant int32

const (
	MultiHttpEntryAssertionSubjectVariant_DEFAULT_SUBJECT  MultiHttpEntryAssertionSubjectVariant = 0
	MultiHttpEntryAssertionSubjectVariant_RESPONSE_HEADERS MultiHttpEntryAssertionSubjectVariant = 1
	MultiHttpEntryAssertionSubjectVariant_HTTP_STATUS_CODE MultiHttpEntryAssertionSubjectVariant = 2
	MultiHttpEntryAssertionSubjectVariant_RESPONSE_BODY    MultiHttpEntryAssertionSubjectVariant = 3
)

var MultiHttpEntryAssertionSubjectVariant_name = map[int32]string{
	0: "DEFAULT_SUBJECT",
	1: "RESPONSE_HEADERS",
	2: "HTTP_STATUS_CODE",
	3: "RESPONSE_BODY",
}

var MultiHttpEntryAssertionSubjectVariant_value = map[string]int32{
	"DEFAULT_SUBJECT":  0,
	"RESPONSE_HEADERS": 1,
	"HTTP_STATUS_CODE": 2,
	"RESPONSE_BODY":    3,
}

func (MultiHttpEntryAssertionSubjectVariant) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{9}
}

// MultiHttpEntryAssertionConditionVariant represents the condition between the assertion's expression and value.
type MultiHttpEntryAssertionConditionVariant int32

const (
	MultiHttpEntryAssertionConditionVariant_DEFAULT_CONDITION MultiHttpEntryAssertionConditionVariant = 0
	MultiHttpEntryAssertionConditionVariant_NOT_CONTAINS      MultiHttpEntryAssertionConditionVariant = 1
	MultiHttpEntryAssertionConditionVariant_EQUALS            MultiHttpEntryAssertionConditionVariant = 2
	MultiHttpEntryAssertionConditionVariant_STARTS_WITH       MultiHttpEntryAssertionConditionVariant = 3
	MultiHttpEntryAssertionConditionVariant_ENDS_WITH         MultiHttpEntryAssertionConditionVariant = 4
	MultiHttpEntryAssertionConditionVariant_TYPE_OF           MultiHttpEntryAssertionConditionVariant = 5
	MultiHttpEntryAssertionConditionVariant_CONTAINS          MultiHttpEntryAssertionConditionVariant = 6
)

var MultiHttpEntryAssertionConditionVariant_name = map[int32]string{
	0: "DEFAULT_CONDITION",
	1: "NOT_CONTAINS",
	2: "EQUALS",
	3: "STARTS_WITH",
	4: "ENDS_WITH",
	5: "TYPE_OF",
	6: "CONTAINS",
}

var MultiHttpEntryAssertionConditionVariant_value = map[string]int32{
	"DEFAULT_CONDITION": 0,
	"NOT_CONTAINS":      1,
	"EQUALS":            2,
	"STARTS_WITH":       3,
	"ENDS_WITH":         4,
	"TYPE_OF":           5,
	"CONTAINS":          6,
}

func (MultiHttpEntryAssertionConditionVariant) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{10}
}

// MultiHttpEntryVariableType represents the type of expression used to populate the variable.
type MultiHttpEntryVariableType int32

const (
	MultiHttpEntryVariableType_JSON_PATH    MultiHttpEntryVariableType = 0
	MultiHttpEntryVariableType_REGEX        MultiHttpEntryVariableType = 1
	MultiHttpEntryVariableType_CSS_SELECTOR MultiHttpEntryVariableType = 2
)

var MultiHttpEntryVariableType_name = map[int32]string{
	0: "JSON_PATH",
	1: "REGEX",
	2: "CSS_SELECTOR",
}

var MultiHttpEntryVariableType_value = map[string]int32{
	"JSON_PATH":    0,
	"REGEX":        1,
	"CSS_SELECTOR": 2,
}

func (MultiHttpEntryVariableType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{11}
}

// CheckClass represents the supported check classes.
type CheckClass int32

const (
	CheckClass_PROTOCOL CheckClass = 0
	CheckClass_SCRIPTED CheckClass = 1
)

var CheckClass_name = map[int32]string{
	0: "PROTOCOL",
	1: "SCRIPTED",
}

var CheckClass_value = map[string]int32{
	"PROTOCOL": 0,
	"SCRIPTED": 1,
}

func (x CheckClass) String() string {
	return proto.EnumName(CheckClass_name, int32(x))
}

func (CheckClass) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{12}
}

// Void is an empty message used by RPC methods that don't take
// arguments.
type Void struct {
}

func (m *Void) Reset()         { *m = Void{} }
func (m *Void) String() string { return proto.CompactTextString(m) }
func (*Void) ProtoMessage()    {}
func (*Void) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{0}
}
func (m *Void) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Void) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Void.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Void) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Void.Merge(m, src)
}
func (m *Void) XXX_Size() int {
	return m.Size()
}
func (m *Void) XXX_DiscardUnknown() {
	xxx_messageInfo_Void.DiscardUnknown(m)
}

var xxx_messageInfo_Void proto.InternalMessageInfo

// ProbeState message is sent by probes as the argument to GetChanges. It contains a list
// of the checks and tenants already known to the probe.
type ProbeState struct {
	Checks  []EntityRef `protobuf:"bytes,1,rep,name=checks,proto3" json:"checks"`
	Tenants []EntityRef `protobuf:"bytes,2,rep,name=tenants,proto3" json:"tenants"`
}

func (m *ProbeState) Reset()         { *m = ProbeState{} }
func (m *ProbeState) String() string { return proto.CompactTextString(m) }
func (*ProbeState) ProtoMessage()    {}
func (*ProbeState) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{1}
}
func (m *ProbeState) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProbeState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProbeState.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProbeState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProbeState.Merge(m, src)
}
func (m *ProbeState) XXX_Size() int {
	return m.Size()
}
func (m *ProbeState) XXX_DiscardUnknown() {
	xxx_messageInfo_ProbeState.DiscardUnknown(m)
}

var xxx_messageInfo_ProbeState proto.InternalMessageInfo

// EntityRef represents a reference to an entity (check, tenant) by it's ID and last modification time.
type EntityRef struct {
	Id           int64   `protobuf:"varint,1,opt,name=id,proto3" json:"id"`
	LastModified float64 `protobuf:"fixed64,2,opt,name=lastModified,proto3" json:"lastModified"`
}

func (m *EntityRef) Reset()         { *m = EntityRef{} }
func (m *EntityRef) String() string { return proto.CompactTextString(m) }
func (*EntityRef) ProtoMessage()    {}
func (*EntityRef) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{2}
}
func (m *EntityRef) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EntityRef) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EntityRef.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EntityRef) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EntityRef.Merge(m, src)
}
func (m *EntityRef) XXX_Size() int {
	return m.Size()
}
func (m *EntityRef) XXX_DiscardUnknown() {
	xxx_messageInfo_EntityRef.DiscardUnknown(m)
}

var xxx_messageInfo_EntityRef proto.InternalMessageInfo

type ProbeInfo struct {
	Version    string `protobuf:"bytes,1,opt,name=Version,proto3" json:"version"`
	Commit     string `protobuf:"bytes,2,opt,name=Commit,proto3" json:"commit"`
	Buildstamp string `protobuf:"bytes,3,opt,name=Buildstamp,proto3" json:"buildstamp"`
}

func (m *ProbeInfo) Reset()         { *m = ProbeInfo{} }
func (m *ProbeInfo) String() string { return proto.CompactTextString(m) }
func (*ProbeInfo) ProtoMessage()    {}
func (*ProbeInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{3}
}
func (m *ProbeInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProbeInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProbeInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProbeInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProbeInfo.Merge(m, src)
}
func (m *ProbeInfo) XXX_Size() int {
	return m.Size()
}
func (m *ProbeInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ProbeInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ProbeInfo proto.InternalMessageInfo

// PingRequest is the message sent as argument of the Ping method.
type PingRequest struct {
	Sequence int64 `protobuf:"varint,1,opt,name=Sequence,proto3" json:"sequence"`
}

func (m *PingRequest) Reset()         { *m = PingRequest{} }
func (m *PingRequest) String() string { return proto.CompactTextString(m) }
func (*PingRequest) ProtoMessage()    {}
func (*PingRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{4}
}
func (m *PingRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PingRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PingRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PingRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PingRequest.Merge(m, src)
}
func (m *PingRequest) XXX_Size() int {
	return m.Size()
}
func (m *PingRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PingRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PingRequest proto.InternalMessageInfo

// PongResponse is the message received as response from the Ping method.
type PongResponse struct {
	Sequence int64 `protobuf:"varint,1,opt,name=Sequence,proto3" json:"sequence"`
}

func (m *PongResponse) Reset()         { *m = PongResponse{} }
func (m *PongResponse) String() string { return proto.CompactTextString(m) }
func (*PongResponse) ProtoMessage()    {}
func (*PongResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{5}
}
func (m *PongResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PongResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PongResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PongResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PongResponse.Merge(m, src)
}
func (m *PongResponse) XXX_Size() int {
	return m.Size()
}
func (m *PongResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PongResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PongResponse proto.InternalMessageInfo

// Status represents the result of registering a probe with the API,
// including both a code as well as textual message that can be
// presented to the user.
type Status struct {
	Code    StatusCode `protobuf:"varint,1,opt,name=code,proto3,enum=synthetic_monitoring.StatusCode" json:"code,omitempty"`
	Message string     `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *Status) Reset()         { *m = Status{} }
func (m *Status) String() string { return proto.CompactTextString(m) }
func (*Status) ProtoMessage()    {}
func (*Status) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{6}
}
func (m *Status) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Status) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Status.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Status) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Status.Merge(m, src)
}
func (m *Status) XXX_Size() int {
	return m.Size()
}
func (m *Status) XXX_DiscardUnknown() {
	xxx_messageInfo_Status.DiscardUnknown(m)
}

var xxx_messageInfo_Status proto.InternalMessageInfo

// RegisterProbeResult is the message returned by the RegisterProbe
// method of the Checks service. It provides both the status of the
// operation and the probe's details after successful registration.
type RegisterProbeResult struct {
	Probe  Probe  `protobuf:"bytes,1,opt,name=probe,proto3" json:"probe"`
	Status Status `protobuf:"bytes,2,opt,name=status,proto3" json:"status"`
}

func (m *RegisterProbeResult) Reset()         { *m = RegisterProbeResult{} }
func (m *RegisterProbeResult) String() string { return proto.CompactTextString(m) }
func (*RegisterProbeResult) ProtoMessage()    {}
func (*RegisterProbeResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{7}
}
func (m *RegisterProbeResult) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RegisterProbeResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RegisterProbeResult.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RegisterProbeResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RegisterProbeResult.Merge(m, src)
}
func (m *RegisterProbeResult) XXX_Size() int {
	return m.Size()
}
func (m *RegisterProbeResult) XXX_DiscardUnknown() {
	xxx_messageInfo_RegisterProbeResult.DiscardUnknown(m)
}

var xxx_messageInfo_RegisterProbeResult proto.InternalMessageInfo

// Probe represents a probe.
type Probe struct {
	Id           int64   `protobuf:"varint,1,opt,name=id,proto3" json:"id"`
	TenantId     int64   `protobuf:"varint,2,opt,name=tenantId,proto3" json:"tenantId"`
	Name         string  `protobuf:"bytes,3,opt,name=name,proto3" json:"name"`
	Latitude     float32 `protobuf:"fixed32,4,opt,name=latitude,proto3" json:"latitude"`
	Longitude    float32 `protobuf:"fixed32,5,opt,name=longitude,proto3" json:"longitude"`
	Labels       []Label `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels"`
	Region       string  `protobuf:"bytes,7,opt,name=region,proto3" json:"region"`
	Public       bool    `protobuf:"varint,8,opt,name=public,proto3" json:"public"`
	Online       bool    `protobuf:"varint,9,opt,name=online,proto3" json:"online"`
	OnlineChange float64 `protobuf:"fixed64,10,opt,name=onlineChange,proto3" json:"onlineChange"`
	Version      string  `protobuf:"bytes,11,opt,name=version,proto3" json:"version"`
	Commit       string  `protobuf:"bytes,12,opt,name=commit,proto3" json:"commit"`
	Buildstamp   string  `protobuf:"bytes,13,opt,name=buildstamp,proto3" json:"buildstamp"`
	Deprecated   bool    `protobuf:"varint,14,opt,name=deprecated,proto3" json:"deprecated"`
	Created      float64 `protobuf:"fixed64,100,opt,name=created,proto3" json:"created"`
	Modified     float64 `protobuf:"fixed64,101,opt,name=modified,proto3" json:"modified"`
}

func (m *Probe) Reset()         { *m = Probe{} }
func (m *Probe) String() string { return proto.CompactTextString(m) }
func (*Probe) ProtoMessage()    {}
func (*Probe) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{8}
}
func (m *Probe) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Probe) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Probe.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Probe) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Probe.Merge(m, src)
}
func (m *Probe) XXX_Size() int {
	return m.Size()
}
func (m *Probe) XXX_DiscardUnknown() {
	xxx_messageInfo_Probe.DiscardUnknown(m)
}

var xxx_messageInfo_Probe proto.InternalMessageInfo

// TenantInfo identifies the tenant for which information is being
// requeted via the GetTenant method of the Tenants service.
type TenantInfo struct {
	Id int64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (m *TenantInfo) Reset()         { *m = TenantInfo{} }
func (m *TenantInfo) String() string { return proto.CompactTextString(m) }
func (*TenantInfo) ProtoMessage()    {}
func (*TenantInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{9}
}
func (m *TenantInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TenantInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TenantInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TenantInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TenantInfo.Merge(m, src)
}
func (m *TenantInfo) XXX_Size() int {
	return m.Size()
}
func (m *TenantInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_TenantInfo.DiscardUnknown(m)
}

var xxx_messageInfo_TenantInfo proto.InternalMessageInfo

// TenantLimits specifies the limits for a tenant.
type TenantLimits struct {
	MaxChecks         int64 `protobuf:"varint,1,opt,name=maxChecks,proto3" json:"maxChecks"`
	MaxScriptedChecks int64 `protobuf:"varint,2,opt,name=maxScriptedChecks,proto3" json:"maxScriptedChecks"`
	MaxMetricLabels   int64 `protobuf:"varint,3,opt,name=maxMetricLabels,proto3" json:"maxMetricLabels"`
	MaxLogLabels      int64 `protobuf:"varint,4,opt,name=maxLogLabels,proto3" json:"maxLogLabels"`
}

func (m *TenantLimits) Reset()         { *m = TenantLimits{} }
func (m *TenantLimits) String() string { return proto.CompactTextString(m) }
func (*TenantLimits) ProtoMessage()    {}
func (*TenantLimits) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{10}
}
func (m *TenantLimits) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TenantLimits) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TenantLimits.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TenantLimits) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TenantLimits.Merge(m, src)
}
func (m *TenantLimits) XXX_Size() int {
	return m.Size()
}
func (m *TenantLimits) XXX_DiscardUnknown() {
	xxx_messageInfo_TenantLimits.DiscardUnknown(m)
}

var xxx_messageInfo_TenantLimits proto.InternalMessageInfo

// Tenant represents a user of synthetic-monitoring.
type Tenant struct {
	Id            int64         `protobuf:"varint,1,opt,name=id,proto3" json:"id"`
	OrgId         int64         `protobuf:"varint,2,opt,name=orgId,proto3" json:"orgId"`
	MetricsRemote *RemoteInfo   `protobuf:"bytes,3,opt,name=metricsRemote,proto3" json:"metricsRemote"`
	EventsRemote  *RemoteInfo   `protobuf:"bytes,4,opt,name=eventsRemote,proto3" json:"eventsRemote"`
	StackId       int64         `protobuf:"varint,5,opt,name=stackId,proto3" json:"stackId"`
	Status        TenantStatus  `protobuf:"varint,6,opt,name=status,proto3,enum=synthetic_monitoring.TenantStatus" json:"status"`
	Reason        string        `protobuf:"bytes,7,opt,name=reason,proto3" json:"reason"`
	Limits        *TenantLimits `protobuf:"bytes,8,opt,name=limits,proto3" json:"limits"`
	Created       float64       `protobuf:"fixed64,100,opt,name=created,proto3" json:"created"`
	Modified      float64       `protobuf:"fixed64,101,opt,name=modified,proto3" json:"modified"`
}

func (m *Tenant) Reset()         { *m = Tenant{} }
func (m *Tenant) String() string { return proto.CompactTextString(m) }
func (*Tenant) ProtoMessage()    {}
func (*Tenant) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{11}
}
func (m *Tenant) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Tenant) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Tenant.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Tenant) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tenant.Merge(m, src)
}
func (m *Tenant) XXX_Size() int {
	return m.Size()
}
func (m *Tenant) XXX_DiscardUnknown() {
	xxx_messageInfo_Tenant.DiscardUnknown(m)
}

var xxx_messageInfo_Tenant proto.InternalMessageInfo

// RemoteInfo represents an instance of the Prometheus remote write
// service to send metrics or events to.
type RemoteInfo struct {
	Name     string `protobuf:"bytes,1,opt,name=name,proto3" json:"name"`
	Url      string `protobuf:"bytes,2,opt,name=url,proto3" json:"url"`
	Username string `protobuf:"bytes,3,opt,name=username,proto3" json:"username"`
	Password string `protobuf:"bytes,4,opt,name=password,proto3" json:"password"`
}

func (m *RemoteInfo) Reset()         { *m = RemoteInfo{} }
func (m *RemoteInfo) String() string { return proto.CompactTextString(m) }
func (*RemoteInfo) ProtoMessage()    {}
func (*RemoteInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{12}
}
func (m *RemoteInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RemoteInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RemoteInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RemoteInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoteInfo.Merge(m, src)
}
func (m *RemoteInfo) XXX_Size() int {
	return m.Size()
}
func (m *RemoteInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoteInfo.DiscardUnknown(m)
}

var xxx_messageInfo_RemoteInfo proto.InternalMessageInfo

// CheckChange represents one change operation for a given check.
type CheckChange struct {
	Operation CheckOperation `protobuf:"varint,1,opt,name=operation,proto3,enum=synthetic_monitoring.CheckOperation" json:"operation,omitempty"`
	Check     Check          `protobuf:"bytes,2,opt,name=check,proto3" json:"check"`
}

func (m *CheckChange) Reset()         { *m = CheckChange{} }
func (m *CheckChange) String() string { return proto.CompactTextString(m) }
func (*CheckChange) ProtoMessage()    {}
func (*CheckChange) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{13}
}
func (m *CheckChange) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckChange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CheckChange.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CheckChange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckChange.Merge(m, src)
}
func (m *CheckChange) XXX_Size() int {
	return m.Size()
}
func (m *CheckChange) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckChange.DiscardUnknown(m)
}

var xxx_messageInfo_CheckChange proto.InternalMessageInfo

// Changes represents a series of changes to be applied to the workloads
// running on the probe.
//
// When a probe connects, it will get a sequence of changes describing
// all the checks associated to that probe. After the initial batch, it
// will continue getting changes as they happen.
//
// When a tenant's credentials change, this message will contain the new
// information for that tenant.
type Changes struct {
	Checks  []CheckChange `protobuf:"bytes,1,rep,name=checks,proto3" json:"checks"`
	Tenants []Tenant      `protobuf:"bytes,2,rep,name=tenants,proto3" json:"tenants"`
	// This field is used to signal that the list of changes should be interpreted as a diff
	// against the existing changes in the probe. For backwards compatibility, this will be
	// false if the probe didn't send a list of known changes.
	IsDeltaFirstBatch bool `protobuf:"varint,3,opt,name=isDeltaFirstBatch,proto3" json:"isDeltaFirstBatch"`
}

func (m *Changes) Reset()         { *m = Changes{} }
func (m *Changes) String() string { return proto.CompactTextString(m) }
func (*Changes) ProtoMessage()    {}
func (*Changes) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{14}
}
func (m *Changes) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Changes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Changes.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Changes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Changes.Merge(m, src)
}
func (m *Changes) XXX_Size() int {
	return m.Size()
}
func (m *Changes) XXX_DiscardUnknown() {
	xxx_messageInfo_Changes.DiscardUnknown(m)
}

var xxx_messageInfo_Changes proto.InternalMessageInfo

type AdHocRequest struct {
	AdHocCheck AdHocCheck `protobuf:"bytes,1,opt,name=adHocCheck,proto3" json:"adHocCheck"`
	Tenant     *Tenant    `protobuf:"bytes,2,opt,name=tenant,proto3" json:"tenant"`
}

func (m *AdHocRequest) Reset()         { *m = AdHocRequest{} }
func (m *AdHocRequest) String() string { return proto.CompactTextString(m) }
func (*AdHocRequest) ProtoMessage()    {}
func (*AdHocRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{15}
}
func (m *AdHocRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AdHocRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AdHocRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AdHocRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdHocRequest.Merge(m, src)
}
func (m *AdHocRequest) XXX_Size() int {
	return m.Size()
}
func (m *AdHocRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AdHocRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AdHocRequest proto.InternalMessageInfo

// Label represents a single label in synthetic monitoring. These are
// applied to the resulting metrics and logs.
type Label struct {
	Name  string `protobuf:"bytes,1,opt,name=name,proto3" json:"name"`
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value"`
}

func (m *Label) Reset()         { *m = Label{} }
func (m *Label) String() string { return proto.CompactTextString(m) }
func (*Label) ProtoMessage()    {}
func (*Label) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{16}
}
func (m *Label) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Label) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Label.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Label) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Label.Merge(m, src)
}
func (m *Label) XXX_Size() int {
	return m.Size()
}
func (m *Label) XXX_DiscardUnknown() {
	xxx_messageInfo_Label.DiscardUnknown(m)
}

var xxx_messageInfo_Label proto.InternalMessageInfo

// Check represents a check.
//
// The "settings" field defines the type of check.
type Check struct {
	Id               int64         `protobuf:"varint,1,opt,name=id,proto3" json:"id"`
	TenantId         int64         `protobuf:"varint,2,opt,name=tenantId,proto3" json:"tenantId"`
	Frequency        int64         `protobuf:"varint,3,opt,name=frequency,proto3" json:"frequency"`
	Offset           int64         `protobuf:"varint,4,opt,name=offset,proto3" json:"offset"`
	Timeout          int64         `protobuf:"varint,5,opt,name=timeout,proto3" json:"timeout"`
	Enabled          bool          `protobuf:"varint,6,opt,name=enabled,proto3" json:"enabled"`
	Labels           []Label       `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels"`
	Settings         CheckSettings `protobuf:"bytes,8,opt,name=settings,proto3" json:"settings"`
	Probes           []int64       `protobuf:"varint,9,rep,packed,name=probes,proto3" json:"probes"`
	Target           string        `protobuf:"bytes,10,opt,name=target,proto3" json:"target"`
	Job              string        `protobuf:"bytes,11,opt,name=job,proto3" json:"job"`
	BasicMetricsOnly bool          `protobuf:"varint,12,opt,name=basicMetricsOnly,proto3" json:"basicMetricsOnly"`
	AlertSensitivity string        `protobuf:"bytes,13,opt,name=alertSensitivity,proto3" json:"alertSensitivity"`
	Created          float64       `protobuf:"fixed64,100,opt,name=created,proto3" json:"created"`
	Modified         float64       `protobuf:"fixed64,101,opt,name=modified,proto3" json:"modified"`
}

func (m *Check) Reset()         { *m = Check{} }
func (m *Check) String() string { return proto.CompactTextString(m) }
func (*Check) ProtoMessage()    {}
func (*Check) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{17}
}
func (m *Check) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Check) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Check.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Check) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Check.Merge(m, src)
}
func (m *Check) XXX_Size() int {
	return m.Size()
}
func (m *Check) XXX_DiscardUnknown() {
	xxx_messageInfo_Check.DiscardUnknown(m)
}

var xxx_messageInfo_Check proto.InternalMessageInfo

type AdHocCheck struct {
	Id       string        `protobuf:"bytes,1,opt,name=id,proto3" json:"id"`
	TenantId int64         `protobuf:"varint,2,opt,name=tenantId,proto3" json:"tenantId"`
	Timeout  int64         `protobuf:"varint,3,opt,name=timeout,proto3" json:"timeout"`
	Settings CheckSettings `protobuf:"bytes,4,opt,name=settings,proto3" json:"settings"`
	Probes   []int64       `protobuf:"varint,5,rep,packed,name=probes,proto3" json:"probes"`
	Target   string        `protobuf:"bytes,6,opt,name=target,proto3" json:"target"`
}

func (m *AdHocCheck) Reset()         { *m = AdHocCheck{} }
func (m *AdHocCheck) String() string { return proto.CompactTextString(m) }
func (*AdHocCheck) ProtoMessage()    {}
func (*AdHocCheck) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{18}
}
func (m *AdHocCheck) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AdHocCheck) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AdHocCheck.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AdHocCheck) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdHocCheck.Merge(m, src)
}
func (m *AdHocCheck) XXX_Size() int {
	return m.Size()
}
func (m *AdHocCheck) XXX_DiscardUnknown() {
	xxx_messageInfo_AdHocCheck.DiscardUnknown(m)
}

var xxx_messageInfo_AdHocCheck proto.InternalMessageInfo

// CheckSettings provides the settings for exactly one type of check.
type CheckSettings struct {
	Ping       *PingSettings       `protobuf:"bytes,1,opt,name=ping,proto3" json:"ping,omitempty"`
	Http       *HttpSettings       `protobuf:"bytes,2,opt,name=http,proto3" json:"http,omitempty"`
	Dns        *DnsSettings        `protobuf:"bytes,3,opt,name=dns,proto3" json:"dns,omitempty"`
	Tcp        *TcpSettings        `protobuf:"bytes,4,opt,name=tcp,proto3" json:"tcp,omitempty"`
	Traceroute *TracerouteSettings `protobuf:"bytes,5,opt,name=traceroute,proto3" json:"traceroute,omitempty"`
	Scripted   *ScriptedSettings   `protobuf:"bytes,6,opt,name=scripted,proto3" json:"scripted,omitempty"`
	Multihttp  *MultiHttpSettings  `protobuf:"bytes,7,opt,name=multihttp,proto3" json:"multihttp,omitempty"`
	Grpc       *GrpcSettings       `protobuf:"bytes,8,opt,name=grpc,proto3" json:"grpc,omitempty"`
}

func (m *CheckSettings) Reset()         { *m = CheckSettings{} }
func (m *CheckSettings) String() string { return proto.CompactTextString(m) }
func (*CheckSettings) ProtoMessage()    {}
func (*CheckSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{19}
}
func (m *CheckSettings) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CheckSettings.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CheckSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckSettings.Merge(m, src)
}
func (m *CheckSettings) XXX_Size() int {
	return m.Size()
}
func (m *CheckSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckSettings.DiscardUnknown(m)
}

var xxx_messageInfo_CheckSettings proto.InternalMessageInfo

// PingSettings provides the settings for a ping check.
type PingSettings struct {
	IpVersion       IpVersion `protobuf:"varint,1,opt,name=ipVersion,proto3,enum=synthetic_monitoring.IpVersion" json:"ipVersion"`
	SourceIpAddress string    `protobuf:"bytes,2,opt,name=sourceIpAddress,proto3" json:"sourceIpAddress,omitempty"`
	PayloadSize     int64     `protobuf:"varint,3,opt,name=payloadSize,proto3" json:"payloadSize,omitempty"`
	DontFragment    bool      `protobuf:"varint,4,opt,name=dontFragment,proto3" json:"dontFragment"`
	PacketCount     int64     `protobuf:"varint,900,opt,name=packetCount,proto3" json:"packetCount"`
}

func (m *PingSettings) Reset()         { *m = PingSettings{} }
func (m *PingSettings) String() string { return proto.CompactTextString(m) }
func (*PingSettings) ProtoMessage()    {}
func (*PingSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{20}
}
func (m *PingSettings) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PingSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PingSettings.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PingSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PingSettings.Merge(m, src)
}
func (m *PingSettings) XXX_Size() int {
	return m.Size()
}
func (m *PingSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_PingSettings.DiscardUnknown(m)
}

var xxx_messageInfo_PingSettings proto.InternalMessageInfo

// HttpSettings provides the settings for a HTTP check.
type HttpSettings struct {
	IpVersion                    IpVersion            `protobuf:"varint,1,opt,name=ipVersion,proto3,enum=synthetic_monitoring.IpVersion" json:"ipVersion"`
	Method                       HttpMethod           `protobuf:"varint,2,opt,name=method,proto3,enum=synthetic_monitoring.HttpMethod" json:"method"`
	Headers                      []string             `protobuf:"bytes,3,rep,name=headers,proto3" json:"headers,omitempty"`
	Body                         string               `protobuf:"bytes,4,opt,name=body,proto3" json:"body,omitempty"`
	NoFollowRedirects            bool                 `protobuf:"varint,5,opt,name=noFollowRedirects,proto3" json:"noFollowRedirects"`
	TlsConfig                    *TLSConfig           `protobuf:"bytes,100,opt,name=tlsConfig,proto3" json:"tlsConfig,omitempty"`
	BasicAuth                    *BasicAuth           `protobuf:"bytes,101,opt,name=basicAuth,proto3" json:"basicAuth,omitempty"`
	BearerToken                  string               `protobuf:"bytes,102,opt,name=bearerToken,proto3" json:"bearerToken,omitempty"`
	ProxyURL                     string               `protobuf:"bytes,103,opt,name=proxyURL,proto3" json:"proxyURL,omitempty"`
	Oauth2Config                 *OAuth2Config        `protobuf:"bytes,104,opt,name=oauth2Config,proto3" json:"oauth2Config,omitempty"`
	ProxyConnectHeaders          []string             `protobuf:"bytes,105,rep,name=proxyConnectHeaders,proto3" json:"proxyConnectHeaders,omitempty"`
	FailIfSSL                    bool                 `protobuf:"varint,200,opt,name=failIfSSL,proto3" json:"failIfSSL"`
	FailIfNotSSL                 bool                 `protobuf:"varint,201,opt,name=failIfNotSSL,proto3" json:"failIfNotSSL"`
	ValidStatusCodes             []int32              `protobuf:"varint,202,rep,packed,name=validStatusCodes,proto3" json:"validStatusCodes,omitempty"`
	ValidHTTPVersions            []string             `protobuf:"bytes,203,rep,name=validHTTPVersions,proto3" json:"validHTTPVersions,omitempty"`
	FailIfBodyMatchesRegexp      []string             `protobuf:"bytes,204,rep,name=failIfBodyMatchesRegexp,proto3" json:"failIfBodyMatchesRegexp,omitempty"`
	FailIfBodyNotMatchesRegexp   []string             `protobuf:"bytes,205,rep,name=failIfBodyNotMatchesRegexp,proto3" json:"failIfBodyNotMatchesRegexp,omitempty"`
	FailIfHeaderMatchesRegexp    []HeaderMatch        `protobuf:"bytes,206,rep,name=failIfHeaderMatchesRegexp,proto3" json:"failIfHeaderMatchesRegexp,omitempty"`
	FailIfHeaderNotMatchesRegexp []HeaderMatch        `protobuf:"bytes,207,rep,name=failIfHeaderNotMatchesRegexp,proto3" json:"failIfHeaderNotMatchesRegexp,omitempty"`
	Compression                  CompressionAlgorithm `protobuf:"varint,208,opt,name=compression,proto3,enum=synthetic_monitoring.CompressionAlgorithm" json:"compression,omitempty"`
	CacheBustingQueryParamName   string               `protobuf:"bytes,900,opt,name=cacheBustingQueryParamName,proto3" json:"cacheBustingQueryParamName,omitempty"`
}

func (m *HttpSettings) Reset()         { *m = HttpSettings{} }
func (m *HttpSettings) String() string { return proto.CompactTextString(m) }
func (*HttpSettings) ProtoMessage()    {}
func (*HttpSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{21}
}
func (m *HttpSettings) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HttpSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HttpSettings.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HttpSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HttpSettings.Merge(m, src)
}
func (m *HttpSettings) XXX_Size() int {
	return m.Size()
}
func (m *HttpSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_HttpSettings.DiscardUnknown(m)
}

var xxx_messageInfo_HttpSettings proto.InternalMessageInfo

// Configuration for two-legged OAuth2 (client_credentials grant type).
type OAuth2Config struct {
	ClientId       string     `protobuf:"bytes,1,opt,name=clientId,proto3" json:"clientId"`
	ClientSecret   string     `protobuf:"bytes,2,opt,name=clientSecret,proto3" json:"clientSecret"`
	TokenURL       string     `protobuf:"bytes,3,opt,name=tokenURL,proto3" json:"tokenURL"`
	Scopes         []string   `protobuf:"bytes,4,rep,name=scopes,proto3" json:"scopes,omitempty"`
	EndpointParams []Label    `protobuf:"bytes,5,rep,name=endpointParams,proto3" json:"endpointParams,omitempty"`
	TlsConfig      *TLSConfig `protobuf:"bytes,6,opt,name=tlsConfig,proto3" json:"tlsConfig,omitempty"`
	ProxyURL       string     `protobuf:"bytes,7,opt,name=proxyURL,proto3" json:"proxyURL,omitempty"`
}

func (m *OAuth2Config) Reset()         { *m = OAuth2Config{} }
func (m *OAuth2Config) String() string { return proto.CompactTextString(m) }
func (*OAuth2Config) ProtoMessage()    {}
func (*OAuth2Config) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{22}
}
func (m *OAuth2Config) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OAuth2Config) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OAuth2Config.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OAuth2Config) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OAuth2Config.Merge(m, src)
}
func (m *OAuth2Config) XXX_Size() int {
	return m.Size()
}
func (m *OAuth2Config) XXX_DiscardUnknown() {
	xxx_messageInfo_OAuth2Config.DiscardUnknown(m)
}

var xxx_messageInfo_OAuth2Config proto.InternalMessageInfo

// HeaderMatch represents a single header that must match in order for
// the check to be considered successful.
type HeaderMatch struct {
	Header       string `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Regexp       string `protobuf:"bytes,2,opt,name=regexp,proto3" json:"regexp,omitempty"`
	AllowMissing bool   `protobuf:"varint,3,opt,name=allowMissing,proto3" json:"allowMissing,omitempty"`
}

func (m *HeaderMatch) Reset()         { *m = HeaderMatch{} }
func (m *HeaderMatch) String() string { return proto.CompactTextString(m) }
func (*HeaderMatch) ProtoMessage()    {}
func (*HeaderMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{23}
}
func (m *HeaderMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HeaderMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HeaderMatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HeaderMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HeaderMatch.Merge(m, src)
}
func (m *HeaderMatch) XXX_Size() int {
	return m.Size()
}
func (m *HeaderMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_HeaderMatch.DiscardUnknown(m)
}

var xxx_messageInfo_HeaderMatch proto.InternalMessageInfo

// DNSRRValidator represents the DNS resource record validations.
type DNSRRValidator struct {
	FailIfMatchesRegexp    []string `protobuf:"bytes,1,rep,name=failIfMatchesRegexp,proto3" json:"failIfMatchesRegexp,omitempty"`
	FailIfNotMatchesRegexp []string `protobuf:"bytes,2,rep,name=failIfNotMatchesRegexp,proto3" json:"failIfNotMatchesRegexp,omitempty"`
}

func (m *DNSRRValidator) Reset()         { *m = DNSRRValidator{} }
func (m *DNSRRValidator) String() string { return proto.CompactTextString(m) }
func (*DNSRRValidator) ProtoMessage()    {}
func (*DNSRRValidator) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{24}
}
func (m *DNSRRValidator) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DNSRRValidator) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DNSRRValidator.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DNSRRValidator) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DNSRRValidator.Merge(m, src)
}
func (m *DNSRRValidator) XXX_Size() int {
	return m.Size()
}
func (m *DNSRRValidator) XXX_DiscardUnknown() {
	xxx_messageInfo_DNSRRValidator.DiscardUnknown(m)
}

var xxx_messageInfo_DNSRRValidator proto.InternalMessageInfo

// DnsSettings provides the settings for a DNS check.
//
// The way blackbox-exporter works, a DNS check tests a _server_, so the
// _target_ of the check is a server address, and the check itself
// contains the record to check.
//
// "ipVersion" is the IP version to use in the IP layer.
type DnsSettings struct {
	IpVersion          IpVersion       `protobuf:"varint,1,opt,name=ipVersion,proto3,enum=synthetic_monitoring.IpVersion" json:"ipVersion"`
	SourceIpAddress    string          `protobuf:"bytes,2,opt,name=sourceIpAddress,proto3" json:"sourceIpAddress,omitempty"`
	Server             string          `protobuf:"bytes,3,opt,name=server,proto3" json:"server"`
	Port               int32           `protobuf:"varint,4,opt,name=port,proto3" json:"port"`
	RecordType         DnsRecordType   `protobuf:"varint,5,opt,name=recordType,proto3,enum=synthetic_monitoring.DnsRecordType" json:"recordType"`
	Protocol           DnsProtocol     `protobuf:"varint,6,opt,name=protocol,proto3,enum=synthetic_monitoring.DnsProtocol" json:"protocol"`
	ValidRCodes        []string        `protobuf:"bytes,200,rep,name=validRCodes,proto3" json:"validRCodes,omitempty"`
	ValidateAnswer     *DNSRRValidator `protobuf:"bytes,201,opt,name=validateAnswer,proto3" json:"validateAnswerRRS,omitempty"`
	ValidateAuthority  *DNSRRValidator `protobuf:"bytes,202,opt,name=validateAuthority,proto3" json:"validateAuthorityRRS,omitempty"`
	ValidateAdditional *DNSRRValidator `protobuf:"bytes,203,opt,name=validateAdditional,proto3" json:"validateAdditionalRRS,omitempty"`
}

func (m *DnsSettings) Reset()         { *m = DnsSettings{} }
func (m *DnsSettings) String() string { return proto.CompactTextString(m) }
func (*DnsSettings) ProtoMessage()    {}
func (*DnsSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{25}
}
func (m *DnsSettings) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DnsSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DnsSettings.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DnsSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DnsSettings.Merge(m, src)
}
func (m *DnsSettings) XXX_Size() int {
	return m.Size()
}
func (m *DnsSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_DnsSettings.DiscardUnknown(m)
}

var xxx_messageInfo_DnsSettings proto.InternalMessageInfo

// TcpSettings provides the settings for a TCP check.
//
// "ipVersion" is the IP version to use in the IP layer.
type TcpSettings struct {
	IpVersion       IpVersion          `protobuf:"varint,1,opt,name=ipVersion,proto3,enum=synthetic_monitoring.IpVersion" json:"ipVersion"`
	SourceIpAddress string             `protobuf:"bytes,2,opt,name=sourceIpAddress,proto3" json:"sourceIpAddress,omitempty"`
	Tls             bool               `protobuf:"varint,3,opt,name=tls,proto3" json:"tls,omitempty"`
	TlsConfig       *TLSConfig         `protobuf:"bytes,4,opt,name=tlsConfig,proto3" json:"tlsConfig,omitempty"`
	QueryResponse   []TCPQueryResponse `protobuf:"bytes,5,rep,name=queryResponse,proto3" json:"queryResponse,omitempty"`
}

func (m *TcpSettings) Reset()         { *m = TcpSettings{} }
func (m *TcpSettings) String() string { return proto.CompactTextString(m) }
func (*TcpSettings) ProtoMessage()    {}
func (*TcpSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{26}
}
func (m *TcpSettings) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TcpSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TcpSettings.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TcpSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TcpSettings.Merge(m, src)
}
func (m *TcpSettings) XXX_Size() int {
	return m.Size()
}
func (m *TcpSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_TcpSettings.DiscardUnknown(m)
}

var xxx_messageInfo_TcpSettings proto.InternalMessageInfo

// TCPQueryResponse represents a single step in a sequence of
// send/expect pairs to be used when connecting to a generic TCP
// service.
type TCPQueryResponse struct {
	Send     []byte `protobuf:"bytes,1,opt,name=send,proto3" json:"send"`
	Expect   []byte `protobuf:"bytes,2,opt,name=expect,proto3" json:"expect"`
	StartTLS bool   `protobuf:"varint,3,opt,name=startTLS,proto3" json:"startTLS,omitempty"`
}

func (m *TCPQueryResponse) Reset()         { *m = TCPQueryResponse{} }
func (m *TCPQueryResponse) String() string { return proto.CompactTextString(m) }
func (*TCPQueryResponse) ProtoMessage()    {}
func (*TCPQueryResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{27}
}
func (m *TCPQueryResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TCPQueryResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TCPQueryResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TCPQueryResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TCPQueryResponse.Merge(m, src)
}
func (m *TCPQueryResponse) XXX_Size() int {
	return m.Size()
}
func (m *TCPQueryResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_TCPQueryResponse.DiscardUnknown(m)
}

var xxx_messageInfo_TCPQueryResponse proto.InternalMessageInfo

// TLSConfig represents the TLS data to be used when establishing a
// secure connection in the protocols that support it.
type TLSConfig struct {
	InsecureSkipVerify bool   `protobuf:"varint,1,opt,name=insecureSkipVerify,proto3" json:"insecureSkipVerify,omitempty"`
	CACert             []byte `protobuf:"bytes,2,opt,name=CACert,proto3" json:"caCert,omitempty"`
	ClientCert         []byte `protobuf:"bytes,3,opt,name=clientCert,proto3" json:"clientCert,omitempty"`
	ClientKey          []byte `protobuf:"bytes,4,opt,name=clientKey,proto3" json:"clientKey,omitempty"`
	ServerName         string `protobuf:"bytes,5,opt,name=serverName,proto3" json:"serverName,omitempty"`
}

func (m *TLSConfig) Reset()         { *m = TLSConfig{} }
func (m *TLSConfig) String() string { return proto.CompactTextString(m) }
func (*TLSConfig) ProtoMessage()    {}
func (*TLSConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{28}
}
func (m *TLSConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TLSConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TLSConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TLSConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TLSConfig.Merge(m, src)
}
func (m *TLSConfig) XXX_Size() int {
	return m.Size()
}
func (m *TLSConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_TLSConfig.DiscardUnknown(m)
}

var xxx_messageInfo_TLSConfig proto.InternalMessageInfo

// BasicAuth represents the basic authentication credentials to be used
// when talking to HTTP servers.
type BasicAuth struct {
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	Password string `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
}

func (m *BasicAuth) Reset()         { *m = BasicAuth{} }
func (m *BasicAuth) String() string { return proto.CompactTextString(m) }
func (*BasicAuth) ProtoMessage()    {}
func (*BasicAuth) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{29}
}
func (m *BasicAuth) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BasicAuth) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BasicAuth.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BasicAuth) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BasicAuth.Merge(m, src)
}
func (m *BasicAuth) XXX_Size() int {
	return m.Size()
}
func (m *BasicAuth) XXX_DiscardUnknown() {
	xxx_messageInfo_BasicAuth.DiscardUnknown(m)
}

var xxx_messageInfo_BasicAuth proto.InternalMessageInfo

type TracerouteSettings struct {
	MaxHops        int64 `protobuf:"varint,1,opt,name=maxHops,proto3" json:"maxHops"`
	MaxUnknownHops int64 `protobuf:"varint,2,opt,name=maxUnknownHops,proto3" json:"maxUnknownHops"`
	PtrLookup      bool  `protobuf:"varint,3,opt,name=ptrLookup,proto3" json:"ptrLookup"`
	HopTimeout     int64 `protobuf:"varint,4,opt,name=hopTimeout,proto3" json:"hopTimeout"`
}

func (m *TracerouteSettings) Reset()         { *m = TracerouteSettings{} }
func (m *TracerouteSettings) String() string { return proto.CompactTextString(m) }
func (*TracerouteSettings) ProtoMessage()    {}
func (*TracerouteSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{30}
}
func (m *TracerouteSettings) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TracerouteSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TracerouteSettings.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TracerouteSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TracerouteSettings.Merge(m, src)
}
func (m *TracerouteSettings) XXX_Size() int {
	return m.Size()
}
func (m *TracerouteSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_TracerouteSettings.DiscardUnknown(m)
}

var xxx_messageInfo_TracerouteSettings proto.InternalMessageInfo

type ScriptedSettings struct {
	Script []byte `protobuf:"bytes,1,opt,name=script,proto3" json:"script"`
}

func (m *ScriptedSettings) Reset()         { *m = ScriptedSettings{} }
func (m *ScriptedSettings) String() string { return proto.CompactTextString(m) }
func (*ScriptedSettings) ProtoMessage()    {}
func (*ScriptedSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{31}
}
func (m *ScriptedSettings) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScriptedSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ScriptedSettings.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ScriptedSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScriptedSettings.Merge(m, src)
}
func (m *ScriptedSettings) XXX_Size() int {
	return m.Size()
}
func (m *ScriptedSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_ScriptedSettings.DiscardUnknown(m)
}

var xxx_messageInfo_ScriptedSettings proto.InternalMessageInfo

// MultiHttpSettings represents the settings for the MultiHttp check type.
type MultiHttpSettings struct {
	Entries      []*MultiHttpEntry `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries"`
	LogResponses bool              `protobuf:"varint,2,opt,name=logResponses,proto3" json:"logResponseBodies,omitempty"`
}

func (m *MultiHttpSettings) Reset()         { *m = MultiHttpSettings{} }
func (m *MultiHttpSettings) String() string { return proto.CompactTextString(m) }
func (*MultiHttpSettings) ProtoMessage()    {}
func (*MultiHttpSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{32}
}
func (m *MultiHttpSettings) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MultiHttpSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MultiHttpSettings.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MultiHttpSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiHttpSettings.Merge(m, src)
}
func (m *MultiHttpSettings) XXX_Size() int {
	return m.Size()
}
func (m *MultiHttpSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiHttpSettings.DiscardUnknown(m)
}

var xxx_messageInfo_MultiHttpSettings proto.InternalMessageInfo

// MultiHttpEntry represents a single entry in a MultiHttp check.
type MultiHttpEntry struct {
	Request    *MultiHttpEntryRequest     `protobuf:"bytes,1,opt,name=request,proto3" json:"request,omitempty"`
	Assertions []*MultiHttpEntryAssertion `protobuf:"bytes,2,rep,name=assertions,proto3" json:"checks,omitempty"`
	Variables  []*MultiHttpEntryVariable  `protobuf:"bytes,3,rep,name=variables,proto3" json:"variables,omitempty"`
}

func (m *MultiHttpEntry) Reset()         { *m = MultiHttpEntry{} }
func (m *MultiHttpEntry) String() string { return proto.CompactTextString(m) }
func (*MultiHttpEntry) ProtoMessage()    {}
func (*MultiHttpEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{33}
}
func (m *MultiHttpEntry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MultiHttpEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MultiHttpEntry.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MultiHttpEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiHttpEntry.Merge(m, src)
}
func (m *MultiHttpEntry) XXX_Size() int {
	return m.Size()
}
func (m *MultiHttpEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiHttpEntry.DiscardUnknown(m)
}

var xxx_messageInfo_MultiHttpEntry proto.InternalMessageInfo

// HttpHeader represents a single HTTP header key-value pair.
type HttpHeader struct {
	Name  string `protobuf:"bytes,1,opt,name=name,proto3" json:"name"`
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value"`
}

func (m *HttpHeader) Reset()         { *m = HttpHeader{} }
func (m *HttpHeader) String() string { return proto.CompactTextString(m) }
func (*HttpHeader) ProtoMessage()    {}
func (*HttpHeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{34}
}
func (m *HttpHeader) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HttpHeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HttpHeader.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HttpHeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HttpHeader.Merge(m, src)
}
func (m *HttpHeader) XXX_Size() int {
	return m.Size()
}
func (m *HttpHeader) XXX_DiscardUnknown() {
	xxx_messageInfo_HttpHeader.DiscardUnknown(m)
}

var xxx_messageInfo_HttpHeader proto.InternalMessageInfo

// QueryField represents a single query field key-value pair.
type QueryField struct {
	Name  string `protobuf:"bytes,1,opt,name=name,proto3" json:"name"`
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value"`
}

func (m *QueryField) Reset()         { *m = QueryField{} }
func (m *QueryField) String() string { return proto.CompactTextString(m) }
func (*QueryField) ProtoMessage()    {}
func (*QueryField) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{35}
}
func (m *QueryField) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryField) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryField.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryField) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryField.Merge(m, src)
}
func (m *QueryField) XXX_Size() int {
	return m.Size()
}
func (m *QueryField) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryField.DiscardUnknown(m)
}

var xxx_messageInfo_QueryField proto.InternalMessageInfo

// MultiHttpEntryRequest contains the settings for a single request in a MultiHttp check.
type MultiHttpEntryRequest struct {
	Method      HttpMethod       `protobuf:"varint,1,opt,name=method,proto3,enum=synthetic_monitoring.HttpMethod" json:"method"`
	Url         string           `protobuf:"bytes,2,opt,name=url,proto3" json:"url"`
	Headers     []*HttpHeader    `protobuf:"bytes,3,rep,name=headers,proto3" json:"headers,omitempty"`
	QueryFields []*QueryField    `protobuf:"bytes,4,rep,name=queryFields,proto3" json:"queryFields,omitempty"`
	Body        *HttpRequestBody `protobuf:"bytes,5,opt,name=body,proto3" json:"body,omitempty"`
}

func (m *MultiHttpEntryRequest) Reset()         { *m = MultiHttpEntryRequest{} }
func (m *MultiHttpEntryRequest) String() string { return proto.CompactTextString(m) }
func (*MultiHttpEntryRequest) ProtoMessage()    {}
func (*MultiHttpEntryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{36}
}
func (m *MultiHttpEntryRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MultiHttpEntryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MultiHttpEntryRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MultiHttpEntryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiHttpEntryRequest.Merge(m, src)
}
func (m *MultiHttpEntryRequest) XXX_Size() int {
	return m.Size()
}
func (m *MultiHttpEntryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiHttpEntryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MultiHttpEntryRequest proto.InternalMessageInfo

// HttpRequestBody represents the body of an HTTP request.
type HttpRequestBody struct {
	ContentType     string `protobuf:"bytes,1,opt,name=contentType,proto3" json:"contentType"`
	ContentEncoding string `protobuf:"bytes,2,opt,name=contentEncoding,proto3" json:"contentEncoding,omitempty"`
	Payload         []byte `protobuf:"bytes,3,opt,name=payload,proto3" json:"payload"`
}

func (m *HttpRequestBody) Reset()         { *m = HttpRequestBody{} }
func (m *HttpRequestBody) String() string { return proto.CompactTextString(m) }
func (*HttpRequestBody) ProtoMessage()    {}
func (*HttpRequestBody) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{37}
}
func (m *HttpRequestBody) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HttpRequestBody) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HttpRequestBody.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HttpRequestBody) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HttpRequestBody.Merge(m, src)
}
func (m *HttpRequestBody) XXX_Size() int {
	return m.Size()
}
func (m *HttpRequestBody) XXX_DiscardUnknown() {
	xxx_messageInfo_HttpRequestBody.DiscardUnknown(m)
}

var xxx_messageInfo_HttpRequestBody proto.InternalMessageInfo

// MultiHttpEntryAssertion represents a single assertion to be made on the response.
//
// The `value` field specifies the _value_ that the subject and the condition
// should meet, e.g. if the subject is body and the condition is contains,
// value specifies the substring that should be found in the body.
//
// For the JSON_PATH_VALUE type, `expression` specifies the JSON path to match against `value`.
//
// For the JSON_PATH_ASSERTION type, `expression` specifies the JSON path to assert.
//
// For the TEXT type, if the subject is `RESPONSE_HEADERS`, `expression`
// specifies which specific header should be used as the subject of the
// operation. Headers are case-insensitive (RFC 7230, section 3.2,
// https://datatracker.ietf.org/doc/html/rfc7230#section-3.2).
type MultiHttpEntryAssertion struct {
	Type       MultiHttpEntryAssertionType             `protobuf:"varint,1,opt,name=type,proto3,enum=synthetic_monitoring.MultiHttpEntryAssertionType" json:"type"`
	Subject    MultiHttpEntryAssertionSubjectVariant   `protobuf:"varint,2,opt,name=subject,proto3,enum=synthetic_monitoring.MultiHttpEntryAssertionSubjectVariant" json:"subject,omitempty"`
	Condition  MultiHttpEntryAssertionConditionVariant `protobuf:"varint,3,opt,name=condition,proto3,enum=synthetic_monitoring.MultiHttpEntryAssertionConditionVariant" json:"condition,omitempty"`
	Expression string                                  `protobuf:"bytes,4,opt,name=expression,proto3" json:"expression,omitempty"`
	Value      string                                  `protobuf:"bytes,5,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *MultiHttpEntryAssertion) Reset()         { *m = MultiHttpEntryAssertion{} }
func (m *MultiHttpEntryAssertion) String() string { return proto.CompactTextString(m) }
func (*MultiHttpEntryAssertion) ProtoMessage()    {}
func (*MultiHttpEntryAssertion) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{38}
}
func (m *MultiHttpEntryAssertion) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MultiHttpEntryAssertion) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MultiHttpEntryAssertion.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MultiHttpEntryAssertion) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiHttpEntryAssertion.Merge(m, src)
}
func (m *MultiHttpEntryAssertion) XXX_Size() int {
	return m.Size()
}
func (m *MultiHttpEntryAssertion) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiHttpEntryAssertion.DiscardUnknown(m)
}

var xxx_messageInfo_MultiHttpEntryAssertion proto.InternalMessageInfo

// MultiHttpEntryVariable represents a single variable to be used in the request.
type MultiHttpEntryVariable struct {
	Type       MultiHttpEntryVariableType `protobuf:"varint,1,opt,name=type,proto3,enum=synthetic_monitoring.MultiHttpEntryVariableType" json:"type"`
	Name       string                     `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Expression string                     `protobuf:"bytes,3,opt,name=expression,proto3" json:"expression,omitempty"`
	Attribute  string                     `protobuf:"bytes,4,opt,name=attribute,proto3" json:"attribute,omitempty"`
}

func (m *MultiHttpEntryVariable) Reset()         { *m = MultiHttpEntryVariable{} }
func (m *MultiHttpEntryVariable) String() string { return proto.CompactTextString(m) }
func (*MultiHttpEntryVariable) ProtoMessage()    {}
func (*MultiHttpEntryVariable) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{39}
}
func (m *MultiHttpEntryVariable) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MultiHttpEntryVariable) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MultiHttpEntryVariable.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MultiHttpEntryVariable) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MultiHttpEntryVariable.Merge(m, src)
}
func (m *MultiHttpEntryVariable) XXX_Size() int {
	return m.Size()
}
func (m *MultiHttpEntryVariable) XXX_DiscardUnknown() {
	xxx_messageInfo_MultiHttpEntryVariable.DiscardUnknown(m)
}

var xxx_messageInfo_MultiHttpEntryVariable proto.InternalMessageInfo

// GrpcSettings provides the settings for a gRPC check.
type GrpcSettings struct {
	IpVersion IpVersion  `protobuf:"varint,1,opt,name=ipVersion,proto3,enum=synthetic_monitoring.IpVersion" json:"ipVersion"`
	Service   string     `protobuf:"bytes,2,opt,name=service,proto3" json:"service,omitempty"`
	Tls       bool       `protobuf:"varint,3,opt,name=tls,proto3" json:"tls,omitempty"`
	TlsConfig *TLSConfig `protobuf:"bytes,4,opt,name=tlsConfig,proto3" json:"tlsConfig,omitempty"`
}

func (m *GrpcSettings) Reset()         { *m = GrpcSettings{} }
func (m *GrpcSettings) String() string { return proto.CompactTextString(m) }
func (*GrpcSettings) ProtoMessage()    {}
func (*GrpcSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{40}
}
func (m *GrpcSettings) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GrpcSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GrpcSettings.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GrpcSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GrpcSettings.Merge(m, src)
}
func (m *GrpcSettings) XXX_Size() int {
	return m.Size()
}
func (m *GrpcSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_GrpcSettings.DiscardUnknown(m)
}

var xxx_messageInfo_GrpcSettings proto.InternalMessageInfo

// RegionTelemetry represents the telemetry data for a specific region.
// Groups the telemetry data for all the tenants that have checks being
// executed in the agent and belong to the same region.
type RegionTelemetry struct {
	Instance  string             `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance"`
	RegionId  int32              `protobuf:"varint,2,opt,name=regionId,proto3" json:"regionId"`
	Telemetry []*TenantTelemetry `protobuf:"bytes,3,rep,name=telemetry,proto3" json:"telemetry"`
}

func (m *RegionTelemetry) Reset()         { *m = RegionTelemetry{} }
func (m *RegionTelemetry) String() string { return proto.CompactTextString(m) }
func (*RegionTelemetry) ProtoMessage()    {}
func (*RegionTelemetry) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{41}
}
func (m *RegionTelemetry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RegionTelemetry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RegionTelemetry.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RegionTelemetry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RegionTelemetry.Merge(m, src)
}
func (m *RegionTelemetry) XXX_Size() int {
	return m.Size()
}
func (m *RegionTelemetry) XXX_DiscardUnknown() {
	xxx_messageInfo_RegionTelemetry.DiscardUnknown(m)
}

var xxx_messageInfo_RegionTelemetry proto.InternalMessageInfo

// TenantTelemetry represents the telemetry data for a specific tenant.
type TenantTelemetry struct {
	TenantId  int64                  `protobuf:"varint,1,opt,name=tenantId,proto3" json:"tenantId"`
	Telemetry []*CheckClassTelemetry `protobuf:"bytes,2,rep,name=telemetry,proto3" json:"telemetry"`
}

func (m *TenantTelemetry) Reset()         { *m = TenantTelemetry{} }
func (m *TenantTelemetry) String() string { return proto.CompactTextString(m) }
func (*TenantTelemetry) ProtoMessage()    {}
func (*TenantTelemetry) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{42}
}
func (m *TenantTelemetry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TenantTelemetry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TenantTelemetry.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TenantTelemetry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TenantTelemetry.Merge(m, src)
}
func (m *TenantTelemetry) XXX_Size() int {
	return m.Size()
}
func (m *TenantTelemetry) XXX_DiscardUnknown() {
	xxx_messageInfo_TenantTelemetry.DiscardUnknown(m)
}

var xxx_messageInfo_TenantTelemetry proto.InternalMessageInfo

// CheckClassTelemetry represents the telemetry data for a specific check class.
type CheckClassTelemetry struct {
	CheckClass        CheckClass `protobuf:"varint,1,opt,name=checkClass,proto3,enum=synthetic_monitoring.CheckClass" json:"checkClass"`
	Executions        int32      `protobuf:"varint,2,opt,name=executions,proto3" json:"executions"`
	Duration          float32    `protobuf:"fixed32,3,opt,name=duration,proto3" json:"duration"`
	SampledExecutions int32      `protobuf:"varint,4,opt,name=sampledExecutions,proto3" json:"sampledExecutions"`
}

func (m *CheckClassTelemetry) Reset()         { *m = CheckClassTelemetry{} }
func (m *CheckClassTelemetry) String() string { return proto.CompactTextString(m) }
func (*CheckClassTelemetry) ProtoMessage()    {}
func (*CheckClassTelemetry) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{43}
}
func (m *CheckClassTelemetry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckClassTelemetry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CheckClassTelemetry.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CheckClassTelemetry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckClassTelemetry.Merge(m, src)
}
func (m *CheckClassTelemetry) XXX_Size() int {
	return m.Size()
}
func (m *CheckClassTelemetry) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckClassTelemetry.DiscardUnknown(m)
}

var xxx_messageInfo_CheckClassTelemetry proto.InternalMessageInfo

// PushTelemetryResponse represents a response for a push telemetry rpc call.
type PushTelemetryResponse struct {
	Status *Status `protobuf:"bytes,1,opt,name=status,proto3" json:"status"`
}

func (m *PushTelemetryResponse) Reset()         { *m = PushTelemetryResponse{} }
func (m *PushTelemetryResponse) String() string { return proto.CompactTextString(m) }
func (*PushTelemetryResponse) ProtoMessage()    {}
func (*PushTelemetryResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a921b63774164c1f, []int{44}
}
func (m *PushTelemetryResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PushTelemetryResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PushTelemetryResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PushTelemetryResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PushTelemetryResponse.Merge(m, src)
}
func (m *PushTelemetryResponse) XXX_Size() int {
	return m.Size()
}
func (m *PushTelemetryResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PushTelemetryResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PushTelemetryResponse proto.InternalMessageInfo

func init() {
	proto.RegisterEnum("synthetic_monitoring.StatusCode", StatusCode_name, StatusCode_value)
	proto.RegisterEnum("synthetic_monitoring.TenantStatus", TenantStatus_name, TenantStatus_value)
	proto.RegisterEnum("synthetic_monitoring.CheckOperation", CheckOperation_name, CheckOperation_value)
	proto.RegisterEnum("synthetic_monitoring.HttpMethod", HttpMethod_name, HttpMethod_value)
	proto.RegisterEnum("synthetic_monitoring.DnsRecordType", DnsRecordType_name, DnsRecordType_value)
	proto.RegisterEnum("synthetic_monitoring.DnsProtocol", DnsProtocol_name, DnsProtocol_value)
	proto.RegisterEnum("synthetic_monitoring.IpVersion", IpVersion_name, IpVersion_value)
	proto.RegisterEnum("synthetic_monitoring.CompressionAlgorithm", CompressionAlgorithm_name, CompressionAlgorithm_value)
	proto.RegisterEnum("synthetic_monitoring.MultiHttpEntryAssertionType", MultiHttpEntryAssertionType_name, MultiHttpEntryAssertionType_value)
	proto.RegisterEnum("synthetic_monitoring.MultiHttpEntryAssertionSubjectVariant", MultiHttpEntryAssertionSubjectVariant_name, MultiHttpEntryAssertionSubjectVariant_value)
	proto.RegisterEnum("synthetic_monitoring.MultiHttpEntryAssertionConditionVariant", MultiHttpEntryAssertionConditionVariant_name, MultiHttpEntryAssertionConditionVariant_value)
	proto.RegisterEnum("synthetic_monitoring.MultiHttpEntryVariableType", MultiHttpEntryVariableType_name, MultiHttpEntryVariableType_value)
	proto.RegisterEnum("synthetic_monitoring.CheckClass", CheckClass_name, CheckClass_value)
	proto.RegisterType((*Void)(nil), "synthetic_monitoring.Void")
	proto.RegisterType((*ProbeState)(nil), "synthetic_monitoring.ProbeState")
	proto.RegisterType((*EntityRef)(nil), "synthetic_monitoring.EntityRef")
	proto.RegisterType((*ProbeInfo)(nil), "synthetic_monitoring.ProbeInfo")
	proto.RegisterType((*PingRequest)(nil), "synthetic_monitoring.PingRequest")
	proto.RegisterType((*PongResponse)(nil), "synthetic_monitoring.PongResponse")
	proto.RegisterType((*Status)(nil), "synthetic_monitoring.Status")
	proto.RegisterType((*RegisterProbeResult)(nil), "synthetic_monitoring.RegisterProbeResult")
	proto.RegisterType((*Probe)(nil), "synthetic_monitoring.Probe")
	proto.RegisterType((*TenantInfo)(nil), "synthetic_monitoring.TenantInfo")
	proto.RegisterType((*TenantLimits)(nil), "synthetic_monitoring.TenantLimits")
	proto.RegisterType((*Tenant)(nil), "synthetic_monitoring.Tenant")
	proto.RegisterType((*RemoteInfo)(nil), "synthetic_monitoring.RemoteInfo")
	proto.RegisterType((*CheckChange)(nil), "synthetic_monitoring.CheckChange")
	proto.RegisterType((*Changes)(nil), "synthetic_monitoring.Changes")
	proto.RegisterType((*AdHocRequest)(nil), "synthetic_monitoring.AdHocRequest")
	proto.RegisterType((*Label)(nil), "synthetic_monitoring.Label")
	proto.RegisterType((*Check)(nil), "synthetic_monitoring.Check")
	proto.RegisterType((*AdHocCheck)(nil), "synthetic_monitoring.AdHocCheck")
	proto.RegisterType((*CheckSettings)(nil), "synthetic_monitoring.CheckSettings")
	proto.RegisterType((*PingSettings)(nil), "synthetic_monitoring.PingSettings")
	proto.RegisterType((*HttpSettings)(nil), "synthetic_monitoring.HttpSettings")
	proto.RegisterType((*OAuth2Config)(nil), "synthetic_monitoring.OAuth2Config")
	proto.RegisterType((*HeaderMatch)(nil), "synthetic_monitoring.HeaderMatch")
	proto.RegisterType((*DNSRRValidator)(nil), "synthetic_monitoring.DNSRRValidator")
	proto.RegisterType((*DnsSettings)(nil), "synthetic_monitoring.DnsSettings")
	proto.RegisterType((*TcpSettings)(nil), "synthetic_monitoring.TcpSettings")
	proto.RegisterType((*TCPQueryResponse)(nil), "synthetic_monitoring.TCPQueryResponse")
	proto.RegisterType((*TLSConfig)(nil), "synthetic_monitoring.TLSConfig")
	proto.RegisterType((*BasicAuth)(nil), "synthetic_monitoring.BasicAuth")
	proto.RegisterType((*TracerouteSettings)(nil), "synthetic_monitoring.TracerouteSettings")
	proto.RegisterType((*ScriptedSettings)(nil), "synthetic_monitoring.ScriptedSettings")
	proto.RegisterType((*MultiHttpSettings)(nil), "synthetic_monitoring.MultiHttpSettings")
	proto.RegisterType((*MultiHttpEntry)(nil), "synthetic_monitoring.MultiHttpEntry")
	proto.RegisterType((*HttpHeader)(nil), "synthetic_monitoring.HttpHeader")
	proto.RegisterType((*QueryField)(nil), "synthetic_monitoring.QueryField")
	proto.RegisterType((*MultiHttpEntryRequest)(nil), "synthetic_monitoring.MultiHttpEntryRequest")
	proto.RegisterType((*HttpRequestBody)(nil), "synthetic_monitoring.HttpRequestBody")
	proto.RegisterType((*MultiHttpEntryAssertion)(nil), "synthetic_monitoring.MultiHttpEntryAssertion")
	proto.RegisterType((*MultiHttpEntryVariable)(nil), "synthetic_monitoring.MultiHttpEntryVariable")
	proto.RegisterType((*GrpcSettings)(nil), "synthetic_monitoring.GrpcSettings")
	proto.RegisterType((*RegionTelemetry)(nil), "synthetic_monitoring.RegionTelemetry")
	proto.RegisterType((*TenantTelemetry)(nil), "synthetic_monitoring.TenantTelemetry")
	proto.RegisterType((*CheckClassTelemetry)(nil), "synthetic_monitoring.CheckClassTelemetry")
	proto.RegisterType((*PushTelemetryResponse)(nil), "synthetic_monitoring.PushTelemetryResponse")
}

func init() { proto.RegisterFile("checks.proto", fileDescriptor_a921b63774164c1f) }

var fileDescriptor_a921b63774164c1f = []byte{
	// 4603 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x7b, 0x4d, 0x6c, 0x23, 0x47,
	0x76, 0xbf, 0x9a, 0xa4, 0x28, 0xf1, 0x51, 0xd2, 0xf4, 0xd4, 0x8c, 0x6d, 0x5a, 0x1e, 0x8b, 0x72,
	0xdb, 0xe3, 0x95, 0x65, 0xff, 0xc7, 0xbb, 0xfa, 0xdb, 0xde, 0x85, 0x37, 0x1b, 0x2c, 0xbf, 0x66,
	0x24, 0x8f, 0x44, 0x72, 0x8a, 0x2d, 0x65, 0xc6, 0xd8, 0x8d, 0xd2, 0x6a, 0x96, 0xa4, 0xf6, 0x90,
	0xdd, 0x74, 0x77, 0x71, 0x2c, 0xf9, 0xb6, 0xc0, 0x62, 0x11, 0x6c, 0x10, 0xc0, 0x40, 0x80, 0x00,
	0x39, 0x65, 0x17, 0x48, 0x80, 0x6c, 0x72, 0x4c, 0x10, 0xec, 0x5e, 0x93, 0xcb, 0x24, 0xd9, 0x24,
	0x3e, 0xe4, 0x90, 0x13, 0x91, 0x8c, 0x0f, 0x01, 0x78, 0xca, 0x25, 0x87, 0xdc, 0x82, 0xfa, 0xe8,
	0xee, 0x6a, 0x91, 0x4d, 0x6b, 0xd6, 0x13, 0x64, 0x2f, 0xec, 0xaa, 0x5f, 0xbd, 0xf7, 0xaa, 0xba,
	0xea, 0xd5, 0x7b, 0xaf, 0x5e, 0x17, 0x61, 0xc9, 0x3e, 0x25, 0xf6, 0xc3, 0xe0, 0xd6, 0xc0, 0xf7,
	0xa8, 0x87, 0xae, 0x07, 0xe7, 0x2e, 0x3d, 0x25, 0xd4, 0xb1, 0x0f, 0xfb, 0x9e, 0xeb, 0x50, 0xcf,
	0x77, 0xdc, 0x93, 0xd5, 0xeb, 0x27, 0xde, 0x89, 0xc7, 0x09, 0xde, 0x66, 0x25, 0x41, 0x6b, 0xe4,
	0x21, 0x77, 0xe0, 0x39, 0x5d, 0xe3, 0xa7, 0x1a, 0x40, 0xdb, 0xf7, 0x8e, 0x48, 0x87, 0x5a, 0x94,
	0xa0, 0x3b, 0x90, 0x17, 0x22, 0x4b, 0xda, 0x7a, 0x76, 0xa3, 0xb8, 0x55, 0xbe, 0x35, 0x4d, 0xe6,
	0xad, 0x86, 0x4b, 0x1d, 0x7a, 0x8e, 0xc9, 0x71, 0x75, 0xe5, 0xf1, 0xa8, 0x3c, 0x37, 0x1e, 0x95,
	0x25, 0x1b, 0x96, 0x4f, 0xf4, 0x01, 0x2c, 0x50, 0xe2, 0x5a, 0x2e, 0x0d, 0x4a, 0x99, 0xcb, 0x49,
	0xba, 0x22, 0x25, 0x85, 0x7c, 0x38, 0x2c, 0x18, 0x0f, 0xa0, 0x10, 0x91, 0xa1, 0xe7, 0x21, 0xe3,
	0x74, 0x4b, 0xda, 0xba, 0xb6, 0x91, 0xad, 0xe6, 0xc7, 0xa3, 0x72, 0xc6, 0xe9, 0xe2, 0x8c, 0xd3,
	0x45, 0xef, 0xc0, 0x52, 0xcf, 0x0a, 0xe8, 0x9e, 0xd7, 0x75, 0x8e, 0x1d, 0xd2, 0x2d, 0x65, 0xd6,
	0xb5, 0x0d, 0xad, 0xaa, 0x8f, 0x47, 0xe5, 0x04, 0x8e, 0x13, 0x35, 0xe3, 0x47, 0x1a, 0x14, 0xf8,
	0xeb, 0xef, 0xb8, 0xc7, 0x1e, 0xba, 0x09, 0x0b, 0x07, 0xc4, 0x0f, 0x1c, 0xcf, 0xe5, 0x1d, 0x14,
	0xaa, 0x45, 0x36, 0x9e, 0x47, 0x02, 0xc2, 0x61, 0x1b, 0x32, 0x20, 0x5f, 0xf3, 0xfa, 0x7d, 0x87,
	0xf2, 0x4e, 0x0a, 0x55, 0xe0, 0xef, 0xcf, 0x11, 0x2c, 0x5b, 0xd0, 0x2d, 0x80, 0xea, 0xd0, 0xe9,
	0x75, 0x03, 0x6a, 0xf5, 0x07, 0xa5, 0x2c, 0xa7, 0x5b, 0x19, 0x8f, 0xca, 0x70, 0x14, 0xa1, 0x58,
	0xa1, 0x30, 0xbe, 0x09, 0xc5, 0xb6, 0xe3, 0x9e, 0x60, 0xf2, 0xf1, 0x90, 0x04, 0x14, 0x6d, 0xc0,
	0x62, 0x87, 0x15, 0x5d, 0x9b, 0xc8, 0x77, 0x5d, 0x1a, 0x8f, 0xca, 0x8b, 0x81, 0xc4, 0x70, 0xd4,
	0x6a, 0x7c, 0x0b, 0x96, 0xda, 0x1e, 0x63, 0x0c, 0x06, 0x9e, 0x1b, 0x90, 0xa7, 0xe0, 0xbc, 0x0f,
	0x79, 0xb6, 0xe8, 0xc3, 0x00, 0xbd, 0x03, 0x39, 0xdb, 0xeb, 0x0a, 0xfa, 0x95, 0xad, 0xf5, 0xe9,
	0x2b, 0x25, 0x68, 0x6b, 0x5e, 0x97, 0x60, 0x4e, 0x8d, 0x4a, 0xb0, 0xd0, 0x27, 0x41, 0x60, 0x9d,
	0x10, 0x31, 0x0f, 0x38, 0xac, 0x1a, 0x3f, 0xd6, 0xe0, 0x1a, 0x26, 0x27, 0x4e, 0x40, 0x89, 0xcf,
	0x67, 0x17, 0x93, 0x60, 0xd8, 0xa3, 0xe8, 0x9b, 0x30, 0x3f, 0x60, 0x55, 0xde, 0x51, 0x71, 0xeb,
	0xa5, 0xe9, 0x1d, 0x71, 0x8e, 0x6a, 0x8e, 0xa9, 0x03, 0x16, 0xf4, 0xe8, 0x7d, 0xc8, 0x07, 0xbc,
	0x7b, 0xde, 0x53, 0x71, 0xeb, 0xc6, 0xac, 0x21, 0x4a, 0x56, 0xc9, 0x61, 0xfc, 0x74, 0x1e, 0xe6,
	0xb9, 0xc8, 0x54, 0xd5, 0xd9, 0x80, 0x45, 0xa1, 0x6a, 0x3b, 0x42, 0x6d, 0xe4, 0x94, 0x85, 0x18,
	0x8e, 0x4a, 0xe8, 0x06, 0xe4, 0x5c, 0xab, 0x4f, 0xe4, 0x7a, 0x2e, 0x8e, 0x47, 0x65, 0x5e, 0xc7,
	0xfc, 0x97, 0xc9, 0xe9, 0x59, 0xd4, 0xa1, 0xc3, 0x2e, 0x29, 0xe5, 0xd6, 0xb5, 0x8d, 0x8c, 0x90,
	0x13, 0x62, 0x38, 0x2a, 0xa1, 0x37, 0xa1, 0xd0, 0xf3, 0xdc, 0x13, 0x41, 0x3a, 0xcf, 0x49, 0x97,
	0xc7, 0xa3, 0x72, 0x0c, 0xe2, 0xb8, 0x88, 0x6a, 0x90, 0xef, 0x59, 0x47, 0xa4, 0x17, 0x94, 0xf2,
	0x7c, 0x27, 0xa5, 0x4c, 0xdb, 0x2e, 0xa3, 0x89, 0xf7, 0xa3, 0x60, 0xc1, 0xf2, 0xc9, 0x74, 0xd6,
	0x27, 0x27, 0x4c, 0xb3, 0x17, 0x62, 0x9d, 0x15, 0x08, 0x96, 0x4f, 0x46, 0x33, 0x18, 0x1e, 0xf5,
	0x1c, 0xbb, 0xb4, 0xb8, 0xae, 0x6d, 0x2c, 0x0a, 0x1a, 0x81, 0x60, 0xf9, 0x64, 0x34, 0x9e, 0xdb,
	0x73, 0x5c, 0x52, 0x2a, 0xc4, 0x34, 0x02, 0xc1, 0xf2, 0xc9, 0xb6, 0xa2, 0x28, 0xd5, 0x4e, 0x2d,
	0xf7, 0x84, 0x94, 0x20, 0xde, 0x8a, 0x2a, 0x8e, 0x13, 0x35, 0xb6, 0xf9, 0xe4, 0x4e, 0x2b, 0x15,
	0xa7, 0x6c, 0xbe, 0x47, 0xf1, 0xe6, 0x13, 0x5b, 0xad, 0xb4, 0x34, 0xb9, 0xf9, 0xec, 0x68, 0xf3,
	0xc5, 0xdb, 0xac, 0xb4, 0x3c, 0x7d, 0xf3, 0xc5, 0x65, 0x46, 0xdf, 0x25, 0x03, 0x9f, 0xd8, 0x16,
	0x25, 0xdd, 0xd2, 0x0a, 0x7f, 0x31, 0x4e, 0x1f, 0xa3, 0x58, 0x29, 0xb3, 0xa1, 0xda, 0x3e, 0xe1,
	0xc4, 0x5d, 0xfe, 0x6e, 0x7c, 0xa8, 0x12, 0xc2, 0x61, 0x81, 0xe9, 0x43, 0x3f, 0x34, 0x47, 0x84,
	0xd3, 0x71, 0x7d, 0x08, 0x31, 0x1c, 0x95, 0x8c, 0x1b, 0x00, 0xa6, 0xd0, 0x31, 0x66, 0x86, 0x56,
	0x62, 0x3d, 0x65, 0xfa, 0x69, 0xfc, 0x97, 0x06, 0x4b, 0xa2, 0x79, 0xd7, 0xe9, 0x3b, 0x34, 0x60,
	0xea, 0xd3, 0xb7, 0xce, 0x6a, 0xa1, 0xa1, 0x66, 0x1a, 0xcb, 0xd5, 0x27, 0x02, 0x71, 0x5c, 0x44,
	0x35, 0xb8, 0xda, 0xb7, 0xce, 0x3a, 0xb6, 0xef, 0x0c, 0x28, 0xe9, 0x4a, 0x26, 0xa1, 0xe6, 0xcf,
	0x8d, 0x47, 0xe5, 0xc9, 0x46, 0x3c, 0x09, 0xa1, 0xef, 0xc0, 0x95, 0xbe, 0x75, 0xb6, 0x47, 0xa8,
	0xef, 0xd8, 0xbb, 0x42, 0x19, 0xb3, 0x5c, 0xc4, 0xb5, 0xf1, 0xa8, 0x7c, 0xb1, 0x09, 0x5f, 0x04,
	0x98, 0x46, 0xf4, 0xad, 0xb3, 0x5d, 0xef, 0x44, 0xf2, 0xe6, 0x38, 0x2f, 0xd7, 0x08, 0x15, 0xc7,
	0x89, 0x9a, 0xf1, 0x93, 0x1c, 0xe4, 0xc5, 0x7b, 0xa7, 0x6e, 0xdd, 0x32, 0xcc, 0x7b, 0xfe, 0x49,
	0xb4, 0x6f, 0x0b, 0xe3, 0x51, 0x59, 0x00, 0x58, 0x3c, 0xd0, 0x03, 0x58, 0xee, 0xf3, 0x91, 0x04,
	0x98, 0xf4, 0x3d, 0x2a, 0xb6, 0x6e, 0x31, 0xcd, 0xc6, 0x09, 0x1a, 0xb6, 0x08, 0xd5, 0xab, 0xe3,
	0x51, 0x39, 0xc9, 0x8a, 0x93, 0x55, 0x74, 0x00, 0x4b, 0xe4, 0x11, 0x61, 0x9e, 0x4a, 0x48, 0xce,
	0x5d, 0x52, 0x32, 0x7f, 0x6d, 0x95, 0x13, 0x27, 0x6a, 0x4c, 0xbb, 0x02, 0x6a, 0xd9, 0x0f, 0x77,
	0xba, 0xdc, 0x34, 0x64, 0x85, 0x76, 0x49, 0x08, 0x87, 0x05, 0x74, 0x3b, 0xb2, 0x89, 0x79, 0x6e,
	0xb6, 0x8d, 0xe9, 0x1d, 0x8b, 0x09, 0x94, 0x96, 0x91, 0x6f, 0x16, 0xc1, 0x15, 0xda, 0x47, 0x61,
	0x19, 0xac, 0xe0, 0xa2, 0x65, 0x60, 0x08, 0x96, 0x4f, 0xd6, 0x57, 0x8f, 0xab, 0x1e, 0xb7, 0x0c,
	0xc5, 0xd9, 0x7d, 0x09, 0x25, 0x15, 0x72, 0x04, 0x17, 0x96, 0xcf, 0x67, 0xbf, 0x71, 0xfe, 0x48,
	0x03, 0x88, 0xa7, 0x36, 0xb2, 0xcf, 0xda, 0x54, 0xfb, 0xfc, 0x22, 0x64, 0x87, 0x7e, 0x4f, 0x3a,
	0xed, 0x85, 0xf1, 0xa8, 0xcc, 0xaa, 0x98, 0xfd, 0xb0, 0x1e, 0x87, 0x01, 0xf1, 0x15, 0xe3, 0xce,
	0x7b, 0x0c, 0x31, 0x1c, 0x95, 0x18, 0xe5, 0xc0, 0x0a, 0x82, 0x4f, 0x3c, 0xbf, 0xcb, 0x57, 0x5c,
	0x52, 0x86, 0x18, 0x8e, 0x4a, 0xcc, 0x0b, 0x16, 0xf9, 0xf6, 0x91, 0x06, 0xae, 0x0a, 0x05, 0x6f,
	0x40, 0x7c, 0x8b, 0x86, 0xf1, 0xc5, 0xca, 0xd6, 0x6b, 0xd3, 0xe7, 0x91, 0x73, 0xb5, 0x42, 0x5a,
	0x1c, 0xb3, 0x31, 0x0f, 0xca, 0x03, 0x2c, 0xe9, 0x07, 0x5f, 0x9a, 0xc1, 0x1f, 0x7a, 0x50, 0x4e,
	0x6f, 0x3c, 0xd1, 0x60, 0x41, 0x8c, 0x23, 0x40, 0x3b, 0x17, 0x82, 0xbc, 0x57, 0x66, 0x48, 0x11,
	0x3c, 0xa9, 0x61, 0xde, 0x9d, 0x8b, 0x61, 0xde, 0x8d, 0x59, 0x9a, 0x91, 0x1e, 0xe3, 0x31, 0x2b,
	0xe5, 0x04, 0x75, 0xd2, 0xa3, 0xd6, 0x6d, 0xc7, 0x0f, 0x68, 0xd5, 0xa2, 0xf6, 0x29, 0x5f, 0x89,
	0x45, 0x61, 0xa5, 0x26, 0x1a, 0xf1, 0x24, 0x64, 0xfc, 0xb9, 0x06, 0x4b, 0x95, 0xee, 0xb6, 0x67,
	0x87, 0x61, 0x94, 0x09, 0x60, 0xb1, 0x3a, 0x7f, 0x15, 0x19, 0x75, 0xa4, 0x6c, 0xd0, 0x4a, 0x44,
	0x57, 0x45, 0x72, 0x94, 0x0a, 0x2f, 0x56, 0xca, 0xa8, 0x0e, 0x79, 0x31, 0xec, 0xd9, 0xd1, 0x88,
	0x7c, 0x67, 0x36, 0x75, 0x1a, 0x9b, 0x3a, 0xc1, 0x83, 0xe5, 0xd3, 0xb8, 0x0d, 0xf3, 0xdc, 0xce,
	0x7d, 0x89, 0xd2, 0x96, 0x61, 0xfe, 0x91, 0xd5, 0x1b, 0xca, 0x18, 0x4b, 0x58, 0x38, 0x0e, 0x60,
	0xf1, 0x30, 0x7e, 0x3e, 0x0f, 0xf3, 0x62, 0x5c, 0x5f, 0x3d, 0xbe, 0x79, 0x13, 0x0a, 0xc7, 0xbe,
	0x88, 0x0f, 0xcf, 0xa5, 0x81, 0xe7, 0x8e, 0x25, 0x02, 0x71, 0x5c, 0xe4, 0xa1, 0xc0, 0xf1, 0x71,
	0x40, 0xa8, 0x34, 0xe7, 0x22, 0x14, 0xe0, 0x08, 0x96, 0x4f, 0xb6, 0xe1, 0xa9, 0xd3, 0x27, 0xde,
	0x90, 0xaa, 0xb6, 0x4c, 0x42, 0x38, 0x2c, 0x30, 0x32, 0xe2, 0x5a, 0x47, 0x3d, 0xd2, 0xe5, 0xc6,
	0x6c, 0x51, 0x90, 0x49, 0x08, 0x87, 0x05, 0x25, 0x12, 0x5a, 0xf8, 0xd5, 0x23, 0xa1, 0x7b, 0xb0,
	0x18, 0x10, 0x4a, 0x1d, 0xf7, 0x24, 0xb4, 0x66, 0xaf, 0xce, 0xd0, 0xff, 0x8e, 0x24, 0xad, 0xea,
	0x52, 0x5c, 0xc4, 0x8c, 0xa3, 0x12, 0x0f, 0x9c, 0x58, 0x84, 0x19, 0x94, 0x0a, 0xeb, 0xd9, 0x70,
	0x26, 0x04, 0x82, 0xe5, 0x93, 0xd1, 0x50, 0xcb, 0x3f, 0x21, 0x94, 0x87, 0x43, 0xd2, 0xcc, 0x0a,
	0x04, 0xcb, 0x27, 0x33, 0x50, 0x1f, 0x79, 0x47, 0x32, 0xfc, 0xe1, 0x06, 0xea, 0x23, 0xef, 0x08,
	0xb3, 0x1f, 0xf4, 0x5d, 0xd0, 0x8f, 0xac, 0xc0, 0xb1, 0x85, 0x5b, 0x0d, 0x5a, 0x6e, 0xef, 0x9c,
	0x07, 0x40, 0x8b, 0xd5, 0xeb, 0xe3, 0x51, 0x79, 0xa2, 0x0d, 0x4f, 0x20, 0x4c, 0x82, 0xd5, 0x23,
	0x3e, 0xed, 0x10, 0x37, 0x70, 0xa8, 0xf3, 0xc8, 0xa1, 0xe7, 0x32, 0x34, 0xe2, 0x12, 0x2e, 0xb6,
	0xe1, 0x09, 0xe4, 0xd9, 0x5b, 0xef, 0xcf, 0x32, 0x00, 0xf1, 0xbe, 0x53, 0xf4, 0xb7, 0xf0, 0x2b,
	0xea, 0xaf, 0xa2, 0x6e, 0xd9, 0x19, 0xea, 0xa6, 0xaa, 0x40, 0xee, 0x59, 0xab, 0xc0, 0xfc, 0x25,
	0x54, 0x20, 0x9f, 0xa6, 0x02, 0xc6, 0xcf, 0xe6, 0x61, 0x39, 0xd1, 0x2b, 0xfa, 0x00, 0x72, 0x03,
	0xc7, 0x3d, 0x91, 0xd6, 0x2b, 0xc5, 0xf3, 0xb2, 0xb3, 0x63, 0x34, 0x4e, 0x34, 0x1e, 0x95, 0x57,
	0x18, 0xcf, 0x5b, 0x5e, 0xdf, 0xa1, 0xa4, 0x3f, 0xa0, 0xe7, 0x98, 0xcb, 0x60, 0xb2, 0x4e, 0x29,
	0x1d, 0x48, 0xbb, 0x95, 0x22, 0x6b, 0x9b, 0xd2, 0x41, 0x52, 0x16, 0xe3, 0x51, 0x65, 0xb1, 0x3a,
	0xba, 0x0d, 0xd9, 0xae, 0x1b, 0xc8, 0x78, 0x2a, 0xc5, 0x85, 0xd4, 0xdd, 0x20, 0x92, 0xc4, 0x03,
	0xaa, 0xae, 0x1b, 0x28, 0x82, 0x98, 0x00, 0x26, 0x87, 0xda, 0x03, 0xb9, 0x0e, 0x29, 0x72, 0x4c,
	0x7b, 0x90, 0x94, 0x43, 0x6d, 0x75, 0x40, 0x4c, 0x00, 0x3a, 0x02, 0xa0, 0xbe, 0x65, 0x13, 0xdf,
	0x1b, 0x52, 0x71, 0xa8, 0x2a, 0x6e, 0x6d, 0xa4, 0x88, 0x8b, 0xe8, 0x22, 0xa9, 0xa5, 0xf1, 0xa8,
	0x7c, 0x3d, 0xe6, 0x57, 0x84, 0x2b, 0x52, 0xd1, 0x87, 0xb0, 0x18, 0xc8, 0xc0, 0x98, 0xaf, 0x61,
	0x71, 0xeb, 0xf5, 0x94, 0x93, 0xa8, 0xa4, 0x8a, 0xe4, 0x3f, 0x3f, 0x1e, 0x95, 0x51, 0xc8, 0xab,
	0x48, 0x8f, 0xe4, 0xa1, 0xdf, 0x86, 0x42, 0x7f, 0xd8, 0xa3, 0x0e, 0x5f, 0xa0, 0x05, 0x2e, 0xfc,
	0x6b, 0xd3, 0x85, 0xef, 0x31, 0xb2, 0xc4, 0x2a, 0xbd, 0x30, 0x1e, 0x95, 0xaf, 0x45, 0xdc, 0x8a,
	0xf8, 0x58, 0x24, 0x5b, 0xfb, 0x13, 0x7f, 0x60, 0xcf, 0x8e, 0xe0, 0xee, 0xf8, 0x03, 0x3b, 0xb9,
	0xf6, 0x8c, 0x47, 0x5d, 0x7b, 0x56, 0x7f, 0x3f, 0xf7, 0xf8, 0x27, 0x65, 0xcd, 0xf8, 0x65, 0x06,
	0x96, 0x54, 0xc5, 0x43, 0xbb, 0x50, 0x70, 0x06, 0x6a, 0x06, 0x65, 0x25, 0x2d, 0xed, 0xb3, 0x13,
	0x92, 0x09, 0xff, 0x12, 0x71, 0xe1, 0xb8, 0x88, 0xee, 0xc0, 0x95, 0xc0, 0x1b, 0xfa, 0x36, 0xd9,
	0x19, 0x54, 0xba, 0x5d, 0x9f, 0x04, 0x81, 0xf4, 0x81, 0x2f, 0x8f, 0x47, 0xe5, 0x17, 0x2f, 0x34,
	0x29, 0x43, 0xbc, 0xc8, 0x85, 0xbe, 0x0d, 0xc5, 0x81, 0x75, 0xde, 0xf3, 0xac, 0x6e, 0xc7, 0xf9,
	0x94, 0x48, 0xcb, 0xf0, 0xe2, 0x78, 0x54, 0x7e, 0x4e, 0x81, 0x15, 0x01, 0x2a, 0x35, 0x3b, 0xba,
	0x74, 0x3d, 0x97, 0xde, 0xf6, 0xad, 0x93, 0x3e, 0x71, 0x85, 0xaf, 0x5b, 0x14, 0x31, 0xbc, 0x8a,
	0xe3, 0x44, 0x0d, 0x6d, 0xb1, 0x2e, 0xed, 0x87, 0x84, 0xd6, 0xbc, 0xa1, 0x4b, 0x4b, 0x3f, 0x5c,
	0xe0, 0x7d, 0x5e, 0x19, 0x8f, 0xca, 0x2a, 0x8e, 0xd5, 0x8a, 0xf1, 0x1f, 0xcb, 0xb0, 0xa4, 0xae,
	0xea, 0x33, 0x9e, 0xce, 0x3a, 0xe4, 0xfb, 0x84, 0x9e, 0x7a, 0xc2, 0x86, 0xa6, 0xa6, 0x79, 0xd8,
	0x08, 0xf6, 0x38, 0x9d, 0xb0, 0x4f, 0x82, 0x07, 0xcb, 0x27, 0x7a, 0x1b, 0x16, 0x4e, 0x89, 0xd5,
	0x25, 0x3e, 0xdb, 0xf9, 0xd9, 0x8d, 0x82, 0x88, 0xce, 0x24, 0xa4, 0xcc, 0x61, 0x48, 0x85, 0x5e,
	0x87, 0xdc, 0x91, 0xd7, 0x3d, 0x97, 0xb1, 0x32, 0x57, 0x29, 0x56, 0x57, 0x55, 0x8a, 0xd5, 0x59,
	0x00, 0xe8, 0x7a, 0xb7, 0xbd, 0x5e, 0xcf, 0xfb, 0x04, 0x93, 0xae, 0xe3, 0x13, 0x9b, 0x06, 0x7c,
	0x17, 0xcb, 0x00, 0x70, 0xa2, 0x11, 0x4f, 0x42, 0xe8, 0x00, 0x0a, 0xb4, 0x17, 0xd4, 0x3c, 0xf7,
	0xd8, 0x39, 0xe1, 0x3e, 0x2a, 0x35, 0xef, 0x68, 0xee, 0x76, 0x04, 0x99, 0xd8, 0x3b, 0x11, 0x97,
	0xba, 0x77, 0x22, 0x90, 0xc9, 0xe5, 0xfe, 0xb4, 0x32, 0xa4, 0xa7, 0xdc, 0xa7, 0xa5, 0xca, 0xad,
	0x86, 0x64, 0x42, 0x6e, 0xc4, 0xa5, 0xca, 0x8d, 0x40, 0xa6, 0x99, 0x47, 0xc4, 0xf2, 0x89, 0x6f,
	0x7a, 0x0f, 0x89, 0x5b, 0x3a, 0xe6, 0x73, 0xc4, 0x35, 0x53, 0x81, 0x55, 0xcd, 0x54, 0x60, 0xb4,
	0x05, 0x8b, 0x03, 0xdf, 0x3b, 0x3b, 0xdf, 0xc7, 0xbb, 0xa5, 0x13, 0xce, 0xc9, 0x8d, 0x4c, 0x88,
	0xa9, 0x46, 0x26, 0xc4, 0xd0, 0x11, 0x2c, 0x79, 0xd6, 0x90, 0x9e, 0x6e, 0xc9, 0x39, 0x3a, 0x9d,
	0x65, 0x0c, 0x5a, 0x95, 0x98, 0xb2, 0xba, 0x3a, 0x1e, 0x95, 0x9f, 0x57, 0x79, 0x15, 0xf9, 0x09,
	0x99, 0xa8, 0x03, 0xd7, 0x78, 0x7f, 0x35, 0xcf, 0x75, 0x89, 0x4d, 0xb7, 0xa5, 0xba, 0x38, 0x5c,
	0x5d, 0x5e, 0x19, 0x8f, 0xca, 0x2f, 0x4f, 0x69, 0x56, 0xa4, 0x4d, 0xe3, 0x46, 0x6f, 0x41, 0xe1,
	0xd8, 0x72, 0x7a, 0x3b, 0xc7, 0x9d, 0xce, 0x6e, 0xe9, 0xb1, 0xc6, 0xf5, 0x42, 0x84, 0xa6, 0x21,
	0x8a, 0xe3, 0x22, 0x7a, 0x17, 0x96, 0x44, 0xa5, 0xe9, 0x51, 0xc6, 0xf0, 0x77, 0x5a, 0xbc, 0x6b,
	0xd5, 0x06, 0x9c, 0xa8, 0xa1, 0xbb, 0xa0, 0x3f, 0xb2, 0x7a, 0x4e, 0x37, 0x4e, 0x75, 0x06, 0xa5,
	0xbf, 0x67, 0x67, 0xa4, 0xf9, 0xea, 0xda, 0x78, 0x54, 0x5e, 0xbd, 0xd8, 0xa8, 0x0c, 0x7a, 0x82,
	0x11, 0x35, 0xe1, 0x2a, 0xc7, 0xb6, 0x4d, 0xb3, 0x2d, 0xf7, 0x60, 0x50, 0xfa, 0x07, 0x8d, 0xcf,
	0x42, 0x79, 0x3c, 0x2a, 0xbf, 0x34, 0xd1, 0xaa, 0x88, 0x9b, 0x64, 0x45, 0xbf, 0x03, 0x2f, 0x88,
	0xc1, 0x56, 0xbd, 0xee, 0xf9, 0x1e, 0x3b, 0xef, 0x90, 0x00, 0x93, 0x13, 0x72, 0x36, 0x28, 0xfd,
	0x52, 0x48, 0xbd, 0x39, 0x1e, 0x95, 0x5f, 0x49, 0xa1, 0x51, 0x64, 0xa7, 0x89, 0x41, 0x0e, 0xac,
	0xc6, 0x4d, 0x4d, 0x8f, 0x26, 0x3b, 0xf9, 0x47, 0xd1, 0xc9, 0xc6, 0x78, 0x54, 0x7e, 0x2d, 0x9d,
	0x4c, 0xe9, 0x67, 0x86, 0x30, 0xf4, 0xfb, 0x1a, 0xbc, 0x28, 0x9a, 0xc5, 0x02, 0x27, 0xbb, 0xfa,
	0xa7, 0x99, 0xe7, 0x52, 0x85, 0xa3, 0xfa, 0xa6, 0x0c, 0xc9, 0x5e, 0x4d, 0x15, 0xa6, 0x0c, 0x28,
	0xbd, 0x47, 0xf4, 0x87, 0x1a, 0xdc, 0x50, 0x5b, 0x27, 0xde, 0xfe, 0x9f, 0x2f, 0x3d, 0xa4, 0x5b,
	0x72, 0x48, 0xaf, 0xcf, 0x92, 0xa7, 0x8c, 0x6a, 0x66, 0xbf, 0xe8, 0x14, 0x8a, 0xb6, 0xd7, 0x1f,
	0x30, 0x3f, 0xc6, 0xbc, 0xc0, 0xe7, 0xc2, 0x0d, 0x6c, 0xa6, 0x84, 0xab, 0x31, 0x65, 0xa5, 0x77,
	0xe2, 0xf9, 0x0e, 0x3d, 0xed, 0x0b, 0x73, 0xa2, 0xc8, 0x50, 0xcd, 0x89, 0x02, 0xb3, 0xd5, 0xb7,
	0x2d, 0xfb, 0x94, 0x54, 0x87, 0x01, 0x73, 0x3f, 0xf7, 0x86, 0xc4, 0x3f, 0x6f, 0x5b, 0xbe, 0xd5,
	0x6f, 0xb2, 0xc3, 0xe9, 0x0f, 0x45, 0x72, 0x88, 0xaf, 0x7e, 0x3a, 0x99, 0xba, 0xfa, 0xe9, 0x54,
	0xc6, 0x2f, 0xb2, 0xb0, 0xa4, 0x1a, 0x17, 0x16, 0xe1, 0xdb, 0x3d, 0x87, 0xf0, 0x08, 0x5f, 0x8b,
	0x93, 0x2a, 0x21, 0x86, 0xa3, 0x12, 0x73, 0xc7, 0xa2, 0xdc, 0x21, 0xb6, 0x4f, 0xc2, 0x2f, 0x30,
	0x7c, 0x63, 0xab, 0x38, 0x4e, 0xd4, 0xf8, 0x09, 0x82, 0xd9, 0x4c, 0x66, 0x2a, 0x95, 0xf4, 0x4e,
	0x88, 0xe1, 0xa8, 0x84, 0xde, 0x82, 0x7c, 0x60, 0x7b, 0x03, 0xc2, 0x0e, 0x06, 0xd9, 0xf0, 0x6c,
	0x24, 0x10, 0xe5, 0xe5, 0x24, 0x0d, 0x22, 0xb0, 0x42, 0xdc, 0xee, 0xc0, 0x73, 0x5c, 0xca, 0xdf,
	0x4e, 0x44, 0xff, 0x5f, 0x72, 0x30, 0x5d, 0x97, 0x0a, 0x52, 0x4a, 0xb2, 0x2a, 0xe2, 0x2f, 0x08,
	0x4d, 0xba, 0xb5, 0xfc, 0xb3, 0x73, 0x6b, 0xaa, 0x07, 0x59, 0xb8, 0x9c, 0x07, 0x31, 0x7e, 0xa6,
	0x41, 0x51, 0x51, 0x77, 0x36, 0x61, 0xc2, 0xd5, 0xcb, 0x85, 0xe3, 0x13, 0x26, 0x10, 0x75, 0xc2,
	0x04, 0xc2, 0xa8, 0x7d, 0xb1, 0xa1, 0x32, 0x31, 0xb5, 0x7f, 0x71, 0x4b, 0x48, 0x1a, 0xf4, 0x9b,
	0xb0, 0x64, 0x31, 0x07, 0xbf, 0xe7, 0x04, 0x01, 0x3b, 0x02, 0x89, 0x7c, 0x10, 0xf7, 0x44, 0x2a,
	0xae, 0x7a, 0x22, 0x15, 0x37, 0xfe, 0x56, 0x83, 0x95, 0x7a, 0xb3, 0x83, 0xf1, 0x01, 0xb3, 0xa6,
	0x16, 0xf5, 0x7c, 0xe6, 0x9c, 0xc4, 0x7e, 0x4b, 0x6e, 0x6f, 0x2d, 0x76, 0x4e, 0x53, 0x9a, 0x55,
	0xe7, 0x34, 0xa5, 0x19, 0x7d, 0x0f, 0x9e, 0x8f, 0xfc, 0x48, 0x52, 0x6e, 0x86, 0xcb, 0x7d, 0x6d,
	0x3c, 0x2a, 0xaf, 0x4f, 0xa7, 0x50, 0x44, 0xa7, 0xc8, 0x30, 0xfe, 0x22, 0x0f, 0x45, 0xe5, 0x20,
	0xf5, 0xeb, 0x1a, 0x65, 0x1b, 0x90, 0x0f, 0x88, 0xff, 0x88, 0xf8, 0x72, 0x87, 0x89, 0x5c, 0x33,
	0x47, 0xb0, 0x7c, 0xa2, 0x1b, 0x90, 0x1b, 0x78, 0xbe, 0x08, 0xa2, 0xe7, 0x45, 0xaa, 0x8b, 0xd5,
	0x31, 0xff, 0x45, 0x1d, 0x00, 0x9f, 0xd8, 0x9e, 0xdf, 0x35, 0xcf, 0x07, 0xe2, 0x04, 0xb7, 0x92,
	0x76, 0x30, 0xaf, 0xbb, 0x01, 0x8e, 0x48, 0xc5, 0xb7, 0x9a, 0x98, 0x15, 0x2b, 0x65, 0x74, 0x97,
	0xeb, 0x38, 0xf5, 0x6c, 0xaf, 0x27, 0x13, 0xe5, 0xe9, 0x67, 0xd5, 0xb6, 0x24, 0x94, 0x29, 0x5d,
	0x59, 0xc3, 0x51, 0x09, 0xfd, 0x06, 0x14, 0xb9, 0x63, 0xc6, 0x22, 0x36, 0x78, 0x2c, 0xd4, 0x86,
	0x5b, 0x58, 0x05, 0x57, 0x2d, 0xac, 0x02, 0x23, 0x17, 0x56, 0x1e, 0x09, 0x45, 0x24, 0x15, 0x37,
	0xf8, 0x84, 0xf8, 0x22, 0x2e, 0x29, 0xa6, 0xa5, 0x81, 0x93, 0xaa, 0xab, 0x04, 0x0d, 0x91, 0x00,
	0x8c, 0x3b, 0xaa, 0xd9, 0x48, 0x36, 0xa2, 0x4f, 0x64, 0x04, 0xc2, 0x90, 0x21, 0x3d, 0x65, 0xfe,
	0xe0, 0x9c, 0xc5, 0x33, 0x97, 0xef, 0xd2, 0x18, 0x8f, 0xca, 0x6b, 0x13, 0x32, 0x92, 0xbd, 0x4e,
	0xf6, 0x81, 0x3e, 0x05, 0x14, 0x81, 0xdd, 0xae, 0x43, 0x1d, 0xcf, 0xb5, 0x7a, 0x2c, 0xf6, 0xb9,
	0x7c, 0xcf, 0xaf, 0x8e, 0x47, 0xe5, 0xf2, 0xa4, 0x90, 0x64, 0xd7, 0x53, 0x7a, 0x31, 0x3e, 0xcb,
	0x42, 0x51, 0x49, 0x17, 0xfc, 0xba, 0xee, 0x96, 0x57, 0x21, 0x4b, 0xe5, 0x47, 0xb4, 0x45, 0x99,
	0xd2, 0xe8, 0x25, 0x52, 0x23, 0xb4, 0x77, 0xc1, 0xee, 0xe7, 0x9e, 0x9d, 0xdd, 0xef, 0xc3, 0xf2,
	0xc7, 0xcc, 0x23, 0x87, 0x97, 0x06, 0xa4, 0xd7, 0x4a, 0xc9, 0x65, 0x98, 0xb5, 0xf6, 0x3d, 0x95,
	0xba, 0x5a, 0x96, 0x0e, 0xec, 0x85, 0x84, 0x10, 0xa5, 0xab, 0xa4, 0x74, 0xe3, 0x77, 0x35, 0xd0,
	0x2f, 0x0a, 0x61, 0xa6, 0x20, 0x20, 0xae, 0x70, 0xf7, 0x4b, 0xc2, 0x14, 0xb0, 0x3a, 0xe6, 0xbf,
	0xcc, 0x98, 0x90, 0xb3, 0x01, 0xb1, 0x85, 0x83, 0x5f, 0x12, 0xc6, 0x44, 0x20, 0x58, 0x3e, 0x99,
	0xf7, 0x0a, 0xa8, 0xe5, 0x53, 0x73, 0xb7, 0x23, 0xe7, 0x51, 0x24, 0x59, 0x24, 0x96, 0x48, 0xb2,
	0x48, 0xcc, 0xf8, 0xeb, 0x0c, 0x14, 0xa2, 0xb9, 0x42, 0x6d, 0x40, 0x8e, 0x1b, 0x10, 0x7b, 0xe8,
	0x93, 0xce, 0x43, 0xbe, 0xc8, 0xce, 0xf1, 0x79, 0x49, 0x9c, 0x15, 0xd6, 0xc7, 0xa3, 0xf2, 0x8d,
	0xc9, 0x56, 0x55, 0xfb, 0x26, 0x5b, 0x99, 0x7f, 0xab, 0x55, 0x6a, 0xc4, 0x0f, 0xc7, 0xcd, 0xfd,
	0x9b, 0x6d, 0x31, 0x44, 0xf5, 0x6f, 0x82, 0x06, 0x7d, 0x0b, 0x40, 0x84, 0x29, 0x9c, 0x23, 0xcb,
	0x39, 0x78, 0x22, 0x2a, 0x46, 0xd5, 0x44, 0x54, 0x8c, 0xa2, 0x77, 0xa1, 0x20, 0x6a, 0x77, 0x89,
	0x38, 0x5a, 0x2f, 0x89, 0x85, 0x8f, 0x40, 0x75, 0xe1, 0x23, 0x90, 0x75, 0x28, 0x2c, 0x31, 0x8f,
	0xe9, 0xe6, 0xb9, 0xe6, 0xf2, 0x0e, 0x63, 0x54, 0xed, 0x30, 0x46, 0x8d, 0x00, 0x0a, 0xd1, 0xd1,
	0x96, 0xcd, 0x7c, 0xf4, 0xb5, 0x4c, 0x8b, 0xe3, 0x86, 0x10, 0x53, 0x67, 0x3e, 0xfa, 0x6e, 0xb6,
	0xa5, 0x7c, 0x37, 0xcb, 0x28, 0xb1, 0x86, 0xc4, 0x12, 0xb1, 0x46, 0xf8, 0x05, 0xed, 0x5f, 0x34,
	0x40, 0x93, 0xb9, 0x3a, 0x74, 0x13, 0x16, 0xfa, 0xd6, 0xd9, 0xb6, 0x37, 0x08, 0x3f, 0x7e, 0xf3,
	0x2c, 0xaf, 0x84, 0x70, 0x58, 0x40, 0xef, 0xc3, 0x4a, 0xdf, 0x3a, 0xdb, 0x77, 0x1f, 0xba, 0xde,
	0x27, 0x2e, 0xa7, 0x16, 0xc9, 0x63, 0x9e, 0x83, 0x48, 0xb6, 0xe0, 0x0b, 0x75, 0xf4, 0x26, 0x14,
	0x06, 0xd4, 0xdf, 0xf5, 0xbc, 0x87, 0xc3, 0x81, 0x54, 0x2e, 0x6e, 0x14, 0x22, 0x10, 0xc7, 0x45,
	0x74, 0x0b, 0xe0, 0xd4, 0x1b, 0x98, 0x32, 0xf1, 0x2c, 0x3e, 0x86, 0x70, 0x97, 0x14, 0xa3, 0x58,
	0x29, 0x1b, 0xef, 0x81, 0x7e, 0x31, 0x3f, 0xc8, 0xbd, 0x27, 0xc7, 0xe4, 0x86, 0x10, 0xde, 0x93,
	0x23, 0x58, 0x3e, 0x8d, 0x3f, 0xd5, 0xe0, 0xea, 0x44, 0xee, 0x0f, 0xdd, 0x85, 0x05, 0xe2, 0x52,
	0xdf, 0x21, 0xe1, 0xe7, 0xbc, 0xd7, 0xbe, 0x24, 0x6b, 0xd8, 0x70, 0xa9, 0x7f, 0x1e, 0x7e, 0x61,
	0xe1, 0x8c, 0x38, 0x2c, 0xa0, 0x1a, 0x2c, 0xf5, 0xbc, 0xe8, 0x32, 0x91, 0x98, 0xb1, 0x45, 0xe1,
	0x79, 0x14, 0xbc, 0xea, 0x75, 0x9d, 0x84, 0x9b, 0x4b, 0x30, 0x19, 0x3f, 0xcf, 0xc0, 0x4a, 0xb2,
	0x37, 0xf4, 0x3d, 0x58, 0xf0, 0xc5, 0x37, 0x39, 0x99, 0xc7, 0x7e, 0xf3, 0x32, 0x83, 0x94, 0x9f,
	0xf1, 0x44, 0x02, 0x48, 0xf2, 0xab, 0x39, 0x26, 0x09, 0x21, 0x1b, 0xc0, 0x0a, 0x02, 0xe2, 0x53,
	0x7e, 0xc6, 0x16, 0x1f, 0x22, 0xff, 0xdf, 0x65, 0x3a, 0xa8, 0x84, 0x5c, 0x72, 0xa3, 0xf2, 0x8f,
	0x9a, 0xea, 0x0e, 0x88, 0xc5, 0x22, 0x1b, 0x0a, 0x8f, 0x2c, 0xdf, 0xb1, 0x8e, 0x7a, 0x44, 0xe4,
	0xbe, 0x8a, 0x5b, 0x6f, 0x5d, 0xa6, 0x8f, 0x03, 0xc9, 0x24, 0x36, 0x68, 0x24, 0x42, 0xdd, 0xa0,
	0x11, 0x68, 0xdc, 0x05, 0x60, 0x8c, 0x22, 0xc0, 0xfe, 0xaa, 0x5f, 0x06, 0xef, 0x02, 0x70, 0x9b,
	0x7b, 0xdb, 0x21, 0xbd, 0xee, 0x57, 0x15, 0xf6, 0xdf, 0x19, 0x78, 0x6e, 0xea, 0xea, 0x28, 0x89,
	0x45, 0xed, 0x2b, 0x24, 0x16, 0x67, 0x7c, 0x9c, 0xbf, 0x97, 0xcc, 0x39, 0x16, 0x67, 0xf5, 0x20,
	0x66, 0xee, 0x4b, 0xb3, 0x92, 0xdf, 0x87, 0xe2, 0xc7, 0xd1, 0xd4, 0x88, 0xb3, 0x5e, 0xaa, 0xd8,
	0x78, 0x0e, 0x45, 0xa4, 0xa7, 0x30, 0xaa, 0x91, 0x9e, 0x02, 0xa3, 0x3d, 0x99, 0xf4, 0x14, 0x5f,
	0x21, 0x6e, 0xa6, 0x0f, 0x37, 0xd4, 0x70, 0xaf, 0x7b, 0x9e, 0x9e, 0x1b, 0x35, 0xfe, 0x4a, 0x83,
	0x2b, 0x17, 0xa8, 0xd1, 0x37, 0xa0, 0x68, 0x7b, 0x2e, 0x25, 0x2e, 0xe5, 0xd1, 0xb2, 0x58, 0x55,
	0x9e, 0x60, 0x56, 0x60, 0xac, 0x56, 0x58, 0xf0, 0x22, 0xab, 0x0d, 0xd7, 0xf6, 0xba, 0xec, 0x44,
	0xa5, 0x04, 0x2f, 0x17, 0x9a, 0xd4, 0xe0, 0xe5, 0x42, 0x13, 0x33, 0xc0, 0x32, 0x45, 0x2e, 0x9d,
	0x16, 0x37, 0x26, 0x12, 0xc2, 0x61, 0xc1, 0xf8, 0xcb, 0x2c, 0xbc, 0x90, 0xb2, 0xdf, 0x50, 0x0b,
	0x72, 0x34, 0x1c, 0xf7, 0xca, 0xd6, 0x37, 0x9e, 0x6a, 0xb3, 0xf2, 0x98, 0x9f, 0x2b, 0x30, 0x13,
	0x81, 0xf9, 0x2f, 0xea, 0xc1, 0x42, 0x30, 0x3c, 0xfa, 0x28, 0x0c, 0x19, 0x56, 0xb6, 0xbe, 0xfd,
	0x54, 0x32, 0x3b, 0x82, 0x97, 0x6f, 0x56, 0x57, 0x5a, 0x1c, 0x29, 0x4f, 0xd5, 0x1f, 0x09, 0x21,
	0x0a, 0x05, 0xdb, 0x73, 0x45, 0xd0, 0xc9, 0xe7, 0x60, 0x65, 0xeb, 0x3b, 0x4f, 0xd5, 0x5f, 0x2d,
	0xe4, 0x0e, 0x7b, 0x14, 0xee, 0x3b, 0x44, 0x13, 0xee, 0x3b, 0x04, 0x99, 0xfb, 0x26, 0x67, 0x51,
	0x2e, 0x28, 0x17, 0xbb, 0xef, 0x18, 0x55, 0x8d, 0x57, 0x8c, 0xa2, 0x37, 0xc2, 0xed, 0x2d, 0x7c,
	0x3e, 0xbf, 0xb5, 0xc5, 0x01, 0x85, 0x5e, 0x6e, 0xf4, 0x1f, 0x64, 0xe0, 0xf9, 0xe9, 0x16, 0x0c,
	0x35, 0x13, 0x8b, 0xf6, 0xf5, 0xa7, 0xb1, 0x7e, 0x53, 0xd7, 0xec, 0x75, 0x69, 0x92, 0x32, 0xf1,
	0xb7, 0x81, 0x0b, 0xf1, 0x83, 0x30, 0x4e, 0xc9, 0xf7, 0xce, 0x3e, 0xc5, 0x7b, 0xbf, 0x0b, 0x05,
	0x8b, 0x52, 0xdf, 0x39, 0x1a, 0xca, 0x0b, 0x5a, 0x05, 0x31, 0xd1, 0x11, 0xa8, 0x4e, 0x74, 0x04,
	0x1a, 0x3f, 0xce, 0xc0, 0x92, 0xfa, 0x29, 0xec, 0x19, 0x9f, 0x22, 0xde, 0x86, 0x05, 0x16, 0x5a,
	0x39, 0x76, 0xf8, 0xea, 0x42, 0xdd, 0x04, 0x94, 0x50, 0x37, 0x01, 0xfd, 0x9f, 0x9e, 0x16, 0x8c,
	0x5f, 0x68, 0x70, 0x05, 0xf3, 0x1b, 0xa2, 0x26, 0xe9, 0x91, 0x3e, 0x61, 0xfe, 0x7c, 0x03, 0x16,
	0x1d, 0x37, 0xa0, 0x56, 0x78, 0xcb, 0x58, 0x26, 0xd4, 0x42, 0x0c, 0x47, 0x25, 0x46, 0x29, 0xae,
	0x97, 0xca, 0x8f, 0xf7, 0xf3, 0x82, 0x32, 0xc4, 0x70, 0x54, 0x42, 0x18, 0x0a, 0x34, 0xec, 0x40,
	0x1a, 0xfa, 0x9b, 0xb3, 0x6e, 0xd6, 0x44, 0xa3, 0x11, 0x33, 0x1d, 0xf1, 0xe2, 0xb8, 0x68, 0xfc,
	0x81, 0x06, 0x57, 0x2e, 0x50, 0x27, 0xae, 0x13, 0x68, 0x33, 0xaf, 0x13, 0x1c, 0xa8, 0x23, 0x12,
	0x61, 0xc5, 0x1b, 0xb3, 0xee, 0x4a, 0xf5, 0xac, 0x20, 0xb8, 0xcc, 0xa8, 0x7e, 0x94, 0x81, 0x6b,
	0x53, 0x38, 0x50, 0x1b, 0xc0, 0x8e, 0xe0, 0xd9, 0xde, 0x34, 0x66, 0x17, 0xa1, 0x66, 0xcc, 0x87,
	0x95, 0x32, 0x0b, 0x4d, 0xc9, 0x19, 0xb1, 0x87, 0x61, 0x64, 0xc4, 0xe6, 0x9f, 0xd3, 0xc7, 0x28,
	0x56, 0xca, 0x6c, 0x6e, 0xba, 0x43, 0x79, 0x45, 0x2d, 0x1b, 0x5f, 0x61, 0x0e, 0x31, 0x1c, 0x95,
	0x50, 0x0d, 0xae, 0x06, 0x56, 0x7f, 0xd0, 0x23, 0xdd, 0x46, 0xdc, 0x81, 0xc8, 0xeb, 0x08, 0x6d,
	0xbe, 0xd8, 0x88, 0x27, 0x21, 0xe3, 0x01, 0x3c, 0xd7, 0x1e, 0x06, 0xa7, 0xd1, 0x0c, 0x44, 0xa7,
	0xc3, 0xef, 0x46, 0x97, 0x1b, 0xb5, 0x4b, 0x5c, 0xf8, 0x9e, 0x72, 0xad, 0x71, 0x73, 0x08, 0x10,
	0x7f, 0x8d, 0x41, 0x79, 0xc8, 0xb4, 0xee, 0xea, 0x73, 0x68, 0x19, 0x0a, 0xcd, 0x96, 0x79, 0x78,
	0xbb, 0xb5, 0xdf, 0xac, 0xeb, 0x1a, 0xba, 0x0e, 0xfa, 0x4e, 0xf3, 0xa0, 0xb2, 0xbb, 0x53, 0x3f,
	0xac, 0xe0, 0x3b, 0xfb, 0x7b, 0x8d, 0xa6, 0xa9, 0x67, 0x10, 0x82, 0x95, 0xca, 0x2e, 0x6e, 0x54,
	0xea, 0x0f, 0x0e, 0x1b, 0xf7, 0x77, 0x3a, 0x66, 0x47, 0xcf, 0x32, 0x6c, 0xa7, 0x69, 0x36, 0x70,
	0xb3, 0xb2, 0x7b, 0xd8, 0xc0, 0xb8, 0x85, 0xf5, 0x1c, 0xc3, 0x98, 0xb0, 0xca, 0xbe, 0xb9, 0xdd,
	0xc2, 0x3b, 0x1f, 0x36, 0xea, 0xfa, 0xfc, 0xe6, 0x46, 0x78, 0x55, 0x57, 0x5e, 0xad, 0x07, 0xc8,
	0x57, 0x6a, 0xe6, 0xce, 0x41, 0x43, 0x9f, 0x43, 0x4b, 0xb0, 0x58, 0xdf, 0xe9, 0x54, 0xaa, 0xbb,
	0x8d, 0xba, 0xae, 0x6d, 0xd6, 0x60, 0x25, 0x79, 0xcf, 0x8f, 0x0d, 0xae, 0xb6, 0xdd, 0xa8, 0xdd,
	0x3d, 0xac, 0xd4, 0xeb, 0xfa, 0x1c, 0xd2, 0x61, 0x49, 0x54, 0xf7, 0xdb, 0xf5, 0x8a, 0xd9, 0xd0,
	0xb5, 0x18, 0xa9, 0x37, 0x76, 0x1b, 0x66, 0x43, 0xcf, 0x6c, 0xda, 0x22, 0x5e, 0x14, 0x71, 0x15,
	0x5a, 0x80, 0xec, 0x9d, 0x86, 0xa9, 0xcf, 0xa1, 0x22, 0x2c, 0xd4, 0x5a, 0xcd, 0x66, 0xa3, 0x66,
	0xea, 0x1a, 0x1b, 0x42, 0x48, 0x8f, 0x16, 0x21, 0xb7, 0xdd, 0xa8, 0xd4, 0xf5, 0x2c, 0x23, 0x69,
	0xb5, 0xcd, 0x9d, 0x56, 0xb3, 0xa3, 0xe7, 0x18, 0xdc, 0x6e, 0x75, 0x4c, 0x7d, 0x9e, 0x89, 0x68,
	0xef, 0x9b, 0x7a, 0x1e, 0x15, 0x60, 0xde, 0xc4, 0x95, 0x5a, 0x43, 0x5f, 0xd8, 0x3c, 0x85, 0xe5,
	0x44, 0xbe, 0x8d, 0x11, 0x55, 0x9a, 0x0f, 0xf4, 0x39, 0x34, 0x0f, 0x5a, 0x45, 0xd7, 0x18, 0x7b,
	0xa5, 0x52, 0xa9, 0xe8, 0x19, 0xc6, 0x55, 0x6b, 0x56, 0xf6, 0x1a, 0x7a, 0x96, 0x4d, 0xf9, 0xde,
	0x7d, 0x3d, 0xc7, 0x9e, 0xcd, 0x8e, 0x94, 0x6c, 0x62, 0x3d, 0xcf, 0x0a, 0x9d, 0x56, 0x45, 0x5f,
	0xe0, 0x05, 0x7c, 0xa0, 0x2f, 0xb2, 0x82, 0x79, 0xdf, 0xd4, 0x0b, 0x9b, 0x65, 0x9e, 0xe9, 0x0c,
	0xd3, 0x70, 0x1c, 0xaf, 0xb5, 0xf5, 0x39, 0x56, 0xd8, 0xaf, 0xb7, 0x75, 0x6d, 0xf3, 0x35, 0x28,
	0x44, 0x06, 0x96, 0x0f, 0xc3, 0x3d, 0xd7, 0xe7, 0x58, 0x17, 0x07, 0xef, 0xe8, 0x1a, 0x7f, 0xbe,
	0xa7, 0x67, 0x36, 0xf7, 0xe0, 0xfa, 0xb4, 0x4f, 0x21, 0x6c, 0x9c, 0xae, 0xe7, 0x12, 0xb1, 0x14,
	0x4e, 0x97, 0xf0, 0x3f, 0x95, 0x88, 0xf1, 0x9f, 0x7c, 0xea, 0x0c, 0xf4, 0x0c, 0x93, 0x70, 0xe4,
	0x8b, 0xd9, 0xe9, 0x92, 0xe3, 0x9e, 0x45, 0x89, 0x9e, 0xdb, 0x1c, 0xc0, 0x4b, 0x33, 0x22, 0x11,
	0xc6, 0x6d, 0x36, 0xee, 0xb3, 0x69, 0xbf, 0x06, 0x57, 0x3e, 0xe8, 0xb4, 0x9a, 0x87, 0xed, 0x8a,
	0xb9, 0x7d, 0x78, 0x50, 0xd9, 0xdd, 0x67, 0x8b, 0xf6, 0x02, 0x5c, 0x8b, 0xc1, 0x4a, 0xa7, 0xd3,
	0xc0, 0x6c, 0xd6, 0xf5, 0x0c, 0xa3, 0xc6, 0x8d, 0x3b, 0x8d, 0xfb, 0x0a, 0x98, 0x5d, 0xcd, 0xfd,
	0xd9, 0x9f, 0xac, 0xcd, 0x6d, 0xfe, 0x40, 0x83, 0x9b, 0x97, 0x0a, 0x54, 0x98, 0x90, 0x7a, 0xe3,
	0x76, 0x65, 0x7f, 0xd7, 0x3c, 0xec, 0xec, 0x57, 0x3f, 0x60, 0x2b, 0x3e, 0xc7, 0xd4, 0x1a, 0x37,
	0x3a, 0xed, 0x56, 0xb3, 0xd3, 0x38, 0x64, 0xcb, 0xdd, 0xc0, 0x1d, 0xa1, 0xec, 0xdb, 0xa6, 0xd9,
	0x3e, 0xec, 0x98, 0x15, 0x73, 0xbf, 0x73, 0x58, 0x6b, 0xd5, 0x99, 0x46, 0x5c, 0x85, 0xe5, 0x88,
	0xb6, 0xda, 0xaa, 0x3f, 0x88, 0xc6, 0xf0, 0xc7, 0x1a, 0x7c, 0xed, 0x92, 0xc1, 0x0b, 0x7a, 0x0e,
	0xae, 0x86, 0xa3, 0xa8, 0xb5, 0x9a, 0xf5, 0x1d, 0xfe, 0x32, 0x5c, 0x83, 0xd9, 0x06, 0xa9, 0xb5,
	0x9a, 0x66, 0x65, 0xa7, 0xd9, 0x11, 0xba, 0xd8, 0xb8, 0xb7, 0x5f, 0xd9, 0xed, 0xe8, 0x19, 0x74,
	0x05, 0x8a, 0x1d, 0xb3, 0x82, 0xcd, 0xce, 0xe1, 0x6f, 0xed, 0x98, 0xdb, 0x7a, 0x96, 0xe9, 0x7f,
	0xa3, 0x59, 0x97, 0xd5, 0x1c, 0x5b, 0x03, 0xf3, 0x41, 0xbb, 0x71, 0xd8, 0xba, 0xad, 0xcf, 0xb3,
	0x05, 0x8b, 0xc4, 0xe4, 0xe5, 0x08, 0x9b, 0xb0, 0x9a, 0x1e, 0x6c, 0x30, 0x69, 0xd1, 0xbc, 0xeb,
	0x73, 0x4c, 0x33, 0xf9, 0x6c, 0xcb, 0x6d, 0xd4, 0xe9, 0x1c, 0x76, 0x1a, 0xbb, 0x8d, 0x9a, 0xd9,
	0xc2, 0x7a, 0x46, 0xca, 0xdb, 0x00, 0x88, 0xcd, 0x2a, 0xeb, 0xb1, 0x8d, 0x5b, 0x66, 0xab, 0xd6,
	0xda, 0x15, 0x0a, 0xd3, 0xa9, 0xe1, 0x9d, 0xb6, 0xc9, 0xf6, 0xee, 0xd6, 0xef, 0x65, 0x20, 0x2f,
	0x6f, 0xc6, 0x7f, 0x1f, 0x96, 0x13, 0x7f, 0x75, 0x41, 0xe5, 0x19, 0xff, 0x6a, 0xd9, 0x71, 0x8f,
	0xbd, 0xd5, 0x37, 0xd2, 0x6e, 0x88, 0x4f, 0xfc, 0x61, 0xc6, 0x98, 0x43, 0xf7, 0x00, 0xee, 0x10,
	0x1a, 0xde, 0xdc, 0x5d, 0x9f, 0x21, 0x9b, 0xff, 0x81, 0x6b, 0xf5, 0xe5, 0x34, 0x77, 0xc1, 0x05,
	0x18, 0x73, 0x5f, 0xd7, 0x58, 0xe8, 0xdd, 0x66, 0x51, 0xfc, 0x2b, 0xe9, 0x57, 0xc9, 0xe4, 0x41,
	0x63, 0x35, 0xed, 0xb6, 0x99, 0xf2, 0x87, 0x23, 0x63, 0x6e, 0xeb, 0x6f, 0x34, 0x28, 0xc6, 0xd7,
	0xf8, 0xfe, 0xd7, 0xa7, 0xc4, 0x84, 0x95, 0x3b, 0x84, 0xaa, 0x1d, 0xae, 0x4e, 0x67, 0x3f, 0xf0,
	0x9c, 0x6e, 0xda, 0x2b, 0xa8, 0xd7, 0x84, 0xd9, 0xac, 0x6c, 0xdd, 0x87, 0x05, 0x53, 0xde, 0x45,
	0xde, 0x83, 0xc2, 0x1d, 0x42, 0xe5, 0x3f, 0x0f, 0xd6, 0x67, 0x85, 0x20, 0x7c, 0xf0, 0x33, 0xaf,
	0xff, 0x1a, 0x73, 0x5b, 0x3e, 0x14, 0x62, 0x17, 0x4f, 0x60, 0x39, 0xe1, 0xf1, 0xd0, 0xcd, 0xf4,
	0x57, 0x57, 0x02, 0xae, 0xd5, 0x94, 0x7c, 0xc9, 0x54, 0xef, 0x69, 0xcc, 0x55, 0xdf, 0x7b, 0xfc,
	0xef, 0x6b, 0x73, 0x8f, 0x9f, 0xac, 0x69, 0x9f, 0x3f, 0x59, 0xd3, 0xfe, 0xed, 0xc9, 0x9a, 0xf6,
	0x9f, 0x4f, 0xd6, 0xe6, 0x3e, 0xfb, 0x62, 0x6d, 0xee, 0xf3, 0x2f, 0xd6, 0xe6, 0xfe, 0xf5, 0x8b,
	0xb5, 0xb9, 0x0f, 0xa7, 0xfe, 0x59, 0xf0, 0x28, 0xcf, 0x3f, 0x75, 0xfc, 0xff, 0xff, 0x09, 0x00,
	0x00, 0xff, 0xff, 0xaf, 0xc6, 0xf9, 0xb7, 0x59, 0x38, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ChecksClient is the client API for Checks service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ChecksClient interface {
	// RegisterProbe causes this probe to be reported as online with
	// synthetic-monitoring-api.
	//
	// The probe is identified via an authentication token provided
	// through a different channel by synthetic-monitoring-api.
	RegisterProbe(ctx context.Context, in *ProbeInfo, opts ...grpc.CallOption) (*RegisterProbeResult, error)
	// GetChanges returns a list of check operations, specifying
	// whether to add, update or delete checks.
	GetChanges(ctx context.Context, in *ProbeState, opts ...grpc.CallOption) (Checks_GetChangesClient, error)
	// Ping sends a ping to the server and receives an
	// acknowledgement back.
	Ping(ctx context.Context, in *PingRequest, opts ...grpc.CallOption) (*PongResponse, error)
}

type checksClient struct {
	cc *grpc.ClientConn
}

func NewChecksClient(cc *grpc.ClientConn) ChecksClient {
	return &checksClient{cc}
}

func (c *checksClient) RegisterProbe(ctx context.Context, in *ProbeInfo, opts ...grpc.CallOption) (*RegisterProbeResult, error) {
	out := new(RegisterProbeResult)
	err := c.cc.Invoke(ctx, "/synthetic_monitoring.Checks/RegisterProbe", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *checksClient) GetChanges(ctx context.Context, in *ProbeState, opts ...grpc.CallOption) (Checks_GetChangesClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Checks_serviceDesc.Streams[0], "/synthetic_monitoring.Checks/GetChanges", opts...)
	if err != nil {
		return nil, err
	}
	x := &checksGetChangesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Checks_GetChangesClient interface {
	Recv() (*Changes, error)
	grpc.ClientStream
}

type checksGetChangesClient struct {
	grpc.ClientStream
}

func (x *checksGetChangesClient) Recv() (*Changes, error) {
	m := new(Changes)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *checksClient) Ping(ctx context.Context, in *PingRequest, opts ...grpc.CallOption) (*PongResponse, error) {
	out := new(PongResponse)
	err := c.cc.Invoke(ctx, "/synthetic_monitoring.Checks/Ping", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ChecksServer is the server API for Checks service.
type ChecksServer interface {
	// RegisterProbe causes this probe to be reported as online with
	// synthetic-monitoring-api.
	//
	// The probe is identified via an authentication token provided
	// through a different channel by synthetic-monitoring-api.
	RegisterProbe(context.Context, *ProbeInfo) (*RegisterProbeResult, error)
	// GetChanges returns a list of check operations, specifying
	// whether to add, update or delete checks.
	GetChanges(*ProbeState, Checks_GetChangesServer) error
	// Ping sends a ping to the server and receives an
	// acknowledgement back.
	Ping(context.Context, *PingRequest) (*PongResponse, error)
}

// UnimplementedChecksServer can be embedded to have forward compatible implementations.
type UnimplementedChecksServer struct {
}

func (*UnimplementedChecksServer) RegisterProbe(ctx context.Context, req *ProbeInfo) (*RegisterProbeResult, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RegisterProbe not implemented")
}
func (*UnimplementedChecksServer) GetChanges(req *ProbeState, srv Checks_GetChangesServer) error {
	return status.Errorf(codes.Unimplemented, "method GetChanges not implemented")
}
func (*UnimplementedChecksServer) Ping(ctx context.Context, req *PingRequest) (*PongResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Ping not implemented")
}

func RegisterChecksServer(s *grpc.Server, srv ChecksServer) {
	s.RegisterService(&_Checks_serviceDesc, srv)
}

func _Checks_RegisterProbe_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProbeInfo)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ChecksServer).RegisterProbe(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/synthetic_monitoring.Checks/RegisterProbe",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ChecksServer).RegisterProbe(ctx, req.(*ProbeInfo))
	}
	return interceptor(ctx, in, info, handler)
}

func _Checks_GetChanges_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ProbeState)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ChecksServer).GetChanges(m, &checksGetChangesServer{stream})
}

type Checks_GetChangesServer interface {
	Send(*Changes) error
	grpc.ServerStream
}

type checksGetChangesServer struct {
	grpc.ServerStream
}

func (x *checksGetChangesServer) Send(m *Changes) error {
	return x.ServerStream.SendMsg(m)
}

func _Checks_Ping_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ChecksServer).Ping(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/synthetic_monitoring.Checks/Ping",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ChecksServer).Ping(ctx, req.(*PingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Checks_serviceDesc = grpc.ServiceDesc{
	ServiceName: "synthetic_monitoring.Checks",
	HandlerType: (*ChecksServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "RegisterProbe",
			Handler:    _Checks_RegisterProbe_Handler,
		},
		{
			MethodName: "Ping",
			Handler:    _Checks_Ping_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GetChanges",
			Handler:       _Checks_GetChanges_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "checks.proto",
}

// AdHocChecksClient is the client API for AdHocChecks service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AdHocChecksClient interface {
	// RegisterProbe causes this probe to be reported as available
	// with synthetic-monitoring-api.
	//
	// The probe is identified via an authentication token provided
	// through a different channel by synthetic-monitoring-api.
	RegisterProbe(ctx context.Context, in *ProbeInfo, opts ...grpc.CallOption) (*RegisterProbeResult, error)
	// GetAdHocChecks returns a list of checks to be run immediately.
	GetAdHocChecks(ctx context.Context, in *Void, opts ...grpc.CallOption) (AdHocChecks_GetAdHocChecksClient, error)
}

type adHocChecksClient struct {
	cc *grpc.ClientConn
}

func NewAdHocChecksClient(cc *grpc.ClientConn) AdHocChecksClient {
	return &adHocChecksClient{cc}
}

func (c *adHocChecksClient) RegisterProbe(ctx context.Context, in *ProbeInfo, opts ...grpc.CallOption) (*RegisterProbeResult, error) {
	out := new(RegisterProbeResult)
	err := c.cc.Invoke(ctx, "/synthetic_monitoring.AdHocChecks/RegisterProbe", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adHocChecksClient) GetAdHocChecks(ctx context.Context, in *Void, opts ...grpc.CallOption) (AdHocChecks_GetAdHocChecksClient, error) {
	stream, err := c.cc.NewStream(ctx, &_AdHocChecks_serviceDesc.Streams[0], "/synthetic_monitoring.AdHocChecks/GetAdHocChecks", opts...)
	if err != nil {
		return nil, err
	}
	x := &adHocChecksGetAdHocChecksClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type AdHocChecks_GetAdHocChecksClient interface {
	Recv() (*AdHocRequest, error)
	grpc.ClientStream
}

type adHocChecksGetAdHocChecksClient struct {
	grpc.ClientStream
}

func (x *adHocChecksGetAdHocChecksClient) Recv() (*AdHocRequest, error) {
	m := new(AdHocRequest)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// AdHocChecksServer is the server API for AdHocChecks service.
type AdHocChecksServer interface {
	// RegisterProbe causes this probe to be reported as available
	// with synthetic-monitoring-api.
	//
	// The probe is identified via an authentication token provided
	// through a different channel by synthetic-monitoring-api.
	RegisterProbe(context.Context, *ProbeInfo) (*RegisterProbeResult, error)
	// GetAdHocChecks returns a list of checks to be run immediately.
	GetAdHocChecks(*Void, AdHocChecks_GetAdHocChecksServer) error
}

// UnimplementedAdHocChecksServer can be embedded to have forward compatible implementations.
type UnimplementedAdHocChecksServer struct {
}

func (*UnimplementedAdHocChecksServer) RegisterProbe(ctx context.Context, req *ProbeInfo) (*RegisterProbeResult, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RegisterProbe not implemented")
}
func (*UnimplementedAdHocChecksServer) GetAdHocChecks(req *Void, srv AdHocChecks_GetAdHocChecksServer) error {
	return status.Errorf(codes.Unimplemented, "method GetAdHocChecks not implemented")
}

func RegisterAdHocChecksServer(s *grpc.Server, srv AdHocChecksServer) {
	s.RegisterService(&_AdHocChecks_serviceDesc, srv)
}

func _AdHocChecks_RegisterProbe_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProbeInfo)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdHocChecksServer).RegisterProbe(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/synthetic_monitoring.AdHocChecks/RegisterProbe",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdHocChecksServer).RegisterProbe(ctx, req.(*ProbeInfo))
	}
	return interceptor(ctx, in, info, handler)
}

func _AdHocChecks_GetAdHocChecks_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(Void)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(AdHocChecksServer).GetAdHocChecks(m, &adHocChecksGetAdHocChecksServer{stream})
}

type AdHocChecks_GetAdHocChecksServer interface {
	Send(*AdHocRequest) error
	grpc.ServerStream
}

type adHocChecksGetAdHocChecksServer struct {
	grpc.ServerStream
}

func (x *adHocChecksGetAdHocChecksServer) Send(m *AdHocRequest) error {
	return x.ServerStream.SendMsg(m)
}

var _AdHocChecks_serviceDesc = grpc.ServiceDesc{
	ServiceName: "synthetic_monitoring.AdHocChecks",
	HandlerType: (*AdHocChecksServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "RegisterProbe",
			Handler:    _AdHocChecks_RegisterProbe_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GetAdHocChecks",
			Handler:       _AdHocChecks_GetAdHocChecks_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "checks.proto",
}

// TenantsClient is the client API for Tenants service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TenantsClient interface {
	// GetTenant returns the details of the specified tenant
	GetTenant(ctx context.Context, in *TenantInfo, opts ...grpc.CallOption) (*Tenant, error)
}

type tenantsClient struct {
	cc *grpc.ClientConn
}

func NewTenantsClient(cc *grpc.ClientConn) TenantsClient {
	return &tenantsClient{cc}
}

func (c *tenantsClient) GetTenant(ctx context.Context, in *TenantInfo, opts ...grpc.CallOption) (*Tenant, error) {
	out := new(Tenant)
	err := c.cc.Invoke(ctx, "/synthetic_monitoring.Tenants/GetTenant", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TenantsServer is the server API for Tenants service.
type TenantsServer interface {
	// GetTenant returns the details of the specified tenant
	GetTenant(context.Context, *TenantInfo) (*Tenant, error)
}

// UnimplementedTenantsServer can be embedded to have forward compatible implementations.
type UnimplementedTenantsServer struct {
}

func (*UnimplementedTenantsServer) GetTenant(ctx context.Context, req *TenantInfo) (*Tenant, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTenant not implemented")
}

func RegisterTenantsServer(s *grpc.Server, srv TenantsServer) {
	s.RegisterService(&_Tenants_serviceDesc, srv)
}

func _Tenants_GetTenant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TenantInfo)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TenantsServer).GetTenant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/synthetic_monitoring.Tenants/GetTenant",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TenantsServer).GetTenant(ctx, req.(*TenantInfo))
	}
	return interceptor(ctx, in, info, handler)
}

var _Tenants_serviceDesc = grpc.ServiceDesc{
	ServiceName: "synthetic_monitoring.Tenants",
	HandlerType: (*TenantsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetTenant",
			Handler:    _Tenants_GetTenant_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "checks.proto",
}

// TelemetryClient is the client API for Telemetry service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TelemetryClient interface {
	// PushTelemetry pushes telemetry data for all the tenants that are running
	// checks in the agent which belong to the same region.
	PushTelemetry(ctx context.Context, in *RegionTelemetry, opts ...grpc.CallOption) (*PushTelemetryResponse, error)
}

type telemetryClient struct {
	cc *grpc.ClientConn
}

func NewTelemetryClient(cc *grpc.ClientConn) TelemetryClient {
	return &telemetryClient{cc}
}

func (c *telemetryClient) PushTelemetry(ctx context.Context, in *RegionTelemetry, opts ...grpc.CallOption) (*PushTelemetryResponse, error) {
	out := new(PushTelemetryResponse)
	err := c.cc.Invoke(ctx, "/synthetic_monitoring.Telemetry/PushTelemetry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TelemetryServer is the server API for Telemetry service.
type TelemetryServer interface {
	// PushTelemetry pushes telemetry data for all the tenants that are running
	// checks in the agent which belong to the same region.
	PushTelemetry(context.Context, *RegionTelemetry) (*PushTelemetryResponse, error)
}

// UnimplementedTelemetryServer can be embedded to have forward compatible implementations.
type UnimplementedTelemetryServer struct {
}

func (*UnimplementedTelemetryServer) PushTelemetry(ctx context.Context, req *RegionTelemetry) (*PushTelemetryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PushTelemetry not implemented")
}

func RegisterTelemetryServer(s *grpc.Server, srv TelemetryServer) {
	s.RegisterService(&_Telemetry_serviceDesc, srv)
}

func _Telemetry_PushTelemetry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RegionTelemetry)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelemetryServer).PushTelemetry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/synthetic_monitoring.Telemetry/PushTelemetry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelemetryServer).PushTelemetry(ctx, req.(*RegionTelemetry))
	}
	return interceptor(ctx, in, info, handler)
}

var _Telemetry_serviceDesc = grpc.ServiceDesc{
	ServiceName: "synthetic_monitoring.Telemetry",
	HandlerType: (*TelemetryServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "PushTelemetry",
			Handler:    _Telemetry_PushTelemetry_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "checks.proto",
}

func (m *Void) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Void) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Void) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *ProbeState) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProbeState) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProbeState) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Tenants) > 0 {
		for iNdEx := len(m.Tenants) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Tenants[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintChecks(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Checks) > 0 {
		for iNdEx := len(m.Checks) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Checks[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintChecks(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *EntityRef) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EntityRef) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EntityRef) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.LastModified != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.LastModified))))
		i--
		dAtA[i] = 0x11
	}
	if m.Id != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.Id))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ProbeInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProbeInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProbeInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Buildstamp) > 0 {
		i -= len(m.Buildstamp)
		copy(dAtA[i:], m.Buildstamp)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Buildstamp)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Commit) > 0 {
		i -= len(m.Commit)
		copy(dAtA[i:], m.Commit)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Commit)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Version) > 0 {
		i -= len(m.Version)
		copy(dAtA[i:], m.Version)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Version)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PingRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PingRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PingRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Sequence != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.Sequence))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *PongResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PongResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PongResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Sequence != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.Sequence))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Status) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Status) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Status) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0x12
	}
	if m.Code != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.Code))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *RegisterProbeResult) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RegisterProbeResult) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RegisterProbeResult) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.Status.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintChecks(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x12
	{
		size, err := m.Probe.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintChecks(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *Probe) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Probe) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Probe) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Modified != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Modified))))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xa9
	}
	if m.Created != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Created))))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xa1
	}
	if m.Deprecated {
		i--
		if m.Deprecated {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x70
	}
	if len(m.Buildstamp) > 0 {
		i -= len(m.Buildstamp)
		copy(dAtA[i:], m.Buildstamp)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Buildstamp)))
		i--
		dAtA[i] = 0x6a
	}
	if len(m.Commit) > 0 {
		i -= len(m.Commit)
		copy(dAtA[i:], m.Commit)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Commit)))
		i--
		dAtA[i] = 0x62
	}
	if len(m.Version) > 0 {
		i -= len(m.Version)
		copy(dAtA[i:], m.Version)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Version)))
		i--
		dAtA[i] = 0x5a
	}
	if m.OnlineChange != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.OnlineChange))))
		i--
		dAtA[i] = 0x51
	}
	if m.Online {
		i--
		if m.Online {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x48
	}
	if m.Public {
		i--
		if m.Public {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x40
	}
	if len(m.Region) > 0 {
		i -= len(m.Region)
		copy(dAtA[i:], m.Region)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Region)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Labels) > 0 {
		for iNdEx := len(m.Labels) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Labels[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintChecks(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if m.Longitude != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.Longitude))))
		i--
		dAtA[i] = 0x2d
	}
	if m.Latitude != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.Latitude))))
		i--
		dAtA[i] = 0x25
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if m.TenantId != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.TenantId))
		i--
		dAtA[i] = 0x10
	}
	if m.Id != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.Id))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *TenantInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TenantInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TenantInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Id != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.Id))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *TenantLimits) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TenantLimits) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TenantLimits) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.MaxLogLabels != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.MaxLogLabels))
		i--
		dAtA[i] = 0x20
	}
	if m.MaxMetricLabels != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.MaxMetricLabels))
		i--
		dAtA[i] = 0x18
	}
	if m.MaxScriptedChecks != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.MaxScriptedChecks))
		i--
		dAtA[i] = 0x10
	}
	if m.MaxChecks != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.MaxChecks))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Tenant) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tenant) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tenant) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Modified != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Modified))))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xa9
	}
	if m.Created != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Created))))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xa1
	}
	if m.Limits != nil {
		{
			size, err := m.Limits.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecks(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if len(m.Reason) > 0 {
		i -= len(m.Reason)
		copy(dAtA[i:], m.Reason)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Reason)))
		i--
		dAtA[i] = 0x3a
	}
	if m.Status != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.Status))
		i--
		dAtA[i] = 0x30
	}
	if m.StackId != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.StackId))
		i--
		dAtA[i] = 0x28
	}
	if m.EventsRemote != nil {
		{
			size, err := m.EventsRemote.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecks(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.MetricsRemote != nil {
		{
			size, err := m.MetricsRemote.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecks(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.OrgId != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.OrgId))
		i--
		dAtA[i] = 0x10
	}
	if m.Id != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.Id))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *RemoteInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RemoteInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RemoteInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Password) > 0 {
		i -= len(m.Password)
		copy(dAtA[i:], m.Password)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Password)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Username) > 0 {
		i -= len(m.Username)
		copy(dAtA[i:], m.Username)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Username)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CheckChange) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckChange) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CheckChange) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.Check.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintChecks(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x12
	if m.Operation != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.Operation))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Changes) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Changes) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Changes) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.IsDeltaFirstBatch {
		i--
		if m.IsDeltaFirstBatch {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.Tenants) > 0 {
		for iNdEx := len(m.Tenants) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Tenants[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintChecks(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Checks) > 0 {
		for iNdEx := len(m.Checks) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Checks[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintChecks(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *AdHocRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdHocRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AdHocRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Tenant != nil {
		{
			size, err := m.Tenant.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecks(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	{
		size, err := m.AdHocCheck.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintChecks(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *Label) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Label) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Label) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Check) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Check) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Check) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Modified != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Modified))))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xa9
	}
	if m.Created != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Created))))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xa1
	}
	if len(m.AlertSensitivity) > 0 {
		i -= len(m.AlertSensitivity)
		copy(dAtA[i:], m.AlertSensitivity)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.AlertSensitivity)))
		i--
		dAtA[i] = 0x6a
	}
	if m.BasicMetricsOnly {
		i--
		if m.BasicMetricsOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x60
	}
	if len(m.Job) > 0 {
		i -= len(m.Job)
		copy(dAtA[i:], m.Job)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Job)))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.Target) > 0 {
		i -= len(m.Target)
		copy(dAtA[i:], m.Target)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Target)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.Probes) > 0 {
		dAtA10 := make([]byte, len(m.Probes)*10)
		var j9 int
		for _, num1 := range m.Probes {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA10[j9] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j9++
			}
			dAtA10[j9] = uint8(num)
			j9++
		}
		i -= j9
		copy(dAtA[i:], dAtA10[:j9])
		i = encodeVarintChecks(dAtA, i, uint64(j9))
		i--
		dAtA[i] = 0x4a
	}
	{
		size, err := m.Settings.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintChecks(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x42
	if len(m.Labels) > 0 {
		for iNdEx := len(m.Labels) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Labels[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintChecks(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if m.Enabled {
		i--
		if m.Enabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if m.Timeout != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.Timeout))
		i--
		dAtA[i] = 0x28
	}
	if m.Offset != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.Offset))
		i--
		dAtA[i] = 0x20
	}
	if m.Frequency != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.Frequency))
		i--
		dAtA[i] = 0x18
	}
	if m.TenantId != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.TenantId))
		i--
		dAtA[i] = 0x10
	}
	if m.Id != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.Id))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *AdHocCheck) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdHocCheck) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AdHocCheck) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Target) > 0 {
		i -= len(m.Target)
		copy(dAtA[i:], m.Target)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Target)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.Probes) > 0 {
		dAtA13 := make([]byte, len(m.Probes)*10)
		var j12 int
		for _, num1 := range m.Probes {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA13[j12] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j12++
			}
			dAtA13[j12] = uint8(num)
			j12++
		}
		i -= j12
		copy(dAtA[i:], dAtA13[:j12])
		i = encodeVarintChecks(dAtA, i, uint64(j12))
		i--
		dAtA[i] = 0x2a
	}
	{
		size, err := m.Settings.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintChecks(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x22
	if m.Timeout != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.Timeout))
		i--
		dAtA[i] = 0x18
	}
	if m.TenantId != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.TenantId))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CheckSettings) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckSettings) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CheckSettings) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Grpc != nil {
		{
			size, err := m.Grpc.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecks(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.Multihttp != nil {
		{
			size, err := m.Multihttp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecks(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.Scripted != nil {
		{
			size, err := m.Scripted.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecks(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.Traceroute != nil {
		{
			size, err := m.Traceroute.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecks(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.Tcp != nil {
		{
			size, err := m.Tcp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecks(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.Dns != nil {
		{
			size, err := m.Dns.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecks(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Http != nil {
		{
			size, err := m.Http.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecks(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Ping != nil {
		{
			size, err := m.Ping.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecks(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PingSettings) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PingSettings) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PingSettings) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.PacketCount != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.PacketCount))
		i--
		dAtA[i] = 0x38
		i--
		dAtA[i] = 0xa0
	}
	if m.DontFragment {
		i--
		if m.DontFragment {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.PayloadSize != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.PayloadSize))
		i--
		dAtA[i] = 0x18
	}
	if len(m.SourceIpAddress) > 0 {
		i -= len(m.SourceIpAddress)
		copy(dAtA[i:], m.SourceIpAddress)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.SourceIpAddress)))
		i--
		dAtA[i] = 0x12
	}
	if m.IpVersion != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.IpVersion))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *HttpSettings) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HttpSettings) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HttpSettings) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.CacheBustingQueryParamName) > 0 {
		i -= len(m.CacheBustingQueryParamName)
		copy(dAtA[i:], m.CacheBustingQueryParamName)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.CacheBustingQueryParamName)))
		i--
		dAtA[i] = 0x38
		i--
		dAtA[i] = 0xa2
	}
	if m.Compression != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.Compression))
		i--
		dAtA[i] = 0xd
		i--
		dAtA[i] = 0x80
	}
	if len(m.FailIfHeaderNotMatchesRegexp) > 0 {
		for iNdEx := len(m.FailIfHeaderNotMatchesRegexp) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.FailIfHeaderNotMatchesRegexp[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintChecks(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xc
			i--
			dAtA[i] = 0xfa
		}
	}
	if len(m.FailIfHeaderMatchesRegexp) > 0 {
		for iNdEx := len(m.FailIfHeaderMatchesRegexp) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.FailIfHeaderMatchesRegexp[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintChecks(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xc
			i--
			dAtA[i] = 0xf2
		}
	}
	if len(m.FailIfBodyNotMatchesRegexp) > 0 {
		for iNdEx := len(m.FailIfBodyNotMatchesRegexp) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.FailIfBodyNotMatchesRegexp[iNdEx])
			copy(dAtA[i:], m.FailIfBodyNotMatchesRegexp[iNdEx])
			i = encodeVarintChecks(dAtA, i, uint64(len(m.FailIfBodyNotMatchesRegexp[iNdEx])))
			i--
			dAtA[i] = 0xc
			i--
			dAtA[i] = 0xea
		}
	}
	if len(m.FailIfBodyMatchesRegexp) > 0 {
		for iNdEx := len(m.FailIfBodyMatchesRegexp) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.FailIfBodyMatchesRegexp[iNdEx])
			copy(dAtA[i:], m.FailIfBodyMatchesRegexp[iNdEx])
			i = encodeVarintChecks(dAtA, i, uint64(len(m.FailIfBodyMatchesRegexp[iNdEx])))
			i--
			dAtA[i] = 0xc
			i--
			dAtA[i] = 0xe2
		}
	}
	if len(m.ValidHTTPVersions) > 0 {
		for iNdEx := len(m.ValidHTTPVersions) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ValidHTTPVersions[iNdEx])
			copy(dAtA[i:], m.ValidHTTPVersions[iNdEx])
			i = encodeVarintChecks(dAtA, i, uint64(len(m.ValidHTTPVersions[iNdEx])))
			i--
			dAtA[i] = 0xc
			i--
			dAtA[i] = 0xda
		}
	}
	if len(m.ValidStatusCodes) > 0 {
		dAtA24 := make([]byte, len(m.ValidStatusCodes)*10)
		var j23 int
		for _, num1 := range m.ValidStatusCodes {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA24[j23] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j23++
			}
			dAtA24[j23] = uint8(num)
			j23++
		}
		i -= j23
		copy(dAtA[i:], dAtA24[:j23])
		i = encodeVarintChecks(dAtA, i, uint64(j23))
		i--
		dAtA[i] = 0xc
		i--
		dAtA[i] = 0xd2
	}
	if m.FailIfNotSSL {
		i--
		if m.FailIfNotSSL {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0xc
		i--
		dAtA[i] = 0xc8
	}
	if m.FailIfSSL {
		i--
		if m.FailIfSSL {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0xc
		i--
		dAtA[i] = 0xc0
	}
	if len(m.ProxyConnectHeaders) > 0 {
		for iNdEx := len(m.ProxyConnectHeaders) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ProxyConnectHeaders[iNdEx])
			copy(dAtA[i:], m.ProxyConnectHeaders[iNdEx])
			i = encodeVarintChecks(dAtA, i, uint64(len(m.ProxyConnectHeaders[iNdEx])))
			i--
			dAtA[i] = 0x6
			i--
			dAtA[i] = 0xca
		}
	}
	if m.Oauth2Config != nil {
		{
			size, err := m.Oauth2Config.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecks(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xc2
	}
	if len(m.ProxyURL) > 0 {
		i -= len(m.ProxyURL)
		copy(dAtA[i:], m.ProxyURL)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.ProxyURL)))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xba
	}
	if len(m.BearerToken) > 0 {
		i -= len(m.BearerToken)
		copy(dAtA[i:], m.BearerToken)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.BearerToken)))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xb2
	}
	if m.BasicAuth != nil {
		{
			size, err := m.BasicAuth.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecks(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xaa
	}
	if m.TlsConfig != nil {
		{
			size, err := m.TlsConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecks(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xa2
	}
	if m.NoFollowRedirects {
		i--
		if m.NoFollowRedirects {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if len(m.Body) > 0 {
		i -= len(m.Body)
		copy(dAtA[i:], m.Body)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Body)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Headers) > 0 {
		for iNdEx := len(m.Headers) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Headers[iNdEx])
			copy(dAtA[i:], m.Headers[iNdEx])
			i = encodeVarintChecks(dAtA, i, uint64(len(m.Headers[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.Method != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.Method))
		i--
		dAtA[i] = 0x10
	}
	if m.IpVersion != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.IpVersion))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *OAuth2Config) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OAuth2Config) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OAuth2Config) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ProxyURL) > 0 {
		i -= len(m.ProxyURL)
		copy(dAtA[i:], m.ProxyURL)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.ProxyURL)))
		i--
		dAtA[i] = 0x3a
	}
	if m.TlsConfig != nil {
		{
			size, err := m.TlsConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecks(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if len(m.EndpointParams) > 0 {
		for iNdEx := len(m.EndpointParams) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.EndpointParams[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintChecks(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Scopes) > 0 {
		for iNdEx := len(m.Scopes) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Scopes[iNdEx])
			copy(dAtA[i:], m.Scopes[iNdEx])
			i = encodeVarintChecks(dAtA, i, uint64(len(m.Scopes[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.TokenURL) > 0 {
		i -= len(m.TokenURL)
		copy(dAtA[i:], m.TokenURL)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.TokenURL)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ClientSecret) > 0 {
		i -= len(m.ClientSecret)
		copy(dAtA[i:], m.ClientSecret)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.ClientSecret)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClientId) > 0 {
		i -= len(m.ClientId)
		copy(dAtA[i:], m.ClientId)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.ClientId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *HeaderMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HeaderMatch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HeaderMatch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AllowMissing {
		i--
		if m.AllowMissing {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.Regexp) > 0 {
		i -= len(m.Regexp)
		copy(dAtA[i:], m.Regexp)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Regexp)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Header) > 0 {
		i -= len(m.Header)
		copy(dAtA[i:], m.Header)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Header)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DNSRRValidator) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DNSRRValidator) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DNSRRValidator) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.FailIfNotMatchesRegexp) > 0 {
		for iNdEx := len(m.FailIfNotMatchesRegexp) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.FailIfNotMatchesRegexp[iNdEx])
			copy(dAtA[i:], m.FailIfNotMatchesRegexp[iNdEx])
			i = encodeVarintChecks(dAtA, i, uint64(len(m.FailIfNotMatchesRegexp[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.FailIfMatchesRegexp) > 0 {
		for iNdEx := len(m.FailIfMatchesRegexp) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.FailIfMatchesRegexp[iNdEx])
			copy(dAtA[i:], m.FailIfMatchesRegexp[iNdEx])
			i = encodeVarintChecks(dAtA, i, uint64(len(m.FailIfMatchesRegexp[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *DnsSettings) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DnsSettings) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DnsSettings) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ValidateAdditional != nil {
		{
			size, err := m.ValidateAdditional.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecks(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xc
		i--
		dAtA[i] = 0xda
	}
	if m.ValidateAuthority != nil {
		{
			size, err := m.ValidateAuthority.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecks(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xc
		i--
		dAtA[i] = 0xd2
	}
	if m.ValidateAnswer != nil {
		{
			size, err := m.ValidateAnswer.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecks(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xc
		i--
		dAtA[i] = 0xca
	}
	if len(m.ValidRCodes) > 0 {
		for iNdEx := len(m.ValidRCodes) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ValidRCodes[iNdEx])
			copy(dAtA[i:], m.ValidRCodes[iNdEx])
			i = encodeVarintChecks(dAtA, i, uint64(len(m.ValidRCodes[iNdEx])))
			i--
			dAtA[i] = 0xc
			i--
			dAtA[i] = 0xc2
		}
	}
	if m.Protocol != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.Protocol))
		i--
		dAtA[i] = 0x30
	}
	if m.RecordType != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.RecordType))
		i--
		dAtA[i] = 0x28
	}
	if m.Port != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.Port))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Server) > 0 {
		i -= len(m.Server)
		copy(dAtA[i:], m.Server)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Server)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.SourceIpAddress) > 0 {
		i -= len(m.SourceIpAddress)
		copy(dAtA[i:], m.SourceIpAddress)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.SourceIpAddress)))
		i--
		dAtA[i] = 0x12
	}
	if m.IpVersion != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.IpVersion))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *TcpSettings) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TcpSettings) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TcpSettings) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.QueryResponse) > 0 {
		for iNdEx := len(m.QueryResponse) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.QueryResponse[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintChecks(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.TlsConfig != nil {
		{
			size, err := m.TlsConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecks(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.Tls {
		i--
		if m.Tls {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.SourceIpAddress) > 0 {
		i -= len(m.SourceIpAddress)
		copy(dAtA[i:], m.SourceIpAddress)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.SourceIpAddress)))
		i--
		dAtA[i] = 0x12
	}
	if m.IpVersion != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.IpVersion))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *TCPQueryResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TCPQueryResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TCPQueryResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.StartTLS {
		i--
		if m.StartTLS {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.Expect) > 0 {
		i -= len(m.Expect)
		copy(dAtA[i:], m.Expect)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Expect)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Send) > 0 {
		i -= len(m.Send)
		copy(dAtA[i:], m.Send)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Send)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TLSConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TLSConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TLSConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ServerName) > 0 {
		i -= len(m.ServerName)
		copy(dAtA[i:], m.ServerName)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.ServerName)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ClientKey) > 0 {
		i -= len(m.ClientKey)
		copy(dAtA[i:], m.ClientKey)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.ClientKey)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.ClientCert) > 0 {
		i -= len(m.ClientCert)
		copy(dAtA[i:], m.ClientCert)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.ClientCert)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.CACert) > 0 {
		i -= len(m.CACert)
		copy(dAtA[i:], m.CACert)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.CACert)))
		i--
		dAtA[i] = 0x12
	}
	if m.InsecureSkipVerify {
		i--
		if m.InsecureSkipVerify {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *BasicAuth) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BasicAuth) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BasicAuth) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Password) > 0 {
		i -= len(m.Password)
		copy(dAtA[i:], m.Password)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Password)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Username) > 0 {
		i -= len(m.Username)
		copy(dAtA[i:], m.Username)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Username)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TracerouteSettings) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TracerouteSettings) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TracerouteSettings) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.HopTimeout != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.HopTimeout))
		i--
		dAtA[i] = 0x20
	}
	if m.PtrLookup {
		i--
		if m.PtrLookup {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.MaxUnknownHops != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.MaxUnknownHops))
		i--
		dAtA[i] = 0x10
	}
	if m.MaxHops != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.MaxHops))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ScriptedSettings) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScriptedSettings) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScriptedSettings) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Script) > 0 {
		i -= len(m.Script)
		copy(dAtA[i:], m.Script)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Script)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MultiHttpSettings) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MultiHttpSettings) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MultiHttpSettings) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.LogResponses {
		i--
		if m.LogResponses {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.Entries) > 0 {
		for iNdEx := len(m.Entries) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Entries[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintChecks(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *MultiHttpEntry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MultiHttpEntry) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MultiHttpEntry) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Variables) > 0 {
		for iNdEx := len(m.Variables) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Variables[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintChecks(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Assertions) > 0 {
		for iNdEx := len(m.Assertions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Assertions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintChecks(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Request != nil {
		{
			size, err := m.Request.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecks(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *HttpHeader) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HttpHeader) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HttpHeader) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *QueryField) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryField) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryField) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MultiHttpEntryRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MultiHttpEntryRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MultiHttpEntryRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Body != nil {
		{
			size, err := m.Body.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecks(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.QueryFields) > 0 {
		for iNdEx := len(m.QueryFields) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.QueryFields[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintChecks(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Headers) > 0 {
		for iNdEx := len(m.Headers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Headers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintChecks(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0x12
	}
	if m.Method != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.Method))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *HttpRequestBody) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HttpRequestBody) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HttpRequestBody) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Payload) > 0 {
		i -= len(m.Payload)
		copy(dAtA[i:], m.Payload)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Payload)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ContentEncoding) > 0 {
		i -= len(m.ContentEncoding)
		copy(dAtA[i:], m.ContentEncoding)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.ContentEncoding)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ContentType) > 0 {
		i -= len(m.ContentType)
		copy(dAtA[i:], m.ContentType)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.ContentType)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MultiHttpEntryAssertion) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MultiHttpEntryAssertion) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MultiHttpEntryAssertion) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Expression) > 0 {
		i -= len(m.Expression)
		copy(dAtA[i:], m.Expression)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Expression)))
		i--
		dAtA[i] = 0x22
	}
	if m.Condition != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.Condition))
		i--
		dAtA[i] = 0x18
	}
	if m.Subject != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.Subject))
		i--
		dAtA[i] = 0x10
	}
	if m.Type != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *MultiHttpEntryVariable) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MultiHttpEntryVariable) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MultiHttpEntryVariable) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Attribute) > 0 {
		i -= len(m.Attribute)
		copy(dAtA[i:], m.Attribute)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Attribute)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Expression) > 0 {
		i -= len(m.Expression)
		copy(dAtA[i:], m.Expression)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Expression)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if m.Type != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *GrpcSettings) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GrpcSettings) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GrpcSettings) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.TlsConfig != nil {
		{
			size, err := m.TlsConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecks(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.Tls {
		i--
		if m.Tls {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.Service) > 0 {
		i -= len(m.Service)
		copy(dAtA[i:], m.Service)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Service)))
		i--
		dAtA[i] = 0x12
	}
	if m.IpVersion != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.IpVersion))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *RegionTelemetry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RegionTelemetry) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RegionTelemetry) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Telemetry) > 0 {
		for iNdEx := len(m.Telemetry) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Telemetry[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintChecks(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.RegionId != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.RegionId))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Instance) > 0 {
		i -= len(m.Instance)
		copy(dAtA[i:], m.Instance)
		i = encodeVarintChecks(dAtA, i, uint64(len(m.Instance)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TenantTelemetry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TenantTelemetry) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TenantTelemetry) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Telemetry) > 0 {
		for iNdEx := len(m.Telemetry) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Telemetry[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintChecks(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.TenantId != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.TenantId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CheckClassTelemetry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckClassTelemetry) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CheckClassTelemetry) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.SampledExecutions != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.SampledExecutions))
		i--
		dAtA[i] = 0x20
	}
	if m.Duration != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.Duration))))
		i--
		dAtA[i] = 0x1d
	}
	if m.Executions != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.Executions))
		i--
		dAtA[i] = 0x10
	}
	if m.CheckClass != 0 {
		i = encodeVarintChecks(dAtA, i, uint64(m.CheckClass))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *PushTelemetryResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PushTelemetryResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PushTelemetryResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Status != nil {
		{
			size, err := m.Status.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintChecks(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintChecks(dAtA []byte, offset int, v uint64) int {
	offset -= sovChecks(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Void) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *ProbeState) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Checks) > 0 {
		for _, e := range m.Checks {
			l = e.Size()
			n += 1 + l + sovChecks(uint64(l))
		}
	}
	if len(m.Tenants) > 0 {
		for _, e := range m.Tenants {
			l = e.Size()
			n += 1 + l + sovChecks(uint64(l))
		}
	}
	return n
}

func (m *EntityRef) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovChecks(uint64(m.Id))
	}
	if m.LastModified != 0 {
		n += 9
	}
	return n
}

func (m *ProbeInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	l = len(m.Commit)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	l = len(m.Buildstamp)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	return n
}

func (m *PingRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Sequence != 0 {
		n += 1 + sovChecks(uint64(m.Sequence))
	}
	return n
}

func (m *PongResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Sequence != 0 {
		n += 1 + sovChecks(uint64(m.Sequence))
	}
	return n
}

func (m *Status) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Code != 0 {
		n += 1 + sovChecks(uint64(m.Code))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	return n
}

func (m *RegisterProbeResult) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Probe.Size()
	n += 1 + l + sovChecks(uint64(l))
	l = m.Status.Size()
	n += 1 + l + sovChecks(uint64(l))
	return n
}

func (m *Probe) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovChecks(uint64(m.Id))
	}
	if m.TenantId != 0 {
		n += 1 + sovChecks(uint64(m.TenantId))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	if m.Latitude != 0 {
		n += 5
	}
	if m.Longitude != 0 {
		n += 5
	}
	if len(m.Labels) > 0 {
		for _, e := range m.Labels {
			l = e.Size()
			n += 1 + l + sovChecks(uint64(l))
		}
	}
	l = len(m.Region)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	if m.Public {
		n += 2
	}
	if m.Online {
		n += 2
	}
	if m.OnlineChange != 0 {
		n += 9
	}
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	l = len(m.Commit)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	l = len(m.Buildstamp)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	if m.Deprecated {
		n += 2
	}
	if m.Created != 0 {
		n += 10
	}
	if m.Modified != 0 {
		n += 10
	}
	return n
}

func (m *TenantInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovChecks(uint64(m.Id))
	}
	return n
}

func (m *TenantLimits) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MaxChecks != 0 {
		n += 1 + sovChecks(uint64(m.MaxChecks))
	}
	if m.MaxScriptedChecks != 0 {
		n += 1 + sovChecks(uint64(m.MaxScriptedChecks))
	}
	if m.MaxMetricLabels != 0 {
		n += 1 + sovChecks(uint64(m.MaxMetricLabels))
	}
	if m.MaxLogLabels != 0 {
		n += 1 + sovChecks(uint64(m.MaxLogLabels))
	}
	return n
}

func (m *Tenant) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovChecks(uint64(m.Id))
	}
	if m.OrgId != 0 {
		n += 1 + sovChecks(uint64(m.OrgId))
	}
	if m.MetricsRemote != nil {
		l = m.MetricsRemote.Size()
		n += 1 + l + sovChecks(uint64(l))
	}
	if m.EventsRemote != nil {
		l = m.EventsRemote.Size()
		n += 1 + l + sovChecks(uint64(l))
	}
	if m.StackId != 0 {
		n += 1 + sovChecks(uint64(m.StackId))
	}
	if m.Status != 0 {
		n += 1 + sovChecks(uint64(m.Status))
	}
	l = len(m.Reason)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	if m.Limits != nil {
		l = m.Limits.Size()
		n += 1 + l + sovChecks(uint64(l))
	}
	if m.Created != 0 {
		n += 10
	}
	if m.Modified != 0 {
		n += 10
	}
	return n
}

func (m *RemoteInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	l = len(m.Username)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	l = len(m.Password)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	return n
}

func (m *CheckChange) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Operation != 0 {
		n += 1 + sovChecks(uint64(m.Operation))
	}
	l = m.Check.Size()
	n += 1 + l + sovChecks(uint64(l))
	return n
}

func (m *Changes) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Checks) > 0 {
		for _, e := range m.Checks {
			l = e.Size()
			n += 1 + l + sovChecks(uint64(l))
		}
	}
	if len(m.Tenants) > 0 {
		for _, e := range m.Tenants {
			l = e.Size()
			n += 1 + l + sovChecks(uint64(l))
		}
	}
	if m.IsDeltaFirstBatch {
		n += 2
	}
	return n
}

func (m *AdHocRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.AdHocCheck.Size()
	n += 1 + l + sovChecks(uint64(l))
	if m.Tenant != nil {
		l = m.Tenant.Size()
		n += 1 + l + sovChecks(uint64(l))
	}
	return n
}

func (m *Label) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	return n
}

func (m *Check) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovChecks(uint64(m.Id))
	}
	if m.TenantId != 0 {
		n += 1 + sovChecks(uint64(m.TenantId))
	}
	if m.Frequency != 0 {
		n += 1 + sovChecks(uint64(m.Frequency))
	}
	if m.Offset != 0 {
		n += 1 + sovChecks(uint64(m.Offset))
	}
	if m.Timeout != 0 {
		n += 1 + sovChecks(uint64(m.Timeout))
	}
	if m.Enabled {
		n += 2
	}
	if len(m.Labels) > 0 {
		for _, e := range m.Labels {
			l = e.Size()
			n += 1 + l + sovChecks(uint64(l))
		}
	}
	l = m.Settings.Size()
	n += 1 + l + sovChecks(uint64(l))
	if len(m.Probes) > 0 {
		l = 0
		for _, e := range m.Probes {
			l += sovChecks(uint64(e))
		}
		n += 1 + sovChecks(uint64(l)) + l
	}
	l = len(m.Target)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	l = len(m.Job)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	if m.BasicMetricsOnly {
		n += 2
	}
	l = len(m.AlertSensitivity)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	if m.Created != 0 {
		n += 10
	}
	if m.Modified != 0 {
		n += 10
	}
	return n
}

func (m *AdHocCheck) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	if m.TenantId != 0 {
		n += 1 + sovChecks(uint64(m.TenantId))
	}
	if m.Timeout != 0 {
		n += 1 + sovChecks(uint64(m.Timeout))
	}
	l = m.Settings.Size()
	n += 1 + l + sovChecks(uint64(l))
	if len(m.Probes) > 0 {
		l = 0
		for _, e := range m.Probes {
			l += sovChecks(uint64(e))
		}
		n += 1 + sovChecks(uint64(l)) + l
	}
	l = len(m.Target)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	return n
}

func (m *CheckSettings) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Ping != nil {
		l = m.Ping.Size()
		n += 1 + l + sovChecks(uint64(l))
	}
	if m.Http != nil {
		l = m.Http.Size()
		n += 1 + l + sovChecks(uint64(l))
	}
	if m.Dns != nil {
		l = m.Dns.Size()
		n += 1 + l + sovChecks(uint64(l))
	}
	if m.Tcp != nil {
		l = m.Tcp.Size()
		n += 1 + l + sovChecks(uint64(l))
	}
	if m.Traceroute != nil {
		l = m.Traceroute.Size()
		n += 1 + l + sovChecks(uint64(l))
	}
	if m.Scripted != nil {
		l = m.Scripted.Size()
		n += 1 + l + sovChecks(uint64(l))
	}
	if m.Multihttp != nil {
		l = m.Multihttp.Size()
		n += 1 + l + sovChecks(uint64(l))
	}
	if m.Grpc != nil {
		l = m.Grpc.Size()
		n += 1 + l + sovChecks(uint64(l))
	}
	return n
}

func (m *PingSettings) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.IpVersion != 0 {
		n += 1 + sovChecks(uint64(m.IpVersion))
	}
	l = len(m.SourceIpAddress)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	if m.PayloadSize != 0 {
		n += 1 + sovChecks(uint64(m.PayloadSize))
	}
	if m.DontFragment {
		n += 2
	}
	if m.PacketCount != 0 {
		n += 2 + sovChecks(uint64(m.PacketCount))
	}
	return n
}

func (m *HttpSettings) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.IpVersion != 0 {
		n += 1 + sovChecks(uint64(m.IpVersion))
	}
	if m.Method != 0 {
		n += 1 + sovChecks(uint64(m.Method))
	}
	if len(m.Headers) > 0 {
		for _, s := range m.Headers {
			l = len(s)
			n += 1 + l + sovChecks(uint64(l))
		}
	}
	l = len(m.Body)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	if m.NoFollowRedirects {
		n += 2
	}
	if m.TlsConfig != nil {
		l = m.TlsConfig.Size()
		n += 2 + l + sovChecks(uint64(l))
	}
	if m.BasicAuth != nil {
		l = m.BasicAuth.Size()
		n += 2 + l + sovChecks(uint64(l))
	}
	l = len(m.BearerToken)
	if l > 0 {
		n += 2 + l + sovChecks(uint64(l))
	}
	l = len(m.ProxyURL)
	if l > 0 {
		n += 2 + l + sovChecks(uint64(l))
	}
	if m.Oauth2Config != nil {
		l = m.Oauth2Config.Size()
		n += 2 + l + sovChecks(uint64(l))
	}
	if len(m.ProxyConnectHeaders) > 0 {
		for _, s := range m.ProxyConnectHeaders {
			l = len(s)
			n += 2 + l + sovChecks(uint64(l))
		}
	}
	if m.FailIfSSL {
		n += 3
	}
	if m.FailIfNotSSL {
		n += 3
	}
	if len(m.ValidStatusCodes) > 0 {
		l = 0
		for _, e := range m.ValidStatusCodes {
			l += sovChecks(uint64(e))
		}
		n += 2 + sovChecks(uint64(l)) + l
	}
	if len(m.ValidHTTPVersions) > 0 {
		for _, s := range m.ValidHTTPVersions {
			l = len(s)
			n += 2 + l + sovChecks(uint64(l))
		}
	}
	if len(m.FailIfBodyMatchesRegexp) > 0 {
		for _, s := range m.FailIfBodyMatchesRegexp {
			l = len(s)
			n += 2 + l + sovChecks(uint64(l))
		}
	}
	if len(m.FailIfBodyNotMatchesRegexp) > 0 {
		for _, s := range m.FailIfBodyNotMatchesRegexp {
			l = len(s)
			n += 2 + l + sovChecks(uint64(l))
		}
	}
	if len(m.FailIfHeaderMatchesRegexp) > 0 {
		for _, e := range m.FailIfHeaderMatchesRegexp {
			l = e.Size()
			n += 2 + l + sovChecks(uint64(l))
		}
	}
	if len(m.FailIfHeaderNotMatchesRegexp) > 0 {
		for _, e := range m.FailIfHeaderNotMatchesRegexp {
			l = e.Size()
			n += 2 + l + sovChecks(uint64(l))
		}
	}
	if m.Compression != 0 {
		n += 2 + sovChecks(uint64(m.Compression))
	}
	l = len(m.CacheBustingQueryParamName)
	if l > 0 {
		n += 2 + l + sovChecks(uint64(l))
	}
	return n
}

func (m *OAuth2Config) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClientId)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	l = len(m.ClientSecret)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	l = len(m.TokenURL)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	if len(m.Scopes) > 0 {
		for _, s := range m.Scopes {
			l = len(s)
			n += 1 + l + sovChecks(uint64(l))
		}
	}
	if len(m.EndpointParams) > 0 {
		for _, e := range m.EndpointParams {
			l = e.Size()
			n += 1 + l + sovChecks(uint64(l))
		}
	}
	if m.TlsConfig != nil {
		l = m.TlsConfig.Size()
		n += 1 + l + sovChecks(uint64(l))
	}
	l = len(m.ProxyURL)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	return n
}

func (m *HeaderMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Header)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	l = len(m.Regexp)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	if m.AllowMissing {
		n += 2
	}
	return n
}

func (m *DNSRRValidator) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.FailIfMatchesRegexp) > 0 {
		for _, s := range m.FailIfMatchesRegexp {
			l = len(s)
			n += 1 + l + sovChecks(uint64(l))
		}
	}
	if len(m.FailIfNotMatchesRegexp) > 0 {
		for _, s := range m.FailIfNotMatchesRegexp {
			l = len(s)
			n += 1 + l + sovChecks(uint64(l))
		}
	}
	return n
}

func (m *DnsSettings) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.IpVersion != 0 {
		n += 1 + sovChecks(uint64(m.IpVersion))
	}
	l = len(m.SourceIpAddress)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	l = len(m.Server)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	if m.Port != 0 {
		n += 1 + sovChecks(uint64(m.Port))
	}
	if m.RecordType != 0 {
		n += 1 + sovChecks(uint64(m.RecordType))
	}
	if m.Protocol != 0 {
		n += 1 + sovChecks(uint64(m.Protocol))
	}
	if len(m.ValidRCodes) > 0 {
		for _, s := range m.ValidRCodes {
			l = len(s)
			n += 2 + l + sovChecks(uint64(l))
		}
	}
	if m.ValidateAnswer != nil {
		l = m.ValidateAnswer.Size()
		n += 2 + l + sovChecks(uint64(l))
	}
	if m.ValidateAuthority != nil {
		l = m.ValidateAuthority.Size()
		n += 2 + l + sovChecks(uint64(l))
	}
	if m.ValidateAdditional != nil {
		l = m.ValidateAdditional.Size()
		n += 2 + l + sovChecks(uint64(l))
	}
	return n
}

func (m *TcpSettings) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.IpVersion != 0 {
		n += 1 + sovChecks(uint64(m.IpVersion))
	}
	l = len(m.SourceIpAddress)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	if m.Tls {
		n += 2
	}
	if m.TlsConfig != nil {
		l = m.TlsConfig.Size()
		n += 1 + l + sovChecks(uint64(l))
	}
	if len(m.QueryResponse) > 0 {
		for _, e := range m.QueryResponse {
			l = e.Size()
			n += 1 + l + sovChecks(uint64(l))
		}
	}
	return n
}

func (m *TCPQueryResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Send)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	l = len(m.Expect)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	if m.StartTLS {
		n += 2
	}
	return n
}

func (m *TLSConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.InsecureSkipVerify {
		n += 2
	}
	l = len(m.CACert)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	l = len(m.ClientCert)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	l = len(m.ClientKey)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	l = len(m.ServerName)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	return n
}

func (m *BasicAuth) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Username)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	l = len(m.Password)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	return n
}

func (m *TracerouteSettings) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MaxHops != 0 {
		n += 1 + sovChecks(uint64(m.MaxHops))
	}
	if m.MaxUnknownHops != 0 {
		n += 1 + sovChecks(uint64(m.MaxUnknownHops))
	}
	if m.PtrLookup {
		n += 2
	}
	if m.HopTimeout != 0 {
		n += 1 + sovChecks(uint64(m.HopTimeout))
	}
	return n
}

func (m *ScriptedSettings) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Script)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	return n
}

func (m *MultiHttpSettings) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Entries) > 0 {
		for _, e := range m.Entries {
			l = e.Size()
			n += 1 + l + sovChecks(uint64(l))
		}
	}
	if m.LogResponses {
		n += 2
	}
	return n
}

func (m *MultiHttpEntry) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Request != nil {
		l = m.Request.Size()
		n += 1 + l + sovChecks(uint64(l))
	}
	if len(m.Assertions) > 0 {
		for _, e := range m.Assertions {
			l = e.Size()
			n += 1 + l + sovChecks(uint64(l))
		}
	}
	if len(m.Variables) > 0 {
		for _, e := range m.Variables {
			l = e.Size()
			n += 1 + l + sovChecks(uint64(l))
		}
	}
	return n
}

func (m *HttpHeader) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	return n
}

func (m *QueryField) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	return n
}

func (m *MultiHttpEntryRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Method != 0 {
		n += 1 + sovChecks(uint64(m.Method))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	if len(m.Headers) > 0 {
		for _, e := range m.Headers {
			l = e.Size()
			n += 1 + l + sovChecks(uint64(l))
		}
	}
	if len(m.QueryFields) > 0 {
		for _, e := range m.QueryFields {
			l = e.Size()
			n += 1 + l + sovChecks(uint64(l))
		}
	}
	if m.Body != nil {
		l = m.Body.Size()
		n += 1 + l + sovChecks(uint64(l))
	}
	return n
}

func (m *HttpRequestBody) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContentType)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	l = len(m.ContentEncoding)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	l = len(m.Payload)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	return n
}

func (m *MultiHttpEntryAssertion) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovChecks(uint64(m.Type))
	}
	if m.Subject != 0 {
		n += 1 + sovChecks(uint64(m.Subject))
	}
	if m.Condition != 0 {
		n += 1 + sovChecks(uint64(m.Condition))
	}
	l = len(m.Expression)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	return n
}

func (m *MultiHttpEntryVariable) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovChecks(uint64(m.Type))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	l = len(m.Expression)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	l = len(m.Attribute)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	return n
}

func (m *GrpcSettings) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.IpVersion != 0 {
		n += 1 + sovChecks(uint64(m.IpVersion))
	}
	l = len(m.Service)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	if m.Tls {
		n += 2
	}
	if m.TlsConfig != nil {
		l = m.TlsConfig.Size()
		n += 1 + l + sovChecks(uint64(l))
	}
	return n
}

func (m *RegionTelemetry) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Instance)
	if l > 0 {
		n += 1 + l + sovChecks(uint64(l))
	}
	if m.RegionId != 0 {
		n += 1 + sovChecks(uint64(m.RegionId))
	}
	if len(m.Telemetry) > 0 {
		for _, e := range m.Telemetry {
			l = e.Size()
			n += 1 + l + sovChecks(uint64(l))
		}
	}
	return n
}

func (m *TenantTelemetry) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TenantId != 0 {
		n += 1 + sovChecks(uint64(m.TenantId))
	}
	if len(m.Telemetry) > 0 {
		for _, e := range m.Telemetry {
			l = e.Size()
			n += 1 + l + sovChecks(uint64(l))
		}
	}
	return n
}

func (m *CheckClassTelemetry) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CheckClass != 0 {
		n += 1 + sovChecks(uint64(m.CheckClass))
	}
	if m.Executions != 0 {
		n += 1 + sovChecks(uint64(m.Executions))
	}
	if m.Duration != 0 {
		n += 5
	}
	if m.SampledExecutions != 0 {
		n += 1 + sovChecks(uint64(m.SampledExecutions))
	}
	return n
}

func (m *PushTelemetryResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Status != nil {
		l = m.Status.Size()
		n += 1 + l + sovChecks(uint64(l))
	}
	return n
}

func sovChecks(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozChecks(x uint64) (n int) {
	return sovChecks(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *CheckSettings) GetValue() interface{} {
	if this.Ping != nil {
		return this.Ping
	}
	if this.Http != nil {
		return this.Http
	}
	if this.Dns != nil {
		return this.Dns
	}
	if this.Tcp != nil {
		return this.Tcp
	}
	if this.Traceroute != nil {
		return this.Traceroute
	}
	if this.Scripted != nil {
		return this.Scripted
	}
	if this.Multihttp != nil {
		return this.Multihttp
	}
	if this.Grpc != nil {
		return this.Grpc
	}
	return nil
}

func (this *CheckSettings) SetValue(value interface{}) bool {
	switch vt := value.(type) {
	case *PingSettings:
		this.Ping = vt
	case *HttpSettings:
		this.Http = vt
	case *DnsSettings:
		this.Dns = vt
	case *TcpSettings:
		this.Tcp = vt
	case *TracerouteSettings:
		this.Traceroute = vt
	case *ScriptedSettings:
		this.Scripted = vt
	case *MultiHttpSettings:
		this.Multihttp = vt
	case *GrpcSettings:
		this.Grpc = vt
	default:
		return false
	}
	return true
}
func (m *Void) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Void: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Void: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProbeState) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProbeState: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProbeState: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Checks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Checks = append(m.Checks, EntityRef{})
			if err := m.Checks[len(m.Checks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tenants", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tenants = append(m.Tenants, EntityRef{})
			if err := m.Tenants[len(m.Tenants)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EntityRef) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EntityRef: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EntityRef: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastModified", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.LastModified = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProbeInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProbeInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProbeInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Commit", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Commit = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Buildstamp", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Buildstamp = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PingRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PingRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PingRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sequence", wireType)
			}
			m.Sequence = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Sequence |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PongResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PongResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PongResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sequence", wireType)
			}
			m.Sequence = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Sequence |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Status) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Status: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Status: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Code", wireType)
			}
			m.Code = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Code |= StatusCode(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RegisterProbeResult) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RegisterProbeResult: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RegisterProbeResult: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Probe", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Probe.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Probe) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Probe: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Probe: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TenantId", wireType)
			}
			m.TenantId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TenantId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field Latitude", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.Latitude = float32(math.Float32frombits(v))
		case 5:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field Longitude", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.Longitude = float32(math.Float32frombits(v))
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Labels = append(m.Labels, Label{})
			if err := m.Labels[len(m.Labels)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Region", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Region = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Public", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Public = bool(v != 0)
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Online", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Online = bool(v != 0)
		case 10:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field OnlineChange", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.OnlineChange = float64(math.Float64frombits(v))
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Commit", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Commit = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Buildstamp", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Buildstamp = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deprecated", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Deprecated = bool(v != 0)
		case 100:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Created", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Created = float64(math.Float64frombits(v))
		case 101:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Modified", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Modified = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TenantInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TenantInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TenantInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TenantLimits) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TenantLimits: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TenantLimits: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxChecks", wireType)
			}
			m.MaxChecks = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxChecks |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxScriptedChecks", wireType)
			}
			m.MaxScriptedChecks = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxScriptedChecks |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxMetricLabels", wireType)
			}
			m.MaxMetricLabels = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxMetricLabels |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxLogLabels", wireType)
			}
			m.MaxLogLabels = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxLogLabels |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tenant) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Tenant: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Tenant: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrgId", wireType)
			}
			m.OrgId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.OrgId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MetricsRemote", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MetricsRemote == nil {
				m.MetricsRemote = &RemoteInfo{}
			}
			if err := m.MetricsRemote.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EventsRemote", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EventsRemote == nil {
				m.EventsRemote = &RemoteInfo{}
			}
			if err := m.EventsRemote.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StackId", wireType)
			}
			m.StackId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StackId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= TenantStatus(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reason", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Reason = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limits", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Limits == nil {
				m.Limits = &TenantLimits{}
			}
			if err := m.Limits.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 100:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Created", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Created = float64(math.Float64frombits(v))
		case 101:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Modified", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Modified = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemoteInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoteInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoteInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Username", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Username = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Password", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Password = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckChange) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckChange: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckChange: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Operation", wireType)
			}
			m.Operation = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Operation |= CheckOperation(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Check", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Check.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Changes) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Changes: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Changes: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Checks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Checks = append(m.Checks, CheckChange{})
			if err := m.Checks[len(m.Checks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tenants", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tenants = append(m.Tenants, Tenant{})
			if err := m.Tenants[len(m.Tenants)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDeltaFirstBatch", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDeltaFirstBatch = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdHocRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdHocRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdHocRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdHocCheck", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.AdHocCheck.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tenant", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Tenant == nil {
				m.Tenant = &Tenant{}
			}
			if err := m.Tenant.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Label) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Label: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Label: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Check) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Check: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Check: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TenantId", wireType)
			}
			m.TenantId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TenantId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Frequency", wireType)
			}
			m.Frequency = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Frequency |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Offset", wireType)
			}
			m.Offset = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Offset |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timeout", wireType)
			}
			m.Timeout = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Timeout |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Enabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Enabled = bool(v != 0)
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Labels = append(m.Labels, Label{})
			if err := m.Labels[len(m.Labels)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Settings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Settings.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType == 0 {
				var v int64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowChecks
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Probes = append(m.Probes, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowChecks
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthChecks
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthChecks
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.Probes) == 0 {
					m.Probes = make([]int64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowChecks
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Probes = append(m.Probes, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Probes", wireType)
			}
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Target", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Target = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Job", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Job = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BasicMetricsOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.BasicMetricsOnly = bool(v != 0)
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AlertSensitivity", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AlertSensitivity = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 100:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Created", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Created = float64(math.Float64frombits(v))
		case 101:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Modified", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Modified = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdHocCheck) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdHocCheck: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdHocCheck: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TenantId", wireType)
			}
			m.TenantId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TenantId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timeout", wireType)
			}
			m.Timeout = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Timeout |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Settings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Settings.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType == 0 {
				var v int64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowChecks
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Probes = append(m.Probes, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowChecks
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthChecks
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthChecks
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.Probes) == 0 {
					m.Probes = make([]int64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowChecks
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Probes = append(m.Probes, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Probes", wireType)
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Target", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Target = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckSettings) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckSettings: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckSettings: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ping", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Ping == nil {
				m.Ping = &PingSettings{}
			}
			if err := m.Ping.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Http", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Http == nil {
				m.Http = &HttpSettings{}
			}
			if err := m.Http.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dns", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Dns == nil {
				m.Dns = &DnsSettings{}
			}
			if err := m.Dns.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tcp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Tcp == nil {
				m.Tcp = &TcpSettings{}
			}
			if err := m.Tcp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Traceroute", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Traceroute == nil {
				m.Traceroute = &TracerouteSettings{}
			}
			if err := m.Traceroute.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scripted", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Scripted == nil {
				m.Scripted = &ScriptedSettings{}
			}
			if err := m.Scripted.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Multihttp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Multihttp == nil {
				m.Multihttp = &MultiHttpSettings{}
			}
			if err := m.Multihttp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Grpc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Grpc == nil {
				m.Grpc = &GrpcSettings{}
			}
			if err := m.Grpc.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PingSettings) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PingSettings: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PingSettings: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IpVersion", wireType)
			}
			m.IpVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IpVersion |= IpVersion(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceIpAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceIpAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PayloadSize", wireType)
			}
			m.PayloadSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PayloadSize |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DontFragment", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DontFragment = bool(v != 0)
		case 900:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PacketCount", wireType)
			}
			m.PacketCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PacketCount |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HttpSettings) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HttpSettings: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HttpSettings: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IpVersion", wireType)
			}
			m.IpVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IpVersion |= IpVersion(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Method", wireType)
			}
			m.Method = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Method |= HttpMethod(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Headers", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Headers = append(m.Headers, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Body", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Body = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NoFollowRedirects", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NoFollowRedirects = bool(v != 0)
		case 100:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TlsConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TlsConfig == nil {
				m.TlsConfig = &TLSConfig{}
			}
			if err := m.TlsConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 101:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BasicAuth", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BasicAuth == nil {
				m.BasicAuth = &BasicAuth{}
			}
			if err := m.BasicAuth.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 102:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BearerToken", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BearerToken = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 103:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProxyURL", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProxyURL = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 104:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Oauth2Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Oauth2Config == nil {
				m.Oauth2Config = &OAuth2Config{}
			}
			if err := m.Oauth2Config.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 105:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProxyConnectHeaders", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProxyConnectHeaders = append(m.ProxyConnectHeaders, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 200:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailIfSSL", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.FailIfSSL = bool(v != 0)
		case 201:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailIfNotSSL", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.FailIfNotSSL = bool(v != 0)
		case 202:
			if wireType == 0 {
				var v int32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowChecks
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int32(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.ValidStatusCodes = append(m.ValidStatusCodes, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowChecks
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthChecks
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthChecks
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.ValidStatusCodes) == 0 {
					m.ValidStatusCodes = make([]int32, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowChecks
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.ValidStatusCodes = append(m.ValidStatusCodes, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field ValidStatusCodes", wireType)
			}
		case 203:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValidHTTPVersions", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ValidHTTPVersions = append(m.ValidHTTPVersions, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 204:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailIfBodyMatchesRegexp", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FailIfBodyMatchesRegexp = append(m.FailIfBodyMatchesRegexp, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 205:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailIfBodyNotMatchesRegexp", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FailIfBodyNotMatchesRegexp = append(m.FailIfBodyNotMatchesRegexp, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 206:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailIfHeaderMatchesRegexp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FailIfHeaderMatchesRegexp = append(m.FailIfHeaderMatchesRegexp, HeaderMatch{})
			if err := m.FailIfHeaderMatchesRegexp[len(m.FailIfHeaderMatchesRegexp)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 207:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailIfHeaderNotMatchesRegexp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FailIfHeaderNotMatchesRegexp = append(m.FailIfHeaderNotMatchesRegexp, HeaderMatch{})
			if err := m.FailIfHeaderNotMatchesRegexp[len(m.FailIfHeaderNotMatchesRegexp)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 208:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Compression", wireType)
			}
			m.Compression = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Compression |= CompressionAlgorithm(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 900:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CacheBustingQueryParamName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CacheBustingQueryParamName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OAuth2Config) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OAuth2Config: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OAuth2Config: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientSecret", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientSecret = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TokenURL", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TokenURL = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scopes", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Scopes = append(m.Scopes, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndpointParams", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndpointParams = append(m.EndpointParams, Label{})
			if err := m.EndpointParams[len(m.EndpointParams)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TlsConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TlsConfig == nil {
				m.TlsConfig = &TLSConfig{}
			}
			if err := m.TlsConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProxyURL", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProxyURL = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HeaderMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HeaderMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HeaderMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Header", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Header = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Regexp", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Regexp = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllowMissing", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AllowMissing = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DNSRRValidator) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DNSRRValidator: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DNSRRValidator: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailIfMatchesRegexp", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FailIfMatchesRegexp = append(m.FailIfMatchesRegexp, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailIfNotMatchesRegexp", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FailIfNotMatchesRegexp = append(m.FailIfNotMatchesRegexp, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DnsSettings) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DnsSettings: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DnsSettings: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IpVersion", wireType)
			}
			m.IpVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IpVersion |= IpVersion(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceIpAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceIpAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Server", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Server = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			m.Port = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Port |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RecordType", wireType)
			}
			m.RecordType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RecordType |= DnsRecordType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			m.Protocol = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Protocol |= DnsProtocol(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 200:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValidRCodes", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ValidRCodes = append(m.ValidRCodes, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 201:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValidateAnswer", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ValidateAnswer == nil {
				m.ValidateAnswer = &DNSRRValidator{}
			}
			if err := m.ValidateAnswer.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 202:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValidateAuthority", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ValidateAuthority == nil {
				m.ValidateAuthority = &DNSRRValidator{}
			}
			if err := m.ValidateAuthority.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 203:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValidateAdditional", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ValidateAdditional == nil {
				m.ValidateAdditional = &DNSRRValidator{}
			}
			if err := m.ValidateAdditional.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TcpSettings) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TcpSettings: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TcpSettings: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IpVersion", wireType)
			}
			m.IpVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IpVersion |= IpVersion(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceIpAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceIpAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tls", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Tls = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TlsConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TlsConfig == nil {
				m.TlsConfig = &TLSConfig{}
			}
			if err := m.TlsConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueryResponse", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.QueryResponse = append(m.QueryResponse, TCPQueryResponse{})
			if err := m.QueryResponse[len(m.QueryResponse)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TCPQueryResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TCPQueryResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TCPQueryResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Send", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Send = append(m.Send[:0], dAtA[iNdEx:postIndex]...)
			if m.Send == nil {
				m.Send = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Expect", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Expect = append(m.Expect[:0], dAtA[iNdEx:postIndex]...)
			if m.Expect == nil {
				m.Expect = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTLS", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.StartTLS = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TLSConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TLSConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TLSConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InsecureSkipVerify", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.InsecureSkipVerify = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CACert", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CACert = append(m.CACert[:0], dAtA[iNdEx:postIndex]...)
			if m.CACert == nil {
				m.CACert = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientCert", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientCert = append(m.ClientCert[:0], dAtA[iNdEx:postIndex]...)
			if m.ClientCert == nil {
				m.ClientCert = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientKey = append(m.ClientKey[:0], dAtA[iNdEx:postIndex]...)
			if m.ClientKey == nil {
				m.ClientKey = []byte{}
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServerName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServerName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BasicAuth) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BasicAuth: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BasicAuth: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Username", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Username = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Password", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Password = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TracerouteSettings) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TracerouteSettings: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TracerouteSettings: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxHops", wireType)
			}
			m.MaxHops = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxHops |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxUnknownHops", wireType)
			}
			m.MaxUnknownHops = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxUnknownHops |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PtrLookup", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.PtrLookup = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HopTimeout", wireType)
			}
			m.HopTimeout = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HopTimeout |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScriptedSettings) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScriptedSettings: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScriptedSettings: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Script", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Script = append(m.Script[:0], dAtA[iNdEx:postIndex]...)
			if m.Script == nil {
				m.Script = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MultiHttpSettings) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MultiHttpSettings: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MultiHttpSettings: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Entries", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Entries = append(m.Entries, &MultiHttpEntry{})
			if err := m.Entries[len(m.Entries)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LogResponses", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LogResponses = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MultiHttpEntry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MultiHttpEntry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MultiHttpEntry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Request", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Request == nil {
				m.Request = &MultiHttpEntryRequest{}
			}
			if err := m.Request.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Assertions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Assertions = append(m.Assertions, &MultiHttpEntryAssertion{})
			if err := m.Assertions[len(m.Assertions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Variables", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Variables = append(m.Variables, &MultiHttpEntryVariable{})
			if err := m.Variables[len(m.Variables)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HttpHeader) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HttpHeader: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HttpHeader: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryField) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryField: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryField: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MultiHttpEntryRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MultiHttpEntryRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MultiHttpEntryRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Method", wireType)
			}
			m.Method = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Method |= HttpMethod(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Headers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Headers = append(m.Headers, &HttpHeader{})
			if err := m.Headers[len(m.Headers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueryFields", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.QueryFields = append(m.QueryFields, &QueryField{})
			if err := m.QueryFields[len(m.QueryFields)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Body", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Body == nil {
				m.Body = &HttpRequestBody{}
			}
			if err := m.Body.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HttpRequestBody) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HttpRequestBody: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HttpRequestBody: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContentType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContentType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContentEncoding", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContentEncoding = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Payload", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Payload = append(m.Payload[:0], dAtA[iNdEx:postIndex]...)
			if m.Payload == nil {
				m.Payload = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MultiHttpEntryAssertion) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MultiHttpEntryAssertion: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MultiHttpEntryAssertion: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= MultiHttpEntryAssertionType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subject", wireType)
			}
			m.Subject = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Subject |= MultiHttpEntryAssertionSubjectVariant(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Condition", wireType)
			}
			m.Condition = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Condition |= MultiHttpEntryAssertionConditionVariant(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Expression", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Expression = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MultiHttpEntryVariable) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MultiHttpEntryVariable: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MultiHttpEntryVariable: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= MultiHttpEntryVariableType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Expression", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Expression = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attribute", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attribute = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GrpcSettings) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GrpcSettings: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GrpcSettings: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IpVersion", wireType)
			}
			m.IpVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IpVersion |= IpVersion(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Service", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Service = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tls", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Tls = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TlsConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TlsConfig == nil {
				m.TlsConfig = &TLSConfig{}
			}
			if err := m.TlsConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RegionTelemetry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RegionTelemetry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RegionTelemetry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Instance", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Instance = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionId", wireType)
			}
			m.RegionId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RegionId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Telemetry", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Telemetry = append(m.Telemetry, &TenantTelemetry{})
			if err := m.Telemetry[len(m.Telemetry)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TenantTelemetry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TenantTelemetry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TenantTelemetry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TenantId", wireType)
			}
			m.TenantId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TenantId |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Telemetry", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Telemetry = append(m.Telemetry, &CheckClassTelemetry{})
			if err := m.Telemetry[len(m.Telemetry)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckClassTelemetry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckClassTelemetry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckClassTelemetry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CheckClass", wireType)
			}
			m.CheckClass = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CheckClass |= CheckClass(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Executions", wireType)
			}
			m.Executions = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Executions |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field Duration", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.Duration = float32(math.Float32frombits(v))
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SampledExecutions", wireType)
			}
			m.SampledExecutions = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SampledExecutions |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PushTelemetryResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PushTelemetryResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PushTelemetryResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthChecks
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthChecks
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Status == nil {
				m.Status = &Status{}
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipChecks(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthChecks
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipChecks(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowChecks
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowChecks
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthChecks
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupChecks
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthChecks
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthChecks        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowChecks          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupChecks = fmt.Errorf("proto: unexpected end of group")
)
