// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/datafusion/v1/datafusion.proto

package datafusionpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	DataFusion_ListAvailableVersions_FullMethodName = "/google.cloud.datafusion.v1.DataFusion/ListAvailableVersions"
	DataFusion_ListInstances_FullMethodName         = "/google.cloud.datafusion.v1.DataFusion/ListInstances"
	DataFusion_GetInstance_FullMethodName           = "/google.cloud.datafusion.v1.DataFusion/GetInstance"
	DataFusion_CreateInstance_FullMethodName        = "/google.cloud.datafusion.v1.DataFusion/CreateInstance"
	DataFusion_DeleteInstance_FullMethodName        = "/google.cloud.datafusion.v1.DataFusion/DeleteInstance"
	DataFusion_UpdateInstance_FullMethodName        = "/google.cloud.datafusion.v1.DataFusion/UpdateInstance"
	DataFusion_RestartInstance_FullMethodName       = "/google.cloud.datafusion.v1.DataFusion/RestartInstance"
)

// DataFusionClient is the client API for DataFusion service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type DataFusionClient interface {
	// Lists possible versions for Data Fusion instances in the specified project
	// and location.
	ListAvailableVersions(ctx context.Context, in *ListAvailableVersionsRequest, opts ...grpc.CallOption) (*ListAvailableVersionsResponse, error)
	// Lists Data Fusion instances in the specified project and location.
	ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error)
	// Gets details of a single Data Fusion instance.
	GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error)
	// Creates a new Data Fusion instance in the specified project and location.
	CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Date Fusion instance.
	DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a single Data Fusion instance.
	UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Restart a single Data Fusion instance.
	// At the end of an operation instance is fully restarted.
	RestartInstance(ctx context.Context, in *RestartInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type dataFusionClient struct {
	cc grpc.ClientConnInterface
}

func NewDataFusionClient(cc grpc.ClientConnInterface) DataFusionClient {
	return &dataFusionClient{cc}
}

func (c *dataFusionClient) ListAvailableVersions(ctx context.Context, in *ListAvailableVersionsRequest, opts ...grpc.CallOption) (*ListAvailableVersionsResponse, error) {
	out := new(ListAvailableVersionsResponse)
	err := c.cc.Invoke(ctx, DataFusion_ListAvailableVersions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataFusionClient) ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error) {
	out := new(ListInstancesResponse)
	err := c.cc.Invoke(ctx, DataFusion_ListInstances_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataFusionClient) GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := c.cc.Invoke(ctx, DataFusion_GetInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataFusionClient) CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataFusion_CreateInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataFusionClient) DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataFusion_DeleteInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataFusionClient) UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataFusion_UpdateInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataFusionClient) RestartInstance(ctx context.Context, in *RestartInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataFusion_RestartInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataFusionServer is the server API for DataFusion service.
// All implementations should embed UnimplementedDataFusionServer
// for forward compatibility
type DataFusionServer interface {
	// Lists possible versions for Data Fusion instances in the specified project
	// and location.
	ListAvailableVersions(context.Context, *ListAvailableVersionsRequest) (*ListAvailableVersionsResponse, error)
	// Lists Data Fusion instances in the specified project and location.
	ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error)
	// Gets details of a single Data Fusion instance.
	GetInstance(context.Context, *GetInstanceRequest) (*Instance, error)
	// Creates a new Data Fusion instance in the specified project and location.
	CreateInstance(context.Context, *CreateInstanceRequest) (*longrunningpb.Operation, error)
	// Deletes a single Date Fusion instance.
	DeleteInstance(context.Context, *DeleteInstanceRequest) (*longrunningpb.Operation, error)
	// Updates a single Data Fusion instance.
	UpdateInstance(context.Context, *UpdateInstanceRequest) (*longrunningpb.Operation, error)
	// Restart a single Data Fusion instance.
	// At the end of an operation instance is fully restarted.
	RestartInstance(context.Context, *RestartInstanceRequest) (*longrunningpb.Operation, error)
}

// UnimplementedDataFusionServer should be embedded to have forward compatible implementations.
type UnimplementedDataFusionServer struct {
}

func (UnimplementedDataFusionServer) ListAvailableVersions(context.Context, *ListAvailableVersionsRequest) (*ListAvailableVersionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAvailableVersions not implemented")
}
func (UnimplementedDataFusionServer) ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInstances not implemented")
}
func (UnimplementedDataFusionServer) GetInstance(context.Context, *GetInstanceRequest) (*Instance, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInstance not implemented")
}
func (UnimplementedDataFusionServer) CreateInstance(context.Context, *CreateInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateInstance not implemented")
}
func (UnimplementedDataFusionServer) DeleteInstance(context.Context, *DeleteInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteInstance not implemented")
}
func (UnimplementedDataFusionServer) UpdateInstance(context.Context, *UpdateInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateInstance not implemented")
}
func (UnimplementedDataFusionServer) RestartInstance(context.Context, *RestartInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestartInstance not implemented")
}

// UnsafeDataFusionServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DataFusionServer will
// result in compilation errors.
type UnsafeDataFusionServer interface {
	mustEmbedUnimplementedDataFusionServer()
}

func RegisterDataFusionServer(s grpc.ServiceRegistrar, srv DataFusionServer) {
	s.RegisterService(&DataFusion_ServiceDesc, srv)
}

func _DataFusion_ListAvailableVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAvailableVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataFusionServer).ListAvailableVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataFusion_ListAvailableVersions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataFusionServer).ListAvailableVersions(ctx, req.(*ListAvailableVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataFusion_ListInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataFusionServer).ListInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataFusion_ListInstances_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataFusionServer).ListInstances(ctx, req.(*ListInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataFusion_GetInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataFusionServer).GetInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataFusion_GetInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataFusionServer).GetInstance(ctx, req.(*GetInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataFusion_CreateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataFusionServer).CreateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataFusion_CreateInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataFusionServer).CreateInstance(ctx, req.(*CreateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataFusion_DeleteInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataFusionServer).DeleteInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataFusion_DeleteInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataFusionServer).DeleteInstance(ctx, req.(*DeleteInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataFusion_UpdateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataFusionServer).UpdateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataFusion_UpdateInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataFusionServer).UpdateInstance(ctx, req.(*UpdateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataFusion_RestartInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestartInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataFusionServer).RestartInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataFusion_RestartInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataFusionServer).RestartInstance(ctx, req.(*RestartInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// DataFusion_ServiceDesc is the grpc.ServiceDesc for DataFusion service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var DataFusion_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.datafusion.v1.DataFusion",
	HandlerType: (*DataFusionServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListAvailableVersions",
			Handler:    _DataFusion_ListAvailableVersions_Handler,
		},
		{
			MethodName: "ListInstances",
			Handler:    _DataFusion_ListInstances_Handler,
		},
		{
			MethodName: "GetInstance",
			Handler:    _DataFusion_GetInstance_Handler,
		},
		{
			MethodName: "CreateInstance",
			Handler:    _DataFusion_CreateInstance_Handler,
		},
		{
			MethodName: "DeleteInstance",
			Handler:    _DataFusion_DeleteInstance_Handler,
		},
		{
			MethodName: "UpdateInstance",
			Handler:    _DataFusion_UpdateInstance_Handler,
		},
		{
			MethodName: "RestartInstance",
			Handler:    _DataFusion_RestartInstance_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/datafusion/v1/datafusion.proto",
}
