//go:build linux
// +build linux

package fake

import (
	"encoding/hex"
	"fmt"

	"github.com/Microsoft/hcsshim/pkg/amdsevsnp"
)

const fakeSNPReport = "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"

// FetchRawSNPReport hex decodes fakeSNPReport.
func FetchRawSNPReport() ([]byte, error) {
	return hex.DecodeString(fakeSNPReport)
}

// FetchSNPReport returns amdsev.Report object that corresponds to the decoded
// version of fakeSNPReport. Overrides the resulting report's HostData field
// with provided `hostData`.
func FetchSNPReport(hostData string) (amdsevsnp.Report, error) {
	if hostData == "" {
		hostData = "28603a3ea835a83bd688b0ec1dcb36b6b8c22412e5b63115b75db8628b989bc5"
	}
	hdBytes, err := hex.DecodeString(hostData)
	if err != nil {
		return amdsevsnp.Report{}, fmt.Errorf("failed to decode host data: %w", err)
	}
	r := amdsevsnp.Report{
		Version:          1,
		GuestSVN:         1,
		Policy:           0x03001f,
		FamilyID:         "00000000000000000000000000000001",
		ImageID:          "00000000000000000000000000000001",
		VMPL:             0,
		SignatureAlgo:    1,
		PlatformVersion:  0x2800000000000000,
		PlatformInfo:     1,
		AuthorKeyEn:      0,
		ReportData:       "7ab000a323b3c873f5b81bbe584e7c1a26bcf40dc27e00f8e0d144b1ed2d14f10000000000000000000000000000000000000000000000000000000000000000",
		Measurement:      "e29af700e85b39996fa38226d2804b78cad746ffef4477360a61b47874bdecd640f9d32f5ff64a55baad3c545484d9ed",
		HostData:         hdBytes[:],
		IDKeyDigest:      "98c475ca5f7683e8d351e7e789a1baff19041750567161ad52bf0d152bd76d7c6f313d0a0fd72d0089692c18f5211558",
		AuthorKeyDigest:  "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
		ReportID:         "40aea62690b08eb6d680392c9a9b3db56a9b3cc44083b9da31fb88bcfc493407",
		ReportIDMA:       "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
		ReportTCB:        0x2800000000000000,
		ChipID:           "e6c86796cd44b0bc6b7c0d4fdab33e2807e14b5fc4538b3750921169d97bcf4447c7d3ab2a7c25f74c1641e2885c1011d025cc536f5c9a2504713136c7877f48",
		CommittedSVN:     "0000000000000000",
		CommittedVersion: "0000000000000000",
		LaunchSVN:        "0000000000000000",
		Signature:        "3131c0f3e7be5c6e400f22404596e1874381e99d03de45ef8b97eee0a0fa93a4911550330343f14dddbbd6c0db83744f000000000000000000000000000000000000000000000000db07c83c5e6162c2387f3b76cd547672657f6a5df99df98efee7c15349320d83e086c5003ec43050a9b18d1c39dedc340000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
	}
	return r, nil
}
