// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dataplex/v1/cmek.proto

package dataplexpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	CmekService_CreateEncryptionConfig_FullMethodName = "/google.cloud.dataplex.v1.CmekService/CreateEncryptionConfig"
	CmekService_UpdateEncryptionConfig_FullMethodName = "/google.cloud.dataplex.v1.CmekService/UpdateEncryptionConfig"
	CmekService_DeleteEncryptionConfig_FullMethodName = "/google.cloud.dataplex.v1.CmekService/DeleteEncryptionConfig"
	CmekService_ListEncryptionConfigs_FullMethodName  = "/google.cloud.dataplex.v1.CmekService/ListEncryptionConfigs"
	CmekService_GetEncryptionConfig_FullMethodName    = "/google.cloud.dataplex.v1.CmekService/GetEncryptionConfig"
)

// CmekServiceClient is the client API for CmekService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type CmekServiceClient interface {
	// Create an EncryptionConfig.
	CreateEncryptionConfig(ctx context.Context, in *CreateEncryptionConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Update an EncryptionConfig.
	UpdateEncryptionConfig(ctx context.Context, in *UpdateEncryptionConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Delete an EncryptionConfig.
	DeleteEncryptionConfig(ctx context.Context, in *DeleteEncryptionConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// List EncryptionConfigs.
	ListEncryptionConfigs(ctx context.Context, in *ListEncryptionConfigsRequest, opts ...grpc.CallOption) (*ListEncryptionConfigsResponse, error)
	// Get an EncryptionConfig.
	GetEncryptionConfig(ctx context.Context, in *GetEncryptionConfigRequest, opts ...grpc.CallOption) (*EncryptionConfig, error)
}

type cmekServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCmekServiceClient(cc grpc.ClientConnInterface) CmekServiceClient {
	return &cmekServiceClient{cc}
}

func (c *cmekServiceClient) CreateEncryptionConfig(ctx context.Context, in *CreateEncryptionConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CmekService_CreateEncryptionConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cmekServiceClient) UpdateEncryptionConfig(ctx context.Context, in *UpdateEncryptionConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CmekService_UpdateEncryptionConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cmekServiceClient) DeleteEncryptionConfig(ctx context.Context, in *DeleteEncryptionConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CmekService_DeleteEncryptionConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cmekServiceClient) ListEncryptionConfigs(ctx context.Context, in *ListEncryptionConfigsRequest, opts ...grpc.CallOption) (*ListEncryptionConfigsResponse, error) {
	out := new(ListEncryptionConfigsResponse)
	err := c.cc.Invoke(ctx, CmekService_ListEncryptionConfigs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cmekServiceClient) GetEncryptionConfig(ctx context.Context, in *GetEncryptionConfigRequest, opts ...grpc.CallOption) (*EncryptionConfig, error) {
	out := new(EncryptionConfig)
	err := c.cc.Invoke(ctx, CmekService_GetEncryptionConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CmekServiceServer is the server API for CmekService service.
// All implementations should embed UnimplementedCmekServiceServer
// for forward compatibility
type CmekServiceServer interface {
	// Create an EncryptionConfig.
	CreateEncryptionConfig(context.Context, *CreateEncryptionConfigRequest) (*longrunningpb.Operation, error)
	// Update an EncryptionConfig.
	UpdateEncryptionConfig(context.Context, *UpdateEncryptionConfigRequest) (*longrunningpb.Operation, error)
	// Delete an EncryptionConfig.
	DeleteEncryptionConfig(context.Context, *DeleteEncryptionConfigRequest) (*longrunningpb.Operation, error)
	// List EncryptionConfigs.
	ListEncryptionConfigs(context.Context, *ListEncryptionConfigsRequest) (*ListEncryptionConfigsResponse, error)
	// Get an EncryptionConfig.
	GetEncryptionConfig(context.Context, *GetEncryptionConfigRequest) (*EncryptionConfig, error)
}

// UnimplementedCmekServiceServer should be embedded to have forward compatible implementations.
type UnimplementedCmekServiceServer struct {
}

func (UnimplementedCmekServiceServer) CreateEncryptionConfig(context.Context, *CreateEncryptionConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEncryptionConfig not implemented")
}
func (UnimplementedCmekServiceServer) UpdateEncryptionConfig(context.Context, *UpdateEncryptionConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEncryptionConfig not implemented")
}
func (UnimplementedCmekServiceServer) DeleteEncryptionConfig(context.Context, *DeleteEncryptionConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEncryptionConfig not implemented")
}
func (UnimplementedCmekServiceServer) ListEncryptionConfigs(context.Context, *ListEncryptionConfigsRequest) (*ListEncryptionConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEncryptionConfigs not implemented")
}
func (UnimplementedCmekServiceServer) GetEncryptionConfig(context.Context, *GetEncryptionConfigRequest) (*EncryptionConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEncryptionConfig not implemented")
}

// UnsafeCmekServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to CmekServiceServer will
// result in compilation errors.
type UnsafeCmekServiceServer interface {
	mustEmbedUnimplementedCmekServiceServer()
}

func RegisterCmekServiceServer(s grpc.ServiceRegistrar, srv CmekServiceServer) {
	s.RegisterService(&CmekService_ServiceDesc, srv)
}

func _CmekService_CreateEncryptionConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEncryptionConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CmekServiceServer).CreateEncryptionConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CmekService_CreateEncryptionConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CmekServiceServer).CreateEncryptionConfig(ctx, req.(*CreateEncryptionConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CmekService_UpdateEncryptionConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEncryptionConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CmekServiceServer).UpdateEncryptionConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CmekService_UpdateEncryptionConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CmekServiceServer).UpdateEncryptionConfig(ctx, req.(*UpdateEncryptionConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CmekService_DeleteEncryptionConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEncryptionConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CmekServiceServer).DeleteEncryptionConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CmekService_DeleteEncryptionConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CmekServiceServer).DeleteEncryptionConfig(ctx, req.(*DeleteEncryptionConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CmekService_ListEncryptionConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEncryptionConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CmekServiceServer).ListEncryptionConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CmekService_ListEncryptionConfigs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CmekServiceServer).ListEncryptionConfigs(ctx, req.(*ListEncryptionConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CmekService_GetEncryptionConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEncryptionConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CmekServiceServer).GetEncryptionConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CmekService_GetEncryptionConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CmekServiceServer).GetEncryptionConfig(ctx, req.(*GetEncryptionConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// CmekService_ServiceDesc is the grpc.ServiceDesc for CmekService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var CmekService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataplex.v1.CmekService",
	HandlerType: (*CmekServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateEncryptionConfig",
			Handler:    _CmekService_CreateEncryptionConfig_Handler,
		},
		{
			MethodName: "UpdateEncryptionConfig",
			Handler:    _CmekService_UpdateEncryptionConfig_Handler,
		},
		{
			MethodName: "DeleteEncryptionConfig",
			Handler:    _CmekService_DeleteEncryptionConfig_Handler,
		},
		{
			MethodName: "ListEncryptionConfigs",
			Handler:    _CmekService_ListEncryptionConfigs_Handler,
		},
		{
			MethodName: "GetEncryptionConfig",
			Handler:    _CmekService_GetEncryptionConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dataplex/v1/cmek.proto",
}
