// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dataplex/v1/data_taxonomy.proto

package dataplexpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	DataTaxonomyService_CreateDataTaxonomy_FullMethodName         = "/google.cloud.dataplex.v1.DataTaxonomyService/CreateDataTaxonomy"
	DataTaxonomyService_UpdateDataTaxonomy_FullMethodName         = "/google.cloud.dataplex.v1.DataTaxonomyService/UpdateDataTaxonomy"
	DataTaxonomyService_DeleteDataTaxonomy_FullMethodName         = "/google.cloud.dataplex.v1.DataTaxonomyService/DeleteDataTaxonomy"
	DataTaxonomyService_ListDataTaxonomies_FullMethodName         = "/google.cloud.dataplex.v1.DataTaxonomyService/ListDataTaxonomies"
	DataTaxonomyService_GetDataTaxonomy_FullMethodName            = "/google.cloud.dataplex.v1.DataTaxonomyService/GetDataTaxonomy"
	DataTaxonomyService_CreateDataAttributeBinding_FullMethodName = "/google.cloud.dataplex.v1.DataTaxonomyService/CreateDataAttributeBinding"
	DataTaxonomyService_UpdateDataAttributeBinding_FullMethodName = "/google.cloud.dataplex.v1.DataTaxonomyService/UpdateDataAttributeBinding"
	DataTaxonomyService_DeleteDataAttributeBinding_FullMethodName = "/google.cloud.dataplex.v1.DataTaxonomyService/DeleteDataAttributeBinding"
	DataTaxonomyService_ListDataAttributeBindings_FullMethodName  = "/google.cloud.dataplex.v1.DataTaxonomyService/ListDataAttributeBindings"
	DataTaxonomyService_GetDataAttributeBinding_FullMethodName    = "/google.cloud.dataplex.v1.DataTaxonomyService/GetDataAttributeBinding"
	DataTaxonomyService_CreateDataAttribute_FullMethodName        = "/google.cloud.dataplex.v1.DataTaxonomyService/CreateDataAttribute"
	DataTaxonomyService_UpdateDataAttribute_FullMethodName        = "/google.cloud.dataplex.v1.DataTaxonomyService/UpdateDataAttribute"
	DataTaxonomyService_DeleteDataAttribute_FullMethodName        = "/google.cloud.dataplex.v1.DataTaxonomyService/DeleteDataAttribute"
	DataTaxonomyService_ListDataAttributes_FullMethodName         = "/google.cloud.dataplex.v1.DataTaxonomyService/ListDataAttributes"
	DataTaxonomyService_GetDataAttribute_FullMethodName           = "/google.cloud.dataplex.v1.DataTaxonomyService/GetDataAttribute"
)

// DataTaxonomyServiceClient is the client API for DataTaxonomyService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// Deprecated: Do not use.
type DataTaxonomyServiceClient interface {
	// Deprecated: Do not use.
	// Create a DataTaxonomy resource.
	CreateDataTaxonomy(ctx context.Context, in *CreateDataTaxonomyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Updates a DataTaxonomy resource.
	UpdateDataTaxonomy(ctx context.Context, in *UpdateDataTaxonomyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Deletes a DataTaxonomy resource. All attributes within the DataTaxonomy
	// must be deleted before the DataTaxonomy can be deleted.
	DeleteDataTaxonomy(ctx context.Context, in *DeleteDataTaxonomyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Lists DataTaxonomy resources in a project and location.
	ListDataTaxonomies(ctx context.Context, in *ListDataTaxonomiesRequest, opts ...grpc.CallOption) (*ListDataTaxonomiesResponse, error)
	// Deprecated: Do not use.
	// Retrieves a DataTaxonomy resource.
	GetDataTaxonomy(ctx context.Context, in *GetDataTaxonomyRequest, opts ...grpc.CallOption) (*DataTaxonomy, error)
	// Deprecated: Do not use.
	// Create a DataAttributeBinding resource.
	CreateDataAttributeBinding(ctx context.Context, in *CreateDataAttributeBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Updates a DataAttributeBinding resource.
	UpdateDataAttributeBinding(ctx context.Context, in *UpdateDataAttributeBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Deletes a DataAttributeBinding resource. All attributes within the
	// DataAttributeBinding must be deleted before the DataAttributeBinding can be
	// deleted.
	DeleteDataAttributeBinding(ctx context.Context, in *DeleteDataAttributeBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Lists DataAttributeBinding resources in a project and location.
	ListDataAttributeBindings(ctx context.Context, in *ListDataAttributeBindingsRequest, opts ...grpc.CallOption) (*ListDataAttributeBindingsResponse, error)
	// Deprecated: Do not use.
	// Retrieves a DataAttributeBinding resource.
	GetDataAttributeBinding(ctx context.Context, in *GetDataAttributeBindingRequest, opts ...grpc.CallOption) (*DataAttributeBinding, error)
	// Deprecated: Do not use.
	// Create a DataAttribute resource.
	CreateDataAttribute(ctx context.Context, in *CreateDataAttributeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Updates a DataAttribute resource.
	UpdateDataAttribute(ctx context.Context, in *UpdateDataAttributeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Deletes a Data Attribute resource.
	DeleteDataAttribute(ctx context.Context, in *DeleteDataAttributeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Lists Data Attribute resources in a DataTaxonomy.
	ListDataAttributes(ctx context.Context, in *ListDataAttributesRequest, opts ...grpc.CallOption) (*ListDataAttributesResponse, error)
	// Deprecated: Do not use.
	// Retrieves a Data Attribute resource.
	GetDataAttribute(ctx context.Context, in *GetDataAttributeRequest, opts ...grpc.CallOption) (*DataAttribute, error)
}

type dataTaxonomyServiceClient struct {
	cc grpc.ClientConnInterface
}

// Deprecated: Do not use.
func NewDataTaxonomyServiceClient(cc grpc.ClientConnInterface) DataTaxonomyServiceClient {
	return &dataTaxonomyServiceClient{cc}
}

// Deprecated: Do not use.
func (c *dataTaxonomyServiceClient) CreateDataTaxonomy(ctx context.Context, in *CreateDataTaxonomyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataTaxonomyService_CreateDataTaxonomy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataTaxonomyServiceClient) UpdateDataTaxonomy(ctx context.Context, in *UpdateDataTaxonomyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataTaxonomyService_UpdateDataTaxonomy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataTaxonomyServiceClient) DeleteDataTaxonomy(ctx context.Context, in *DeleteDataTaxonomyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataTaxonomyService_DeleteDataTaxonomy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataTaxonomyServiceClient) ListDataTaxonomies(ctx context.Context, in *ListDataTaxonomiesRequest, opts ...grpc.CallOption) (*ListDataTaxonomiesResponse, error) {
	out := new(ListDataTaxonomiesResponse)
	err := c.cc.Invoke(ctx, DataTaxonomyService_ListDataTaxonomies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataTaxonomyServiceClient) GetDataTaxonomy(ctx context.Context, in *GetDataTaxonomyRequest, opts ...grpc.CallOption) (*DataTaxonomy, error) {
	out := new(DataTaxonomy)
	err := c.cc.Invoke(ctx, DataTaxonomyService_GetDataTaxonomy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataTaxonomyServiceClient) CreateDataAttributeBinding(ctx context.Context, in *CreateDataAttributeBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataTaxonomyService_CreateDataAttributeBinding_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataTaxonomyServiceClient) UpdateDataAttributeBinding(ctx context.Context, in *UpdateDataAttributeBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataTaxonomyService_UpdateDataAttributeBinding_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataTaxonomyServiceClient) DeleteDataAttributeBinding(ctx context.Context, in *DeleteDataAttributeBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataTaxonomyService_DeleteDataAttributeBinding_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataTaxonomyServiceClient) ListDataAttributeBindings(ctx context.Context, in *ListDataAttributeBindingsRequest, opts ...grpc.CallOption) (*ListDataAttributeBindingsResponse, error) {
	out := new(ListDataAttributeBindingsResponse)
	err := c.cc.Invoke(ctx, DataTaxonomyService_ListDataAttributeBindings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataTaxonomyServiceClient) GetDataAttributeBinding(ctx context.Context, in *GetDataAttributeBindingRequest, opts ...grpc.CallOption) (*DataAttributeBinding, error) {
	out := new(DataAttributeBinding)
	err := c.cc.Invoke(ctx, DataTaxonomyService_GetDataAttributeBinding_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataTaxonomyServiceClient) CreateDataAttribute(ctx context.Context, in *CreateDataAttributeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataTaxonomyService_CreateDataAttribute_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataTaxonomyServiceClient) UpdateDataAttribute(ctx context.Context, in *UpdateDataAttributeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataTaxonomyService_UpdateDataAttribute_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataTaxonomyServiceClient) DeleteDataAttribute(ctx context.Context, in *DeleteDataAttributeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataTaxonomyService_DeleteDataAttribute_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataTaxonomyServiceClient) ListDataAttributes(ctx context.Context, in *ListDataAttributesRequest, opts ...grpc.CallOption) (*ListDataAttributesResponse, error) {
	out := new(ListDataAttributesResponse)
	err := c.cc.Invoke(ctx, DataTaxonomyService_ListDataAttributes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataTaxonomyServiceClient) GetDataAttribute(ctx context.Context, in *GetDataAttributeRequest, opts ...grpc.CallOption) (*DataAttribute, error) {
	out := new(DataAttribute)
	err := c.cc.Invoke(ctx, DataTaxonomyService_GetDataAttribute_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataTaxonomyServiceServer is the server API for DataTaxonomyService service.
// All implementations should embed UnimplementedDataTaxonomyServiceServer
// for forward compatibility
//
// Deprecated: Do not use.
type DataTaxonomyServiceServer interface {
	// Deprecated: Do not use.
	// Create a DataTaxonomy resource.
	CreateDataTaxonomy(context.Context, *CreateDataTaxonomyRequest) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Updates a DataTaxonomy resource.
	UpdateDataTaxonomy(context.Context, *UpdateDataTaxonomyRequest) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Deletes a DataTaxonomy resource. All attributes within the DataTaxonomy
	// must be deleted before the DataTaxonomy can be deleted.
	DeleteDataTaxonomy(context.Context, *DeleteDataTaxonomyRequest) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Lists DataTaxonomy resources in a project and location.
	ListDataTaxonomies(context.Context, *ListDataTaxonomiesRequest) (*ListDataTaxonomiesResponse, error)
	// Deprecated: Do not use.
	// Retrieves a DataTaxonomy resource.
	GetDataTaxonomy(context.Context, *GetDataTaxonomyRequest) (*DataTaxonomy, error)
	// Deprecated: Do not use.
	// Create a DataAttributeBinding resource.
	CreateDataAttributeBinding(context.Context, *CreateDataAttributeBindingRequest) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Updates a DataAttributeBinding resource.
	UpdateDataAttributeBinding(context.Context, *UpdateDataAttributeBindingRequest) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Deletes a DataAttributeBinding resource. All attributes within the
	// DataAttributeBinding must be deleted before the DataAttributeBinding can be
	// deleted.
	DeleteDataAttributeBinding(context.Context, *DeleteDataAttributeBindingRequest) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Lists DataAttributeBinding resources in a project and location.
	ListDataAttributeBindings(context.Context, *ListDataAttributeBindingsRequest) (*ListDataAttributeBindingsResponse, error)
	// Deprecated: Do not use.
	// Retrieves a DataAttributeBinding resource.
	GetDataAttributeBinding(context.Context, *GetDataAttributeBindingRequest) (*DataAttributeBinding, error)
	// Deprecated: Do not use.
	// Create a DataAttribute resource.
	CreateDataAttribute(context.Context, *CreateDataAttributeRequest) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Updates a DataAttribute resource.
	UpdateDataAttribute(context.Context, *UpdateDataAttributeRequest) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Deletes a Data Attribute resource.
	DeleteDataAttribute(context.Context, *DeleteDataAttributeRequest) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Lists Data Attribute resources in a DataTaxonomy.
	ListDataAttributes(context.Context, *ListDataAttributesRequest) (*ListDataAttributesResponse, error)
	// Deprecated: Do not use.
	// Retrieves a Data Attribute resource.
	GetDataAttribute(context.Context, *GetDataAttributeRequest) (*DataAttribute, error)
}

// UnimplementedDataTaxonomyServiceServer should be embedded to have forward compatible implementations.
type UnimplementedDataTaxonomyServiceServer struct {
}

func (UnimplementedDataTaxonomyServiceServer) CreateDataTaxonomy(context.Context, *CreateDataTaxonomyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDataTaxonomy not implemented")
}
func (UnimplementedDataTaxonomyServiceServer) UpdateDataTaxonomy(context.Context, *UpdateDataTaxonomyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDataTaxonomy not implemented")
}
func (UnimplementedDataTaxonomyServiceServer) DeleteDataTaxonomy(context.Context, *DeleteDataTaxonomyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDataTaxonomy not implemented")
}
func (UnimplementedDataTaxonomyServiceServer) ListDataTaxonomies(context.Context, *ListDataTaxonomiesRequest) (*ListDataTaxonomiesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDataTaxonomies not implemented")
}
func (UnimplementedDataTaxonomyServiceServer) GetDataTaxonomy(context.Context, *GetDataTaxonomyRequest) (*DataTaxonomy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataTaxonomy not implemented")
}
func (UnimplementedDataTaxonomyServiceServer) CreateDataAttributeBinding(context.Context, *CreateDataAttributeBindingRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDataAttributeBinding not implemented")
}
func (UnimplementedDataTaxonomyServiceServer) UpdateDataAttributeBinding(context.Context, *UpdateDataAttributeBindingRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDataAttributeBinding not implemented")
}
func (UnimplementedDataTaxonomyServiceServer) DeleteDataAttributeBinding(context.Context, *DeleteDataAttributeBindingRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDataAttributeBinding not implemented")
}
func (UnimplementedDataTaxonomyServiceServer) ListDataAttributeBindings(context.Context, *ListDataAttributeBindingsRequest) (*ListDataAttributeBindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDataAttributeBindings not implemented")
}
func (UnimplementedDataTaxonomyServiceServer) GetDataAttributeBinding(context.Context, *GetDataAttributeBindingRequest) (*DataAttributeBinding, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataAttributeBinding not implemented")
}
func (UnimplementedDataTaxonomyServiceServer) CreateDataAttribute(context.Context, *CreateDataAttributeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDataAttribute not implemented")
}
func (UnimplementedDataTaxonomyServiceServer) UpdateDataAttribute(context.Context, *UpdateDataAttributeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDataAttribute not implemented")
}
func (UnimplementedDataTaxonomyServiceServer) DeleteDataAttribute(context.Context, *DeleteDataAttributeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDataAttribute not implemented")
}
func (UnimplementedDataTaxonomyServiceServer) ListDataAttributes(context.Context, *ListDataAttributesRequest) (*ListDataAttributesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDataAttributes not implemented")
}
func (UnimplementedDataTaxonomyServiceServer) GetDataAttribute(context.Context, *GetDataAttributeRequest) (*DataAttribute, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataAttribute not implemented")
}

// UnsafeDataTaxonomyServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DataTaxonomyServiceServer will
// result in compilation errors.
type UnsafeDataTaxonomyServiceServer interface {
	mustEmbedUnimplementedDataTaxonomyServiceServer()
}

// Deprecated: Do not use.
func RegisterDataTaxonomyServiceServer(s grpc.ServiceRegistrar, srv DataTaxonomyServiceServer) {
	s.RegisterService(&DataTaxonomyService_ServiceDesc, srv)
}

func _DataTaxonomyService_CreateDataTaxonomy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDataTaxonomyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTaxonomyServiceServer).CreateDataTaxonomy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTaxonomyService_CreateDataTaxonomy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTaxonomyServiceServer).CreateDataTaxonomy(ctx, req.(*CreateDataTaxonomyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTaxonomyService_UpdateDataTaxonomy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDataTaxonomyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTaxonomyServiceServer).UpdateDataTaxonomy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTaxonomyService_UpdateDataTaxonomy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTaxonomyServiceServer).UpdateDataTaxonomy(ctx, req.(*UpdateDataTaxonomyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTaxonomyService_DeleteDataTaxonomy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDataTaxonomyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTaxonomyServiceServer).DeleteDataTaxonomy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTaxonomyService_DeleteDataTaxonomy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTaxonomyServiceServer).DeleteDataTaxonomy(ctx, req.(*DeleteDataTaxonomyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTaxonomyService_ListDataTaxonomies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDataTaxonomiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTaxonomyServiceServer).ListDataTaxonomies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTaxonomyService_ListDataTaxonomies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTaxonomyServiceServer).ListDataTaxonomies(ctx, req.(*ListDataTaxonomiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTaxonomyService_GetDataTaxonomy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataTaxonomyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTaxonomyServiceServer).GetDataTaxonomy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTaxonomyService_GetDataTaxonomy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTaxonomyServiceServer).GetDataTaxonomy(ctx, req.(*GetDataTaxonomyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTaxonomyService_CreateDataAttributeBinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDataAttributeBindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTaxonomyServiceServer).CreateDataAttributeBinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTaxonomyService_CreateDataAttributeBinding_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTaxonomyServiceServer).CreateDataAttributeBinding(ctx, req.(*CreateDataAttributeBindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTaxonomyService_UpdateDataAttributeBinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDataAttributeBindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTaxonomyServiceServer).UpdateDataAttributeBinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTaxonomyService_UpdateDataAttributeBinding_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTaxonomyServiceServer).UpdateDataAttributeBinding(ctx, req.(*UpdateDataAttributeBindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTaxonomyService_DeleteDataAttributeBinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDataAttributeBindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTaxonomyServiceServer).DeleteDataAttributeBinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTaxonomyService_DeleteDataAttributeBinding_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTaxonomyServiceServer).DeleteDataAttributeBinding(ctx, req.(*DeleteDataAttributeBindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTaxonomyService_ListDataAttributeBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDataAttributeBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTaxonomyServiceServer).ListDataAttributeBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTaxonomyService_ListDataAttributeBindings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTaxonomyServiceServer).ListDataAttributeBindings(ctx, req.(*ListDataAttributeBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTaxonomyService_GetDataAttributeBinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataAttributeBindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTaxonomyServiceServer).GetDataAttributeBinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTaxonomyService_GetDataAttributeBinding_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTaxonomyServiceServer).GetDataAttributeBinding(ctx, req.(*GetDataAttributeBindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTaxonomyService_CreateDataAttribute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDataAttributeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTaxonomyServiceServer).CreateDataAttribute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTaxonomyService_CreateDataAttribute_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTaxonomyServiceServer).CreateDataAttribute(ctx, req.(*CreateDataAttributeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTaxonomyService_UpdateDataAttribute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDataAttributeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTaxonomyServiceServer).UpdateDataAttribute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTaxonomyService_UpdateDataAttribute_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTaxonomyServiceServer).UpdateDataAttribute(ctx, req.(*UpdateDataAttributeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTaxonomyService_DeleteDataAttribute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDataAttributeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTaxonomyServiceServer).DeleteDataAttribute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTaxonomyService_DeleteDataAttribute_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTaxonomyServiceServer).DeleteDataAttribute(ctx, req.(*DeleteDataAttributeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTaxonomyService_ListDataAttributes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDataAttributesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTaxonomyServiceServer).ListDataAttributes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTaxonomyService_ListDataAttributes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTaxonomyServiceServer).ListDataAttributes(ctx, req.(*ListDataAttributesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTaxonomyService_GetDataAttribute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataAttributeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTaxonomyServiceServer).GetDataAttribute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataTaxonomyService_GetDataAttribute_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTaxonomyServiceServer).GetDataAttribute(ctx, req.(*GetDataAttributeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// DataTaxonomyService_ServiceDesc is the grpc.ServiceDesc for DataTaxonomyService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var DataTaxonomyService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataplex.v1.DataTaxonomyService",
	HandlerType: (*DataTaxonomyServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateDataTaxonomy",
			Handler:    _DataTaxonomyService_CreateDataTaxonomy_Handler,
		},
		{
			MethodName: "UpdateDataTaxonomy",
			Handler:    _DataTaxonomyService_UpdateDataTaxonomy_Handler,
		},
		{
			MethodName: "DeleteDataTaxonomy",
			Handler:    _DataTaxonomyService_DeleteDataTaxonomy_Handler,
		},
		{
			MethodName: "ListDataTaxonomies",
			Handler:    _DataTaxonomyService_ListDataTaxonomies_Handler,
		},
		{
			MethodName: "GetDataTaxonomy",
			Handler:    _DataTaxonomyService_GetDataTaxonomy_Handler,
		},
		{
			MethodName: "CreateDataAttributeBinding",
			Handler:    _DataTaxonomyService_CreateDataAttributeBinding_Handler,
		},
		{
			MethodName: "UpdateDataAttributeBinding",
			Handler:    _DataTaxonomyService_UpdateDataAttributeBinding_Handler,
		},
		{
			MethodName: "DeleteDataAttributeBinding",
			Handler:    _DataTaxonomyService_DeleteDataAttributeBinding_Handler,
		},
		{
			MethodName: "ListDataAttributeBindings",
			Handler:    _DataTaxonomyService_ListDataAttributeBindings_Handler,
		},
		{
			MethodName: "GetDataAttributeBinding",
			Handler:    _DataTaxonomyService_GetDataAttributeBinding_Handler,
		},
		{
			MethodName: "CreateDataAttribute",
			Handler:    _DataTaxonomyService_CreateDataAttribute_Handler,
		},
		{
			MethodName: "UpdateDataAttribute",
			Handler:    _DataTaxonomyService_UpdateDataAttribute_Handler,
		},
		{
			MethodName: "DeleteDataAttribute",
			Handler:    _DataTaxonomyService_DeleteDataAttribute_Handler,
		},
		{
			MethodName: "ListDataAttributes",
			Handler:    _DataTaxonomyService_ListDataAttributes_Handler,
		},
		{
			MethodName: "GetDataAttribute",
			Handler:    _DataTaxonomyService_GetDataAttribute_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dataplex/v1/data_taxonomy.proto",
}
