# JSON Schema for Go

This module implements the [JSON Schema](https://json-schema.org/) specification.
The `jsonschema` package supports creating schemas, validating JSON values
against a schema, and inferring a schema from a Go struct. See the package
documentation for usage.

## Contributing

This module welcomes external contributions.
It has no dependencies outside of the standard library, and can be built with
the standard Go toolchain. Run `go test ./...` at the module root to run all
the tests.

## Issues

This project uses the [GitHub issue
tracker](https://github.com/google/jsonschema-go/issues) for bug reports, feature requests, and other issues. 

Please [report
bugs](https://github.com/google/jsonschema-go/issues/new?template=bug_report.md). If the SDK is
not working as you expected, it is likely due to a bug or inadequate
documentation, and reporting an issue will help us address this shortcoming.

When reporting a bug, make sure to answer these five questions:

1. What did you do?
2. What did you see?
3. What did you expect to see?
4. What version of the Go MCP SDK are you using?
5. What version of Go are you using (`go version`)?

## License

This project is licensed under the MIT license. See the LICENSE file for details.

