// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/ai/generativelanguage/v1alpha/cache_service.proto

package generativelanguagepb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	CacheService_ListCachedContents_FullMethodName  = "/google.ai.generativelanguage.v1alpha.CacheService/ListCachedContents"
	CacheService_CreateCachedContent_FullMethodName = "/google.ai.generativelanguage.v1alpha.CacheService/CreateCachedContent"
	CacheService_GetCachedContent_FullMethodName    = "/google.ai.generativelanguage.v1alpha.CacheService/GetCachedContent"
	CacheService_UpdateCachedContent_FullMethodName = "/google.ai.generativelanguage.v1alpha.CacheService/UpdateCachedContent"
	CacheService_DeleteCachedContent_FullMethodName = "/google.ai.generativelanguage.v1alpha.CacheService/DeleteCachedContent"
)

// CacheServiceClient is the client API for CacheService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type CacheServiceClient interface {
	// Lists CachedContents.
	ListCachedContents(ctx context.Context, in *ListCachedContentsRequest, opts ...grpc.CallOption) (*ListCachedContentsResponse, error)
	// Creates CachedContent resource.
	CreateCachedContent(ctx context.Context, in *CreateCachedContentRequest, opts ...grpc.CallOption) (*CachedContent, error)
	// Reads CachedContent resource.
	GetCachedContent(ctx context.Context, in *GetCachedContentRequest, opts ...grpc.CallOption) (*CachedContent, error)
	// Updates CachedContent resource (only expiration is updatable).
	UpdateCachedContent(ctx context.Context, in *UpdateCachedContentRequest, opts ...grpc.CallOption) (*CachedContent, error)
	// Deletes CachedContent resource.
	DeleteCachedContent(ctx context.Context, in *DeleteCachedContentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type cacheServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCacheServiceClient(cc grpc.ClientConnInterface) CacheServiceClient {
	return &cacheServiceClient{cc}
}

func (c *cacheServiceClient) ListCachedContents(ctx context.Context, in *ListCachedContentsRequest, opts ...grpc.CallOption) (*ListCachedContentsResponse, error) {
	out := new(ListCachedContentsResponse)
	err := c.cc.Invoke(ctx, CacheService_ListCachedContents_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cacheServiceClient) CreateCachedContent(ctx context.Context, in *CreateCachedContentRequest, opts ...grpc.CallOption) (*CachedContent, error) {
	out := new(CachedContent)
	err := c.cc.Invoke(ctx, CacheService_CreateCachedContent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cacheServiceClient) GetCachedContent(ctx context.Context, in *GetCachedContentRequest, opts ...grpc.CallOption) (*CachedContent, error) {
	out := new(CachedContent)
	err := c.cc.Invoke(ctx, CacheService_GetCachedContent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cacheServiceClient) UpdateCachedContent(ctx context.Context, in *UpdateCachedContentRequest, opts ...grpc.CallOption) (*CachedContent, error) {
	out := new(CachedContent)
	err := c.cc.Invoke(ctx, CacheService_UpdateCachedContent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cacheServiceClient) DeleteCachedContent(ctx context.Context, in *DeleteCachedContentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, CacheService_DeleteCachedContent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CacheServiceServer is the server API for CacheService service.
// All implementations should embed UnimplementedCacheServiceServer
// for forward compatibility
type CacheServiceServer interface {
	// Lists CachedContents.
	ListCachedContents(context.Context, *ListCachedContentsRequest) (*ListCachedContentsResponse, error)
	// Creates CachedContent resource.
	CreateCachedContent(context.Context, *CreateCachedContentRequest) (*CachedContent, error)
	// Reads CachedContent resource.
	GetCachedContent(context.Context, *GetCachedContentRequest) (*CachedContent, error)
	// Updates CachedContent resource (only expiration is updatable).
	UpdateCachedContent(context.Context, *UpdateCachedContentRequest) (*CachedContent, error)
	// Deletes CachedContent resource.
	DeleteCachedContent(context.Context, *DeleteCachedContentRequest) (*emptypb.Empty, error)
}

// UnimplementedCacheServiceServer should be embedded to have forward compatible implementations.
type UnimplementedCacheServiceServer struct {
}

func (UnimplementedCacheServiceServer) ListCachedContents(context.Context, *ListCachedContentsRequest) (*ListCachedContentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCachedContents not implemented")
}
func (UnimplementedCacheServiceServer) CreateCachedContent(context.Context, *CreateCachedContentRequest) (*CachedContent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCachedContent not implemented")
}
func (UnimplementedCacheServiceServer) GetCachedContent(context.Context, *GetCachedContentRequest) (*CachedContent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCachedContent not implemented")
}
func (UnimplementedCacheServiceServer) UpdateCachedContent(context.Context, *UpdateCachedContentRequest) (*CachedContent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCachedContent not implemented")
}
func (UnimplementedCacheServiceServer) DeleteCachedContent(context.Context, *DeleteCachedContentRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCachedContent not implemented")
}

// UnsafeCacheServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to CacheServiceServer will
// result in compilation errors.
type UnsafeCacheServiceServer interface {
	mustEmbedUnimplementedCacheServiceServer()
}

func RegisterCacheServiceServer(s grpc.ServiceRegistrar, srv CacheServiceServer) {
	s.RegisterService(&CacheService_ServiceDesc, srv)
}

func _CacheService_ListCachedContents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCachedContentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CacheServiceServer).ListCachedContents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CacheService_ListCachedContents_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CacheServiceServer).ListCachedContents(ctx, req.(*ListCachedContentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CacheService_CreateCachedContent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCachedContentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CacheServiceServer).CreateCachedContent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CacheService_CreateCachedContent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CacheServiceServer).CreateCachedContent(ctx, req.(*CreateCachedContentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CacheService_GetCachedContent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCachedContentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CacheServiceServer).GetCachedContent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CacheService_GetCachedContent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CacheServiceServer).GetCachedContent(ctx, req.(*GetCachedContentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CacheService_UpdateCachedContent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCachedContentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CacheServiceServer).UpdateCachedContent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CacheService_UpdateCachedContent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CacheServiceServer).UpdateCachedContent(ctx, req.(*UpdateCachedContentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CacheService_DeleteCachedContent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCachedContentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CacheServiceServer).DeleteCachedContent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CacheService_DeleteCachedContent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CacheServiceServer).DeleteCachedContent(ctx, req.(*DeleteCachedContentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// CacheService_ServiceDesc is the grpc.ServiceDesc for CacheService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var CacheService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.ai.generativelanguage.v1alpha.CacheService",
	HandlerType: (*CacheServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListCachedContents",
			Handler:    _CacheService_ListCachedContents_Handler,
		},
		{
			MethodName: "CreateCachedContent",
			Handler:    _CacheService_CreateCachedContent_Handler,
		},
		{
			MethodName: "GetCachedContent",
			Handler:    _CacheService_GetCachedContent_Handler,
		},
		{
			MethodName: "UpdateCachedContent",
			Handler:    _CacheService_UpdateCachedContent_Handler,
		},
		{
			MethodName: "DeleteCachedContent",
			Handler:    _CacheService_DeleteCachedContent_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ai/generativelanguage/v1alpha/cache_service.proto",
}
