// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/ai/generativelanguage/v1beta/generative_service.proto

package generativelanguagepb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Type of task for which the embedding will be used.
type TaskType int32

const (
	// Unset value, which will default to one of the other enum values.
	TaskType_TASK_TYPE_UNSPECIFIED TaskType = 0
	// Specifies the given text is a query in a search/retrieval setting.
	TaskType_RETRIEVAL_QUERY TaskType = 1
	// Specifies the given text is a document from the corpus being searched.
	TaskType_RETRIEVAL_DOCUMENT TaskType = 2
	// Specifies the given text will be used for STS.
	TaskType_SEMANTIC_SIMILARITY TaskType = 3
	// Specifies that the given text will be classified.
	TaskType_CLASSIFICATION TaskType = 4
	// Specifies that the embeddings will be used for clustering.
	TaskType_CLUSTERING TaskType = 5
	// Specifies that the given text will be used for question answering.
	TaskType_QUESTION_ANSWERING TaskType = 6
	// Specifies that the given text will be used for fact verification.
	TaskType_FACT_VERIFICATION TaskType = 7
	// Specifies that the given text will be used for code retrieval.
	TaskType_CODE_RETRIEVAL_QUERY TaskType = 8
)

// Enum value maps for TaskType.
var (
	TaskType_name = map[int32]string{
		0: "TASK_TYPE_UNSPECIFIED",
		1: "RETRIEVAL_QUERY",
		2: "RETRIEVAL_DOCUMENT",
		3: "SEMANTIC_SIMILARITY",
		4: "CLASSIFICATION",
		5: "CLUSTERING",
		6: "QUESTION_ANSWERING",
		7: "FACT_VERIFICATION",
		8: "CODE_RETRIEVAL_QUERY",
	}
	TaskType_value = map[string]int32{
		"TASK_TYPE_UNSPECIFIED": 0,
		"RETRIEVAL_QUERY":       1,
		"RETRIEVAL_DOCUMENT":    2,
		"SEMANTIC_SIMILARITY":   3,
		"CLASSIFICATION":        4,
		"CLUSTERING":            5,
		"QUESTION_ANSWERING":    6,
		"FACT_VERIFICATION":     7,
		"CODE_RETRIEVAL_QUERY":  8,
	}
)

func (x TaskType) Enum() *TaskType {
	p := new(TaskType)
	*p = x
	return p
}

func (x TaskType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TaskType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes[0].Descriptor()
}

func (TaskType) Type() protoreflect.EnumType {
	return &file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes[0]
}

func (x TaskType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TaskType.Descriptor instead.
func (TaskType) EnumDescriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{0}
}

// Supported modalities of the response.
type GenerationConfig_Modality int32

const (
	// Default value.
	GenerationConfig_MODALITY_UNSPECIFIED GenerationConfig_Modality = 0
	// Indicates the model should return text.
	GenerationConfig_TEXT GenerationConfig_Modality = 1
	// Indicates the model should return images.
	GenerationConfig_IMAGE GenerationConfig_Modality = 2
	// Indicates the model should return audio.
	GenerationConfig_AUDIO GenerationConfig_Modality = 3
)

// Enum value maps for GenerationConfig_Modality.
var (
	GenerationConfig_Modality_name = map[int32]string{
		0: "MODALITY_UNSPECIFIED",
		1: "TEXT",
		2: "IMAGE",
		3: "AUDIO",
	}
	GenerationConfig_Modality_value = map[string]int32{
		"MODALITY_UNSPECIFIED": 0,
		"TEXT":                 1,
		"IMAGE":                2,
		"AUDIO":                3,
	}
)

func (x GenerationConfig_Modality) Enum() *GenerationConfig_Modality {
	p := new(GenerationConfig_Modality)
	*p = x
	return p
}

func (x GenerationConfig_Modality) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GenerationConfig_Modality) Descriptor() protoreflect.EnumDescriptor {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes[1].Descriptor()
}

func (GenerationConfig_Modality) Type() protoreflect.EnumType {
	return &file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes[1]
}

func (x GenerationConfig_Modality) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GenerationConfig_Modality.Descriptor instead.
func (GenerationConfig_Modality) EnumDescriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{5, 0}
}

// Media resolution for the input media.
type GenerationConfig_MediaResolution int32

const (
	// Media resolution has not been set.
	GenerationConfig_MEDIA_RESOLUTION_UNSPECIFIED GenerationConfig_MediaResolution = 0
	// Media resolution set to low (64 tokens).
	GenerationConfig_MEDIA_RESOLUTION_LOW GenerationConfig_MediaResolution = 1
	// Media resolution set to medium (256 tokens).
	GenerationConfig_MEDIA_RESOLUTION_MEDIUM GenerationConfig_MediaResolution = 2
	// Media resolution set to high (zoomed reframing with 256 tokens).
	GenerationConfig_MEDIA_RESOLUTION_HIGH GenerationConfig_MediaResolution = 3
)

// Enum value maps for GenerationConfig_MediaResolution.
var (
	GenerationConfig_MediaResolution_name = map[int32]string{
		0: "MEDIA_RESOLUTION_UNSPECIFIED",
		1: "MEDIA_RESOLUTION_LOW",
		2: "MEDIA_RESOLUTION_MEDIUM",
		3: "MEDIA_RESOLUTION_HIGH",
	}
	GenerationConfig_MediaResolution_value = map[string]int32{
		"MEDIA_RESOLUTION_UNSPECIFIED": 0,
		"MEDIA_RESOLUTION_LOW":         1,
		"MEDIA_RESOLUTION_MEDIUM":      2,
		"MEDIA_RESOLUTION_HIGH":        3,
	}
)

func (x GenerationConfig_MediaResolution) Enum() *GenerationConfig_MediaResolution {
	p := new(GenerationConfig_MediaResolution)
	*p = x
	return p
}

func (x GenerationConfig_MediaResolution) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GenerationConfig_MediaResolution) Descriptor() protoreflect.EnumDescriptor {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes[2].Descriptor()
}

func (GenerationConfig_MediaResolution) Type() protoreflect.EnumType {
	return &file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes[2]
}

func (x GenerationConfig_MediaResolution) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GenerationConfig_MediaResolution.Descriptor instead.
func (GenerationConfig_MediaResolution) EnumDescriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{5, 1}
}

// Specifies the reason why the prompt was blocked.
type GenerateContentResponse_PromptFeedback_BlockReason int32

const (
	// Default value. This value is unused.
	GenerateContentResponse_PromptFeedback_BLOCK_REASON_UNSPECIFIED GenerateContentResponse_PromptFeedback_BlockReason = 0
	// Prompt was blocked due to safety reasons. Inspect `safety_ratings`
	// to understand which safety category blocked it.
	GenerateContentResponse_PromptFeedback_SAFETY GenerateContentResponse_PromptFeedback_BlockReason = 1
	// Prompt was blocked due to unknown reasons.
	GenerateContentResponse_PromptFeedback_OTHER GenerateContentResponse_PromptFeedback_BlockReason = 2
	// Prompt was blocked due to the terms which are included from the
	// terminology blocklist.
	GenerateContentResponse_PromptFeedback_BLOCKLIST GenerateContentResponse_PromptFeedback_BlockReason = 3
	// Prompt was blocked due to prohibited content.
	GenerateContentResponse_PromptFeedback_PROHIBITED_CONTENT GenerateContentResponse_PromptFeedback_BlockReason = 4
	// Candidates blocked due to unsafe image generation content.
	GenerateContentResponse_PromptFeedback_IMAGE_SAFETY GenerateContentResponse_PromptFeedback_BlockReason = 5
)

// Enum value maps for GenerateContentResponse_PromptFeedback_BlockReason.
var (
	GenerateContentResponse_PromptFeedback_BlockReason_name = map[int32]string{
		0: "BLOCK_REASON_UNSPECIFIED",
		1: "SAFETY",
		2: "OTHER",
		3: "BLOCKLIST",
		4: "PROHIBITED_CONTENT",
		5: "IMAGE_SAFETY",
	}
	GenerateContentResponse_PromptFeedback_BlockReason_value = map[string]int32{
		"BLOCK_REASON_UNSPECIFIED": 0,
		"SAFETY":                   1,
		"OTHER":                    2,
		"BLOCKLIST":                3,
		"PROHIBITED_CONTENT":       4,
		"IMAGE_SAFETY":             5,
	}
)

func (x GenerateContentResponse_PromptFeedback_BlockReason) Enum() *GenerateContentResponse_PromptFeedback_BlockReason {
	p := new(GenerateContentResponse_PromptFeedback_BlockReason)
	*p = x
	return p
}

func (x GenerateContentResponse_PromptFeedback_BlockReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GenerateContentResponse_PromptFeedback_BlockReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes[3].Descriptor()
}

func (GenerateContentResponse_PromptFeedback_BlockReason) Type() protoreflect.EnumType {
	return &file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes[3]
}

func (x GenerateContentResponse_PromptFeedback_BlockReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GenerateContentResponse_PromptFeedback_BlockReason.Descriptor instead.
func (GenerateContentResponse_PromptFeedback_BlockReason) EnumDescriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{7, 0, 0}
}

// Defines the reason why the model stopped generating tokens.
type Candidate_FinishReason int32

const (
	// Default value. This value is unused.
	Candidate_FINISH_REASON_UNSPECIFIED Candidate_FinishReason = 0
	// Natural stop point of the model or provided stop sequence.
	Candidate_STOP Candidate_FinishReason = 1
	// The maximum number of tokens as specified in the request was reached.
	Candidate_MAX_TOKENS Candidate_FinishReason = 2
	// The response candidate content was flagged for safety reasons.
	Candidate_SAFETY Candidate_FinishReason = 3
	// The response candidate content was flagged for recitation reasons.
	Candidate_RECITATION Candidate_FinishReason = 4
	// The response candidate content was flagged for using an unsupported
	// language.
	Candidate_LANGUAGE Candidate_FinishReason = 6
	// Unknown reason.
	Candidate_OTHER Candidate_FinishReason = 5
	// Token generation stopped because the content contains forbidden terms.
	Candidate_BLOCKLIST Candidate_FinishReason = 7
	// Token generation stopped for potentially containing prohibited content.
	Candidate_PROHIBITED_CONTENT Candidate_FinishReason = 8
	// Token generation stopped because the content potentially contains
	// Sensitive Personally Identifiable Information (SPII).
	Candidate_SPII Candidate_FinishReason = 9
	// The function call generated by the model is invalid.
	Candidate_MALFORMED_FUNCTION_CALL Candidate_FinishReason = 10
	// Token generation stopped because generated images contain safety
	// violations.
	Candidate_IMAGE_SAFETY Candidate_FinishReason = 11
)

// Enum value maps for Candidate_FinishReason.
var (
	Candidate_FinishReason_name = map[int32]string{
		0:  "FINISH_REASON_UNSPECIFIED",
		1:  "STOP",
		2:  "MAX_TOKENS",
		3:  "SAFETY",
		4:  "RECITATION",
		6:  "LANGUAGE",
		5:  "OTHER",
		7:  "BLOCKLIST",
		8:  "PROHIBITED_CONTENT",
		9:  "SPII",
		10: "MALFORMED_FUNCTION_CALL",
		11: "IMAGE_SAFETY",
	}
	Candidate_FinishReason_value = map[string]int32{
		"FINISH_REASON_UNSPECIFIED": 0,
		"STOP":                      1,
		"MAX_TOKENS":                2,
		"SAFETY":                    3,
		"RECITATION":                4,
		"LANGUAGE":                  6,
		"OTHER":                     5,
		"BLOCKLIST":                 7,
		"PROHIBITED_CONTENT":        8,
		"SPII":                      9,
		"MALFORMED_FUNCTION_CALL":   10,
		"IMAGE_SAFETY":              11,
	}
)

func (x Candidate_FinishReason) Enum() *Candidate_FinishReason {
	p := new(Candidate_FinishReason)
	*p = x
	return p
}

func (x Candidate_FinishReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Candidate_FinishReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes[4].Descriptor()
}

func (Candidate_FinishReason) Type() protoreflect.EnumType {
	return &file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes[4]
}

func (x Candidate_FinishReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Candidate_FinishReason.Descriptor instead.
func (Candidate_FinishReason) EnumDescriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{8, 0}
}

// Style for grounded answers.
type GenerateAnswerRequest_AnswerStyle int32

const (
	// Unspecified answer style.
	GenerateAnswerRequest_ANSWER_STYLE_UNSPECIFIED GenerateAnswerRequest_AnswerStyle = 0
	// Succint but abstract style.
	GenerateAnswerRequest_ABSTRACTIVE GenerateAnswerRequest_AnswerStyle = 1
	// Very brief and extractive style.
	GenerateAnswerRequest_EXTRACTIVE GenerateAnswerRequest_AnswerStyle = 2
	// Verbose style including extra details. The response may be formatted as a
	// sentence, paragraph, multiple paragraphs, or bullet points, etc.
	GenerateAnswerRequest_VERBOSE GenerateAnswerRequest_AnswerStyle = 3
)

// Enum value maps for GenerateAnswerRequest_AnswerStyle.
var (
	GenerateAnswerRequest_AnswerStyle_name = map[int32]string{
		0: "ANSWER_STYLE_UNSPECIFIED",
		1: "ABSTRACTIVE",
		2: "EXTRACTIVE",
		3: "VERBOSE",
	}
	GenerateAnswerRequest_AnswerStyle_value = map[string]int32{
		"ANSWER_STYLE_UNSPECIFIED": 0,
		"ABSTRACTIVE":              1,
		"EXTRACTIVE":               2,
		"VERBOSE":                  3,
	}
)

func (x GenerateAnswerRequest_AnswerStyle) Enum() *GenerateAnswerRequest_AnswerStyle {
	p := new(GenerateAnswerRequest_AnswerStyle)
	*p = x
	return p
}

func (x GenerateAnswerRequest_AnswerStyle) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GenerateAnswerRequest_AnswerStyle) Descriptor() protoreflect.EnumDescriptor {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes[5].Descriptor()
}

func (GenerateAnswerRequest_AnswerStyle) Type() protoreflect.EnumType {
	return &file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes[5]
}

func (x GenerateAnswerRequest_AnswerStyle) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GenerateAnswerRequest_AnswerStyle.Descriptor instead.
func (GenerateAnswerRequest_AnswerStyle) EnumDescriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{18, 0}
}

// Specifies what was the reason why input was blocked.
type GenerateAnswerResponse_InputFeedback_BlockReason int32

const (
	// Default value. This value is unused.
	GenerateAnswerResponse_InputFeedback_BLOCK_REASON_UNSPECIFIED GenerateAnswerResponse_InputFeedback_BlockReason = 0
	// Input was blocked due to safety reasons. Inspect
	// `safety_ratings` to understand which safety category blocked it.
	GenerateAnswerResponse_InputFeedback_SAFETY GenerateAnswerResponse_InputFeedback_BlockReason = 1
	// Input was blocked due to other reasons.
	GenerateAnswerResponse_InputFeedback_OTHER GenerateAnswerResponse_InputFeedback_BlockReason = 2
)

// Enum value maps for GenerateAnswerResponse_InputFeedback_BlockReason.
var (
	GenerateAnswerResponse_InputFeedback_BlockReason_name = map[int32]string{
		0: "BLOCK_REASON_UNSPECIFIED",
		1: "SAFETY",
		2: "OTHER",
	}
	GenerateAnswerResponse_InputFeedback_BlockReason_value = map[string]int32{
		"BLOCK_REASON_UNSPECIFIED": 0,
		"SAFETY":                   1,
		"OTHER":                    2,
	}
)

func (x GenerateAnswerResponse_InputFeedback_BlockReason) Enum() *GenerateAnswerResponse_InputFeedback_BlockReason {
	p := new(GenerateAnswerResponse_InputFeedback_BlockReason)
	*p = x
	return p
}

func (x GenerateAnswerResponse_InputFeedback_BlockReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GenerateAnswerResponse_InputFeedback_BlockReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes[6].Descriptor()
}

func (GenerateAnswerResponse_InputFeedback_BlockReason) Type() protoreflect.EnumType {
	return &file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes[6]
}

func (x GenerateAnswerResponse_InputFeedback_BlockReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GenerateAnswerResponse_InputFeedback_BlockReason.Descriptor instead.
func (GenerateAnswerResponse_InputFeedback_BlockReason) EnumDescriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{19, 0, 0}
}

// The different ways of handling user activity.
type RealtimeInputConfig_ActivityHandling int32

const (
	// If unspecified, the default behavior is `START_OF_ACTIVITY_INTERRUPTS`.
	RealtimeInputConfig_ACTIVITY_HANDLING_UNSPECIFIED RealtimeInputConfig_ActivityHandling = 0
	// If true, start of activity will interrupt the model's response (also
	// called "barge in"). The model's current response will be cut-off in the
	// moment of the interruption. This is the default behavior.
	RealtimeInputConfig_START_OF_ACTIVITY_INTERRUPTS RealtimeInputConfig_ActivityHandling = 1
	// The model's response will not be interrupted.
	RealtimeInputConfig_NO_INTERRUPTION RealtimeInputConfig_ActivityHandling = 2
)

// Enum value maps for RealtimeInputConfig_ActivityHandling.
var (
	RealtimeInputConfig_ActivityHandling_name = map[int32]string{
		0: "ACTIVITY_HANDLING_UNSPECIFIED",
		1: "START_OF_ACTIVITY_INTERRUPTS",
		2: "NO_INTERRUPTION",
	}
	RealtimeInputConfig_ActivityHandling_value = map[string]int32{
		"ACTIVITY_HANDLING_UNSPECIFIED": 0,
		"START_OF_ACTIVITY_INTERRUPTS":  1,
		"NO_INTERRUPTION":               2,
	}
)

func (x RealtimeInputConfig_ActivityHandling) Enum() *RealtimeInputConfig_ActivityHandling {
	p := new(RealtimeInputConfig_ActivityHandling)
	*p = x
	return p
}

func (x RealtimeInputConfig_ActivityHandling) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RealtimeInputConfig_ActivityHandling) Descriptor() protoreflect.EnumDescriptor {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes[7].Descriptor()
}

func (RealtimeInputConfig_ActivityHandling) Type() protoreflect.EnumType {
	return &file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes[7]
}

func (x RealtimeInputConfig_ActivityHandling) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RealtimeInputConfig_ActivityHandling.Descriptor instead.
func (RealtimeInputConfig_ActivityHandling) EnumDescriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{27, 0}
}

// Options about which input is included in the user's turn.
type RealtimeInputConfig_TurnCoverage int32

const (
	// If unspecified, the default behavior is `TURN_INCLUDES_ONLY_ACTIVITY`.
	RealtimeInputConfig_TURN_COVERAGE_UNSPECIFIED RealtimeInputConfig_TurnCoverage = 0
	// The users turn only includes activity since the last turn, excluding
	// inactivity (e.g. silence on the audio stream). This is the default
	// behavior.
	RealtimeInputConfig_TURN_INCLUDES_ONLY_ACTIVITY RealtimeInputConfig_TurnCoverage = 1
	// The users turn includes all realtime input since the last turn, including
	// inactivity (e.g. silence on the audio stream).
	RealtimeInputConfig_TURN_INCLUDES_ALL_INPUT RealtimeInputConfig_TurnCoverage = 2
)

// Enum value maps for RealtimeInputConfig_TurnCoverage.
var (
	RealtimeInputConfig_TurnCoverage_name = map[int32]string{
		0: "TURN_COVERAGE_UNSPECIFIED",
		1: "TURN_INCLUDES_ONLY_ACTIVITY",
		2: "TURN_INCLUDES_ALL_INPUT",
	}
	RealtimeInputConfig_TurnCoverage_value = map[string]int32{
		"TURN_COVERAGE_UNSPECIFIED":   0,
		"TURN_INCLUDES_ONLY_ACTIVITY": 1,
		"TURN_INCLUDES_ALL_INPUT":     2,
	}
)

func (x RealtimeInputConfig_TurnCoverage) Enum() *RealtimeInputConfig_TurnCoverage {
	p := new(RealtimeInputConfig_TurnCoverage)
	*p = x
	return p
}

func (x RealtimeInputConfig_TurnCoverage) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RealtimeInputConfig_TurnCoverage) Descriptor() protoreflect.EnumDescriptor {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes[8].Descriptor()
}

func (RealtimeInputConfig_TurnCoverage) Type() protoreflect.EnumType {
	return &file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes[8]
}

func (x RealtimeInputConfig_TurnCoverage) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RealtimeInputConfig_TurnCoverage.Descriptor instead.
func (RealtimeInputConfig_TurnCoverage) EnumDescriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{27, 1}
}

// Determines how start of speech is detected.
type RealtimeInputConfig_AutomaticActivityDetection_StartSensitivity int32

const (
	// The default is START_SENSITIVITY_HIGH.
	RealtimeInputConfig_AutomaticActivityDetection_START_SENSITIVITY_UNSPECIFIED RealtimeInputConfig_AutomaticActivityDetection_StartSensitivity = 0
	// Automatic detection will detect the start of speech more often.
	RealtimeInputConfig_AutomaticActivityDetection_START_SENSITIVITY_HIGH RealtimeInputConfig_AutomaticActivityDetection_StartSensitivity = 1
	// Automatic detection will detect the start of speech less often.
	RealtimeInputConfig_AutomaticActivityDetection_START_SENSITIVITY_LOW RealtimeInputConfig_AutomaticActivityDetection_StartSensitivity = 2
)

// Enum value maps for RealtimeInputConfig_AutomaticActivityDetection_StartSensitivity.
var (
	RealtimeInputConfig_AutomaticActivityDetection_StartSensitivity_name = map[int32]string{
		0: "START_SENSITIVITY_UNSPECIFIED",
		1: "START_SENSITIVITY_HIGH",
		2: "START_SENSITIVITY_LOW",
	}
	RealtimeInputConfig_AutomaticActivityDetection_StartSensitivity_value = map[string]int32{
		"START_SENSITIVITY_UNSPECIFIED": 0,
		"START_SENSITIVITY_HIGH":        1,
		"START_SENSITIVITY_LOW":         2,
	}
)

func (x RealtimeInputConfig_AutomaticActivityDetection_StartSensitivity) Enum() *RealtimeInputConfig_AutomaticActivityDetection_StartSensitivity {
	p := new(RealtimeInputConfig_AutomaticActivityDetection_StartSensitivity)
	*p = x
	return p
}

func (x RealtimeInputConfig_AutomaticActivityDetection_StartSensitivity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RealtimeInputConfig_AutomaticActivityDetection_StartSensitivity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes[9].Descriptor()
}

func (RealtimeInputConfig_AutomaticActivityDetection_StartSensitivity) Type() protoreflect.EnumType {
	return &file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes[9]
}

func (x RealtimeInputConfig_AutomaticActivityDetection_StartSensitivity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RealtimeInputConfig_AutomaticActivityDetection_StartSensitivity.Descriptor instead.
func (RealtimeInputConfig_AutomaticActivityDetection_StartSensitivity) EnumDescriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{27, 0, 0}
}

// Determines how end of speech is detected.
type RealtimeInputConfig_AutomaticActivityDetection_EndSensitivity int32

const (
	// The default is END_SENSITIVITY_HIGH.
	RealtimeInputConfig_AutomaticActivityDetection_END_SENSITIVITY_UNSPECIFIED RealtimeInputConfig_AutomaticActivityDetection_EndSensitivity = 0
	// Automatic detection ends speech more often.
	RealtimeInputConfig_AutomaticActivityDetection_END_SENSITIVITY_HIGH RealtimeInputConfig_AutomaticActivityDetection_EndSensitivity = 1
	// Automatic detection ends speech less often.
	RealtimeInputConfig_AutomaticActivityDetection_END_SENSITIVITY_LOW RealtimeInputConfig_AutomaticActivityDetection_EndSensitivity = 2
)

// Enum value maps for RealtimeInputConfig_AutomaticActivityDetection_EndSensitivity.
var (
	RealtimeInputConfig_AutomaticActivityDetection_EndSensitivity_name = map[int32]string{
		0: "END_SENSITIVITY_UNSPECIFIED",
		1: "END_SENSITIVITY_HIGH",
		2: "END_SENSITIVITY_LOW",
	}
	RealtimeInputConfig_AutomaticActivityDetection_EndSensitivity_value = map[string]int32{
		"END_SENSITIVITY_UNSPECIFIED": 0,
		"END_SENSITIVITY_HIGH":        1,
		"END_SENSITIVITY_LOW":         2,
	}
)

func (x RealtimeInputConfig_AutomaticActivityDetection_EndSensitivity) Enum() *RealtimeInputConfig_AutomaticActivityDetection_EndSensitivity {
	p := new(RealtimeInputConfig_AutomaticActivityDetection_EndSensitivity)
	*p = x
	return p
}

func (x RealtimeInputConfig_AutomaticActivityDetection_EndSensitivity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RealtimeInputConfig_AutomaticActivityDetection_EndSensitivity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes[10].Descriptor()
}

func (RealtimeInputConfig_AutomaticActivityDetection_EndSensitivity) Type() protoreflect.EnumType {
	return &file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes[10]
}

func (x RealtimeInputConfig_AutomaticActivityDetection_EndSensitivity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RealtimeInputConfig_AutomaticActivityDetection_EndSensitivity.Descriptor instead.
func (RealtimeInputConfig_AutomaticActivityDetection_EndSensitivity) EnumDescriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{27, 0, 1}
}

// Request to generate a completion from the model.
type GenerateContentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the `Model` to use for generating the completion.
	//
	// Format: `models/{model}`.
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Optional. Developer set [system
	// instruction(s)](https://ai.google.dev/gemini-api/docs/system-instructions).
	// Currently, text only.
	SystemInstruction *Content `protobuf:"bytes,8,opt,name=system_instruction,json=systemInstruction,proto3,oneof" json:"system_instruction,omitempty"`
	// Required. The content of the current conversation with the model.
	//
	// For single-turn queries, this is a single instance. For multi-turn queries
	// like [chat](https://ai.google.dev/gemini-api/docs/text-generation#chat),
	// this is a repeated field that contains the conversation history and the
	// latest request.
	Contents []*Content `protobuf:"bytes,2,rep,name=contents,proto3" json:"contents,omitempty"`
	// Optional. A list of `Tools` the `Model` may use to generate the next
	// response.
	//
	// A `Tool` is a piece of code that enables the system to interact with
	// external systems to perform an action, or set of actions, outside of
	// knowledge and scope of the `Model`. Supported `Tool`s are `Function` and
	// `code_execution`. Refer to the [Function
	// calling](https://ai.google.dev/gemini-api/docs/function-calling) and the
	// [Code execution](https://ai.google.dev/gemini-api/docs/code-execution)
	// guides to learn more.
	Tools []*Tool `protobuf:"bytes,5,rep,name=tools,proto3" json:"tools,omitempty"`
	// Optional. Tool configuration for any `Tool` specified in the request. Refer
	// to the [Function calling
	// guide](https://ai.google.dev/gemini-api/docs/function-calling#function_calling_mode)
	// for a usage example.
	ToolConfig *ToolConfig `protobuf:"bytes,7,opt,name=tool_config,json=toolConfig,proto3" json:"tool_config,omitempty"`
	// Optional. A list of unique `SafetySetting` instances for blocking unsafe
	// content.
	//
	// This will be enforced on the `GenerateContentRequest.contents` and
	// `GenerateContentResponse.candidates`. There should not be more than one
	// setting for each `SafetyCategory` type. The API will block any contents and
	// responses that fail to meet the thresholds set by these settings. This list
	// overrides the default settings for each `SafetyCategory` specified in the
	// safety_settings. If there is no `SafetySetting` for a given
	// `SafetyCategory` provided in the list, the API will use the default safety
	// setting for that category. Harm categories HARM_CATEGORY_HATE_SPEECH,
	// HARM_CATEGORY_SEXUALLY_EXPLICIT, HARM_CATEGORY_DANGEROUS_CONTENT,
	// HARM_CATEGORY_HARASSMENT, HARM_CATEGORY_CIVIC_INTEGRITY are supported.
	// Refer to the [guide](https://ai.google.dev/gemini-api/docs/safety-settings)
	// for detailed information on available safety settings. Also refer to the
	// [Safety guidance](https://ai.google.dev/gemini-api/docs/safety-guidance) to
	// learn how to incorporate safety considerations in your AI applications.
	SafetySettings []*SafetySetting `protobuf:"bytes,3,rep,name=safety_settings,json=safetySettings,proto3" json:"safety_settings,omitempty"`
	// Optional. Configuration options for model generation and outputs.
	GenerationConfig *GenerationConfig `protobuf:"bytes,4,opt,name=generation_config,json=generationConfig,proto3,oneof" json:"generation_config,omitempty"`
	// Optional. The name of the content
	// [cached](https://ai.google.dev/gemini-api/docs/caching) to use as context
	// to serve the prediction. Format: `cachedContents/{cachedContent}`
	CachedContent *string `protobuf:"bytes,9,opt,name=cached_content,json=cachedContent,proto3,oneof" json:"cached_content,omitempty"`
}

func (x *GenerateContentRequest) Reset() {
	*x = GenerateContentRequest{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateContentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateContentRequest) ProtoMessage() {}

func (x *GenerateContentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateContentRequest.ProtoReflect.Descriptor instead.
func (*GenerateContentRequest) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{0}
}

func (x *GenerateContentRequest) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *GenerateContentRequest) GetSystemInstruction() *Content {
	if x != nil {
		return x.SystemInstruction
	}
	return nil
}

func (x *GenerateContentRequest) GetContents() []*Content {
	if x != nil {
		return x.Contents
	}
	return nil
}

func (x *GenerateContentRequest) GetTools() []*Tool {
	if x != nil {
		return x.Tools
	}
	return nil
}

func (x *GenerateContentRequest) GetToolConfig() *ToolConfig {
	if x != nil {
		return x.ToolConfig
	}
	return nil
}

func (x *GenerateContentRequest) GetSafetySettings() []*SafetySetting {
	if x != nil {
		return x.SafetySettings
	}
	return nil
}

func (x *GenerateContentRequest) GetGenerationConfig() *GenerationConfig {
	if x != nil {
		return x.GenerationConfig
	}
	return nil
}

func (x *GenerateContentRequest) GetCachedContent() string {
	if x != nil && x.CachedContent != nil {
		return *x.CachedContent
	}
	return ""
}

// The configuration for the prebuilt speaker to use.
type PrebuiltVoiceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the preset voice to use.
	VoiceName *string `protobuf:"bytes,1,opt,name=voice_name,json=voiceName,proto3,oneof" json:"voice_name,omitempty"`
}

func (x *PrebuiltVoiceConfig) Reset() {
	*x = PrebuiltVoiceConfig{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PrebuiltVoiceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrebuiltVoiceConfig) ProtoMessage() {}

func (x *PrebuiltVoiceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrebuiltVoiceConfig.ProtoReflect.Descriptor instead.
func (*PrebuiltVoiceConfig) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{1}
}

func (x *PrebuiltVoiceConfig) GetVoiceName() string {
	if x != nil && x.VoiceName != nil {
		return *x.VoiceName
	}
	return ""
}

// The configuration for the voice to use.
type VoiceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The configuration for the speaker to use.
	//
	// Types that are assignable to VoiceConfig:
	//
	//	*VoiceConfig_PrebuiltVoiceConfig
	VoiceConfig isVoiceConfig_VoiceConfig `protobuf_oneof:"voice_config"`
}

func (x *VoiceConfig) Reset() {
	*x = VoiceConfig{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VoiceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VoiceConfig) ProtoMessage() {}

func (x *VoiceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VoiceConfig.ProtoReflect.Descriptor instead.
func (*VoiceConfig) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{2}
}

func (m *VoiceConfig) GetVoiceConfig() isVoiceConfig_VoiceConfig {
	if m != nil {
		return m.VoiceConfig
	}
	return nil
}

func (x *VoiceConfig) GetPrebuiltVoiceConfig() *PrebuiltVoiceConfig {
	if x, ok := x.GetVoiceConfig().(*VoiceConfig_PrebuiltVoiceConfig); ok {
		return x.PrebuiltVoiceConfig
	}
	return nil
}

type isVoiceConfig_VoiceConfig interface {
	isVoiceConfig_VoiceConfig()
}

type VoiceConfig_PrebuiltVoiceConfig struct {
	// The configuration for the prebuilt voice to use.
	PrebuiltVoiceConfig *PrebuiltVoiceConfig `protobuf:"bytes,1,opt,name=prebuilt_voice_config,json=prebuiltVoiceConfig,proto3,oneof"`
}

func (*VoiceConfig_PrebuiltVoiceConfig) isVoiceConfig_VoiceConfig() {}

// The speech generation config.
type SpeechConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The configuration in case of single-voice output.
	VoiceConfig *VoiceConfig `protobuf:"bytes,1,opt,name=voice_config,json=voiceConfig,proto3" json:"voice_config,omitempty"`
	// Optional. Language code (in BCP 47 format, e.g. "en-US") for speech
	// synthesis.
	//
	// Valid values are: de-DE, en-AU, en-GB, en-IN, en-US, es-US, fr-FR, hi-IN,
	// pt-BR, ar-XA, es-ES, fr-CA, id-ID, it-IT, ja-JP, tr-TR, vi-VN, bn-IN,
	// gu-IN, kn-IN, ml-IN, mr-IN, ta-IN, te-IN, nl-NL, ko-KR, cmn-CN, pl-PL,
	// ru-RU, and th-TH.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *SpeechConfig) Reset() {
	*x = SpeechConfig{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SpeechConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpeechConfig) ProtoMessage() {}

func (x *SpeechConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpeechConfig.ProtoReflect.Descriptor instead.
func (*SpeechConfig) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{3}
}

func (x *SpeechConfig) GetVoiceConfig() *VoiceConfig {
	if x != nil {
		return x.VoiceConfig
	}
	return nil
}

func (x *SpeechConfig) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// Config for thinking features.
type ThinkingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates whether to include thoughts in the response.
	// If true, thoughts are returned only when available.
	IncludeThoughts *bool `protobuf:"varint,1,opt,name=include_thoughts,json=includeThoughts,proto3,oneof" json:"include_thoughts,omitempty"`
	// The number of thoughts tokens that the model should generate.
	ThinkingBudget *int32 `protobuf:"varint,2,opt,name=thinking_budget,json=thinkingBudget,proto3,oneof" json:"thinking_budget,omitempty"`
}

func (x *ThinkingConfig) Reset() {
	*x = ThinkingConfig{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ThinkingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ThinkingConfig) ProtoMessage() {}

func (x *ThinkingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ThinkingConfig.ProtoReflect.Descriptor instead.
func (*ThinkingConfig) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{4}
}

func (x *ThinkingConfig) GetIncludeThoughts() bool {
	if x != nil && x.IncludeThoughts != nil {
		return *x.IncludeThoughts
	}
	return false
}

func (x *ThinkingConfig) GetThinkingBudget() int32 {
	if x != nil && x.ThinkingBudget != nil {
		return *x.ThinkingBudget
	}
	return 0
}

// Configuration options for model generation and outputs. Not all parameters
// are configurable for every model.
type GenerationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Number of generated responses to return. If unset, this will
	// default to 1. Please note that this doesn't work for previous generation
	// models (Gemini 1.0 family)
	CandidateCount *int32 `protobuf:"varint,1,opt,name=candidate_count,json=candidateCount,proto3,oneof" json:"candidate_count,omitempty"`
	// Optional. The set of character sequences (up to 5) that will stop output
	// generation. If specified, the API will stop at the first appearance of a
	// `stop_sequence`. The stop sequence will not be included as part of the
	// response.
	StopSequences []string `protobuf:"bytes,2,rep,name=stop_sequences,json=stopSequences,proto3" json:"stop_sequences,omitempty"`
	// Optional. The maximum number of tokens to include in a response candidate.
	//
	// Note: The default value varies by model, see the `Model.output_token_limit`
	// attribute of the `Model` returned from the `getModel` function.
	MaxOutputTokens *int32 `protobuf:"varint,4,opt,name=max_output_tokens,json=maxOutputTokens,proto3,oneof" json:"max_output_tokens,omitempty"`
	// Optional. Controls the randomness of the output.
	//
	// Note: The default value varies by model, see the `Model.temperature`
	// attribute of the `Model` returned from the `getModel` function.
	//
	// Values can range from [0.0, 2.0].
	Temperature *float32 `protobuf:"fixed32,5,opt,name=temperature,proto3,oneof" json:"temperature,omitempty"`
	// Optional. The maximum cumulative probability of tokens to consider when
	// sampling.
	//
	// The model uses combined Top-k and Top-p (nucleus) sampling.
	//
	// Tokens are sorted based on their assigned probabilities so that only the
	// most likely tokens are considered. Top-k sampling directly limits the
	// maximum number of tokens to consider, while Nucleus sampling limits the
	// number of tokens based on the cumulative probability.
	//
	// Note: The default value varies by `Model` and is specified by
	// the`Model.top_p` attribute returned from the `getModel` function. An empty
	// `top_k` attribute indicates that the model doesn't apply top-k sampling
	// and doesn't allow setting `top_k` on requests.
	TopP *float32 `protobuf:"fixed32,6,opt,name=top_p,json=topP,proto3,oneof" json:"top_p,omitempty"`
	// Optional. The maximum number of tokens to consider when sampling.
	//
	// Gemini models use Top-p (nucleus) sampling or a combination of Top-k and
	// nucleus sampling. Top-k sampling considers the set of `top_k` most probable
	// tokens. Models running with nucleus sampling don't allow top_k setting.
	//
	// Note: The default value varies by `Model` and is specified by
	// the`Model.top_p` attribute returned from the `getModel` function. An empty
	// `top_k` attribute indicates that the model doesn't apply top-k sampling
	// and doesn't allow setting `top_k` on requests.
	TopK *int32 `protobuf:"varint,7,opt,name=top_k,json=topK,proto3,oneof" json:"top_k,omitempty"`
	// Optional. Seed used in decoding. If not set, the request uses a randomly
	// generated seed.
	Seed *int32 `protobuf:"varint,8,opt,name=seed,proto3,oneof" json:"seed,omitempty"`
	// Optional. MIME type of the generated candidate text.
	// Supported MIME types are:
	// `text/plain`: (default) Text output.
	// `application/json`: JSON response in the response candidates.
	// `text/x.enum`: ENUM as a string response in the response candidates.
	// Refer to the
	// [docs](https://ai.google.dev/gemini-api/docs/prompting_with_media#plain_text_formats)
	// for a list of all supported text MIME types.
	ResponseMimeType string `protobuf:"bytes,13,opt,name=response_mime_type,json=responseMimeType,proto3" json:"response_mime_type,omitempty"`
	// Optional. Output schema of the generated candidate text. Schemas must be a
	// subset of the [OpenAPI schema](https://spec.openapis.org/oas/v3.0.3#schema)
	// and can be objects, primitives or arrays.
	//
	// If set, a compatible `response_mime_type` must also be set.
	// Compatible MIME types:
	// `application/json`: Schema for JSON response.
	// Refer to the [JSON text generation
	// guide](https://ai.google.dev/gemini-api/docs/json-mode) for more details.
	ResponseSchema *Schema `protobuf:"bytes,14,opt,name=response_schema,json=responseSchema,proto3" json:"response_schema,omitempty"`
	// Optional. Presence penalty applied to the next token's logprobs if the
	// token has already been seen in the response.
	//
	// This penalty is binary on/off and not dependant on the number of times the
	// token is used (after the first). Use
	// [frequency_penalty][google.ai.generativelanguage.v1beta.GenerationConfig.frequency_penalty]
	// for a penalty that increases with each use.
	//
	// A positive penalty will discourage the use of tokens that have already
	// been used in the response, increasing the vocabulary.
	//
	// A negative penalty will encourage the use of tokens that have already been
	// used in the response, decreasing the vocabulary.
	PresencePenalty *float32 `protobuf:"fixed32,15,opt,name=presence_penalty,json=presencePenalty,proto3,oneof" json:"presence_penalty,omitempty"`
	// Optional. Frequency penalty applied to the next token's logprobs,
	// multiplied by the number of times each token has been seen in the respponse
	// so far.
	//
	// A positive penalty will discourage the use of tokens that have already
	// been used, proportional to the number of times the token has been used:
	// The more a token is used, the more difficult it is for the model to use
	// that token again increasing the vocabulary of responses.
	//
	// Caution: A _negative_ penalty will encourage the model to reuse tokens
	// proportional to the number of times the token has been used. Small
	// negative values will reduce the vocabulary of a response. Larger negative
	// values will cause the model to start repeating a common token  until it
	// hits the
	// [max_output_tokens][google.ai.generativelanguage.v1beta.GenerationConfig.max_output_tokens]
	// limit.
	FrequencyPenalty *float32 `protobuf:"fixed32,16,opt,name=frequency_penalty,json=frequencyPenalty,proto3,oneof" json:"frequency_penalty,omitempty"`
	// Optional. If true, export the logprobs results in response.
	ResponseLogprobs *bool `protobuf:"varint,17,opt,name=response_logprobs,json=responseLogprobs,proto3,oneof" json:"response_logprobs,omitempty"`
	// Optional. Only valid if
	// [response_logprobs=True][google.ai.generativelanguage.v1beta.GenerationConfig.response_logprobs].
	// This sets the number of top logprobs to return at each decoding step in the
	// [Candidate.logprobs_result][google.ai.generativelanguage.v1beta.Candidate.logprobs_result].
	Logprobs *int32 `protobuf:"varint,18,opt,name=logprobs,proto3,oneof" json:"logprobs,omitempty"`
	// Optional. Enables enhanced civic answers. It may not be available for all
	// models.
	EnableEnhancedCivicAnswers *bool `protobuf:"varint,19,opt,name=enable_enhanced_civic_answers,json=enableEnhancedCivicAnswers,proto3,oneof" json:"enable_enhanced_civic_answers,omitempty"`
	// Optional. The requested modalities of the response. Represents the set of
	// modalities that the model can return, and should be expected in the
	// response. This is an exact match to the modalities of the response.
	//
	// A model may have multiple combinations of supported modalities. If the
	// requested modalities do not match any of the supported combinations, an
	// error will be returned.
	//
	// An empty list is equivalent to requesting only text.
	ResponseModalities []GenerationConfig_Modality `protobuf:"varint,20,rep,packed,name=response_modalities,json=responseModalities,proto3,enum=google.ai.generativelanguage.v1beta.GenerationConfig_Modality" json:"response_modalities,omitempty"`
	// Optional. The speech generation config.
	SpeechConfig *SpeechConfig `protobuf:"bytes,21,opt,name=speech_config,json=speechConfig,proto3,oneof" json:"speech_config,omitempty"`
	// Optional. Config for thinking features.
	// An error will be returned if this field is set for models that don't
	// support thinking.
	ThinkingConfig *ThinkingConfig `protobuf:"bytes,22,opt,name=thinking_config,json=thinkingConfig,proto3,oneof" json:"thinking_config,omitempty"`
	// Optional. If specified, the media resolution specified will be used.
	MediaResolution *GenerationConfig_MediaResolution `protobuf:"varint,23,opt,name=media_resolution,json=mediaResolution,proto3,enum=google.ai.generativelanguage.v1beta.GenerationConfig_MediaResolution,oneof" json:"media_resolution,omitempty"`
}

func (x *GenerationConfig) Reset() {
	*x = GenerationConfig{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerationConfig) ProtoMessage() {}

func (x *GenerationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerationConfig.ProtoReflect.Descriptor instead.
func (*GenerationConfig) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{5}
}

func (x *GenerationConfig) GetCandidateCount() int32 {
	if x != nil && x.CandidateCount != nil {
		return *x.CandidateCount
	}
	return 0
}

func (x *GenerationConfig) GetStopSequences() []string {
	if x != nil {
		return x.StopSequences
	}
	return nil
}

func (x *GenerationConfig) GetMaxOutputTokens() int32 {
	if x != nil && x.MaxOutputTokens != nil {
		return *x.MaxOutputTokens
	}
	return 0
}

func (x *GenerationConfig) GetTemperature() float32 {
	if x != nil && x.Temperature != nil {
		return *x.Temperature
	}
	return 0
}

func (x *GenerationConfig) GetTopP() float32 {
	if x != nil && x.TopP != nil {
		return *x.TopP
	}
	return 0
}

func (x *GenerationConfig) GetTopK() int32 {
	if x != nil && x.TopK != nil {
		return *x.TopK
	}
	return 0
}

func (x *GenerationConfig) GetSeed() int32 {
	if x != nil && x.Seed != nil {
		return *x.Seed
	}
	return 0
}

func (x *GenerationConfig) GetResponseMimeType() string {
	if x != nil {
		return x.ResponseMimeType
	}
	return ""
}

func (x *GenerationConfig) GetResponseSchema() *Schema {
	if x != nil {
		return x.ResponseSchema
	}
	return nil
}

func (x *GenerationConfig) GetPresencePenalty() float32 {
	if x != nil && x.PresencePenalty != nil {
		return *x.PresencePenalty
	}
	return 0
}

func (x *GenerationConfig) GetFrequencyPenalty() float32 {
	if x != nil && x.FrequencyPenalty != nil {
		return *x.FrequencyPenalty
	}
	return 0
}

func (x *GenerationConfig) GetResponseLogprobs() bool {
	if x != nil && x.ResponseLogprobs != nil {
		return *x.ResponseLogprobs
	}
	return false
}

func (x *GenerationConfig) GetLogprobs() int32 {
	if x != nil && x.Logprobs != nil {
		return *x.Logprobs
	}
	return 0
}

func (x *GenerationConfig) GetEnableEnhancedCivicAnswers() bool {
	if x != nil && x.EnableEnhancedCivicAnswers != nil {
		return *x.EnableEnhancedCivicAnswers
	}
	return false
}

func (x *GenerationConfig) GetResponseModalities() []GenerationConfig_Modality {
	if x != nil {
		return x.ResponseModalities
	}
	return nil
}

func (x *GenerationConfig) GetSpeechConfig() *SpeechConfig {
	if x != nil {
		return x.SpeechConfig
	}
	return nil
}

func (x *GenerationConfig) GetThinkingConfig() *ThinkingConfig {
	if x != nil {
		return x.ThinkingConfig
	}
	return nil
}

func (x *GenerationConfig) GetMediaResolution() GenerationConfig_MediaResolution {
	if x != nil && x.MediaResolution != nil {
		return *x.MediaResolution
	}
	return GenerationConfig_MEDIA_RESOLUTION_UNSPECIFIED
}

// Configuration for retrieving grounding content from a `Corpus` or
// `Document` created using the Semantic Retriever API.
type SemanticRetrieverConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource for retrieval. Example: `corpora/123` or
	// `corpora/123/documents/abc`.
	Source string `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// Required. Query to use for matching `Chunk`s in the given resource by
	// similarity.
	Query *Content `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Optional. Filters for selecting `Document`s and/or `Chunk`s from the
	// resource.
	MetadataFilters []*MetadataFilter `protobuf:"bytes,3,rep,name=metadata_filters,json=metadataFilters,proto3" json:"metadata_filters,omitempty"`
	// Optional. Maximum number of relevant `Chunk`s to retrieve.
	MaxChunksCount *int32 `protobuf:"varint,4,opt,name=max_chunks_count,json=maxChunksCount,proto3,oneof" json:"max_chunks_count,omitempty"`
	// Optional. Minimum relevance score for retrieved relevant `Chunk`s.
	MinimumRelevanceScore *float32 `protobuf:"fixed32,5,opt,name=minimum_relevance_score,json=minimumRelevanceScore,proto3,oneof" json:"minimum_relevance_score,omitempty"`
}

func (x *SemanticRetrieverConfig) Reset() {
	*x = SemanticRetrieverConfig{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SemanticRetrieverConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SemanticRetrieverConfig) ProtoMessage() {}

func (x *SemanticRetrieverConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SemanticRetrieverConfig.ProtoReflect.Descriptor instead.
func (*SemanticRetrieverConfig) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{6}
}

func (x *SemanticRetrieverConfig) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *SemanticRetrieverConfig) GetQuery() *Content {
	if x != nil {
		return x.Query
	}
	return nil
}

func (x *SemanticRetrieverConfig) GetMetadataFilters() []*MetadataFilter {
	if x != nil {
		return x.MetadataFilters
	}
	return nil
}

func (x *SemanticRetrieverConfig) GetMaxChunksCount() int32 {
	if x != nil && x.MaxChunksCount != nil {
		return *x.MaxChunksCount
	}
	return 0
}

func (x *SemanticRetrieverConfig) GetMinimumRelevanceScore() float32 {
	if x != nil && x.MinimumRelevanceScore != nil {
		return *x.MinimumRelevanceScore
	}
	return 0
}

// Response from the model supporting multiple candidate responses.
//
// Safety ratings and content filtering are reported for both
// prompt in `GenerateContentResponse.prompt_feedback` and for each candidate
// in `finish_reason` and in `safety_ratings`. The API:
//   - Returns either all requested candidates or none of them
//   - Returns no candidates at all only if there was something wrong with the
//     prompt (check `prompt_feedback`)
//   - Reports feedback on each candidate in `finish_reason` and
//     `safety_ratings`.
type GenerateContentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Candidate responses from the model.
	Candidates []*Candidate `protobuf:"bytes,1,rep,name=candidates,proto3" json:"candidates,omitempty"`
	// Returns the prompt's feedback related to the content filters.
	PromptFeedback *GenerateContentResponse_PromptFeedback `protobuf:"bytes,2,opt,name=prompt_feedback,json=promptFeedback,proto3" json:"prompt_feedback,omitempty"`
	// Output only. Metadata on the generation requests' token usage.
	UsageMetadata *GenerateContentResponse_UsageMetadata `protobuf:"bytes,3,opt,name=usage_metadata,json=usageMetadata,proto3" json:"usage_metadata,omitempty"`
	// Output only. The model version used to generate the response.
	ModelVersion string `protobuf:"bytes,4,opt,name=model_version,json=modelVersion,proto3" json:"model_version,omitempty"`
}

func (x *GenerateContentResponse) Reset() {
	*x = GenerateContentResponse{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateContentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateContentResponse) ProtoMessage() {}

func (x *GenerateContentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateContentResponse.ProtoReflect.Descriptor instead.
func (*GenerateContentResponse) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{7}
}

func (x *GenerateContentResponse) GetCandidates() []*Candidate {
	if x != nil {
		return x.Candidates
	}
	return nil
}

func (x *GenerateContentResponse) GetPromptFeedback() *GenerateContentResponse_PromptFeedback {
	if x != nil {
		return x.PromptFeedback
	}
	return nil
}

func (x *GenerateContentResponse) GetUsageMetadata() *GenerateContentResponse_UsageMetadata {
	if x != nil {
		return x.UsageMetadata
	}
	return nil
}

func (x *GenerateContentResponse) GetModelVersion() string {
	if x != nil {
		return x.ModelVersion
	}
	return ""
}

// A response candidate generated from the model.
type Candidate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Index of the candidate in the list of response candidates.
	Index *int32 `protobuf:"varint,3,opt,name=index,proto3,oneof" json:"index,omitempty"`
	// Output only. Generated content returned from the model.
	Content *Content `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// Optional. Output only. The reason why the model stopped generating tokens.
	//
	// If empty, the model has not stopped generating tokens.
	FinishReason Candidate_FinishReason `protobuf:"varint,2,opt,name=finish_reason,json=finishReason,proto3,enum=google.ai.generativelanguage.v1beta.Candidate_FinishReason" json:"finish_reason,omitempty"`
	// List of ratings for the safety of a response candidate.
	//
	// There is at most one rating per category.
	SafetyRatings []*SafetyRating `protobuf:"bytes,5,rep,name=safety_ratings,json=safetyRatings,proto3" json:"safety_ratings,omitempty"`
	// Output only. Citation information for model-generated candidate.
	//
	// This field may be populated with recitation information for any text
	// included in the `content`. These are passages that are "recited" from
	// copyrighted material in the foundational LLM's training data.
	CitationMetadata *CitationMetadata `protobuf:"bytes,6,opt,name=citation_metadata,json=citationMetadata,proto3" json:"citation_metadata,omitempty"`
	// Output only. Token count for this candidate.
	TokenCount int32 `protobuf:"varint,7,opt,name=token_count,json=tokenCount,proto3" json:"token_count,omitempty"`
	// Output only. Attribution information for sources that contributed to a
	// grounded answer.
	//
	// This field is populated for `GenerateAnswer` calls.
	GroundingAttributions []*GroundingAttribution `protobuf:"bytes,8,rep,name=grounding_attributions,json=groundingAttributions,proto3" json:"grounding_attributions,omitempty"`
	// Output only. Grounding metadata for the candidate.
	//
	// This field is populated for `GenerateContent` calls.
	GroundingMetadata *GroundingMetadata `protobuf:"bytes,9,opt,name=grounding_metadata,json=groundingMetadata,proto3" json:"grounding_metadata,omitempty"`
	// Output only. Average log probability score of the candidate.
	AvgLogprobs float64 `protobuf:"fixed64,10,opt,name=avg_logprobs,json=avgLogprobs,proto3" json:"avg_logprobs,omitempty"`
	// Output only. Log-likelihood scores for the response tokens and top tokens
	LogprobsResult *LogprobsResult `protobuf:"bytes,11,opt,name=logprobs_result,json=logprobsResult,proto3" json:"logprobs_result,omitempty"`
}

func (x *Candidate) Reset() {
	*x = Candidate{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Candidate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Candidate) ProtoMessage() {}

func (x *Candidate) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Candidate.ProtoReflect.Descriptor instead.
func (*Candidate) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{8}
}

func (x *Candidate) GetIndex() int32 {
	if x != nil && x.Index != nil {
		return *x.Index
	}
	return 0
}

func (x *Candidate) GetContent() *Content {
	if x != nil {
		return x.Content
	}
	return nil
}

func (x *Candidate) GetFinishReason() Candidate_FinishReason {
	if x != nil {
		return x.FinishReason
	}
	return Candidate_FINISH_REASON_UNSPECIFIED
}

func (x *Candidate) GetSafetyRatings() []*SafetyRating {
	if x != nil {
		return x.SafetyRatings
	}
	return nil
}

func (x *Candidate) GetCitationMetadata() *CitationMetadata {
	if x != nil {
		return x.CitationMetadata
	}
	return nil
}

func (x *Candidate) GetTokenCount() int32 {
	if x != nil {
		return x.TokenCount
	}
	return 0
}

func (x *Candidate) GetGroundingAttributions() []*GroundingAttribution {
	if x != nil {
		return x.GroundingAttributions
	}
	return nil
}

func (x *Candidate) GetGroundingMetadata() *GroundingMetadata {
	if x != nil {
		return x.GroundingMetadata
	}
	return nil
}

func (x *Candidate) GetAvgLogprobs() float64 {
	if x != nil {
		return x.AvgLogprobs
	}
	return 0
}

func (x *Candidate) GetLogprobsResult() *LogprobsResult {
	if x != nil {
		return x.LogprobsResult
	}
	return nil
}

// Logprobs Result
type LogprobsResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Length = total number of decoding steps.
	TopCandidates []*LogprobsResult_TopCandidates `protobuf:"bytes,1,rep,name=top_candidates,json=topCandidates,proto3" json:"top_candidates,omitempty"`
	// Length = total number of decoding steps.
	// The chosen candidates may or may not be in top_candidates.
	ChosenCandidates []*LogprobsResult_Candidate `protobuf:"bytes,2,rep,name=chosen_candidates,json=chosenCandidates,proto3" json:"chosen_candidates,omitempty"`
}

func (x *LogprobsResult) Reset() {
	*x = LogprobsResult{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogprobsResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogprobsResult) ProtoMessage() {}

func (x *LogprobsResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogprobsResult.ProtoReflect.Descriptor instead.
func (*LogprobsResult) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{9}
}

func (x *LogprobsResult) GetTopCandidates() []*LogprobsResult_TopCandidates {
	if x != nil {
		return x.TopCandidates
	}
	return nil
}

func (x *LogprobsResult) GetChosenCandidates() []*LogprobsResult_Candidate {
	if x != nil {
		return x.ChosenCandidates
	}
	return nil
}

// Identifier for the source contributing to this attribution.
type AttributionSourceId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Source:
	//
	//	*AttributionSourceId_GroundingPassage
	//	*AttributionSourceId_SemanticRetrieverChunk_
	Source isAttributionSourceId_Source `protobuf_oneof:"source"`
}

func (x *AttributionSourceId) Reset() {
	*x = AttributionSourceId{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AttributionSourceId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributionSourceId) ProtoMessage() {}

func (x *AttributionSourceId) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributionSourceId.ProtoReflect.Descriptor instead.
func (*AttributionSourceId) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{10}
}

func (m *AttributionSourceId) GetSource() isAttributionSourceId_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *AttributionSourceId) GetGroundingPassage() *AttributionSourceId_GroundingPassageId {
	if x, ok := x.GetSource().(*AttributionSourceId_GroundingPassage); ok {
		return x.GroundingPassage
	}
	return nil
}

func (x *AttributionSourceId) GetSemanticRetrieverChunk() *AttributionSourceId_SemanticRetrieverChunk {
	if x, ok := x.GetSource().(*AttributionSourceId_SemanticRetrieverChunk_); ok {
		return x.SemanticRetrieverChunk
	}
	return nil
}

type isAttributionSourceId_Source interface {
	isAttributionSourceId_Source()
}

type AttributionSourceId_GroundingPassage struct {
	// Identifier for an inline passage.
	GroundingPassage *AttributionSourceId_GroundingPassageId `protobuf:"bytes,1,opt,name=grounding_passage,json=groundingPassage,proto3,oneof"`
}

type AttributionSourceId_SemanticRetrieverChunk_ struct {
	// Identifier for a `Chunk` fetched via Semantic Retriever.
	SemanticRetrieverChunk *AttributionSourceId_SemanticRetrieverChunk `protobuf:"bytes,2,opt,name=semantic_retriever_chunk,json=semanticRetrieverChunk,proto3,oneof"`
}

func (*AttributionSourceId_GroundingPassage) isAttributionSourceId_Source() {}

func (*AttributionSourceId_SemanticRetrieverChunk_) isAttributionSourceId_Source() {}

// Attribution for a source that contributed to an answer.
type GroundingAttribution struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Identifier for the source contributing to this attribution.
	SourceId *AttributionSourceId `protobuf:"bytes,3,opt,name=source_id,json=sourceId,proto3" json:"source_id,omitempty"`
	// Grounding source content that makes up this attribution.
	Content *Content `protobuf:"bytes,2,opt,name=content,proto3" json:"content,omitempty"`
}

func (x *GroundingAttribution) Reset() {
	*x = GroundingAttribution{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroundingAttribution) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroundingAttribution) ProtoMessage() {}

func (x *GroundingAttribution) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroundingAttribution.ProtoReflect.Descriptor instead.
func (*GroundingAttribution) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{11}
}

func (x *GroundingAttribution) GetSourceId() *AttributionSourceId {
	if x != nil {
		return x.SourceId
	}
	return nil
}

func (x *GroundingAttribution) GetContent() *Content {
	if x != nil {
		return x.Content
	}
	return nil
}

// Metadata related to retrieval in the grounding flow.
type RetrievalMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Score indicating how likely information from google search could
	// help answer the prompt. The score is in the range [0, 1], where 0 is the
	// least likely and 1 is the most likely. This score is only populated when
	// google search grounding and dynamic retrieval is enabled. It will be
	// compared to the threshold to determine whether to trigger google search.
	GoogleSearchDynamicRetrievalScore float32 `protobuf:"fixed32,2,opt,name=google_search_dynamic_retrieval_score,json=googleSearchDynamicRetrievalScore,proto3" json:"google_search_dynamic_retrieval_score,omitempty"`
}

func (x *RetrievalMetadata) Reset() {
	*x = RetrievalMetadata{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RetrievalMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetrievalMetadata) ProtoMessage() {}

func (x *RetrievalMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetrievalMetadata.ProtoReflect.Descriptor instead.
func (*RetrievalMetadata) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{12}
}

func (x *RetrievalMetadata) GetGoogleSearchDynamicRetrievalScore() float32 {
	if x != nil {
		return x.GoogleSearchDynamicRetrievalScore
	}
	return 0
}

// Metadata returned to client when grounding is enabled.
type GroundingMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Google search entry for the following-up web searches.
	SearchEntryPoint *SearchEntryPoint `protobuf:"bytes,1,opt,name=search_entry_point,json=searchEntryPoint,proto3,oneof" json:"search_entry_point,omitempty"`
	// List of supporting references retrieved from specified grounding source.
	GroundingChunks []*GroundingChunk `protobuf:"bytes,2,rep,name=grounding_chunks,json=groundingChunks,proto3" json:"grounding_chunks,omitempty"`
	// List of grounding support.
	GroundingSupports []*GroundingSupport `protobuf:"bytes,3,rep,name=grounding_supports,json=groundingSupports,proto3" json:"grounding_supports,omitempty"`
	// Metadata related to retrieval in the grounding flow.
	RetrievalMetadata *RetrievalMetadata `protobuf:"bytes,4,opt,name=retrieval_metadata,json=retrievalMetadata,proto3,oneof" json:"retrieval_metadata,omitempty"`
	// Web search queries for the following-up web search.
	WebSearchQueries []string `protobuf:"bytes,5,rep,name=web_search_queries,json=webSearchQueries,proto3" json:"web_search_queries,omitempty"`
}

func (x *GroundingMetadata) Reset() {
	*x = GroundingMetadata{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroundingMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroundingMetadata) ProtoMessage() {}

func (x *GroundingMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroundingMetadata.ProtoReflect.Descriptor instead.
func (*GroundingMetadata) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{13}
}

func (x *GroundingMetadata) GetSearchEntryPoint() *SearchEntryPoint {
	if x != nil {
		return x.SearchEntryPoint
	}
	return nil
}

func (x *GroundingMetadata) GetGroundingChunks() []*GroundingChunk {
	if x != nil {
		return x.GroundingChunks
	}
	return nil
}

func (x *GroundingMetadata) GetGroundingSupports() []*GroundingSupport {
	if x != nil {
		return x.GroundingSupports
	}
	return nil
}

func (x *GroundingMetadata) GetRetrievalMetadata() *RetrievalMetadata {
	if x != nil {
		return x.RetrievalMetadata
	}
	return nil
}

func (x *GroundingMetadata) GetWebSearchQueries() []string {
	if x != nil {
		return x.WebSearchQueries
	}
	return nil
}

// Google search entry point.
type SearchEntryPoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Web content snippet that can be embedded in a web page or an app
	// webview.
	RenderedContent string `protobuf:"bytes,1,opt,name=rendered_content,json=renderedContent,proto3" json:"rendered_content,omitempty"`
	// Optional. Base64 encoded JSON representing array of <search term, search
	// url> tuple.
	SdkBlob []byte `protobuf:"bytes,2,opt,name=sdk_blob,json=sdkBlob,proto3" json:"sdk_blob,omitempty"`
}

func (x *SearchEntryPoint) Reset() {
	*x = SearchEntryPoint{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchEntryPoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchEntryPoint) ProtoMessage() {}

func (x *SearchEntryPoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchEntryPoint.ProtoReflect.Descriptor instead.
func (*SearchEntryPoint) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{14}
}

func (x *SearchEntryPoint) GetRenderedContent() string {
	if x != nil {
		return x.RenderedContent
	}
	return ""
}

func (x *SearchEntryPoint) GetSdkBlob() []byte {
	if x != nil {
		return x.SdkBlob
	}
	return nil
}

// Grounding chunk.
type GroundingChunk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Chunk type.
	//
	// Types that are assignable to ChunkType:
	//
	//	*GroundingChunk_Web_
	ChunkType isGroundingChunk_ChunkType `protobuf_oneof:"chunk_type"`
}

func (x *GroundingChunk) Reset() {
	*x = GroundingChunk{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroundingChunk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroundingChunk) ProtoMessage() {}

func (x *GroundingChunk) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroundingChunk.ProtoReflect.Descriptor instead.
func (*GroundingChunk) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{15}
}

func (m *GroundingChunk) GetChunkType() isGroundingChunk_ChunkType {
	if m != nil {
		return m.ChunkType
	}
	return nil
}

func (x *GroundingChunk) GetWeb() *GroundingChunk_Web {
	if x, ok := x.GetChunkType().(*GroundingChunk_Web_); ok {
		return x.Web
	}
	return nil
}

type isGroundingChunk_ChunkType interface {
	isGroundingChunk_ChunkType()
}

type GroundingChunk_Web_ struct {
	// Grounding chunk from the web.
	Web *GroundingChunk_Web `protobuf:"bytes,1,opt,name=web,proto3,oneof"`
}

func (*GroundingChunk_Web_) isGroundingChunk_ChunkType() {}

// Segment of the content.
type Segment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The index of a Part object within its parent Content object.
	PartIndex int32 `protobuf:"varint,1,opt,name=part_index,json=partIndex,proto3" json:"part_index,omitempty"`
	// Output only. Start index in the given Part, measured in bytes. Offset from
	// the start of the Part, inclusive, starting at zero.
	StartIndex int32 `protobuf:"varint,2,opt,name=start_index,json=startIndex,proto3" json:"start_index,omitempty"`
	// Output only. End index in the given Part, measured in bytes. Offset from
	// the start of the Part, exclusive, starting at zero.
	EndIndex int32 `protobuf:"varint,3,opt,name=end_index,json=endIndex,proto3" json:"end_index,omitempty"`
	// Output only. The text corresponding to the segment from the response.
	Text string `protobuf:"bytes,4,opt,name=text,proto3" json:"text,omitempty"`
}

func (x *Segment) Reset() {
	*x = Segment{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Segment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Segment) ProtoMessage() {}

func (x *Segment) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Segment.ProtoReflect.Descriptor instead.
func (*Segment) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{16}
}

func (x *Segment) GetPartIndex() int32 {
	if x != nil {
		return x.PartIndex
	}
	return 0
}

func (x *Segment) GetStartIndex() int32 {
	if x != nil {
		return x.StartIndex
	}
	return 0
}

func (x *Segment) GetEndIndex() int32 {
	if x != nil {
		return x.EndIndex
	}
	return 0
}

func (x *Segment) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

// Grounding support.
type GroundingSupport struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Segment of the content this support belongs to.
	Segment *Segment `protobuf:"bytes,1,opt,name=segment,proto3,oneof" json:"segment,omitempty"`
	// A list of indices (into 'grounding_chunk') specifying the
	// citations associated with the claim. For instance [1,3,4] means
	// that grounding_chunk[1], grounding_chunk[3],
	// grounding_chunk[4] are the retrieved content attributed to the claim.
	GroundingChunkIndices []int32 `protobuf:"varint,2,rep,packed,name=grounding_chunk_indices,json=groundingChunkIndices,proto3" json:"grounding_chunk_indices,omitempty"`
	// Confidence score of the support references. Ranges from 0 to 1. 1 is the
	// most confident. This list must have the same size as the
	// grounding_chunk_indices.
	ConfidenceScores []float32 `protobuf:"fixed32,3,rep,packed,name=confidence_scores,json=confidenceScores,proto3" json:"confidence_scores,omitempty"`
}

func (x *GroundingSupport) Reset() {
	*x = GroundingSupport{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroundingSupport) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroundingSupport) ProtoMessage() {}

func (x *GroundingSupport) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroundingSupport.ProtoReflect.Descriptor instead.
func (*GroundingSupport) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{17}
}

func (x *GroundingSupport) GetSegment() *Segment {
	if x != nil {
		return x.Segment
	}
	return nil
}

func (x *GroundingSupport) GetGroundingChunkIndices() []int32 {
	if x != nil {
		return x.GroundingChunkIndices
	}
	return nil
}

func (x *GroundingSupport) GetConfidenceScores() []float32 {
	if x != nil {
		return x.ConfidenceScores
	}
	return nil
}

// Request to generate a grounded answer from the `Model`.
type GenerateAnswerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The sources in which to ground the answer.
	//
	// Types that are assignable to GroundingSource:
	//
	//	*GenerateAnswerRequest_InlinePassages
	//	*GenerateAnswerRequest_SemanticRetriever
	GroundingSource isGenerateAnswerRequest_GroundingSource `protobuf_oneof:"grounding_source"`
	// Required. The name of the `Model` to use for generating the grounded
	// response.
	//
	// Format: `model=models/{model}`.
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Required. The content of the current conversation with the `Model`. For
	// single-turn queries, this is a single question to answer. For multi-turn
	// queries, this is a repeated field that contains conversation history and
	// the last `Content` in the list containing the question.
	//
	// Note: `GenerateAnswer` only supports queries in English.
	Contents []*Content `protobuf:"bytes,2,rep,name=contents,proto3" json:"contents,omitempty"`
	// Required. Style in which answers should be returned.
	AnswerStyle GenerateAnswerRequest_AnswerStyle `protobuf:"varint,5,opt,name=answer_style,json=answerStyle,proto3,enum=google.ai.generativelanguage.v1beta.GenerateAnswerRequest_AnswerStyle" json:"answer_style,omitempty"`
	// Optional. A list of unique `SafetySetting` instances for blocking unsafe
	// content.
	//
	// This will be enforced on the `GenerateAnswerRequest.contents` and
	// `GenerateAnswerResponse.candidate`. There should not be more than one
	// setting for each `SafetyCategory` type. The API will block any contents and
	// responses that fail to meet the thresholds set by these settings. This list
	// overrides the default settings for each `SafetyCategory` specified in the
	// safety_settings. If there is no `SafetySetting` for a given
	// `SafetyCategory` provided in the list, the API will use the default safety
	// setting for that category. Harm categories HARM_CATEGORY_HATE_SPEECH,
	// HARM_CATEGORY_SEXUALLY_EXPLICIT, HARM_CATEGORY_DANGEROUS_CONTENT,
	// HARM_CATEGORY_HARASSMENT are supported.
	// Refer to the
	// [guide](https://ai.google.dev/gemini-api/docs/safety-settings)
	// for detailed information on available safety settings. Also refer to the
	// [Safety guidance](https://ai.google.dev/gemini-api/docs/safety-guidance) to
	// learn how to incorporate safety considerations in your AI applications.
	SafetySettings []*SafetySetting `protobuf:"bytes,3,rep,name=safety_settings,json=safetySettings,proto3" json:"safety_settings,omitempty"`
	// Optional. Controls the randomness of the output.
	//
	// Values can range from [0.0,1.0], inclusive. A value closer to 1.0 will
	// produce responses that are more varied and creative, while a value closer
	// to 0.0 will typically result in more straightforward responses from the
	// model. A low temperature (~0.2) is usually recommended for
	// Attributed-Question-Answering use cases.
	Temperature *float32 `protobuf:"fixed32,4,opt,name=temperature,proto3,oneof" json:"temperature,omitempty"`
}

func (x *GenerateAnswerRequest) Reset() {
	*x = GenerateAnswerRequest{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateAnswerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateAnswerRequest) ProtoMessage() {}

func (x *GenerateAnswerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateAnswerRequest.ProtoReflect.Descriptor instead.
func (*GenerateAnswerRequest) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{18}
}

func (m *GenerateAnswerRequest) GetGroundingSource() isGenerateAnswerRequest_GroundingSource {
	if m != nil {
		return m.GroundingSource
	}
	return nil
}

func (x *GenerateAnswerRequest) GetInlinePassages() *GroundingPassages {
	if x, ok := x.GetGroundingSource().(*GenerateAnswerRequest_InlinePassages); ok {
		return x.InlinePassages
	}
	return nil
}

func (x *GenerateAnswerRequest) GetSemanticRetriever() *SemanticRetrieverConfig {
	if x, ok := x.GetGroundingSource().(*GenerateAnswerRequest_SemanticRetriever); ok {
		return x.SemanticRetriever
	}
	return nil
}

func (x *GenerateAnswerRequest) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *GenerateAnswerRequest) GetContents() []*Content {
	if x != nil {
		return x.Contents
	}
	return nil
}

func (x *GenerateAnswerRequest) GetAnswerStyle() GenerateAnswerRequest_AnswerStyle {
	if x != nil {
		return x.AnswerStyle
	}
	return GenerateAnswerRequest_ANSWER_STYLE_UNSPECIFIED
}

func (x *GenerateAnswerRequest) GetSafetySettings() []*SafetySetting {
	if x != nil {
		return x.SafetySettings
	}
	return nil
}

func (x *GenerateAnswerRequest) GetTemperature() float32 {
	if x != nil && x.Temperature != nil {
		return *x.Temperature
	}
	return 0
}

type isGenerateAnswerRequest_GroundingSource interface {
	isGenerateAnswerRequest_GroundingSource()
}

type GenerateAnswerRequest_InlinePassages struct {
	// Passages provided inline with the request.
	InlinePassages *GroundingPassages `protobuf:"bytes,6,opt,name=inline_passages,json=inlinePassages,proto3,oneof"`
}

type GenerateAnswerRequest_SemanticRetriever struct {
	// Content retrieved from resources created via the Semantic Retriever
	// API.
	SemanticRetriever *SemanticRetrieverConfig `protobuf:"bytes,7,opt,name=semantic_retriever,json=semanticRetriever,proto3,oneof"`
}

func (*GenerateAnswerRequest_InlinePassages) isGenerateAnswerRequest_GroundingSource() {}

func (*GenerateAnswerRequest_SemanticRetriever) isGenerateAnswerRequest_GroundingSource() {}

// Response from the model for a grounded answer.
type GenerateAnswerResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Candidate answer from the model.
	//
	// Note: The model *always* attempts to provide a grounded answer, even when
	// the answer is unlikely to be answerable from the given passages.
	// In that case, a low-quality or ungrounded answer may be provided, along
	// with a low `answerable_probability`.
	Answer *Candidate `protobuf:"bytes,1,opt,name=answer,proto3" json:"answer,omitempty"`
	// Output only. The model's estimate of the probability that its answer is
	// correct and grounded in the input passages.
	//
	// A low `answerable_probability` indicates that the answer might not be
	// grounded in the sources.
	//
	// When `answerable_probability` is low, you may want to:
	//
	// * Display a message to the effect of "We couldn’t answer that question" to
	// the user.
	// * Fall back to a general-purpose LLM that answers the question from world
	// knowledge. The threshold and nature of such fallbacks will depend on
	// individual use cases. `0.5` is a good starting threshold.
	AnswerableProbability *float32 `protobuf:"fixed32,2,opt,name=answerable_probability,json=answerableProbability,proto3,oneof" json:"answerable_probability,omitempty"`
	// Output only. Feedback related to the input data used to answer the
	// question, as opposed to the model-generated response to the question.
	//
	// The input data can be one or more of the following:
	//
	// - Question specified by the last entry in `GenerateAnswerRequest.content`
	// - Conversation history specified by the other entries in
	// `GenerateAnswerRequest.content`
	// - Grounding sources (`GenerateAnswerRequest.semantic_retriever` or
	// `GenerateAnswerRequest.inline_passages`)
	InputFeedback *GenerateAnswerResponse_InputFeedback `protobuf:"bytes,3,opt,name=input_feedback,json=inputFeedback,proto3,oneof" json:"input_feedback,omitempty"`
}

func (x *GenerateAnswerResponse) Reset() {
	*x = GenerateAnswerResponse{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateAnswerResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateAnswerResponse) ProtoMessage() {}

func (x *GenerateAnswerResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateAnswerResponse.ProtoReflect.Descriptor instead.
func (*GenerateAnswerResponse) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{19}
}

func (x *GenerateAnswerResponse) GetAnswer() *Candidate {
	if x != nil {
		return x.Answer
	}
	return nil
}

func (x *GenerateAnswerResponse) GetAnswerableProbability() float32 {
	if x != nil && x.AnswerableProbability != nil {
		return *x.AnswerableProbability
	}
	return 0
}

func (x *GenerateAnswerResponse) GetInputFeedback() *GenerateAnswerResponse_InputFeedback {
	if x != nil {
		return x.InputFeedback
	}
	return nil
}

// Request containing the `Content` for the model to embed.
type EmbedContentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The model's resource name. This serves as an ID for the Model to
	// use.
	//
	// This name should match a model name returned by the `ListModels` method.
	//
	// Format: `models/{model}`
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Required. The content to embed. Only the `parts.text` fields will be
	// counted.
	Content *Content `protobuf:"bytes,2,opt,name=content,proto3" json:"content,omitempty"`
	// Optional. Optional task type for which the embeddings will be used. Not
	// supported on earlier models (`models/embedding-001`).
	TaskType *TaskType `protobuf:"varint,3,opt,name=task_type,json=taskType,proto3,enum=google.ai.generativelanguage.v1beta.TaskType,oneof" json:"task_type,omitempty"`
	// Optional. An optional title for the text. Only applicable when TaskType is
	// `RETRIEVAL_DOCUMENT`.
	//
	// Note: Specifying a `title` for `RETRIEVAL_DOCUMENT` provides better quality
	// embeddings for retrieval.
	Title *string `protobuf:"bytes,4,opt,name=title,proto3,oneof" json:"title,omitempty"`
	// Optional. Optional reduced dimension for the output embedding. If set,
	// excessive values in the output embedding are truncated from the end.
	// Supported by newer models since 2024 only. You cannot set this value if
	// using the earlier model (`models/embedding-001`).
	OutputDimensionality *int32 `protobuf:"varint,5,opt,name=output_dimensionality,json=outputDimensionality,proto3,oneof" json:"output_dimensionality,omitempty"`
}

func (x *EmbedContentRequest) Reset() {
	*x = EmbedContentRequest{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EmbedContentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EmbedContentRequest) ProtoMessage() {}

func (x *EmbedContentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EmbedContentRequest.ProtoReflect.Descriptor instead.
func (*EmbedContentRequest) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{20}
}

func (x *EmbedContentRequest) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *EmbedContentRequest) GetContent() *Content {
	if x != nil {
		return x.Content
	}
	return nil
}

func (x *EmbedContentRequest) GetTaskType() TaskType {
	if x != nil && x.TaskType != nil {
		return *x.TaskType
	}
	return TaskType_TASK_TYPE_UNSPECIFIED
}

func (x *EmbedContentRequest) GetTitle() string {
	if x != nil && x.Title != nil {
		return *x.Title
	}
	return ""
}

func (x *EmbedContentRequest) GetOutputDimensionality() int32 {
	if x != nil && x.OutputDimensionality != nil {
		return *x.OutputDimensionality
	}
	return 0
}

// A list of floats representing an embedding.
type ContentEmbedding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The embedding values.
	Values []float32 `protobuf:"fixed32,1,rep,packed,name=values,proto3" json:"values,omitempty"`
}

func (x *ContentEmbedding) Reset() {
	*x = ContentEmbedding{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContentEmbedding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContentEmbedding) ProtoMessage() {}

func (x *ContentEmbedding) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContentEmbedding.ProtoReflect.Descriptor instead.
func (*ContentEmbedding) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{21}
}

func (x *ContentEmbedding) GetValues() []float32 {
	if x != nil {
		return x.Values
	}
	return nil
}

// The response to an `EmbedContentRequest`.
type EmbedContentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The embedding generated from the input content.
	Embedding *ContentEmbedding `protobuf:"bytes,1,opt,name=embedding,proto3" json:"embedding,omitempty"`
}

func (x *EmbedContentResponse) Reset() {
	*x = EmbedContentResponse{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EmbedContentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EmbedContentResponse) ProtoMessage() {}

func (x *EmbedContentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EmbedContentResponse.ProtoReflect.Descriptor instead.
func (*EmbedContentResponse) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{22}
}

func (x *EmbedContentResponse) GetEmbedding() *ContentEmbedding {
	if x != nil {
		return x.Embedding
	}
	return nil
}

// Batch request to get embeddings from the model for a list of prompts.
type BatchEmbedContentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The model's resource name. This serves as an ID for the Model to
	// use.
	//
	// This name should match a model name returned by the `ListModels` method.
	//
	// Format: `models/{model}`
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Required. Embed requests for the batch. The model in each of these requests
	// must match the model specified `BatchEmbedContentsRequest.model`.
	Requests []*EmbedContentRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchEmbedContentsRequest) Reset() {
	*x = BatchEmbedContentsRequest{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchEmbedContentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchEmbedContentsRequest) ProtoMessage() {}

func (x *BatchEmbedContentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchEmbedContentsRequest.ProtoReflect.Descriptor instead.
func (*BatchEmbedContentsRequest) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{23}
}

func (x *BatchEmbedContentsRequest) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *BatchEmbedContentsRequest) GetRequests() []*EmbedContentRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// The response to a `BatchEmbedContentsRequest`.
type BatchEmbedContentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The embeddings for each request, in the same order as provided
	// in the batch request.
	Embeddings []*ContentEmbedding `protobuf:"bytes,1,rep,name=embeddings,proto3" json:"embeddings,omitempty"`
}

func (x *BatchEmbedContentsResponse) Reset() {
	*x = BatchEmbedContentsResponse{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchEmbedContentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchEmbedContentsResponse) ProtoMessage() {}

func (x *BatchEmbedContentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchEmbedContentsResponse.ProtoReflect.Descriptor instead.
func (*BatchEmbedContentsResponse) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{24}
}

func (x *BatchEmbedContentsResponse) GetEmbeddings() []*ContentEmbedding {
	if x != nil {
		return x.Embeddings
	}
	return nil
}

// Counts the number of tokens in the `prompt` sent to a model.
//
// Models may tokenize text differently, so each model may return a different
// `token_count`.
type CountTokensRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The model's resource name. This serves as an ID for the Model to
	// use.
	//
	// This name should match a model name returned by the `ListModels` method.
	//
	// Format: `models/{model}`
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Optional. The input given to the model as a prompt. This field is ignored
	// when `generate_content_request` is set.
	Contents []*Content `protobuf:"bytes,2,rep,name=contents,proto3" json:"contents,omitempty"`
	// Optional. The overall input given to the `Model`. This includes the prompt
	// as well as other model steering information like [system
	// instructions](https://ai.google.dev/gemini-api/docs/system-instructions),
	// and/or function declarations for [function
	// calling](https://ai.google.dev/gemini-api/docs/function-calling).
	// `Model`s/`Content`s and `generate_content_request`s are mutually
	// exclusive. You can either send `Model` + `Content`s or a
	// `generate_content_request`, but never both.
	GenerateContentRequest *GenerateContentRequest `protobuf:"bytes,3,opt,name=generate_content_request,json=generateContentRequest,proto3" json:"generate_content_request,omitempty"`
}

func (x *CountTokensRequest) Reset() {
	*x = CountTokensRequest{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CountTokensRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CountTokensRequest) ProtoMessage() {}

func (x *CountTokensRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CountTokensRequest.ProtoReflect.Descriptor instead.
func (*CountTokensRequest) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{25}
}

func (x *CountTokensRequest) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *CountTokensRequest) GetContents() []*Content {
	if x != nil {
		return x.Contents
	}
	return nil
}

func (x *CountTokensRequest) GetGenerateContentRequest() *GenerateContentRequest {
	if x != nil {
		return x.GenerateContentRequest
	}
	return nil
}

// A response from `CountTokens`.
//
// It returns the model's `token_count` for the `prompt`.
type CountTokensResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of tokens that the `Model` tokenizes the `prompt` into. Always
	// non-negative.
	TotalTokens int32 `protobuf:"varint,1,opt,name=total_tokens,json=totalTokens,proto3" json:"total_tokens,omitempty"`
	// Number of tokens in the cached part of the prompt (the cached content).
	CachedContentTokenCount int32 `protobuf:"varint,5,opt,name=cached_content_token_count,json=cachedContentTokenCount,proto3" json:"cached_content_token_count,omitempty"`
	// Output only. List of modalities that were processed in the request input.
	PromptTokensDetails []*ModalityTokenCount `protobuf:"bytes,6,rep,name=prompt_tokens_details,json=promptTokensDetails,proto3" json:"prompt_tokens_details,omitempty"`
	// Output only. List of modalities that were processed in the cached content.
	CacheTokensDetails []*ModalityTokenCount `protobuf:"bytes,7,rep,name=cache_tokens_details,json=cacheTokensDetails,proto3" json:"cache_tokens_details,omitempty"`
}

func (x *CountTokensResponse) Reset() {
	*x = CountTokensResponse{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CountTokensResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CountTokensResponse) ProtoMessage() {}

func (x *CountTokensResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CountTokensResponse.ProtoReflect.Descriptor instead.
func (*CountTokensResponse) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{26}
}

func (x *CountTokensResponse) GetTotalTokens() int32 {
	if x != nil {
		return x.TotalTokens
	}
	return 0
}

func (x *CountTokensResponse) GetCachedContentTokenCount() int32 {
	if x != nil {
		return x.CachedContentTokenCount
	}
	return 0
}

func (x *CountTokensResponse) GetPromptTokensDetails() []*ModalityTokenCount {
	if x != nil {
		return x.PromptTokensDetails
	}
	return nil
}

func (x *CountTokensResponse) GetCacheTokensDetails() []*ModalityTokenCount {
	if x != nil {
		return x.CacheTokensDetails
	}
	return nil
}

// Configures the realtime input behavior in `BidiGenerateContent`.
type RealtimeInputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. If not set, automatic activity detection is enabled by default.
	// If automatic voice detection is disabled, the client must send activity
	// signals.
	AutomaticActivityDetection *RealtimeInputConfig_AutomaticActivityDetection `protobuf:"bytes,1,opt,name=automatic_activity_detection,json=automaticActivityDetection,proto3" json:"automatic_activity_detection,omitempty"`
	// Optional. Defines what effect activity has.
	ActivityHandling *RealtimeInputConfig_ActivityHandling `protobuf:"varint,3,opt,name=activity_handling,json=activityHandling,proto3,enum=google.ai.generativelanguage.v1beta.RealtimeInputConfig_ActivityHandling,oneof" json:"activity_handling,omitempty"`
	// Optional. Defines which input is included in the user's turn.
	TurnCoverage *RealtimeInputConfig_TurnCoverage `protobuf:"varint,4,opt,name=turn_coverage,json=turnCoverage,proto3,enum=google.ai.generativelanguage.v1beta.RealtimeInputConfig_TurnCoverage,oneof" json:"turn_coverage,omitempty"`
}

func (x *RealtimeInputConfig) Reset() {
	*x = RealtimeInputConfig{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RealtimeInputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RealtimeInputConfig) ProtoMessage() {}

func (x *RealtimeInputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RealtimeInputConfig.ProtoReflect.Descriptor instead.
func (*RealtimeInputConfig) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{27}
}

func (x *RealtimeInputConfig) GetAutomaticActivityDetection() *RealtimeInputConfig_AutomaticActivityDetection {
	if x != nil {
		return x.AutomaticActivityDetection
	}
	return nil
}

func (x *RealtimeInputConfig) GetActivityHandling() RealtimeInputConfig_ActivityHandling {
	if x != nil && x.ActivityHandling != nil {
		return *x.ActivityHandling
	}
	return RealtimeInputConfig_ACTIVITY_HANDLING_UNSPECIFIED
}

func (x *RealtimeInputConfig) GetTurnCoverage() RealtimeInputConfig_TurnCoverage {
	if x != nil && x.TurnCoverage != nil {
		return *x.TurnCoverage
	}
	return RealtimeInputConfig_TURN_COVERAGE_UNSPECIFIED
}

// Session resumption configuration.
//
// This message is included in the session configuration as
// `BidiGenerateContentSetup.session_resumption`. If configured, the server
// will send `SessionResumptionUpdate` messages.
type SessionResumptionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The handle of a previous session. If not present then a new session is
	// created.
	//
	// Session handles come from `SessionResumptionUpdate.token` values in
	// previous connections.
	Handle *string `protobuf:"bytes,1,opt,name=handle,proto3,oneof" json:"handle,omitempty"`
}

func (x *SessionResumptionConfig) Reset() {
	*x = SessionResumptionConfig{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SessionResumptionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SessionResumptionConfig) ProtoMessage() {}

func (x *SessionResumptionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SessionResumptionConfig.ProtoReflect.Descriptor instead.
func (*SessionResumptionConfig) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{28}
}

func (x *SessionResumptionConfig) GetHandle() string {
	if x != nil && x.Handle != nil {
		return *x.Handle
	}
	return ""
}

// Enables context window compression — a mechanism for managing the model's
// context window so that it does not exceed a given length.
type ContextWindowCompressionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The context window compression mechanism used.
	//
	// Types that are assignable to CompressionMechanism:
	//
	//	*ContextWindowCompressionConfig_SlidingWindow_
	CompressionMechanism isContextWindowCompressionConfig_CompressionMechanism `protobuf_oneof:"compression_mechanism"`
	// The number of tokens (before running a turn) required to trigger a context
	// window compression.
	//
	// This can be used to balance quality against latency as shorter context
	// windows may result in faster model responses. However, any compression
	// operation will cause a temporary latency increase, so they should not be
	// triggered frequently.
	//
	// If not set, the default is 80% of the model's context window limit. This
	// leaves 20% for the next user request/model response.
	TriggerTokens *int64 `protobuf:"varint,1,opt,name=trigger_tokens,json=triggerTokens,proto3,oneof" json:"trigger_tokens,omitempty"`
}

func (x *ContextWindowCompressionConfig) Reset() {
	*x = ContextWindowCompressionConfig{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContextWindowCompressionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContextWindowCompressionConfig) ProtoMessage() {}

func (x *ContextWindowCompressionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContextWindowCompressionConfig.ProtoReflect.Descriptor instead.
func (*ContextWindowCompressionConfig) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{29}
}

func (m *ContextWindowCompressionConfig) GetCompressionMechanism() isContextWindowCompressionConfig_CompressionMechanism {
	if m != nil {
		return m.CompressionMechanism
	}
	return nil
}

func (x *ContextWindowCompressionConfig) GetSlidingWindow() *ContextWindowCompressionConfig_SlidingWindow {
	if x, ok := x.GetCompressionMechanism().(*ContextWindowCompressionConfig_SlidingWindow_); ok {
		return x.SlidingWindow
	}
	return nil
}

func (x *ContextWindowCompressionConfig) GetTriggerTokens() int64 {
	if x != nil && x.TriggerTokens != nil {
		return *x.TriggerTokens
	}
	return 0
}

type isContextWindowCompressionConfig_CompressionMechanism interface {
	isContextWindowCompressionConfig_CompressionMechanism()
}

type ContextWindowCompressionConfig_SlidingWindow_ struct {
	// A sliding-window mechanism.
	SlidingWindow *ContextWindowCompressionConfig_SlidingWindow `protobuf:"bytes,2,opt,name=sliding_window,json=slidingWindow,proto3,oneof"`
}

func (*ContextWindowCompressionConfig_SlidingWindow_) isContextWindowCompressionConfig_CompressionMechanism() {
}

// The audio transcription configuration.
type AudioTranscriptionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AudioTranscriptionConfig) Reset() {
	*x = AudioTranscriptionConfig{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AudioTranscriptionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudioTranscriptionConfig) ProtoMessage() {}

func (x *AudioTranscriptionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudioTranscriptionConfig.ProtoReflect.Descriptor instead.
func (*AudioTranscriptionConfig) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{30}
}

// Message to be sent in the first (and only in the first)
// `BidiGenerateContentClientMessage`. Contains configuration that will apply
// for the duration of the streaming RPC.
//
// Clients should wait for a `BidiGenerateContentSetupComplete` message before
// sending any additional messages.
type BidiGenerateContentSetup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The model's resource name. This serves as an ID for the Model to
	// use.
	//
	// Format: `models/{model}`
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Optional. Generation config.
	//
	// The following fields are not supported:
	//
	//   - `response_logprobs`
	//   - `response_mime_type`
	//   - `logprobs`
	//   - `response_schema`
	//   - `stop_sequence`
	//   - `routing_config`
	//   - `audio_timestamp`
	GenerationConfig *GenerationConfig `protobuf:"bytes,2,opt,name=generation_config,json=generationConfig,proto3" json:"generation_config,omitempty"`
	// Optional. The user provided system instructions for the model.
	//
	// Note: Only text should be used in parts and content in each part will be
	// in a separate paragraph.
	SystemInstruction *Content `protobuf:"bytes,3,opt,name=system_instruction,json=systemInstruction,proto3" json:"system_instruction,omitempty"`
	// Optional. A list of `Tools` the model may use to generate the next
	// response.
	//
	// A `Tool` is a piece of code that enables the system to interact with
	// external systems to perform an action, or set of actions, outside of
	// knowledge and scope of the model.
	Tools []*Tool `protobuf:"bytes,4,rep,name=tools,proto3" json:"tools,omitempty"`
	// Optional. Configures the handling of realtime input.
	RealtimeInputConfig *RealtimeInputConfig `protobuf:"bytes,6,opt,name=realtime_input_config,json=realtimeInputConfig,proto3" json:"realtime_input_config,omitempty"`
	// Optional. Configures session resumption mechanism.
	//
	// If included, the server will send `SessionResumptionUpdate` messages.
	SessionResumption *SessionResumptionConfig `protobuf:"bytes,7,opt,name=session_resumption,json=sessionResumption,proto3" json:"session_resumption,omitempty"`
	// Optional. Configures a context window compression mechanism.
	//
	// If included, the server will automatically reduce the size of the context
	// when it exceeds the configured length.
	ContextWindowCompression *ContextWindowCompressionConfig `protobuf:"bytes,8,opt,name=context_window_compression,json=contextWindowCompression,proto3" json:"context_window_compression,omitempty"`
	// Optional. If set, enables transcription of the model's audio output. The
	// transcription aligns with the language code specified for the output
	// audio, if configured.
	OutputAudioTranscription *AudioTranscriptionConfig `protobuf:"bytes,11,opt,name=output_audio_transcription,json=outputAudioTranscription,proto3" json:"output_audio_transcription,omitempty"`
}

func (x *BidiGenerateContentSetup) Reset() {
	*x = BidiGenerateContentSetup{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BidiGenerateContentSetup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BidiGenerateContentSetup) ProtoMessage() {}

func (x *BidiGenerateContentSetup) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BidiGenerateContentSetup.ProtoReflect.Descriptor instead.
func (*BidiGenerateContentSetup) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{31}
}

func (x *BidiGenerateContentSetup) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *BidiGenerateContentSetup) GetGenerationConfig() *GenerationConfig {
	if x != nil {
		return x.GenerationConfig
	}
	return nil
}

func (x *BidiGenerateContentSetup) GetSystemInstruction() *Content {
	if x != nil {
		return x.SystemInstruction
	}
	return nil
}

func (x *BidiGenerateContentSetup) GetTools() []*Tool {
	if x != nil {
		return x.Tools
	}
	return nil
}

func (x *BidiGenerateContentSetup) GetRealtimeInputConfig() *RealtimeInputConfig {
	if x != nil {
		return x.RealtimeInputConfig
	}
	return nil
}

func (x *BidiGenerateContentSetup) GetSessionResumption() *SessionResumptionConfig {
	if x != nil {
		return x.SessionResumption
	}
	return nil
}

func (x *BidiGenerateContentSetup) GetContextWindowCompression() *ContextWindowCompressionConfig {
	if x != nil {
		return x.ContextWindowCompression
	}
	return nil
}

func (x *BidiGenerateContentSetup) GetOutputAudioTranscription() *AudioTranscriptionConfig {
	if x != nil {
		return x.OutputAudioTranscription
	}
	return nil
}

// Incremental update of the current conversation delivered from the client.
// All of the content here is unconditionally appended to the conversation
// history and used as part of the prompt to the model to generate content.
//
// A message here will interrupt any current model generation.
type BidiGenerateContentClientContent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The content appended to the current conversation with the model.
	//
	// For single-turn queries, this is a single instance. For multi-turn
	// queries, this is a repeated field that contains conversation history and
	// the latest request.
	Turns []*Content `protobuf:"bytes,1,rep,name=turns,proto3" json:"turns,omitempty"`
	// Optional. If true, indicates that the server content generation should
	// start with the currently accumulated prompt. Otherwise, the server awaits
	// additional messages before starting generation.
	TurnComplete bool `protobuf:"varint,2,opt,name=turn_complete,json=turnComplete,proto3" json:"turn_complete,omitempty"`
}

func (x *BidiGenerateContentClientContent) Reset() {
	*x = BidiGenerateContentClientContent{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BidiGenerateContentClientContent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BidiGenerateContentClientContent) ProtoMessage() {}

func (x *BidiGenerateContentClientContent) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BidiGenerateContentClientContent.ProtoReflect.Descriptor instead.
func (*BidiGenerateContentClientContent) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{32}
}

func (x *BidiGenerateContentClientContent) GetTurns() []*Content {
	if x != nil {
		return x.Turns
	}
	return nil
}

func (x *BidiGenerateContentClientContent) GetTurnComplete() bool {
	if x != nil {
		return x.TurnComplete
	}
	return false
}

// User input that is sent in real time.
//
// The different modalities (audio, video and text) are handled as concurrent
// streams. The ordering across these streams is not guaranteed.
//
// This is different from
// [BidiGenerateContentClientContent][google.ai.generativelanguage.v1beta.BidiGenerateContentClientContent]
// in a few ways:
//
//   - Can be sent continuously without interruption to model generation.
//   - If there is a need to mix data interleaved across the
//     [BidiGenerateContentClientContent][google.ai.generativelanguage.v1beta.BidiGenerateContentClientContent]
//     and the
//     [BidiGenerateContentRealtimeInput][google.ai.generativelanguage.v1beta.BidiGenerateContentRealtimeInput],
//     the server attempts to optimize for best response, but there are no
//     guarantees.
//   - End of turn is not explicitly specified, but is rather derived from user
//     activity (for example, end of speech).
//   - Even before the end of turn, the data is processed incrementally
//     to optimize for a fast start of the response from the model.
type BidiGenerateContentRealtimeInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Inlined bytes data for media input. Multiple `media_chunks` are
	// not supported, all but the first will be ignored.
	//
	// DEPRECATED: Use one of `audio`, `video`, or `text` instead.
	MediaChunks []*Blob `protobuf:"bytes,1,rep,name=media_chunks,json=mediaChunks,proto3" json:"media_chunks,omitempty"`
	// Optional. These form the realtime audio input stream.
	Audio *Blob `protobuf:"bytes,2,opt,name=audio,proto3" json:"audio,omitempty"`
	// Optional. Indicates that the audio stream has ended, e.g. because the
	// microphone was turned off.
	//
	// This should only be sent when automatic activity detection is enabled
	// (which is the default).
	//
	// The client can reopen the stream by sending an audio message.
	AudioStreamEnd *bool `protobuf:"varint,3,opt,name=audio_stream_end,json=audioStreamEnd,proto3,oneof" json:"audio_stream_end,omitempty"`
	// Optional. These form the realtime video input stream.
	Video *Blob `protobuf:"bytes,4,opt,name=video,proto3" json:"video,omitempty"`
	// Optional. These form the realtime text input stream.
	Text *string `protobuf:"bytes,5,opt,name=text,proto3,oneof" json:"text,omitempty"`
	// Optional. Marks the start of user activity. This can only be sent if
	// automatic (i.e. server-side) activity detection is disabled.
	ActivityStart *BidiGenerateContentRealtimeInput_ActivityStart `protobuf:"bytes,6,opt,name=activity_start,json=activityStart,proto3" json:"activity_start,omitempty"`
	// Optional. Marks the end of user activity. This can only be sent if
	// automatic (i.e. server-side) activity detection is disabled.
	ActivityEnd *BidiGenerateContentRealtimeInput_ActivityEnd `protobuf:"bytes,7,opt,name=activity_end,json=activityEnd,proto3" json:"activity_end,omitempty"`
}

func (x *BidiGenerateContentRealtimeInput) Reset() {
	*x = BidiGenerateContentRealtimeInput{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BidiGenerateContentRealtimeInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BidiGenerateContentRealtimeInput) ProtoMessage() {}

func (x *BidiGenerateContentRealtimeInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BidiGenerateContentRealtimeInput.ProtoReflect.Descriptor instead.
func (*BidiGenerateContentRealtimeInput) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{33}
}

func (x *BidiGenerateContentRealtimeInput) GetMediaChunks() []*Blob {
	if x != nil {
		return x.MediaChunks
	}
	return nil
}

func (x *BidiGenerateContentRealtimeInput) GetAudio() *Blob {
	if x != nil {
		return x.Audio
	}
	return nil
}

func (x *BidiGenerateContentRealtimeInput) GetAudioStreamEnd() bool {
	if x != nil && x.AudioStreamEnd != nil {
		return *x.AudioStreamEnd
	}
	return false
}

func (x *BidiGenerateContentRealtimeInput) GetVideo() *Blob {
	if x != nil {
		return x.Video
	}
	return nil
}

func (x *BidiGenerateContentRealtimeInput) GetText() string {
	if x != nil && x.Text != nil {
		return *x.Text
	}
	return ""
}

func (x *BidiGenerateContentRealtimeInput) GetActivityStart() *BidiGenerateContentRealtimeInput_ActivityStart {
	if x != nil {
		return x.ActivityStart
	}
	return nil
}

func (x *BidiGenerateContentRealtimeInput) GetActivityEnd() *BidiGenerateContentRealtimeInput_ActivityEnd {
	if x != nil {
		return x.ActivityEnd
	}
	return nil
}

// Client generated response to a `ToolCall` received from the server.
// Individual `FunctionResponse` objects are matched to the respective
// `FunctionCall` objects by the `id` field.
//
// Note that in the unary and server-streaming GenerateContent APIs function
// calling happens by exchanging the `Content` parts, while in the bidi
// GenerateContent APIs function calling happens over these dedicated set of
// messages.
type BidiGenerateContentToolResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The response to the function calls.
	FunctionResponses []*FunctionResponse `protobuf:"bytes,1,rep,name=function_responses,json=functionResponses,proto3" json:"function_responses,omitempty"`
}

func (x *BidiGenerateContentToolResponse) Reset() {
	*x = BidiGenerateContentToolResponse{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BidiGenerateContentToolResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BidiGenerateContentToolResponse) ProtoMessage() {}

func (x *BidiGenerateContentToolResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BidiGenerateContentToolResponse.ProtoReflect.Descriptor instead.
func (*BidiGenerateContentToolResponse) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{34}
}

func (x *BidiGenerateContentToolResponse) GetFunctionResponses() []*FunctionResponse {
	if x != nil {
		return x.FunctionResponses
	}
	return nil
}

// Messages sent by the client in the BidiGenerateContent call.
type BidiGenerateContentClientMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of the message.
	//
	// Types that are assignable to MessageType:
	//
	//	*BidiGenerateContentClientMessage_Setup
	//	*BidiGenerateContentClientMessage_ClientContent
	//	*BidiGenerateContentClientMessage_RealtimeInput
	//	*BidiGenerateContentClientMessage_ToolResponse
	MessageType isBidiGenerateContentClientMessage_MessageType `protobuf_oneof:"message_type"`
}

func (x *BidiGenerateContentClientMessage) Reset() {
	*x = BidiGenerateContentClientMessage{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BidiGenerateContentClientMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BidiGenerateContentClientMessage) ProtoMessage() {}

func (x *BidiGenerateContentClientMessage) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BidiGenerateContentClientMessage.ProtoReflect.Descriptor instead.
func (*BidiGenerateContentClientMessage) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{35}
}

func (m *BidiGenerateContentClientMessage) GetMessageType() isBidiGenerateContentClientMessage_MessageType {
	if m != nil {
		return m.MessageType
	}
	return nil
}

func (x *BidiGenerateContentClientMessage) GetSetup() *BidiGenerateContentSetup {
	if x, ok := x.GetMessageType().(*BidiGenerateContentClientMessage_Setup); ok {
		return x.Setup
	}
	return nil
}

func (x *BidiGenerateContentClientMessage) GetClientContent() *BidiGenerateContentClientContent {
	if x, ok := x.GetMessageType().(*BidiGenerateContentClientMessage_ClientContent); ok {
		return x.ClientContent
	}
	return nil
}

func (x *BidiGenerateContentClientMessage) GetRealtimeInput() *BidiGenerateContentRealtimeInput {
	if x, ok := x.GetMessageType().(*BidiGenerateContentClientMessage_RealtimeInput); ok {
		return x.RealtimeInput
	}
	return nil
}

func (x *BidiGenerateContentClientMessage) GetToolResponse() *BidiGenerateContentToolResponse {
	if x, ok := x.GetMessageType().(*BidiGenerateContentClientMessage_ToolResponse); ok {
		return x.ToolResponse
	}
	return nil
}

type isBidiGenerateContentClientMessage_MessageType interface {
	isBidiGenerateContentClientMessage_MessageType()
}

type BidiGenerateContentClientMessage_Setup struct {
	// Optional. Session configuration sent in the first and only first client
	// message.
	Setup *BidiGenerateContentSetup `protobuf:"bytes,1,opt,name=setup,proto3,oneof"`
}

type BidiGenerateContentClientMessage_ClientContent struct {
	// Optional. Incremental update of the current conversation delivered from
	// the client.
	ClientContent *BidiGenerateContentClientContent `protobuf:"bytes,2,opt,name=client_content,json=clientContent,proto3,oneof"`
}

type BidiGenerateContentClientMessage_RealtimeInput struct {
	// Optional. User input that is sent in real time.
	RealtimeInput *BidiGenerateContentRealtimeInput `protobuf:"bytes,3,opt,name=realtime_input,json=realtimeInput,proto3,oneof"`
}

type BidiGenerateContentClientMessage_ToolResponse struct {
	// Optional. Response to a `ToolCallMessage` received from the server.
	ToolResponse *BidiGenerateContentToolResponse `protobuf:"bytes,4,opt,name=tool_response,json=toolResponse,proto3,oneof"`
}

func (*BidiGenerateContentClientMessage_Setup) isBidiGenerateContentClientMessage_MessageType() {}

func (*BidiGenerateContentClientMessage_ClientContent) isBidiGenerateContentClientMessage_MessageType() {
}

func (*BidiGenerateContentClientMessage_RealtimeInput) isBidiGenerateContentClientMessage_MessageType() {
}

func (*BidiGenerateContentClientMessage_ToolResponse) isBidiGenerateContentClientMessage_MessageType() {
}

// Sent in response to a `BidiGenerateContentSetup` message from the client.
type BidiGenerateContentSetupComplete struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *BidiGenerateContentSetupComplete) Reset() {
	*x = BidiGenerateContentSetupComplete{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BidiGenerateContentSetupComplete) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BidiGenerateContentSetupComplete) ProtoMessage() {}

func (x *BidiGenerateContentSetupComplete) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BidiGenerateContentSetupComplete.ProtoReflect.Descriptor instead.
func (*BidiGenerateContentSetupComplete) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{36}
}

// Incremental server update generated by the model in response to client
// messages.
//
// Content is generated as quickly as possible, and not in real time. Clients
// may choose to buffer and play it out in real time.
type BidiGenerateContentServerContent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The content that the model has generated as part of the
	// current conversation with the user.
	ModelTurn *Content `protobuf:"bytes,1,opt,name=model_turn,json=modelTurn,proto3,oneof" json:"model_turn,omitempty"`
	// Output only. If true, indicates that the model is done generating.
	//
	// When model is interrupted while generating there will be no
	// 'generation_complete' message in interrupted turn, it will go through
	// 'interrupted > turn_complete'.
	//
	// When model assumes realtime playback there will be delay between
	// generation_complete and turn_complete that is caused by model waiting for
	// playback to finish.
	GenerationComplete bool `protobuf:"varint,5,opt,name=generation_complete,json=generationComplete,proto3" json:"generation_complete,omitempty"`
	// Output only. If true, indicates that the model has completed its turn.
	// Generation will only start in response to additional client messages.
	TurnComplete bool `protobuf:"varint,2,opt,name=turn_complete,json=turnComplete,proto3" json:"turn_complete,omitempty"`
	// Output only. If true, indicates that a client message has interrupted
	// current model generation. If the client is playing out the content in real
	// time, this is a good signal to stop and empty the current playback queue.
	Interrupted bool `protobuf:"varint,3,opt,name=interrupted,proto3" json:"interrupted,omitempty"`
	// Output only. Grounding metadata for the generated content.
	GroundingMetadata *GroundingMetadata `protobuf:"bytes,4,opt,name=grounding_metadata,json=groundingMetadata,proto3" json:"grounding_metadata,omitempty"`
	// Output only. Output audio transcription. The transcription is sent
	// independently of the other server messages and there is no guaranteed
	// ordering, in particular not between `server_content` and this
	// `output_transcription`.
	OutputTranscription *BidiGenerateContentTranscription `protobuf:"bytes,7,opt,name=output_transcription,json=outputTranscription,proto3" json:"output_transcription,omitempty"`
}

func (x *BidiGenerateContentServerContent) Reset() {
	*x = BidiGenerateContentServerContent{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BidiGenerateContentServerContent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BidiGenerateContentServerContent) ProtoMessage() {}

func (x *BidiGenerateContentServerContent) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BidiGenerateContentServerContent.ProtoReflect.Descriptor instead.
func (*BidiGenerateContentServerContent) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{37}
}

func (x *BidiGenerateContentServerContent) GetModelTurn() *Content {
	if x != nil {
		return x.ModelTurn
	}
	return nil
}

func (x *BidiGenerateContentServerContent) GetGenerationComplete() bool {
	if x != nil {
		return x.GenerationComplete
	}
	return false
}

func (x *BidiGenerateContentServerContent) GetTurnComplete() bool {
	if x != nil {
		return x.TurnComplete
	}
	return false
}

func (x *BidiGenerateContentServerContent) GetInterrupted() bool {
	if x != nil {
		return x.Interrupted
	}
	return false
}

func (x *BidiGenerateContentServerContent) GetGroundingMetadata() *GroundingMetadata {
	if x != nil {
		return x.GroundingMetadata
	}
	return nil
}

func (x *BidiGenerateContentServerContent) GetOutputTranscription() *BidiGenerateContentTranscription {
	if x != nil {
		return x.OutputTranscription
	}
	return nil
}

// Request for the client to execute the `function_calls` and return the
// responses with the matching `id`s.
type BidiGenerateContentToolCall struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The function call to be executed.
	FunctionCalls []*FunctionCall `protobuf:"bytes,2,rep,name=function_calls,json=functionCalls,proto3" json:"function_calls,omitempty"`
}

func (x *BidiGenerateContentToolCall) Reset() {
	*x = BidiGenerateContentToolCall{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BidiGenerateContentToolCall) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BidiGenerateContentToolCall) ProtoMessage() {}

func (x *BidiGenerateContentToolCall) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BidiGenerateContentToolCall.ProtoReflect.Descriptor instead.
func (*BidiGenerateContentToolCall) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{38}
}

func (x *BidiGenerateContentToolCall) GetFunctionCalls() []*FunctionCall {
	if x != nil {
		return x.FunctionCalls
	}
	return nil
}

// Notification for the client that a previously issued `ToolCallMessage`
// with the specified `id`s should not have been executed and should be
// cancelled. If there were side-effects to those tool calls, clients may
// attempt to undo the tool calls. This message occurs only in cases where the
// clients interrupt server turns.
type BidiGenerateContentToolCallCancellation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The ids of the tool calls to be cancelled.
	Ids []string `protobuf:"bytes,1,rep,name=ids,proto3" json:"ids,omitempty"`
}

func (x *BidiGenerateContentToolCallCancellation) Reset() {
	*x = BidiGenerateContentToolCallCancellation{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BidiGenerateContentToolCallCancellation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BidiGenerateContentToolCallCancellation) ProtoMessage() {}

func (x *BidiGenerateContentToolCallCancellation) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BidiGenerateContentToolCallCancellation.ProtoReflect.Descriptor instead.
func (*BidiGenerateContentToolCallCancellation) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{39}
}

func (x *BidiGenerateContentToolCallCancellation) GetIds() []string {
	if x != nil {
		return x.Ids
	}
	return nil
}

// A notice that the server will soon disconnect.
type GoAway struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The remaining time before the connection will be terminated as ABORTED.
	//
	// This duration will never be less than a model-specific minimum, which will
	// be specified together with the rate limits for the model.
	TimeLeft *durationpb.Duration `protobuf:"bytes,1,opt,name=time_left,json=timeLeft,proto3" json:"time_left,omitempty"`
}

func (x *GoAway) Reset() {
	*x = GoAway{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GoAway) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GoAway) ProtoMessage() {}

func (x *GoAway) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GoAway.ProtoReflect.Descriptor instead.
func (*GoAway) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{40}
}

func (x *GoAway) GetTimeLeft() *durationpb.Duration {
	if x != nil {
		return x.TimeLeft
	}
	return nil
}

// Update of the session resumption state.
//
// Only sent if `BidiGenerateContentSetup.session_resumption` was set.
type SessionResumptionUpdate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// New handle that represents a state that can be resumed. Empty if
	// `resumable`=false.
	NewHandle string `protobuf:"bytes,1,opt,name=new_handle,json=newHandle,proto3" json:"new_handle,omitempty"`
	// True if the current session can be resumed at this point.
	//
	// Resumption is not possible at some points in the session. For example, when
	// the model is executing function calls or generating. Resuming the session
	// (using a previous session token) in such a state will result in some data
	// loss. In these cases, `new_handle` will be empty and `resumable` will be
	// false.
	Resumable bool `protobuf:"varint,2,opt,name=resumable,proto3" json:"resumable,omitempty"`
}

func (x *SessionResumptionUpdate) Reset() {
	*x = SessionResumptionUpdate{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SessionResumptionUpdate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SessionResumptionUpdate) ProtoMessage() {}

func (x *SessionResumptionUpdate) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SessionResumptionUpdate.ProtoReflect.Descriptor instead.
func (*SessionResumptionUpdate) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{41}
}

func (x *SessionResumptionUpdate) GetNewHandle() string {
	if x != nil {
		return x.NewHandle
	}
	return ""
}

func (x *SessionResumptionUpdate) GetResumable() bool {
	if x != nil {
		return x.Resumable
	}
	return false
}

// Transcription of audio (input or output).
type BidiGenerateContentTranscription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Transcription text.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
}

func (x *BidiGenerateContentTranscription) Reset() {
	*x = BidiGenerateContentTranscription{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BidiGenerateContentTranscription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BidiGenerateContentTranscription) ProtoMessage() {}

func (x *BidiGenerateContentTranscription) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BidiGenerateContentTranscription.ProtoReflect.Descriptor instead.
func (*BidiGenerateContentTranscription) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{42}
}

func (x *BidiGenerateContentTranscription) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

// Response message for the BidiGenerateContent call.
type BidiGenerateContentServerMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of the message.
	//
	// Types that are assignable to MessageType:
	//
	//	*BidiGenerateContentServerMessage_SetupComplete
	//	*BidiGenerateContentServerMessage_ServerContent
	//	*BidiGenerateContentServerMessage_ToolCall
	//	*BidiGenerateContentServerMessage_ToolCallCancellation
	//	*BidiGenerateContentServerMessage_GoAway
	//	*BidiGenerateContentServerMessage_SessionResumptionUpdate
	MessageType isBidiGenerateContentServerMessage_MessageType `protobuf_oneof:"message_type"`
	// Output only. Usage metadata about the response(s).
	UsageMetadata *UsageMetadata `protobuf:"bytes,10,opt,name=usage_metadata,json=usageMetadata,proto3" json:"usage_metadata,omitempty"`
}

func (x *BidiGenerateContentServerMessage) Reset() {
	*x = BidiGenerateContentServerMessage{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BidiGenerateContentServerMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BidiGenerateContentServerMessage) ProtoMessage() {}

func (x *BidiGenerateContentServerMessage) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BidiGenerateContentServerMessage.ProtoReflect.Descriptor instead.
func (*BidiGenerateContentServerMessage) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{43}
}

func (m *BidiGenerateContentServerMessage) GetMessageType() isBidiGenerateContentServerMessage_MessageType {
	if m != nil {
		return m.MessageType
	}
	return nil
}

func (x *BidiGenerateContentServerMessage) GetSetupComplete() *BidiGenerateContentSetupComplete {
	if x, ok := x.GetMessageType().(*BidiGenerateContentServerMessage_SetupComplete); ok {
		return x.SetupComplete
	}
	return nil
}

func (x *BidiGenerateContentServerMessage) GetServerContent() *BidiGenerateContentServerContent {
	if x, ok := x.GetMessageType().(*BidiGenerateContentServerMessage_ServerContent); ok {
		return x.ServerContent
	}
	return nil
}

func (x *BidiGenerateContentServerMessage) GetToolCall() *BidiGenerateContentToolCall {
	if x, ok := x.GetMessageType().(*BidiGenerateContentServerMessage_ToolCall); ok {
		return x.ToolCall
	}
	return nil
}

func (x *BidiGenerateContentServerMessage) GetToolCallCancellation() *BidiGenerateContentToolCallCancellation {
	if x, ok := x.GetMessageType().(*BidiGenerateContentServerMessage_ToolCallCancellation); ok {
		return x.ToolCallCancellation
	}
	return nil
}

func (x *BidiGenerateContentServerMessage) GetGoAway() *GoAway {
	if x, ok := x.GetMessageType().(*BidiGenerateContentServerMessage_GoAway); ok {
		return x.GoAway
	}
	return nil
}

func (x *BidiGenerateContentServerMessage) GetSessionResumptionUpdate() *SessionResumptionUpdate {
	if x, ok := x.GetMessageType().(*BidiGenerateContentServerMessage_SessionResumptionUpdate); ok {
		return x.SessionResumptionUpdate
	}
	return nil
}

func (x *BidiGenerateContentServerMessage) GetUsageMetadata() *UsageMetadata {
	if x != nil {
		return x.UsageMetadata
	}
	return nil
}

type isBidiGenerateContentServerMessage_MessageType interface {
	isBidiGenerateContentServerMessage_MessageType()
}

type BidiGenerateContentServerMessage_SetupComplete struct {
	// Output only. Sent in response to a `BidiGenerateContentSetup` message
	// from the client when setup is complete.
	SetupComplete *BidiGenerateContentSetupComplete `protobuf:"bytes,2,opt,name=setup_complete,json=setupComplete,proto3,oneof"`
}

type BidiGenerateContentServerMessage_ServerContent struct {
	// Output only. Content generated by the model in response to client
	// messages.
	ServerContent *BidiGenerateContentServerContent `protobuf:"bytes,3,opt,name=server_content,json=serverContent,proto3,oneof"`
}

type BidiGenerateContentServerMessage_ToolCall struct {
	// Output only. Request for the client to execute the `function_calls` and
	// return the responses with the matching `id`s.
	ToolCall *BidiGenerateContentToolCall `protobuf:"bytes,4,opt,name=tool_call,json=toolCall,proto3,oneof"`
}

type BidiGenerateContentServerMessage_ToolCallCancellation struct {
	// Output only. Notification for the client that a previously issued
	// `ToolCallMessage` with the specified `id`s should be cancelled.
	ToolCallCancellation *BidiGenerateContentToolCallCancellation `protobuf:"bytes,5,opt,name=tool_call_cancellation,json=toolCallCancellation,proto3,oneof"`
}

type BidiGenerateContentServerMessage_GoAway struct {
	// Output only. A notice that the server will soon disconnect.
	GoAway *GoAway `protobuf:"bytes,6,opt,name=go_away,json=goAway,proto3,oneof"`
}

type BidiGenerateContentServerMessage_SessionResumptionUpdate struct {
	// Output only. Update of the session resumption state.
	SessionResumptionUpdate *SessionResumptionUpdate `protobuf:"bytes,7,opt,name=session_resumption_update,json=sessionResumptionUpdate,proto3,oneof"`
}

func (*BidiGenerateContentServerMessage_SetupComplete) isBidiGenerateContentServerMessage_MessageType() {
}

func (*BidiGenerateContentServerMessage_ServerContent) isBidiGenerateContentServerMessage_MessageType() {
}

func (*BidiGenerateContentServerMessage_ToolCall) isBidiGenerateContentServerMessage_MessageType() {}

func (*BidiGenerateContentServerMessage_ToolCallCancellation) isBidiGenerateContentServerMessage_MessageType() {
}

func (*BidiGenerateContentServerMessage_GoAway) isBidiGenerateContentServerMessage_MessageType() {}

func (*BidiGenerateContentServerMessage_SessionResumptionUpdate) isBidiGenerateContentServerMessage_MessageType() {
}

// Usage metadata about response(s).
type UsageMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Number of tokens in the prompt. When `cached_content` is set,
	// this is still the total effective prompt size meaning this includes the
	// number of tokens in the cached content.
	PromptTokenCount int32 `protobuf:"varint,1,opt,name=prompt_token_count,json=promptTokenCount,proto3" json:"prompt_token_count,omitempty"`
	// Number of tokens in the cached part of the prompt (the cached content)
	CachedContentTokenCount int32 `protobuf:"varint,4,opt,name=cached_content_token_count,json=cachedContentTokenCount,proto3" json:"cached_content_token_count,omitempty"`
	// Output only. Total number of tokens across all the generated response
	// candidates.
	ResponseTokenCount int32 `protobuf:"varint,2,opt,name=response_token_count,json=responseTokenCount,proto3" json:"response_token_count,omitempty"`
	// Output only. Number of tokens present in tool-use prompt(s).
	ToolUsePromptTokenCount int32 `protobuf:"varint,8,opt,name=tool_use_prompt_token_count,json=toolUsePromptTokenCount,proto3" json:"tool_use_prompt_token_count,omitempty"`
	// Output only. Number of tokens of thoughts for thinking models.
	ThoughtsTokenCount int32 `protobuf:"varint,10,opt,name=thoughts_token_count,json=thoughtsTokenCount,proto3" json:"thoughts_token_count,omitempty"`
	// Output only. Total token count for the generation request (prompt +
	// response candidates).
	TotalTokenCount int32 `protobuf:"varint,3,opt,name=total_token_count,json=totalTokenCount,proto3" json:"total_token_count,omitempty"`
	// Output only. List of modalities that were processed in the request input.
	PromptTokensDetails []*ModalityTokenCount `protobuf:"bytes,5,rep,name=prompt_tokens_details,json=promptTokensDetails,proto3" json:"prompt_tokens_details,omitempty"`
	// Output only. List of modalities of the cached content in the request input.
	CacheTokensDetails []*ModalityTokenCount `protobuf:"bytes,6,rep,name=cache_tokens_details,json=cacheTokensDetails,proto3" json:"cache_tokens_details,omitempty"`
	// Output only. List of modalities that were returned in the response.
	ResponseTokensDetails []*ModalityTokenCount `protobuf:"bytes,7,rep,name=response_tokens_details,json=responseTokensDetails,proto3" json:"response_tokens_details,omitempty"`
	// Output only. List of modalities that were processed for tool-use request
	// inputs.
	ToolUsePromptTokensDetails []*ModalityTokenCount `protobuf:"bytes,9,rep,name=tool_use_prompt_tokens_details,json=toolUsePromptTokensDetails,proto3" json:"tool_use_prompt_tokens_details,omitempty"`
}

func (x *UsageMetadata) Reset() {
	*x = UsageMetadata{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UsageMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UsageMetadata) ProtoMessage() {}

func (x *UsageMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UsageMetadata.ProtoReflect.Descriptor instead.
func (*UsageMetadata) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{44}
}

func (x *UsageMetadata) GetPromptTokenCount() int32 {
	if x != nil {
		return x.PromptTokenCount
	}
	return 0
}

func (x *UsageMetadata) GetCachedContentTokenCount() int32 {
	if x != nil {
		return x.CachedContentTokenCount
	}
	return 0
}

func (x *UsageMetadata) GetResponseTokenCount() int32 {
	if x != nil {
		return x.ResponseTokenCount
	}
	return 0
}

func (x *UsageMetadata) GetToolUsePromptTokenCount() int32 {
	if x != nil {
		return x.ToolUsePromptTokenCount
	}
	return 0
}

func (x *UsageMetadata) GetThoughtsTokenCount() int32 {
	if x != nil {
		return x.ThoughtsTokenCount
	}
	return 0
}

func (x *UsageMetadata) GetTotalTokenCount() int32 {
	if x != nil {
		return x.TotalTokenCount
	}
	return 0
}

func (x *UsageMetadata) GetPromptTokensDetails() []*ModalityTokenCount {
	if x != nil {
		return x.PromptTokensDetails
	}
	return nil
}

func (x *UsageMetadata) GetCacheTokensDetails() []*ModalityTokenCount {
	if x != nil {
		return x.CacheTokensDetails
	}
	return nil
}

func (x *UsageMetadata) GetResponseTokensDetails() []*ModalityTokenCount {
	if x != nil {
		return x.ResponseTokensDetails
	}
	return nil
}

func (x *UsageMetadata) GetToolUsePromptTokensDetails() []*ModalityTokenCount {
	if x != nil {
		return x.ToolUsePromptTokensDetails
	}
	return nil
}

// A set of the feedback metadata the prompt specified in
// `GenerateContentRequest.content`.
type GenerateContentResponse_PromptFeedback struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. If set, the prompt was blocked and no candidates are returned.
	// Rephrase the prompt.
	BlockReason GenerateContentResponse_PromptFeedback_BlockReason `protobuf:"varint,1,opt,name=block_reason,json=blockReason,proto3,enum=google.ai.generativelanguage.v1beta.GenerateContentResponse_PromptFeedback_BlockReason" json:"block_reason,omitempty"`
	// Ratings for safety of the prompt.
	// There is at most one rating per category.
	SafetyRatings []*SafetyRating `protobuf:"bytes,2,rep,name=safety_ratings,json=safetyRatings,proto3" json:"safety_ratings,omitempty"`
}

func (x *GenerateContentResponse_PromptFeedback) Reset() {
	*x = GenerateContentResponse_PromptFeedback{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateContentResponse_PromptFeedback) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateContentResponse_PromptFeedback) ProtoMessage() {}

func (x *GenerateContentResponse_PromptFeedback) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateContentResponse_PromptFeedback.ProtoReflect.Descriptor instead.
func (*GenerateContentResponse_PromptFeedback) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{7, 0}
}

func (x *GenerateContentResponse_PromptFeedback) GetBlockReason() GenerateContentResponse_PromptFeedback_BlockReason {
	if x != nil {
		return x.BlockReason
	}
	return GenerateContentResponse_PromptFeedback_BLOCK_REASON_UNSPECIFIED
}

func (x *GenerateContentResponse_PromptFeedback) GetSafetyRatings() []*SafetyRating {
	if x != nil {
		return x.SafetyRatings
	}
	return nil
}

// Metadata on the generation request's token usage.
type GenerateContentResponse_UsageMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of tokens in the prompt. When `cached_content` is set, this is
	// still the total effective prompt size meaning this includes the number of
	// tokens in the cached content.
	PromptTokenCount int32 `protobuf:"varint,1,opt,name=prompt_token_count,json=promptTokenCount,proto3" json:"prompt_token_count,omitempty"`
	// Number of tokens in the cached part of the prompt (the cached content)
	CachedContentTokenCount int32 `protobuf:"varint,4,opt,name=cached_content_token_count,json=cachedContentTokenCount,proto3" json:"cached_content_token_count,omitempty"`
	// Total number of tokens across all the generated response candidates.
	CandidatesTokenCount int32 `protobuf:"varint,2,opt,name=candidates_token_count,json=candidatesTokenCount,proto3" json:"candidates_token_count,omitempty"`
	// Output only. Number of tokens present in tool-use prompt(s).
	ToolUsePromptTokenCount int32 `protobuf:"varint,8,opt,name=tool_use_prompt_token_count,json=toolUsePromptTokenCount,proto3" json:"tool_use_prompt_token_count,omitempty"`
	// Output only. Number of tokens of thoughts for thinking models.
	ThoughtsTokenCount int32 `protobuf:"varint,10,opt,name=thoughts_token_count,json=thoughtsTokenCount,proto3" json:"thoughts_token_count,omitempty"`
	// Total token count for the generation request (prompt + response
	// candidates).
	TotalTokenCount int32 `protobuf:"varint,3,opt,name=total_token_count,json=totalTokenCount,proto3" json:"total_token_count,omitempty"`
	// Output only. List of modalities that were processed in the request input.
	PromptTokensDetails []*ModalityTokenCount `protobuf:"bytes,5,rep,name=prompt_tokens_details,json=promptTokensDetails,proto3" json:"prompt_tokens_details,omitempty"`
	// Output only. List of modalities of the cached content in the request
	// input.
	CacheTokensDetails []*ModalityTokenCount `protobuf:"bytes,6,rep,name=cache_tokens_details,json=cacheTokensDetails,proto3" json:"cache_tokens_details,omitempty"`
	// Output only. List of modalities that were returned in the response.
	CandidatesTokensDetails []*ModalityTokenCount `protobuf:"bytes,7,rep,name=candidates_tokens_details,json=candidatesTokensDetails,proto3" json:"candidates_tokens_details,omitempty"`
	// Output only. List of modalities that were processed for tool-use request
	// inputs.
	ToolUsePromptTokensDetails []*ModalityTokenCount `protobuf:"bytes,9,rep,name=tool_use_prompt_tokens_details,json=toolUsePromptTokensDetails,proto3" json:"tool_use_prompt_tokens_details,omitempty"`
}

func (x *GenerateContentResponse_UsageMetadata) Reset() {
	*x = GenerateContentResponse_UsageMetadata{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateContentResponse_UsageMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateContentResponse_UsageMetadata) ProtoMessage() {}

func (x *GenerateContentResponse_UsageMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateContentResponse_UsageMetadata.ProtoReflect.Descriptor instead.
func (*GenerateContentResponse_UsageMetadata) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{7, 1}
}

func (x *GenerateContentResponse_UsageMetadata) GetPromptTokenCount() int32 {
	if x != nil {
		return x.PromptTokenCount
	}
	return 0
}

func (x *GenerateContentResponse_UsageMetadata) GetCachedContentTokenCount() int32 {
	if x != nil {
		return x.CachedContentTokenCount
	}
	return 0
}

func (x *GenerateContentResponse_UsageMetadata) GetCandidatesTokenCount() int32 {
	if x != nil {
		return x.CandidatesTokenCount
	}
	return 0
}

func (x *GenerateContentResponse_UsageMetadata) GetToolUsePromptTokenCount() int32 {
	if x != nil {
		return x.ToolUsePromptTokenCount
	}
	return 0
}

func (x *GenerateContentResponse_UsageMetadata) GetThoughtsTokenCount() int32 {
	if x != nil {
		return x.ThoughtsTokenCount
	}
	return 0
}

func (x *GenerateContentResponse_UsageMetadata) GetTotalTokenCount() int32 {
	if x != nil {
		return x.TotalTokenCount
	}
	return 0
}

func (x *GenerateContentResponse_UsageMetadata) GetPromptTokensDetails() []*ModalityTokenCount {
	if x != nil {
		return x.PromptTokensDetails
	}
	return nil
}

func (x *GenerateContentResponse_UsageMetadata) GetCacheTokensDetails() []*ModalityTokenCount {
	if x != nil {
		return x.CacheTokensDetails
	}
	return nil
}

func (x *GenerateContentResponse_UsageMetadata) GetCandidatesTokensDetails() []*ModalityTokenCount {
	if x != nil {
		return x.CandidatesTokensDetails
	}
	return nil
}

func (x *GenerateContentResponse_UsageMetadata) GetToolUsePromptTokensDetails() []*ModalityTokenCount {
	if x != nil {
		return x.ToolUsePromptTokensDetails
	}
	return nil
}

// Candidate for the logprobs token and score.
type LogprobsResult_Candidate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The candidate’s token string value.
	Token *string `protobuf:"bytes,1,opt,name=token,proto3,oneof" json:"token,omitempty"`
	// The candidate’s token id value.
	TokenId *int32 `protobuf:"varint,3,opt,name=token_id,json=tokenId,proto3,oneof" json:"token_id,omitempty"`
	// The candidate's log probability.
	LogProbability *float32 `protobuf:"fixed32,2,opt,name=log_probability,json=logProbability,proto3,oneof" json:"log_probability,omitempty"`
}

func (x *LogprobsResult_Candidate) Reset() {
	*x = LogprobsResult_Candidate{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogprobsResult_Candidate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogprobsResult_Candidate) ProtoMessage() {}

func (x *LogprobsResult_Candidate) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogprobsResult_Candidate.ProtoReflect.Descriptor instead.
func (*LogprobsResult_Candidate) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{9, 0}
}

func (x *LogprobsResult_Candidate) GetToken() string {
	if x != nil && x.Token != nil {
		return *x.Token
	}
	return ""
}

func (x *LogprobsResult_Candidate) GetTokenId() int32 {
	if x != nil && x.TokenId != nil {
		return *x.TokenId
	}
	return 0
}

func (x *LogprobsResult_Candidate) GetLogProbability() float32 {
	if x != nil && x.LogProbability != nil {
		return *x.LogProbability
	}
	return 0
}

// Candidates with top log probabilities at each decoding step.
type LogprobsResult_TopCandidates struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sorted by log probability in descending order.
	Candidates []*LogprobsResult_Candidate `protobuf:"bytes,1,rep,name=candidates,proto3" json:"candidates,omitempty"`
}

func (x *LogprobsResult_TopCandidates) Reset() {
	*x = LogprobsResult_TopCandidates{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogprobsResult_TopCandidates) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogprobsResult_TopCandidates) ProtoMessage() {}

func (x *LogprobsResult_TopCandidates) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogprobsResult_TopCandidates.ProtoReflect.Descriptor instead.
func (*LogprobsResult_TopCandidates) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{9, 1}
}

func (x *LogprobsResult_TopCandidates) GetCandidates() []*LogprobsResult_Candidate {
	if x != nil {
		return x.Candidates
	}
	return nil
}

// Identifier for a part within a `GroundingPassage`.
type AttributionSourceId_GroundingPassageId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. ID of the passage matching the `GenerateAnswerRequest`'s
	// `GroundingPassage.id`.
	PassageId string `protobuf:"bytes,1,opt,name=passage_id,json=passageId,proto3" json:"passage_id,omitempty"`
	// Output only. Index of the part within the `GenerateAnswerRequest`'s
	// `GroundingPassage.content`.
	PartIndex int32 `protobuf:"varint,2,opt,name=part_index,json=partIndex,proto3" json:"part_index,omitempty"`
}

func (x *AttributionSourceId_GroundingPassageId) Reset() {
	*x = AttributionSourceId_GroundingPassageId{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AttributionSourceId_GroundingPassageId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributionSourceId_GroundingPassageId) ProtoMessage() {}

func (x *AttributionSourceId_GroundingPassageId) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributionSourceId_GroundingPassageId.ProtoReflect.Descriptor instead.
func (*AttributionSourceId_GroundingPassageId) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{10, 0}
}

func (x *AttributionSourceId_GroundingPassageId) GetPassageId() string {
	if x != nil {
		return x.PassageId
	}
	return ""
}

func (x *AttributionSourceId_GroundingPassageId) GetPartIndex() int32 {
	if x != nil {
		return x.PartIndex
	}
	return 0
}

// Identifier for a `Chunk` retrieved via Semantic Retriever specified in the
// `GenerateAnswerRequest` using `SemanticRetrieverConfig`.
type AttributionSourceId_SemanticRetrieverChunk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Name of the source matching the request's
	// `SemanticRetrieverConfig.source`. Example: `corpora/123` or
	// `corpora/123/documents/abc`
	Source string `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// Output only. Name of the `Chunk` containing the attributed text.
	// Example: `corpora/123/documents/abc/chunks/xyz`
	Chunk string `protobuf:"bytes,2,opt,name=chunk,proto3" json:"chunk,omitempty"`
}

func (x *AttributionSourceId_SemanticRetrieverChunk) Reset() {
	*x = AttributionSourceId_SemanticRetrieverChunk{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AttributionSourceId_SemanticRetrieverChunk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributionSourceId_SemanticRetrieverChunk) ProtoMessage() {}

func (x *AttributionSourceId_SemanticRetrieverChunk) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributionSourceId_SemanticRetrieverChunk.ProtoReflect.Descriptor instead.
func (*AttributionSourceId_SemanticRetrieverChunk) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{10, 1}
}

func (x *AttributionSourceId_SemanticRetrieverChunk) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *AttributionSourceId_SemanticRetrieverChunk) GetChunk() string {
	if x != nil {
		return x.Chunk
	}
	return ""
}

// Chunk from the web.
type GroundingChunk_Web struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URI reference of the chunk.
	Uri *string `protobuf:"bytes,1,opt,name=uri,proto3,oneof" json:"uri,omitempty"`
	// Title of the chunk.
	Title *string `protobuf:"bytes,2,opt,name=title,proto3,oneof" json:"title,omitempty"`
}

func (x *GroundingChunk_Web) Reset() {
	*x = GroundingChunk_Web{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[51]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroundingChunk_Web) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroundingChunk_Web) ProtoMessage() {}

func (x *GroundingChunk_Web) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[51]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroundingChunk_Web.ProtoReflect.Descriptor instead.
func (*GroundingChunk_Web) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{15, 0}
}

func (x *GroundingChunk_Web) GetUri() string {
	if x != nil && x.Uri != nil {
		return *x.Uri
	}
	return ""
}

func (x *GroundingChunk_Web) GetTitle() string {
	if x != nil && x.Title != nil {
		return *x.Title
	}
	return ""
}

// Feedback related to the input data used to answer the question, as opposed
// to the model-generated response to the question.
type GenerateAnswerResponse_InputFeedback struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. If set, the input was blocked and no candidates are returned.
	// Rephrase the input.
	BlockReason *GenerateAnswerResponse_InputFeedback_BlockReason `protobuf:"varint,1,opt,name=block_reason,json=blockReason,proto3,enum=google.ai.generativelanguage.v1beta.GenerateAnswerResponse_InputFeedback_BlockReason,oneof" json:"block_reason,omitempty"`
	// Ratings for safety of the input.
	// There is at most one rating per category.
	SafetyRatings []*SafetyRating `protobuf:"bytes,2,rep,name=safety_ratings,json=safetyRatings,proto3" json:"safety_ratings,omitempty"`
}

func (x *GenerateAnswerResponse_InputFeedback) Reset() {
	*x = GenerateAnswerResponse_InputFeedback{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[52]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateAnswerResponse_InputFeedback) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateAnswerResponse_InputFeedback) ProtoMessage() {}

func (x *GenerateAnswerResponse_InputFeedback) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[52]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateAnswerResponse_InputFeedback.ProtoReflect.Descriptor instead.
func (*GenerateAnswerResponse_InputFeedback) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{19, 0}
}

func (x *GenerateAnswerResponse_InputFeedback) GetBlockReason() GenerateAnswerResponse_InputFeedback_BlockReason {
	if x != nil && x.BlockReason != nil {
		return *x.BlockReason
	}
	return GenerateAnswerResponse_InputFeedback_BLOCK_REASON_UNSPECIFIED
}

func (x *GenerateAnswerResponse_InputFeedback) GetSafetyRatings() []*SafetyRating {
	if x != nil {
		return x.SafetyRatings
	}
	return nil
}

// Configures automatic detection of activity.
type RealtimeInputConfig_AutomaticActivityDetection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. If enabled (the default), detected voice and text input count
	// as activity. If disabled, the client must send activity signals.
	Disabled *bool `protobuf:"varint,2,opt,name=disabled,proto3,oneof" json:"disabled,omitempty"`
	// Optional. Determines how likely speech is to be detected.
	StartOfSpeechSensitivity *RealtimeInputConfig_AutomaticActivityDetection_StartSensitivity `protobuf:"varint,3,opt,name=start_of_speech_sensitivity,json=startOfSpeechSensitivity,proto3,enum=google.ai.generativelanguage.v1beta.RealtimeInputConfig_AutomaticActivityDetection_StartSensitivity,oneof" json:"start_of_speech_sensitivity,omitempty"`
	// Optional. The required duration of detected speech before start-of-speech
	// is committed. The lower this value, the more sensitive the
	// start-of-speech detection is and shorter speech can be recognized.
	// However, this also increases the probability of false positives.
	PrefixPaddingMs *int32 `protobuf:"varint,4,opt,name=prefix_padding_ms,json=prefixPaddingMs,proto3,oneof" json:"prefix_padding_ms,omitempty"`
	// Optional. Determines how likely detected speech is ended.
	EndOfSpeechSensitivity *RealtimeInputConfig_AutomaticActivityDetection_EndSensitivity `protobuf:"varint,5,opt,name=end_of_speech_sensitivity,json=endOfSpeechSensitivity,proto3,enum=google.ai.generativelanguage.v1beta.RealtimeInputConfig_AutomaticActivityDetection_EndSensitivity,oneof" json:"end_of_speech_sensitivity,omitempty"`
	// Optional. The required duration of detected non-speech (e.g. silence)
	// before end-of-speech is committed. The larger this value, the longer
	// speech gaps can be without interrupting the user's activity but this will
	// increase the model's latency.
	SilenceDurationMs *int32 `protobuf:"varint,6,opt,name=silence_duration_ms,json=silenceDurationMs,proto3,oneof" json:"silence_duration_ms,omitempty"`
}

func (x *RealtimeInputConfig_AutomaticActivityDetection) Reset() {
	*x = RealtimeInputConfig_AutomaticActivityDetection{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[53]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RealtimeInputConfig_AutomaticActivityDetection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RealtimeInputConfig_AutomaticActivityDetection) ProtoMessage() {}

func (x *RealtimeInputConfig_AutomaticActivityDetection) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[53]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RealtimeInputConfig_AutomaticActivityDetection.ProtoReflect.Descriptor instead.
func (*RealtimeInputConfig_AutomaticActivityDetection) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{27, 0}
}

func (x *RealtimeInputConfig_AutomaticActivityDetection) GetDisabled() bool {
	if x != nil && x.Disabled != nil {
		return *x.Disabled
	}
	return false
}

func (x *RealtimeInputConfig_AutomaticActivityDetection) GetStartOfSpeechSensitivity() RealtimeInputConfig_AutomaticActivityDetection_StartSensitivity {
	if x != nil && x.StartOfSpeechSensitivity != nil {
		return *x.StartOfSpeechSensitivity
	}
	return RealtimeInputConfig_AutomaticActivityDetection_START_SENSITIVITY_UNSPECIFIED
}

func (x *RealtimeInputConfig_AutomaticActivityDetection) GetPrefixPaddingMs() int32 {
	if x != nil && x.PrefixPaddingMs != nil {
		return *x.PrefixPaddingMs
	}
	return 0
}

func (x *RealtimeInputConfig_AutomaticActivityDetection) GetEndOfSpeechSensitivity() RealtimeInputConfig_AutomaticActivityDetection_EndSensitivity {
	if x != nil && x.EndOfSpeechSensitivity != nil {
		return *x.EndOfSpeechSensitivity
	}
	return RealtimeInputConfig_AutomaticActivityDetection_END_SENSITIVITY_UNSPECIFIED
}

func (x *RealtimeInputConfig_AutomaticActivityDetection) GetSilenceDurationMs() int32 {
	if x != nil && x.SilenceDurationMs != nil {
		return *x.SilenceDurationMs
	}
	return 0
}

// The SlidingWindow method operates by discarding content at the beginning of
// the context window. The resulting context will always begin at the start of
// a USER role turn. System instructions and any
// `BidiGenerateContentSetup.prefix_turns` will always remain at the beginning
// of the result.
type ContextWindowCompressionConfig_SlidingWindow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The target number of tokens to keep. The default value is
	// trigger_tokens/2.
	//
	// Discarding parts of the context window causes a temporary latency
	// increase so this value should be calibrated to avoid frequent compression
	// operations.
	TargetTokens *int64 `protobuf:"varint,1,opt,name=target_tokens,json=targetTokens,proto3,oneof" json:"target_tokens,omitempty"`
}

func (x *ContextWindowCompressionConfig_SlidingWindow) Reset() {
	*x = ContextWindowCompressionConfig_SlidingWindow{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[54]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContextWindowCompressionConfig_SlidingWindow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContextWindowCompressionConfig_SlidingWindow) ProtoMessage() {}

func (x *ContextWindowCompressionConfig_SlidingWindow) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[54]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContextWindowCompressionConfig_SlidingWindow.ProtoReflect.Descriptor instead.
func (*ContextWindowCompressionConfig_SlidingWindow) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{29, 0}
}

func (x *ContextWindowCompressionConfig_SlidingWindow) GetTargetTokens() int64 {
	if x != nil && x.TargetTokens != nil {
		return *x.TargetTokens
	}
	return 0
}

// Marks the start of user activity.
type BidiGenerateContentRealtimeInput_ActivityStart struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *BidiGenerateContentRealtimeInput_ActivityStart) Reset() {
	*x = BidiGenerateContentRealtimeInput_ActivityStart{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[55]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BidiGenerateContentRealtimeInput_ActivityStart) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BidiGenerateContentRealtimeInput_ActivityStart) ProtoMessage() {}

func (x *BidiGenerateContentRealtimeInput_ActivityStart) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[55]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BidiGenerateContentRealtimeInput_ActivityStart.ProtoReflect.Descriptor instead.
func (*BidiGenerateContentRealtimeInput_ActivityStart) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{33, 0}
}

// Marks the end of user activity.
type BidiGenerateContentRealtimeInput_ActivityEnd struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *BidiGenerateContentRealtimeInput_ActivityEnd) Reset() {
	*x = BidiGenerateContentRealtimeInput_ActivityEnd{}
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[56]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BidiGenerateContentRealtimeInput_ActivityEnd) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BidiGenerateContentRealtimeInput_ActivityEnd) ProtoMessage() {}

func (x *BidiGenerateContentRealtimeInput_ActivityEnd) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[56]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BidiGenerateContentRealtimeInput_ActivityEnd.ProtoReflect.Descriptor instead.
func (*BidiGenerateContentRealtimeInput_ActivityEnd) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP(), []int{33, 1}
}

var File_google_ai_generativelanguage_v1beta_generative_service_proto protoreflect.FileDescriptor

var file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDesc = []byte{
	0x0a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x69, 0x2f, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x23,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x69, 0x2f, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x63, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x69, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x69, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f,
	0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x69, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa7, 0x06, 0x0a, 0x16, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x45, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52,
	0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x65, 0x0a, 0x12, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x5f, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x11, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x49,
	0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x4d, 0x0a,
	0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x44, 0x0a, 0x05,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x12, 0x55, 0x0a, 0x0b, 0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x54, 0x6f,
	0x6f, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x74,
	0x6f, 0x6f, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x60, 0x0a, 0x0f, 0x73, 0x61, 0x66,
	0x65, 0x74, 0x79, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x61, 0x66,
	0x65, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x6c, 0x0a, 0x11, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x48, 0x01, 0x52, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x88, 0x01, 0x01, 0x12, 0x63, 0x0a, 0x0e, 0x63, 0x61, 0x63,
	0x68, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x37, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x63,
	0x68, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x48, 0x02, 0x52, 0x0d, 0x63, 0x61,
	0x63, 0x68, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x42, 0x15,
	0x0a, 0x13, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x11, 0x0a, 0x0f, 0x5f,
	0x63, 0x61, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0x48,
	0x0a, 0x13, 0x50, 0x72, 0x65, 0x62, 0x75, 0x69, 0x6c, 0x74, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x22, 0x0a, 0x0a, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x76, 0x6f, 0x69,
	0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x76, 0x6f,
	0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x8d, 0x01, 0x0a, 0x0b, 0x56, 0x6f, 0x69,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6e, 0x0a, 0x15, 0x70, 0x72, 0x65, 0x62,
	0x75, 0x69, 0x6c, 0x74, 0x5f, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72,
	0x65, 0x62, 0x75, 0x69, 0x6c, 0x74, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x48, 0x00, 0x52, 0x13, 0x70, 0x72, 0x65, 0x62, 0x75, 0x69, 0x6c, 0x74, 0x56, 0x6f, 0x69,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x0e, 0x0a, 0x0c, 0x76, 0x6f, 0x69, 0x63,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x8d, 0x01, 0x0a, 0x0c, 0x53, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x53, 0x0a, 0x0c, 0x76, 0x6f, 0x69,
	0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x0b, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x28,
	0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x97, 0x01, 0x0a, 0x0e, 0x54, 0x68, 0x69,
	0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2e, 0x0a, 0x10, 0x69,
	0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68, 0x74, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x0f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65,
	0x54, 0x68, 0x6f, 0x75, 0x67, 0x68, 0x74, 0x73, 0x88, 0x01, 0x01, 0x12, 0x2c, 0x0a, 0x0f, 0x74,
	0x68, 0x69, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x48, 0x01, 0x52, 0x0e, 0x74, 0x68, 0x69, 0x6e, 0x6b, 0x69, 0x6e, 0x67,
	0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x88, 0x01, 0x01, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x69, 0x6e,
	0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68, 0x74, 0x73, 0x42, 0x12,
	0x0a, 0x10, 0x5f, 0x74, 0x68, 0x69, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x75, 0x64, 0x67,
	0x65, 0x74, 0x22, 0xdf, 0x0c, 0x0a, 0x10, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x31, 0x0a, 0x0f, 0x63, 0x61, 0x6e, 0x64, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0e, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x74,
	0x6f, 0x70, 0x5f, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x73, 0x74, 0x6f, 0x70, 0x53, 0x65, 0x71,
	0x75, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x34, 0x0a, 0x11, 0x6d, 0x61, 0x78, 0x5f, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x0f, 0x6d, 0x61, 0x78, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x2a, 0x0a, 0x0b,
	0x74, 0x65, 0x6d, 0x70, 0x65, 0x72, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x02, 0x52, 0x0b, 0x74, 0x65, 0x6d, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x1d, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x5f,
	0x70, 0x18, 0x06, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x03, 0x52, 0x04,
	0x74, 0x6f, 0x70, 0x50, 0x88, 0x01, 0x01, 0x12, 0x1d, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x5f, 0x6b,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x04, 0x52, 0x04, 0x74,
	0x6f, 0x70, 0x4b, 0x88, 0x01, 0x01, 0x12, 0x1c, 0x0a, 0x04, 0x73, 0x65, 0x65, 0x64, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x05, 0x52, 0x04, 0x73, 0x65, 0x65,
	0x64, 0x88, 0x01, 0x01, 0x12, 0x31, 0x0a, 0x12, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x5f, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d,
	0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x59, 0x0a, 0x0f, 0x72, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0e, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x53, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x12, 0x33, 0x0a, 0x10, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x70,
	0x65, 0x6e, 0x61, 0x6c, 0x74, 0x79, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x06, 0x52, 0x0f, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x50, 0x65, 0x6e,
	0x61, 0x6c, 0x74, 0x79, 0x88, 0x01, 0x01, 0x12, 0x35, 0x0a, 0x11, 0x66, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x79, 0x5f, 0x70, 0x65, 0x6e, 0x61, 0x6c, 0x74, 0x79, 0x18, 0x10, 0x20, 0x01,
	0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x07, 0x52, 0x10, 0x66, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x79, 0x50, 0x65, 0x6e, 0x61, 0x6c, 0x74, 0x79, 0x88, 0x01, 0x01, 0x12, 0x35,
	0x0a, 0x11, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x6c, 0x6f, 0x67, 0x70, 0x72,
	0x6f, 0x62, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x08,
	0x52, 0x10, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4c, 0x6f, 0x67, 0x70, 0x72, 0x6f,
	0x62, 0x73, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x08, 0x6c, 0x6f, 0x67, 0x70, 0x72, 0x6f, 0x62,
	0x73, 0x18, 0x12, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x09, 0x52, 0x08,
	0x6c, 0x6f, 0x67, 0x70, 0x72, 0x6f, 0x62, 0x73, 0x88, 0x01, 0x01, 0x12, 0x4b, 0x0a, 0x1d, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x65, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x63,
	0x69, 0x76, 0x69, 0x63, 0x5f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x18, 0x13, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x0a, 0x52, 0x1a, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x45, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x43, 0x69, 0x76, 0x69, 0x63, 0x41, 0x6e,
	0x73, 0x77, 0x65, 0x72, 0x73, 0x88, 0x01, 0x01, 0x12, 0x74, 0x0a, 0x13, 0x72, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x61, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18,
	0x14, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x64,
	0x61, 0x6c, 0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x72, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x6f, 0x64, 0x61, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x60,
	0x0a, 0x0d, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x70, 0x65, 0x65,
	0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x0b, 0x52,
	0x0c, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x88, 0x01, 0x01,
	0x12, 0x66, 0x0a, 0x0f, 0x74, 0x68, 0x69, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x54, 0x68, 0x69, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x0c, 0x52, 0x0e, 0x74, 0x68, 0x69, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x88, 0x01, 0x01, 0x12, 0x7a, 0x0a, 0x10, 0x6d, 0x65, 0x64, 0x69,
	0x61, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x17, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x52,
	0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x0d,
	0x52, 0x0f, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x88, 0x01, 0x01, 0x22, 0x44, 0x0a, 0x08, 0x4d, 0x6f, 0x64, 0x61, 0x6c, 0x69, 0x74, 0x79,
	0x12, 0x18, 0x0a, 0x14, 0x4d, 0x4f, 0x44, 0x41, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x54, 0x45,
	0x58, 0x54, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x49, 0x4d, 0x41, 0x47, 0x45, 0x10, 0x02, 0x12,
	0x09, 0x0a, 0x05, 0x41, 0x55, 0x44, 0x49, 0x4f, 0x10, 0x03, 0x22, 0x85, 0x01, 0x0a, 0x0f, 0x4d,
	0x65, 0x64, 0x69, 0x61, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20,
	0x0a, 0x1c, 0x4d, 0x45, 0x44, 0x49, 0x41, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x4c, 0x55, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x18, 0x0a, 0x14, 0x4d, 0x45, 0x44, 0x49, 0x41, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x4c, 0x55,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4c, 0x4f, 0x57, 0x10, 0x01, 0x12, 0x1b, 0x0a, 0x17, 0x4d, 0x45,
	0x44, 0x49, 0x41, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x4c, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d,
	0x45, 0x44, 0x49, 0x55, 0x4d, 0x10, 0x02, 0x12, 0x19, 0x0a, 0x15, 0x4d, 0x45, 0x44, 0x49, 0x41,
	0x5f, 0x52, 0x45, 0x53, 0x4f, 0x4c, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x48, 0x49, 0x47, 0x48,
	0x10, 0x03, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x42, 0x0e, 0x0a, 0x0c,
	0x5f, 0x74, 0x65, 0x6d, 0x70, 0x65, 0x72, 0x61, 0x74, 0x75, 0x72, 0x65, 0x42, 0x08, 0x0a, 0x06,
	0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x70, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x6b,
	0x42, 0x07, 0x0a, 0x05, 0x5f, 0x73, 0x65, 0x65, 0x64, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x70, 0x72,
	0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x65, 0x6e, 0x61, 0x6c, 0x74, 0x79, 0x42, 0x14,
	0x0a, 0x12, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x70, 0x65, 0x6e,
	0x61, 0x6c, 0x74, 0x79, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x5f, 0x6c, 0x6f, 0x67, 0x70, 0x72, 0x6f, 0x62, 0x73, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x6c,
	0x6f, 0x67, 0x70, 0x72, 0x6f, 0x62, 0x73, 0x42, 0x20, 0x0a, 0x1e, 0x5f, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x65, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x63, 0x69, 0x76, 0x69,
	0x63, 0x5f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x73, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x12, 0x0a, 0x10, 0x5f,
	0x74, 0x68, 0x69, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42,
	0x13, 0x0a, 0x11, 0x5f, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8b, 0x03, 0x0a, 0x17, 0x53, 0x65, 0x6d, 0x61, 0x6e, 0x74, 0x69,
	0x63, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x1b, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x47, 0x0a,
	0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x63, 0x0a, 0x10, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x32, 0x0a, 0x10, 0x6d,
	0x61, 0x78, 0x5f, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0e, 0x6d, 0x61,
	0x78, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x12,
	0x40, 0x0a, 0x17, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x72, 0x65, 0x6c, 0x65, 0x76,
	0x61, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x02,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x15, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d,
	0x52, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x88, 0x01,
	0x01, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x73,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x1a, 0x0a, 0x18, 0x5f, 0x6d, 0x69, 0x6e, 0x69, 0x6d,
	0x75, 0x6d, 0x5f, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x63, 0x6f,
	0x72, 0x65, 0x22, 0xa4, 0x0c, 0x0a, 0x17, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4e,
	0x0a, 0x0a, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x52, 0x0a, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x73, 0x12, 0x74,
	0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x5f, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x46, 0x65, 0x65, 0x64,
	0x62, 0x61, 0x63, 0x6b, 0x52, 0x0e, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x46, 0x65, 0x65, 0x64,
	0x62, 0x61, 0x63, 0x6b, 0x12, 0x76, 0x0a, 0x0e, 0x75, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x55, 0x73, 0x61, 0x67, 0x65,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x75,
	0x73, 0x61, 0x67, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x28, 0x0a, 0x0d,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0xe8, 0x02, 0x0a, 0x0e, 0x50, 0x72, 0x6f, 0x6d, 0x70,
	0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x12, 0x7f, 0x0a, 0x0c, 0x62, 0x6c, 0x6f,
	0x63, 0x6b, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x50, 0x72,
	0x6f, 0x6d, 0x70, 0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x2e, 0x42, 0x6c, 0x6f,
	0x63, 0x6b, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x62,
	0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x58, 0x0a, 0x0e, 0x73, 0x61,
	0x66, 0x65, 0x74, 0x79, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x52,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x0d, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x52, 0x61, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x22, 0x7b, 0x0a, 0x0b, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x18, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x52, 0x45, 0x41,
	0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x41, 0x46, 0x45, 0x54, 0x59, 0x10, 0x01, 0x12, 0x09, 0x0a,
	0x05, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x42, 0x4c, 0x4f, 0x43,
	0x4b, 0x4c, 0x49, 0x53, 0x54, 0x10, 0x03, 0x12, 0x16, 0x0a, 0x12, 0x50, 0x52, 0x4f, 0x48, 0x49,
	0x42, 0x49, 0x54, 0x45, 0x44, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x10, 0x04, 0x12,
	0x10, 0x0a, 0x0c, 0x49, 0x4d, 0x41, 0x47, 0x45, 0x5f, 0x53, 0x41, 0x46, 0x45, 0x54, 0x59, 0x10,
	0x05, 0x1a, 0xb5, 0x06, 0x0a, 0x0d, 0x55, 0x73, 0x61, 0x67, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x2c, 0x0a, 0x12, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x10, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x3b, 0x0a, 0x1a, 0x63, 0x61, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x17, 0x63, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x34,
	0x0a, 0x16, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x73, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x14,
	0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x41, 0x0a, 0x1b, 0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x75, 0x73, 0x65,
	0x5f, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17,
	0x74, 0x6f, 0x6f, 0x6c, 0x55, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x35, 0x0a, 0x14, 0x74, 0x68, 0x6f, 0x75, 0x67,
	0x68, 0x74, 0x73, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x74, 0x68, 0x6f, 0x75,
	0x67, 0x68, 0x74, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2a,
	0x0a, 0x11, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x74, 0x6f, 0x74, 0x61, 0x6c,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x70, 0x0a, 0x15, 0x70, 0x72,
	0x6f, 0x6d, 0x70, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x5f, 0x64, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x4d, 0x6f, 0x64, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x6e, 0x0a, 0x14,
	0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x5f, 0x64, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x4d, 0x6f, 0x64, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x63, 0x61, 0x63, 0x68, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x78, 0x0a, 0x19,
	0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x73, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x73, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x6f, 0x64, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x63,
	0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x80, 0x01, 0x0a, 0x1e, 0x74, 0x6f, 0x6f, 0x6c, 0x5f,
	0x75, 0x73, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x73, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x6f, 0x64, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1a, 0x74,
	0x6f, 0x6f, 0x6c, 0x55, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0xa2, 0x08, 0x0a, 0x09, 0x43, 0x61,
	0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x12, 0x1e, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x05, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x88, 0x01, 0x01, 0x12, 0x4b, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x12, 0x68, 0x0a, 0x0d, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x5f, 0x72,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x43, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x46, 0x69, 0x6e, 0x69,
	0x73, 0x68, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x42, 0x06, 0xe0, 0x41, 0x01, 0xe0, 0x41, 0x03,
	0x52, 0x0c, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x58,
	0x0a, 0x0e, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x61, 0x66,
	0x65, 0x74, 0x79, 0x52, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x0d, 0x73, 0x61, 0x66, 0x65, 0x74,
	0x79, 0x52, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x67, 0x0a, 0x11, 0x63, 0x69, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x69, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x10, 0x63, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x24, 0x0a, 0x0b, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x75, 0x0a, 0x16, 0x67, 0x72, 0x6f, 0x75, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x72,
	0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x6a,
	0x0a, 0x12, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x26, 0x0a, 0x0c, 0x61, 0x76,
	0x67, 0x5f, 0x6c, 0x6f, 0x67, 0x70, 0x72, 0x6f, 0x62, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x01,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x61, 0x76, 0x67, 0x4c, 0x6f, 0x67, 0x70, 0x72, 0x6f,
	0x62, 0x73, 0x12, 0x61, 0x0a, 0x0f, 0x6c, 0x6f, 0x67, 0x70, 0x72, 0x6f, 0x62, 0x73, 0x5f, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x4c, 0x6f, 0x67, 0x70, 0x72, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x6c, 0x6f, 0x67, 0x70, 0x72, 0x6f, 0x62, 0x73, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0xdc, 0x01, 0x0a, 0x0c, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68,
	0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x19, 0x46, 0x49, 0x4e, 0x49, 0x53, 0x48,
	0x5f, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x54, 0x4f, 0x50, 0x10, 0x01, 0x12,
	0x0e, 0x0a, 0x0a, 0x4d, 0x41, 0x58, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x53, 0x10, 0x02, 0x12,
	0x0a, 0x0a, 0x06, 0x53, 0x41, 0x46, 0x45, 0x54, 0x59, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x52,
	0x45, 0x43, 0x49, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x4c,
	0x41, 0x4e, 0x47, 0x55, 0x41, 0x47, 0x45, 0x10, 0x06, 0x12, 0x09, 0x0a, 0x05, 0x4f, 0x54, 0x48,
	0x45, 0x52, 0x10, 0x05, 0x12, 0x0d, 0x0a, 0x09, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x4c, 0x49, 0x53,
	0x54, 0x10, 0x07, 0x12, 0x16, 0x0a, 0x12, 0x50, 0x52, 0x4f, 0x48, 0x49, 0x42, 0x49, 0x54, 0x45,
	0x44, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x10, 0x08, 0x12, 0x08, 0x0a, 0x04, 0x53,
	0x50, 0x49, 0x49, 0x10, 0x09, 0x12, 0x1b, 0x0a, 0x17, 0x4d, 0x41, 0x4c, 0x46, 0x4f, 0x52, 0x4d,
	0x45, 0x44, 0x5f, 0x46, 0x55, 0x4e, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x41, 0x4c, 0x4c,
	0x10, 0x0a, 0x12, 0x10, 0x0a, 0x0c, 0x49, 0x4d, 0x41, 0x47, 0x45, 0x5f, 0x53, 0x41, 0x46, 0x45,
	0x54, 0x59, 0x10, 0x0b, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x22, 0xf8,
	0x03, 0x0a, 0x0e, 0x4c, 0x6f, 0x67, 0x70, 0x72, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x12, 0x68, 0x0a, 0x0e, 0x74, 0x6f, 0x70, 0x5f, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x4c, 0x6f, 0x67, 0x70, 0x72, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x54,
	0x6f, 0x70, 0x43, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x73, 0x52, 0x0d, 0x74, 0x6f,
	0x70, 0x43, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x73, 0x12, 0x6a, 0x0a, 0x11, 0x63,
	0x68, 0x6f, 0x73, 0x65, 0x6e, 0x5f, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x6f, 0x67,
	0x70, 0x72, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x43, 0x61, 0x6e, 0x64,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x52, 0x10, 0x63, 0x68, 0x6f, 0x73, 0x65, 0x6e, 0x43, 0x61, 0x6e,
	0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x73, 0x1a, 0x9f, 0x01, 0x0a, 0x09, 0x43, 0x61, 0x6e, 0x64,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x88, 0x01, 0x01,
	0x12, 0x1e, 0x0a, 0x08, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x05, 0x48, 0x01, 0x52, 0x07, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x49, 0x64, 0x88, 0x01, 0x01,
	0x12, 0x2c, 0x0a, 0x0f, 0x6c, 0x6f, 0x67, 0x5f, 0x70, 0x72, 0x6f, 0x62, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x48, 0x02, 0x52, 0x0e, 0x6c, 0x6f, 0x67,
	0x50, 0x72, 0x6f, 0x62, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x88, 0x01, 0x01, 0x42, 0x08,
	0x0a, 0x06, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x5f, 0x69, 0x64, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x70, 0x72,
	0x6f, 0x62, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x1a, 0x6e, 0x0a, 0x0d, 0x54, 0x6f, 0x70,
	0x43, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x73, 0x12, 0x5d, 0x0a, 0x0a, 0x63, 0x61,
	0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x6f, 0x67, 0x70, 0x72, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x2e, 0x43, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x52, 0x0a, 0x63,
	0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x73, 0x22, 0xd9, 0x03, 0x0a, 0x13, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49,
	0x64, 0x12, 0x7a, 0x0a, 0x11, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x70,
	0x61, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x49, 0x64, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x50, 0x61, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64, 0x48, 0x00, 0x52, 0x10, 0x67, 0x72, 0x6f,
	0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x61, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x8b, 0x01,
	0x0a, 0x18, 0x73, 0x65, 0x6d, 0x61, 0x6e, 0x74, 0x69, 0x63, 0x5f, 0x72, 0x65, 0x74, 0x72, 0x69,
	0x65, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x64, 0x2e, 0x53, 0x65, 0x6d, 0x61, 0x6e,
	0x74, 0x69, 0x63, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x72, 0x43, 0x68, 0x75, 0x6e,
	0x6b, 0x48, 0x00, 0x52, 0x16, 0x73, 0x65, 0x6d, 0x61, 0x6e, 0x74, 0x69, 0x63, 0x52, 0x65, 0x74,
	0x72, 0x69, 0x65, 0x76, 0x65, 0x72, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x1a, 0x5c, 0x0a, 0x12, 0x47,
	0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x61, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49,
	0x64, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x70, 0x61, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x74, 0x5f, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09,
	0x70, 0x61, 0x72, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x1a, 0x50, 0x0a, 0x16, 0x53, 0x65, 0x6d,
	0x61, 0x6e, 0x74, 0x69, 0x63, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x72, 0x43, 0x68,
	0x75, 0x6e, 0x6b, 0x12, 0x1b, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0x19, 0x0a, 0x05, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x42, 0x08, 0x0a, 0x06, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0xba, 0x01, 0x0a, 0x14, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5a,
	0x0a, 0x09, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x08, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x64, 0x12, 0x46, 0x0a, 0x07, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x22, 0x6a, 0x0a, 0x11, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x55, 0x0a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63,
	0x5f, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x21, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63,
	0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x22, 0x90,
	0x04, 0x0a, 0x11, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x6d, 0x0a, 0x12, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x10,
	0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x50, 0x6f, 0x69, 0x6e, 0x74,
	0x88, 0x01, 0x01, 0x12, 0x5e, 0x0a, 0x10, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x5f, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x75,
	0x6e, 0x6b, 0x52, 0x0f, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x75,
	0x6e, 0x6b, 0x73, 0x12, 0x64, 0x0a, 0x12, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x5f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53,
	0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x11, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x6a, 0x0a, 0x12, 0x72, 0x65, 0x74,
	0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x74, 0x72,
	0x69, 0x65, 0x76, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x01, 0x52,
	0x11, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x88, 0x01, 0x01, 0x12, 0x2c, 0x0a, 0x12, 0x77, 0x65, 0x62, 0x5f, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x10, 0x77, 0x65, 0x62, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x51, 0x75, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x72,
	0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x22, 0x62, 0x0a, 0x10, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x50, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x10, 0x72, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x65,
	0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x72, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x65, 0x64, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x1e, 0x0a, 0x08, 0x73, 0x64, 0x6b, 0x5f, 0x62, 0x6c, 0x6f,
	0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x73, 0x64,
	0x6b, 0x42, 0x6c, 0x6f, 0x62, 0x22, 0xb6, 0x01, 0x0a, 0x0e, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x12, 0x4b, 0x0a, 0x03, 0x77, 0x65, 0x62, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x72, 0x6f, 0x75,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x2e, 0x57, 0x65, 0x62, 0x48, 0x00,
	0x52, 0x03, 0x77, 0x65, 0x62, 0x1a, 0x49, 0x0a, 0x03, 0x57, 0x65, 0x62, 0x12, 0x15, 0x0a, 0x03,
	0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x03, 0x75, 0x72, 0x69,
	0x88, 0x01, 0x01, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x01, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x42, 0x06,
	0x0a, 0x04, 0x5f, 0x75, 0x72, 0x69, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x42, 0x0c, 0x0a, 0x0a, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0x8e,
	0x01, 0x0a, 0x07, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61,
	0x72, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x09, 0x70, 0x61, 0x72, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x24,
	0x0a, 0x0b, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x12, 0x20, 0x0a, 0x09, 0x65, 0x6e, 0x64, 0x5f, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x65, 0x6e,
	0x64, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x22,
	0xd0, 0x01, 0x0a, 0x10, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x12, 0x4b, 0x0a, 0x07, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x07, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x88, 0x01,
	0x01, 0x12, 0x36, 0x0a, 0x17, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63,
	0x68, 0x75, 0x6e, 0x6b, 0x5f, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x05, 0x52, 0x15, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x75,
	0x6e, 0x6b, 0x49, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x02, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65,
	0x53, 0x63, 0x6f, 0x72, 0x65, 0x73, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x22, 0xfc, 0x05, 0x0a, 0x15, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41,
	0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x61, 0x0a, 0x0f,
	0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x72, 0x6f, 0x75,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x61, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x48, 0x00, 0x52,
	0x0e, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x50, 0x61, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x12,
	0x6d, 0x0a, 0x12, 0x73, 0x65, 0x6d, 0x61, 0x6e, 0x74, 0x69, 0x63, 0x5f, 0x72, 0x65, 0x74, 0x72,
	0x69, 0x65, 0x76, 0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x53, 0x65, 0x6d, 0x61, 0x6e, 0x74, 0x69, 0x63, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65,
	0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x11, 0x73, 0x65, 0x6d,
	0x61, 0x6e, 0x74, 0x69, 0x63, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x72, 0x12, 0x45,
	0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x05,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x4d, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x73, 0x12, 0x6e, 0x0a, 0x0c, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f, 0x73,
	0x74, 0x79, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x53, 0x74, 0x79,
	0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x53,
	0x74, 0x79, 0x6c, 0x65, 0x12, 0x60, 0x0a, 0x0f, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x5f, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x2a, 0x0a, 0x0b, 0x74, 0x65, 0x6d, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x01, 0x52, 0x0b, 0x74, 0x65, 0x6d, 0x70, 0x65, 0x72, 0x61, 0x74, 0x75, 0x72, 0x65, 0x88,
	0x01, 0x01, 0x22, 0x59, 0x0a, 0x0b, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x53, 0x74, 0x79, 0x6c,
	0x65, 0x12, 0x1c, 0x0a, 0x18, 0x41, 0x4e, 0x53, 0x57, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x59, 0x4c,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0f, 0x0a, 0x0b, 0x41, 0x42, 0x53, 0x54, 0x52, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01,
	0x12, 0x0e, 0x0a, 0x0a, 0x45, 0x58, 0x54, 0x52, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02,
	0x12, 0x0b, 0x0a, 0x07, 0x56, 0x45, 0x52, 0x42, 0x4f, 0x53, 0x45, 0x10, 0x03, 0x42, 0x12, 0x0a,
	0x10, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x65, 0x72, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x22, 0x91, 0x05, 0x0a, 0x16, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x6e,
	0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x46, 0x0a, 0x06,
	0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x43, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x52, 0x06, 0x61, 0x6e,
	0x73, 0x77, 0x65, 0x72, 0x12, 0x3f, 0x0a, 0x16, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x62, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x15, 0x61, 0x6e, 0x73,
	0x77, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x62, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x88, 0x01, 0x01, 0x12, 0x7a, 0x0a, 0x0e, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x66,
	0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x73, 0x77,
	0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01, 0x52,
	0x0d, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x88, 0x01,
	0x01, 0x1a, 0xc3, 0x02, 0x0a, 0x0d, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x46, 0x65, 0x65, 0x64, 0x62,
	0x61, 0x63, 0x6b, 0x12, 0x82, 0x01, 0x0a, 0x0c, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x72, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x55, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x46, 0x65, 0x65,
	0x64, 0x62, 0x61, 0x63, 0x6b, 0x2e, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0b, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x52,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x58, 0x0a, 0x0e, 0x73, 0x61, 0x66, 0x65,
	0x74, 0x79, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x52, 0x61, 0x74,
	0x69, 0x6e, 0x67, 0x52, 0x0d, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x52, 0x61, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x22, 0x42, 0x0a, 0x0b, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x12, 0x1c, 0x0a, 0x18, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x52, 0x45, 0x41, 0x53, 0x4f,
	0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0a, 0x0a, 0x06, 0x53, 0x41, 0x46, 0x45, 0x54, 0x59, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x4f,
	0x54, 0x48, 0x45, 0x52, 0x10, 0x02, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b,
	0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x42, 0x19, 0x0a, 0x17, 0x5f, 0x61, 0x6e, 0x73, 0x77,
	0x65, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x62, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x66, 0x65, 0x65,
	0x64, 0x62, 0x61, 0x63, 0x6b, 0x22, 0x90, 0x03, 0x0a, 0x13, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a,
	0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x05, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x12, 0x4b, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x12, 0x54, 0x0a, 0x09, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69,
	0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x54,
	0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x08, 0x74, 0x61, 0x73, 0x6b,
	0x54, 0x79, 0x70, 0x65, 0x88, 0x01, 0x01, 0x12, 0x1e, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x05, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12, 0x3d, 0x0a, 0x15, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x69, 0x74, 0x79,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x02, 0x52, 0x14, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x6c,
	0x69, 0x74, 0x79, 0x88, 0x01, 0x01, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x74, 0x61, 0x73, 0x6b, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x42, 0x18,
	0x0a, 0x16, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x22, 0x2a, 0x0a, 0x10, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x16, 0x0a, 0x06,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x02, 0x52, 0x06, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x22, 0x70, 0x0a, 0x14, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x58, 0x0a, 0x09,
	0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x45, 0x6d, 0x62,
	0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x65, 0x6d, 0x62,
	0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x22, 0xbd, 0x01, 0x0a, 0x19, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x45, 0x6d, 0x62, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x59, 0x0a, 0x08, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x22, 0x78, 0x0a, 0x1a, 0x42, 0x61, 0x74, 0x63, 0x68, 0x45,
	0x6d, 0x62, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5a, 0x0a, 0x0a, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e,
	0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x73,
	0x22, 0xa6, 0x02, 0x0a, 0x12, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x4d,
	0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x7a, 0x0a,
	0x18, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x16, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0xd7, 0x02, 0x0a, 0x13, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x21, 0x0a, 0x0c, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x73, 0x12, 0x3b, 0x0a, 0x1a, 0x63, 0x61, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x17, 0x63, 0x61, 0x63, 0x68, 0x65, 0x64,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x70, 0x0a, 0x15, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x73, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x6f, 0x64, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13,
	0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x12, 0x6e, 0x0a, 0x14, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x73, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x6f, 0x64, 0x61, 0x6c, 0x69, 0x74, 0x79,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x12, 0x63, 0x61, 0x63, 0x68, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x22, 0x8a, 0x0c, 0x0a, 0x13, 0x52, 0x65, 0x61, 0x6c, 0x74, 0x69, 0x6d, 0x65,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x9a, 0x01, 0x0a, 0x1c,
	0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x61, 0x6c, 0x74, 0x69, 0x6d,
	0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x75, 0x74,
	0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1a, 0x61, 0x75,
	0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x44,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x80, 0x01, 0x0a, 0x11, 0x61, 0x63, 0x74,
	0x69, 0x76, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69,
	0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x61, 0x6c, 0x74,
	0x69, 0x6d, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x69, 0x6e, 0x67, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x10, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79,
	0x48, 0x61, 0x6e, 0x64, 0x6c, 0x69, 0x6e, 0x67, 0x88, 0x01, 0x01, 0x12, 0x74, 0x0a, 0x0d, 0x74,
	0x75, 0x72, 0x6e, 0x5f, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x61, 0x6c, 0x74, 0x69, 0x6d,
	0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x54, 0x75, 0x72,
	0x6e, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01,
	0x52, 0x0c, 0x74, 0x75, 0x72, 0x6e, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x88, 0x01,
	0x01, 0x1a, 0xd9, 0x06, 0x0a, 0x1a, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x41,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x24, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x88, 0x01, 0x01, 0x12, 0xad, 0x01, 0x0a, 0x1b, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x6f, 0x66, 0x5f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x73, 0x65, 0x6e, 0x73, 0x69,
	0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x52, 0x65, 0x61, 0x6c, 0x74, 0x69, 0x6d, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63,
	0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x53, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x18, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x4f, 0x66, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x53, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x88, 0x01, 0x01, 0x12, 0x34, 0x0a, 0x11, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x5f, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x02, 0x52, 0x0f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x50, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x4d, 0x73, 0x88, 0x01, 0x01, 0x12, 0xa7, 0x01, 0x0a,
	0x19, 0x65, 0x6e, 0x64, 0x5f, 0x6f, 0x66, 0x5f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x73,
	0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x61, 0x6c, 0x74, 0x69, 0x6d, 0x65, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d,
	0x61, 0x74, 0x69, 0x63, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x44, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x6e, 0x64, 0x53, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x03, 0x52, 0x16, 0x65, 0x6e, 0x64,
	0x4f, 0x66, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x53, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x88, 0x01, 0x01, 0x12, 0x38, 0x0a, 0x13, 0x73, 0x69, 0x6c, 0x65, 0x6e, 0x63,
	0x65, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x73, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x04, 0x52, 0x11, 0x73, 0x69, 0x6c, 0x65,
	0x6e, 0x63, 0x65, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x73, 0x88, 0x01, 0x01,
	0x22, 0x6c, 0x0a, 0x10, 0x53, 0x74, 0x61, 0x72, 0x74, 0x53, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x12, 0x21, 0x0a, 0x1d, 0x53, 0x54, 0x41, 0x52, 0x54, 0x5f, 0x53, 0x45,
	0x4e, 0x53, 0x49, 0x54, 0x49, 0x56, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x53, 0x54, 0x41, 0x52, 0x54,
	0x5f, 0x53, 0x45, 0x4e, 0x53, 0x49, 0x54, 0x49, 0x56, 0x49, 0x54, 0x59, 0x5f, 0x48, 0x49, 0x47,
	0x48, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x15, 0x53, 0x54, 0x41, 0x52, 0x54, 0x5f, 0x53, 0x45, 0x4e,
	0x53, 0x49, 0x54, 0x49, 0x56, 0x49, 0x54, 0x59, 0x5f, 0x4c, 0x4f, 0x57, 0x10, 0x02, 0x22, 0x64,
	0x0a, 0x0e, 0x45, 0x6e, 0x64, 0x53, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79,
	0x12, 0x1f, 0x0a, 0x1b, 0x45, 0x4e, 0x44, 0x5f, 0x53, 0x45, 0x4e, 0x53, 0x49, 0x54, 0x49, 0x56,
	0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x18, 0x0a, 0x14, 0x45, 0x4e, 0x44, 0x5f, 0x53, 0x45, 0x4e, 0x53, 0x49, 0x54, 0x49,
	0x56, 0x49, 0x54, 0x59, 0x5f, 0x48, 0x49, 0x47, 0x48, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13, 0x45,
	0x4e, 0x44, 0x5f, 0x53, 0x45, 0x4e, 0x53, 0x49, 0x54, 0x49, 0x56, 0x49, 0x54, 0x59, 0x5f, 0x4c,
	0x4f, 0x57, 0x10, 0x02, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x42, 0x1e, 0x0a, 0x1c, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x6f, 0x66, 0x5f, 0x73,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x5f, 0x70, 0x61, 0x64,
	0x64, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x73, 0x42, 0x1c, 0x0a, 0x1a, 0x5f, 0x65, 0x6e, 0x64, 0x5f,
	0x6f, 0x66, 0x5f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74,
	0x69, 0x76, 0x69, 0x74, 0x79, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x73, 0x69, 0x6c, 0x65, 0x6e, 0x63,
	0x65, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x73, 0x22, 0x6c, 0x0a,
	0x10, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x69, 0x6e,
	0x67, 0x12, 0x21, 0x0a, 0x1d, 0x41, 0x43, 0x54, 0x49, 0x56, 0x49, 0x54, 0x59, 0x5f, 0x48, 0x41,
	0x4e, 0x44, 0x4c, 0x49, 0x4e, 0x47, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x20, 0x0a, 0x1c, 0x53, 0x54, 0x41, 0x52, 0x54, 0x5f, 0x4f, 0x46,
	0x5f, 0x41, 0x43, 0x54, 0x49, 0x56, 0x49, 0x54, 0x59, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x52,
	0x55, 0x50, 0x54, 0x53, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x4e, 0x4f, 0x5f, 0x49, 0x4e, 0x54,
	0x45, 0x52, 0x52, 0x55, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x22, 0x6b, 0x0a, 0x0c, 0x54,
	0x75, 0x72, 0x6e, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x54,
	0x55, 0x52, 0x4e, 0x5f, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x41, 0x47, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1f, 0x0a, 0x1b, 0x54, 0x55,
	0x52, 0x4e, 0x5f, 0x49, 0x4e, 0x43, 0x4c, 0x55, 0x44, 0x45, 0x53, 0x5f, 0x4f, 0x4e, 0x4c, 0x59,
	0x5f, 0x41, 0x43, 0x54, 0x49, 0x56, 0x49, 0x54, 0x59, 0x10, 0x01, 0x12, 0x1b, 0x0a, 0x17, 0x54,
	0x55, 0x52, 0x4e, 0x5f, 0x49, 0x4e, 0x43, 0x4c, 0x55, 0x44, 0x45, 0x53, 0x5f, 0x41, 0x4c, 0x4c,
	0x5f, 0x49, 0x4e, 0x50, 0x55, 0x54, 0x10, 0x02, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x61, 0x63, 0x74,
	0x69, 0x76, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x69, 0x6e, 0x67, 0x42, 0x10,
	0x0a, 0x0e, 0x5f, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65,
	0x22, 0x41, 0x0a, 0x17, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6d,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1b, 0x0a, 0x06, 0x68,
	0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x06, 0x68,
	0x61, 0x6e, 0x64, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x68, 0x61, 0x6e,
	0x64, 0x6c, 0x65, 0x22, 0xc1, 0x02, 0x0a, 0x1e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x57,
	0x69, 0x6e, 0x64, 0x6f, 0x77, 0x43, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7a, 0x0a, 0x0e, 0x73, 0x6c, 0x69, 0x64, 0x69, 0x6e,
	0x67, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x51,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x57, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x43, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x53, 0x6c, 0x69, 0x64, 0x69, 0x6e, 0x67, 0x57, 0x69, 0x6e, 0x64, 0x6f,
	0x77, 0x48, 0x00, 0x52, 0x0d, 0x73, 0x6c, 0x69, 0x64, 0x69, 0x6e, 0x67, 0x57, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x12, 0x2a, 0x0a, 0x0e, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x01, 0x52, 0x0d, 0x74, 0x72,
	0x69, 0x67, 0x67, 0x65, 0x72, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x1a, 0x4b,
	0x0a, 0x0d, 0x53, 0x6c, 0x69, 0x64, 0x69, 0x6e, 0x67, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12,
	0x28, 0x0a, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x0c, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x42, 0x17, 0x0a, 0x15, 0x63,
	0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x63, 0x68, 0x61,
	0x6e, 0x69, 0x73, 0x6d, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x22, 0x1a, 0x0a, 0x18, 0x41, 0x75, 0x64, 0x69, 0x6f,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x22, 0xb7, 0x06, 0x0a, 0x18, 0x42, 0x69, 0x64, 0x69, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x75, 0x70,
	0x12, 0x19, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x67, 0x0a, 0x11, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x60, 0x0a, 0x12, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x69,
	0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x11, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x44, 0x0a, 0x05, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x54, 0x6f, 0x6f, 0x6c,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x71, 0x0a, 0x15,
	0x72, 0x65, 0x61, 0x6c, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x52, 0x65, 0x61, 0x6c, 0x74, 0x69, 0x6d, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x72, 0x65, 0x61, 0x6c,
	0x74, 0x69, 0x6d, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x70, 0x0a, 0x12, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6d,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11,
	0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x86, 0x01, 0x0a, 0x1a, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x77, 0x69,
	0x6e, 0x64, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x43, 0x6f, 0x6d, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x18, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x43,
	0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x80, 0x01, 0x0a, 0x1a, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x18, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x95, 0x01,
	0x0a, 0x20, 0x42, 0x69, 0x64, 0x69, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x12, 0x47, 0x0a, 0x05, 0x74, 0x75, 0x72, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x74, 0x75, 0x72, 0x6e, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x74,
	0x75, 0x72, 0x6e, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x74, 0x75, 0x72, 0x6e, 0x43, 0x6f, 0x6d,
	0x70, 0x6c, 0x65, 0x74, 0x65, 0x22, 0x8d, 0x05, 0x0a, 0x20, 0x42, 0x69, 0x64, 0x69, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x61,
	0x6c, 0x74, 0x69, 0x6d, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x51, 0x0a, 0x0c, 0x6d, 0x65,
	0x64, 0x69, 0x61, 0x5f, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x6c, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0b, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x12, 0x44, 0x0a,
	0x05, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x42, 0x6c, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x61, 0x75,
	0x64, 0x69, 0x6f, 0x12, 0x32, 0x0a, 0x10, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x5f, 0x65, 0x6e, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x48, 0x00, 0x52, 0x0e, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x45, 0x6e, 0x64, 0x88, 0x01, 0x01, 0x12, 0x44, 0x0a, 0x05, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x6c, 0x6f,
	0x62, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x12, 0x1c, 0x0a,
	0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x01, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x88, 0x01, 0x01, 0x12, 0x7f, 0x0a, 0x0e, 0x61,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x69, 0x64, 0x69, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x61,
	0x6c, 0x74, 0x69, 0x6d, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x53, 0x74, 0x61, 0x72, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x61,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x53, 0x74, 0x61, 0x72, 0x74, 0x12, 0x79, 0x0a, 0x0c,
	0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x5f, 0x65, 0x6e, 0x64, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x69, 0x64, 0x69, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x61, 0x6c,
	0x74, 0x69, 0x6d, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x45, 0x6e, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x63, 0x74, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x45, 0x6e, 0x64, 0x1a, 0x0f, 0x0a, 0x0d, 0x41, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x53, 0x74, 0x61, 0x72, 0x74, 0x1a, 0x0d, 0x0a, 0x0b, 0x41, 0x63, 0x74, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x45, 0x6e, 0x64, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x61, 0x75, 0x64, 0x69,
	0x6f, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x65, 0x6e, 0x64, 0x42, 0x07, 0x0a, 0x05,
	0x5f, 0x74, 0x65, 0x78, 0x74, 0x22, 0x8c, 0x01, 0x0a, 0x1f, 0x42, 0x69, 0x64, 0x69, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x6f,
	0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x69, 0x0a, 0x12, 0x66, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x11, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x73, 0x22, 0xea, 0x03, 0x0a, 0x20, 0x42, 0x69, 0x64, 0x69, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x43, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x5a, 0x0a, 0x05, 0x73, 0x65, 0x74,
	0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42,
	0x69, 0x64, 0x69, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x53, 0x65, 0x74, 0x75, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x05,
	0x73, 0x65, 0x74, 0x75, 0x70, 0x12, 0x73, 0x0a, 0x0e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x42, 0x69, 0x64, 0x69, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0d, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x73, 0x0a, 0x0e, 0x72, 0x65,
	0x61, 0x6c, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x69, 0x64, 0x69, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x61, 0x6c,
	0x74, 0x69, 0x6d, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00,
	0x52, 0x0d, 0x72, 0x65, 0x61, 0x6c, 0x74, 0x69, 0x6d, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12,
	0x70, 0x0a, 0x0d, 0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x69, 0x64,
	0x69, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x00, 0x52, 0x0c, 0x74, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x42, 0x0e, 0x0a, 0x0c, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x22, 0x22, 0x0a, 0x20, 0x42, 0x69, 0x64, 0x69, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x75, 0x70, 0x43, 0x6f, 0x6d,
	0x70, 0x6c, 0x65, 0x74, 0x65, 0x22, 0xfa, 0x03, 0x0a, 0x20, 0x42, 0x69, 0x64, 0x69, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x55, 0x0a, 0x0a, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x5f, 0x74, 0x75, 0x72, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x48, 0x00, 0x52, 0x09, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x54, 0x75, 0x72, 0x6e, 0x88, 0x01,
	0x01, 0x12, 0x34, 0x0a, 0x13, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x12, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x74, 0x75, 0x72, 0x6e, 0x5f,
	0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0c, 0x74, 0x75, 0x72, 0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74,
	0x65, 0x12, 0x25, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x72, 0x75, 0x70, 0x74, 0x65, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x72, 0x75, 0x70, 0x74, 0x65, 0x64, 0x12, 0x6a, 0x0a, 0x12, 0x67, 0x72, 0x6f, 0x75,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69,
	0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x11, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x7d, 0x0a, 0x14, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x69, 0x64, 0x69, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x74, 0x75,
	0x72, 0x6e, 0x22, 0x7c, 0x0a, 0x1b, 0x42, 0x69, 0x64, 0x69, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x43, 0x61, 0x6c,
	0x6c, 0x12, 0x5d, 0x0a, 0x0e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x61,
	0x6c, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x6c, 0x6c, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0d, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x6c, 0x6c, 0x73,
	0x22, 0x40, 0x0a, 0x27, 0x42, 0x69, 0x64, 0x69, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x43, 0x61, 0x6c, 0x6c, 0x43,
	0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x15, 0x0a, 0x03, 0x69,
	0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x69,
	0x64, 0x73, 0x22, 0x40, 0x0a, 0x06, 0x47, 0x6f, 0x41, 0x77, 0x61, 0x79, 0x12, 0x36, 0x0a, 0x09,
	0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6c, 0x65, 0x66, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x74, 0x69, 0x6d, 0x65,
	0x4c, 0x65, 0x66, 0x74, 0x22, 0x56, 0x0a, 0x17, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x75, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x6e, 0x65, 0x77, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x6e, 0x65, 0x77, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x12, 0x1c,
	0x0a, 0x09, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x09, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x36, 0x0a, 0x20,
	0x42, 0x69, 0x64, 0x69, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x12, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x74, 0x65, 0x78, 0x74, 0x22, 0xbc, 0x06, 0x0a, 0x20, 0x42, 0x69, 0x64, 0x69, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x73, 0x0a, 0x0e, 0x73, 0x65, 0x74,
	0x75, 0x70, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x69, 0x64, 0x69, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x75, 0x70,
	0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52,
	0x0d, 0x73, 0x65, 0x74, 0x75, 0x70, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x73,
	0x0a, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x69, 0x64,
	0x69, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x48, 0x00, 0x52, 0x0d, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x12, 0x64, 0x0a, 0x09, 0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x63, 0x61, 0x6c, 0x6c,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x69, 0x64,
	0x69, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x54, 0x6f, 0x6f, 0x6c, 0x43, 0x61, 0x6c, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52,
	0x08, 0x74, 0x6f, 0x6f, 0x6c, 0x43, 0x61, 0x6c, 0x6c, 0x12, 0x89, 0x01, 0x0a, 0x16, 0x74, 0x6f,
	0x6f, 0x6c, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x42, 0x69, 0x64, 0x69, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x43, 0x61, 0x6c, 0x6c, 0x43, 0x61, 0x6e, 0x63,
	0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52,
	0x14, 0x74, 0x6f, 0x6f, 0x6c, 0x43, 0x61, 0x6c, 0x6c, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4b, 0x0a, 0x07, 0x67, 0x6f, 0x5f, 0x61, 0x77, 0x61, 0x79,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x6f, 0x41,
	0x77, 0x61, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x06, 0x67, 0x6f, 0x41, 0x77,
	0x61, 0x79, 0x12, 0x7f, 0x0a, 0x19, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65,
	0x73, 0x75, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x17, 0x73, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x12, 0x5e, 0x0a, 0x0e, 0x75, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x55, 0x73, 0x61, 0x67, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x75, 0x73, 0x61, 0x67, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x42, 0x0e, 0x0a, 0x0c, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x22, 0xbc, 0x06, 0x0a, 0x0d, 0x55, 0x73, 0x61, 0x67, 0x65, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x31, 0x0a, 0x12, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3b, 0x0a, 0x1a, 0x63, 0x61, 0x63, 0x68,
	0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x17, 0x63, 0x61,
	0x63, 0x68, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x35, 0x0a, 0x14, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x41, 0x0a, 0x1b,
	0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x74, 0x6f, 0x6f, 0x6c, 0x55, 0x73, 0x65, 0x50,
	0x72, 0x6f, 0x6d, 0x70, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x35, 0x0a, 0x14, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68, 0x74, 0x73, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x12, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68, 0x74, 0x73, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2f, 0x0a, 0x11, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x70, 0x0a, 0x15, 0x70, 0x72, 0x6f, 0x6d, 0x70,
	0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x6f, 0x64,
	0x61, 0x6c, 0x69, 0x74, 0x79, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x6e, 0x0a, 0x14, 0x63, 0x61, 0x63,
	0x68, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x6f,
	0x64, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x63, 0x61, 0x63, 0x68, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x74, 0x0a, 0x17, 0x72, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x5f, 0x64, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x4d, 0x6f, 0x64, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12,
	0x80, 0x01, 0x0a, 0x1e, 0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x70, 0x72, 0x6f,
	0x6d, 0x70, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d,
	0x6f, 0x64, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1a, 0x74, 0x6f, 0x6f, 0x6c, 0x55, 0x73, 0x65, 0x50,
	0x72, 0x6f, 0x6d, 0x70, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x2a, 0xd8, 0x01, 0x0a, 0x08, 0x54, 0x61, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x19, 0x0a, 0x15, 0x54, 0x41, 0x53, 0x4b, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x52, 0x45,
	0x54, 0x52, 0x49, 0x45, 0x56, 0x41, 0x4c, 0x5f, 0x51, 0x55, 0x45, 0x52, 0x59, 0x10, 0x01, 0x12,
	0x16, 0x0a, 0x12, 0x52, 0x45, 0x54, 0x52, 0x49, 0x45, 0x56, 0x41, 0x4c, 0x5f, 0x44, 0x4f, 0x43,
	0x55, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x53, 0x45, 0x4d, 0x41, 0x4e,
	0x54, 0x49, 0x43, 0x5f, 0x53, 0x49, 0x4d, 0x49, 0x4c, 0x41, 0x52, 0x49, 0x54, 0x59, 0x10, 0x03,
	0x12, 0x12, 0x0a, 0x0e, 0x43, 0x4c, 0x41, 0x53, 0x53, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x10, 0x04, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x4c, 0x55, 0x53, 0x54, 0x45, 0x52, 0x49,
	0x4e, 0x47, 0x10, 0x05, 0x12, 0x16, 0x0a, 0x12, 0x51, 0x55, 0x45, 0x53, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x41, 0x4e, 0x53, 0x57, 0x45, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x06, 0x12, 0x15, 0x0a, 0x11,
	0x46, 0x41, 0x43, 0x54, 0x5f, 0x56, 0x45, 0x52, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x10, 0x07, 0x12, 0x18, 0x0a, 0x14, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x52, 0x45, 0x54, 0x52,
	0x49, 0x45, 0x56, 0x41, 0x4c, 0x5f, 0x51, 0x55, 0x45, 0x52, 0x59, 0x10, 0x08, 0x32, 0xd1, 0x0d,
	0x0a, 0x11, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x12, 0xb8, 0x02, 0x0a, 0x0f, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69,
	0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0xa9, 0x01, 0xda, 0x41, 0x0e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2c, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x91, 0x01, 0x3a, 0x01, 0x2a,
	0x5a, 0x32, 0x3a, 0x01, 0x2a, 0x22, 0x2d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x3d, 0x74, 0x75, 0x6e, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x5a, 0x2e, 0x3a, 0x01, 0x2a, 0x22, 0x29, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2f, 0x7b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x3d, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69,
	0x63, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x22, 0x28, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x3d, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0xeb,
	0x01, 0x0a, 0x0e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x73, 0x77, 0x65,
	0x72, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65,
	0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x73, 0x77,
	0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x60, 0xda, 0x41, 0x2b, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x2c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x2c, 0x73, 0x61,
	0x66, 0x65, 0x74, 0x79, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2c, 0x61, 0x6e,
	0x73, 0x77, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c,
	0x3a, 0x01, 0x2a, 0x22, 0x27, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x3d, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x12, 0xd2, 0x02, 0x0a,
	0x15, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0xbb, 0x01, 0xda, 0x41, 0x0e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2c, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xa3, 0x01, 0x3a, 0x01, 0x2a, 0x5a,
	0x38, 0x3a, 0x01, 0x2a, 0x22, 0x33, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x3d, 0x74, 0x75, 0x6e, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5a, 0x34, 0x3a, 0x01, 0x2a, 0x22, 0x2f,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x3d, 0x64,
	0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22,
	0x2e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x3d,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x30,
	0x01, 0x12, 0xc5, 0x01, 0x0a, 0x0c, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x40, 0xda, 0x41, 0x0d, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x2c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x3a,
	0x01, 0x2a, 0x22, 0x25, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x3d, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x65, 0x6d, 0x62,
	0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0xde, 0x01, 0x0a, 0x12, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73,
	0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x45, 0x6d, 0x62, 0x65,
	0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x45, 0x6d, 0x62, 0x65,
	0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x47, 0xda, 0x41, 0x0e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2c, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x3a, 0x01, 0x2a, 0x22, 0x2b, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x3d, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x45, 0x6d, 0x62,
	0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xc2, 0x01, 0x0a, 0x0b, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x40, 0xda,
	0x41, 0x0e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x29, 0x3a, 0x01, 0x2a, 0x22, 0x24, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2f, 0x7b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x3d, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x12,
	0xa9, 0x01, 0x0a, 0x13, 0x42, 0x69, 0x64, 0x69, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x69,
	0x64, 0x69, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x1a, 0x45,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x69, 0x64, 0x69, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x00, 0x28, 0x01, 0x30, 0x01, 0x1a, 0x24, 0xca, 0x41, 0x21,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x42, 0xa2, 0x01, 0x0a, 0x27, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x16, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x5d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x2f,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x70,
	0x62, 0x3b, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescOnce sync.Once
	file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescData = file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDesc
)

func file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescGZIP() []byte {
	file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescOnce.Do(func() {
		file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescData)
	})
	return file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDescData
}

var file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes = make([]protoimpl.EnumInfo, 11)
var file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes = make([]protoimpl.MessageInfo, 57)
var file_google_ai_generativelanguage_v1beta_generative_service_proto_goTypes = []any{
	(TaskType)(0),                                                        // 0: google.ai.generativelanguage.v1beta.TaskType
	(GenerationConfig_Modality)(0),                                       // 1: google.ai.generativelanguage.v1beta.GenerationConfig.Modality
	(GenerationConfig_MediaResolution)(0),                                // 2: google.ai.generativelanguage.v1beta.GenerationConfig.MediaResolution
	(GenerateContentResponse_PromptFeedback_BlockReason)(0),              // 3: google.ai.generativelanguage.v1beta.GenerateContentResponse.PromptFeedback.BlockReason
	(Candidate_FinishReason)(0),                                          // 4: google.ai.generativelanguage.v1beta.Candidate.FinishReason
	(GenerateAnswerRequest_AnswerStyle)(0),                               // 5: google.ai.generativelanguage.v1beta.GenerateAnswerRequest.AnswerStyle
	(GenerateAnswerResponse_InputFeedback_BlockReason)(0),                // 6: google.ai.generativelanguage.v1beta.GenerateAnswerResponse.InputFeedback.BlockReason
	(RealtimeInputConfig_ActivityHandling)(0),                            // 7: google.ai.generativelanguage.v1beta.RealtimeInputConfig.ActivityHandling
	(RealtimeInputConfig_TurnCoverage)(0),                                // 8: google.ai.generativelanguage.v1beta.RealtimeInputConfig.TurnCoverage
	(RealtimeInputConfig_AutomaticActivityDetection_StartSensitivity)(0), // 9: google.ai.generativelanguage.v1beta.RealtimeInputConfig.AutomaticActivityDetection.StartSensitivity
	(RealtimeInputConfig_AutomaticActivityDetection_EndSensitivity)(0),   // 10: google.ai.generativelanguage.v1beta.RealtimeInputConfig.AutomaticActivityDetection.EndSensitivity
	(*GenerateContentRequest)(nil),                                       // 11: google.ai.generativelanguage.v1beta.GenerateContentRequest
	(*PrebuiltVoiceConfig)(nil),                                          // 12: google.ai.generativelanguage.v1beta.PrebuiltVoiceConfig
	(*VoiceConfig)(nil),                                                  // 13: google.ai.generativelanguage.v1beta.VoiceConfig
	(*SpeechConfig)(nil),                                                 // 14: google.ai.generativelanguage.v1beta.SpeechConfig
	(*ThinkingConfig)(nil),                                               // 15: google.ai.generativelanguage.v1beta.ThinkingConfig
	(*GenerationConfig)(nil),                                             // 16: google.ai.generativelanguage.v1beta.GenerationConfig
	(*SemanticRetrieverConfig)(nil),                                      // 17: google.ai.generativelanguage.v1beta.SemanticRetrieverConfig
	(*GenerateContentResponse)(nil),                                      // 18: google.ai.generativelanguage.v1beta.GenerateContentResponse
	(*Candidate)(nil),                                                    // 19: google.ai.generativelanguage.v1beta.Candidate
	(*LogprobsResult)(nil),                                               // 20: google.ai.generativelanguage.v1beta.LogprobsResult
	(*AttributionSourceId)(nil),                                          // 21: google.ai.generativelanguage.v1beta.AttributionSourceId
	(*GroundingAttribution)(nil),                                         // 22: google.ai.generativelanguage.v1beta.GroundingAttribution
	(*RetrievalMetadata)(nil),                                            // 23: google.ai.generativelanguage.v1beta.RetrievalMetadata
	(*GroundingMetadata)(nil),                                            // 24: google.ai.generativelanguage.v1beta.GroundingMetadata
	(*SearchEntryPoint)(nil),                                             // 25: google.ai.generativelanguage.v1beta.SearchEntryPoint
	(*GroundingChunk)(nil),                                               // 26: google.ai.generativelanguage.v1beta.GroundingChunk
	(*Segment)(nil),                                                      // 27: google.ai.generativelanguage.v1beta.Segment
	(*GroundingSupport)(nil),                                             // 28: google.ai.generativelanguage.v1beta.GroundingSupport
	(*GenerateAnswerRequest)(nil),                                        // 29: google.ai.generativelanguage.v1beta.GenerateAnswerRequest
	(*GenerateAnswerResponse)(nil),                                       // 30: google.ai.generativelanguage.v1beta.GenerateAnswerResponse
	(*EmbedContentRequest)(nil),                                          // 31: google.ai.generativelanguage.v1beta.EmbedContentRequest
	(*ContentEmbedding)(nil),                                             // 32: google.ai.generativelanguage.v1beta.ContentEmbedding
	(*EmbedContentResponse)(nil),                                         // 33: google.ai.generativelanguage.v1beta.EmbedContentResponse
	(*BatchEmbedContentsRequest)(nil),                                    // 34: google.ai.generativelanguage.v1beta.BatchEmbedContentsRequest
	(*BatchEmbedContentsResponse)(nil),                                   // 35: google.ai.generativelanguage.v1beta.BatchEmbedContentsResponse
	(*CountTokensRequest)(nil),                                           // 36: google.ai.generativelanguage.v1beta.CountTokensRequest
	(*CountTokensResponse)(nil),                                          // 37: google.ai.generativelanguage.v1beta.CountTokensResponse
	(*RealtimeInputConfig)(nil),                                          // 38: google.ai.generativelanguage.v1beta.RealtimeInputConfig
	(*SessionResumptionConfig)(nil),                                      // 39: google.ai.generativelanguage.v1beta.SessionResumptionConfig
	(*ContextWindowCompressionConfig)(nil),                               // 40: google.ai.generativelanguage.v1beta.ContextWindowCompressionConfig
	(*AudioTranscriptionConfig)(nil),                                     // 41: google.ai.generativelanguage.v1beta.AudioTranscriptionConfig
	(*BidiGenerateContentSetup)(nil),                                     // 42: google.ai.generativelanguage.v1beta.BidiGenerateContentSetup
	(*BidiGenerateContentClientContent)(nil),                             // 43: google.ai.generativelanguage.v1beta.BidiGenerateContentClientContent
	(*BidiGenerateContentRealtimeInput)(nil),                             // 44: google.ai.generativelanguage.v1beta.BidiGenerateContentRealtimeInput
	(*BidiGenerateContentToolResponse)(nil),                              // 45: google.ai.generativelanguage.v1beta.BidiGenerateContentToolResponse
	(*BidiGenerateContentClientMessage)(nil),                             // 46: google.ai.generativelanguage.v1beta.BidiGenerateContentClientMessage
	(*BidiGenerateContentSetupComplete)(nil),                             // 47: google.ai.generativelanguage.v1beta.BidiGenerateContentSetupComplete
	(*BidiGenerateContentServerContent)(nil),                             // 48: google.ai.generativelanguage.v1beta.BidiGenerateContentServerContent
	(*BidiGenerateContentToolCall)(nil),                                  // 49: google.ai.generativelanguage.v1beta.BidiGenerateContentToolCall
	(*BidiGenerateContentToolCallCancellation)(nil),                      // 50: google.ai.generativelanguage.v1beta.BidiGenerateContentToolCallCancellation
	(*GoAway)(nil),                                                       // 51: google.ai.generativelanguage.v1beta.GoAway
	(*SessionResumptionUpdate)(nil),                                      // 52: google.ai.generativelanguage.v1beta.SessionResumptionUpdate
	(*BidiGenerateContentTranscription)(nil),                             // 53: google.ai.generativelanguage.v1beta.BidiGenerateContentTranscription
	(*BidiGenerateContentServerMessage)(nil),                             // 54: google.ai.generativelanguage.v1beta.BidiGenerateContentServerMessage
	(*UsageMetadata)(nil),                                                // 55: google.ai.generativelanguage.v1beta.UsageMetadata
	(*GenerateContentResponse_PromptFeedback)(nil),                       // 56: google.ai.generativelanguage.v1beta.GenerateContentResponse.PromptFeedback
	(*GenerateContentResponse_UsageMetadata)(nil),                        // 57: google.ai.generativelanguage.v1beta.GenerateContentResponse.UsageMetadata
	(*LogprobsResult_Candidate)(nil),                                     // 58: google.ai.generativelanguage.v1beta.LogprobsResult.Candidate
	(*LogprobsResult_TopCandidates)(nil),                                 // 59: google.ai.generativelanguage.v1beta.LogprobsResult.TopCandidates
	(*AttributionSourceId_GroundingPassageId)(nil),                       // 60: google.ai.generativelanguage.v1beta.AttributionSourceId.GroundingPassageId
	(*AttributionSourceId_SemanticRetrieverChunk)(nil),                   // 61: google.ai.generativelanguage.v1beta.AttributionSourceId.SemanticRetrieverChunk
	(*GroundingChunk_Web)(nil),                                           // 62: google.ai.generativelanguage.v1beta.GroundingChunk.Web
	(*GenerateAnswerResponse_InputFeedback)(nil),                         // 63: google.ai.generativelanguage.v1beta.GenerateAnswerResponse.InputFeedback
	(*RealtimeInputConfig_AutomaticActivityDetection)(nil),               // 64: google.ai.generativelanguage.v1beta.RealtimeInputConfig.AutomaticActivityDetection
	(*ContextWindowCompressionConfig_SlidingWindow)(nil),                 // 65: google.ai.generativelanguage.v1beta.ContextWindowCompressionConfig.SlidingWindow
	(*BidiGenerateContentRealtimeInput_ActivityStart)(nil),               // 66: google.ai.generativelanguage.v1beta.BidiGenerateContentRealtimeInput.ActivityStart
	(*BidiGenerateContentRealtimeInput_ActivityEnd)(nil),                 // 67: google.ai.generativelanguage.v1beta.BidiGenerateContentRealtimeInput.ActivityEnd
	(*Content)(nil),                                                      // 68: google.ai.generativelanguage.v1beta.Content
	(*Tool)(nil),                                                         // 69: google.ai.generativelanguage.v1beta.Tool
	(*ToolConfig)(nil),                                                   // 70: google.ai.generativelanguage.v1beta.ToolConfig
	(*SafetySetting)(nil),                                                // 71: google.ai.generativelanguage.v1beta.SafetySetting
	(*Schema)(nil),                                                       // 72: google.ai.generativelanguage.v1beta.Schema
	(*MetadataFilter)(nil),                                               // 73: google.ai.generativelanguage.v1beta.MetadataFilter
	(*SafetyRating)(nil),                                                 // 74: google.ai.generativelanguage.v1beta.SafetyRating
	(*CitationMetadata)(nil),                                             // 75: google.ai.generativelanguage.v1beta.CitationMetadata
	(*GroundingPassages)(nil),                                            // 76: google.ai.generativelanguage.v1beta.GroundingPassages
	(*ModalityTokenCount)(nil),                                           // 77: google.ai.generativelanguage.v1beta.ModalityTokenCount
	(*Blob)(nil),                                                         // 78: google.ai.generativelanguage.v1beta.Blob
	(*FunctionResponse)(nil),                                             // 79: google.ai.generativelanguage.v1beta.FunctionResponse
	(*FunctionCall)(nil),                                                 // 80: google.ai.generativelanguage.v1beta.FunctionCall
	(*durationpb.Duration)(nil),                                          // 81: google.protobuf.Duration
}
var file_google_ai_generativelanguage_v1beta_generative_service_proto_depIdxs = []int32{
	68,  // 0: google.ai.generativelanguage.v1beta.GenerateContentRequest.system_instruction:type_name -> google.ai.generativelanguage.v1beta.Content
	68,  // 1: google.ai.generativelanguage.v1beta.GenerateContentRequest.contents:type_name -> google.ai.generativelanguage.v1beta.Content
	69,  // 2: google.ai.generativelanguage.v1beta.GenerateContentRequest.tools:type_name -> google.ai.generativelanguage.v1beta.Tool
	70,  // 3: google.ai.generativelanguage.v1beta.GenerateContentRequest.tool_config:type_name -> google.ai.generativelanguage.v1beta.ToolConfig
	71,  // 4: google.ai.generativelanguage.v1beta.GenerateContentRequest.safety_settings:type_name -> google.ai.generativelanguage.v1beta.SafetySetting
	16,  // 5: google.ai.generativelanguage.v1beta.GenerateContentRequest.generation_config:type_name -> google.ai.generativelanguage.v1beta.GenerationConfig
	12,  // 6: google.ai.generativelanguage.v1beta.VoiceConfig.prebuilt_voice_config:type_name -> google.ai.generativelanguage.v1beta.PrebuiltVoiceConfig
	13,  // 7: google.ai.generativelanguage.v1beta.SpeechConfig.voice_config:type_name -> google.ai.generativelanguage.v1beta.VoiceConfig
	72,  // 8: google.ai.generativelanguage.v1beta.GenerationConfig.response_schema:type_name -> google.ai.generativelanguage.v1beta.Schema
	1,   // 9: google.ai.generativelanguage.v1beta.GenerationConfig.response_modalities:type_name -> google.ai.generativelanguage.v1beta.GenerationConfig.Modality
	14,  // 10: google.ai.generativelanguage.v1beta.GenerationConfig.speech_config:type_name -> google.ai.generativelanguage.v1beta.SpeechConfig
	15,  // 11: google.ai.generativelanguage.v1beta.GenerationConfig.thinking_config:type_name -> google.ai.generativelanguage.v1beta.ThinkingConfig
	2,   // 12: google.ai.generativelanguage.v1beta.GenerationConfig.media_resolution:type_name -> google.ai.generativelanguage.v1beta.GenerationConfig.MediaResolution
	68,  // 13: google.ai.generativelanguage.v1beta.SemanticRetrieverConfig.query:type_name -> google.ai.generativelanguage.v1beta.Content
	73,  // 14: google.ai.generativelanguage.v1beta.SemanticRetrieverConfig.metadata_filters:type_name -> google.ai.generativelanguage.v1beta.MetadataFilter
	19,  // 15: google.ai.generativelanguage.v1beta.GenerateContentResponse.candidates:type_name -> google.ai.generativelanguage.v1beta.Candidate
	56,  // 16: google.ai.generativelanguage.v1beta.GenerateContentResponse.prompt_feedback:type_name -> google.ai.generativelanguage.v1beta.GenerateContentResponse.PromptFeedback
	57,  // 17: google.ai.generativelanguage.v1beta.GenerateContentResponse.usage_metadata:type_name -> google.ai.generativelanguage.v1beta.GenerateContentResponse.UsageMetadata
	68,  // 18: google.ai.generativelanguage.v1beta.Candidate.content:type_name -> google.ai.generativelanguage.v1beta.Content
	4,   // 19: google.ai.generativelanguage.v1beta.Candidate.finish_reason:type_name -> google.ai.generativelanguage.v1beta.Candidate.FinishReason
	74,  // 20: google.ai.generativelanguage.v1beta.Candidate.safety_ratings:type_name -> google.ai.generativelanguage.v1beta.SafetyRating
	75,  // 21: google.ai.generativelanguage.v1beta.Candidate.citation_metadata:type_name -> google.ai.generativelanguage.v1beta.CitationMetadata
	22,  // 22: google.ai.generativelanguage.v1beta.Candidate.grounding_attributions:type_name -> google.ai.generativelanguage.v1beta.GroundingAttribution
	24,  // 23: google.ai.generativelanguage.v1beta.Candidate.grounding_metadata:type_name -> google.ai.generativelanguage.v1beta.GroundingMetadata
	20,  // 24: google.ai.generativelanguage.v1beta.Candidate.logprobs_result:type_name -> google.ai.generativelanguage.v1beta.LogprobsResult
	59,  // 25: google.ai.generativelanguage.v1beta.LogprobsResult.top_candidates:type_name -> google.ai.generativelanguage.v1beta.LogprobsResult.TopCandidates
	58,  // 26: google.ai.generativelanguage.v1beta.LogprobsResult.chosen_candidates:type_name -> google.ai.generativelanguage.v1beta.LogprobsResult.Candidate
	60,  // 27: google.ai.generativelanguage.v1beta.AttributionSourceId.grounding_passage:type_name -> google.ai.generativelanguage.v1beta.AttributionSourceId.GroundingPassageId
	61,  // 28: google.ai.generativelanguage.v1beta.AttributionSourceId.semantic_retriever_chunk:type_name -> google.ai.generativelanguage.v1beta.AttributionSourceId.SemanticRetrieverChunk
	21,  // 29: google.ai.generativelanguage.v1beta.GroundingAttribution.source_id:type_name -> google.ai.generativelanguage.v1beta.AttributionSourceId
	68,  // 30: google.ai.generativelanguage.v1beta.GroundingAttribution.content:type_name -> google.ai.generativelanguage.v1beta.Content
	25,  // 31: google.ai.generativelanguage.v1beta.GroundingMetadata.search_entry_point:type_name -> google.ai.generativelanguage.v1beta.SearchEntryPoint
	26,  // 32: google.ai.generativelanguage.v1beta.GroundingMetadata.grounding_chunks:type_name -> google.ai.generativelanguage.v1beta.GroundingChunk
	28,  // 33: google.ai.generativelanguage.v1beta.GroundingMetadata.grounding_supports:type_name -> google.ai.generativelanguage.v1beta.GroundingSupport
	23,  // 34: google.ai.generativelanguage.v1beta.GroundingMetadata.retrieval_metadata:type_name -> google.ai.generativelanguage.v1beta.RetrievalMetadata
	62,  // 35: google.ai.generativelanguage.v1beta.GroundingChunk.web:type_name -> google.ai.generativelanguage.v1beta.GroundingChunk.Web
	27,  // 36: google.ai.generativelanguage.v1beta.GroundingSupport.segment:type_name -> google.ai.generativelanguage.v1beta.Segment
	76,  // 37: google.ai.generativelanguage.v1beta.GenerateAnswerRequest.inline_passages:type_name -> google.ai.generativelanguage.v1beta.GroundingPassages
	17,  // 38: google.ai.generativelanguage.v1beta.GenerateAnswerRequest.semantic_retriever:type_name -> google.ai.generativelanguage.v1beta.SemanticRetrieverConfig
	68,  // 39: google.ai.generativelanguage.v1beta.GenerateAnswerRequest.contents:type_name -> google.ai.generativelanguage.v1beta.Content
	5,   // 40: google.ai.generativelanguage.v1beta.GenerateAnswerRequest.answer_style:type_name -> google.ai.generativelanguage.v1beta.GenerateAnswerRequest.AnswerStyle
	71,  // 41: google.ai.generativelanguage.v1beta.GenerateAnswerRequest.safety_settings:type_name -> google.ai.generativelanguage.v1beta.SafetySetting
	19,  // 42: google.ai.generativelanguage.v1beta.GenerateAnswerResponse.answer:type_name -> google.ai.generativelanguage.v1beta.Candidate
	63,  // 43: google.ai.generativelanguage.v1beta.GenerateAnswerResponse.input_feedback:type_name -> google.ai.generativelanguage.v1beta.GenerateAnswerResponse.InputFeedback
	68,  // 44: google.ai.generativelanguage.v1beta.EmbedContentRequest.content:type_name -> google.ai.generativelanguage.v1beta.Content
	0,   // 45: google.ai.generativelanguage.v1beta.EmbedContentRequest.task_type:type_name -> google.ai.generativelanguage.v1beta.TaskType
	32,  // 46: google.ai.generativelanguage.v1beta.EmbedContentResponse.embedding:type_name -> google.ai.generativelanguage.v1beta.ContentEmbedding
	31,  // 47: google.ai.generativelanguage.v1beta.BatchEmbedContentsRequest.requests:type_name -> google.ai.generativelanguage.v1beta.EmbedContentRequest
	32,  // 48: google.ai.generativelanguage.v1beta.BatchEmbedContentsResponse.embeddings:type_name -> google.ai.generativelanguage.v1beta.ContentEmbedding
	68,  // 49: google.ai.generativelanguage.v1beta.CountTokensRequest.contents:type_name -> google.ai.generativelanguage.v1beta.Content
	11,  // 50: google.ai.generativelanguage.v1beta.CountTokensRequest.generate_content_request:type_name -> google.ai.generativelanguage.v1beta.GenerateContentRequest
	77,  // 51: google.ai.generativelanguage.v1beta.CountTokensResponse.prompt_tokens_details:type_name -> google.ai.generativelanguage.v1beta.ModalityTokenCount
	77,  // 52: google.ai.generativelanguage.v1beta.CountTokensResponse.cache_tokens_details:type_name -> google.ai.generativelanguage.v1beta.ModalityTokenCount
	64,  // 53: google.ai.generativelanguage.v1beta.RealtimeInputConfig.automatic_activity_detection:type_name -> google.ai.generativelanguage.v1beta.RealtimeInputConfig.AutomaticActivityDetection
	7,   // 54: google.ai.generativelanguage.v1beta.RealtimeInputConfig.activity_handling:type_name -> google.ai.generativelanguage.v1beta.RealtimeInputConfig.ActivityHandling
	8,   // 55: google.ai.generativelanguage.v1beta.RealtimeInputConfig.turn_coverage:type_name -> google.ai.generativelanguage.v1beta.RealtimeInputConfig.TurnCoverage
	65,  // 56: google.ai.generativelanguage.v1beta.ContextWindowCompressionConfig.sliding_window:type_name -> google.ai.generativelanguage.v1beta.ContextWindowCompressionConfig.SlidingWindow
	16,  // 57: google.ai.generativelanguage.v1beta.BidiGenerateContentSetup.generation_config:type_name -> google.ai.generativelanguage.v1beta.GenerationConfig
	68,  // 58: google.ai.generativelanguage.v1beta.BidiGenerateContentSetup.system_instruction:type_name -> google.ai.generativelanguage.v1beta.Content
	69,  // 59: google.ai.generativelanguage.v1beta.BidiGenerateContentSetup.tools:type_name -> google.ai.generativelanguage.v1beta.Tool
	38,  // 60: google.ai.generativelanguage.v1beta.BidiGenerateContentSetup.realtime_input_config:type_name -> google.ai.generativelanguage.v1beta.RealtimeInputConfig
	39,  // 61: google.ai.generativelanguage.v1beta.BidiGenerateContentSetup.session_resumption:type_name -> google.ai.generativelanguage.v1beta.SessionResumptionConfig
	40,  // 62: google.ai.generativelanguage.v1beta.BidiGenerateContentSetup.context_window_compression:type_name -> google.ai.generativelanguage.v1beta.ContextWindowCompressionConfig
	41,  // 63: google.ai.generativelanguage.v1beta.BidiGenerateContentSetup.output_audio_transcription:type_name -> google.ai.generativelanguage.v1beta.AudioTranscriptionConfig
	68,  // 64: google.ai.generativelanguage.v1beta.BidiGenerateContentClientContent.turns:type_name -> google.ai.generativelanguage.v1beta.Content
	78,  // 65: google.ai.generativelanguage.v1beta.BidiGenerateContentRealtimeInput.media_chunks:type_name -> google.ai.generativelanguage.v1beta.Blob
	78,  // 66: google.ai.generativelanguage.v1beta.BidiGenerateContentRealtimeInput.audio:type_name -> google.ai.generativelanguage.v1beta.Blob
	78,  // 67: google.ai.generativelanguage.v1beta.BidiGenerateContentRealtimeInput.video:type_name -> google.ai.generativelanguage.v1beta.Blob
	66,  // 68: google.ai.generativelanguage.v1beta.BidiGenerateContentRealtimeInput.activity_start:type_name -> google.ai.generativelanguage.v1beta.BidiGenerateContentRealtimeInput.ActivityStart
	67,  // 69: google.ai.generativelanguage.v1beta.BidiGenerateContentRealtimeInput.activity_end:type_name -> google.ai.generativelanguage.v1beta.BidiGenerateContentRealtimeInput.ActivityEnd
	79,  // 70: google.ai.generativelanguage.v1beta.BidiGenerateContentToolResponse.function_responses:type_name -> google.ai.generativelanguage.v1beta.FunctionResponse
	42,  // 71: google.ai.generativelanguage.v1beta.BidiGenerateContentClientMessage.setup:type_name -> google.ai.generativelanguage.v1beta.BidiGenerateContentSetup
	43,  // 72: google.ai.generativelanguage.v1beta.BidiGenerateContentClientMessage.client_content:type_name -> google.ai.generativelanguage.v1beta.BidiGenerateContentClientContent
	44,  // 73: google.ai.generativelanguage.v1beta.BidiGenerateContentClientMessage.realtime_input:type_name -> google.ai.generativelanguage.v1beta.BidiGenerateContentRealtimeInput
	45,  // 74: google.ai.generativelanguage.v1beta.BidiGenerateContentClientMessage.tool_response:type_name -> google.ai.generativelanguage.v1beta.BidiGenerateContentToolResponse
	68,  // 75: google.ai.generativelanguage.v1beta.BidiGenerateContentServerContent.model_turn:type_name -> google.ai.generativelanguage.v1beta.Content
	24,  // 76: google.ai.generativelanguage.v1beta.BidiGenerateContentServerContent.grounding_metadata:type_name -> google.ai.generativelanguage.v1beta.GroundingMetadata
	53,  // 77: google.ai.generativelanguage.v1beta.BidiGenerateContentServerContent.output_transcription:type_name -> google.ai.generativelanguage.v1beta.BidiGenerateContentTranscription
	80,  // 78: google.ai.generativelanguage.v1beta.BidiGenerateContentToolCall.function_calls:type_name -> google.ai.generativelanguage.v1beta.FunctionCall
	81,  // 79: google.ai.generativelanguage.v1beta.GoAway.time_left:type_name -> google.protobuf.Duration
	47,  // 80: google.ai.generativelanguage.v1beta.BidiGenerateContentServerMessage.setup_complete:type_name -> google.ai.generativelanguage.v1beta.BidiGenerateContentSetupComplete
	48,  // 81: google.ai.generativelanguage.v1beta.BidiGenerateContentServerMessage.server_content:type_name -> google.ai.generativelanguage.v1beta.BidiGenerateContentServerContent
	49,  // 82: google.ai.generativelanguage.v1beta.BidiGenerateContentServerMessage.tool_call:type_name -> google.ai.generativelanguage.v1beta.BidiGenerateContentToolCall
	50,  // 83: google.ai.generativelanguage.v1beta.BidiGenerateContentServerMessage.tool_call_cancellation:type_name -> google.ai.generativelanguage.v1beta.BidiGenerateContentToolCallCancellation
	51,  // 84: google.ai.generativelanguage.v1beta.BidiGenerateContentServerMessage.go_away:type_name -> google.ai.generativelanguage.v1beta.GoAway
	52,  // 85: google.ai.generativelanguage.v1beta.BidiGenerateContentServerMessage.session_resumption_update:type_name -> google.ai.generativelanguage.v1beta.SessionResumptionUpdate
	55,  // 86: google.ai.generativelanguage.v1beta.BidiGenerateContentServerMessage.usage_metadata:type_name -> google.ai.generativelanguage.v1beta.UsageMetadata
	77,  // 87: google.ai.generativelanguage.v1beta.UsageMetadata.prompt_tokens_details:type_name -> google.ai.generativelanguage.v1beta.ModalityTokenCount
	77,  // 88: google.ai.generativelanguage.v1beta.UsageMetadata.cache_tokens_details:type_name -> google.ai.generativelanguage.v1beta.ModalityTokenCount
	77,  // 89: google.ai.generativelanguage.v1beta.UsageMetadata.response_tokens_details:type_name -> google.ai.generativelanguage.v1beta.ModalityTokenCount
	77,  // 90: google.ai.generativelanguage.v1beta.UsageMetadata.tool_use_prompt_tokens_details:type_name -> google.ai.generativelanguage.v1beta.ModalityTokenCount
	3,   // 91: google.ai.generativelanguage.v1beta.GenerateContentResponse.PromptFeedback.block_reason:type_name -> google.ai.generativelanguage.v1beta.GenerateContentResponse.PromptFeedback.BlockReason
	74,  // 92: google.ai.generativelanguage.v1beta.GenerateContentResponse.PromptFeedback.safety_ratings:type_name -> google.ai.generativelanguage.v1beta.SafetyRating
	77,  // 93: google.ai.generativelanguage.v1beta.GenerateContentResponse.UsageMetadata.prompt_tokens_details:type_name -> google.ai.generativelanguage.v1beta.ModalityTokenCount
	77,  // 94: google.ai.generativelanguage.v1beta.GenerateContentResponse.UsageMetadata.cache_tokens_details:type_name -> google.ai.generativelanguage.v1beta.ModalityTokenCount
	77,  // 95: google.ai.generativelanguage.v1beta.GenerateContentResponse.UsageMetadata.candidates_tokens_details:type_name -> google.ai.generativelanguage.v1beta.ModalityTokenCount
	77,  // 96: google.ai.generativelanguage.v1beta.GenerateContentResponse.UsageMetadata.tool_use_prompt_tokens_details:type_name -> google.ai.generativelanguage.v1beta.ModalityTokenCount
	58,  // 97: google.ai.generativelanguage.v1beta.LogprobsResult.TopCandidates.candidates:type_name -> google.ai.generativelanguage.v1beta.LogprobsResult.Candidate
	6,   // 98: google.ai.generativelanguage.v1beta.GenerateAnswerResponse.InputFeedback.block_reason:type_name -> google.ai.generativelanguage.v1beta.GenerateAnswerResponse.InputFeedback.BlockReason
	74,  // 99: google.ai.generativelanguage.v1beta.GenerateAnswerResponse.InputFeedback.safety_ratings:type_name -> google.ai.generativelanguage.v1beta.SafetyRating
	9,   // 100: google.ai.generativelanguage.v1beta.RealtimeInputConfig.AutomaticActivityDetection.start_of_speech_sensitivity:type_name -> google.ai.generativelanguage.v1beta.RealtimeInputConfig.AutomaticActivityDetection.StartSensitivity
	10,  // 101: google.ai.generativelanguage.v1beta.RealtimeInputConfig.AutomaticActivityDetection.end_of_speech_sensitivity:type_name -> google.ai.generativelanguage.v1beta.RealtimeInputConfig.AutomaticActivityDetection.EndSensitivity
	11,  // 102: google.ai.generativelanguage.v1beta.GenerativeService.GenerateContent:input_type -> google.ai.generativelanguage.v1beta.GenerateContentRequest
	29,  // 103: google.ai.generativelanguage.v1beta.GenerativeService.GenerateAnswer:input_type -> google.ai.generativelanguage.v1beta.GenerateAnswerRequest
	11,  // 104: google.ai.generativelanguage.v1beta.GenerativeService.StreamGenerateContent:input_type -> google.ai.generativelanguage.v1beta.GenerateContentRequest
	31,  // 105: google.ai.generativelanguage.v1beta.GenerativeService.EmbedContent:input_type -> google.ai.generativelanguage.v1beta.EmbedContentRequest
	34,  // 106: google.ai.generativelanguage.v1beta.GenerativeService.BatchEmbedContents:input_type -> google.ai.generativelanguage.v1beta.BatchEmbedContentsRequest
	36,  // 107: google.ai.generativelanguage.v1beta.GenerativeService.CountTokens:input_type -> google.ai.generativelanguage.v1beta.CountTokensRequest
	46,  // 108: google.ai.generativelanguage.v1beta.GenerativeService.BidiGenerateContent:input_type -> google.ai.generativelanguage.v1beta.BidiGenerateContentClientMessage
	18,  // 109: google.ai.generativelanguage.v1beta.GenerativeService.GenerateContent:output_type -> google.ai.generativelanguage.v1beta.GenerateContentResponse
	30,  // 110: google.ai.generativelanguage.v1beta.GenerativeService.GenerateAnswer:output_type -> google.ai.generativelanguage.v1beta.GenerateAnswerResponse
	18,  // 111: google.ai.generativelanguage.v1beta.GenerativeService.StreamGenerateContent:output_type -> google.ai.generativelanguage.v1beta.GenerateContentResponse
	33,  // 112: google.ai.generativelanguage.v1beta.GenerativeService.EmbedContent:output_type -> google.ai.generativelanguage.v1beta.EmbedContentResponse
	35,  // 113: google.ai.generativelanguage.v1beta.GenerativeService.BatchEmbedContents:output_type -> google.ai.generativelanguage.v1beta.BatchEmbedContentsResponse
	37,  // 114: google.ai.generativelanguage.v1beta.GenerativeService.CountTokens:output_type -> google.ai.generativelanguage.v1beta.CountTokensResponse
	54,  // 115: google.ai.generativelanguage.v1beta.GenerativeService.BidiGenerateContent:output_type -> google.ai.generativelanguage.v1beta.BidiGenerateContentServerMessage
	109, // [109:116] is the sub-list for method output_type
	102, // [102:109] is the sub-list for method input_type
	102, // [102:102] is the sub-list for extension type_name
	102, // [102:102] is the sub-list for extension extendee
	0,   // [0:102] is the sub-list for field type_name
}

func init() { file_google_ai_generativelanguage_v1beta_generative_service_proto_init() }
func file_google_ai_generativelanguage_v1beta_generative_service_proto_init() {
	if File_google_ai_generativelanguage_v1beta_generative_service_proto != nil {
		return
	}
	file_google_ai_generativelanguage_v1beta_citation_proto_init()
	file_google_ai_generativelanguage_v1beta_content_proto_init()
	file_google_ai_generativelanguage_v1beta_retriever_proto_init()
	file_google_ai_generativelanguage_v1beta_safety_proto_init()
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[0].OneofWrappers = []any{}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[1].OneofWrappers = []any{}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[2].OneofWrappers = []any{
		(*VoiceConfig_PrebuiltVoiceConfig)(nil),
	}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[4].OneofWrappers = []any{}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[5].OneofWrappers = []any{}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[6].OneofWrappers = []any{}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[8].OneofWrappers = []any{}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[10].OneofWrappers = []any{
		(*AttributionSourceId_GroundingPassage)(nil),
		(*AttributionSourceId_SemanticRetrieverChunk_)(nil),
	}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[13].OneofWrappers = []any{}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[15].OneofWrappers = []any{
		(*GroundingChunk_Web_)(nil),
	}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[17].OneofWrappers = []any{}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[18].OneofWrappers = []any{
		(*GenerateAnswerRequest_InlinePassages)(nil),
		(*GenerateAnswerRequest_SemanticRetriever)(nil),
	}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[19].OneofWrappers = []any{}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[20].OneofWrappers = []any{}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[27].OneofWrappers = []any{}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[28].OneofWrappers = []any{}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[29].OneofWrappers = []any{
		(*ContextWindowCompressionConfig_SlidingWindow_)(nil),
	}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[33].OneofWrappers = []any{}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[35].OneofWrappers = []any{
		(*BidiGenerateContentClientMessage_Setup)(nil),
		(*BidiGenerateContentClientMessage_ClientContent)(nil),
		(*BidiGenerateContentClientMessage_RealtimeInput)(nil),
		(*BidiGenerateContentClientMessage_ToolResponse)(nil),
	}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[37].OneofWrappers = []any{}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[43].OneofWrappers = []any{
		(*BidiGenerateContentServerMessage_SetupComplete)(nil),
		(*BidiGenerateContentServerMessage_ServerContent)(nil),
		(*BidiGenerateContentServerMessage_ToolCall)(nil),
		(*BidiGenerateContentServerMessage_ToolCallCancellation)(nil),
		(*BidiGenerateContentServerMessage_GoAway)(nil),
		(*BidiGenerateContentServerMessage_SessionResumptionUpdate)(nil),
	}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[47].OneofWrappers = []any{}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[51].OneofWrappers = []any{}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[52].OneofWrappers = []any{}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[53].OneofWrappers = []any{}
	file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes[54].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDesc,
			NumEnums:      11,
			NumMessages:   57,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_ai_generativelanguage_v1beta_generative_service_proto_goTypes,
		DependencyIndexes: file_google_ai_generativelanguage_v1beta_generative_service_proto_depIdxs,
		EnumInfos:         file_google_ai_generativelanguage_v1beta_generative_service_proto_enumTypes,
		MessageInfos:      file_google_ai_generativelanguage_v1beta_generative_service_proto_msgTypes,
	}.Build()
	File_google_ai_generativelanguage_v1beta_generative_service_proto = out.File
	file_google_ai_generativelanguage_v1beta_generative_service_proto_rawDesc = nil
	file_google_ai_generativelanguage_v1beta_generative_service_proto_goTypes = nil
	file_google_ai_generativelanguage_v1beta_generative_service_proto_depIdxs = nil
}
