// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/aiplatform/v1/reasoning_engine_service.proto

package aiplatformpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for
// [ReasoningEngineService.CreateReasoningEngine][google.cloud.aiplatform.v1.ReasoningEngineService.CreateReasoningEngine].
type CreateReasoningEngineRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Location to create the ReasoningEngine
	// in. Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ReasoningEngine to create.
	ReasoningEngine *ReasoningEngine `protobuf:"bytes,2,opt,name=reasoning_engine,json=reasoningEngine,proto3" json:"reasoning_engine,omitempty"`
}

func (x *CreateReasoningEngineRequest) Reset() {
	*x = CreateReasoningEngineRequest{}
	mi := &file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateReasoningEngineRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateReasoningEngineRequest) ProtoMessage() {}

func (x *CreateReasoningEngineRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateReasoningEngineRequest.ProtoReflect.Descriptor instead.
func (*CreateReasoningEngineRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_rawDescGZIP(), []int{0}
}

func (x *CreateReasoningEngineRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateReasoningEngineRequest) GetReasoningEngine() *ReasoningEngine {
	if x != nil {
		return x.ReasoningEngine
	}
	return nil
}

// Details of
// [ReasoningEngineService.CreateReasoningEngine][google.cloud.aiplatform.v1.ReasoningEngineService.CreateReasoningEngine]
// operation.
type CreateReasoningEngineOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The common part of the operation metadata.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *CreateReasoningEngineOperationMetadata) Reset() {
	*x = CreateReasoningEngineOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateReasoningEngineOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateReasoningEngineOperationMetadata) ProtoMessage() {}

func (x *CreateReasoningEngineOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateReasoningEngineOperationMetadata.ProtoReflect.Descriptor instead.
func (*CreateReasoningEngineOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_rawDescGZIP(), []int{1}
}

func (x *CreateReasoningEngineOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Request message for
// [ReasoningEngineService.GetReasoningEngine][google.cloud.aiplatform.v1.ReasoningEngineService.GetReasoningEngine].
type GetReasoningEngineRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the ReasoningEngine resource.
	// Format:
	// `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetReasoningEngineRequest) Reset() {
	*x = GetReasoningEngineRequest{}
	mi := &file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetReasoningEngineRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetReasoningEngineRequest) ProtoMessage() {}

func (x *GetReasoningEngineRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetReasoningEngineRequest.ProtoReflect.Descriptor instead.
func (*GetReasoningEngineRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_rawDescGZIP(), []int{2}
}

func (x *GetReasoningEngineRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [ReasoningEngineService.UpdateReasoningEngine][google.cloud.aiplatform.v1.ReasoningEngineService.UpdateReasoningEngine].
type UpdateReasoningEngineRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ReasoningEngine which replaces the resource on the server.
	ReasoningEngine *ReasoningEngine `protobuf:"bytes,1,opt,name=reasoning_engine,json=reasoningEngine,proto3" json:"reasoning_engine,omitempty"`
	// Optional. Mask specifying which fields to update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateReasoningEngineRequest) Reset() {
	*x = UpdateReasoningEngineRequest{}
	mi := &file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateReasoningEngineRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateReasoningEngineRequest) ProtoMessage() {}

func (x *UpdateReasoningEngineRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateReasoningEngineRequest.ProtoReflect.Descriptor instead.
func (*UpdateReasoningEngineRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_rawDescGZIP(), []int{3}
}

func (x *UpdateReasoningEngineRequest) GetReasoningEngine() *ReasoningEngine {
	if x != nil {
		return x.ReasoningEngine
	}
	return nil
}

func (x *UpdateReasoningEngineRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Details of
// [ReasoningEngineService.UpdateReasoningEngine][google.cloud.aiplatform.v1.ReasoningEngineService.UpdateReasoningEngine]
// operation.
type UpdateReasoningEngineOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The common part of the operation metadata.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *UpdateReasoningEngineOperationMetadata) Reset() {
	*x = UpdateReasoningEngineOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateReasoningEngineOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateReasoningEngineOperationMetadata) ProtoMessage() {}

func (x *UpdateReasoningEngineOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateReasoningEngineOperationMetadata.ProtoReflect.Descriptor instead.
func (*UpdateReasoningEngineOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateReasoningEngineOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Request message for
// [ReasoningEngineService.ListReasoningEngines][google.cloud.aiplatform.v1.ReasoningEngineService.ListReasoningEngines].
type ListReasoningEnginesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Location to list the ReasoningEngines
	// from. Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The standard list filter.
	// More detail in [AIP-160](https://google.aip.dev/160).
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The standard list page size.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The standard list page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListReasoningEnginesRequest) Reset() {
	*x = ListReasoningEnginesRequest{}
	mi := &file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListReasoningEnginesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReasoningEnginesRequest) ProtoMessage() {}

func (x *ListReasoningEnginesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReasoningEnginesRequest.ProtoReflect.Descriptor instead.
func (*ListReasoningEnginesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_rawDescGZIP(), []int{5}
}

func (x *ListReasoningEnginesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListReasoningEnginesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListReasoningEnginesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListReasoningEnginesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for
// [ReasoningEngineService.ListReasoningEngines][google.cloud.aiplatform.v1.ReasoningEngineService.ListReasoningEngines]
type ListReasoningEnginesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of ReasoningEngines in the requested page.
	ReasoningEngines []*ReasoningEngine `protobuf:"bytes,1,rep,name=reasoning_engines,json=reasoningEngines,proto3" json:"reasoning_engines,omitempty"`
	// A token to retrieve the next page of results.
	// Pass to
	// [ListReasoningEnginesRequest.page_token][google.cloud.aiplatform.v1.ListReasoningEnginesRequest.page_token]
	// to obtain that page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListReasoningEnginesResponse) Reset() {
	*x = ListReasoningEnginesResponse{}
	mi := &file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListReasoningEnginesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReasoningEnginesResponse) ProtoMessage() {}

func (x *ListReasoningEnginesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReasoningEnginesResponse.ProtoReflect.Descriptor instead.
func (*ListReasoningEnginesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_rawDescGZIP(), []int{6}
}

func (x *ListReasoningEnginesResponse) GetReasoningEngines() []*ReasoningEngine {
	if x != nil {
		return x.ReasoningEngines
	}
	return nil
}

func (x *ListReasoningEnginesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [ReasoningEngineService.DeleteReasoningEngine][google.cloud.aiplatform.v1.ReasoningEngineService.DeleteReasoningEngine].
type DeleteReasoningEngineRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the ReasoningEngine resource to be deleted.
	// Format:
	// `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. If set to true, child resources of this reasoning engine will
	// also be deleted. Otherwise, the request will fail with FAILED_PRECONDITION
	// error when the reasoning engine has undeleted child resources.
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteReasoningEngineRequest) Reset() {
	*x = DeleteReasoningEngineRequest{}
	mi := &file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteReasoningEngineRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteReasoningEngineRequest) ProtoMessage() {}

func (x *DeleteReasoningEngineRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteReasoningEngineRequest.ProtoReflect.Descriptor instead.
func (*DeleteReasoningEngineRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteReasoningEngineRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteReasoningEngineRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

var File_google_cloud_aiplatform_v1_reasoning_engine_service_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_rawDesc = []byte{
	0x0a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f,
	0x76, 0x31, 0x2f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xbe, 0x01,
	0x0a, 0x1c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e,
	0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x5b, 0x0a, 0x10, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69,
	0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x72,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x22, 0x89,
	0x01, 0x0a, 0x26, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69,
	0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5f, 0x0a, 0x10, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x62, 0x0a, 0x19, 0x47, 0x65,
	0x74, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69,
	0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbd,
	0x01, 0x0a, 0x1c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69,
	0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x5b, 0x0a, 0x10, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x72, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x89,
	0x01, 0x0a, 0x26, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69,
	0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5f, 0x0a, 0x10, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xc3, 0x01, 0x0a, 0x1b, 0x4c,
	0x69, 0x73, 0x74, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0xa0, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69,
	0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x58, 0x0a, 0x11, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x10, 0x72, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x80, 0x01, 0x0a, 0x1c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x66,
	0x6f, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x32, 0xaf, 0x0a, 0x0a, 0x16, 0x52, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x12, 0x97, 0x02, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x12, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa4, 0x01, 0xca, 0x41, 0x39, 0x0a, 0x0f, 0x52, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x12, 0x26, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x17, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x72, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x48, 0x3a, 0x10, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x22, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73, 0x12, 0xbd, 0x01, 0x0a, 0x12,
	0x47, 0x65, 0x74, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x22, 0x43, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x36, 0x12, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e,
	0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd0, 0x01, 0x0a, 0x14,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x45, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x12, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73, 0x12, 0xad,
	0x02, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69,
	0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0xba, 0x01, 0xca, 0x41, 0x39, 0x0a, 0x0f, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69,
	0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x12, 0x26, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0xda, 0x41, 0x1c, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x59, 0x3a, 0x10, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67,
	0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x32, 0x45, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe8,
	0x01, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69,
	0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x76, 0xca, 0x41, 0x30, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x17, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x36, 0x2a, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x4d, 0xca, 0x41, 0x19, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a,
	0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xd9, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x42, 0x1b, 0x52, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_rawDescData = file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_rawDesc
)

func file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_rawDescData
}

var file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_goTypes = []any{
	(*CreateReasoningEngineRequest)(nil),           // 0: google.cloud.aiplatform.v1.CreateReasoningEngineRequest
	(*CreateReasoningEngineOperationMetadata)(nil), // 1: google.cloud.aiplatform.v1.CreateReasoningEngineOperationMetadata
	(*GetReasoningEngineRequest)(nil),              // 2: google.cloud.aiplatform.v1.GetReasoningEngineRequest
	(*UpdateReasoningEngineRequest)(nil),           // 3: google.cloud.aiplatform.v1.UpdateReasoningEngineRequest
	(*UpdateReasoningEngineOperationMetadata)(nil), // 4: google.cloud.aiplatform.v1.UpdateReasoningEngineOperationMetadata
	(*ListReasoningEnginesRequest)(nil),            // 5: google.cloud.aiplatform.v1.ListReasoningEnginesRequest
	(*ListReasoningEnginesResponse)(nil),           // 6: google.cloud.aiplatform.v1.ListReasoningEnginesResponse
	(*DeleteReasoningEngineRequest)(nil),           // 7: google.cloud.aiplatform.v1.DeleteReasoningEngineRequest
	(*ReasoningEngine)(nil),                        // 8: google.cloud.aiplatform.v1.ReasoningEngine
	(*GenericOperationMetadata)(nil),               // 9: google.cloud.aiplatform.v1.GenericOperationMetadata
	(*fieldmaskpb.FieldMask)(nil),                  // 10: google.protobuf.FieldMask
	(*longrunningpb.Operation)(nil),                // 11: google.longrunning.Operation
}
var file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_depIdxs = []int32{
	8,  // 0: google.cloud.aiplatform.v1.CreateReasoningEngineRequest.reasoning_engine:type_name -> google.cloud.aiplatform.v1.ReasoningEngine
	9,  // 1: google.cloud.aiplatform.v1.CreateReasoningEngineOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1.GenericOperationMetadata
	8,  // 2: google.cloud.aiplatform.v1.UpdateReasoningEngineRequest.reasoning_engine:type_name -> google.cloud.aiplatform.v1.ReasoningEngine
	10, // 3: google.cloud.aiplatform.v1.UpdateReasoningEngineRequest.update_mask:type_name -> google.protobuf.FieldMask
	9,  // 4: google.cloud.aiplatform.v1.UpdateReasoningEngineOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1.GenericOperationMetadata
	8,  // 5: google.cloud.aiplatform.v1.ListReasoningEnginesResponse.reasoning_engines:type_name -> google.cloud.aiplatform.v1.ReasoningEngine
	0,  // 6: google.cloud.aiplatform.v1.ReasoningEngineService.CreateReasoningEngine:input_type -> google.cloud.aiplatform.v1.CreateReasoningEngineRequest
	2,  // 7: google.cloud.aiplatform.v1.ReasoningEngineService.GetReasoningEngine:input_type -> google.cloud.aiplatform.v1.GetReasoningEngineRequest
	5,  // 8: google.cloud.aiplatform.v1.ReasoningEngineService.ListReasoningEngines:input_type -> google.cloud.aiplatform.v1.ListReasoningEnginesRequest
	3,  // 9: google.cloud.aiplatform.v1.ReasoningEngineService.UpdateReasoningEngine:input_type -> google.cloud.aiplatform.v1.UpdateReasoningEngineRequest
	7,  // 10: google.cloud.aiplatform.v1.ReasoningEngineService.DeleteReasoningEngine:input_type -> google.cloud.aiplatform.v1.DeleteReasoningEngineRequest
	11, // 11: google.cloud.aiplatform.v1.ReasoningEngineService.CreateReasoningEngine:output_type -> google.longrunning.Operation
	8,  // 12: google.cloud.aiplatform.v1.ReasoningEngineService.GetReasoningEngine:output_type -> google.cloud.aiplatform.v1.ReasoningEngine
	6,  // 13: google.cloud.aiplatform.v1.ReasoningEngineService.ListReasoningEngines:output_type -> google.cloud.aiplatform.v1.ListReasoningEnginesResponse
	11, // 14: google.cloud.aiplatform.v1.ReasoningEngineService.UpdateReasoningEngine:output_type -> google.longrunning.Operation
	11, // 15: google.cloud.aiplatform.v1.ReasoningEngineService.DeleteReasoningEngine:output_type -> google.longrunning.Operation
	11, // [11:16] is the sub-list for method output_type
	6,  // [6:11] is the sub-list for method input_type
	6,  // [6:6] is the sub-list for extension type_name
	6,  // [6:6] is the sub-list for extension extendee
	0,  // [0:6] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_init() }
func file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_init() {
	if File_google_cloud_aiplatform_v1_reasoning_engine_service_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1_operation_proto_init()
	file_google_cloud_aiplatform_v1_reasoning_engine_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1_reasoning_engine_service_proto = out.File
	file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_goTypes = nil
	file_google_cloud_aiplatform_v1_reasoning_engine_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ReasoningEngineServiceClient is the client API for ReasoningEngineService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ReasoningEngineServiceClient interface {
	// Creates a reasoning engine.
	CreateReasoningEngine(ctx context.Context, in *CreateReasoningEngineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a reasoning engine.
	GetReasoningEngine(ctx context.Context, in *GetReasoningEngineRequest, opts ...grpc.CallOption) (*ReasoningEngine, error)
	// Lists reasoning engines in a location.
	ListReasoningEngines(ctx context.Context, in *ListReasoningEnginesRequest, opts ...grpc.CallOption) (*ListReasoningEnginesResponse, error)
	// Updates a reasoning engine.
	UpdateReasoningEngine(ctx context.Context, in *UpdateReasoningEngineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a reasoning engine.
	DeleteReasoningEngine(ctx context.Context, in *DeleteReasoningEngineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type reasoningEngineServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewReasoningEngineServiceClient(cc grpc.ClientConnInterface) ReasoningEngineServiceClient {
	return &reasoningEngineServiceClient{cc}
}

func (c *reasoningEngineServiceClient) CreateReasoningEngine(ctx context.Context, in *CreateReasoningEngineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.ReasoningEngineService/CreateReasoningEngine", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reasoningEngineServiceClient) GetReasoningEngine(ctx context.Context, in *GetReasoningEngineRequest, opts ...grpc.CallOption) (*ReasoningEngine, error) {
	out := new(ReasoningEngine)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.ReasoningEngineService/GetReasoningEngine", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reasoningEngineServiceClient) ListReasoningEngines(ctx context.Context, in *ListReasoningEnginesRequest, opts ...grpc.CallOption) (*ListReasoningEnginesResponse, error) {
	out := new(ListReasoningEnginesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.ReasoningEngineService/ListReasoningEngines", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reasoningEngineServiceClient) UpdateReasoningEngine(ctx context.Context, in *UpdateReasoningEngineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.ReasoningEngineService/UpdateReasoningEngine", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reasoningEngineServiceClient) DeleteReasoningEngine(ctx context.Context, in *DeleteReasoningEngineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.ReasoningEngineService/DeleteReasoningEngine", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ReasoningEngineServiceServer is the server API for ReasoningEngineService service.
type ReasoningEngineServiceServer interface {
	// Creates a reasoning engine.
	CreateReasoningEngine(context.Context, *CreateReasoningEngineRequest) (*longrunningpb.Operation, error)
	// Gets a reasoning engine.
	GetReasoningEngine(context.Context, *GetReasoningEngineRequest) (*ReasoningEngine, error)
	// Lists reasoning engines in a location.
	ListReasoningEngines(context.Context, *ListReasoningEnginesRequest) (*ListReasoningEnginesResponse, error)
	// Updates a reasoning engine.
	UpdateReasoningEngine(context.Context, *UpdateReasoningEngineRequest) (*longrunningpb.Operation, error)
	// Deletes a reasoning engine.
	DeleteReasoningEngine(context.Context, *DeleteReasoningEngineRequest) (*longrunningpb.Operation, error)
}

// UnimplementedReasoningEngineServiceServer can be embedded to have forward compatible implementations.
type UnimplementedReasoningEngineServiceServer struct {
}

func (*UnimplementedReasoningEngineServiceServer) CreateReasoningEngine(context.Context, *CreateReasoningEngineRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateReasoningEngine not implemented")
}
func (*UnimplementedReasoningEngineServiceServer) GetReasoningEngine(context.Context, *GetReasoningEngineRequest) (*ReasoningEngine, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetReasoningEngine not implemented")
}
func (*UnimplementedReasoningEngineServiceServer) ListReasoningEngines(context.Context, *ListReasoningEnginesRequest) (*ListReasoningEnginesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListReasoningEngines not implemented")
}
func (*UnimplementedReasoningEngineServiceServer) UpdateReasoningEngine(context.Context, *UpdateReasoningEngineRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateReasoningEngine not implemented")
}
func (*UnimplementedReasoningEngineServiceServer) DeleteReasoningEngine(context.Context, *DeleteReasoningEngineRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteReasoningEngine not implemented")
}

func RegisterReasoningEngineServiceServer(s *grpc.Server, srv ReasoningEngineServiceServer) {
	s.RegisterService(&_ReasoningEngineService_serviceDesc, srv)
}

func _ReasoningEngineService_CreateReasoningEngine_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateReasoningEngineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReasoningEngineServiceServer).CreateReasoningEngine(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.ReasoningEngineService/CreateReasoningEngine",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReasoningEngineServiceServer).CreateReasoningEngine(ctx, req.(*CreateReasoningEngineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReasoningEngineService_GetReasoningEngine_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReasoningEngineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReasoningEngineServiceServer).GetReasoningEngine(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.ReasoningEngineService/GetReasoningEngine",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReasoningEngineServiceServer).GetReasoningEngine(ctx, req.(*GetReasoningEngineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReasoningEngineService_ListReasoningEngines_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListReasoningEnginesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReasoningEngineServiceServer).ListReasoningEngines(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.ReasoningEngineService/ListReasoningEngines",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReasoningEngineServiceServer).ListReasoningEngines(ctx, req.(*ListReasoningEnginesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReasoningEngineService_UpdateReasoningEngine_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateReasoningEngineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReasoningEngineServiceServer).UpdateReasoningEngine(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.ReasoningEngineService/UpdateReasoningEngine",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReasoningEngineServiceServer).UpdateReasoningEngine(ctx, req.(*UpdateReasoningEngineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReasoningEngineService_DeleteReasoningEngine_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteReasoningEngineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReasoningEngineServiceServer).DeleteReasoningEngine(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.ReasoningEngineService/DeleteReasoningEngine",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReasoningEngineServiceServer).DeleteReasoningEngine(ctx, req.(*DeleteReasoningEngineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ReasoningEngineService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1.ReasoningEngineService",
	HandlerType: (*ReasoningEngineServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateReasoningEngine",
			Handler:    _ReasoningEngineService_CreateReasoningEngine_Handler,
		},
		{
			MethodName: "GetReasoningEngine",
			Handler:    _ReasoningEngineService_GetReasoningEngine_Handler,
		},
		{
			MethodName: "ListReasoningEngines",
			Handler:    _ReasoningEngineService_ListReasoningEngines_Handler,
		},
		{
			MethodName: "UpdateReasoningEngine",
			Handler:    _ReasoningEngineService_UpdateReasoningEngine_Handler,
		},
		{
			MethodName: "DeleteReasoningEngine",
			Handler:    _ReasoningEngineService_DeleteReasoningEngine_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1/reasoning_engine_service.proto",
}
