// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/aiplatform/v1/notebook_runtime.proto

package aiplatformpb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Represents a notebook runtime type.
type NotebookRuntimeType int32

const (
	// Unspecified notebook runtime type, NotebookRuntimeType will default to
	// USER_DEFINED.
	NotebookRuntimeType_NOTEBOOK_RUNTIME_TYPE_UNSPECIFIED NotebookRuntimeType = 0
	// runtime or template with coustomized configurations from user.
	NotebookRuntimeType_USER_DEFINED NotebookRuntimeType = 1
	// runtime or template with system defined configurations.
	NotebookRuntimeType_ONE_CLICK NotebookRuntimeType = 2
)

// Enum value maps for NotebookRuntimeType.
var (
	NotebookRuntimeType_name = map[int32]string{
		0: "NOTEBOOK_RUNTIME_TYPE_UNSPECIFIED",
		1: "USER_DEFINED",
		2: "ONE_CLICK",
	}
	NotebookRuntimeType_value = map[string]int32{
		"NOTEBOOK_RUNTIME_TYPE_UNSPECIFIED": 0,
		"USER_DEFINED":                      1,
		"ONE_CLICK":                         2,
	}
)

func (x NotebookRuntimeType) Enum() *NotebookRuntimeType {
	p := new(NotebookRuntimeType)
	*p = x
	return p
}

func (x NotebookRuntimeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NotebookRuntimeType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1_notebook_runtime_proto_enumTypes[0].Descriptor()
}

func (NotebookRuntimeType) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1_notebook_runtime_proto_enumTypes[0]
}

func (x NotebookRuntimeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NotebookRuntimeType.Descriptor instead.
func (NotebookRuntimeType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_notebook_runtime_proto_rawDescGZIP(), []int{0}
}

// The substate of the NotebookRuntime to display health information.
type NotebookRuntime_HealthState int32

const (
	// Unspecified health state.
	NotebookRuntime_HEALTH_STATE_UNSPECIFIED NotebookRuntime_HealthState = 0
	// NotebookRuntime is in healthy state. Applies to ACTIVE state.
	NotebookRuntime_HEALTHY NotebookRuntime_HealthState = 1
	// NotebookRuntime is in unhealthy state. Applies to ACTIVE state.
	NotebookRuntime_UNHEALTHY NotebookRuntime_HealthState = 2
)

// Enum value maps for NotebookRuntime_HealthState.
var (
	NotebookRuntime_HealthState_name = map[int32]string{
		0: "HEALTH_STATE_UNSPECIFIED",
		1: "HEALTHY",
		2: "UNHEALTHY",
	}
	NotebookRuntime_HealthState_value = map[string]int32{
		"HEALTH_STATE_UNSPECIFIED": 0,
		"HEALTHY":                  1,
		"UNHEALTHY":                2,
	}
)

func (x NotebookRuntime_HealthState) Enum() *NotebookRuntime_HealthState {
	p := new(NotebookRuntime_HealthState)
	*p = x
	return p
}

func (x NotebookRuntime_HealthState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NotebookRuntime_HealthState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1_notebook_runtime_proto_enumTypes[1].Descriptor()
}

func (NotebookRuntime_HealthState) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1_notebook_runtime_proto_enumTypes[1]
}

func (x NotebookRuntime_HealthState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NotebookRuntime_HealthState.Descriptor instead.
func (NotebookRuntime_HealthState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_notebook_runtime_proto_rawDescGZIP(), []int{1, 0}
}

// The substate of the NotebookRuntime to display state of runtime.
// The resource of NotebookRuntime is in ACTIVE state for these sub state.
type NotebookRuntime_RuntimeState int32

const (
	// Unspecified runtime state.
	NotebookRuntime_RUNTIME_STATE_UNSPECIFIED NotebookRuntime_RuntimeState = 0
	// NotebookRuntime is in running state.
	NotebookRuntime_RUNNING NotebookRuntime_RuntimeState = 1
	// NotebookRuntime is in starting state.
	NotebookRuntime_BEING_STARTED NotebookRuntime_RuntimeState = 2
	// NotebookRuntime is in stopping state.
	NotebookRuntime_BEING_STOPPED NotebookRuntime_RuntimeState = 3
	// NotebookRuntime is in stopped state.
	NotebookRuntime_STOPPED NotebookRuntime_RuntimeState = 4
	// NotebookRuntime is in upgrading state. It is in the middle of upgrading
	// process.
	NotebookRuntime_BEING_UPGRADED NotebookRuntime_RuntimeState = 5
	// NotebookRuntime was unable to start/stop properly.
	NotebookRuntime_ERROR NotebookRuntime_RuntimeState = 100
	// NotebookRuntime is in invalid state. Cannot be recovered.
	NotebookRuntime_INVALID NotebookRuntime_RuntimeState = 101
)

// Enum value maps for NotebookRuntime_RuntimeState.
var (
	NotebookRuntime_RuntimeState_name = map[int32]string{
		0:   "RUNTIME_STATE_UNSPECIFIED",
		1:   "RUNNING",
		2:   "BEING_STARTED",
		3:   "BEING_STOPPED",
		4:   "STOPPED",
		5:   "BEING_UPGRADED",
		100: "ERROR",
		101: "INVALID",
	}
	NotebookRuntime_RuntimeState_value = map[string]int32{
		"RUNTIME_STATE_UNSPECIFIED": 0,
		"RUNNING":                   1,
		"BEING_STARTED":             2,
		"BEING_STOPPED":             3,
		"STOPPED":                   4,
		"BEING_UPGRADED":            5,
		"ERROR":                     100,
		"INVALID":                   101,
	}
)

func (x NotebookRuntime_RuntimeState) Enum() *NotebookRuntime_RuntimeState {
	p := new(NotebookRuntime_RuntimeState)
	*p = x
	return p
}

func (x NotebookRuntime_RuntimeState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NotebookRuntime_RuntimeState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1_notebook_runtime_proto_enumTypes[2].Descriptor()
}

func (NotebookRuntime_RuntimeState) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1_notebook_runtime_proto_enumTypes[2]
}

func (x NotebookRuntime_RuntimeState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NotebookRuntime_RuntimeState.Descriptor instead.
func (NotebookRuntime_RuntimeState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_notebook_runtime_proto_rawDescGZIP(), []int{1, 1}
}

// A template that specifies runtime configurations such as machine type,
// runtime version, network configurations, etc.
// Multiple runtimes can be created from a runtime template.
type NotebookRuntimeTemplate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the NotebookRuntimeTemplate.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The display name of the NotebookRuntimeTemplate.
	// The name can be up to 128 characters long and can consist of any UTF-8
	// characters.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The description of the NotebookRuntimeTemplate.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Deprecated: This field has no behavior. Use
	// notebook_runtime_type = 'ONE_CLICK' instead.
	//
	// The default template to use if not specified.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1/notebook_runtime.proto.
	IsDefault bool `protobuf:"varint,4,opt,name=is_default,json=isDefault,proto3" json:"is_default,omitempty"`
	// Optional. Immutable. The specification of a single machine for the
	// template.
	MachineSpec *MachineSpec `protobuf:"bytes,5,opt,name=machine_spec,json=machineSpec,proto3" json:"machine_spec,omitempty"`
	// Optional. The specification of [persistent
	// disk][https://cloud.google.com/compute/docs/disks/persistent-disks]
	// attached to the runtime as data disk storage.
	DataPersistentDiskSpec *PersistentDiskSpec `protobuf:"bytes,8,opt,name=data_persistent_disk_spec,json=dataPersistentDiskSpec,proto3" json:"data_persistent_disk_spec,omitempty"`
	// Optional. Network spec.
	NetworkSpec *NetworkSpec `protobuf:"bytes,12,opt,name=network_spec,json=networkSpec,proto3" json:"network_spec,omitempty"`
	// Deprecated: This field is ignored and the "Vertex AI Notebook Service
	// Account"
	// (service-PROJECT_NUMBER@gcp-sa-aiplatform-vm.iam.gserviceaccount.com) is
	// used for the runtime workload identity.
	// See
	// https://cloud.google.com/iam/docs/service-agents#vertex-ai-notebook-service-account
	// for more details.
	// For NotebookExecutionJob, use NotebookExecutionJob.service_account instead.
	//
	// The service account that the runtime workload runs as.
	// You can use any service account within the same project, but you
	// must have the service account user permission to use the instance.
	//
	// If not specified, the [Compute Engine default service
	// account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
	// is used.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1/notebook_runtime.proto.
	ServiceAccount string `protobuf:"bytes,13,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Used to perform consistent read-modify-write updates. If not set, a blind
	// "overwrite" update happens.
	Etag string `protobuf:"bytes,14,opt,name=etag,proto3" json:"etag,omitempty"`
	// The labels with user-defined metadata to organize the
	// NotebookRuntimeTemplates.
	//
	// Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	//
	// See https://goo.gl/xmQnxf for more information and examples of labels.
	Labels map[string]string `protobuf:"bytes,15,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The idle shutdown configuration of NotebookRuntimeTemplate. This config
	// will only be set when idle shutdown is enabled.
	IdleShutdownConfig *NotebookIdleShutdownConfig `protobuf:"bytes,17,opt,name=idle_shutdown_config,json=idleShutdownConfig,proto3" json:"idle_shutdown_config,omitempty"`
	// EUC configuration of the NotebookRuntimeTemplate.
	EucConfig *NotebookEucConfig `protobuf:"bytes,18,opt,name=euc_config,json=eucConfig,proto3" json:"euc_config,omitempty"`
	// Output only. Timestamp when this NotebookRuntimeTemplate was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp when this NotebookRuntimeTemplate was most recently
	// updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Immutable. The type of the notebook runtime template.
	NotebookRuntimeType NotebookRuntimeType `protobuf:"varint,19,opt,name=notebook_runtime_type,json=notebookRuntimeType,proto3,enum=google.cloud.aiplatform.v1.NotebookRuntimeType" json:"notebook_runtime_type,omitempty"`
	// Optional. Immutable. Runtime Shielded VM spec.
	ShieldedVmConfig *ShieldedVmConfig `protobuf:"bytes,20,opt,name=shielded_vm_config,json=shieldedVmConfig,proto3" json:"shielded_vm_config,omitempty"`
	// Optional. The Compute Engine tags to add to runtime (see [Tagging
	// instances](https://cloud.google.com/vpc/docs/add-remove-network-tags)).
	NetworkTags []string `protobuf:"bytes,21,rep,name=network_tags,json=networkTags,proto3" json:"network_tags,omitempty"`
	// Customer-managed encryption key spec for the notebook runtime.
	EncryptionSpec *EncryptionSpec `protobuf:"bytes,23,opt,name=encryption_spec,json=encryptionSpec,proto3" json:"encryption_spec,omitempty"`
	// Optional. The notebook software configuration of the notebook runtime.
	SoftwareConfig *NotebookSoftwareConfig `protobuf:"bytes,24,opt,name=software_config,json=softwareConfig,proto3" json:"software_config,omitempty"`
}

func (x *NotebookRuntimeTemplate) Reset() {
	*x = NotebookRuntimeTemplate{}
	mi := &file_google_cloud_aiplatform_v1_notebook_runtime_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NotebookRuntimeTemplate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NotebookRuntimeTemplate) ProtoMessage() {}

func (x *NotebookRuntimeTemplate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_notebook_runtime_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NotebookRuntimeTemplate.ProtoReflect.Descriptor instead.
func (*NotebookRuntimeTemplate) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_notebook_runtime_proto_rawDescGZIP(), []int{0}
}

func (x *NotebookRuntimeTemplate) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *NotebookRuntimeTemplate) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *NotebookRuntimeTemplate) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1/notebook_runtime.proto.
func (x *NotebookRuntimeTemplate) GetIsDefault() bool {
	if x != nil {
		return x.IsDefault
	}
	return false
}

func (x *NotebookRuntimeTemplate) GetMachineSpec() *MachineSpec {
	if x != nil {
		return x.MachineSpec
	}
	return nil
}

func (x *NotebookRuntimeTemplate) GetDataPersistentDiskSpec() *PersistentDiskSpec {
	if x != nil {
		return x.DataPersistentDiskSpec
	}
	return nil
}

func (x *NotebookRuntimeTemplate) GetNetworkSpec() *NetworkSpec {
	if x != nil {
		return x.NetworkSpec
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1/notebook_runtime.proto.
func (x *NotebookRuntimeTemplate) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *NotebookRuntimeTemplate) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *NotebookRuntimeTemplate) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *NotebookRuntimeTemplate) GetIdleShutdownConfig() *NotebookIdleShutdownConfig {
	if x != nil {
		return x.IdleShutdownConfig
	}
	return nil
}

func (x *NotebookRuntimeTemplate) GetEucConfig() *NotebookEucConfig {
	if x != nil {
		return x.EucConfig
	}
	return nil
}

func (x *NotebookRuntimeTemplate) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *NotebookRuntimeTemplate) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *NotebookRuntimeTemplate) GetNotebookRuntimeType() NotebookRuntimeType {
	if x != nil {
		return x.NotebookRuntimeType
	}
	return NotebookRuntimeType_NOTEBOOK_RUNTIME_TYPE_UNSPECIFIED
}

func (x *NotebookRuntimeTemplate) GetShieldedVmConfig() *ShieldedVmConfig {
	if x != nil {
		return x.ShieldedVmConfig
	}
	return nil
}

func (x *NotebookRuntimeTemplate) GetNetworkTags() []string {
	if x != nil {
		return x.NetworkTags
	}
	return nil
}

func (x *NotebookRuntimeTemplate) GetEncryptionSpec() *EncryptionSpec {
	if x != nil {
		return x.EncryptionSpec
	}
	return nil
}

func (x *NotebookRuntimeTemplate) GetSoftwareConfig() *NotebookSoftwareConfig {
	if x != nil {
		return x.SoftwareConfig
	}
	return nil
}

// A runtime is a virtual machine allocated to a particular user for a
// particular Notebook file on temporary basis with lifetime limited to 24
// hours.
type NotebookRuntime struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the NotebookRuntime.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The user email of the NotebookRuntime.
	RuntimeUser string `protobuf:"bytes,2,opt,name=runtime_user,json=runtimeUser,proto3" json:"runtime_user,omitempty"`
	// Output only. The pointer to NotebookRuntimeTemplate this NotebookRuntime is
	// created from.
	NotebookRuntimeTemplateRef *NotebookRuntimeTemplateRef `protobuf:"bytes,3,opt,name=notebook_runtime_template_ref,json=notebookRuntimeTemplateRef,proto3" json:"notebook_runtime_template_ref,omitempty"`
	// Output only. The proxy endpoint used to access the NotebookRuntime.
	ProxyUri string `protobuf:"bytes,5,opt,name=proxy_uri,json=proxyUri,proto3" json:"proxy_uri,omitempty"`
	// Output only. Timestamp when this NotebookRuntime was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp when this NotebookRuntime was most recently updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The health state of the NotebookRuntime.
	HealthState NotebookRuntime_HealthState `protobuf:"varint,8,opt,name=health_state,json=healthState,proto3,enum=google.cloud.aiplatform.v1.NotebookRuntime_HealthState" json:"health_state,omitempty"`
	// Required. The display name of the NotebookRuntime.
	// The name can be up to 128 characters long and can consist of any UTF-8
	// characters.
	DisplayName string `protobuf:"bytes,10,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The description of the NotebookRuntime.
	Description string `protobuf:"bytes,11,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Deprecated: This field is no longer used and the "Vertex AI
	// Notebook Service Account"
	// (service-PROJECT_NUMBER@gcp-sa-aiplatform-vm.iam.gserviceaccount.com) is
	// used for the runtime workload identity.
	// See
	// https://cloud.google.com/iam/docs/service-agents#vertex-ai-notebook-service-account
	// for more details.
	//
	// The service account that the NotebookRuntime workload runs as.
	ServiceAccount string `protobuf:"bytes,13,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Output only. The runtime (instance) state of the NotebookRuntime.
	RuntimeState NotebookRuntime_RuntimeState `protobuf:"varint,14,opt,name=runtime_state,json=runtimeState,proto3,enum=google.cloud.aiplatform.v1.NotebookRuntime_RuntimeState" json:"runtime_state,omitempty"`
	// Output only. Whether NotebookRuntime is upgradable.
	IsUpgradable bool `protobuf:"varint,15,opt,name=is_upgradable,json=isUpgradable,proto3" json:"is_upgradable,omitempty"`
	// The labels with user-defined metadata to organize your
	// NotebookRuntime.
	//
	// Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// No more than 64 user labels can be associated with one NotebookRuntime
	// (System labels are excluded).
	//
	// See https://goo.gl/xmQnxf for more information and examples of labels.
	// System reserved label keys are prefixed with "aiplatform.googleapis.com/"
	// and are immutable. Following system labels exist for NotebookRuntime:
	//
	// * "aiplatform.googleapis.com/notebook_runtime_gce_instance_id": output
	// only, its value is the Compute Engine instance id.
	// * "aiplatform.googleapis.com/colab_enterprise_entry_service": its value is
	// either "bigquery" or "vertex"; if absent, it should be "vertex". This is to
	// describe the entry service, either BigQuery or Vertex.
	Labels map[string]string `protobuf:"bytes,16,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Timestamp when this NotebookRuntime will be expired:
	// 1. System Predefined NotebookRuntime: 24 hours after creation. After
	// expiration, system predifined runtime will be deleted.
	// 2. User created NotebookRuntime: 6 months after last upgrade. After
	// expiration, user created runtime will be stopped and allowed for upgrade.
	ExpirationTime *timestamppb.Timestamp `protobuf:"bytes,17,opt,name=expiration_time,json=expirationTime,proto3" json:"expiration_time,omitempty"`
	// Output only. The VM os image version of NotebookRuntime.
	Version string `protobuf:"bytes,18,opt,name=version,proto3" json:"version,omitempty"`
	// Output only. The type of the notebook runtime.
	NotebookRuntimeType NotebookRuntimeType `protobuf:"varint,19,opt,name=notebook_runtime_type,json=notebookRuntimeType,proto3,enum=google.cloud.aiplatform.v1.NotebookRuntimeType" json:"notebook_runtime_type,omitempty"`
	// Output only. The specification of a single machine used by the notebook
	// runtime.
	MachineSpec *MachineSpec `protobuf:"bytes,20,opt,name=machine_spec,json=machineSpec,proto3" json:"machine_spec,omitempty"`
	// Output only. The specification of [persistent
	// disk][https://cloud.google.com/compute/docs/disks/persistent-disks]
	// attached to the notebook runtime as data disk storage.
	DataPersistentDiskSpec *PersistentDiskSpec `protobuf:"bytes,21,opt,name=data_persistent_disk_spec,json=dataPersistentDiskSpec,proto3" json:"data_persistent_disk_spec,omitempty"`
	// Output only. Network spec of the notebook runtime.
	NetworkSpec *NetworkSpec `protobuf:"bytes,22,opt,name=network_spec,json=networkSpec,proto3" json:"network_spec,omitempty"`
	// Output only. The idle shutdown configuration of the notebook runtime.
	IdleShutdownConfig *NotebookIdleShutdownConfig `protobuf:"bytes,23,opt,name=idle_shutdown_config,json=idleShutdownConfig,proto3" json:"idle_shutdown_config,omitempty"`
	// Output only. EUC configuration of the notebook runtime.
	EucConfig *NotebookEucConfig `protobuf:"bytes,24,opt,name=euc_config,json=eucConfig,proto3" json:"euc_config,omitempty"`
	// Output only. Runtime Shielded VM spec.
	ShieldedVmConfig *ShieldedVmConfig `protobuf:"bytes,32,opt,name=shielded_vm_config,json=shieldedVmConfig,proto3" json:"shielded_vm_config,omitempty"`
	// Optional. The Compute Engine tags to add to runtime (see [Tagging
	// instances](https://cloud.google.com/vpc/docs/add-remove-network-tags)).
	NetworkTags []string `protobuf:"bytes,25,rep,name=network_tags,json=networkTags,proto3" json:"network_tags,omitempty"`
	// Output only. Software config of the notebook runtime.
	SoftwareConfig *NotebookSoftwareConfig `protobuf:"bytes,31,opt,name=software_config,json=softwareConfig,proto3" json:"software_config,omitempty"`
	// Output only. Customer-managed encryption key spec for the notebook runtime.
	EncryptionSpec *EncryptionSpec `protobuf:"bytes,28,opt,name=encryption_spec,json=encryptionSpec,proto3" json:"encryption_spec,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzs bool `protobuf:"varint,29,opt,name=satisfies_pzs,json=satisfiesPzs,proto3" json:"satisfies_pzs,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzi bool `protobuf:"varint,30,opt,name=satisfies_pzi,json=satisfiesPzi,proto3" json:"satisfies_pzi,omitempty"`
}

func (x *NotebookRuntime) Reset() {
	*x = NotebookRuntime{}
	mi := &file_google_cloud_aiplatform_v1_notebook_runtime_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NotebookRuntime) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NotebookRuntime) ProtoMessage() {}

func (x *NotebookRuntime) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_notebook_runtime_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NotebookRuntime.ProtoReflect.Descriptor instead.
func (*NotebookRuntime) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_notebook_runtime_proto_rawDescGZIP(), []int{1}
}

func (x *NotebookRuntime) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *NotebookRuntime) GetRuntimeUser() string {
	if x != nil {
		return x.RuntimeUser
	}
	return ""
}

func (x *NotebookRuntime) GetNotebookRuntimeTemplateRef() *NotebookRuntimeTemplateRef {
	if x != nil {
		return x.NotebookRuntimeTemplateRef
	}
	return nil
}

func (x *NotebookRuntime) GetProxyUri() string {
	if x != nil {
		return x.ProxyUri
	}
	return ""
}

func (x *NotebookRuntime) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *NotebookRuntime) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *NotebookRuntime) GetHealthState() NotebookRuntime_HealthState {
	if x != nil {
		return x.HealthState
	}
	return NotebookRuntime_HEALTH_STATE_UNSPECIFIED
}

func (x *NotebookRuntime) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *NotebookRuntime) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *NotebookRuntime) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *NotebookRuntime) GetRuntimeState() NotebookRuntime_RuntimeState {
	if x != nil {
		return x.RuntimeState
	}
	return NotebookRuntime_RUNTIME_STATE_UNSPECIFIED
}

func (x *NotebookRuntime) GetIsUpgradable() bool {
	if x != nil {
		return x.IsUpgradable
	}
	return false
}

func (x *NotebookRuntime) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *NotebookRuntime) GetExpirationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpirationTime
	}
	return nil
}

func (x *NotebookRuntime) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *NotebookRuntime) GetNotebookRuntimeType() NotebookRuntimeType {
	if x != nil {
		return x.NotebookRuntimeType
	}
	return NotebookRuntimeType_NOTEBOOK_RUNTIME_TYPE_UNSPECIFIED
}

func (x *NotebookRuntime) GetMachineSpec() *MachineSpec {
	if x != nil {
		return x.MachineSpec
	}
	return nil
}

func (x *NotebookRuntime) GetDataPersistentDiskSpec() *PersistentDiskSpec {
	if x != nil {
		return x.DataPersistentDiskSpec
	}
	return nil
}

func (x *NotebookRuntime) GetNetworkSpec() *NetworkSpec {
	if x != nil {
		return x.NetworkSpec
	}
	return nil
}

func (x *NotebookRuntime) GetIdleShutdownConfig() *NotebookIdleShutdownConfig {
	if x != nil {
		return x.IdleShutdownConfig
	}
	return nil
}

func (x *NotebookRuntime) GetEucConfig() *NotebookEucConfig {
	if x != nil {
		return x.EucConfig
	}
	return nil
}

func (x *NotebookRuntime) GetShieldedVmConfig() *ShieldedVmConfig {
	if x != nil {
		return x.ShieldedVmConfig
	}
	return nil
}

func (x *NotebookRuntime) GetNetworkTags() []string {
	if x != nil {
		return x.NetworkTags
	}
	return nil
}

func (x *NotebookRuntime) GetSoftwareConfig() *NotebookSoftwareConfig {
	if x != nil {
		return x.SoftwareConfig
	}
	return nil
}

func (x *NotebookRuntime) GetEncryptionSpec() *EncryptionSpec {
	if x != nil {
		return x.EncryptionSpec
	}
	return nil
}

func (x *NotebookRuntime) GetSatisfiesPzs() bool {
	if x != nil {
		return x.SatisfiesPzs
	}
	return false
}

func (x *NotebookRuntime) GetSatisfiesPzi() bool {
	if x != nil {
		return x.SatisfiesPzi
	}
	return false
}

var File_google_cloud_aiplatform_v1_notebook_runtime_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1_notebook_runtime_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x6e, 0x6f, 0x74,
	0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e,
	0x65, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x6e, 0x6f, 0x74,
	0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x65, 0x75, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f,
	0x76, 0x31, 0x2f, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x69, 0x64, 0x6c, 0x65,
	0x5f, 0x73, 0x68, 0x75, 0x74, 0x64, 0x6f, 0x77, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f,
	0x76, 0x31, 0x2f, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x65, 0x66,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f,
	0x76, 0x31, 0x2f, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x73, 0x6f, 0x66, 0x74,
	0x77, 0x61, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x8b, 0x0c, 0x0a, 0x17, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x52,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0a,
	0x69, 0x73, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x05, 0xe0, 0x41, 0x03, 0x18, 0x01, 0x52, 0x09, 0x69, 0x73, 0x44, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x12, 0x52, 0x0a, 0x0c, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x70,
	0x65, 0x63, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x53, 0x70, 0x65,
	0x63, 0x42, 0x06, 0xe0, 0x41, 0x01, 0xe0, 0x41, 0x05, 0x52, 0x0b, 0x6d, 0x61, 0x63, 0x68, 0x69,
	0x6e, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x6e, 0x0a, 0x19, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70,
	0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73,
	0x70, 0x65, 0x63, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e,
	0x74, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16,
	0x64, 0x61, 0x74, 0x61, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x44, 0x69,
	0x73, 0x6b, 0x53, 0x70, 0x65, 0x63, 0x12, 0x4f, 0x0a, 0x0c, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x53, 0x70, 0x65, 0x63, 0x12, 0x2b, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x57, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x12, 0x68, 0x0a, 0x14, 0x69, 0x64, 0x6c, 0x65, 0x5f, 0x73, 0x68, 0x75, 0x74, 0x64, 0x6f,
	0x77, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74,
	0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x49, 0x64, 0x6c, 0x65, 0x53, 0x68, 0x75, 0x74, 0x64, 0x6f, 0x77,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x12, 0x69, 0x64, 0x6c, 0x65, 0x53, 0x68, 0x75,
	0x74, 0x64, 0x6f, 0x77, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4c, 0x0a, 0x0a, 0x65,
	0x75, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74,
	0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x45, 0x75, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x09,
	0x65, 0x75, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x6b, 0x0a,
	0x15, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f,
	0x6f, 0x6b, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x06, 0xe0,
	0x41, 0x01, 0xe0, 0x41, 0x05, 0x52, 0x13, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x52,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x62, 0x0a, 0x12, 0x73, 0x68,
	0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x5f, 0x76, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x56, 0x6d, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x42, 0x06, 0xe0, 0x41, 0x01, 0xe0, 0x41, 0x05, 0x52, 0x10, 0x73, 0x68,
	0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x56, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x26,
	0x0a, 0x0c, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x15,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x54, 0x61, 0x67, 0x73, 0x12, 0x53, 0x0a, 0x0f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0e, 0x65, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x60, 0x0a, 0x0f, 0x73,
	0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x18,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61,
	0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73,
	0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x39, 0x0a,
	0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x95, 0x01, 0xea, 0x41, 0x91, 0x01, 0x0a,
	0x31, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x6f, 0x74, 0x65, 0x62,
	0x6f, 0x6f, 0x6b, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x12, 0x5c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6e, 0x6f, 0x74, 0x65,
	0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x73, 0x2f, 0x7b, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x7d,
	0x22, 0x8d, 0x12, 0x0a, 0x0f, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a,
	0x0c, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x55, 0x73, 0x65, 0x72, 0x12, 0x7e, 0x0a, 0x1d, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f,
	0x6b, 0x5f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f,
	0x6f, 0x6b, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x66, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1a, 0x6e, 0x6f, 0x74, 0x65, 0x62,
	0x6f, 0x6f, 0x6b, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x52, 0x65, 0x66, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x5f, 0x75,
	0x72, 0x69, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x70,
	0x72, 0x6f, 0x78, 0x79, 0x55, 0x72, 0x69, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5f, 0x0a, 0x0c, 0x68,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4e,
	0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x48,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0b, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x26, 0x0a, 0x0c,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x62, 0x0a, 0x0d, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f,
	0x6b, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x69, 0x73, 0x5f, 0x75,
	0x70, 0x67, 0x72, 0x61, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x69, 0x73, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x61, 0x62,
	0x6c, 0x65, 0x12, 0x4f, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x10, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x12, 0x48, 0x0a, 0x0f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x65,
	0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1d, 0x0a,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x68, 0x0a, 0x15,
	0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f,
	0x6b, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x13, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4f, 0x0a, 0x0c, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e,
	0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e,
	0x65, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x6d, 0x61, 0x63, 0x68,
	0x69, 0x6e, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x6e, 0x0a, 0x19, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x70, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f,
	0x73, 0x70, 0x65, 0x63, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65,
	0x6e, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x16, 0x64, 0x61, 0x74, 0x61, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x44,
	0x69, 0x73, 0x6b, 0x53, 0x70, 0x65, 0x63, 0x12, 0x4f, 0x0a, 0x0c, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x53, 0x70, 0x65, 0x63, 0x12, 0x6d, 0x0a, 0x14, 0x69, 0x64, 0x6c, 0x65,
	0x5f, 0x73, 0x68, 0x75, 0x74, 0x64, 0x6f, 0x77, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x49, 0x64, 0x6c, 0x65,
	0x53, 0x68, 0x75, 0x74, 0x64, 0x6f, 0x77, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x12, 0x69, 0x64, 0x6c, 0x65, 0x53, 0x68, 0x75, 0x74, 0x64, 0x6f, 0x77,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x51, 0x0a, 0x0a, 0x65, 0x75, 0x63, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f,
	0x6b, 0x45, 0x75, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x09, 0x65, 0x75, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5f, 0x0a, 0x12, 0x73, 0x68,
	0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x5f, 0x76, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x20, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x56, 0x6d, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x73, 0x68, 0x69, 0x65, 0x6c,
	0x64, 0x65, 0x64, 0x56, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x26, 0x0a, 0x0c, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x19, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x54,
	0x61, 0x67, 0x73, 0x12, 0x60, 0x0a, 0x0f, 0x73, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f,
	0x6f, 0x6b, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x73, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x58, 0x0a, 0x0f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0e, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12,
	0x28, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x73,
	0x18, 0x1d, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x61, 0x74,
	0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x61, 0x74,
	0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x69, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73,
	0x50, 0x7a, 0x69, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x47,
	0x0a, 0x0b, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1c, 0x0a,
	0x18, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x48,
	0x45, 0x41, 0x4c, 0x54, 0x48, 0x59, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x55, 0x4e, 0x48, 0x45,
	0x41, 0x4c, 0x54, 0x48, 0x59, 0x10, 0x02, 0x22, 0x99, 0x01, 0x0a, 0x0c, 0x52, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x52, 0x55, 0x4e, 0x54,
	0x49, 0x4d, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49,
	0x4e, 0x47, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x42, 0x45, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x54,
	0x41, 0x52, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x11, 0x0a, 0x0d, 0x42, 0x45, 0x49, 0x4e, 0x47,
	0x5f, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54,
	0x4f, 0x50, 0x50, 0x45, 0x44, 0x10, 0x04, 0x12, 0x12, 0x0a, 0x0e, 0x42, 0x45, 0x49, 0x4e, 0x47,
	0x5f, 0x55, 0x50, 0x47, 0x52, 0x41, 0x44, 0x45, 0x44, 0x10, 0x05, 0x12, 0x09, 0x0a, 0x05, 0x45,
	0x52, 0x52, 0x4f, 0x52, 0x10, 0x64, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49,
	0x44, 0x10, 0x65, 0x3a, 0x7b, 0xea, 0x41, 0x78, 0x0a, 0x29, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x12, 0x4b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6e, 0x6f, 0x74,
	0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x2f, 0x7b, 0x6e,
	0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x7d,
	0x2a, 0x5d, 0x0a, 0x13, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x25, 0x0a, 0x21, 0x4e, 0x4f, 0x54, 0x45, 0x42,
	0x4f, 0x4f, 0x4b, 0x5f, 0x52, 0x55, 0x4e, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10,
	0x0a, 0x0c, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x44, 0x45, 0x46, 0x49, 0x4e, 0x45, 0x44, 0x10, 0x01,
	0x12, 0x0d, 0x0a, 0x09, 0x4f, 0x4e, 0x45, 0x5f, 0x43, 0x4c, 0x49, 0x43, 0x4b, 0x10, 0x02, 0x42,
	0xd2, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x42, 0x14, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1_notebook_runtime_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1_notebook_runtime_proto_rawDescData = file_google_cloud_aiplatform_v1_notebook_runtime_proto_rawDesc
)

func file_google_cloud_aiplatform_v1_notebook_runtime_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1_notebook_runtime_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1_notebook_runtime_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1_notebook_runtime_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1_notebook_runtime_proto_rawDescData
}

var file_google_cloud_aiplatform_v1_notebook_runtime_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_aiplatform_v1_notebook_runtime_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_cloud_aiplatform_v1_notebook_runtime_proto_goTypes = []any{
	(NotebookRuntimeType)(0),           // 0: google.cloud.aiplatform.v1.NotebookRuntimeType
	(NotebookRuntime_HealthState)(0),   // 1: google.cloud.aiplatform.v1.NotebookRuntime.HealthState
	(NotebookRuntime_RuntimeState)(0),  // 2: google.cloud.aiplatform.v1.NotebookRuntime.RuntimeState
	(*NotebookRuntimeTemplate)(nil),    // 3: google.cloud.aiplatform.v1.NotebookRuntimeTemplate
	(*NotebookRuntime)(nil),            // 4: google.cloud.aiplatform.v1.NotebookRuntime
	nil,                                // 5: google.cloud.aiplatform.v1.NotebookRuntimeTemplate.LabelsEntry
	nil,                                // 6: google.cloud.aiplatform.v1.NotebookRuntime.LabelsEntry
	(*MachineSpec)(nil),                // 7: google.cloud.aiplatform.v1.MachineSpec
	(*PersistentDiskSpec)(nil),         // 8: google.cloud.aiplatform.v1.PersistentDiskSpec
	(*NetworkSpec)(nil),                // 9: google.cloud.aiplatform.v1.NetworkSpec
	(*NotebookIdleShutdownConfig)(nil), // 10: google.cloud.aiplatform.v1.NotebookIdleShutdownConfig
	(*NotebookEucConfig)(nil),          // 11: google.cloud.aiplatform.v1.NotebookEucConfig
	(*timestamppb.Timestamp)(nil),      // 12: google.protobuf.Timestamp
	(*ShieldedVmConfig)(nil),           // 13: google.cloud.aiplatform.v1.ShieldedVmConfig
	(*EncryptionSpec)(nil),             // 14: google.cloud.aiplatform.v1.EncryptionSpec
	(*NotebookSoftwareConfig)(nil),     // 15: google.cloud.aiplatform.v1.NotebookSoftwareConfig
	(*NotebookRuntimeTemplateRef)(nil), // 16: google.cloud.aiplatform.v1.NotebookRuntimeTemplateRef
}
var file_google_cloud_aiplatform_v1_notebook_runtime_proto_depIdxs = []int32{
	7,  // 0: google.cloud.aiplatform.v1.NotebookRuntimeTemplate.machine_spec:type_name -> google.cloud.aiplatform.v1.MachineSpec
	8,  // 1: google.cloud.aiplatform.v1.NotebookRuntimeTemplate.data_persistent_disk_spec:type_name -> google.cloud.aiplatform.v1.PersistentDiskSpec
	9,  // 2: google.cloud.aiplatform.v1.NotebookRuntimeTemplate.network_spec:type_name -> google.cloud.aiplatform.v1.NetworkSpec
	5,  // 3: google.cloud.aiplatform.v1.NotebookRuntimeTemplate.labels:type_name -> google.cloud.aiplatform.v1.NotebookRuntimeTemplate.LabelsEntry
	10, // 4: google.cloud.aiplatform.v1.NotebookRuntimeTemplate.idle_shutdown_config:type_name -> google.cloud.aiplatform.v1.NotebookIdleShutdownConfig
	11, // 5: google.cloud.aiplatform.v1.NotebookRuntimeTemplate.euc_config:type_name -> google.cloud.aiplatform.v1.NotebookEucConfig
	12, // 6: google.cloud.aiplatform.v1.NotebookRuntimeTemplate.create_time:type_name -> google.protobuf.Timestamp
	12, // 7: google.cloud.aiplatform.v1.NotebookRuntimeTemplate.update_time:type_name -> google.protobuf.Timestamp
	0,  // 8: google.cloud.aiplatform.v1.NotebookRuntimeTemplate.notebook_runtime_type:type_name -> google.cloud.aiplatform.v1.NotebookRuntimeType
	13, // 9: google.cloud.aiplatform.v1.NotebookRuntimeTemplate.shielded_vm_config:type_name -> google.cloud.aiplatform.v1.ShieldedVmConfig
	14, // 10: google.cloud.aiplatform.v1.NotebookRuntimeTemplate.encryption_spec:type_name -> google.cloud.aiplatform.v1.EncryptionSpec
	15, // 11: google.cloud.aiplatform.v1.NotebookRuntimeTemplate.software_config:type_name -> google.cloud.aiplatform.v1.NotebookSoftwareConfig
	16, // 12: google.cloud.aiplatform.v1.NotebookRuntime.notebook_runtime_template_ref:type_name -> google.cloud.aiplatform.v1.NotebookRuntimeTemplateRef
	12, // 13: google.cloud.aiplatform.v1.NotebookRuntime.create_time:type_name -> google.protobuf.Timestamp
	12, // 14: google.cloud.aiplatform.v1.NotebookRuntime.update_time:type_name -> google.protobuf.Timestamp
	1,  // 15: google.cloud.aiplatform.v1.NotebookRuntime.health_state:type_name -> google.cloud.aiplatform.v1.NotebookRuntime.HealthState
	2,  // 16: google.cloud.aiplatform.v1.NotebookRuntime.runtime_state:type_name -> google.cloud.aiplatform.v1.NotebookRuntime.RuntimeState
	6,  // 17: google.cloud.aiplatform.v1.NotebookRuntime.labels:type_name -> google.cloud.aiplatform.v1.NotebookRuntime.LabelsEntry
	12, // 18: google.cloud.aiplatform.v1.NotebookRuntime.expiration_time:type_name -> google.protobuf.Timestamp
	0,  // 19: google.cloud.aiplatform.v1.NotebookRuntime.notebook_runtime_type:type_name -> google.cloud.aiplatform.v1.NotebookRuntimeType
	7,  // 20: google.cloud.aiplatform.v1.NotebookRuntime.machine_spec:type_name -> google.cloud.aiplatform.v1.MachineSpec
	8,  // 21: google.cloud.aiplatform.v1.NotebookRuntime.data_persistent_disk_spec:type_name -> google.cloud.aiplatform.v1.PersistentDiskSpec
	9,  // 22: google.cloud.aiplatform.v1.NotebookRuntime.network_spec:type_name -> google.cloud.aiplatform.v1.NetworkSpec
	10, // 23: google.cloud.aiplatform.v1.NotebookRuntime.idle_shutdown_config:type_name -> google.cloud.aiplatform.v1.NotebookIdleShutdownConfig
	11, // 24: google.cloud.aiplatform.v1.NotebookRuntime.euc_config:type_name -> google.cloud.aiplatform.v1.NotebookEucConfig
	13, // 25: google.cloud.aiplatform.v1.NotebookRuntime.shielded_vm_config:type_name -> google.cloud.aiplatform.v1.ShieldedVmConfig
	15, // 26: google.cloud.aiplatform.v1.NotebookRuntime.software_config:type_name -> google.cloud.aiplatform.v1.NotebookSoftwareConfig
	14, // 27: google.cloud.aiplatform.v1.NotebookRuntime.encryption_spec:type_name -> google.cloud.aiplatform.v1.EncryptionSpec
	28, // [28:28] is the sub-list for method output_type
	28, // [28:28] is the sub-list for method input_type
	28, // [28:28] is the sub-list for extension type_name
	28, // [28:28] is the sub-list for extension extendee
	0,  // [0:28] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1_notebook_runtime_proto_init() }
func file_google_cloud_aiplatform_v1_notebook_runtime_proto_init() {
	if File_google_cloud_aiplatform_v1_notebook_runtime_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1_encryption_spec_proto_init()
	file_google_cloud_aiplatform_v1_machine_resources_proto_init()
	file_google_cloud_aiplatform_v1_network_spec_proto_init()
	file_google_cloud_aiplatform_v1_notebook_euc_config_proto_init()
	file_google_cloud_aiplatform_v1_notebook_idle_shutdown_config_proto_init()
	file_google_cloud_aiplatform_v1_notebook_runtime_template_ref_proto_init()
	file_google_cloud_aiplatform_v1_notebook_software_config_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1_notebook_runtime_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1_notebook_runtime_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1_notebook_runtime_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1_notebook_runtime_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1_notebook_runtime_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1_notebook_runtime_proto = out.File
	file_google_cloud_aiplatform_v1_notebook_runtime_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1_notebook_runtime_proto_goTypes = nil
	file_google_cloud_aiplatform_v1_notebook_runtime_proto_depIdxs = nil
}
