// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

//go:build go1.23

package admin

import (
	"iter"

	adminpb "cloud.google.com/go/analytics/admin/apiv1alpha/adminpb"
	"github.com/googleapis/gax-go/v2/iterator"
)

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *AccessBindingIterator) All() iter.Seq2[*adminpb.AccessBinding, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *AccountIterator) All() iter.Seq2[*adminpb.Account, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *AccountSummaryIterator) All() iter.Seq2[*adminpb.AccountSummary, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *AdSenseLinkIterator) All() iter.Seq2[*adminpb.AdSenseLink, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *AudienceIterator) All() iter.Seq2[*adminpb.Audience, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *BigQueryLinkIterator) All() iter.Seq2[*adminpb.BigQueryLink, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *CalculatedMetricIterator) All() iter.Seq2[*adminpb.CalculatedMetric, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *ChangeHistoryEventIterator) All() iter.Seq2[*adminpb.ChangeHistoryEvent, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *ChannelGroupIterator) All() iter.Seq2[*adminpb.ChannelGroup, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *ConversionEventIterator) All() iter.Seq2[*adminpb.ConversionEvent, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *CustomDimensionIterator) All() iter.Seq2[*adminpb.CustomDimension, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *CustomMetricIterator) All() iter.Seq2[*adminpb.CustomMetric, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *DataStreamIterator) All() iter.Seq2[*adminpb.DataStream, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *DisplayVideo360AdvertiserLinkIterator) All() iter.Seq2[*adminpb.DisplayVideo360AdvertiserLink, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *DisplayVideo360AdvertiserLinkProposalIterator) All() iter.Seq2[*adminpb.DisplayVideo360AdvertiserLinkProposal, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *EventCreateRuleIterator) All() iter.Seq2[*adminpb.EventCreateRule, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *EventEditRuleIterator) All() iter.Seq2[*adminpb.EventEditRule, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *ExpandedDataSetIterator) All() iter.Seq2[*adminpb.ExpandedDataSet, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *FirebaseLinkIterator) All() iter.Seq2[*adminpb.FirebaseLink, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *GoogleAdsLinkIterator) All() iter.Seq2[*adminpb.GoogleAdsLink, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *KeyEventIterator) All() iter.Seq2[*adminpb.KeyEvent, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *MeasurementProtocolSecretIterator) All() iter.Seq2[*adminpb.MeasurementProtocolSecret, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *PropertyIterator) All() iter.Seq2[*adminpb.Property, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *ReportingDataAnnotationIterator) All() iter.Seq2[*adminpb.ReportingDataAnnotation, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *RollupPropertySourceLinkIterator) All() iter.Seq2[*adminpb.RollupPropertySourceLink, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *SKAdNetworkConversionValueSchemaIterator) All() iter.Seq2[*adminpb.SKAdNetworkConversionValueSchema, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *SearchAds360LinkIterator) All() iter.Seq2[*adminpb.SearchAds360Link, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *SubpropertyEventFilterIterator) All() iter.Seq2[*adminpb.SubpropertyEventFilter, error] {
	return iterator.RangeAdapter(it.Next)
}
