// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/bigtable/v2/bigtable.proto

package bigtablepb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Bigtable_ReadRows_FullMethodName                              = "/google.bigtable.v2.Bigtable/ReadRows"
	Bigtable_SampleRowKeys_FullMethodName                         = "/google.bigtable.v2.Bigtable/SampleRowKeys"
	Bigtable_MutateRow_FullMethodName                             = "/google.bigtable.v2.Bigtable/MutateRow"
	Bigtable_MutateRows_FullMethodName                            = "/google.bigtable.v2.Bigtable/MutateRows"
	Bigtable_CheckAndMutateRow_FullMethodName                     = "/google.bigtable.v2.Bigtable/CheckAndMutateRow"
	Bigtable_PingAndWarm_FullMethodName                           = "/google.bigtable.v2.Bigtable/PingAndWarm"
	Bigtable_ReadModifyWriteRow_FullMethodName                    = "/google.bigtable.v2.Bigtable/ReadModifyWriteRow"
	Bigtable_GenerateInitialChangeStreamPartitions_FullMethodName = "/google.bigtable.v2.Bigtable/GenerateInitialChangeStreamPartitions"
	Bigtable_ReadChangeStream_FullMethodName                      = "/google.bigtable.v2.Bigtable/ReadChangeStream"
	Bigtable_PrepareQuery_FullMethodName                          = "/google.bigtable.v2.Bigtable/PrepareQuery"
	Bigtable_ExecuteQuery_FullMethodName                          = "/google.bigtable.v2.Bigtable/ExecuteQuery"
)

// BigtableClient is the client API for Bigtable service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type BigtableClient interface {
	// Streams back the contents of all requested rows in key order, optionally
	// applying the same Reader filter to each. Depending on their size,
	// rows and cells may be broken up across multiple responses, but
	// atomicity of each row will still be preserved. See the
	// ReadRowsResponse documentation for details.
	ReadRows(ctx context.Context, in *ReadRowsRequest, opts ...grpc.CallOption) (Bigtable_ReadRowsClient, error)
	// Returns a sample of row keys in the table. The returned row keys will
	// delimit contiguous sections of the table of approximately equal size,
	// which can be used to break up the data for distributed tasks like
	// mapreduces.
	SampleRowKeys(ctx context.Context, in *SampleRowKeysRequest, opts ...grpc.CallOption) (Bigtable_SampleRowKeysClient, error)
	// Mutates a row atomically. Cells already present in the row are left
	// unchanged unless explicitly changed by `mutation`.
	MutateRow(ctx context.Context, in *MutateRowRequest, opts ...grpc.CallOption) (*MutateRowResponse, error)
	// Mutates multiple rows in a batch. Each individual row is mutated
	// atomically as in MutateRow, but the entire batch is not executed
	// atomically.
	MutateRows(ctx context.Context, in *MutateRowsRequest, opts ...grpc.CallOption) (Bigtable_MutateRowsClient, error)
	// Mutates a row atomically based on the output of a predicate Reader filter.
	CheckAndMutateRow(ctx context.Context, in *CheckAndMutateRowRequest, opts ...grpc.CallOption) (*CheckAndMutateRowResponse, error)
	// Warm up associated instance metadata for this connection.
	// This call is not required but may be useful for connection keep-alive.
	PingAndWarm(ctx context.Context, in *PingAndWarmRequest, opts ...grpc.CallOption) (*PingAndWarmResponse, error)
	// Modifies a row atomically on the server. The method reads the latest
	// existing timestamp and value from the specified columns and writes a new
	// entry based on pre-defined read/modify/write rules. The new value for the
	// timestamp is the greater of the existing timestamp or the current server
	// time. The method returns the new contents of all modified cells.
	ReadModifyWriteRow(ctx context.Context, in *ReadModifyWriteRowRequest, opts ...grpc.CallOption) (*ReadModifyWriteRowResponse, error)
	// Returns the current list of partitions that make up the table's
	// change stream. The union of partitions will cover the entire keyspace.
	// Partitions can be read with `ReadChangeStream`.
	// NOTE: This API is only intended to be used by Apache Beam BigtableIO.
	GenerateInitialChangeStreamPartitions(ctx context.Context, in *GenerateInitialChangeStreamPartitionsRequest, opts ...grpc.CallOption) (Bigtable_GenerateInitialChangeStreamPartitionsClient, error)
	// Reads changes from a table's change stream. Changes will
	// reflect both user-initiated mutations and mutations that are caused by
	// garbage collection.
	// NOTE: This API is only intended to be used by Apache Beam BigtableIO.
	ReadChangeStream(ctx context.Context, in *ReadChangeStreamRequest, opts ...grpc.CallOption) (Bigtable_ReadChangeStreamClient, error)
	// Prepares a GoogleSQL query for execution on a particular Bigtable instance.
	PrepareQuery(ctx context.Context, in *PrepareQueryRequest, opts ...grpc.CallOption) (*PrepareQueryResponse, error)
	// Executes a SQL query against a particular Bigtable instance.
	ExecuteQuery(ctx context.Context, in *ExecuteQueryRequest, opts ...grpc.CallOption) (Bigtable_ExecuteQueryClient, error)
}

type bigtableClient struct {
	cc grpc.ClientConnInterface
}

func NewBigtableClient(cc grpc.ClientConnInterface) BigtableClient {
	return &bigtableClient{cc}
}

func (c *bigtableClient) ReadRows(ctx context.Context, in *ReadRowsRequest, opts ...grpc.CallOption) (Bigtable_ReadRowsClient, error) {
	stream, err := c.cc.NewStream(ctx, &Bigtable_ServiceDesc.Streams[0], Bigtable_ReadRows_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &bigtableReadRowsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Bigtable_ReadRowsClient interface {
	Recv() (*ReadRowsResponse, error)
	grpc.ClientStream
}

type bigtableReadRowsClient struct {
	grpc.ClientStream
}

func (x *bigtableReadRowsClient) Recv() (*ReadRowsResponse, error) {
	m := new(ReadRowsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *bigtableClient) SampleRowKeys(ctx context.Context, in *SampleRowKeysRequest, opts ...grpc.CallOption) (Bigtable_SampleRowKeysClient, error) {
	stream, err := c.cc.NewStream(ctx, &Bigtable_ServiceDesc.Streams[1], Bigtable_SampleRowKeys_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &bigtableSampleRowKeysClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Bigtable_SampleRowKeysClient interface {
	Recv() (*SampleRowKeysResponse, error)
	grpc.ClientStream
}

type bigtableSampleRowKeysClient struct {
	grpc.ClientStream
}

func (x *bigtableSampleRowKeysClient) Recv() (*SampleRowKeysResponse, error) {
	m := new(SampleRowKeysResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *bigtableClient) MutateRow(ctx context.Context, in *MutateRowRequest, opts ...grpc.CallOption) (*MutateRowResponse, error) {
	out := new(MutateRowResponse)
	err := c.cc.Invoke(ctx, Bigtable_MutateRow_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableClient) MutateRows(ctx context.Context, in *MutateRowsRequest, opts ...grpc.CallOption) (Bigtable_MutateRowsClient, error) {
	stream, err := c.cc.NewStream(ctx, &Bigtable_ServiceDesc.Streams[2], Bigtable_MutateRows_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &bigtableMutateRowsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Bigtable_MutateRowsClient interface {
	Recv() (*MutateRowsResponse, error)
	grpc.ClientStream
}

type bigtableMutateRowsClient struct {
	grpc.ClientStream
}

func (x *bigtableMutateRowsClient) Recv() (*MutateRowsResponse, error) {
	m := new(MutateRowsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *bigtableClient) CheckAndMutateRow(ctx context.Context, in *CheckAndMutateRowRequest, opts ...grpc.CallOption) (*CheckAndMutateRowResponse, error) {
	out := new(CheckAndMutateRowResponse)
	err := c.cc.Invoke(ctx, Bigtable_CheckAndMutateRow_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableClient) PingAndWarm(ctx context.Context, in *PingAndWarmRequest, opts ...grpc.CallOption) (*PingAndWarmResponse, error) {
	out := new(PingAndWarmResponse)
	err := c.cc.Invoke(ctx, Bigtable_PingAndWarm_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableClient) ReadModifyWriteRow(ctx context.Context, in *ReadModifyWriteRowRequest, opts ...grpc.CallOption) (*ReadModifyWriteRowResponse, error) {
	out := new(ReadModifyWriteRowResponse)
	err := c.cc.Invoke(ctx, Bigtable_ReadModifyWriteRow_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableClient) GenerateInitialChangeStreamPartitions(ctx context.Context, in *GenerateInitialChangeStreamPartitionsRequest, opts ...grpc.CallOption) (Bigtable_GenerateInitialChangeStreamPartitionsClient, error) {
	stream, err := c.cc.NewStream(ctx, &Bigtable_ServiceDesc.Streams[3], Bigtable_GenerateInitialChangeStreamPartitions_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &bigtableGenerateInitialChangeStreamPartitionsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Bigtable_GenerateInitialChangeStreamPartitionsClient interface {
	Recv() (*GenerateInitialChangeStreamPartitionsResponse, error)
	grpc.ClientStream
}

type bigtableGenerateInitialChangeStreamPartitionsClient struct {
	grpc.ClientStream
}

func (x *bigtableGenerateInitialChangeStreamPartitionsClient) Recv() (*GenerateInitialChangeStreamPartitionsResponse, error) {
	m := new(GenerateInitialChangeStreamPartitionsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *bigtableClient) ReadChangeStream(ctx context.Context, in *ReadChangeStreamRequest, opts ...grpc.CallOption) (Bigtable_ReadChangeStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &Bigtable_ServiceDesc.Streams[4], Bigtable_ReadChangeStream_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &bigtableReadChangeStreamClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Bigtable_ReadChangeStreamClient interface {
	Recv() (*ReadChangeStreamResponse, error)
	grpc.ClientStream
}

type bigtableReadChangeStreamClient struct {
	grpc.ClientStream
}

func (x *bigtableReadChangeStreamClient) Recv() (*ReadChangeStreamResponse, error) {
	m := new(ReadChangeStreamResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *bigtableClient) PrepareQuery(ctx context.Context, in *PrepareQueryRequest, opts ...grpc.CallOption) (*PrepareQueryResponse, error) {
	out := new(PrepareQueryResponse)
	err := c.cc.Invoke(ctx, Bigtable_PrepareQuery_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableClient) ExecuteQuery(ctx context.Context, in *ExecuteQueryRequest, opts ...grpc.CallOption) (Bigtable_ExecuteQueryClient, error) {
	stream, err := c.cc.NewStream(ctx, &Bigtable_ServiceDesc.Streams[5], Bigtable_ExecuteQuery_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &bigtableExecuteQueryClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Bigtable_ExecuteQueryClient interface {
	Recv() (*ExecuteQueryResponse, error)
	grpc.ClientStream
}

type bigtableExecuteQueryClient struct {
	grpc.ClientStream
}

func (x *bigtableExecuteQueryClient) Recv() (*ExecuteQueryResponse, error) {
	m := new(ExecuteQueryResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BigtableServer is the server API for Bigtable service.
// All implementations should embed UnimplementedBigtableServer
// for forward compatibility
type BigtableServer interface {
	// Streams back the contents of all requested rows in key order, optionally
	// applying the same Reader filter to each. Depending on their size,
	// rows and cells may be broken up across multiple responses, but
	// atomicity of each row will still be preserved. See the
	// ReadRowsResponse documentation for details.
	ReadRows(*ReadRowsRequest, Bigtable_ReadRowsServer) error
	// Returns a sample of row keys in the table. The returned row keys will
	// delimit contiguous sections of the table of approximately equal size,
	// which can be used to break up the data for distributed tasks like
	// mapreduces.
	SampleRowKeys(*SampleRowKeysRequest, Bigtable_SampleRowKeysServer) error
	// Mutates a row atomically. Cells already present in the row are left
	// unchanged unless explicitly changed by `mutation`.
	MutateRow(context.Context, *MutateRowRequest) (*MutateRowResponse, error)
	// Mutates multiple rows in a batch. Each individual row is mutated
	// atomically as in MutateRow, but the entire batch is not executed
	// atomically.
	MutateRows(*MutateRowsRequest, Bigtable_MutateRowsServer) error
	// Mutates a row atomically based on the output of a predicate Reader filter.
	CheckAndMutateRow(context.Context, *CheckAndMutateRowRequest) (*CheckAndMutateRowResponse, error)
	// Warm up associated instance metadata for this connection.
	// This call is not required but may be useful for connection keep-alive.
	PingAndWarm(context.Context, *PingAndWarmRequest) (*PingAndWarmResponse, error)
	// Modifies a row atomically on the server. The method reads the latest
	// existing timestamp and value from the specified columns and writes a new
	// entry based on pre-defined read/modify/write rules. The new value for the
	// timestamp is the greater of the existing timestamp or the current server
	// time. The method returns the new contents of all modified cells.
	ReadModifyWriteRow(context.Context, *ReadModifyWriteRowRequest) (*ReadModifyWriteRowResponse, error)
	// Returns the current list of partitions that make up the table's
	// change stream. The union of partitions will cover the entire keyspace.
	// Partitions can be read with `ReadChangeStream`.
	// NOTE: This API is only intended to be used by Apache Beam BigtableIO.
	GenerateInitialChangeStreamPartitions(*GenerateInitialChangeStreamPartitionsRequest, Bigtable_GenerateInitialChangeStreamPartitionsServer) error
	// Reads changes from a table's change stream. Changes will
	// reflect both user-initiated mutations and mutations that are caused by
	// garbage collection.
	// NOTE: This API is only intended to be used by Apache Beam BigtableIO.
	ReadChangeStream(*ReadChangeStreamRequest, Bigtable_ReadChangeStreamServer) error
	// Prepares a GoogleSQL query for execution on a particular Bigtable instance.
	PrepareQuery(context.Context, *PrepareQueryRequest) (*PrepareQueryResponse, error)
	// Executes a SQL query against a particular Bigtable instance.
	ExecuteQuery(*ExecuteQueryRequest, Bigtable_ExecuteQueryServer) error
}

// UnimplementedBigtableServer should be embedded to have forward compatible implementations.
type UnimplementedBigtableServer struct {
}

func (UnimplementedBigtableServer) ReadRows(*ReadRowsRequest, Bigtable_ReadRowsServer) error {
	return status.Errorf(codes.Unimplemented, "method ReadRows not implemented")
}
func (UnimplementedBigtableServer) SampleRowKeys(*SampleRowKeysRequest, Bigtable_SampleRowKeysServer) error {
	return status.Errorf(codes.Unimplemented, "method SampleRowKeys not implemented")
}
func (UnimplementedBigtableServer) MutateRow(context.Context, *MutateRowRequest) (*MutateRowResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MutateRow not implemented")
}
func (UnimplementedBigtableServer) MutateRows(*MutateRowsRequest, Bigtable_MutateRowsServer) error {
	return status.Errorf(codes.Unimplemented, "method MutateRows not implemented")
}
func (UnimplementedBigtableServer) CheckAndMutateRow(context.Context, *CheckAndMutateRowRequest) (*CheckAndMutateRowResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CheckAndMutateRow not implemented")
}
func (UnimplementedBigtableServer) PingAndWarm(context.Context, *PingAndWarmRequest) (*PingAndWarmResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PingAndWarm not implemented")
}
func (UnimplementedBigtableServer) ReadModifyWriteRow(context.Context, *ReadModifyWriteRowRequest) (*ReadModifyWriteRowResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReadModifyWriteRow not implemented")
}
func (UnimplementedBigtableServer) GenerateInitialChangeStreamPartitions(*GenerateInitialChangeStreamPartitionsRequest, Bigtable_GenerateInitialChangeStreamPartitionsServer) error {
	return status.Errorf(codes.Unimplemented, "method GenerateInitialChangeStreamPartitions not implemented")
}
func (UnimplementedBigtableServer) ReadChangeStream(*ReadChangeStreamRequest, Bigtable_ReadChangeStreamServer) error {
	return status.Errorf(codes.Unimplemented, "method ReadChangeStream not implemented")
}
func (UnimplementedBigtableServer) PrepareQuery(context.Context, *PrepareQueryRequest) (*PrepareQueryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PrepareQuery not implemented")
}
func (UnimplementedBigtableServer) ExecuteQuery(*ExecuteQueryRequest, Bigtable_ExecuteQueryServer) error {
	return status.Errorf(codes.Unimplemented, "method ExecuteQuery not implemented")
}

// UnsafeBigtableServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to BigtableServer will
// result in compilation errors.
type UnsafeBigtableServer interface {
	mustEmbedUnimplementedBigtableServer()
}

func RegisterBigtableServer(s grpc.ServiceRegistrar, srv BigtableServer) {
	s.RegisterService(&Bigtable_ServiceDesc, srv)
}

func _Bigtable_ReadRows_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ReadRowsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BigtableServer).ReadRows(m, &bigtableReadRowsServer{stream})
}

type Bigtable_ReadRowsServer interface {
	Send(*ReadRowsResponse) error
	grpc.ServerStream
}

type bigtableReadRowsServer struct {
	grpc.ServerStream
}

func (x *bigtableReadRowsServer) Send(m *ReadRowsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Bigtable_SampleRowKeys_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(SampleRowKeysRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BigtableServer).SampleRowKeys(m, &bigtableSampleRowKeysServer{stream})
}

type Bigtable_SampleRowKeysServer interface {
	Send(*SampleRowKeysResponse) error
	grpc.ServerStream
}

type bigtableSampleRowKeysServer struct {
	grpc.ServerStream
}

func (x *bigtableSampleRowKeysServer) Send(m *SampleRowKeysResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Bigtable_MutateRow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateRowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableServer).MutateRow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bigtable_MutateRow_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableServer).MutateRow(ctx, req.(*MutateRowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bigtable_MutateRows_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(MutateRowsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BigtableServer).MutateRows(m, &bigtableMutateRowsServer{stream})
}

type Bigtable_MutateRowsServer interface {
	Send(*MutateRowsResponse) error
	grpc.ServerStream
}

type bigtableMutateRowsServer struct {
	grpc.ServerStream
}

func (x *bigtableMutateRowsServer) Send(m *MutateRowsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Bigtable_CheckAndMutateRow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckAndMutateRowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableServer).CheckAndMutateRow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bigtable_CheckAndMutateRow_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableServer).CheckAndMutateRow(ctx, req.(*CheckAndMutateRowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bigtable_PingAndWarm_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PingAndWarmRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableServer).PingAndWarm(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bigtable_PingAndWarm_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableServer).PingAndWarm(ctx, req.(*PingAndWarmRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bigtable_ReadModifyWriteRow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReadModifyWriteRowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableServer).ReadModifyWriteRow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bigtable_ReadModifyWriteRow_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableServer).ReadModifyWriteRow(ctx, req.(*ReadModifyWriteRowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bigtable_GenerateInitialChangeStreamPartitions_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GenerateInitialChangeStreamPartitionsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BigtableServer).GenerateInitialChangeStreamPartitions(m, &bigtableGenerateInitialChangeStreamPartitionsServer{stream})
}

type Bigtable_GenerateInitialChangeStreamPartitionsServer interface {
	Send(*GenerateInitialChangeStreamPartitionsResponse) error
	grpc.ServerStream
}

type bigtableGenerateInitialChangeStreamPartitionsServer struct {
	grpc.ServerStream
}

func (x *bigtableGenerateInitialChangeStreamPartitionsServer) Send(m *GenerateInitialChangeStreamPartitionsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Bigtable_ReadChangeStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ReadChangeStreamRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BigtableServer).ReadChangeStream(m, &bigtableReadChangeStreamServer{stream})
}

type Bigtable_ReadChangeStreamServer interface {
	Send(*ReadChangeStreamResponse) error
	grpc.ServerStream
}

type bigtableReadChangeStreamServer struct {
	grpc.ServerStream
}

func (x *bigtableReadChangeStreamServer) Send(m *ReadChangeStreamResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Bigtable_PrepareQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PrepareQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableServer).PrepareQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Bigtable_PrepareQuery_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableServer).PrepareQuery(ctx, req.(*PrepareQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bigtable_ExecuteQuery_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ExecuteQueryRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BigtableServer).ExecuteQuery(m, &bigtableExecuteQueryServer{stream})
}

type Bigtable_ExecuteQueryServer interface {
	Send(*ExecuteQueryResponse) error
	grpc.ServerStream
}

type bigtableExecuteQueryServer struct {
	grpc.ServerStream
}

func (x *bigtableExecuteQueryServer) Send(m *ExecuteQueryResponse) error {
	return x.ServerStream.SendMsg(m)
}

// Bigtable_ServiceDesc is the grpc.ServiceDesc for Bigtable service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Bigtable_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.bigtable.v2.Bigtable",
	HandlerType: (*BigtableServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "MutateRow",
			Handler:    _Bigtable_MutateRow_Handler,
		},
		{
			MethodName: "CheckAndMutateRow",
			Handler:    _Bigtable_CheckAndMutateRow_Handler,
		},
		{
			MethodName: "PingAndWarm",
			Handler:    _Bigtable_PingAndWarm_Handler,
		},
		{
			MethodName: "ReadModifyWriteRow",
			Handler:    _Bigtable_ReadModifyWriteRow_Handler,
		},
		{
			MethodName: "PrepareQuery",
			Handler:    _Bigtable_PrepareQuery_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ReadRows",
			Handler:       _Bigtable_ReadRows_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "SampleRowKeys",
			Handler:       _Bigtable_SampleRowKeys_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "MutateRows",
			Handler:       _Bigtable_MutateRows_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GenerateInitialChangeStreamPartitions",
			Handler:       _Bigtable_GenerateInitialChangeStreamPartitions_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ReadChangeStream",
			Handler:       _Bigtable_ReadChangeStream_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ExecuteQuery",
			Handler:       _Bigtable_ExecuteQuery_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/bigtable/v2/bigtable.proto",
}
