// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/dataproc/v1/session_templates.proto

package dataprocpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A request to create a session template.
type CreateSessionTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource where this session template will be created.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The session template to create.
	SessionTemplate *SessionTemplate `protobuf:"bytes,3,opt,name=session_template,json=sessionTemplate,proto3" json:"session_template,omitempty"`
}

func (x *CreateSessionTemplateRequest) Reset() {
	*x = CreateSessionTemplateRequest{}
	mi := &file_google_cloud_dataproc_v1_session_templates_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateSessionTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSessionTemplateRequest) ProtoMessage() {}

func (x *CreateSessionTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_session_templates_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSessionTemplateRequest.ProtoReflect.Descriptor instead.
func (*CreateSessionTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_session_templates_proto_rawDescGZIP(), []int{0}
}

func (x *CreateSessionTemplateRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSessionTemplateRequest) GetSessionTemplate() *SessionTemplate {
	if x != nil {
		return x.SessionTemplate
	}
	return nil
}

// A request to update a session template.
type UpdateSessionTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The updated session template.
	SessionTemplate *SessionTemplate `protobuf:"bytes,1,opt,name=session_template,json=sessionTemplate,proto3" json:"session_template,omitempty"`
}

func (x *UpdateSessionTemplateRequest) Reset() {
	*x = UpdateSessionTemplateRequest{}
	mi := &file_google_cloud_dataproc_v1_session_templates_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateSessionTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSessionTemplateRequest) ProtoMessage() {}

func (x *UpdateSessionTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_session_templates_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSessionTemplateRequest.ProtoReflect.Descriptor instead.
func (*UpdateSessionTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_session_templates_proto_rawDescGZIP(), []int{1}
}

func (x *UpdateSessionTemplateRequest) GetSessionTemplate() *SessionTemplate {
	if x != nil {
		return x.SessionTemplate
	}
	return nil
}

// A request to get the resource representation for a session template.
type GetSessionTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the session template to retrieve.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSessionTemplateRequest) Reset() {
	*x = GetSessionTemplateRequest{}
	mi := &file_google_cloud_dataproc_v1_session_templates_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSessionTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSessionTemplateRequest) ProtoMessage() {}

func (x *GetSessionTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_session_templates_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSessionTemplateRequest.ProtoReflect.Descriptor instead.
func (*GetSessionTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_session_templates_proto_rawDescGZIP(), []int{2}
}

func (x *GetSessionTemplateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A request to list session templates in a project.
type ListSessionTemplatesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent that owns this collection of session templates.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of sessions to return in each response.
	// The service may return fewer than this value.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token received from a previous `ListSessions` call.
	// Provide this token to retrieve the subsequent page.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. A filter for the session templates to return in the response.
	// Filters are case sensitive and have the following syntax:
	//
	// [field = value] AND [field [= value]] ...
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListSessionTemplatesRequest) Reset() {
	*x = ListSessionTemplatesRequest{}
	mi := &file_google_cloud_dataproc_v1_session_templates_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSessionTemplatesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSessionTemplatesRequest) ProtoMessage() {}

func (x *ListSessionTemplatesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_session_templates_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSessionTemplatesRequest.ProtoReflect.Descriptor instead.
func (*ListSessionTemplatesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_session_templates_proto_rawDescGZIP(), []int{3}
}

func (x *ListSessionTemplatesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSessionTemplatesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSessionTemplatesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListSessionTemplatesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// A list of session templates.
type ListSessionTemplatesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Session template list
	SessionTemplates []*SessionTemplate `protobuf:"bytes,1,rep,name=session_templates,json=sessionTemplates,proto3" json:"session_templates,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSessionTemplatesResponse) Reset() {
	*x = ListSessionTemplatesResponse{}
	mi := &file_google_cloud_dataproc_v1_session_templates_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSessionTemplatesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSessionTemplatesResponse) ProtoMessage() {}

func (x *ListSessionTemplatesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_session_templates_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSessionTemplatesResponse.ProtoReflect.Descriptor instead.
func (*ListSessionTemplatesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_session_templates_proto_rawDescGZIP(), []int{4}
}

func (x *ListSessionTemplatesResponse) GetSessionTemplates() []*SessionTemplate {
	if x != nil {
		return x.SessionTemplates
	}
	return nil
}

func (x *ListSessionTemplatesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// A request to delete a session template.
type DeleteSessionTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the session template resource to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteSessionTemplateRequest) Reset() {
	*x = DeleteSessionTemplateRequest{}
	mi := &file_google_cloud_dataproc_v1_session_templates_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteSessionTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSessionTemplateRequest) ProtoMessage() {}

func (x *DeleteSessionTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_session_templates_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSessionTemplateRequest.ProtoReflect.Descriptor instead.
func (*DeleteSessionTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_session_templates_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteSessionTemplateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A representation of a session template.
type SessionTemplate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the session template.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Brief description of the template.
	Description string `protobuf:"bytes,9,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The time when the template was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The session configuration.
	//
	// Types that are assignable to SessionConfig:
	//
	//	*SessionTemplate_JupyterSession
	//	*SessionTemplate_SparkConnectSession
	SessionConfig isSessionTemplate_SessionConfig `protobuf_oneof:"session_config"`
	// Output only. The email address of the user who created the template.
	Creator string `protobuf:"bytes,5,opt,name=creator,proto3" json:"creator,omitempty"`
	// Optional. Labels to associate with sessions created using this template.
	// Label **keys** must contain 1 to 63 characters, and must conform to
	// [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
	// Label **values** can be empty, but, if present, must contain 1 to 63
	// characters and conform to [RFC
	// 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
	// associated with a session.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Runtime configuration for session execution.
	RuntimeConfig *RuntimeConfig `protobuf:"bytes,7,opt,name=runtime_config,json=runtimeConfig,proto3" json:"runtime_config,omitempty"`
	// Optional. Environment configuration for session execution.
	EnvironmentConfig *EnvironmentConfig `protobuf:"bytes,8,opt,name=environment_config,json=environmentConfig,proto3" json:"environment_config,omitempty"`
	// Output only. The time the template was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. A session template UUID (Unique Universal Identifier). The
	// service generates this value when it creates the session template.
	Uuid string `protobuf:"bytes,12,opt,name=uuid,proto3" json:"uuid,omitempty"`
}

func (x *SessionTemplate) Reset() {
	*x = SessionTemplate{}
	mi := &file_google_cloud_dataproc_v1_session_templates_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SessionTemplate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SessionTemplate) ProtoMessage() {}

func (x *SessionTemplate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_session_templates_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SessionTemplate.ProtoReflect.Descriptor instead.
func (*SessionTemplate) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_session_templates_proto_rawDescGZIP(), []int{6}
}

func (x *SessionTemplate) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SessionTemplate) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *SessionTemplate) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (m *SessionTemplate) GetSessionConfig() isSessionTemplate_SessionConfig {
	if m != nil {
		return m.SessionConfig
	}
	return nil
}

func (x *SessionTemplate) GetJupyterSession() *JupyterConfig {
	if x, ok := x.GetSessionConfig().(*SessionTemplate_JupyterSession); ok {
		return x.JupyterSession
	}
	return nil
}

func (x *SessionTemplate) GetSparkConnectSession() *SparkConnectConfig {
	if x, ok := x.GetSessionConfig().(*SessionTemplate_SparkConnectSession); ok {
		return x.SparkConnectSession
	}
	return nil
}

func (x *SessionTemplate) GetCreator() string {
	if x != nil {
		return x.Creator
	}
	return ""
}

func (x *SessionTemplate) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *SessionTemplate) GetRuntimeConfig() *RuntimeConfig {
	if x != nil {
		return x.RuntimeConfig
	}
	return nil
}

func (x *SessionTemplate) GetEnvironmentConfig() *EnvironmentConfig {
	if x != nil {
		return x.EnvironmentConfig
	}
	return nil
}

func (x *SessionTemplate) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *SessionTemplate) GetUuid() string {
	if x != nil {
		return x.Uuid
	}
	return ""
}

type isSessionTemplate_SessionConfig interface {
	isSessionTemplate_SessionConfig()
}

type SessionTemplate_JupyterSession struct {
	// Optional. Jupyter session config.
	JupyterSession *JupyterConfig `protobuf:"bytes,3,opt,name=jupyter_session,json=jupyterSession,proto3,oneof"`
}

type SessionTemplate_SparkConnectSession struct {
	// Optional. Spark Connect session config.
	SparkConnectSession *SparkConnectConfig `protobuf:"bytes,11,opt,name=spark_connect_session,json=sparkConnectSession,proto3,oneof"`
}

func (*SessionTemplate_JupyterSession) isSessionTemplate_SessionConfig() {}

func (*SessionTemplate_SparkConnectSession) isSessionTemplate_SessionConfig() {}

var File_google_cloud_dataproc_v1_session_templates_proto protoreflect.FileDescriptor

var file_google_cloud_dataproc_v1_session_templates_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2f,
	0x76, 0x31, 0x2f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc2, 0x01,
	0x0a, 0x1c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x12, 0x27, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x59, 0x0a, 0x10, 0x73, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x22, 0x79, 0x0a, 0x1c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x59, 0x0a, 0x10, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x73, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x22, 0x60, 0x0a,
	0x19, 0x47, 0x65, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29,
	0x0a, 0x27, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xc9, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x47, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x12, 0x27, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f,
	0x63, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xa3, 0x01, 0x0a, 0x1c,
	0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5b, 0x0a, 0x11,
	0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x63, 0x0a, 0x1c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f,
	0x63, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x99, 0x07, 0x0a, 0x0f, 0x53, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x57, 0x0a, 0x0f,
	0x6a, 0x75, 0x70, 0x79, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31,
	0x2e, 0x4a, 0x75, 0x70, 0x79, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0e, 0x6a, 0x75, 0x70, 0x79, 0x74, 0x65, 0x72, 0x53, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x67, 0x0a, 0x15, 0x73, 0x70, 0x61, 0x72, 0x6b, 0x5f, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x70, 0x61, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x13, 0x73, 0x70, 0x61, 0x72, 0x6b,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1d,
	0x0a, 0x07, 0x63, 0x72, 0x65, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x63, 0x72, 0x65, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x52, 0x0a,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x12, 0x53, 0x0a, 0x0e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f,
	0x63, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5f, 0x0a, 0x12, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e,
	0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x75, 0x75, 0x69,
	0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x75, 0x75,
	0x69, 0x64, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x71, 0xea,
	0x41, 0x6e, 0x0a, 0x27, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x43, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x7b, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x7d,
	0x42, 0x10, 0x0a, 0x0e, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x32, 0xfa, 0x08, 0x0a, 0x19, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72,
	0x12, 0xe4, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72,
	0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x22, 0x68, 0xda,
	0x41, 0x17, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x3a,
	0x10, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x22, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x12, 0xee, 0x01, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f,
	0x63, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x22, 0x72, 0xda, 0x41, 0x10, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x59, 0x3a,
	0x10, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x32, 0x45, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb9, 0x01, 0x0a, 0x12, 0x47, 0x65, 0x74,
	0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x22,
	0x43, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x12, 0x34,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xcc, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x12, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x45, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x12, 0x34, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x73, 0x12, 0xac, 0x01, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x43, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x2a, 0x34, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x1a, 0x4b, 0xca, 0x41, 0x17, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41,
	0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42,
	0x74, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x42,
	0x15, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2f, 0x76, 0x32, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x70, 0x62, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x72, 0x6f, 0x63, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dataproc_v1_session_templates_proto_rawDescOnce sync.Once
	file_google_cloud_dataproc_v1_session_templates_proto_rawDescData = file_google_cloud_dataproc_v1_session_templates_proto_rawDesc
)

func file_google_cloud_dataproc_v1_session_templates_proto_rawDescGZIP() []byte {
	file_google_cloud_dataproc_v1_session_templates_proto_rawDescOnce.Do(func() {
		file_google_cloud_dataproc_v1_session_templates_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dataproc_v1_session_templates_proto_rawDescData)
	})
	return file_google_cloud_dataproc_v1_session_templates_proto_rawDescData
}

var file_google_cloud_dataproc_v1_session_templates_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_cloud_dataproc_v1_session_templates_proto_goTypes = []any{
	(*CreateSessionTemplateRequest)(nil), // 0: google.cloud.dataproc.v1.CreateSessionTemplateRequest
	(*UpdateSessionTemplateRequest)(nil), // 1: google.cloud.dataproc.v1.UpdateSessionTemplateRequest
	(*GetSessionTemplateRequest)(nil),    // 2: google.cloud.dataproc.v1.GetSessionTemplateRequest
	(*ListSessionTemplatesRequest)(nil),  // 3: google.cloud.dataproc.v1.ListSessionTemplatesRequest
	(*ListSessionTemplatesResponse)(nil), // 4: google.cloud.dataproc.v1.ListSessionTemplatesResponse
	(*DeleteSessionTemplateRequest)(nil), // 5: google.cloud.dataproc.v1.DeleteSessionTemplateRequest
	(*SessionTemplate)(nil),              // 6: google.cloud.dataproc.v1.SessionTemplate
	nil,                                  // 7: google.cloud.dataproc.v1.SessionTemplate.LabelsEntry
	(*timestamppb.Timestamp)(nil),        // 8: google.protobuf.Timestamp
	(*JupyterConfig)(nil),                // 9: google.cloud.dataproc.v1.JupyterConfig
	(*SparkConnectConfig)(nil),           // 10: google.cloud.dataproc.v1.SparkConnectConfig
	(*RuntimeConfig)(nil),                // 11: google.cloud.dataproc.v1.RuntimeConfig
	(*EnvironmentConfig)(nil),            // 12: google.cloud.dataproc.v1.EnvironmentConfig
	(*emptypb.Empty)(nil),                // 13: google.protobuf.Empty
}
var file_google_cloud_dataproc_v1_session_templates_proto_depIdxs = []int32{
	6,  // 0: google.cloud.dataproc.v1.CreateSessionTemplateRequest.session_template:type_name -> google.cloud.dataproc.v1.SessionTemplate
	6,  // 1: google.cloud.dataproc.v1.UpdateSessionTemplateRequest.session_template:type_name -> google.cloud.dataproc.v1.SessionTemplate
	6,  // 2: google.cloud.dataproc.v1.ListSessionTemplatesResponse.session_templates:type_name -> google.cloud.dataproc.v1.SessionTemplate
	8,  // 3: google.cloud.dataproc.v1.SessionTemplate.create_time:type_name -> google.protobuf.Timestamp
	9,  // 4: google.cloud.dataproc.v1.SessionTemplate.jupyter_session:type_name -> google.cloud.dataproc.v1.JupyterConfig
	10, // 5: google.cloud.dataproc.v1.SessionTemplate.spark_connect_session:type_name -> google.cloud.dataproc.v1.SparkConnectConfig
	7,  // 6: google.cloud.dataproc.v1.SessionTemplate.labels:type_name -> google.cloud.dataproc.v1.SessionTemplate.LabelsEntry
	11, // 7: google.cloud.dataproc.v1.SessionTemplate.runtime_config:type_name -> google.cloud.dataproc.v1.RuntimeConfig
	12, // 8: google.cloud.dataproc.v1.SessionTemplate.environment_config:type_name -> google.cloud.dataproc.v1.EnvironmentConfig
	8,  // 9: google.cloud.dataproc.v1.SessionTemplate.update_time:type_name -> google.protobuf.Timestamp
	0,  // 10: google.cloud.dataproc.v1.SessionTemplateController.CreateSessionTemplate:input_type -> google.cloud.dataproc.v1.CreateSessionTemplateRequest
	1,  // 11: google.cloud.dataproc.v1.SessionTemplateController.UpdateSessionTemplate:input_type -> google.cloud.dataproc.v1.UpdateSessionTemplateRequest
	2,  // 12: google.cloud.dataproc.v1.SessionTemplateController.GetSessionTemplate:input_type -> google.cloud.dataproc.v1.GetSessionTemplateRequest
	3,  // 13: google.cloud.dataproc.v1.SessionTemplateController.ListSessionTemplates:input_type -> google.cloud.dataproc.v1.ListSessionTemplatesRequest
	5,  // 14: google.cloud.dataproc.v1.SessionTemplateController.DeleteSessionTemplate:input_type -> google.cloud.dataproc.v1.DeleteSessionTemplateRequest
	6,  // 15: google.cloud.dataproc.v1.SessionTemplateController.CreateSessionTemplate:output_type -> google.cloud.dataproc.v1.SessionTemplate
	6,  // 16: google.cloud.dataproc.v1.SessionTemplateController.UpdateSessionTemplate:output_type -> google.cloud.dataproc.v1.SessionTemplate
	6,  // 17: google.cloud.dataproc.v1.SessionTemplateController.GetSessionTemplate:output_type -> google.cloud.dataproc.v1.SessionTemplate
	4,  // 18: google.cloud.dataproc.v1.SessionTemplateController.ListSessionTemplates:output_type -> google.cloud.dataproc.v1.ListSessionTemplatesResponse
	13, // 19: google.cloud.dataproc.v1.SessionTemplateController.DeleteSessionTemplate:output_type -> google.protobuf.Empty
	15, // [15:20] is the sub-list for method output_type
	10, // [10:15] is the sub-list for method input_type
	10, // [10:10] is the sub-list for extension type_name
	10, // [10:10] is the sub-list for extension extendee
	0,  // [0:10] is the sub-list for field type_name
}

func init() { file_google_cloud_dataproc_v1_session_templates_proto_init() }
func file_google_cloud_dataproc_v1_session_templates_proto_init() {
	if File_google_cloud_dataproc_v1_session_templates_proto != nil {
		return
	}
	file_google_cloud_dataproc_v1_sessions_proto_init()
	file_google_cloud_dataproc_v1_shared_proto_init()
	file_google_cloud_dataproc_v1_session_templates_proto_msgTypes[6].OneofWrappers = []any{
		(*SessionTemplate_JupyterSession)(nil),
		(*SessionTemplate_SparkConnectSession)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dataproc_v1_session_templates_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dataproc_v1_session_templates_proto_goTypes,
		DependencyIndexes: file_google_cloud_dataproc_v1_session_templates_proto_depIdxs,
		MessageInfos:      file_google_cloud_dataproc_v1_session_templates_proto_msgTypes,
	}.Build()
	File_google_cloud_dataproc_v1_session_templates_proto = out.File
	file_google_cloud_dataproc_v1_session_templates_proto_rawDesc = nil
	file_google_cloud_dataproc_v1_session_templates_proto_goTypes = nil
	file_google_cloud_dataproc_v1_session_templates_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SessionTemplateControllerClient is the client API for SessionTemplateController service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SessionTemplateControllerClient interface {
	// Create a session template synchronously.
	CreateSessionTemplate(ctx context.Context, in *CreateSessionTemplateRequest, opts ...grpc.CallOption) (*SessionTemplate, error)
	// Updates the session template synchronously.
	UpdateSessionTemplate(ctx context.Context, in *UpdateSessionTemplateRequest, opts ...grpc.CallOption) (*SessionTemplate, error)
	// Gets the resource representation for a session template.
	GetSessionTemplate(ctx context.Context, in *GetSessionTemplateRequest, opts ...grpc.CallOption) (*SessionTemplate, error)
	// Lists session templates.
	ListSessionTemplates(ctx context.Context, in *ListSessionTemplatesRequest, opts ...grpc.CallOption) (*ListSessionTemplatesResponse, error)
	// Deletes a session template.
	DeleteSessionTemplate(ctx context.Context, in *DeleteSessionTemplateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type sessionTemplateControllerClient struct {
	cc grpc.ClientConnInterface
}

func NewSessionTemplateControllerClient(cc grpc.ClientConnInterface) SessionTemplateControllerClient {
	return &sessionTemplateControllerClient{cc}
}

func (c *sessionTemplateControllerClient) CreateSessionTemplate(ctx context.Context, in *CreateSessionTemplateRequest, opts ...grpc.CallOption) (*SessionTemplate, error) {
	out := new(SessionTemplate)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.SessionTemplateController/CreateSessionTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sessionTemplateControllerClient) UpdateSessionTemplate(ctx context.Context, in *UpdateSessionTemplateRequest, opts ...grpc.CallOption) (*SessionTemplate, error) {
	out := new(SessionTemplate)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.SessionTemplateController/UpdateSessionTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sessionTemplateControllerClient) GetSessionTemplate(ctx context.Context, in *GetSessionTemplateRequest, opts ...grpc.CallOption) (*SessionTemplate, error) {
	out := new(SessionTemplate)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.SessionTemplateController/GetSessionTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sessionTemplateControllerClient) ListSessionTemplates(ctx context.Context, in *ListSessionTemplatesRequest, opts ...grpc.CallOption) (*ListSessionTemplatesResponse, error) {
	out := new(ListSessionTemplatesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.SessionTemplateController/ListSessionTemplates", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sessionTemplateControllerClient) DeleteSessionTemplate(ctx context.Context, in *DeleteSessionTemplateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.SessionTemplateController/DeleteSessionTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SessionTemplateControllerServer is the server API for SessionTemplateController service.
type SessionTemplateControllerServer interface {
	// Create a session template synchronously.
	CreateSessionTemplate(context.Context, *CreateSessionTemplateRequest) (*SessionTemplate, error)
	// Updates the session template synchronously.
	UpdateSessionTemplate(context.Context, *UpdateSessionTemplateRequest) (*SessionTemplate, error)
	// Gets the resource representation for a session template.
	GetSessionTemplate(context.Context, *GetSessionTemplateRequest) (*SessionTemplate, error)
	// Lists session templates.
	ListSessionTemplates(context.Context, *ListSessionTemplatesRequest) (*ListSessionTemplatesResponse, error)
	// Deletes a session template.
	DeleteSessionTemplate(context.Context, *DeleteSessionTemplateRequest) (*emptypb.Empty, error)
}

// UnimplementedSessionTemplateControllerServer can be embedded to have forward compatible implementations.
type UnimplementedSessionTemplateControllerServer struct {
}

func (*UnimplementedSessionTemplateControllerServer) CreateSessionTemplate(context.Context, *CreateSessionTemplateRequest) (*SessionTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSessionTemplate not implemented")
}
func (*UnimplementedSessionTemplateControllerServer) UpdateSessionTemplate(context.Context, *UpdateSessionTemplateRequest) (*SessionTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSessionTemplate not implemented")
}
func (*UnimplementedSessionTemplateControllerServer) GetSessionTemplate(context.Context, *GetSessionTemplateRequest) (*SessionTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSessionTemplate not implemented")
}
func (*UnimplementedSessionTemplateControllerServer) ListSessionTemplates(context.Context, *ListSessionTemplatesRequest) (*ListSessionTemplatesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSessionTemplates not implemented")
}
func (*UnimplementedSessionTemplateControllerServer) DeleteSessionTemplate(context.Context, *DeleteSessionTemplateRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSessionTemplate not implemented")
}

func RegisterSessionTemplateControllerServer(s *grpc.Server, srv SessionTemplateControllerServer) {
	s.RegisterService(&_SessionTemplateController_serviceDesc, srv)
}

func _SessionTemplateController_CreateSessionTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSessionTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionTemplateControllerServer).CreateSessionTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.SessionTemplateController/CreateSessionTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionTemplateControllerServer).CreateSessionTemplate(ctx, req.(*CreateSessionTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SessionTemplateController_UpdateSessionTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSessionTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionTemplateControllerServer).UpdateSessionTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.SessionTemplateController/UpdateSessionTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionTemplateControllerServer).UpdateSessionTemplate(ctx, req.(*UpdateSessionTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SessionTemplateController_GetSessionTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSessionTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionTemplateControllerServer).GetSessionTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.SessionTemplateController/GetSessionTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionTemplateControllerServer).GetSessionTemplate(ctx, req.(*GetSessionTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SessionTemplateController_ListSessionTemplates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSessionTemplatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionTemplateControllerServer).ListSessionTemplates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.SessionTemplateController/ListSessionTemplates",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionTemplateControllerServer).ListSessionTemplates(ctx, req.(*ListSessionTemplatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SessionTemplateController_DeleteSessionTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSessionTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionTemplateControllerServer).DeleteSessionTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.SessionTemplateController/DeleteSessionTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionTemplateControllerServer).DeleteSessionTemplate(ctx, req.(*DeleteSessionTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SessionTemplateController_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataproc.v1.SessionTemplateController",
	HandlerType: (*SessionTemplateControllerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateSessionTemplate",
			Handler:    _SessionTemplateController_CreateSessionTemplate_Handler,
		},
		{
			MethodName: "UpdateSessionTemplate",
			Handler:    _SessionTemplateController_UpdateSessionTemplate_Handler,
		},
		{
			MethodName: "GetSessionTemplate",
			Handler:    _SessionTemplateController_GetSessionTemplate_Handler,
		},
		{
			MethodName: "ListSessionTemplates",
			Handler:    _SessionTemplateController_ListSessionTemplates_Handler,
		},
		{
			MethodName: "DeleteSessionTemplate",
			Handler:    _SessionTemplateController_DeleteSessionTemplate_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dataproc/v1/session_templates.proto",
}
