// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dataproc/v1/node_groups.proto

package dataprocpb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	NodeGroupController_CreateNodeGroup_FullMethodName = "/google.cloud.dataproc.v1.NodeGroupController/CreateNodeGroup"
	NodeGroupController_ResizeNodeGroup_FullMethodName = "/google.cloud.dataproc.v1.NodeGroupController/ResizeNodeGroup"
	NodeGroupController_GetNodeGroup_FullMethodName    = "/google.cloud.dataproc.v1.NodeGroupController/GetNodeGroup"
)

// NodeGroupControllerClient is the client API for NodeGroupController service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type NodeGroupControllerClient interface {
	// Creates a node group in a cluster. The returned
	// [Operation.metadata][google.longrunning.Operation.metadata] is
	// [NodeGroupOperationMetadata](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#nodegroupoperationmetadata).
	CreateNodeGroup(ctx context.Context, in *CreateNodeGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Resizes a node group in a cluster. The returned
	// [Operation.metadata][google.longrunning.Operation.metadata] is
	// [NodeGroupOperationMetadata](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#nodegroupoperationmetadata).
	ResizeNodeGroup(ctx context.Context, in *ResizeNodeGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets the resource representation for a node group in a
	// cluster.
	GetNodeGroup(ctx context.Context, in *GetNodeGroupRequest, opts ...grpc.CallOption) (*NodeGroup, error)
}

type nodeGroupControllerClient struct {
	cc grpc.ClientConnInterface
}

func NewNodeGroupControllerClient(cc grpc.ClientConnInterface) NodeGroupControllerClient {
	return &nodeGroupControllerClient{cc}
}

func (c *nodeGroupControllerClient) CreateNodeGroup(ctx context.Context, in *CreateNodeGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NodeGroupController_CreateNodeGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeGroupControllerClient) ResizeNodeGroup(ctx context.Context, in *ResizeNodeGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NodeGroupController_ResizeNodeGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeGroupControllerClient) GetNodeGroup(ctx context.Context, in *GetNodeGroupRequest, opts ...grpc.CallOption) (*NodeGroup, error) {
	out := new(NodeGroup)
	err := c.cc.Invoke(ctx, NodeGroupController_GetNodeGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NodeGroupControllerServer is the server API for NodeGroupController service.
// All implementations should embed UnimplementedNodeGroupControllerServer
// for forward compatibility
type NodeGroupControllerServer interface {
	// Creates a node group in a cluster. The returned
	// [Operation.metadata][google.longrunning.Operation.metadata] is
	// [NodeGroupOperationMetadata](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#nodegroupoperationmetadata).
	CreateNodeGroup(context.Context, *CreateNodeGroupRequest) (*longrunningpb.Operation, error)
	// Resizes a node group in a cluster. The returned
	// [Operation.metadata][google.longrunning.Operation.metadata] is
	// [NodeGroupOperationMetadata](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#nodegroupoperationmetadata).
	ResizeNodeGroup(context.Context, *ResizeNodeGroupRequest) (*longrunningpb.Operation, error)
	// Gets the resource representation for a node group in a
	// cluster.
	GetNodeGroup(context.Context, *GetNodeGroupRequest) (*NodeGroup, error)
}

// UnimplementedNodeGroupControllerServer should be embedded to have forward compatible implementations.
type UnimplementedNodeGroupControllerServer struct {
}

func (UnimplementedNodeGroupControllerServer) CreateNodeGroup(context.Context, *CreateNodeGroupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateNodeGroup not implemented")
}
func (UnimplementedNodeGroupControllerServer) ResizeNodeGroup(context.Context, *ResizeNodeGroupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResizeNodeGroup not implemented")
}
func (UnimplementedNodeGroupControllerServer) GetNodeGroup(context.Context, *GetNodeGroupRequest) (*NodeGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNodeGroup not implemented")
}

// UnsafeNodeGroupControllerServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to NodeGroupControllerServer will
// result in compilation errors.
type UnsafeNodeGroupControllerServer interface {
	mustEmbedUnimplementedNodeGroupControllerServer()
}

func RegisterNodeGroupControllerServer(s grpc.ServiceRegistrar, srv NodeGroupControllerServer) {
	s.RegisterService(&NodeGroupController_ServiceDesc, srv)
}

func _NodeGroupController_CreateNodeGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNodeGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeGroupControllerServer).CreateNodeGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NodeGroupController_CreateNodeGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeGroupControllerServer).CreateNodeGroup(ctx, req.(*CreateNodeGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeGroupController_ResizeNodeGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResizeNodeGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeGroupControllerServer).ResizeNodeGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NodeGroupController_ResizeNodeGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeGroupControllerServer).ResizeNodeGroup(ctx, req.(*ResizeNodeGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeGroupController_GetNodeGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNodeGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeGroupControllerServer).GetNodeGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NodeGroupController_GetNodeGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeGroupControllerServer).GetNodeGroup(ctx, req.(*GetNodeGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// NodeGroupController_ServiceDesc is the grpc.ServiceDesc for NodeGroupController service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var NodeGroupController_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataproc.v1.NodeGroupController",
	HandlerType: (*NodeGroupControllerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateNodeGroup",
			Handler:    _NodeGroupController_CreateNodeGroup_Handler,
		},
		{
			MethodName: "ResizeNodeGroup",
			Handler:    _NodeGroupController_ResizeNodeGroup_Handler,
		},
		{
			MethodName: "GetNodeGroup",
			Handler:    _NodeGroupController_GetNodeGroup_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dataproc/v1/node_groups.proto",
}
