// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/datastore/admin/v1/datastore_admin.proto

package adminpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	DatastoreAdmin_ExportEntities_FullMethodName = "/google.datastore.admin.v1.DatastoreAdmin/ExportEntities"
	DatastoreAdmin_ImportEntities_FullMethodName = "/google.datastore.admin.v1.DatastoreAdmin/ImportEntities"
	DatastoreAdmin_CreateIndex_FullMethodName    = "/google.datastore.admin.v1.DatastoreAdmin/CreateIndex"
	DatastoreAdmin_DeleteIndex_FullMethodName    = "/google.datastore.admin.v1.DatastoreAdmin/DeleteIndex"
	DatastoreAdmin_GetIndex_FullMethodName       = "/google.datastore.admin.v1.DatastoreAdmin/GetIndex"
	DatastoreAdmin_ListIndexes_FullMethodName    = "/google.datastore.admin.v1.DatastoreAdmin/ListIndexes"
)

// DatastoreAdminClient is the client API for DatastoreAdmin service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type DatastoreAdminClient interface {
	// Exports a copy of all or a subset of entities from Google Cloud Datastore
	// to another storage system, such as Google Cloud Storage. Recent updates to
	// entities may not be reflected in the export. The export occurs in the
	// background and its progress can be monitored and managed via the
	// Operation resource that is created. The output of an export may only be
	// used once the associated operation is done. If an export operation is
	// cancelled before completion it may leave partial data behind in Google
	// Cloud Storage.
	ExportEntities(ctx context.Context, in *ExportEntitiesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Imports entities into Google Cloud Datastore. Existing entities with the
	// same key are overwritten. The import occurs in the background and its
	// progress can be monitored and managed via the Operation resource that is
	// created. If an ImportEntities operation is cancelled, it is possible
	// that a subset of the data has already been imported to Cloud Datastore.
	ImportEntities(ctx context.Context, in *ImportEntitiesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates the specified index.
	// A newly created index's initial state is `CREATING`. On completion of the
	// returned [google.longrunning.Operation][google.longrunning.Operation], the
	// state will be `READY`. If the index already exists, the call will return an
	// `ALREADY_EXISTS` status.
	//
	// During index creation, the process could result in an error, in which
	// case the index will move to the `ERROR` state. The process can be recovered
	// by fixing the data that caused the error, removing the index with
	// [delete][google.datastore.admin.v1.DatastoreAdmin.DeleteIndex], then
	// re-creating the index with [create]
	// [google.datastore.admin.v1.DatastoreAdmin.CreateIndex].
	//
	// Indexes with a single property cannot be created.
	CreateIndex(ctx context.Context, in *CreateIndexRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an existing index.
	// An index can only be deleted if it is in a `READY` or `ERROR` state. On
	// successful execution of the request, the index will be in a `DELETING`
	// [state][google.datastore.admin.v1.Index.State]. And on completion of the
	// returned [google.longrunning.Operation][google.longrunning.Operation], the
	// index will be removed.
	//
	// During index deletion, the process could result in an error, in which
	// case the index will move to the `ERROR` state. The process can be recovered
	// by fixing the data that caused the error, followed by calling
	// [delete][google.datastore.admin.v1.DatastoreAdmin.DeleteIndex] again.
	DeleteIndex(ctx context.Context, in *DeleteIndexRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets an index.
	GetIndex(ctx context.Context, in *GetIndexRequest, opts ...grpc.CallOption) (*Index, error)
	// Lists the indexes that match the specified filters.  Datastore uses an
	// eventually consistent query to fetch the list of indexes and may
	// occasionally return stale results.
	ListIndexes(ctx context.Context, in *ListIndexesRequest, opts ...grpc.CallOption) (*ListIndexesResponse, error)
}

type datastoreAdminClient struct {
	cc grpc.ClientConnInterface
}

func NewDatastoreAdminClient(cc grpc.ClientConnInterface) DatastoreAdminClient {
	return &datastoreAdminClient{cc}
}

func (c *datastoreAdminClient) ExportEntities(ctx context.Context, in *ExportEntitiesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DatastoreAdmin_ExportEntities_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreAdminClient) ImportEntities(ctx context.Context, in *ImportEntitiesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DatastoreAdmin_ImportEntities_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreAdminClient) CreateIndex(ctx context.Context, in *CreateIndexRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DatastoreAdmin_CreateIndex_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreAdminClient) DeleteIndex(ctx context.Context, in *DeleteIndexRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DatastoreAdmin_DeleteIndex_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreAdminClient) GetIndex(ctx context.Context, in *GetIndexRequest, opts ...grpc.CallOption) (*Index, error) {
	out := new(Index)
	err := c.cc.Invoke(ctx, DatastoreAdmin_GetIndex_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreAdminClient) ListIndexes(ctx context.Context, in *ListIndexesRequest, opts ...grpc.CallOption) (*ListIndexesResponse, error) {
	out := new(ListIndexesResponse)
	err := c.cc.Invoke(ctx, DatastoreAdmin_ListIndexes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DatastoreAdminServer is the server API for DatastoreAdmin service.
// All implementations should embed UnimplementedDatastoreAdminServer
// for forward compatibility
type DatastoreAdminServer interface {
	// Exports a copy of all or a subset of entities from Google Cloud Datastore
	// to another storage system, such as Google Cloud Storage. Recent updates to
	// entities may not be reflected in the export. The export occurs in the
	// background and its progress can be monitored and managed via the
	// Operation resource that is created. The output of an export may only be
	// used once the associated operation is done. If an export operation is
	// cancelled before completion it may leave partial data behind in Google
	// Cloud Storage.
	ExportEntities(context.Context, *ExportEntitiesRequest) (*longrunningpb.Operation, error)
	// Imports entities into Google Cloud Datastore. Existing entities with the
	// same key are overwritten. The import occurs in the background and its
	// progress can be monitored and managed via the Operation resource that is
	// created. If an ImportEntities operation is cancelled, it is possible
	// that a subset of the data has already been imported to Cloud Datastore.
	ImportEntities(context.Context, *ImportEntitiesRequest) (*longrunningpb.Operation, error)
	// Creates the specified index.
	// A newly created index's initial state is `CREATING`. On completion of the
	// returned [google.longrunning.Operation][google.longrunning.Operation], the
	// state will be `READY`. If the index already exists, the call will return an
	// `ALREADY_EXISTS` status.
	//
	// During index creation, the process could result in an error, in which
	// case the index will move to the `ERROR` state. The process can be recovered
	// by fixing the data that caused the error, removing the index with
	// [delete][google.datastore.admin.v1.DatastoreAdmin.DeleteIndex], then
	// re-creating the index with [create]
	// [google.datastore.admin.v1.DatastoreAdmin.CreateIndex].
	//
	// Indexes with a single property cannot be created.
	CreateIndex(context.Context, *CreateIndexRequest) (*longrunningpb.Operation, error)
	// Deletes an existing index.
	// An index can only be deleted if it is in a `READY` or `ERROR` state. On
	// successful execution of the request, the index will be in a `DELETING`
	// [state][google.datastore.admin.v1.Index.State]. And on completion of the
	// returned [google.longrunning.Operation][google.longrunning.Operation], the
	// index will be removed.
	//
	// During index deletion, the process could result in an error, in which
	// case the index will move to the `ERROR` state. The process can be recovered
	// by fixing the data that caused the error, followed by calling
	// [delete][google.datastore.admin.v1.DatastoreAdmin.DeleteIndex] again.
	DeleteIndex(context.Context, *DeleteIndexRequest) (*longrunningpb.Operation, error)
	// Gets an index.
	GetIndex(context.Context, *GetIndexRequest) (*Index, error)
	// Lists the indexes that match the specified filters.  Datastore uses an
	// eventually consistent query to fetch the list of indexes and may
	// occasionally return stale results.
	ListIndexes(context.Context, *ListIndexesRequest) (*ListIndexesResponse, error)
}

// UnimplementedDatastoreAdminServer should be embedded to have forward compatible implementations.
type UnimplementedDatastoreAdminServer struct {
}

func (UnimplementedDatastoreAdminServer) ExportEntities(context.Context, *ExportEntitiesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportEntities not implemented")
}
func (UnimplementedDatastoreAdminServer) ImportEntities(context.Context, *ImportEntitiesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportEntities not implemented")
}
func (UnimplementedDatastoreAdminServer) CreateIndex(context.Context, *CreateIndexRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateIndex not implemented")
}
func (UnimplementedDatastoreAdminServer) DeleteIndex(context.Context, *DeleteIndexRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteIndex not implemented")
}
func (UnimplementedDatastoreAdminServer) GetIndex(context.Context, *GetIndexRequest) (*Index, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIndex not implemented")
}
func (UnimplementedDatastoreAdminServer) ListIndexes(context.Context, *ListIndexesRequest) (*ListIndexesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListIndexes not implemented")
}

// UnsafeDatastoreAdminServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DatastoreAdminServer will
// result in compilation errors.
type UnsafeDatastoreAdminServer interface {
	mustEmbedUnimplementedDatastoreAdminServer()
}

func RegisterDatastoreAdminServer(s grpc.ServiceRegistrar, srv DatastoreAdminServer) {
	s.RegisterService(&DatastoreAdmin_ServiceDesc, srv)
}

func _DatastoreAdmin_ExportEntities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportEntitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreAdminServer).ExportEntities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatastoreAdmin_ExportEntities_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreAdminServer).ExportEntities(ctx, req.(*ExportEntitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatastoreAdmin_ImportEntities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportEntitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreAdminServer).ImportEntities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatastoreAdmin_ImportEntities_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreAdminServer).ImportEntities(ctx, req.(*ImportEntitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatastoreAdmin_CreateIndex_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreAdminServer).CreateIndex(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatastoreAdmin_CreateIndex_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreAdminServer).CreateIndex(ctx, req.(*CreateIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatastoreAdmin_DeleteIndex_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreAdminServer).DeleteIndex(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatastoreAdmin_DeleteIndex_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreAdminServer).DeleteIndex(ctx, req.(*DeleteIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatastoreAdmin_GetIndex_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreAdminServer).GetIndex(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatastoreAdmin_GetIndex_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreAdminServer).GetIndex(ctx, req.(*GetIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatastoreAdmin_ListIndexes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListIndexesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreAdminServer).ListIndexes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatastoreAdmin_ListIndexes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreAdminServer).ListIndexes(ctx, req.(*ListIndexesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// DatastoreAdmin_ServiceDesc is the grpc.ServiceDesc for DatastoreAdmin service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var DatastoreAdmin_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.datastore.admin.v1.DatastoreAdmin",
	HandlerType: (*DatastoreAdminServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ExportEntities",
			Handler:    _DatastoreAdmin_ExportEntities_Handler,
		},
		{
			MethodName: "ImportEntities",
			Handler:    _DatastoreAdmin_ImportEntities_Handler,
		},
		{
			MethodName: "CreateIndex",
			Handler:    _DatastoreAdmin_CreateIndex_Handler,
		},
		{
			MethodName: "DeleteIndex",
			Handler:    _DatastoreAdmin_DeleteIndex_Handler,
		},
		{
			MethodName: "GetIndex",
			Handler:    _DatastoreAdmin_GetIndex_Handler,
		},
		{
			MethodName: "ListIndexes",
			Handler:    _DatastoreAdmin_ListIndexes_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/datastore/admin/v1/datastore_admin.proto",
}
