// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/cloud/dialogflow/cx/v3beta1/entity_type.proto

package cxpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Represents kinds of entities.
type EntityType_Kind int32

const (
	// Not specified. This value should be never used.
	EntityType_KIND_UNSPECIFIED EntityType_Kind = 0
	// Map entity types allow mapping of a group of synonyms to a canonical
	// value.
	EntityType_KIND_MAP EntityType_Kind = 1
	// List entity types contain a set of entries that do not map to canonical
	// values. However, list entity types can contain references to other entity
	// types (with or without aliases).
	EntityType_KIND_LIST EntityType_Kind = 2
	// Regexp entity types allow to specify regular expressions in entries
	// values.
	EntityType_KIND_REGEXP EntityType_Kind = 3
)

// Enum value maps for EntityType_Kind.
var (
	EntityType_Kind_name = map[int32]string{
		0: "KIND_UNSPECIFIED",
		1: "KIND_MAP",
		2: "KIND_LIST",
		3: "KIND_REGEXP",
	}
	EntityType_Kind_value = map[string]int32{
		"KIND_UNSPECIFIED": 0,
		"KIND_MAP":         1,
		"KIND_LIST":        2,
		"KIND_REGEXP":      3,
	}
)

func (x EntityType_Kind) Enum() *EntityType_Kind {
	p := new(EntityType_Kind)
	*p = x
	return p
}

func (x EntityType_Kind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EntityType_Kind) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_enumTypes[0].Descriptor()
}

func (EntityType_Kind) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_enumTypes[0]
}

func (x EntityType_Kind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EntityType_Kind.Descriptor instead.
func (EntityType_Kind) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_rawDescGZIP(), []int{0, 0}
}

// Represents different entity type expansion modes. Automated expansion
// allows an agent to recognize values that have not been explicitly listed in
// the entity (for example, new kinds of shopping list items).
type EntityType_AutoExpansionMode int32

const (
	// Auto expansion disabled for the entity.
	EntityType_AUTO_EXPANSION_MODE_UNSPECIFIED EntityType_AutoExpansionMode = 0
	// Allows an agent to recognize values that have not been explicitly
	// listed in the entity.
	EntityType_AUTO_EXPANSION_MODE_DEFAULT EntityType_AutoExpansionMode = 1
)

// Enum value maps for EntityType_AutoExpansionMode.
var (
	EntityType_AutoExpansionMode_name = map[int32]string{
		0: "AUTO_EXPANSION_MODE_UNSPECIFIED",
		1: "AUTO_EXPANSION_MODE_DEFAULT",
	}
	EntityType_AutoExpansionMode_value = map[string]int32{
		"AUTO_EXPANSION_MODE_UNSPECIFIED": 0,
		"AUTO_EXPANSION_MODE_DEFAULT":     1,
	}
)

func (x EntityType_AutoExpansionMode) Enum() *EntityType_AutoExpansionMode {
	p := new(EntityType_AutoExpansionMode)
	*p = x
	return p
}

func (x EntityType_AutoExpansionMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EntityType_AutoExpansionMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_enumTypes[1].Descriptor()
}

func (EntityType_AutoExpansionMode) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_enumTypes[1]
}

func (x EntityType_AutoExpansionMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EntityType_AutoExpansionMode.Descriptor instead.
func (EntityType_AutoExpansionMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_rawDescGZIP(), []int{0, 1}
}

// Data format of the exported entity types.
type ExportEntityTypesRequest_DataFormat int32

const (
	// Unspecified format. Treated as `BLOB`.
	ExportEntityTypesRequest_DATA_FORMAT_UNSPECIFIED ExportEntityTypesRequest_DataFormat = 0
	// EntityTypes will be exported as raw bytes.
	ExportEntityTypesRequest_BLOB ExportEntityTypesRequest_DataFormat = 1
	// EntityTypes will be exported in JSON Package format.
	ExportEntityTypesRequest_JSON_PACKAGE ExportEntityTypesRequest_DataFormat = 5
)

// Enum value maps for ExportEntityTypesRequest_DataFormat.
var (
	ExportEntityTypesRequest_DataFormat_name = map[int32]string{
		0: "DATA_FORMAT_UNSPECIFIED",
		1: "BLOB",
		5: "JSON_PACKAGE",
	}
	ExportEntityTypesRequest_DataFormat_value = map[string]int32{
		"DATA_FORMAT_UNSPECIFIED": 0,
		"BLOB":                    1,
		"JSON_PACKAGE":            5,
	}
)

func (x ExportEntityTypesRequest_DataFormat) Enum() *ExportEntityTypesRequest_DataFormat {
	p := new(ExportEntityTypesRequest_DataFormat)
	*p = x
	return p
}

func (x ExportEntityTypesRequest_DataFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExportEntityTypesRequest_DataFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_enumTypes[2].Descriptor()
}

func (ExportEntityTypesRequest_DataFormat) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_enumTypes[2]
}

func (x ExportEntityTypesRequest_DataFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExportEntityTypesRequest_DataFormat.Descriptor instead.
func (ExportEntityTypesRequest_DataFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_rawDescGZIP(), []int{1, 0}
}

// Merge option when display name conflicts exist during import.
type ImportEntityTypesRequest_MergeOption int32

const (
	// Unspecified. If used, system uses REPORT_CONFLICT as default.
	ImportEntityTypesRequest_MERGE_OPTION_UNSPECIFIED ImportEntityTypesRequest_MergeOption = 0
	// Replace the original entity type in the agent with the new entity type
	// when display name conflicts exist.
	ImportEntityTypesRequest_REPLACE ImportEntityTypesRequest_MergeOption = 1
	// Merge the original entity type with the new entity type when display name
	// conflicts exist.
	ImportEntityTypesRequest_MERGE ImportEntityTypesRequest_MergeOption = 2
	// Create new entity types with new display names to differentiate them from
	// the existing entity types when display name conflicts exist.
	ImportEntityTypesRequest_RENAME ImportEntityTypesRequest_MergeOption = 3
	// Report conflict information if display names conflict is detected.
	// Otherwise, import entity types.
	ImportEntityTypesRequest_REPORT_CONFLICT ImportEntityTypesRequest_MergeOption = 4
	// Keep the original entity type and discard the conflicting new entity type
	// when display name conflicts exist.
	ImportEntityTypesRequest_KEEP ImportEntityTypesRequest_MergeOption = 5
)

// Enum value maps for ImportEntityTypesRequest_MergeOption.
var (
	ImportEntityTypesRequest_MergeOption_name = map[int32]string{
		0: "MERGE_OPTION_UNSPECIFIED",
		1: "REPLACE",
		2: "MERGE",
		3: "RENAME",
		4: "REPORT_CONFLICT",
		5: "KEEP",
	}
	ImportEntityTypesRequest_MergeOption_value = map[string]int32{
		"MERGE_OPTION_UNSPECIFIED": 0,
		"REPLACE":                  1,
		"MERGE":                    2,
		"RENAME":                   3,
		"REPORT_CONFLICT":          4,
		"KEEP":                     5,
	}
)

func (x ImportEntityTypesRequest_MergeOption) Enum() *ImportEntityTypesRequest_MergeOption {
	p := new(ImportEntityTypesRequest_MergeOption)
	*p = x
	return p
}

func (x ImportEntityTypesRequest_MergeOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ImportEntityTypesRequest_MergeOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_enumTypes[3].Descriptor()
}

func (ImportEntityTypesRequest_MergeOption) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_enumTypes[3]
}

func (x ImportEntityTypesRequest_MergeOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ImportEntityTypesRequest_MergeOption.Descriptor instead.
func (ImportEntityTypesRequest_MergeOption) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_rawDescGZIP(), []int{4, 0}
}

// Entities are extracted from user input and represent parameters that are
// meaningful to your application. For example, a date range, a proper name
// such as a geographic location or landmark, and so on. Entities represent
// actionable data for your application.
//
// When you define an entity, you can also include synonyms that all map to
// that entity. For example, "soft drink", "soda", "pop", and so on.
//
// There are three types of entities:
//
//   - **System** - entities that are defined by the Dialogflow API for common
//     data types such as date, time, currency, and so on. A system entity is
//     represented by the `EntityType` type.
//
//   - **Custom** - entities that are defined by you that represent
//     actionable data that is meaningful to your application. For example,
//     you could define a `pizza.sauce` entity for red or white pizza sauce,
//     a `pizza.cheese` entity for the different types of cheese on a pizza,
//     a `pizza.topping` entity for different toppings, and so on. A custom
//     entity is represented by the `EntityType` type.
//
//   - **User** - entities that are built for an individual user such as
//     favorites, preferences, playlists, and so on. A user entity is
//     represented by the
//     [SessionEntityType][google.cloud.dialogflow.cx.v3beta1.SessionEntityType]
//     type.
//
// For more information about entity types, see the [Dialogflow
// documentation](https://cloud.google.com/dialogflow/docs/entities-overview).
type EntityType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier of the entity type.
	// Required for
	// [EntityTypes.UpdateEntityType][google.cloud.dialogflow.cx.v3beta1.EntityTypes.UpdateEntityType].
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/entityTypes/<EntityTypeID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The human-readable name of the entity type, unique within the
	// agent.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. Indicates the kind of entity type.
	Kind EntityType_Kind `protobuf:"varint,3,opt,name=kind,proto3,enum=google.cloud.dialogflow.cx.v3beta1.EntityType_Kind" json:"kind,omitempty"`
	// Indicates whether the entity type can be automatically expanded.
	AutoExpansionMode EntityType_AutoExpansionMode `protobuf:"varint,4,opt,name=auto_expansion_mode,json=autoExpansionMode,proto3,enum=google.cloud.dialogflow.cx.v3beta1.EntityType_AutoExpansionMode" json:"auto_expansion_mode,omitempty"`
	// The collection of entity entries associated with the entity type.
	Entities []*EntityType_Entity `protobuf:"bytes,5,rep,name=entities,proto3" json:"entities,omitempty"`
	// Collection of exceptional words and phrases that shouldn't be matched.
	// For example, if you have a size entity type with entry `giant`(an
	// adjective), you might consider adding `giants`(a noun) as an exclusion.
	// If the kind of entity type is `KIND_MAP`, then the phrases specified by
	// entities and excluded phrases should be mutually exclusive.
	ExcludedPhrases []*EntityType_ExcludedPhrase `protobuf:"bytes,6,rep,name=excluded_phrases,json=excludedPhrases,proto3" json:"excluded_phrases,omitempty"`
	// Enables fuzzy entity extraction during classification.
	EnableFuzzyExtraction bool `protobuf:"varint,7,opt,name=enable_fuzzy_extraction,json=enableFuzzyExtraction,proto3" json:"enable_fuzzy_extraction,omitempty"`
	// Indicates whether parameters of the entity type should be redacted in log.
	// If redaction is enabled, page parameters and intent parameters referring to
	// the entity type will be replaced by parameter name during logging.
	Redact bool `protobuf:"varint,9,opt,name=redact,proto3" json:"redact,omitempty"`
}

func (x *EntityType) Reset() {
	*x = EntityType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EntityType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntityType) ProtoMessage() {}

func (x *EntityType) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntityType.ProtoReflect.Descriptor instead.
func (*EntityType) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_rawDescGZIP(), []int{0}
}

func (x *EntityType) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EntityType) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *EntityType) GetKind() EntityType_Kind {
	if x != nil {
		return x.Kind
	}
	return EntityType_KIND_UNSPECIFIED
}

func (x *EntityType) GetAutoExpansionMode() EntityType_AutoExpansionMode {
	if x != nil {
		return x.AutoExpansionMode
	}
	return EntityType_AUTO_EXPANSION_MODE_UNSPECIFIED
}

func (x *EntityType) GetEntities() []*EntityType_Entity {
	if x != nil {
		return x.Entities
	}
	return nil
}

func (x *EntityType) GetExcludedPhrases() []*EntityType_ExcludedPhrase {
	if x != nil {
		return x.ExcludedPhrases
	}
	return nil
}

func (x *EntityType) GetEnableFuzzyExtraction() bool {
	if x != nil {
		return x.EnableFuzzyExtraction
	}
	return false
}

func (x *EntityType) GetRedact() bool {
	if x != nil {
		return x.Redact
	}
	return false
}

// The request message for
// [EntityTypes.ExportEntityTypes][google.cloud.dialogflow.cx.v3beta1.EntityTypes.ExportEntityTypes].
type ExportEntityTypesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the parent agent to export entity types.
	// Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The name of the entity types to export.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/entityTypes/<EntityTypeID>`.
	EntityTypes []string `protobuf:"bytes,2,rep,name=entity_types,json=entityTypes,proto3" json:"entity_types,omitempty"`
	// The destination to export.
	//
	// Types that are assignable to Destination:
	//
	//	*ExportEntityTypesRequest_EntityTypesUri
	//	*ExportEntityTypesRequest_EntityTypesContentInline
	Destination isExportEntityTypesRequest_Destination `protobuf_oneof:"destination"`
	// Optional. The data format of the exported entity types. If not specified,
	// `BLOB` is assumed.
	DataFormat ExportEntityTypesRequest_DataFormat `protobuf:"varint,5,opt,name=data_format,json=dataFormat,proto3,enum=google.cloud.dialogflow.cx.v3beta1.ExportEntityTypesRequest_DataFormat" json:"data_format,omitempty"`
	// Optional. The language to retrieve the entity type for. The following
	// fields are language dependent:
	//
	// *   `EntityType.entities.value`
	// *   `EntityType.entities.synonyms`
	// *   `EntityType.excluded_phrases.value`
	//
	// If not specified, all language dependent fields will be retrieved.
	// [Many
	// languages](https://cloud.google.com/dialogflow/docs/reference/language)
	// are supported.
	// Note: languages must be enabled in the agent before they can be used.
	LanguageCode string `protobuf:"bytes,6,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *ExportEntityTypesRequest) Reset() {
	*x = ExportEntityTypesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportEntityTypesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportEntityTypesRequest) ProtoMessage() {}

func (x *ExportEntityTypesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportEntityTypesRequest.ProtoReflect.Descriptor instead.
func (*ExportEntityTypesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_rawDescGZIP(), []int{1}
}

func (x *ExportEntityTypesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ExportEntityTypesRequest) GetEntityTypes() []string {
	if x != nil {
		return x.EntityTypes
	}
	return nil
}

func (m *ExportEntityTypesRequest) GetDestination() isExportEntityTypesRequest_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *ExportEntityTypesRequest) GetEntityTypesUri() string {
	if x, ok := x.GetDestination().(*ExportEntityTypesRequest_EntityTypesUri); ok {
		return x.EntityTypesUri
	}
	return ""
}

func (x *ExportEntityTypesRequest) GetEntityTypesContentInline() bool {
	if x, ok := x.GetDestination().(*ExportEntityTypesRequest_EntityTypesContentInline); ok {
		return x.EntityTypesContentInline
	}
	return false
}

func (x *ExportEntityTypesRequest) GetDataFormat() ExportEntityTypesRequest_DataFormat {
	if x != nil {
		return x.DataFormat
	}
	return ExportEntityTypesRequest_DATA_FORMAT_UNSPECIFIED
}

func (x *ExportEntityTypesRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

type isExportEntityTypesRequest_Destination interface {
	isExportEntityTypesRequest_Destination()
}

type ExportEntityTypesRequest_EntityTypesUri struct {
	// Optional. The [Google Cloud
	// Storage](https://cloud.google.com/storage/docs/) URI to export the entity
	// types to. The format of this URI must be
	// `gs://<bucket-name>/<object-name>`.
	//
	// Dialogflow performs a write operation for the Cloud Storage object
	// on the caller's behalf, so your request authentication must
	// have write permissions for the object. For more information, see
	// [Dialogflow access
	// control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
	EntityTypesUri string `protobuf:"bytes,3,opt,name=entity_types_uri,json=entityTypesUri,proto3,oneof"`
}

type ExportEntityTypesRequest_EntityTypesContentInline struct {
	// Optional. The option to return the serialized entity types inline.
	EntityTypesContentInline bool `protobuf:"varint,4,opt,name=entity_types_content_inline,json=entityTypesContentInline,proto3,oneof"`
}

func (*ExportEntityTypesRequest_EntityTypesUri) isExportEntityTypesRequest_Destination() {}

func (*ExportEntityTypesRequest_EntityTypesContentInline) isExportEntityTypesRequest_Destination() {}

// The response message for
// [EntityTypes.ExportEntityTypes][google.cloud.dialogflow.cx.v3beta1.EntityTypes.ExportEntityTypes].
type ExportEntityTypesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Exported entity types can be either in cloud storage or local download.
	//
	// Types that are assignable to ExportedEntityTypes:
	//
	//	*ExportEntityTypesResponse_EntityTypesUri
	//	*ExportEntityTypesResponse_EntityTypesContent
	ExportedEntityTypes isExportEntityTypesResponse_ExportedEntityTypes `protobuf_oneof:"exported_entity_types"`
}

func (x *ExportEntityTypesResponse) Reset() {
	*x = ExportEntityTypesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportEntityTypesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportEntityTypesResponse) ProtoMessage() {}

func (x *ExportEntityTypesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportEntityTypesResponse.ProtoReflect.Descriptor instead.
func (*ExportEntityTypesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_rawDescGZIP(), []int{2}
}

func (m *ExportEntityTypesResponse) GetExportedEntityTypes() isExportEntityTypesResponse_ExportedEntityTypes {
	if m != nil {
		return m.ExportedEntityTypes
	}
	return nil
}

func (x *ExportEntityTypesResponse) GetEntityTypesUri() string {
	if x, ok := x.GetExportedEntityTypes().(*ExportEntityTypesResponse_EntityTypesUri); ok {
		return x.EntityTypesUri
	}
	return ""
}

func (x *ExportEntityTypesResponse) GetEntityTypesContent() *InlineDestination {
	if x, ok := x.GetExportedEntityTypes().(*ExportEntityTypesResponse_EntityTypesContent); ok {
		return x.EntityTypesContent
	}
	return nil
}

type isExportEntityTypesResponse_ExportedEntityTypes interface {
	isExportEntityTypesResponse_ExportedEntityTypes()
}

type ExportEntityTypesResponse_EntityTypesUri struct {
	// The URI to a file containing the exported entity types. This field is
	// populated only if `entity_types_uri` is specified in
	// [ExportEntityTypesRequest][google.cloud.dialogflow.cx.v3beta1.ExportEntityTypesRequest].
	EntityTypesUri string `protobuf:"bytes,1,opt,name=entity_types_uri,json=entityTypesUri,proto3,oneof"`
}

type ExportEntityTypesResponse_EntityTypesContent struct {
	// Uncompressed byte content for entity types. This field is populated only
	// if `entity_types_content_inline` is set to true in
	// [ExportEntityTypesRequest][google.cloud.dialogflow.cx.v3beta1.ExportEntityTypesRequest].
	EntityTypesContent *InlineDestination `protobuf:"bytes,2,opt,name=entity_types_content,json=entityTypesContent,proto3,oneof"`
}

func (*ExportEntityTypesResponse_EntityTypesUri) isExportEntityTypesResponse_ExportedEntityTypes() {}

func (*ExportEntityTypesResponse_EntityTypesContent) isExportEntityTypesResponse_ExportedEntityTypes() {
}

// Metadata returned for the
// [EntityTypes.ExportEntityTypes][google.cloud.dialogflow.cx.v3beta1.EntityTypes.ExportEntityTypes]
// long running operation.
type ExportEntityTypesMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ExportEntityTypesMetadata) Reset() {
	*x = ExportEntityTypesMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportEntityTypesMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportEntityTypesMetadata) ProtoMessage() {}

func (x *ExportEntityTypesMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportEntityTypesMetadata.ProtoReflect.Descriptor instead.
func (*ExportEntityTypesMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_rawDescGZIP(), []int{3}
}

// The request message for
// [EntityTypes.ImportEntityTypes][google.cloud.dialogflow.cx.v3beta1.EntityTypes.ImportEntityTypes].
type ImportEntityTypesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent to import the entity types into.
	// Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The entity types to import.
	//
	// Types that are assignable to EntityTypes:
	//
	//	*ImportEntityTypesRequest_EntityTypesUri
	//	*ImportEntityTypesRequest_EntityTypesContent
	EntityTypes isImportEntityTypesRequest_EntityTypes `protobuf_oneof:"entity_types"`
	// Required. Merge option for importing entity types.
	MergeOption ImportEntityTypesRequest_MergeOption `protobuf:"varint,4,opt,name=merge_option,json=mergeOption,proto3,enum=google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest_MergeOption" json:"merge_option,omitempty"`
	// Optional. The target entity type to import into.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/entity_types/<EntityTypeID>`.
	//
	//	If set, there should be only one entity type included in
	//	[entity_types][google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.entity_types],
	//	of which the type should match the type of the target entity type. All
	//	[entities][google.cloud.dialogflow.cx.v3beta1.EntityType.entities] in the
	//	imported entity type will be added to the target entity type.
	TargetEntityType string `protobuf:"bytes,5,opt,name=target_entity_type,json=targetEntityType,proto3" json:"target_entity_type,omitempty"`
}

func (x *ImportEntityTypesRequest) Reset() {
	*x = ImportEntityTypesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportEntityTypesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportEntityTypesRequest) ProtoMessage() {}

func (x *ImportEntityTypesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportEntityTypesRequest.ProtoReflect.Descriptor instead.
func (*ImportEntityTypesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_rawDescGZIP(), []int{4}
}

func (x *ImportEntityTypesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (m *ImportEntityTypesRequest) GetEntityTypes() isImportEntityTypesRequest_EntityTypes {
	if m != nil {
		return m.EntityTypes
	}
	return nil
}

func (x *ImportEntityTypesRequest) GetEntityTypesUri() string {
	if x, ok := x.GetEntityTypes().(*ImportEntityTypesRequest_EntityTypesUri); ok {
		return x.EntityTypesUri
	}
	return ""
}

func (x *ImportEntityTypesRequest) GetEntityTypesContent() *InlineSource {
	if x, ok := x.GetEntityTypes().(*ImportEntityTypesRequest_EntityTypesContent); ok {
		return x.EntityTypesContent
	}
	return nil
}

func (x *ImportEntityTypesRequest) GetMergeOption() ImportEntityTypesRequest_MergeOption {
	if x != nil {
		return x.MergeOption
	}
	return ImportEntityTypesRequest_MERGE_OPTION_UNSPECIFIED
}

func (x *ImportEntityTypesRequest) GetTargetEntityType() string {
	if x != nil {
		return x.TargetEntityType
	}
	return ""
}

type isImportEntityTypesRequest_EntityTypes interface {
	isImportEntityTypesRequest_EntityTypes()
}

type ImportEntityTypesRequest_EntityTypesUri struct {
	// The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
	// to import entity types from. The format of this URI must be
	// `gs://<bucket-name>/<object-name>`.
	//
	// Dialogflow performs a read operation for the Cloud Storage object
	// on the caller's behalf, so your request authentication must
	// have read permissions for the object. For more information, see
	// [Dialogflow access
	// control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
	EntityTypesUri string `protobuf:"bytes,2,opt,name=entity_types_uri,json=entityTypesUri,proto3,oneof"`
}

type ImportEntityTypesRequest_EntityTypesContent struct {
	// Uncompressed byte content of entity types.
	EntityTypesContent *InlineSource `protobuf:"bytes,3,opt,name=entity_types_content,json=entityTypesContent,proto3,oneof"`
}

func (*ImportEntityTypesRequest_EntityTypesUri) isImportEntityTypesRequest_EntityTypes() {}

func (*ImportEntityTypesRequest_EntityTypesContent) isImportEntityTypesRequest_EntityTypes() {}

// The response message for
// [EntityTypes.ImportEntityTypes][google.cloud.dialogflow.cx.v3beta1.EntityTypes.ImportEntityTypes].
type ImportEntityTypesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier of the imported entity types.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/entity_types/<EntityTypeID>`.
	EntityTypes []string `protobuf:"bytes,1,rep,name=entity_types,json=entityTypes,proto3" json:"entity_types,omitempty"`
	// Info which resources have conflicts when
	// [REPORT_CONFLICT][ImportEntityTypesResponse.REPORT_CONFLICT] merge_option
	// is set in ImportEntityTypesRequest.
	ConflictingResources *ImportEntityTypesResponse_ConflictingResources `protobuf:"bytes,2,opt,name=conflicting_resources,json=conflictingResources,proto3" json:"conflicting_resources,omitempty"`
}

func (x *ImportEntityTypesResponse) Reset() {
	*x = ImportEntityTypesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportEntityTypesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportEntityTypesResponse) ProtoMessage() {}

func (x *ImportEntityTypesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportEntityTypesResponse.ProtoReflect.Descriptor instead.
func (*ImportEntityTypesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_rawDescGZIP(), []int{5}
}

func (x *ImportEntityTypesResponse) GetEntityTypes() []string {
	if x != nil {
		return x.EntityTypes
	}
	return nil
}

func (x *ImportEntityTypesResponse) GetConflictingResources() *ImportEntityTypesResponse_ConflictingResources {
	if x != nil {
		return x.ConflictingResources
	}
	return nil
}

// Metadata returned for the
// [EntityTypes.ImportEntityTypes][google.cloud.dialogflow.cx.v3beta1.EntityTypes.ImportEntityTypes]
// long running operation.
type ImportEntityTypesMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ImportEntityTypesMetadata) Reset() {
	*x = ImportEntityTypesMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportEntityTypesMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportEntityTypesMetadata) ProtoMessage() {}

func (x *ImportEntityTypesMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportEntityTypesMetadata.ProtoReflect.Descriptor instead.
func (*ImportEntityTypesMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_rawDescGZIP(), []int{6}
}

// The request message for
// [EntityTypes.ListEntityTypes][google.cloud.dialogflow.cx.v3beta1.EntityTypes.ListEntityTypes].
type ListEntityTypesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent to list all entity types for.
	// Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The language to list entity types for. The following fields are language
	// dependent:
	//
	// *   `EntityType.entities.value`
	// *   `EntityType.entities.synonyms`
	// *   `EntityType.excluded_phrases.value`
	//
	// If not specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/cx/docs/reference/language)
	// are supported.
	// Note: languages must be enabled in the agent before they can be used.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The maximum number of items to return in a single page. By default 100 and
	// at most 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListEntityTypesRequest) Reset() {
	*x = ListEntityTypesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEntityTypesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntityTypesRequest) ProtoMessage() {}

func (x *ListEntityTypesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntityTypesRequest.ProtoReflect.Descriptor instead.
func (*ListEntityTypesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_rawDescGZIP(), []int{7}
}

func (x *ListEntityTypesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListEntityTypesRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *ListEntityTypesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListEntityTypesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for
// [EntityTypes.ListEntityTypes][google.cloud.dialogflow.cx.v3beta1.EntityTypes.ListEntityTypes].
type ListEntityTypesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of entity types. There will be a maximum number of items returned
	// based on the page_size field in the request.
	EntityTypes []*EntityType `protobuf:"bytes,1,rep,name=entity_types,json=entityTypes,proto3" json:"entity_types,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListEntityTypesResponse) Reset() {
	*x = ListEntityTypesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEntityTypesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntityTypesResponse) ProtoMessage() {}

func (x *ListEntityTypesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntityTypesResponse.ProtoReflect.Descriptor instead.
func (*ListEntityTypesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_rawDescGZIP(), []int{8}
}

func (x *ListEntityTypesResponse) GetEntityTypes() []*EntityType {
	if x != nil {
		return x.EntityTypes
	}
	return nil
}

func (x *ListEntityTypesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for
// [EntityTypes.GetEntityType][google.cloud.dialogflow.cx.v3beta1.EntityTypes.GetEntityType].
type GetEntityTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the entity type.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/entityTypes/<EntityTypeID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The language to retrieve the entity type for. The following fields are
	// language dependent:
	//
	// *   `EntityType.entities.value`
	// *   `EntityType.entities.synonyms`
	// *   `EntityType.excluded_phrases.value`
	//
	// If not specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/cx/docs/reference/language)
	// are supported.
	// Note: languages must be enabled in the agent before they can be used.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *GetEntityTypeRequest) Reset() {
	*x = GetEntityTypeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEntityTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEntityTypeRequest) ProtoMessage() {}

func (x *GetEntityTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEntityTypeRequest.ProtoReflect.Descriptor instead.
func (*GetEntityTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_rawDescGZIP(), []int{9}
}

func (x *GetEntityTypeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetEntityTypeRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// The request message for
// [EntityTypes.CreateEntityType][google.cloud.dialogflow.cx.v3beta1.EntityTypes.CreateEntityType].
type CreateEntityTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent to create a entity type for.
	// Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The entity type to create.
	EntityType *EntityType `protobuf:"bytes,2,opt,name=entity_type,json=entityType,proto3" json:"entity_type,omitempty"`
	// The language of the following fields in `entity_type`:
	//
	// *   `EntityType.entities.value`
	// *   `EntityType.entities.synonyms`
	// *   `EntityType.excluded_phrases.value`
	//
	// If not specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/cx/docs/reference/language)
	// are supported.
	// Note: languages must be enabled in the agent before they can be used.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *CreateEntityTypeRequest) Reset() {
	*x = CreateEntityTypeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateEntityTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateEntityTypeRequest) ProtoMessage() {}

func (x *CreateEntityTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateEntityTypeRequest.ProtoReflect.Descriptor instead.
func (*CreateEntityTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_rawDescGZIP(), []int{10}
}

func (x *CreateEntityTypeRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateEntityTypeRequest) GetEntityType() *EntityType {
	if x != nil {
		return x.EntityType
	}
	return nil
}

func (x *CreateEntityTypeRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// The request message for
// [EntityTypes.UpdateEntityType][google.cloud.dialogflow.cx.v3beta1.EntityTypes.UpdateEntityType].
type UpdateEntityTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The entity type to update.
	EntityType *EntityType `protobuf:"bytes,1,opt,name=entity_type,json=entityType,proto3" json:"entity_type,omitempty"`
	// The language of the following fields in `entity_type`:
	//
	// *   `EntityType.entities.value`
	// *   `EntityType.entities.synonyms`
	// *   `EntityType.excluded_phrases.value`
	//
	// If not specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/cx/docs/reference/language)
	// are supported.
	// Note: languages must be enabled in the agent before they can be used.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The mask to control which fields get updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateEntityTypeRequest) Reset() {
	*x = UpdateEntityTypeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateEntityTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateEntityTypeRequest) ProtoMessage() {}

func (x *UpdateEntityTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateEntityTypeRequest.ProtoReflect.Descriptor instead.
func (*UpdateEntityTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_rawDescGZIP(), []int{11}
}

func (x *UpdateEntityTypeRequest) GetEntityType() *EntityType {
	if x != nil {
		return x.EntityType
	}
	return nil
}

func (x *UpdateEntityTypeRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *UpdateEntityTypeRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request message for
// [EntityTypes.DeleteEntityType][google.cloud.dialogflow.cx.v3beta1.EntityTypes.DeleteEntityType].
type DeleteEntityTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the entity type to delete.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/entityTypes/<EntityTypeID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// This field has no effect for entity type not being used.
	// For entity types that are used by intents or pages:
	//
	//   - If `force` is set to false, an error will be returned with message
	//     indicating the referencing resources.
	//   - If `force` is set to true, Dialogflow will remove the entity type, as
	//     well as any references to the entity type (i.e. Page
	//     [parameter][google.cloud.dialogflow.cx.v3beta1.Form.Parameter] of the
	//     entity type will be changed to
	//     '@sys.any' and intent
	//     [parameter][google.cloud.dialogflow.cx.v3beta1.Intent.Parameter] of the
	//     entity type will be removed).
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteEntityTypeRequest) Reset() {
	*x = DeleteEntityTypeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteEntityTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteEntityTypeRequest) ProtoMessage() {}

func (x *DeleteEntityTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteEntityTypeRequest.ProtoReflect.Descriptor instead.
func (*DeleteEntityTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_rawDescGZIP(), []int{12}
}

func (x *DeleteEntityTypeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteEntityTypeRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// An **entity entry** for an associated entity type.
type EntityType_Entity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The primary value associated with this entity entry.
	// For example, if the entity type is *vegetable*, the value could be
	// *scallions*.
	//
	// For `KIND_MAP` entity types:
	//
	// *   A canonical value to be used in place of synonyms.
	//
	// For `KIND_LIST` entity types:
	//
	//   - A string that can contain references to other entity types (with or
	//     without aliases).
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Required. A collection of value synonyms. For example, if the entity type
	// is *vegetable*, and `value` is *scallions*, a synonym could be *green
	// onions*.
	//
	// For `KIND_LIST` entity types:
	//
	// *   This collection must contain exactly one synonym equal to `value`.
	Synonyms []string `protobuf:"bytes,2,rep,name=synonyms,proto3" json:"synonyms,omitempty"`
}

func (x *EntityType_Entity) Reset() {
	*x = EntityType_Entity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EntityType_Entity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntityType_Entity) ProtoMessage() {}

func (x *EntityType_Entity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntityType_Entity.ProtoReflect.Descriptor instead.
func (*EntityType_Entity) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_rawDescGZIP(), []int{0, 0}
}

func (x *EntityType_Entity) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *EntityType_Entity) GetSynonyms() []string {
	if x != nil {
		return x.Synonyms
	}
	return nil
}

// An excluded entity phrase that should not be matched.
type EntityType_ExcludedPhrase struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The word or phrase to be excluded.
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *EntityType_ExcludedPhrase) Reset() {
	*x = EntityType_ExcludedPhrase{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EntityType_ExcludedPhrase) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntityType_ExcludedPhrase) ProtoMessage() {}

func (x *EntityType_ExcludedPhrase) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntityType_ExcludedPhrase.ProtoReflect.Descriptor instead.
func (*EntityType_ExcludedPhrase) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_rawDescGZIP(), []int{0, 1}
}

func (x *EntityType_ExcludedPhrase) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// Conflicting resources detected during the import process. Only filled when
// [REPORT_CONFLICT][ImportEntityTypesResponse.REPORT_CONFLICT] is set in the
// request and there are conflicts in the display names.
type ImportEntityTypesResponse_ConflictingResources struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Display names of conflicting entity types.
	EntityTypeDisplayNames []string `protobuf:"bytes,1,rep,name=entity_type_display_names,json=entityTypeDisplayNames,proto3" json:"entity_type_display_names,omitempty"`
	// Display names of conflicting entities.
	EntityDisplayNames []string `protobuf:"bytes,2,rep,name=entity_display_names,json=entityDisplayNames,proto3" json:"entity_display_names,omitempty"`
}

func (x *ImportEntityTypesResponse_ConflictingResources) Reset() {
	*x = ImportEntityTypesResponse_ConflictingResources{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportEntityTypesResponse_ConflictingResources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportEntityTypesResponse_ConflictingResources) ProtoMessage() {}

func (x *ImportEntityTypesResponse_ConflictingResources) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportEntityTypesResponse_ConflictingResources.ProtoReflect.Descriptor instead.
func (*ImportEntityTypesResponse_ConflictingResources) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_rawDescGZIP(), []int{5, 0}
}

func (x *ImportEntityTypesResponse_ConflictingResources) GetEntityTypeDisplayNames() []string {
	if x != nil {
		return x.EntityTypeDisplayNames
	}
	return nil
}

func (x *ImportEntityTypesResponse_ConflictingResources) GetEntityDisplayNames() []string {
	if x != nil {
		return x.EntityDisplayNames
	}
	return nil
}

var File_google_cloud_dialogflow_cx_v3beta1_entity_type_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_rawDesc = []byte{
	0x0a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xac, 0x07, 0x0a, 0x0a, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4c, 0x0a,
	0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x4b, 0x69, 0x6e, 0x64,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x70, 0x0a, 0x13, 0x61,
	0x75, 0x74, 0x6f, 0x5f, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f,
	0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x45, 0x78, 0x70,
	0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x11, 0x61, 0x75, 0x74, 0x6f,
	0x45, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x51, 0x0a,
	0x08, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x2e,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x08, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73,
	0x12, 0x68, 0x0a, 0x10, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x68, 0x72,
	0x61, 0x73, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x45, 0x78, 0x63, 0x6c, 0x75,
	0x64, 0x65, 0x64, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x52, 0x0f, 0x65, 0x78, 0x63, 0x6c, 0x75,
	0x64, 0x65, 0x64, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x73, 0x12, 0x36, 0x0a, 0x17, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x66, 0x75, 0x7a, 0x7a, 0x79, 0x5f, 0x65, 0x78, 0x74, 0x72, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x46, 0x75, 0x7a, 0x7a, 0x79, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x64, 0x61, 0x63, 0x74, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x06, 0x72, 0x65, 0x64, 0x61, 0x63, 0x74, 0x1a, 0x44, 0x0a, 0x06, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x12, 0x19, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x1f, 0x0a, 0x08, 0x73, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x73, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x73,
	0x1a, 0x2b, 0x0a, 0x0e, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x50, 0x68, 0x72, 0x61,
	0x73, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x4a, 0x0a,
	0x04, 0x4b, 0x69, 0x6e, 0x64, 0x12, 0x14, 0x0a, 0x10, 0x4b, 0x49, 0x4e, 0x44, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x4b,
	0x49, 0x4e, 0x44, 0x5f, 0x4d, 0x41, 0x50, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x4b, 0x49, 0x4e,
	0x44, 0x5f, 0x4c, 0x49, 0x53, 0x54, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x4b, 0x49, 0x4e, 0x44,
	0x5f, 0x52, 0x45, 0x47, 0x45, 0x58, 0x50, 0x10, 0x03, 0x22, 0x59, 0x0a, 0x11, 0x41, 0x75, 0x74,
	0x6f, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x23,
	0x0a, 0x1f, 0x41, 0x55, 0x54, 0x4f, 0x5f, 0x45, 0x58, 0x50, 0x41, 0x4e, 0x53, 0x49, 0x4f, 0x4e,
	0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x1f, 0x0a, 0x1b, 0x41, 0x55, 0x54, 0x4f, 0x5f, 0x45, 0x58, 0x50, 0x41,
	0x4e, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x44, 0x45, 0x46, 0x41, 0x55,
	0x4c, 0x54, 0x10, 0x01, 0x3a, 0x7b, 0xea, 0x41, 0x78, 0x0a, 0x24, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x50, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f,
	0x7b, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x7d, 0x22, 0xee, 0x03, 0x0a, 0x18, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x12, 0x24, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x26, 0x0a, 0x0c, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x2f, 0x0a, 0x10,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x5f, 0x75, 0x72, 0x69,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0e, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x55, 0x72, 0x69, 0x12, 0x44, 0x0a,
	0x1b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x5f, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x18, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x6c,
	0x69, 0x6e, 0x65, 0x12, 0x6d, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x46, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x46, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63,
	0x6f, 0x64, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x45, 0x0a, 0x0a,
	0x44, 0x61, 0x74, 0x61, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x1b, 0x0a, 0x17, 0x44, 0x41,
	0x54, 0x41, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x42, 0x4c, 0x4f, 0x42, 0x10,
	0x01, 0x12, 0x10, 0x0a, 0x0c, 0x4a, 0x53, 0x4f, 0x4e, 0x5f, 0x50, 0x41, 0x43, 0x4b, 0x41, 0x47,
	0x45, 0x10, 0x05, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xcb, 0x01, 0x0a, 0x19, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x2a, 0x0a, 0x10, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0e, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x55, 0x72, 0x69, 0x12, 0x69, 0x0a, 0x14,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x48, 0x00, 0x52, 0x12, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x17, 0x0a, 0x15, 0x65, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x22, 0x1b, 0x0a, 0x19, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xc0, 0x04,
	0x0a, 0x18, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x26, 0x12, 0x24, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x2a, 0x0a, 0x10, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0e, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x55, 0x72, 0x69, 0x12, 0x64, 0x0a, 0x14,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x12,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x12, 0x70, 0x0a, 0x0c, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5a, 0x0a, 0x12, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2c, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x10,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65,
	0x22, 0x6e, 0x0a, 0x0b, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x1c, 0x0a, 0x18, 0x4d, 0x45, 0x52, 0x47, 0x45, 0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a,
	0x07, 0x52, 0x45, 0x50, 0x4c, 0x41, 0x43, 0x45, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x45,
	0x52, 0x47, 0x45, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x52, 0x45, 0x4e, 0x41, 0x4d, 0x45, 0x10,
	0x03, 0x12, 0x13, 0x0a, 0x0f, 0x52, 0x45, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x43, 0x4f, 0x4e, 0x46,
	0x4c, 0x49, 0x43, 0x54, 0x10, 0x04, 0x12, 0x08, 0x0a, 0x04, 0x4b, 0x45, 0x45, 0x50, 0x10, 0x05,
	0x42, 0x0e, 0x0a, 0x0c, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x22, 0xf9, 0x02, 0x0a, 0x19, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4c,
	0x0a, 0x0c, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x29, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x87, 0x01, 0x0a,
	0x15, 0x63, 0x6f, 0x6e, 0x66, 0x6c, 0x69, 0x63, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x52, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x66,
	0x6c, 0x69, 0x63, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x52, 0x14, 0x63, 0x6f, 0x6e, 0x66, 0x6c, 0x69, 0x63, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x1a, 0x83, 0x01, 0x0a, 0x14, 0x43, 0x6f, 0x6e, 0x66, 0x6c,
	0x69, 0x63, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12,
	0x39, 0x0a, 0x19, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x16, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x44, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x12, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x22, 0x1b, 0x0a, 0x19,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65,
	0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xbf, 0x01, 0x0a, 0x16, 0x4c, 0x69,
	0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x12, 0x24, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x94, 0x01, 0x0a, 0x17,
	0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x51, 0x0a, 0x0c, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0x7d, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26,
	0x0a, 0x24, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64,
	0x65, 0x22, 0xda, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x26, 0x12, 0x24, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x54, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0xd1,
	0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x0b, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x6b, 0x22, 0x71, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x26, 0x0a, 0x24, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05,
	0x66, 0x6f, 0x72, 0x63, 0x65, 0x32, 0xc9, 0x0d, 0x0a, 0x0b, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0xc7, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70,
	0x65, 0x22, 0x4c, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f,
	0x12, 0x3d, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xe8, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70,
	0x65, 0x22, 0x67, 0xda, 0x41, 0x12, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4c, 0x3a, 0x0b,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0x3d, 0x2f, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0xf9, 0x01, 0x0a, 0x10, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x22, 0x78, 0xda, 0x41,
	0x17, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2c, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x58, 0x3a, 0x0b,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x32, 0x49, 0x2f, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb5, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x22, 0x4c, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x2a,
	0x3d, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xda,
	0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70,
	0x65, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4e, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x12, 0x3d, 0x2f, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0xfb, 0x01, 0x0a, 0x11,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65,
	0x73, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x88,
	0x01, 0xca, 0x41, 0x36, 0x0a, 0x19, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x19, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70,
	0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49,
	0x3a, 0x01, 0x2a, 0x22, 0x44, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70,
	0x65, 0x73, 0x3a, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x12, 0xfb, 0x01, 0x0a, 0x11, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x88, 0x01, 0xca,
	0x41, 0x36, 0x0a, 0x19, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x19, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x3a, 0x01,
	0x2a, 0x22, 0x44, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73,
	0x3a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x1a, 0x78, 0xca, 0x41, 0x19, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x59, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
	0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x42, 0xc6, 0x01, 0x0a, 0x26, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x0f, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x36, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f,
	0x63, 0x78, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x63, 0x78,
	0x70, 0x62, 0x3b, 0x63, 0x78, 0x70, 0x62, 0xa2, 0x02, 0x02, 0x44, 0x46, 0xaa, 0x02, 0x22, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x43, 0x78, 0x2e, 0x56, 0x33, 0x42, 0x65, 0x74, 0x61,
	0x31, 0xea, 0x02, 0x26, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x3a, 0x3a, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x3a, 0x3a, 0x43,
	0x58, 0x3a, 0x3a, 0x56, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_rawDescData = file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_rawDesc
)

func file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_rawDescData
}

var file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes = make([]protoimpl.MessageInfo, 16)
var file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_goTypes = []any{
	(EntityType_Kind)(0),                                   // 0: google.cloud.dialogflow.cx.v3beta1.EntityType.Kind
	(EntityType_AutoExpansionMode)(0),                      // 1: google.cloud.dialogflow.cx.v3beta1.EntityType.AutoExpansionMode
	(ExportEntityTypesRequest_DataFormat)(0),               // 2: google.cloud.dialogflow.cx.v3beta1.ExportEntityTypesRequest.DataFormat
	(ImportEntityTypesRequest_MergeOption)(0),              // 3: google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.MergeOption
	(*EntityType)(nil),                                     // 4: google.cloud.dialogflow.cx.v3beta1.EntityType
	(*ExportEntityTypesRequest)(nil),                       // 5: google.cloud.dialogflow.cx.v3beta1.ExportEntityTypesRequest
	(*ExportEntityTypesResponse)(nil),                      // 6: google.cloud.dialogflow.cx.v3beta1.ExportEntityTypesResponse
	(*ExportEntityTypesMetadata)(nil),                      // 7: google.cloud.dialogflow.cx.v3beta1.ExportEntityTypesMetadata
	(*ImportEntityTypesRequest)(nil),                       // 8: google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest
	(*ImportEntityTypesResponse)(nil),                      // 9: google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesResponse
	(*ImportEntityTypesMetadata)(nil),                      // 10: google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesMetadata
	(*ListEntityTypesRequest)(nil),                         // 11: google.cloud.dialogflow.cx.v3beta1.ListEntityTypesRequest
	(*ListEntityTypesResponse)(nil),                        // 12: google.cloud.dialogflow.cx.v3beta1.ListEntityTypesResponse
	(*GetEntityTypeRequest)(nil),                           // 13: google.cloud.dialogflow.cx.v3beta1.GetEntityTypeRequest
	(*CreateEntityTypeRequest)(nil),                        // 14: google.cloud.dialogflow.cx.v3beta1.CreateEntityTypeRequest
	(*UpdateEntityTypeRequest)(nil),                        // 15: google.cloud.dialogflow.cx.v3beta1.UpdateEntityTypeRequest
	(*DeleteEntityTypeRequest)(nil),                        // 16: google.cloud.dialogflow.cx.v3beta1.DeleteEntityTypeRequest
	(*EntityType_Entity)(nil),                              // 17: google.cloud.dialogflow.cx.v3beta1.EntityType.Entity
	(*EntityType_ExcludedPhrase)(nil),                      // 18: google.cloud.dialogflow.cx.v3beta1.EntityType.ExcludedPhrase
	(*ImportEntityTypesResponse_ConflictingResources)(nil), // 19: google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesResponse.ConflictingResources
	(*InlineDestination)(nil),                              // 20: google.cloud.dialogflow.cx.v3beta1.InlineDestination
	(*InlineSource)(nil),                                   // 21: google.cloud.dialogflow.cx.v3beta1.InlineSource
	(*fieldmaskpb.FieldMask)(nil),                          // 22: google.protobuf.FieldMask
	(*emptypb.Empty)(nil),                                  // 23: google.protobuf.Empty
	(*longrunningpb.Operation)(nil),                        // 24: google.longrunning.Operation
}
var file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_depIdxs = []int32{
	0,  // 0: google.cloud.dialogflow.cx.v3beta1.EntityType.kind:type_name -> google.cloud.dialogflow.cx.v3beta1.EntityType.Kind
	1,  // 1: google.cloud.dialogflow.cx.v3beta1.EntityType.auto_expansion_mode:type_name -> google.cloud.dialogflow.cx.v3beta1.EntityType.AutoExpansionMode
	17, // 2: google.cloud.dialogflow.cx.v3beta1.EntityType.entities:type_name -> google.cloud.dialogflow.cx.v3beta1.EntityType.Entity
	18, // 3: google.cloud.dialogflow.cx.v3beta1.EntityType.excluded_phrases:type_name -> google.cloud.dialogflow.cx.v3beta1.EntityType.ExcludedPhrase
	2,  // 4: google.cloud.dialogflow.cx.v3beta1.ExportEntityTypesRequest.data_format:type_name -> google.cloud.dialogflow.cx.v3beta1.ExportEntityTypesRequest.DataFormat
	20, // 5: google.cloud.dialogflow.cx.v3beta1.ExportEntityTypesResponse.entity_types_content:type_name -> google.cloud.dialogflow.cx.v3beta1.InlineDestination
	21, // 6: google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.entity_types_content:type_name -> google.cloud.dialogflow.cx.v3beta1.InlineSource
	3,  // 7: google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.merge_option:type_name -> google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest.MergeOption
	19, // 8: google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesResponse.conflicting_resources:type_name -> google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesResponse.ConflictingResources
	4,  // 9: google.cloud.dialogflow.cx.v3beta1.ListEntityTypesResponse.entity_types:type_name -> google.cloud.dialogflow.cx.v3beta1.EntityType
	4,  // 10: google.cloud.dialogflow.cx.v3beta1.CreateEntityTypeRequest.entity_type:type_name -> google.cloud.dialogflow.cx.v3beta1.EntityType
	4,  // 11: google.cloud.dialogflow.cx.v3beta1.UpdateEntityTypeRequest.entity_type:type_name -> google.cloud.dialogflow.cx.v3beta1.EntityType
	22, // 12: google.cloud.dialogflow.cx.v3beta1.UpdateEntityTypeRequest.update_mask:type_name -> google.protobuf.FieldMask
	13, // 13: google.cloud.dialogflow.cx.v3beta1.EntityTypes.GetEntityType:input_type -> google.cloud.dialogflow.cx.v3beta1.GetEntityTypeRequest
	14, // 14: google.cloud.dialogflow.cx.v3beta1.EntityTypes.CreateEntityType:input_type -> google.cloud.dialogflow.cx.v3beta1.CreateEntityTypeRequest
	15, // 15: google.cloud.dialogflow.cx.v3beta1.EntityTypes.UpdateEntityType:input_type -> google.cloud.dialogflow.cx.v3beta1.UpdateEntityTypeRequest
	16, // 16: google.cloud.dialogflow.cx.v3beta1.EntityTypes.DeleteEntityType:input_type -> google.cloud.dialogflow.cx.v3beta1.DeleteEntityTypeRequest
	11, // 17: google.cloud.dialogflow.cx.v3beta1.EntityTypes.ListEntityTypes:input_type -> google.cloud.dialogflow.cx.v3beta1.ListEntityTypesRequest
	5,  // 18: google.cloud.dialogflow.cx.v3beta1.EntityTypes.ExportEntityTypes:input_type -> google.cloud.dialogflow.cx.v3beta1.ExportEntityTypesRequest
	8,  // 19: google.cloud.dialogflow.cx.v3beta1.EntityTypes.ImportEntityTypes:input_type -> google.cloud.dialogflow.cx.v3beta1.ImportEntityTypesRequest
	4,  // 20: google.cloud.dialogflow.cx.v3beta1.EntityTypes.GetEntityType:output_type -> google.cloud.dialogflow.cx.v3beta1.EntityType
	4,  // 21: google.cloud.dialogflow.cx.v3beta1.EntityTypes.CreateEntityType:output_type -> google.cloud.dialogflow.cx.v3beta1.EntityType
	4,  // 22: google.cloud.dialogflow.cx.v3beta1.EntityTypes.UpdateEntityType:output_type -> google.cloud.dialogflow.cx.v3beta1.EntityType
	23, // 23: google.cloud.dialogflow.cx.v3beta1.EntityTypes.DeleteEntityType:output_type -> google.protobuf.Empty
	12, // 24: google.cloud.dialogflow.cx.v3beta1.EntityTypes.ListEntityTypes:output_type -> google.cloud.dialogflow.cx.v3beta1.ListEntityTypesResponse
	24, // 25: google.cloud.dialogflow.cx.v3beta1.EntityTypes.ExportEntityTypes:output_type -> google.longrunning.Operation
	24, // 26: google.cloud.dialogflow.cx.v3beta1.EntityTypes.ImportEntityTypes:output_type -> google.longrunning.Operation
	20, // [20:27] is the sub-list for method output_type
	13, // [13:20] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_init() }
func file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_init() {
	if File_google_cloud_dialogflow_cx_v3beta1_entity_type_proto != nil {
		return
	}
	file_google_cloud_dialogflow_cx_v3beta1_inline_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*EntityType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*ExportEntityTypesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*ExportEntityTypesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*ExportEntityTypesMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*ImportEntityTypesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*ImportEntityTypesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*ImportEntityTypesMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*ListEntityTypesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*ListEntityTypesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*GetEntityTypeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*CreateEntityTypeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateEntityTypeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*DeleteEntityTypeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*EntityType_Entity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[14].Exporter = func(v any, i int) any {
			switch v := v.(*EntityType_ExcludedPhrase); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[15].Exporter = func(v any, i int) any {
			switch v := v.(*ImportEntityTypesResponse_ConflictingResources); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[1].OneofWrappers = []any{
		(*ExportEntityTypesRequest_EntityTypesUri)(nil),
		(*ExportEntityTypesRequest_EntityTypesContentInline)(nil),
	}
	file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[2].OneofWrappers = []any{
		(*ExportEntityTypesResponse_EntityTypesUri)(nil),
		(*ExportEntityTypesResponse_EntityTypesContent)(nil),
	}
	file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes[4].OneofWrappers = []any{
		(*ImportEntityTypesRequest_EntityTypesUri)(nil),
		(*ImportEntityTypesRequest_EntityTypesContent)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   16,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_cx_v3beta1_entity_type_proto = out.File
	file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_rawDesc = nil
	file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_goTypes = nil
	file_google_cloud_dialogflow_cx_v3beta1_entity_type_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// EntityTypesClient is the client API for EntityTypes service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type EntityTypesClient interface {
	// Retrieves the specified entity type.
	GetEntityType(ctx context.Context, in *GetEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error)
	// Creates an entity type in the specified agent.
	CreateEntityType(ctx context.Context, in *CreateEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error)
	// Updates the specified entity type.
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	UpdateEntityType(ctx context.Context, in *UpdateEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error)
	// Deletes the specified entity type.
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	DeleteEntityType(ctx context.Context, in *DeleteEntityTypeRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Returns the list of all entity types in the specified agent.
	ListEntityTypes(ctx context.Context, in *ListEntityTypesRequest, opts ...grpc.CallOption) (*ListEntityTypesResponse, error)
	// Exports the selected entity types.
	ExportEntityTypes(ctx context.Context, in *ExportEntityTypesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Imports the specified entitytypes into the agent.
	ImportEntityTypes(ctx context.Context, in *ImportEntityTypesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type entityTypesClient struct {
	cc grpc.ClientConnInterface
}

func NewEntityTypesClient(cc grpc.ClientConnInterface) EntityTypesClient {
	return &entityTypesClient{cc}
}

func (c *entityTypesClient) GetEntityType(ctx context.Context, in *GetEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error) {
	out := new(EntityType)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.EntityTypes/GetEntityType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) CreateEntityType(ctx context.Context, in *CreateEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error) {
	out := new(EntityType)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.EntityTypes/CreateEntityType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) UpdateEntityType(ctx context.Context, in *UpdateEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error) {
	out := new(EntityType)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.EntityTypes/UpdateEntityType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) DeleteEntityType(ctx context.Context, in *DeleteEntityTypeRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.EntityTypes/DeleteEntityType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) ListEntityTypes(ctx context.Context, in *ListEntityTypesRequest, opts ...grpc.CallOption) (*ListEntityTypesResponse, error) {
	out := new(ListEntityTypesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.EntityTypes/ListEntityTypes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) ExportEntityTypes(ctx context.Context, in *ExportEntityTypesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.EntityTypes/ExportEntityTypes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) ImportEntityTypes(ctx context.Context, in *ImportEntityTypesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.EntityTypes/ImportEntityTypes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EntityTypesServer is the server API for EntityTypes service.
type EntityTypesServer interface {
	// Retrieves the specified entity type.
	GetEntityType(context.Context, *GetEntityTypeRequest) (*EntityType, error)
	// Creates an entity type in the specified agent.
	CreateEntityType(context.Context, *CreateEntityTypeRequest) (*EntityType, error)
	// Updates the specified entity type.
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	UpdateEntityType(context.Context, *UpdateEntityTypeRequest) (*EntityType, error)
	// Deletes the specified entity type.
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	DeleteEntityType(context.Context, *DeleteEntityTypeRequest) (*emptypb.Empty, error)
	// Returns the list of all entity types in the specified agent.
	ListEntityTypes(context.Context, *ListEntityTypesRequest) (*ListEntityTypesResponse, error)
	// Exports the selected entity types.
	ExportEntityTypes(context.Context, *ExportEntityTypesRequest) (*longrunningpb.Operation, error)
	// Imports the specified entitytypes into the agent.
	ImportEntityTypes(context.Context, *ImportEntityTypesRequest) (*longrunningpb.Operation, error)
}

// UnimplementedEntityTypesServer can be embedded to have forward compatible implementations.
type UnimplementedEntityTypesServer struct {
}

func (*UnimplementedEntityTypesServer) GetEntityType(context.Context, *GetEntityTypeRequest) (*EntityType, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEntityType not implemented")
}
func (*UnimplementedEntityTypesServer) CreateEntityType(context.Context, *CreateEntityTypeRequest) (*EntityType, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEntityType not implemented")
}
func (*UnimplementedEntityTypesServer) UpdateEntityType(context.Context, *UpdateEntityTypeRequest) (*EntityType, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEntityType not implemented")
}
func (*UnimplementedEntityTypesServer) DeleteEntityType(context.Context, *DeleteEntityTypeRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEntityType not implemented")
}
func (*UnimplementedEntityTypesServer) ListEntityTypes(context.Context, *ListEntityTypesRequest) (*ListEntityTypesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEntityTypes not implemented")
}
func (*UnimplementedEntityTypesServer) ExportEntityTypes(context.Context, *ExportEntityTypesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportEntityTypes not implemented")
}
func (*UnimplementedEntityTypesServer) ImportEntityTypes(context.Context, *ImportEntityTypesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportEntityTypes not implemented")
}

func RegisterEntityTypesServer(s *grpc.Server, srv EntityTypesServer) {
	s.RegisterService(&_EntityTypes_serviceDesc, srv)
}

func _EntityTypes_GetEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).GetEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.EntityTypes/GetEntityType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).GetEntityType(ctx, req.(*GetEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_CreateEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).CreateEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.EntityTypes/CreateEntityType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).CreateEntityType(ctx, req.(*CreateEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_UpdateEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).UpdateEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.EntityTypes/UpdateEntityType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).UpdateEntityType(ctx, req.(*UpdateEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_DeleteEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).DeleteEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.EntityTypes/DeleteEntityType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).DeleteEntityType(ctx, req.(*DeleteEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_ListEntityTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEntityTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).ListEntityTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.EntityTypes/ListEntityTypes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).ListEntityTypes(ctx, req.(*ListEntityTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_ExportEntityTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportEntityTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).ExportEntityTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.EntityTypes/ExportEntityTypes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).ExportEntityTypes(ctx, req.(*ExportEntityTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_ImportEntityTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportEntityTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).ImportEntityTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.EntityTypes/ImportEntityTypes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).ImportEntityTypes(ctx, req.(*ImportEntityTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _EntityTypes_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.cx.v3beta1.EntityTypes",
	HandlerType: (*EntityTypesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetEntityType",
			Handler:    _EntityTypes_GetEntityType_Handler,
		},
		{
			MethodName: "CreateEntityType",
			Handler:    _EntityTypes_CreateEntityType_Handler,
		},
		{
			MethodName: "UpdateEntityType",
			Handler:    _EntityTypes_UpdateEntityType_Handler,
		},
		{
			MethodName: "DeleteEntityType",
			Handler:    _EntityTypes_DeleteEntityType_Handler,
		},
		{
			MethodName: "ListEntityTypes",
			Handler:    _EntityTypes_ListEntityTypes_Handler,
		},
		{
			MethodName: "ExportEntityTypes",
			Handler:    _EntityTypes_ExportEntityTypes_Handler,
		},
		{
			MethodName: "ImportEntityTypes",
			Handler:    _EntityTypes_ImportEntityTypes_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/cx/v3beta1/entity_type.proto",
}
