// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/cx/v3/test_case.proto

package cxpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	TestCases_ListTestCases_FullMethodName        = "/google.cloud.dialogflow.cx.v3.TestCases/ListTestCases"
	TestCases_BatchDeleteTestCases_FullMethodName = "/google.cloud.dialogflow.cx.v3.TestCases/BatchDeleteTestCases"
	TestCases_GetTestCase_FullMethodName          = "/google.cloud.dialogflow.cx.v3.TestCases/GetTestCase"
	TestCases_CreateTestCase_FullMethodName       = "/google.cloud.dialogflow.cx.v3.TestCases/CreateTestCase"
	TestCases_UpdateTestCase_FullMethodName       = "/google.cloud.dialogflow.cx.v3.TestCases/UpdateTestCase"
	TestCases_RunTestCase_FullMethodName          = "/google.cloud.dialogflow.cx.v3.TestCases/RunTestCase"
	TestCases_BatchRunTestCases_FullMethodName    = "/google.cloud.dialogflow.cx.v3.TestCases/BatchRunTestCases"
	TestCases_CalculateCoverage_FullMethodName    = "/google.cloud.dialogflow.cx.v3.TestCases/CalculateCoverage"
	TestCases_ImportTestCases_FullMethodName      = "/google.cloud.dialogflow.cx.v3.TestCases/ImportTestCases"
	TestCases_ExportTestCases_FullMethodName      = "/google.cloud.dialogflow.cx.v3.TestCases/ExportTestCases"
	TestCases_ListTestCaseResults_FullMethodName  = "/google.cloud.dialogflow.cx.v3.TestCases/ListTestCaseResults"
	TestCases_GetTestCaseResult_FullMethodName    = "/google.cloud.dialogflow.cx.v3.TestCases/GetTestCaseResult"
)

// TestCasesClient is the client API for TestCases service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type TestCasesClient interface {
	// Fetches a list of test cases for a given agent.
	ListTestCases(ctx context.Context, in *ListTestCasesRequest, opts ...grpc.CallOption) (*ListTestCasesResponse, error)
	// Batch deletes test cases.
	BatchDeleteTestCases(ctx context.Context, in *BatchDeleteTestCasesRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets a test case.
	GetTestCase(ctx context.Context, in *GetTestCaseRequest, opts ...grpc.CallOption) (*TestCase, error)
	// Creates a test case for the given agent.
	CreateTestCase(ctx context.Context, in *CreateTestCaseRequest, opts ...grpc.CallOption) (*TestCase, error)
	// Updates the specified test case.
	UpdateTestCase(ctx context.Context, in *UpdateTestCaseRequest, opts ...grpc.CallOption) (*TestCase, error)
	// Kicks off a test case run.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [RunTestCaseMetadata][google.cloud.dialogflow.cx.v3.RunTestCaseMetadata]
	// - `response`:
	// [RunTestCaseResponse][google.cloud.dialogflow.cx.v3.RunTestCaseResponse]
	RunTestCase(ctx context.Context, in *RunTestCaseRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Kicks off a batch run of test cases.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [BatchRunTestCasesMetadata][google.cloud.dialogflow.cx.v3.BatchRunTestCasesMetadata]
	// - `response`:
	// [BatchRunTestCasesResponse][google.cloud.dialogflow.cx.v3.BatchRunTestCasesResponse]
	BatchRunTestCases(ctx context.Context, in *BatchRunTestCasesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Calculates the test coverage for an agent.
	CalculateCoverage(ctx context.Context, in *CalculateCoverageRequest, opts ...grpc.CallOption) (*CalculateCoverageResponse, error)
	// Imports the test cases from a Cloud Storage bucket or a local file. It
	// always creates new test cases and won't overwrite any existing ones. The
	// provided ID in the imported test case is neglected.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [ImportTestCasesMetadata][google.cloud.dialogflow.cx.v3.ImportTestCasesMetadata]
	// - `response`:
	// [ImportTestCasesResponse][google.cloud.dialogflow.cx.v3.ImportTestCasesResponse]
	ImportTestCases(ctx context.Context, in *ImportTestCasesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Exports the test cases under the agent to a Cloud Storage bucket or a local
	// file. Filter can be applied to export a subset of test cases.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [ExportTestCasesMetadata][google.cloud.dialogflow.cx.v3.ExportTestCasesMetadata]
	// - `response`:
	// [ExportTestCasesResponse][google.cloud.dialogflow.cx.v3.ExportTestCasesResponse]
	ExportTestCases(ctx context.Context, in *ExportTestCasesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Fetches the list of run results for the given test case. A maximum of 100
	// results are kept for each test case.
	ListTestCaseResults(ctx context.Context, in *ListTestCaseResultsRequest, opts ...grpc.CallOption) (*ListTestCaseResultsResponse, error)
	// Gets a test case result.
	GetTestCaseResult(ctx context.Context, in *GetTestCaseResultRequest, opts ...grpc.CallOption) (*TestCaseResult, error)
}

type testCasesClient struct {
	cc grpc.ClientConnInterface
}

func NewTestCasesClient(cc grpc.ClientConnInterface) TestCasesClient {
	return &testCasesClient{cc}
}

func (c *testCasesClient) ListTestCases(ctx context.Context, in *ListTestCasesRequest, opts ...grpc.CallOption) (*ListTestCasesResponse, error) {
	out := new(ListTestCasesResponse)
	err := c.cc.Invoke(ctx, TestCases_ListTestCases_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *testCasesClient) BatchDeleteTestCases(ctx context.Context, in *BatchDeleteTestCasesRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, TestCases_BatchDeleteTestCases_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *testCasesClient) GetTestCase(ctx context.Context, in *GetTestCaseRequest, opts ...grpc.CallOption) (*TestCase, error) {
	out := new(TestCase)
	err := c.cc.Invoke(ctx, TestCases_GetTestCase_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *testCasesClient) CreateTestCase(ctx context.Context, in *CreateTestCaseRequest, opts ...grpc.CallOption) (*TestCase, error) {
	out := new(TestCase)
	err := c.cc.Invoke(ctx, TestCases_CreateTestCase_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *testCasesClient) UpdateTestCase(ctx context.Context, in *UpdateTestCaseRequest, opts ...grpc.CallOption) (*TestCase, error) {
	out := new(TestCase)
	err := c.cc.Invoke(ctx, TestCases_UpdateTestCase_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *testCasesClient) RunTestCase(ctx context.Context, in *RunTestCaseRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, TestCases_RunTestCase_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *testCasesClient) BatchRunTestCases(ctx context.Context, in *BatchRunTestCasesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, TestCases_BatchRunTestCases_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *testCasesClient) CalculateCoverage(ctx context.Context, in *CalculateCoverageRequest, opts ...grpc.CallOption) (*CalculateCoverageResponse, error) {
	out := new(CalculateCoverageResponse)
	err := c.cc.Invoke(ctx, TestCases_CalculateCoverage_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *testCasesClient) ImportTestCases(ctx context.Context, in *ImportTestCasesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, TestCases_ImportTestCases_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *testCasesClient) ExportTestCases(ctx context.Context, in *ExportTestCasesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, TestCases_ExportTestCases_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *testCasesClient) ListTestCaseResults(ctx context.Context, in *ListTestCaseResultsRequest, opts ...grpc.CallOption) (*ListTestCaseResultsResponse, error) {
	out := new(ListTestCaseResultsResponse)
	err := c.cc.Invoke(ctx, TestCases_ListTestCaseResults_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *testCasesClient) GetTestCaseResult(ctx context.Context, in *GetTestCaseResultRequest, opts ...grpc.CallOption) (*TestCaseResult, error) {
	out := new(TestCaseResult)
	err := c.cc.Invoke(ctx, TestCases_GetTestCaseResult_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TestCasesServer is the server API for TestCases service.
// All implementations should embed UnimplementedTestCasesServer
// for forward compatibility
type TestCasesServer interface {
	// Fetches a list of test cases for a given agent.
	ListTestCases(context.Context, *ListTestCasesRequest) (*ListTestCasesResponse, error)
	// Batch deletes test cases.
	BatchDeleteTestCases(context.Context, *BatchDeleteTestCasesRequest) (*emptypb.Empty, error)
	// Gets a test case.
	GetTestCase(context.Context, *GetTestCaseRequest) (*TestCase, error)
	// Creates a test case for the given agent.
	CreateTestCase(context.Context, *CreateTestCaseRequest) (*TestCase, error)
	// Updates the specified test case.
	UpdateTestCase(context.Context, *UpdateTestCaseRequest) (*TestCase, error)
	// Kicks off a test case run.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [RunTestCaseMetadata][google.cloud.dialogflow.cx.v3.RunTestCaseMetadata]
	// - `response`:
	// [RunTestCaseResponse][google.cloud.dialogflow.cx.v3.RunTestCaseResponse]
	RunTestCase(context.Context, *RunTestCaseRequest) (*longrunningpb.Operation, error)
	// Kicks off a batch run of test cases.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [BatchRunTestCasesMetadata][google.cloud.dialogflow.cx.v3.BatchRunTestCasesMetadata]
	// - `response`:
	// [BatchRunTestCasesResponse][google.cloud.dialogflow.cx.v3.BatchRunTestCasesResponse]
	BatchRunTestCases(context.Context, *BatchRunTestCasesRequest) (*longrunningpb.Operation, error)
	// Calculates the test coverage for an agent.
	CalculateCoverage(context.Context, *CalculateCoverageRequest) (*CalculateCoverageResponse, error)
	// Imports the test cases from a Cloud Storage bucket or a local file. It
	// always creates new test cases and won't overwrite any existing ones. The
	// provided ID in the imported test case is neglected.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [ImportTestCasesMetadata][google.cloud.dialogflow.cx.v3.ImportTestCasesMetadata]
	// - `response`:
	// [ImportTestCasesResponse][google.cloud.dialogflow.cx.v3.ImportTestCasesResponse]
	ImportTestCases(context.Context, *ImportTestCasesRequest) (*longrunningpb.Operation, error)
	// Exports the test cases under the agent to a Cloud Storage bucket or a local
	// file. Filter can be applied to export a subset of test cases.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [ExportTestCasesMetadata][google.cloud.dialogflow.cx.v3.ExportTestCasesMetadata]
	// - `response`:
	// [ExportTestCasesResponse][google.cloud.dialogflow.cx.v3.ExportTestCasesResponse]
	ExportTestCases(context.Context, *ExportTestCasesRequest) (*longrunningpb.Operation, error)
	// Fetches the list of run results for the given test case. A maximum of 100
	// results are kept for each test case.
	ListTestCaseResults(context.Context, *ListTestCaseResultsRequest) (*ListTestCaseResultsResponse, error)
	// Gets a test case result.
	GetTestCaseResult(context.Context, *GetTestCaseResultRequest) (*TestCaseResult, error)
}

// UnimplementedTestCasesServer should be embedded to have forward compatible implementations.
type UnimplementedTestCasesServer struct {
}

func (UnimplementedTestCasesServer) ListTestCases(context.Context, *ListTestCasesRequest) (*ListTestCasesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTestCases not implemented")
}
func (UnimplementedTestCasesServer) BatchDeleteTestCases(context.Context, *BatchDeleteTestCasesRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchDeleteTestCases not implemented")
}
func (UnimplementedTestCasesServer) GetTestCase(context.Context, *GetTestCaseRequest) (*TestCase, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTestCase not implemented")
}
func (UnimplementedTestCasesServer) CreateTestCase(context.Context, *CreateTestCaseRequest) (*TestCase, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTestCase not implemented")
}
func (UnimplementedTestCasesServer) UpdateTestCase(context.Context, *UpdateTestCaseRequest) (*TestCase, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTestCase not implemented")
}
func (UnimplementedTestCasesServer) RunTestCase(context.Context, *RunTestCaseRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunTestCase not implemented")
}
func (UnimplementedTestCasesServer) BatchRunTestCases(context.Context, *BatchRunTestCasesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchRunTestCases not implemented")
}
func (UnimplementedTestCasesServer) CalculateCoverage(context.Context, *CalculateCoverageRequest) (*CalculateCoverageResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CalculateCoverage not implemented")
}
func (UnimplementedTestCasesServer) ImportTestCases(context.Context, *ImportTestCasesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportTestCases not implemented")
}
func (UnimplementedTestCasesServer) ExportTestCases(context.Context, *ExportTestCasesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportTestCases not implemented")
}
func (UnimplementedTestCasesServer) ListTestCaseResults(context.Context, *ListTestCaseResultsRequest) (*ListTestCaseResultsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTestCaseResults not implemented")
}
func (UnimplementedTestCasesServer) GetTestCaseResult(context.Context, *GetTestCaseResultRequest) (*TestCaseResult, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTestCaseResult not implemented")
}

// UnsafeTestCasesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to TestCasesServer will
// result in compilation errors.
type UnsafeTestCasesServer interface {
	mustEmbedUnimplementedTestCasesServer()
}

func RegisterTestCasesServer(s grpc.ServiceRegistrar, srv TestCasesServer) {
	s.RegisterService(&TestCases_ServiceDesc, srv)
}

func _TestCases_ListTestCases_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTestCasesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TestCasesServer).ListTestCases(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TestCases_ListTestCases_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TestCasesServer).ListTestCases(ctx, req.(*ListTestCasesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TestCases_BatchDeleteTestCases_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteTestCasesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TestCasesServer).BatchDeleteTestCases(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TestCases_BatchDeleteTestCases_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TestCasesServer).BatchDeleteTestCases(ctx, req.(*BatchDeleteTestCasesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TestCases_GetTestCase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTestCaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TestCasesServer).GetTestCase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TestCases_GetTestCase_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TestCasesServer).GetTestCase(ctx, req.(*GetTestCaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TestCases_CreateTestCase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTestCaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TestCasesServer).CreateTestCase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TestCases_CreateTestCase_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TestCasesServer).CreateTestCase(ctx, req.(*CreateTestCaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TestCases_UpdateTestCase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTestCaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TestCasesServer).UpdateTestCase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TestCases_UpdateTestCase_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TestCasesServer).UpdateTestCase(ctx, req.(*UpdateTestCaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TestCases_RunTestCase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunTestCaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TestCasesServer).RunTestCase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TestCases_RunTestCase_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TestCasesServer).RunTestCase(ctx, req.(*RunTestCaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TestCases_BatchRunTestCases_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchRunTestCasesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TestCasesServer).BatchRunTestCases(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TestCases_BatchRunTestCases_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TestCasesServer).BatchRunTestCases(ctx, req.(*BatchRunTestCasesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TestCases_CalculateCoverage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CalculateCoverageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TestCasesServer).CalculateCoverage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TestCases_CalculateCoverage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TestCasesServer).CalculateCoverage(ctx, req.(*CalculateCoverageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TestCases_ImportTestCases_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportTestCasesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TestCasesServer).ImportTestCases(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TestCases_ImportTestCases_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TestCasesServer).ImportTestCases(ctx, req.(*ImportTestCasesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TestCases_ExportTestCases_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportTestCasesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TestCasesServer).ExportTestCases(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TestCases_ExportTestCases_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TestCasesServer).ExportTestCases(ctx, req.(*ExportTestCasesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TestCases_ListTestCaseResults_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTestCaseResultsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TestCasesServer).ListTestCaseResults(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TestCases_ListTestCaseResults_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TestCasesServer).ListTestCaseResults(ctx, req.(*ListTestCaseResultsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TestCases_GetTestCaseResult_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTestCaseResultRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TestCasesServer).GetTestCaseResult(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TestCases_GetTestCaseResult_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TestCasesServer).GetTestCaseResult(ctx, req.(*GetTestCaseResultRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// TestCases_ServiceDesc is the grpc.ServiceDesc for TestCases service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var TestCases_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.cx.v3.TestCases",
	HandlerType: (*TestCasesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListTestCases",
			Handler:    _TestCases_ListTestCases_Handler,
		},
		{
			MethodName: "BatchDeleteTestCases",
			Handler:    _TestCases_BatchDeleteTestCases_Handler,
		},
		{
			MethodName: "GetTestCase",
			Handler:    _TestCases_GetTestCase_Handler,
		},
		{
			MethodName: "CreateTestCase",
			Handler:    _TestCases_CreateTestCase_Handler,
		},
		{
			MethodName: "UpdateTestCase",
			Handler:    _TestCases_UpdateTestCase_Handler,
		},
		{
			MethodName: "RunTestCase",
			Handler:    _TestCases_RunTestCase_Handler,
		},
		{
			MethodName: "BatchRunTestCases",
			Handler:    _TestCases_BatchRunTestCases_Handler,
		},
		{
			MethodName: "CalculateCoverage",
			Handler:    _TestCases_CalculateCoverage_Handler,
		},
		{
			MethodName: "ImportTestCases",
			Handler:    _TestCases_ImportTestCases_Handler,
		},
		{
			MethodName: "ExportTestCases",
			Handler:    _TestCases_ExportTestCases_Handler,
		},
		{
			MethodName: "ListTestCaseResults",
			Handler:    _TestCases_ListTestCaseResults_Handler,
		},
		{
			MethodName: "GetTestCaseResult",
			Handler:    _TestCases_GetTestCaseResult_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/cx/v3/test_case.proto",
}
