// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/cx/v3beta1/flow.proto

package cxpb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Flows_CreateFlow_FullMethodName              = "/google.cloud.dialogflow.cx.v3beta1.Flows/CreateFlow"
	Flows_DeleteFlow_FullMethodName              = "/google.cloud.dialogflow.cx.v3beta1.Flows/DeleteFlow"
	Flows_ListFlows_FullMethodName               = "/google.cloud.dialogflow.cx.v3beta1.Flows/ListFlows"
	Flows_GetFlow_FullMethodName                 = "/google.cloud.dialogflow.cx.v3beta1.Flows/GetFlow"
	Flows_UpdateFlow_FullMethodName              = "/google.cloud.dialogflow.cx.v3beta1.Flows/UpdateFlow"
	Flows_TrainFlow_FullMethodName               = "/google.cloud.dialogflow.cx.v3beta1.Flows/TrainFlow"
	Flows_ValidateFlow_FullMethodName            = "/google.cloud.dialogflow.cx.v3beta1.Flows/ValidateFlow"
	Flows_GetFlowValidationResult_FullMethodName = "/google.cloud.dialogflow.cx.v3beta1.Flows/GetFlowValidationResult"
	Flows_ImportFlow_FullMethodName              = "/google.cloud.dialogflow.cx.v3beta1.Flows/ImportFlow"
	Flows_ExportFlow_FullMethodName              = "/google.cloud.dialogflow.cx.v3beta1.Flows/ExportFlow"
)

// FlowsClient is the client API for Flows service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type FlowsClient interface {
	// Creates a flow in the specified agent.
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	CreateFlow(ctx context.Context, in *CreateFlowRequest, opts ...grpc.CallOption) (*Flow, error)
	// Deletes a specified flow.
	DeleteFlow(ctx context.Context, in *DeleteFlowRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Returns the list of all flows in the specified agent.
	ListFlows(ctx context.Context, in *ListFlowsRequest, opts ...grpc.CallOption) (*ListFlowsResponse, error)
	// Retrieves the specified flow.
	GetFlow(ctx context.Context, in *GetFlowRequest, opts ...grpc.CallOption) (*Flow, error)
	// Updates the specified flow.
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	UpdateFlow(ctx context.Context, in *UpdateFlowRequest, opts ...grpc.CallOption) (*Flow, error)
	// Trains the specified flow. Note that only the flow in 'draft' environment
	// is trained.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	//   - `metadata`: An empty [Struct
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	TrainFlow(ctx context.Context, in *TrainFlowRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Validates the specified flow and creates or updates validation results.
	// Please call this API after the training is completed to get the complete
	// validation results.
	ValidateFlow(ctx context.Context, in *ValidateFlowRequest, opts ...grpc.CallOption) (*FlowValidationResult, error)
	// Gets the latest flow validation result. Flow validation is performed
	// when ValidateFlow is called.
	GetFlowValidationResult(ctx context.Context, in *GetFlowValidationResultRequest, opts ...grpc.CallOption) (*FlowValidationResult, error)
	// Imports the specified flow to the specified agent from a binary file.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	//   - `metadata`: An empty [Struct
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	//   - `response`:
	//
	// [ImportFlowResponse][google.cloud.dialogflow.cx.v3beta1.ImportFlowResponse]
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	ImportFlow(ctx context.Context, in *ImportFlowRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Exports the specified flow to a binary file.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	//   - `metadata`: An empty [Struct
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	//   - `response`:
	//
	// [ExportFlowResponse][google.cloud.dialogflow.cx.v3beta1.ExportFlowResponse]
	//
	// Note that resources (e.g. intents, entities, webhooks) that the flow
	// references will also be exported.
	ExportFlow(ctx context.Context, in *ExportFlowRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type flowsClient struct {
	cc grpc.ClientConnInterface
}

func NewFlowsClient(cc grpc.ClientConnInterface) FlowsClient {
	return &flowsClient{cc}
}

func (c *flowsClient) CreateFlow(ctx context.Context, in *CreateFlowRequest, opts ...grpc.CallOption) (*Flow, error) {
	out := new(Flow)
	err := c.cc.Invoke(ctx, Flows_CreateFlow_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *flowsClient) DeleteFlow(ctx context.Context, in *DeleteFlowRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Flows_DeleteFlow_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *flowsClient) ListFlows(ctx context.Context, in *ListFlowsRequest, opts ...grpc.CallOption) (*ListFlowsResponse, error) {
	out := new(ListFlowsResponse)
	err := c.cc.Invoke(ctx, Flows_ListFlows_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *flowsClient) GetFlow(ctx context.Context, in *GetFlowRequest, opts ...grpc.CallOption) (*Flow, error) {
	out := new(Flow)
	err := c.cc.Invoke(ctx, Flows_GetFlow_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *flowsClient) UpdateFlow(ctx context.Context, in *UpdateFlowRequest, opts ...grpc.CallOption) (*Flow, error) {
	out := new(Flow)
	err := c.cc.Invoke(ctx, Flows_UpdateFlow_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *flowsClient) TrainFlow(ctx context.Context, in *TrainFlowRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Flows_TrainFlow_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *flowsClient) ValidateFlow(ctx context.Context, in *ValidateFlowRequest, opts ...grpc.CallOption) (*FlowValidationResult, error) {
	out := new(FlowValidationResult)
	err := c.cc.Invoke(ctx, Flows_ValidateFlow_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *flowsClient) GetFlowValidationResult(ctx context.Context, in *GetFlowValidationResultRequest, opts ...grpc.CallOption) (*FlowValidationResult, error) {
	out := new(FlowValidationResult)
	err := c.cc.Invoke(ctx, Flows_GetFlowValidationResult_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *flowsClient) ImportFlow(ctx context.Context, in *ImportFlowRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Flows_ImportFlow_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *flowsClient) ExportFlow(ctx context.Context, in *ExportFlowRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Flows_ExportFlow_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FlowsServer is the server API for Flows service.
// All implementations should embed UnimplementedFlowsServer
// for forward compatibility
type FlowsServer interface {
	// Creates a flow in the specified agent.
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	CreateFlow(context.Context, *CreateFlowRequest) (*Flow, error)
	// Deletes a specified flow.
	DeleteFlow(context.Context, *DeleteFlowRequest) (*emptypb.Empty, error)
	// Returns the list of all flows in the specified agent.
	ListFlows(context.Context, *ListFlowsRequest) (*ListFlowsResponse, error)
	// Retrieves the specified flow.
	GetFlow(context.Context, *GetFlowRequest) (*Flow, error)
	// Updates the specified flow.
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	UpdateFlow(context.Context, *UpdateFlowRequest) (*Flow, error)
	// Trains the specified flow. Note that only the flow in 'draft' environment
	// is trained.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	//   - `metadata`: An empty [Struct
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	TrainFlow(context.Context, *TrainFlowRequest) (*longrunningpb.Operation, error)
	// Validates the specified flow and creates or updates validation results.
	// Please call this API after the training is completed to get the complete
	// validation results.
	ValidateFlow(context.Context, *ValidateFlowRequest) (*FlowValidationResult, error)
	// Gets the latest flow validation result. Flow validation is performed
	// when ValidateFlow is called.
	GetFlowValidationResult(context.Context, *GetFlowValidationResultRequest) (*FlowValidationResult, error)
	// Imports the specified flow to the specified agent from a binary file.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	//   - `metadata`: An empty [Struct
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	//   - `response`:
	//
	// [ImportFlowResponse][google.cloud.dialogflow.cx.v3beta1.ImportFlowResponse]
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	ImportFlow(context.Context, *ImportFlowRequest) (*longrunningpb.Operation, error)
	// Exports the specified flow to a binary file.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	//   - `metadata`: An empty [Struct
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	//   - `response`:
	//
	// [ExportFlowResponse][google.cloud.dialogflow.cx.v3beta1.ExportFlowResponse]
	//
	// Note that resources (e.g. intents, entities, webhooks) that the flow
	// references will also be exported.
	ExportFlow(context.Context, *ExportFlowRequest) (*longrunningpb.Operation, error)
}

// UnimplementedFlowsServer should be embedded to have forward compatible implementations.
type UnimplementedFlowsServer struct {
}

func (UnimplementedFlowsServer) CreateFlow(context.Context, *CreateFlowRequest) (*Flow, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFlow not implemented")
}
func (UnimplementedFlowsServer) DeleteFlow(context.Context, *DeleteFlowRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFlow not implemented")
}
func (UnimplementedFlowsServer) ListFlows(context.Context, *ListFlowsRequest) (*ListFlowsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFlows not implemented")
}
func (UnimplementedFlowsServer) GetFlow(context.Context, *GetFlowRequest) (*Flow, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFlow not implemented")
}
func (UnimplementedFlowsServer) UpdateFlow(context.Context, *UpdateFlowRequest) (*Flow, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFlow not implemented")
}
func (UnimplementedFlowsServer) TrainFlow(context.Context, *TrainFlowRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TrainFlow not implemented")
}
func (UnimplementedFlowsServer) ValidateFlow(context.Context, *ValidateFlowRequest) (*FlowValidationResult, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateFlow not implemented")
}
func (UnimplementedFlowsServer) GetFlowValidationResult(context.Context, *GetFlowValidationResultRequest) (*FlowValidationResult, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFlowValidationResult not implemented")
}
func (UnimplementedFlowsServer) ImportFlow(context.Context, *ImportFlowRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportFlow not implemented")
}
func (UnimplementedFlowsServer) ExportFlow(context.Context, *ExportFlowRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportFlow not implemented")
}

// UnsafeFlowsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to FlowsServer will
// result in compilation errors.
type UnsafeFlowsServer interface {
	mustEmbedUnimplementedFlowsServer()
}

func RegisterFlowsServer(s grpc.ServiceRegistrar, srv FlowsServer) {
	s.RegisterService(&Flows_ServiceDesc, srv)
}

func _Flows_CreateFlow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFlowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FlowsServer).CreateFlow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Flows_CreateFlow_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FlowsServer).CreateFlow(ctx, req.(*CreateFlowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Flows_DeleteFlow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFlowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FlowsServer).DeleteFlow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Flows_DeleteFlow_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FlowsServer).DeleteFlow(ctx, req.(*DeleteFlowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Flows_ListFlows_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFlowsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FlowsServer).ListFlows(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Flows_ListFlows_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FlowsServer).ListFlows(ctx, req.(*ListFlowsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Flows_GetFlow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFlowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FlowsServer).GetFlow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Flows_GetFlow_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FlowsServer).GetFlow(ctx, req.(*GetFlowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Flows_UpdateFlow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFlowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FlowsServer).UpdateFlow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Flows_UpdateFlow_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FlowsServer).UpdateFlow(ctx, req.(*UpdateFlowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Flows_TrainFlow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TrainFlowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FlowsServer).TrainFlow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Flows_TrainFlow_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FlowsServer).TrainFlow(ctx, req.(*TrainFlowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Flows_ValidateFlow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateFlowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FlowsServer).ValidateFlow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Flows_ValidateFlow_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FlowsServer).ValidateFlow(ctx, req.(*ValidateFlowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Flows_GetFlowValidationResult_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFlowValidationResultRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FlowsServer).GetFlowValidationResult(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Flows_GetFlowValidationResult_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FlowsServer).GetFlowValidationResult(ctx, req.(*GetFlowValidationResultRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Flows_ImportFlow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportFlowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FlowsServer).ImportFlow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Flows_ImportFlow_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FlowsServer).ImportFlow(ctx, req.(*ImportFlowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Flows_ExportFlow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportFlowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FlowsServer).ExportFlow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Flows_ExportFlow_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FlowsServer).ExportFlow(ctx, req.(*ExportFlowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Flows_ServiceDesc is the grpc.ServiceDesc for Flows service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Flows_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.cx.v3beta1.Flows",
	HandlerType: (*FlowsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateFlow",
			Handler:    _Flows_CreateFlow_Handler,
		},
		{
			MethodName: "DeleteFlow",
			Handler:    _Flows_DeleteFlow_Handler,
		},
		{
			MethodName: "ListFlows",
			Handler:    _Flows_ListFlows_Handler,
		},
		{
			MethodName: "GetFlow",
			Handler:    _Flows_GetFlow_Handler,
		},
		{
			MethodName: "UpdateFlow",
			Handler:    _Flows_UpdateFlow_Handler,
		},
		{
			MethodName: "TrainFlow",
			Handler:    _Flows_TrainFlow_Handler,
		},
		{
			MethodName: "ValidateFlow",
			Handler:    _Flows_ValidateFlow_Handler,
		},
		{
			MethodName: "GetFlowValidationResult",
			Handler:    _Flows_GetFlowValidationResult_Handler,
		},
		{
			MethodName: "ImportFlow",
			Handler:    _Flows_ImportFlow_Handler,
		},
		{
			MethodName: "ExportFlow",
			Handler:    _Flows_ExportFlow_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/cx/v3beta1/flow.proto",
}
